/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"METADATA_FILE_EXTENSION", "", "DOT_METADATA_FILE_EXTENSION", "readProto", "Lkotlin/Triple;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolverImpl;", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "stream", "Ljava/io/InputStream;", "deserialization.common"})
public final class MetadataUtilKt {
    @NotNull
    public static final String METADATA_FILE_EXTENSION = "kotlin_metadata";
    @NotNull
    public static final String DOT_METADATA_FILE_EXTENSION = ".kotlin_metadata";

    @NotNull
    public static final Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion> readProto(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        BuiltInsBinaryVersion version2 = BuiltInsBinaryVersion.Companion.readFrom(stream);
        if (!version2.isCompatibleWithCurrentCompilerVersion()) {
            throw new UnsupportedOperationException("Kotlin metadata definition format version is not supported: expected " + BuiltInsBinaryVersion.INSTANCE + ", actual " + version2 + ". Please update Kotlin");
        }
        ProtoBuf.PackageFragment message2 = ProtoBuf.PackageFragment.parseFrom(stream, BuiltInSerializerProtocol.INSTANCE.getExtensionRegistry());
        ProtoBuf.StringTable stringTable2 = message2.getStrings();
        Intrinsics.checkNotNullExpressionValue(stringTable2, "getStrings(...)");
        ProtoBuf.QualifiedNameTable qualifiedNameTable = message2.getQualifiedNames();
        Intrinsics.checkNotNullExpressionValue(qualifiedNameTable, "getQualifiedNames(...)");
        NameResolverImpl nameResolver = new NameResolverImpl(stringTable2, qualifiedNameTable);
        return new Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion>(message2, nameResolver, version2);
    }
}

