/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.internal.util.require;
import io.jenetics.util.ISeq;
import java.util.Objects;

public final class EvolutionInit<G extends Gene<?, G>> {
    private final ISeq<Genotype<G>> _population;
    private final long _generation;

    private EvolutionInit(ISeq<Genotype<G>> population, long generation) {
        this._population = Objects.requireNonNull(population);
        this._generation = require.positive(generation);
    }

    public ISeq<Genotype<G>> getPopulation() {
        return this._population;
    }

    public long getGeneration() {
        return this._generation;
    }

    public int hashCode() {
        int hash = 17;
        hash = (int)((long)hash + (31L * this._generation + 17L));
        return hash += 31 * Objects.hashCode(this._population) + 17;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof EvolutionInit && this._generation == ((EvolutionInit)obj)._generation && Objects.equals(this._population, ((EvolutionInit)obj)._population);
    }

    public String toString() {
        return String.format("EvolutionStart[population-size=%d, generation=%d]", this._population.size(), this._generation);
    }

    public static <G extends Gene<?, G>> EvolutionInit<G> of(ISeq<Genotype<G>> population, long generation) {
        return new EvolutionInit<G>(population, generation);
    }
}

