/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.Phenotype;
import io.jenetics.Recombinator;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import java.util.Random;

public abstract class Crossover<G extends Gene<?, G>, C extends Comparable<? super C>>
extends Recombinator<G, C> {
    protected Crossover(double probability2) {
        super(probability2, 2);
    }

    @Override
    protected final int recombine(MSeq<Phenotype<G, C>> population, int[] individuals, long generation) {
        assert (individuals.length == 2) : "Required order of 2";
        Random random2 = RandomRegistry.getRandom();
        Phenotype pt1 = (Phenotype)population.get(individuals[0]);
        Phenotype pt2 = (Phenotype)population.get(individuals[1]);
        Genotype gt1 = pt1.getGenotype();
        Genotype gt2 = pt2.getGenotype();
        int chIndex = random2.nextInt(Math.min(gt1.length(), gt2.length()));
        Object c1 = gt1.toSeq().copy();
        Object c2 = gt2.toSeq().copy();
        Object genes1 = ((Chromosome)c1.get(chIndex)).toSeq().copy();
        Object genes2 = ((Chromosome)c2.get(chIndex)).toSeq().copy();
        this.crossover((MSeq<G>)genes1, (MSeq<G>)genes2);
        c1.set(chIndex, ((Chromosome)c1.get(chIndex)).newInstance(genes1.toISeq()));
        c2.set(chIndex, ((Chromosome)c2.get(chIndex)).newInstance(genes2.toISeq()));
        population.set(individuals[0], pt1.newInstance(Genotype.of(c1), generation));
        population.set(individuals[1], pt2.newInstance(Genotype.of(c2), generation));
        return this.getOrder();
    }

    protected abstract int crossover(MSeq<G> var1, MSeq<G> var2);
}

