/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.config.BeanComponentDefinitionBuilder;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class GridFsTemplateParser
extends AbstractBeanDefinitionParser {
    GridFsTemplateParser() {
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "gridFsTemplate";
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanComponentDefinitionBuilder helper = new BeanComponentDefinitionBuilder(element, parserContext);
        String converterRef = element.getAttribute("converter-ref");
        String dbFactoryRef = element.getAttribute("db-factory-ref");
        String bucket = element.getAttribute("bucket");
        BeanDefinitionBuilder gridFsTemplateBuilder = BeanDefinitionBuilder.genericBeanDefinition(GridFsTemplate.class);
        if (StringUtils.hasText((String)dbFactoryRef)) {
            gridFsTemplateBuilder.addConstructorArgReference(dbFactoryRef);
        } else {
            gridFsTemplateBuilder.addConstructorArgReference("mongoDbFactory");
        }
        if (StringUtils.hasText((String)converterRef)) {
            gridFsTemplateBuilder.addConstructorArgReference(converterRef);
        } else {
            gridFsTemplateBuilder.addConstructorArgReference("mappingConverter");
        }
        if (StringUtils.hasText((String)bucket)) {
            gridFsTemplateBuilder.addConstructorArgValue((Object)bucket);
        }
        return (AbstractBeanDefinition)helper.getComponentIdButFallback(gridFsTemplateBuilder, "gridFsTemplate").getBeanDefinition();
    }
}

