/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.stat;

import java.io.Serializable;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;

public final class LongSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long _count;
    private final long _min;
    private final long _max;
    private final long _sum;
    private final double _mean;

    private LongSummary(long count, long min, long max, long sum, double mean) {
        this._count = count;
        this._min = min;
        this._max = max;
        this._sum = sum;
        this._mean = mean;
    }

    public long getCount() {
        return this._count;
    }

    public long getMin() {
        return this._min;
    }

    public long getMax() {
        return this._max;
    }

    public long getSum() {
        return this._sum;
    }

    public double getMean() {
        return this._mean;
    }

    public int hashCode() {
        int hash = 17;
        hash = (int)((long)hash + (33L * this._count + 37L));
        hash = (int)((long)hash + (33L * this._sum + 37L));
        hash = (int)((long)hash + (33L * this._min + 37L));
        hash = (int)((long)hash + (33L * this._max + 37L));
        return hash += 33 * Double.hashCode(this._mean) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LongSummary && this._count == ((LongSummary)obj)._count && this._sum == ((LongSummary)obj)._sum && this._min == ((LongSummary)obj)._min && this._max == ((LongSummary)obj)._max && Double.compare(this._mean, ((LongSummary)obj)._mean) == 0;
    }

    public String toString() {
        return String.format("LongSummary[N=%d, \u2227=%s, \u2228=%s, \u03a3=%s, \u03bc=%s]", this.getCount(), this.getMin(), this.getMax(), this.getSum(), this.getMean());
    }

    public static LongSummary of(long count, long min, long max, long sum, double mean) {
        return new LongSummary(count, min, max, sum, mean);
    }

    public static LongSummary of(LongSummaryStatistics statistics) {
        return new LongSummary(statistics.getCount(), statistics.getMin(), statistics.getMax(), statistics.getSum(), statistics.getAverage());
    }

    public static <T> Collector<T, ?, LongSummary> toLongSummary(ToLongFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return Collector.of(LongSummaryStatistics::new, (a, b) -> a.accept(mapper.applyAsLong(b)), (a, b) -> {
            a.combine((LongSummaryStatistics)b);
            return a;
        }, LongSummary::of, new Collector.Characteristics[0]);
    }

    public static long min(long[] values) {
        long min = Long.MAX_VALUE;
        if (values.length > 0) {
            min = values[0];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] >= min) continue;
                min = values[i];
            }
        }
        return min;
    }

    public static long max(long[] values) {
        long max = Long.MIN_VALUE;
        if (values.length > 0) {
            max = values[0];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] <= max) continue;
                max = values[i];
            }
        }
        return max;
    }

    public static long sum(long[] values) {
        long sum = 0L;
        int i = values.length;
        while (--i >= 0) {
            sum += values[i];
        }
        return sum;
    }

    public static double mean(long[] values) {
        return values.length > 0 ? (double)LongSummary.sum(values) / (double)values.length : Double.NaN;
    }
}

