/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.BitGene;
import io.jenetics.internal.collection.Array;
import io.jenetics.internal.util.bit;
import io.jenetics.internal.util.require;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

final class BitGeneStore
implements Array.Store<BitGene>,
Serializable {
    private static final long serialVersionUID = 1L;
    final byte[] array;
    final int length;

    private BitGeneStore(byte[] array2, int length) {
        this.array = Objects.requireNonNull(array2);
        this.length = require.nonNegative(length);
    }

    @Override
    public BitGene get(int index) {
        return BitGene.of(bit.get(this.array, index));
    }

    @Override
    public void sort(int from, int until, Comparator<? super BitGene> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int index, BitGene value) {
        bit.set(this.array, index, value.booleanValue());
    }

    void swap(int start, int end, BitGeneStore other, int otherStart) {
        bit.swap(this.array, start, end, other.array, otherStart);
    }

    public BitGeneStore copy(int from, int until) {
        return new BitGeneStore(bit.copy(this.array, from, until), until - from);
    }

    public BitGeneStore newInstance(int length) {
        return BitGeneStore.ofLength(length);
    }

    @Override
    public int length() {
        return this.length;
    }

    static BitGeneStore of(byte[] array2, int length) {
        return new BitGeneStore(array2, length);
    }

    static BitGeneStore ofLength(int length) {
        return new BitGeneStore(bit.newArray(length), length);
    }
}

