/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.ISeq;
import io.jenetics.util.Verifiable;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import java.util.RandomAccess;

public abstract class AbstractChromosome<G extends Gene<?, G>>
implements Chromosome<G>,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient ISeq<G> _genes;
    protected transient Boolean _valid = null;

    protected AbstractChromosome(ISeq<? extends G> genes) {
        Objects.requireNonNull(genes, "Gene array");
        assert (genes.forAll(Objects::nonNull)) : "Found at least on null gene.";
        if (genes.isEmpty()) {
            throw new IllegalArgumentException("The genes sequence must contain at least one gene.");
        }
        this._genes = ISeq.upcast(genes);
    }

    @Override
    public G getGene(int index) {
        return (G)((Gene)this._genes.get(index));
    }

    @Override
    public ISeq<G> toSeq() {
        return this._genes;
    }

    @Override
    public boolean isValid() {
        if (this._valid == null) {
            this._valid = this._genes.forAll(Verifiable::isValid);
        }
        return this._valid;
    }

    @Override
    public Iterator<G> iterator() {
        return this._genes.iterator();
    }

    @Override
    public int length() {
        return this._genes.length();
    }

    public int hashCode() {
        return Hash.of(this.getClass()).and(this._genes).value();
    }

    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(ch -> Equality.eq(this._genes, ch._genes));
    }

    public String toString() {
        return Objects.toString(this._genes);
    }
}

