/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.function.Supplier;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.Logger;
import reactor.util.Loggers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class BoundedElasticSchedulerSupplier
implements Supplier<Scheduler> {
    static final Logger logger = Loggers.getLogger(BoundedElasticSchedulerSupplier.class);

    BoundedElasticSchedulerSupplier() {
    }

    @Override
    public Scheduler get() {
        if (Schedulers.DEFAULT_BOUNDED_ELASTIC_ON_VIRTUAL_THREADS) {
            logger.warn("Virtual Threads support is not available on the given JVM. Falling back to default BoundedElastic setup");
        }
        return Schedulers.newBoundedElastic(Schedulers.DEFAULT_BOUNDED_ELASTIC_SIZE, Schedulers.DEFAULT_BOUNDED_ELASTIC_QUEUESIZE, "boundedElastic", 60, true);
    }
}

