/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.auth.login.client;

import com.axlradius.radclient4.ClientReceiveException;
import com.axlradius.radclient4.ClientSendException;
import com.axlradius.radclient4.RADIUSClient;
import com.axlradius.radclient4.RADIUSException;
import com.axlradius.radclient4.TimeoutContext;
import com.axlradius.radclient4.attributes.Attribute;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.auth.login.client.AccessAccept;
import com.axlradius.radclient4.auth.login.client.AccessBadPacket;
import com.axlradius.radclient4.auth.login.client.AccessReject;
import com.axlradius.radclient4.auth.login.client.Attributes;
import com.axlradius.radclient4.auth.login.client.ClientException;
import com.axlradius.radclient4.auth.login.client.RADIUSCallback;
import com.axlradius.radclient4.auth.login.client.RADIUSNameCallback;
import com.axlradius.radclient4.auth.login.client.RADIUSPasswordCallback;
import com.axlradius.radclient4.auth.login.client.RADIUSPrincipal;
import com.axlradius.radclient4.auth.login.client.RADIUSTextInputCallback;
import com.axlradius.radclient4.auth.login.client.RADIUSTextOutputCallback;
import com.axlradius.radclient4.auth.login.client.SetAccessRequestAttributes;
import com.axlradius.radclient4.dictionary.BD;
import com.axlradius.radclient4.dictionary.DefaultDictionary;
import com.axlradius.radclient4.radutil.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RADIUSLogin
implements LoginModule {
    public static final String AUTH_PAP = "PAP";
    public static final String AUTH_CHAP = "CHAP";
    public static final String AUTH_MSCHAP = "MSCHAP";
    public static final String AUTH_MSCHAPV2 = "MSCHAPV2";
    private static final String[] d = new String[]{"debug", "debugFile", "server", "port", "secret", "authtype", "timeout", "passwordPrompt", "namePrompt"};
    private Subject subject;
    private CallbackHandler a;
    private boolean debug = false;
    private String f;
    private int m;
    private String g;
    private String h;
    private String i;
    private String j;
    private AttributeList d;
    private String k = null;
    private boolean q = false;
    private boolean r = false;
    private String l;
    private RADIUSPrincipal a;

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(Subject object, CallbackHandler object2, Map<String, ?> object32, Map<String, ?> map) {
        void var4_7;
        this.subject = object;
        this.a = object2;
        BD.addDictionary(new DefaultDictionary());
        this.debug = ((String)var4_7.get("debug")).equals("true");
        var4_7.get("debugFile");
        this.f = (String)var4_7.get("server");
        this.g = (String)var4_7.get("secret");
        this.h = (String)var4_7.get("namePrompt");
        if (this.h == null) {
            this.h = "Name";
        }
        this.i = (String)var4_7.get("passwordPrompt");
        if (this.i == null) {
            this.i = "Password";
        }
        this.j = (String)var4_7.get("authtype");
        if (this.j == null) {
            this.j = AUTH_PAP;
        }
        object = (String)var4_7.get("port");
        try {
            this.m = Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            this.m = 1812;
        }
        BD.addDictionary(new DefaultDictionary());
        this.d = new AttributeList();
        for (String string : var4_7.keySet()) {
            object = (String)var4_7.get(string);
            try {
                if ((object = RADIUSLogin.a(string, (String)object)) == null) continue;
                this.d.add((Attribute)object);
            }
            catch (Exception exception) {
                this.k = "Parse error in attribute: " + exception.getMessage();
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Attributes attributes;
        Object object5;
        Object object6;
        if (this.k != null) {
            throw new LoginException("Configuration error in RADIUSLogin.config: " + this.k);
        }
        if (this.a == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        if (this.f == null || this.g == null) {
            throw new LoginException("Missing or bad RADIUS options. Server or secret are missing.");
        }
        try {
            object6 = new RADIUSNameCallback(this.h);
            object5 = new RADIUSPasswordCallback(this.i);
            attributes = new SetAccessRequestAttributes();
            object4 = new Callback[]{object6, object5, attributes};
            this.a.handle((Callback[])object4);
            object4 = ((NameCallback)object6).getName();
            if (object4 == null) {
                throw new LoginException("Error: No user name specified.");
            }
            object3 = ((PasswordCallback)object5).getPassword();
            ((PasswordCallback)object5).clearPassword();
            if (object3 == null) {
                object3 = new char[]{};
            }
            object5 = attributes.getRequestAttributes();
        }
        catch (IOException iOException) {
            ClientException clientException = new ClientException();
            clientException.setException(iOException);
            this.a(clientException);
            throw new LoginException(iOException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString() + " callback not understood by application.");
        }
        try {
            object6 = new RADIUSClient(this.f, this.m, Util.toUTF8(this.g), TimeoutContext.AUTHENTICATION.getContext());
            ((RADIUSClient)object6).setDebug(this.debug);
        }
        catch (SocketException socketException) {
            attributes = new ClientException();
            ((ClientException)attributes).setException(socketException);
            this.a(attributes);
            throw new LoginException("SocketException creating RADIUSClient: " + socketException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            attributes = new ClientException();
            ((ClientException)attributes).setException(unknownHostException);
            this.a(attributes);
            throw new LoginException("UnknownHostException creating RADIUSClient: " + unknownHostException.getMessage());
        }
        int n2 = this.a((RADIUSClient)object6, (String)object4, (char[])object3, (AttributeList)object5);
        Object object7 = object3 = (Object)((RADIUSClient)object6).getAttributes();
        int n3 = n2;
        if (!((AttributeList)object7).contains(18)) {
            object2 = null;
        } else if (((String)(object7 = ((AttributeList)object7).getString(18))).length() == 0) {
            object2 = null;
        } else {
            RADIUSTextOutputCallback rADIUSTextOutputCallback = null;
            switch (n3) {
                case 3: {
                    rADIUSTextOutputCallback = new RADIUSTextOutputCallback(2, (String)object7);
                    break;
                }
                case 0: {
                    break;
                }
                case 2: 
                case 11: {
                    rADIUSTextOutputCallback = new RADIUSTextOutputCallback(0, (String)object7);
                }
            }
            if (rADIUSTextOutputCallback == null) {
                object2 = null;
            } else {
                rADIUSTextOutputCallback.setReady(true);
                object2 = object = rADIUSTextOutputCallback;
            }
        }
        if (object2 != null) {
            this.a((RADIUSCallback)object);
        }
        do {
            switch (n2) {
                case 3: {
                    object4 = new AccessReject();
                    new AccessReject().e = object3;
                    this.a((RADIUSCallback)object4);
                    throw new LoginException("Access rejected.");
                }
                case 0: {
                    object4 = new AccessBadPacket();
                    new AccessBadPacket().e = object3;
                    ((AccessBadPacket)object4).a(((RADIUSClient)object6).getError());
                    this.a((RADIUSCallback)object4);
                    throw new LoginException("Bad RADIUS response packet.");
                }
                case 11: {
                    char[] cArray = object3;
                    object = cArray.getString(18);
                    object = new RADIUSTextInputCallback((String)object);
                    object7 = new Callback[]{object};
                    try {
                        this.a.handle((Callback[])object7);
                    }
                    catch (IOException iOException) {
                        throw new LoginException("IOException handling challenge callback: " + iOException.getMessage());
                    }
                    catch (UnsupportedCallbackException unsupportedCallbackException) {
                        throw new LoginException("UnsupportedCallbackException handling challenge callback: " + unsupportedCallbackException.getMessage());
                    }
                    object = ((TextInputCallback)object).getText();
                    if (object == null) {
                        throw new LoginException("No response was provided to the challenge.");
                    }
                    object7 = new AttributeList((AttributeList)object5);
                    ((AttributeList)object7).add(24, cArray.getString(24));
                    n2 = this.a((RADIUSClient)object6, (String)object4, ((String)object).toCharArray(), (AttributeList)object7);
                    break;
                }
                case 2: {
                    this.l = object4;
                    this.q = true;
                    object = new AccessAccept();
                    new AccessAccept().e = ((RADIUSClient)object6).getAttributes();
                    this.a((RADIUSCallback)object);
                    break;
                }
                default: {
                    object5 = "Unexpected packet type returned: " + n2;
                    throw new LoginException((String)object5);
                }
            }
        } while (!this.q);
        return true;
    }

    private int a(RADIUSClient object, String object2, char[] objectArray, AttributeList attributeList) throws LoginException {
        int n2;
        block13: {
            AttributeList attributeList2 = new AttributeList();
            attributeList2.add(this.d);
            if (attributeList != null) {
                attributeList2.add(attributeList);
            }
            try {
                ((RADIUSClient)object).reset();
            }
            catch (SocketException socketException) {
                throw new LoginException("SocketException resetting RADIUS Client: " + socketException.getMessage());
            }
            objectArray = Util.toUTF8(objectArray);
            try {
                if (this.j.equals(AUTH_PAP)) {
                    attributeList2.add(1, (String)object2);
                    ((RADIUSClient)object).createPAP((byte[])objectArray, attributeList2);
                    n2 = ((RADIUSClient)object).authenticate(attributeList2);
                    break block13;
                }
                if (this.j.equals(AUTH_CHAP)) {
                    attributeList2.add(1, (String)object2);
                    ((RADIUSClient)object).createCHAP((byte[])objectArray, attributeList2);
                    n2 = ((RADIUSClient)object).authenticate(attributeList2);
                    break block13;
                }
                if (this.j.equals(AUTH_MSCHAP)) {
                    ((RADIUSClient)object).createMSCHAP((byte[])objectArray, attributeList2);
                    attributeList2.add(1, (String)object2);
                    n2 = ((RADIUSClient)object).authenticate(attributeList2);
                    break block13;
                }
                if (this.j.equals(AUTH_MSCHAPV2)) {
                    ((RADIUSClient)object).createMSCHAP2(Util.toUTF8((String)object2), (byte[])objectArray, attributeList2);
                    attributeList2.add(1, (String)object2);
                    n2 = ((RADIUSClient)object).authenticate(attributeList2);
                    break block13;
                }
                throw new LoginException("Unknown authtype of " + this.j);
            }
            catch (ClientSendException clientSendException) {
                object2 = new ClientException();
                ((ClientException)object2).setException(clientSendException);
                this.a((RADIUSCallback)object2);
                throw new LoginException("Failed with a ClientSendExcepton (" + clientSendException.getMessage() + ")");
            }
            catch (ClientReceiveException clientReceiveException) {
                object2 = new ClientException();
                ((ClientException)object2).setException(clientReceiveException);
                this.a((RADIUSCallback)object2);
                throw new LoginException("Failed with a ClientReceiveException (" + clientReceiveException.getMessage() + ")");
            }
            catch (RADIUSException rADIUSException) {
                object2 = new ClientException();
                ((ClientException)object2).setException(rADIUSException);
                this.a((RADIUSCallback)object2);
                throw new LoginException("Failed with a RADIUSException (" + rADIUSException.getMessage() + ")");
            }
            catch (Exception exception) {
                object2 = new ClientException();
                ((ClientException)object2).setException(exception);
                this.a((RADIUSCallback)object2);
                throw new LoginException("Failed with a EAPException (" + exception.getMessage() + ")");
            }
        }
        if (this.debug) {
            object = ((RADIUSClient)object).getAttributes();
            System.out.println("Result: " + n2);
            System.out.println("Response attributes:=n" + object);
        }
        return n2;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.q) {
            return false;
        }
        this.a = new RADIUSPrincipal(this.l);
        if (!this.subject.getPrincipals().contains(this.a)) {
            this.subject.getPrincipals().add(this.a);
        }
        if (this.debug) {
            System.out.println("RADIUSLogin: added RADIUSPrincipal to Subject");
        }
        this.l = null;
        this.r = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.q) {
            return false;
        }
        if (this.q && !this.r) {
            this.q = false;
            this.l = null;
            this.a = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.a);
        this.q = false;
        this.q = this.r;
        this.l = null;
        this.a = null;
        return true;
    }

    private static Attribute a(String string, String string2) throws Exception {
        Object object;
        int n2;
        for (n2 = 0; n2 < 9; ++n2) {
            if (!string.equals(d[n2])) continue;
            return null;
        }
        n2 = BD.lookupTag(string);
        if (n2 == 0) {
            throw new Exception("Unknown attribute " + string);
        }
        switch (string2.charAt(0)) {
            case '#': {
                if (string2.length() == 1) {
                    throw new Exception("Missing integer value.");
                }
                if (Character.isDigit(string2.charAt(1))) {
                    try {
                        int n3 = Integer.parseInt(string2.substring(1));
                        new Attribute(n2, n3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new Exception("Attribute value is not a number: " + string + "=" + string2);
                    }
                }
            }
            case '@': {
                try {
                    object = new Attribute(n2, InetAddress.getByName(string2.substring(1)).getAddress());
                    break;
                }
                catch (UnknownHostException unknownHostException) {
                    throw new Exception("Attribute value is not an IP Address: " + string + "=" + string2);
                }
            }
            default: {
                if (string2.startsWith("0x") || string2.startsWith("0X")) {
                    try {
                        byte[] byArray = new BigInteger(string2.substring(2), 16).toByteArray();
                        object = byArray;
                        if (byArray.length > 253) {
                            throw new Exception("Attribute binary value is too long (max=253): " + string + "=" + string2);
                        }
                        object = new Attribute(n2, (byte[])object);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new Exception("Attribute value is not a hex string: " + string + "=" + string2);
                    }
                }
                int n4 = BD.lookupValue(n2, string2);
                object = n4 != -1 ? new Attribute(n2, n4) : new Attribute(n2, Util.toUTF8(string2));
            }
        }
        return object;
    }

    private void a(RADIUSCallback rADIUSCallback) throws LoginException {
        rADIUSCallback.setReady(true);
        Callback[] callbackArray = new Callback[1];
        Callback[] callbackArray2 = callbackArray;
        callbackArray[0] = (Callback)((Object)rADIUSCallback);
        try {
            this.a.handle(callbackArray2);
            rADIUSCallback.setReady(false);
            return;
        }
        catch (IOException iOException) {
            rADIUSCallback.setReady(false);
            throw new LoginException("IOException handling challenge callback: " + iOException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            rADIUSCallback.setReady(false);
            throw new LoginException("UnsupportedCallbackException handling challenge callback: " + unsupportedCallbackException.getMessage());
        }
    }
}

