/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.BufferUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.protocol.Jt600ProtocolDecoder;
import org.traccar.session.DeviceSession;

public class HuabaoProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_TERMINAL_GENERAL_RESPONSE = 1;
    public static final int MSG_GENERAL_RESPONSE = 32769;
    public static final int MSG_GENERAL_RESPONSE_2 = 17409;
    public static final int MSG_HEARTBEAT = 2;
    public static final int MSG_HEARTBEAT_2 = 1286;
    public static final int MSG_TERMINAL_REGISTER = 256;
    public static final int MSG_TERMINAL_REGISTER_RESPONSE = 33024;
    public static final int MSG_TERMINAL_CONTROL = 33029;
    public static final int MSG_TERMINAL_AUTH = 258;
    public static final int MSG_LOCATION_REPORT = 512;
    public static final int MSG_LOCATION_BATCH_2 = 528;
    public static final int MSG_ACCELERATION = 8304;
    public static final int MSG_LOCATION_REPORT_2 = 21761;
    public static final int MSG_LOCATION_REPORT_BLIND = 21762;
    public static final int MSG_LOCATION_BATCH = 1796;
    public static final int MSG_OIL_CONTROL = 40966;
    public static final int MSG_TIME_SYNC_REQUEST = 265;
    public static final int MSG_TIME_SYNC_RESPONSE = 33033;
    public static final int MSG_PHOTO = 34952;
    public static final int MSG_TRANSPARENT = 2304;
    public static final int MSG_PARAMETER_SETTING = 784;
    public static final int MSG_SEND_TEXT_MESSAGE = 33536;
    public static final int MSG_REPORT_TEXT_MESSAGE = 24582;
    public static final int MSG_CONFIGURATION_PARAMETERS = 33027;
    public static final int MSG_COMMAND_RESPONSE = 1793;
    public static final int MSG_DRIVER_IDENTITY = 1794;
    public static final int RESULT_SUCCESS = 0;
    private int delimiter = 126;

    public HuabaoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public boolean isAlternative() {
        return this.delimiter == 231;
    }

    public static ByteBuf formatMessage(int delimiter, int type, ByteBuf id, boolean shortIndex, ByteBuf data) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(delimiter);
        buf.writeShort(type);
        buf.writeShort(data.readableBytes());
        buf.writeBytes(id);
        if (shortIndex) {
            buf.writeByte(1);
        } else {
            buf.writeShort(0);
        }
        buf.writeBytes(data);
        data.release();
        buf.writeByte(Checksum.xor(buf.nioBuffer(1, buf.readableBytes() - 1)));
        buf.writeByte(delimiter);
        return buf;
    }

    private void sendGeneralResponse(Channel channel, SocketAddress remoteAddress, ByteBuf id, int type, int index) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(index);
            response.writeShort(type);
            response.writeByte(0);
            channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(this.delimiter, 32769, id, false, response), remoteAddress));
        }
    }

    private void sendGeneralResponse2(Channel channel, SocketAddress remoteAddress, ByteBuf id, int type) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(type);
            response.writeByte(0);
            channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(this.delimiter, 17409, id, true, response), remoteAddress));
        }
    }

    private void decodeAlarm(Position position, String model, long value) {
        if (model != null && Set.of("G-360P", "G-508P").contains(model)) {
            if (BitUtil.check(value, 0) || BitUtil.check(value, 4)) {
                position.addAlarm("removing");
            }
            if (BitUtil.check(value, 1)) {
                position.addAlarm("tampering");
            }
        } else if (model != null && Set.of("AL300", "GL100").contains(model)) {
            if (BitUtil.check(value, 16)) {
                position.addAlarm("movement");
            }
        } else {
            if (BitUtil.check(value, 0)) {
                position.addAlarm("sos");
            }
            if (BitUtil.check(value, 1)) {
                position.addAlarm("overspeed");
            }
            if (BitUtil.check(value, 5)) {
                position.addAlarm("gpsAntennaCut");
            }
            if (BitUtil.check(value, 4) || BitUtil.check(value, 9) || BitUtil.check(value, 10) || BitUtil.check(value, 11)) {
                position.addAlarm("fault");
            }
            if (BitUtil.check(value, 7) || BitUtil.check(value, 18)) {
                position.addAlarm("lowBattery");
            }
            if (BitUtil.check(value, 8)) {
                position.addAlarm("powerOff");
            }
            if (BitUtil.check(value, 15)) {
                position.addAlarm("vibration");
            }
            if (BitUtil.check(value, 16) || BitUtil.check(value, 17)) {
                position.addAlarm("tampering");
            }
            if (BitUtil.check(value, 20)) {
                position.addAlarm("geofence");
            }
            if (BitUtil.check(value, 28)) {
                position.addAlarm("movement");
            }
            if (!(!BitUtil.check(value, 29) && !BitUtil.check(value, 30) || model != null && model.equals("VL300"))) {
                position.addAlarm("accident");
            }
        }
    }

    private int readSignedWord(ByteBuf buf) {
        int value = buf.readUnsignedShort();
        return BitUtil.check(value, 15) ? -BitUtil.to(value, 15) : BitUtil.to(value, 15);
    }

    private Date readDate(ByteBuf buf, TimeZone timeZone) {
        DateBuilder dateBuilder = new DateBuilder(timeZone).setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
        return dateBuilder.getDate();
    }

    private String decodeId(ByteBuf id) {
        String serial = ByteBufUtil.hexDump((ByteBuf)id);
        if (serial.matches("[0-9]+")) {
            return serial;
        }
        long imei = id.getUnsignedShort(0);
        imei = (imei << 32) + id.getUnsignedInt(2);
        return String.valueOf(imei) + Checksum.luhn(imei);
    }

    private void decodeObdRt(Position position, String data) {
        String[] values = data.split(",");
        int index = 1;
        if (!values[index++].isEmpty()) {
            position.set("power", Double.parseDouble(values[index - 1]));
        }
        if (!values[index++].isEmpty()) {
            position.set("rpm", Double.parseDouble(values[index - 1]));
        }
        if (!values[index++].isEmpty()) {
            position.set("obdSpeed", Double.parseDouble(values[index - 1]));
        }
        if (!values[index++].isEmpty()) {
            position.set("throttle", Double.parseDouble(values[index - 1]));
        }
        if (!values[index++].isEmpty()) {
            position.set("engineLoad", Double.parseDouble(values[index - 1]));
        }
        if (!values[index++].isEmpty()) {
            position.set("coolantTemp", Integer.parseInt(values[index - 1]));
        }
        if (!values[index++].isEmpty()) {
            position.set("fuelConsumption", Double.parseDouble(values[index - 1]));
        }
        if (!values[index++].isEmpty()) {
            position.set("fuelConsumption", Double.parseDouble(values[index - 1]));
        }
        if (!values[index++].isEmpty()) {
            position.set("tripOdometer", Double.parseDouble(values[index - 1]));
        }
        if (!values[index++].isEmpty()) {
            position.set("obdOdometer", Double.parseDouble(values[index - 1]));
        }
        if (!values[index++].isEmpty()) {
            position.set("tripFuelUsed", Double.parseDouble(values[index - 1]));
        }
        if (!values[index++].isEmpty()) {
            position.set("fuelUsed", Double.parseDouble(values[index - 1]));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getByte(buf.readerIndex()) == 40) {
            String sentence = buf.toString(StandardCharsets.US_ASCII);
            if (sentence.contains("BASE,2")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                String response = sentence.replace("TIME", dateFormat.format(new Date()));
                if (channel != null) {
                    channel.writeAndFlush((Object)new NetworkMessage(Unpooled.copiedBuffer((CharSequence)response, (Charset)StandardCharsets.US_ASCII), remoteAddress));
                }
                return null;
            }
            return this.decodeResult(channel, remoteAddress, sentence);
        }
        this.delimiter = buf.readUnsignedByte();
        int type = buf.readUnsignedShort();
        int attribute = buf.readUnsignedShort();
        ByteBuf id = buf.readSlice(this.isAlternative() ? 7 : 6);
        int index = type == 21761 || type == 21762 ? buf.readUnsignedByte() : buf.readUnsignedShort();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.decodeId(id));
        if (deviceSession == null) {
            return null;
        }
        if (!deviceSession.contains("timezone")) {
            deviceSession.set("timezone", this.getTimeZone(deviceSession.getDeviceId(), "GMT+8"));
        }
        if (type == 256) {
            if (channel != null) {
                ByteBuf response = Unpooled.buffer();
                response.writeShort(index);
                response.writeByte(0);
                response.writeBytes(this.decodeId(id).getBytes(StandardCharsets.US_ASCII));
                channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(this.delimiter, 33024, id, false, response), remoteAddress));
            }
        } else {
            if (type == 24582) {
                this.sendGeneralResponse(channel, remoteAddress, id, type, index);
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.getLastLocation(position, null);
                buf.readUnsignedByte();
                Charset charset = Charset.isSupported("GBK") ? Charset.forName("GBK") : StandardCharsets.US_ASCII;
                position.set("result", buf.readCharSequence(buf.readableBytes() - 2, charset).toString());
                return position;
            }
            if (type == 2) {
                this.sendGeneralResponse(channel, remoteAddress, id, type, index);
                if (buf.readableBytes() >= 4) {
                    Position position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    this.getLastLocation(position, null);
                    position.set("batteryLevel", buf.readUnsignedByte());
                    position.set("rssi", buf.readUnsignedByte());
                    position.set("status", buf.readUnsignedByte());
                    return position;
                }
            } else if (type == 258 || type == 1286 || type == 34952) {
                this.sendGeneralResponse(channel, remoteAddress, id, type, index);
            } else {
                if (type == 512) {
                    this.sendGeneralResponse(channel, remoteAddress, id, type, index);
                    return this.decodeLocation(deviceSession, buf);
                }
                if (type == 21761 || type == 21762) {
                    if (BitUtil.check(attribute, 15)) {
                        this.sendGeneralResponse2(channel, remoteAddress, id, type);
                    }
                    return this.decodeLocation2(deviceSession, buf, type);
                }
                if (type == 1796 || type == 528) {
                    this.sendGeneralResponse(channel, remoteAddress, id, type, index);
                    return this.decodeLocationBatch(deviceSession, buf, type);
                }
                if (type == 265) {
                    if (channel != null) {
                        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                        ByteBuf response = Unpooled.buffer();
                        response.writeShort(calendar.get(1));
                        response.writeByte(calendar.get(2) + 1);
                        response.writeByte(calendar.get(5));
                        response.writeByte(calendar.get(11));
                        response.writeByte(calendar.get(12));
                        response.writeByte(calendar.get(13));
                        channel.writeAndFlush((Object)new NetworkMessage(HuabaoProtocolDecoder.formatMessage(this.delimiter, 33024, id, false, response), remoteAddress));
                    }
                } else {
                    if (type == 8304) {
                        Position position = new Position(this.getProtocolName());
                        position.setDeviceId(deviceSession.getDeviceId());
                        this.getLastLocation(position, null);
                        StringBuilder data = new StringBuilder("[");
                        while (buf.readableBytes() > 2) {
                            buf.skipBytes(6);
                            if (data.length() > 1) {
                                data.append(",");
                            }
                            data.append("[");
                            data.append(this.readSignedWord(buf));
                            data.append(",");
                            data.append(this.readSignedWord(buf));
                            data.append(",");
                            data.append(this.readSignedWord(buf));
                            data.append("]");
                        }
                        data.append("]");
                        position.set("gSensor", data.toString());
                        return position;
                    }
                    if (type == 2304) {
                        this.sendGeneralResponse(channel, remoteAddress, id, type, index);
                        return this.decodeTransparent(deviceSession, buf);
                    }
                    if (type == 1793) {
                        Position position = new Position(this.getProtocolName());
                        position.setDeviceId(deviceSession.getDeviceId());
                        this.getLastLocation(position, null);
                        String result = buf.readCharSequence(buf.readInt(), StandardCharsets.US_ASCII).toString();
                        position.set("result", result);
                        return position;
                    }
                    if (type == 1794) {
                        Position position = new Position(this.getProtocolName());
                        position.setDeviceId(deviceSession.getDeviceId());
                        this.getLastLocation(position, null);
                        position.set("cardStatus", buf.readUnsignedByte());
                        position.setDeviceTime(this.readDate(buf, (TimeZone)deviceSession.get("timezone")));
                        position.set("cardResult", buf.readUnsignedByte());
                        position.set("driver", buf.readString((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII));
                        position.set("cardCode", buf.readString(20, StandardCharsets.US_ASCII).trim());
                        position.set("cardAgency", buf.readString((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII));
                        position.set("cardValidity", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(4)));
                        return position;
                    }
                }
            }
        }
        return null;
    }

    private Position decodeResult(Channel channel, SocketAddress remoteAddress, String sentence) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession != null) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            position.set("result", sentence);
            return position;
        }
        return null;
    }

    private void decodeExtension(Position position, ByteBuf buf, int endIndex) {
        block24: while (buf.readerIndex() < endIndex) {
            short type = buf.readUnsignedByte();
            short length = buf.readUnsignedByte();
            switch (type) {
                case 1: {
                    position.set("odometer", buf.readUnsignedInt() * 100L);
                    continue block24;
                }
                case 2: {
                    position.set("fuel", (double)buf.readUnsignedShort() * 0.1);
                    continue block24;
                }
                case 3: {
                    position.set("obdSpeed", (double)buf.readUnsignedShort() * 0.1);
                    continue block24;
                }
                case 86: {
                    buf.readUnsignedByte();
                    position.set("batteryLevel", buf.readUnsignedByte());
                    continue block24;
                }
                case 97: {
                    position.set("power", (double)buf.readUnsignedShort() * 0.01);
                    continue block24;
                }
                case 105: {
                    position.set("battery", (double)buf.readUnsignedShort() * 0.01);
                    continue block24;
                }
                case 128: {
                    position.set("obdSpeed", buf.readUnsignedByte());
                    continue block24;
                }
                case 129: {
                    position.set("rpm", buf.readUnsignedShort());
                    continue block24;
                }
                case 130: {
                    position.set("power", (double)buf.readUnsignedShort() * 0.1);
                    continue block24;
                }
                case 131: {
                    position.set("engineLoad", buf.readUnsignedByte());
                    continue block24;
                }
                case 132: {
                    position.set("coolantTemp", buf.readUnsignedByte() - 40);
                    continue block24;
                }
                case 133: {
                    position.set("fuelConsumption", buf.readUnsignedShort());
                    continue block24;
                }
                case 134: {
                    position.set("intakeTemp", buf.readUnsignedByte() - 40);
                    continue block24;
                }
                case 135: {
                    position.set("intakeFlow", buf.readUnsignedShort());
                    continue block24;
                }
                case 136: {
                    position.set("intakePressure", buf.readUnsignedByte());
                    continue block24;
                }
                case 137: {
                    position.set("throttle", buf.readUnsignedByte());
                    continue block24;
                }
                case 139: {
                    position.set("vin", buf.readCharSequence(17, StandardCharsets.US_ASCII).toString());
                    continue block24;
                }
                case 140: {
                    position.set("obdOdometer", buf.readUnsignedInt() * 100L);
                    continue block24;
                }
                case 141: {
                    position.set("tripOdometer", (long)buf.readUnsignedShort() * 1000L);
                    continue block24;
                }
                case 142: {
                    position.set("fuel", buf.readUnsignedByte());
                    continue block24;
                }
                case 160: {
                    String codes = buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString();
                    position.set("dtcs", codes.replace(',', ' '));
                    continue block24;
                }
                case 204: {
                    position.set("iccid", buf.readCharSequence(20, StandardCharsets.US_ASCII).toString());
                    continue block24;
                }
            }
            buf.skipBytes((int)length);
        }
    }

    private void decodeCoordinates(Position position, DeviceSession deviceSession, ByteBuf buf) {
        int status = buf.readInt();
        String model = this.getDeviceModel(deviceSession);
        position.set("ignition", BitUtil.check(status, 0));
        if ("G1C Pro".equals(model)) {
            position.set("motion", BitUtil.check(status, 4));
        }
        position.set("blocked", BitUtil.check(status, 10));
        if ("MV810G".equals(model) || "MV710G".equals(model)) {
            position.set("door", BitUtil.check(status, 16));
        }
        position.set("charge", BitUtil.check(status, 26));
        position.setValid(BitUtil.check(status, 1));
        double lat = (double)buf.readUnsignedInt() * 1.0E-6;
        double lon = (double)buf.readUnsignedInt() * 1.0E-6;
        if (BitUtil.check(status, 2)) {
            position.setLatitude(-lat);
        } else {
            position.setLatitude(lat);
        }
        if (BitUtil.check(status, 3)) {
            position.setLongitude(-lon);
        } else {
            position.setLongitude(lon);
        }
    }

    private double decodeCustomDouble(ByteBuf buf) {
        byte b1 = buf.readByte();
        short b2 = buf.readUnsignedByte();
        int sign = b1 != 0 ? b1 / Math.abs(b1) : 1;
        return (double)sign * ((double)Math.abs(b1) + (double)b2 / 255.0);
    }

    private Position decodeLocation(DeviceSession deviceSession, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        String model = this.getDeviceModel(deviceSession);
        this.decodeAlarm(position, model, buf.readUnsignedInt());
        this.decodeCoordinates(position, deviceSession, buf);
        position.setAltitude(buf.readShort());
        position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShort() * 0.1));
        position.setCourse(buf.readUnsignedShort());
        position.setTime(this.readDate(buf, (TimeZone)deviceSession.get("timezone")));
        if (buf.readableBytes() == 20) {
            buf.skipBytes(4);
            position.set("odometer", buf.readUnsignedInt() * 1000L);
            position.set("battery", (double)buf.readUnsignedShort() * 0.1);
            buf.readUnsignedInt();
            position.set("rssi", buf.readUnsignedByte());
            buf.skipBytes(3);
            return position;
        }
        Network network = new Network();
        while (buf.readableBytes() > 2) {
            short subtype = buf.readUnsignedByte();
            short length = buf.readUnsignedByte();
            int endIndex = buf.readerIndex() + length;
            switch (subtype) {
                case 1: {
                    position.set("odometer", buf.readUnsignedInt() * 100L);
                    break;
                }
                case 2: {
                    int fuel = buf.readUnsignedShort();
                    if (BitUtil.check(fuel, 15)) {
                        position.set("fuel", BitUtil.to(fuel, 15));
                        break;
                    }
                    position.set("fuel", (double)fuel / 10.0);
                    break;
                }
                case 6: {
                    position.set("batteryLevel", buf.readUnsignedByte());
                    break;
                }
                case 11: {
                    position.set("lockCommand", buf.readUnsignedByte());
                    if (length >= 5 && length <= 6) {
                        position.set("lockCard", buf.readUnsignedInt());
                    } else if (length >= 7) {
                        position.set("lockPassword", buf.readCharSequence(6, StandardCharsets.US_ASCII).toString());
                    }
                    if (length % 2 != 0) break;
                    position.set("unlockResult", buf.readUnsignedByte());
                    break;
                }
                case 20: {
                    position.set("videoAlarm", buf.readUnsignedInt());
                    break;
                }
                case 37: {
                    position.set("input", buf.readUnsignedInt());
                    break;
                }
                case 43: 
                case 167: {
                    position.set("adc1", (double)buf.readUnsignedShort() / 100.0);
                    position.set("adc2", (double)buf.readUnsignedShort() / 100.0);
                    break;
                }
                case 48: {
                    position.set("rssi", buf.readUnsignedByte());
                    break;
                }
                case 49: {
                    position.set("sat", buf.readUnsignedByte());
                    break;
                }
                case 51: {
                    if (length == 1) {
                        position.set("mode", buf.readUnsignedByte());
                        break;
                    }
                    String stringValue = buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString();
                    if (!stringValue.startsWith("*M00")) break;
                    String lockStatus = stringValue.substring(8, 15);
                    position.set("battery", (double)Integer.parseInt(lockStatus.substring(2, 5)) * 0.01);
                    break;
                }
                case 81: {
                    if (length != 2 && length != 16) break;
                    for (int i = 1; i <= length / 2; ++i) {
                        int value = buf.readUnsignedShort();
                        if (value == 65535) continue;
                        if (BitUtil.check(value, 15)) {
                            position.set("temp" + i, (double)(-BitUtil.to(value, 15)) / 10.0);
                            continue;
                        }
                        position.set("temp" + i, (double)value / 10.0);
                    }
                    break;
                }
                case 86: {
                    position.set("batteryLevel", buf.readUnsignedByte() * 10);
                    buf.readUnsignedByte();
                    break;
                }
                case 87: {
                    int alarm = buf.readUnsignedShort();
                    position.addAlarm(BitUtil.check(alarm, 8) ? "hardAcceleration" : null);
                    position.addAlarm(BitUtil.check(alarm, 9) ? "hardBraking" : null);
                    position.addAlarm(BitUtil.check(alarm, 10) ? "hardCornering" : null);
                    buf.readUnsignedShort();
                    long alarm2 = buf.readUnsignedInt();
                    if (!"MV810G".equals(model) && !"MV710G".equals(model)) break;
                    position.addAlarm(BitUtil.check(alarm2, 16) ? "door" : null);
                    break;
                }
                case 96: {
                    int event = buf.readUnsignedShort();
                    position.set("event", event);
                    if (event < 97 || event > 102) break;
                    buf.skipBytes(6);
                    String stringValue = buf.readCharSequence(8, StandardCharsets.US_ASCII).toString();
                    position.set("driverUniqueId", stringValue);
                    break;
                }
                case 99: {
                    for (int i = 1; i <= length / 11; ++i) {
                        position.set("lock" + i + "Id", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
                        position.set("lock" + i + "Battery", (double)buf.readUnsignedShort() * 0.001);
                        position.set("lock" + i + "Seal", buf.readUnsignedByte() == 49);
                        buf.readUnsignedByte();
                        buf.readUnsignedByte();
                    }
                    break;
                }
                case 100: {
                    buf.readUnsignedInt();
                    buf.readUnsignedByte();
                    position.set("adasAlarm", buf.readUnsignedByte());
                    break;
                }
                case 101: {
                    buf.readUnsignedInt();
                    buf.readUnsignedByte();
                    position.set("dmsAlarm", buf.readUnsignedByte());
                    break;
                }
                case 103: {
                    String stringValue = buf.readCharSequence(8, StandardCharsets.US_ASCII).toString();
                    position.set("password", stringValue);
                    break;
                }
                case 112: {
                    buf.readUnsignedInt();
                    buf.readUnsignedByte();
                    switch (buf.readUnsignedByte()) {
                        case 1: {
                            position.addAlarm("hardAcceleration");
                            break;
                        }
                        case 2: {
                            position.addAlarm("hardBraking");
                            break;
                        }
                        case 3: {
                            position.addAlarm("hardCornering");
                            break;
                        }
                        case 22: {
                            position.addAlarm("accident");
                        }
                    }
                    break;
                }
                case 104: {
                    position.set("batteryLevel", (double)buf.readUnsignedShort() * 0.01);
                    break;
                }
                case 105: {
                    position.set("battery", (double)buf.readUnsignedShort() * 0.01);
                    break;
                }
                case 119: {
                    while (buf.readerIndex() < endIndex) {
                        short tireIndex = buf.readUnsignedByte();
                        position.set("tire" + tireIndex + "SensorId", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(3)));
                        position.set("tire" + tireIndex + "Pressure", (double)BitUtil.to(buf.readUnsignedShort(), 10) / 40.0);
                        position.set("tire" + tireIndex + "Temp", buf.readUnsignedByte() - 50);
                        position.set("tire" + tireIndex + "Status", buf.readUnsignedByte());
                    }
                    break;
                }
                case 128: {
                    buf.readUnsignedByte();
                    endIndex = buf.writerIndex() - 2;
                    this.decodeExtension(position, buf, endIndex);
                    break;
                }
                case 130: {
                    position.set("power", (double)buf.readUnsignedShort() / 10.0);
                    break;
                }
                case 145: {
                    position.set("battery", (double)buf.readUnsignedShort() * 0.1);
                    position.set("rpm", buf.readUnsignedShort());
                    position.set("obdSpeed", buf.readUnsignedByte());
                    position.set("throttle", buf.readUnsignedByte() * 100 / 255);
                    position.set("engineLoad", buf.readUnsignedByte() * 100 / 255);
                    position.set("coolantTemp", buf.readUnsignedByte() - 40);
                    buf.readUnsignedShort();
                    position.set("fuelConsumption", (double)buf.readUnsignedShort() * 0.01);
                    buf.readUnsignedShort();
                    buf.readUnsignedInt();
                    buf.readUnsignedShort();
                    position.set("fuelUsed", (double)buf.readUnsignedShort() * 0.01);
                    break;
                }
                case 148: {
                    if (length <= 0) break;
                    String stringValue = buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString();
                    position.set("vin", stringValue);
                    break;
                }
                case 172: {
                    position.set("odometer", buf.readUnsignedInt());
                    break;
                }
                case 188: {
                    String stringValue = buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString();
                    position.set("driver", stringValue.trim());
                    break;
                }
                case 189: {
                    String stringValue = buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString();
                    position.set("driverUniqueId", stringValue);
                    break;
                }
                case 208: {
                    long userStatus = buf.readUnsignedInt();
                    if (!BitUtil.check(userStatus, 3)) break;
                    position.addAlarm("vibration");
                    break;
                }
                case 211: {
                    position.set("power", (double)buf.readUnsignedShort() * 0.1);
                    break;
                }
                case 212: 
                case 225: 
                case 233: {
                    if (length == 1) {
                        short batteryLevel = buf.readUnsignedByte();
                        if (batteryLevel == 255) {
                            position.set("charge", true);
                            break;
                        }
                        position.set("batteryLevel", Integer.valueOf(batteryLevel));
                        break;
                    }
                    position.set("driverUniqueId", String.valueOf(buf.readUnsignedInt()));
                    break;
                }
                case 213: {
                    if (length == 2) {
                        position.set("battery", (double)buf.readUnsignedShort() * 0.01);
                        break;
                    }
                    int count = buf.readUnsignedByte();
                    for (int i = 1; i <= count; ++i) {
                        position.set("lock" + i + "Id", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(5)));
                        position.set("lock" + i + "Card", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(5)));
                        position.set("lock" + i + "Battery", buf.readUnsignedByte());
                        int status = buf.readUnsignedShort();
                        position.set("lock" + i + "Locked", !BitUtil.check(status, 5));
                    }
                    break;
                }
                case 218: {
                    buf.readUnsignedShort();
                    short deviceStatus = buf.readUnsignedByte();
                    position.set("string", BitUtil.check(deviceStatus, 0));
                    position.set("motion", BitUtil.check(deviceStatus, 2));
                    position.set("cover", BitUtil.check(deviceStatus, 3));
                    break;
                }
                case 226: {
                    if ("DT800".equals(model)) break;
                    position.set("fuel", (double)buf.readUnsignedInt() * 0.1);
                    break;
                }
                case 227: {
                    buf.readUnsignedByte();
                    position.set("batteryLevel", buf.readUnsignedByte());
                    position.set("battery", (double)buf.readUnsignedShort() / 100.0);
                    break;
                }
                case 228: {
                    if (buf.readUnsignedByte() == 0) {
                        position.set("charge", true);
                    }
                    position.set("batteryLevel", buf.readUnsignedByte());
                    break;
                }
                case 230: {
                    String header = buf.getCharSequence(buf.readerIndex(), 7, StandardCharsets.UTF_8).toString();
                    if (header.equals("$OBD-RT")) {
                        String data = buf.readCharSequence((int)length, StandardCharsets.UTF_8).toString();
                        this.decodeObdRt(position, data);
                        break;
                    }
                    while (buf.readerIndex() < endIndex) {
                        short sensorIndex = buf.readUnsignedByte();
                        buf.skipBytes(6);
                        position.set("temp" + sensorIndex, this.decodeCustomDouble(buf));
                        position.set("humidity" + sensorIndex, this.decodeCustomDouble(buf));
                    }
                    break;
                }
                case 232: {
                    position.set("lockStatus", buf.readUnsignedMedium());
                    break;
                }
                case 234: {
                    short extendedLength;
                    if (length <= 2) break;
                    buf.readUnsignedByte();
                    while (buf.readerIndex() < endIndex) {
                        short extendedType = buf.readUnsignedByte();
                        extendedLength = buf.readUnsignedByte();
                        int extendedEndIndex = buf.readerIndex() + extendedLength;
                        switch (extendedType) {
                            case 17: {
                                position.set("externalAlarms", buf.readUnsignedShort());
                                position.set("alarmThresholdType", buf.readUnsignedByte());
                                buf.readUnsignedInt();
                                buf.readUnsignedInt();
                                buf.readUnsignedInt();
                                break;
                            }
                            case 19: {
                                position.set("externalIlluminance", buf.readUnsignedShort());
                                break;
                            }
                            case 20: {
                                position.set("externalAirPressure", buf.readUnsignedShort());
                                break;
                            }
                            case 21: {
                                position.set("externalHumidity", (double)buf.readUnsignedShort() / 10.0);
                                break;
                            }
                            case 22: {
                                position.set("externalTemp", (double)buf.readUnsignedShort() / 10.0 - 50.0);
                                break;
                            }
                        }
                        buf.readerIndex(extendedEndIndex);
                    }
                    break;
                }
                case 235: {
                    if (buf.getUnsignedShort(buf.readerIndex()) > 200 && (length - 3) % 5 == 0) {
                        int mcc = buf.readUnsignedShort();
                        short mnc = buf.readUnsignedByte();
                        while (buf.readerIndex() < endIndex) {
                            network.addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedByte()));
                        }
                    } else {
                        if (BufferUtil.isPrintable(buf, length)) {
                            position.set("timezone", buf.readString((int)length, StandardCharsets.UTF_8));
                            break;
                        }
                        while (buf.readerIndex() < endIndex) {
                            int extendedLength = buf.readUnsignedShort();
                            int extendedEndIndex = buf.readerIndex() + extendedLength;
                            int extendedType = buf.readUnsignedShort();
                            switch (extendedType) {
                                case 1: {
                                    position.set("fuel1", (double)buf.readUnsignedShort() * 0.1);
                                    buf.readUnsignedByte();
                                    break;
                                }
                                case 35: {
                                    position.set("fuel2", Double.parseDouble(buf.readCharSequence(6, StandardCharsets.US_ASCII).toString()));
                                    break;
                                }
                                case 45: {
                                    position.set("battery", (double)buf.readUnsignedShort() / 1000.0);
                                    break;
                                }
                                case 178: {
                                    position.set("iccid", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(10)).replaceAll("f", ""));
                                    break;
                                }
                                case 185: {
                                    buf.readUnsignedByte();
                                    String[] wifi = buf.readCharSequence(extendedLength - 3, StandardCharsets.US_ASCII).toString().split(",");
                                    for (int i = 0; i < wifi.length / 2; ++i) {
                                        network.addWifiAccessPoint(WifiAccessPoint.from(wifi[i * 2], Integer.parseInt(wifi[i * 2 + 1])));
                                    }
                                    break;
                                }
                                case 198: {
                                    short batteryAlarm = buf.readUnsignedByte();
                                    if (batteryAlarm == 3 || batteryAlarm == 4) {
                                        position.set("alarm", "lowBattery");
                                    }
                                    position.set("batteryAlarm", Integer.valueOf(batteryAlarm));
                                    break;
                                }
                                case 206: {
                                    position.set("power", (double)buf.readUnsignedShort() * 0.01);
                                    break;
                                }
                                case 216: {
                                    network.addCellTower(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedByte(), buf.readUnsignedShort(), buf.readUnsignedInt()));
                                    break;
                                }
                                case 168: 
                                case 225: {
                                    position.set("batteryLevel", buf.readUnsignedByte());
                                    break;
                                }
                            }
                            buf.readerIndex(extendedEndIndex);
                        }
                    }
                    break;
                }
                case 237: {
                    String stringValue = buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString();
                    position.set("card", stringValue.trim());
                    break;
                }
                case 238: {
                    position.set("rssi", buf.readUnsignedByte());
                    position.set("power", (double)buf.readUnsignedShort() * 0.001);
                    position.set("battery", (double)buf.readUnsignedShort() * 0.001);
                    position.set("sat", buf.readUnsignedByte());
                    break;
                }
                case 241: {
                    position.set("power", (double)buf.readUnsignedInt() * 0.001);
                    break;
                }
                case 243: {
                    short extendedLength;
                    block110: while (buf.readerIndex() < endIndex) {
                        int extendedType = buf.readUnsignedShort();
                        extendedLength = buf.readUnsignedByte();
                        switch (extendedType) {
                            case 2: {
                                position.set("obdSpeed", (double)buf.readUnsignedShort() * 0.1);
                                continue block110;
                            }
                            case 3: {
                                position.set("rpm", buf.readUnsignedShort());
                                continue block110;
                            }
                            case 4: {
                                position.set("power", (double)buf.readUnsignedShort() * 0.001);
                                continue block110;
                            }
                            case 5: {
                                position.set("obdOdometer", buf.readUnsignedInt() * 100L);
                                continue block110;
                            }
                            case 7: {
                                position.set("fuelConsumption", (double)buf.readUnsignedShort() * 0.1);
                                continue block110;
                            }
                            case 8: {
                                position.set("engineLoad", (double)buf.readUnsignedShort() * 0.1);
                                continue block110;
                            }
                            case 9: {
                                position.set("coolantTemp", buf.readUnsignedShort() - 40);
                                continue block110;
                            }
                            case 11: {
                                position.set("intakePressure", buf.readUnsignedShort());
                                continue block110;
                            }
                            case 12: {
                                position.set("intakeTemp", buf.readUnsignedShort() - 40);
                                continue block110;
                            }
                            case 13: {
                                position.set("intakeFlow", buf.readUnsignedShort());
                                continue block110;
                            }
                            case 14: {
                                position.set("throttle", buf.readUnsignedShort() * 100 / 255);
                                continue block110;
                            }
                            case 80: {
                                position.set("vin", BufferUtil.readString(buf, 17));
                                continue block110;
                            }
                            case 81: {
                                if (extendedLength <= 0) continue block110;
                                position.set("cvn", ByteBufUtil.hexDump((ByteBuf)buf.readSlice((int)extendedLength)));
                                continue block110;
                            }
                            case 82: {
                                if (extendedLength <= 0) continue block110;
                                position.set("calid", BufferUtil.readString(buf, extendedLength));
                                continue block110;
                            }
                            case 256: {
                                position.set("tripOdometer", (double)buf.readUnsignedShort() * 0.1);
                                continue block110;
                            }
                            case 258: {
                                position.set("tripFuel", (double)buf.readUnsignedShort() * 0.1);
                                continue block110;
                            }
                            case 274: {
                                position.set("hardAccelerationCount", buf.readUnsignedShort());
                                continue block110;
                            }
                            case 275: {
                                position.set("hardDecelerationCount", buf.readUnsignedShort());
                                continue block110;
                            }
                            case 276: {
                                position.set("hardCorneringCount", buf.readUnsignedShort());
                                continue block110;
                            }
                        }
                        buf.skipBytes((int)extendedLength);
                    }
                    break;
                }
                case 244: {
                    while (buf.readerIndex() < endIndex) {
                        String mac = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)).replaceAll("(..)", "$1:");
                        network.addWifiAccessPoint(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), buf.readByte()));
                    }
                    break;
                }
                case 245: {
                    if (length != 2) break;
                    position.set("illuminance", buf.readUnsignedShort());
                    break;
                }
                case 246: {
                    short fieldMask;
                    if (length == 2) {
                        position.set("airPressure", buf.readUnsignedShort());
                        break;
                    }
                    int event = buf.readUnsignedByte();
                    position.set("event", event);
                    if (event == 2) {
                        position.set("motion", true);
                    }
                    if (BitUtil.check(fieldMask = buf.readUnsignedByte(), 0)) {
                        position.set("lightSensor", buf.readUnsignedShort());
                    }
                    if (BitUtil.check(fieldMask, 1)) {
                        position.set("temp1", (double)buf.readShort() * 0.1);
                    }
                    if (!BitUtil.check(fieldMask, 2)) break;
                    position.set("humidity", (double)buf.readShort() * 0.1);
                    break;
                }
                case 247: {
                    short batteryStatus;
                    if (length == 2) {
                        position.set("humidity", (double)buf.readUnsignedShort() / 10.0);
                        break;
                    }
                    position.set("battery", (double)buf.readUnsignedInt() * 0.001);
                    if (length >= 5 && ((batteryStatus = buf.readUnsignedByte()) == 2 || batteryStatus == 3)) {
                        position.set("charge", true);
                    }
                    if (length < 6) break;
                    position.set("batteryLevel", buf.readUnsignedByte());
                    break;
                }
                case 248: {
                    position.set("temp2", (double)buf.readUnsignedShort() / 10.0 - 50.0);
                    break;
                }
                case 251: {
                    position.set("container", buf.readCharSequence((int)length, StandardCharsets.US_ASCII).toString());
                    break;
                }
                case 252: {
                    position.set("geofence", buf.readUnsignedByte());
                    break;
                }
                case 254: {
                    if (length == 1) {
                        position.set("batteryLevel", buf.readUnsignedByte());
                        break;
                    }
                    if (length == 2) {
                        position.set("power", (double)buf.readUnsignedShort() * 0.1);
                        break;
                    }
                    if (length == 4) {
                        position.set("odometer", buf.readUnsignedInt());
                        break;
                    }
                    short mark = buf.readUnsignedByte();
                    if (mark == 124) {
                        while (buf.readerIndex() < endIndex) {
                            short extendedType = buf.readUnsignedByte();
                            short extendedLength = buf.readUnsignedByte();
                            if (extendedType == 1) {
                                long alarms = buf.readUnsignedInt();
                                if (BitUtil.check(alarms, 0)) {
                                    position.addAlarm("hardAcceleration");
                                }
                                if (BitUtil.check(alarms, 1)) {
                                    position.addAlarm("hardBraking");
                                }
                                if (BitUtil.check(alarms, 2)) {
                                    position.addAlarm("hardCornering");
                                }
                                if (BitUtil.check(alarms, 3)) {
                                    position.addAlarm("accident");
                                }
                                if (!BitUtil.check(alarms, 4)) continue;
                                position.addAlarm("tampering");
                                continue;
                            }
                            buf.skipBytes((int)extendedLength);
                        }
                    }
                    position.set("batteryLevel", buf.readUnsignedByte());
                    break;
                }
            }
            buf.readerIndex(endIndex);
        }
        if (network.getCellTowers() != null || network.getWifiAccessPoints() != null) {
            position.setNetwork(network);
        }
        return position;
    }

    private Position decodeLocation2(DeviceSession deviceSession, ByteBuf buf, int type) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        Jt600ProtocolDecoder.decodeBinaryLocation(buf, position);
        position.setValid(type != 21762);
        position.set("rssi", buf.readUnsignedByte());
        position.set("sat", buf.readUnsignedByte());
        position.set("odometer", buf.readUnsignedInt() * 1000L);
        short battery = buf.readUnsignedByte();
        if (battery <= 100) {
            position.set("batteryLevel", Integer.valueOf(battery));
        } else if (battery == 170 || battery == 171) {
            position.set("charge", true);
        }
        long cid = buf.readUnsignedInt();
        int lac = buf.readUnsignedShort();
        if (cid > 0L && lac > 0) {
            position.setNetwork(new Network(CellTower.fromCidLac(this.getConfig(), cid, lac)));
        }
        short product = buf.readUnsignedByte();
        int status = buf.readUnsignedShort();
        int alarm = buf.readUnsignedShort();
        if (product == 1 || product == 2) {
            if (BitUtil.check(alarm, 0)) {
                position.addAlarm("lowPower");
            }
        } else if (product == 3) {
            position.set("blocked", BitUtil.check(status, 5));
            if (BitUtil.check(alarm, 0)) {
                position.addAlarm("overspeed");
            }
            if (BitUtil.check(alarm, 1)) {
                position.addAlarm("lowPower");
            }
            if (BitUtil.check(alarm, 2)) {
                position.addAlarm("vibration");
            }
            if (BitUtil.check(alarm, 3)) {
                position.addAlarm("lowBattery");
            }
            if (BitUtil.check(alarm, 5)) {
                position.addAlarm("geofenceEnter");
            }
            if (BitUtil.check(alarm, 6)) {
                position.addAlarm("geofenceExit");
            }
        }
        position.set("status", status);
        block8: while (buf.readableBytes() > 2) {
            short id = buf.readUnsignedByte();
            short length = buf.readUnsignedByte();
            switch (id) {
                case 2: {
                    position.setAltitude(buf.readShort());
                    continue block8;
                }
                case 16: {
                    position.set("wakeSource", buf.readUnsignedByte());
                    continue block8;
                }
                case 10: {
                    if (length == 3) {
                        buf.readUnsignedShort();
                        buf.readUnsignedByte();
                        continue block8;
                    }
                    buf.skipBytes((int)length);
                    continue block8;
                }
                case 11: {
                    position.set("lockCommand", buf.readUnsignedByte());
                    if (length >= 5 && length <= 6) {
                        position.set("lockCard", buf.readUnsignedInt());
                    } else if (length >= 7) {
                        position.set("lockPassword", buf.readCharSequence(6, StandardCharsets.US_ASCII).toString());
                    }
                    if (length % 2 != 0) continue block8;
                    position.set("unlockResult", buf.readUnsignedByte());
                    continue block8;
                }
                case 12: {
                    int z;
                    int y;
                    int x = buf.readUnsignedShort();
                    if (x > 32768) {
                        x -= 65536;
                    }
                    if ((y = buf.readUnsignedShort()) > 32768) {
                        y -= 65536;
                    }
                    if ((z = buf.readUnsignedShort()) > 32768) {
                        z -= 65536;
                    }
                    position.set("tilt", String.format("[%d,%d,%d]", x, y, z));
                    continue block8;
                }
                case 252: {
                    position.set("geofence", buf.readUnsignedByte());
                    continue block8;
                }
            }
            buf.skipBytes((int)length);
        }
        return position;
    }

    private List<Position> decodeLocationBatch(DeviceSession deviceSession, ByteBuf buf, int type) {
        LinkedList<Position> positions = new LinkedList<Position>();
        short locationType = 0;
        if (type == 1796) {
            buf.readUnsignedShort();
            locationType = buf.readUnsignedByte();
        }
        while (buf.readableBytes() > 2) {
            int length = type == 528 ? buf.readUnsignedByte() : buf.readUnsignedShort();
            ByteBuf fragment = buf.readSlice(length);
            Position position = this.decodeLocation(deviceSession, fragment);
            if (locationType > 0) {
                position.set("archive", true);
            }
            positions.add(position);
        }
        return positions;
    }

    private Position decodeTransparent(DeviceSession deviceSession, ByteBuf buf) {
        short type = buf.readUnsignedByte();
        if (type == 64) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            String data = buf.readCharSequence(buf.readableBytes(), StandardCharsets.US_ASCII).toString().trim();
            if (data.startsWith("GTSL")) {
                String[] values = data.split("\\|");
                if (values.length > 4) {
                    position.set("driverUniqueId", values[4]);
                }
            } else {
                position.set("data", data);
            }
            return position.getAttributes().isEmpty() ? null : position;
        }
        if (type == 65) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            String data = buf.readCharSequence(buf.readableBytes() - 2, StandardCharsets.US_ASCII).toString().trim();
            this.decodeObdRt(position, data);
            return position;
        }
        if (type == 240) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            Date time = this.readDate(buf, (TimeZone)deviceSession.get("timezone"));
            if (buf.readUnsignedByte() > 0) {
                position.set("archive", true);
            }
            buf.readUnsignedByte();
            short subtype = buf.readUnsignedByte();
            switch (subtype) {
                case 1: {
                    int count = buf.readUnsignedByte();
                    block48: for (int i = 0; i < count; ++i) {
                        int id = buf.readUnsignedShort();
                        short length = buf.readUnsignedByte();
                        switch (id) {
                            case 258: 
                            case 1320: 
                            case 1350: {
                                position.set("odometer", buf.readUnsignedInt() * 100L);
                                continue block48;
                            }
                            case 259: {
                                position.set("fuel", (double)buf.readUnsignedInt() * 0.01);
                                continue block48;
                            }
                            case 273: {
                                position.set("fuelTemp", buf.readUnsignedByte() - 40);
                                continue block48;
                            }
                            case 302: {
                                position.set("oilLevel", (double)buf.readUnsignedShort() * 0.1);
                                continue block48;
                            }
                            case 1322: {
                                position.set("fuel", (double)buf.readUnsignedShort() * 0.01);
                                continue block48;
                            }
                            case 261: 
                            case 1324: {
                                position.set("fuelUsed", (double)buf.readUnsignedInt() * 0.01);
                                continue block48;
                            }
                            case 330: 
                            case 1335: 
                            case 1336: 
                            case 1337: {
                                position.set("fuelConsumption", (double)buf.readUnsignedShort() * 0.01);
                                continue block48;
                            }
                            case 1323: {
                                position.set("fuel", buf.readUnsignedByte());
                                continue block48;
                            }
                            case 1325: {
                                position.set("coolantTemp", buf.readUnsignedByte() - 40);
                                continue block48;
                            }
                            case 1326: {
                                position.set("airTemp", buf.readUnsignedByte() - 40);
                                continue block48;
                            }
                            case 1328: {
                                position.set("power", (double)buf.readUnsignedShort() * 0.001);
                                continue block48;
                            }
                            case 1333: {
                                position.set("obdSpeed", (double)buf.readUnsignedShort() * 0.1);
                                continue block48;
                            }
                            case 1334: {
                                position.set("rpm", buf.readUnsignedShort());
                                continue block48;
                            }
                            case 1341: {
                                position.set("intakePressure", (double)buf.readUnsignedShort() * 0.1);
                                continue block48;
                            }
                            case 1348: {
                                position.set("liquidLevel", buf.readUnsignedByte());
                                continue block48;
                            }
                            case 1351: 
                            case 1352: {
                                position.set("throttle", buf.readUnsignedByte());
                                continue block48;
                            }
                            default: {
                                switch (length) {
                                    case 1: {
                                        position.set("io" + id, buf.readUnsignedByte());
                                        continue block48;
                                    }
                                    case 2: {
                                        position.set("io" + id, buf.readUnsignedShort());
                                        continue block48;
                                    }
                                    case 4: {
                                        position.set("io" + id, buf.readUnsignedInt());
                                        continue block48;
                                    }
                                }
                                buf.skipBytes((int)length);
                            }
                        }
                    }
                    this.getLastLocation(position, time);
                    this.decodeCoordinates(position, deviceSession, buf);
                    position.setTime(time);
                    break;
                }
                case 2: {
                    LinkedList<String> codes = new LinkedList<String>();
                    int count = buf.readUnsignedShort();
                    for (int i = 0; i < count; ++i) {
                        buf.readUnsignedInt();
                        int codeCount = buf.readUnsignedShort();
                        for (int j = 0; j < codeCount; ++j) {
                            buf.readUnsignedInt();
                            buf.readUnsignedInt();
                            codes.add(buf.readCharSequence(buf.readUnsignedShort(), StandardCharsets.US_ASCII).toString().trim());
                        }
                    }
                    position.set("dtcs", String.join((CharSequence)" ", codes));
                    this.getLastLocation(position, time);
                    this.decodeCoordinates(position, deviceSession, buf);
                    position.setTime(time);
                    break;
                }
                case 3: {
                    int count = buf.readUnsignedByte();
                    for (int i = 0; i < count; ++i) {
                        short id = buf.readUnsignedByte();
                        short length = buf.readUnsignedByte();
                        switch (id) {
                            case 1: {
                                position.addAlarm("powerRestored");
                                break;
                            }
                            case 2: {
                                position.addAlarm("powerCut");
                                break;
                            }
                            case 26: {
                                position.addAlarm("hardAcceleration");
                                break;
                            }
                            case 27: {
                                position.addAlarm("hardBraking");
                                break;
                            }
                            case 28: {
                                position.addAlarm("hardCornering");
                                break;
                            }
                            case 29: 
                            case 30: 
                            case 31: {
                                position.addAlarm("laneChange");
                                break;
                            }
                            case 35: {
                                position.addAlarm("fatigueDriving");
                                break;
                            }
                            case 38: 
                            case 39: 
                            case 40: {
                                position.addAlarm("accident");
                                break;
                            }
                            case 49: 
                            case 50: {
                                position.addAlarm("door");
                                break;
                            }
                        }
                        buf.skipBytes((int)length);
                    }
                    this.getLastLocation(position, time);
                    this.decodeCoordinates(position, deviceSession, buf);
                    position.setTime(time);
                    break;
                }
                case 11: {
                    if (buf.readUnsignedByte() > 0) {
                        position.set("vin", buf.readCharSequence(17, StandardCharsets.US_ASCII).toString());
                    }
                    this.getLastLocation(position, time);
                    break;
                }
                case 21: {
                    int event = buf.readInt();
                    switch (event) {
                        case 51: {
                            position.addAlarm("hardAcceleration");
                            break;
                        }
                        case 52: {
                            position.addAlarm("hardBraking");
                            break;
                        }
                        case 53: {
                            position.addAlarm("hardCornering");
                            break;
                        }
                        case 54: {
                            position.addAlarm("laneChange");
                            break;
                        }
                        case 56: {
                            position.addAlarm("accident");
                            break;
                        }
                        default: {
                            position.set("event", event);
                        }
                    }
                    this.getLastLocation(position, time);
                    break;
                }
                default: {
                    return null;
                }
            }
            return position;
        }
        if (type == 255) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setValid(true);
            position.setTime(this.readDate(buf, (TimeZone)deviceSession.get("timezone")));
            position.setLatitude((double)buf.readInt() * 1.0E-6);
            position.setLongitude((double)buf.readInt() * 1.0E-6);
            position.setAltitude(buf.readShort());
            position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShort() * 0.1));
            position.setCourse(buf.readUnsignedShort());
            return position;
        }
        return null;
    }
}

