/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class BwsProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_KEEP_ALIVE = 63;
    public static final int MSG_ACK = 64;
    public static final int MSG_NACK = 65;
    public static final int MSG_ACTION = 66;
    public static final int MSG_CHECK = 67;
    public static final int MSG_DEFINE = 68;

    public BwsProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int deviceType, ByteBuf id, int type, int index) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(deviceType);
            response.writeBytes(id);
            response.writeByte(type);
            response.writeByte(index);
            response.writeByte(Checksum.crc8(Checksum.CRC8_DALLAS, response.nioBuffer()));
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        short deviceType = buf.readUnsignedByte();
        ByteBuf id = buf.readSlice(4);
        short messageType = buf.readUnsignedByte();
        short index = buf.readUnsignedByte();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)id));
        this.sendResponse(channel, remoteAddress, deviceType, id, deviceSession != null ? 64 : 65, index);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("event", Integer.valueOf(messageType));
        position.setTime(new Date(buf.readUnsignedInt() * 1000L));
        position.setLatitude((double)buf.readInt() / 360000.0);
        position.setLongitude((double)buf.readInt() / 360000.0);
        short flags = buf.readUnsignedByte();
        position.setValid(BitUtil.check(flags, 7));
        position.set("sat", BitUtil.to(flags, 7));
        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
        position.setCourse((double)buf.readUnsignedShort() / 10.0);
        position.set("power", (double)buf.readUnsignedShort() / 10.0);
        position.set("battery", (double)buf.readUnsignedByte() / 10.0);
        position.set("io1", buf.readUnsignedShort());
        position.set("odometer", buf.readUnsignedMedium() * 100);
        position.set("hours", (long)buf.readUnsignedMedium() * 60000L);
        position.set("deviceTemp", buf.readUnsignedByte());
        position.set("rssi", buf.readUnsignedByte());
        buf.readUnsignedByte();
        return position;
    }
}

