/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.ErrorCode;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.NonNull;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigException;
import com.google.firebase.remoteconfig.Parameter;
import com.google.firebase.remoteconfig.ParameterGroup;
import com.google.firebase.remoteconfig.ServerCondition;
import com.google.firebase.remoteconfig.Version;
import com.google.firebase.remoteconfig.internal.ServerTemplateResponse;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class ServerTemplateData {
    private String etag;
    private Map<String, Parameter> parameters;
    private List<ServerCondition> serverConditions;
    private Map<String, ParameterGroup> parameterGroups;
    private Version version;

    ServerTemplateData(String etag) {
        this.parameters = new HashMap<String, Parameter>();
        this.serverConditions = new ArrayList<ServerCondition>();
        this.parameterGroups = new HashMap<String, ParameterGroup>();
        this.etag = etag;
    }

    ServerTemplateData() {
        this((String)null);
    }

    ServerTemplateData(@NonNull ServerTemplateResponse serverTemplateResponse) {
        Preconditions.checkNotNull((Object)serverTemplateResponse);
        this.parameters = new HashMap<String, Parameter>();
        this.serverConditions = new ArrayList<ServerCondition>();
        this.parameterGroups = new HashMap<String, ParameterGroup>();
        if (serverTemplateResponse.getParameters() != null) {
            for (Map.Entry entry : serverTemplateResponse.getParameters().entrySet()) {
                this.parameters.put((String)entry.getKey(), new Parameter((TemplateResponse.ParameterResponse)entry.getValue()));
            }
        }
        if (serverTemplateResponse.getServerConditions() != null) {
            for (ServerTemplateResponse.ServerConditionResponse serverConditionResponse : serverTemplateResponse.getServerConditions()) {
                this.serverConditions.add(new ServerCondition(serverConditionResponse));
            }
        }
        if (serverTemplateResponse.getParameterGroups() != null) {
            for (Map.Entry entry : serverTemplateResponse.getParameterGroups().entrySet()) {
                this.parameterGroups.put((String)entry.getKey(), new ParameterGroup((TemplateResponse.ParameterGroupResponse)entry.getValue()));
            }
        }
        if (serverTemplateResponse.getVersion() != null) {
            this.version = new Version(serverTemplateResponse.getVersion());
        }
        this.etag = serverTemplateResponse.getEtag();
    }

    static ServerTemplateData fromJSON(@NonNull String json) throws FirebaseRemoteConfigException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)json) ? 1 : 0) != 0, (Object)"JSON String must not be null or empty.");
        JsonFactory jsonFactory = ApiClientUtils.getDefaultJsonFactory();
        try {
            ServerTemplateResponse serverTemplateResponse = (ServerTemplateResponse)jsonFactory.createJsonParser(json).parseAndClose(ServerTemplateResponse.class);
            return new ServerTemplateData(serverTemplateResponse);
        }
        catch (IOException e) {
            throw new FirebaseRemoteConfigException(ErrorCode.INVALID_ARGUMENT, "Unable to parse JSON string.");
        }
    }

    String getETag() {
        return this.etag;
    }

    @NonNull
    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    @NonNull
    List<ServerCondition> getServerConditions() {
        return this.serverConditions;
    }

    @NonNull
    Map<String, ParameterGroup> getParameterGroups() {
        return this.parameterGroups;
    }

    Version getVersion() {
        return this.version;
    }

    ServerTemplateData setParameters(@NonNull Map<String, Parameter> parameters) {
        Preconditions.checkNotNull(parameters, (Object)"parameters must not be null.");
        this.parameters = parameters;
        return this;
    }

    ServerTemplateData setServerConditions(@NonNull List<ServerCondition> conditions) {
        Preconditions.checkNotNull(conditions, (Object)"conditions must not be null.");
        this.serverConditions = conditions;
        return this;
    }

    ServerTemplateData setParameterGroups(@NonNull Map<String, ParameterGroup> parameterGroups) {
        Preconditions.checkNotNull(parameterGroups, (Object)"parameter groups must not be null.");
        this.parameterGroups = parameterGroups;
        return this;
    }

    ServerTemplateData setVersion(Version version) {
        this.version = version;
        return this;
    }

    String toJSON() {
        JsonFactory jsonFactory = ApiClientUtils.getDefaultJsonFactory();
        try {
            return jsonFactory.toString((Object)this.toServerTemplateResponse(true));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    ServerTemplateData setETag(String etag) {
        this.etag = etag;
        return this;
    }

    ServerTemplateResponse toServerTemplateResponse(boolean includeAll) {
        HashMap<String, TemplateResponse.ParameterResponse> parameterResponses = new HashMap<String, TemplateResponse.ParameterResponse>();
        for (Map.Entry<String, Parameter> entry : this.parameters.entrySet()) {
            parameterResponses.put(entry.getKey(), entry.getValue().toParameterResponse());
        }
        ArrayList<ServerTemplateResponse.ServerConditionResponse> serverConditionResponses = new ArrayList<ServerTemplateResponse.ServerConditionResponse>();
        for (ServerCondition serverCondition : this.serverConditions) {
            serverConditionResponses.add(serverCondition.toServerConditionResponse());
        }
        HashMap<String, TemplateResponse.ParameterGroupResponse> hashMap = new HashMap<String, TemplateResponse.ParameterGroupResponse>();
        for (Map.Entry<String, ParameterGroup> entry : this.parameterGroups.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().toParameterGroupResponse());
        }
        TemplateResponse.VersionResponse versionResponse = this.version == null ? null : this.version.toVersionResponse(includeAll);
        ServerTemplateResponse serverTemplateResponse = new ServerTemplateResponse().setParameters(parameterResponses).setServerConditions(serverConditionResponses).setParameterGroups(hashMap).setVersion(versionResponse);
        if (includeAll) {
            return serverTemplateResponse.setEtag(this.etag);
        }
        return serverTemplateResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerTemplateData template = (ServerTemplateData)o;
        return Objects.equals(this.etag, template.etag) && Objects.equals(this.parameters, template.parameters) && Objects.equals(this.serverConditions, template.serverConditions) && Objects.equals(this.parameterGroups, template.parameterGroups) && Objects.equals(this.version, template.version);
    }

    public int hashCode() {
        return Objects.hash(this.etag, this.parameters, this.serverConditions, this.parameterGroups, this.version);
    }
}

