/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ShareGroupDescribeResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<DescribedGroup> groups;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("groups", new CompactArrayOf(DescribedGroup.SCHEMA_1), "Each described group."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 1;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public ShareGroupDescribeResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ShareGroupDescribeResponseData() {
        this.throttleTimeMs = 0;
        this.groups = new ArrayList<DescribedGroup>(0);
    }

    @Override
    public short apiKey() {
        return 77;
    }

    @Override
    public short lowestSupportedVersion() {
        return 1;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field groups was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<DescribedGroup> newCollection = new ArrayList<DescribedGroup>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new DescribedGroup(_readable, _version));
        }
        this.groups = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeUnsignedVarint(this.groups.size() + 1);
        for (DescribedGroup groupsElement : this.groups) {
            groupsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.groups.size() + 1));
        for (DescribedGroup groupsElement : this.groups) {
            groupsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShareGroupDescribeResponseData)) {
            return false;
        }
        ShareGroupDescribeResponseData other = (ShareGroupDescribeResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.groups == null ? 0 : this.groups.hashCode());
        return hashCode;
    }

    @Override
    public ShareGroupDescribeResponseData duplicate() {
        ShareGroupDescribeResponseData _duplicate = new ShareGroupDescribeResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<DescribedGroup> newGroups = new ArrayList<DescribedGroup>(this.groups.size());
        for (DescribedGroup _element : this.groups) {
            newGroups.add(_element.duplicate());
        }
        _duplicate.groups = newGroups;
        return _duplicate;
    }

    public String toString() {
        return "ShareGroupDescribeResponseData(throttleTimeMs=" + this.throttleTimeMs + ", groups=" + MessageUtil.deepToString(this.groups.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<DescribedGroup> groups() {
        return this.groups;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ShareGroupDescribeResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ShareGroupDescribeResponseData setGroups(List<DescribedGroup> v) {
        this.groups = v;
        return this;
    }

    public static class DescribedGroup
    implements Message {
        short errorCode;
        String errorMessage;
        String groupId;
        String groupState;
        int groupEpoch;
        int assignmentEpoch;
        String assignorName;
        List<Member> members;
        int authorizedOperations;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The describe error, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The top-level error message, or null if there was no error."), new Field("group_id", Type.COMPACT_STRING, "The group ID string."), new Field("group_state", Type.COMPACT_STRING, "The group state string, or the empty string."), new Field("group_epoch", Type.INT32, "The group epoch."), new Field("assignment_epoch", Type.INT32, "The assignment epoch."), new Field("assignor_name", Type.COMPACT_STRING, "The selected assignor."), new Field("members", new CompactArrayOf(Member.SCHEMA_1), "The members."), new Field("authorized_operations", Type.INT32, "32-bit bitfield to represent authorized operations for this group."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public DescribedGroup(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribedGroup() {
            this.errorCode = 0;
            this.errorMessage = null;
            this.groupId = "";
            this.groupState = "";
            this.groupEpoch = 0;
            this.assignmentEpoch = 0;
            this.assignorName = "";
            this.members = new ArrayList<Member>(0);
            this.authorizedOperations = Integer.MIN_VALUE;
        }

        @Override
        public short lowestSupportedVersion() {
            return 1;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribedGroup");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupId had invalid length " + length);
            }
            this.groupId = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field groupState was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field groupState had invalid length " + length);
            }
            this.groupState = _readable.readString(length);
            this.groupEpoch = _readable.readInt();
            this.assignmentEpoch = _readable.readInt();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field assignorName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field assignorName had invalid length " + length);
            }
            this.assignorName = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field members was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Member> newCollection = new ArrayList<Member>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new Member(_readable, _version));
            }
            this.members = newCollection;
            this.authorizedOperations = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _stringBytes = _cache.getSerializedValue(this.groupId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.groupState);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.groupEpoch);
            _writable.writeInt(this.assignmentEpoch);
            _stringBytes = _cache.getSerializedValue(this.assignorName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.members.size() + 1);
            _stringBytes = this.members.iterator();
            while (_stringBytes.hasNext()) {
                Member membersElement = (Member)_stringBytes.next();
                membersElement.write(_writable, _cache, _version);
            }
            _writable.writeInt(this.authorizedOperations);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribedGroup");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.groupId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.groupState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'groupState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.groupState, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            _size.addBytes(4);
            _stringBytes = this.assignorName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'assignorName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.assignorName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.members.size() + 1));
            for (Member membersElement : this.members) {
                membersElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedGroup)) {
                return false;
            }
            DescribedGroup other = (DescribedGroup)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            if (this.groupState == null ? other.groupState != null : !this.groupState.equals(other.groupState)) {
                return false;
            }
            if (this.groupEpoch != other.groupEpoch) {
                return false;
            }
            if (this.assignmentEpoch != other.assignmentEpoch) {
                return false;
            }
            if (this.assignorName == null ? other.assignorName != null : !this.assignorName.equals(other.assignorName)) {
                return false;
            }
            if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
                return false;
            }
            if (this.authorizedOperations != other.authorizedOperations) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
            hashCode = 31 * hashCode + (this.groupState == null ? 0 : this.groupState.hashCode());
            hashCode = 31 * hashCode + this.groupEpoch;
            hashCode = 31 * hashCode + this.assignmentEpoch;
            hashCode = 31 * hashCode + (this.assignorName == null ? 0 : this.assignorName.hashCode());
            hashCode = 31 * hashCode + (this.members == null ? 0 : this.members.hashCode());
            hashCode = 31 * hashCode + this.authorizedOperations;
            return hashCode;
        }

        @Override
        public DescribedGroup duplicate() {
            DescribedGroup _duplicate = new DescribedGroup();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.groupId = this.groupId;
            _duplicate.groupState = this.groupState;
            _duplicate.groupEpoch = this.groupEpoch;
            _duplicate.assignmentEpoch = this.assignmentEpoch;
            _duplicate.assignorName = this.assignorName;
            ArrayList<Member> newMembers = new ArrayList<Member>(this.members.size());
            for (Member _element : this.members) {
                newMembers.add(_element.duplicate());
            }
            _duplicate.members = newMembers;
            _duplicate.authorizedOperations = this.authorizedOperations;
            return _duplicate;
        }

        public String toString() {
            return "DescribedGroup(errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", groupId=" + (String)(this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", groupState=" + (String)(this.groupState == null ? "null" : "'" + this.groupState.toString() + "'") + ", groupEpoch=" + this.groupEpoch + ", assignmentEpoch=" + this.assignmentEpoch + ", assignorName=" + (String)(this.assignorName == null ? "null" : "'" + this.assignorName.toString() + "'") + ", members=" + MessageUtil.deepToString(this.members.iterator()) + ", authorizedOperations=" + this.authorizedOperations + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public String groupId() {
            return this.groupId;
        }

        public String groupState() {
            return this.groupState;
        }

        public int groupEpoch() {
            return this.groupEpoch;
        }

        public int assignmentEpoch() {
            return this.assignmentEpoch;
        }

        public String assignorName() {
            return this.assignorName;
        }

        public List<Member> members() {
            return this.members;
        }

        public int authorizedOperations() {
            return this.authorizedOperations;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribedGroup setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribedGroup setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public DescribedGroup setGroupId(String v) {
            this.groupId = v;
            return this;
        }

        public DescribedGroup setGroupState(String v) {
            this.groupState = v;
            return this;
        }

        public DescribedGroup setGroupEpoch(int v) {
            this.groupEpoch = v;
            return this;
        }

        public DescribedGroup setAssignmentEpoch(int v) {
            this.assignmentEpoch = v;
            return this;
        }

        public DescribedGroup setAssignorName(String v) {
            this.assignorName = v;
            return this;
        }

        public DescribedGroup setMembers(List<Member> v) {
            this.members = v;
            return this;
        }

        public DescribedGroup setAuthorizedOperations(int v) {
            this.authorizedOperations = v;
            return this;
        }
    }

    public static class TopicPartitions
    implements Message {
        Uuid topicId;
        String topicName;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_id", Type.UUID, "The topic ID."), new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(Type.INT32), "The partitions."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public TopicPartitions(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicPartitions() {
            this.topicId = Uuid.ZERO_UUID;
            this.topicName = "";
            this.partitions = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            this.topicId = _readable.readUuid();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(16);
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartitions)) {
                return false;
            }
            TopicPartitions other = (TopicPartitions)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicPartitions duplicate() {
            TopicPartitions _duplicate = new TopicPartitions();
            _duplicate.topicId = this.topicId;
            _duplicate.topicName = this.topicName;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicPartitions(topicId=" + this.topicId.toString() + ", topicName=" + (String)(this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public String topicName() {
            return this.topicName;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicPartitions setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public TopicPartitions setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public TopicPartitions setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class Assignment
    implements Message {
        List<TopicPartitions> topicPartitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_partitions", new CompactArrayOf(TopicPartitions.SCHEMA_1), "The assigned topic-partitions to the member."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public Assignment(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Assignment() {
            this.topicPartitions = new ArrayList<TopicPartitions>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topicPartitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<TopicPartitions> newCollection = new ArrayList<TopicPartitions>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicPartitions(_readable, _version));
            }
            this.topicPartitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUnsignedVarint(this.topicPartitions.size() + 1);
            for (TopicPartitions topicPartitionsElement : this.topicPartitions) {
                topicPartitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topicPartitions.size() + 1));
            for (TopicPartitions topicPartitionsElement : this.topicPartitions) {
                topicPartitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Assignment)) {
                return false;
            }
            Assignment other = (Assignment)obj;
            if (this.topicPartitions == null ? other.topicPartitions != null : !this.topicPartitions.equals(other.topicPartitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicPartitions == null ? 0 : this.topicPartitions.hashCode());
            return hashCode;
        }

        @Override
        public Assignment duplicate() {
            Assignment _duplicate = new Assignment();
            ArrayList<TopicPartitions> newTopicPartitions = new ArrayList<TopicPartitions>(this.topicPartitions.size());
            for (TopicPartitions _element : this.topicPartitions) {
                newTopicPartitions.add(_element.duplicate());
            }
            _duplicate.topicPartitions = newTopicPartitions;
            return _duplicate;
        }

        public String toString() {
            return "Assignment(topicPartitions=" + MessageUtil.deepToString(this.topicPartitions.iterator()) + ")";
        }

        public List<TopicPartitions> topicPartitions() {
            return this.topicPartitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Assignment setTopicPartitions(List<TopicPartitions> v) {
            this.topicPartitions = v;
            return this;
        }
    }

    public static class Member
    implements Message {
        String memberId;
        String rackId;
        int memberEpoch;
        String clientId;
        String clientHost;
        List<String> subscribedTopicNames;
        Assignment assignment;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(new Field("member_id", Type.COMPACT_STRING, "The member ID."), new Field("rack_id", Type.COMPACT_NULLABLE_STRING, "The member rack ID."), new Field("member_epoch", Type.INT32, "The current member epoch."), new Field("client_id", Type.COMPACT_STRING, "The client ID."), new Field("client_host", Type.COMPACT_STRING, "The client host."), new Field("subscribed_topic_names", new CompactArrayOf(Type.COMPACT_STRING), "The subscribed topic names."), new Field("assignment", Assignment.SCHEMA_1, "The current assignment."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public Member(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Member() {
            this.memberId = "";
            this.rackId = null;
            this.memberEpoch = 0;
            this.clientId = "";
            this.clientHost = "";
            this.subscribedTopicNames = new ArrayList<String>(0);
            this.assignment = new Assignment();
        }

        @Override
        public short lowestSupportedVersion() {
            return 1;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Member");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.rackId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field rackId had invalid length " + length);
                }
                this.rackId = _readable.readString(length);
            }
            this.memberEpoch = _readable.readInt();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientId had invalid length " + length);
            }
            this.clientId = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientHost was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field clientHost had invalid length " + length);
            }
            this.clientHost = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field subscribedTopicNames was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                int length2 = _readable.readUnsignedVarint() - 1;
                if (length2 < 0) {
                    throw new RuntimeException("non-nullable field subscribedTopicNames element was serialized as null");
                }
                if (length2 > Short.MAX_VALUE) {
                    throw new RuntimeException("string field subscribedTopicNames element had invalid length " + length2);
                }
                newCollection.add(_readable.readString(length2));
            }
            this.subscribedTopicNames = newCollection;
            this.assignment = new Assignment(_readable, _version);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.memberId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            if (this.rackId == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.rackId);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeInt(this.memberEpoch);
            _stringBytes = _cache.getSerializedValue(this.clientId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.clientHost);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.subscribedTopicNames.size() + 1);
            _stringBytes = this.subscribedTopicNames.iterator();
            while (_stringBytes.hasNext()) {
                String subscribedTopicNamesElement = (String)_stringBytes.next();
                byte[] _stringBytes2 = _cache.getSerializedValue(subscribedTopicNamesElement);
                _writable.writeUnsignedVarint(_stringBytes2.length + 1);
                _writable.writeByteArray(_stringBytes2);
            }
            this.assignment.write(_writable, _cache, _version);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Member");
            }
            byte[] _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.memberId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this.rackId == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.rackId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'rackId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.rackId, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(4);
            _stringBytes = this.clientId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clientId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.clientHost.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'clientHost' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clientHost, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.subscribedTopicNames.size() + 1));
            for (String subscribedTopicNamesElement : this.subscribedTopicNames) {
                byte[] _stringBytes2 = subscribedTopicNamesElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes2.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'subscribedTopicNamesElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(subscribedTopicNamesElement, _stringBytes2);
                _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
            }
            this.assignment.addSize(_size, _cache, _version);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Member)) {
                return false;
            }
            Member other = (Member)obj;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            if (this.rackId == null ? other.rackId != null : !this.rackId.equals(other.rackId)) {
                return false;
            }
            if (this.memberEpoch != other.memberEpoch) {
                return false;
            }
            if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
                return false;
            }
            if (this.clientHost == null ? other.clientHost != null : !this.clientHost.equals(other.clientHost)) {
                return false;
            }
            if (this.subscribedTopicNames == null ? other.subscribedTopicNames != null : !this.subscribedTopicNames.equals(other.subscribedTopicNames)) {
                return false;
            }
            if (this.assignment == null ? other.assignment != null : !this.assignment.equals(other.assignment)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + (this.rackId == null ? 0 : this.rackId.hashCode());
            hashCode = 31 * hashCode + this.memberEpoch;
            hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
            hashCode = 31 * hashCode + (this.clientHost == null ? 0 : this.clientHost.hashCode());
            hashCode = 31 * hashCode + (this.subscribedTopicNames == null ? 0 : this.subscribedTopicNames.hashCode());
            hashCode = 31 * hashCode + (this.assignment == null ? 0 : this.assignment.hashCode());
            return hashCode;
        }

        @Override
        public Member duplicate() {
            Member _duplicate = new Member();
            _duplicate.memberId = this.memberId;
            _duplicate.rackId = this.rackId == null ? null : this.rackId;
            _duplicate.memberEpoch = this.memberEpoch;
            _duplicate.clientId = this.clientId;
            _duplicate.clientHost = this.clientHost;
            ArrayList<String> newSubscribedTopicNames = new ArrayList<String>(this.subscribedTopicNames.size());
            for (String _element : this.subscribedTopicNames) {
                newSubscribedTopicNames.add(_element);
            }
            _duplicate.subscribedTopicNames = newSubscribedTopicNames;
            _duplicate.assignment = this.assignment.duplicate();
            return _duplicate;
        }

        public String toString() {
            return "Member(memberId=" + (String)(this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", rackId=" + (String)(this.rackId == null ? "null" : "'" + this.rackId.toString() + "'") + ", memberEpoch=" + this.memberEpoch + ", clientId=" + (String)(this.clientId == null ? "null" : "'" + this.clientId.toString() + "'") + ", clientHost=" + (String)(this.clientHost == null ? "null" : "'" + this.clientHost.toString() + "'") + ", subscribedTopicNames=" + MessageUtil.deepToString(this.subscribedTopicNames.iterator()) + ", assignment=" + this.assignment.toString() + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public String rackId() {
            return this.rackId;
        }

        public int memberEpoch() {
            return this.memberEpoch;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public List<String> subscribedTopicNames() {
            return this.subscribedTopicNames;
        }

        public Assignment assignment() {
            return this.assignment;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Member setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public Member setRackId(String v) {
            this.rackId = v;
            return this;
        }

        public Member setMemberEpoch(int v) {
            this.memberEpoch = v;
            return this;
        }

        public Member setClientId(String v) {
            this.clientId = v;
            return this;
        }

        public Member setClientHost(String v) {
            this.clientHost = v;
            return this;
        }

        public Member setSubscribedTopicNames(List<String> v) {
            this.subscribedTopicNames = v;
            return this;
        }

        public Member setAssignment(Assignment v) {
            this.assignment = v;
            return this;
        }
    }
}

