/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.util.Date;

public final class IssueScheduleInfo {
    private final Date date;
    private final int interval;

    public IssueScheduleInfo(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date must not be null");
        }
        this.date = date;
        this.interval = 1;
    }

    public IssueScheduleInfo(Date startDate, int interval) {
        if (interval < 1) {
            throw new IllegalArgumentException("interval must be >= 1");
        }
        if (startDate == null) {
            throw new IllegalArgumentException("startDate must not be null");
        }
        this.date = startDate;
        this.interval = interval;
    }

    public Date getDate() {
        return this.date;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IssueScheduleInfo) {
            IssueScheduleInfo other = (IssueScheduleInfo)obj;
            return this.date.equals(other.date) && this.interval == other.interval;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.date != null ? this.date.hashCode() : 0);
        hash = 67 * hash + this.interval;
        return hash;
    }
}

