/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.knockout.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.AttributeFilter;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.knockout.api.KODataBindTokenId;
import org.netbeans.modules.html.knockout.model.Binding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;

public class KOModel {
    private static final Map<HtmlParserResult, KOModel> INSTANCES = new WeakHashMap<HtmlParserResult, KOModel>();
    private Map<OpenTag, Collection<Attribute>> elements2attributes = new HashMap<OpenTag, Collection<Attribute>>();
    private Collection<Attribute> attributes = new ArrayList<Attribute>();

    @NonNull
    public static synchronized KOModel getModel(HtmlParserResult result) {
        KOModel model = INSTANCES.get(result);
        if (model == null) {
            model = new KOModel(result);
            INSTANCES.put(result, model);
        }
        return model;
    }

    private KOModel(HtmlParserResult result) {
        Iterator elementsIterator = result.getSyntaxAnalyzerResult().getElementsIterator();
        while (elementsIterator.hasNext()) {
            Element element = (Element)elementsIterator.next();
            switch (element.type()) {
                case OPEN_TAG: {
                    OpenTag ot = (OpenTag)element;
                    for (Attribute ngAttr : ot.attributes(new AttributeFilter(){

                        public boolean accepts(Attribute attribute) {
                            return KOModel.isKODataBindingAttribute(attribute) || KOModel.isKOParamsAttribute(attribute);
                        }
                    })) {
                        Collection<Attribute> attrs = this.elements2attributes.get(ot);
                        if (attrs == null) {
                            attrs = new ArrayList<Attribute>();
                            this.elements2attributes.put(ot, attrs);
                        }
                        attrs.add(ngAttr);
                        this.attributes.add(ngAttr);
                    }
                    break;
                }
            }
        }
    }

    public static boolean isKODataBindingAttribute(Attribute attribute) {
        return LexerUtils.equals((CharSequence)"data-bind", (CharSequence)attribute.unqualifiedName(), (boolean)true, (boolean)true);
    }

    public static boolean isKOParamsAttribute(Attribute attribute) {
        return LexerUtils.equals((CharSequence)"params", (CharSequence)attribute.unqualifiedName(), (boolean)true, (boolean)true);
    }

    private static boolean containsKODirective(Snapshot snapshot, Attribute attribute) {
        TokenHierarchy tokenHierarchy = snapshot.getTokenHierarchy();
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(HTMLTokenId.language());
        if (tokenSequence != null) {
            TokenSequence embedded;
            tokenSequence.move(attribute.valueOffset() + (attribute.isValueQuoted() ? 1 : 0));
            if (tokenSequence.moveNext() && (embedded = tokenSequence.embedded(KODataBindTokenId.language())) != null) {
                embedded.moveStart();
                while (embedded.moveNext()) {
                    switch ((KODataBindTokenId)embedded.token().id()) {
                        case KEY: {
                            String img = embedded.token().text().toString();
                            if (Binding.getBinding(img) == null) break;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    @NonNull
    public Collection<Attribute> getBindings() {
        return this.attributes;
    }

    public boolean containsKnockout() {
        return !this.getBindings().isEmpty();
    }
}

