/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ResourceBundle;

public class ConnectionProvider {
    final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle");
    private Connection con;
    private DatabaseMetaData dmd;
    private String driver;
    private String url;
    private String username;
    private String password;
    private String schema;

    public ConnectionProvider(Connection con, String driver) throws SQLException {
        this.con = con;
        this.driver = driver;
        this.dmd = con.getMetaData();
    }

    public ConnectionProvider(String driver, String url, String username, String password) throws ClassNotFoundException, SQLException {
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
        Class.forName(driver);
        this.con = DriverManager.getConnection(url, username, password);
        this.dmd = this.con.getMetaData();
    }

    public Connection getConnection() {
        return this.con;
    }

    public DatabaseMetaData getDatabaseMetaData() throws SQLException {
        return this.dmd;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void closeConnection() {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException exc) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    System.out.println(this.bundle.getString("UnableToCloseConnection"));
                }
                this.con = null;
            }
        }
    }
}

