/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.model.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.model.api.AtRule;
import org.netbeans.modules.css.model.api.AtRuleId;
import org.netbeans.modules.css.model.api.Body;
import org.netbeans.modules.css.model.api.BodyItem;
import org.netbeans.modules.css.model.api.CharSet;
import org.netbeans.modules.css.model.api.CharSetValue;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.ElementFactory;
import org.netbeans.modules.css.model.api.Expression;
import org.netbeans.modules.css.model.api.FontFace;
import org.netbeans.modules.css.model.api.GenericAtRule;
import org.netbeans.modules.css.model.api.ImportItem;
import org.netbeans.modules.css.model.api.Imports;
import org.netbeans.modules.css.model.api.Media;
import org.netbeans.modules.css.model.api.MediaBody;
import org.netbeans.modules.css.model.api.MediaExpression;
import org.netbeans.modules.css.model.api.MediaFeature;
import org.netbeans.modules.css.model.api.MediaFeatureValue;
import org.netbeans.modules.css.model.api.MediaQuery;
import org.netbeans.modules.css.model.api.MediaQueryList;
import org.netbeans.modules.css.model.api.MediaQueryOperator;
import org.netbeans.modules.css.model.api.MediaType;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.MozDocument;
import org.netbeans.modules.css.model.api.MozDocumentFunction;
import org.netbeans.modules.css.model.api.Namespace;
import org.netbeans.modules.css.model.api.NamespacePrefixName;
import org.netbeans.modules.css.model.api.Namespaces;
import org.netbeans.modules.css.model.api.Page;
import org.netbeans.modules.css.model.api.PlainElement;
import org.netbeans.modules.css.model.api.Prio;
import org.netbeans.modules.css.model.api.Property;
import org.netbeans.modules.css.model.api.PropertyDeclaration;
import org.netbeans.modules.css.model.api.PropertyValue;
import org.netbeans.modules.css.model.api.ResourceIdentifier;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.Selector;
import org.netbeans.modules.css.model.api.SelectorsGroup;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.model.api.VendorAtRule;
import org.netbeans.modules.css.model.api.WebkitKeyframeSelectors;
import org.netbeans.modules.css.model.api.WebkitKeyframes;
import org.netbeans.modules.css.model.api.WebkitKeyframesBlock;
import org.netbeans.modules.css.model.impl.AtRuleI;
import org.netbeans.modules.css.model.impl.AtRuleIdI;
import org.netbeans.modules.css.model.impl.BodyI;
import org.netbeans.modules.css.model.impl.BodyItemI;
import org.netbeans.modules.css.model.impl.CharSetI;
import org.netbeans.modules.css.model.impl.CharSetValueI;
import org.netbeans.modules.css.model.impl.DeclarationI;
import org.netbeans.modules.css.model.impl.DeclarationsI;
import org.netbeans.modules.css.model.impl.ExpressionI;
import org.netbeans.modules.css.model.impl.FontFaceI;
import org.netbeans.modules.css.model.impl.GenericAtRuleI;
import org.netbeans.modules.css.model.impl.ImportItemI;
import org.netbeans.modules.css.model.impl.ImportsI;
import org.netbeans.modules.css.model.impl.MediaBodyI;
import org.netbeans.modules.css.model.impl.MediaBodyItem;
import org.netbeans.modules.css.model.impl.MediaBodyItemI;
import org.netbeans.modules.css.model.impl.MediaConditionI;
import org.netbeans.modules.css.model.impl.MediaExpressionI;
import org.netbeans.modules.css.model.impl.MediaFeatureI;
import org.netbeans.modules.css.model.impl.MediaFeatureValueI;
import org.netbeans.modules.css.model.impl.MediaI;
import org.netbeans.modules.css.model.impl.MediaInParensI;
import org.netbeans.modules.css.model.impl.MediaQueryI;
import org.netbeans.modules.css.model.impl.MediaQueryListI;
import org.netbeans.modules.css.model.impl.MediaQueryOperatorI;
import org.netbeans.modules.css.model.impl.MediaTypeI;
import org.netbeans.modules.css.model.impl.MozDocumentFunctionI;
import org.netbeans.modules.css.model.impl.MozDocumentI;
import org.netbeans.modules.css.model.impl.NamespaceI;
import org.netbeans.modules.css.model.impl.NamespacePrefixNameI;
import org.netbeans.modules.css.model.impl.NamespacesI;
import org.netbeans.modules.css.model.impl.PageI;
import org.netbeans.modules.css.model.impl.PlainElementI;
import org.netbeans.modules.css.model.impl.PrioI;
import org.netbeans.modules.css.model.impl.PropertyDeclarationI;
import org.netbeans.modules.css.model.impl.PropertyI;
import org.netbeans.modules.css.model.impl.PropertyValueI;
import org.netbeans.modules.css.model.impl.ResourceIdentifierI;
import org.netbeans.modules.css.model.impl.RuleI;
import org.netbeans.modules.css.model.impl.SelectorI;
import org.netbeans.modules.css.model.impl.SelectorsGroupI;
import org.netbeans.modules.css.model.impl.StyleSheetI;
import org.netbeans.modules.css.model.impl.Utils;
import org.netbeans.modules.css.model.impl.VendorAtRuleI;
import org.netbeans.modules.css.model.impl.WebkitKeyframeSelectorsI;
import org.netbeans.modules.css.model.impl.WebkitKeyframesBlockI;
import org.netbeans.modules.css.model.impl.WebkitKeyframesI;
import org.netbeans.modules.css.model.impl.WsI;
import org.openide.util.Parameters;

public final class ElementFactoryImpl
implements ElementFactory {
    private final Model model;
    private static final Map<NodeType, Reference<Constructor<?>>> reflectiveImplementations = new ConcurrentHashMap();

    public ElementFactoryImpl(Model model) {
        this.model = model;
    }

    public Element createElement(Model model, Node node) {
        String className;
        NodeType type = node.type();
        switch (className = Utils.getInterfaceForNodeType(type.name())) {
            case "AtRuleId": {
                return new AtRuleIdI(model, node);
            }
            case "AtRule": {
                return new AtRuleI(model, node);
            }
            case "GenericAtRule": {
                return new GenericAtRuleI(model, node);
            }
            case "MozDocument": {
                return new MozDocumentI(model, node);
            }
            case "MozDocumentFunction": {
                return new MozDocumentFunctionI(model, node);
            }
            case "VendorAtRule": {
                return new VendorAtRuleI(model, node);
            }
            case "WebkitKeyframes": {
                return new WebkitKeyframesI(model, node);
            }
            case "WebkitKeyframeSelectors": {
                return new WebkitKeyframeSelectorsI(model, node);
            }
            case "WebkitKeyframesBlock": {
                return new WebkitKeyframesBlockI(model, node);
            }
            case "StyleSheet": {
                return new StyleSheetI(model, node);
            }
            case "CharSet": {
                return new CharSetI(model, node);
            }
            case "CharSetValue": {
                return new CharSetValueI(model, node);
            }
            case "FontFace": {
                return new FontFaceI(model, node);
            }
            case "Imports": {
                return new ImportsI(model, node);
            }
            case "ImportItem": {
                return new ImportItemI(model, node);
            }
            case "ResourceIdentifier": {
                return new ResourceIdentifierI(model, node);
            }
            case "Media": {
                return new MediaI(model, node);
            }
            case "MediaBody": {
                return new MediaBodyI(model, node);
            }
            case "MediaBodyItem": {
                return new MediaBodyItemI(model, node);
            }
            case "MediaQueryList": {
                return new MediaQueryListI(model, node);
            }
            case "MediaQuery": {
                return new MediaQueryI(model, node);
            }
            case "MediaQueryOperator": {
                return new MediaQueryOperatorI(model, node);
            }
            case "MediaConditionWithoutOr": 
            case "MediaCondition": {
                return new MediaConditionI(model, node);
            }
            case "MediaInParens": {
                return new MediaInParensI(model, node);
            }
            case "MediaExpression": {
                return new MediaExpressionI(model, node);
            }
            case "MediaFeature": {
                return new MediaFeatureI(model, node);
            }
            case "MediaFeatureValue": {
                return new MediaFeatureValueI(model, node);
            }
            case "MediaType": {
                return new MediaTypeI(model, node);
            }
            case "SupportsAtRule": {
                return new PlainElementI(model, node);
            }
            case "Namespaces": {
                return new NamespacesI(model, node);
            }
            case "Namespace": {
                return new NamespaceI(model, node);
            }
            case "NamespacePrefixName": {
                return new NamespacePrefixNameI(model, node);
            }
            case "Body": {
                return new BodyI(model, node);
            }
            case "BodyItem": {
                return new BodyItemI(model, node);
            }
            case "Rule": {
                return new RuleI(model, node);
            }
            case "SelectorsGroup": {
                return new SelectorsGroupI(model, node);
            }
            case "Selector": {
                return new SelectorI(model, node);
            }
            case "Declarations": {
                return new DeclarationsI(model, node);
            }
            case "PropertyDeclaration": {
                return new PropertyDeclarationI(model, node);
            }
            case "Declaration": {
                return new DeclarationI(model, node);
            }
            case "Property": {
                return new PropertyI(model, node);
            }
            case "PropertyValue": {
                return new PropertyValueI(model, node);
            }
            case "Expression": {
                return new ExpressionI(model, node);
            }
            case "Prio": {
                return new PrioI(model, node);
            }
            case "PlainElement": {
                return new PlainElementI(model, node);
            }
            case "Page": {
                return new PageI(model, node);
            }
            case "Ws": {
                return new WsI(model, node);
            }
            case "ComponentValueOuter": 
            case "Token": 
            case "Error": {
                return new PlainElementI(model, node);
            }
        }
        return this.createElementByReflection(model, node, className);
    }

    private Element createElementByReflection(Model model, Node node, String interfaceName) {
        Parameters.notNull((CharSequence)"model", (Object)model);
        Parameters.notNull((CharSequence)"node", (Object)node);
        try {
            Constructor<?> implConstructor;
            Reference<Constructor<?>> implConstructorRef = reflectiveImplementations.get(node.type());
            Constructor<?> constructor = implConstructor = implConstructorRef == null ? null : implConstructorRef.get();
            if (implConstructor != null) {
                return (Element)implConstructor.newInstance(model, node);
            }
            Logger.getLogger(ElementFactoryImpl.class.getName()).log(Level.FINE, "created element by reflection for {0}, update the ElementFactoryImpl.createElement() methods ugly switch!", interfaceName);
            Class<?> clazz = Class.forName(Utils.getImplementingClassNameForNodeType(node.type()));
            Constructor<?> constructor2 = clazz.getConstructor(Model.class, Node.class);
            reflectiveImplementations.put(node.type(), new WeakReference(constructor2));
            return (Element)constructor2.newInstance(model, node);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                reflectiveImplementations.put(node.type(), new WeakReference(PlainElementI.class.getConstructor(Model.class, Node.class)));
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(cnfe);
            }
            return new PlainElementI(model, node);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public StyleSheet createStyleSheet() {
        return new StyleSheetI(this.model);
    }

    @Override
    public CharSet createCharSet() {
        return new CharSetI(this.model);
    }

    @Override
    public CharSetValue createCharSetValue() {
        return new CharSetValueI(this.model);
    }

    @Override
    public FontFace createFontFace() {
        return new FontFaceI(this.model);
    }

    @Override
    public FontFace createFontFace(Declarations declarations) {
        FontFace fontFace = this.createFontFace();
        fontFace.setDeclarations(declarations);
        return fontFace;
    }

    @Override
    public Imports createImports() {
        return new ImportsI(this.model);
    }

    @Override
    public ImportItem createImportItem() {
        return new ImportItemI(this.model);
    }

    @Override
    public ResourceIdentifier createResourceIdentifier() {
        return new ResourceIdentifierI(this.model);
    }

    @Override
    public MediaQueryList createMediaQueryList() {
        return new MediaQueryListI(this.model);
    }

    @Override
    public MediaQuery createMediaQuery() {
        return new MediaQueryI(this.model);
    }

    @Override
    public Namespaces createNamespaces() {
        return new NamespacesI(this.model);
    }

    @Override
    public Namespace createNamespace() {
        return new NamespaceI(this.model);
    }

    @Override
    public NamespacePrefixName createNamespacePrefixName() {
        return new NamespacePrefixNameI(this.model);
    }

    @Override
    public Body createBody() {
        return new BodyI(this.model);
    }

    @Override
    public BodyItem createBodyItem() {
        return new BodyItemI(this.model);
    }

    @Override
    public Rule createRule() {
        return new RuleI(this.model);
    }

    @Override
    public Rule createRule(SelectorsGroup selectorsGroup, Declarations declarations) {
        Rule rule = this.createRule();
        rule.setSelectorsGroup(selectorsGroup);
        rule.setDeclarations(declarations);
        return rule;
    }

    @Override
    public SelectorsGroup createSelectorsGroup() {
        return new SelectorsGroupI(this.model);
    }

    @Override
    public SelectorsGroup createSelectorsGroup(Selector ... selectors) {
        SelectorsGroup sg = this.createSelectorsGroup();
        for (Selector s : selectors) {
            sg.addSelector(s);
        }
        return sg;
    }

    @Override
    public Selector createSelector() {
        return new SelectorI(this.model);
    }

    @Override
    public Selector createSelector(CharSequence code) {
        return new SelectorI(this.model, code);
    }

    @Override
    public Declarations createDeclarations() {
        return new DeclarationsI(this.model);
    }

    @Override
    public Declarations createDeclarations(PropertyDeclaration ... declarations) {
        Declarations ds = this.createDeclarations();
        for (PropertyDeclaration pd : declarations) {
            Declaration declaration = this.createDeclaration();
            declaration.setPropertyDeclaration(pd);
            ds.addDeclaration(declaration);
        }
        return ds;
    }

    @Override
    public Declaration createDeclaration() {
        return new DeclarationI(this.model);
    }

    @Override
    public PropertyDeclaration createPropertyDeclaration() {
        return new PropertyDeclarationI(this.model);
    }

    @Override
    public PropertyDeclaration createPropertyDeclaration(Property property, PropertyValue propertyValue, boolean isImportant) {
        PropertyDeclaration d = this.createPropertyDeclaration();
        d.setProperty(property);
        d.setPropertyValue(propertyValue);
        Prio prio = this.createPrio();
        prio.setContent(isImportant ? "!" : "");
        d.setPrio(prio);
        return d;
    }

    @Override
    public Property createProperty() {
        return new PropertyI(this.model);
    }

    @Override
    public Property createProperty(CharSequence propertyName) {
        Property p = this.createProperty();
        p.setContent(propertyName);
        return p;
    }

    @Override
    public PropertyValue createPropertyValue() {
        return new PropertyValueI(this.model);
    }

    @Override
    public PropertyValue createPropertyValue(Expression expression) {
        PropertyValue pv = this.createPropertyValue();
        pv.setExpression(expression);
        return pv;
    }

    @Override
    public Expression createExpression() {
        return new ExpressionI(this.model);
    }

    @Override
    public Expression createExpression(CharSequence expression) {
        Expression e = this.createExpression();
        e.setContent(expression);
        return e;
    }

    @Override
    public Prio createPrio() {
        return new PrioI(this.model);
    }

    @Override
    public PlainElement createPlainElement() {
        return new PlainElementI(this.model);
    }

    @Override
    public PlainElement createPlainElement(CharSequence text) {
        return new PlainElementI(this.model, text);
    }

    @Override
    public MediaQueryOperator createMediaQueryOperator() {
        return new MediaQueryOperatorI(this.model);
    }

    @Override
    public MediaExpression createMediaExpression() {
        return new MediaExpressionI(this.model);
    }

    @Override
    public MediaExpression createMediaExpression(MediaFeature mediaFeature, MediaFeatureValue mediaFeatureValue) {
        MediaExpression me = this.createMediaExpression();
        me.setMediaFeature(mediaFeature);
        me.setMediaFeatureValue(mediaFeatureValue);
        return me;
    }

    @Override
    public MediaFeature createMediaFeature() {
        return new MediaFeatureI(this.model);
    }

    @Override
    public MediaFeatureValue createMediaFeatureValue() {
        return new MediaFeatureValueI(this.model);
    }

    @Override
    public MediaType createMediaType() {
        return new MediaTypeI(this.model);
    }

    @Override
    public Media createMedia() {
        return new MediaI(this.model);
    }

    @Override
    public Page createPage() {
        return new PageI(this.model);
    }

    @Override
    public Page createPage(CharSequence source) {
        return new PageI(this.model, source);
    }

    @Override
    public MediaQueryOperator createMediaQueryOperator(CharSequence text) {
        return new MediaQueryOperatorI(this.model, text);
    }

    @Override
    public MediaFeature createMediaFeature(CharSequence text) {
        return new MediaFeatureI(this.model, text);
    }

    @Override
    public MediaType createMediaType(CharSequence text) {
        return new MediaTypeI(this.model, text);
    }

    @Override
    public MediaQuery createMediaQuery(MediaQueryOperator mediaQueryOperator, MediaType mediaType, MediaExpression ... mediaExpression) {
        MediaQuery mq = this.createMediaQuery();
        mq.setMediaQueryOperator(mediaQueryOperator);
        mq.setMediaType(mediaType);
        for (MediaExpression me : mediaExpression) {
            mq.addMediaExpression(me);
        }
        return mq;
    }

    @Override
    public MediaQueryList createMediaQueryList(MediaQuery ... mediaQuery) {
        MediaQueryList mql = this.createMediaQueryList();
        for (MediaQuery mq : mediaQuery) {
            mql.addMediaQuery(mq);
        }
        return mql;
    }

    @Override
    public Media createMedia(MediaQueryList mediaQueryList, MediaBody mediaBody) {
        Media media = this.createMedia();
        media.setMediaQueryList(mediaQueryList);
        media.setMediaBody(mediaBody);
        return media;
    }

    @Override
    public MediaBody createMediaBody() {
        return new MediaBodyI(this.model);
    }

    public MediaBodyItem createMediaBodyItem() {
        return new MediaBodyItemI(this.model);
    }

    @Override
    public MediaBody createMediaBody(Rule ... rules) {
        MediaBody mediaBody = this.createMediaBody();
        for (Rule r : rules) {
            mediaBody.addRule(r);
        }
        return mediaBody;
    }

    @Override
    public MediaBody createMediaBody(Page ... pages) {
        MediaBody mediaBody = this.createMediaBody();
        for (Page page : pages) {
            mediaBody.addPage(page);
        }
        return mediaBody;
    }

    @Override
    public VendorAtRule createVendorAtRule() {
        return new VendorAtRuleI(this.model);
    }

    @Override
    public AtRuleId createAtRuleId() {
        return new AtRuleIdI(this.model);
    }

    @Override
    public AtRuleId createAtRuleId(CharSequence text) {
        AtRuleId atRuleId = this.createAtRuleId();
        atRuleId.setContent(text);
        return atRuleId;
    }

    @Override
    public MozDocument createMozDocument() {
        return new MozDocumentI(this.model);
    }

    @Override
    public MozDocumentFunction createMozDocumentFunction() {
        return new MozDocumentFunctionI(this.model);
    }

    @Override
    public GenericAtRule createGenericAtRule() {
        return new GenericAtRuleI(this.model);
    }

    @Override
    public WebkitKeyframes createWebkitKeyFrames() {
        return new WebkitKeyframesI(this.model);
    }

    @Override
    public WebkitKeyframesBlock createWebkitKeyFramesBlock() {
        return new WebkitKeyframesBlockI(this.model);
    }

    @Override
    public WebkitKeyframeSelectors createWebkitKeyframeSelectors() {
        return new WebkitKeyframeSelectorsI(this.model);
    }

    @Override
    public AtRule createAtRule() {
        return new AtRuleI(this.model);
    }

    @Override
    public MediaFeatureValue createMediaFeatureValue(Expression expression) {
        MediaFeatureValue mediaFeatureValue = this.createMediaFeatureValue();
        mediaFeatureValue.setExpression(expression);
        return mediaFeatureValue;
    }
}

