/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.commit;

import java.awt.Dialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.ui.commit.Bundle;
import org.netbeans.modules.docker.ui.commit.CommitPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class CommitContainerAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(CommitContainerAction.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] activatedNodes) {
        DockerContainer container = (DockerContainer)activatedNodes[0].getLookup().lookup(DockerContainer.class);
        if (container != null) {
            JButton commitButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)commitButton, (String)Bundle.LBL_Commit());
            CommitPanel panel = new CommitPanel(container.getInstance(), commitButton);
            DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.LBL_CommitContainer(container.getShortId()), true, new Object[]{commitButton, DialogDescriptor.CANCEL_OPTION}, (Object)commitButton, 0, null, null);
            descriptor.setClosingOptions(new Object[]{commitButton, DialogDescriptor.CANCEL_OPTION});
            panel.setMessageLine(descriptor.createNotificationLineSupport());
            Dialog dlg = null;
            try {
                dlg = DialogDisplayer.getDefault().createDialog(descriptor);
                dlg.setVisible(true);
                if (descriptor.getValue() == commitButton) {
                    this.perform(container, panel.getRepository(), panel.getTag(), panel.getAuthor(), panel.getMessage(), panel.isPause());
                }
            }
            finally {
                if (dlg != null) {
                    dlg.dispose();
                }
            }
        }
    }

    private void perform(final DockerContainer container, final String repository, final String tag, final String author, final String message, final boolean pause) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.MSG_Commiting(container.getShortId()));
                handle.start();
                try {
                    DockerAction facade = new DockerAction(container.getInstance());
                    facade.commit(container, repository, tag, author, message, pause);
                }
                catch (DockerException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    String msg = ex.getLocalizedMessage();
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
                finally {
                    handle.finish();
                }
            }
        });
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0].getLookup().lookup(DockerContainer.class) != null;
    }

    public String getName() {
        return Bundle.LBL_CommitContainerAction();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

