/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.ui;

import java.awt.Dialog;
import java.awt.HeadlessException;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.lsp.server.LspServerUtils;
import org.netbeans.modules.java.lsp.server.protocol.UIContext;
import org.netbeans.modules.java.lsp.server.ui.NotifyDescriptorAdapter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public class AbstractDialogDisplayer
extends DialogDisplayer {
    private static final Logger LOG = Logger.getLogger(AbstractDialogDisplayer.class.getName());

    public AbstractDialogDisplayer() {
        LOG.log(Level.FINE, "Creating dialog displayer with lookup context: {0}", Lookup.getDefault());
    }

    public Object notify(NotifyDescriptor descriptor) {
        LspServerUtils.avoidClientMessageThread(Lookup.getDefault());
        UIContext ctx = UIContext.find();
        NotifyDescriptorAdapter adapter = new NotifyDescriptorAdapter(descriptor, ctx);
        return adapter.clientNotify();
    }

    public void notifyLater(NotifyDescriptor descriptor) {
        UIContext ctx = UIContext.find();
        NotifyDescriptorAdapter adapter = new NotifyDescriptorAdapter(descriptor, ctx);
        adapter.clientNotifyLater();
    }

    public <T extends NotifyDescriptor> CompletableFuture<T> notifyFuture(T descriptor) {
        UIContext ctx = UIContext.find();
        NotifyDescriptorAdapter adapter = new NotifyDescriptorAdapter(descriptor, ctx);
        return adapter.clientNotifyCompletion();
    }

    public Dialog createDialog(DialogDescriptor descriptor) {
        throw new HeadlessException();
    }
}

