/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.widgets.DateEditorWithSlider;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.Interval;

public class DateFilterPanel
extends JPanel {
    private final DateEditorWithSlider dateFrom = new DateEditorWithSlider(I18n.tr("From", new Object[0]));
    private final DateEditorWithSlider dateTo = new DateEditorWithSlider(I18n.tr("To", new Object[0]));
    private final JCheckBox noTimestampCb = new JCheckBox(I18n.tr("No timestamp", new Object[0]));
    private final transient GpxLayer layer;
    private transient ActionListener filterAppliedListener;
    private final String prefDate0;
    private final String prefDateMin;
    private final String prefDateMax;
    private final Timer t = new Timer(200, e -> this.applyFilter());

    public DateFilterPanel(GpxLayer layer, String preferencePrefix, boolean enabled) {
        super(new GridBagLayout());
        this.prefDate0 = preferencePrefix + ".showzerotimestamp";
        this.prefDateMin = preferencePrefix + ".mintime";
        this.prefDateMax = preferencePrefix + ".maxtime";
        this.layer = layer;
        Interval interval = layer.data.getMinMaxTimeForAllTracks().orElseGet(() -> new Interval(ZonedDateTime.of(2000, 1, 1, 0, 0, 0, 0, ZoneId.systemDefault()).toInstant(), Instant.now()));
        this.dateFrom.setDate(interval.getStart());
        this.dateTo.setDate(interval.getEnd());
        this.dateFrom.setRange(interval.getStart(), interval.getEnd());
        this.dateTo.setRange(interval.getStart(), interval.getEnd());
        this.add((Component)this.noTimestampCb, GBC.std().grid(1, 1).insets(0, 0, 5, 0));
        this.add((Component)this.dateFrom, GBC.std().grid(2, 1).fill(2));
        this.add((Component)this.dateTo, GBC.eol().grid(3, 1).fill(2));
        this.setEnabled(enabled);
        ChangeListener changeListener = e -> {
            if (this.isEnabled()) {
                this.applyFilterWithDelay();
            }
        };
        this.dateFrom.addDateListener(changeListener);
        this.dateTo.addDateListener(changeListener);
        this.noTimestampCb.addChangeListener(changeListener);
    }

    public void applyFilterWithDelay() {
        if (this.t.isRunning()) {
            this.t.restart();
        } else {
            this.t.start();
        }
    }

    public void applyFilter() {
        this.t.stop();
        this.filterTracksByDate();
        if (this.filterAppliedListener != null) {
            this.filterAppliedListener.actionPerformed(null);
        }
    }

    public void saveInPrefs() {
        Config.getPref().putLong(this.prefDateMin, this.dateFrom.getDate().toEpochMilli());
        Config.getPref().putLong(this.prefDateMax, this.dateTo.getDate().toEpochMilli());
        Config.getPref().putBoolean(this.prefDate0, this.noTimestampCb.isSelected());
    }

    public void loadFromPrefs() {
        long t2;
        long t1 = Config.getPref().getLong(this.prefDateMin, 0L);
        if (t1 != 0L) {
            this.dateFrom.setDate(Instant.ofEpochMilli(t1));
        }
        if ((t2 = Config.getPref().getLong(this.prefDateMax, 0L)) != 0L) {
            this.dateTo.setDate(Instant.ofEpochMilli(t2));
        }
        this.noTimestampCb.setSelected(Config.getPref().getBoolean(this.prefDate0, false));
    }

    public void setFilterAppliedListener(ActionListener filterAppliedListener) {
        this.filterAppliedListener = filterAppliedListener;
    }

    private void filterTracksByDate() {
        Instant from = this.dateFrom.getDate();
        Instant to = this.dateTo.getDate();
        this.layer.filterTracksByDate(from, to, this.noTimestampCb.isSelected());
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }
}

