/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import java.util.List;
import org.gradle.internal.logging.events.PromptOutputEvent;
import org.gradle.util.internal.TextUtil;

public class SelectOptionPromptEvent
extends PromptOutputEvent {
    private final String question;
    private final List<String> options;
    private final int defaultOption;

    public SelectOptionPromptEvent(long timestamp, String question, List<String> options, int defaultOption) {
        super(timestamp);
        this.question = question;
        this.options = options;
        this.defaultOption = defaultOption;
    }

    public String getQuestion() {
        return this.question;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public int getDefaultOption() {
        return this.defaultOption;
    }

    @Override
    public String getPrompt() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.question);
        builder.append(":");
        builder.append(TextUtil.getPlatformLineSeparator());
        for (int i = 0; i < this.options.size(); ++i) {
            builder.append("  ");
            builder.append(i + 1);
            builder.append(": ");
            builder.append(this.options.get(i));
            builder.append(TextUtil.getPlatformLineSeparator());
        }
        builder.append("Enter selection (default: ");
        builder.append(this.options.get(this.defaultOption));
        builder.append(") [1..");
        builder.append(this.options.size());
        builder.append("] ");
        return builder.toString();
    }

    public PromptOutputEvent.PromptResult<Integer> convert(String text) {
        int value;
        if (text.isEmpty()) {
            return PromptOutputEvent.PromptResult.response(this.defaultOption);
        }
        String trimmed = text.trim();
        if (trimmed.matches("\\d+") && (value = Integer.parseInt(trimmed)) > 0 && value <= this.options.size()) {
            return PromptOutputEvent.PromptResult.response(value - 1);
        }
        return PromptOutputEvent.PromptResult.newPrompt("Please enter a value between 1 and " + this.options.size() + ": ");
    }
}

