// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contentwarehouse/v1/histogram.proto

package contentwarehouse

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The result of the histogram query count('FilterableProperties') using
// HISTOGRAM_YAXIS_DOCUMENT will be:
// invoice_id: 2
// address: 1
// payment_method: 2
// line_item_description: 1
type HistogramQueryPropertyNameFilter_HistogramYAxis int32

const (
	// Count the documents per property name.
	HistogramQueryPropertyNameFilter_HISTOGRAM_YAXIS_DOCUMENT HistogramQueryPropertyNameFilter_HistogramYAxis = 0
	// Count the properties per property name.
	HistogramQueryPropertyNameFilter_HISTOGRAM_YAXIS_PROPERTY HistogramQueryPropertyNameFilter_HistogramYAxis = 1
)

// Enum value maps for HistogramQueryPropertyNameFilter_HistogramYAxis.
var (
	HistogramQueryPropertyNameFilter_HistogramYAxis_name = map[int32]string{
		0: "HISTOGRAM_YAXIS_DOCUMENT",
		1: "HISTOGRAM_YAXIS_PROPERTY",
	}
	HistogramQueryPropertyNameFilter_HistogramYAxis_value = map[string]int32{
		"HISTOGRAM_YAXIS_DOCUMENT": 0,
		"HISTOGRAM_YAXIS_PROPERTY": 1,
	}
)

func (x HistogramQueryPropertyNameFilter_HistogramYAxis) Enum() *HistogramQueryPropertyNameFilter_HistogramYAxis {
	p := new(HistogramQueryPropertyNameFilter_HistogramYAxis)
	*p = x
	return p
}

func (x HistogramQueryPropertyNameFilter_HistogramYAxis) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HistogramQueryPropertyNameFilter_HistogramYAxis) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contentwarehouse_v1_histogram_proto_enumTypes[0].Descriptor()
}

func (HistogramQueryPropertyNameFilter_HistogramYAxis) Type() protoreflect.EnumType {
	return &file_google_cloud_contentwarehouse_v1_histogram_proto_enumTypes[0]
}

func (x HistogramQueryPropertyNameFilter_HistogramYAxis) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HistogramQueryPropertyNameFilter_HistogramYAxis.Descriptor instead.
func (HistogramQueryPropertyNameFilter_HistogramYAxis) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_histogram_proto_rawDescGZIP(), []int{1, 0}
}

// The histogram request.
type HistogramQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An expression specifies a histogram request against matching documents for
	// searches.
	//
	// See [SearchDocumentsRequest.histogram_queries][google.cloud.contentwarehouse.v1.SearchDocumentsRequest.histogram_queries] for details about syntax.
	HistogramQuery string `protobuf:"bytes,1,opt,name=histogram_query,json=histogramQuery,proto3" json:"histogram_query,omitempty"`
	// Controls if the histogram query requires the return of a precise count.
	// Enable this flag may adversely impact performance.
	//
	// Defaults to true.
	RequirePreciseResultSize bool `protobuf:"varint,2,opt,name=require_precise_result_size,json=requirePreciseResultSize,proto3" json:"require_precise_result_size,omitempty"`
	// Optional. Filter the result of histogram query by the property names. It only works
	// with histogram query count('FilterableProperties').
	// It is an optional. It will perform histogram on all the property names for
	// all the document schemas. Setting this field will have a better
	// performance.
	Filters *HistogramQueryPropertyNameFilter `protobuf:"bytes,3,opt,name=filters,proto3" json:"filters,omitempty"`
}

func (x *HistogramQuery) Reset() {
	*x = HistogramQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_histogram_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HistogramQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HistogramQuery) ProtoMessage() {}

func (x *HistogramQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_histogram_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HistogramQuery.ProtoReflect.Descriptor instead.
func (*HistogramQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_histogram_proto_rawDescGZIP(), []int{0}
}

func (x *HistogramQuery) GetHistogramQuery() string {
	if x != nil {
		return x.HistogramQuery
	}
	return ""
}

func (x *HistogramQuery) GetRequirePreciseResultSize() bool {
	if x != nil {
		return x.RequirePreciseResultSize
	}
	return false
}

func (x *HistogramQuery) GetFilters() *HistogramQueryPropertyNameFilter {
	if x != nil {
		return x.Filters
	}
	return nil
}

type HistogramQueryPropertyNameFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This filter specifies the exact document schema(s)
	// [Document.document_schema_name][google.cloud.contentwarehouse.v1.Document.document_schema_name] to run histogram query against.
	// It is optional. It will perform histogram for property names for all the
	// document schemas if it is not set.
	//
	// At most 10 document schema names are allowed.
	// Format:
	// projects/{project_number}/locations/{location}/documentSchemas/{document_schema_id}.
	DocumentSchemas []string `protobuf:"bytes,1,rep,name=document_schemas,json=documentSchemas,proto3" json:"document_schemas,omitempty"`
	// It is optional. It will perform histogram for all the property names if it
	// is not set.
	// The properties need to be defined with the is_filterable flag set to
	// true and the name of the property should be in the format:
	// "schemaId.propertyName". The property needs to be defined in the schema.
	// Example: the schema id is abc. Then the name of property for property
	// MORTGAGE_TYPE will be "abc.MORTGAGE_TYPE".
	PropertyNames []string `protobuf:"bytes,2,rep,name=property_names,json=propertyNames,proto3" json:"property_names,omitempty"`
	// By default, the y_axis is HISTOGRAM_YAXIS_DOCUMENT if this field is not
	// set.
	YAxis HistogramQueryPropertyNameFilter_HistogramYAxis `protobuf:"varint,3,opt,name=y_axis,json=yAxis,proto3,enum=google.cloud.contentwarehouse.v1.HistogramQueryPropertyNameFilter_HistogramYAxis" json:"y_axis,omitempty"`
}

func (x *HistogramQueryPropertyNameFilter) Reset() {
	*x = HistogramQueryPropertyNameFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_histogram_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HistogramQueryPropertyNameFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HistogramQueryPropertyNameFilter) ProtoMessage() {}

func (x *HistogramQueryPropertyNameFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_histogram_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HistogramQueryPropertyNameFilter.ProtoReflect.Descriptor instead.
func (*HistogramQueryPropertyNameFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_histogram_proto_rawDescGZIP(), []int{1}
}

func (x *HistogramQueryPropertyNameFilter) GetDocumentSchemas() []string {
	if x != nil {
		return x.DocumentSchemas
	}
	return nil
}

func (x *HistogramQueryPropertyNameFilter) GetPropertyNames() []string {
	if x != nil {
		return x.PropertyNames
	}
	return nil
}

func (x *HistogramQueryPropertyNameFilter) GetYAxis() HistogramQueryPropertyNameFilter_HistogramYAxis {
	if x != nil {
		return x.YAxis
	}
	return HistogramQueryPropertyNameFilter_HISTOGRAM_YAXIS_DOCUMENT
}

// Histogram result that matches [HistogramQuery][google.cloud.contentwarehouse.v1.HistogramQuery] specified in searches.
type HistogramQueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Requested histogram expression.
	HistogramQuery string `protobuf:"bytes,1,opt,name=histogram_query,json=histogramQuery,proto3" json:"histogram_query,omitempty"`
	// A map from the values of the facet associated with distinct values to the
	// number of matching entries with corresponding value.
	//
	// The key format is:
	//
	// * (for string histogram) string values stored in the field.
	Histogram map[string]int64 `protobuf:"bytes,2,rep,name=histogram,proto3" json:"histogram,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *HistogramQueryResult) Reset() {
	*x = HistogramQueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_histogram_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HistogramQueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HistogramQueryResult) ProtoMessage() {}

func (x *HistogramQueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_histogram_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HistogramQueryResult.ProtoReflect.Descriptor instead.
func (*HistogramQueryResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_histogram_proto_rawDescGZIP(), []int{2}
}

func (x *HistogramQueryResult) GetHistogramQuery() string {
	if x != nil {
		return x.HistogramQuery
	}
	return ""
}

func (x *HistogramQueryResult) GetHistogram() map[string]int64 {
	if x != nil {
		return x.Histogram
	}
	return nil
}

var File_google_cloud_contentwarehouse_v1_histogram_proto protoreflect.FileDescriptor

var file_google_cloud_contentwarehouse_v1_histogram_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xdb, 0x01, 0x0a, 0x0e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x68, 0x69,
	0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x3d, 0x0a, 0x1b,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x18, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x61, 0x0a, 0x07, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x22, 0xe1,
	0x02, 0x0a, 0x20, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x5e, 0x0a, 0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x33, 0xfa,
	0x41, 0x30, 0x0a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x52, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x68, 0x0a, 0x06, 0x79, 0x5f,
	0x61, 0x78, 0x69, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x59, 0x41, 0x78, 0x69, 0x73, 0x52, 0x05, 0x79,
	0x41, 0x78, 0x69, 0x73, 0x22, 0x4c, 0x0a, 0x0e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x59, 0x41, 0x78, 0x69, 0x73, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x47,
	0x52, 0x41, 0x4d, 0x5f, 0x59, 0x41, 0x58, 0x49, 0x53, 0x5f, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45,
	0x4e, 0x54, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x47, 0x52, 0x41,
	0x4d, 0x5f, 0x59, 0x41, 0x58, 0x49, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x54, 0x59,
	0x10, 0x01, 0x22, 0xe2, 0x01, 0x0a, 0x14, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x68,
	0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x63, 0x0a, 0x09, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09,
	0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x1a, 0x3c, 0x0a, 0x0e, 0x48, 0x69, 0x73,
	0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x8a, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x42, 0x0e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contentwarehouse_v1_histogram_proto_rawDescOnce sync.Once
	file_google_cloud_contentwarehouse_v1_histogram_proto_rawDescData = file_google_cloud_contentwarehouse_v1_histogram_proto_rawDesc
)

func file_google_cloud_contentwarehouse_v1_histogram_proto_rawDescGZIP() []byte {
	file_google_cloud_contentwarehouse_v1_histogram_proto_rawDescOnce.Do(func() {
		file_google_cloud_contentwarehouse_v1_histogram_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contentwarehouse_v1_histogram_proto_rawDescData)
	})
	return file_google_cloud_contentwarehouse_v1_histogram_proto_rawDescData
}

var file_google_cloud_contentwarehouse_v1_histogram_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_contentwarehouse_v1_histogram_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_contentwarehouse_v1_histogram_proto_goTypes = []interface{}{
	(HistogramQueryPropertyNameFilter_HistogramYAxis)(0), // 0: google.cloud.contentwarehouse.v1.HistogramQueryPropertyNameFilter.HistogramYAxis
	(*HistogramQuery)(nil),                               // 1: google.cloud.contentwarehouse.v1.HistogramQuery
	(*HistogramQueryPropertyNameFilter)(nil),             // 2: google.cloud.contentwarehouse.v1.HistogramQueryPropertyNameFilter
	(*HistogramQueryResult)(nil),                         // 3: google.cloud.contentwarehouse.v1.HistogramQueryResult
	nil,                                                  // 4: google.cloud.contentwarehouse.v1.HistogramQueryResult.HistogramEntry
}
var file_google_cloud_contentwarehouse_v1_histogram_proto_depIdxs = []int32{
	2, // 0: google.cloud.contentwarehouse.v1.HistogramQuery.filters:type_name -> google.cloud.contentwarehouse.v1.HistogramQueryPropertyNameFilter
	0, // 1: google.cloud.contentwarehouse.v1.HistogramQueryPropertyNameFilter.y_axis:type_name -> google.cloud.contentwarehouse.v1.HistogramQueryPropertyNameFilter.HistogramYAxis
	4, // 2: google.cloud.contentwarehouse.v1.HistogramQueryResult.histogram:type_name -> google.cloud.contentwarehouse.v1.HistogramQueryResult.HistogramEntry
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_contentwarehouse_v1_histogram_proto_init() }
func file_google_cloud_contentwarehouse_v1_histogram_proto_init() {
	if File_google_cloud_contentwarehouse_v1_histogram_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contentwarehouse_v1_histogram_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HistogramQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_histogram_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HistogramQueryPropertyNameFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_histogram_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HistogramQueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contentwarehouse_v1_histogram_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_contentwarehouse_v1_histogram_proto_goTypes,
		DependencyIndexes: file_google_cloud_contentwarehouse_v1_histogram_proto_depIdxs,
		EnumInfos:         file_google_cloud_contentwarehouse_v1_histogram_proto_enumTypes,
		MessageInfos:      file_google_cloud_contentwarehouse_v1_histogram_proto_msgTypes,
	}.Build()
	File_google_cloud_contentwarehouse_v1_histogram_proto = out.File
	file_google_cloud_contentwarehouse_v1_histogram_proto_rawDesc = nil
	file_google_cloud_contentwarehouse_v1_histogram_proto_goTypes = nil
	file_google_cloud_contentwarehouse_v1_histogram_proto_depIdxs = nil
}
