// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package dlp aliases all exported identifiers in package
// "cloud.google.com/go/dlp/apiv2/dlppb".
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package dlp

import (
	src "cloud.google.com/go/dlp/apiv2/dlppb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/dlp/apiv2/dlppb
const (
	BigQueryOptions_RANDOM_START                                              = src.BigQueryOptions_RANDOM_START
	BigQueryOptions_SAMPLE_METHOD_UNSPECIFIED                                 = src.BigQueryOptions_SAMPLE_METHOD_UNSPECIFIED
	BigQueryOptions_TOP                                                       = src.BigQueryOptions_TOP
	ByteContentItem_AVRO                                                      = src.ByteContentItem_AVRO
	ByteContentItem_BYTES_TYPE_UNSPECIFIED                                    = src.ByteContentItem_BYTES_TYPE_UNSPECIFIED
	ByteContentItem_CSV                                                       = src.ByteContentItem_CSV
	ByteContentItem_EXCEL_DOCUMENT                                            = src.ByteContentItem_EXCEL_DOCUMENT
	ByteContentItem_IMAGE                                                     = src.ByteContentItem_IMAGE
	ByteContentItem_IMAGE_BMP                                                 = src.ByteContentItem_IMAGE_BMP
	ByteContentItem_IMAGE_JPEG                                                = src.ByteContentItem_IMAGE_JPEG
	ByteContentItem_IMAGE_PNG                                                 = src.ByteContentItem_IMAGE_PNG
	ByteContentItem_IMAGE_SVG                                                 = src.ByteContentItem_IMAGE_SVG
	ByteContentItem_PDF                                                       = src.ByteContentItem_PDF
	ByteContentItem_POWERPOINT_DOCUMENT                                       = src.ByteContentItem_POWERPOINT_DOCUMENT
	ByteContentItem_TEXT_UTF8                                                 = src.ByteContentItem_TEXT_UTF8
	ByteContentItem_TSV                                                       = src.ByteContentItem_TSV
	ByteContentItem_WORD_DOCUMENT                                             = src.ByteContentItem_WORD_DOCUMENT
	CharsToIgnore_ALPHA_LOWER_CASE                                            = src.CharsToIgnore_ALPHA_LOWER_CASE
	CharsToIgnore_ALPHA_UPPER_CASE                                            = src.CharsToIgnore_ALPHA_UPPER_CASE
	CharsToIgnore_COMMON_CHARS_TO_IGNORE_UNSPECIFIED                          = src.CharsToIgnore_COMMON_CHARS_TO_IGNORE_UNSPECIFIED
	CharsToIgnore_NUMERIC                                                     = src.CharsToIgnore_NUMERIC
	CharsToIgnore_PUNCTUATION                                                 = src.CharsToIgnore_PUNCTUATION
	CharsToIgnore_WHITESPACE                                                  = src.CharsToIgnore_WHITESPACE
	CloudStorageOptions_RANDOM_START                                          = src.CloudStorageOptions_RANDOM_START
	CloudStorageOptions_SAMPLE_METHOD_UNSPECIFIED                             = src.CloudStorageOptions_SAMPLE_METHOD_UNSPECIFIED
	CloudStorageOptions_TOP                                                   = src.CloudStorageOptions_TOP
	ContentOption_CONTENT_IMAGE                                               = src.ContentOption_CONTENT_IMAGE
	ContentOption_CONTENT_TEXT                                                = src.ContentOption_CONTENT_TEXT
	ContentOption_CONTENT_UNSPECIFIED                                         = src.ContentOption_CONTENT_UNSPECIFIED
	CryptoReplaceFfxFpeConfig_ALPHA_NUMERIC                                   = src.CryptoReplaceFfxFpeConfig_ALPHA_NUMERIC
	CryptoReplaceFfxFpeConfig_FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED          = src.CryptoReplaceFfxFpeConfig_FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED
	CryptoReplaceFfxFpeConfig_HEXADECIMAL                                     = src.CryptoReplaceFfxFpeConfig_HEXADECIMAL
	CryptoReplaceFfxFpeConfig_NUMERIC                                         = src.CryptoReplaceFfxFpeConfig_NUMERIC
	CryptoReplaceFfxFpeConfig_UPPER_CASE_ALPHA_NUMERIC                        = src.CryptoReplaceFfxFpeConfig_UPPER_CASE_ALPHA_NUMERIC
	CustomInfoType_EXCLUSION_TYPE_EXCLUDE                                     = src.CustomInfoType_EXCLUSION_TYPE_EXCLUDE
	CustomInfoType_EXCLUSION_TYPE_UNSPECIFIED                                 = src.CustomInfoType_EXCLUSION_TYPE_UNSPECIFIED
	DataProfileAction_CHANGED_PROFILE                                         = src.DataProfileAction_CHANGED_PROFILE
	DataProfileAction_ERROR_CHANGED                                           = src.DataProfileAction_ERROR_CHANGED
	DataProfileAction_EVENT_TYPE_UNSPECIFIED                                  = src.DataProfileAction_EVENT_TYPE_UNSPECIFIED
	DataProfileAction_NEW_PROFILE                                             = src.DataProfileAction_NEW_PROFILE
	DataProfileAction_PubSubNotification_DETAIL_LEVEL_UNSPECIFIED             = src.DataProfileAction_PubSubNotification_DETAIL_LEVEL_UNSPECIFIED
	DataProfileAction_PubSubNotification_RESOURCE_NAME                        = src.DataProfileAction_PubSubNotification_RESOURCE_NAME
	DataProfileAction_PubSubNotification_TABLE_PROFILE                        = src.DataProfileAction_PubSubNotification_TABLE_PROFILE
	DataProfileAction_SCORE_INCREASED                                         = src.DataProfileAction_SCORE_INCREASED
	DataProfilePubSubCondition_HIGH                                           = src.DataProfilePubSubCondition_HIGH
	DataProfilePubSubCondition_MEDIUM_OR_HIGH                                 = src.DataProfilePubSubCondition_MEDIUM_OR_HIGH
	DataProfilePubSubCondition_PROFILE_SCORE_BUCKET_UNSPECIFIED               = src.DataProfilePubSubCondition_PROFILE_SCORE_BUCKET_UNSPECIFIED
	DataProfilePubSubCondition_PubSubExpressions_AND                          = src.DataProfilePubSubCondition_PubSubExpressions_AND
	DataProfilePubSubCondition_PubSubExpressions_LOGICAL_OPERATOR_UNSPECIFIED = src.DataProfilePubSubCondition_PubSubExpressions_LOGICAL_OPERATOR_UNSPECIFIED
	DataProfilePubSubCondition_PubSubExpressions_OR                           = src.DataProfilePubSubCondition_PubSubExpressions_OR
	DataRiskLevel_RISK_HIGH                                                   = src.DataRiskLevel_RISK_HIGH
	DataRiskLevel_RISK_LOW                                                    = src.DataRiskLevel_RISK_LOW
	DataRiskLevel_RISK_MODERATE                                               = src.DataRiskLevel_RISK_MODERATE
	DataRiskLevel_RISK_SCORE_UNSPECIFIED                                      = src.DataRiskLevel_RISK_SCORE_UNSPECIFIED
	DlpJobType_DLP_JOB_TYPE_UNSPECIFIED                                       = src.DlpJobType_DLP_JOB_TYPE_UNSPECIFIED
	DlpJobType_INSPECT_JOB                                                    = src.DlpJobType_INSPECT_JOB
	DlpJobType_RISK_ANALYSIS_JOB                                              = src.DlpJobType_RISK_ANALYSIS_JOB
	DlpJob_ACTIVE                                                             = src.DlpJob_ACTIVE
	DlpJob_CANCELED                                                           = src.DlpJob_CANCELED
	DlpJob_DONE                                                               = src.DlpJob_DONE
	DlpJob_FAILED                                                             = src.DlpJob_FAILED
	DlpJob_JOB_STATE_UNSPECIFIED                                              = src.DlpJob_JOB_STATE_UNSPECIFIED
	DlpJob_PENDING                                                            = src.DlpJob_PENDING
	DlpJob_RUNNING                                                            = src.DlpJob_RUNNING
	EncryptionStatus_ENCRYPTION_CUSTOMER_MANAGED                              = src.EncryptionStatus_ENCRYPTION_CUSTOMER_MANAGED
	EncryptionStatus_ENCRYPTION_GOOGLE_MANAGED                                = src.EncryptionStatus_ENCRYPTION_GOOGLE_MANAGED
	EncryptionStatus_ENCRYPTION_STATUS_UNSPECIFIED                            = src.EncryptionStatus_ENCRYPTION_STATUS_UNSPECIFIED
	FileType_AVRO                                                             = src.FileType_AVRO
	FileType_BINARY_FILE                                                      = src.FileType_BINARY_FILE
	FileType_CSV                                                              = src.FileType_CSV
	FileType_EXCEL                                                            = src.FileType_EXCEL
	FileType_FILE_TYPE_UNSPECIFIED                                            = src.FileType_FILE_TYPE_UNSPECIFIED
	FileType_IMAGE                                                            = src.FileType_IMAGE
	FileType_PDF                                                              = src.FileType_PDF
	FileType_POWERPOINT                                                       = src.FileType_POWERPOINT
	FileType_TEXT_FILE                                                        = src.FileType_TEXT_FILE
	FileType_TSV                                                              = src.FileType_TSV
	FileType_WORD                                                             = src.FileType_WORD
	InfoTypeCategory_ARGENTINA                                                = src.InfoTypeCategory_ARGENTINA
	InfoTypeCategory_AUSTRALIA                                                = src.InfoTypeCategory_AUSTRALIA
	InfoTypeCategory_BELGIUM                                                  = src.InfoTypeCategory_BELGIUM
	InfoTypeCategory_BRAZIL                                                   = src.InfoTypeCategory_BRAZIL
	InfoTypeCategory_CANADA                                                   = src.InfoTypeCategory_CANADA
	InfoTypeCategory_CHILE                                                    = src.InfoTypeCategory_CHILE
	InfoTypeCategory_CHINA                                                    = src.InfoTypeCategory_CHINA
	InfoTypeCategory_COLOMBIA                                                 = src.InfoTypeCategory_COLOMBIA
	InfoTypeCategory_CONTEXTUAL_INFORMATION                                   = src.InfoTypeCategory_CONTEXTUAL_INFORMATION
	InfoTypeCategory_CREDENTIAL                                               = src.InfoTypeCategory_CREDENTIAL
	InfoTypeCategory_DEMOGRAPHIC                                              = src.InfoTypeCategory_DEMOGRAPHIC
	InfoTypeCategory_DENMARK                                                  = src.InfoTypeCategory_DENMARK
	InfoTypeCategory_DOCUMENT                                                 = src.InfoTypeCategory_DOCUMENT
	InfoTypeCategory_FINANCE                                                  = src.InfoTypeCategory_FINANCE
	InfoTypeCategory_FINLAND                                                  = src.InfoTypeCategory_FINLAND
	InfoTypeCategory_FRANCE                                                   = src.InfoTypeCategory_FRANCE
	InfoTypeCategory_GERMANY                                                  = src.InfoTypeCategory_GERMANY
	InfoTypeCategory_GLOBAL                                                   = src.InfoTypeCategory_GLOBAL
	InfoTypeCategory_GOVERNMENT_ID                                            = src.InfoTypeCategory_GOVERNMENT_ID
	InfoTypeCategory_HEALTH                                                   = src.InfoTypeCategory_HEALTH
	InfoTypeCategory_HONG_KONG                                                = src.InfoTypeCategory_HONG_KONG
	InfoTypeCategory_INDIA                                                    = src.InfoTypeCategory_INDIA
	InfoTypeCategory_INDONESIA                                                = src.InfoTypeCategory_INDONESIA
	InfoTypeCategory_INDUSTRY_UNSPECIFIED                                     = src.InfoTypeCategory_INDUSTRY_UNSPECIFIED
	InfoTypeCategory_INTERNAL                                                 = src.InfoTypeCategory_INTERNAL
	InfoTypeCategory_IRELAND                                                  = src.InfoTypeCategory_IRELAND
	InfoTypeCategory_ISRAEL                                                   = src.InfoTypeCategory_ISRAEL
	InfoTypeCategory_ITALY                                                    = src.InfoTypeCategory_ITALY
	InfoTypeCategory_JAPAN                                                    = src.InfoTypeCategory_JAPAN
	InfoTypeCategory_KOREA                                                    = src.InfoTypeCategory_KOREA
	InfoTypeCategory_LOCATION_UNSPECIFIED                                     = src.InfoTypeCategory_LOCATION_UNSPECIFIED
	InfoTypeCategory_MEXICO                                                   = src.InfoTypeCategory_MEXICO
	InfoTypeCategory_NORWAY                                                   = src.InfoTypeCategory_NORWAY
	InfoTypeCategory_PARAGUAY                                                 = src.InfoTypeCategory_PARAGUAY
	InfoTypeCategory_PERU                                                     = src.InfoTypeCategory_PERU
	InfoTypeCategory_PII                                                      = src.InfoTypeCategory_PII
	InfoTypeCategory_POLAND                                                   = src.InfoTypeCategory_POLAND
	InfoTypeCategory_PORTUGAL                                                 = src.InfoTypeCategory_PORTUGAL
	InfoTypeCategory_SINGAPORE                                                = src.InfoTypeCategory_SINGAPORE
	InfoTypeCategory_SOUTH_AFRICA                                             = src.InfoTypeCategory_SOUTH_AFRICA
	InfoTypeCategory_SPAIN                                                    = src.InfoTypeCategory_SPAIN
	InfoTypeCategory_SPII                                                     = src.InfoTypeCategory_SPII
	InfoTypeCategory_SWEDEN                                                   = src.InfoTypeCategory_SWEDEN
	InfoTypeCategory_TAIWAN                                                   = src.InfoTypeCategory_TAIWAN
	InfoTypeCategory_TELECOMMUNICATIONS                                       = src.InfoTypeCategory_TELECOMMUNICATIONS
	InfoTypeCategory_THAILAND                                                 = src.InfoTypeCategory_THAILAND
	InfoTypeCategory_THE_NETHERLANDS                                          = src.InfoTypeCategory_THE_NETHERLANDS
	InfoTypeCategory_TURKEY                                                   = src.InfoTypeCategory_TURKEY
	InfoTypeCategory_TYPE_UNSPECIFIED                                         = src.InfoTypeCategory_TYPE_UNSPECIFIED
	InfoTypeCategory_UNITED_KINGDOM                                           = src.InfoTypeCategory_UNITED_KINGDOM
	InfoTypeCategory_UNITED_STATES                                            = src.InfoTypeCategory_UNITED_STATES
	InfoTypeCategory_URUGUAY                                                  = src.InfoTypeCategory_URUGUAY
	InfoTypeCategory_VENEZUELA                                                = src.InfoTypeCategory_VENEZUELA
	InfoTypeSupportedBy_ENUM_TYPE_UNSPECIFIED                                 = src.InfoTypeSupportedBy_ENUM_TYPE_UNSPECIFIED
	InfoTypeSupportedBy_INSPECT                                               = src.InfoTypeSupportedBy_INSPECT
	InfoTypeSupportedBy_RISK_ANALYSIS                                         = src.InfoTypeSupportedBy_RISK_ANALYSIS
	JobTrigger_CANCELLED                                                      = src.JobTrigger_CANCELLED
	JobTrigger_HEALTHY                                                        = src.JobTrigger_HEALTHY
	JobTrigger_PAUSED                                                         = src.JobTrigger_PAUSED
	JobTrigger_STATUS_UNSPECIFIED                                             = src.JobTrigger_STATUS_UNSPECIFIED
	Likelihood_LIKELIHOOD_UNSPECIFIED                                         = src.Likelihood_LIKELIHOOD_UNSPECIFIED
	Likelihood_LIKELY                                                         = src.Likelihood_LIKELY
	Likelihood_POSSIBLE                                                       = src.Likelihood_POSSIBLE
	Likelihood_UNLIKELY                                                       = src.Likelihood_UNLIKELY
	Likelihood_VERY_LIKELY                                                    = src.Likelihood_VERY_LIKELY
	Likelihood_VERY_UNLIKELY                                                  = src.Likelihood_VERY_UNLIKELY
	MatchingType_MATCHING_TYPE_FULL_MATCH                                     = src.MatchingType_MATCHING_TYPE_FULL_MATCH
	MatchingType_MATCHING_TYPE_INVERSE_MATCH                                  = src.MatchingType_MATCHING_TYPE_INVERSE_MATCH
	MatchingType_MATCHING_TYPE_PARTIAL_MATCH                                  = src.MatchingType_MATCHING_TYPE_PARTIAL_MATCH
	MatchingType_MATCHING_TYPE_UNSPECIFIED                                    = src.MatchingType_MATCHING_TYPE_UNSPECIFIED
	MetadataType_METADATATYPE_UNSPECIFIED                                     = src.MetadataType_METADATATYPE_UNSPECIFIED
	MetadataType_STORAGE_METADATA                                             = src.MetadataType_STORAGE_METADATA
	OutputStorageConfig_ALL_COLUMNS                                           = src.OutputStorageConfig_ALL_COLUMNS
	OutputStorageConfig_BASIC_COLUMNS                                         = src.OutputStorageConfig_BASIC_COLUMNS
	OutputStorageConfig_BIG_QUERY_COLUMNS                                     = src.OutputStorageConfig_BIG_QUERY_COLUMNS
	OutputStorageConfig_DATASTORE_COLUMNS                                     = src.OutputStorageConfig_DATASTORE_COLUMNS
	OutputStorageConfig_GCS_COLUMNS                                           = src.OutputStorageConfig_GCS_COLUMNS
	OutputStorageConfig_OUTPUT_SCHEMA_UNSPECIFIED                             = src.OutputStorageConfig_OUTPUT_SCHEMA_UNSPECIFIED
	RecordCondition_Expressions_AND                                           = src.RecordCondition_Expressions_AND
	RecordCondition_Expressions_LOGICAL_OPERATOR_UNSPECIFIED                  = src.RecordCondition_Expressions_LOGICAL_OPERATOR_UNSPECIFIED
	RelationalOperator_EQUAL_TO                                               = src.RelationalOperator_EQUAL_TO
	RelationalOperator_EXISTS                                                 = src.RelationalOperator_EXISTS
	RelationalOperator_GREATER_THAN                                           = src.RelationalOperator_GREATER_THAN
	RelationalOperator_GREATER_THAN_OR_EQUALS                                 = src.RelationalOperator_GREATER_THAN_OR_EQUALS
	RelationalOperator_LESS_THAN                                              = src.RelationalOperator_LESS_THAN
	RelationalOperator_LESS_THAN_OR_EQUALS                                    = src.RelationalOperator_LESS_THAN_OR_EQUALS
	RelationalOperator_NOT_EQUAL_TO                                           = src.RelationalOperator_NOT_EQUAL_TO
	RelationalOperator_RELATIONAL_OPERATOR_UNSPECIFIED                        = src.RelationalOperator_RELATIONAL_OPERATOR_UNSPECIFIED
	ResourceVisibility_RESOURCE_VISIBILITY_PUBLIC                             = src.ResourceVisibility_RESOURCE_VISIBILITY_PUBLIC
	ResourceVisibility_RESOURCE_VISIBILITY_RESTRICTED                         = src.ResourceVisibility_RESOURCE_VISIBILITY_RESTRICTED
	ResourceVisibility_RESOURCE_VISIBILITY_UNSPECIFIED                        = src.ResourceVisibility_RESOURCE_VISIBILITY_UNSPECIFIED
	SensitivityScore_SENSITIVITY_HIGH                                         = src.SensitivityScore_SENSITIVITY_HIGH
	SensitivityScore_SENSITIVITY_LOW                                          = src.SensitivityScore_SENSITIVITY_LOW
	SensitivityScore_SENSITIVITY_MODERATE                                     = src.SensitivityScore_SENSITIVITY_MODERATE
	SensitivityScore_SENSITIVITY_SCORE_UNSPECIFIED                            = src.SensitivityScore_SENSITIVITY_SCORE_UNSPECIFIED
	StoredInfoTypeState_FAILED                                                = src.StoredInfoTypeState_FAILED
	StoredInfoTypeState_INVALID                                               = src.StoredInfoTypeState_INVALID
	StoredInfoTypeState_PENDING                                               = src.StoredInfoTypeState_PENDING
	StoredInfoTypeState_READY                                                 = src.StoredInfoTypeState_READY
	StoredInfoTypeState_STORED_INFO_TYPE_STATE_UNSPECIFIED                    = src.StoredInfoTypeState_STORED_INFO_TYPE_STATE_UNSPECIFIED
	TableDataProfile_DONE                                                     = src.TableDataProfile_DONE
	TableDataProfile_RUNNING                                                  = src.TableDataProfile_RUNNING
	TableDataProfile_STATE_UNSPECIFIED                                        = src.TableDataProfile_STATE_UNSPECIFIED
	TimePartConfig_DAY_OF_MONTH                                               = src.TimePartConfig_DAY_OF_MONTH
	TimePartConfig_DAY_OF_WEEK                                                = src.TimePartConfig_DAY_OF_WEEK
	TimePartConfig_HOUR_OF_DAY                                                = src.TimePartConfig_HOUR_OF_DAY
	TimePartConfig_MONTH                                                      = src.TimePartConfig_MONTH
	TimePartConfig_TIME_PART_UNSPECIFIED                                      = src.TimePartConfig_TIME_PART_UNSPECIFIED
	TimePartConfig_WEEK_OF_YEAR                                               = src.TimePartConfig_WEEK_OF_YEAR
	TimePartConfig_YEAR                                                       = src.TimePartConfig_YEAR
	TransformationContainerType_TRANSFORM_BODY                                = src.TransformationContainerType_TRANSFORM_BODY
	TransformationContainerType_TRANSFORM_METADATA                            = src.TransformationContainerType_TRANSFORM_METADATA
	TransformationContainerType_TRANSFORM_TABLE                               = src.TransformationContainerType_TRANSFORM_TABLE
	TransformationContainerType_TRANSFORM_UNKNOWN_CONTAINER                   = src.TransformationContainerType_TRANSFORM_UNKNOWN_CONTAINER
	TransformationResultStatusType_BIGQUERY_MAX_ROW_SIZE_EXCEEDED             = src.TransformationResultStatusType_BIGQUERY_MAX_ROW_SIZE_EXCEEDED
	TransformationResultStatusType_INVALID_TRANSFORM                          = src.TransformationResultStatusType_INVALID_TRANSFORM
	TransformationResultStatusType_METADATA_UNRETRIEVABLE                     = src.TransformationResultStatusType_METADATA_UNRETRIEVABLE
	TransformationResultStatusType_STATE_TYPE_UNSPECIFIED                     = src.TransformationResultStatusType_STATE_TYPE_UNSPECIFIED
	TransformationResultStatusType_SUCCESS                                    = src.TransformationResultStatusType_SUCCESS
	TransformationSummary_ERROR                                               = src.TransformationSummary_ERROR
	TransformationSummary_SUCCESS                                             = src.TransformationSummary_SUCCESS
	TransformationSummary_TRANSFORMATION_RESULT_CODE_UNSPECIFIED              = src.TransformationSummary_TRANSFORMATION_RESULT_CODE_UNSPECIFIED
	TransformationType_BUCKETING                                              = src.TransformationType_BUCKETING
	TransformationType_CHARACTER_MASK                                         = src.TransformationType_CHARACTER_MASK
	TransformationType_CRYPTO_DETERMINISTIC_CONFIG                            = src.TransformationType_CRYPTO_DETERMINISTIC_CONFIG
	TransformationType_CRYPTO_HASH                                            = src.TransformationType_CRYPTO_HASH
	TransformationType_CRYPTO_REPLACE_FFX_FPE                                 = src.TransformationType_CRYPTO_REPLACE_FFX_FPE
	TransformationType_DATE_SHIFT                                             = src.TransformationType_DATE_SHIFT
	TransformationType_FIXED_SIZE_BUCKETING                                   = src.TransformationType_FIXED_SIZE_BUCKETING
	TransformationType_RECORD_SUPPRESSION                                     = src.TransformationType_RECORD_SUPPRESSION
	TransformationType_REDACT                                                 = src.TransformationType_REDACT
	TransformationType_REDACT_IMAGE                                           = src.TransformationType_REDACT_IMAGE
	TransformationType_REPLACE_DICTIONARY                                     = src.TransformationType_REPLACE_DICTIONARY
	TransformationType_REPLACE_VALUE                                          = src.TransformationType_REPLACE_VALUE
	TransformationType_REPLACE_WITH_INFO_TYPE                                 = src.TransformationType_REPLACE_WITH_INFO_TYPE
	TransformationType_TIME_PART                                              = src.TransformationType_TIME_PART
	TransformationType_TRANSFORMATION_TYPE_UNSPECIFIED                        = src.TransformationType_TRANSFORMATION_TYPE_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/dlp/apiv2/dlppb
var (
	BigQueryOptions_SampleMethod_name                                        = src.BigQueryOptions_SampleMethod_name
	BigQueryOptions_SampleMethod_value                                       = src.BigQueryOptions_SampleMethod_value
	ByteContentItem_BytesType_name                                           = src.ByteContentItem_BytesType_name
	ByteContentItem_BytesType_value                                          = src.ByteContentItem_BytesType_value
	CharsToIgnore_CommonCharsToIgnore_name                                   = src.CharsToIgnore_CommonCharsToIgnore_name
	CharsToIgnore_CommonCharsToIgnore_value                                  = src.CharsToIgnore_CommonCharsToIgnore_value
	CloudStorageOptions_SampleMethod_name                                    = src.CloudStorageOptions_SampleMethod_name
	CloudStorageOptions_SampleMethod_value                                   = src.CloudStorageOptions_SampleMethod_value
	ContentOption_name                                                       = src.ContentOption_name
	ContentOption_value                                                      = src.ContentOption_value
	CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_name                   = src.CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_name
	CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_value                  = src.CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet_value
	CustomInfoType_ExclusionType_name                                        = src.CustomInfoType_ExclusionType_name
	CustomInfoType_ExclusionType_value                                       = src.CustomInfoType_ExclusionType_value
	DataProfileAction_EventType_name                                         = src.DataProfileAction_EventType_name
	DataProfileAction_EventType_value                                        = src.DataProfileAction_EventType_value
	DataProfileAction_PubSubNotification_DetailLevel_name                    = src.DataProfileAction_PubSubNotification_DetailLevel_name
	DataProfileAction_PubSubNotification_DetailLevel_value                   = src.DataProfileAction_PubSubNotification_DetailLevel_value
	DataProfilePubSubCondition_ProfileScoreBucket_name                       = src.DataProfilePubSubCondition_ProfileScoreBucket_name
	DataProfilePubSubCondition_ProfileScoreBucket_value                      = src.DataProfilePubSubCondition_ProfileScoreBucket_value
	DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator_name  = src.DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator_name
	DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator_value = src.DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator_value
	DataRiskLevel_DataRiskLevelScore_name                                    = src.DataRiskLevel_DataRiskLevelScore_name
	DataRiskLevel_DataRiskLevelScore_value                                   = src.DataRiskLevel_DataRiskLevelScore_value
	DlpJobType_name                                                          = src.DlpJobType_name
	DlpJobType_value                                                         = src.DlpJobType_value
	DlpJob_JobState_name                                                     = src.DlpJob_JobState_name
	DlpJob_JobState_value                                                    = src.DlpJob_JobState_value
	EncryptionStatus_name                                                    = src.EncryptionStatus_name
	EncryptionStatus_value                                                   = src.EncryptionStatus_value
	FileType_name                                                            = src.FileType_name
	FileType_value                                                           = src.FileType_value
	File_google_privacy_dlp_v2_dlp_proto                                     = src.File_google_privacy_dlp_v2_dlp_proto
	File_google_privacy_dlp_v2_storage_proto                                 = src.File_google_privacy_dlp_v2_storage_proto
	InfoTypeCategory_IndustryCategory_name                                   = src.InfoTypeCategory_IndustryCategory_name
	InfoTypeCategory_IndustryCategory_value                                  = src.InfoTypeCategory_IndustryCategory_value
	InfoTypeCategory_LocationCategory_name                                   = src.InfoTypeCategory_LocationCategory_name
	InfoTypeCategory_LocationCategory_value                                  = src.InfoTypeCategory_LocationCategory_value
	InfoTypeCategory_TypeCategory_name                                       = src.InfoTypeCategory_TypeCategory_name
	InfoTypeCategory_TypeCategory_value                                      = src.InfoTypeCategory_TypeCategory_value
	InfoTypeSupportedBy_name                                                 = src.InfoTypeSupportedBy_name
	InfoTypeSupportedBy_value                                                = src.InfoTypeSupportedBy_value
	JobTrigger_Status_name                                                   = src.JobTrigger_Status_name
	JobTrigger_Status_value                                                  = src.JobTrigger_Status_value
	Likelihood_name                                                          = src.Likelihood_name
	Likelihood_value                                                         = src.Likelihood_value
	MatchingType_name                                                        = src.MatchingType_name
	MatchingType_value                                                       = src.MatchingType_value
	MetadataType_name                                                        = src.MetadataType_name
	MetadataType_value                                                       = src.MetadataType_value
	OutputStorageConfig_OutputSchema_name                                    = src.OutputStorageConfig_OutputSchema_name
	OutputStorageConfig_OutputSchema_value                                   = src.OutputStorageConfig_OutputSchema_value
	RecordCondition_Expressions_LogicalOperator_name                         = src.RecordCondition_Expressions_LogicalOperator_name
	RecordCondition_Expressions_LogicalOperator_value                        = src.RecordCondition_Expressions_LogicalOperator_value
	RelationalOperator_name                                                  = src.RelationalOperator_name
	RelationalOperator_value                                                 = src.RelationalOperator_value
	ResourceVisibility_name                                                  = src.ResourceVisibility_name
	ResourceVisibility_value                                                 = src.ResourceVisibility_value
	SensitivityScore_SensitivityScoreLevel_name                              = src.SensitivityScore_SensitivityScoreLevel_name
	SensitivityScore_SensitivityScoreLevel_value                             = src.SensitivityScore_SensitivityScoreLevel_value
	StoredInfoTypeState_name                                                 = src.StoredInfoTypeState_name
	StoredInfoTypeState_value                                                = src.StoredInfoTypeState_value
	TableDataProfile_State_name                                              = src.TableDataProfile_State_name
	TableDataProfile_State_value                                             = src.TableDataProfile_State_value
	TimePartConfig_TimePart_name                                             = src.TimePartConfig_TimePart_name
	TimePartConfig_TimePart_value                                            = src.TimePartConfig_TimePart_value
	TransformationContainerType_name                                         = src.TransformationContainerType_name
	TransformationContainerType_value                                        = src.TransformationContainerType_value
	TransformationResultStatusType_name                                      = src.TransformationResultStatusType_name
	TransformationResultStatusType_value                                     = src.TransformationResultStatusType_value
	TransformationSummary_TransformationResultCode_name                      = src.TransformationSummary_TransformationResultCode_name
	TransformationSummary_TransformationResultCode_value                     = src.TransformationSummary_TransformationResultCode_value
	TransformationType_name                                                  = src.TransformationType_name
	TransformationType_value                                                 = src.TransformationType_value
)

// A task to execute on the completion of a job. See
// https://cloud.google.com/dlp/docs/concepts-actions to learn more.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Action = src.Action

// Create a de-identified copy of the requested table or files. A
// TransformationDetail will be created for each transformation. If any rows in
// BigQuery are skipped during de-identification (transformation errors or row
// size exceeds BigQuery insert API limits) they are placed in the failure
// output table. If the original row exceeds the BigQuery insert API limit it
// will be truncated when written to the failure output table. The failure
// output table can be set in the
// action.deidentify.output.big_query_output.deidentified_failure_output_table
// field, if no table is set, a table will be automatically created in the same
// project and dataset as the original table. Compatible with: Inspect
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Action_Deidentify = src.Action_Deidentify
type Action_Deidentify_ = src.Action_Deidentify_
type Action_Deidentify_CloudStorageOutput = src.Action_Deidentify_CloudStorageOutput

// Sends an email when the job completes. The email goes to IAM project owners
// and technical [Essential
// Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Action_JobNotificationEmails = src.Action_JobNotificationEmails
type Action_JobNotificationEmails_ = src.Action_JobNotificationEmails_
type Action_PubSub = src.Action_PubSub

// Publish findings of a DlpJob to Data Catalog. In Data Catalog, tag
// templates are applied to the resource that Cloud DLP scanned. Data Catalog
// tag templates are stored in the same project and region where the BigQuery
// table exists. For Cloud DLP to create and apply the tag template, the Cloud
// DLP service agent must have the `roles/datacatalog.tagTemplateOwner`
// permission on the project. The tag template contains fields summarizing the
// results of the DlpJob. Any field values previously written by another DlpJob
// are deleted. [InfoType naming patterns][google.privacy.dlp.v2.InfoType] are
// strictly enforced when using this feature. Findings are persisted in Data
// Catalog storage and are governed by service-specific policies for Data
// Catalog. For more information, see [Service Specific
// Terms](https://cloud.google.com/terms/service-terms). Only a single instance
// of this action can be specified. This action is allowed only if all
// resources being scanned are BigQuery tables. Compatible with: Inspect
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Action_PublishFindingsToCloudDataCatalog = src.Action_PublishFindingsToCloudDataCatalog
type Action_PublishFindingsToCloudDataCatalog_ = src.Action_PublishFindingsToCloudDataCatalog_

// Publish the result summary of a DlpJob to the Cloud Security Command Center
// (CSCC Alpha). This action is only available for projects which are parts of
// an organization and whitelisted for the alpha Cloud Security Command Center.
// The action will publish the count of finding instances and their info types.
// The summary of findings will be persisted in CSCC and are governed by CSCC
// service-specific policy, see https://cloud.google.com/terms/service-terms
// Only a single instance of this action can be specified. Compatible with:
// Inspect
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Action_PublishSummaryToCscc = src.Action_PublishSummaryToCscc
type Action_PublishSummaryToCscc_ = src.Action_PublishSummaryToCscc_

// Publish a message into a given Pub/Sub topic when DlpJob has completed. The
// message contains a single field, `DlpJobName`, which is equal to the
// finished job's
// [`DlpJob.name`](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.dlpJobs#DlpJob).
// Compatible with: Inspect, Risk
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Action_PublishToPubSub = src.Action_PublishToPubSub

// Enable Stackdriver metric dlp.googleapis.com/finding_count. This will
// publish a metric to stack driver on each infotype requested and how many
// findings were found for it. CustomDetectors will be bucketed as 'Custom'
// under the Stackdriver label 'info_type'.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Action_PublishToStackdriver = src.Action_PublishToStackdriver
type Action_PublishToStackdriver_ = src.Action_PublishToStackdriver_

// If set, the detailed findings will be persisted to the specified
// OutputStorageConfig. Only a single instance of this action can be specified.
// Compatible with: Inspect, Risk
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Action_SaveFindings = src.Action_SaveFindings
type Action_SaveFindings_ = src.Action_SaveFindings_

// Request message for ActivateJobTrigger.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ActivateJobTriggerRequest = src.ActivateJobTriggerRequest

// Result of a risk analysis operation request.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails = src.AnalyzeDataSourceRiskDetails

// Result of the categorical stats computation.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_CategoricalStatsResult = src.AnalyzeDataSourceRiskDetails_CategoricalStatsResult
type AnalyzeDataSourceRiskDetails_CategoricalStatsResult_ = src.AnalyzeDataSourceRiskDetails_CategoricalStatsResult_

// Histogram of value frequencies in the column.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket = src.AnalyzeDataSourceRiskDetails_CategoricalStatsResult_CategoricalStatsHistogramBucket

// Result of the δ-presence computation. Note that these results are an
// estimation, not exact values.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult = src.AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult
type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_ = src.AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_

// A DeltaPresenceEstimationHistogramBucket message with the following values:
// min_probability: 0.1 max_probability: 0.2 frequency: 42 means that there are
// 42 records for which δ is in [0.1, 0.2). An important particular case is
// when min_probability = max_probability = 1: then, every individual who
// shares this quasi-identifier combination is in the dataset.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket = src.AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationHistogramBucket

// A tuple of values for the quasi-identifier columns.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues = src.AnalyzeDataSourceRiskDetails_DeltaPresenceEstimationResult_DeltaPresenceEstimationQuasiIdValues

// Result of the k-anonymity computation.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_KAnonymityResult = src.AnalyzeDataSourceRiskDetails_KAnonymityResult
type AnalyzeDataSourceRiskDetails_KAnonymityResult_ = src.AnalyzeDataSourceRiskDetails_KAnonymityResult_

// The set of columns' values that share the same ldiversity value
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass = src.AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityEquivalenceClass

// Histogram of k-anonymity equivalence classes.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket = src.AnalyzeDataSourceRiskDetails_KAnonymityResult_KAnonymityHistogramBucket

// Result of the reidentifiability analysis. Note that these results are an
// estimation, not exact values.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_KMapEstimationResult = src.AnalyzeDataSourceRiskDetails_KMapEstimationResult
type AnalyzeDataSourceRiskDetails_KMapEstimationResult_ = src.AnalyzeDataSourceRiskDetails_KMapEstimationResult_

// A KMapEstimationHistogramBucket message with the following values:
// min_anonymity: 3 max_anonymity: 5 frequency: 42 means that there are 42
// records whose quasi-identifier values correspond to 3, 4 or 5 people in the
// overlying population. An important particular case is when min_anonymity =
// max_anonymity = 1: the frequency field then corresponds to the number of
// uniquely identifiable records.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket = src.AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationHistogramBucket

// A tuple of values for the quasi-identifier columns.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues = src.AnalyzeDataSourceRiskDetails_KMapEstimationResult_KMapEstimationQuasiIdValues

// Result of the l-diversity computation.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_LDiversityResult = src.AnalyzeDataSourceRiskDetails_LDiversityResult
type AnalyzeDataSourceRiskDetails_LDiversityResult_ = src.AnalyzeDataSourceRiskDetails_LDiversityResult_

// The set of columns' values that share the same ldiversity value.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass = src.AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityEquivalenceClass

// Histogram of l-diversity equivalence class sensitive value frequencies.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket = src.AnalyzeDataSourceRiskDetails_LDiversityResult_LDiversityHistogramBucket

// Result of the numerical stats computation.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_NumericalStatsResult = src.AnalyzeDataSourceRiskDetails_NumericalStatsResult
type AnalyzeDataSourceRiskDetails_NumericalStatsResult_ = src.AnalyzeDataSourceRiskDetails_NumericalStatsResult_

// Risk analysis options.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions = src.AnalyzeDataSourceRiskDetails_RequestedRiskAnalysisOptions

// Message defining a field of a BigQuery table.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type BigQueryField = src.BigQueryField

// Row key for identifying a record in BigQuery table.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type BigQueryKey = src.BigQueryKey

// Options defining BigQuery table and row identifiers.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type BigQueryOptions = src.BigQueryOptions

// How to sample rows if not all rows are scanned. Meaningful only when used
// in conjunction with either rows_limit or rows_limit_percent. If not
// specified, rows are scanned in the order BigQuery reads them.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type BigQueryOptions_SampleMethod = src.BigQueryOptions_SampleMethod

// Message defining the location of a BigQuery table. A table is uniquely
// identified by its project_id, dataset_id, and table_name. Within a query a
// table is often referenced with a string in the format of:
// `<project_id>:<dataset_id>.<table_id>` or
// `<project_id>.<dataset_id>.<table_id>`.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type BigQueryTable = src.BigQueryTable

// Bounding box encompassing detected text within an image.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type BoundingBox = src.BoundingBox

// Generalization function that buckets values based on ranges. The ranges and
// replacement values are dynamically provided by the user for custom behavior,
// such as 1-30 -> LOW 31-65 -> MEDIUM 66-100 -> HIGH This can be used on data
// of type: number, long, string, timestamp. If the bound `Value` type differs
// from the type of data being transformed, we will first attempt converting
// the type of the data to be transformed to match the type of the bound before
// comparing. See https://cloud.google.com/dlp/docs/concepts-bucketing to learn
// more.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type BucketingConfig = src.BucketingConfig

// Bucket is represented as a range, along with replacement values.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type BucketingConfig_Bucket = src.BucketingConfig_Bucket

// Container for bytes to inspect or redact.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ByteContentItem = src.ByteContentItem

// The type of data being sent for inspection. To learn more, see [Supported
// file types](https://cloud.google.com/dlp/docs/supported-file-types).
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ByteContentItem_BytesType = src.ByteContentItem_BytesType

// The request message for canceling a DLP job.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CancelDlpJobRequest = src.CancelDlpJobRequest

// Partially mask a string by replacing a given number of characters with a
// fixed character. Masking can start from the beginning or end of the string.
// This can be used on data of any type (numbers, longs, and so on) and when
// de-identifying structured data we'll attempt to preserve the original data's
// type. (This allows you to take a long like 123 and modify it to a string
// like **3.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CharacterMaskConfig = src.CharacterMaskConfig

// Characters to skip when doing deidentification of a value. These will be
// left alone and skipped.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CharsToIgnore = src.CharsToIgnore
type CharsToIgnore_CharactersToSkip = src.CharsToIgnore_CharactersToSkip
type CharsToIgnore_CommonCharactersToIgnore = src.CharsToIgnore_CommonCharactersToIgnore

// Convenience enum for indicating common characters to not transform.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CharsToIgnore_CommonCharsToIgnore = src.CharsToIgnore_CommonCharsToIgnore

// Message representing a set of files in Cloud Storage.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CloudStorageFileSet = src.CloudStorageFileSet

// Options defining a file or a set of files within a Cloud Storage bucket.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CloudStorageOptions = src.CloudStorageOptions

// Set of files to scan.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CloudStorageOptions_FileSet = src.CloudStorageOptions_FileSet

// How to sample bytes if not all bytes are scanned. Meaningful only when used
// in conjunction with bytes_limit_per_file. If not specified, scanning would
// start from the top.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CloudStorageOptions_SampleMethod = src.CloudStorageOptions_SampleMethod

// Message representing a single file or path in Cloud Storage.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CloudStoragePath = src.CloudStoragePath

// Message representing a set of files in a Cloud Storage bucket. Regular
// expressions are used to allow fine-grained control over which files in the
// bucket to include. Included files are those that match at least one item in
// `include_regex` and do not match any items in `exclude_regex`. Note that a
// file that matches items from both lists will _not_ be included. For a match
// to occur, the entire file path (i.e., everything in the url after the bucket
// name) must match the regular expression. For example, given the input
// `{bucket_name: "mybucket", include_regex: ["directory1/.*"], exclude_regex:
// ["directory1/excluded.*"]}`: * `gs://mybucket/directory1/myfile` will be
// included * `gs://mybucket/directory1/directory2/myfile` will be included
// (`.*` matches across `/`) * `gs://mybucket/directory0/directory1/myfile`
// will _not_ be included (the full path doesn't match any items in
// `include_regex`) * `gs://mybucket/directory1/excludedfile` will _not_ be
// included (the path matches an item in `exclude_regex`) If `include_regex` is
// left empty, it will match all files by default (this is equivalent to
// setting `include_regex: [".*"]`). Some other common use cases: *
// `{bucket_name: "mybucket", exclude_regex: [".*\.pdf"]}` will include all
// files in `mybucket` except for .pdf files * `{bucket_name: "mybucket",
// include_regex: ["directory/[^/]+"]}` will include all files directly under
// `gs://mybucket/directory/`, without matching across `/`
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CloudStorageRegexFileSet = src.CloudStorageRegexFileSet

// Represents a color in the RGB color space.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Color = src.Color

// Represents a container that may contain DLP findings. Examples of a
// container include a file, table, or database record.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Container = src.Container

// Container structure for the content to inspect.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ContentItem = src.ContentItem
type ContentItem_ByteItem = src.ContentItem_ByteItem
type ContentItem_Table = src.ContentItem_Table
type ContentItem_Value = src.ContentItem_Value

// Precise location of the finding within a document, record, image, or
// metadata container.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ContentLocation = src.ContentLocation
type ContentLocation_DocumentLocation = src.ContentLocation_DocumentLocation
type ContentLocation_ImageLocation = src.ContentLocation_ImageLocation
type ContentLocation_MetadataLocation = src.ContentLocation_MetadataLocation
type ContentLocation_RecordLocation = src.ContentLocation_RecordLocation

// Deprecated and unused.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ContentOption = src.ContentOption

// Request message for CreateDeidentifyTemplate.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CreateDeidentifyTemplateRequest = src.CreateDeidentifyTemplateRequest

// Request message for CreateDlpJobRequest. Used to initiate long running jobs
// such as calculating risk metrics or inspecting Google Cloud Storage.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CreateDlpJobRequest = src.CreateDlpJobRequest
type CreateDlpJobRequest_InspectJob = src.CreateDlpJobRequest_InspectJob
type CreateDlpJobRequest_RiskJob = src.CreateDlpJobRequest_RiskJob

// Request message for CreateInspectTemplate.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CreateInspectTemplateRequest = src.CreateInspectTemplateRequest

// Request message for CreateJobTrigger.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CreateJobTriggerRequest = src.CreateJobTriggerRequest

// Request message for CreateStoredInfoType.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CreateStoredInfoTypeRequest = src.CreateStoredInfoTypeRequest

// Pseudonymization method that generates deterministic encryption for the
// given input. Outputs a base64 encoded representation of the encrypted
// output. Uses AES-SIV based on the RFC https://tools.ietf.org/html/rfc5297.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CryptoDeterministicConfig = src.CryptoDeterministicConfig

// Pseudonymization method that generates surrogates via cryptographic
// hashing. Uses SHA-256. The key size must be either 32 or 64 bytes. Outputs a
// base64 encoded representation of the hashed output (for example,
// L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=). Currently, only string and
// integer values can be hashed. See
// https://cloud.google.com/dlp/docs/pseudonymization to learn more.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CryptoHashConfig = src.CryptoHashConfig

// This is a data encryption key (DEK) (as opposed to a key encryption key
// (KEK) stored by Cloud Key Management Service (Cloud KMS). When using Cloud
// KMS to wrap or unwrap a DEK, be sure to set an appropriate IAM policy on the
// KEK to ensure an attacker cannot unwrap the DEK.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CryptoKey = src.CryptoKey
type CryptoKey_KmsWrapped = src.CryptoKey_KmsWrapped
type CryptoKey_Transient = src.CryptoKey_Transient
type CryptoKey_Unwrapped = src.CryptoKey_Unwrapped

// Replaces an identifier with a surrogate using Format Preserving Encryption
// (FPE) with the FFX mode of operation; however when used in the
// `ReidentifyContent` API method, it serves the opposite function by reversing
// the surrogate back into the original identifier. The identifier must be
// encoded as ASCII. For a given crypto key and context, the same identifier
// will be replaced with the same surrogate. Identifiers must be at least two
// characters long. In the case that the identifier is the empty string, it
// will be skipped. See https://cloud.google.com/dlp/docs/pseudonymization to
// learn more. Note: We recommend using CryptoDeterministicConfig for all use
// cases which do not require preserving the input alphabet space and size,
// plus warrant referential integrity.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CryptoReplaceFfxFpeConfig = src.CryptoReplaceFfxFpeConfig
type CryptoReplaceFfxFpeConfig_CommonAlphabet = src.CryptoReplaceFfxFpeConfig_CommonAlphabet
type CryptoReplaceFfxFpeConfig_CustomAlphabet = src.CryptoReplaceFfxFpeConfig_CustomAlphabet

// These are commonly used subsets of the alphabet that the FFX mode natively
// supports. In the algorithm, the alphabet is selected using the "radix".
// Therefore each corresponds to a particular radix.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet = src.CryptoReplaceFfxFpeConfig_FfxCommonNativeAlphabet
type CryptoReplaceFfxFpeConfig_Radix = src.CryptoReplaceFfxFpeConfig_Radix

// Custom information type provided by the user. Used to find domain-specific
// sensitive information configurable to the data in question.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CustomInfoType = src.CustomInfoType

// Deprecated; use `InspectionRuleSet` instead. Rule for modifying a
// `CustomInfoType` to alter behavior under certain circumstances, depending on
// the specific details of the rule. Not supported for the `surrogate_type`
// custom infoType.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CustomInfoType_DetectionRule = src.CustomInfoType_DetectionRule

// The rule that adjusts the likelihood of findings within a certain proximity
// of hotwords.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CustomInfoType_DetectionRule_HotwordRule = src.CustomInfoType_DetectionRule_HotwordRule
type CustomInfoType_DetectionRule_HotwordRule_ = src.CustomInfoType_DetectionRule_HotwordRule_

// Message for specifying an adjustment to the likelihood of a finding as part
// of a detection rule.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CustomInfoType_DetectionRule_LikelihoodAdjustment = src.CustomInfoType_DetectionRule_LikelihoodAdjustment
type CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood = src.CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood
type CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood = src.CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood

// Message for specifying a window around a finding to apply a detection rule.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CustomInfoType_DetectionRule_Proximity = src.CustomInfoType_DetectionRule_Proximity

// Custom information type based on a dictionary of words or phrases. This can
// be used to match sensitive information specific to the data, such as a list
// of employee IDs or job titles. Dictionary words are case-insensitive and all
// characters other than letters and digits in the unicode [Basic Multilingual
// Plane](https://en.wikipedia.org/wiki/Plane_%28Unicode%29#Basic_Multilingual_Plane)
// will be replaced with whitespace when scanning for matches, so the
// dictionary phrase "Sam Johnson" will match all three phrases "sam johnson",
// "Sam, Johnson", and "Sam (Johnson)". Additionally, the characters
// surrounding any match must be of a different type than the adjacent
// characters within the word, so letters must be next to non-letters and
// digits next to non-digits. For example, the dictionary word "jen" will match
// the first three letters of the text "jen123" but will return no matches for
// "jennifer". Dictionary words containing a large number of characters that
// are not letters or digits may result in unexpected findings because such
// characters are treated as whitespace. The
// [limits](https://cloud.google.com/dlp/limits) page contains details about
// the size limits of dictionaries. For dictionaries that do not fit within
// these constraints, consider using `LargeCustomDictionaryConfig` in the
// `StoredInfoType` API.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CustomInfoType_Dictionary = src.CustomInfoType_Dictionary
type CustomInfoType_Dictionary_ = src.CustomInfoType_Dictionary_
type CustomInfoType_Dictionary_CloudStoragePath = src.CustomInfoType_Dictionary_CloudStoragePath

// Message defining a list of words or phrases to search for in the data.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CustomInfoType_Dictionary_WordList = src.CustomInfoType_Dictionary_WordList
type CustomInfoType_Dictionary_WordList_ = src.CustomInfoType_Dictionary_WordList_
type CustomInfoType_ExclusionType = src.CustomInfoType_ExclusionType

// Message defining a custom regular expression.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CustomInfoType_Regex = src.CustomInfoType_Regex
type CustomInfoType_Regex_ = src.CustomInfoType_Regex_
type CustomInfoType_StoredType = src.CustomInfoType_StoredType

// Message for detecting output from deidentification transformations such as
// [`CryptoReplaceFfxFpeConfig`](https://cloud.google.com/dlp/docs/reference/rest/v2/organizations.deidentifyTemplates#cryptoreplaceffxfpeconfig).
// These types of transformations are those that perform pseudonymization,
// thereby producing a "surrogate" as output. This should be used in
// conjunction with a field on the transformation such as
// `surrogate_info_type`. This CustomInfoType does not support the use of
// `detection_rules`.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type CustomInfoType_SurrogateType = src.CustomInfoType_SurrogateType
type CustomInfoType_SurrogateType_ = src.CustomInfoType_SurrogateType_

// A task to execute when a data profile has been generated.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfileAction = src.DataProfileAction

// Types of event that can trigger an action.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfileAction_EventType = src.DataProfileAction_EventType

// If set, the detailed data profiles will be persisted to the location of
// your choice whenever updated.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfileAction_Export = src.DataProfileAction_Export
type DataProfileAction_ExportData = src.DataProfileAction_ExportData

// Send a Pub/Sub message into the given Pub/Sub topic to connect other
// systems to data profile generation. The message payload data will be the
// byte serialization of `DataProfilePubSubMessage`.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfileAction_PubSubNotification = src.DataProfileAction_PubSubNotification
type DataProfileAction_PubSubNotification_ = src.DataProfileAction_PubSubNotification_

// The levels of detail that can be included in the Pub/Sub message.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfileAction_PubSubNotification_DetailLevel = src.DataProfileAction_PubSubNotification_DetailLevel

// Snapshot of the configurations used to generate the profile.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfileConfigSnapshot = src.DataProfileConfigSnapshot

// Configuration for setting up a job to scan resources for profile
// generation. Only one data profile configuration may exist per organization,
// folder, or project. The generated data profiles are retained according to
// the [data retention policy]
// (https://cloud.google.com/dlp/docs/data-profiles#retention).
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfileJobConfig = src.DataProfileJobConfig

// The data that will be profiled.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfileLocation = src.DataProfileLocation
type DataProfileLocation_FolderId = src.DataProfileLocation_FolderId
type DataProfileLocation_OrganizationId = src.DataProfileLocation_OrganizationId

// A condition for determining whether a Pub/Sub should be triggered.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfilePubSubCondition = src.DataProfilePubSubCondition

// Various score levels for resources.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfilePubSubCondition_ProfileScoreBucket = src.DataProfilePubSubCondition_ProfileScoreBucket

// A condition consisting of a value.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfilePubSubCondition_PubSubCondition = src.DataProfilePubSubCondition_PubSubCondition
type DataProfilePubSubCondition_PubSubCondition_MinimumRiskScore = src.DataProfilePubSubCondition_PubSubCondition_MinimumRiskScore
type DataProfilePubSubCondition_PubSubCondition_MinimumSensitivityScore = src.DataProfilePubSubCondition_PubSubCondition_MinimumSensitivityScore

// An expression, consisting of an operator and conditions.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfilePubSubCondition_PubSubExpressions = src.DataProfilePubSubCondition_PubSubExpressions

// Logical operators for conditional checks.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator = src.DataProfilePubSubCondition_PubSubExpressions_PubSubLogicalOperator

// Pub/Sub topic message for a DataProfileAction.PubSubNotification event. To
// receive a message of protocol buffer schema type, convert the message data
// to an object of this proto class.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataProfilePubSubMessage = src.DataProfilePubSubMessage

// Score is a summary of all elements in the data profile. A higher number
// means more risk.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataRiskLevel = src.DataRiskLevel

// Various score levels for resources.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DataRiskLevel_DataRiskLevelScore = src.DataRiskLevel_DataRiskLevelScore

// Record key for a finding in Cloud Datastore.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DatastoreKey = src.DatastoreKey

// Options defining a data set within Google Cloud Datastore.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DatastoreOptions = src.DatastoreOptions

// Shifts dates by random number of days, with option to be consistent for the
// same context. See https://cloud.google.com/dlp/docs/concepts-date-shifting
// to learn more.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DateShiftConfig = src.DateShiftConfig
type DateShiftConfig_CryptoKey = src.DateShiftConfig_CryptoKey

// Message for a date time object. e.g. 2018-01-01, 5th August.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DateTime = src.DateTime

// Time zone of the date time object.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DateTime_TimeZone = src.DateTime_TimeZone

// The configuration that controls how the data will change.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DeidentifyConfig = src.DeidentifyConfig
type DeidentifyConfig_ImageTransformations = src.DeidentifyConfig_ImageTransformations
type DeidentifyConfig_InfoTypeTransformations = src.DeidentifyConfig_InfoTypeTransformations
type DeidentifyConfig_RecordTransformations = src.DeidentifyConfig_RecordTransformations

// Request to de-identify a ContentItem.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DeidentifyContentRequest = src.DeidentifyContentRequest

// Results of de-identifying a ContentItem.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DeidentifyContentResponse = src.DeidentifyContentResponse

// DeidentifyTemplates contains instructions on how to de-identify content.
// See https://cloud.google.com/dlp/docs/concepts-templates to learn more.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DeidentifyTemplate = src.DeidentifyTemplate

// Request message for DeleteDeidentifyTemplate.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DeleteDeidentifyTemplateRequest = src.DeleteDeidentifyTemplateRequest

// The request message for deleting a DLP job.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DeleteDlpJobRequest = src.DeleteDlpJobRequest

// Request message for DeleteInspectTemplate.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DeleteInspectTemplateRequest = src.DeleteInspectTemplateRequest

// Request message for DeleteJobTrigger.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DeleteJobTriggerRequest = src.DeleteJobTriggerRequest

// Request message for DeleteStoredInfoType.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DeleteStoredInfoTypeRequest = src.DeleteStoredInfoTypeRequest

// Combines all of the information about a DLP job.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DlpJob = src.DlpJob

// An enum to represent the various types of DLP jobs.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DlpJobType = src.DlpJobType
type DlpJob_InspectDetails = src.DlpJob_InspectDetails

// Possible states of a job. New items may be added.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DlpJob_JobState = src.DlpJob_JobState
type DlpJob_RiskDetails = src.DlpJob_RiskDetails

// DlpServiceClient is the client API for DlpService service. For semantics
// around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DlpServiceClient = src.DlpServiceClient

// DlpServiceServer is the server API for DlpService service.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DlpServiceServer = src.DlpServiceServer

// Location of a finding within a document.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type DocumentLocation = src.DocumentLocation

// How a resource is encrypted.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type EncryptionStatus = src.EncryptionStatus

// An entity in a dataset is a field or set of fields that correspond to a
// single person. For example, in medical records the `EntityId` might be a
// patient identifier, or for financial records it might be an account
// identifier. This message is used when generalizations or analysis must take
// into account that multiple rows correspond to the same entity.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type EntityId = src.EntityId

// Details information about an error encountered during job execution or the
// results of an unsuccessful activation of the JobTrigger.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Error = src.Error

// List of excluded infoTypes.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ExcludeInfoTypes = src.ExcludeInfoTypes

// The rule that specifies conditions when findings of infoTypes specified in
// `InspectionRuleSet` are removed from results.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ExclusionRule = src.ExclusionRule
type ExclusionRule_Dictionary = src.ExclusionRule_Dictionary
type ExclusionRule_ExcludeInfoTypes = src.ExclusionRule_ExcludeInfoTypes
type ExclusionRule_Regex = src.ExclusionRule_Regex

// General identifier of a data field in a storage service.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type FieldId = src.FieldId

// The transformation to apply to the field.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type FieldTransformation = src.FieldTransformation
type FieldTransformation_InfoTypeTransformations = src.FieldTransformation_InfoTypeTransformations
type FieldTransformation_PrimitiveTransformation = src.FieldTransformation_PrimitiveTransformation

// Definitions of file type groups to scan. New types will be added to this
// list.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type FileType = src.FileType

// Represents a piece of potentially sensitive content.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Finding = src.Finding

// The request message for finishing a DLP hybrid job.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type FinishDlpJobRequest = src.FinishDlpJobRequest

// Buckets values based on fixed size ranges. The Bucketing transformation can
// provide all of this functionality, but requires more configuration. This
// message is provided as a convenience to the user for simple bucketing
// strategies. The transformed value will be a hyphenated string of
// {lower_bound}-{upper_bound}. For example, if lower_bound = 10 and
// upper_bound = 20, all values that are within this bucket will be replaced
// with "10-20". This can be used on data of type: double, long. If the bound
// Value type differs from the type of data being transformed, we will first
// attempt converting the type of the data to be transformed to match the type
// of the bound before comparing. See
// https://cloud.google.com/dlp/docs/concepts-bucketing to learn more.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type FixedSizeBucketingConfig = src.FixedSizeBucketingConfig

// Request message for GetDeidentifyTemplate.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type GetDeidentifyTemplateRequest = src.GetDeidentifyTemplateRequest

// The request message for [DlpJobs.GetDlpJob][].
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type GetDlpJobRequest = src.GetDlpJobRequest

// Request message for GetInspectTemplate.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type GetInspectTemplateRequest = src.GetInspectTemplateRequest

// Request message for GetJobTrigger.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type GetJobTriggerRequest = src.GetJobTriggerRequest

// Request message for GetStoredInfoType.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type GetStoredInfoTypeRequest = src.GetStoredInfoTypeRequest

// An individual hybrid item to inspect. Will be stored temporarily during
// processing.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type HybridContentItem = src.HybridContentItem

// Populate to associate additional data with each finding.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type HybridFindingDetails = src.HybridFindingDetails

// Request to search for potentially sensitive info in a custom location.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type HybridInspectDlpJobRequest = src.HybridInspectDlpJobRequest

// Request to search for potentially sensitive info in a custom location.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type HybridInspectJobTriggerRequest = src.HybridInspectJobTriggerRequest

// Quota exceeded errors will be thrown once quota has been met.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type HybridInspectResponse = src.HybridInspectResponse

// Statistics related to processing hybrid inspect requests.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type HybridInspectStatistics = src.HybridInspectStatistics

// Configuration to control jobs where the content being inspected is outside
// of Google Cloud Platform.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type HybridOptions = src.HybridOptions

// Location of the finding within an image.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ImageLocation = src.ImageLocation

// A type of transformation that is applied over images.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ImageTransformations = src.ImageTransformations

// Configuration for determining how redaction of images should occur.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ImageTransformations_ImageTransformation = src.ImageTransformations_ImageTransformation

// Apply transformation to all findings.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ImageTransformations_ImageTransformation_AllInfoTypes = src.ImageTransformations_ImageTransformation_AllInfoTypes
type ImageTransformations_ImageTransformation_AllInfoTypes_ = src.ImageTransformations_ImageTransformation_AllInfoTypes_

// Apply to all text.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ImageTransformations_ImageTransformation_AllText = src.ImageTransformations_ImageTransformation_AllText
type ImageTransformations_ImageTransformation_AllText_ = src.ImageTransformations_ImageTransformation_AllText_

// Apply transformation to the selected info_types.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ImageTransformations_ImageTransformation_SelectedInfoTypes = src.ImageTransformations_ImageTransformation_SelectedInfoTypes
type ImageTransformations_ImageTransformation_SelectedInfoTypes_ = src.ImageTransformations_ImageTransformation_SelectedInfoTypes_

// Type of information detected by the API.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InfoType = src.InfoType

// Classification of infoTypes to organize them according to geographic
// location, industry, and data type.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InfoTypeCategory = src.InfoTypeCategory

// Enum of the current industries in the category. We might add more
// industries in the future.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InfoTypeCategory_IndustryCategory = src.InfoTypeCategory_IndustryCategory
type InfoTypeCategory_IndustryCategory_ = src.InfoTypeCategory_IndustryCategory_

// Enum of the current locations. We might add more locations in the future.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InfoTypeCategory_LocationCategory = src.InfoTypeCategory_LocationCategory
type InfoTypeCategory_LocationCategory_ = src.InfoTypeCategory_LocationCategory_

// Enum of the current types in the category. We might add more types in the
// future.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InfoTypeCategory_TypeCategory = src.InfoTypeCategory_TypeCategory
type InfoTypeCategory_TypeCategory_ = src.InfoTypeCategory_TypeCategory_

// InfoType description.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InfoTypeDescription = src.InfoTypeDescription

// Statistics regarding a specific InfoType.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InfoTypeStats = src.InfoTypeStats

// The infoType details for this column.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InfoTypeSummary = src.InfoTypeSummary

// Parts of the APIs which use certain infoTypes.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InfoTypeSupportedBy = src.InfoTypeSupportedBy

// A type of transformation that will scan unstructured text and apply various
// `PrimitiveTransformation`s to each finding, where the transformation is
// applied to only values that were identified as a specific info_type.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InfoTypeTransformations = src.InfoTypeTransformations

// A transformation to apply to text that is identified as a specific
// info_type.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InfoTypeTransformations_InfoTypeTransformation = src.InfoTypeTransformations_InfoTypeTransformation

// Configuration description of the scanning process. When used with
// redactContent only info_types and min_likelihood are currently used.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectConfig = src.InspectConfig

// Configuration to control the number of findings returned for inspection.
// This is not used for de-identification or data profiling. When redacting
// sensitive data from images, finding limits don't apply. They can cause
// unexpected or inconsistent results, where only some data is redacted. Don't
// include finding limits in
// [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage] requests.
// Otherwise, Cloud DLP returns an error.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectConfig_FindingLimits = src.InspectConfig_FindingLimits

// Max findings configuration per infoType, per content item or long running
// DlpJob.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectConfig_FindingLimits_InfoTypeLimit = src.InspectConfig_FindingLimits_InfoTypeLimit

// Request to search for potentially sensitive info in a ContentItem.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectContentRequest = src.InspectContentRequest

// Results of inspecting an item.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectContentResponse = src.InspectContentResponse

// The results of an inspect DataSource job.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectDataSourceDetails = src.InspectDataSourceDetails

// Snapshot of the inspection configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectDataSourceDetails_RequestedOptions = src.InspectDataSourceDetails_RequestedOptions

// All result fields mentioned below are updated while the job is processing.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectDataSourceDetails_Result = src.InspectDataSourceDetails_Result

// Controls what and how to inspect for findings.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectJobConfig = src.InspectJobConfig

// All the findings for a single scanned item.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectResult = src.InspectResult

// The inspectTemplate contains a configuration (set of types of sensitive
// data to be detected) to be used anywhere you otherwise would normally
// specify InspectConfig. See
// https://cloud.google.com/dlp/docs/concepts-templates to learn more.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectTemplate = src.InspectTemplate

// A single inspection rule to be applied to infoTypes, specified in
// `InspectionRuleSet`.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectionRule = src.InspectionRule

// Rule set for modifying a set of infoTypes to alter behavior under certain
// circumstances, depending on the specific details of the rules within the
// set.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type InspectionRuleSet = src.InspectionRuleSet
type InspectionRule_ExclusionRule = src.InspectionRule_ExclusionRule
type InspectionRule_HotwordRule = src.InspectionRule_HotwordRule

// Contains a configuration to make dlp api calls on a repeating basis. See
// https://cloud.google.com/dlp/docs/concepts-job-triggers to learn more.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type JobTrigger = src.JobTrigger
type JobTrigger_InspectJob = src.JobTrigger_InspectJob

// Whether the trigger is currently active. If PAUSED or CANCELLED, no jobs
// will be created with this configuration. The service may automatically pause
// triggers experiencing frequent errors. To restart a job, set the status to
// HEALTHY after correcting user errors.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type JobTrigger_Status = src.JobTrigger_Status

// What event needs to occur for a new job to be started.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type JobTrigger_Trigger = src.JobTrigger_Trigger
type JobTrigger_Trigger_Manual = src.JobTrigger_Trigger_Manual
type JobTrigger_Trigger_Schedule = src.JobTrigger_Trigger_Schedule

// A unique identifier for a Datastore entity. If a key's partition ID or any
// of its path kinds or names are reserved/read-only, the key is
// reserved/read-only. A reserved/read-only key is forbidden in certain
// documented contexts.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Key = src.Key

// A (kind, ID/name) pair used to construct a key path. If either name or ID
// is set, the element is complete. If neither is set, the element is
// incomplete.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Key_PathElement = src.Key_PathElement
type Key_PathElement_Id = src.Key_PathElement_Id
type Key_PathElement_Name = src.Key_PathElement_Name

// A representation of a Datastore kind.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type KindExpression = src.KindExpression

// Include to use an existing data crypto key wrapped by KMS. The wrapped key
// must be a 128-, 192-, or 256-bit key. Authorization requires the following
// IAM permissions when sending a request to perform a crypto transformation
// using a KMS-wrapped crypto key: dlp.kms.encrypt For more information, see
// [Creating a wrapped key]
// (https://cloud.google.com/dlp/docs/create-wrapped-key). Note: When you use
// Cloud KMS for cryptographic operations, [charges
// apply](https://cloud.google.com/kms/pricing).
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type KmsWrappedCryptoKey = src.KmsWrappedCryptoKey

// Configuration for a custom dictionary created from a data source of any
// size up to the maximum size defined in the
// [limits](https://cloud.google.com/dlp/limits) page. The artifacts of
// dictionary creation are stored in the specified Cloud Storage location.
// Consider using `CustomInfoType.Dictionary` for smaller dictionaries that
// satisfy the size requirements.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type LargeCustomDictionaryConfig = src.LargeCustomDictionaryConfig
type LargeCustomDictionaryConfig_BigQueryField = src.LargeCustomDictionaryConfig_BigQueryField
type LargeCustomDictionaryConfig_CloudStorageFileSet = src.LargeCustomDictionaryConfig_CloudStorageFileSet

// Summary statistics of a custom dictionary.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type LargeCustomDictionaryStats = src.LargeCustomDictionaryStats

// Categorization of results based on how likely they are to represent a
// match, based on the number of elements they contain which imply a match.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Likelihood = src.Likelihood

// Request message for ListDeidentifyTemplates.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListDeidentifyTemplatesRequest = src.ListDeidentifyTemplatesRequest

// Response message for ListDeidentifyTemplates.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListDeidentifyTemplatesResponse = src.ListDeidentifyTemplatesResponse

// The request message for listing DLP jobs.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListDlpJobsRequest = src.ListDlpJobsRequest

// The response message for listing DLP jobs.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListDlpJobsResponse = src.ListDlpJobsResponse

// Request for the list of infoTypes.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListInfoTypesRequest = src.ListInfoTypesRequest

// Response to the ListInfoTypes request.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListInfoTypesResponse = src.ListInfoTypesResponse

// Request message for ListInspectTemplates.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListInspectTemplatesRequest = src.ListInspectTemplatesRequest

// Response message for ListInspectTemplates.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListInspectTemplatesResponse = src.ListInspectTemplatesResponse

// Request message for ListJobTriggers.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListJobTriggersRequest = src.ListJobTriggersRequest

// Response message for ListJobTriggers.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListJobTriggersResponse = src.ListJobTriggersResponse

// Request message for ListStoredInfoTypes.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListStoredInfoTypesRequest = src.ListStoredInfoTypesRequest

// Response message for ListStoredInfoTypes.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ListStoredInfoTypesResponse = src.ListStoredInfoTypesResponse

// Specifies the location of the finding.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Location = src.Location

// Job trigger option for hybrid jobs. Jobs must be manually created and
// finished.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Manual = src.Manual

// Type of the match which can be applied to different ways of matching, like
// Dictionary, regular expression and intersecting with findings of another
// info type.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type MatchingType = src.MatchingType

// Metadata Location
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type MetadataLocation = src.MetadataLocation
type MetadataLocation_StorageLabel = src.MetadataLocation_StorageLabel

// Type of metadata containing the finding.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type MetadataType = src.MetadataType

// Infotype details for other infoTypes found within a column.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type OtherInfoTypeSummary = src.OtherInfoTypeSummary

// Cloud repository for storing output.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type OutputStorageConfig = src.OutputStorageConfig

// Predefined schemas for storing findings. Only for use with external
// storage.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type OutputStorageConfig_OutputSchema = src.OutputStorageConfig_OutputSchema
type OutputStorageConfig_Table = src.OutputStorageConfig_Table

// Datastore partition ID. A partition ID identifies a grouping of entities.
// The grouping is always by project and namespace, however the namespace ID
// may be empty. A partition ID contains several dimensions: project ID and
// namespace ID.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PartitionId = src.PartitionId

// A rule for transforming a value.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PrimitiveTransformation = src.PrimitiveTransformation
type PrimitiveTransformation_BucketingConfig = src.PrimitiveTransformation_BucketingConfig
type PrimitiveTransformation_CharacterMaskConfig = src.PrimitiveTransformation_CharacterMaskConfig
type PrimitiveTransformation_CryptoDeterministicConfig = src.PrimitiveTransformation_CryptoDeterministicConfig
type PrimitiveTransformation_CryptoHashConfig = src.PrimitiveTransformation_CryptoHashConfig
type PrimitiveTransformation_CryptoReplaceFfxFpeConfig = src.PrimitiveTransformation_CryptoReplaceFfxFpeConfig
type PrimitiveTransformation_DateShiftConfig = src.PrimitiveTransformation_DateShiftConfig
type PrimitiveTransformation_FixedSizeBucketingConfig = src.PrimitiveTransformation_FixedSizeBucketingConfig
type PrimitiveTransformation_RedactConfig = src.PrimitiveTransformation_RedactConfig
type PrimitiveTransformation_ReplaceConfig = src.PrimitiveTransformation_ReplaceConfig
type PrimitiveTransformation_ReplaceDictionaryConfig = src.PrimitiveTransformation_ReplaceDictionaryConfig
type PrimitiveTransformation_ReplaceWithInfoTypeConfig = src.PrimitiveTransformation_ReplaceWithInfoTypeConfig
type PrimitiveTransformation_TimePartConfig = src.PrimitiveTransformation_TimePartConfig

// Privacy metric to compute for reidentification risk analysis.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PrivacyMetric = src.PrivacyMetric

// Compute numerical stats over an individual column, including number of
// distinct values and value count distribution.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PrivacyMetric_CategoricalStatsConfig = src.PrivacyMetric_CategoricalStatsConfig
type PrivacyMetric_CategoricalStatsConfig_ = src.PrivacyMetric_CategoricalStatsConfig_

// δ-presence metric, used to estimate how likely it is for an attacker to
// figure out that one given individual appears in a de-identified dataset.
// Similarly to the k-map metric, we cannot compute δ-presence exactly without
// knowing the attack dataset, so we use a statistical model instead.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PrivacyMetric_DeltaPresenceEstimationConfig = src.PrivacyMetric_DeltaPresenceEstimationConfig
type PrivacyMetric_DeltaPresenceEstimationConfig_ = src.PrivacyMetric_DeltaPresenceEstimationConfig_

// k-anonymity metric, used for analysis of reidentification risk.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PrivacyMetric_KAnonymityConfig = src.PrivacyMetric_KAnonymityConfig
type PrivacyMetric_KAnonymityConfig_ = src.PrivacyMetric_KAnonymityConfig_

// Reidentifiability metric. This corresponds to a risk model similar to what
// is called "journalist risk" in the literature, except the attack dataset is
// statistically modeled instead of being perfectly known. This can be done
// using publicly available data (like the US Census), or using a custom
// statistical model (indicated as one or several BigQuery tables), or by
// extrapolating from the distribution of values in the input dataset.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PrivacyMetric_KMapEstimationConfig = src.PrivacyMetric_KMapEstimationConfig
type PrivacyMetric_KMapEstimationConfig_ = src.PrivacyMetric_KMapEstimationConfig_

// An auxiliary table contains statistical information on the relative
// frequency of different quasi-identifiers values. It has one or several
// quasi-identifiers columns, and one column that indicates the relative
// frequency of each quasi-identifier tuple. If a tuple is present in the data
// but not in the auxiliary table, the corresponding relative frequency is
// assumed to be zero (and thus, the tuple is highly reidentifiable).
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PrivacyMetric_KMapEstimationConfig_AuxiliaryTable = src.PrivacyMetric_KMapEstimationConfig_AuxiliaryTable

// A quasi-identifier column has a custom_tag, used to know which column in
// the data corresponds to which column in the statistical model.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField = src.PrivacyMetric_KMapEstimationConfig_AuxiliaryTable_QuasiIdField

// A column with a semantic tag attached.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PrivacyMetric_KMapEstimationConfig_TaggedField = src.PrivacyMetric_KMapEstimationConfig_TaggedField
type PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag = src.PrivacyMetric_KMapEstimationConfig_TaggedField_CustomTag
type PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred = src.PrivacyMetric_KMapEstimationConfig_TaggedField_Inferred
type PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType = src.PrivacyMetric_KMapEstimationConfig_TaggedField_InfoType

// l-diversity metric, used for analysis of reidentification risk.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PrivacyMetric_LDiversityConfig = src.PrivacyMetric_LDiversityConfig
type PrivacyMetric_LDiversityConfig_ = src.PrivacyMetric_LDiversityConfig_

// Compute numerical stats over an individual column, including min, max, and
// quantiles.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type PrivacyMetric_NumericalStatsConfig = src.PrivacyMetric_NumericalStatsConfig
type PrivacyMetric_NumericalStatsConfig_ = src.PrivacyMetric_NumericalStatsConfig_
type ProfileStatus = src.ProfileStatus

// A column with a semantic tag attached.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type QuasiId = src.QuasiId
type QuasiId_CustomTag = src.QuasiId_CustomTag
type QuasiId_Inferred = src.QuasiId_Inferred
type QuasiId_InfoType = src.QuasiId_InfoType

// Message for infoType-dependent details parsed from quote.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type QuoteInfo = src.QuoteInfo
type QuoteInfo_DateTime = src.QuoteInfo_DateTime

// Generic half-open interval [start, end)
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Range = src.Range

// A condition for determining whether a transformation should be applied to a
// field.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RecordCondition = src.RecordCondition

// The field type of `value` and `field` do not need to match to be considered
// equal, but not all comparisons are possible. EQUAL_TO and NOT_EQUAL_TO
// attempt to compare even with incompatible types, but all other comparisons
// are invalid with incompatible types. A `value` of type: - `string` can be
// compared against all other types - `boolean` can only be compared against
// other booleans - `integer` can be compared against doubles or a string if
// the string value can be parsed as an integer. - `double` can be compared
// against integers or a string if the string can be parsed as a double. -
// `Timestamp` can be compared against strings in RFC 3339 date string format.
// - `TimeOfDay` can be compared against timestamps and strings in the format
// of 'HH:mm:ss'. If we fail to compare do to type mismatch, a warning will be
// given and the condition will evaluate to false.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RecordCondition_Condition = src.RecordCondition_Condition

// A collection of conditions.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RecordCondition_Conditions = src.RecordCondition_Conditions

// An expression, consisting of an operator and conditions.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RecordCondition_Expressions = src.RecordCondition_Expressions
type RecordCondition_Expressions_Conditions = src.RecordCondition_Expressions_Conditions

// Logical operators for conditional checks.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RecordCondition_Expressions_LogicalOperator = src.RecordCondition_Expressions_LogicalOperator

// Message for a unique key indicating a record that contains a finding.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RecordKey = src.RecordKey
type RecordKey_BigQueryKey = src.RecordKey_BigQueryKey
type RecordKey_DatastoreKey = src.RecordKey_DatastoreKey

// Location of a finding within a row or record.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RecordLocation = src.RecordLocation

// Configuration to suppress records whose suppression conditions evaluate to
// true.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RecordSuppression = src.RecordSuppression
type RecordTransformation = src.RecordTransformation

// A type of transformation that is applied over structured data such as a
// table.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RecordTransformations = src.RecordTransformations

// Redact a given value. For example, if used with an `InfoTypeTransformation`
// transforming PHONE_NUMBER, and input 'My phone number is 206-555-0123', the
// output would be 'My phone number is '.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RedactConfig = src.RedactConfig

// Request to search for potentially sensitive info in an image and redact it
// by covering it with a colored rectangle.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RedactImageRequest = src.RedactImageRequest

// Configuration for determining how redaction of images should occur.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RedactImageRequest_ImageRedactionConfig = src.RedactImageRequest_ImageRedactionConfig
type RedactImageRequest_ImageRedactionConfig_InfoType = src.RedactImageRequest_ImageRedactionConfig_InfoType
type RedactImageRequest_ImageRedactionConfig_RedactAllText = src.RedactImageRequest_ImageRedactionConfig_RedactAllText

// Results of redacting an image.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RedactImageResponse = src.RedactImageResponse

// Request to re-identify an item.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ReidentifyContentRequest = src.ReidentifyContentRequest

// Results of re-identifying an item.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ReidentifyContentResponse = src.ReidentifyContentResponse

// Operators available for comparing the value of fields.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RelationalOperator = src.RelationalOperator

// Replace each input value with a value randomly selected from the
// dictionary.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ReplaceDictionaryConfig = src.ReplaceDictionaryConfig
type ReplaceDictionaryConfig_WordList = src.ReplaceDictionaryConfig_WordList

// Replace each input value with a given `Value`.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ReplaceValueConfig = src.ReplaceValueConfig

// Replace each matching finding with the name of the info_type.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ReplaceWithInfoTypeConfig = src.ReplaceWithInfoTypeConfig

// How broadly a resource has been shared. New items may be added over time. A
// higher number means more restricted.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ResourceVisibility = src.ResourceVisibility

// Configuration for a risk analysis job. See
// https://cloud.google.com/dlp/docs/concepts-risk-analysis to learn more.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type RiskAnalysisJobConfig = src.RiskAnalysisJobConfig

// Schedule for inspect job triggers.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Schedule = src.Schedule
type Schedule_RecurrencePeriodDuration = src.Schedule_RecurrencePeriodDuration

// Score is a summary of all elements in the data profile. A higher number
// means more sensitive.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type SensitivityScore = src.SensitivityScore

// Various score levels for resources.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type SensitivityScore_SensitivityScoreLevel = src.SensitivityScore_SensitivityScoreLevel

// An auxiliary table containing statistical information on the relative
// frequency of different quasi-identifiers values. It has one or several
// quasi-identifiers columns, and one column that indicates the relative
// frequency of each quasi-identifier tuple. If a tuple is present in the data
// but not in the auxiliary table, the corresponding relative frequency is
// assumed to be zero (and thus, the tuple is highly reidentifiable).
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type StatisticalTable = src.StatisticalTable

// A quasi-identifier column has a custom_tag, used to know which column in
// the data corresponds to which column in the statistical model.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type StatisticalTable_QuasiIdentifierField = src.StatisticalTable_QuasiIdentifierField

// Shared message indicating Cloud storage type.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type StorageConfig = src.StorageConfig
type StorageConfig_BigQueryOptions = src.StorageConfig_BigQueryOptions
type StorageConfig_CloudStorageOptions = src.StorageConfig_CloudStorageOptions
type StorageConfig_DatastoreOptions = src.StorageConfig_DatastoreOptions
type StorageConfig_HybridOptions = src.StorageConfig_HybridOptions

// Configuration of the timespan of the items to include in scanning.
// Currently only supported when inspecting Cloud Storage and BigQuery.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type StorageConfig_TimespanConfig = src.StorageConfig_TimespanConfig

// Storage metadata label to indicate which metadata entry contains findings.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type StorageMetadataLabel = src.StorageMetadataLabel

// StoredInfoType resource message that contains information about the current
// version and any pending updates.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type StoredInfoType = src.StoredInfoType

// Configuration for stored infoTypes. All fields and subfield are provided by
// the user. For more information, see
// https://cloud.google.com/dlp/docs/creating-custom-infotypes.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type StoredInfoTypeConfig = src.StoredInfoTypeConfig
type StoredInfoTypeConfig_Dictionary = src.StoredInfoTypeConfig_Dictionary
type StoredInfoTypeConfig_LargeCustomDictionary = src.StoredInfoTypeConfig_LargeCustomDictionary
type StoredInfoTypeConfig_Regex = src.StoredInfoTypeConfig_Regex

// State of a StoredInfoType version.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type StoredInfoTypeState = src.StoredInfoTypeState

// Statistics for a StoredInfoType.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type StoredInfoTypeStats = src.StoredInfoTypeStats
type StoredInfoTypeStats_LargeCustomDictionary = src.StoredInfoTypeStats_LargeCustomDictionary

// Version of a StoredInfoType, including the configuration used to build it,
// create timestamp, and current state.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type StoredInfoTypeVersion = src.StoredInfoTypeVersion

// A reference to a StoredInfoType to use with scanning.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type StoredType = src.StoredType

// Structured content to inspect. Up to 50,000 `Value`s per request allowed.
// See
// https://cloud.google.com/dlp/docs/inspecting-structured-text#inspecting_a_table
// to learn more.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Table = src.Table

// The profile for a scanned table.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TableDataProfile = src.TableDataProfile

// Possible states of a profile. New items may be added.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TableDataProfile_State = src.TableDataProfile_State

// Location of a finding within a table.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TableLocation = src.TableLocation

// Instructions regarding the table content being inspected.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TableOptions = src.TableOptions

// Values of the row.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Table_Row = src.Table_Row

// For use with `Date`, `Timestamp`, and `TimeOfDay`, extract or preserve a
// portion of the value.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TimePartConfig = src.TimePartConfig

// Components that make up time.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TimePartConfig_TimePart = src.TimePartConfig_TimePart

// User specified templates and configs for how to deidentify structured,
// unstructures, and image files. User must provide either a unstructured
// deidentify template or at least one redact image config.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationConfig = src.TransformationConfig

// Describes functionality of a given container in its original format.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationContainerType = src.TransformationContainerType

// A flattened description of a `PrimitiveTransformation` or
// `RecordSuppression`.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationDescription = src.TransformationDescription

// Details about a single transformation. This object contains a description
// of the transformation, information about whether the transformation was
// successfully applied, and the precise location where the transformation
// occurred. These details are stored in a user-specified BigQuery table.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationDetails = src.TransformationDetails

// Config for storing transformation details.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationDetailsStorageConfig = src.TransformationDetailsStorageConfig
type TransformationDetailsStorageConfig_Table = src.TransformationDetailsStorageConfig_Table

// How to handle transformation errors during de-identification. A
// transformation error occurs when the requested transformation is
// incompatible with the data. For example, trying to de-identify an IP address
// using a `DateShift` transformation would result in a transformation error,
// since date info cannot be extracted from an IP address. Information about
// any incompatible transformations, and how they were handled, is returned in
// the response as part of the `TransformationOverviews`.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationErrorHandling = src.TransformationErrorHandling

// Skips the data without modifying it if the requested transformation would
// cause an error. For example, if a `DateShift` transformation were applied an
// an IP address, this mode would leave the IP address unchanged in the
// response.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationErrorHandling_LeaveUntransformed = src.TransformationErrorHandling_LeaveUntransformed
type TransformationErrorHandling_LeaveUntransformed_ = src.TransformationErrorHandling_LeaveUntransformed_

// Throw an error and fail the request when a transformation error occurs.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationErrorHandling_ThrowError = src.TransformationErrorHandling_ThrowError
type TransformationErrorHandling_ThrowError_ = src.TransformationErrorHandling_ThrowError_

// Specifies the location of a transformation.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationLocation = src.TransformationLocation
type TransformationLocation_FindingId = src.TransformationLocation_FindingId
type TransformationLocation_RecordTransformation = src.TransformationLocation_RecordTransformation

// Overview of the modifications that occurred.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationOverview = src.TransformationOverview
type TransformationResultStatus = src.TransformationResultStatus

// Enum of possible outcomes of transformations. SUCCESS if transformation and
// storing of transformation was successful, otherwise, reason for not
// transforming.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationResultStatusType = src.TransformationResultStatusType

// Summary of a single transformation. Only one of 'transformation',
// 'field_transformation', or 'record_suppress' will be set.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationSummary = src.TransformationSummary

// A collection that informs the user the number of times a particular
// `TransformationResultCode` and error details occurred.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationSummary_SummaryResult = src.TransformationSummary_SummaryResult

// Possible outcomes of transformations.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationSummary_TransformationResultCode = src.TransformationSummary_TransformationResultCode

// An enum of rules that can be used to transform a value. Can be a record
// suppression, or one of the transformation rules specified under
// `PrimitiveTransformation`.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransformationType = src.TransformationType

// Use this to have a random data crypto key generated. It will be discarded
// after the request finishes.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type TransientCryptoKey = src.TransientCryptoKey

// UnimplementedDlpServiceServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type UnimplementedDlpServiceServer = src.UnimplementedDlpServiceServer

// Using raw keys is prone to security risks due to accidentally leaking the
// key. Choose another type of key if possible.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type UnwrappedCryptoKey = src.UnwrappedCryptoKey

// Request message for UpdateDeidentifyTemplate.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type UpdateDeidentifyTemplateRequest = src.UpdateDeidentifyTemplateRequest

// Request message for UpdateInspectTemplate.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type UpdateInspectTemplateRequest = src.UpdateInspectTemplateRequest

// Request message for UpdateJobTrigger.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type UpdateJobTriggerRequest = src.UpdateJobTriggerRequest

// Request message for UpdateStoredInfoType.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type UpdateStoredInfoTypeRequest = src.UpdateStoredInfoTypeRequest

// Set of primitive values supported by the system. Note that for the purposes
// of inspection or transformation, the number of bytes considered to comprise
// a 'Value' is based on its representation as a UTF-8 encoded string. For
// example, if 'integer_value' is set to 123456789, the number of bytes would
// be counted as 9, even though an int64 only holds up to 8 bytes of data.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type Value = src.Value

// A value of a field, including its frequency.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type ValueFrequency = src.ValueFrequency
type Value_BooleanValue = src.Value_BooleanValue
type Value_DateValue = src.Value_DateValue
type Value_DayOfWeekValue = src.Value_DayOfWeekValue
type Value_FloatValue = src.Value_FloatValue
type Value_IntegerValue = src.Value_IntegerValue
type Value_StringValue = src.Value_StringValue
type Value_TimeValue = src.Value_TimeValue
type Value_TimestampValue = src.Value_TimestampValue

// Details about each available version for an infotype.
//
// Deprecated: Please use types in: cloud.google.com/go/dlp/apiv2/dlppb
type VersionDescription = src.VersionDescription

// Deprecated: Please use funcs in: cloud.google.com/go/dlp/apiv2/dlppb
func NewDlpServiceClient(cc grpc.ClientConnInterface) DlpServiceClient {
	return src.NewDlpServiceClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/dlp/apiv2/dlppb
func RegisterDlpServiceServer(s *grpc.Server, srv DlpServiceServer) {
	src.RegisterDlpServiceServer(s, srv)
}
