// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package contactcenterinsights provides access to the Contact Center AI Insights API.
//
// For product documentation, see: https://cloud.google.com/contact-center/insights/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/contactcenterinsights/v1"
//	...
//	ctx := context.Background()
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	contactcenterinsightsService, err := contactcenterinsights.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package contactcenterinsights // import "google.golang.org/api/contactcenterinsights/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "contactcenterinsights:v1"
const apiName = "contactcenterinsights"
const apiVersion = "v1"
const basePath = "https://contactcenterinsights.googleapis.com/"
const basePathTemplate = "https://contactcenterinsights.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://contactcenterinsights.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.AnalysisRules = NewProjectsLocationsAnalysisRulesService(s)
	rs.AssessmentRules = NewProjectsLocationsAssessmentRulesService(s)
	rs.AuthorizedViewSets = NewProjectsLocationsAuthorizedViewSetsService(s)
	rs.Conversations = NewProjectsLocationsConversationsService(s)
	rs.Datasets = NewProjectsLocationsDatasetsService(s)
	rs.EncryptionSpec = NewProjectsLocationsEncryptionSpecService(s)
	rs.Insightsdata = NewProjectsLocationsInsightsdataService(s)
	rs.IssueModels = NewProjectsLocationsIssueModelsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.PhraseMatchers = NewProjectsLocationsPhraseMatchersService(s)
	rs.QaQuestionTags = NewProjectsLocationsQaQuestionTagsService(s)
	rs.QaScorecards = NewProjectsLocationsQaScorecardsService(s)
	rs.Views = NewProjectsLocationsViewsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	AnalysisRules *ProjectsLocationsAnalysisRulesService

	AssessmentRules *ProjectsLocationsAssessmentRulesService

	AuthorizedViewSets *ProjectsLocationsAuthorizedViewSetsService

	Conversations *ProjectsLocationsConversationsService

	Datasets *ProjectsLocationsDatasetsService

	EncryptionSpec *ProjectsLocationsEncryptionSpecService

	Insightsdata *ProjectsLocationsInsightsdataService

	IssueModels *ProjectsLocationsIssueModelsService

	Operations *ProjectsLocationsOperationsService

	PhraseMatchers *ProjectsLocationsPhraseMatchersService

	QaQuestionTags *ProjectsLocationsQaQuestionTagsService

	QaScorecards *ProjectsLocationsQaScorecardsService

	Views *ProjectsLocationsViewsService
}

func NewProjectsLocationsAnalysisRulesService(s *Service) *ProjectsLocationsAnalysisRulesService {
	rs := &ProjectsLocationsAnalysisRulesService{s: s}
	return rs
}

type ProjectsLocationsAnalysisRulesService struct {
	s *Service
}

func NewProjectsLocationsAssessmentRulesService(s *Service) *ProjectsLocationsAssessmentRulesService {
	rs := &ProjectsLocationsAssessmentRulesService{s: s}
	return rs
}

type ProjectsLocationsAssessmentRulesService struct {
	s *Service
}

func NewProjectsLocationsAuthorizedViewSetsService(s *Service) *ProjectsLocationsAuthorizedViewSetsService {
	rs := &ProjectsLocationsAuthorizedViewSetsService{s: s}
	rs.AuthorizedViews = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsService(s)
	return rs
}

type ProjectsLocationsAuthorizedViewSetsService struct {
	s *Service

	AuthorizedViews *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService{s: s}
	rs.Conversations = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService(s)
	rs.Operations = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService(s)
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService struct {
	s *Service

	Conversations *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService

	Operations *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService{s: s}
	rs.Analyses = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesService(s)
	rs.Assessments = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService(s)
	rs.FeedbackLabels = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService(s)
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService struct {
	s *Service

	Analyses *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesService

	Assessments *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService

	FeedbackLabels *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesService{s: s}
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesService struct {
	s *Service
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService{s: s}
	rs.Notes = NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService(s)
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService struct {
	s *Service

	Notes *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService{s: s}
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService struct {
	s *Service
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService{s: s}
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService struct {
	s *Service
}

func NewProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService(s *Service) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService {
	rs := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService{s: s}
	return rs
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService struct {
	s *Service
}

func NewProjectsLocationsConversationsService(s *Service) *ProjectsLocationsConversationsService {
	rs := &ProjectsLocationsConversationsService{s: s}
	rs.Analyses = NewProjectsLocationsConversationsAnalysesService(s)
	rs.Assessments = NewProjectsLocationsConversationsAssessmentsService(s)
	rs.FeedbackLabels = NewProjectsLocationsConversationsFeedbackLabelsService(s)
	return rs
}

type ProjectsLocationsConversationsService struct {
	s *Service

	Analyses *ProjectsLocationsConversationsAnalysesService

	Assessments *ProjectsLocationsConversationsAssessmentsService

	FeedbackLabels *ProjectsLocationsConversationsFeedbackLabelsService
}

func NewProjectsLocationsConversationsAnalysesService(s *Service) *ProjectsLocationsConversationsAnalysesService {
	rs := &ProjectsLocationsConversationsAnalysesService{s: s}
	return rs
}

type ProjectsLocationsConversationsAnalysesService struct {
	s *Service
}

func NewProjectsLocationsConversationsAssessmentsService(s *Service) *ProjectsLocationsConversationsAssessmentsService {
	rs := &ProjectsLocationsConversationsAssessmentsService{s: s}
	rs.Notes = NewProjectsLocationsConversationsAssessmentsNotesService(s)
	return rs
}

type ProjectsLocationsConversationsAssessmentsService struct {
	s *Service

	Notes *ProjectsLocationsConversationsAssessmentsNotesService
}

func NewProjectsLocationsConversationsAssessmentsNotesService(s *Service) *ProjectsLocationsConversationsAssessmentsNotesService {
	rs := &ProjectsLocationsConversationsAssessmentsNotesService{s: s}
	return rs
}

type ProjectsLocationsConversationsAssessmentsNotesService struct {
	s *Service
}

func NewProjectsLocationsConversationsFeedbackLabelsService(s *Service) *ProjectsLocationsConversationsFeedbackLabelsService {
	rs := &ProjectsLocationsConversationsFeedbackLabelsService{s: s}
	return rs
}

type ProjectsLocationsConversationsFeedbackLabelsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsService(s *Service) *ProjectsLocationsDatasetsService {
	rs := &ProjectsLocationsDatasetsService{s: s}
	rs.Conversations = NewProjectsLocationsDatasetsConversationsService(s)
	rs.Insightsdata = NewProjectsLocationsDatasetsInsightsdataService(s)
	return rs
}

type ProjectsLocationsDatasetsService struct {
	s *Service

	Conversations *ProjectsLocationsDatasetsConversationsService

	Insightsdata *ProjectsLocationsDatasetsInsightsdataService
}

func NewProjectsLocationsDatasetsConversationsService(s *Service) *ProjectsLocationsDatasetsConversationsService {
	rs := &ProjectsLocationsDatasetsConversationsService{s: s}
	rs.Analyses = NewProjectsLocationsDatasetsConversationsAnalysesService(s)
	rs.FeedbackLabels = NewProjectsLocationsDatasetsConversationsFeedbackLabelsService(s)
	return rs
}

type ProjectsLocationsDatasetsConversationsService struct {
	s *Service

	Analyses *ProjectsLocationsDatasetsConversationsAnalysesService

	FeedbackLabels *ProjectsLocationsDatasetsConversationsFeedbackLabelsService
}

func NewProjectsLocationsDatasetsConversationsAnalysesService(s *Service) *ProjectsLocationsDatasetsConversationsAnalysesService {
	rs := &ProjectsLocationsDatasetsConversationsAnalysesService{s: s}
	return rs
}

type ProjectsLocationsDatasetsConversationsAnalysesService struct {
	s *Service
}

func NewProjectsLocationsDatasetsConversationsFeedbackLabelsService(s *Service) *ProjectsLocationsDatasetsConversationsFeedbackLabelsService {
	rs := &ProjectsLocationsDatasetsConversationsFeedbackLabelsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsConversationsFeedbackLabelsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsInsightsdataService(s *Service) *ProjectsLocationsDatasetsInsightsdataService {
	rs := &ProjectsLocationsDatasetsInsightsdataService{s: s}
	return rs
}

type ProjectsLocationsDatasetsInsightsdataService struct {
	s *Service
}

func NewProjectsLocationsEncryptionSpecService(s *Service) *ProjectsLocationsEncryptionSpecService {
	rs := &ProjectsLocationsEncryptionSpecService{s: s}
	return rs
}

type ProjectsLocationsEncryptionSpecService struct {
	s *Service
}

func NewProjectsLocationsInsightsdataService(s *Service) *ProjectsLocationsInsightsdataService {
	rs := &ProjectsLocationsInsightsdataService{s: s}
	return rs
}

type ProjectsLocationsInsightsdataService struct {
	s *Service
}

func NewProjectsLocationsIssueModelsService(s *Service) *ProjectsLocationsIssueModelsService {
	rs := &ProjectsLocationsIssueModelsService{s: s}
	rs.Issues = NewProjectsLocationsIssueModelsIssuesService(s)
	return rs
}

type ProjectsLocationsIssueModelsService struct {
	s *Service

	Issues *ProjectsLocationsIssueModelsIssuesService
}

func NewProjectsLocationsIssueModelsIssuesService(s *Service) *ProjectsLocationsIssueModelsIssuesService {
	rs := &ProjectsLocationsIssueModelsIssuesService{s: s}
	return rs
}

type ProjectsLocationsIssueModelsIssuesService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPhraseMatchersService(s *Service) *ProjectsLocationsPhraseMatchersService {
	rs := &ProjectsLocationsPhraseMatchersService{s: s}
	return rs
}

type ProjectsLocationsPhraseMatchersService struct {
	s *Service
}

func NewProjectsLocationsQaQuestionTagsService(s *Service) *ProjectsLocationsQaQuestionTagsService {
	rs := &ProjectsLocationsQaQuestionTagsService{s: s}
	return rs
}

type ProjectsLocationsQaQuestionTagsService struct {
	s *Service
}

func NewProjectsLocationsQaScorecardsService(s *Service) *ProjectsLocationsQaScorecardsService {
	rs := &ProjectsLocationsQaScorecardsService{s: s}
	rs.Revisions = NewProjectsLocationsQaScorecardsRevisionsService(s)
	return rs
}

type ProjectsLocationsQaScorecardsService struct {
	s *Service

	Revisions *ProjectsLocationsQaScorecardsRevisionsService
}

func NewProjectsLocationsQaScorecardsRevisionsService(s *Service) *ProjectsLocationsQaScorecardsRevisionsService {
	rs := &ProjectsLocationsQaScorecardsRevisionsService{s: s}
	rs.QaQuestions = NewProjectsLocationsQaScorecardsRevisionsQaQuestionsService(s)
	return rs
}

type ProjectsLocationsQaScorecardsRevisionsService struct {
	s *Service

	QaQuestions *ProjectsLocationsQaScorecardsRevisionsQaQuestionsService
}

func NewProjectsLocationsQaScorecardsRevisionsQaQuestionsService(s *Service) *ProjectsLocationsQaScorecardsRevisionsQaQuestionsService {
	rs := &ProjectsLocationsQaScorecardsRevisionsQaQuestionsService{s: s}
	return rs
}

type ProjectsLocationsQaScorecardsRevisionsQaQuestionsService struct {
	s *Service
}

func NewProjectsLocationsViewsService(s *Service) *ProjectsLocationsViewsService {
	rs := &ProjectsLocationsViewsService{s: s}
	return rs
}

type ProjectsLocationsViewsService struct {
	s *Service
}

// GoogleCloudContactcenterinsightsV1Analysis: The analysis resource.
type GoogleCloudContactcenterinsightsV1Analysis struct {
	// AnalysisResult: Output only. The result of the analysis, which is populated
	// when the analysis finishes.
	AnalysisResult *GoogleCloudContactcenterinsightsV1AnalysisResult `json:"analysisResult,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// CreateTime: Output only. The time at which the analysis was created, which
	// occurs when the long-running operation completes.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Immutable. The resource name of the analysis. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/analyses
	// /{analysis}
	Name string `json:"name,omitempty"`
	// RequestTime: Output only. The time at which the analysis was requested.
	RequestTime string `json:"requestTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnalysisResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Analysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Analysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnalysisResult: The result of an analysis.
type GoogleCloudContactcenterinsightsV1AnalysisResult struct {
	// CallAnalysisMetadata: Call-specific metadata created by the analysis.
	CallAnalysisMetadata *GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata `json:"callAnalysisMetadata,omitempty"`
	// EndTime: The time at which the analysis ended.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CallAnalysisMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CallAnalysisMetadata") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata:
// Call-specific metadata created during analysis.
type GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata struct {
	// Annotations: A list of call annotations that apply to this call.
	Annotations []*GoogleCloudContactcenterinsightsV1CallAnnotation `json:"annotations,omitempty"`
	// Entities: All the entities in the call.
	Entities map[string]GoogleCloudContactcenterinsightsV1Entity `json:"entities,omitempty"`
	// Intents: All the matched intents in the call.
	Intents map[string]GoogleCloudContactcenterinsightsV1Intent `json:"intents,omitempty"`
	// IssueModelResult: Overall conversation-level issue modeling result.
	IssueModelResult *GoogleCloudContactcenterinsightsV1IssueModelResult `json:"issueModelResult,omitempty"`
	// PhraseMatchers: All the matched phrase matchers in the call.
	PhraseMatchers map[string]GoogleCloudContactcenterinsightsV1PhraseMatchData `json:"phraseMatchers,omitempty"`
	// QaScorecardResults: Results of scoring QaScorecards.
	QaScorecardResults []*GoogleCloudContactcenterinsightsV1QaScorecardResult `json:"qaScorecardResults,omitempty"`
	// Sentiments: Overall conversation-level sentiment for each channel of the
	// call.
	Sentiments []*GoogleCloudContactcenterinsightsV1ConversationLevelSentiment `json:"sentiments,omitempty"`
	// Silence: Overall conversation-level silence during the call.
	Silence *GoogleCloudContactcenterinsightsV1ConversationLevelSilence `json:"silence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnalysisRule: The CCAI Insights project
// wide analysis rule. This rule will be applied to all conversations that
// match the filter defined in the rule. For a conversation matches the filter,
// the annotators specified in the rule will be run. If a conversation matches
// multiple rules, a union of all the annotators will be run. One project can
// have multiple analysis rules.
type GoogleCloudContactcenterinsightsV1AnalysisRule struct {
	// Active: If true, apply this rule to conversations. Otherwise, this rule is
	// inactive and saved as a draft.
	Active bool `json:"active,omitempty"`
	// AnalysisPercentage: Percentage of conversations that we should apply this
	// analysis setting automatically, between [0, 1]. For example, 0.1 means 10%.
	// Conversations are sampled in a determenestic way. The original
	// runtime_percentage & upload percentage will be replaced by defining filters
	// on the conversation.
	AnalysisPercentage float64 `json:"analysisPercentage,omitempty"`
	// AnnotatorSelector: Selector of annotators to run and the phrase matchers to
	// use for conversations that matches the conversation_filter. If not
	// specified, NO annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// ConversationFilter: Filter for the conversations that should apply this
	// analysis rule. An empty filter means this analysis rule applies to all
	// conversations. Refer to
	// https://cloud.google.com/contact-center/insights/docs/filtering for details.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// CreateTime: Output only. The time at which this analysis rule was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Display Name of the analysis rule.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The resource name of the analysis rule. Format:
	// projects/{project}/locations/{location}/analysisRules/{analysis_rule}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The most recent time at which this analysis rule
	// was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Active") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnalysisRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1AnalysisRule) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1AnalysisRule
	var s1 struct {
		AnalysisPercentage gensupport.JSONFloat64 `json:"analysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnalysisPercentage = float64(s1.AnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1AnnotationBoundary: A point in a
// conversation that marks the start or the end of an annotation.
type GoogleCloudContactcenterinsightsV1AnnotationBoundary struct {
	// TranscriptIndex: The index in the sequence of transcribed pieces of the
	// conversation where the boundary is located. This index starts at zero.
	TranscriptIndex int64 `json:"transcriptIndex,omitempty"`
	// WordIndex: The word index of this boundary with respect to the first word in
	// the transcript piece. This index starts at zero.
	WordIndex int64 `json:"wordIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptIndex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotationBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotationBoundary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelector: Selector of all
// available annotators and phrase matchers to run.
type GoogleCloudContactcenterinsightsV1AnnotatorSelector struct {
	// IssueModels: The issue model to run. If not provided, the most recently
	// deployed topic model will be used. The provided issue model will only be
	// used for inference if the issue model is deployed and if
	// run_issue_model_annotator is set to true. If more than one issue model is
	// provided, only the first provided issue model will be used for inference.
	IssueModels []string `json:"issueModels,omitempty"`
	// PhraseMatchers: The list of phrase matchers to run. If not provided, all
	// active phrase matchers will be used. If inactive phrase matchers are
	// provided, they will not be used. Phrase matchers will be run only if
	// run_phrase_matcher_annotator is set to true. Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
	PhraseMatchers []string `json:"phraseMatchers,omitempty"`
	// QaConfig: Configuration for the QA annotator.
	QaConfig *GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig `json:"qaConfig,omitempty"`
	// RunEntityAnnotator: Whether to run the entity annotator.
	RunEntityAnnotator bool `json:"runEntityAnnotator,omitempty"`
	// RunIntentAnnotator: Whether to run the intent annotator.
	RunIntentAnnotator bool `json:"runIntentAnnotator,omitempty"`
	// RunInterruptionAnnotator: Whether to run the interruption annotator.
	RunInterruptionAnnotator bool `json:"runInterruptionAnnotator,omitempty"`
	// RunIssueModelAnnotator: Whether to run the issue model annotator. A model
	// should have already been deployed for this to take effect.
	RunIssueModelAnnotator bool `json:"runIssueModelAnnotator,omitempty"`
	// RunPhraseMatcherAnnotator: Whether to run the active phrase matcher
	// annotator(s).
	RunPhraseMatcherAnnotator bool `json:"runPhraseMatcherAnnotator,omitempty"`
	// RunQaAnnotator: Whether to run the QA annotator.
	RunQaAnnotator bool `json:"runQaAnnotator,omitempty"`
	// RunSentimentAnnotator: Whether to run the sentiment annotator.
	RunSentimentAnnotator bool `json:"runSentimentAnnotator,omitempty"`
	// RunSilenceAnnotator: Whether to run the silence annotator.
	RunSilenceAnnotator bool `json:"runSilenceAnnotator,omitempty"`
	// RunSummarizationAnnotator: Whether to run the summarization annotator.
	RunSummarizationAnnotator bool `json:"runSummarizationAnnotator,omitempty"`
	// SummarizationConfig: Configuration for the summarization annotator.
	SummarizationConfig *GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig `json:"summarizationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig: Configuration
// for the QA feature.
type GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig struct {
	// ScorecardList: A manual list of scorecards to score.
	ScorecardList *GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList `json:"scorecardList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScorecardList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScorecardList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList:
// Container for a list of scorecards.
type GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList struct {
	// QaScorecardRevisions: List of QaScorecardRevisions.
	QaScorecardRevisions []string `json:"qaScorecardRevisions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaScorecardRevisions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaScorecardRevisions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig:
// Configuration for summarization.
type GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig struct {
	// ConversationProfile: Resource name of the Dialogflow conversation profile.
	// Format:
	// projects/{project}/locations/{location}/conversationProfiles/{conversation_pr
	// ofile}
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// Generator: The resource name of the existing created generator. Format:
	// projects//locations//generators/
	Generator string `json:"generator,omitempty"`
	// SummarizationModel: Default summarization model to be used.
	//
	// Possible values:
	//   "SUMMARIZATION_MODEL_UNSPECIFIED" - Unspecified summarization model.
	//   "BASELINE_MODEL" - The CCAI baseline model. This model is deprecated and
	// will be removed in the future. We recommend using `generator` instead.
	//   "BASELINE_MODEL_V2_0" - The CCAI baseline model, V2.0. This model is
	// deprecated and will be removed in the future. We recommend using `generator`
	// instead.
	SummarizationModel string `json:"summarizationModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AnswerFeedback: The feedback that the
// customer has about a certain answer in the conversation.
type GoogleCloudContactcenterinsightsV1AnswerFeedback struct {
	// Clicked: Indicates whether an answer or item was clicked by the human agent.
	Clicked bool `json:"clicked,omitempty"`
	// CorrectnessLevel: The correctness level of an answer.
	//
	// Possible values:
	//   "CORRECTNESS_LEVEL_UNSPECIFIED" - Correctness level unspecified.
	//   "NOT_CORRECT" - Answer is totally wrong.
	//   "PARTIALLY_CORRECT" - Answer is partially correct.
	//   "FULLY_CORRECT" - Answer is fully correct.
	CorrectnessLevel string `json:"correctnessLevel,omitempty"`
	// Displayed: Indicates whether an answer or item was displayed to the human
	// agent in the agent desktop UI.
	Displayed bool `json:"displayed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clicked") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clicked") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AnswerFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AppealAssessmentRequest: The message to
// appeal an assessment.
type GoogleCloudContactcenterinsightsV1AppealAssessmentRequest struct {
}

// GoogleCloudContactcenterinsightsV1ArticleSuggestionData: Agent Assist
// Article Suggestion data.
type GoogleCloudContactcenterinsightsV1ArticleSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this article is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Article Suggestion and the
	// document that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}
	Source string `json:"source,omitempty"`
	// Title: Article title.
	Title string `json:"title,omitempty"`
	// Uri: Article URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ArticleSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ArticleSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ArticleSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ArticleSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1Assessment: The assessment resource.
type GoogleCloudContactcenterinsightsV1Assessment struct {
	// AgentInfo: Information about the agent the assessment is for.
	AgentInfo *GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo `json:"agentInfo,omitempty"`
	// CreateTime: Output only. The time at which the assessment was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The resource name of the assessment. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/assessme
	// nts/{assessment}
	Name string `json:"name,omitempty"`
	// State: Output only. The state of the assessment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The state is unspecified. This value should not be
	// used.
	//   "DRAFT" - The default state of all new assessments.
	//   "PUBLISHED" - The assessment has been published.
	//   "APPEALED" - The assessment has been appealed.
	//   "FINALIZED" - The assessment has been finalized.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. The time at which the assessment was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Assessment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Assessment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AssessmentRule: The CCAI Insights project
// wide assessment rule. This assessment rule will be applied to all
// conversations from the previous sampling cycle that match the sample rule
// defined in the assessment rule. One project can have multiple assessment
// rules.
type GoogleCloudContactcenterinsightsV1AssessmentRule struct {
	// Active: If true, apply this rule to conversations. Otherwise, this rule is
	// inactive.
	Active bool `json:"active,omitempty"`
	// CreateTime: Output only. The time at which this assessment rule was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Display Name of the assessment rule.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The resource name of the assessment rule. Format:
	// projects/{project}/locations/{location}/assessmentRules/{assessment_rule}
	Name string `json:"name,omitempty"`
	// SampleRule: The sample rule for the assessment rule.
	SampleRule *GoogleCloudContactcenterinsightsV1SampleRule `json:"sampleRule,omitempty"`
	// ScheduleInfo: Schedule info for the assessment rule.
	ScheduleInfo *GoogleCloudContactcenterinsightsV1ScheduleInfo `json:"scheduleInfo,omitempty"`
	// UpdateTime: Output only. The most recent time at which this assessment rule
	// was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Active") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AssessmentRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AssessmentRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AuthorizedView: An AuthorizedView
// represents a view of accessible Insights resources (for example,
// Conversation and Scorecard). Who have read access to the AuthorizedView
// resource will have access to these Insight resources as well.
type GoogleCloudContactcenterinsightsV1AuthorizedView struct {
	// ConversationFilter: A filter to reduce conversation results to a specific
	// subset. The AuthorizedView's assigned permission (read/write) could be
	// applied to the subset of conversations. If conversation_filter is empty,
	// there is no restriction on the conversations that the AuthorizedView can
	// access. Having *authorizedViews.get* access to the AuthorizedView means
	// having the same read/write access to the Conversations (as well as
	// metadata/annotations linked to the conversation) that this AuthorizedView
	// has.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// CreateTime: Output only. The time at which the authorized view was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Display Name. Limit 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The resource name of the AuthorizedView. Format:
	// projects/{project}/locations/{location}/authorizedViewSets/{authorized_view_s
	// et}/authorizedViews/{authorized_view}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The most recent time at which the authorized view
	// was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversationFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationFilter") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AuthorizedView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AuthorizedView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1AuthorizedViewSet: An AuthorizedViewSet
// contains a set of AuthorizedView resources.
type GoogleCloudContactcenterinsightsV1AuthorizedViewSet struct {
	// CreateTime: Output only. Create time.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Display Name. Limit 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The resource name of the AuthorizedViewSet. Format:
	// projects/{project}/locations/{location}/authorizedViewSets/{authorized_view_s
	// et}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Update time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1AuthorizedViewSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1AuthorizedViewSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata: The
// metadata for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata struct {
	// CompletedAnalysesCount: The number of requested analyses that have completed
	// successfully so far.
	CompletedAnalysesCount int64 `json:"completedAnalysesCount,omitempty"`
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedAnalysesCount: The number of requested analyses that have failed so
	// far.
	FailedAnalysesCount int64 `json:"failedAnalysesCount,omitempty"`
	// PartialErrors: Output only. Partial errors during bulk analyze operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk analyze.
	Request *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest `json:"request,omitempty"`
	// TotalRequestedAnalysesCount: Total number of analyses requested. Computed by
	// the number of conversations returned by `filter` multiplied by
	// `analysis_percentage` in the request.
	TotalRequestedAnalysesCount int64 `json:"totalRequestedAnalysesCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest: The
// request to analyze conversations in bulk.
type GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest struct {
	// AnalysisPercentage: Required. Percentage of selected conversation to
	// analyze, between [0, 100].
	AnalysisPercentage float64 `json:"analysisPercentage,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Filter: Required. Filter used to select the subset of conversations to
	// analyze.
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource to create analyses in.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisPercentage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisPercentage") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest
	var s1 struct {
		AnalysisPercentage gensupport.JSONFloat64 `json:"analysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnalysisPercentage = float64(s1.AnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse: The
// response for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse struct {
	// FailedAnalysisCount: Count of failed analyses.
	FailedAnalysisCount int64 `json:"failedAnalysisCount,omitempty"`
	// SuccessfulAnalysisCount: Count of successful analyses.
	SuccessfulAnalysisCount int64 `json:"successfulAnalysisCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedAnalysisCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedAnalysisCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata: The
// metadata for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during bulk delete conversations operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk delete.
	Request *GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest: The
// request to delete conversations in bulk.
type GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest struct {
	// Filter: Filter used to select the subset of conversations to delete.
	Filter string `json:"filter,omitempty"`
	// Force: If set to true, all of this conversation's analyses will also be
	// deleted. Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `json:"force,omitempty"`
	// MaxDeleteCount: Maximum number of conversations to delete.
	MaxDeleteCount int64 `json:"maxDeleteCount,omitempty"`
	// Parent: Required. The parent resource to delete conversations from. Format:
	// projects/{project}/locations/{location}
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteConversationsResponse: The
// response for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1BulkDeleteConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsMetadata: Metadata
// for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsMetadata struct {
	// PartialErrors: Partial errors during deletion operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for delete.
	Request *GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PartialErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PartialErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest: Request
// for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest struct {
	// Filter: Optional. A filter to reduce results to a specific subset. Supports
	// disjunctions (OR) and conjunctions (AND). Supported fields: *
	// `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time`
	// * `max_create_time` * `min_update_time` * `max_update_time` *
	// `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource for new feedback labels.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsResponse: Response
// for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsResponse struct {
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata:
// Metadata for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DownloadStats: Output only. Statistics for BulkDownloadFeedbackLabels
	// operation.
	DownloadStats *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats `json:"downloadStats,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during ingest operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for download.
	Request *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadS
// tats: Statistics for BulkDownloadFeedbackLabels operation.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats struct {
	// FileNames: Output only. Full name of the files written to Cloud storage.
	FileNames []string `json:"fileNames,omitempty"`
	// ProcessedObjectCount: The number of objects processed during the download
	// operation.
	ProcessedObjectCount int64 `json:"processedObjectCount,omitempty"`
	// SuccessfulDownloadCount: The number of new feedback labels downloaded during
	// this operation. Different from "processed" because some labels might not be
	// downloaded because an error.
	SuccessfulDownloadCount int64 `json:"successfulDownloadCount,omitempty"`
	// TotalFilesWritten: Total number of files written to the provided Cloud
	// Storage bucket.
	TotalFilesWritten int64 `json:"totalFilesWritten,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest: Request
// for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest struct {
	// ConversationFilter: Optional. Filter parent conversations to download
	// feedback labels for. When specified, the feedback labels will be downloaded
	// for the conversations that match the filter. If `template_qa_scorecard_id`
	// is set, all the conversations that match the filter will be paired with the
	// questions under the scorecard for labeling.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// FeedbackLabelType: Optional. The type of feedback labels that will be
	// downloaded.
	//
	// Possible values:
	//   "FEEDBACK_LABEL_TYPE_UNSPECIFIED" - Unspecified format
	//   "QUALITY_AI" - Downloaded file will contain all Quality AI labels from the
	// latest scorecard revision.
	//   "TOPIC_MODELING" - Downloaded file will contain only Topic Modeling
	// labels.
	//   "AGENT_ASSIST_SUMMARY" - Agent Assist Summarization labels.
	FeedbackLabelType string `json:"feedbackLabelType,omitempty"`
	// Filter: Optional. A filter to reduce results to a specific subset. Supports
	// disjunctions (OR) and conjunctions (AND). Supported fields: *
	// `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time`
	// * `max_create_time` * `min_update_time` * `max_update_time` *
	// `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `json:"filter,omitempty"`
	// GcsDestination: A cloud storage bucket destination.
	GcsDestination *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination `json:"gcsDestination,omitempty"`
	// MaxDownloadCount: Optional. Limits the maximum number of feedback labels
	// that will be downloaded. The first `N` feedback labels will be downloaded.
	MaxDownloadCount int64 `json:"maxDownloadCount,omitempty"`
	// Parent: Required. The parent resource for new feedback labels.
	Parent string `json:"parent,omitempty"`
	// SheetsDestination: A sheets document destination.
	SheetsDestination *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDestination `json:"sheetsDestination,omitempty"`
	// TemplateQaScorecardId: Optional. If set, a template for labeling
	// conversations and scorecard questions will be created from the
	// conversation_filter and the questions under the scorecard(s). The feedback
	// label `filter` will be ignored.
	TemplateQaScorecardId []string `json:"templateQaScorecardId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationFilter") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestina
// tion: Google Cloud Storage Object details to write the feedback labels to.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination struct {
	// AddWhitespace: Optional. Add whitespace to the JSON file. Makes easier to
	// read, but increases file size. Only applicable for JSON format.
	AddWhitespace bool `json:"addWhitespace,omitempty"`
	// AlwaysPrintEmptyFields: Optional. Always print fields with no presence. This
	// is useful for printing fields that are not set, like implicit 0 value or
	// empty lists/maps. Only applicable for JSON format.
	AlwaysPrintEmptyFields bool `json:"alwaysPrintEmptyFields,omitempty"`
	// Format: Required. File format in which the labels will be exported.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Unspecified format.
	//   "CSV" - CSV format. 1,000 labels are stored per CSV file by default.
	//   "JSON" - JSON format. 1 label stored per JSON file by default.
	Format string `json:"format,omitempty"`
	// ObjectUri: Required. The Google Cloud Storage URI to write the feedback
	// labels to. The file name will be used as a prefix for the files written to
	// the bucket if the output needs to be split across multiple files, otherwise
	// it will be used as is. The file extension will be appended to the file name
	// based on the format selected. E.g. `gs://bucket_name/object_uri_prefix`
	ObjectUri string `json:"objectUri,omitempty"`
	// RecordsPerFileCount: Optional. The number of records per file. Applicable
	// for either format.
	RecordsPerFileCount int64 `json:"recordsPerFileCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AddWhitespace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddWhitespace") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDest
// ination: Google Sheets document details to write the feedback labels to.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDestination struct {
	// SheetTitle: Optional. The title of the new sheet to write the feedback
	// labels to.
	SheetTitle string `json:"sheetTitle,omitempty"`
	// SpreadsheetUri: Required. The Google Sheets document to write the feedback
	// labels to. Retrieved from Google Sheets URI. E.g.
	// `https://docs.google.com/spreadsheets/d/1234567890` The spreadsheet must be
	// shared with the Insights P4SA. The spreadsheet ID written to will be
	// returned as `file_names` in the BulkDownloadFeedbackLabelsMetadata.
	SpreadsheetUri string `json:"spreadsheetUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SheetTitle") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SheetTitle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsResponse:
// Response for the BulkDownloadFeedbackLabel endpoint.
type GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsResponse struct {
}

// GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest: The
// request for bulk uploading feedback labels.
type GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest struct {
	// GcsSource: A cloud storage bucket source.
	GcsSource *GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource `json:"gcsSource,omitempty"`
	// SheetsSource: A sheets document source.
	SheetsSource *GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource `json:"sheetsSource,omitempty"`
	// ValidateOnly: Optional. If set, upload will not happen and the labels will
	// be validated. If not set, then default behavior will be to upload the labels
	// after validation is complete.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource:
// Google Cloud Storage Object details to get the feedback label file from.
type GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource struct {
	// Format: Required. File format which will be ingested.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Unspecified format.
	//   "CSV" - CSV format.
	//   "JSON" - JSON format.
	Format string `json:"format,omitempty"`
	// ObjectUri: Required. The Google Cloud Storage URI of the file to import.
	// Format: `gs://bucket_name/object_name`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Format") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource
// : Google Sheets document details to get the feedback label file from.
type GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource struct {
	// SpreadsheetUri: Required. The Google Sheets document to write the feedback
	// labels to. Retrieved from Google Sheets URI. E.g.
	// `https://docs.google.com/spreadsheets/d/1234567890` The spreadsheet must be
	// shared with the Insights P4SA.
	SpreadsheetUri string `json:"spreadsheetUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SpreadsheetUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SpreadsheetUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse: Response
// of querying an issue model's statistics.
type GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse struct {
	// CurrentStats: The latest label statistics for the queried issue model.
	// Includes results on both training data and data labeled after deployment.
	CurrentStats *GoogleCloudContactcenterinsightsV1IssueModelLabelStats `json:"currentStats,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CurrentStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentStats") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsRequest: The request for
// calculating conversation statistics.
type GoogleCloudContactcenterinsightsV1CalculateStatsRequest struct {
	// Filter: A filter to reduce results to a specific subset. This field is
	// useful for getting statistics about conversations with specific properties.
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateStatsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponse: The response for
// calculating conversation statistics.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponse struct {
	// AverageDuration: The average duration of all conversations. The average is
	// calculated using only conversations that have a time duration.
	AverageDuration string `json:"averageDuration,omitempty"`
	// AverageTurnCount: The average number of turns per conversation.
	AverageTurnCount int64 `json:"averageTurnCount,omitempty"`
	// ConversationCount: The total number of conversations.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// ConversationCountTimeSeries: A time series representing the count of
	// conversations created over time that match that requested filter criteria.
	ConversationCountTimeSeries *GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries `json:"conversationCountTimeSeries,omitempty"`
	// CustomHighlighterMatches: A map associating each custom highlighter resource
	// name with its respective number of matches in the set of conversations.
	CustomHighlighterMatches map[string]int64 `json:"customHighlighterMatches,omitempty"`
	// IssueMatches: A map associating each issue resource name with its respective
	// number of matches in the set of conversations. Key has the format:
	// `projects//locations//issueModels//issues/` Deprecated, use
	// `issue_matches_stats` field instead.
	IssueMatches map[string]int64 `json:"issueMatches,omitempty"`
	// IssueMatchesStats: A map associating each issue resource name with its
	// respective number of matches in the set of conversations. Key has the
	// format: `projects//locations//issueModels//issues/`
	IssueMatchesStats map[string]GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats `json:"issueMatchesStats,omitempty"`
	// SmartHighlighterMatches: A map associating each smart highlighter display
	// name with its respective number of matches in the set of conversations.
	SmartHighlighterMatches map[string]int64 `json:"smartHighlighterMatches,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AverageDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries: A time
// series representing conversations over time.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries struct {
	// IntervalDuration: The duration of each interval.
	IntervalDuration string `json:"intervalDuration,omitempty"`
	// Points: An ordered list of intervals from earliest to latest, where each
	// interval represents the number of conversations that transpired during the
	// time window.
	Points []*GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval `json:"points,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntervalDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntervalDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval:
// A single interval in a time series.
type GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval struct {
	// ConversationCount: The number of conversations created in this interval.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// StartTime: The start time of this interval.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CallAnnotation: A piece of metadata that
// applies to a window of a call.
type GoogleCloudContactcenterinsightsV1CallAnnotation struct {
	// AnnotationEndBoundary: The boundary in the conversation where the annotation
	// ends, inclusive.
	AnnotationEndBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"annotationEndBoundary,omitempty"`
	// AnnotationStartBoundary: The boundary in the conversation where the
	// annotation starts, inclusive.
	AnnotationStartBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"annotationStartBoundary,omitempty"`
	// ChannelTag: The channel of the audio where the annotation occurs. For
	// single-channel audio, this field is not populated.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// EntityMentionData: Data specifying an entity mention.
	EntityMentionData *GoogleCloudContactcenterinsightsV1EntityMentionData `json:"entityMentionData,omitempty"`
	// HoldData: Data specifying a hold.
	HoldData *GoogleCloudContactcenterinsightsV1HoldData `json:"holdData,omitempty"`
	// IntentMatchData: Data specifying an intent match.
	IntentMatchData *GoogleCloudContactcenterinsightsV1IntentMatchData `json:"intentMatchData,omitempty"`
	// InterruptionData: Data specifying an interruption.
	InterruptionData *GoogleCloudContactcenterinsightsV1InterruptionData `json:"interruptionData,omitempty"`
	// IssueMatchData: Data specifying an issue match.
	IssueMatchData *GoogleCloudContactcenterinsightsV1IssueMatchData `json:"issueMatchData,omitempty"`
	// PhraseMatchData: Data specifying a phrase match.
	PhraseMatchData *GoogleCloudContactcenterinsightsV1PhraseMatchData `json:"phraseMatchData,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentimentData,omitempty"`
	// SilenceData: Data specifying silence.
	SilenceData *GoogleCloudContactcenterinsightsV1SilenceData `json:"silenceData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CallAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CallAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Conversation: The conversation resource.
type GoogleCloudContactcenterinsightsV1Conversation struct {
	// AgentId: An opaque, user-specified string representing the human agent who
	// handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// CallMetadata: Call-specific metadata.
	CallMetadata *GoogleCloudContactcenterinsightsV1ConversationCallMetadata `json:"callMetadata,omitempty"`
	// CreateTime: Output only. The time at which the conversation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataSource: The source of the audio and transcription for the conversation.
	DataSource *GoogleCloudContactcenterinsightsV1ConversationDataSource `json:"dataSource,omitempty"`
	// DialogflowIntents: Output only. All the matched Dialogflow intents in the
	// call. The key corresponds to a Dialogflow intent, format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntents map[string]GoogleCloudContactcenterinsightsV1DialogflowIntent `json:"dialogflowIntents,omitempty"`
	// Duration: Output only. The duration of the conversation.
	Duration string `json:"duration,omitempty"`
	// ExpireTime: The time at which this conversation should expire. After this
	// time, the conversation data and any associated analyses will be deleted.
	ExpireTime string `json:"expireTime,omitempty"`
	// Labels: A map for the user to specify any custom fields. A maximum of 100
	// labels per conversation is allowed, with a maximum of 256 characters per
	// entry.
	Labels map[string]string `json:"labels,omitempty"`
	// LanguageCode: A user-specified language code for the conversation.
	LanguageCode string `json:"languageCode,omitempty"`
	// LatestAnalysis: Output only. The conversation's latest analysis, if one
	// exists.
	LatestAnalysis *GoogleCloudContactcenterinsightsV1Analysis `json:"latestAnalysis,omitempty"`
	// LatestSummary: Output only. Latest summary of the conversation.
	LatestSummary *GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData `json:"latestSummary,omitempty"`
	// Medium: Immutable. The conversation medium, if unspecified will default to
	// PHONE_CALL.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// MetadataJson: Input only. JSON metadata encoded as a string. This field is
	// primarily used by Insights integrations with various telephony systems and
	// must be in one of Insight's supported formats.
	MetadataJson string `json:"metadataJson,omitempty"`
	// Name: Immutable. The resource name of the conversation. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	Name string `json:"name,omitempty"`
	// ObfuscatedUserId: Obfuscated user ID which the customer sent to us.
	ObfuscatedUserId string `json:"obfuscatedUserId,omitempty"`
	// QualityMetadata: Conversation metadata related to quality management.
	QualityMetadata *GoogleCloudContactcenterinsightsV1ConversationQualityMetadata `json:"qualityMetadata,omitempty"`
	// RuntimeAnnotations: Output only. The annotations that were generated during
	// the customer and agent interaction.
	RuntimeAnnotations []*GoogleCloudContactcenterinsightsV1RuntimeAnnotation `json:"runtimeAnnotations,omitempty"`
	// StartTime: The time at which the conversation started.
	StartTime string `json:"startTime,omitempty"`
	// Transcript: Output only. The conversation transcript.
	Transcript *GoogleCloudContactcenterinsightsV1ConversationTranscript `json:"transcript,omitempty"`
	// Ttl: Input only. The TTL for this resource. If specified, then this TTL will
	// be used to calculate the expire time.
	Ttl string `json:"ttl,omitempty"`
	// TurnCount: Output only. The number of turns in the conversation.
	TurnCount int64 `json:"turnCount,omitempty"`
	// UpdateTime: Output only. The most recent time at which the conversation was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationCallMetadata: Call-specific
// metadata.
type GoogleCloudContactcenterinsightsV1ConversationCallMetadata struct {
	// AgentChannel: The audio channel that contains the agent.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// CustomerChannel: The audio channel that contains the customer.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationCallMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationCallMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationDataSource: The conversation
// source, which is a combination of transcript and audio.
type GoogleCloudContactcenterinsightsV1ConversationDataSource struct {
	// DialogflowSource: The source when the conversation comes from Dialogflow.
	DialogflowSource *GoogleCloudContactcenterinsightsV1DialogflowSource `json:"dialogflowSource,omitempty"`
	// GcsSource: A Cloud Storage location specification for the audio and
	// transcript.
	GcsSource *GoogleCloudContactcenterinsightsV1GcsSource `json:"gcsSource,omitempty"`
	// MetadataUri: Cloud Storage URI that points to a file that contains the
	// conversation metadata.
	MetadataUri string `json:"metadataUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationDataSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationLevelSentiment: One channel of
// conversation-level sentiment data.
type GoogleCloudContactcenterinsightsV1ConversationLevelSentiment struct {
	// ChannelTag: The channel of the audio that the data applies to.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentimentData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationLevelSentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationLevelSentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationLevelSilence:
// Conversation-level silence data.
type GoogleCloudContactcenterinsightsV1ConversationLevelSilence struct {
	// SilenceDuration: Amount of time calculated to be in silence.
	SilenceDuration string `json:"silenceDuration,omitempty"`
	// SilencePercentage: Percentage of the total conversation spent in silence.
	SilencePercentage float64 `json:"silencePercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SilenceDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SilenceDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationLevelSilence) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationLevelSilence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationLevelSilence) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationLevelSilence
	var s1 struct {
		SilencePercentage gensupport.JSONFloat64 `json:"silencePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SilencePercentage = float64(s1.SilencePercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1ConversationParticipant: The call
// participant speaking for a given utterance.
type GoogleCloudContactcenterinsightsV1ConversationParticipant struct {
	// DialogflowParticipant: Deprecated. Use `dialogflow_participant_name`
	// instead. The name of the Dialogflow participant. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipant string `json:"dialogflowParticipant,omitempty"`
	// DialogflowParticipantName: The name of the participant provided by
	// Dialogflow. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipantName string `json:"dialogflowParticipantName,omitempty"`
	// ObfuscatedExternalUserId: Obfuscated user ID from Dialogflow.
	ObfuscatedExternalUserId string `json:"obfuscatedExternalUserId,omitempty"`
	// Role: The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	Role string `json:"role,omitempty"`
	// UserId: A user-specified ID representing the participant.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowParticipant") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowParticipant") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationParticipant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationParticipant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationQualityMetadata: Conversation
// metadata related to quality management.
type GoogleCloudContactcenterinsightsV1ConversationQualityMetadata struct {
	// AgentInfo: Information about agents involved in the call.
	AgentInfo []*GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo `json:"agentInfo,omitempty"`
	// CustomerSatisfactionRating: An arbitrary integer value indicating the
	// customer's satisfaction rating.
	CustomerSatisfactionRating int64 `json:"customerSatisfactionRating,omitempty"`
	// FeedbackLabels: Input only. The feedback labels associated with the
	// conversation.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// MenuPath: An arbitrary string value specifying the menu path the customer
	// took.
	MenuPath string `json:"menuPath,omitempty"`
	// WaitDuration: The amount of time the customer waited to connect with an
	// agent.
	WaitDuration string `json:"waitDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationQualityMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationQualityMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo:
// Information about an agent involved in the conversation.
type GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo struct {
	// AgentId: A user-specified string representing the agent.
	AgentId string `json:"agentId,omitempty"`
	// AgentType: The agent type, e.g. HUMAN_AGENT.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	AgentType string `json:"agentType,omitempty"`
	// DisplayName: The agent's name.
	DisplayName string `json:"displayName,omitempty"`
	// DispositionCode: A user-provided string indicating the outcome of the
	// agent's segment of the call.
	DispositionCode string `json:"dispositionCode,omitempty"`
	// Location: The agent's location.
	Location string `json:"location,omitempty"`
	// Team: A user-specified string representing the agent's team. Deprecated in
	// favor of the `teams` field.
	Team string `json:"team,omitempty"`
	// Teams: User-specified strings representing the agent's teams.
	Teams []string `json:"teams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData:
// Conversation summarization suggestion data.
type GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData struct {
	// AnswerRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: The confidence score of the summarization.
	Confidence float64 `json:"confidence,omitempty"`
	// ConversationModel: The name of the model that generates this summary.
	// Format:
	// projects/{project}/locations/{location}/conversationModels/{conversation_mode
	// l}
	ConversationModel string `json:"conversationModel,omitempty"`
	// GeneratorId: Agent Assist generator ID.
	GeneratorId string `json:"generatorId,omitempty"`
	// Metadata: A map that contains metadata about the summarization and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Text: The summarization content that is concatenated into one string.
	Text string `json:"text,omitempty"`
	// TextSections: The summarization content that is divided into sections. The
	// key is the section's name and the value is the section's content. There is
	// no specific format for the key or value.
	TextSections map[string]string `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1ConversationTranscript: A message
// representing the transcript of a conversation.
type GoogleCloudContactcenterinsightsV1ConversationTranscript struct {
	// TranscriptSegments: A list of sequential transcript segments that comprise
	// the conversation.
	TranscriptSegments []*GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment `json:"transcriptSegments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptSegments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptSegments") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscript
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment: A
// segment of a full transcript.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment struct {
	// ChannelTag: For conversations derived from multi-channel audio, this is the
	// channel number corresponding to the audio from that channel. For
	// audioChannelCount = N, its output values can range from '1' to 'N'. A
	// channel tag of 0 indicates that the audio is mono.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this segment. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowSegmentMetadata: CCAI metadata relating to the current transcript
	// segment.
	DialogflowSegmentMetadata *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata `json:"dialogflowSegmentMetadata,omitempty"`
	// LanguageCode: The language code of this segment as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// MessageTime: The time that the message occurred, if provided.
	MessageTime string `json:"messageTime,omitempty"`
	// SegmentParticipant: The participant of this segment.
	SegmentParticipant *GoogleCloudContactcenterinsightsV1ConversationParticipant `json:"segmentParticipant,omitempty"`
	// Sentiment: The sentiment for this transcript segment.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`
	// Text: The text of this segment.
	Text string `json:"text,omitempty"`
	// Words: A list of the word-specific information for each word in the segment.
	Words []*GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo `json:"words,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDial
// ogflowSegmentMetadata: Metadata from Dialogflow relating to the current
// transcript segment.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata struct {
	// SmartReplyAllowlistCovered: Whether the transcript segment was covered under
	// the configured smart reply allowlist in Agent Assist.
	SmartReplyAllowlistCovered bool `json:"smartReplyAllowlistCovered,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SmartReplyAllowlistCovered")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SmartReplyAllowlistCovered") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWord
// Info: Word-level info for words in a transcript.
type GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo struct {
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this word. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// EndOffset: Time offset of the end of this word relative to the beginning of
	// the total conversation.
	EndOffset string `json:"endOffset,omitempty"`
	// StartOffset: Time offset of the start of this word relative to the beginning
	// of the total conversation.
	StartOffset string `json:"startOffset,omitempty"`
	// Word: The word itself. Includes punctuation marks that surround the word.
	Word string `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata: Metadata
// for a create analysis operation.
type GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata struct {
	// AnnotatorSelector: Output only. The annotator selector used for the analysis
	// (if any).
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Conversation: Output only. The Conversation that this Analysis Operation
	// belongs to.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatorSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatorSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueMetadata: Metadata for creating
// an issue.
type GoogleCloudContactcenterinsightsV1CreateIssueMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1CreateIssueRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateIssueMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata: Metadata for
// creating an issue model.
type GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1CreateIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueModelRequest: The request to
// create an issue model.
type GoogleCloudContactcenterinsightsV1CreateIssueModelRequest struct {
	// IssueModel: Required. The issue model to create.
	IssueModel *GoogleCloudContactcenterinsightsV1IssueModel `json:"issueModel,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1CreateIssueRequest: The request to create
// an issue.
type GoogleCloudContactcenterinsightsV1CreateIssueRequest struct {
	// Issue: Required. The values for the new issue.
	Issue *GoogleCloudContactcenterinsightsV1Issue `json:"issue,omitempty"`
	// Parent: Required. The parent resource of the issue.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Issue") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Issue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1CreateIssueRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1CreateIssueRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Dataset: Dataset resource represents a
// collection of conversations that may be bounded (Static Dataset, e.g. golden
// dataset for training), or unbounded (Dynamic Dataset, e.g. live traffic, or
// agent training traffic)
type GoogleCloudContactcenterinsightsV1Dataset struct {
	// CreateTime: Output only. Dataset create time.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Dataset description.
	Description string `json:"description,omitempty"`
	// DisplayName: Display name for the dataaset
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. Identifier. Resource name of the dataset. Format:
	// projects/{project}/locations/{location}/datasets/{dataset}
	Name string `json:"name,omitempty"`
	// Ttl: Optional. Option TTL for the dataset.
	Ttl string `json:"ttl,omitempty"`
	// Type: Dataset usage type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value for unspecified.
	//   "EVAL" - For evals only.
	//   "LIVE" - Dataset with new conversations coming in regularly (Insights
	// legacy conversations and AI trainer)
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. Dataset update time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata: Metadata for
// deleting an issue model.
type GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deletion.
	Request *GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest: The request to
// delete an issue model.
type GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest struct {
	// Name: Required. The name of the issue model to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagMetadata: The metadata
// for deleting a QaQuestionTag Resource.
type GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest: The request
// for deleting a QaQuestionTag.
type GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest struct {
	// Name: Required. The name of the QaQuestionTag to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata: Metadata for
// deploying an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deployment.
	Request *GoogleCloudContactcenterinsightsV1DeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelRequest: The request to
// deploy an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelRequest struct {
	// Name: Required. The issue model to deploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DeployIssueModelResponse: The response to
// deploy an issue model.
type GoogleCloudContactcenterinsightsV1DeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1DeployQaScorecardRevisionRequest: The
// request to deploy a QaScorecardRevision
type GoogleCloudContactcenterinsightsV1DeployQaScorecardRevisionRequest struct {
}

// GoogleCloudContactcenterinsightsV1DialogflowIntent: The data for a
// Dialogflow intent. Represents a detected intent in the conversation, e.g.
// MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1DialogflowIntent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DialogflowIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowIntent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DialogflowInteractionData: Dialogflow
// interaction data.
type GoogleCloudContactcenterinsightsV1DialogflowInteractionData struct {
	// Confidence: The confidence of the match ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowIntentId: The Dialogflow intent resource path. Format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntentId string `json:"dialogflowIntentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DialogflowInteractionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowInteractionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1DialogflowInteractionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowInteractionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1DialogflowSource: A Dialogflow source of
// conversation data.
type GoogleCloudContactcenterinsightsV1DialogflowSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// DialogflowConversation: Output only. The name of the Dialogflow conversation
	// that this conversation resource is derived from. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	DialogflowConversation string `json:"dialogflowConversation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DialogflowSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DialogflowSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Dimension: A dimension determines the
// grouping key for the query. In SQL terms, these would be part of both the
// "SELECT" and "GROUP BY" clauses.
type GoogleCloudContactcenterinsightsV1Dimension struct {
	// AgentDimensionMetadata: Output only. Metadata about the agent dimension.
	AgentDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata `json:"agentDimensionMetadata,omitempty"`
	// DimensionKey: The key of the dimension.
	//
	// Possible values:
	//   "DIMENSION_KEY_UNSPECIFIED" - The key of the dimension is unspecified.
	//   "ISSUE" - The dimension is keyed by issues.
	//   "ISSUE_NAME" - The dimension is keyed by issue names.
	//   "AGENT" - The dimension is keyed by agents.
	//   "AGENT_TEAM" - The dimension is keyed by agent teams.
	//   "QA_QUESTION_ID" - The dimension is keyed by QaQuestionIds. Note that: We
	// only group by the QuestionId and not the revision-id of the scorecard this
	// question is a part of. This allows for showing stats for the same question
	// across different scorecard revisions.
	//   "QA_QUESTION_ANSWER_VALUE" - The dimension is keyed by
	// QaQuestionIds-Answer value pairs. Note that: We only group by the QuestionId
	// and not the revision-id of the scorecard this question is a part of. This
	// allows for showing distribution of answers per question across different
	// scorecard revisions.
	//   "QA_SCORECARD_ID" - The dimension is keyed by QaScorecardIds. Note that:
	// We only group by the ScorecardId and not the revision-id of the scorecard.
	// This allows for showing stats for the same scorecard across different
	// revisions. This metric is mostly only useful if querying the average
	// normalized score per scorecard.
	//   "CONVERSATION_PROFILE_ID" - The dimension is keyed by the conversation
	// profile ID.
	//   "MEDIUM" - The dimension is keyed by the conversation medium.
	DimensionKey string `json:"dimensionKey,omitempty"`
	// IssueDimensionMetadata: Output only. Metadata about the issue dimension.
	IssueDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata `json:"issueDimensionMetadata,omitempty"`
	// QaQuestionAnswerDimensionMetadata: Output only. Metadata about the QA
	// question-answer dimension.
	QaQuestionAnswerDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata `json:"qaQuestionAnswerDimensionMetadata,omitempty"`
	// QaQuestionDimensionMetadata: Output only. Metadata about the QA question
	// dimension.
	QaQuestionDimensionMetadata *GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata `json:"qaQuestionDimensionMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Dimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Dimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata: Metadata
// about the agent dimension.
type GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata struct {
	// AgentDisplayName: Optional. The agent's name
	AgentDisplayName string `json:"agentDisplayName,omitempty"`
	// AgentId: Optional. A user-specified string representing the agent.
	AgentId string `json:"agentId,omitempty"`
	// AgentTeam: Optional. A user-specified string representing the agent's team.
	AgentTeam string `json:"agentTeam,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata: Metadata
// about the issue dimension.
type GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata struct {
	// IssueDisplayName: The issue display name.
	IssueDisplayName string `json:"issueDisplayName,omitempty"`
	// IssueId: The issue ID.
	IssueId string `json:"issueId,omitempty"`
	// IssueModelId: The parent issue model ID.
	IssueModelId string `json:"issueModelId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata:
//
//	Metadata about the QA question-answer dimension. This is useful for showing
//
// the answer distribution for questions for a given scorecard.
type GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata struct {
	// AnswerValue: Optional. The full body of the question.
	AnswerValue string `json:"answerValue,omitempty"`
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata:
// Metadata about the QA question dimension.
type GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata struct {
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1EncryptionSpec: A customer-managed
// encryption key specification that can be applied to all created resources
// (e.g. `Conversation`).
type GoogleCloudContactcenterinsightsV1EncryptionSpec struct {
	// KmsKey: Required. The name of customer-managed encryption key that is used
	// to secure a resource and its sub-resources. If empty, the resource is
	// secured by our default encryption key. Only the key in the same location as
	// this resource is allowed to be used for encryption. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKey string `json:"kmsKey,omitempty"`
	// Name: Immutable. The resource name of the encryption key specification
	// resource. Format: projects/{project}/locations/{location}/encryptionSpec
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Entity: The data for an entity annotation.
// Represents a phrase in the conversation that is a known entity, such as a
// person, an organization, or location.
type GoogleCloudContactcenterinsightsV1Entity struct {
	// DisplayName: The representative name for the entity.
	DisplayName string `json:"displayName,omitempty"`
	// Metadata: Metadata associated with the entity. For most entity types, the
	// metadata is a Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID
	// (`mid`), if they are available. For the metadata associated with other
	// entity types, see the Type table below.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Salience: The salience score associated with the entity in the [0, 1.0]
	// range. The salience score for an entity provides information about the
	// importance or centrality of that entity to the entire document text. Scores
	// closer to 0 are less salient, while scores closer to 1.0 are highly salient.
	Salience float64 `json:"salience,omitempty"`
	// Sentiment: The aggregate sentiment expressed for this entity in the
	// conversation.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`
	// Type: The entity type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified.
	//   "PERSON" - Person.
	//   "LOCATION" - Location.
	//   "ORGANIZATION" - Organization.
	//   "EVENT" - Event.
	//   "WORK_OF_ART" - Artwork.
	//   "CONSUMER_GOOD" - Consumer product.
	//   "OTHER" - Other types of entities.
	//   "PHONE_NUMBER" - Phone number. The metadata lists the phone number
	// (formatted according to local convention), plus whichever additional
	// elements appear in the text: * `number` - The actual number, broken down
	// into sections according to local convention. * `national_prefix` - Country
	// code, if detected. * `area_code` - Region or area code, if detected. *
	// `extension` - Phone extension (to be dialed after connection), if detected.
	//   "ADDRESS" - Address. The metadata identifies the street number and
	// locality plus whichever additional elements appear in the text: *
	// `street_number` - Street number. * `locality` - City or town. *
	// `street_name` - Street/route name, if detected. * `postal_code` - Postal
	// code, if detected. * `country` - Country, if detected. * `broad_region` -
	// Administrative area, such as the state, if detected. * `narrow_region` -
	// Smaller administrative area, such as county, if detected. * `sublocality` -
	// Used in Asian addresses to demark a district within a city, if detected.
	//   "DATE" - Date. The metadata identifies the components of the date: *
	// `year` - Four digit year, if detected. * `month` - Two digit month number,
	// if detected. * `day` - Two digit day number, if detected.
	//   "NUMBER" - Number. The metadata is the number itself.
	//   "PRICE" - Price. The metadata identifies the `value` and `currency`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Entity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Entity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1Entity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1Entity
	var s1 struct {
		Salience gensupport.JSONFloat64 `json:"salience"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Salience = float64(s1.Salience)
	return nil
}

// GoogleCloudContactcenterinsightsV1EntityMentionData: The data for an entity
// mention annotation. This represents a mention of an `Entity` in the
// conversation.
type GoogleCloudContactcenterinsightsV1EntityMentionData struct {
	// EntityUniqueId: The key of this entity in conversation entities. Can be used
	// to retrieve the exact `Entity` this mention is attached to.
	EntityUniqueId string `json:"entityUniqueId,omitempty"`
	// Sentiment: Sentiment expressed for this mention of the entity.
	Sentiment *GoogleCloudContactcenterinsightsV1SentimentData `json:"sentiment,omitempty"`
	// Type: The type of the entity mention.
	//
	// Possible values:
	//   "MENTION_TYPE_UNSPECIFIED" - Unspecified.
	//   "PROPER" - Proper noun.
	//   "COMMON" - Common noun (or noun compound).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1EntityMentionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1EntityMentionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExactMatchConfig: Exact match
// configuration.
type GoogleCloudContactcenterinsightsV1ExactMatchConfig struct {
	// CaseSensitive: Whether to consider case sensitivity when performing an exact
	// match.
	CaseSensitive bool `json:"caseSensitive,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseSensitive") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExactMatchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExactMatchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata: Metadata for
// an export insights operation.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata struct {
	// CompletedExportCount: The number of conversations that were exported
	// successfully.
	CompletedExportCount int64 `json:"completedExportCount,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedExportCount: The number of conversations that failed to be exported.
	FailedExportCount int64 `json:"failedExportCount,omitempty"`
	// PartialErrors: Partial errors during export operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for export.
	Request *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedExportCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedExportCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest: The request to
// export insights.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest struct {
	// BigQueryDestination: Specified if sink is a BigQuery table.
	BigQueryDestination *GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination `json:"bigQueryDestination,omitempty"`
	// ExportSchemaVersion: Optional. Version of the export schema.
	//
	// Possible values:
	//   "EXPORT_SCHEMA_VERSION_UNSPECIFIED" - Unspecified. Defaults to EXPORT_V3.
	//   "EXPORT_V1" - Export schema version 1.
	//   "EXPORT_V2" - Export schema version 2.
	//   "EXPORT_V3" - Export schema version 3.
	//   "EXPORT_V4" - Export schema version 4.
	//   "EXPORT_V5" - Export schema version 5.
	//   "EXPORT_V6" - Export schema version 6.
	//   "EXPORT_V7" - Export schema version 7.
	//   "EXPORT_V8" - Export schema version 8.
	//   "EXPORT_V9" - Export schema version 9.
	//   "EXPORT_V10" - Export schema version 10.
	//   "EXPORT_VERSION_LATEST_AVAILABLE" - Export schema version latest
	// available.
	ExportSchemaVersion string `json:"exportSchemaVersion,omitempty"`
	// Filter: A filter to reduce results to a specific subset. Useful for
	// exporting conversations with specific properties.
	Filter string `json:"filter,omitempty"`
	// KmsKey: A fully qualified KMS key name for BigQuery tables protected by
	// CMEK. Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/c
	// ryptoKeyVersions/{version}
	KmsKey string `json:"kmsKey,omitempty"`
	// Parent: Required. The parent resource to export data from.
	Parent string `json:"parent,omitempty"`
	// WriteDisposition: Options for what to do if the destination table already
	// exists.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Write disposition is not specified.
	// Defaults to WRITE_TRUNCATE.
	//   "WRITE_TRUNCATE" - If the table already exists, BigQuery will overwrite
	// the table data and use the schema from the load.
	//   "WRITE_APPEND" - If the table already exists, BigQuery will append data to
	// the table.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestinatio
// n: A BigQuery Table Reference.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination struct {
	// Dataset: Required. The name of the BigQuery dataset that the snapshot result
	// should be exported to. If this dataset does not exist, the export call
	// returns an INVALID_ARGUMENT error.
	Dataset string `json:"dataset,omitempty"`
	// ProjectId: A project ID or number. If specified, then export will attempt to
	// write data to this project instead of the resource project. Otherwise, the
	// resource project will be used.
	ProjectId string `json:"projectId,omitempty"`
	// Table: The BigQuery table name to which the insights data should be written.
	// If this table does not exist, the export call returns an INVALID_ARGUMENT
	// error.
	Table string `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportInsightsDataResponse: Response for
// an export insights operation.
type GoogleCloudContactcenterinsightsV1ExportInsightsDataResponse struct {
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata: Metadata used
// for export issue model.
type GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original export request.
	Request *GoogleCloudContactcenterinsightsV1ExportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelRequest: Request to export
// an issue model.
type GoogleCloudContactcenterinsightsV1ExportIssueModelRequest struct {
	// GcsDestination: Google Cloud Storage URI to export the issue model to.
	GcsDestination *GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination `json:"gcsDestination,omitempty"`
	// Name: Required. The issue model to export.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination:
// Google Cloud Storage Object URI to save the issue model to.
type GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ExportIssueModelResponse: Response from
// export issue model
type GoogleCloudContactcenterinsightsV1ExportIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1FaqAnswerData: Agent Assist
// frequently-asked-question answer data.
type GoogleCloudContactcenterinsightsV1FaqAnswerData struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`
	// ConfidenceScore: The system's confidence score that this answer is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the FAQ answer and the document
	// that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1FaqAnswerData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1FaqAnswerData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1FaqAnswerData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1FaqAnswerData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1FeedbackLabel: Represents a conversation,
// resource, and label provided by the user. Can take the form of a string
// label or a QaAnswer label. QaAnswer labels are used for Quality AI example
// conversations. String labels are used for Topic Modeling. AgentAssistSummary
// labels are used for Agent Assist Summarization.
type GoogleCloudContactcenterinsightsV1FeedbackLabel struct {
	// CreateTime: Output only. Create time of the label.
	CreateTime string `json:"createTime,omitempty"`
	// Label: String label used for Topic Modeling.
	Label string `json:"label,omitempty"`
	// LabeledResource: Name of the resource to be labeled. Supported resources
	// are: *
	// `projects/{project}/locations/{location}/qaScorecards/{scorecard}/revisions/{
	// revision}/qaQuestions/{question}` *
	// `projects/{project}/locations/{location}/issueModels/{issue_model}` *
	// `projects/{project}/locations/{location}/generators/{generator_id}`
	LabeledResource string `json:"labeledResource,omitempty"`
	// Name: Immutable. Resource name of the FeedbackLabel. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/feedback
	// Labels/{feedback_label}
	Name string `json:"name,omitempty"`
	// QaAnswerLabel: QaAnswer label used for Quality AI example conversations.
	QaAnswerLabel *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue `json:"qaAnswerLabel,omitempty"`
	// UpdateTime: Output only. Update time of the label.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1FeedbackLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1FeedbackLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1FinalizeAssessmentRequest: The message to
// finalize an assessment. Finalizing makes an assessment and its notes
// immutable.
type GoogleCloudContactcenterinsightsV1FinalizeAssessmentRequest struct {
}

// GoogleCloudContactcenterinsightsV1GcsSource: A Cloud Storage source of
// conversation data.
type GoogleCloudContactcenterinsightsV1GcsSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// TranscriptUri: Immutable. Cloud Storage URI that points to a file that
	// contains the conversation transcript.
	TranscriptUri string `json:"transcriptUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1HoldData: The data for a hold annotation.
type GoogleCloudContactcenterinsightsV1HoldData struct {
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata: Metadata used
// for import issue model.
type GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original import request.
	Request *GoogleCloudContactcenterinsightsV1ImportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelRequest: Request to import
// an issue model.
type GoogleCloudContactcenterinsightsV1ImportIssueModelRequest struct {
	// CreateNewModel: Optional. If set to true, will create an issue model from
	// the imported file with randomly generated IDs for the issue model and
	// corresponding issues. Otherwise, replaces an existing model with the same ID
	// as the file.
	CreateNewModel bool `json:"createNewModel,omitempty"`
	// GcsSource: Google Cloud Storage source message.
	GcsSource *GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateNewModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateNewModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ImportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ImportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource: Google
// Cloud Storage Object URI to get the issue model file from.
type GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ImportIssueModelResponse: Response from
// import issue model
type GoogleCloudContactcenterinsightsV1ImportIssueModelResponse struct {
	// IssueModel: The issue model that was imported.
	IssueModel *GoogleCloudContactcenterinsightsV1IssueModel `json:"issueModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ImportIssueModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ImportIssueModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsMetadata: The metadata
// for an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1IngestConversationsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// IngestConversationsStats: Output only. Statistics for IngestConversations
	// operation.
	IngestConversationsStats *GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats `json:"ingestConversationsStats,omitempty"`
	// PartialErrors: Output only. Partial errors during ingest operation that
	// might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for ingest.
	Request *GoogleCloudContactcenterinsightsV1IngestConversationsRequest `json:"request,omitempty"`
	// SampledConversations: Output only. Stores the conversation resources
	// produced by ingest sampling operations.
	SampledConversations []string `json:"sampledConversations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversati
// onsStats: Statistics for IngestConversations operation.
type GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats struct {
	// DuplicatesSkippedCount: Output only. The number of objects skipped because
	// another conversation with the same transcript uri had already been ingested.
	DuplicatesSkippedCount int64 `json:"duplicatesSkippedCount,omitempty"`
	// FailedIngestCount: Output only. The number of objects which were unable to
	// be ingested due to errors. The errors are populated in the partial_errors
	// field.
	FailedIngestCount int64 `json:"failedIngestCount,omitempty"`
	// ProcessedObjectCount: Output only. The number of objects processed during
	// the ingest operation.
	ProcessedObjectCount int64 `json:"processedObjectCount,omitempty"`
	// SuccessfulIngestCount: Output only. The number of new conversations added
	// during this ingest operation.
	SuccessfulIngestCount int64 `json:"successfulIngestCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequest: The request to
// ingest conversations.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequest struct {
	// ConversationConfig: Configuration that applies to all conversations.
	ConversationConfig *GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig `json:"conversationConfig,omitempty"`
	// GcsSource: A cloud storage bucket source. Note that any previously ingested
	// objects from the source will be skipped to avoid duplication.
	GcsSource *GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource for new conversations.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Optional,
	// will default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"redactionConfig,omitempty"`
	// SampleSize: Optional. If set, this fields indicates the number of objects to
	// ingest from the Cloud Storage bucket. If empty, the entire bucket will be
	// ingested. Unless they are first deleted, conversations produced through
	// sampling won't be ingested by subsequent ingest requests.
	SampleSize int64 `json:"sampleSize,omitempty"`
	// SpeechConfig: Optional. Default Speech-to-Text configuration. Optional, will
	// default to the config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1SpeechConfig `json:"speechConfig,omitempty"`
	// TranscriptObjectConfig: Configuration for when `source` contains
	// conversation transcripts.
	TranscriptObjectConfig *GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig `json:"transcriptObjectConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfi
// g: Configuration that applies to all conversations.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig struct {
	// AgentChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// AgentId: Optional. An opaque, user-specified string representing a human
	// agent who handled all conversations in the import. Note that this will be
	// overridden if per-conversation metadata is provided through the
	// `metadata_bucket_uri`.
	AgentId string `json:"agentId,omitempty"`
	// CustomerChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource:
// Configuration for Cloud Storage bucket sources.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource struct {
	// AudioBucketUri: Optional. The Cloud Storage path to the conversation audio
	// file. Note that: [1] Audio files will be transcribed if not already. [2]
	// Audio files and transcript files must be in separate buckets / folders. [3]
	// A source file and its corresponding audio file must share the same name to
	// be properly ingested, E.g. `gs://bucket/transcript/conversation1.json` and
	// `gs://bucket/audio/conversation1.mp3`.
	AudioBucketUri string `json:"audioBucketUri,omitempty"`
	// BucketObjectType: Optional. Specifies the type of the objects in
	// `bucket_uri`. Avoid passing this. This is inferred from the
	// `transcript_bucket_uri`, `audio_bucket_uri`.
	//
	// Possible values:
	//   "BUCKET_OBJECT_TYPE_UNSPECIFIED" - The object type is unspecified and will
	// default to `TRANSCRIPT`.
	//   "TRANSCRIPT" - The object is a transcript.
	//   "AUDIO" - The object is an audio file.
	BucketObjectType string `json:"bucketObjectType,omitempty"`
	// BucketUri: Optional. The Cloud Storage bucket containing source objects.
	// Avoid passing this. Pass this through one of `transcript_bucket_uri` or
	// `audio_bucket_uri`.
	BucketUri string `json:"bucketUri,omitempty"`
	// CustomMetadataKeys: Optional. Custom keys to extract as conversation labels
	// from metadata files in `metadata_bucket_uri`. Keys not included in this
	// field will be ignored. Note that there is a limit of 100 labels per
	// conversation.
	CustomMetadataKeys []string `json:"customMetadataKeys,omitempty"`
	// MetadataBucketUri: Optional. The Cloud Storage path to the conversation
	// metadata. Note that: [1] Metadata files are expected to be in JSON format.
	// [2] Metadata and source files (transcripts or audio) must be in separate
	// buckets / folders. [3] A source file and its corresponding metadata file
	// must share the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	MetadataBucketUri string `json:"metadataBucketUri,omitempty"`
	// TranscriptBucketUri: Optional. The Cloud Storage path to the conversation
	// transcripts. Note that: [1] Transcript files are expected to be in JSON
	// format. [2] Transcript, audio, metadata files must be in separate buckets /
	// folders. [3] A source file and its corresponding metadata file must share
	// the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	TranscriptBucketUri string `json:"transcriptBucketUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioBucketUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioBucketUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectC
// onfig: Configuration for processing transcript objects.
type GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig struct {
	// Medium: Required. The medium transcript objects represent.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IngestConversationsResponse: The response
// to an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1IngestConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata: Metadata
// for initializing a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during initializing operation that might cause
	// the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for initialization.
	Request *GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest: The
// request to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest struct {
	// EncryptionSpec: Required. The encryption spec used for CMEK encryption. It
	// is required that the kms key is in the same region as the endpoint. The same
	// key will be used for all provisioned resources, if encryption is available.
	// If the `kms_key_name` field is left empty, no encryption will be enforced.
	EncryptionSpec *GoogleCloudContactcenterinsightsV1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecResponse: The
// response to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecResponse struct {
}

// GoogleCloudContactcenterinsightsV1Intent: The data for an intent. Represents
// a detected intent in the conversation, for example MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1Intent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// Id: The unique identifier of the intent.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IntentMatchData: The data for an intent
// match. Represents an intent match for a text segment in the conversation. A
// text segment can be part of a sentence, a complete sentence, or an utterance
// with multiple sentences.
type GoogleCloudContactcenterinsightsV1IntentMatchData struct {
	// IntentUniqueId: The id of the matched intent. Can be used to retrieve the
	// corresponding intent information.
	IntentUniqueId string `json:"intentUniqueId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IntentMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IntentMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1InterruptionData: The data for an
// interruption annotation.
type GoogleCloudContactcenterinsightsV1InterruptionData struct {
}

// GoogleCloudContactcenterinsightsV1Issue: The issue resource.
type GoogleCloudContactcenterinsightsV1Issue struct {
	// CreateTime: Output only. The time at which this issue was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayDescription: Representative description of the issue.
	DisplayDescription string `json:"displayDescription,omitempty"`
	// DisplayName: The representative name for the issue.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. The resource name of the issue. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{iss
	// ue}
	Name string `json:"name,omitempty"`
	// SampleUtterances: Output only. Resource names of the sample representative
	// utterances that match to this issue.
	SampleUtterances []string `json:"sampleUtterances,omitempty"`
	// UpdateTime: Output only. The most recent time that this issue was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Issue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Issue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueAssignment: Information about the
// issue.
type GoogleCloudContactcenterinsightsV1IssueAssignment struct {
	// DisplayName: Immutable. Display name of the assigned issue. This field is
	// set at time of analysis and immutable since then.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Resource name of the assigned issue.
	Issue string `json:"issue,omitempty"`
	// Score: Score indicating the likelihood of the issue assignment. currently
	// bounded on [0,1].
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueAssignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1IssueAssignment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueAssignment
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1IssueMatchData: The data for an issue
// match annotation.
type GoogleCloudContactcenterinsightsV1IssueMatchData struct {
	// IssueAssignment: Information about the issue's assignment.
	IssueAssignment *GoogleCloudContactcenterinsightsV1IssueAssignment `json:"issueAssignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueAssignment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueAssignment") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModel: The issue model resource.
type GoogleCloudContactcenterinsightsV1IssueModel struct {
	// CreateTime: Output only. The time at which this issue model was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The representative name for the issue model.
	DisplayName string `json:"displayName,omitempty"`
	// InputDataConfig: Configs for the input data that used to create the issue
	// model.
	InputDataConfig *GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig `json:"inputDataConfig,omitempty"`
	// IssueCount: Output only. Number of issues in this issue model.
	IssueCount int64 `json:"issueCount,omitempty,string"`
	// LanguageCode: Language of the model.
	LanguageCode string `json:"languageCode,omitempty"`
	// ModelType: Type of the model.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Unspecified model type.
	//   "TYPE_V1" - Type V1.
	//   "TYPE_V2" - Type V2.
	ModelType string `json:"modelType,omitempty"`
	// Name: Immutable. The resource name of the issue model. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	Name string `json:"name,omitempty"`
	// State: Output only. State of the model.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "UNDEPLOYED" - Model is not deployed but is ready to deploy.
	//   "DEPLOYING" - Model is being deployed.
	//   "DEPLOYED" - Model is deployed and is ready to be used. A model can only
	// be used in analysis if it's in this state.
	//   "UNDEPLOYING" - Model is being undeployed.
	//   "DELETING" - Model is being deleted.
	State string `json:"state,omitempty"`
	// TrainingStats: Output only. Immutable. The issue model's label statistics on
	// its training data.
	TrainingStats *GoogleCloudContactcenterinsightsV1IssueModelLabelStats `json:"trainingStats,omitempty"`
	// UpdateTime: Output only. The most recent time at which the issue model was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig: Configs for the
// input data used to create the issue model.
type GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig struct {
	// Filter: A filter to reduce the conversations used for training the model to
	// a specific subset. Refer to
	// https://cloud.google.com/contact-center/insights/docs/filtering for details.
	Filter string `json:"filter,omitempty"`
	// Medium: Medium of conversations used in training data. This field is being
	// deprecated. To specify the medium to be used in training a new issue model,
	// set the `medium` field on `filter`.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// TrainingConversationsCount: Output only. Number of conversations used in
	// training. Output only.
	TrainingConversationsCount int64 `json:"trainingConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelLabelStats: Aggregated
// statistics about an issue model.
type GoogleCloudContactcenterinsightsV1IssueModelLabelStats struct {
	// AnalyzedConversationsCount: Number of conversations the issue model has
	// analyzed at this point in time.
	AnalyzedConversationsCount int64 `json:"analyzedConversationsCount,omitempty,string"`
	// IssueStats: Statistics on each issue. Key is the issue's resource name.
	IssueStats map[string]GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats `json:"issueStats,omitempty"`
	// UnclassifiedConversationsCount: Number of analyzed conversations for which
	// no issue was applicable at this point in time.
	UnclassifiedConversationsCount int64 `json:"unclassifiedConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AnalyzedConversationsCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyzedConversationsCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelLabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelLabelStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats: Aggregated
// statistics about an issue.
type GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats struct {
	// DisplayName: Display name of the issue.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Issue resource. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{iss
	// ue}
	Issue string `json:"issue,omitempty"`
	// LabeledConversationsCount: Number of conversations attached to the issue at
	// this point in time.
	LabeledConversationsCount int64 `json:"labeledConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1IssueModelResult: Issue Modeling result on
// a conversation.
type GoogleCloudContactcenterinsightsV1IssueModelResult struct {
	// IssueModel: Issue model that generates the result. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	IssueModel string `json:"issueModel,omitempty"`
	// Issues: All the matched issues.
	Issues []*GoogleCloudContactcenterinsightsV1IssueAssignment `json:"issues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1IssueModelResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1IssueModelResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse: The
// response for listing all feedback labels.
type GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAnalysesResponse: The response to list
// analyses.
type GoogleCloudContactcenterinsightsV1ListAnalysesResponse struct {
	// Analyses: The analyses that match the request.
	Analyses []*GoogleCloudContactcenterinsightsV1Analysis `json:"analyses,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Analyses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Analyses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAnalysesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAnalysesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse: The response of
// listing views.
type GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse struct {
	// AnalysisRules: The analysis_rule that match the request.
	AnalysisRules []*GoogleCloudContactcenterinsightsV1AnalysisRule `json:"analysisRules,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnalysisRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisRules") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse: The response
// of listing assessment rules.
type GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse struct {
	// AssessmentRules: The assessment rules that match the request.
	AssessmentRules []*GoogleCloudContactcenterinsightsV1AssessmentRule `json:"assessmentRules,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssessmentRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssessmentRules") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAssessmentsResponse: The response of
// listing assessments.
type GoogleCloudContactcenterinsightsV1ListAssessmentsResponse struct {
	// Assessments: The assessments that match the request.
	Assessments []*GoogleCloudContactcenterinsightsV1Assessment `json:"assessments,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Assessments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Assessments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAssessmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAssessmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse: The
// response from a ListAuthorizedViewSet request.
type GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse struct {
	// AuthorizedViewSets: The AuthorizedViewSets under the parent.
	AuthorizedViewSets []*GoogleCloudContactcenterinsightsV1AuthorizedViewSet `json:"authorizedViewSets,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuthorizedViewSets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorizedViewSets") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse: The response
// from a ListAuthorizedViews request.
type GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse struct {
	// AuthorizedViews: The AuthorizedViews under the parent.
	AuthorizedViews []*GoogleCloudContactcenterinsightsV1AuthorizedView `json:"authorizedViews,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuthorizedViews") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorizedViews") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListConversationsResponse: The response of
// listing conversations.
type GoogleCloudContactcenterinsightsV1ListConversationsResponse struct {
	// Conversations: The conversations that match the request.
	Conversations []*GoogleCloudContactcenterinsightsV1Conversation `json:"conversations,omitempty"`
	// NextPageToken: A token which can be sent as `page_token` to retrieve the
	// next page. If this field is set, it means there is another page available.
	// If it is not set, it means no other pages are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListDatasetsResponse: The response to list
// datasets.
type GoogleCloudContactcenterinsightsV1ListDatasetsResponse struct {
	// Datasets: The datasets that match the request.
	Datasets []*GoogleCloudContactcenterinsightsV1Dataset `json:"datasets,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Datasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Datasets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListDatasetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListDatasetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse: The response
// for listing feedback labels.
type GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: The next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListIssueModelsResponse: The response of
// listing issue models.
type GoogleCloudContactcenterinsightsV1ListIssueModelsResponse struct {
	// IssueModels: The issue models that match the request.
	IssueModels []*GoogleCloudContactcenterinsightsV1IssueModel `json:"issueModels,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IssueModels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListIssueModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListIssueModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListIssuesResponse: The response of
// listing issues.
type GoogleCloudContactcenterinsightsV1ListIssuesResponse struct {
	// Issues: The issues that match the request.
	Issues []*GoogleCloudContactcenterinsightsV1Issue `json:"issues,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Issues") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Issues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListIssuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListIssuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListNotesResponse: The response of listing
// notes.
type GoogleCloudContactcenterinsightsV1ListNotesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Notes: The notes that match the request.
	Notes []*GoogleCloudContactcenterinsightsV1Note `json:"notes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListNotesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListNotesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse: The response
// of listing phrase matchers.
type GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PhraseMatchers: The phrase matchers that match the request.
	PhraseMatchers []*GoogleCloudContactcenterinsightsV1PhraseMatcher `json:"phraseMatchers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListQaQuestionTagsResponse: The response
// from a ListQaQuestionTags request.
type GoogleCloudContactcenterinsightsV1ListQaQuestionTagsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QaQuestionTags: The parent resource of the questions.
	QaQuestionTags []*GoogleCloudContactcenterinsightsV1QaQuestionTag `json:"qaQuestionTags,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListQaQuestionTagsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListQaQuestionTagsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse: The response from
// a ListQaQuestions request.
type GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QaQuestions: The QaQuestions under the parent.
	QaQuestions []*GoogleCloudContactcenterinsightsV1QaQuestion `json:"qaQuestions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse: The
// response from a ListQaScorecardRevisions request.
type GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QaScorecardRevisions: The QaScorecards under the parent.
	QaScorecardRevisions []*GoogleCloudContactcenterinsightsV1QaScorecardRevision `json:"qaScorecardRevisions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse: The response
// from a ListQaScorecards request.
type GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// QaScorecards: The QaScorecards under the parent.
	QaScorecards []*GoogleCloudContactcenterinsightsV1QaScorecard `json:"qaScorecards,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1ListViewsResponse: The response of listing
// views.
type GoogleCloudContactcenterinsightsV1ListViewsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Views: The views that match the request.
	Views []*GoogleCloudContactcenterinsightsV1View `json:"views,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ListViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ListViewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1Note: The conversation assessment note
// resource.
type GoogleCloudContactcenterinsightsV1Note struct {
	// AssessmentNote: The note is associated to the entire parent assessment.
	AssessmentNote *GoogleCloudContactcenterinsightsV1NoteAssessmentNote `json:"assessmentNote,omitempty"`
	// Content: The note content.
	Content string `json:"content,omitempty"`
	// ConversationTurnNote: The note is associated with a conversation turn.
	ConversationTurnNote *GoogleCloudContactcenterinsightsV1NoteConversationTurnNote `json:"conversationTurnNote,omitempty"`
	// CreateTime: Output only. The time at which the note was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The resource name of the note. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/assessme
	// nts/{assessment}/notes/{note}
	Name string `json:"name,omitempty"`
	// NoteCreator: Output only. The user that created the note.
	NoteCreator *GoogleCloudContactcenterinsightsV1UserInfo `json:"noteCreator,omitempty"`
	// QaQuestionNote: The note is associated with a QA question in one of the
	// conversation's scorecard results.
	QaQuestionNote *GoogleCloudContactcenterinsightsV1NoteQaQuestionNote `json:"qaQuestionNote,omitempty"`
	// UpdateTime: Output only. The time at which the note was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AssessmentNote") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AssessmentNote") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Note) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Note
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1NoteAssessmentNote: A note about the
// entire parent assessment.
type GoogleCloudContactcenterinsightsV1NoteAssessmentNote struct {
}

// GoogleCloudContactcenterinsightsV1NoteConversationTurnNote: A note about a
// conversation turn.
type GoogleCloudContactcenterinsightsV1NoteConversationTurnNote struct {
	// TurnIndex: The conversation turn index that the note is associated with.
	TurnIndex int64 `json:"turnIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1NoteConversationTurnNote) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1NoteConversationTurnNote
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1NoteQaQuestionNote: A note about a QA
// question.
type GoogleCloudContactcenterinsightsV1NoteQaQuestionNote struct {
	// QaQuestion: The question resource that the note is associated with.
	QaQuestion string `json:"qaQuestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1NoteQaQuestionNote) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1NoteQaQuestionNote
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchData: The data for a matched
// phrase matcher. Represents information identifying a phrase matcher for a
// given match.
type GoogleCloudContactcenterinsightsV1PhraseMatchData struct {
	// DisplayName: The human-readable name of the phrase matcher.
	DisplayName string `json:"displayName,omitempty"`
	// PhraseMatcher: The unique identifier (the resource name) of the phrase
	// matcher.
	PhraseMatcher string `json:"phraseMatcher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRule: The data for a phrase
// match rule.
type GoogleCloudContactcenterinsightsV1PhraseMatchRule struct {
	// Config: Provides additional information about the rule that specifies how to
	// apply the rule.
	Config *GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig `json:"config,omitempty"`
	// Negated: Specifies whether the phrase must be missing from the transcript
	// segment or present in the transcript segment.
	Negated bool `json:"negated,omitempty"`
	// Query: Required. The phrase to be matched.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig: Configuration
// information of a phrase match rule.
type GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig struct {
	// ExactMatchConfig: The configuration for the exact match rule.
	ExactMatchConfig *GoogleCloudContactcenterinsightsV1ExactMatchConfig `json:"exactMatchConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExactMatchConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatchConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup: A message
// representing a rule in the phrase matcher.
type GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup struct {
	// PhraseMatchRules: A list of phrase match rules that are included in this
	// group.
	PhraseMatchRules []*GoogleCloudContactcenterinsightsV1PhraseMatchRule `json:"phraseMatchRules,omitempty"`
	// Type: Required. The type of this phrase match rule group.
	//
	// Possible values:
	//   "PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED" - Unspecified.
	//   "ALL_OF" - Must meet all phrase match rules or there is no match.
	//   "ANY_OF" - If any of the phrase match rules are met, there is a match.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhraseMatchRules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhraseMatchRules") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PhraseMatcher: The phrase matcher
// resource.
type GoogleCloudContactcenterinsightsV1PhraseMatcher struct {
	// ActivationUpdateTime: Output only. The most recent time at which the
	// activation status was updated.
	ActivationUpdateTime string `json:"activationUpdateTime,omitempty"`
	// Active: Applies the phrase matcher only when it is active.
	Active bool `json:"active,omitempty"`
	// DisplayName: The human-readable name of the phrase matcher.
	DisplayName string `json:"displayName,omitempty"`
	// Name: The resource name of the phrase matcher. Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
	Name string `json:"name,omitempty"`
	// PhraseMatchRuleGroups: A list of phase match rule groups that are included
	// in this matcher.
	PhraseMatchRuleGroups []*GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup `json:"phraseMatchRuleGroups,omitempty"`
	// RevisionCreateTime: Output only. The timestamp of when the revision was
	// created. It is also the create time when a new matcher is added.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`
	// RevisionId: Output only. Immutable. The revision ID of the phrase matcher. A
	// new revision is committed whenever the matcher is changed, except when it is
	// activated or deactivated. A server generated random ID will be used.
	// Example: locations/global/phraseMatchers/my-first-matcher@1234567
	RevisionId string `json:"revisionId,omitempty"`
	// RoleMatch: The role whose utterances the phrase matcher should be matched
	// against. If the role is ROLE_UNSPECIFIED it will be matched against any
	// utterances in the transcript.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	RoleMatch string `json:"roleMatch,omitempty"`
	// Type: Required. The type of this phrase matcher.
	//
	// Possible values:
	//   "PHRASE_MATCHER_TYPE_UNSPECIFIED" - Unspecified.
	//   "ALL_OF" - Must meet all phrase match rule groups or there is no match.
	//   "ANY_OF" - If any of the phrase match rule groups are met, there is a
	// match.
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. The most recent time at which the phrase matcher
	// was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VersionTag: The customized version tag to use for the phrase matcher. If not
	// specified, it will default to `revision_id`.
	VersionTag string `json:"versionTag,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActivationUpdateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationUpdateTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1PhraseMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1PhraseMatcher
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1PublishAssessmentRequest: The message to
// publish an assessment. Draft and appealed assessments can be published.
// Publishing simply changes the state of the assessment to published, allowing
// the console and authorized views to filter on the state.
type GoogleCloudContactcenterinsightsV1PublishAssessmentRequest struct {
}

// GoogleCloudContactcenterinsightsV1QaAnswer: An answer to a QaQuestion.
type GoogleCloudContactcenterinsightsV1QaAnswer struct {
	// AnswerSources: List of all individual answers given to the question.
	AnswerSources []*GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource `json:"answerSources,omitempty"`
	// AnswerValue: The main answer value, incorporating any manual edits if they
	// exist.
	AnswerValue *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// Conversation: The conversation the answer applies to.
	Conversation string `json:"conversation,omitempty"`
	// QaQuestion: The QaQuestion answered by this answer.
	QaQuestion string `json:"qaQuestion,omitempty"`
	// QuestionBody: Question text. E.g., "Did the agent greet the customer?"
	QuestionBody string `json:"questionBody,omitempty"`
	// Tags: User-defined list of arbitrary tags. Matches the value from
	// QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and for
	// weighting the score of each answer.
	Tags []string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource: A question may have
// multiple answers from varying sources, one of which becomes the "main"
// answer above. AnswerSource represents each individual answer.
type GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource struct {
	// AnswerValue: The answer value from this source.
	AnswerValue *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// SourceType: What created the answer.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED" - Answer was system-generated; created during an
	// Insights analysis.
	//   "MANUAL_EDIT" - Answer was created by a human via manual edit.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue: Message for holding
// the value of a QaAnswer. QaQuestion.AnswerChoice defines the possible answer
// values for a question.
type GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue struct {
	// BoolValue: Boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// Key: A short string used as an identifier. Matches the value used in
	// QaQuestion.AnswerChoice.key.
	Key string `json:"key,omitempty"`
	// NaValue: A value of "Not Applicable (N/A)". Should only ever be `true`.
	NaValue bool `json:"naValue,omitempty"`
	// NormalizedScore: Output only. Normalized score of the questions. Calculated
	// as score / potential_score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// NumValue: Numerical value.
	NumValue float64 `json:"numValue,omitempty"`
	// PotentialScore: Output only. The maximum potential score of the question.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: Output only. Numerical score of the answer.
	Score float64 `json:"score,omitempty"`
	// SkipValue: Output only. A value of "Skip". If provided, this field may only
	// be set to `true`. If a question receives this answer, it will be excluded
	// from any score calculations. This would mean that the question was not
	// evaluated.
	SkipValue bool `json:"skipValue,omitempty"`
	// StrValue: String value.
	StrValue string `json:"strValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		NumValue        gensupport.JSONFloat64 `json:"numValue"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.NumValue = float64(s1.NumValue)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaQuestion: A single question to be scored
// by the Insights QA feature.
type GoogleCloudContactcenterinsightsV1QaQuestion struct {
	// Abbreviation: Short, descriptive string, used in the UI where it's not
	// practical to display the full question body. E.g., "Greeting".
	Abbreviation string `json:"abbreviation,omitempty"`
	// AnswerChoices: A list of valid answers to the question, which the LLM must
	// choose from.
	AnswerChoices []*GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice `json:"answerChoices,omitempty"`
	// AnswerInstructions: Instructions describing how to determine the answer.
	AnswerInstructions string `json:"answerInstructions,omitempty"`
	// CreateTime: Output only. The time at which this question was created.
	CreateTime string `json:"createTime,omitempty"`
	// Metrics: Metrics of the underlying tuned LLM over a holdout/test set while
	// fine tuning the underlying LLM for the given question. This field will only
	// be populated if and only if the question is part of a scorecard revision
	// that has been tuned.
	Metrics *GoogleCloudContactcenterinsightsV1QaQuestionMetrics `json:"metrics,omitempty"`
	// Name: Identifier. The resource name of the question. Format:
	// projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions
	// /{revision}/qaQuestions/{qa_question}
	Name string `json:"name,omitempty"`
	// Order: Defines the order of the question within its parent scorecard
	// revision.
	Order int64 `json:"order,omitempty"`
	// PredefinedQuestionConfig: The configuration of the predefined question. This
	// field will only be set if the Question Type is predefined.
	PredefinedQuestionConfig *GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig `json:"predefinedQuestionConfig,omitempty"`
	// QuestionBody: Question text. E.g., "Did the agent greet the customer?"
	QuestionBody string `json:"questionBody,omitempty"`
	// QuestionType: The type of question.
	//
	// Possible values:
	//   "QA_QUESTION_TYPE_UNSPECIFIED" - The type of the question is unspecified.
	//   "CUSTOMIZABLE" - The default question type. The question is fully
	// customizable by the user.
	//   "PREDEFINED" - The question type is using a predefined model provided by
	// CCAI teams. Users are not allowed to edit the question_body, answer_choices,
	// upload feedback labels for the question nor fine-tune the question. However,
	// users may edit other fields like question tags, question order, etc.
	QuestionType string `json:"questionType,omitempty"`
	// Tags: Questions are tagged for categorization and scoring. Tags can either
	// be: - Default Tags: These are predefined categories. They are identified by
	// their string value (e.g., "BUSINESS", "COMPLIANCE", and "CUSTOMER"). -
	// Custom Tags: These are user-defined categories. They are identified by their
	// full resource name (e.g.,
	// projects/{project}/locations/{location}/qaQuestionTags/{qa_question_tag}).
	// Both default and custom tags are used to group questions and to influence
	// the scoring of each question.
	Tags []string `json:"tags,omitempty"`
	// TuningMetadata: Metadata about the tuning operation for the question.This
	// field will only be populated if and only if the question is part of a
	// scorecard revision that has been tuned.
	TuningMetadata *GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata `json:"tuningMetadata,omitempty"`
	// UpdateTime: Output only. The most recent time at which the question was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Abbreviation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Abbreviation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice: Message
// representing a possible answer to the question.
type GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice struct {
	// BoolValue: Boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// Key: A short string used as an identifier.
	Key string `json:"key,omitempty"`
	// NaValue: A value of "Not Applicable (N/A)". If provided, this field may only
	// be set to `true`. If a question receives this answer, it will be excluded
	// from any score calculations.
	NaValue bool `json:"naValue,omitempty"`
	// NumValue: Numerical value.
	NumValue float64 `json:"numValue,omitempty"`
	// Score: Numerical score of the answer, used for generating the overall score
	// of a QaScorecardResult. If the answer uses na_value, this field is unused.
	Score float64 `json:"score,omitempty"`
	// StrValue: String value.
	StrValue string `json:"strValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice
	var s1 struct {
		NumValue gensupport.JSONFloat64 `json:"numValue"`
		Score    gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumValue = float64(s1.NumValue)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaQuestionMetrics: A wrapper representing
// metrics calculated against a test-set on a LLM that was fine tuned for this
// question.
type GoogleCloudContactcenterinsightsV1QaQuestionMetrics struct {
	// Accuracy: Output only. Accuracy of the model. Measures the percentage of
	// correct answers the model gave on the test set.
	Accuracy float64 `json:"accuracy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Accuracy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accuracy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaQuestionMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionMetrics
	var s1 struct {
		Accuracy gensupport.JSONFloat64 `json:"accuracy"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Accuracy = float64(s1.Accuracy)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig:
// Configuration for a predefined question. This field will only be set if the
// Question Type is predefined.
type GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig struct {
	// Type: The type of the predefined question.
	//
	// Possible values:
	//   "PREDEFINED_QUESTION_TYPE_UNSPECIFIED" - The type of the predefined
	// question is unspecified.
	//   "CONVERSATION_OUTCOME" - A prebuilt classifier classfying the outcome of
	// the conversation. For example, if the customer issue mentioned in a
	// conversation has been resolved or not.
	//   "CONVERSATION_OUTCOME_ESCALATION_INITIATOR_ROLE" - A prebuilt classifier
	// classfying the initiator of the conversation escalation. For example, if it
	// was initiated by the customer or the agent.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaQuestionTag: A tag is a resource which
// aims to categorize a set of questions across multiple scorecards, e.g.,
// "Customer Satisfaction","Billing", etc.
type GoogleCloudContactcenterinsightsV1QaQuestionTag struct {
	// CreateTime: Output only. The time at which the question tag was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. A user-specified display name for the tag.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. Resource name for the QaQuestionTag Format
	// projects/{project}/locations/{location}/qaQuestionTags/{qa_question_tag} In
	// the above format, the last segment, i.e., qa_question_tag, is a
	// server-generated ID corresponding to the tag resource.
	Name string `json:"name,omitempty"`
	// QaQuestionIds: Optional. The list of Scorecard Question IDs that the tag
	// applies to. Each QaQuestionId is represented as a full resource name
	// containing the Question ID. Lastly, Since a tag may not necessarily be
	// referenced by any Scorecard Questions, we treat this field as optional.
	QaQuestionIds []string `json:"qaQuestionIds,omitempty"`
	// UpdateTime: Output only. The most recent time at which the question tag was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionTag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionTag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata: Metadata about
// the tuning operation for the question. Will only be set if a scorecard
// containing this question has been tuned.
type GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata struct {
	// DatasetValidationWarnings: A list of any applicable data validation warnings
	// about the question's feedback labels.
	//
	// Possible values:
	//   "DATASET_VALIDATION_WARNING_UNSPECIFIED" - Unspecified data validation
	// warning.
	//   "TOO_MANY_INVALID_FEEDBACK_LABELS" - A non-trivial percentage of the
	// feedback labels are invalid.
	//   "INSUFFICIENT_FEEDBACK_LABELS" - The quantity of valid feedback labels
	// provided is less than the recommended minimum.
	//   "INSUFFICIENT_FEEDBACK_LABELS_PER_ANSWER" - One or more of the answers
	// have less than the recommended minimum of feedback labels.
	//   "ALL_FEEDBACK_LABELS_HAVE_THE_SAME_ANSWER" - All the labels in the dataset
	// come from a single answer choice.
	DatasetValidationWarnings []string `json:"datasetValidationWarnings,omitempty"`
	// TotalValidLabelCount: Total number of valid labels provided for the question
	// at the time of tuining.
	TotalValidLabelCount int64 `json:"totalValidLabelCount,omitempty,string"`
	// TuningError: Error status of the tuning operation for the question. Will
	// only be set if the tuning operation failed.
	TuningError string `json:"tuningError,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetValidationWarnings")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetValidationWarnings") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaScorecard: A QaScorecard represents a
// collection of questions to be scored during analysis.
type GoogleCloudContactcenterinsightsV1QaScorecard struct {
	// CreateTime: Output only. The time at which this scorecard was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: A text description explaining the intent of the scorecard.
	Description string `json:"description,omitempty"`
	// DisplayName: The user-specified display name of the scorecard.
	DisplayName string `json:"displayName,omitempty"`
	// IsDefault: Whether the scorecard is the default one for the project. A
	// default scorecard cannot be deleted and will always appear first in
	// scorecard selector.
	IsDefault bool `json:"isDefault,omitempty"`
	// Name: Identifier. The scorecard name. Format:
	// projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}
	Name string `json:"name,omitempty"`
	// Source: Output only. The source of the scorecard.
	//
	// Possible values:
	//   "QA_SCORECARD_SOURCE_UNSPECIFIED" - The source of the scorecard is
	// unspecified. Default to QA_SCORECARD_SOURCE_CUSTOMER_DEFINED.
	//   "QA_SCORECARD_SOURCE_CUSTOMER_DEFINED" - The scorecard is a custom
	// scorecard created by the user.
	//   "QA_SCORECARD_SOURCE_DISCOVERY_ENGINE" - The scorecard is a scorecard
	// created through discovery engine deployment.
	Source string `json:"source,omitempty"`
	// UpdateTime: Output only. The most recent time at which the scorecard was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QaScorecardResult: The results of scoring
// a single conversation against a QaScorecard. Contains a collection of
// QaAnswers and aggregate score.
type GoogleCloudContactcenterinsightsV1QaScorecardResult struct {
	// AgentId: ID of the agent that handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// Conversation: The conversation scored by this result.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The timestamp that the revision was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the scorecard result. Format:
	// projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_resu
	// lt}
	Name string `json:"name,omitempty"`
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score. Any manual edits are included if they exist.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaAnswers: Set of QaAnswers represented in the result.
	QaAnswers []*GoogleCloudContactcenterinsightsV1QaAnswer `json:"qaAnswers,omitempty"`
	// QaScorecardRevision: The QaScorecardRevision scored by this result.
	QaScorecardRevision string `json:"qaScorecardRevision,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result, incorporating any manual
	// edits if they exist.
	Score float64 `json:"score,omitempty"`
	// ScoreSources: List of all individual score sets.
	ScoreSources []*GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource `json:"scoreSources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaScorecardResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult: Tags and
// their corresponding results.
type GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult struct {
	// NormalizedScore: The normalized score the tag applies to.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The potential score the tag applies to.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: The score the tag applies to.
	Score float64 `json:"score,omitempty"`
	// Tag: The tag the score applies to.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource: A scorecard
// result may have multiple sets of scores from varying sources, one of which
// becomes the "main" answer above. A ScoreSource represents each individual
// set of scores.
type GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource struct {
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result.
	Score float64 `json:"score,omitempty"`
	// SourceType: What created the score.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED_ONLY" - Score is derived only from system-generated
	// answers.
	//   "INCLUDES_MANUAL_EDITS" - Score is derived from both system-generated
	// answers, and includes any manual edits if they exist.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1QaScorecardRevision: A revision of a
// QaScorecard. Modifying published scorecard fields would invalidate existing
// scorecard results — the questions may have changed, or the score weighting
// will make existing scores impossible to understand. So changes must create a
// new revision, rather than modifying the existing resource.
type GoogleCloudContactcenterinsightsV1QaScorecardRevision struct {
	// AlternateIds: Output only. Alternative IDs for this revision of the
	// scorecard, e.g., `latest`.
	AlternateIds []string `json:"alternateIds,omitempty"`
	// CreateTime: Output only. The timestamp that the revision was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the scorecard revision. Format:
	// projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions
	// /{revision}
	Name string `json:"name,omitempty"`
	// Snapshot: The snapshot of the scorecard at the time of this revision's
	// creation.
	Snapshot *GoogleCloudContactcenterinsightsV1QaScorecard `json:"snapshot,omitempty"`
	// State: Output only. State of the scorecard revision, indicating whether it's
	// ready to be used in analysis.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "EDITABLE" - The scorecard revision can be edited.
	//   "TRAINING" - Scorecard model training is in progress.
	//   "TRAINING_FAILED" - Scorecard revision model training failed.
	//   "READY" - The revision can be used in analysis.
	//   "DELETING" - Scorecard is being deleted.
	//   "TRAINING_CANCELLED" - Scorecard model training was explicitly cancelled
	// by the user.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AlternateIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlternateIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QaScorecardRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QaScorecardRevision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryInterval: A time window for querying
// conversations.
type GoogleCloudContactcenterinsightsV1QueryInterval struct {
	// EndTime: Required. The end time of the time window.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Required. The start time of the time window.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsMetadata: The metadata from
// querying metrics.
type GoogleCloudContactcenterinsightsV1QueryMetricsMetadata struct {
	// ResultIsTruncated: Whether the result rows were truncated because the result
	// row size is too large to materialize.
	ResultIsTruncated bool `json:"resultIsTruncated,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResultIsTruncated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResultIsTruncated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsRequest: The request for
// querying metrics.
type GoogleCloudContactcenterinsightsV1QueryMetricsRequest struct {
	// Dimensions: The dimensions that determine the grouping key for the query.
	// Defaults to no dimension if this field is unspecified. If a dimension is
	// specified, its key must also be specified. Each dimension's key must be
	// unique. If a time granularity is also specified, metric values in the
	// dimension will be bucketed by this granularity. Up to one dimension is
	// supported for now.
	Dimensions []*GoogleCloudContactcenterinsightsV1Dimension `json:"dimensions,omitempty"`
	// Filter: Required. Filter to select a subset of conversations to compute the
	// metrics. Must specify a window of the conversation create time to compute
	// the metrics. The returned metrics will be from the range [DATE(starting
	// create time), DATE(ending create time)).
	Filter string `json:"filter,omitempty"`
	// MeasureMask: Measures to return. Defaults to all measures if this field is
	// unspecified. A valid mask should traverse from the `measure` field from the
	// response. For example, a path from a measure mask to get the conversation
	// count is "conversation_measure.count".
	MeasureMask string `json:"measureMask,omitempty"`
	// TimeGranularity: The time granularity of each data point in the time series.
	// Defaults to NONE if this field is unspecified.
	//
	// Possible values:
	//   "TIME_GRANULARITY_UNSPECIFIED" - The time granularity is unspecified and
	// will default to NONE.
	//   "NONE" - No time granularity. The response won't contain a time series.
	// This is the default value if no time granularity is specified.
	//   "DAILY" - Data points in the time series will aggregate at a daily
	// granularity. 1 day means [midnight to midnight).
	//   "HOURLY" - Data points in the time series will aggregate at a daily
	// granularity. 1 HOUR means [01:00 to 02:00).
	//   "PER_MINUTE" - Data points in the time series will aggregate at a daily
	// granularity. PER_MINUTE means [01:00 to 01:01).
	//   "PER_5_MINUTES" - Data points in the time series will aggregate at a 1
	// minute granularity. PER_5_MINUTES means [01:00 to 01:05).
	//   "MONTHLY" - Data points in the time series will aggregate at a monthly
	// granularity. 1 MONTH means [01st of the month to 1st of the next month).
	TimeGranularity string `json:"timeGranularity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponse: The response for
// querying metrics.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponse struct {
	// Location: Required. The location of the data.
	// "projects/{project}/locations/{location}"
	Location string `json:"location,omitempty"`
	// MacroAverageSlice: The macro average slice contains aggregated averages
	// across the selected dimension. i.e. if group_by agent is specified this
	// field will contain the average across all agents. This field is only
	// populated if the request specifies a Dimension.
	MacroAverageSlice *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice `json:"macroAverageSlice,omitempty"`
	// Slices: A slice contains a total and (if the request specified a time
	// granularity) a time series of metric values. Each slice contains a unique
	// combination of the cardinality of dimensions from the request.
	Slices []*GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice `json:"slices,omitempty"`
	// UpdateTime: The metrics last update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice: A slice
// contains a total and (if the request specified a time granularity) a time
// series of metric values. Each slice contains a unique combination of the
// cardinality of dimensions from the request. For example, if the request
// specifies a single ISSUE dimension and it has a cardinality of 2 (i.e. the
// data used to compute the metrics has 2 issues in total), the response will
// have 2 slices: * Slice 1 -> dimensions=[Issue 1] * Slice 2 ->
// dimensions=[Issue 2]
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice struct {
	// Dimensions: A unique combination of dimensions that this slice represents.
	Dimensions []*GoogleCloudContactcenterinsightsV1Dimension `json:"dimensions,omitempty"`
	// TimeSeries: A time series of metric values. This is only populated if the
	// request specifies a time granularity other than NONE.
	TimeSeries *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries `json:"timeSeries,omitempty"`
	// Total: The total metric value. The interval of this data point is [starting
	// create time, ending create time) from the request.
	Total *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint `json:"total,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint: A data
// point contains the metric values mapped to an interval.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint struct {
	// ConversationMeasure: The measure related to conversations.
	ConversationMeasure *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure `json:"conversationMeasure,omitempty"`
	// Interval: The interval that this data point represents. * If this is the
	// total data point, the interval is [starting create time, ending create time)
	// from the request. * If this a data point from the time series, the interval
	// is [time, time + time granularity from the request).
	Interval *GoogleTypeInterval `json:"interval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationMeasure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationMeasure") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversat
// ionMeasure: The measure related to conversations.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure struct {
	// AverageAgentSentimentScore: The average agent's sentiment score.
	AverageAgentSentimentScore float64 `json:"averageAgentSentimentScore,omitempty"`
	// AverageClientSentimentScore: The average client's sentiment score.
	AverageClientSentimentScore float64 `json:"averageClientSentimentScore,omitempty"`
	// AverageCustomerSatisfactionRating: The average customer satisfaction rating.
	AverageCustomerSatisfactionRating float64 `json:"averageCustomerSatisfactionRating,omitempty"`
	// AverageDuration: The average duration.
	AverageDuration string `json:"averageDuration,omitempty"`
	// AverageQaNormalizedScore: Average QA normalized score. Will exclude 0's in
	// average calculation.
	AverageQaNormalizedScore float64 `json:"averageQaNormalizedScore,omitempty"`
	// AverageQaQuestionNormalizedScore: Average QA normalized score averaged for
	// questions averaged across all revisions of the parent scorecard. Will be
	// only populated if the request specifies a dimension of QA_QUESTION_ID.
	AverageQaQuestionNormalizedScore float64 `json:"averageQaQuestionNormalizedScore,omitempty"`
	// AverageSilencePercentage: The average silence percentage.
	AverageSilencePercentage float64 `json:"averageSilencePercentage,omitempty"`
	// AverageTurnCount: The average turn count.
	AverageTurnCount float64 `json:"averageTurnCount,omitempty"`
	// ConversationCount: The conversation count.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// QaTagScores: Average QA normalized score for all the tags.
	QaTagScores []*GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore `json:"qaTagScores,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageAgentSentimentScore")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageAgentSentimentScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure
	var s1 struct {
		AverageAgentSentimentScore        gensupport.JSONFloat64 `json:"averageAgentSentimentScore"`
		AverageClientSentimentScore       gensupport.JSONFloat64 `json:"averageClientSentimentScore"`
		AverageCustomerSatisfactionRating gensupport.JSONFloat64 `json:"averageCustomerSatisfactionRating"`
		AverageQaNormalizedScore          gensupport.JSONFloat64 `json:"averageQaNormalizedScore"`
		AverageQaQuestionNormalizedScore  gensupport.JSONFloat64 `json:"averageQaQuestionNormalizedScore"`
		AverageSilencePercentage          gensupport.JSONFloat64 `json:"averageSilencePercentage"`
		AverageTurnCount                  gensupport.JSONFloat64 `json:"averageTurnCount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageAgentSentimentScore = float64(s1.AverageAgentSentimentScore)
	s.AverageClientSentimentScore = float64(s1.AverageClientSentimentScore)
	s.AverageCustomerSatisfactionRating = float64(s1.AverageCustomerSatisfactionRating)
	s.AverageQaNormalizedScore = float64(s1.AverageQaNormalizedScore)
	s.AverageQaQuestionNormalizedScore = float64(s1.AverageQaQuestionNormalizedScore)
	s.AverageSilencePercentage = float64(s1.AverageSilencePercentage)
	s.AverageTurnCount = float64(s1.AverageTurnCount)
	return nil
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversat
// ionMeasureQaTagScore: Average QA normalized score for the tag.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore struct {
	// AverageTagNormalizedScore: Average tag normalized score per tag.
	AverageTagNormalizedScore float64 `json:"averageTagNormalizedScore,omitempty"`
	// Tag: Tag name.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageTagNormalizedScore")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageTagNormalizedScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	var s1 struct {
		AverageTagNormalizedScore gensupport.JSONFloat64 `json:"averageTagNormalizedScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageTagNormalizedScore = float64(s1.AverageTagNormalizedScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries: A
// time series of metric values.
type GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries struct {
	// DataPoints: The data points that make up the time series .
	DataPoints []*GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint `json:"dataPoints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataPoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataPoints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewMetadata: The
// metadata for querying performance overview.
type GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewMetadata struct {
}

// GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest: The
// request for summarizing performance according to different metrics for
// conversations over a specified time window.
type GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest struct {
	// AgentPerformanceSource: Conversations are from a single agent.
	AgentPerformanceSource *GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource `json:"agentPerformanceSource,omitempty"`
	// ComparisonQueryInterval: The time window of the conversations to compare the
	// performance to.
	ComparisonQueryInterval *GoogleCloudContactcenterinsightsV1QueryInterval `json:"comparisonQueryInterval,omitempty"`
	// Filter: Optional. Filter to select a subset of conversations to compute the
	// performance overview. Supports the same filters as the filter field in
	// QueryMetricsRequest. The source and query interval/comparison query interval
	// should not be included here.
	Filter string `json:"filter,omitempty"`
	// QueryInterval: Required. The time window of the conversations to derive
	// performance stats from.
	QueryInterval *GoogleCloudContactcenterinsightsV1QueryInterval `json:"queryInterval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentPerformanceSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentPerformanceSource") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource:
//
//	The entity whose performance is being queried is a single agent.
type GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource struct {
	// AgentId: Required. Agent id to query performance overview for.
	AgentId string `json:"agentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewResponse: The
// response for querying performance overview.
type GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewResponse struct {
	// SummaryText: The summary text of the performance.
	SummaryText string `json:"summaryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SummaryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SummaryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1RedactionConfig: DLP resources used for
// redaction while ingesting conversations. DLP settings are applied to
// conversations ingested from the `UploadConversation` and
// `IngestConversations` endpoints, including conversation coming from CCAI
// Platform. They are not applied to conversations ingested from the
// `CreateConversation` endpoint or the Dialogflow / Agent Assist runtime
// integrations. When using Dialogflow / Agent Assist runtime integrations,
// redaction should be performed in Dialogflow / Agent Assist.
type GoogleCloudContactcenterinsightsV1RedactionConfig struct {
	// DeidentifyTemplate: The fully-qualified DLP deidentify template resource
	// name. Format: `projects/{project}/deidentifyTemplates/{template}`
	DeidentifyTemplate string `json:"deidentifyTemplate,omitempty"`
	// InspectTemplate: The fully-qualified DLP inspect template resource name.
	// Format:
	// `projects/{project}/locations/{location}/inspectTemplates/{template}`
	InspectTemplate string `json:"inspectTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1RedactionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1RedactionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1RuntimeAnnotation: An annotation that was
// generated during the customer and agent interaction.
type GoogleCloudContactcenterinsightsV1RuntimeAnnotation struct {
	// AnnotationId: The unique identifier of the annotation. Format:
	// projects/{project}/locations/{location}/conversationDatasets/{dataset}/conver
	// sationDataItems/{data_item}/conversationAnnotations/{annotation}
	AnnotationId string `json:"annotationId,omitempty"`
	// AnswerFeedback: The feedback that the customer has about the answer in
	// `data`.
	AnswerFeedback *GoogleCloudContactcenterinsightsV1AnswerFeedback `json:"answerFeedback,omitempty"`
	// ArticleSuggestion: Agent Assist Article Suggestion data.
	ArticleSuggestion *GoogleCloudContactcenterinsightsV1ArticleSuggestionData `json:"articleSuggestion,omitempty"`
	// ConversationSummarizationSuggestion: Conversation summarization suggestion
	// data.
	ConversationSummarizationSuggestion *GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData `json:"conversationSummarizationSuggestion,omitempty"`
	// CreateTime: The time at which this annotation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DialogflowInteraction: Dialogflow interaction data.
	DialogflowInteraction *GoogleCloudContactcenterinsightsV1DialogflowInteractionData `json:"dialogflowInteraction,omitempty"`
	// EndBoundary: The boundary in the conversation where the annotation ends,
	// inclusive.
	EndBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"endBoundary,omitempty"`
	// FaqAnswer: Agent Assist FAQ answer data.
	FaqAnswer *GoogleCloudContactcenterinsightsV1FaqAnswerData `json:"faqAnswer,omitempty"`
	// SmartComposeSuggestion: Agent Assist Smart Compose suggestion data.
	SmartComposeSuggestion *GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData `json:"smartComposeSuggestion,omitempty"`
	// SmartReply: Agent Assist Smart Reply data.
	SmartReply *GoogleCloudContactcenterinsightsV1SmartReplyData `json:"smartReply,omitempty"`
	// StartBoundary: The boundary in the conversation where the annotation starts,
	// inclusive.
	StartBoundary *GoogleCloudContactcenterinsightsV1AnnotationBoundary `json:"startBoundary,omitempty"`
	// UserInput: Explicit input used for generating the answer
	UserInput *GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput `json:"userInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1RuntimeAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1RuntimeAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput: Explicit input
// used for generating the answer
type GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput struct {
	// GeneratorName: The resource name of associated generator. Format:
	// `projects//locations//generators/`
	GeneratorName string `json:"generatorName,omitempty"`
	// Query: Query text. Article Search uses this to store the input query used to
	// generate the search results.
	Query string `json:"query,omitempty"`
	// QuerySource: Query source for the answer.
	//
	// Possible values:
	//   "QUERY_SOURCE_UNSPECIFIED" - Unknown query source.
	//   "AGENT_QUERY" - The query is from agents.
	//   "SUGGESTED_QUERY" - The query is a query from previous suggestions, e.g.
	// from a preceding SuggestKnowledgeAssist response.
	QuerySource string `json:"querySource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratorName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SampleConversationsMetadata: The metadata
// for an SampleConversations operation.
type GoogleCloudContactcenterinsightsV1SampleConversationsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Output only. Partial errors during sample conversations
	// operation that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for sample conversations to
	// dataset.
	Request *GoogleCloudContactcenterinsightsV1SampleConversationsRequest `json:"request,omitempty"`
	// SampleConversationsStats: Output only. Statistics for SampleConversations
	// operation.
	SampleConversationsStats *GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversationsStats `json:"sampleConversationsStats,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SampleConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SampleConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversati
// onsStats: Statistics for SampleConversations operation.
type GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversationsStats struct {
	// FailedSampleCount: Output only. The number of objects which were unable to
	// be sampled due to errors. The errors are populated in the partial_errors
	// field.
	FailedSampleCount int64 `json:"failedSampleCount,omitempty"`
	// SuccessfulSampleCount: Output only. The number of new conversations added
	// during this sample operation.
	SuccessfulSampleCount int64 `json:"successfulSampleCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedSampleCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedSampleCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversationsStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversationsStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SampleConversationsRequest: The request to
// sample conversations to a dataset.
type GoogleCloudContactcenterinsightsV1SampleConversationsRequest struct {
	// DestinationDataset: The dataset resource to copy the sampled conversations
	// to.
	DestinationDataset *GoogleCloudContactcenterinsightsV1Dataset `json:"destinationDataset,omitempty"`
	// Parent: Required. The parent resource of the dataset.
	Parent string `json:"parent,omitempty"`
	// SampleRule: Optional. The sample rule used for sampling conversations.
	SampleRule *GoogleCloudContactcenterinsightsV1SampleRule `json:"sampleRule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SampleConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SampleConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SampleConversationsResponse: The response
// to an SampleConversations operation.
type GoogleCloudContactcenterinsightsV1SampleConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1SampleRule: Message for sampling
// conversations.
type GoogleCloudContactcenterinsightsV1SampleRule struct {
	// ConversationFilter: To specify the filter for the conversions that should
	// apply this sample rule. An empty filter means this sample rule applies to
	// all conversations.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// Dimension: Optional. Group by dimension to sample the conversation. If no
	// dimension is provided, the sampling will be applied to the project level.
	// Current supported dimensions is 'quality_metadata.agent_info.agent_id'.
	Dimension string `json:"dimension,omitempty"`
	// SamplePercentage: Percentage of conversations that we should sample based on
	// the dimension between [0, 100].
	SamplePercentage float64 `json:"samplePercentage,omitempty"`
	// SampleRow: Number of the conversations that we should sample based on the
	// dimension.
	SampleRow int64 `json:"sampleRow,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ConversationFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationFilter") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SampleRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SampleRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SampleRule) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SampleRule
	var s1 struct {
		SamplePercentage gensupport.JSONFloat64 `json:"samplePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SamplePercentage = float64(s1.SamplePercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1ScheduleInfo: Message for schedule info.
type GoogleCloudContactcenterinsightsV1ScheduleInfo struct {
	// EndTime: End time of the schedule. If not specified, will keep scheduling
	// new pipelines for execution util the schedule is no longer active or
	// deleted.
	EndTime string `json:"endTime,omitempty"`
	// Schedule: The groc expression. Format: `every number [synchronized]` Time
	// units can be: minutes, hours Synchronized is optional and indicates that the
	// schedule should be synchronized to the start of the interval: every 5
	// minutes synchronized means 00:00, 00:05 ... Otherwise the start time is
	// random within the interval. Example: `every 5 minutes` could be 00:02,
	// 00:07, 00:12, ...
	Schedule string `json:"schedule,omitempty"`
	// StartTime: Start time of the schedule. If not specified, will start as soon
	// as the schedule is created.
	StartTime string `json:"startTime,omitempty"`
	// TimeZone: The timezone to use for the groc expression. If not specified,
	// defaults to UTC.
	TimeZone string `json:"timeZone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1ScheduleInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1ScheduleInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse: The
// response from a ListAuthorizedViews request.
type GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse struct {
	// AuthorizedViews: The AuthorizedViews under the parent.
	AuthorizedViews []*GoogleCloudContactcenterinsightsV1AuthorizedView `json:"authorizedViews,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuthorizedViews") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorizedViews") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SentimentData: The data for a sentiment
// annotation.
type GoogleCloudContactcenterinsightsV1SentimentData struct {
	// Magnitude: A non-negative number from 0 to infinity which represents the
	// absolute magnitude of sentiment regardless of score.
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: The sentiment score between -1.0 (negative) and 1.0 (positive).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SentimentData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SentimentData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SentimentData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SentimentData
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1Settings: The CCAI Insights project wide
// settings. Use these settings to configure the behavior of Insights. View
// these settings with `getsettings`
// (https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/getSettings)
// and change the settings with `updateSettings`
// (https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/updateSettings).
type GoogleCloudContactcenterinsightsV1Settings struct {
	// AnalysisConfig: Default analysis settings.
	AnalysisConfig *GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig `json:"analysisConfig,omitempty"`
	// ConversationTtl: The default TTL for newly-created conversations. If a
	// conversation has a specified expiration, that value will be used instead.
	// Changing this value will not change the expiration of existing
	// conversations. Conversations with no expire time persist until they are
	// deleted.
	ConversationTtl string `json:"conversationTtl,omitempty"`
	// CreateTime: Output only. The time at which the settings was created.
	CreateTime string `json:"createTime,omitempty"`
	// LanguageCode: A language code to be applied to each transcript segment
	// unless the segment already specifies a language code. Language code defaults
	// to "en-US" if it is neither specified on the segment nor here.
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: Immutable. The resource name of the settings resource. Format:
	// projects/{project}/locations/{location}/settings
	Name string `json:"name,omitempty"`
	// PubsubNotificationSettings: A map that maps a notification trigger to a
	// Pub/Sub topic. Each time a specified trigger occurs, Insights will notify
	// the corresponding Pub/Sub topic. Keys are notification triggers. Supported
	// keys are: * "all-triggers": Notify each time any of the supported triggers
	// occurs. * "create-analysis": Notify each time an analysis is created. *
	// "create-conversation": Notify each time a conversation is created. *
	// "export-insights-data": Notify each time an export is complete. *
	// "ingest-conversations": Notify each time an IngestConversations LRO is
	// complete. * "update-conversation": Notify each time a conversation is
	// updated via UpdateConversation. * "upload-conversation": Notify when an
	// UploadConversation LRO is complete. * "update-or-analyze-conversation":
	// Notify when an analysis for a conversation is completed or when the
	// conversation is updated. The message will contain the conversation with
	// transcript, analysis and other metadata. Values are Pub/Sub topics. The
	// format of each Pub/Sub topic is: projects/{project}/topics/{topic}
	PubsubNotificationSettings map[string]string `json:"pubsubNotificationSettings,omitempty"`
	// RedactionConfig: Default DLP redaction resources to be applied while
	// ingesting conversations. This applies to conversations ingested from the
	// `UploadConversation` and `IngestConversations` endpoints, including
	// conversations coming from CCAI Platform.
	RedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"redactionConfig,omitempty"`
	// SpeechConfig: Optional. Default Speech-to-Text resources to use while
	// ingesting audio files. Optional, CCAI Insights will create a default if not
	// provided. This applies to conversations ingested from the
	// `UploadConversation` and `IngestConversations` endpoints, including
	// conversations coming from CCAI Platform.
	SpeechConfig *GoogleCloudContactcenterinsightsV1SpeechConfig `json:"speechConfig,omitempty"`
	// UpdateTime: Output only. The time at which the settings were last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnalysisConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1Settings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1Settings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig: Default
// configuration when creating Analyses in Insights.
type GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig struct {
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// RuntimeIntegrationAnalysisPercentage: Percentage of conversations created
	// using Dialogflow runtime integration to analyze automatically, between [0,
	// 100].
	RuntimeIntegrationAnalysisPercentage float64 `json:"runtimeIntegrationAnalysisPercentage,omitempty"`
	// UploadConversationAnalysisPercentage: Percentage of conversations created
	// using the UploadConversation endpoint to analyze automatically, between [0,
	// 100].
	UploadConversationAnalysisPercentage float64 `json:"uploadConversationAnalysisPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatorSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatorSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig
	var s1 struct {
		RuntimeIntegrationAnalysisPercentage gensupport.JSONFloat64 `json:"runtimeIntegrationAnalysisPercentage"`
		UploadConversationAnalysisPercentage gensupport.JSONFloat64 `json:"uploadConversationAnalysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RuntimeIntegrationAnalysisPercentage = float64(s1.RuntimeIntegrationAnalysisPercentage)
	s.UploadConversationAnalysisPercentage = float64(s1.UploadConversationAnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1SilenceData: The data for a silence
// annotation.
type GoogleCloudContactcenterinsightsV1SilenceData struct {
}

// GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData: Agent Assist
// Smart Compose suggestion data.
type GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this suggestion is a
	// good match for this conversation, ranging from 0.0 (completely uncertain) to
	// 1.0 (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Compose suggestion and
	// the document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Suggestion: The content of the suggestion.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1SmartReplyData: Agent Assist Smart Reply
// data.
type GoogleCloudContactcenterinsightsV1SmartReplyData struct {
	// ConfidenceScore: The system's confidence score that this reply is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Reply and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Reply: The content of the reply.
	Reply string `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SmartReplyData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartReplyData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1SmartReplyData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1SmartReplyData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1SpeechConfig: Speech-to-Text
// configuration. Speech-to-Text settings are applied to conversations ingested
// from the `UploadConversation` and `IngestConversations` endpoints, including
// conversation coming from CCAI Platform. They are not applied to
// conversations ingested from the `CreateConversation` endpoint.
type GoogleCloudContactcenterinsightsV1SpeechConfig struct {
	// SpeechRecognizer: The fully-qualified Speech Recognizer resource name.
	// Format: `projects/{project_id}/locations/{location}/recognizer/{recognizer}`
	SpeechRecognizer string `json:"speechRecognizer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SpeechRecognizer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SpeechRecognizer") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1SpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1SpeechConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest: Request
// for TuneQaScorecardRevision endpoint.
type GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest struct {
	// Filter: Required. Filter for selecting the feedback labels that needs to be
	// used for training. This filter can be used to limit the feedback labels used
	// for tuning to a feedback labels created or updated for a specific
	// time-window etc.
	Filter string `json:"filter,omitempty"`
	// ValidateOnly: Optional. Run in validate only mode, no fine tuning will
	// actually run. Data quality validations like training data distributions will
	// run. Even when set to false, the data quality validations will still run but
	// once the validations complete we will proceed with the fine tune, if
	// applicable.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata: Metadata for
// undeploying an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for undeployment.
	Request *GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest: The request to
// undeploy an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest struct {
	// Name: Required. The issue model to undeploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UndeployIssueModelResponse: The response
// to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1UndeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1UndeployQaScorecardRevisionRequest: The
// request to undeploy a QaScorecardRevision
type GoogleCloudContactcenterinsightsV1UndeployQaScorecardRevisionRequest struct {
}

// GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagMetadata: The metadata
// for updating a QaQuestionTag Resource.
type GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest: The request
// for updating a QaQuestionTag.
type GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest struct {
	// QaQuestionTag: Required. The QaQuestionTag to update.
	QaQuestionTag *GoogleCloudContactcenterinsightsV1QaQuestionTag `json:"qaQuestionTag,omitempty"`
	// UpdateMask: Optional. The list of fields to be updated. All possible fields
	// can be updated by passing `*`, or a subset of the following updateable
	// fields can be provided: * `qa_question_tag_name` - the name of the tag *
	// `qa_question_ids` - the list of questions the tag applies to
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestionTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestionTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UploadConversationMetadata: The metadata
// for an `UploadConversation` operation.
type GoogleCloudContactcenterinsightsV1UploadConversationMetadata struct {
	// AnalysisOperation: Output only. The operation name for a successfully
	// created analysis operation, if any.
	AnalysisOperation string `json:"analysisOperation,omitempty"`
	// AppliedRedactionConfig: Output only. The redaction config applied to the
	// uploaded conversation.
	AppliedRedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"appliedRedactionConfig,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1UploadConversationRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisOperation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UploadConversationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UploadConversationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UploadConversationRequest: Request to
// upload a conversation.
type GoogleCloudContactcenterinsightsV1UploadConversationRequest struct {
	// Conversation: Required. The conversation resource to create.
	Conversation *GoogleCloudContactcenterinsightsV1Conversation `json:"conversation,omitempty"`
	// ConversationId: Optional. A unique ID for the new conversation. This ID will
	// become the final component of the conversation's resource name. If no ID is
	// specified, a server-generated ID will be used. This value should be 4-64
	// characters and must match the regular expression `^[a-z0-9-]{4,64}$`. Valid
	// characters are `a-z-`
	ConversationId string `json:"conversationId,omitempty"`
	// Parent: Required. The parent resource of the conversation.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Will
	// default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1RedactionConfig `json:"redactionConfig,omitempty"`
	// SpeechConfig: Optional. Speech-to-Text configuration. Will default to the
	// config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1SpeechConfig `json:"speechConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UploadConversationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UploadConversationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1UserInfo: Information about a user.
type GoogleCloudContactcenterinsightsV1UserInfo struct {
	// Username: The user's username.
	Username string `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Username") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Username") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1UserInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1UserInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1View: The View resource.
type GoogleCloudContactcenterinsightsV1View struct {
	// CreateTime: Output only. The time at which this view was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The human-readable display name of the view.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. The resource name of the view. Format:
	// projects/{project}/locations/{location}/views/{view}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The most recent time at which the view was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Value: A filter to reduce conversation results to a specific subset. Refer
	// to https://cloud.google.com/contact-center/insights/docs/filtering for
	// details.
	Value string `json:"value,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1View) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1View
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Analysis: The analysis resource.
type GoogleCloudContactcenterinsightsV1alpha1Analysis struct {
	// AnalysisResult: Output only. The result of the analysis, which is populated
	// when the analysis finishes.
	AnalysisResult *GoogleCloudContactcenterinsightsV1alpha1AnalysisResult `json:"analysisResult,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// CreateTime: Output only. The time at which the analysis was created, which
	// occurs when the long-running operation completes.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Immutable. The resource name of the analysis. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/analyses
	// /{analysis}
	Name string `json:"name,omitempty"`
	// RequestTime: Output only. The time at which the analysis was requested.
	RequestTime string `json:"requestTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Analysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Analysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnalysisResult: The result of an
// analysis.
type GoogleCloudContactcenterinsightsV1alpha1AnalysisResult struct {
	// CallAnalysisMetadata: Call-specific metadata created by the analysis.
	CallAnalysisMetadata *GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata `json:"callAnalysisMetadata,omitempty"`
	// EndTime: The time at which the analysis ended.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CallAnalysisMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CallAnalysisMetadata") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata:
// Call-specific metadata created during analysis.
type GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata struct {
	// Annotations: A list of call annotations that apply to this call.
	Annotations []*GoogleCloudContactcenterinsightsV1alpha1CallAnnotation `json:"annotations,omitempty"`
	// Entities: All the entities in the call.
	Entities map[string]GoogleCloudContactcenterinsightsV1alpha1Entity `json:"entities,omitempty"`
	// Intents: All the matched intents in the call.
	Intents map[string]GoogleCloudContactcenterinsightsV1alpha1Intent `json:"intents,omitempty"`
	// IssueModelResult: Overall conversation-level issue modeling result.
	IssueModelResult *GoogleCloudContactcenterinsightsV1alpha1IssueModelResult `json:"issueModelResult,omitempty"`
	// PhraseMatchers: All the matched phrase matchers in the call.
	PhraseMatchers map[string]GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData `json:"phraseMatchers,omitempty"`
	// QaScorecardResults: Results of scoring QaScorecards.
	QaScorecardResults []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult `json:"qaScorecardResults,omitempty"`
	// Sentiments: Overall conversation-level sentiment for each channel of the
	// call.
	Sentiments []*GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment `json:"sentiments,omitempty"`
	// Silence: Overall conversation-level silence during the call.
	Silence *GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence `json:"silence,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary: A point in a
// conversation that marks the start or the end of an annotation.
type GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary struct {
	// TranscriptIndex: The index in the sequence of transcribed pieces of the
	// conversation where the boundary is located. This index starts at zero.
	TranscriptIndex int64 `json:"transcriptIndex,omitempty"`
	// WordIndex: The word index of this boundary with respect to the first word in
	// the transcript piece. This index starts at zero.
	WordIndex int64 `json:"wordIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptIndex") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector: Selector of all
// available annotators and phrase matchers to run.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector struct {
	// IssueModels: The issue model to run. If not provided, the most recently
	// deployed topic model will be used. The provided issue model will only be
	// used for inference if the issue model is deployed and if
	// run_issue_model_annotator is set to true. If more than one issue model is
	// provided, only the first provided issue model will be used for inference.
	IssueModels []string `json:"issueModels,omitempty"`
	// PhraseMatchers: The list of phrase matchers to run. If not provided, all
	// active phrase matchers will be used. If inactive phrase matchers are
	// provided, they will not be used. Phrase matchers will be run only if
	// run_phrase_matcher_annotator is set to true. Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
	PhraseMatchers []string `json:"phraseMatchers,omitempty"`
	// QaConfig: Configuration for the QA annotator.
	QaConfig *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig `json:"qaConfig,omitempty"`
	// RunEntityAnnotator: Whether to run the entity annotator.
	RunEntityAnnotator bool `json:"runEntityAnnotator,omitempty"`
	// RunIntentAnnotator: Whether to run the intent annotator.
	RunIntentAnnotator bool `json:"runIntentAnnotator,omitempty"`
	// RunInterruptionAnnotator: Whether to run the interruption annotator.
	RunInterruptionAnnotator bool `json:"runInterruptionAnnotator,omitempty"`
	// RunIssueModelAnnotator: Whether to run the issue model annotator. A model
	// should have already been deployed for this to take effect.
	RunIssueModelAnnotator bool `json:"runIssueModelAnnotator,omitempty"`
	// RunPhraseMatcherAnnotator: Whether to run the active phrase matcher
	// annotator(s).
	RunPhraseMatcherAnnotator bool `json:"runPhraseMatcherAnnotator,omitempty"`
	// RunQaAnnotator: Whether to run the QA annotator.
	RunQaAnnotator bool `json:"runQaAnnotator,omitempty"`
	// RunSentimentAnnotator: Whether to run the sentiment annotator.
	RunSentimentAnnotator bool `json:"runSentimentAnnotator,omitempty"`
	// RunSilenceAnnotator: Whether to run the silence annotator.
	RunSilenceAnnotator bool `json:"runSilenceAnnotator,omitempty"`
	// RunSummarizationAnnotator: Whether to run the summarization annotator.
	RunSummarizationAnnotator bool `json:"runSummarizationAnnotator,omitempty"`
	// SummarizationConfig: Configuration for the summarization annotator.
	SummarizationConfig *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig `json:"summarizationConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig:
// Configuration for the QA feature.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig struct {
	// ScorecardList: A manual list of scorecards to score.
	ScorecardList *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList `json:"scorecardList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ScorecardList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ScorecardList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardLis
// t: Container for a list of scorecards.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList struct {
	// QaScorecardRevisions: List of QaScorecardRevisions.
	QaScorecardRevisions []string `json:"qaScorecardRevisions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaScorecardRevisions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaScorecardRevisions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig:
//
//	Configuration for summarization.
type GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig struct {
	// ConversationProfile: Resource name of the Dialogflow conversation profile.
	// Format:
	// projects/{project}/locations/{location}/conversationProfiles/{conversation_pr
	// ofile}
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// Generator: The resource name of the existing created generator. Format:
	// projects//locations//generators/
	Generator string `json:"generator,omitempty"`
	// SummarizationModel: Default summarization model to be used.
	//
	// Possible values:
	//   "SUMMARIZATION_MODEL_UNSPECIFIED" - Unspecified summarization model.
	//   "BASELINE_MODEL" - The CCAI baseline model. This model is deprecated and
	// will be removed in the future. We recommend using `generator` instead.
	//   "BASELINE_MODEL_V2_0" - The CCAI baseline model, V2.0. This model is
	// deprecated and will be removed in the future. We recommend using `generator`
	// instead.
	SummarizationModel string `json:"summarizationModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback: The feedback that
// the customer has about a certain answer in the conversation.
type GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback struct {
	// Clicked: Indicates whether an answer or item was clicked by the human agent.
	Clicked bool `json:"clicked,omitempty"`
	// CorrectnessLevel: The correctness level of an answer.
	//
	// Possible values:
	//   "CORRECTNESS_LEVEL_UNSPECIFIED" - Correctness level unspecified.
	//   "NOT_CORRECT" - Answer is totally wrong.
	//   "PARTIALLY_CORRECT" - Answer is partially correct.
	//   "FULLY_CORRECT" - Answer is fully correct.
	CorrectnessLevel string `json:"correctnessLevel,omitempty"`
	// Displayed: Indicates whether an answer or item was displayed to the human
	// agent in the agent desktop UI.
	Displayed bool `json:"displayed,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clicked") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clicked") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData: Agent Assist
// Article Suggestion data.
type GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this article is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Article Suggestion and the
	// document that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}
	Source string `json:"source,omitempty"`
	// Title: Article title.
	Title string `json:"title,omitempty"`
	// Uri: Article URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata:
// The metadata for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata struct {
	// CompletedAnalysesCount: The number of requested analyses that have completed
	// successfully so far.
	CompletedAnalysesCount int64 `json:"completedAnalysesCount,omitempty"`
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedAnalysesCount: The number of requested analyses that have failed so
	// far.
	FailedAnalysesCount int64 `json:"failedAnalysesCount,omitempty"`
	// PartialErrors: Output only. Partial errors during bulk analyze operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk analyze.
	Request *GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest `json:"request,omitempty"`
	// TotalRequestedAnalysesCount: Total number of analyses requested. Computed by
	// the number of conversations returned by `filter` multiplied by
	// `analysis_percentage` in the request.
	TotalRequestedAnalysesCount int64 `json:"totalRequestedAnalysesCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedAnalysesCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest: The
// request to analyze conversations in bulk.
type GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest struct {
	// AnalysisPercentage: Required. Percentage of selected conversation to
	// analyze, between [0, 100].
	AnalysisPercentage float64 `json:"analysisPercentage,omitempty"`
	// AnnotatorSelector: To select the annotators to run and the phrase matchers
	// to use (if any). If not specified, all annotators will be run.
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Filter: Required. Filter used to select the subset of conversations to
	// analyze.
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource to create analyses in.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisPercentage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisPercentage") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest
	var s1 struct {
		AnalysisPercentage gensupport.JSONFloat64 `json:"analysisPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnalysisPercentage = float64(s1.AnalysisPercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse:
// The response for a bulk analyze conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse struct {
	// FailedAnalysisCount: Count of failed analyses.
	FailedAnalysisCount int64 `json:"failedAnalysisCount,omitempty"`
	// SuccessfulAnalysisCount: Count of successful analyses.
	SuccessfulAnalysisCount int64 `json:"successfulAnalysisCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedAnalysisCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedAnalysisCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata: The
// metadata for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during bulk delete conversations operation
	// that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for bulk delete.
	Request *GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest: The
// request to delete conversations in bulk.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest struct {
	// Filter: Filter used to select the subset of conversations to delete.
	Filter string `json:"filter,omitempty"`
	// Force: If set to true, all of this conversation's analyses will also be
	// deleted. Otherwise, the request will only succeed if the conversation has no
	// analyses.
	Force bool `json:"force,omitempty"`
	// MaxDeleteCount: Maximum number of conversations to delete.
	MaxDeleteCount int64 `json:"maxDeleteCount,omitempty"`
	// Parent: Required. The parent resource to delete conversations from. Format:
	// projects/{project}/locations/{location}
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsResponse: The
// response for a bulk delete conversations operation.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsMetadata:
// Metadata for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsMetadata struct {
	// PartialErrors: Partial errors during deletion operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for delete.
	Request *GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PartialErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PartialErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest:
// Request for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest struct {
	// Filter: Optional. A filter to reduce results to a specific subset. Supports
	// disjunctions (OR) and conjunctions (AND). Supported fields: *
	// `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time`
	// * `max_create_time` * `min_update_time` * `max_update_time` *
	// `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
	Filter string `json:"filter,omitempty"`
	// Parent: Required. The parent resource for new feedback labels.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsResponse:
// Response for the BulkDeleteFeedbackLabels endpoint.
type GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1CallAnnotation: A piece of metadata
// that applies to a window of a call.
type GoogleCloudContactcenterinsightsV1alpha1CallAnnotation struct {
	// AnnotationEndBoundary: The boundary in the conversation where the annotation
	// ends, inclusive.
	AnnotationEndBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"annotationEndBoundary,omitempty"`
	// AnnotationStartBoundary: The boundary in the conversation where the
	// annotation starts, inclusive.
	AnnotationStartBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"annotationStartBoundary,omitempty"`
	// ChannelTag: The channel of the audio where the annotation occurs. For
	// single-channel audio, this field is not populated.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// EntityMentionData: Data specifying an entity mention.
	EntityMentionData *GoogleCloudContactcenterinsightsV1alpha1EntityMentionData `json:"entityMentionData,omitempty"`
	// HoldData: Data specifying a hold.
	HoldData *GoogleCloudContactcenterinsightsV1alpha1HoldData `json:"holdData,omitempty"`
	// IntentMatchData: Data specifying an intent match.
	IntentMatchData *GoogleCloudContactcenterinsightsV1alpha1IntentMatchData `json:"intentMatchData,omitempty"`
	// InterruptionData: Data specifying an interruption.
	InterruptionData *GoogleCloudContactcenterinsightsV1alpha1InterruptionData `json:"interruptionData,omitempty"`
	// IssueMatchData: Data specifying an issue match.
	IssueMatchData *GoogleCloudContactcenterinsightsV1alpha1IssueMatchData `json:"issueMatchData,omitempty"`
	// PhraseMatchData: Data specifying a phrase match.
	PhraseMatchData *GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData `json:"phraseMatchData,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentimentData,omitempty"`
	// SilenceData: Data specifying silence.
	SilenceData *GoogleCloudContactcenterinsightsV1alpha1SilenceData `json:"silenceData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationEndBoundary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CallAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CallAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Conversation: The conversation
// resource.
type GoogleCloudContactcenterinsightsV1alpha1Conversation struct {
	// AgentId: An opaque, user-specified string representing the human agent who
	// handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// CallMetadata: Call-specific metadata.
	CallMetadata *GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata `json:"callMetadata,omitempty"`
	// CreateTime: Output only. The time at which the conversation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataSource: The source of the audio and transcription for the conversation.
	DataSource *GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource `json:"dataSource,omitempty"`
	// DialogflowIntents: Output only. All the matched Dialogflow intents in the
	// call. The key corresponds to a Dialogflow intent, format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntents map[string]GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent `json:"dialogflowIntents,omitempty"`
	// Duration: Output only. The duration of the conversation.
	Duration string `json:"duration,omitempty"`
	// ExpireTime: The time at which this conversation should expire. After this
	// time, the conversation data and any associated analyses will be deleted.
	ExpireTime string `json:"expireTime,omitempty"`
	// Labels: A map for the user to specify any custom fields. A maximum of 100
	// labels per conversation is allowed, with a maximum of 256 characters per
	// entry.
	Labels map[string]string `json:"labels,omitempty"`
	// LanguageCode: A user-specified language code for the conversation.
	LanguageCode string `json:"languageCode,omitempty"`
	// LatestAnalysis: Output only. The conversation's latest analysis, if one
	// exists.
	LatestAnalysis *GoogleCloudContactcenterinsightsV1alpha1Analysis `json:"latestAnalysis,omitempty"`
	// LatestSummary: Output only. Latest summary of the conversation.
	LatestSummary *GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData `json:"latestSummary,omitempty"`
	// Medium: Immutable. The conversation medium, if unspecified will default to
	// PHONE_CALL.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// MetadataJson: Input only. JSON metadata encoded as a string. This field is
	// primarily used by Insights integrations with various telephony systems and
	// must be in one of Insight's supported formats.
	MetadataJson string `json:"metadataJson,omitempty"`
	// Name: Immutable. The resource name of the conversation. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	Name string `json:"name,omitempty"`
	// ObfuscatedUserId: Obfuscated user ID which the customer sent to us.
	ObfuscatedUserId string `json:"obfuscatedUserId,omitempty"`
	// QualityMetadata: Conversation metadata related to quality management.
	QualityMetadata *GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata `json:"qualityMetadata,omitempty"`
	// RuntimeAnnotations: Output only. The annotations that were generated during
	// the customer and agent interaction.
	RuntimeAnnotations []*GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation `json:"runtimeAnnotations,omitempty"`
	// StartTime: The time at which the conversation started.
	StartTime string `json:"startTime,omitempty"`
	// Transcript: Output only. The conversation transcript.
	Transcript *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript `json:"transcript,omitempty"`
	// Ttl: Input only. The TTL for this resource. If specified, then this TTL will
	// be used to calculate the expire time.
	Ttl string `json:"ttl,omitempty"`
	// TurnCount: Output only. The number of turns in the conversation.
	TurnCount int64 `json:"turnCount,omitempty"`
	// UpdateTime: Output only. The most recent time at which the conversation was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata:
// Call-specific metadata.
type GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata struct {
	// AgentChannel: The audio channel that contains the agent.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// CustomerChannel: The audio channel that contains the customer.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource: The
// conversation source, which is a combination of transcript and audio.
type GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource struct {
	// DialogflowSource: The source when the conversation comes from Dialogflow.
	DialogflowSource *GoogleCloudContactcenterinsightsV1alpha1DialogflowSource `json:"dialogflowSource,omitempty"`
	// GcsSource: A Cloud Storage location specification for the audio and
	// transcript.
	GcsSource *GoogleCloudContactcenterinsightsV1alpha1GcsSource `json:"gcsSource,omitempty"`
	// MetadataUri: Cloud Storage URI that points to a file that contains the
	// conversation metadata.
	MetadataUri string `json:"metadataUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment: One
// channel of conversation-level sentiment data.
type GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment struct {
	// ChannelTag: The channel of the audio that the data applies to.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// SentimentData: Data specifying sentiment.
	SentimentData *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentimentData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence:
// Conversation-level silence data.
type GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence struct {
	// SilenceDuration: Amount of time calculated to be in silence.
	SilenceDuration string `json:"silenceDuration,omitempty"`
	// SilencePercentage: Percentage of the total conversation spent in silence.
	SilencePercentage float64 `json:"silencePercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SilenceDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SilenceDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence
	var s1 struct {
		SilencePercentage gensupport.JSONFloat64 `json:"silencePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SilencePercentage = float64(s1.SilencePercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant: The call
// participant speaking for a given utterance.
type GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant struct {
	// DialogflowParticipant: Deprecated. Use `dialogflow_participant_name`
	// instead. The name of the Dialogflow participant. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipant string `json:"dialogflowParticipant,omitempty"`
	// DialogflowParticipantName: The name of the participant provided by
	// Dialogflow. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/particip
	// ants/{participant}
	DialogflowParticipantName string `json:"dialogflowParticipantName,omitempty"`
	// ObfuscatedExternalUserId: Obfuscated user ID from Dialogflow.
	ObfuscatedExternalUserId string `json:"obfuscatedExternalUserId,omitempty"`
	// Role: The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	Role string `json:"role,omitempty"`
	// UserId: A user-specified ID representing the participant.
	UserId string `json:"userId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DialogflowParticipant") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DialogflowParticipant") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata:
// Conversation metadata related to quality management.
type GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata struct {
	// AgentInfo: Information about agents involved in the call.
	AgentInfo []*GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo `json:"agentInfo,omitempty"`
	// CustomerSatisfactionRating: An arbitrary integer value indicating the
	// customer's satisfaction rating.
	CustomerSatisfactionRating int64 `json:"customerSatisfactionRating,omitempty"`
	// FeedbackLabels: Input only. The feedback labels associated with the
	// conversation.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// MenuPath: An arbitrary string value specifying the menu path the customer
	// took.
	MenuPath string `json:"menuPath,omitempty"`
	// WaitDuration: The amount of time the customer waited to connect with an
	// agent.
	WaitDuration string `json:"waitDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo:
//
//	Information about an agent involved in the conversation.
type GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo struct {
	// AgentId: A user-specified string representing the agent.
	AgentId string `json:"agentId,omitempty"`
	// AgentType: The agent type, e.g. HUMAN_AGENT.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant's role is not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent.
	//   "END_USER" - Participant is an end user who conversed with the contact
	// center.
	//   "ANY_AGENT" - Participant is either a human or automated agent.
	AgentType string `json:"agentType,omitempty"`
	// DisplayName: The agent's name.
	DisplayName string `json:"displayName,omitempty"`
	// DispositionCode: A user-provided string indicating the outcome of the
	// agent's segment of the call.
	DispositionCode string `json:"dispositionCode,omitempty"`
	// Location: The agent's location.
	Location string `json:"location,omitempty"`
	// Team: A user-specified string representing the agent's team. Deprecated in
	// favor of the `teams` field.
	Team string `json:"team,omitempty"`
	// Teams: User-specified strings representing the agent's teams.
	Teams []string `json:"teams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionDa
// ta: Conversation summarization suggestion data.
type GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData struct {
	// AnswerRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: The confidence score of the summarization.
	Confidence float64 `json:"confidence,omitempty"`
	// ConversationModel: The name of the model that generates this summary.
	// Format:
	// projects/{project}/locations/{location}/conversationModels/{conversation_mode
	// l}
	ConversationModel string `json:"conversationModel,omitempty"`
	// GeneratorId: Agent Assist generator ID.
	GeneratorId string `json:"generatorId,omitempty"`
	// Metadata: A map that contains metadata about the summarization and the
	// document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Text: The summarization content that is concatenated into one string.
	Text string `json:"text,omitempty"`
	// TextSections: The summarization content that is divided into sections. The
	// key is the section's name and the value is the section's content. There is
	// no specific format for the key or value.
	TextSections map[string]string `json:"textSections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript: A message
// representing the transcript of a conversation.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript struct {
	// TranscriptSegments: A list of sequential transcript segments that comprise
	// the conversation.
	TranscriptSegments []*GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment `json:"transcriptSegments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TranscriptSegments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TranscriptSegments") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegme
// nt: A segment of a full transcript.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment struct {
	// ChannelTag: For conversations derived from multi-channel audio, this is the
	// channel number corresponding to the audio from that channel. For
	// audioChannelCount = N, its output values can range from '1' to 'N'. A
	// channel tag of 0 indicates that the audio is mono.
	ChannelTag int64 `json:"channelTag,omitempty"`
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this segment. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowSegmentMetadata: CCAI metadata relating to the current transcript
	// segment.
	DialogflowSegmentMetadata *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata `json:"dialogflowSegmentMetadata,omitempty"`
	// LanguageCode: The language code of this segment as a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// MessageTime: The time that the message occurred, if provided.
	MessageTime string `json:"messageTime,omitempty"`
	// SegmentParticipant: The participant of this segment.
	SegmentParticipant *GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant `json:"segmentParticipant,omitempty"`
	// Sentiment: The sentiment for this transcript segment.
	Sentiment *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentiment,omitempty"`
	// Text: The text of this segment.
	Text string `json:"text,omitempty"`
	// Words: A list of the word-specific information for each word in the segment.
	Words []*GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo `json:"words,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChannelTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChannelTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegme
// ntDialogflowSegmentMetadata: Metadata from Dialogflow relating to the
// current transcript segment.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata struct {
	// SmartReplyAllowlistCovered: Whether the transcript segment was covered under
	// the configured smart reply allowlist in Agent Assist.
	SmartReplyAllowlistCovered bool `json:"smartReplyAllowlistCovered,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SmartReplyAllowlistCovered")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SmartReplyAllowlistCovered") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegme
// ntWordInfo: Word-level info for words in a transcript.
type GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo struct {
	// Confidence: A confidence estimate between 0.0 and 1.0 of the fidelity of
	// this word. A default value of 0.0 indicates that the value is unset.
	Confidence float64 `json:"confidence,omitempty"`
	// EndOffset: Time offset of the end of this word relative to the beginning of
	// the total conversation.
	EndOffset string `json:"endOffset,omitempty"`
	// StartOffset: Time offset of the start of this word relative to the beginning
	// of the total conversation.
	StartOffset string `json:"startOffset,omitempty"`
	// Word: The word itself. Includes punctuation marks that surround the word.
	Word string `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata:
// Metadata for a create analysis operation.
type GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata struct {
	// AnnotatorSelector: Output only. The annotator selector used for the analysis
	// (if any).
	AnnotatorSelector *GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector `json:"annotatorSelector,omitempty"`
	// Conversation: Output only. The Conversation that this Analysis Operation
	// belongs to.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotatorSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotatorSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueMetadata: Metadata for
// creating an issue.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateIssueMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata: Metadata
// for creating an issue model.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for creation.
	Request *GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest: The request
// to create an issue model.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest struct {
	// IssueModel: Required. The issue model to create.
	IssueModel *GoogleCloudContactcenterinsightsV1alpha1IssueModel `json:"issueModel,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest: The request to
// create an issue.
type GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest struct {
	// Issue: Required. The values for the new issue.
	Issue *GoogleCloudContactcenterinsightsV1alpha1Issue `json:"issue,omitempty"`
	// Parent: Required. The parent resource of the issue.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Issue") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Issue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Dataset: Dataset resource represents
// a collection of conversations that may be bounded (Static Dataset, e.g.
// golden dataset for training), or unbounded (Dynamic Dataset, e.g. live
// traffic, or agent training traffic)
type GoogleCloudContactcenterinsightsV1alpha1Dataset struct {
	// CreateTime: Output only. Dataset create time.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Dataset description.
	Description string `json:"description,omitempty"`
	// DisplayName: Display name for the dataaset
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. Identifier. Resource name of the dataset. Format:
	// projects/{project}/locations/{location}/datasets/{dataset}
	Name string `json:"name,omitempty"`
	// Ttl: Optional. Option TTL for the dataset.
	Ttl string `json:"ttl,omitempty"`
	// Type: Dataset usage type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value for unspecified.
	//   "EVAL" - For evals only.
	//   "LIVE" - Dataset with new conversations coming in regularly (Insights
	// legacy conversations and AI trainer)
	Type string `json:"type,omitempty"`
	// UpdateTime: Output only. Dataset update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata: Metadata
// for deleting an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deletion.
	Request *GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest: The request
// to delete an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest struct {
	// Name: Required. The name of the issue model to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagMetadata: The
// metadata for deleting a QaQuestionTag Resource.
type GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest: The
// request for deleting a QaQuestionTag.
type GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest struct {
	// Name: Required. The name of the QaQuestionTag to delete.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata: Metadata
// for deploying an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for deployment.
	Request *GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest: The request
// to deploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest struct {
	// Name: Required. The issue model to deploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelResponse: The
// response to deploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent: The data for a
// Dialogflow intent. Represents a detected intent in the conversation, e.g.
// MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData:
// Dialogflow interaction data.
type GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData struct {
	// Confidence: The confidence of the match ranging from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// DialogflowIntentId: The Dialogflow intent resource path. Format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntentId string `json:"dialogflowIntentId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1DialogflowSource: A Dialogflow
// source of conversation data.
type GoogleCloudContactcenterinsightsV1alpha1DialogflowSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// DialogflowConversation: Output only. The name of the Dialogflow conversation
	// that this conversation resource is derived from. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	DialogflowConversation string `json:"dialogflowConversation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DialogflowSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DialogflowSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Dimension: A dimension determines
// the grouping key for the query. In SQL terms, these would be part of both
// the "SELECT" and "GROUP BY" clauses.
type GoogleCloudContactcenterinsightsV1alpha1Dimension struct {
	// AgentDimensionMetadata: Output only. Metadata about the agent dimension.
	AgentDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata `json:"agentDimensionMetadata,omitempty"`
	// DimensionKey: The key of the dimension.
	//
	// Possible values:
	//   "DIMENSION_KEY_UNSPECIFIED" - The key of the dimension is unspecified.
	//   "ISSUE" - The dimension is keyed by issues.
	//   "ISSUE_NAME" - The dimension is keyed by issue names.
	//   "AGENT" - The dimension is keyed by agents.
	//   "AGENT_TEAM" - The dimension is keyed by agent teams.
	//   "QA_QUESTION_ID" - The dimension is keyed by QaQuestionIds. Note that: We
	// only group by the QuestionId and not the revision-id of the scorecard this
	// question is a part of. This allows for showing stats for the same question
	// across different scorecard revisions.
	//   "QA_QUESTION_ANSWER_VALUE" - The dimension is keyed by
	// QaQuestionIds-Answer value pairs. Note that: We only group by the QuestionId
	// and not the revision-id of the scorecard this question is a part of. This
	// allows for showing distribution of answers per question across different
	// scorecard revisions.
	//   "QA_SCORECARD_ID" - The dimension is keyed by QaScorecardIds. Note that:
	// We only group by the ScorecardId and not the revision-id of the scorecard.
	// This allows for showing stats for the same scorecard across different
	// revisions. This metric is mostly only useful if querying the average
	// normalized score per scorecard.
	//   "CONVERSATION_PROFILE_ID" - The dimension is keyed by the conversation
	// profile ID.
	//   "MEDIUM" - The dimension is keyed by the conversation medium.
	DimensionKey string `json:"dimensionKey,omitempty"`
	// IssueDimensionMetadata: Output only. Metadata about the issue dimension.
	IssueDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata `json:"issueDimensionMetadata,omitempty"`
	// QaQuestionAnswerDimensionMetadata: Output only. Metadata about the QA
	// question-answer dimension.
	QaQuestionAnswerDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata `json:"qaQuestionAnswerDimensionMetadata,omitempty"`
	// QaQuestionDimensionMetadata: Output only. Metadata about the QA question
	// dimension.
	QaQuestionDimensionMetadata *GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata `json:"qaQuestionDimensionMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDimensionMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Dimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Dimension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata:
// Metadata about the agent dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata struct {
	// AgentDisplayName: Optional. The agent's name
	AgentDisplayName string `json:"agentDisplayName,omitempty"`
	// AgentId: Optional. A user-specified string representing the agent.
	AgentId string `json:"agentId,omitempty"`
	// AgentTeam: Optional. A user-specified string representing the agent's team.
	AgentTeam string `json:"agentTeam,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata:
// Metadata about the issue dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata struct {
	// IssueDisplayName: The issue display name.
	IssueDisplayName string `json:"issueDisplayName,omitempty"`
	// IssueId: The issue ID.
	IssueId string `json:"issueId,omitempty"`
	// IssueModelId: The parent issue model ID.
	IssueModelId string `json:"issueModelId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMet
// adata: Metadata about the QA question-answer dimension. This is useful for
// showing the answer distribution for questions for a given scorecard.
type GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata struct {
	// AnswerValue: Optional. The full body of the question.
	AnswerValue string `json:"answerValue,omitempty"`
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata:
//
//	Metadata about the QA question dimension.
type GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata struct {
	// QaQuestionId: Optional. The QA question ID.
	QaQuestionId string `json:"qaQuestionId,omitempty"`
	// QaScorecardId: Optional. The QA scorecard ID.
	QaScorecardId string `json:"qaScorecardId,omitempty"`
	// QuestionBody: Optional. The full body of the question.
	QuestionBody string `json:"questionBody,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec: A customer-managed
// encryption key specification that can be applied to all created resources
// (e.g. `Conversation`).
type GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec struct {
	// KmsKey: Required. The name of customer-managed encryption key that is used
	// to secure a resource and its sub-resources. If empty, the resource is
	// secured by our default encryption key. Only the key in the same location as
	// this resource is allowed to be used for encryption. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKey string `json:"kmsKey,omitempty"`
	// Name: Immutable. The resource name of the encryption key specification
	// resource. Format: projects/{project}/locations/{location}/encryptionSpec
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1Entity: The data for an entity
// annotation. Represents a phrase in the conversation that is a known entity,
// such as a person, an organization, or location.
type GoogleCloudContactcenterinsightsV1alpha1Entity struct {
	// DisplayName: The representative name for the entity.
	DisplayName string `json:"displayName,omitempty"`
	// Metadata: Metadata associated with the entity. For most entity types, the
	// metadata is a Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID
	// (`mid`), if they are available. For the metadata associated with other
	// entity types, see the Type table below.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Salience: The salience score associated with the entity in the [0, 1.0]
	// range. The salience score for an entity provides information about the
	// importance or centrality of that entity to the entire document text. Scores
	// closer to 0 are less salient, while scores closer to 1.0 are highly salient.
	Salience float64 `json:"salience,omitempty"`
	// Sentiment: The aggregate sentiment expressed for this entity in the
	// conversation.
	Sentiment *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentiment,omitempty"`
	// Type: The entity type.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified.
	//   "PERSON" - Person.
	//   "LOCATION" - Location.
	//   "ORGANIZATION" - Organization.
	//   "EVENT" - Event.
	//   "WORK_OF_ART" - Artwork.
	//   "CONSUMER_GOOD" - Consumer product.
	//   "OTHER" - Other types of entities.
	//   "PHONE_NUMBER" - Phone number. The metadata lists the phone number
	// (formatted according to local convention), plus whichever additional
	// elements appear in the text: * `number` - The actual number, broken down
	// into sections according to local convention. * `national_prefix` - Country
	// code, if detected. * `area_code` - Region or area code, if detected. *
	// `extension` - Phone extension (to be dialed after connection), if detected.
	//   "ADDRESS" - Address. The metadata identifies the street number and
	// locality plus whichever additional elements appear in the text: *
	// `street_number` - Street number. * `locality` - City or town. *
	// `street_name` - Street/route name, if detected. * `postal_code` - Postal
	// code, if detected. * `country` - Country, if detected. * `broad_region` -
	// Administrative area, such as the state, if detected. * `narrow_region` -
	// Smaller administrative area, such as county, if detected. * `sublocality` -
	// Used in Asian addresses to demark a district within a city, if detected.
	//   "DATE" - Date. The metadata identifies the components of the date: *
	// `year` - Four digit year, if detected. * `month` - Two digit month number,
	// if detected. * `day` - Two digit day number, if detected.
	//   "NUMBER" - Number. The metadata is the number itself.
	//   "PRICE" - Price. The metadata identifies the `value` and `currency`.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Entity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Entity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1Entity) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Entity
	var s1 struct {
		Salience gensupport.JSONFloat64 `json:"salience"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Salience = float64(s1.Salience)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1EntityMentionData: The data for an
// entity mention annotation. This represents a mention of an `Entity` in the
// conversation.
type GoogleCloudContactcenterinsightsV1alpha1EntityMentionData struct {
	// EntityUniqueId: The key of this entity in conversation entities. Can be used
	// to retrieve the exact `Entity` this mention is attached to.
	EntityUniqueId string `json:"entityUniqueId,omitempty"`
	// Sentiment: Sentiment expressed for this mention of the entity.
	Sentiment *GoogleCloudContactcenterinsightsV1alpha1SentimentData `json:"sentiment,omitempty"`
	// Type: The type of the entity mention.
	//
	// Possible values:
	//   "MENTION_TYPE_UNSPECIFIED" - Unspecified.
	//   "PROPER" - Proper noun.
	//   "COMMON" - Common noun (or noun compound).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1EntityMentionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1EntityMentionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata: Metadata
// for an export insights operation.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata struct {
	// CompletedExportCount: The number of conversations that were exported
	// successfully.
	CompletedExportCount int64 `json:"completedExportCount,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// FailedExportCount: The number of conversations that failed to be exported.
	FailedExportCount int64 `json:"failedExportCount,omitempty"`
	// PartialErrors: Partial errors during export operation that might cause the
	// operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: The original request for export.
	Request *GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedExportCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedExportCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest: The
// request to export insights.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest struct {
	// BigQueryDestination: Specified if sink is a BigQuery table.
	BigQueryDestination *GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination `json:"bigQueryDestination,omitempty"`
	// ExportSchemaVersion: Optional. Version of the export schema.
	//
	// Possible values:
	//   "EXPORT_SCHEMA_VERSION_UNSPECIFIED" - Unspecified. Defaults to EXPORT_V3.
	//   "EXPORT_V1" - Export schema version 1.
	//   "EXPORT_V2" - Export schema version 2.
	//   "EXPORT_V3" - Export schema version 3.
	//   "EXPORT_V4" - Export schema version 4.
	//   "EXPORT_V5" - Export schema version 5.
	//   "EXPORT_V6" - Export schema version 6.
	//   "EXPORT_V7" - Export schema version 7.
	//   "EXPORT_V8" - Export schema version 8.
	//   "EXPORT_V9" - Export schema version 9.
	//   "EXPORT_V10" - Export schema version 10.
	//   "EXPORT_VERSION_LATEST_AVAILABLE" - Export schema version latest
	// available.
	ExportSchemaVersion string `json:"exportSchemaVersion,omitempty"`
	// Filter: A filter to reduce results to a specific subset. Useful for
	// exporting conversations with specific properties.
	Filter string `json:"filter,omitempty"`
	// KmsKey: A fully qualified KMS key name for BigQuery tables protected by
	// CMEK. Format:
	// projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/c
	// ryptoKeyVersions/{version}
	KmsKey string `json:"kmsKey,omitempty"`
	// Parent: Required. The parent resource to export data from.
	Parent string `json:"parent,omitempty"`
	// WriteDisposition: Options for what to do if the destination table already
	// exists.
	//
	// Possible values:
	//   "WRITE_DISPOSITION_UNSPECIFIED" - Write disposition is not specified.
	// Defaults to WRITE_TRUNCATE.
	//   "WRITE_TRUNCATE" - If the table already exists, BigQuery will overwrite
	// the table data and use the schema from the load.
	//   "WRITE_APPEND" - If the table already exists, BigQuery will append data to
	// the table.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDest
// ination: A BigQuery Table Reference.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination struct {
	// Dataset: Required. The name of the BigQuery dataset that the snapshot result
	// should be exported to. If this dataset does not exist, the export call
	// returns an INVALID_ARGUMENT error.
	Dataset string `json:"dataset,omitempty"`
	// ProjectId: A project ID or number. If specified, then export will attempt to
	// write data to this project instead of the resource project. Otherwise, the
	// resource project will be used.
	ProjectId string `json:"projectId,omitempty"`
	// Table: The BigQuery table name to which the insights data should be written.
	// If this table does not exist, the export call returns an INVALID_ARGUMENT
	// error.
	Table string `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataResponse: Response
// for an export insights operation.
type GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata: Metadata
// used for export issue model.
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original export request.
	Request *GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest: Request to
// export an issue model.
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest struct {
	// GcsDestination: Google Cloud Storage URI to export the issue model to.
	GcsDestination *GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination `json:"gcsDestination,omitempty"`
	// Name: Required. The issue model to export.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination
// : Google Cloud Storage Object URI to save the issue model to.
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelResponse: Response
// from export issue model
type GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData: Agent Assist
// frequently-asked-question answer data.
type GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`
	// ConfidenceScore: The system's confidence score that this answer is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the FAQ answer and the document
	// that it originates from.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// Source: The knowledge document that this answer was extracted from. Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel: Represents a
// conversation, resource, and label provided by the user. Can take the form of
// a string label or a QaAnswer label. QaAnswer labels are used for Quality AI
// example conversations. String labels are used for Topic Modeling.
// AgentAssistSummary labels are used for Agent Assist Summarization.
type GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel struct {
	// CreateTime: Output only. Create time of the label.
	CreateTime string `json:"createTime,omitempty"`
	// Label: String label used for Topic Modeling.
	Label string `json:"label,omitempty"`
	// LabeledResource: Name of the resource to be labeled. Supported resources
	// are: *
	// `projects/{project}/locations/{location}/qaScorecards/{scorecard}/revisions/{
	// revision}/qaQuestions/{question}` *
	// `projects/{project}/locations/{location}/issueModels/{issue_model}` *
	// `projects/{project}/locations/{location}/generators/{generator_id}`
	LabeledResource string `json:"labeledResource,omitempty"`
	// Name: Immutable. Resource name of the FeedbackLabel. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/feedback
	// Labels/{feedback_label}
	Name string `json:"name,omitempty"`
	// QaAnswerLabel: QaAnswer label used for Quality AI example conversations.
	QaAnswerLabel *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue `json:"qaAnswerLabel,omitempty"`
	// UpdateTime: Output only. Update time of the label.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1GcsSource: A Cloud Storage source of
// conversation data.
type GoogleCloudContactcenterinsightsV1alpha1GcsSource struct {
	// AudioUri: Cloud Storage URI that points to a file that contains the
	// conversation audio.
	AudioUri string `json:"audioUri,omitempty"`
	// TranscriptUri: Immutable. Cloud Storage URI that points to a file that
	// contains the conversation transcript.
	TranscriptUri string `json:"transcriptUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1HoldData: The data for a hold
// annotation.
type GoogleCloudContactcenterinsightsV1alpha1HoldData struct {
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata: Metadata
// used for import issue model.
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata struct {
	// CreateTime: The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original import request.
	Request *GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest: Request to
// import an issue model.
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest struct {
	// CreateNewModel: Optional. If set to true, will create an issue model from
	// the imported file with randomly generated IDs for the issue model and
	// corresponding issues. Otherwise, replaces an existing model with the same ID
	// as the file.
	CreateNewModel bool `json:"createNewModel,omitempty"`
	// GcsSource: Google Cloud Storage source message.
	GcsSource *GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource of the issue model.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateNewModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateNewModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource:
// Google Cloud Storage Object URI to get the issue model file from.
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource struct {
	// ObjectUri: Required. Format: `gs:///`
	ObjectUri string `json:"objectUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ObjectUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ObjectUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelResponse: Response
// from import issue model
type GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelResponse struct {
	// IssueModel: The issue model that was imported.
	IssueModel *GoogleCloudContactcenterinsightsV1alpha1IssueModel `json:"issueModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata: The
// metadata for an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// IngestConversationsStats: Output only. Statistics for IngestConversations
	// operation.
	IngestConversationsStats *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats `json:"ingestConversationsStats,omitempty"`
	// PartialErrors: Output only. Partial errors during ingest operation that
	// might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for ingest.
	Request *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest `json:"request,omitempty"`
	// SampledConversations: Output only. Stores the conversation resources
	// produced by ingest sampling operations.
	SampledConversations []string `json:"sampledConversations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConv
// ersationsStats: Statistics for IngestConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats struct {
	// DuplicatesSkippedCount: Output only. The number of objects skipped because
	// another conversation with the same transcript uri had already been ingested.
	DuplicatesSkippedCount int64 `json:"duplicatesSkippedCount,omitempty"`
	// FailedIngestCount: Output only. The number of objects which were unable to
	// be ingested due to errors. The errors are populated in the partial_errors
	// field.
	FailedIngestCount int64 `json:"failedIngestCount,omitempty"`
	// ProcessedObjectCount: Output only. The number of objects processed during
	// the ingest operation.
	ProcessedObjectCount int64 `json:"processedObjectCount,omitempty"`
	// SuccessfulIngestCount: Output only. The number of new conversations added
	// during this ingest operation.
	SuccessfulIngestCount int64 `json:"successfulIngestCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DuplicatesSkippedCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest: The
// request to ingest conversations.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest struct {
	// ConversationConfig: Configuration that applies to all conversations.
	ConversationConfig *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig `json:"conversationConfig,omitempty"`
	// GcsSource: A cloud storage bucket source. Note that any previously ingested
	// objects from the source will be skipped to avoid duplication.
	GcsSource *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource `json:"gcsSource,omitempty"`
	// Parent: Required. The parent resource for new conversations.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Optional,
	// will default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1alpha1RedactionConfig `json:"redactionConfig,omitempty"`
	// SampleSize: Optional. If set, this fields indicates the number of objects to
	// ingest from the Cloud Storage bucket. If empty, the entire bucket will be
	// ingested. Unless they are first deleted, conversations produced through
	// sampling won't be ingested by subsequent ingest requests.
	SampleSize int64 `json:"sampleSize,omitempty"`
	// SpeechConfig: Optional. Default Speech-to-Text configuration. Optional, will
	// default to the config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1alpha1SpeechConfig `json:"speechConfig,omitempty"`
	// TranscriptObjectConfig: Configuration for when `source` contains
	// conversation transcripts.
	TranscriptObjectConfig *GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig `json:"transcriptObjectConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversatio
// nConfig: Configuration that applies to all conversations.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig struct {
	// AgentChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	AgentChannel int64 `json:"agentChannel,omitempty"`
	// AgentId: Optional. An opaque, user-specified string representing a human
	// agent who handled all conversations in the import. Note that this will be
	// overridden if per-conversation metadata is provided through the
	// `metadata_bucket_uri`.
	AgentId string `json:"agentId,omitempty"`
	// CustomerChannel: Optional. Indicates which of the channels, 1 or 2, contains
	// the agent. Note that this must be set for conversations to be properly
	// displayed and analyzed.
	CustomerChannel int64 `json:"customerChannel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentChannel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentChannel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource:
// Configuration for Cloud Storage bucket sources.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource struct {
	// AudioBucketUri: Optional. The Cloud Storage path to the conversation audio
	// file. Note that: [1] Audio files will be transcribed if not already. [2]
	// Audio files and transcript files must be in separate buckets / folders. [3]
	// A source file and its corresponding audio file must share the same name to
	// be properly ingested, E.g. `gs://bucket/transcript/conversation1.json` and
	// `gs://bucket/audio/conversation1.mp3`.
	AudioBucketUri string `json:"audioBucketUri,omitempty"`
	// BucketObjectType: Optional. Specifies the type of the objects in
	// `bucket_uri`. Avoid passing this. This is inferred from the
	// `transcript_bucket_uri`, `audio_bucket_uri`.
	//
	// Possible values:
	//   "BUCKET_OBJECT_TYPE_UNSPECIFIED" - The object type is unspecified and will
	// default to `TRANSCRIPT`.
	//   "TRANSCRIPT" - The object is a transcript.
	//   "AUDIO" - The object is an audio file.
	BucketObjectType string `json:"bucketObjectType,omitempty"`
	// BucketUri: Optional. The Cloud Storage bucket containing source objects.
	// Avoid passing this. Pass this through one of `transcript_bucket_uri` or
	// `audio_bucket_uri`.
	BucketUri string `json:"bucketUri,omitempty"`
	// CustomMetadataKeys: Optional. Custom keys to extract as conversation labels
	// from metadata files in `metadata_bucket_uri`. Keys not included in this
	// field will be ignored. Note that there is a limit of 100 labels per
	// conversation.
	CustomMetadataKeys []string `json:"customMetadataKeys,omitempty"`
	// MetadataBucketUri: Optional. The Cloud Storage path to the conversation
	// metadata. Note that: [1] Metadata files are expected to be in JSON format.
	// [2] Metadata and source files (transcripts or audio) must be in separate
	// buckets / folders. [3] A source file and its corresponding metadata file
	// must share the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	MetadataBucketUri string `json:"metadataBucketUri,omitempty"`
	// TranscriptBucketUri: Optional. The Cloud Storage path to the conversation
	// transcripts. Note that: [1] Transcript files are expected to be in JSON
	// format. [2] Transcript, audio, metadata files must be in separate buckets /
	// folders. [3] A source file and its corresponding metadata file must share
	// the same name to be properly ingested, E.g.
	// `gs://bucket/audio/conversation1.mp3` and
	// `gs://bucket/metadata/conversation1.json`.
	TranscriptBucketUri string `json:"transcriptBucketUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioBucketUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioBucketUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptO
// bjectConfig: Configuration for processing transcript objects.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig struct {
	// Medium: Required. The medium transcript objects represent.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IngestConversationsResponse: The
// response to an IngestConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1IngestConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata:
// Metadata for initializing a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Partial errors during initializing operation that might cause
	// the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for initialization.
	Request *GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest: The
// request to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest struct {
	// EncryptionSpec: Required. The encryption spec used for CMEK encryption. It
	// is required that the kms key is in the same region as the endpoint. The same
	// key will be used for all provisioned resources, if encryption is available.
	// If the `kms_key_name` field is left empty, no encryption will be enforced.
	EncryptionSpec *GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecResponse:
// The response to initialize a location-level encryption specification.
type GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1Intent: The data for an intent.
// Represents a detected intent in the conversation, for example MAKES_PROMISE.
type GoogleCloudContactcenterinsightsV1alpha1Intent struct {
	// DisplayName: The human-readable name of the intent.
	DisplayName string `json:"displayName,omitempty"`
	// Id: The unique identifier of the intent.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IntentMatchData: The data for an
// intent match. Represents an intent match for a text segment in the
// conversation. A text segment can be part of a sentence, a complete sentence,
// or an utterance with multiple sentences.
type GoogleCloudContactcenterinsightsV1alpha1IntentMatchData struct {
	// IntentUniqueId: The id of the matched intent. Can be used to retrieve the
	// corresponding intent information.
	IntentUniqueId string `json:"intentUniqueId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentUniqueId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentUniqueId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IntentMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IntentMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1InterruptionData: The data for an
// interruption annotation.
type GoogleCloudContactcenterinsightsV1alpha1InterruptionData struct {
}

// GoogleCloudContactcenterinsightsV1alpha1Issue: The issue resource.
type GoogleCloudContactcenterinsightsV1alpha1Issue struct {
	// CreateTime: Output only. The time at which this issue was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayDescription: Representative description of the issue.
	DisplayDescription string `json:"displayDescription,omitempty"`
	// DisplayName: The representative name for the issue.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Immutable. The resource name of the issue. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{iss
	// ue}
	Name string `json:"name,omitempty"`
	// SampleUtterances: Output only. Resource names of the sample representative
	// utterances that match to this issue.
	SampleUtterances []string `json:"sampleUtterances,omitempty"`
	// UpdateTime: Output only. The most recent time that this issue was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1Issue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1Issue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueAssignment: Information about
// the issue.
type GoogleCloudContactcenterinsightsV1alpha1IssueAssignment struct {
	// DisplayName: Immutable. Display name of the assigned issue. This field is
	// set at time of analysis and immutable since then.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Resource name of the assigned issue.
	Issue string `json:"issue,omitempty"`
	// Score: Score indicating the likelihood of the issue assignment. currently
	// bounded on [0,1].
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueAssignment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueAssignment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1IssueAssignment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueAssignment
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1IssueMatchData: The data for an
// issue match annotation.
type GoogleCloudContactcenterinsightsV1alpha1IssueMatchData struct {
	// IssueAssignment: Information about the issue's assignment.
	IssueAssignment *GoogleCloudContactcenterinsightsV1alpha1IssueAssignment `json:"issueAssignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueAssignment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueAssignment") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModel: The issue model
// resource.
type GoogleCloudContactcenterinsightsV1alpha1IssueModel struct {
	// CreateTime: Output only. The time at which this issue model was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The representative name for the issue model.
	DisplayName string `json:"displayName,omitempty"`
	// InputDataConfig: Configs for the input data that used to create the issue
	// model.
	InputDataConfig *GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig `json:"inputDataConfig,omitempty"`
	// IssueCount: Output only. Number of issues in this issue model.
	IssueCount int64 `json:"issueCount,omitempty,string"`
	// LanguageCode: Language of the model.
	LanguageCode string `json:"languageCode,omitempty"`
	// ModelType: Type of the model.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Unspecified model type.
	//   "TYPE_V1" - Type V1.
	//   "TYPE_V2" - Type V2.
	ModelType string `json:"modelType,omitempty"`
	// Name: Immutable. The resource name of the issue model. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	Name string `json:"name,omitempty"`
	// State: Output only. State of the model.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "UNDEPLOYED" - Model is not deployed but is ready to deploy.
	//   "DEPLOYING" - Model is being deployed.
	//   "DEPLOYED" - Model is deployed and is ready to be used. A model can only
	// be used in analysis if it's in this state.
	//   "UNDEPLOYING" - Model is being undeployed.
	//   "DELETING" - Model is being deleted.
	State string `json:"state,omitempty"`
	// TrainingStats: Output only. Immutable. The issue model's label statistics on
	// its training data.
	TrainingStats *GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats `json:"trainingStats,omitempty"`
	// UpdateTime: Output only. The most recent time at which the issue model was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig: Configs
// for the input data used to create the issue model.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig struct {
	// Filter: A filter to reduce the conversations used for training the model to
	// a specific subset. Refer to
	// https://cloud.google.com/contact-center/insights/docs/filtering for details.
	Filter string `json:"filter,omitempty"`
	// Medium: Medium of conversations used in training data. This field is being
	// deprecated. To specify the medium to be used in training a new issue model,
	// set the `medium` field on `filter`.
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - Default value, if unspecified will default to
	// PHONE_CALL.
	//   "PHONE_CALL" - The format for conversations that took place over the
	// phone.
	//   "CHAT" - The format for conversations that took place over chat.
	Medium string `json:"medium,omitempty"`
	// TrainingConversationsCount: Output only. Number of conversations used in
	// training. Output only.
	TrainingConversationsCount int64 `json:"trainingConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats: Aggregated
// statistics about an issue model.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats struct {
	// AnalyzedConversationsCount: Number of conversations the issue model has
	// analyzed at this point in time.
	AnalyzedConversationsCount int64 `json:"analyzedConversationsCount,omitempty,string"`
	// IssueStats: Statistics on each issue. Key is the issue's resource name.
	IssueStats map[string]GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats `json:"issueStats,omitempty"`
	// UnclassifiedConversationsCount: Number of analyzed conversations for which
	// no issue was applicable at this point in time.
	UnclassifiedConversationsCount int64 `json:"unclassifiedConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "AnalyzedConversationsCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyzedConversationsCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats:
// Aggregated statistics about an issue.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats struct {
	// DisplayName: Display name of the issue.
	DisplayName string `json:"displayName,omitempty"`
	// Issue: Issue resource. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{iss
	// ue}
	Issue string `json:"issue,omitempty"`
	// LabeledConversationsCount: Number of conversations attached to the issue at
	// this point in time.
	LabeledConversationsCount int64 `json:"labeledConversationsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1IssueModelResult: Issue Modeling
// result on a conversation.
type GoogleCloudContactcenterinsightsV1alpha1IssueModelResult struct {
	// IssueModel: Issue model that generates the result. Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	IssueModel string `json:"issueModel,omitempty"`
	// Issues: All the matched issues.
	Issues []*GoogleCloudContactcenterinsightsV1alpha1IssueAssignment `json:"issues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IssueModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IssueModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1IssueModelResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1IssueModelResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse: The
// response for listing all feedback labels.
type GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse: The
// response for listing feedback labels.
type GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse struct {
	// FeedbackLabels: The feedback labels that match the request.
	FeedbackLabels []*GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel `json:"feedbackLabels,omitempty"`
	// NextPageToken: The next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeedbackLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeedbackLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData: The data for a
// matched phrase matcher. Represents information identifying a phrase matcher
// for a given match.
type GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData struct {
	// DisplayName: The human-readable name of the phrase matcher.
	DisplayName string `json:"displayName,omitempty"`
	// PhraseMatcher: The unique identifier (the resource name) of the phrase
	// matcher.
	PhraseMatcher string `json:"phraseMatcher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QaAnswer: An answer to a QaQuestion.
type GoogleCloudContactcenterinsightsV1alpha1QaAnswer struct {
	// AnswerSources: List of all individual answers given to the question.
	AnswerSources []*GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource `json:"answerSources,omitempty"`
	// AnswerValue: The main answer value, incorporating any manual edits if they
	// exist.
	AnswerValue *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// Conversation: The conversation the answer applies to.
	Conversation string `json:"conversation,omitempty"`
	// QaQuestion: The QaQuestion answered by this answer.
	QaQuestion string `json:"qaQuestion,omitempty"`
	// QuestionBody: Question text. E.g., "Did the agent greet the customer?"
	QuestionBody string `json:"questionBody,omitempty"`
	// Tags: User-defined list of arbitrary tags. Matches the value from
	// QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and for
	// weighting the score of each answer.
	Tags []string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerSources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource: A question may
// have multiple answers from varying sources, one of which becomes the "main"
// answer above. AnswerSource represents each individual answer.
type GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource struct {
	// AnswerValue: The answer value from this source.
	AnswerValue *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue `json:"answerValue,omitempty"`
	// SourceType: What created the answer.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED" - Answer was system-generated; created during an
	// Insights analysis.
	//   "MANUAL_EDIT" - Answer was created by a human via manual edit.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue: Message for
// holding the value of a QaAnswer. QaQuestion.AnswerChoice defines the
// possible answer values for a question.
type GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue struct {
	// BoolValue: Boolean value.
	BoolValue bool `json:"boolValue,omitempty"`
	// Key: A short string used as an identifier. Matches the value used in
	// QaQuestion.AnswerChoice.key.
	Key string `json:"key,omitempty"`
	// NaValue: A value of "Not Applicable (N/A)". Should only ever be `true`.
	NaValue bool `json:"naValue,omitempty"`
	// NormalizedScore: Output only. Normalized score of the questions. Calculated
	// as score / potential_score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// NumValue: Numerical value.
	NumValue float64 `json:"numValue,omitempty"`
	// PotentialScore: Output only. The maximum potential score of the question.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: Output only. Numerical score of the answer.
	Score float64 `json:"score,omitempty"`
	// SkipValue: Output only. A value of "Skip". If provided, this field may only
	// be set to `true`. If a question receives this answer, it will be excluded
	// from any score calculations. This would mean that the question was not
	// evaluated.
	SkipValue bool `json:"skipValue,omitempty"`
	// StrValue: String value.
	StrValue string `json:"strValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		NumValue        gensupport.JSONFloat64 `json:"numValue"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.NumValue = float64(s1.NumValue)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag: A tag is a resource
// which aims to categorize a set of questions across multiple scorecards,
// e.g., "Customer Satisfaction","Billing", etc.
type GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag struct {
	// CreateTime: Output only. The time at which the question tag was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. A user-specified display name for the tag.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. Resource name for the QaQuestionTag Format
	// projects/{project}/locations/{location}/qaQuestionTags/{qa_question_tag} In
	// the above format, the last segment, i.e., qa_question_tag, is a
	// server-generated ID corresponding to the tag resource.
	Name string `json:"name,omitempty"`
	// QaQuestionIds: Optional. The list of Scorecard Question IDs that the tag
	// applies to. Each QaQuestionId is represented as a full resource name
	// containing the Question ID. Lastly, Since a tag may not necessarily be
	// referenced by any Scorecard Questions, we treat this field as optional.
	QaQuestionIds []string `json:"qaQuestionIds,omitempty"`
	// UpdateTime: Output only. The most recent time at which the question tag was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult: The results of
// scoring a single conversation against a QaScorecard. Contains a collection
// of QaAnswers and aggregate score.
type GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult struct {
	// AgentId: ID of the agent that handled the conversation.
	AgentId string `json:"agentId,omitempty"`
	// Conversation: The conversation scored by this result.
	Conversation string `json:"conversation,omitempty"`
	// CreateTime: Output only. The timestamp that the revision was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Identifier. The name of the scorecard result. Format:
	// projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_resu
	// lt}
	Name string `json:"name,omitempty"`
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score. Any manual edits are included if they exist.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaAnswers: Set of QaAnswers represented in the result.
	QaAnswers []*GoogleCloudContactcenterinsightsV1alpha1QaAnswer `json:"qaAnswers,omitempty"`
	// QaScorecardRevision: The QaScorecardRevision scored by this result.
	QaScorecardRevision string `json:"qaScorecardRevision,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result, incorporating any manual
	// edits if they exist.
	Score float64 `json:"score,omitempty"`
	// ScoreSources: List of all individual score sets.
	ScoreSources []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource `json:"scoreSources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult: Tags
// and their corresponding results.
type GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult struct {
	// NormalizedScore: The normalized score the tag applies to.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The potential score the tag applies to.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// Score: The score the tag applies to.
	Score float64 `json:"score,omitempty"`
	// Tag: The tag the score applies to.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource: A
// scorecard result may have multiple sets of scores from varying sources, one
// of which becomes the "main" answer above. A ScoreSource represents each
// individual set of scores.
type GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource struct {
	// NormalizedScore: The normalized score, which is the score divided by the
	// potential score.
	NormalizedScore float64 `json:"normalizedScore,omitempty"`
	// PotentialScore: The maximum potential overall score of the scorecard. Any
	// questions answered using `na_value` are excluded from this calculation.
	PotentialScore float64 `json:"potentialScore,omitempty"`
	// QaTagResults: Collection of tags and their scores.
	QaTagResults []*GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult `json:"qaTagResults,omitempty"`
	// Score: The overall numerical score of the result.
	Score float64 `json:"score,omitempty"`
	// SourceType: What created the score.
	//
	// Possible values:
	//   "SOURCE_TYPE_UNSPECIFIED" - Source type is unspecified.
	//   "SYSTEM_GENERATED_ONLY" - Score is derived only from system-generated
	// answers.
	//   "INCLUDES_MANUAL_EDITS" - Score is derived from both system-generated
	// answers, and includes any manual edits if they exist.
	SourceType string `json:"sourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NormalizedScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NormalizedScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource
	var s1 struct {
		NormalizedScore gensupport.JSONFloat64 `json:"normalizedScore"`
		PotentialScore  gensupport.JSONFloat64 `json:"potentialScore"`
		Score           gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NormalizedScore = float64(s1.NormalizedScore)
	s.PotentialScore = float64(s1.PotentialScore)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsMetadata: The metadata
// from querying metrics.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsMetadata struct {
	// ResultIsTruncated: Whether the result rows were truncated because the result
	// row size is too large to materialize.
	ResultIsTruncated bool `json:"resultIsTruncated,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResultIsTruncated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResultIsTruncated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse: The response
// for querying metrics.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse struct {
	// Location: Required. The location of the data.
	// "projects/{project}/locations/{location}"
	Location string `json:"location,omitempty"`
	// MacroAverageSlice: The macro average slice contains aggregated averages
	// across the selected dimension. i.e. if group_by agent is specified this
	// field will contain the average across all agents. This field is only
	// populated if the request specifies a Dimension.
	MacroAverageSlice *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice `json:"macroAverageSlice,omitempty"`
	// Slices: A slice contains a total and (if the request specified a time
	// granularity) a time series of metric values. Each slice contains a unique
	// combination of the cardinality of dimensions from the request.
	Slices []*GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice `json:"slices,omitempty"`
	// UpdateTime: The metrics last update time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice: A slice
// contains a total and (if the request specified a time granularity) a time
// series of metric values. Each slice contains a unique combination of the
// cardinality of dimensions from the request. For example, if the request
// specifies a single ISSUE dimension and it has a cardinality of 2 (i.e. the
// data used to compute the metrics has 2 issues in total), the response will
// have 2 slices: * Slice 1 -> dimensions=[Issue 1] * Slice 2 ->
// dimensions=[Issue 2]
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice struct {
	// Dimensions: A unique combination of dimensions that this slice represents.
	Dimensions []*GoogleCloudContactcenterinsightsV1alpha1Dimension `json:"dimensions,omitempty"`
	// TimeSeries: A time series of metric values. This is only populated if the
	// request specifies a time granularity other than NONE.
	TimeSeries *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries `json:"timeSeries,omitempty"`
	// Total: The total metric value. The interval of this data point is [starting
	// create time, ending create time) from the request.
	Total *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint `json:"total,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint:
// A data point contains the metric values mapped to an interval.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint struct {
	// ConversationMeasure: The measure related to conversations.
	ConversationMeasure *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure `json:"conversationMeasure,omitempty"`
	// Interval: The interval that this data point represents. * If this is the
	// total data point, the interval is [starting create time, ending create time)
	// from the request. * If this a data point from the time series, the interval
	// is [time, time + time granularity from the request).
	Interval *GoogleTypeInterval `json:"interval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationMeasure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationMeasure") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointCon
// versationMeasure: The measure related to conversations.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure struct {
	// AverageAgentSentimentScore: The average agent's sentiment score.
	AverageAgentSentimentScore float64 `json:"averageAgentSentimentScore,omitempty"`
	// AverageClientSentimentScore: The average client's sentiment score.
	AverageClientSentimentScore float64 `json:"averageClientSentimentScore,omitempty"`
	// AverageCustomerSatisfactionRating: The average customer satisfaction rating.
	AverageCustomerSatisfactionRating float64 `json:"averageCustomerSatisfactionRating,omitempty"`
	// AverageDuration: The average duration.
	AverageDuration string `json:"averageDuration,omitempty"`
	// AverageQaNormalizedScore: Average QA normalized score. Will exclude 0's in
	// average calculation.
	AverageQaNormalizedScore float64 `json:"averageQaNormalizedScore,omitempty"`
	// AverageQaQuestionNormalizedScore: Average QA normalized score averaged for
	// questions averaged across all revisions of the parent scorecard. Will be
	// only populated if the request specifies a dimension of QA_QUESTION_ID.
	AverageQaQuestionNormalizedScore float64 `json:"averageQaQuestionNormalizedScore,omitempty"`
	// AverageSilencePercentage: The average silence percentage.
	AverageSilencePercentage float64 `json:"averageSilencePercentage,omitempty"`
	// AverageTurnCount: The average turn count.
	AverageTurnCount float64 `json:"averageTurnCount,omitempty"`
	// ConversationCount: The conversation count.
	ConversationCount int64 `json:"conversationCount,omitempty"`
	// QaTagScores: Average QA normalized score for all the tags.
	QaTagScores []*GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore `json:"qaTagScores,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageAgentSentimentScore")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageAgentSentimentScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure
	var s1 struct {
		AverageAgentSentimentScore        gensupport.JSONFloat64 `json:"averageAgentSentimentScore"`
		AverageClientSentimentScore       gensupport.JSONFloat64 `json:"averageClientSentimentScore"`
		AverageCustomerSatisfactionRating gensupport.JSONFloat64 `json:"averageCustomerSatisfactionRating"`
		AverageQaNormalizedScore          gensupport.JSONFloat64 `json:"averageQaNormalizedScore"`
		AverageQaQuestionNormalizedScore  gensupport.JSONFloat64 `json:"averageQaQuestionNormalizedScore"`
		AverageSilencePercentage          gensupport.JSONFloat64 `json:"averageSilencePercentage"`
		AverageTurnCount                  gensupport.JSONFloat64 `json:"averageTurnCount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageAgentSentimentScore = float64(s1.AverageAgentSentimentScore)
	s.AverageClientSentimentScore = float64(s1.AverageClientSentimentScore)
	s.AverageCustomerSatisfactionRating = float64(s1.AverageCustomerSatisfactionRating)
	s.AverageQaNormalizedScore = float64(s1.AverageQaNormalizedScore)
	s.AverageQaQuestionNormalizedScore = float64(s1.AverageQaQuestionNormalizedScore)
	s.AverageSilencePercentage = float64(s1.AverageSilencePercentage)
	s.AverageTurnCount = float64(s1.AverageTurnCount)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointCon
// versationMeasureQaTagScore: Average QA normalized score for the tag.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore struct {
	// AverageTagNormalizedScore: Average tag normalized score per tag.
	AverageTagNormalizedScore float64 `json:"averageTagNormalizedScore,omitempty"`
	// Tag: Tag name.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageTagNormalizedScore")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageTagNormalizedScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore
	var s1 struct {
		AverageTagNormalizedScore gensupport.JSONFloat64 `json:"averageTagNormalizedScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageTagNormalizedScore = float64(s1.AverageTagNormalizedScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries:
// A time series of metric values.
type GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries struct {
	// DataPoints: The data points that make up the time series .
	DataPoints []*GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint `json:"dataPoints,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataPoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataPoints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewMetadata:
// The metadata for querying performance overview.
type GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewMetadata struct {
}

// GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewResponse:
// The response for querying performance overview.
type GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewResponse struct {
	// SummaryText: The summary text of the performance.
	SummaryText string `json:"summaryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SummaryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SummaryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1RedactionConfig: DLP resources used
// for redaction while ingesting conversations. DLP settings are applied to
// conversations ingested from the `UploadConversation` and
// `IngestConversations` endpoints, including conversation coming from CCAI
// Platform. They are not applied to conversations ingested from the
// `CreateConversation` endpoint or the Dialogflow / Agent Assist runtime
// integrations. When using Dialogflow / Agent Assist runtime integrations,
// redaction should be performed in Dialogflow / Agent Assist.
type GoogleCloudContactcenterinsightsV1alpha1RedactionConfig struct {
	// DeidentifyTemplate: The fully-qualified DLP deidentify template resource
	// name. Format: `projects/{project}/deidentifyTemplates/{template}`
	DeidentifyTemplate string `json:"deidentifyTemplate,omitempty"`
	// InspectTemplate: The fully-qualified DLP inspect template resource name.
	// Format:
	// `projects/{project}/locations/{location}/inspectTemplates/{template}`
	InspectTemplate string `json:"inspectTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeidentifyTemplate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeidentifyTemplate") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1RedactionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1RedactionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation: An annotation
// that was generated during the customer and agent interaction.
type GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation struct {
	// AnnotationId: The unique identifier of the annotation. Format:
	// projects/{project}/locations/{location}/conversationDatasets/{dataset}/conver
	// sationDataItems/{data_item}/conversationAnnotations/{annotation}
	AnnotationId string `json:"annotationId,omitempty"`
	// AnswerFeedback: The feedback that the customer has about the answer in
	// `data`.
	AnswerFeedback *GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback `json:"answerFeedback,omitempty"`
	// ArticleSuggestion: Agent Assist Article Suggestion data.
	ArticleSuggestion *GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData `json:"articleSuggestion,omitempty"`
	// ConversationSummarizationSuggestion: Conversation summarization suggestion
	// data.
	ConversationSummarizationSuggestion *GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData `json:"conversationSummarizationSuggestion,omitempty"`
	// CreateTime: The time at which this annotation was created.
	CreateTime string `json:"createTime,omitempty"`
	// DialogflowInteraction: Dialogflow interaction data.
	DialogflowInteraction *GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData `json:"dialogflowInteraction,omitempty"`
	// EndBoundary: The boundary in the conversation where the annotation ends,
	// inclusive.
	EndBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"endBoundary,omitempty"`
	// FaqAnswer: Agent Assist FAQ answer data.
	FaqAnswer *GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData `json:"faqAnswer,omitempty"`
	// SmartComposeSuggestion: Agent Assist Smart Compose suggestion data.
	SmartComposeSuggestion *GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData `json:"smartComposeSuggestion,omitempty"`
	// SmartReply: Agent Assist Smart Reply data.
	SmartReply *GoogleCloudContactcenterinsightsV1alpha1SmartReplyData `json:"smartReply,omitempty"`
	// StartBoundary: The boundary in the conversation where the annotation starts,
	// inclusive.
	StartBoundary *GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary `json:"startBoundary,omitempty"`
	// UserInput: Explicit input used for generating the answer
	UserInput *GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput `json:"userInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput: Explicit
// input used for generating the answer
type GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput struct {
	// GeneratorName: The resource name of associated generator. Format:
	// `projects//locations//generators/`
	GeneratorName string `json:"generatorName,omitempty"`
	// Query: Query text. Article Search uses this to store the input query used to
	// generate the search results.
	Query string `json:"query,omitempty"`
	// QuerySource: Query source for the answer.
	//
	// Possible values:
	//   "QUERY_SOURCE_UNSPECIFIED" - Unknown query source.
	//   "AGENT_QUERY" - The query is from agents.
	//   "SUGGESTED_QUERY" - The query is a query from previous suggestions, e.g.
	// from a preceding SuggestKnowledgeAssist response.
	QuerySource string `json:"querySource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratorName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadata: The
// metadata for an SampleConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// PartialErrors: Output only. Partial errors during sample conversations
	// operation that might cause the operation output to be incomplete.
	PartialErrors []*GoogleRpcStatus `json:"partialErrors,omitempty"`
	// Request: Output only. The original request for sample conversations to
	// dataset.
	Request *GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest `json:"request,omitempty"`
	// SampleConversationsStats: Output only. Statistics for SampleConversations
	// operation.
	SampleConversationsStats *GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConversationsStats `json:"sampleConversationsStats,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConv
// ersationsStats: Statistics for SampleConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConversationsStats struct {
	// FailedSampleCount: Output only. The number of objects which were unable to
	// be sampled due to errors. The errors are populated in the partial_errors
	// field.
	FailedSampleCount int64 `json:"failedSampleCount,omitempty"`
	// SuccessfulSampleCount: Output only. The number of new conversations added
	// during this sample operation.
	SuccessfulSampleCount int64 `json:"successfulSampleCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailedSampleCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedSampleCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConversationsStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConversationsStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest: The
// request to sample conversations to a dataset.
type GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest struct {
	// DestinationDataset: The dataset resource to copy the sampled conversations
	// to.
	DestinationDataset *GoogleCloudContactcenterinsightsV1alpha1Dataset `json:"destinationDataset,omitempty"`
	// Parent: Required. The parent resource of the dataset.
	Parent string `json:"parent,omitempty"`
	// SampleRule: Optional. The sample rule used for sampling conversations.
	SampleRule *GoogleCloudContactcenterinsightsV1alpha1SampleRule `json:"sampleRule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1SampleConversationsResponse: The
// response to an SampleConversations operation.
type GoogleCloudContactcenterinsightsV1alpha1SampleConversationsResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1SampleRule: Message for sampling
// conversations.
type GoogleCloudContactcenterinsightsV1alpha1SampleRule struct {
	// ConversationFilter: To specify the filter for the conversions that should
	// apply this sample rule. An empty filter means this sample rule applies to
	// all conversations.
	ConversationFilter string `json:"conversationFilter,omitempty"`
	// Dimension: Optional. Group by dimension to sample the conversation. If no
	// dimension is provided, the sampling will be applied to the project level.
	// Current supported dimensions is 'quality_metadata.agent_info.agent_id'.
	Dimension string `json:"dimension,omitempty"`
	// SamplePercentage: Percentage of conversations that we should sample based on
	// the dimension between [0, 100].
	SamplePercentage float64 `json:"samplePercentage,omitempty"`
	// SampleRow: Number of the conversations that we should sample based on the
	// dimension.
	SampleRow int64 `json:"sampleRow,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ConversationFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationFilter") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SampleRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SampleRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1SampleRule) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SampleRule
	var s1 struct {
		SamplePercentage gensupport.JSONFloat64 `json:"samplePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SamplePercentage = float64(s1.SamplePercentage)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1SentimentData: The data for a
// sentiment annotation.
type GoogleCloudContactcenterinsightsV1alpha1SentimentData struct {
	// Magnitude: A non-negative number from 0 to infinity which represents the
	// absolute magnitude of sentiment regardless of score.
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: The sentiment score between -1.0 (negative) and 1.0 (positive).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SentimentData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SentimentData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1SentimentData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SentimentData
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1SilenceData: The data for a silence
// annotation.
type GoogleCloudContactcenterinsightsV1alpha1SilenceData struct {
}

// GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData: Agent
// Assist Smart Compose suggestion data.
type GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData struct {
	// ConfidenceScore: The system's confidence score that this suggestion is a
	// good match for this conversation, ranging from 0.0 (completely uncertain) to
	// 1.0 (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Compose suggestion and
	// the document from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Suggestion: The content of the suggestion.
	Suggestion string `json:"suggestion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1SmartReplyData: Agent Assist Smart
// Reply data.
type GoogleCloudContactcenterinsightsV1alpha1SmartReplyData struct {
	// ConfidenceScore: The system's confidence score that this reply is a good
	// match for this conversation, ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// Metadata: Map that contains metadata about the Smart Reply and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// QueryRecord: The name of the answer record. Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `json:"queryRecord,omitempty"`
	// Reply: The content of the reply.
	Reply string `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SmartReplyData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartReplyData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudContactcenterinsightsV1alpha1SmartReplyData) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SmartReplyData
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudContactcenterinsightsV1alpha1SpeechConfig: Speech-to-Text
// configuration. Speech-to-Text settings are applied to conversations ingested
// from the `UploadConversation` and `IngestConversations` endpoints, including
// conversation coming from CCAI Platform. They are not applied to
// conversations ingested from the `CreateConversation` endpoint.
type GoogleCloudContactcenterinsightsV1alpha1SpeechConfig struct {
	// SpeechRecognizer: The fully-qualified Speech Recognizer resource name.
	// Format: `projects/{project_id}/locations/{location}/recognizer/{recognizer}`
	SpeechRecognizer string `json:"speechRecognizer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SpeechRecognizer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SpeechRecognizer") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1SpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1SpeechConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata: Metadata
// for undeploying an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: The original request for undeployment.
	Request *GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest: The
// request to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest struct {
	// Name: Required. The issue model to undeploy.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelResponse: The
// response to undeploy an issue model.
type GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelResponse struct {
}

// GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagMetadata: The
// metadata for updating a QaQuestionTag Resource.
type GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagMetadata struct {
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest: The
// request for updating a QaQuestionTag.
type GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest struct {
	// QaQuestionTag: Required. The QaQuestionTag to update.
	QaQuestionTag *GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag `json:"qaQuestionTag,omitempty"`
	// UpdateMask: Optional. The list of fields to be updated. All possible fields
	// can be updated by passing `*`, or a subset of the following updateable
	// fields can be provided: * `qa_question_tag_name` - the name of the tag *
	// `qa_question_ids` - the list of questions the tag applies to
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QaQuestionTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QaQuestionTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata: The
// metadata for an `UploadConversation` operation.
type GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata struct {
	// AnalysisOperation: Output only. The operation name for a successfully
	// created analysis operation, if any.
	AnalysisOperation string `json:"analysisOperation,omitempty"`
	// AppliedRedactionConfig: Output only. The redaction config applied to the
	// uploaded conversation.
	AppliedRedactionConfig *GoogleCloudContactcenterinsightsV1alpha1RedactionConfig `json:"appliedRedactionConfig,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// Request: Output only. The original request.
	Request *GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalysisOperation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalysisOperation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest: Request
// to upload a conversation.
type GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest struct {
	// Conversation: Required. The conversation resource to create.
	Conversation *GoogleCloudContactcenterinsightsV1alpha1Conversation `json:"conversation,omitempty"`
	// ConversationId: Optional. A unique ID for the new conversation. This ID will
	// become the final component of the conversation's resource name. If no ID is
	// specified, a server-generated ID will be used. This value should be 4-64
	// characters and must match the regular expression `^[a-z0-9-]{4,64}$`. Valid
	// characters are `a-z-`
	ConversationId string `json:"conversationId,omitempty"`
	// Parent: Required. The parent resource of the conversation.
	Parent string `json:"parent,omitempty"`
	// RedactionConfig: Optional. DLP settings for transcript redaction. Will
	// default to the config specified in Settings.
	RedactionConfig *GoogleCloudContactcenterinsightsV1alpha1RedactionConfig `json:"redactionConfig,omitempty"`
	// SpeechConfig: Optional. Speech-to-Text configuration. Will default to the
	// config specified in Settings.
	SpeechConfig *GoogleCloudContactcenterinsightsV1alpha1SpeechConfig `json:"speechConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type GoogleIamV1AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*GoogleIamV1AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type GoogleIamV1AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Binding: Associates `members`, or principals, with a `role`.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *GoogleTypeExpr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Policy: An Identity and Access Management (IAM) policy, which
// specifies access controls for Google Cloud resources. A `Policy` is a
// collection of `bindings`. A `binding` binds one or more `members`, or
// principals, to a single `role`. Principals can be user accounts, service
// accounts, Google groups, and domains (such as G Suite). A `role` is a named
// list of permissions; each `role` can be an IAM predefined role or a
// user-created custom role. For some types of Google Cloud resources, a
// `binding` can also specify a `condition`, which is a logical expression that
// allows access to a resource only if the expression evaluates to `true`. A
// condition can add constraints based on attributes of the request, the
// resource, or both. To learn which resources support conditions in their IAM
// policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type GoogleIamV1Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*GoogleIamV1AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*GoogleIamV1Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type GoogleIamV1SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1TestIamPermissionsRequest: Request message for
// `TestIamPermissions` method.
type GoogleIamV1TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1TestIamPermissionsResponse: Response message for
// `TestIamPermissions` method.
type GoogleIamV1TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeExpr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The syntax and
// semantics of CEL are documented at https://github.com/google/cel-spec.
// Example (Comparison): title: "Summary size limit" description: "Determines
// if a summary is less than 100 chars" expression: "document.summary.size() <
// 100" Example (Equality): title: "Requestor is owner" description:
// "Determines if requestor is the document owner" expression: "document.owner
// == request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type GoogleTypeExpr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeInterval: Represents a time interval, encoded as a Timestamp start
// (inclusive) and a Timestamp end (exclusive). The start must be less than or
// equal to the end. When the start equals the end, the interval is empty
// (matches no time). When both start and end are unspecified, the interval
// matches any time.
type GoogleTypeInterval struct {
	// EndTime: Optional. Exclusive end of the interval. If specified, a Timestamp
	// matching this interval will have to be before the end.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Optional. Inclusive start of the interval. If specified, a
	// Timestamp matching this interval will have to be the same or after the
	// start.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsBulkDeleteFeedbackLabelsCall struct {
	s                                                                 *Service
	parent                                                            string
	googlecloudcontactcenterinsightsv1bulkdeletefeedbacklabelsrequest *GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// BulkDeleteFeedbackLabels: Delete feedback labels in bulk using a filter.
//
// - parent: The parent resource for new feedback labels.
func (r *ProjectsLocationsService) BulkDeleteFeedbackLabels(parent string, googlecloudcontactcenterinsightsv1bulkdeletefeedbacklabelsrequest *GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest) *ProjectsLocationsBulkDeleteFeedbackLabelsCall {
	c := &ProjectsLocationsBulkDeleteFeedbackLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1bulkdeletefeedbacklabelsrequest = googlecloudcontactcenterinsightsv1bulkdeletefeedbacklabelsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBulkDeleteFeedbackLabelsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBulkDeleteFeedbackLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBulkDeleteFeedbackLabelsCall) Context(ctx context.Context) *ProjectsLocationsBulkDeleteFeedbackLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBulkDeleteFeedbackLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBulkDeleteFeedbackLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1bulkdeletefeedbacklabelsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:bulkDeleteFeedbackLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.bulkDeleteFeedbackLabels", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.bulkDeleteFeedbackLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBulkDeleteFeedbackLabelsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.bulkDeleteFeedbackLabels", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBulkDownloadFeedbackLabelsCall struct {
	s                                                                   *Service
	parent                                                              string
	googlecloudcontactcenterinsightsv1bulkdownloadfeedbacklabelsrequest *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest
	urlParams_                                                          gensupport.URLParams
	ctx_                                                                context.Context
	header_                                                             http.Header
}

// BulkDownloadFeedbackLabels: Download feedback labels in bulk from an
// external source. Currently supports exporting Quality AI example
// conversations with transcripts and question bodies.
//
// - parent: The parent resource for new feedback labels.
func (r *ProjectsLocationsService) BulkDownloadFeedbackLabels(parent string, googlecloudcontactcenterinsightsv1bulkdownloadfeedbacklabelsrequest *GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest) *ProjectsLocationsBulkDownloadFeedbackLabelsCall {
	c := &ProjectsLocationsBulkDownloadFeedbackLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1bulkdownloadfeedbacklabelsrequest = googlecloudcontactcenterinsightsv1bulkdownloadfeedbacklabelsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBulkDownloadFeedbackLabelsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBulkDownloadFeedbackLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBulkDownloadFeedbackLabelsCall) Context(ctx context.Context) *ProjectsLocationsBulkDownloadFeedbackLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBulkDownloadFeedbackLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBulkDownloadFeedbackLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1bulkdownloadfeedbacklabelsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:bulkDownloadFeedbackLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.bulkDownloadFeedbackLabels", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.bulkDownloadFeedbackLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBulkDownloadFeedbackLabelsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.bulkDownloadFeedbackLabels", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBulkUploadFeedbackLabelsCall struct {
	s                                                                 *Service
	parent                                                            string
	googlecloudcontactcenterinsightsv1bulkuploadfeedbacklabelsrequest *GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// BulkUploadFeedbackLabels: Upload feedback labels from an external source in
// bulk. Currently supports labeling Quality AI example conversations.
//
// - parent: The parent resource for new feedback labels.
func (r *ProjectsLocationsService) BulkUploadFeedbackLabels(parent string, googlecloudcontactcenterinsightsv1bulkuploadfeedbacklabelsrequest *GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest) *ProjectsLocationsBulkUploadFeedbackLabelsCall {
	c := &ProjectsLocationsBulkUploadFeedbackLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1bulkuploadfeedbacklabelsrequest = googlecloudcontactcenterinsightsv1bulkuploadfeedbacklabelsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBulkUploadFeedbackLabelsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBulkUploadFeedbackLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBulkUploadFeedbackLabelsCall) Context(ctx context.Context) *ProjectsLocationsBulkUploadFeedbackLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBulkUploadFeedbackLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBulkUploadFeedbackLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1bulkuploadfeedbacklabelsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:bulkUploadFeedbackLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.bulkUploadFeedbackLabels", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.bulkUploadFeedbackLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBulkUploadFeedbackLabelsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.bulkUploadFeedbackLabels", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGetEncryptionSpecCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEncryptionSpec: Gets location-level encryption key specification.
//
// - name: The name of the encryption spec resource to get.
func (r *ProjectsLocationsService) GetEncryptionSpec(name string) *ProjectsLocationsGetEncryptionSpecCall {
	c := &ProjectsLocationsGetEncryptionSpecCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetEncryptionSpecCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetEncryptionSpecCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetEncryptionSpecCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetEncryptionSpecCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetEncryptionSpecCall) Context(ctx context.Context) *ProjectsLocationsGetEncryptionSpecCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetEncryptionSpecCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetEncryptionSpecCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.getEncryptionSpec", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.getEncryptionSpec" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1EncryptionSpec.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetEncryptionSpecCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1EncryptionSpec, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1EncryptionSpec{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.getEncryptionSpec", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsGetSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSettings: Gets project-level settings.
//
// - name: The name of the settings resource to get.
func (r *ProjectsLocationsService) GetSettings(name string) *ProjectsLocationsGetSettingsCall {
	c := &ProjectsLocationsGetSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsGetSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsGetSettingsCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsGetSettingsCall) Context(ctx context.Context) *ProjectsLocationsGetSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsGetSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.getSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.getSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Settings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsGetSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.getSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsListAllFeedbackLabelsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListAllFeedbackLabels: List all feedback labels by project number.
//
// - parent: The parent resource of all feedback labels per project.
func (r *ProjectsLocationsService) ListAllFeedbackLabels(parent string) *ProjectsLocationsListAllFeedbackLabelsCall {
	c := &ProjectsLocationsListAllFeedbackLabelsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset in the entire project. Supports disjunctions (OR) and
// conjunctions (AND). Supported fields: * `issue_model_id` * `qa_question_id`
// * `min_create_time` * `max_create_time` * `min_update_time` *
// `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Filter(filter string) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// feedback labels to return in the response. A valid page size ranges from 0
// to 100,000 inclusive. If the page size is zero or unspecified, a default
// page size of 100 will be chosen. Note that a call might return fewer results
// than the requested page size.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) PageSize(pageSize int64) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAllFeedbackLabelsResponse`. This value indicates that this is a
// continuation of a prior `ListAllFeedbackLabels` call and that the system
// should return the next page of data.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) PageToken(pageToken string) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Fields(s ...googleapi.Field) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) IfNoneMatch(entityTag string) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Context(ctx context.Context) *ProjectsLocationsListAllFeedbackLabelsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListAllFeedbackLabelsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:listAllFeedbackLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.listAllFeedbackLabels", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.listAllFeedbackLabels" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.listAllFeedbackLabels", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListAllFeedbackLabelsCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsQueryMetricsCall struct {
	s                                                     *Service
	location                                              string
	googlecloudcontactcenterinsightsv1querymetricsrequest *GoogleCloudContactcenterinsightsV1QueryMetricsRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// QueryMetrics: Query metrics.
//
//   - location: The location of the data.
//     "projects/{project}/locations/{location}".
func (r *ProjectsLocationsService) QueryMetrics(location string, googlecloudcontactcenterinsightsv1querymetricsrequest *GoogleCloudContactcenterinsightsV1QueryMetricsRequest) *ProjectsLocationsQueryMetricsCall {
	c := &ProjectsLocationsQueryMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	c.googlecloudcontactcenterinsightsv1querymetricsrequest = googlecloudcontactcenterinsightsv1querymetricsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQueryMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsQueryMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQueryMetricsCall) Context(ctx context.Context) *ProjectsLocationsQueryMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQueryMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQueryMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1querymetricsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+location}:queryMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.queryMetrics", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.queryMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQueryMetricsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.queryMetrics", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsQueryPerformanceOverviewCall struct {
	s                                                                 *Service
	parent                                                            string
	googlecloudcontactcenterinsightsv1queryperformanceoverviewrequest *GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// QueryPerformanceOverview: Generates a summary of predefined performance
// metrics for a set of conversations. Conversations can be specified by
// specifying a time window and an agent id, for now. The summary includes a
// comparison of metrics computed for conversations in the previous time
// period, and also a comparison with peers in the same time period.
//
//   - parent: The parent resource of the conversations to derive performance
//     stats from. "projects/{project}/locations/{location}".
func (r *ProjectsLocationsService) QueryPerformanceOverview(parent string, googlecloudcontactcenterinsightsv1queryperformanceoverviewrequest *GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest) *ProjectsLocationsQueryPerformanceOverviewCall {
	c := &ProjectsLocationsQueryPerformanceOverviewCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1queryperformanceoverviewrequest = googlecloudcontactcenterinsightsv1queryperformanceoverviewrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsQueryPerformanceOverviewCall) Fields(s ...googleapi.Field) *ProjectsLocationsQueryPerformanceOverviewCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsQueryPerformanceOverviewCall) Context(ctx context.Context) *ProjectsLocationsQueryPerformanceOverviewCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsQueryPerformanceOverviewCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsQueryPerformanceOverviewCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1queryperformanceoverviewrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:queryPerformanceOverview")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.queryPerformanceOverview", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.queryPerformanceOverview" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsQueryPerformanceOverviewCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.queryPerformanceOverview", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsUpdateSettingsCall struct {
	s                                          *Service
	name                                       string
	googlecloudcontactcenterinsightsv1settings *GoogleCloudContactcenterinsightsV1Settings
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// UpdateSettings: Updates project-level settings.
//
//   - name: Immutable. The resource name of the settings resource. Format:
//     projects/{project}/locations/{location}/settings.
func (r *ProjectsLocationsService) UpdateSettings(name string, googlecloudcontactcenterinsightsv1settings *GoogleCloudContactcenterinsightsV1Settings) *ProjectsLocationsUpdateSettingsCall {
	c := &ProjectsLocationsUpdateSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1settings = googlecloudcontactcenterinsightsv1settings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated.
func (c *ProjectsLocationsUpdateSettingsCall) UpdateMask(updateMask string) *ProjectsLocationsUpdateSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsUpdateSettingsCall) Fields(s ...googleapi.Field) *ProjectsLocationsUpdateSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsUpdateSettingsCall) Context(ctx context.Context) *ProjectsLocationsUpdateSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsUpdateSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsUpdateSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1settings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.updateSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.updateSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Settings.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsUpdateSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.updateSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAnalysisRulesCreateCall struct {
	s                                              *Service
	parent                                         string
	googlecloudcontactcenterinsightsv1analysisrule *GoogleCloudContactcenterinsightsV1AnalysisRule
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Create: Creates a analysis rule.
//
//   - parent: The parent resource of the analysis rule. Required. The location
//     to create a analysis rule for. Format: `projects//locations/` or
//     `projects//locations/`.
func (r *ProjectsLocationsAnalysisRulesService) Create(parent string, googlecloudcontactcenterinsightsv1analysisrule *GoogleCloudContactcenterinsightsV1AnalysisRule) *ProjectsLocationsAnalysisRulesCreateCall {
	c := &ProjectsLocationsAnalysisRulesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1analysisrule = googlecloudcontactcenterinsightsv1analysisrule
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAnalysisRulesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAnalysisRulesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAnalysisRulesCreateCall) Context(ctx context.Context) *ProjectsLocationsAnalysisRulesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAnalysisRulesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAnalysisRulesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1analysisrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analysisRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.analysisRules.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.analysisRules.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AnalysisRule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAnalysisRulesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AnalysisRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AnalysisRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.analysisRules.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAnalysisRulesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a analysis rule.
//
// - name: The name of the analysis rule to delete.
func (r *ProjectsLocationsAnalysisRulesService) Delete(name string) *ProjectsLocationsAnalysisRulesDeleteCall {
	c := &ProjectsLocationsAnalysisRulesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAnalysisRulesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAnalysisRulesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAnalysisRulesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAnalysisRulesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAnalysisRulesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAnalysisRulesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.analysisRules.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.analysisRules.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAnalysisRulesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.analysisRules.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAnalysisRulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a analysis rule.
//
// - name: The name of the AnalysisRule to get.
func (r *ProjectsLocationsAnalysisRulesService) Get(name string) *ProjectsLocationsAnalysisRulesGetCall {
	c := &ProjectsLocationsAnalysisRulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAnalysisRulesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAnalysisRulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAnalysisRulesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAnalysisRulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAnalysisRulesGetCall) Context(ctx context.Context) *ProjectsLocationsAnalysisRulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAnalysisRulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAnalysisRulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.analysisRules.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.analysisRules.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AnalysisRule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAnalysisRulesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AnalysisRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AnalysisRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.analysisRules.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAnalysisRulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists analysis rules.
//
// - parent: The parent resource of the analysis rules.
func (r *ProjectsLocationsAnalysisRulesService) List(parent string) *ProjectsLocationsAnalysisRulesListCall {
	c := &ProjectsLocationsAnalysisRulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// analysis rule to return in the response. If this value is zero, the service
// will select a default size. A call may return fewer objects than requested.
// A non-empty `next_page_token` in the response indicates that more data is
// available.
func (c *ProjectsLocationsAnalysisRulesListCall) PageSize(pageSize int64) *ProjectsLocationsAnalysisRulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAnalysisRulesResponse`; indicates that this is a continuation of a
// prior `ListAnalysisRules` call and the system should return the next page of
// data.
func (c *ProjectsLocationsAnalysisRulesListCall) PageToken(pageToken string) *ProjectsLocationsAnalysisRulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAnalysisRulesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAnalysisRulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAnalysisRulesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAnalysisRulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAnalysisRulesListCall) Context(ctx context.Context) *ProjectsLocationsAnalysisRulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAnalysisRulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAnalysisRulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analysisRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.analysisRules.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.analysisRules.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAnalysisRulesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.analysisRules.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAnalysisRulesListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAnalysisRulesPatchCall struct {
	s                                              *Service
	name                                           string
	googlecloudcontactcenterinsightsv1analysisrule *GoogleCloudContactcenterinsightsV1AnalysisRule
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Patch: Updates a analysis rule.
//
//   - name: Identifier. The resource name of the analysis rule. Format:
//     projects/{project}/locations/{location}/analysisRules/{analysis_rule}.
func (r *ProjectsLocationsAnalysisRulesService) Patch(name string, googlecloudcontactcenterinsightsv1analysisrule *GoogleCloudContactcenterinsightsV1AnalysisRule) *ProjectsLocationsAnalysisRulesPatchCall {
	c := &ProjectsLocationsAnalysisRulesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1analysisrule = googlecloudcontactcenterinsightsv1analysisrule
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated. If the update_mask is not provided, the update will be applied
// to all fields.
func (c *ProjectsLocationsAnalysisRulesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAnalysisRulesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAnalysisRulesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAnalysisRulesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAnalysisRulesPatchCall) Context(ctx context.Context) *ProjectsLocationsAnalysisRulesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAnalysisRulesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAnalysisRulesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1analysisrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.analysisRules.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.analysisRules.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AnalysisRule.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAnalysisRulesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AnalysisRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AnalysisRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.analysisRules.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAssessmentRulesCreateCall struct {
	s                                                *Service
	parent                                           string
	googlecloudcontactcenterinsightsv1assessmentrule *GoogleCloudContactcenterinsightsV1AssessmentRule
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Create: Creates an assessment rule.
//
//   - parent: The parent resource of the assessment rule. Required. The location
//     to create a assessment rule for. Format: `projects//locations/` or
//     `projects//locations/`.
func (r *ProjectsLocationsAssessmentRulesService) Create(parent string, googlecloudcontactcenterinsightsv1assessmentrule *GoogleCloudContactcenterinsightsV1AssessmentRule) *ProjectsLocationsAssessmentRulesCreateCall {
	c := &ProjectsLocationsAssessmentRulesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1assessmentrule = googlecloudcontactcenterinsightsv1assessmentrule
	return c
}

// AssessmentRuleId sets the optional parameter "assessmentRuleId": A unique ID
// for the new AssessmentRule. This ID will become the final component of the
// AssessmentRule's resource name. If no ID is specified, a server-generated ID
// will be used. This value should be 4-64 characters and must match the
// regular expression `^a-z ([a-z0-9-]{0,61}[a-z0-9])?$`.
func (c *ProjectsLocationsAssessmentRulesCreateCall) AssessmentRuleId(assessmentRuleId string) *ProjectsLocationsAssessmentRulesCreateCall {
	c.urlParams_.Set("assessmentRuleId", assessmentRuleId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssessmentRulesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssessmentRulesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssessmentRulesCreateCall) Context(ctx context.Context) *ProjectsLocationsAssessmentRulesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssessmentRulesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssessmentRulesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1assessmentrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assessmentRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.assessmentRules.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.assessmentRules.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AssessmentRule.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAssessmentRulesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AssessmentRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AssessmentRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.assessmentRules.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAssessmentRulesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an assessment rule.
//
// - name: The name of the assessment rule to delete.
func (r *ProjectsLocationsAssessmentRulesService) Delete(name string) *ProjectsLocationsAssessmentRulesDeleteCall {
	c := &ProjectsLocationsAssessmentRulesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssessmentRulesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssessmentRulesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssessmentRulesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAssessmentRulesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssessmentRulesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssessmentRulesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.assessmentRules.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.assessmentRules.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAssessmentRulesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.assessmentRules.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAssessmentRulesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get an assessment rule.
//
// - name: The name of the assessment rule to get.
func (r *ProjectsLocationsAssessmentRulesService) Get(name string) *ProjectsLocationsAssessmentRulesGetCall {
	c := &ProjectsLocationsAssessmentRulesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssessmentRulesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssessmentRulesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAssessmentRulesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAssessmentRulesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssessmentRulesGetCall) Context(ctx context.Context) *ProjectsLocationsAssessmentRulesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssessmentRulesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssessmentRulesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.assessmentRules.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.assessmentRules.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AssessmentRule.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAssessmentRulesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AssessmentRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AssessmentRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.assessmentRules.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAssessmentRulesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists assessment rules.
//
// - parent: The parent resource of the assessment rules.
func (r *ProjectsLocationsAssessmentRulesService) List(parent string) *ProjectsLocationsAssessmentRulesListCall {
	c := &ProjectsLocationsAssessmentRulesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// assessment rule to return in the response. If this value is zero, the
// service will select a default size. A call may return fewer objects than
// requested. A non-empty `next_page_token` in the response indicates that more
// data is available.
func (c *ProjectsLocationsAssessmentRulesListCall) PageSize(pageSize int64) *ProjectsLocationsAssessmentRulesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAssessmentRulesResponse`; indicates that this is a continuation of
// a prior `ListAssessmentRules` call and the system should return the next
// page of data.
func (c *ProjectsLocationsAssessmentRulesListCall) PageToken(pageToken string) *ProjectsLocationsAssessmentRulesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssessmentRulesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssessmentRulesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAssessmentRulesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAssessmentRulesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssessmentRulesListCall) Context(ctx context.Context) *ProjectsLocationsAssessmentRulesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssessmentRulesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssessmentRulesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assessmentRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.assessmentRules.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.assessmentRules.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAssessmentRulesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.assessmentRules.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAssessmentRulesListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAssessmentRulesPatchCall struct {
	s                                                *Service
	name                                             string
	googlecloudcontactcenterinsightsv1assessmentrule *GoogleCloudContactcenterinsightsV1AssessmentRule
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Patch: Updates an assessment rule.
//
//   - name: Identifier. The resource name of the assessment rule. Format:
//     projects/{project}/locations/{location}/assessmentRules/{assessment_rule}.
func (r *ProjectsLocationsAssessmentRulesService) Patch(name string, googlecloudcontactcenterinsightsv1assessmentrule *GoogleCloudContactcenterinsightsV1AssessmentRule) *ProjectsLocationsAssessmentRulesPatchCall {
	c := &ProjectsLocationsAssessmentRulesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1assessmentrule = googlecloudcontactcenterinsightsv1assessmentrule
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated. If the update_mask is not provided, the update will be applied
// to all fields.
func (c *ProjectsLocationsAssessmentRulesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAssessmentRulesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAssessmentRulesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAssessmentRulesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAssessmentRulesPatchCall) Context(ctx context.Context) *ProjectsLocationsAssessmentRulesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAssessmentRulesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAssessmentRulesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1assessmentrule)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.assessmentRules.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.assessmentRules.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AssessmentRule.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAssessmentRulesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AssessmentRule, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AssessmentRule{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.assessmentRules.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsCreateCall struct {
	s                                                   *Service
	parent                                              string
	googlecloudcontactcenterinsightsv1authorizedviewset *GoogleCloudContactcenterinsightsV1AuthorizedViewSet
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// Create: Create AuthorizedViewSet
//
// - parent: The parent resource of the AuthorizedViewSet.
func (r *ProjectsLocationsAuthorizedViewSetsService) Create(parent string, googlecloudcontactcenterinsightsv1authorizedviewset *GoogleCloudContactcenterinsightsV1AuthorizedViewSet) *ProjectsLocationsAuthorizedViewSetsCreateCall {
	c := &ProjectsLocationsAuthorizedViewSetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1authorizedviewset = googlecloudcontactcenterinsightsv1authorizedviewset
	return c
}

// AuthorizedViewSetId sets the optional parameter "authorizedViewSetId": A
// unique ID for the new AuthorizedViewSet. This ID will become the final
// component of the AuthorizedViewSet's resource name. If no ID is specified, a
// server-generated ID will be used. This value should be 4-64 characters and
// must match the regular expression `^a-z ([a-z0-9-]{0,61}[a-z0-9])?$`. See
// https://google.aip.dev/122#resource-id-segments
func (c *ProjectsLocationsAuthorizedViewSetsCreateCall) AuthorizedViewSetId(authorizedViewSetId string) *ProjectsLocationsAuthorizedViewSetsCreateCall {
	c.urlParams_.Set("authorizedViewSetId", authorizedViewSetId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsCreateCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1authorizedviewset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/authorizedViewSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AuthorizedViewSet.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AuthorizedViewSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AuthorizedViewSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an AuthorizedViewSet.
//
// - name: The name of the AuthorizedViewSet to delete.
func (r *ProjectsLocationsAuthorizedViewSetsService) Delete(name string) *ProjectsLocationsAuthorizedViewSetsDeleteCall {
	c := &ProjectsLocationsAuthorizedViewSetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, all of this
// AuthorizedViewSet's child resources will also be deleted. Otherwise, the
// request will only succeed if it has none.
func (c *ProjectsLocationsAuthorizedViewSetsDeleteCall) Force(force bool) *ProjectsLocationsAuthorizedViewSetsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizedViewSetsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get AuthorizedViewSet
//
// - name: The name of the AuthorizedViewSet to get.
func (r *ProjectsLocationsAuthorizedViewSetsService) Get(name string) *ProjectsLocationsAuthorizedViewSetsGetCall {
	c := &ProjectsLocationsAuthorizedViewSetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsGetCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AuthorizedViewSet.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AuthorizedViewSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AuthorizedViewSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List AuthorizedViewSets
//
// - parent: The parent resource of the AuthorizedViewSets.
func (r *ProjectsLocationsAuthorizedViewSetsService) List(parent string) *ProjectsLocationsAuthorizedViewSetsListCall {
	c := &ProjectsLocationsAuthorizedViewSetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The filter expression to filter
// authorized view sets listed in the response.
func (c *ProjectsLocationsAuthorizedViewSetsListCall) Filter(filter string) *ProjectsLocationsAuthorizedViewSetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": The order by expression to
// order authorized view sets listed in the response.
func (c *ProjectsLocationsAuthorizedViewSetsListCall) OrderBy(orderBy string) *ProjectsLocationsAuthorizedViewSetsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of view
// sets to return in the response. If the value is zero, the service will
// select a default size. A call might return fewer objects than requested. A
// non-empty `next_page_token` in the response indicates that more data is
// available.
func (c *ProjectsLocationsAuthorizedViewSetsListCall) PageSize(pageSize int64) *ProjectsLocationsAuthorizedViewSetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAuthorizedViewSetsResponse`. This value indicates that this is a
// continuation of a prior `ListAuthorizedViewSets` call and that the system
// should return the next page of data.
func (c *ProjectsLocationsAuthorizedViewSetsListCall) PageToken(pageToken string) *ProjectsLocationsAuthorizedViewSetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsListCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/authorizedViewSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthorizedViewSetsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthorizedViewSetsPatchCall struct {
	s                                                   *Service
	name                                                string
	googlecloudcontactcenterinsightsv1authorizedviewset *GoogleCloudContactcenterinsightsV1AuthorizedViewSet
	urlParams_                                          gensupport.URLParams
	ctx_                                                context.Context
	header_                                             http.Header
}

// Patch: Updates an AuthorizedViewSet.
//
//   - name: Identifier. The resource name of the AuthorizedViewSet. Format:
//     projects/{project}/locations/{location}/authorizedViewSets/{authorized_view
//     _set}.
func (r *ProjectsLocationsAuthorizedViewSetsService) Patch(name string, googlecloudcontactcenterinsightsv1authorizedviewset *GoogleCloudContactcenterinsightsV1AuthorizedViewSet) *ProjectsLocationsAuthorizedViewSetsPatchCall {
	c := &ProjectsLocationsAuthorizedViewSetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1authorizedviewset = googlecloudcontactcenterinsightsv1authorizedviewset
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated. All possible fields can be updated by passing `*`, or a subset
// of the following updateable fields can be provided: * `display_name`
func (c *ProjectsLocationsAuthorizedViewSetsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAuthorizedViewSetsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsPatchCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1authorizedviewset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AuthorizedViewSet.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AuthorizedViewSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AuthorizedViewSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall struct {
	s                                                *Service
	parent                                           string
	googlecloudcontactcenterinsightsv1authorizedview *GoogleCloudContactcenterinsightsV1AuthorizedView
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Create: Create AuthorizedView
//
// - parent: The parent resource of the AuthorizedView.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService) Create(parent string, googlecloudcontactcenterinsightsv1authorizedview *GoogleCloudContactcenterinsightsV1AuthorizedView) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1authorizedview = googlecloudcontactcenterinsightsv1authorizedview
	return c
}

// AuthorizedViewId sets the optional parameter "authorizedViewId": A unique ID
// for the new AuthorizedView. This ID will become the final component of the
// AuthorizedView's resource name. If no ID is specified, a server-generated ID
// will be used. This value should be 4-64 characters and must match the
// regular expression `^a-z ([a-z0-9-]{0,61}[a-z0-9])?$`. See
// https://google.aip.dev/122#resource-id-segments
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall) AuthorizedViewId(authorizedViewId string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall {
	c.urlParams_.Set("authorizedViewId", authorizedViewId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1authorizedview)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/authorizedViews")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AuthorizedView.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AuthorizedView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AuthorizedView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an AuthorizedView.
//
// - name: The name of the AuthorizedView to delete.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService) Delete(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsDeleteCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get AuthorizedView
//
// - name: The name of the AuthorizedView to get.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService) Get(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AuthorizedView.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AuthorizedView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AuthorizedView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService) GetIamPolicy(resource string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List AuthorizedViewSets
//
//   - parent: The parent resource of the AuthorizedViews. If the parent is set
//     to `-`, all AuthorizedViews under the location will be returned.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService) List(parent string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The filter expression to filter
// authorized views listed in the response.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall) Filter(filter string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": The order by expression to
// order authorized views listed in the response.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall) OrderBy(orderBy string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of view
// to return in the response. If the value is zero, the service will select a
// default size. A call might return fewer objects than requested. A non-empty
// `next_page_token` in the response indicates that more data is available.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall) PageSize(pageSize int64) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAuthorizedViewsResponse`. This value indicates that this is a
// continuation of a prior `ListAuthorizedViews` call and that the system
// should return the next page of data.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall) PageToken(pageToken string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/authorizedViews")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall struct {
	s                                                *Service
	name                                             string
	googlecloudcontactcenterinsightsv1authorizedview *GoogleCloudContactcenterinsightsV1AuthorizedView
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Patch: Updates an AuthorizedView.
//
//   - name: Identifier. The resource name of the AuthorizedView. Format:
//     projects/{project}/locations/{location}/authorizedViewSets/{authorized_view
//     _set}/authorizedViews/{authorized_view}.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService) Patch(name string, googlecloudcontactcenterinsightsv1authorizedview *GoogleCloudContactcenterinsightsV1AuthorizedView) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1authorizedview = googlecloudcontactcenterinsightsv1authorizedview
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated. All possible fields can be updated by passing `*`, or a subset
// of the following updateable fields can be provided: * `conversation_filter`
// * `display_name`
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1authorizedview)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1AuthorizedView.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1AuthorizedView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1AuthorizedView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryMetricsCall struct {
	s                                                     *Service
	location                                              string
	googlecloudcontactcenterinsightsv1querymetricsrequest *GoogleCloudContactcenterinsightsV1QueryMetricsRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// QueryMetrics: Query metrics.
//
//   - location: The location of the data.
//     "projects/{project}/locations/{location}".
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService) QueryMetrics(location string, googlecloudcontactcenterinsightsv1querymetricsrequest *GoogleCloudContactcenterinsightsV1QueryMetricsRequest) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryMetricsCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryMetricsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	c.googlecloudcontactcenterinsightsv1querymetricsrequest = googlecloudcontactcenterinsightsv1querymetricsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryMetricsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryMetricsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryMetricsCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryMetricsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryMetricsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryMetricsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1querymetricsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+location}:queryMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.queryMetrics", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.queryMetrics" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryMetricsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.queryMetrics", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryPerformanceOverviewCall struct {
	s                                                                 *Service
	parent                                                            string
	googlecloudcontactcenterinsightsv1queryperformanceoverviewrequest *GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// QueryPerformanceOverview: Generates a summary of predefined performance
// metrics for a set of conversations. Conversations can be specified by
// specifying a time window and an agent id, for now. The summary includes a
// comparison of metrics computed for conversations in the previous time
// period, and also a comparison with peers in the same time period.
//
//   - parent: The parent resource of the conversations to derive performance
//     stats from. "projects/{project}/locations/{location}".
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService) QueryPerformanceOverview(parent string, googlecloudcontactcenterinsightsv1queryperformanceoverviewrequest *GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryPerformanceOverviewCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryPerformanceOverviewCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1queryperformanceoverviewrequest = googlecloudcontactcenterinsightsv1queryperformanceoverviewrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryPerformanceOverviewCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryPerformanceOverviewCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryPerformanceOverviewCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryPerformanceOverviewCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryPerformanceOverviewCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryPerformanceOverviewCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1queryperformanceoverviewrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:queryPerformanceOverview")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.queryPerformanceOverview", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.queryPerformanceOverview" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsQueryPerformanceOverviewCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.queryPerformanceOverview", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: SearchAuthorizedViewSets
//
//   - parent: The parent resource of the AuthorizedViews. If the parent is set
//     to `-`, all AuthorizedViews under the location will be returned.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService) Search(parent string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// OrderBy sets the optional parameter "orderBy": The order by expression to
// order authorized views listed in the response.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall) OrderBy(orderBy string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of view
// to return in the response. If the value is zero, the service will select a
// default size. A call might return fewer objects than requested. A non-empty
// `next_page_token` in the response indicates that more data is available.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall) PageSize(pageSize int64) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAuthorizedViewsResponse`. This value indicates that this is a
// continuation of a prior `ListAuthorizedViews` call and that the system
// should return the next page of data.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall) PageToken(pageToken string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": The query expression to search
// authorized views.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall) Query(query string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/authorizedViews:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.search", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSearchCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSetIamPolicyCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsTestIamPermissionsCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsBulkAnalyzeCall struct {
	s                                                                 *Service
	parent                                                            string
	googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// BulkAnalyze: Analyzes multiple conversations in a single request.
//
// - parent: The parent resource to create analyses in.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService) BulkAnalyze(parent string, googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsBulkAnalyzeCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsBulkAnalyzeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest = googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsBulkAnalyzeCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsBulkAnalyzeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsBulkAnalyzeCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsBulkAnalyzeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsBulkAnalyzeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsBulkAnalyzeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations:bulkAnalyze")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.bulkAnalyze", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.bulkAnalyze" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsBulkAnalyzeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.bulkAnalyze", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall struct {
	s            *Service
	location     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CalculateStats: Gets conversation statistics.
//
// - location: The location of the conversations.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService) CalculateStats(location string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. This field is useful for getting statistics about
// conversations with specific properties.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall) Filter(filter string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+location}/conversations:calculateStats")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.calculateStats", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.calculateStats" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1CalculateStatsResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsCalculateStatsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1CalculateStatsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1CalculateStatsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.calculateStats", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a conversation.
//
// - name: The name of the conversation to delete.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService) Delete(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, all of this
// conversation's analyses will also be deleted. Otherwise, the request will
// only succeed if the conversation has no analyses.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall) Force(force bool) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a conversation.
//
// - name: The name of the conversation to get.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService) Get(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": The level of details of the
// conversation. Default is `FULL`.
//
// Possible values:
//
//	"CONVERSATION_VIEW_UNSPECIFIED" - The conversation view is not specified.
//
// * Defaults to `FULL` in `GetConversationRequest`. * Defaults to `BASIC` in
// `ListConversationsRequest`.
//
//	"FULL" - Populates all fields in the conversation.
//	"BASIC" - Populates all fields in the conversation except the transcript.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall) View(view string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Conversation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists conversations.
//
// - parent: The parent resource of the conversation.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsService) List(parent string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. Useful for querying conversations with specific properties.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) Filter(filter string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": The attribute by which to
// order conversations in the response. If empty, conversations will be ordered
// by descending creation time. Supported values are one of the following: *
// create_time * customer_satisfaction_rating * duration * latest_analysis *
// start_time * turn_count The default sort order is ascending. To specify
// order, append `asc` or `desc` (`create_time desc`). For more details, see
// Google AIPs Ordering (https://google.aip.dev/132#ordering).
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) OrderBy(orderBy string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// conversations to return in the response. A valid page size ranges from 0 to
// 100,000 inclusive. If the page size is zero or unspecified, a default page
// size of 100 will be chosen. Note that a call might return fewer results than
// the requested page size.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) PageSize(pageSize int64) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListConversationsResponse`. This value indicates that this is a
// continuation of a prior `ListConversations` call and that the system should
// return the next page of data.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) PageToken(pageToken string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The level of details of the
// conversation. Default is `BASIC`.
//
// Possible values:
//
//	"CONVERSATION_VIEW_UNSPECIFIED" - The conversation view is not specified.
//
// * Defaults to `FULL` in `GetConversationRequest`. * Defaults to `BASIC` in
// `ListConversationsRequest`.
//
//	"FULL" - Populates all fields in the conversation.
//	"BASIC" - Populates all fields in the conversation except the transcript.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) View(view string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListConversationsResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListConversationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListConversationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListConversationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesCreateCall struct {
	s                                          *Service
	parent                                     string
	googlecloudcontactcenterinsightsv1analysis *GoogleCloudContactcenterinsightsV1Analysis
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Create: Creates an analysis. The long running operation is done when the
// analysis has completed.
//
// - parent: The parent resource of the analysis.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesService) Create(parent string, googlecloudcontactcenterinsightsv1analysis *GoogleCloudContactcenterinsightsV1Analysis) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesCreateCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1analysis = googlecloudcontactcenterinsightsv1analysis
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesCreateCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1analysis)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analyses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an analysis.
//
// - name: The name of the analysis to delete.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesService) Delete(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesDeleteCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an analysis.
//
// - name: The name of the analysis to get.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesService) Get(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Analysis.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Analysis, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Analysis{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists analyses.
//
// - parent: The parent resource of the analyses.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesService) List(parent string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. Useful for querying conversations with specific properties.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall) Filter(filter string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// analyses to return in the response. If this value is zero, the service will
// select a default size. A call might return fewer objects than requested. A
// non-empty `next_page_token` in the response indicates that more data is
// available.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall) PageSize(pageSize int64) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAnalysesResponse`; indicates that this is a continuation of a
// prior `ListAnalyses` call and the system should return the next page of
// data.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall) PageToken(pageToken string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analyses")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListAnalysesResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListAnalysesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListAnalysesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.analyses.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAnalysesListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListAnalysesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsAppealCall struct {
	s                                                         *Service
	name                                                      string
	googlecloudcontactcenterinsightsv1appealassessmentrequest *GoogleCloudContactcenterinsightsV1AppealAssessmentRequest
	urlParams_                                                gensupport.URLParams
	ctx_                                                      context.Context
	header_                                                   http.Header
}

// Appeal: Appeal an Assessment.
//
// - name: The name of the assessment to appeal.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService) Appeal(name string, googlecloudcontactcenterinsightsv1appealassessmentrequest *GoogleCloudContactcenterinsightsV1AppealAssessmentRequest) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsAppealCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsAppealCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1appealassessmentrequest = googlecloudcontactcenterinsightsv1appealassessmentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsAppealCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsAppealCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsAppealCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsAppealCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsAppealCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsAppealCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1appealassessmentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:appeal")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.appeal", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.appeal" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Assessment.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsAppealCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Assessment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Assessment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.appeal", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsCreateCall struct {
	s                                            *Service
	parent                                       string
	googlecloudcontactcenterinsightsv1assessment *GoogleCloudContactcenterinsightsV1Assessment
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// Create: Create Assessment.
//
// - parent: The parent resource of the assessment.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService) Create(parent string, googlecloudcontactcenterinsightsv1assessment *GoogleCloudContactcenterinsightsV1Assessment) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsCreateCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1assessment = googlecloudcontactcenterinsightsv1assessment
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsCreateCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1assessment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assessments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Assessment.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Assessment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Assessment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete an Assessment.
//
// - name: The name of the assessment to delete.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService) Delete(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, all of this
// assessment's notes will also be deleted. Otherwise, the request will only
// succeed if it has no notes.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall) Force(force bool) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsFinalizeCall struct {
	s                                                           *Service
	name                                                        string
	googlecloudcontactcenterinsightsv1finalizeassessmentrequest *GoogleCloudContactcenterinsightsV1FinalizeAssessmentRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// Finalize: Finalize an Assessment.
//
// - name: The name of the assessment to finalize.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService) Finalize(name string, googlecloudcontactcenterinsightsv1finalizeassessmentrequest *GoogleCloudContactcenterinsightsV1FinalizeAssessmentRequest) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsFinalizeCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsFinalizeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1finalizeassessmentrequest = googlecloudcontactcenterinsightsv1finalizeassessmentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsFinalizeCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsFinalizeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsFinalizeCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsFinalizeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsFinalizeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsFinalizeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1finalizeassessmentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:finalize")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.finalize", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.finalize" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Assessment.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsFinalizeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Assessment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Assessment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.finalize", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get Assessment.
//
// - name: The name of the assessment to get.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService) Get(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Assessment.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Assessment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Assessment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List Assessments.
//
//   - parent: The parent resource of the assessments. To list all assessments in
//     a location, substitute the conversation ID with a '-' character.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService) List(parent string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. Supported filters include: * `state` - The state of the
// assessment * `agent_info.agent_id` - The ID of the agent the assessment is
// for
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall) Filter(filter string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// assessments to list. If zero, the service will select a default size. A call
// may return fewer objects than requested. A non-empty `next_page_token` in
// the response indicates that more data is available.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall) PageSize(pageSize int64) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListAssessmentRulesResponse`; indicates that this is a continuation of
// a prior `ListAssessmentRules` call and the system should return the next
// page of data.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall) PageToken(pageToken string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/assessments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListAssessmentsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListAssessmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListAssessmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListAssessmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsPublishCall struct {
	s                                                          *Service
	name                                                       string
	googlecloudcontactcenterinsightsv1publishassessmentrequest *GoogleCloudContactcenterinsightsV1PublishAssessmentRequest
	urlParams_                                                 gensupport.URLParams
	ctx_                                                       context.Context
	header_                                                    http.Header
}

// Publish: Publish an Assessment.
//
// - name: The name of the assessment to publish.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsService) Publish(name string, googlecloudcontactcenterinsightsv1publishassessmentrequest *GoogleCloudContactcenterinsightsV1PublishAssessmentRequest) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsPublishCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsPublishCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1publishassessmentrequest = googlecloudcontactcenterinsightsv1publishassessmentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsPublishCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsPublishCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsPublishCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsPublishCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsPublishCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsPublishCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1publishassessmentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:publish")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.publish", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.publish" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Assessment.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsPublishCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Assessment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Assessment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.publish", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesCreateCall struct {
	s                                      *Service
	parent                                 string
	googlecloudcontactcenterinsightsv1note *GoogleCloudContactcenterinsightsV1Note
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Create: Create Note.
//
// - parent: The parent resource of the note.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService) Create(parent string, googlecloudcontactcenterinsightsv1note *GoogleCloudContactcenterinsightsV1Note) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesCreateCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1note = googlecloudcontactcenterinsightsv1note
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesCreateCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1note)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/notes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Note.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Note, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Note{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Note.
//
// - name: The name of the note to delete.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService) Delete(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesDeleteCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List Notes.
//
// - parent: The parent resource of the notes.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService) List(parent string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of notes
// to return in the response. If zero the service will select a default size. A
// call might return fewer objects than requested. A non-empty
// `next_page_token` in the response indicates that more data is available.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall) PageSize(pageSize int64) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListNotesResponse`. This value indicates that this is a continuation
// of a prior `ListNotes` call and that the system should return the next page
// of data.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall) PageToken(pageToken string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/notes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListNotesResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListNotesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListNotesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListNotesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall struct {
	s                                      *Service
	name                                   string
	googlecloudcontactcenterinsightsv1note *GoogleCloudContactcenterinsightsV1Note
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Patch: Update Note.
//
//   - name: Identifier. The resource name of the note. Format:
//     projects/{project}/locations/{location}/conversations/{conversation}/assess
//     ments/{assessment}/notes/{note}.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesService) Patch(name string, googlecloudcontactcenterinsightsv1note *GoogleCloudContactcenterinsightsV1Note) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1note = googlecloudcontactcenterinsightsv1note
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated. If the update_mask is empty, all updateable fields will be
// updated. Acceptable fields include: * `content`
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1note)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Note.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsAssessmentsNotesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Note, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Note{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall struct {
	s                                               *Service
	parent                                          string
	googlecloudcontactcenterinsightsv1feedbacklabel *GoogleCloudContactcenterinsightsV1FeedbackLabel
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Create: Create feedback label.
//
// - parent: The parent resource of the feedback label.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService) Create(parent string, googlecloudcontactcenterinsightsv1feedbacklabel *GoogleCloudContactcenterinsightsV1FeedbackLabel) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1feedbacklabel = googlecloudcontactcenterinsightsv1feedbacklabel
	return c
}

// FeedbackLabelId sets the optional parameter "feedbackLabelId": The ID of the
// feedback label to create. If one is not specified it will be generated by
// the server.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall) FeedbackLabelId(feedbackLabelId string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall {
	c.urlParams_.Set("feedbackLabelId", feedbackLabelId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1feedbacklabel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/feedbackLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1FeedbackLabel.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1FeedbackLabel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1FeedbackLabel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete feedback label.
//
// - name: The name of the feedback label to delete.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService) Delete(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsDeleteCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsDeleteCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get feedback label.
//
// - name: The name of the feedback label to get.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService) Get(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1FeedbackLabel.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1FeedbackLabel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1FeedbackLabel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List feedback labels.
//
// - parent: The parent resource of the feedback labels.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService) List(parent string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. Supports disjunctions (OR) and conjunctions (AND).
// Automatically sorts by conversation ID. To sort by all feedback labels in a
// project see ListAllFeedbackLabels. Supported fields: * `issue_model_id` *
// `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time`
// * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI,
// TOPIC_MODELING
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall) Filter(filter string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// feedback labels to return in the response. A valid page size ranges from 0
// to 100,000 inclusive. If the page size is zero or unspecified, a default
// page size of 100 will be chosen. Note that a call might return fewer results
// than the requested page size.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall) PageSize(pageSize int64) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListFeedbackLabelsResponse`. This value indicates that this is a
// continuation of a prior `ListFeedbackLabels` call and that the system should
// return the next page of data.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall) PageToken(pageToken string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/feedbackLabels")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall struct {
	s                                               *Service
	name                                            string
	googlecloudcontactcenterinsightsv1feedbacklabel *GoogleCloudContactcenterinsightsV1FeedbackLabel
	urlParams_                                      gensupport.URLParams
	ctx_                                            context.Context
	header_                                         http.Header
}

// Patch: Update feedback label.
//
//   - name: Immutable. Resource name of the FeedbackLabel. Format:
//     projects/{project}/locations/{location}/conversations/{conversation}/feedba
//     ckLabels/{feedback_label}.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsService) Patch(name string, googlecloudcontactcenterinsightsv1feedbacklabel *GoogleCloudContactcenterinsightsV1FeedbackLabel) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1feedbacklabel = googlecloudcontactcenterinsightsv1feedbacklabel
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The list of
// fields to be updated.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1feedbacklabel)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1FeedbackLabel.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsConversationsFeedbackLabelsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1FeedbackLabel, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1FeedbackLabel{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsCancelCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of `1`, corresponding to
// `Code.CANCELLED`.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService) Cancel(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsCancelCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.cancel", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService) Get(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsService) List(name string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall {
	c := &ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall) Filter(filter string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthorizedViewSetsAuthorizedViewsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsConversationsBulkAnalyzeCall struct {
	s                                                                 *Service
	parent                                                            string
	googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest
	urlParams_                                                        gensupport.URLParams
	ctx_                                                              context.Context
	header_                                                           http.Header
}

// BulkAnalyze: Analyzes multiple conversations in a single request.
//
// - parent: The parent resource to create analyses in.
func (r *ProjectsLocationsConversationsService) BulkAnalyze(parent string, googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest *GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest) *ProjectsLocationsConversationsBulkAnalyzeCall {
	c := &ProjectsLocationsConversationsBulkAnalyzeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest = googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsBulkAnalyzeCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsBulkAnalyzeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsBulkAnalyzeCall) Context(ctx context.Context) *ProjectsLocationsConversationsBulkAnalyzeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsBulkAnalyzeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsBulkAnalyzeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1bulkanalyzeconversationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations:bulkAnalyze")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.bulkAnalyze", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.bulkAnalyze" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsBulkAnalyzeCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.bulkAnalyze", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConversationsBulkDeleteCall struct {
	s                                                                *Service
	parent                                                           string
	googlecloudcontactcenterinsightsv1bulkdeleteconversationsrequest *GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest
	urlParams_                                                       gensupport.URLParams
	ctx_                                                             context.Context
	header_                                                          http.Header
}

// BulkDelete: Deletes multiple conversations in a single request.
//
//   - parent: The parent resource to delete conversations from. Format:
//     projects/{project}/locations/{location}.
func (r *ProjectsLocationsConversationsService) BulkDelete(parent string, googlecloudcontactcenterinsightsv1bulkdeleteconversationsrequest *GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest) *ProjectsLocationsConversationsBulkDeleteCall {
	c := &ProjectsLocationsConversationsBulkDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1bulkdeleteconversationsrequest = googlecloudcontactcenterinsightsv1bulkdeleteconversationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsBulkDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsBulkDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsBulkDeleteCall) Context(ctx context.Context) *ProjectsLocationsConversationsBulkDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsBulkDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsBulkDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1bulkdeleteconversationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations:bulkDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.bulkDelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.bulkDelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsBulkDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.bulkDelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConversationsCalculateStatsCall struct {
	s            *Service
	location     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CalculateStats: Gets conversation statistics.
//
// - location: The location of the conversations.
func (r *ProjectsLocationsConversationsService) CalculateStats(location string) *ProjectsLocationsConversationsCalculateStatsCall {
	c := &ProjectsLocationsConversationsCalculateStatsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.location = location
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. This field is useful for getting statistics about
// conversations with specific properties.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Filter(filter string) *ProjectsLocationsConversationsCalculateStatsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsCalculateStatsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConversationsCalculateStatsCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsCalculateStatsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Context(ctx context.Context) *ProjectsLocationsConversationsCalculateStatsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsCalculateStatsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+location}/conversations:calculateStats")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"location": c.location,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.calculateStats", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.calculateStats" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1CalculateStatsResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsCalculateStatsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1CalculateStatsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1CalculateStatsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.calculateStats", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConversationsCreateCall struct {
	s                                              *Service
	parent                                         string
	googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Create: Creates a conversation. Note that this method does not support audio
// transcription or redaction. Use `conversations.upload` instead.
//
// - parent: The parent resource of the conversation.
func (r *ProjectsLocationsConversationsService) Create(parent string, googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation) *ProjectsLocationsConversationsCreateCall {
	c := &ProjectsLocationsConversationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1conversation = googlecloudcontactcenterinsightsv1conversation
	return c
}

// ConversationId sets the optional parameter "conversationId": A unique ID for
// the new conversation. This ID will become the final component of the
// conversation's resource name. If no ID is specified, a server-generated ID
// will be used. This value should be 4-64 characters and must match the
// regular expression `^[a-z0-9-]{4,64}$`. Valid characters are `a-z-`
func (c *ProjectsLocationsConversationsCreateCall) ConversationId(conversationId string) *ProjectsLocationsConversationsCreateCall {
	c.urlParams_.Set("conversationId", conversationId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsCreateCall) Context(ctx context.Context) *ProjectsLocationsConversationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1conversation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Conversation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConversationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a conversation.
//
// - name: The name of the conversation to delete.
func (r *ProjectsLocationsConversationsService) Delete(name string) *ProjectsLocationsConversationsDeleteCall {
	c := &ProjectsLocationsConversationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Force sets the optional parameter "force": If set to true, all of this
// conversation's analyses will also be deleted. Otherwise, the request will
// only succeed if the conversation has no analyses.
func (c *ProjectsLocationsConversationsDeleteCall) Force(force bool) *ProjectsLocationsConversationsDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsConversationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConversationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConversationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a conversation.
//
// - name: The name of the conversation to get.
func (r *ProjectsLocationsConversationsService) Get(name string) *ProjectsLocationsConversationsGetCall {
	c := &ProjectsLocationsConversationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": The level of details of the
// conversation. Default is `FULL`.
//
// Possible values:
//
//	"CONVERSATION_VIEW_UNSPECIFIED" - The conversation view is not specified.
//
// * Defaults to `FULL` in `GetConversationRequest`. * Defaults to `BASIC` in
// `ListConversationsRequest`.
//
//	"FULL" - Populates all fields in the conversation.
//	"BASIC" - Populates all fields in the conversation except the transcript.
func (c *ProjectsLocationsConversationsGetCall) View(view string) *ProjectsLocationsConversationsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConversationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsGetCall) Context(ctx context.Context) *ProjectsLocationsConversationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Conversation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConversationsIngestCall struct {
	s                                                            *Service
	parent                                                       string
	googlecloudcontactcenterinsightsv1ingestconversationsrequest *GoogleCloudContactcenterinsightsV1IngestConversationsRequest
	urlParams_                                                   gensupport.URLParams
	ctx_                                                         context.Context
	header_                                                      http.Header
}

// Ingest: Imports conversations and processes them according to the user's
// configuration.
//
// - parent: The parent resource for new conversations.
func (r *ProjectsLocationsConversationsService) Ingest(parent string, googlecloudcontactcenterinsightsv1ingestconversationsrequest *GoogleCloudContactcenterinsightsV1IngestConversationsRequest) *ProjectsLocationsConversationsIngestCall {
	c := &ProjectsLocationsConversationsIngestCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudcontactcenterinsightsv1ingestconversationsrequest = googlecloudcontactcenterinsightsv1ingestconversationsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsIngestCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsIngestCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsIngestCall) Context(ctx context.Context) *ProjectsLocationsConversationsIngestCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsIngestCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsIngestCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1ingestconversationsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations:ingest")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.ingest", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.ingest" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsIngestCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.ingest", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConversationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists conversations.
//
// - parent: The parent resource of the conversation.
func (r *ProjectsLocationsConversationsService) List(parent string) *ProjectsLocationsConversationsListCall {
	c := &ProjectsLocationsConversationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter to reduce results to a
// specific subset. Useful for querying conversations with specific properties.
func (c *ProjectsLocationsConversationsListCall) Filter(filter string) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": The attribute by which to
// order conversations in the response. If empty, conversations will be ordered
// by descending creation time. Supported values are one of the following: *
// create_time * customer_satisfaction_rating * duration * latest_analysis *
// start_time * turn_count The default sort order is ascending. To specify
// order, append `asc` or `desc` (`create_time desc`). For more details, see
// Google AIPs Ordering (https://google.aip.dev/132#ordering).
func (c *ProjectsLocationsConversationsListCall) OrderBy(orderBy string) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// conversations to return in the response. A valid page size ranges from 0 to
// 100,000 inclusive. If the page size is zero or unspecified, a default page
// size of 100 will be chosen. Note that a call might return fewer results than
// the requested page size.
func (c *ProjectsLocationsConversationsListCall) PageSize(pageSize int64) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The value returned by the
// last `ListConversationsResponse`. This value indicates that this is a
// continuation of a prior `ListConversations` call and that the system should
// return the next page of data.
func (c *ProjectsLocationsConversationsListCall) PageToken(pageToken string) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The level of details of the
// conversation. Default is `BASIC`.
//
// Possible values:
//
//	"CONVERSATION_VIEW_UNSPECIFIED" - The conversation view is not specified.
//
// * Defaults to `FULL` in `GetConversationRequest`. * Defaults to `BASIC` in
// `ListConversationsRequest`.
//
//	"FULL" - Populates all fields in the conversation.
//	"BASIC" - Populates all fields in the conversation except the transcript.
func (c *ProjectsLocationsConversationsListCall) View(view string) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConversationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConversationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsListCall) Context(ctx context.Context) *ProjectsLocationsConversationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/conversations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1ListConversationsResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1ListConversationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1ListConversationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConversationsListCall) Pages(ctx context.Context, f func(*GoogleCloudContactcenterinsightsV1ListConversationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsConversationsPatchCall struct {
	s                                              *Service
	name                                           string
	googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// Patch: Updates a conversation.
//
//   - name: Immutable. The resource name of the conversation. Format:
//     projects/{project}/locations/{location}/conversations/{conversation}.
func (r *ProjectsLocationsConversationsService) Patch(name string, googlecloudcontactcenterinsightsv1conversation *GoogleCloudContactcenterinsightsV1Conversation) *ProjectsLocationsConversationsPatchCall {
	c := &ProjectsLocationsConversationsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudcontactcenterinsightsv1conversation = googlecloudcontactcenterinsightsv1conversation
	return c
}

// AllowMissing sets the optional parameter "allowMissing": Defaults to false.
// If set to true, and the conversation is not found, a new conversation will
// be created. In this situation, `update_mask` is ignored.
func (c *ProjectsLocationsConversationsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsConversationsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated. All possible fields can be updated by passing `*`, or a subset
// of the following updateable fields can be provided: * `agent_id` *
// `language_code` * `labels` * `metadata` * `quality_metadata` *
// `call_metadata` * `start_time` * `expire_time` or `ttl` *
// `data_source.gcs_source.audio_uri` or
// `data_source.dialogflow_source.audio_uri`
func (c *ProjectsLocationsConversationsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsConversationsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConversationsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsConversationsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConversationsPatchCall) Context(ctx context.Context) *ProjectsLocationsConversationsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConversationsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConversationsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudcontactcenterinsightsv1conversation)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "contactcenterinsights.projects.locations.conversations.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "contactcenterinsights.projects.locations.conversations.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudContactcenterinsightsV1Conversation.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConversationsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudContactcenterinsightsV1Conversation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudContactcenterinsightsV1Conversation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, 