// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package aiplatform provides access to the Vertex AI API.
//
// For product documentation, see: https://cloud.google.com/vertex-ai/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/aiplatform/v1beta1"
//	...
//	ctx := context.Background()
//	aiplatformService, err := aiplatform.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	aiplatformService, err := aiplatform.NewService(ctx, option.WithScopes(aiplatform.CloudPlatformReadOnlyScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	aiplatformService, err := aiplatform.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	aiplatformService, err := aiplatform.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package aiplatform // import "google.golang.org/api/aiplatform/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "aiplatform:v1beta1"
const apiName = "aiplatform"
const apiVersion = "v1beta1"
const basePath = "https://aiplatform.googleapis.com/"
const basePathTemplate = "https://aiplatform.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://aiplatform.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View your data across Google Cloud services and see the email address of
	// your Google Account
	CloudPlatformReadOnlyScope = "https://www.googleapis.com/auth/cloud-platform.read-only"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/cloud-platform.read-only",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Datasets = NewDatasetsService(s)
	s.Endpoints = NewEndpointsService(s)
	s.Media = NewMediaService(s)
	s.Projects = NewProjectsService(s)
	s.Publishers = NewPublishersService(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Datasets *DatasetsService

	Endpoints *EndpointsService

	Media *MediaService

	Projects *ProjectsService

	Publishers *PublishersService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewDatasetsService(s *Service) *DatasetsService {
	rs := &DatasetsService{s: s}
	rs.DatasetVersions = NewDatasetsDatasetVersionsService(s)
	return rs
}

type DatasetsService struct {
	s *Service

	DatasetVersions *DatasetsDatasetVersionsService
}

func NewDatasetsDatasetVersionsService(s *Service) *DatasetsDatasetVersionsService {
	rs := &DatasetsDatasetVersionsService{s: s}
	return rs
}

type DatasetsDatasetVersionsService struct {
	s *Service
}

func NewEndpointsService(s *Service) *EndpointsService {
	rs := &EndpointsService{s: s}
	return rs
}

type EndpointsService struct {
	s *Service
}

func NewMediaService(s *Service) *MediaService {
	rs := &MediaService{s: s}
	return rs
}

type MediaService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.ModelGardenEula = NewProjectsModelGardenEulaService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	ModelGardenEula *ProjectsModelGardenEulaService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Agents = NewProjectsLocationsAgentsService(s)
	rs.Apps = NewProjectsLocationsAppsService(s)
	rs.BatchPredictionJobs = NewProjectsLocationsBatchPredictionJobsService(s)
	rs.CachedContents = NewProjectsLocationsCachedContentsService(s)
	rs.CustomJobs = NewProjectsLocationsCustomJobsService(s)
	rs.DataLabelingJobs = NewProjectsLocationsDataLabelingJobsService(s)
	rs.Datasets = NewProjectsLocationsDatasetsService(s)
	rs.DeploymentResourcePools = NewProjectsLocationsDeploymentResourcePoolsService(s)
	rs.EdgeDevices = NewProjectsLocationsEdgeDevicesService(s)
	rs.Endpoints = NewProjectsLocationsEndpointsService(s)
	rs.EvaluationTasks = NewProjectsLocationsEvaluationTasksService(s)
	rs.ExampleStores = NewProjectsLocationsExampleStoresService(s)
	rs.ExtensionControllers = NewProjectsLocationsExtensionControllersService(s)
	rs.Extensions = NewProjectsLocationsExtensionsService(s)
	rs.FeatureGroups = NewProjectsLocationsFeatureGroupsService(s)
	rs.FeatureOnlineStores = NewProjectsLocationsFeatureOnlineStoresService(s)
	rs.Featurestores = NewProjectsLocationsFeaturestoresService(s)
	rs.HyperparameterTuningJobs = NewProjectsLocationsHyperparameterTuningJobsService(s)
	rs.IndexEndpoints = NewProjectsLocationsIndexEndpointsService(s)
	rs.Indexes = NewProjectsLocationsIndexesService(s)
	rs.MetadataStores = NewProjectsLocationsMetadataStoresService(s)
	rs.MigratableResources = NewProjectsLocationsMigratableResourcesService(s)
	rs.ModelDeploymentMonitoringJobs = NewProjectsLocationsModelDeploymentMonitoringJobsService(s)
	rs.ModelMonitors = NewProjectsLocationsModelMonitorsService(s)
	rs.Models = NewProjectsLocationsModelsService(s)
	rs.NasJobs = NewProjectsLocationsNasJobsService(s)
	rs.NotebookExecutionJobs = NewProjectsLocationsNotebookExecutionJobsService(s)
	rs.NotebookRuntimeTemplates = NewProjectsLocationsNotebookRuntimeTemplatesService(s)
	rs.NotebookRuntimes = NewProjectsLocationsNotebookRuntimesService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.PersistentResources = NewProjectsLocationsPersistentResourcesService(s)
	rs.PipelineJobs = NewProjectsLocationsPipelineJobsService(s)
	rs.Publishers = NewProjectsLocationsPublishersService(s)
	rs.RagCorpora = NewProjectsLocationsRagCorporaService(s)
	rs.ReasoningEngines = NewProjectsLocationsReasoningEnginesService(s)
	rs.Schedules = NewProjectsLocationsSchedulesService(s)
	rs.Sessions = NewProjectsLocationsSessionsService(s)
	rs.Solvers = NewProjectsLocationsSolversService(s)
	rs.SpecialistPools = NewProjectsLocationsSpecialistPoolsService(s)
	rs.Studies = NewProjectsLocationsStudiesService(s)
	rs.Tensorboards = NewProjectsLocationsTensorboardsService(s)
	rs.TrainingPipelines = NewProjectsLocationsTrainingPipelinesService(s)
	rs.TuningJobs = NewProjectsLocationsTuningJobsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Agents *ProjectsLocationsAgentsService

	Apps *ProjectsLocationsAppsService

	BatchPredictionJobs *ProjectsLocationsBatchPredictionJobsService

	CachedContents *ProjectsLocationsCachedContentsService

	CustomJobs *ProjectsLocationsCustomJobsService

	DataLabelingJobs *ProjectsLocationsDataLabelingJobsService

	Datasets *ProjectsLocationsDatasetsService

	DeploymentResourcePools *ProjectsLocationsDeploymentResourcePoolsService

	EdgeDevices *ProjectsLocationsEdgeDevicesService

	Endpoints *ProjectsLocationsEndpointsService

	EvaluationTasks *ProjectsLocationsEvaluationTasksService

	ExampleStores *ProjectsLocationsExampleStoresService

	ExtensionControllers *ProjectsLocationsExtensionControllersService

	Extensions *ProjectsLocationsExtensionsService

	FeatureGroups *ProjectsLocationsFeatureGroupsService

	FeatureOnlineStores *ProjectsLocationsFeatureOnlineStoresService

	Featurestores *ProjectsLocationsFeaturestoresService

	HyperparameterTuningJobs *ProjectsLocationsHyperparameterTuningJobsService

	IndexEndpoints *ProjectsLocationsIndexEndpointsService

	Indexes *ProjectsLocationsIndexesService

	MetadataStores *ProjectsLocationsMetadataStoresService

	MigratableResources *ProjectsLocationsMigratableResourcesService

	ModelDeploymentMonitoringJobs *ProjectsLocationsModelDeploymentMonitoringJobsService

	ModelMonitors *ProjectsLocationsModelMonitorsService

	Models *ProjectsLocationsModelsService

	NasJobs *ProjectsLocationsNasJobsService

	NotebookExecutionJobs *ProjectsLocationsNotebookExecutionJobsService

	NotebookRuntimeTemplates *ProjectsLocationsNotebookRuntimeTemplatesService

	NotebookRuntimes *ProjectsLocationsNotebookRuntimesService

	Operations *ProjectsLocationsOperationsService

	PersistentResources *ProjectsLocationsPersistentResourcesService

	PipelineJobs *ProjectsLocationsPipelineJobsService

	Publishers *ProjectsLocationsPublishersService

	RagCorpora *ProjectsLocationsRagCorporaService

	ReasoningEngines *ProjectsLocationsReasoningEnginesService

	Schedules *ProjectsLocationsSchedulesService

	Sessions *ProjectsLocationsSessionsService

	Solvers *ProjectsLocationsSolversService

	SpecialistPools *ProjectsLocationsSpecialistPoolsService

	Studies *ProjectsLocationsStudiesService

	Tensorboards *ProjectsLocationsTensorboardsService

	TrainingPipelines *ProjectsLocationsTrainingPipelinesService

	TuningJobs *ProjectsLocationsTuningJobsService
}

func NewProjectsLocationsAgentsService(s *Service) *ProjectsLocationsAgentsService {
	rs := &ProjectsLocationsAgentsService{s: s}
	rs.Operations = NewProjectsLocationsAgentsOperationsService(s)
	return rs
}

type ProjectsLocationsAgentsService struct {
	s *Service

	Operations *ProjectsLocationsAgentsOperationsService
}

func NewProjectsLocationsAgentsOperationsService(s *Service) *ProjectsLocationsAgentsOperationsService {
	rs := &ProjectsLocationsAgentsOperationsService{s: s}
	return rs
}

type ProjectsLocationsAgentsOperationsService struct {
	s *Service
}

func NewProjectsLocationsAppsService(s *Service) *ProjectsLocationsAppsService {
	rs := &ProjectsLocationsAppsService{s: s}
	rs.Operations = NewProjectsLocationsAppsOperationsService(s)
	return rs
}

type ProjectsLocationsAppsService struct {
	s *Service

	Operations *ProjectsLocationsAppsOperationsService
}

func NewProjectsLocationsAppsOperationsService(s *Service) *ProjectsLocationsAppsOperationsService {
	rs := &ProjectsLocationsAppsOperationsService{s: s}
	return rs
}

type ProjectsLocationsAppsOperationsService struct {
	s *Service
}

func NewProjectsLocationsBatchPredictionJobsService(s *Service) *ProjectsLocationsBatchPredictionJobsService {
	rs := &ProjectsLocationsBatchPredictionJobsService{s: s}
	return rs
}

type ProjectsLocationsBatchPredictionJobsService struct {
	s *Service
}

func NewProjectsLocationsCachedContentsService(s *Service) *ProjectsLocationsCachedContentsService {
	rs := &ProjectsLocationsCachedContentsService{s: s}
	return rs
}

type ProjectsLocationsCachedContentsService struct {
	s *Service
}

func NewProjectsLocationsCustomJobsService(s *Service) *ProjectsLocationsCustomJobsService {
	rs := &ProjectsLocationsCustomJobsService{s: s}
	rs.Operations = NewProjectsLocationsCustomJobsOperationsService(s)
	return rs
}

type ProjectsLocationsCustomJobsService struct {
	s *Service

	Operations *ProjectsLocationsCustomJobsOperationsService
}

func NewProjectsLocationsCustomJobsOperationsService(s *Service) *ProjectsLocationsCustomJobsOperationsService {
	rs := &ProjectsLocationsCustomJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsCustomJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDataLabelingJobsService(s *Service) *ProjectsLocationsDataLabelingJobsService {
	rs := &ProjectsLocationsDataLabelingJobsService{s: s}
	rs.Operations = NewProjectsLocationsDataLabelingJobsOperationsService(s)
	return rs
}

type ProjectsLocationsDataLabelingJobsService struct {
	s *Service

	Operations *ProjectsLocationsDataLabelingJobsOperationsService
}

func NewProjectsLocationsDataLabelingJobsOperationsService(s *Service) *ProjectsLocationsDataLabelingJobsOperationsService {
	rs := &ProjectsLocationsDataLabelingJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDataLabelingJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsService(s *Service) *ProjectsLocationsDatasetsService {
	rs := &ProjectsLocationsDatasetsService{s: s}
	rs.AnnotationSpecs = NewProjectsLocationsDatasetsAnnotationSpecsService(s)
	rs.DataItems = NewProjectsLocationsDatasetsDataItemsService(s)
	rs.DatasetVersions = NewProjectsLocationsDatasetsDatasetVersionsService(s)
	rs.Operations = NewProjectsLocationsDatasetsOperationsService(s)
	rs.SavedQueries = NewProjectsLocationsDatasetsSavedQueriesService(s)
	return rs
}

type ProjectsLocationsDatasetsService struct {
	s *Service

	AnnotationSpecs *ProjectsLocationsDatasetsAnnotationSpecsService

	DataItems *ProjectsLocationsDatasetsDataItemsService

	DatasetVersions *ProjectsLocationsDatasetsDatasetVersionsService

	Operations *ProjectsLocationsDatasetsOperationsService

	SavedQueries *ProjectsLocationsDatasetsSavedQueriesService
}

func NewProjectsLocationsDatasetsAnnotationSpecsService(s *Service) *ProjectsLocationsDatasetsAnnotationSpecsService {
	rs := &ProjectsLocationsDatasetsAnnotationSpecsService{s: s}
	rs.Operations = NewProjectsLocationsDatasetsAnnotationSpecsOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsAnnotationSpecsService struct {
	s *Service

	Operations *ProjectsLocationsDatasetsAnnotationSpecsOperationsService
}

func NewProjectsLocationsDatasetsAnnotationSpecsOperationsService(s *Service) *ProjectsLocationsDatasetsAnnotationSpecsOperationsService {
	rs := &ProjectsLocationsDatasetsAnnotationSpecsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsAnnotationSpecsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDataItemsService(s *Service) *ProjectsLocationsDatasetsDataItemsService {
	rs := &ProjectsLocationsDatasetsDataItemsService{s: s}
	rs.Annotations = NewProjectsLocationsDatasetsDataItemsAnnotationsService(s)
	rs.Operations = NewProjectsLocationsDatasetsDataItemsOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsDataItemsService struct {
	s *Service

	Annotations *ProjectsLocationsDatasetsDataItemsAnnotationsService

	Operations *ProjectsLocationsDatasetsDataItemsOperationsService
}

func NewProjectsLocationsDatasetsDataItemsAnnotationsService(s *Service) *ProjectsLocationsDatasetsDataItemsAnnotationsService {
	rs := &ProjectsLocationsDatasetsDataItemsAnnotationsService{s: s}
	rs.Operations = NewProjectsLocationsDatasetsDataItemsAnnotationsOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsDataItemsAnnotationsService struct {
	s *Service

	Operations *ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService
}

func NewProjectsLocationsDatasetsDataItemsAnnotationsOperationsService(s *Service) *ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService {
	rs := &ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDataItemsAnnotationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDataItemsOperationsService(s *Service) *ProjectsLocationsDatasetsDataItemsOperationsService {
	rs := &ProjectsLocationsDatasetsDataItemsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDataItemsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsDatasetVersionsService(s *Service) *ProjectsLocationsDatasetsDatasetVersionsService {
	rs := &ProjectsLocationsDatasetsDatasetVersionsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsDatasetVersionsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsOperationsService(s *Service) *ProjectsLocationsDatasetsOperationsService {
	rs := &ProjectsLocationsDatasetsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsOperationsService struct {
	s *Service
}

func NewProjectsLocationsDatasetsSavedQueriesService(s *Service) *ProjectsLocationsDatasetsSavedQueriesService {
	rs := &ProjectsLocationsDatasetsSavedQueriesService{s: s}
	rs.Operations = NewProjectsLocationsDatasetsSavedQueriesOperationsService(s)
	return rs
}

type ProjectsLocationsDatasetsSavedQueriesService struct {
	s *Service

	Operations *ProjectsLocationsDatasetsSavedQueriesOperationsService
}

func NewProjectsLocationsDatasetsSavedQueriesOperationsService(s *Service) *ProjectsLocationsDatasetsSavedQueriesOperationsService {
	rs := &ProjectsLocationsDatasetsSavedQueriesOperationsService{s: s}
	return rs
}

type ProjectsLocationsDatasetsSavedQueriesOperationsService struct {
	s *Service
}

func NewProjectsLocationsDeploymentResourcePoolsService(s *Service) *ProjectsLocationsDeploymentResourcePoolsService {
	rs := &ProjectsLocationsDeploymentResourcePoolsService{s: s}
	rs.Operations = NewProjectsLocationsDeploymentResourcePoolsOperationsService(s)
	return rs
}

type ProjectsLocationsDeploymentResourcePoolsService struct {
	s *Service

	Operations *ProjectsLocationsDeploymentResourcePoolsOperationsService
}

func NewProjectsLocationsDeploymentResourcePoolsOperationsService(s *Service) *ProjectsLocationsDeploymentResourcePoolsOperationsService {
	rs := &ProjectsLocationsDeploymentResourcePoolsOperationsService{s: s}
	return rs
}

type ProjectsLocationsDeploymentResourcePoolsOperationsService struct {
	s *Service
}

func NewProjectsLocationsEdgeDevicesService(s *Service) *ProjectsLocationsEdgeDevicesService {
	rs := &ProjectsLocationsEdgeDevicesService{s: s}
	rs.Operations = NewProjectsLocationsEdgeDevicesOperationsService(s)
	return rs
}

type ProjectsLocationsEdgeDevicesService struct {
	s *Service

	Operations *ProjectsLocationsEdgeDevicesOperationsService
}

func NewProjectsLocationsEdgeDevicesOperationsService(s *Service) *ProjectsLocationsEdgeDevicesOperationsService {
	rs := &ProjectsLocationsEdgeDevicesOperationsService{s: s}
	return rs
}

type ProjectsLocationsEdgeDevicesOperationsService struct {
	s *Service
}

func NewProjectsLocationsEndpointsService(s *Service) *ProjectsLocationsEndpointsService {
	rs := &ProjectsLocationsEndpointsService{s: s}
	rs.Chat = NewProjectsLocationsEndpointsChatService(s)
	rs.Operations = NewProjectsLocationsEndpointsOperationsService(s)
	return rs
}

type ProjectsLocationsEndpointsService struct {
	s *Service

	Chat *ProjectsLocationsEndpointsChatService

	Operations *ProjectsLocationsEndpointsOperationsService
}

func NewProjectsLocationsEndpointsChatService(s *Service) *ProjectsLocationsEndpointsChatService {
	rs := &ProjectsLocationsEndpointsChatService{s: s}
	return rs
}

type ProjectsLocationsEndpointsChatService struct {
	s *Service
}

func NewProjectsLocationsEndpointsOperationsService(s *Service) *ProjectsLocationsEndpointsOperationsService {
	rs := &ProjectsLocationsEndpointsOperationsService{s: s}
	return rs
}

type ProjectsLocationsEndpointsOperationsService struct {
	s *Service
}

func NewProjectsLocationsEvaluationTasksService(s *Service) *ProjectsLocationsEvaluationTasksService {
	rs := &ProjectsLocationsEvaluationTasksService{s: s}
	rs.Operations = NewProjectsLocationsEvaluationTasksOperationsService(s)
	return rs
}

type ProjectsLocationsEvaluationTasksService struct {
	s *Service

	Operations *ProjectsLocationsEvaluationTasksOperationsService
}

func NewProjectsLocationsEvaluationTasksOperationsService(s *Service) *ProjectsLocationsEvaluationTasksOperationsService {
	rs := &ProjectsLocationsEvaluationTasksOperationsService{s: s}
	return rs
}

type ProjectsLocationsEvaluationTasksOperationsService struct {
	s *Service
}

func NewProjectsLocationsExampleStoresService(s *Service) *ProjectsLocationsExampleStoresService {
	rs := &ProjectsLocationsExampleStoresService{s: s}
	rs.Operations = NewProjectsLocationsExampleStoresOperationsService(s)
	return rs
}

type ProjectsLocationsExampleStoresService struct {
	s *Service

	Operations *ProjectsLocationsExampleStoresOperationsService
}

func NewProjectsLocationsExampleStoresOperationsService(s *Service) *ProjectsLocationsExampleStoresOperationsService {
	rs := &ProjectsLocationsExampleStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsExampleStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsExtensionControllersService(s *Service) *ProjectsLocationsExtensionControllersService {
	rs := &ProjectsLocationsExtensionControllersService{s: s}
	rs.Operations = NewProjectsLocationsExtensionControllersOperationsService(s)
	return rs
}

type ProjectsLocationsExtensionControllersService struct {
	s *Service

	Operations *ProjectsLocationsExtensionControllersOperationsService
}

func NewProjectsLocationsExtensionControllersOperationsService(s *Service) *ProjectsLocationsExtensionControllersOperationsService {
	rs := &ProjectsLocationsExtensionControllersOperationsService{s: s}
	return rs
}

type ProjectsLocationsExtensionControllersOperationsService struct {
	s *Service
}

func NewProjectsLocationsExtensionsService(s *Service) *ProjectsLocationsExtensionsService {
	rs := &ProjectsLocationsExtensionsService{s: s}
	rs.Operations = NewProjectsLocationsExtensionsOperationsService(s)
	return rs
}

type ProjectsLocationsExtensionsService struct {
	s *Service

	Operations *ProjectsLocationsExtensionsOperationsService
}

func NewProjectsLocationsExtensionsOperationsService(s *Service) *ProjectsLocationsExtensionsOperationsService {
	rs := &ProjectsLocationsExtensionsOperationsService{s: s}
	return rs
}

type ProjectsLocationsExtensionsOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureGroupsService(s *Service) *ProjectsLocationsFeatureGroupsService {
	rs := &ProjectsLocationsFeatureGroupsService{s: s}
	rs.FeatureMonitors = NewProjectsLocationsFeatureGroupsFeatureMonitorsService(s)
	rs.Features = NewProjectsLocationsFeatureGroupsFeaturesService(s)
	rs.Operations = NewProjectsLocationsFeatureGroupsOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureGroupsService struct {
	s *Service

	FeatureMonitors *ProjectsLocationsFeatureGroupsFeatureMonitorsService

	Features *ProjectsLocationsFeatureGroupsFeaturesService

	Operations *ProjectsLocationsFeatureGroupsOperationsService
}

func NewProjectsLocationsFeatureGroupsFeatureMonitorsService(s *Service) *ProjectsLocationsFeatureGroupsFeatureMonitorsService {
	rs := &ProjectsLocationsFeatureGroupsFeatureMonitorsService{s: s}
	rs.FeatureMonitorJobs = NewProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJobsService(s)
	rs.Operations = NewProjectsLocationsFeatureGroupsFeatureMonitorsOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureGroupsFeatureMonitorsService struct {
	s *Service

	FeatureMonitorJobs *ProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJobsService

	Operations *ProjectsLocationsFeatureGroupsFeatureMonitorsOperationsService
}

func NewProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJobsService(s *Service) *ProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJobsService {
	rs := &ProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJobsService{s: s}
	return rs
}

type ProjectsLocationsFeatureGroupsFeatureMonitorsFeatureMonitorJobsService struct {
	s *Service
}

func NewProjectsLocationsFeatureGroupsFeatureMonitorsOperationsService(s *Service) *ProjectsLocationsFeatureGroupsFeatureMonitorsOperationsService {
	rs := &ProjectsLocationsFeatureGroupsFeatureMonitorsOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureGroupsFeatureMonitorsOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureGroupsFeaturesService(s *Service) *ProjectsLocationsFeatureGroupsFeaturesService {
	rs := &ProjectsLocationsFeatureGroupsFeaturesService{s: s}
	rs.Operations = NewProjectsLocationsFeatureGroupsFeaturesOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureGroupsFeaturesService struct {
	s *Service

	Operations *ProjectsLocationsFeatureGroupsFeaturesOperationsService
}

func NewProjectsLocationsFeatureGroupsFeaturesOperationsService(s *Service) *ProjectsLocationsFeatureGroupsFeaturesOperationsService {
	rs := &ProjectsLocationsFeatureGroupsFeaturesOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureGroupsFeaturesOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureGroupsOperationsService(s *Service) *ProjectsLocationsFeatureGroupsOperationsService {
	rs := &ProjectsLocationsFeatureGroupsOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureGroupsOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureOnlineStoresService(s *Service) *ProjectsLocationsFeatureOnlineStoresService {
	rs := &ProjectsLocationsFeatureOnlineStoresService{s: s}
	rs.FeatureViews = NewProjectsLocationsFeatureOnlineStoresFeatureViewsService(s)
	rs.Operations = NewProjectsLocationsFeatureOnlineStoresOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureOnlineStoresService struct {
	s *Service

	FeatureViews *ProjectsLocationsFeatureOnlineStoresFeatureViewsService

	Operations *ProjectsLocationsFeatureOnlineStoresOperationsService
}

func NewProjectsLocationsFeatureOnlineStoresFeatureViewsService(s *Service) *ProjectsLocationsFeatureOnlineStoresFeatureViewsService {
	rs := &ProjectsLocationsFeatureOnlineStoresFeatureViewsService{s: s}
	rs.FeatureViewSyncs = NewProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService(s)
	rs.Operations = NewProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService(s)
	return rs
}

type ProjectsLocationsFeatureOnlineStoresFeatureViewsService struct {
	s *Service

	FeatureViewSyncs *ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService

	Operations *ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService
}

func NewProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService(s *Service) *ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService {
	rs := &ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService{s: s}
	return rs
}

type ProjectsLocationsFeatureOnlineStoresFeatureViewsFeatureViewSyncsService struct {
	s *Service
}

func NewProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService(s *Service) *ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService {
	rs := &ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureOnlineStoresFeatureViewsOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeatureOnlineStoresOperationsService(s *Service) *ProjectsLocationsFeatureOnlineStoresOperationsService {
	rs := &ProjectsLocationsFeatureOnlineStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeatureOnlineStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeaturestoresService(s *Service) *ProjectsLocationsFeaturestoresService {
	rs := &ProjectsLocationsFeaturestoresService{s: s}
	rs.EntityTypes = NewProjectsLocationsFeaturestoresEntityTypesService(s)
	rs.Operations = NewProjectsLocationsFeaturestoresOperationsService(s)
	return rs
}

type ProjectsLocationsFeaturestoresService struct {
	s *Service

	EntityTypes *ProjectsLocationsFeaturestoresEntityTypesService

	Operations *ProjectsLocationsFeaturestoresOperationsService
}

func NewProjectsLocationsFeaturestoresEntityTypesService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesService{s: s}
	rs.Features = NewProjectsLocationsFeaturestoresEntityTypesFeaturesService(s)
	rs.Operations = NewProjectsLocationsFeaturestoresEntityTypesOperationsService(s)
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesService struct {
	s *Service

	Features *ProjectsLocationsFeaturestoresEntityTypesFeaturesService

	Operations *ProjectsLocationsFeaturestoresEntityTypesOperationsService
}

func NewProjectsLocationsFeaturestoresEntityTypesFeaturesService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesFeaturesService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesFeaturesService{s: s}
	rs.Operations = NewProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService(s)
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesFeaturesService struct {
	s *Service

	Operations *ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService
}

func NewProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesFeaturesOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeaturestoresEntityTypesOperationsService(s *Service) *ProjectsLocationsFeaturestoresEntityTypesOperationsService {
	rs := &ProjectsLocationsFeaturestoresEntityTypesOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeaturestoresEntityTypesOperationsService struct {
	s *Service
}

func NewProjectsLocationsFeaturestoresOperationsService(s *Service) *ProjectsLocationsFeaturestoresOperationsService {
	rs := &ProjectsLocationsFeaturestoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsFeaturestoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsHyperparameterTuningJobsService(s *Service) *ProjectsLocationsHyperparameterTuningJobsService {
	rs := &ProjectsLocationsHyperparameterTuningJobsService{s: s}
	rs.Operations = NewProjectsLocationsHyperparameterTuningJobsOperationsService(s)
	return rs
}

type ProjectsLocationsHyperparameterTuningJobsService struct {
	s *Service

	Operations *ProjectsLocationsHyperparameterTuningJobsOperationsService
}

func NewProjectsLocationsHyperparameterTuningJobsOperationsService(s *Service) *ProjectsLocationsHyperparameterTuningJobsOperationsService {
	rs := &ProjectsLocationsHyperparameterTuningJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsHyperparameterTuningJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsIndexEndpointsService(s *Service) *ProjectsLocationsIndexEndpointsService {
	rs := &ProjectsLocationsIndexEndpointsService{s: s}
	rs.Operations = NewProjectsLocationsIndexEndpointsOperationsService(s)
	return rs
}

type ProjectsLocationsIndexEndpointsService struct {
	s *Service

	Operations *ProjectsLocationsIndexEndpointsOperationsService
}

func NewProjectsLocationsIndexEndpointsOperationsService(s *Service) *ProjectsLocationsIndexEndpointsOperationsService {
	rs := &ProjectsLocationsIndexEndpointsOperationsService{s: s}
	return rs
}

type ProjectsLocationsIndexEndpointsOperationsService struct {
	s *Service
}

func NewProjectsLocationsIndexesService(s *Service) *ProjectsLocationsIndexesService {
	rs := &ProjectsLocationsIndexesService{s: s}
	rs.Operations = NewProjectsLocationsIndexesOperationsService(s)
	return rs
}

type ProjectsLocationsIndexesService struct {
	s *Service

	Operations *ProjectsLocationsIndexesOperationsService
}

func NewProjectsLocationsIndexesOperationsService(s *Service) *ProjectsLocationsIndexesOperationsService {
	rs := &ProjectsLocationsIndexesOperationsService{s: s}
	return rs
}

type ProjectsLocationsIndexesOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresService(s *Service) *ProjectsLocationsMetadataStoresService {
	rs := &ProjectsLocationsMetadataStoresService{s: s}
	rs.Artifacts = NewProjectsLocationsMetadataStoresArtifactsService(s)
	rs.Contexts = NewProjectsLocationsMetadataStoresContextsService(s)
	rs.Executions = NewProjectsLocationsMetadataStoresExecutionsService(s)
	rs.MetadataSchemas = NewProjectsLocationsMetadataStoresMetadataSchemasService(s)
	rs.Operations = NewProjectsLocationsMetadataStoresOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresService struct {
	s *Service

	Artifacts *ProjectsLocationsMetadataStoresArtifactsService

	Contexts *ProjectsLocationsMetadataStoresContextsService

	Executions *ProjectsLocationsMetadataStoresExecutionsService

	MetadataSchemas *ProjectsLocationsMetadataStoresMetadataSchemasService

	Operations *ProjectsLocationsMetadataStoresOperationsService
}

func NewProjectsLocationsMetadataStoresArtifactsService(s *Service) *ProjectsLocationsMetadataStoresArtifactsService {
	rs := &ProjectsLocationsMetadataStoresArtifactsService{s: s}
	rs.Operations = NewProjectsLocationsMetadataStoresArtifactsOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresArtifactsService struct {
	s *Service

	Operations *ProjectsLocationsMetadataStoresArtifactsOperationsService
}

func NewProjectsLocationsMetadataStoresArtifactsOperationsService(s *Service) *ProjectsLocationsMetadataStoresArtifactsOperationsService {
	rs := &ProjectsLocationsMetadataStoresArtifactsOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresArtifactsOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresContextsService(s *Service) *ProjectsLocationsMetadataStoresContextsService {
	rs := &ProjectsLocationsMetadataStoresContextsService{s: s}
	rs.Operations = NewProjectsLocationsMetadataStoresContextsOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresContextsService struct {
	s *Service

	Operations *ProjectsLocationsMetadataStoresContextsOperationsService
}

func NewProjectsLocationsMetadataStoresContextsOperationsService(s *Service) *ProjectsLocationsMetadataStoresContextsOperationsService {
	rs := &ProjectsLocationsMetadataStoresContextsOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresContextsOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresExecutionsService(s *Service) *ProjectsLocationsMetadataStoresExecutionsService {
	rs := &ProjectsLocationsMetadataStoresExecutionsService{s: s}
	rs.Operations = NewProjectsLocationsMetadataStoresExecutionsOperationsService(s)
	return rs
}

type ProjectsLocationsMetadataStoresExecutionsService struct {
	s *Service

	Operations *ProjectsLocationsMetadataStoresExecutionsOperationsService
}

func NewProjectsLocationsMetadataStoresExecutionsOperationsService(s *Service) *ProjectsLocationsMetadataStoresExecutionsOperationsService {
	rs := &ProjectsLocationsMetadataStoresExecutionsOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresExecutionsOperationsService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresMetadataSchemasService(s *Service) *ProjectsLocationsMetadataStoresMetadataSchemasService {
	rs := &ProjectsLocationsMetadataStoresMetadataSchemasService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresMetadataSchemasService struct {
	s *Service
}

func NewProjectsLocationsMetadataStoresOperationsService(s *Service) *ProjectsLocationsMetadataStoresOperationsService {
	rs := &ProjectsLocationsMetadataStoresOperationsService{s: s}
	return rs
}

type ProjectsLocationsMetadataStoresOperationsService struct {
	s *Service
}

func NewProjectsLocationsMigratableResourcesService(s *Service) *ProjectsLocationsMigratableResourcesService {
	rs := &ProjectsLocationsMigratableResourcesService{s: s}
	rs.Operations = NewProjectsLocationsMigratableResourcesOperationsService(s)
	return rs
}

type ProjectsLocationsMigratableResourcesService struct {
	s *Service

	Operations *ProjectsLocationsMigratableResourcesOperationsService
}

func NewProjectsLocationsMigratableResourcesOperationsService(s *Service) *ProjectsLocationsMigratableResourcesOperationsService {
	rs := &ProjectsLocationsMigratableResourcesOperationsService{s: s}
	return rs
}

type ProjectsLocationsMigratableResourcesOperationsService struct {
	s *Service
}

func NewProjectsLocationsModelDeploymentMonitoringJobsService(s *Service) *ProjectsLocationsModelDeploymentMonitoringJobsService {
	rs := &ProjectsLocationsModelDeploymentMonitoringJobsService{s: s}
	rs.Operations = NewProjectsLocationsModelDeploymentMonitoringJobsOperationsService(s)
	return rs
}

type ProjectsLocationsModelDeploymentMonitoringJobsService struct {
	s *Service

	Operations *ProjectsLocationsModelDeploymentMonitoringJobsOperationsService
}

func NewProjectsLocationsModelDeploymentMonitoringJobsOperationsService(s *Service) *ProjectsLocationsModelDeploymentMonitoringJobsOperationsService {
	rs := &ProjectsLocationsModelDeploymentMonitoringJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsModelDeploymentMonitoringJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsModelMonitorsService(s *Service) *ProjectsLocationsModelMonitorsService {
	rs := &ProjectsLocationsModelMonitorsService{s: s}
	rs.ModelMonitoringJobs = NewProjectsLocationsModelMonitorsModelMonitoringJobsService(s)
	rs.Operations = NewProjectsLocationsModelMonitorsOperationsService(s)
	return rs
}

type ProjectsLocationsModelMonitorsService struct {
	s *Service

	ModelMonitoringJobs *ProjectsLocationsModelMonitorsModelMonitoringJobsService

	Operations *ProjectsLocationsModelMonitorsOperationsService
}

func NewProjectsLocationsModelMonitorsModelMonitoringJobsService(s *Service) *ProjectsLocationsModelMonitorsModelMonitoringJobsService {
	rs := &ProjectsLocationsModelMonitorsModelMonitoringJobsService{s: s}
	return rs
}

type ProjectsLocationsModelMonitorsModelMonitoringJobsService struct {
	s *Service
}

func NewProjectsLocationsModelMonitorsOperationsService(s *Service) *ProjectsLocationsModelMonitorsOperationsService {
	rs := &ProjectsLocationsModelMonitorsOperationsService{s: s}
	return rs
}

type ProjectsLocationsModelMonitorsOperationsService struct {
	s *Service
}

func NewProjectsLocationsModelsService(s *Service) *ProjectsLocationsModelsService {
	rs := &ProjectsLocationsModelsService{s: s}
	rs.Evaluations = NewProjectsLocationsModelsEvaluationsService(s)
	rs.Operations = NewProjectsLocationsModelsOperationsService(s)
	return rs
}

type ProjectsLocationsModelsService struct {
	s *Service

	Evaluations *ProjectsLocationsModelsEvaluationsService

	Operations *ProjectsLocationsModelsOperationsService
}

func NewProjectsLocationsModelsEvaluationsService(s *Service) *ProjectsLocationsModelsEvaluationsService {
	rs := &ProjectsLocationsModelsEvaluationsService{s: s}
	rs.Operations = NewProjectsLocationsModelsEvaluationsOperationsService(s)
	rs.Slices = NewProjectsLocationsModelsEvaluationsSlicesService(s)
	return rs
}

type ProjectsLocationsModelsEvaluationsService struct {
	s *Service

	Operations *ProjectsLocationsModelsEvaluationsOperationsService

	Slices *ProjectsLocationsModelsEvaluationsSlicesService
}

func NewProjectsLocationsModelsEvaluationsOperationsService(s *Service) *ProjectsLocationsModelsEvaluationsOperationsService {
	rs := &ProjectsLocationsModelsEvaluationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsModelsEvaluationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsModelsEvaluationsSlicesService(s *Service) *ProjectsLocationsModelsEvaluationsSlicesService {
	rs := &ProjectsLocationsModelsEvaluationsSlicesService{s: s}
	return rs
}

type ProjectsLocationsModelsEvaluationsSlicesService struct {
	s *Service
}

func NewProjectsLocationsModelsOperationsService(s *Service) *ProjectsLocationsModelsOperationsService {
	rs := &ProjectsLocationsModelsOperationsService{s: s}
	return rs
}

type ProjectsLocationsModelsOperationsService struct {
	s *Service
}

func NewProjectsLocationsNasJobsService(s *Service) *ProjectsLocationsNasJobsService {
	rs := &ProjectsLocationsNasJobsService{s: s}
	rs.NasTrialDetails = NewProjectsLocationsNasJobsNasTrialDetailsService(s)
	return rs
}

type ProjectsLocationsNasJobsService struct {
	s *Service

	NasTrialDetails *ProjectsLocationsNasJobsNasTrialDetailsService
}

func NewProjectsLocationsNasJobsNasTrialDetailsService(s *Service) *ProjectsLocationsNasJobsNasTrialDetailsService {
	rs := &ProjectsLocationsNasJobsNasTrialDetailsService{s: s}
	return rs
}

type ProjectsLocationsNasJobsNasTrialDetailsService struct {
	s *Service
}

func NewProjectsLocationsNotebookExecutionJobsService(s *Service) *ProjectsLocationsNotebookExecutionJobsService {
	rs := &ProjectsLocationsNotebookExecutionJobsService{s: s}
	rs.Operations = NewProjectsLocationsNotebookExecutionJobsOperationsService(s)
	return rs
}

type ProjectsLocationsNotebookExecutionJobsService struct {
	s *Service

	Operations *ProjectsLocationsNotebookExecutionJobsOperationsService
}

func NewProjectsLocationsNotebookExecutionJobsOperationsService(s *Service) *ProjectsLocationsNotebookExecutionJobsOperationsService {
	rs := &ProjectsLocationsNotebookExecutionJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsNotebookExecutionJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsNotebookRuntimeTemplatesService(s *Service) *ProjectsLocationsNotebookRuntimeTemplatesService {
	rs := &ProjectsLocationsNotebookRuntimeTemplatesService{s: s}
	rs.Operations = NewProjectsLocationsNotebookRuntimeTemplatesOperationsService(s)
	return rs
}

type ProjectsLocationsNotebookRuntimeTemplatesService struct {
	s *Service

	Operations *ProjectsLocationsNotebookRuntimeTemplatesOperationsService
}

func NewProjectsLocationsNotebookRuntimeTemplatesOperationsService(s *Service) *ProjectsLocationsNotebookRuntimeTemplatesOperationsService {
	rs := &ProjectsLocationsNotebookRuntimeTemplatesOperationsService{s: s}
	return rs
}

type ProjectsLocationsNotebookRuntimeTemplatesOperationsService struct {
	s *Service
}

func NewProjectsLocationsNotebookRuntimesService(s *Service) *ProjectsLocationsNotebookRuntimesService {
	rs := &ProjectsLocationsNotebookRuntimesService{s: s}
	rs.Operations = NewProjectsLocationsNotebookRuntimesOperationsService(s)
	return rs
}

type ProjectsLocationsNotebookRuntimesService struct {
	s *Service

	Operations *ProjectsLocationsNotebookRuntimesOperationsService
}

func NewProjectsLocationsNotebookRuntimesOperationsService(s *Service) *ProjectsLocationsNotebookRuntimesOperationsService {
	rs := &ProjectsLocationsNotebookRuntimesOperationsService{s: s}
	return rs
}

type ProjectsLocationsNotebookRuntimesOperationsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPersistentResourcesService(s *Service) *ProjectsLocationsPersistentResourcesService {
	rs := &ProjectsLocationsPersistentResourcesService{s: s}
	rs.Operations = NewProjectsLocationsPersistentResourcesOperationsService(s)
	return rs
}

type ProjectsLocationsPersistentResourcesService struct {
	s *Service

	Operations *ProjectsLocationsPersistentResourcesOperationsService
}

func NewProjectsLocationsPersistentResourcesOperationsService(s *Service) *ProjectsLocationsPersistentResourcesOperationsService {
	rs := &ProjectsLocationsPersistentResourcesOperationsService{s: s}
	return rs
}

type ProjectsLocationsPersistentResourcesOperationsService struct {
	s *Service
}

func NewProjectsLocationsPipelineJobsService(s *Service) *ProjectsLocationsPipelineJobsService {
	rs := &ProjectsLocationsPipelineJobsService{s: s}
	rs.Operations = NewProjectsLocationsPipelineJobsOperationsService(s)
	return rs
}

type ProjectsLocationsPipelineJobsService struct {
	s *Service

	Operations *ProjectsLocationsPipelineJobsOperationsService
}

func NewProjectsLocationsPipelineJobsOperationsService(s *Service) *ProjectsLocationsPipelineJobsOperationsService {
	rs := &ProjectsLocationsPipelineJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsPipelineJobsOperationsService struct {
	s *Service
}

func NewProjectsLocationsPublishersService(s *Service) *ProjectsLocationsPublishersService {
	rs := &ProjectsLocationsPublishersService{s: s}
	rs.Models = NewProjectsLocationsPublishersModelsService(s)
	return rs
}

type ProjectsLocationsPublishersService struct {
	s *Service

	Models *ProjectsLocationsPublishersModelsService
}

func NewProjectsLocationsPublishersModelsService(s *Service) *ProjectsLocationsPublishersModelsService {
	rs := &ProjectsLocationsPublishersModelsService{s: s}
	return rs
}

type ProjectsLocationsPublishersModelsService struct {
	s *Service
}

func NewProjectsLocationsRagCorporaService(s *Service) *ProjectsLocationsRagCorporaService {
	rs := &ProjectsLocationsRagCorporaService{s: s}
	rs.Operations = NewProjectsLocationsRagCorporaOperationsService(s)
	rs.RagFiles = NewProjectsLocationsRagCorporaRagFilesService(s)
	return rs
}

type ProjectsLocationsRagCorporaService struct {
	s *Service

	Operations *ProjectsLocationsRagCorporaOperationsService

	RagFiles *ProjectsLocationsRagCorporaRagFilesService
}

func NewProjectsLocationsRagCorporaOperationsService(s *Service) *ProjectsLocationsRagCorporaOperationsService {
	rs := &ProjectsLocationsRagCorporaOperationsService{s: s}
	return rs
}

type ProjectsLocationsRagCorporaOperationsService struct {
	s *Service
}

func NewProjectsLocationsRagCorporaRagFilesService(s *Service) *ProjectsLocationsRagCorporaRagFilesService {
	rs := &ProjectsLocationsRagCorporaRagFilesService{s: s}
	rs.Operations = NewProjectsLocationsRagCorporaRagFilesOperationsService(s)
	return rs
}

type ProjectsLocationsRagCorporaRagFilesService struct {
	s *Service

	Operations *ProjectsLocationsRagCorporaRagFilesOperationsService
}

func NewProjectsLocationsRagCorporaRagFilesOperationsService(s *Service) *ProjectsLocationsRagCorporaRagFilesOperationsService {
	rs := &ProjectsLocationsRagCorporaRagFilesOperationsService{s: s}
	return rs
}

type ProjectsLocationsRagCorporaRagFilesOperationsService struct {
	s *Service
}

func NewProjectsLocationsReasoningEnginesService(s *Service) *ProjectsLocationsReasoningEnginesService {
	rs := &ProjectsLocationsReasoningEnginesService{s: s}
	rs.Operations = NewProjectsLocationsReasoningEnginesOperationsService(s)
	rs.Sessions = NewProjectsLocationsReasoningEnginesSessionsService(s)
	return rs
}

type ProjectsLocationsReasoningEnginesService struct {
	s *Service

	Operations *ProjectsLocationsReasoningEnginesOperationsService

	Sessions *ProjectsLocationsReasoningEnginesSessionsService
}

func NewProjectsLocationsReasoningEnginesOperationsService(s *Service) *ProjectsLocationsReasoningEnginesOperationsService {
	rs := &ProjectsLocationsReasoningEnginesOperationsService{s: s}
	return rs
}

type ProjectsLocationsReasoningEnginesOperationsService struct {
	s *Service
}

func NewProjectsLocationsReasoningEnginesSessionsService(s *Service) *ProjectsLocationsReasoningEnginesSessionsService {
	rs := &ProjectsLocationsReasoningEnginesSessionsService{s: s}
	rs.Events = NewProjectsLocationsReasoningEnginesSessionsEventsService(s)
	return rs
}

type ProjectsLocationsReasoningEnginesSessionsService struct {
	s *Service

	Events *ProjectsLocationsReasoningEnginesSessionsEventsService
}

func NewProjectsLocationsReasoningEnginesSessionsEventsService(s *Service) *ProjectsLocationsReasoningEnginesSessionsEventsService {
	rs := &ProjectsLocationsReasoningEnginesSessionsEventsService{s: s}
	return rs
}

type ProjectsLocationsReasoningEnginesSessionsEventsService struct {
	s *Service
}

func NewProjectsLocationsSchedulesService(s *Service) *ProjectsLocationsSchedulesService {
	rs := &ProjectsLocationsSchedulesService{s: s}
	rs.Operations = NewProjectsLocationsSchedulesOperationsService(s)
	return rs
}

type ProjectsLocationsSchedulesService struct {
	s *Service

	Operations *ProjectsLocationsSchedulesOperationsService
}

func NewProjectsLocationsSchedulesOperationsService(s *Service) *ProjectsLocationsSchedulesOperationsService {
	rs := &ProjectsLocationsSchedulesOperationsService{s: s}
	return rs
}

type ProjectsLocationsSchedulesOperationsService struct {
	s *Service
}

func NewProjectsLocationsSessionsService(s *Service) *ProjectsLocationsSessionsService {
	rs := &ProjectsLocationsSessionsService{s: s}
	return rs
}

type ProjectsLocationsSessionsService struct {
	s *Service
}

func NewProjectsLocationsSolversService(s *Service) *ProjectsLocationsSolversService {
	rs := &ProjectsLocationsSolversService{s: s}
	rs.Operations = NewProjectsLocationsSolversOperationsService(s)
	return rs
}

type ProjectsLocationsSolversService struct {
	s *Service

	Operations *ProjectsLocationsSolversOperationsService
}

func NewProjectsLocationsSolversOperationsService(s *Service) *ProjectsLocationsSolversOperationsService {
	rs := &ProjectsLocationsSolversOperationsService{s: s}
	return rs
}

type ProjectsLocationsSolversOperationsService struct {
	s *Service
}

func NewProjectsLocationsSpecialistPoolsService(s *Service) *ProjectsLocationsSpecialistPoolsService {
	rs := &ProjectsLocationsSpecialistPoolsService{s: s}
	rs.Operations = NewProjectsLocationsSpecialistPoolsOperationsService(s)
	return rs
}

type ProjectsLocationsSpecialistPoolsService struct {
	s *Service

	Operations *ProjectsLocationsSpecialistPoolsOperationsService
}

func NewProjectsLocationsSpecialistPoolsOperationsService(s *Service) *ProjectsLocationsSpecialistPoolsOperationsService {
	rs := &ProjectsLocationsSpecialistPoolsOperationsService{s: s}
	return rs
}

type ProjectsLocationsSpecialistPoolsOperationsService struct {
	s *Service
}

func NewProjectsLocationsStudiesService(s *Service) *ProjectsLocationsStudiesService {
	rs := &ProjectsLocationsStudiesService{s: s}
	rs.Operations = NewProjectsLocationsStudiesOperationsService(s)
	rs.Trials = NewProjectsLocationsStudiesTrialsService(s)
	return rs
}

type ProjectsLocationsStudiesService struct {
	s *Service

	Operations *ProjectsLocationsStudiesOperationsService

	Trials *ProjectsLocationsStudiesTrialsService
}

func NewProjectsLocationsStudiesOperationsService(s *Service) *ProjectsLocationsStudiesOperationsService {
	rs := &ProjectsLocationsStudiesOperationsService{s: s}
	return rs
}

type ProjectsLocationsStudiesOperationsService struct {
	s *Service
}

func NewProjectsLocationsStudiesTrialsService(s *Service) *ProjectsLocationsStudiesTrialsService {
	rs := &ProjectsLocationsStudiesTrialsService{s: s}
	rs.Operations = NewProjectsLocationsStudiesTrialsOperationsService(s)
	return rs
}

type ProjectsLocationsStudiesTrialsService struct {
	s *Service

	Operations *ProjectsLocationsStudiesTrialsOperationsService
}

func NewProjectsLocationsStudiesTrialsOperationsService(s *Service) *ProjectsLocationsStudiesTrialsOperationsService {
	rs := &ProjectsLocationsStudiesTrialsOperationsService{s: s}
	return rs
}

type ProjectsLocationsStudiesTrialsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsService(s *Service) *ProjectsLocationsTensorboardsService {
	rs := &ProjectsLocationsTensorboardsService{s: s}
	rs.Experiments = NewProjectsLocationsTensorboardsExperimentsService(s)
	rs.Operations = NewProjectsLocationsTensorboardsOperationsService(s)
	return rs
}

type ProjectsLocationsTensorboardsService struct {
	s *Service

	Experiments *ProjectsLocationsTensorboardsExperimentsService

	Operations *ProjectsLocationsTensorboardsOperationsService
}

func NewProjectsLocationsTensorboardsExperimentsService(s *Service) *ProjectsLocationsTensorboardsExperimentsService {
	rs := &ProjectsLocationsTensorboardsExperimentsService{s: s}
	rs.Operations = NewProjectsLocationsTensorboardsExperimentsOperationsService(s)
	rs.Runs = NewProjectsLocationsTensorboardsExperimentsRunsService(s)
	return rs
}

type ProjectsLocationsTensorboardsExperimentsService struct {
	s *Service

	Operations *ProjectsLocationsTensorboardsExperimentsOperationsService

	Runs *ProjectsLocationsTensorboardsExperimentsRunsService
}

func NewProjectsLocationsTensorboardsExperimentsOperationsService(s *Service) *ProjectsLocationsTensorboardsExperimentsOperationsService {
	rs := &ProjectsLocationsTensorboardsExperimentsOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsExperimentsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsExperimentsRunsService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsService{s: s}
	rs.Operations = NewProjectsLocationsTensorboardsExperimentsRunsOperationsService(s)
	rs.TimeSeries = NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService(s)
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsService struct {
	s *Service

	Operations *ProjectsLocationsTensorboardsExperimentsRunsOperationsService

	TimeSeries *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService
}

func NewProjectsLocationsTensorboardsExperimentsRunsOperationsService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsOperationsService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService{s: s}
	rs.Operations = NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService(s)
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesService struct {
	s *Service

	Operations *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService
}

func NewProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService(s *Service) *ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService {
	rs := &ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsExperimentsRunsTimeSeriesOperationsService struct {
	s *Service
}

func NewProjectsLocationsTensorboardsOperationsService(s *Service) *ProjectsLocationsTensorboardsOperationsService {
	rs := &ProjectsLocationsTensorboardsOperationsService{s: s}
	return rs
}

type ProjectsLocationsTensorboardsOperationsService struct {
	s *Service
}

func NewProjectsLocationsTrainingPipelinesService(s *Service) *ProjectsLocationsTrainingPipelinesService {
	rs := &ProjectsLocationsTrainingPipelinesService{s: s}
	rs.Operations = NewProjectsLocationsTrainingPipelinesOperationsService(s)
	return rs
}

type ProjectsLocationsTrainingPipelinesService struct {
	s *Service

	Operations *ProjectsLocationsTrainingPipelinesOperationsService
}

func NewProjectsLocationsTrainingPipelinesOperationsService(s *Service) *ProjectsLocationsTrainingPipelinesOperationsService {
	rs := &ProjectsLocationsTrainingPipelinesOperationsService{s: s}
	return rs
}

type ProjectsLocationsTrainingPipelinesOperationsService struct {
	s *Service
}

func NewProjectsLocationsTuningJobsService(s *Service) *ProjectsLocationsTuningJobsService {
	rs := &ProjectsLocationsTuningJobsService{s: s}
	rs.Operations = NewProjectsLocationsTuningJobsOperationsService(s)
	return rs
}

type ProjectsLocationsTuningJobsService struct {
	s *Service

	Operations *ProjectsLocationsTuningJobsOperationsService
}

func NewProjectsLocationsTuningJobsOperationsService(s *Service) *ProjectsLocationsTuningJobsOperationsService {
	rs := &ProjectsLocationsTuningJobsOperationsService{s: s}
	return rs
}

type ProjectsLocationsTuningJobsOperationsService struct {
	s *Service
}

func NewProjectsModelGardenEulaService(s *Service) *ProjectsModelGardenEulaService {
	rs := &ProjectsModelGardenEulaService{s: s}
	return rs
}

type ProjectsModelGardenEulaService struct {
	s *Service
}

func NewPublishersService(s *Service) *PublishersService {
	rs := &PublishersService{s: s}
	rs.Models = NewPublishersModelsService(s)
	return rs
}

type PublishersService struct {
	s *Service

	Models *PublishersModelsService
}

func NewPublishersModelsService(s *Service) *PublishersModelsService {
	rs := &PublishersModelsService{s: s}
	return rs
}

type PublishersModelsService struct {
	s *Service
}

// CloudAiLargeModelsVisionGenerateVideoResponse: Generate video response.
type CloudAiLargeModelsVisionGenerateVideoResponse struct {
	// GeneratedSamples: The generates samples.
	GeneratedSamples []*CloudAiLargeModelsVisionMedia `json:"generatedSamples,omitempty"`
	// RaiMediaFilteredCount: Returns if any videos were filtered due to RAI
	// policies.
	RaiMediaFilteredCount int64 `json:"raiMediaFilteredCount,omitempty"`
	// RaiMediaFilteredReasons: Returns rai failure reasons if any.
	RaiMediaFilteredReasons []string `json:"raiMediaFilteredReasons,omitempty"`
	// Videos: List of videos, used to align naming with the external response.
	Videos []*CloudAiLargeModelsVisionGenerateVideoResponseVideo `json:"videos,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratedSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratedSamples") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionGenerateVideoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionGenerateVideoResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CloudAiLargeModelsVisionGenerateVideoResponseVideo struct {
	// BytesBase64Encoded: Base64 encoded bytes string representing the video.
	BytesBase64Encoded string `json:"bytesBase64Encoded,omitempty"`
	// GcsUri: Cloud Storage URI where the generated video is written.
	GcsUri string `json:"gcsUri,omitempty"`
	// MimeType: The MIME type of the content of the video. - video/mp4
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BytesBase64Encoded") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesBase64Encoded") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionGenerateVideoResponseVideo) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionGenerateVideoResponseVideo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionImage: Image.
type CloudAiLargeModelsVisionImage struct {
	// Encoding: Image encoding, encoded as "image/png" or "image/jpg".
	Encoding string `json:"encoding,omitempty"`
	// GenerationSeed: Generation seed for the sampled image. This parameter is
	// exposed to the user only if one of the following is true: 1. The user
	// specified per-example seeds in the request. 2. The user doesn't specify the
	// generation seed in the request.
	GenerationSeed int64 `json:"generationSeed,omitempty"`
	// Image: Raw bytes.
	Image string `json:"image,omitempty"`
	// ImageRaiScores: RAI scores for generated image.
	ImageRaiScores *CloudAiLargeModelsVisionImageRAIScores `json:"imageRaiScores,omitempty"`
	// ImageSize: Image size. The size of the image. Can be self reported, or
	// computed from the image bytes.
	ImageSize *CloudAiLargeModelsVisionImageImageSize `json:"imageSize,omitempty"`
	// RaiInfo: RAI info for image.
	RaiInfo *CloudAiLargeModelsVisionRaiInfo `json:"raiInfo,omitempty"`
	// SemanticFilterResponse: Semantic filter info for image.
	SemanticFilterResponse *CloudAiLargeModelsVisionSemanticFilterResponse `json:"semanticFilterResponse,omitempty"`
	// Text: Text/Expanded text input for imagen.
	Text string `json:"text,omitempty"`
	// Uri: Path to another storage (typically Google Cloud Storage).
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Encoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Encoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionImage) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionImageImageSize: Image size.
type CloudAiLargeModelsVisionImageImageSize struct {
	Channels int64 `json:"channels,omitempty"`
	Height   int64 `json:"height,omitempty"`
	Width    int64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionImageImageSize) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionImageImageSize
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionImageRAIScores: RAI scores for generated image
// returned.
type CloudAiLargeModelsVisionImageRAIScores struct {
	// AgileWatermarkDetectionScore: Agile watermark score for image.
	AgileWatermarkDetectionScore float64 `json:"agileWatermarkDetectionScore,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AgileWatermarkDetectionScore") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgileWatermarkDetectionScore") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionImageRAIScores) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionImageRAIScores
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionImageRAIScores) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionImageRAIScores
	var s1 struct {
		AgileWatermarkDetectionScore gensupport.JSONFloat64 `json:"agileWatermarkDetectionScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AgileWatermarkDetectionScore = float64(s1.AgileWatermarkDetectionScore)
	return nil
}

// CloudAiLargeModelsVisionMedia: Media.
type CloudAiLargeModelsVisionMedia struct {
	// Image: Image.
	Image *CloudAiLargeModelsVisionImage `json:"image,omitempty"`
	// Video: Video
	Video *CloudAiLargeModelsVisionVideo `json:"video,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Image") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionMedia) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionMedia
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CloudAiLargeModelsVisionNamedBoundingBox struct {
	Classes  []string  `json:"classes,omitempty"`
	Entities []string  `json:"entities,omitempty"`
	Scores   []float64 `json:"scores,omitempty"`
	X1       float64   `json:"x1,omitempty"`
	X2       float64   `json:"x2,omitempty"`
	Y1       float64   `json:"y1,omitempty"`
	Y2       float64   `json:"y2,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Classes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Classes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionNamedBoundingBox) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionNamedBoundingBox
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionNamedBoundingBox) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionNamedBoundingBox
	var s1 struct {
		Scores []gensupport.JSONFloat64 `json:"scores"`
		X1     gensupport.JSONFloat64   `json:"x1"`
		X2     gensupport.JSONFloat64   `json:"x2"`
		Y1     gensupport.JSONFloat64   `json:"y1"`
		Y2     gensupport.JSONFloat64   `json:"y2"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Scores = make([]float64, len(s1.Scores))
	for i := range s1.Scores {
		s.Scores[i] = float64(s1.Scores[i])
	}
	s.X1 = float64(s1.X1)
	s.X2 = float64(s1.X2)
	s.Y1 = float64(s1.Y1)
	s.Y2 = float64(s1.Y2)
	return nil
}

// CloudAiLargeModelsVisionRaiInfo: Next ID: 6
type CloudAiLargeModelsVisionRaiInfo struct {
	// BlockedEntities: List of blocked entities from the blocklist if it is
	// detected.
	BlockedEntities []string `json:"blockedEntities,omitempty"`
	// DetectedLabels: The list of detected labels for different rai categories.
	DetectedLabels []*CloudAiLargeModelsVisionRaiInfoDetectedLabels `json:"detectedLabels,omitempty"`
	// ModelName: The model name used to indexing into the RaiFilterConfig map.
	// Would either be one of imagegeneration@002-006, imagen-3.0-... api endpoint
	// names, or internal names used for mapping to different filter configs
	// (genselfie, ai_watermark) than its api endpoint.
	ModelName string `json:"modelName,omitempty"`
	// RaiCategories: List of rai categories' information to return
	RaiCategories []string `json:"raiCategories,omitempty"`
	// Scores: List of rai scores mapping to the rai categories. Rounded to 1
	// decimal place.
	Scores []float64 `json:"scores,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockedEntities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockedEntities") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionRaiInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionRaiInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionRaiInfo) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionRaiInfo
	var s1 struct {
		Scores []gensupport.JSONFloat64 `json:"scores"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Scores = make([]float64, len(s1.Scores))
	for i := range s1.Scores {
		s.Scores[i] = float64(s1.Scores[i])
	}
	return nil
}

// CloudAiLargeModelsVisionRaiInfoDetectedLabels: Filters returning list of
// deteceted labels, scores, and bounding boxes.
type CloudAiLargeModelsVisionRaiInfoDetectedLabels struct {
	// Entities: The list of detected entities for the rai signal.
	Entities []*CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity `json:"entities,omitempty"`
	// RaiCategory: The RAI category for the deteceted labels.
	RaiCategory string `json:"raiCategory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionRaiInfoDetectedLabels) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionRaiInfoDetectedLabels
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox: An integer
// bounding box of original pixels of the image for the detected labels.
type CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox struct {
	// X1: The X coordinate of the top-left corner, in pixels.
	X1 int64 `json:"x1,omitempty"`
	// X2: The X coordinate of the bottom-right corner, in pixels.
	X2 int64 `json:"x2,omitempty"`
	// Y1: The Y coordinate of the top-left corner, in pixels.
	Y1 int64 `json:"y1,omitempty"`
	// Y2: The Y coordinate of the bottom-right corner, in pixels.
	Y2 int64 `json:"y2,omitempty"`
	// ForceSendFields is a list of field names (e.g. "X1") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "X1") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity: The properties for a
// detected entity from the rai signal.
type CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity struct {
	// BoundingBox: Bounding box of the label
	BoundingBox *CloudAiLargeModelsVisionRaiInfoDetectedLabelsBoundingBox `json:"boundingBox,omitempty"`
	// Description: Description of the label
	Description string `json:"description,omitempty"`
	// IouScore: The intersection ratio between the detection bounding box and the
	// mask.
	IouScore float64 `json:"iouScore,omitempty"`
	// Mid: MID of the label
	Mid string `json:"mid,omitempty"`
	// Score: Confidence score of the label
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoundingBox") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoundingBox") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity) UnmarshalJSON(data []byte) error {
	type NoMethod CloudAiLargeModelsVisionRaiInfoDetectedLabelsEntity
	var s1 struct {
		IouScore gensupport.JSONFloat64 `json:"iouScore"`
		Score    gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IouScore = float64(s1.IouScore)
	s.Score = float64(s1.Score)
	return nil
}

type CloudAiLargeModelsVisionSemanticFilterResponse struct {
	// NamedBoundingBoxes: Class labels of the bounding boxes that failed the
	// semantic filtering. Bounding box coordinates.
	NamedBoundingBoxes []*CloudAiLargeModelsVisionNamedBoundingBox `json:"namedBoundingBoxes,omitempty"`
	// PassedSemanticFilter: This response is added when semantic filter config is
	// turned on in EditConfig. It reports if this image is passed semantic filter
	// response. If passed_semantic_filter is false, the bounding box information
	// will be populated for user to check what caused the semantic filter to fail.
	PassedSemanticFilter bool `json:"passedSemanticFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NamedBoundingBoxes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NamedBoundingBoxes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionSemanticFilterResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionSemanticFilterResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiLargeModelsVisionVideo: Video
type CloudAiLargeModelsVisionVideo struct {
	// EncodedVideo: Base 64 encoded video bytes.
	EncodedVideo string `json:"encodedVideo,omitempty"`
	// Encoding: Video encoding, for example "video/mp4".
	Encoding string `json:"encoding,omitempty"`
	// Text: Text/Expanded text input for Help Me Write.
	Text string `json:"text,omitempty"`
	// Uri: Path to another storage (typically Google Cloud Storage).
	Uri string `json:"uri,omitempty"`
	// Video: Raw bytes.
	Video string `json:"video,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncodedVideo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncodedVideo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiLargeModelsVisionVideo) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiLargeModelsVisionVideo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloudAiPlatformCommonCreatePipelineJobApiErrorDetail: Create API error
// message for Vertex Pipeline.
type CloudAiPlatformCommonCreatePipelineJobApiErrorDetail struct {
	// ErrorCause: The error root cause returned by CreatePipelineJob API.
	//
	// Possible values:
	//   "ERROR_CAUSE_UNSPECIFIED" - Should never be used.
	//   "INVALID_PIPELINE_SPEC_FORMAT" - IR Pipeline Spec can not been parsed to
	// yaml or json format.
	//   "INVALID_PIPELINE_SPEC" - A pipeline spec is invalid.
	//   "INVALID_DEPLOYMENT_CONFIG" - A deployment config is invalid.
	//   "INVALID_DEPLOYMENT_SPEC" - A deployment spec is invalid.
	//   "INVALID_INSTANCE_SCHEMA" - An instance schema is invalid.
	//   "INVALID_CUSTOM_JOB" - A custom job is invalid.
	//   "INVALID_CONTAINER_SPEC" - A container spec is invalid.
	//   "INVALID_NOTIFICATION_EMAIL_SETUP" - Notification email setup is invalid.
	//   "INVALID_SERVICE_ACCOUNT_SETUP" - Service account setup is invalid.
	//   "INVALID_KMS_SETUP" - KMS setup is invalid.
	//   "INVALID_NETWORK_SETUP" - Network setup is invalid.
	//   "INVALID_PIPELINE_TASK_SPEC" - Task spec is invalid.
	//   "INVALID_PIPELINE_TASK_ARTIFACT" - Task artifact is invalid.
	//   "INVALID_IMPORTER_SPEC" - Importer spec is invalid.
	//   "INVALID_RESOLVER_SPEC" - Resolver spec is invalid.
	//   "INVALID_RUNTIME_PARAMETERS" - Runtime Parameters are invalid.
	//   "CLOUD_API_NOT_ENABLED" - Cloud API not enabled.
	//   "INVALID_GCS_INPUT_URI" - Invalid Cloud Storage input uri
	//   "INVALID_GCS_OUTPUT_URI" - Invalid Cloud Storage output uri
	//   "INVALID_COMPONENT_SPEC" - Component spec of pipeline is invalid.
	//   "INVALID_DAG_OUTPUTS_SPEC" - DagOutputsSpec is invalid.
	//   "INVALID_DAG_SPEC" - DagSpec is invalid.
	//   "INSUFFICIENT_QUOTA" - Project does not have enough quota.
	//   "INTERNAL" - An internal error with unknown cause.
	ErrorCause string `json:"errorCause,omitempty"`
	// PublicMessage: Public messages contains actionable items for the error
	// cause.
	PublicMessage string `json:"publicMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorCause") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorCause") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloudAiPlatformCommonCreatePipelineJobApiErrorDetail) MarshalJSON() ([]byte, error) {
	type NoMethod CloudAiPlatformCommonCreatePipelineJobApiErrorDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It should
// only be used for payload formats that can't be represented as JSON, such as
// raw binary or an HTML page. This message can be used both in streaming and
// non-streaming API methods in the request as well as the response. It can be
// used as a top-level request field, which is convenient if one wants to
// extract parameters from either the URL or HTTP template into the request
// fields and also want access to the raw HTTP body. Example: message
// GetResourceRequest { // A unique request id. string request_id = 1; // The
// raw HTTP body is bound to this field. google.api.HttpBody http_body = 2; }
// service ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns
// (google.protobuf.Empty); } Example with streaming methods: service
// CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream
// google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
// (stream google.api.HttpBody); } Use of this type only changes how the
// request and response bodies are handled, all other features will continue to
// work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the content type
	// of the body.
	ContentType string `json:"contentType,omitempty"`
	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`
	// Extensions: Application specific response metadata. Must be set in the first
	// response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AcceptPublisherModelEulaRequest: Request message
// for ModelGardenService.AcceptPublisherModelEula.
type GoogleCloudAiplatformV1beta1AcceptPublisherModelEulaRequest struct {
	// PublisherModel: Required. The name of the PublisherModel resource. Format:
	// `publishers/{publisher}/models/{publisher_model}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}`
	PublisherModel string `json:"publisherModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PublisherModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublisherModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AcceptPublisherModelEulaRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AcceptPublisherModelEulaRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ActiveLearningConfig: Parameters that configure
// the active learning pipeline. Active learning will label the data
// incrementally by several iterations. For every iteration, it will select a
// batch of data based on the sampling strategy.
type GoogleCloudAiplatformV1beta1ActiveLearningConfig struct {
	// MaxDataItemCount: Max number of human labeled DataItems.
	MaxDataItemCount int64 `json:"maxDataItemCount,omitempty,string"`
	// MaxDataItemPercentage: Max percent of total DataItems for human labeling.
	MaxDataItemPercentage int64 `json:"maxDataItemPercentage,omitempty"`
	// SampleConfig: Active learning data sampling config. For every active
	// learning labeling iteration, it will select a batch of data based on the
	// sampling strategy.
	SampleConfig *GoogleCloudAiplatformV1beta1SampleConfig `json:"sampleConfig,omitempty"`
	// TrainingConfig: CMLE training config. For every active learning labeling
	// iteration, system will train a machine learning model on CMLE. The trained
	// model will be used by data sampling algorithm to select DataItems.
	TrainingConfig *GoogleCloudAiplatformV1beta1TrainingConfig `json:"trainingConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxDataItemCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxDataItemCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ActiveLearningConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ActiveLearningConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsRequest: Request
// message for MetadataService.AddContextArtifactsAndExecutions.
type GoogleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsRequest struct {
	// Artifacts: The resource names of the Artifacts to attribute to the Context.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artif
	// acts/{artifact}`
	Artifacts []string `json:"artifacts,omitempty"`
	// Executions: The resource names of the Executions to associate with the
	// Context. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/execu
	// tions/{execution}`
	Executions []string `json:"executions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Artifacts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Artifacts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsResponse:
// Response message for MetadataService.AddContextArtifactsAndExecutions.
type GoogleCloudAiplatformV1beta1AddContextArtifactsAndExecutionsResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAiplatformV1beta1AddContextChildrenRequest: Request message for
// MetadataService.AddContextChildren.
type GoogleCloudAiplatformV1beta1AddContextChildrenRequest struct {
	// ChildContexts: The resource names of the child Contexts.
	ChildContexts []string `json:"childContexts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChildContexts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChildContexts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AddContextChildrenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AddContextChildrenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AddContextChildrenResponse: Response message for
// MetadataService.AddContextChildren.
type GoogleCloudAiplatformV1beta1AddContextChildrenResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAiplatformV1beta1AddExecutionEventsRequest: Request message for
// MetadataService.AddExecutionEvents.
type GoogleCloudAiplatformV1beta1AddExecutionEventsRequest struct {
	// Events: The Events to create and add.
	Events []*GoogleCloudAiplatformV1beta1Event `json:"events,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Events") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Events") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AddExecutionEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AddExecutionEventsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AddExecutionEventsResponse: Response message for
// MetadataService.AddExecutionEvents.
type GoogleCloudAiplatformV1beta1AddExecutionEventsResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAiplatformV1beta1AddTrialMeasurementRequest: Request message for
// VizierService.AddTrialMeasurement.
type GoogleCloudAiplatformV1beta1AddTrialMeasurementRequest struct {
	// Measurement: Required. The measurement to be added to a Trial.
	Measurement *GoogleCloudAiplatformV1beta1Measurement `json:"measurement,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Measurement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Measurement") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AddTrialMeasurementRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AddTrialMeasurementRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Annotation: Used to assign specific
// AnnotationSpec to a particular area of a DataItem or the whole part of the
// DataItem.
type GoogleCloudAiplatformV1beta1Annotation struct {
	// AnnotationSource: Output only. The source of the Annotation.
	AnnotationSource *GoogleCloudAiplatformV1beta1UserActionReference `json:"annotationSource,omitempty"`
	// CreateTime: Output only. Timestamp when this Annotation was created.
	CreateTime string `json:"createTime,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// Annotations. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed. No
	// more than 64 user labels can be associated with one Annotation(System labels
	// are excluded). See https://goo.gl/xmQnxf for more information and examples
	// of labels. System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable. Following system labels
	// exist for each Annotation: *
	// "aiplatform.googleapis.com/annotation_set_name": optional, name of the UI's
	// annotation set this Annotation belongs to. If not set, the Annotation is not
	// visible in the UI. * "aiplatform.googleapis.com/payload_schema": output
	// only, its value is the payload_schema's title.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. Resource name of the Annotation.
	Name string `json:"name,omitempty"`
	// Payload: Required. The schema of the payload can be found in payload_schema.
	Payload interface{} `json:"payload,omitempty"`
	// PayloadSchemaUri: Required. Google Cloud Storage URI points to a YAML file
	// describing payload. The schema is defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// The schema files that can be used here are found in
	// gs://google-cloud-aiplatform/schema/dataset/annotation/, note that the
	// chosen schema must be consistent with the parent Dataset's metadata.
	PayloadSchemaUri string `json:"payloadSchemaUri,omitempty"`
	// UpdateTime: Output only. Timestamp when this Annotation was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Annotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Annotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AnnotationSpec: Identifies a concept with which
// DataItems may be annotated with.
type GoogleCloudAiplatformV1beta1AnnotationSpec struct {
	// CreateTime: Output only. Timestamp when this AnnotationSpec was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The user-defined name of the AnnotationSpec. The name
	// can be up to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Name: Output only. Resource name of the AnnotationSpec.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Timestamp when AnnotationSpec was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AnnotationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AnnotationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ApiAuth: The generic reusable api auth config.
// Deprecated. Please use AuthConfig
// (google/cloud/aiplatform/master/auth.proto) instead.
type GoogleCloudAiplatformV1beta1ApiAuth struct {
	// ApiKeyConfig: The API secret.
	ApiKeyConfig *GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig `json:"apiKeyConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ApiAuth) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ApiAuth
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig: The API secret.
type GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig struct {
	// ApiKeySecretVersion: Required. The SecretManager secret version resource
	// name storing API key. e.g.
	// projects/{project}/secrets/{secret}/versions/{version}
	ApiKeySecretVersion string `json:"apiKeySecretVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeySecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeySecretVersion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AppendEventResponse: Response message for
// SessionService.AppendEvent.
type GoogleCloudAiplatformV1beta1AppendEventResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudAiplatformV1beta1Artifact: Instance of a general artifact.
type GoogleCloudAiplatformV1beta1Artifact struct {
	// CreateTime: Output only. Timestamp when this Artifact was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of the Artifact
	Description string `json:"description,omitempty"`
	// DisplayName: User provided display name of the Artifact. May be up to 128
	// Unicode characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: An eTag used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Artifacts.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. No more than
	// 64 user labels can be associated with one Artifact (System labels are
	// excluded).
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: Properties of the Artifact. Top level metadata keys' heading and
	// trailing spaces will be trimmed. The size of this field should not exceed
	// 200KB.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Output only. The resource name of the Artifact.
	Name string `json:"name,omitempty"`
	// SchemaTitle: The title of the schema describing the metadata. Schema title
	// and version is expected to be registered in earlier Create Schema calls. And
	// both are used together as unique identifiers to identify schemas within the
	// local metadata store.
	SchemaTitle string `json:"schemaTitle,omitempty"`
	// SchemaVersion: The version of the schema in schema_name to use. Schema title
	// and version is expected to be registered in earlier Create Schema calls. And
	// both are used together as unique identifiers to identify schemas within the
	// local metadata store.
	SchemaVersion string `json:"schemaVersion,omitempty"`
	// State: The state of this Artifact. This is a property of the Artifact, and
	// does not imply or capture any ongoing process. This property is managed by
	// clients (such as Vertex AI Pipelines), and the system does not prescribe or
	// check the validity of state transitions.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state for the Artifact.
	//   "PENDING" - A state used by systems like Vertex AI Pipelines to indicate
	// that the underlying data item represented by this Artifact is being created.
	//   "LIVE" - A state indicating that the Artifact should exist, unless
	// something external to the system deletes it.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp when this Artifact was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Uri: The uniform resource identifier of the artifact file. May be empty if
	// there is no actual artifact file.
	Uri string `json:"uri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Artifact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Artifact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ArtifactTypeSchema: The definition of a artifact
// type in MLMD.
type GoogleCloudAiplatformV1beta1ArtifactTypeSchema struct {
	// InstanceSchema: Contains a raw YAML string, describing the format of the
	// properties of the type.
	InstanceSchema string `json:"instanceSchema,omitempty"`
	// SchemaTitle: The name of the type. The format of the title must be: `.`.
	// Examples: - `aiplatform.Model` - `acme.CustomModel` When this field is set,
	// the type must be pre-registered in the MLMD store.
	SchemaTitle string `json:"schemaTitle,omitempty"`
	// SchemaUri: Points to a YAML file stored on Cloud Storage describing the
	// format. Deprecated. Use PipelineArtifactTypeSchema.schema_title or
	// PipelineArtifactTypeSchema.instance_schema instead.
	SchemaUri string `json:"schemaUri,omitempty"`
	// SchemaVersion: The schema version of the artifact. If the value is not set,
	// it defaults to the latest version in the system.
	SchemaVersion string `json:"schemaVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstanceSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstanceSchema") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ArtifactTypeSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ArtifactTypeSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AssembleDataRequest: Request message for
// DatasetService.AssembleData. Used only for MULTIMODAL datasets.
type GoogleCloudAiplatformV1beta1AssembleDataRequest struct {
	// GeminiTemplateConfig: Optional. Config for assembling templates with a
	// Gemini API structure.
	GeminiTemplateConfig *GoogleCloudAiplatformV1beta1GeminiTemplateConfig `json:"geminiTemplateConfig,omitempty"`
	// RequestColumnName: Optional. The column name in the underlying table that
	// contains already fully assembled requests. If this field is set, the
	// original request will be copied to the output table.
	RequestColumnName string `json:"requestColumnName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeminiTemplateConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeminiTemplateConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AssembleDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AssembleDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AssessDataRequest: Request message for
// DatasetService.AssessData. Used only for MULTIMODAL datasets.
type GoogleCloudAiplatformV1beta1AssessDataRequest struct {
	// BatchPredictionResourceUsageAssessmentConfig: Optional. Configuration for
	// the batch prediction resource usage assessment.
	BatchPredictionResourceUsageAssessmentConfig *GoogleCloudAiplatformV1beta1AssessDataRequestBatchPredictionResourceUsageAssessmentConfig `json:"batchPredictionResourceUsageAssessmentConfig,omitempty"`
	// BatchPredictionValidationAssessmentConfig: Optional. Configuration for the
	// batch prediction validation assessment.
	BatchPredictionValidationAssessmentConfig *GoogleCloudAiplatformV1beta1AssessDataRequestBatchPredictionValidationAssessmentConfig `json:"batchPredictionValidationAssessmentConfig,omitempty"`
	// GeminiTemplateConfig: Optional. Config for assembling templates with a
	// Gemini API structure to assess assembled data.
	GeminiTemplateConfig *GoogleCloudAiplatformV1beta1GeminiTemplateConfig `json:"geminiTemplateConfig,omitempty"`
	// RequestColumnName: Optional. The column name in the underlying table that
	// contains already fully assembled requests.
	RequestColumnName string `json:"requestColumnName,omitempty"`
	// TuningResourceUsageAssessmentConfig: Optional. Configuration for the tuning
	// resource usage assessment.
	TuningResourceUsageAssessmentConfig *GoogleCloudAiplatformV1beta1AssessDataRequestTuningResourceUsageAssessmentConfig `json:"tuningResourceUsageAssessmentConfig,omitempty"`
	// TuningValidationAssessmentConfig: Optional. Configuration for the tuning
	// validation assessment.
	TuningValidationAssessmentConfig *GoogleCloudAiplatformV1beta1AssessDataRequestTuningValidationAssessmentConfig `json:"tuningValidationAssessmentConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "BatchPredictionResourceUsageAssessmentConfig") to unconditionally include
	// in API requests. By default, fields with empty or default values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "BatchPredictionResourceUsageAssessmentConfig") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AssessDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AssessDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AssessDataRequestBatchPredictionResourceUsageAsse
// ssmentConfig: Configuration for the batch prediction resource usage
// assessment.
type GoogleCloudAiplatformV1beta1AssessDataRequestBatchPredictionResourceUsageAssessmentConfig struct {
	// ModelName: Required. The name of the model used for batch prediction.
	ModelName string `json:"modelName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AssessDataRequestBatchPredictionResourceUsageAssessmentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AssessDataRequestBatchPredictionResourceUsageAssessmentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AssessDataRequestBatchPredictionValidationAssessm
// entConfig: Configuration for the batch prediction validation assessment.
type GoogleCloudAiplatformV1beta1AssessDataRequestBatchPredictionValidationAssessmentConfig struct {
	// ModelName: Required. The name of the model used for batch prediction.
	ModelName string `json:"modelName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AssessDataRequestBatchPredictionValidationAssessmentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AssessDataRequestBatchPredictionValidationAssessmentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AssessDataRequestTuningResourceUsageAssessmentCon
// fig: Configuration for the tuning resource usage assessment.
type GoogleCloudAiplatformV1beta1AssessDataRequestTuningResourceUsageAssessmentConfig struct {
	// ModelName: Required. The name of the model used for tuning.
	ModelName string `json:"modelName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AssessDataRequestTuningResourceUsageAssessmentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AssessDataRequestTuningResourceUsageAssessmentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AssessDataRequestTuningValidationAssessmentConfig
// : Configuration for the tuning validation assessment.
type GoogleCloudAiplatformV1beta1AssessDataRequestTuningValidationAssessmentConfig struct {
	// DatasetUsage: Required. The dataset usage (e.g. training/validation).
	//
	// Possible values:
	//   "DATASET_USAGE_UNSPECIFIED" - Default value. Should not be used.
	//   "SFT_TRAINING" - Supervised fine-tuning training dataset.
	//   "SFT_VALIDATION" - Supervised fine-tuning validation dataset.
	DatasetUsage string `json:"datasetUsage,omitempty"`
	// ModelName: Required. The name of the model used for tuning.
	ModelName string `json:"modelName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetUsage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetUsage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AssessDataRequestTuningValidationAssessmentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AssessDataRequestTuningValidationAssessmentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AssignNotebookRuntimeOperationMetadata: Metadata
// information for NotebookService.AssignNotebookRuntime.
type GoogleCloudAiplatformV1beta1AssignNotebookRuntimeOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ProgressMessage: A human-readable message that shows the intermediate
	// progress details of NotebookRuntime.
	ProgressMessage string `json:"progressMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AssignNotebookRuntimeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AssignNotebookRuntimeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AssignNotebookRuntimeRequest: Request message
// for NotebookService.AssignNotebookRuntime.
type GoogleCloudAiplatformV1beta1AssignNotebookRuntimeRequest struct {
	// NotebookRuntime: Required. Provide runtime specific information (e.g.
	// runtime owner, notebook id) used for NotebookRuntime assignment.
	NotebookRuntime *GoogleCloudAiplatformV1beta1NotebookRuntime `json:"notebookRuntime,omitempty"`
	// NotebookRuntimeId: Optional. User specified ID for the notebook runtime.
	NotebookRuntimeId string `json:"notebookRuntimeId,omitempty"`
	// NotebookRuntimeTemplate: Required. The resource name of the
	// NotebookRuntimeTemplate based on which a NotebookRuntime will be assigned
	// (reuse or create a new one).
	NotebookRuntimeTemplate string `json:"notebookRuntimeTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NotebookRuntime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NotebookRuntime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AssignNotebookRuntimeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AssignNotebookRuntimeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Attribution: Attribution that explains a
// particular prediction output.
type GoogleCloudAiplatformV1beta1Attribution struct {
	// ApproximationError: Output only. Error of feature_attributions caused by
	// approximation used in the explanation method. Lower value means more precise
	// attributions. * For Sampled Shapley attribution, increasing path_count might
	// reduce the error. * For Integrated Gradients attribution, increasing
	// step_count might reduce the error. * For XRAI attribution, increasing
	// step_count might reduce the error. See this introduction
	// (/vertex-ai/docs/explainable-ai/overview) for more information.
	ApproximationError float64 `json:"approximationError,omitempty"`
	// BaselineOutputValue: Output only. Model predicted output if the input
	// instance is constructed from the baselines of all the features defined in
	// ExplanationMetadata.inputs. The field name of the output is determined by
	// the key in ExplanationMetadata.outputs. If the Model's predicted output has
	// multiple dimensions (rank > 1), this is the value in the output located by
	// output_index. If there are multiple baselines, their output values are
	// averaged.
	BaselineOutputValue float64 `json:"baselineOutputValue,omitempty"`
	// FeatureAttributions: Output only. Attributions of each explained feature.
	// Features are extracted from the prediction instances according to
	// explanation metadata for inputs. The value is a struct, whose keys are the
	// name of the feature. The values are how much the feature in the instance
	// contributed to the predicted result. The format of the value is determined
	// by the feature's input format: * If the feature is a scalar value, the
	// attribution value is a floating number. * If the feature is an array of
	// scalar values, the attribution value is an array. * If the feature is a
	// struct, the attribution value is a struct. The keys in the attribution value
	// struct are the same as the keys in the feature struct. The formats of the
	// values in the attribution struct are determined by the formats of the values
	// in the feature struct. The
	// ExplanationMetadata.feature_attributions_schema_uri field, pointed to by the
	// ExplanationSpec field of the Endpoint.deployed_models object, points to the
	// schema file that describes the features and their attribution values (if it
	// is populated).
	FeatureAttributions interface{} `json:"featureAttributions,omitempty"`
	// InstanceOutputValue: Output only. Model predicted output on the
	// corresponding explanation instance. The field name of the output is
	// determined by the key in ExplanationMetadata.outputs. If the Model predicted
	// output has multiple dimensions, this is the value in the output located by
	// output_index.
	InstanceOutputValue float64 `json:"instanceOutputValue,omitempty"`
	// OutputDisplayName: Output only. The display name of the output identified by
	// output_index. For example, the predicted class name by a
	// multi-classification Model. This field is only populated iff the Model
	// predicts display names as a separate field along with the explained output.
	// The predicted display name must has the same shape of the explained output,
	// and can be located using output_index.
	OutputDisplayName string `json:"outputDisplayName,omitempty"`
	// OutputIndex: Output only. The index that locates the explained prediction
	// output. If the prediction output is a scalar value, output_index is not
	// populated. If the prediction output has multiple dimensions, the length of
	// the output_index list is the same as the number of dimensions of the output.
	// The i-th element in output_index is the element index of the i-th dimension
	// of the output vector. Indices start from 0.
	OutputIndex []int64 `json:"outputIndex,omitempty"`
	// OutputName: Output only. Name of the explain output. Specified as the key in
	// ExplanationMetadata.outputs.
	OutputName string `json:"outputName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApproximationError") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApproximationError") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Attribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Attribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1Attribution) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1Attribution
	var s1 struct {
		ApproximationError  gensupport.JSONFloat64 `json:"approximationError"`
		BaselineOutputValue gensupport.JSONFloat64 `json:"baselineOutputValue"`
		InstanceOutputValue gensupport.JSONFloat64 `json:"instanceOutputValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ApproximationError = float64(s1.ApproximationError)
	s.BaselineOutputValue = float64(s1.BaselineOutputValue)
	s.InstanceOutputValue = float64(s1.InstanceOutputValue)
	return nil
}

// GoogleCloudAiplatformV1beta1AugmentPromptRequest: Request message for
// AugmentPrompt.
type GoogleCloudAiplatformV1beta1AugmentPromptRequest struct {
	// Contents: Optional. Input content to augment, only text format is supported
	// for now.
	Contents []*GoogleCloudAiplatformV1beta1Content `json:"contents,omitempty"`
	// Model: Optional. Metadata of the backend deployed model.
	Model *GoogleCloudAiplatformV1beta1AugmentPromptRequestModel `json:"model,omitempty"`
	// VertexRagStore: Optional. Retrieves contexts from the Vertex RagStore.
	VertexRagStore *GoogleCloudAiplatformV1beta1VertexRagStore `json:"vertexRagStore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AugmentPromptRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AugmentPromptRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AugmentPromptRequestModel: Metadata of the
// backend deployed model.
type GoogleCloudAiplatformV1beta1AugmentPromptRequestModel struct {
	// Model: Optional. The model that the user will send the augmented prompt for
	// content generation.
	Model string `json:"model,omitempty"`
	// ModelVersion: Optional. The model version of the backend deployed model.
	ModelVersion string `json:"modelVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AugmentPromptRequestModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AugmentPromptRequestModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AugmentPromptResponse: Response message for
// AugmentPrompt.
type GoogleCloudAiplatformV1beta1AugmentPromptResponse struct {
	// AugmentedPrompt: Augmented prompt, only text format is supported for now.
	AugmentedPrompt []*GoogleCloudAiplatformV1beta1Content `json:"augmentedPrompt,omitempty"`
	// Facts: Retrieved facts from RAG data sources.
	Facts []*GoogleCloudAiplatformV1beta1Fact `json:"facts,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AugmentedPrompt") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AugmentedPrompt") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AugmentPromptResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AugmentPromptResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfig: Auth configuration to run the
// extension.
type GoogleCloudAiplatformV1beta1AuthConfig struct {
	// ApiKeyConfig: Config for API key auth.
	ApiKeyConfig *GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig `json:"apiKeyConfig,omitempty"`
	// AuthType: Type of auth scheme.
	//
	// Possible values:
	//   "AUTH_TYPE_UNSPECIFIED"
	//   "NO_AUTH" - No Auth.
	//   "API_KEY_AUTH" - API Key Auth.
	//   "HTTP_BASIC_AUTH" - HTTP Basic Auth.
	//   "GOOGLE_SERVICE_ACCOUNT_AUTH" - Google Service Account Auth.
	//   "OAUTH" - OAuth auth.
	//   "OIDC_AUTH" - OpenID Connect (OIDC) Auth.
	AuthType string `json:"authType,omitempty"`
	// GoogleServiceAccountConfig: Config for Google Service Account auth.
	GoogleServiceAccountConfig *GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig `json:"googleServiceAccountConfig,omitempty"`
	// HttpBasicAuthConfig: Config for HTTP Basic auth.
	HttpBasicAuthConfig *GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig `json:"httpBasicAuthConfig,omitempty"`
	// OauthConfig: Config for user oauth.
	OauthConfig *GoogleCloudAiplatformV1beta1AuthConfigOauthConfig `json:"oauthConfig,omitempty"`
	// OidcConfig: Config for user OIDC auth.
	OidcConfig *GoogleCloudAiplatformV1beta1AuthConfigOidcConfig `json:"oidcConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig: Config for
// authentication with API key.
type GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig struct {
	// ApiKeySecret: Optional. The name of the SecretManager secret version
	// resource storing the API key. Format:
	// `projects/{project}/secrets/{secrete}/versions/{version}` - If both
	// `api_key_secret` and `api_key_string` are specified, this field takes
	// precedence over `api_key_string`. - If specified, the
	// `secretmanager.versions.access` permission should be granted to Vertex AI
	// Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified resource.
	ApiKeySecret string `json:"apiKeySecret,omitempty"`
	// ApiKeyString: Optional. The API key to be used in the request directly.
	ApiKeyString string `json:"apiKeyString,omitempty"`
	// HttpElementLocation: Optional. The location of the API key.
	//
	// Possible values:
	//   "HTTP_IN_UNSPECIFIED"
	//   "HTTP_IN_QUERY" - Element is in the HTTP request query.
	//   "HTTP_IN_HEADER" - Element is in the HTTP request header.
	//   "HTTP_IN_PATH" - Element is in the HTTP request path.
	//   "HTTP_IN_BODY" - Element is in the HTTP request body.
	//   "HTTP_IN_COOKIE" - Element is in the HTTP request cookie.
	HttpElementLocation string `json:"httpElementLocation,omitempty"`
	// Name: Optional. The parameter name of the API key. E.g. If the API request
	// is "https://example.com/act?api_key=", "api_key" would be the parameter
	// name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeySecret") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeySecret") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfigApiKeyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig: Config for
// Google Service Account Authentication.
type GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig struct {
	// ServiceAccount: Optional. The service account that the extension execution
	// service runs as. - If the service account is specified, the
	// `iam.serviceAccounts.getAccessToken` permission should be granted to Vertex
	// AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified service account. - If not specified, the Vertex AI
	// Extension Service Agent will be used to execute the Extension.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAccount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAccount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfigGoogleServiceAccountConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig: Config for HTTP
// Basic Authentication.
type GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig struct {
	// CredentialSecret: Required. The name of the SecretManager secret version
	// resource storing the base64 encoded credentials. Format:
	// `projects/{project}/secrets/{secrete}/versions/{version}` - If specified,
	// the `secretmanager.versions.access` permission should be granted to Vertex
	// AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the specified resource.
	CredentialSecret string `json:"credentialSecret,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CredentialSecret") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CredentialSecret") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfigHttpBasicAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfigOauthConfig: Config for user oauth.
type GoogleCloudAiplatformV1beta1AuthConfigOauthConfig struct {
	// AccessToken: Access token for extension endpoint. Only used to propagate
	// token from [[ExecuteExtensionRequest.runtime_auth_config]] at request time.
	AccessToken string `json:"accessToken,omitempty"`
	// ServiceAccount: The service account used to generate access tokens for
	// executing the Extension. - If the service account is specified, the
	// `iam.serviceAccounts.getAccessToken` permission should be granted to Vertex
	// AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// on the provided service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfigOauthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfigOauthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AuthConfigOidcConfig: Config for user OIDC auth.
type GoogleCloudAiplatformV1beta1AuthConfigOidcConfig struct {
	// IdToken: OpenID Connect formatted ID token for extension endpoint. Only used
	// to propagate token from [[ExecuteExtensionRequest.runtime_auth_config]] at
	// request time.
	IdToken string `json:"idToken,omitempty"`
	// ServiceAccount: The service account used to generate an OpenID Connect
	// (OIDC)-compatible JWT token signed by the Google OIDC Provider
	// (accounts.google.com) for extension endpoint
	// (https://cloud.google.com/iam/docs/create-short-lived-credentials-direct#sa-credentials-oidc).
	// - The audience for the token will be set to the URL in the server url
	// defined in the OpenApi spec. - If the service account is provided, the
	// service account should grant `iam.serviceAccounts.getOpenIdToken` permission
	// to Vertex AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdToken") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AuthConfigOidcConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AuthConfigOidcConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AutomaticResources: A description of resources
// that to large degree are decided by Vertex AI, and require only a modest
// additional configuration. Each Model supporting these resources documents
// its specific guidelines.
type GoogleCloudAiplatformV1beta1AutomaticResources struct {
	// MaxReplicaCount: Immutable. The maximum number of replicas that may be
	// deployed on when the traffic against it increases. If the requested value is
	// too large, the deployment will error, but if deployment succeeds then the
	// ability to scale to that many replicas is guaranteed (barring service
	// outages). If traffic increases beyond what its replicas at maximum may
	// handle, a portion of the traffic will be dropped. If this value is not
	// provided, a no upper bound for scaling under heavy traffic will be assume,
	// though Vertex AI may be unable to scale beyond certain replica number.
	MaxReplicaCount int64 `json:"maxReplicaCount,omitempty"`
	// MinReplicaCount: Immutable. The minimum number of replicas that will be
	// always deployed on. If traffic against it increases, it may dynamically be
	// deployed onto more replicas up to max_replica_count, and as traffic
	// decreases, some of these extra replicas may be freed. If the requested value
	// is too large, the deployment will error.
	MinReplicaCount int64 `json:"minReplicaCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxReplicaCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxReplicaCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AutomaticResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AutomaticResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AutoraterConfig: The configs for autorater. This
// is applicable to both EvaluateInstances and EvaluateDataset.
type GoogleCloudAiplatformV1beta1AutoraterConfig struct {
	// AutoraterModel: Optional. The fully qualified name of the publisher model or
	// tuned autorater endpoint to use. Publisher model format:
	// `projects/{project}/locations/{location}/publishers/*/models/*` Tuned model
	// endpoint format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	AutoraterModel string `json:"autoraterModel,omitempty"`
	// FlipEnabled: Optional. Whether to flip the candidate and baseline responses.
	// This is only applicable to the pairwise metric. If enabled, also provide
	// PairwiseMetricSpec.candidate_response_field_name and
	// PairwiseMetricSpec.baseline_response_field_name. When rendering
	// PairwiseMetricSpec.metric_prompt_template, the candidate and baseline fields
	// will be flipped for half of the samples to reduce bias.
	FlipEnabled bool `json:"flipEnabled,omitempty"`
	// SamplingCount: Optional. Number of samples for each instance in the dataset.
	// If not specified, the default is 4. Minimum value is 1, maximum value is 32.
	SamplingCount int64 `json:"samplingCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoraterModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoraterModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AutoraterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AutoraterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AutoscalingMetricSpec: The metric specification
// that defines the target resource utilization (CPU utilization, accelerator's
// duty cycle, and so on) for calculating the desired replica count.
type GoogleCloudAiplatformV1beta1AutoscalingMetricSpec struct {
	// MetricName: Required. The resource metric name. Supported metrics: * For
	// Online Prediction: *
	// `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` *
	// `aiplatform.googleapis.com/prediction/online/cpu/utilization`
	MetricName string `json:"metricName,omitempty"`
	// Target: The target resource utilization in percentage (1% - 100%) for the
	// given metric; once the real usage deviates from the target by a certain
	// percentage, the machine replicas change. The default value is 60
	// (representing 60%) if not provided.
	Target int64 `json:"target,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetricName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetricName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AutoscalingMetricSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AutoscalingMetricSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1AvroSource: The storage details for Avro input
// content.
type GoogleCloudAiplatformV1beta1AvroSource struct {
	// GcsSource: Required. Google Cloud Storage location.
	GcsSource *GoogleCloudAiplatformV1beta1GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1AvroSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1AvroSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsRequest: Request message
// for PipelineService.BatchCancelPipelineJobs.
type GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsRequest struct {
	// Names: Required. The names of the PipelineJobs to cancel. A maximum of 32
	// PipelineJobs can be cancelled in a batch. Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsResponse: Response
// message for PipelineService.BatchCancelPipelineJobs.
type GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsResponse struct {
	// PipelineJobs: PipelineJobs cancelled.
	PipelineJobs []*GoogleCloudAiplatformV1beta1PipelineJob `json:"pipelineJobs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PipelineJobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PipelineJobs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchCancelPipelineJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchCreateFeaturesOperationMetadata: Details of
// operations that perform batch create Features.
type GoogleCloudAiplatformV1beta1BatchCreateFeaturesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Feature.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchCreateFeaturesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchCreateFeaturesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchCreateFeaturesRequest: Request message for
// FeaturestoreService.BatchCreateFeatures. Request message for
// FeatureRegistryService.BatchCreateFeatures.
type GoogleCloudAiplatformV1beta1BatchCreateFeaturesRequest struct {
	// Requests: Required. The request message specifying the Features to create.
	// All Features must be created under the same parent EntityType /
	// FeatureGroup. The `parent` field in each child request message can be
	// omitted. If `parent` is set in a child request, then the value must match
	// the `parent` value in this request message.
	Requests []*GoogleCloudAiplatformV1beta1CreateFeatureRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchCreateFeaturesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchCreateFeaturesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchCreateFeaturesResponse: Response message
// for FeaturestoreService.BatchCreateFeatures.
type GoogleCloudAiplatformV1beta1BatchCreateFeaturesResponse struct {
	// Features: The Features created.
	Features []*GoogleCloudAiplatformV1beta1Feature `json:"features,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Features") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Features") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchCreateFeaturesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchCreateFeaturesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsRequest: Request
// message for TensorboardService.BatchCreateTensorboardRuns.
type GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsRequest struct {
	// Requests: Required. The request message specifying the TensorboardRuns to
	// create. A maximum of 1000 TensorboardRuns can be created in a batch.
	Requests []*GoogleCloudAiplatformV1beta1CreateTensorboardRunRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsResponse: Response
// message for TensorboardService.BatchCreateTensorboardRuns.
type GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsResponse struct {
	// TensorboardRuns: The created TensorboardRuns.
	TensorboardRuns []*GoogleCloudAiplatformV1beta1TensorboardRun `json:"tensorboardRuns,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TensorboardRuns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TensorboardRuns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchCreateTensorboardRunsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesRequest: Request
// message for TensorboardService.BatchCreateTensorboardTimeSeries.
type GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesRequest struct {
	// Requests: Required. The request message specifying the TensorboardTimeSeries
	// to create. A maximum of 1000 TensorboardTimeSeries can be created in a
	// batch.
	Requests []*GoogleCloudAiplatformV1beta1CreateTensorboardTimeSeriesRequest `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Requests") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesResponse:
// Response message for TensorboardService.BatchCreateTensorboardTimeSeries.
type GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesResponse struct {
	// TensorboardTimeSeries: The created TensorboardTimeSeries.
	TensorboardTimeSeries []*GoogleCloudAiplatformV1beta1TensorboardTimeSeries `json:"tensorboardTimeSeries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TensorboardTimeSeries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TensorboardTimeSeries") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchCreateTensorboardTimeSeriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchDedicatedResources: A description of
// resources that are used for performing batch operations, are dedicated to a
// Model, and need manual configuration.
type GoogleCloudAiplatformV1beta1BatchDedicatedResources struct {
	// MachineSpec: Required. Immutable. The specification of a single machine.
	MachineSpec *GoogleCloudAiplatformV1beta1MachineSpec `json:"machineSpec,omitempty"`
	// MaxReplicaCount: Immutable. The maximum number of machine replicas the batch
	// operation may be scaled to. The default value is 10.
	MaxReplicaCount int64 `json:"maxReplicaCount,omitempty"`
	// StartingReplicaCount: Immutable. The number of machine replicas used at the
	// start of the batch operation. If not set, Vertex AI decides starting number,
	// not greater than max_replica_count
	StartingReplicaCount int64 `json:"startingReplicaCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MachineSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MachineSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchDedicatedResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchDedicatedResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsRequest: Request message
// for PipelineService.BatchDeletePipelineJobs.
type GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsRequest struct {
	// Names: Required. The names of the PipelineJobs to delete. A maximum of 32
	// PipelineJobs can be deleted in a batch. Format:
	// `projects/{project}/locations/{location}/pipelineJobs/{pipelineJob}`
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsResponse: Response
// message for PipelineService.BatchDeletePipelineJobs.
type GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsResponse struct {
	// PipelineJobs: PipelineJobs deleted.
	PipelineJobs []*GoogleCloudAiplatformV1beta1PipelineJob `json:"pipelineJobs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PipelineJobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PipelineJobs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchDeletePipelineJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsRequest: Request
// message for ModelService.BatchImportEvaluatedAnnotations
type GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsRequest struct {
	// EvaluatedAnnotations: Required. Evaluated annotations resource to be
	// imported.
	EvaluatedAnnotations []*GoogleCloudAiplatformV1beta1EvaluatedAnnotation `json:"evaluatedAnnotations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluatedAnnotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluatedAnnotations") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsResponse:
// Response message for ModelService.BatchImportEvaluatedAnnotations
type GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsResponse struct {
	// ImportedEvaluatedAnnotationsCount: Output only. Number of
	// EvaluatedAnnotations imported.
	ImportedEvaluatedAnnotationsCount int64 `json:"importedEvaluatedAnnotationsCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "ImportedEvaluatedAnnotationsCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "ImportedEvaluatedAnnotationsCount") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchImportEvaluatedAnnotationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchImportModelEvaluationSlicesRequest: Request
// message for ModelService.BatchImportModelEvaluationSlices
type GoogleCloudAiplatformV1beta1BatchImportModelEvaluationSlicesRequest struct {
	// ModelEvaluationSlices: Required. Model evaluation slice resource to be
	// imported.
	ModelEvaluationSlices []*GoogleCloudAiplatformV1beta1ModelEvaluationSlice `json:"modelEvaluationSlices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelEvaluationSlices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelEvaluationSlices") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchImportModelEvaluationSlicesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchImportModelEvaluationSlicesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchImportModelEvaluationSlicesResponse:
// Response message for ModelService.BatchImportModelEvaluationSlices
type GoogleCloudAiplatformV1beta1BatchImportModelEvaluationSlicesResponse struct {
	// ImportedModelEvaluationSlices: Output only. List of imported
	// ModelEvaluationSlice.name.
	ImportedModelEvaluationSlices []string `json:"importedModelEvaluationSlices,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ImportedModelEvaluationSlices") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportedModelEvaluationSlices")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchImportModelEvaluationSlicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchImportModelEvaluationSlicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadata: Runtime
// operation information for MigrationService.BatchMigrateResources.
type GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// PartialResults: Partial results that reflect the latest migration operation
	// progress.
	PartialResults []*GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadataPartialResult `json:"partialResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadataPartialResu
// lt: Represents a partial result in batch migration operation for one
// MigrateResourceRequest.
type GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadataPartialResult struct {
	// Dataset: Migrated dataset resource name.
	Dataset string `json:"dataset,omitempty"`
	// Error: The error result of the migration request in case of failure.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Model: Migrated model resource name.
	Model string `json:"model,omitempty"`
	// Request: It's the same as the value in
	// BatchMigrateResourcesRequest.migrate_resource_requests.
	Request *GoogleCloudAiplatformV1beta1MigrateResourceRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadataPartialResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchMigrateResourcesOperationMetadataPartialResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchMigrateResourcesRequest: Request message
// for MigrationService.BatchMigrateResources.
type GoogleCloudAiplatformV1beta1BatchMigrateResourcesRequest struct {
	// MigrateResourceRequests: Required. The request messages specifying the
	// resources to migrate. They must be in the same location as the destination.
	// Up to 50 resources can be migrated in one batch.
	MigrateResourceRequests []*GoogleCloudAiplatformV1beta1MigrateResourceRequest `json:"migrateResourceRequests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MigrateResourceRequests") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrateResourceRequests") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchMigrateResourcesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchMigrateResourcesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchMigrateResourcesResponse: Response message
// for MigrationService.BatchMigrateResources.
type GoogleCloudAiplatformV1beta1BatchMigrateResourcesResponse struct {
	// MigrateResourceResponses: Successfully migrated resources.
	MigrateResourceResponses []*GoogleCloudAiplatformV1beta1MigrateResourceResponse `json:"migrateResourceResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MigrateResourceResponses")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrateResourceResponses") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchMigrateResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchMigrateResourcesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchPredictionJob: A job that uses a Model to
// produce predictions on multiple input instances. If predictions for
// significant portion of the instances fail, the job may finish without
// attempting predictions for all remaining instances.
type GoogleCloudAiplatformV1beta1BatchPredictionJob struct {
	// CompletionStats: Output only. Statistics on completed and failed prediction
	// instances.
	CompletionStats *GoogleCloudAiplatformV1beta1CompletionStats `json:"completionStats,omitempty"`
	// CreateTime: Output only. Time when the BatchPredictionJob was created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedResources: The config of resources used by the Model during the
	// batch prediction. If the Model supports DEDICATED_RESOURCES this config may
	// be provided (and the job will use these resources), if the Model doesn't
	// support AUTOMATIC_RESOURCES, this config must be provided.
	DedicatedResources *GoogleCloudAiplatformV1beta1BatchDedicatedResources `json:"dedicatedResources,omitempty"`
	// DisableContainerLogging: For custom-trained Models and AutoML Tabular
	// Models, the container of the DeployedModel instances will send `stderr` and
	// `stdout` streams to Cloud Logging by default. Please note that the logs
	// incur cost, which are subject to Cloud Logging pricing
	// (https://cloud.google.com/logging/pricing). User can disable container
	// logging by setting this flag to true.
	DisableContainerLogging bool `json:"disableContainerLogging,omitempty"`
	// DisplayName: Required. The user-defined name of this BatchPredictionJob.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Customer-managed encryption key options for a
	// BatchPredictionJob. If this is set, then all resources created by the
	// BatchPredictionJob will be encrypted with the provided encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// EndTime: Output only. Time when the BatchPredictionJob entered any of the
	// following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
	// `JOB_STATE_CANCELLED`.
	EndTime string `json:"endTime,omitempty"`
	// Error: Output only. Only populated when the job's state is JOB_STATE_FAILED
	// or JOB_STATE_CANCELLED.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// ExplanationSpec: Explanation configuration for this BatchPredictionJob. Can
	// be specified only if generate_explanation is set to `true`. This value
	// overrides the value of Model.explanation_spec. All fields of
	// explanation_spec are optional in the request. If a field of the
	// explanation_spec object is not populated, the corresponding field of the
	// Model.explanation_spec object is inherited.
	ExplanationSpec *GoogleCloudAiplatformV1beta1ExplanationSpec `json:"explanationSpec,omitempty"`
	// GenerateExplanation: Generate explanation with the batch prediction results.
	// When set to `true`, the batch prediction output changes based on the
	// `predictions_format` field of the BatchPredictionJob.output_config object: *
	// `bigquery`: output includes a column named `explanation`. The value is a
	// struct that conforms to the Explanation object. * `jsonl`: The JSON objects
	// on each line include an additional entry keyed `explanation`. The value of
	// the entry is a JSON object that conforms to the Explanation object. * `csv`:
	// Generating explanations for CSV format is not supported. If this field is
	// set to true, either the Model.explanation_spec or explanation_spec must be
	// populated.
	GenerateExplanation bool `json:"generateExplanation,omitempty"`
	// InputConfig: Required. Input configuration of the instances on which
	// predictions are performed. The schema of any single instance may be
	// specified via the Model's PredictSchemata's instance_schema_uri.
	InputConfig *GoogleCloudAiplatformV1beta1BatchPredictionJobInputConfig `json:"inputConfig,omitempty"`
	// InstanceConfig: Configuration for how to convert batch prediction input
	// instances to the prediction instances that are sent to the Model.
	InstanceConfig *GoogleCloudAiplatformV1beta1BatchPredictionJobInstanceConfig `json:"instanceConfig,omitempty"`
	// Labels: The labels with user-defined metadata to organize
	// BatchPredictionJobs. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// ManualBatchTuningParameters: Immutable. Parameters configuring the batch
	// behavior. Currently only applicable when dedicated_resources are used (in
	// other cases Vertex AI does the tuning itself).
	ManualBatchTuningParameters *GoogleCloudAiplatformV1beta1ManualBatchTuningParameters `json:"manualBatchTuningParameters,omitempty"`
	// Model: The name of the Model resource that produces the predictions via this
	// job, must share the same ancestor Location. Starting this job has no impact
	// on any existing deployments of the Model and their resources. Exactly one of
	// model and unmanaged_container_model must be set. The model resource name may
	// contain version id or version alias to specify the version. Example:
	// `projects/{project}/locations/{location}/models/{model}@2` or
	// `projects/{project}/locations/{location}/models/{model}@golden` if no
	// version is specified, the default version will be deployed. The model
	// resource could also be a publisher model. Example:
	// `publishers/{publisher}/models/{model}` or
	// `projects/{project}/locations/{location}/publishers/{publisher}/models/{model
	// }`
	Model string `json:"model,omitempty"`
	// ModelMonitoringConfig: Model monitoring config will be used for analysis
	// model behaviors, based on the input and output to the batch prediction job,
	// as well as the provided training dataset.
	ModelMonitoringConfig *GoogleCloudAiplatformV1beta1ModelMonitoringConfig `json:"modelMonitoringConfig,omitempty"`
	// ModelMonitoringStatsAnomalies: Get batch prediction job monitoring
	// statistics.
	ModelMonitoringStatsAnomalies []*GoogleCloudAiplatformV1beta1ModelMonitoringStatsAnomalies `json:"modelMonitoringStatsAnomalies,omitempty"`
	// ModelMonitoringStatus: Output only. The running status of the model
	// monitoring pipeline.
	ModelMonitoringStatus *GoogleRpcStatus `json:"modelMonitoringStatus,omitempty"`
	// ModelParameters: The parameters that govern the predictions. The schema of
	// the parameters may be specified via the Model's PredictSchemata's
	// parameters_schema_uri.
	ModelParameters interface{} `json:"modelParameters,omitempty"`
	// ModelVersionId: Output only. The version ID of the Model that produces the
	// predictions via this job.
	ModelVersionId string `json:"modelVersionId,omitempty"`
	// Name: Output only. Resource name of the BatchPredictionJob.
	Name string `json:"name,omitempty"`
	// OutputConfig: Required. The Configuration specifying where output
	// predictions should be written. The schema of any single prediction may be
	// specified as a concatenation of Model's PredictSchemata's
	// instance_schema_uri and prediction_schema_uri.
	OutputConfig *GoogleCloudAiplatformV1beta1BatchPredictionJobOutputConfig `json:"outputConfig,omitempty"`
	// OutputInfo: Output only. Information further describing the output of this
	// job.
	OutputInfo *GoogleCloudAiplatformV1beta1BatchPredictionJobOutputInfo `json:"outputInfo,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. For example,
	// single files that can't be read. This field never exceeds 20 entries. Status
	// details fields contain standard Google Cloud error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ResourcesConsumed: Output only. Information about resources that had been
	// consumed by this job. Provided in real time at best effort basis, as well as
	// a final value once the job completes. Note: This field currently may be not
	// populated for batch predictions that use AutoML Models.
	ResourcesConsumed *GoogleCloudAiplatformV1beta1ResourcesConsumed `json:"resourcesConsumed,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// ServiceAccount: The service account that the DeployedModel's container runs
	// as. If not specified, a system generated one will be used, which has minimal
	// permissions and the custom container, if used, may not have enough
	// permission to access other Google Cloud resources. Users deploying the Model
	// must have the `iam.serviceAccounts.actAs` permission on this service
	// account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// StartTime: Output only. Time when the BatchPredictionJob for the first time
	// entered the `JOB_STATE_RUNNING` state.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this state the
	// job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to the
	// `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded, some
	// results may be missing due to errors.
	State string `json:"state,omitempty"`
	// UnmanagedContainerModel: Contains model information necessary to perform
	// batch prediction without requiring uploading to model registry. Exactly one
	// of model and unmanaged_container_model must be set.
	UnmanagedContainerModel *GoogleCloudAiplatformV1beta1UnmanagedContainerModel `json:"unmanagedContainerModel,omitempty"`
	// UpdateTime: Output only. Time when the BatchPredictionJob was most recently
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CompletionStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionStats") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchPredictionJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchPredictionJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchPredictionJobInputConfig: Configures the
// input to BatchPredictionJob. See Model.supported_input_storage_formats for
// Model's supported input formats, and how instances should be expressed via
// any of them.
type GoogleCloudAiplatformV1beta1BatchPredictionJobInputConfig struct {
	// BigquerySource: The BigQuery location of the input table. The schema of the
	// table should be in the format described by the given context OpenAPI Schema,
	// if one is provided. The table may contain additional columns that are not
	// described by the schema, and they will be ignored.
	BigquerySource *GoogleCloudAiplatformV1beta1BigQuerySource `json:"bigquerySource,omitempty"`
	// GcsSource: The Cloud Storage location for the input instances.
	GcsSource *GoogleCloudAiplatformV1beta1GcsSource `json:"gcsSource,omitempty"`
	// InstancesFormat: Required. The format in which instances are given, must be
	// one of the Model's supported_input_storage_formats.
	InstancesFormat string `json:"instancesFormat,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigquerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchPredictionJobInputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchPredictionJobInputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchPredictionJobInstanceConfig: Configuration
// defining how to transform batch prediction input instances to the instances
// that the Model accepts.
type GoogleCloudAiplatformV1beta1BatchPredictionJobInstanceConfig struct {
	// ExcludedFields: Fields that will be excluded in the prediction instance that
	// is sent to the Model. Excluded will be attached to the batch prediction
	// output if key_field is not specified. When excluded_fields is populated,
	// included_fields must be empty. The input must be JSONL with objects at each
	// line, BigQuery or TfRecord.
	ExcludedFields []string `json:"excludedFields,omitempty"`
	// IncludedFields: Fields that will be included in the prediction instance that
	// is sent to the Model. If instance_type is `array`, the order of field names
	// in included_fields also determines the order of the values in the array.
	// When included_fields is populated, excluded_fields must be empty. The input
	// must be JSONL with objects at each line, BigQuery or TfRecord.
	IncludedFields []string `json:"includedFields,omitempty"`
	// InstanceType: The format of the instance that the Model accepts. Vertex AI
	// will convert compatible batch prediction input instance formats to the
	// specified format. Supported values are: * `object`: Each input is converted
	// to JSON object format. * For `bigquery`, each row is converted to an object.
	// * For `jsonl`, each line of the JSONL input must be an object. * Does not
	// apply to `csv`, `file-list`, `tf-record`, or `tf-record-gzip`. * `array`:
	// Each input is converted to JSON array format. * For `bigquery`, each row is
	// converted to an array. The order of columns is determined by the BigQuery
	// column order, unless included_fields is populated. included_fields must be
	// populated for specifying field orders. * For `jsonl`, if each line of the
	// JSONL input is an object, included_fields must be populated for specifying
	// field orders. * Does not apply to `csv`, `file-list`, `tf-record`, or
	// `tf-record-gzip`. If not specified, Vertex AI converts the batch prediction
	// input as follows: * For `bigquery` and `csv`, the behavior is the same as
	// `array`. The order of columns is the same as defined in the file or table,
	// unless included_fields is populated. * For `jsonl`, the prediction instance
	// format is determined by each line of the input. * For
	// `tf-record`/`tf-record-gzip`, each record will be converted to an object in
	// the format of `{"b64": }`, where `` is the Base64-encoded string of the
	// content of the record. * For `file-list`, each file in the list will be
	// converted to an object in the format of `{"b64": }`, where `` is the
	// Base64-encoded string of the content of the file.
	InstanceType string `json:"instanceType,omitempty"`
	// KeyField: The name of the field that is considered as a key. The values
	// identified by the key field is not included in the transformed instances
	// that is sent to the Model. This is similar to specifying this name of the
	// field in excluded_fields. In addition, the batch prediction output will not
	// include the instances. Instead the output will only include the value of the
	// key field, in a field named `key` in the output: * For `jsonl` output
	// format, the output will have a `key` field instead of the `instance` field.
	// * For `csv`/`bigquery` output format, the output will have have a `key`
	// column instead of the instance feature columns. The input must be JSONL with
	// objects at each line, CSV, BigQuery or TfRecord.
	KeyField string `json:"keyField,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedFields") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedFields") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchPredictionJobInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchPredictionJobInstanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchPredictionJobOutputConfig: Configures the
// output of BatchPredictionJob. See Model.supported_output_storage_formats for
// supported output formats, and how predictions are expressed via any of them.
type GoogleCloudAiplatformV1beta1BatchPredictionJobOutputConfig struct {
	// BigqueryDestination: The BigQuery project or dataset location where the
	// output is to be written to. If project is provided, a new dataset is created
	// with name `prediction__` where is made BigQuery-dataset-name compatible (for
	// example, most special characters become underscores), and timestamp is in
	// YYYY_MM_DDThh_mm_ss_sssZ "based on ISO-8601" format. In the dataset two
	// tables will be created, `predictions`, and `errors`. If the Model has both
	// instance and prediction schemata defined then the tables have columns as
	// follows: The `predictions` table contains instances for which the prediction
	// succeeded, it has columns as per a concatenation of the Model's instance and
	// prediction schemata. The `errors` table contains rows for which the
	// prediction has failed, it has instance columns, as per the instance schema,
	// followed by a single "errors" column, which as values has google.rpc.Status
	// represented as a STRUCT, and containing only `code` and `message`.
	BigqueryDestination *GoogleCloudAiplatformV1beta1BigQueryDestination `json:"bigqueryDestination,omitempty"`
	// GcsDestination: The Cloud Storage location of the directory where the output
	// is to be written to. In the given directory a new directory is created. Its
	// name is `prediction--`, where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ
	// ISO-8601 format. Inside of it files `predictions_0001.`,
	// `predictions_0002.`, ..., `predictions_N.` are created where `` depends on
	// chosen predictions_format, and N may equal 0001 and depends on the total
	// number of successfully predicted instances. If the Model has both instance
	// and prediction schemata defined then each such file contains predictions as
	// per the predictions_format. If prediction for any instance failed (partially
	// or completely), then an additional `errors_0001.`, `errors_0002.`,...,
	// `errors_N.` files are created (N depends on total number of failed
	// predictions). These files contain the failed instances, as per their schema,
	// followed by an additional `error` field which as value has google.rpc.Status
	// containing only `code` and `message` fields.
	GcsDestination *GoogleCloudAiplatformV1beta1GcsDestination `json:"gcsDestination,omitempty"`
	// PredictionsFormat: Required. The format in which Vertex AI gives the
	// predictions, must be one of the Model's supported_output_storage_formats.
	PredictionsFormat string `json:"predictionsFormat,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchPredictionJobOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchPredictionJobOutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchPredictionJobOutputInfo: Further describes
// this job's output. Supplements output_config.
type GoogleCloudAiplatformV1beta1BatchPredictionJobOutputInfo struct {
	// BigqueryOutputDataset: Output only. The path of the BigQuery dataset
	// created, in `bq://projectId.bqDatasetId` format, into which the prediction
	// output is written.
	BigqueryOutputDataset string `json:"bigqueryOutputDataset,omitempty"`
	// BigqueryOutputTable: Output only. The name of the BigQuery table created, in
	// `predictions_` format, into which the prediction output is written. Can be
	// used by UI to generate the BigQuery output path, for example.
	BigqueryOutputTable string `json:"bigqueryOutputTable,omitempty"`
	// GcsOutputDirectory: Output only. The full path of the Cloud Storage
	// directory created, into which the prediction output is written.
	GcsOutputDirectory string `json:"gcsOutputDirectory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryOutputDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryOutputDataset") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchPredictionJobOutputInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchPredictionJobOutputInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchReadFeatureValuesOperationMetadata: Details
// of operations that batch reads Feature values.
type GoogleCloudAiplatformV1beta1BatchReadFeatureValuesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore batch read Features
	// values.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchReadFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchReadFeatureValuesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequest: Request message
// for FeaturestoreService.BatchReadFeatureValues.
type GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequest struct {
	// BigqueryReadInstances: Similar to csv_read_instances, but from BigQuery
	// source.
	BigqueryReadInstances *GoogleCloudAiplatformV1beta1BigQuerySource `json:"bigqueryReadInstances,omitempty"`
	// CsvReadInstances: Each read instance consists of exactly one read timestamp
	// and one or more entity IDs identifying entities of the corresponding
	// EntityTypes whose Features are requested. Each output instance contains
	// Feature values of requested entities concatenated together as of the read
	// time. An example read instance may be `foo_entity_id, bar_entity_id,
	// 2020-01-01T10:00:00.123Z`. An example output instance may be `foo_entity_id,
	// bar_entity_id, 2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
	// bar_entity_feature2_value`. Timestamp in each read instance must be
	// millisecond-aligned. `csv_read_instances` are read instances stored in a
	// plain-text CSV file. The header should be: [ENTITY_TYPE_ID1],
	// [ENTITY_TYPE_ID2], ..., timestamp The columns can be in any order. Values in
	// the timestamp column must use the RFC 3339 format, e.g.
	// `2012-07-30T10:43:17.123Z`.
	CsvReadInstances *GoogleCloudAiplatformV1beta1CsvSource `json:"csvReadInstances,omitempty"`
	// Destination: Required. Specifies output location and format.
	Destination *GoogleCloudAiplatformV1beta1FeatureValueDestination `json:"destination,omitempty"`
	// EntityTypeSpecs: Required. Specifies EntityType grouping Features to read
	// values of and settings.
	EntityTypeSpecs []*GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestEntityTypeSpec `json:"entityTypeSpecs,omitempty"`
	// PassThroughFields: When not empty, the specified fields in the
	// *_read_instances source will be joined as-is in the output, in addition to
	// those fields from the Featurestore Entity. For BigQuery source, the type of
	// the pass-through values will be automatically inferred. For CSV source, the
	// pass-through values will be passed as opaque bytes.
	PassThroughFields []*GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestPassThroughField `json:"passThroughFields,omitempty"`
	// StartTime: Optional. Excludes Feature values with feature generation
	// timestamp before this timestamp. If not set, retrieve oldest values kept in
	// Feature Store. Timestamp, if present, must not have higher than millisecond
	// precision.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryReadInstances") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryReadInstances") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestEntityTypeSpec:
// Selects Features of an EntityType to read values of and specifies read
// settings.
type GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestEntityTypeSpec struct {
	// EntityTypeId: Required. ID of the EntityType to select Features. The
	// EntityType id is the entity_type_id specified during EntityType creation.
	EntityTypeId string `json:"entityTypeId,omitempty"`
	// FeatureSelector: Required. Selectors choosing which Feature values to read
	// from the EntityType.
	FeatureSelector *GoogleCloudAiplatformV1beta1FeatureSelector `json:"featureSelector,omitempty"`
	// Settings: Per-Feature settings for the batch read.
	Settings []*GoogleCloudAiplatformV1beta1DestinationFeatureSetting `json:"settings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypeId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypeId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestEntityTypeSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestEntityTypeSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestPassThroughField:
// Describe pass-through fields in read_instance source.
type GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestPassThroughField struct {
	// FieldName: Required. The name of the field in the CSV header or the name of
	// the column in BigQuery table. The naming restriction is the same as
	// Feature.name.
	FieldName string `json:"fieldName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestPassThroughField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchReadFeatureValuesRequestPassThroughField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BatchReadFeatureValuesResponse: Response message
// for FeaturestoreService.BatchReadFeatureValues.
type GoogleCloudAiplatformV1beta1BatchReadFeatureValuesResponse struct {
}

// GoogleCloudAiplatformV1beta1BatchReadTensorboardTimeSeriesDataResponse:
// Response message for TensorboardService.BatchReadTensorboardTimeSeriesData.
type GoogleCloudAiplatformV1beta1BatchReadTensorboardTimeSeriesDataResponse struct {
	// TimeSeriesData: The returned time series data.
	TimeSeriesData []*GoogleCloudAiplatformV1beta1TimeSeriesData `json:"timeSeriesData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TimeSeriesData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TimeSeriesData") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BatchReadTensorboardTimeSeriesDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BatchReadTensorboardTimeSeriesDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BigQueryDestination: The BigQuery location for
// the output content.
type GoogleCloudAiplatformV1beta1BigQueryDestination struct {
	// OutputUri: Required. BigQuery URI to a project or table, up to 2000
	// characters long. When only the project is specified, the Dataset and Table
	// is created. When the full table reference is specified, the Dataset must
	// exist and table must not exist. Accepted forms: * BigQuery path. For
	// example: `bq://projectId` or `bq://projectId.bqDatasetId` or
	// `bq://projectId.bqDatasetId.bqTableId`.
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BigQueryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BigQuerySource: The BigQuery location for the
// input content.
type GoogleCloudAiplatformV1beta1BigQuerySource struct {
	// InputUri: Required. BigQuery URI to a table, up to 2000 characters long.
	// Accepted forms: * BigQuery path. For example:
	// `bq://projectId.bqDatasetId.bqTableId`.
	InputUri string `json:"inputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BigQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BleuInput: Input for bleu metric.
type GoogleCloudAiplatformV1beta1BleuInput struct {
	// Instances: Required. Repeated bleu instances.
	Instances []*GoogleCloudAiplatformV1beta1BleuInstance `json:"instances,omitempty"`
	// MetricSpec: Required. Spec for bleu score metric.
	MetricSpec *GoogleCloudAiplatformV1beta1BleuSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instances") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BleuInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BleuInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BleuInstance: Spec for bleu instance.
type GoogleCloudAiplatformV1beta1BleuInstance struct {
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// Reference: Required. Ground truth used to compare against the prediction.
	Reference string `json:"reference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prediction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prediction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BleuInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BleuInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BleuMetricValue: Bleu metric value for an
// instance.
type GoogleCloudAiplatformV1beta1BleuMetricValue struct {
	// Score: Output only. Bleu score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Score") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Score") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BleuMetricValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BleuMetricValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1BleuMetricValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1BleuMetricValue
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1beta1BleuResults: Results for bleu metric.
type GoogleCloudAiplatformV1beta1BleuResults struct {
	// BleuMetricValues: Output only. Bleu metric values.
	BleuMetricValues []*GoogleCloudAiplatformV1beta1BleuMetricValue `json:"bleuMetricValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BleuMetricValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BleuMetricValues") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BleuResults) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BleuResults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BleuSpec: Spec for bleu score metric -
// calculates the precision of n-grams in the prediction as compared to
// reference - returns a score ranging between 0 to 1.
type GoogleCloudAiplatformV1beta1BleuSpec struct {
	// UseEffectiveOrder: Optional. Whether to use_effective_order to compute bleu
	// score.
	UseEffectiveOrder bool `json:"useEffectiveOrder,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UseEffectiveOrder") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UseEffectiveOrder") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BleuSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BleuSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Blob: Content blob.
type GoogleCloudAiplatformV1beta1Blob struct {
	// Data: Required. Raw bytes.
	Data string `json:"data,omitempty"`
	// DisplayName: Optional. Display name of the blob. Used to provide a label or
	// filename to distinguish blobs. This field is only returned in PromptMessage
	// for prompt management. It is not currently used in the Gemini
	// GenerateContent calls.
	DisplayName string `json:"displayName,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Blob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Blob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1BlurBaselineConfig: Config for blur baseline.
// When enabled, a linear path from the maximally blurred image to the input
// image is created. Using a blurred baseline instead of zero (black image) is
// motivated by the BlurIG approach explained here:
// https://arxiv.org/abs/2004.03383
type GoogleCloudAiplatformV1beta1BlurBaselineConfig struct {
	// MaxBlurSigma: The standard deviation of the blur kernel for the blurred
	// baseline. The same blurring parameter is used for both the height and the
	// width dimension. If not set, the method defaults to the zero (i.e. black for
	// images) baseline.
	MaxBlurSigma float64 `json:"maxBlurSigma,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxBlurSigma") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxBlurSigma") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BlurBaselineConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BlurBaselineConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1BlurBaselineConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1BlurBaselineConfig
	var s1 struct {
		MaxBlurSigma gensupport.JSONFloat64 `json:"maxBlurSigma"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxBlurSigma = float64(s1.MaxBlurSigma)
	return nil
}

// GoogleCloudAiplatformV1beta1BoolArray: A list of boolean values.
type GoogleCloudAiplatformV1beta1BoolArray struct {
	// Values: A list of bool values.
	Values []bool `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1BoolArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1BoolArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CacheConfig: Config of GenAI caching features.
// This is a singleton resource.
type GoogleCloudAiplatformV1beta1CacheConfig struct {
	// DisableCache: If set to true, disables GenAI caching. Otherwise caching is
	// enabled.
	DisableCache bool `json:"disableCache,omitempty"`
	// Name: Identifier. Name of the cache config. Format: -
	// `projects/{project}/cacheConfig`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisableCache") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableCache") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CacheConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CacheConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CachedContent: A resource used in LLM queries
// for users to explicitly specify what to cache and how to cache.
type GoogleCloudAiplatformV1beta1CachedContent struct {
	// Contents: Optional. Input only. Immutable. The content to cache
	Contents []*GoogleCloudAiplatformV1beta1Content `json:"contents,omitempty"`
	// CreateTime: Output only. Creation time of the cache entry.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Optional. Immutable. The user-generated meaningful display name
	// of the cached content.
	DisplayName string `json:"displayName,omitempty"`
	// ExpireTime: Timestamp of when this resource is considered expired. This is
	// *always* provided on output, regardless of what was sent on input.
	ExpireTime string `json:"expireTime,omitempty"`
	// Model: Immutable. The name of the `Model` to use for cached content.
	// Currently, only the published Gemini base models are supported, in form of
	// projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}
	Model string `json:"model,omitempty"`
	// Name: Immutable. Identifier. The server-generated resource name of the
	// cached content Format:
	// projects/{project}/locations/{location}/cachedContents/{cached_content}
	Name string `json:"name,omitempty"`
	// SystemInstruction: Optional. Input only. Immutable. Developer set system
	// instruction. Currently, text only
	SystemInstruction *GoogleCloudAiplatformV1beta1Content `json:"systemInstruction,omitempty"`
	// ToolConfig: Optional. Input only. Immutable. Tool config. This config is
	// shared for all tools
	ToolConfig *GoogleCloudAiplatformV1beta1ToolConfig `json:"toolConfig,omitempty"`
	// Tools: Optional. Input only. Immutable. A list of `Tools` the model may use
	// to generate the next response
	Tools []*GoogleCloudAiplatformV1beta1Tool `json:"tools,omitempty"`
	// Ttl: Input only. The TTL for this resource. The expiration time is computed:
	// now + TTL.
	Ttl string `json:"ttl,omitempty"`
	// UpdateTime: Output only. When the cache entry was last updated in UTC time.
	UpdateTime string `json:"updateTime,omitempty"`
	// UsageMetadata: Output only. Metadata on the usage of the cached content.
	UsageMetadata *GoogleCloudAiplatformV1beta1CachedContentUsageMetadata `json:"usageMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CachedContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CachedContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CachedContentUsageMetadata: Metadata on the
// usage of the cached content.
type GoogleCloudAiplatformV1beta1CachedContentUsageMetadata struct {
	// AudioDurationSeconds: Duration of audio in seconds.
	AudioDurationSeconds int64 `json:"audioDurationSeconds,omitempty"`
	// ImageCount: Number of images.
	ImageCount int64 `json:"imageCount,omitempty"`
	// TextCount: Number of text characters.
	TextCount int64 `json:"textCount,omitempty"`
	// TotalTokenCount: Total number of tokens that the cached content consumes.
	TotalTokenCount int64 `json:"totalTokenCount,omitempty"`
	// VideoDurationSeconds: Duration of video in seconds.
	VideoDurationSeconds int64 `json:"videoDurationSeconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioDurationSeconds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioDurationSeconds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CachedContentUsageMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CachedContentUsageMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CancelBatchPredictionJobRequest: Request message
// for JobService.CancelBatchPredictionJob.
type GoogleCloudAiplatformV1beta1CancelBatchPredictionJobRequest struct {
}

// GoogleCloudAiplatformV1beta1CancelCustomJobRequest: Request message for
// JobService.CancelCustomJob.
type GoogleCloudAiplatformV1beta1CancelCustomJobRequest struct {
}

// GoogleCloudAiplatformV1beta1CancelDataLabelingJobRequest: Request message
// for JobService.CancelDataLabelingJob.
type GoogleCloudAiplatformV1beta1CancelDataLabelingJobRequest struct {
}

// GoogleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest: Request
// message for JobService.CancelHyperparameterTuningJob.
type GoogleCloudAiplatformV1beta1CancelHyperparameterTuningJobRequest struct {
}

// GoogleCloudAiplatformV1beta1CancelNasJobRequest: Request message for
// JobService.CancelNasJob.
type GoogleCloudAiplatformV1beta1CancelNasJobRequest struct {
}

// GoogleCloudAiplatformV1beta1CancelPipelineJobRequest: Request message for
// PipelineService.CancelPipelineJob.
type GoogleCloudAiplatformV1beta1CancelPipelineJobRequest struct {
}

// GoogleCloudAiplatformV1beta1CancelTrainingPipelineRequest: Request message
// for PipelineService.CancelTrainingPipeline.
type GoogleCloudAiplatformV1beta1CancelTrainingPipelineRequest struct {
}

// GoogleCloudAiplatformV1beta1CancelTuningJobRequest: Request message for
// GenAiTuningService.CancelTuningJob.
type GoogleCloudAiplatformV1beta1CancelTuningJobRequest struct {
}

// GoogleCloudAiplatformV1beta1Candidate: A response candidate generated from
// the model.
type GoogleCloudAiplatformV1beta1Candidate struct {
	// AvgLogprobs: Output only. Average log probability score of the candidate.
	AvgLogprobs float64 `json:"avgLogprobs,omitempty"`
	// CitationMetadata: Output only. Source attribution of the generated content.
	CitationMetadata *GoogleCloudAiplatformV1beta1CitationMetadata `json:"citationMetadata,omitempty"`
	// Content: Output only. Content parts of the candidate.
	Content *GoogleCloudAiplatformV1beta1Content `json:"content,omitempty"`
	// FinishMessage: Output only. Describes the reason the mode stopped generating
	// tokens in more detail. This is only filled when `finish_reason` is set.
	FinishMessage string `json:"finishMessage,omitempty"`
	// FinishReason: Output only. The reason why the model stopped generating
	// tokens. If empty, the model has not stopped generating the tokens.
	//
	// Possible values:
	//   "FINISH_REASON_UNSPECIFIED" - The finish reason is unspecified.
	//   "STOP" - Token generation reached a natural stopping point or a configured
	// stop sequence.
	//   "MAX_TOKENS" - Token generation reached the configured maximum output
	// tokens.
	//   "SAFETY" - Token generation stopped because the content potentially
	// contains safety violations. NOTE: When streaming, content is empty if
	// content filters blocks the output.
	//   "RECITATION" - The token generation stopped because of potential
	// recitation.
	//   "OTHER" - All other reasons that stopped the token generation.
	//   "BLOCKLIST" - Token generation stopped because the content contains
	// forbidden terms.
	//   "PROHIBITED_CONTENT" - Token generation stopped for potentially containing
	// prohibited content.
	//   "SPII" - Token generation stopped because the content potentially contains
	// Sensitive Personally Identifiable Information (SPII).
	//   "MALFORMED_FUNCTION_CALL" - The function call generated by the model is
	// invalid.
	FinishReason string `json:"finishReason,omitempty"`
	// GroundingMetadata: Output only. Metadata specifies sources used to ground
	// generated content.
	GroundingMetadata *GoogleCloudAiplatformV1beta1GroundingMetadata `json:"groundingMetadata,omitempty"`
	// Index: Output only. Index of the candidate.
	Index int64 `json:"index,omitempty"`
	// LogprobsResult: Output only. Log-likelihood scores for the response tokens
	// and top tokens
	LogprobsResult *GoogleCloudAiplatformV1beta1LogprobsResult `json:"logprobsResult,omitempty"`
	// SafetyRatings: Output only. List of ratings for the safety of a response
	// candidate. There is at most one rating per category.
	SafetyRatings []*GoogleCloudAiplatformV1beta1SafetyRating `json:"safetyRatings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvgLogprobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvgLogprobs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Candidate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Candidate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1Candidate) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1Candidate
	var s1 struct {
		AvgLogprobs gensupport.JSONFloat64 `json:"avgLogprobs"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AvgLogprobs = float64(s1.AvgLogprobs)
	return nil
}

// GoogleCloudAiplatformV1beta1CheckPublisherModelEulaAcceptanceRequest:
// Request message for ModelGardenService.CheckPublisherModelEula.
type GoogleCloudAiplatformV1beta1CheckPublisherModelEulaAcceptanceRequest struct {
	// PublisherModel: Required. The name of the PublisherModel resource. Format:
	// `publishers/{publisher}/models/{publisher_model}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}`
	PublisherModel string `json:"publisherModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PublisherModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublisherModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CheckPublisherModelEulaAcceptanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CheckPublisherModelEulaAcceptanceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateMetatdata: This
// message will be placed in the metadata field of a
// google.longrunning.Operation associated with a CheckTrialEarlyStoppingState
// request.
type GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateMetatdata struct {
	// GenericMetadata: Operation metadata for suggesting Trials.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// Study: The name of the Study that the Trial belongs to.
	Study string `json:"study,omitempty"`
	// Trial: The Trial name.
	Trial string `json:"trial,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateMetatdata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateMetatdata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateRequest: Request
// message for VizierService.CheckTrialEarlyStoppingState.
type GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateRequest struct {
}

// GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateResponse: Response
// message for VizierService.CheckTrialEarlyStoppingState.
type GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateResponse struct {
	// ShouldStop: True if the Trial should stop.
	ShouldStop bool `json:"shouldStop,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ShouldStop") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ShouldStop") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CheckTrialEarlyStoppingStateResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Citation: Source attributions for content.
type GoogleCloudAiplatformV1beta1Citation struct {
	// EndIndex: Output only. End index into the content.
	EndIndex int64 `json:"endIndex,omitempty"`
	// License: Output only. License of the attribution.
	License string `json:"license,omitempty"`
	// PublicationDate: Output only. Publication date of the attribution.
	PublicationDate *GoogleTypeDate `json:"publicationDate,omitempty"`
	// StartIndex: Output only. Start index into the content.
	StartIndex int64 `json:"startIndex,omitempty"`
	// Title: Output only. Title of the attribution.
	Title string `json:"title,omitempty"`
	// Uri: Output only. Url reference of the attribution.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Citation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Citation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CitationMetadata: A collection of source
// attributions for a piece of content.
type GoogleCloudAiplatformV1beta1CitationMetadata struct {
	// Citations: Output only. List of citations.
	Citations []*GoogleCloudAiplatformV1beta1Citation `json:"citations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Citations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Citations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CitationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CitationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Claim: Claim that is extracted from the input
// text and facts that support it.
type GoogleCloudAiplatformV1beta1Claim struct {
	// EndIndex: Index in the input text where the claim ends (exclusive).
	EndIndex int64 `json:"endIndex,omitempty"`
	// FactIndexes: Indexes of the facts supporting this claim.
	FactIndexes []int64 `json:"factIndexes,omitempty"`
	// Score: Confidence score of this corroboration.
	Score float64 `json:"score,omitempty"`
	// StartIndex: Index in the input text where the claim starts (inclusive).
	StartIndex int64 `json:"startIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Claim) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Claim
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1Claim) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1Claim
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1beta1ClientConnectionConfig: Configurations (e.g.
// inference timeout) that are applied on your endpoints.
type GoogleCloudAiplatformV1beta1ClientConnectionConfig struct {
	// InferenceTimeout: Customizable online prediction request timeout.
	InferenceTimeout string `json:"inferenceTimeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InferenceTimeout") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InferenceTimeout") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ClientConnectionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ClientConnectionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CodeExecutionResult: Result of executing the
// [ExecutableCode]. Always follows a `part` containing the [ExecutableCode].
type GoogleCloudAiplatformV1beta1CodeExecutionResult struct {
	// Outcome: Required. Outcome of the code execution.
	//
	// Possible values:
	//   "OUTCOME_UNSPECIFIED" - Unspecified status. This value should not be used.
	//   "OUTCOME_OK" - Code execution completed successfully.
	//   "OUTCOME_FAILED" - Code execution finished but with a failure. `stderr`
	// should contain the reason.
	//   "OUTCOME_DEADLINE_EXCEEDED" - Code execution ran for too long, and was
	// cancelled. There may or may not be a partial output present.
	Outcome string `json:"outcome,omitempty"`
	// Output: Optional. Contains stdout when code execution is successful, stderr
	// or other description otherwise.
	Output string `json:"output,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Outcome") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Outcome") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CodeExecutionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CodeExecutionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CoherenceInput: Input for coherence metric.
type GoogleCloudAiplatformV1beta1CoherenceInput struct {
	// Instance: Required. Coherence instance.
	Instance *GoogleCloudAiplatformV1beta1CoherenceInstance `json:"instance,omitempty"`
	// MetricSpec: Required. Spec for coherence score metric.
	MetricSpec *GoogleCloudAiplatformV1beta1CoherenceSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CoherenceInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CoherenceInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CoherenceInstance: Spec for coherence instance.
type GoogleCloudAiplatformV1beta1CoherenceInstance struct {
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prediction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prediction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CoherenceInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CoherenceInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CoherenceResult: Spec for coherence result.
type GoogleCloudAiplatformV1beta1CoherenceResult struct {
	// Confidence: Output only. Confidence for coherence score.
	Confidence float64 `json:"confidence,omitempty"`
	// Explanation: Output only. Explanation for coherence score.
	Explanation string `json:"explanation,omitempty"`
	// Score: Output only. Coherence score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CoherenceResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CoherenceResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1CoherenceResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1CoherenceResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		Score      gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1beta1CoherenceSpec: Spec for coherence score metric.
type GoogleCloudAiplatformV1beta1CoherenceSpec struct {
	// Version: Optional. Which version to use for evaluation.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CoherenceSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CoherenceSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CometInput: Input for Comet metric.
type GoogleCloudAiplatformV1beta1CometInput struct {
	// Instance: Required. Comet instance.
	Instance *GoogleCloudAiplatformV1beta1CometInstance `json:"instance,omitempty"`
	// MetricSpec: Required. Spec for comet metric.
	MetricSpec *GoogleCloudAiplatformV1beta1CometSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CometInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CometInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CometInstance: Spec for Comet instance - The
// fields used for evaluation are dependent on the comet version.
type GoogleCloudAiplatformV1beta1CometInstance struct {
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// Reference: Optional. Ground truth used to compare against the prediction.
	Reference string `json:"reference,omitempty"`
	// Source: Optional. Source text in original language.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prediction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prediction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CometInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CometInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CometResult: Spec for Comet result - calculates
// the comet score for the given instance using the version specified in the
// spec.
type GoogleCloudAiplatformV1beta1CometResult struct {
	// Score: Output only. Comet score. Range depends on version.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Score") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Score") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CometResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CometResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1CometResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1CometResult
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1beta1CometSpec: Spec for Comet metric.
type GoogleCloudAiplatformV1beta1CometSpec struct {
	// SourceLanguage: Optional. Source language in BCP-47 format.
	SourceLanguage string `json:"sourceLanguage,omitempty"`
	// TargetLanguage: Optional. Target language in BCP-47 format. Covers both
	// prediction and reference.
	TargetLanguage string `json:"targetLanguage,omitempty"`
	// Version: Required. Which version to use for evaluation.
	//
	// Possible values:
	//   "COMET_VERSION_UNSPECIFIED" - Comet version unspecified.
	//   "COMET_22_SRC_REF" - Comet 22 for translation + source + reference
	// (source-reference-combined).
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SourceLanguage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SourceLanguage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CometSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CometSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CompleteTrialRequest: Request message for
// VizierService.CompleteTrial.
type GoogleCloudAiplatformV1beta1CompleteTrialRequest struct {
	// FinalMeasurement: Optional. If provided, it will be used as the completed
	// Trial's final_measurement; Otherwise, the service will auto-select a
	// previously reported measurement as the final-measurement
	FinalMeasurement *GoogleCloudAiplatformV1beta1Measurement `json:"finalMeasurement,omitempty"`
	// InfeasibleReason: Optional. A human readable reason why the trial was
	// infeasible. This should only be provided if `trial_infeasible` is true.
	InfeasibleReason string `json:"infeasibleReason,omitempty"`
	// TrialInfeasible: Optional. True if the Trial cannot be run with the given
	// Parameter, and final_measurement will be ignored.
	TrialInfeasible bool `json:"trialInfeasible,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FinalMeasurement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FinalMeasurement") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CompleteTrialRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CompleteTrialRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CompletionStats: Success and error statistics of
// processing multiple entities (for example, DataItems or structured data
// rows) in batch.
type GoogleCloudAiplatformV1beta1CompletionStats struct {
	// FailedCount: Output only. The number of entities for which any error was
	// encountered.
	FailedCount int64 `json:"failedCount,omitempty,string"`
	// IncompleteCount: Output only. In cases when enough errors are encountered a
	// job, pipeline, or operation may be failed as a whole. Below is the number of
	// entities for which the processing had not been finished (either in
	// successful or failed state). Set to -1 if the number is unknown (for
	// example, the operation failed before the total entity number could be
	// collected).
	IncompleteCount int64 `json:"incompleteCount,omitempty,string"`
	// SuccessfulCount: Output only. The number of entities that had been processed
	// successfully.
	SuccessfulCount int64 `json:"successfulCount,omitempty,string"`
	// SuccessfulForecastPointCount: Output only. The number of the successful
	// forecast points that are generated by the forecasting model. This is ONLY
	// used by the forecasting batch prediction.
	SuccessfulForecastPointCount int64 `json:"successfulForecastPointCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FailedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailedCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CompletionStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CompletionStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ComputeTokensRequest: Request message for
// ComputeTokens RPC call.
type GoogleCloudAiplatformV1beta1ComputeTokensRequest struct {
	// Contents: Optional. Input content.
	Contents []*GoogleCloudAiplatformV1beta1Content `json:"contents,omitempty"`
	// Instances: Optional. The instances that are the input to token computing API
	// call. Schema is identical to the prediction schema of the text model, even
	// for the non-text models, like chat models, or Codey models.
	Instances []interface{} `json:"instances,omitempty"`
	// Model: Optional. The name of the publisher model requested to serve the
	// prediction. Format:
	// projects/{project}/locations/{location}/publishers/*/models/*
	Model string `json:"model,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ComputeTokensRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ComputeTokensRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ComputeTokensResponse: Response message for
// ComputeTokens RPC call.
type GoogleCloudAiplatformV1beta1ComputeTokensResponse struct {
	// TokensInfo: Lists of tokens info from the input. A ComputeTokensRequest
	// could have multiple instances with a prompt in each instance. We also need
	// to return lists of tokens info for the request with multiple instances.
	TokensInfo []*GoogleCloudAiplatformV1beta1TokensInfo `json:"tokensInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "TokensInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TokensInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ComputeTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ComputeTokensResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ContainerRegistryDestination: The Container
// Registry location for the container image.
type GoogleCloudAiplatformV1beta1ContainerRegistryDestination struct {
	// OutputUri: Required. Container Registry URI of a container image. Only
	// Google Container Registry and Artifact Registry are supported now. Accepted
	// forms: * Google Container Registry path. For example:
	// `gcr.io/projectId/imageName:tag`. * Artifact Registry path. For example:
	// `us-central1-docker.pkg.dev/projectId/repoName/imageName:tag`. If a tag is
	// not specified, "latest" will be used as the default tag.
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ContainerRegistryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ContainerRegistryDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ContainerSpec: The spec of a Container.
type GoogleCloudAiplatformV1beta1ContainerSpec struct {
	// Args: The arguments to be passed when starting the container.
	Args []string `json:"args,omitempty"`
	// Command: The command to be invoked when the container is started. It
	// overrides the entrypoint instruction in Dockerfile when provided.
	Command []string `json:"command,omitempty"`
	// Env: Environment variables to be passed to the container. Maximum limit is
	// 100.
	Env []*GoogleCloudAiplatformV1beta1EnvVar `json:"env,omitempty"`
	// ImageUri: Required. The URI of a container image in the Container Registry
	// that is to be run on each worker replica.
	ImageUri string `json:"imageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ContainerSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ContainerSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Content: The base structured datatype containing
// multi-part content of a message. A `Content` includes a `role` field
// designating the producer of the `Content` and a `parts` field containing
// multi-part data that contains the content of the message turn.
type GoogleCloudAiplatformV1beta1Content struct {
	// Parts: Required. Ordered `Parts` that constitute a single message. Parts may
	// have different IANA MIME types.
	Parts []*GoogleCloudAiplatformV1beta1Part `json:"parts,omitempty"`
	// Role: Optional. The producer of the content. Must be either 'user' or
	// 'model'. Useful to set for multi-turn conversations, otherwise can be left
	// blank or unset.
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Content) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Content
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ContentMap: Map of placeholder in metric prompt
// template to contents of model input.
type GoogleCloudAiplatformV1beta1ContentMap struct {
	// Values: Optional. Map of placeholder to contents.
	Values map[string]GoogleCloudAiplatformV1beta1ContentMapContents `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ContentMap) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ContentMap
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ContentMapContents: Repeated Content type.
type GoogleCloudAiplatformV1beta1ContentMapContents struct {
	// Contents: Optional. Repeated contents.
	Contents []*GoogleCloudAiplatformV1beta1Content `json:"contents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ContentMapContents) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ContentMapContents
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ContentsExample: A single example of a
// conversation with the model.
type GoogleCloudAiplatformV1beta1ContentsExample struct {
	// Contents: Required. The content of the conversation with the model that
	// resulted in the expected output.
	Contents []*GoogleCloudAiplatformV1beta1Content `json:"contents,omitempty"`
	// ExpectedContents: Required. The expected output for the given `contents`. To
	// represent multi-step reasoning, this is a repeated field that contains the
	// iterative steps of the expected output.
	ExpectedContents []*GoogleCloudAiplatformV1beta1ContentsExampleExpectedContent `json:"expectedContents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ContentsExample) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ContentsExample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ContentsExampleExpectedContent: A single step of
// the expected output.
type GoogleCloudAiplatformV1beta1ContentsExampleExpectedContent struct {
	// Content: Required. A single step's content.
	Content *GoogleCloudAiplatformV1beta1Content `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ContentsExampleExpectedContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ContentsExampleExpectedContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Context: Instance of a general context.
type GoogleCloudAiplatformV1beta1Context struct {
	// CreateTime: Output only. Timestamp when this Context was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of the Context
	Description string `json:"description,omitempty"`
	// DisplayName: User provided display name of the Context. May be up to 128
	// Unicode characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: An eTag used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Contexts.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. No more than
	// 64 user labels can be associated with one Context (System labels are
	// excluded).
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: Properties of the Context. Top level metadata keys' heading and
	// trailing spaces will be trimmed. The size of this field should not exceed
	// 200KB.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Immutable. The resource name of the Context.
	Name string `json:"name,omitempty"`
	// ParentContexts: Output only. A list of resource names of Contexts that are
	// parents of this Context. A Context may have at most 10 parent_contexts.
	ParentContexts []string `json:"parentContexts,omitempty"`
	// SchemaTitle: The title of the schema describing the metadata. Schema title
	// and version is expected to be registered in earlier Create Schema calls. And
	// both are used together as unique identifiers to identify schemas within the
	// local metadata store.
	SchemaTitle string `json:"schemaTitle,omitempty"`
	// SchemaVersion: The version of the schema in schema_name to use. Schema title
	// and version is expected to be registered in earlier Create Schema calls. And
	// both are used together as unique identifiers to identify schemas within the
	// local metadata store.
	SchemaVersion string `json:"schemaVersion,omitempty"`
	// UpdateTime: Output only. Timestamp when this Context was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Context
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CopyModelOperationMetadata: Details of
// ModelService.CopyModel operation.
type GoogleCloudAiplatformV1beta1CopyModelOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CopyModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CopyModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CopyModelRequest: Request message for
// ModelService.CopyModel.
type GoogleCloudAiplatformV1beta1CopyModelRequest struct {
	// EncryptionSpec: Customer-managed encryption key options. If this is set,
	// then the Model copy will be encrypted with the provided encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ModelId: Optional. Copy source_model into a new Model with this ID. The ID
	// will become the final component of the model resource name. This value may
	// be up to 63 characters, and valid characters are `[a-z0-9_-]`. The first
	// character cannot be a number or hyphen.
	ModelId string `json:"modelId,omitempty"`
	// ParentModel: Optional. Specify this field to copy source_model into this
	// existing Model as a new version. Format:
	// `projects/{project}/locations/{location}/models/{model}`
	ParentModel string `json:"parentModel,omitempty"`
	// SourceModel: Required. The resource name of the Model to copy. That Model
	// must be in the same Project. Format:
	// `projects/{project}/locations/{location}/models/{model}`
	SourceModel string `json:"sourceModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CopyModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CopyModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CopyModelResponse: Response message of
// ModelService.CopyModel operation.
type GoogleCloudAiplatformV1beta1CopyModelResponse struct {
	// Model: The name of the copied Model resource. Format:
	// `projects/{project}/locations/{location}/models/{model}`
	Model string `json:"model,omitempty"`
	// ModelVersionId: Output only. The version ID of the model that is copied.
	ModelVersionId string `json:"modelVersionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CopyModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CopyModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CorpusStatus: RagCorpus status.
type GoogleCloudAiplatformV1beta1CorpusStatus struct {
	// ErrorStatus: Output only. Only when the `state` field is ERROR.
	ErrorStatus string `json:"errorStatus,omitempty"`
	// State: Output only. RagCorpus life state.
	//
	// Possible values:
	//   "UNKNOWN" - This state is not supposed to happen.
	//   "INITIALIZED" - RagCorpus resource entry is initialized, but hasn't done
	// validation.
	//   "ACTIVE" - RagCorpus is provisioned successfully and is ready to serve.
	//   "ERROR" - RagCorpus is in a problematic situation. See `error_message`
	// field for details.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorStatus") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CorpusStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CorpusStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CorroborateContentRequest: Request message for
// CorroborateContent.
type GoogleCloudAiplatformV1beta1CorroborateContentRequest struct {
	// Content: Optional. Input content to corroborate, only text format is
	// supported for now.
	Content *GoogleCloudAiplatformV1beta1Content `json:"content,omitempty"`
	// Facts: Optional. Facts used to generate the text can also be used to
	// corroborate the text.
	Facts []*GoogleCloudAiplatformV1beta1Fact `json:"facts,omitempty"`
	// Parameters: Optional. Parameters that can be set to override default
	// settings per request.
	Parameters *GoogleCloudAiplatformV1beta1CorroborateContentRequestParameters `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CorroborateContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CorroborateContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CorroborateContentRequestParameters: Parameters
// that can be overrided per request.
type GoogleCloudAiplatformV1beta1CorroborateContentRequestParameters struct {
	// CitationThreshold: Optional. Only return claims with citation score larger
	// than the threshold.
	CitationThreshold float64 `json:"citationThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CitationThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CitationThreshold") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CorroborateContentRequestParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CorroborateContentRequestParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1CorroborateContentRequestParameters) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1CorroborateContentRequestParameters
	var s1 struct {
		CitationThreshold gensupport.JSONFloat64 `json:"citationThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CitationThreshold = float64(s1.CitationThreshold)
	return nil
}

// GoogleCloudAiplatformV1beta1CorroborateContentResponse: Response message for
// CorroborateContent.
type GoogleCloudAiplatformV1beta1CorroborateContentResponse struct {
	// Claims: Claims that are extracted from the input content and facts that
	// support the claims.
	Claims []*GoogleCloudAiplatformV1beta1Claim `json:"claims,omitempty"`
	// CorroborationScore: Confidence score of corroborating content. Value is
	// [0,1] with 1 is the most confidence.
	CorroborationScore float64 `json:"corroborationScore,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Claims") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Claims") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CorroborateContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CorroborateContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1CorroborateContentResponse) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1CorroborateContentResponse
	var s1 struct {
		CorroborationScore gensupport.JSONFloat64 `json:"corroborationScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CorroborationScore = float64(s1.CorroborationScore)
	return nil
}

// GoogleCloudAiplatformV1beta1CountTokensRequest: Request message for
// PredictionService.CountTokens.
type GoogleCloudAiplatformV1beta1CountTokensRequest struct {
	// Contents: Optional. Input content.
	Contents []*GoogleCloudAiplatformV1beta1Content `json:"contents,omitempty"`
	// GenerationConfig: Optional. Generation config that the model will use to
	// generate the response.
	GenerationConfig *GoogleCloudAiplatformV1beta1GenerationConfig `json:"generationConfig,omitempty"`
	// Instances: Optional. The instances that are the input to token counting
	// call. Schema is identical to the prediction schema of the underlying model.
	Instances []interface{} `json:"instances,omitempty"`
	// Model: Optional. The name of the publisher model requested to serve the
	// prediction. Format:
	// `projects/{project}/locations/{location}/publishers/*/models/*`
	Model string `json:"model,omitempty"`
	// SystemInstruction: Optional. The user provided system instructions for the
	// model. Note: only text should be used in parts and content in each part will
	// be in a separate paragraph.
	SystemInstruction *GoogleCloudAiplatformV1beta1Content `json:"systemInstruction,omitempty"`
	// Tools: Optional. A list of `Tools` the model may use to generate the next
	// response. A `Tool` is a piece of code that enables the system to interact
	// with external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model.
	Tools []*GoogleCloudAiplatformV1beta1Tool `json:"tools,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CountTokensRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CountTokensRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CountTokensResponse: Response message for
// PredictionService.CountTokens.
type GoogleCloudAiplatformV1beta1CountTokensResponse struct {
	// PromptTokensDetails: Output only. List of modalities that were processed in
	// the request input.
	PromptTokensDetails []*GoogleCloudAiplatformV1beta1ModalityTokenCount `json:"promptTokensDetails,omitempty"`
	// TotalBillableCharacters: The total number of billable characters counted
	// across all instances from the request.
	TotalBillableCharacters int64 `json:"totalBillableCharacters,omitempty"`
	// TotalTokens: The total number of tokens counted across all instances from
	// the request.
	TotalTokens int64 `json:"totalTokens,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "PromptTokensDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PromptTokensDetails") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CountTokensResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CountTokensResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateDatasetOperationMetadata: Runtime
// operation information for DatasetService.CreateDataset.
type GoogleCloudAiplatformV1beta1CreateDatasetOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateDatasetOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateDatasetVersionOperationMetadata: Runtime
// operation information for DatasetService.CreateDatasetVersion.
type GoogleCloudAiplatformV1beta1CreateDatasetVersionOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateDatasetVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateDatasetVersionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolOperationMetadata:
// Runtime operation information for CreateDeploymentResourcePool method.
type GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolRequest: Request
// message for CreateDeploymentResourcePool method.
type GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolRequest struct {
	// DeploymentResourcePool: Required. The DeploymentResourcePool to create.
	DeploymentResourcePool *GoogleCloudAiplatformV1beta1DeploymentResourcePool `json:"deploymentResourcePool,omitempty"`
	// DeploymentResourcePoolId: Required. The ID to use for the
	// DeploymentResourcePool, which will become the final component of the
	// DeploymentResourcePool's resource name. The maximum length is 63 characters,
	// and valid characters are `/^a-z ([a-z0-9-]{0,61}[a-z0-9])?$/`.
	DeploymentResourcePoolId string `json:"deploymentResourcePoolId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeploymentResourcePool") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeploymentResourcePool") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateDeploymentResourcePoolRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateEndpointOperationMetadata: Runtime
// operation information for EndpointService.CreateEndpoint.
type GoogleCloudAiplatformV1beta1CreateEndpointOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateEndpointOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateEndpointOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateEntityTypeOperationMetadata: Details of
// operations that perform create EntityType.
type GoogleCloudAiplatformV1beta1CreateEntityTypeOperationMetadata struct {
	// GenericMetadata: Operation metadata for EntityType.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateEntityTypeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateEntityTypeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateExtensionControllerOperationMetadata:
// Details of ExtensionControllerService.CreateExtensionController operation.
type GoogleCloudAiplatformV1beta1CreateExtensionControllerOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateExtensionControllerOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateExtensionControllerOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateFeatureGroupOperationMetadata: Details of
// operations that perform create FeatureGroup.
type GoogleCloudAiplatformV1beta1CreateFeatureGroupOperationMetadata struct {
	// GenericMetadata: Operation metadata for FeatureGroup.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateFeatureGroupOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateFeatureGroupOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateFeatureOnlineStoreOperationMetadata:
// Details of operations that perform create FeatureOnlineStore.
type GoogleCloudAiplatformV1beta1CreateFeatureOnlineStoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for FeatureOnlineStore.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateFeatureOnlineStoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateFeatureOnlineStoreOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateFeatureOperationMetadata: Details of
// operations that perform create Feature.
type GoogleCloudAiplatformV1beta1CreateFeatureOperationMetadata struct {
	// GenericMetadata: Operation metadata for Feature.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateFeatureOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateFeatureOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateFeatureRequest: Request message for
// FeaturestoreService.CreateFeature. Request message for
// FeatureRegistryService.CreateFeature.
type GoogleCloudAiplatformV1beta1CreateFeatureRequest struct {
	// Feature: Required. The Feature to create.
	Feature *GoogleCloudAiplatformV1beta1Feature `json:"feature,omitempty"`
	// FeatureId: Required. The ID to use for the Feature, which will become the
	// final component of the Feature's resource name. This value may be up to 128
	// characters, and valid characters are `[a-z0-9_]`. The first character cannot
	// be a number. The value must be unique within an EntityType/FeatureGroup.
	FeatureId string `json:"featureId,omitempty"`
	// Parent: Required. The resource name of the EntityType or FeatureGroup to
	// create a Feature. Format for entity_type as parent:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityT
	// ypes/{entity_type}` Format for feature_group as parent:
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Feature") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Feature") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateFeatureRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateFeatureRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateFeatureViewOperationMetadata: Details of
// operations that perform create FeatureView.
type GoogleCloudAiplatformV1beta1CreateFeatureViewOperationMetadata struct {
	// GenericMetadata: Operation metadata for FeatureView Create.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateFeatureViewOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateFeatureViewOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateFeaturestoreOperationMetadata: Details of
// operations that perform create Featurestore.
type GoogleCloudAiplatformV1beta1CreateFeaturestoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateFeaturestoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateFeaturestoreOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateIndexEndpointOperationMetadata: Runtime
// operation information for IndexEndpointService.CreateIndexEndpoint.
type GoogleCloudAiplatformV1beta1CreateIndexEndpointOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateIndexEndpointOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateIndexEndpointOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateIndexOperationMetadata: Runtime operation
// information for IndexService.CreateIndex.
type GoogleCloudAiplatformV1beta1CreateIndexOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// NearestNeighborSearchOperationMetadata: The operation metadata with regard
	// to Matching Engine Index operation.
	NearestNeighborSearchOperationMetadata *GoogleCloudAiplatformV1beta1NearestNeighborSearchOperationMetadata `json:"nearestNeighborSearchOperationMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateIndexOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateIndexOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateMetadataStoreOperationMetadata: Details of
// operations that perform MetadataService.CreateMetadataStore.
type GoogleCloudAiplatformV1beta1CreateMetadataStoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for creating a MetadataStore.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateMetadataStoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateMetadataStoreOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateModelMonitorOperationMetadata: Runtime
// operation information for ModelMonitoringService.CreateModelMonitor.
type GoogleCloudAiplatformV1beta1CreateModelMonitorOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateModelMonitorOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateModelMonitorOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateModelMonitoringJobRequest: Request message
// for ModelMonitoringService.CreateModelMonitoringJob.
type GoogleCloudAiplatformV1beta1CreateModelMonitoringJobRequest struct {
	// ModelMonitoringJob: Required. The ModelMonitoringJob to create
	ModelMonitoringJob *GoogleCloudAiplatformV1beta1ModelMonitoringJob `json:"modelMonitoringJob,omitempty"`
	// ModelMonitoringJobId: Optional. The ID to use for the Model Monitoring Job,
	// which will become the final component of the model monitoring job resource
	// name. The maximum length is 63 characters, and valid characters are `/^a-z
	// ([a-z0-9-]{0,61}[a-z0-9])?$/`.
	ModelMonitoringJobId string `json:"modelMonitoringJobId,omitempty"`
	// Parent: Required. The parent of the ModelMonitoringJob. Format:
	// `projects/{project}/locations/{location}/modelMoniitors/{model_monitor}`
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelMonitoringJob") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelMonitoringJob") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateModelMonitoringJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateModelMonitoringJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateNotebookExecutionJobOperationMetadata:
// Metadata information for NotebookService.CreateNotebookExecutionJob.
type GoogleCloudAiplatformV1beta1CreateNotebookExecutionJobOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ProgressMessage: A human-readable message that shows the intermediate
	// progress details of NotebookRuntime.
	ProgressMessage string `json:"progressMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateNotebookExecutionJobOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateNotebookExecutionJobOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateNotebookExecutionJobRequest: Request
// message for [NotebookService.CreateNotebookExecutionJob]
type GoogleCloudAiplatformV1beta1CreateNotebookExecutionJobRequest struct {
	// NotebookExecutionJob: Required. The NotebookExecutionJob to create.
	NotebookExecutionJob *GoogleCloudAiplatformV1beta1NotebookExecutionJob `json:"notebookExecutionJob,omitempty"`
	// NotebookExecutionJobId: Optional. User specified ID for the
	// NotebookExecutionJob.
	NotebookExecutionJobId string `json:"notebookExecutionJobId,omitempty"`
	// Parent: Required. The resource name of the Location to create the
	// NotebookExecutionJob. Format: `projects/{project}/locations/{location}`
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NotebookExecutionJob") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NotebookExecutionJob") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateNotebookExecutionJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateNotebookExecutionJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateNotebookRuntimeTemplateOperationMetadata:
// Metadata information for NotebookService.CreateNotebookRuntimeTemplate.
type GoogleCloudAiplatformV1beta1CreateNotebookRuntimeTemplateOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateNotebookRuntimeTemplateOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateNotebookRuntimeTemplateOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreatePersistentResourceOperationMetadata:
// Details of operations that perform create PersistentResource.
type GoogleCloudAiplatformV1beta1CreatePersistentResourceOperationMetadata struct {
	// GenericMetadata: Operation metadata for PersistentResource.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ProgressMessage: Progress Message for Create LRO
	ProgressMessage string `json:"progressMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreatePersistentResourceOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreatePersistentResourceOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreatePipelineJobRequest: Request message for
// PipelineService.CreatePipelineJob.
type GoogleCloudAiplatformV1beta1CreatePipelineJobRequest struct {
	// Parent: Required. The resource name of the Location to create the
	// PipelineJob in. Format: `projects/{project}/locations/{location}`
	Parent string `json:"parent,omitempty"`
	// PipelineJob: Required. The PipelineJob to create.
	PipelineJob *GoogleCloudAiplatformV1beta1PipelineJob `json:"pipelineJob,omitempty"`
	// PipelineJobId: The ID to use for the PipelineJob, which will become the
	// final component of the PipelineJob name. If not provided, an ID will be
	// automatically generated. This value should be less than 128 characters, and
	// valid characters are `/a-z-/`.
	PipelineJobId string `json:"pipelineJobId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreatePipelineJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreatePipelineJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateRegistryFeatureOperationMetadata: Details
// of operations that perform create FeatureGroup.
type GoogleCloudAiplatformV1beta1CreateRegistryFeatureOperationMetadata struct {
	// GenericMetadata: Operation metadata for Feature.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateRegistryFeatureOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateRegistryFeatureOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateSolverOperationMetadata: Runtime operation
// information for SolverService.CreateSolver.
type GoogleCloudAiplatformV1beta1CreateSolverOperationMetadata struct {
	// GenericMetadata: The generic operation information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateSolverOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateSolverOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateSpecialistPoolOperationMetadata: Runtime
// operation information for SpecialistPoolService.CreateSpecialistPool.
type GoogleCloudAiplatformV1beta1CreateSpecialistPoolOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateSpecialistPoolOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateSpecialistPoolOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateTensorboardOperationMetadata: Details of
// operations that perform create Tensorboard.
type GoogleCloudAiplatformV1beta1CreateTensorboardOperationMetadata struct {
	// GenericMetadata: Operation metadata for Tensorboard.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateTensorboardOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateTensorboardOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateTensorboardRunRequest: Request message for
// TensorboardService.CreateTensorboardRun.
type GoogleCloudAiplatformV1beta1CreateTensorboardRunRequest struct {
	// Parent: Required. The resource name of the TensorboardExperiment to create
	// the TensorboardRun in. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experimen
	// ts/{experiment}`
	Parent string `json:"parent,omitempty"`
	// TensorboardRun: Required. The TensorboardRun to create.
	TensorboardRun *GoogleCloudAiplatformV1beta1TensorboardRun `json:"tensorboardRun,omitempty"`
	// TensorboardRunId: Required. The ID to use for the Tensorboard run, which
	// becomes the final component of the Tensorboard run's resource name. This
	// value should be 1-128 characters, and valid characters are `/a-z-/`.
	TensorboardRunId string `json:"tensorboardRunId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateTensorboardRunRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateTensorboardRunRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CreateTensorboardTimeSeriesRequest: Request
// message for TensorboardService.CreateTensorboardTimeSeries.
type GoogleCloudAiplatformV1beta1CreateTensorboardTimeSeriesRequest struct {
	// Parent: Required. The resource name of the TensorboardRun to create the
	// TensorboardTimeSeries in. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experimen
	// ts/{experiment}/runs/{run}`
	Parent string `json:"parent,omitempty"`
	// TensorboardTimeSeries: Required. The TensorboardTimeSeries to create.
	TensorboardTimeSeries *GoogleCloudAiplatformV1beta1TensorboardTimeSeries `json:"tensorboardTimeSeries,omitempty"`
	// TensorboardTimeSeriesId: Optional. The user specified unique ID to use for
	// the TensorboardTimeSeries, which becomes the final component of the
	// TensorboardTimeSeries's resource name. This value should match "a-z0-9{0,
	// 127}"
	TensorboardTimeSeriesId string `json:"tensorboardTimeSeriesId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CreateTensorboardTimeSeriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CreateTensorboardTimeSeriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CsvDestination: The storage details for CSV
// output content.
type GoogleCloudAiplatformV1beta1CsvDestination struct {
	// GcsDestination: Required. Google Cloud Storage location.
	GcsDestination *GoogleCloudAiplatformV1beta1GcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsDestination") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CsvDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CsvDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CsvSource: The storage details for CSV input
// content.
type GoogleCloudAiplatformV1beta1CsvSource struct {
	// GcsSource: Required. Google Cloud Storage location.
	GcsSource *GoogleCloudAiplatformV1beta1GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CsvSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CsvSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CustomJob: Represents a job that runs custom
// workloads such as a Docker container or a Python package. A CustomJob can
// have multiple worker pools and each worker pool can have its own machine and
// input spec. A CustomJob will be cleaned up once the job enters terminal
// state (failed or succeeded).
type GoogleCloudAiplatformV1beta1CustomJob struct {
	// CreateTime: Output only. Time when the CustomJob was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The display name of the CustomJob. The name can be up
	// to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Customer-managed encryption key options for a CustomJob. If
	// this is set, then all resources created by the CustomJob will be encrypted
	// with the provided encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// EndTime: Output only. Time when the CustomJob entered any of the following
	// states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
	EndTime string `json:"endTime,omitempty"`
	// Error: Output only. Only populated when job's state is `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// JobSpec: Required. Job spec.
	JobSpec *GoogleCloudAiplatformV1beta1CustomJobSpec `json:"jobSpec,omitempty"`
	// Labels: The labels with user-defined metadata to organize CustomJobs. Label
	// keys and values can be no longer than 64 characters (Unicode codepoints),
	// can only contain lowercase letters, numeric characters, underscores and
	// dashes. International characters are allowed. See https://goo.gl/xmQnxf for
	// more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. Resource name of a CustomJob.
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// StartTime: Output only. Time when the CustomJob for the first time entered
	// the `JOB_STATE_RUNNING` state.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this state the
	// job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to the
	// `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded, some
	// results may be missing due to errors.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Time when the CustomJob was most recently updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// WebAccessUris: Output only. URIs for accessing interactive shells
	// (https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
	// (one URI for each training node). Only available if
	// job_spec.enable_web_access is `true`. The keys are names of each node in the
	// training job; for example, `workerpool0-0` for the primary node,
	// `workerpool1-0` for the first node in the second worker pool, and
	// `workerpool1-1` for the second node in the second worker pool. The values
	// are the URIs for each node's interactive shell.
	WebAccessUris map[string]string `json:"webAccessUris,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CustomJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CustomJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CustomJobSpec: Represents the spec of a
// CustomJob.
type GoogleCloudAiplatformV1beta1CustomJobSpec struct {
	// BaseOutputDirectory: The Cloud Storage location to store the output of this
	// CustomJob or HyperparameterTuningJob. For HyperparameterTuningJob, the
	// baseOutputDirectory of each child CustomJob backing a Trial is set to a
	// subdirectory of name id under its parent HyperparameterTuningJob's
	// baseOutputDirectory. The following Vertex AI environment variables will be
	// passed to containers or python modules when this field is set: For
	// CustomJob: * AIP_MODEL_DIR = `/model/` * AIP_CHECKPOINT_DIR =
	// `/checkpoints/` * AIP_TENSORBOARD_LOG_DIR = `/logs/` For CustomJob backing a
	// Trial of HyperparameterTuningJob: * AIP_MODEL_DIR = `//model/` *
	// AIP_CHECKPOINT_DIR = `//checkpoints/` * AIP_TENSORBOARD_LOG_DIR = `//logs/`
	BaseOutputDirectory *GoogleCloudAiplatformV1beta1GcsDestination `json:"baseOutputDirectory,omitempty"`
	// EnableDashboardAccess: Optional. Whether you want Vertex AI to enable access
	// to the customized dashboard in training chief container. If set to `true`,
	// you can access the dashboard at the URIs given by CustomJob.web_access_uris
	// or Trial.web_access_uris (within HyperparameterTuningJob.trials).
	EnableDashboardAccess bool `json:"enableDashboardAccess,omitempty"`
	// EnableWebAccess: Optional. Whether you want Vertex AI to enable interactive
	// shell access
	// (https://cloud.google.com/vertex-ai/docs/training/monitor-debug-interactive-shell)
	// to training containers. If set to `true`, you can access interactive shells
	// at the URIs given by CustomJob.web_access_uris or Trial.web_access_uris
	// (within HyperparameterTuningJob.trials).
	EnableWebAccess bool `json:"enableWebAccess,omitempty"`
	// Experiment: Optional. The Experiment associated with this job. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadataStores}/cont
	// exts/{experiment-name}`
	Experiment string `json:"experiment,omitempty"`
	// ExperimentRun: Optional. The Experiment Run associated with this job.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadataStores}/cont
	// exts/{experiment-name}-{experiment-run-name}`
	ExperimentRun string `json:"experimentRun,omitempty"`
	// Models: Optional. The name of the Model resources for which to generate a
	// mapping to artifact URIs. Applicable only to some of the Google-provided
	// custom jobs. Format:
	// `projects/{project}/locations/{location}/models/{model}` In order to
	// retrieve a specific version of the model, also provide the version ID or
	// version alias. Example:
	// `projects/{project}/locations/{location}/models/{model}@2` or
	// `projects/{project}/locations/{location}/models/{model}@golden` If no
	// version ID or alias is specified, the "default" version will be returned.
	// The "default" version alias is created for the first version of the model,
	// and can be moved to other versions later on. There will be exactly one
	// default version.
	Models []string `json:"models,omitempty"`
	// Network: Optional. The full name of the Compute Engine network
	// (/compute/docs/networks-and-firewalls#networks) to which the Job should be
	// peered. For example, `projects/12345/global/networks/myVPC`. Format
	// (/compute/docs/reference/rest/v1/networks/insert) is of the form
	// `projects/{project}/global/networks/{network}`. Where {project} is a project
	// number, as in `12345`, and {network} is a network name. To specify this
	// field, you must have already configured VPC Network Peering for Vertex AI
	// (https://cloud.google.com/vertex-ai/docs/general/vpc-peering). If this field
	// is left unspecified, the job is not peered with any network.
	Network string `json:"network,omitempty"`
	// PersistentResourceId: Optional. The ID of the PersistentResource in the same
	// Project and Location which to run If this is specified, the job will be run
	// on existing machines held by the PersistentResource instead of on-demand
	// short-live machines. The network and CMEK configs on the job should be
	// consistent with those on the PersistentResource, otherwise, the job will be
	// rejected.
	PersistentResourceId string `json:"persistentResourceId,omitempty"`
	// ProtectedArtifactLocationId: The ID of the location to store protected
	// artifacts. e.g. us-central1. Populate only when the location is different
	// than CustomJob location. List of supported locations:
	// https://cloud.google.com/vertex-ai/docs/general/locations
	ProtectedArtifactLocationId string `json:"protectedArtifactLocationId,omitempty"`
	// PscInterfaceConfig: Optional. Configuration for PSC-I for CustomJob.
	PscInterfaceConfig *GoogleCloudAiplatformV1beta1PscInterfaceConfig `json:"pscInterfaceConfig,omitempty"`
	// ReservedIpRanges: Optional. A list of names for the reserved ip ranges under
	// the VPC network that can be used for this job. If set, we will deploy the
	// job within the provided ip ranges. Otherwise, the job will be deployed to
	// any ip ranges under the provided VPC network. Example:
	// ['vertex-ai-ip-range'].
	ReservedIpRanges []string `json:"reservedIpRanges,omitempty"`
	// Scheduling: Scheduling options for a CustomJob.
	Scheduling *GoogleCloudAiplatformV1beta1Scheduling `json:"scheduling,omitempty"`
	// ServiceAccount: Specifies the service account for workload run-as account.
	// Users submitting jobs must have act-as permission on this run-as account. If
	// unspecified, the Vertex AI Custom Code Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// for the CustomJob's project is used.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// Tensorboard: Optional. The name of a Vertex AI Tensorboard resource to which
	// this CustomJob will upload Tensorboard logs. Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
	Tensorboard string `json:"tensorboard,omitempty"`
	// WorkerPoolSpecs: Required. The spec of the worker pools including machine
	// type and Docker image. All worker pools except the first one are optional
	// and can be skipped by providing an empty value.
	WorkerPoolSpecs []*GoogleCloudAiplatformV1beta1WorkerPoolSpec `json:"workerPoolSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseOutputDirectory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseOutputDirectory") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CustomJobSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CustomJobSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CustomOutput: Spec for custom output.
type GoogleCloudAiplatformV1beta1CustomOutput struct {
	// RawOutputs: Output only. List of raw output strings.
	RawOutputs *GoogleCloudAiplatformV1beta1RawOutput `json:"rawOutputs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RawOutputs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RawOutputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CustomOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CustomOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1CustomOutputFormatConfig: Spec for custom output
// format configuration.
type GoogleCloudAiplatformV1beta1CustomOutputFormatConfig struct {
	// ReturnRawOutput: Optional. Whether to return raw output.
	ReturnRawOutput bool `json:"returnRawOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReturnRawOutput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReturnRawOutput") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1CustomOutputFormatConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1CustomOutputFormatConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DataItem: A piece of data in a Dataset. Could be
// an image, a video, a document or plain text.
type GoogleCloudAiplatformV1beta1DataItem struct {
	// CreateTime: Output only. Timestamp when this DataItem was created.
	CreateTime string `json:"createTime,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// DataItems. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed. No
	// more than 64 user labels can be associated with one DataItem(System labels
	// are excluded). See https://goo.gl/xmQnxf for more information and examples
	// of labels. System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The resource name of the DataItem.
	Name string `json:"name,omitempty"`
	// Payload: Required. The data that the DataItem represents (for example, an
	// image or a text snippet). The schema of the payload is stored in the parent
	// Dataset's metadata schema's dataItemSchemaUri field.
	Payload interface{} `json:"payload,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// UpdateTime: Output only. Timestamp when this DataItem was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DataItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DataItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DataItemView: A container for a single DataItem
// and Annotations on it.
type GoogleCloudAiplatformV1beta1DataItemView struct {
	// Annotations: The Annotations on the DataItem. If too many Annotations should
	// be returned for the DataItem, this field will be truncated per
	// annotations_limit in request. If it was, then the has_truncated_annotations
	// will be set to true.
	Annotations []*GoogleCloudAiplatformV1beta1Annotation `json:"annotations,omitempty"`
	// DataItem: The DataItem.
	DataItem *GoogleCloudAiplatformV1beta1DataItem `json:"dataItem,omitempty"`
	// HasTruncatedAnnotations: True if and only if the Annotations field has been
	// truncated. It happens if more Annotations for this DataItem met the
	// request's annotation_filter than are allowed to be returned by
	// annotations_limit. Note that if Annotations field is not being returned due
	// to field mask, then this field will not be set to true no matter how many
	// Annotations are there.
	HasTruncatedAnnotations bool `json:"hasTruncatedAnnotations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DataItemView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DataItemView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DataLabelingJob: DataLabelingJob is used to
// trigger a human labeling job on unlabeled data from the following Dataset:
type GoogleCloudAiplatformV1beta1DataLabelingJob struct {
	// ActiveLearningConfig: Parameters that configure the active learning
	// pipeline. Active learning will label the data incrementally via several
	// iterations. For every iteration, it will select a batch of data based on the
	// sampling strategy.
	ActiveLearningConfig *GoogleCloudAiplatformV1beta1ActiveLearningConfig `json:"activeLearningConfig,omitempty"`
	// AnnotationLabels: Labels to assign to annotations generated by this
	// DataLabelingJob. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	// System reserved label keys are prefixed with "aiplatform.googleapis.com/"
	// and are immutable.
	AnnotationLabels map[string]string `json:"annotationLabels,omitempty"`
	// CreateTime: Output only. Timestamp when this DataLabelingJob was created.
	CreateTime string `json:"createTime,omitempty"`
	// CurrentSpend: Output only. Estimated cost(in US dollars) that the
	// DataLabelingJob has incurred to date.
	CurrentSpend *GoogleTypeMoney `json:"currentSpend,omitempty"`
	// Datasets: Required. Dataset resource names. Right now we only support
	// labeling from a single Dataset. Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Datasets []string `json:"datasets,omitempty"`
	// DisplayName: Required. The user-defined name of the DataLabelingJob. The
	// name can be up to 128 characters long and can consist of any UTF-8
	// characters. Display name of a DataLabelingJob.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Customer-managed encryption key spec for a DataLabelingJob.
	// If set, this DataLabelingJob will be secured by this key. Note: Annotations
	// created in the DataLabelingJob are associated with the EncryptionSpec of the
	// Dataset they are exported to.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Error: Output only. DataLabelingJob errors. It is only populated when job's
	// state is `JOB_STATE_FAILED` or `JOB_STATE_CANCELLED`.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Inputs: Required. Input config parameters for the DataLabelingJob.
	Inputs interface{} `json:"inputs,omitempty"`
	// InputsSchemaUri: Required. Points to a YAML file stored on Google Cloud
	// Storage describing the config for a specific type of DataLabelingJob. The
	// schema files that can be used here are found in the
	// https://storage.googleapis.com/google-cloud-aiplatform bucket in the
	// /schema/datalabelingjob/inputs/ folder.
	InputsSchemaUri string `json:"inputsSchemaUri,omitempty"`
	// InstructionUri: Required. The Google Cloud Storage location of the
	// instruction pdf. This pdf is shared with labelers, and provides detailed
	// description on how to label DataItems in Datasets.
	InstructionUri string `json:"instructionUri,omitempty"`
	// LabelerCount: Required. Number of labelers to work on each DataItem.
	LabelerCount int64 `json:"labelerCount,omitempty"`
	// LabelingProgress: Output only. Current labeling job progress percentage
	// scaled in interval [0, 100], indicating the percentage of DataItems that has
	// been finished.
	LabelingProgress int64 `json:"labelingProgress,omitempty"`
	// Labels: The labels with user-defined metadata to organize your
	// DataLabelingJobs. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	// System reserved label keys are prefixed with "aiplatform.googleapis.com/"
	// and are immutable. Following system labels exist for each DataLabelingJob: *
	// "aiplatform.googleapis.com/schema": output only, its value is the
	// inputs_schema's title.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. Resource name of the DataLabelingJob.
	Name string `json:"name,omitempty"`
	// SpecialistPools: The SpecialistPools' resource names associated with this
	// job.
	SpecialistPools []string `json:"specialistPools,omitempty"`
	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this state the
	// job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to the
	// `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded, some
	// results may be missing due to errors.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp when this DataLabelingJob was updated
	// most recently.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveLearningConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveLearningConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DataLabelingJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DataLabelingJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Dataset: A collection of DataItems and
// Annotations on them.
type GoogleCloudAiplatformV1beta1Dataset struct {
	// CreateTime: Output only. Timestamp when this Dataset was created.
	CreateTime string `json:"createTime,omitempty"`
	// DataItemCount: Output only. The number of DataItems in this Dataset. Only
	// apply for non-structured Dataset.
	DataItemCount int64 `json:"dataItemCount,omitempty,string"`
	// Description: The description of the Dataset.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The user-defined name of the Dataset. The name can be
	// up to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Customer-managed encryption key spec for a Dataset. If set,
	// this Dataset and all sub-resources of this Dataset will be secured by this
	// key.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Used to perform consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Datasets.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. No more than
	// 64 user labels can be associated with one Dataset (System labels are
	// excluded). See https://goo.gl/xmQnxf for more information and examples of
	// labels. System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable. Following system labels
	// exist for each Dataset: *
	// "aiplatform.googleapis.com/dataset_metadata_schema": output only, its value
	// is the metadata_schema's title.
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: Required. Additional information about the Dataset.
	Metadata interface{} `json:"metadata,omitempty"`
	// MetadataArtifact: Output only. The resource name of the Artifact that was
	// created in MetadataStore when creating the Dataset. The Artifact resource
	// name pattern is
	// `projects/{project}/locations/{location}/metadataStores/{metadata_store}/arti
	// facts/{artifact}`.
	MetadataArtifact string `json:"metadataArtifact,omitempty"`
	// MetadataSchemaUri: Required. Points to a YAML file stored on Google Cloud
	// Storage describing additional information about the Dataset. The schema is
	// defined as an OpenAPI 3.0.2 Schema Object. The schema files that can be used
	// here are found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
	MetadataSchemaUri string `json:"metadataSchemaUri,omitempty"`
	// ModelReference: Optional. Reference to the public base model last used by
	// the dataset. Only set for prompt datasets.
	ModelReference string `json:"modelReference,omitempty"`
	// Name: Output only. Identifier. The resource name of the Dataset. Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SavedQueries: All SavedQueries belong to the Dataset will be returned in
	// List/Get Dataset response. The annotation_specs field will not be populated
	// except for UI cases which will only use annotation_spec_count. In
	// CreateDataset request, a SavedQuery is created together if this field is
	// set, up to one SavedQuery can be set in CreateDatasetRequest. The SavedQuery
	// should not contain any AnnotationSpec.
	SavedQueries []*GoogleCloudAiplatformV1beta1SavedQuery `json:"savedQueries,omitempty"`
	// UpdateTime: Output only. Timestamp when this Dataset was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DatasetDistribution: Distribution computed over
// a tuning dataset.
type GoogleCloudAiplatformV1beta1DatasetDistribution struct {
	// Buckets: Output only. Defines the histogram bucket.
	Buckets []*GoogleCloudAiplatformV1beta1DatasetDistributionDistributionBucket `json:"buckets,omitempty"`
	// Max: Output only. The maximum of the population values.
	Max float64 `json:"max,omitempty"`
	// Mean: Output only. The arithmetic mean of the values in the population.
	Mean float64 `json:"mean,omitempty"`
	// Median: Output only. The median of the values in the population.
	Median float64 `json:"median,omitempty"`
	// Min: Output only. The minimum of the population values.
	Min float64 `json:"min,omitempty"`
	// P5: Output only. The 5th percentile of the values in the population.
	P5 float64 `json:"p5,omitempty"`
	// P95: Output only. The 95th percentile of the values in the population.
	P95 float64 `json:"p95,omitempty"`
	// Sum: Output only. Sum of a given population of values.
	Sum float64 `json:"sum,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buckets") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buckets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DatasetDistribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DatasetDistribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1DatasetDistribution) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1DatasetDistribution
	var s1 struct {
		Max    gensupport.JSONFloat64 `json:"max"`
		Mean   gensupport.JSONFloat64 `json:"mean"`
		Median gensupport.JSONFloat64 `json:"median"`
		Min    gensupport.JSONFloat64 `json:"min"`
		P5     gensupport.JSONFloat64 `json:"p5"`
		P95    gensupport.JSONFloat64 `json:"p95"`
		Sum    gensupport.JSONFloat64 `json:"sum"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Max = float64(s1.Max)
	s.Mean = float64(s1.Mean)
	s.Median = float64(s1.Median)
	s.Min = float64(s1.Min)
	s.P5 = float64(s1.P5)
	s.P95 = float64(s1.P95)
	s.Sum = float64(s1.Sum)
	return nil
}

// GoogleCloudAiplatformV1beta1DatasetDistributionDistributionBucket: Dataset
// bucket used to create a histogram for the distribution given a population of
// values.
type GoogleCloudAiplatformV1beta1DatasetDistributionDistributionBucket struct {
	// Count: Output only. Number of values in the bucket.
	Count int64 `json:"count,omitempty,string"`
	// Left: Output only. Left bound of the bucket.
	Left float64 `json:"left,omitempty"`
	// Right: Output only. Right bound of the bucket.
	Right float64 `json:"right,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DatasetDistributionDistributionBucket) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DatasetDistributionDistributionBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1DatasetDistributionDistributionBucket) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1DatasetDistributionDistributionBucket
	var s1 struct {
		Left  gensupport.JSONFloat64 `json:"left"`
		Right gensupport.JSONFloat64 `json:"right"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Left = float64(s1.Left)
	s.Right = float64(s1.Right)
	return nil
}

// GoogleCloudAiplatformV1beta1DatasetStats: Statistics computed over a tuning
// dataset.
type GoogleCloudAiplatformV1beta1DatasetStats struct {
	// TotalBillableCharacterCount: Output only. Number of billable characters in
	// the tuning dataset.
	TotalBillableCharacterCount int64 `json:"totalBillableCharacterCount,omitempty,string"`
	// TotalTuningCharacterCount: Output only. Number of tuning characters in the
	// tuning dataset.
	TotalTuningCharacterCount int64 `json:"totalTuningCharacterCount,omitempty,string"`
	// TuningDatasetExampleCount: Output only. Number of examples in the tuning
	// dataset.
	TuningDatasetExampleCount int64 `json:"tuningDatasetExampleCount,omitempty,string"`
	// TuningStepCount: Output only. Number of tuning steps for this Tuning Job.
	TuningStepCount int64 `json:"tuningStepCount,omitempty,string"`
	// UserDatasetExamples: Output only. Sample user messages in the training
	// dataset uri.
	UserDatasetExamples []*GoogleCloudAiplatformV1beta1Content `json:"userDatasetExamples,omitempty"`
	// UserInputTokenDistribution: Output only. Dataset distributions for the user
	// input tokens.
	UserInputTokenDistribution *GoogleCloudAiplatformV1beta1DatasetDistribution `json:"userInputTokenDistribution,omitempty"`
	// UserMessagePerExampleDistribution: Output only. Dataset distributions for
	// the messages per example.
	UserMessagePerExampleDistribution *GoogleCloudAiplatformV1beta1DatasetDistribution `json:"userMessagePerExampleDistribution,omitempty"`
	// UserOutputTokenDistribution: Output only. Dataset distributions for the user
	// output tokens.
	UserOutputTokenDistribution *GoogleCloudAiplatformV1beta1DatasetDistribution `json:"userOutputTokenDistribution,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "TotalBillableCharacterCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalBillableCharacterCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DatasetStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DatasetStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DatasetVersion: Describes the dataset version.
type GoogleCloudAiplatformV1beta1DatasetVersion struct {
	// BigQueryDatasetName: Output only. Name of the associated BigQuery dataset.
	BigQueryDatasetName string `json:"bigQueryDatasetName,omitempty"`
	// CreateTime: Output only. Timestamp when this DatasetVersion was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The user-defined name of the DatasetVersion. The name can be up
	// to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Used to perform consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Metadata: Required. Output only. Additional information about the
	// DatasetVersion.
	Metadata interface{} `json:"metadata,omitempty"`
	// ModelReference: Output only. Reference to the public base model last used by
	// the dataset version. Only set for prompt dataset versions.
	ModelReference string `json:"modelReference,omitempty"`
	// Name: Output only. Identifier. The resource name of the DatasetVersion.
	// Format:
	// `projects/{project}/locations/{location}/datasets/{dataset}/datasetVersions/{
	// dataset_version}`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// UpdateTime: Output only. Timestamp when this DatasetVersion was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BigQueryDatasetName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQueryDatasetName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DatasetVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DatasetVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DedicatedResources: A description of resources
// that are dedicated to a DeployedModel or DeployedIndex, and that need a
// higher degree of manual configuration.
type GoogleCloudAiplatformV1beta1DedicatedResources struct {
	// AutoscalingMetricSpecs: Immutable. The metric specifications that overrides
	// a resource utilization metric (CPU utilization, accelerator's duty cycle,
	// and so on) target value (default to 60 if not set). At most one entry is
	// allowed per metric. If machine_spec.accelerator_count is above 0, the
	// autoscaling will be based on both CPU utilization and accelerator's duty
	// cycle metrics and scale up when either metrics exceeds its target value
	// while scale down if both metrics are under their target value. The default
	// target value is 60 for both metrics. If machine_spec.accelerator_count is 0,
	// the autoscaling will be based on CPU utilization metric only with default
	// target value 60 if not explicitly set. For example, in the case of Online
	// Prediction, if you want to override target CPU utilization to 80, you should
	// set autoscaling_metric_specs.metric_name to
	// `aiplatform.googleapis.com/prediction/online/cpu/utilization` and
	// autoscaling_metric_specs.target to `80`.
	AutoscalingMetricSpecs []*GoogleCloudAiplatformV1beta1AutoscalingMetricSpec `json:"autoscalingMetricSpecs,omitempty"`
	// MachineSpec: Required. Immutable. The specification of a single machine
	// being used.
	MachineSpec *GoogleCloudAiplatformV1beta1MachineSpec `json:"machineSpec,omitempty"`
	// MaxReplicaCount: Immutable. The maximum number of replicas that may be
	// deployed on when the traffic against it increases. If the requested value is
	// too large, the deployment will error, but if deployment succeeds then the
	// ability to scale to that many replicas is guaranteed (barring service
	// outages). If traffic increases beyond what its replicas at maximum may
	// handle, a portion of the traffic will be dropped. If this value is not
	// provided, will use min_replica_count as the default value. The value of this
	// field impacts the charge against Vertex CPU and GPU quotas. Specifically,
	// you will be charged for (max_replica_count * number of cores in the selected
	// machine type) and (max_replica_count * number of GPUs per replica in the
	// selected machine type).
	MaxReplicaCount int64 `json:"maxReplicaCount,omitempty"`
	// MinReplicaCount: Required. Immutable. The minimum number of machine replicas
	// that will be always deployed on. This value must be greater than or equal to
	// 1. If traffic increases, it may dynamically be deployed onto more replicas,
	// and as traffic decreases, some of these extra replicas may be freed.
	MinReplicaCount int64 `json:"minReplicaCount,omitempty"`
	// RequiredReplicaCount: Optional. Number of required available replicas for
	// the deployment to succeed. This field is only needed when partial
	// deployment/mutation is desired. If set, the deploy/mutate operation will
	// succeed once available_replica_count reaches required_replica_count, and the
	// rest of the replicas will be retried. If not set, the default
	// required_replica_count will be min_replica_count.
	RequiredReplicaCount int64 `json:"requiredReplicaCount,omitempty"`
	// Spot: Optional. If true, schedule the deployment workload on spot VMs
	// (https://cloud.google.com/kubernetes-engine/docs/concepts/spot-vms).
	Spot bool `json:"spot,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoscalingMetricSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoscalingMetricSpecs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DedicatedResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DedicatedResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeleteFeatureValuesOperationMetadata: Details of
// operations that delete Feature values.
type GoogleCloudAiplatformV1beta1DeleteFeatureValuesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore delete Features values.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeleteFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeleteFeatureValuesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequest: Request message for
// FeaturestoreService.DeleteFeatureValues.
type GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequest struct {
	// SelectEntity: Select feature values to be deleted by specifying entities.
	SelectEntity *GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectEntity `json:"selectEntity,omitempty"`
	// SelectTimeRangeAndFeature: Select feature values to be deleted by specifying
	// time range and features.
	SelectTimeRangeAndFeature *GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectTimeRangeAndFeature `json:"selectTimeRangeAndFeature,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SelectEntity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SelectEntity") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectEntity: Message
// to select entity. If an entity id is selected, all the feature values
// corresponding to the entity id will be deleted, including the entityId.
type GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectEntity struct {
	// EntityIdSelector: Required. Selectors choosing feature values of which
	// entity id to be deleted from the EntityType.
	EntityIdSelector *GoogleCloudAiplatformV1beta1EntityIdSelector `json:"entityIdSelector,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityIdSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityIdSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectTimeRangeAndFeatu
// re: Message to select time range and feature. Values of the selected feature
// generated within an inclusive time range will be deleted. Using this option
// permanently deletes the feature values from the specified feature IDs within
// the specified time range. This might include data from the online storage.
// If you want to retain any deleted historical data in the online storage, you
// must re-ingest it.
type GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectTimeRangeAndFeature struct {
	// FeatureSelector: Required. Selectors choosing which feature values to be
	// deleted from the EntityType.
	FeatureSelector *GoogleCloudAiplatformV1beta1FeatureSelector `json:"featureSelector,omitempty"`
	// SkipOnlineStorageDelete: If set, data will not be deleted from online
	// storage. When time range is older than the data in online storage, setting
	// this to be true will make the deletion have no impact on online serving.
	SkipOnlineStorageDelete bool `json:"skipOnlineStorageDelete,omitempty"`
	// TimeRange: Required. Select feature generated within a half-inclusive time
	// range. The time range is lower inclusive and upper exclusive.
	TimeRange *GoogleTypeInterval `json:"timeRange,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeatureSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectTimeRangeAndFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeleteFeatureValuesRequestSelectTimeRangeAndFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponse: Response message
// for FeaturestoreService.DeleteFeatureValues.
type GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponse struct {
	// SelectEntity: Response for request specifying the entities to delete
	SelectEntity *GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectEntity `json:"selectEntity,omitempty"`
	// SelectTimeRangeAndFeature: Response for request specifying time range and
	// feature
	SelectTimeRangeAndFeature *GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectTimeRangeAndFeature `json:"selectTimeRangeAndFeature,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SelectEntity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SelectEntity") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectEntity:
// Response message if the request uses the SelectEntity option.
type GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectEntity struct {
	// OfflineStorageDeletedEntityRowCount: The count of deleted entity rows in the
	// offline storage. Each row corresponds to the combination of an entity ID and
	// a timestamp. One entity ID can have multiple rows in the offline storage.
	OfflineStorageDeletedEntityRowCount int64 `json:"offlineStorageDeletedEntityRowCount,omitempty,string"`
	// OnlineStorageDeletedEntityCount: The count of deleted entities in the online
	// storage. Each entity ID corresponds to one entity.
	OnlineStorageDeletedEntityCount int64 `json:"onlineStorageDeletedEntityCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g.
	// "OfflineStorageDeletedEntityRowCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "OfflineStorageDeletedEntityRowCount") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectTimeRangeAndFeat
// ure: Response message if the request uses the SelectTimeRangeAndFeature
// option.
type GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectTimeRangeAndFeature struct {
	// ImpactedFeatureCount: The count of the features or columns impacted. This is
	// the same as the feature count in the request.
	ImpactedFeatureCount int64 `json:"impactedFeatureCount,omitempty,string"`
	// OfflineStorageModifiedEntityRowCount: The count of modified entity rows in
	// the offline storage. Each row corresponds to the combination of an entity ID
	// and a timestamp. One entity ID can have multiple rows in the offline
	// storage. Within each row, only the features specified in the request are
	// deleted.
	OfflineStorageModifiedEntityRowCount int64 `json:"offlineStorageModifiedEntityRowCount,omitempty,string"`
	// OnlineStorageModifiedEntityCount: The count of modified entities in the
	// online storage. Each entity ID corresponds to one entity. Within each
	// entity, only the features specified in the request are deleted.
	OnlineStorageModifiedEntityCount int64 `json:"onlineStorageModifiedEntityCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ImpactedFeatureCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImpactedFeatureCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectTimeRangeAndFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeleteFeatureValuesResponseSelectTimeRangeAndFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeleteMetadataStoreOperationMetadata: Details of
// operations that perform MetadataService.DeleteMetadataStore.
type GoogleCloudAiplatformV1beta1DeleteMetadataStoreOperationMetadata struct {
	// GenericMetadata: Operation metadata for deleting a MetadataStore.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeleteMetadataStoreOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeleteMetadataStoreOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeleteOperationMetadata: Details of operations
// that perform deletes of any entities.
type GoogleCloudAiplatformV1beta1DeleteOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeleteOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeleteOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployIndexOperationMetadata: Runtime operation
// information for IndexEndpointService.DeployIndex.
type GoogleCloudAiplatformV1beta1DeployIndexOperationMetadata struct {
	// DeployedIndexId: The unique index id specified by user
	DeployedIndexId string `json:"deployedIndexId,omitempty"`
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedIndexId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedIndexId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployIndexOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployIndexOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployIndexRequest: Request message for
// IndexEndpointService.DeployIndex.
type GoogleCloudAiplatformV1beta1DeployIndexRequest struct {
	// DeployedIndex: Required. The DeployedIndex to be created within the
	// IndexEndpoint.
	DeployedIndex *GoogleCloudAiplatformV1beta1DeployedIndex `json:"deployedIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployIndexRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployIndexRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployIndexResponse: Response message for
// IndexEndpointService.DeployIndex.
type GoogleCloudAiplatformV1beta1DeployIndexResponse struct {
	// DeployedIndex: The DeployedIndex that had been deployed in the
	// IndexEndpoint.
	DeployedIndex *GoogleCloudAiplatformV1beta1DeployedIndex `json:"deployedIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployIndexResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployIndexResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployModelOperationMetadata: Runtime operation
// information for EndpointService.DeployModel.
type GoogleCloudAiplatformV1beta1DeployModelOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployModelRequest: Request message for
// EndpointService.DeployModel.
type GoogleCloudAiplatformV1beta1DeployModelRequest struct {
	// DeployedModel: Required. The DeployedModel to be created within the
	// Endpoint. Note that Endpoint.traffic_split must be updated for the
	// DeployedModel to start receiving traffic, either as part of this call, or
	// via EndpointService.UpdateEndpoint.
	DeployedModel *GoogleCloudAiplatformV1beta1DeployedModel `json:"deployedModel,omitempty"`
	// TrafficSplit: A map from a DeployedModel's ID to the percentage of this
	// Endpoint's traffic that should be forwarded to that DeployedModel. If this
	// field is non-empty, then the Endpoint's traffic_split will be overwritten
	// with it. To refer to the ID of the just being deployed Model, a "0" should
	// be used, and the actual ID of the new DeployedModel will be filled in its
	// place by this method. The traffic percentage values must add up to 100. If
	// this field is empty, then the Endpoint's traffic_split is not updated.
	TrafficSplit map[string]int64 `json:"trafficSplit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployModelResponse: Response message for
// EndpointService.DeployModel.
type GoogleCloudAiplatformV1beta1DeployModelResponse struct {
	// DeployedModel: The DeployedModel that had been deployed in the Endpoint.
	DeployedModel *GoogleCloudAiplatformV1beta1DeployedModel `json:"deployedModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedModel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployPublisherModelRequest: Request message for
// ModelGardenService.DeployPublisherModel.
type GoogleCloudAiplatformV1beta1DeployPublisherModelRequest struct {
	// AcceptEula: Optional. Whether the user accepts the End User License
	// Agreement (EULA) for the model.
	AcceptEula bool `json:"acceptEula,omitempty"`
	// DedicatedResources: Optional. The dedicated resources to use for the
	// endpoint. If not set, the default resources will be used.
	DedicatedResources *GoogleCloudAiplatformV1beta1DedicatedResources `json:"dedicatedResources,omitempty"`
	// EndpointDisplayName: Optional. The user-specified display name of the
	// endpoint. If not set, a default name will be used.
	EndpointDisplayName string `json:"endpointDisplayName,omitempty"`
	// HuggingFaceAccessToken: Optional. The Hugging Face read access token used to
	// access the model artifacts of gated models.
	HuggingFaceAccessToken string `json:"huggingFaceAccessToken,omitempty"`
	// Model: Required. The model to deploy. Format: 1.
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
	// 2. Hugging Face model ID like `google/gemma-2-2b-it`. 3. Custom model Google
	// Cloud Storage URI like `gs://bucket`. 4. Custom model zip file like
	// `https://example.com/a.zip`.
	Model string `json:"model,omitempty"`
	// ModelDisplayName: Optional. The user-specified display name of the uploaded
	// model. If not set, a default name will be used.
	ModelDisplayName string `json:"modelDisplayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptEula") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptEula") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployPublisherModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployPublisherModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployRequest: Request message for
// ModelGardenService.Deploy.
type GoogleCloudAiplatformV1beta1DeployRequest struct {
	// DeployConfig: Optional. The deploy config to use for the deployment. If not
	// specified, the default deploy config will be used.
	DeployConfig *GoogleCloudAiplatformV1beta1DeployRequestDeployConfig `json:"deployConfig,omitempty"`
	// EndpointConfig: Optional. The endpoint config to use for the deployment. If
	// not specified, the default endpoint config will be used.
	EndpointConfig *GoogleCloudAiplatformV1beta1DeployRequestEndpointConfig `json:"endpointConfig,omitempty"`
	// HuggingFaceModelId: The Hugging Face model to deploy. Format: Hugging Face
	// model ID like `google/gemma-2-2b-it`.
	HuggingFaceModelId string `json:"huggingFaceModelId,omitempty"`
	// ModelConfig: Optional. The model config to use for the deployment. If not
	// specified, the default model config will be used.
	ModelConfig *GoogleCloudAiplatformV1beta1DeployRequestModelConfig `json:"modelConfig,omitempty"`
	// PublisherModelName: The Model Garden model to deploy. Format:
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
	PublisherModelName string `json:"publisherModelName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployRequestDeployConfig: The deploy config to
// use for the deployment.
type GoogleCloudAiplatformV1beta1DeployRequestDeployConfig struct {
	// DedicatedResources: Optional. The dedicated resources to use for the
	// endpoint. If not set, the default resources will be used.
	DedicatedResources *GoogleCloudAiplatformV1beta1DedicatedResources `json:"dedicatedResources,omitempty"`
	// FastTryoutEnabled: Optional. If true, enable the QMT fast tryout feature for
	// this model if possible.
	FastTryoutEnabled bool `json:"fastTryoutEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DedicatedResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DedicatedResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployRequestDeployConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployRequestDeployConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployRequestEndpointConfig: The endpoint config
// to use for the deployment.
type GoogleCloudAiplatformV1beta1DeployRequestEndpointConfig struct {
	// DedicatedEndpointEnabled: Optional. If true, the endpoint will be exposed
	// through a dedicated DNS [Endpoint.dedicated_endpoint_dns]. Your request to
	// the dedicated DNS will be isolated from other users' traffic and will have
	// better performance and reliability. Note: Once you enabled dedicated
	// endpoint, you won't be able to send request to the shared DNS
	// {region}-aiplatform.googleapis.com. The limitations will be removed soon.
	DedicatedEndpointEnabled bool `json:"dedicatedEndpointEnabled,omitempty"`
	// EndpointDisplayName: Optional. The user-specified display name of the
	// endpoint. If not set, a default name will be used.
	EndpointDisplayName string `json:"endpointDisplayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DedicatedEndpointEnabled")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DedicatedEndpointEnabled") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployRequestEndpointConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployRequestEndpointConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployRequestModelConfig: The model config to
// use for the deployment.
type GoogleCloudAiplatformV1beta1DeployRequestModelConfig struct {
	// AcceptEula: Optional. Whether the user accepts the End User License
	// Agreement (EULA) for the model.
	AcceptEula bool `json:"acceptEula,omitempty"`
	// ContainerSpec: Optional. The specification of the container that is to be
	// used when deploying. If not set, the default container spec will be used.
	ContainerSpec *GoogleCloudAiplatformV1beta1ModelContainerSpec `json:"containerSpec,omitempty"`
	// HuggingFaceAccessToken: Optional. The Hugging Face read access token used to
	// access the model artifacts of gated models.
	HuggingFaceAccessToken string `json:"huggingFaceAccessToken,omitempty"`
	// HuggingFaceCacheEnabled: Optional. If true, the model will deploy with a
	// cached version instead of directly downloading the model artifacts from
	// Hugging Face. This is suitable for VPC-SC users with limited internet
	// access.
	HuggingFaceCacheEnabled bool `json:"huggingFaceCacheEnabled,omitempty"`
	// ModelDisplayName: Optional. The user-specified display name of the uploaded
	// model. If not set, a default name will be used.
	ModelDisplayName string `json:"modelDisplayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptEula") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptEula") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployRequestModelConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployRequestModelConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeploySolverOperationMetadata: Runtime operation
// information for SolverService.DeploySolver.
type GoogleCloudAiplatformV1beta1DeploySolverOperationMetadata struct {
	// GenericMetadata: The generic operation information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeploySolverOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeploySolverOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployedIndex: A deployment of an Index.
// IndexEndpoints contain one or more DeployedIndexes.
type GoogleCloudAiplatformV1beta1DeployedIndex struct {
	// AutomaticResources: Optional. A description of resources that the
	// DeployedIndex uses, which to large degree are decided by Vertex AI, and
	// optionally allows only a modest additional configuration. If
	// min_replica_count is not set, the default value is 2 (we don't provide SLA
	// when min_replica_count=1). If max_replica_count is not set, the default
	// value is min_replica_count. The max allowed replica count is 1000.
	AutomaticResources *GoogleCloudAiplatformV1beta1AutomaticResources `json:"automaticResources,omitempty"`
	// CreateTime: Output only. Timestamp when the DeployedIndex was created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedResources: Optional. A description of resources that are dedicated
	// to the DeployedIndex, and that need a higher degree of manual configuration.
	// The field min_replica_count must be set to a value strictly greater than 0,
	// or else validation will fail. We don't provide SLA when min_replica_count=1.
	// If max_replica_count is not set, the default value is min_replica_count. The
	// max allowed replica count is 1000. Available machine types for SMALL shard:
	// e2-standard-2 and all machine types available for MEDIUM and LARGE shard.
	// Available machine types for MEDIUM shard: e2-standard-16 and all machine
	// types available for LARGE shard. Available machine types for LARGE shard:
	// e2-highmem-16, n2d-standard-32. n1-standard-16 and n1-standard-32 are still
	// available, but we recommend e2-standard-16 and e2-highmem-16 for cost
	// efficiency.
	DedicatedResources *GoogleCloudAiplatformV1beta1DedicatedResources `json:"dedicatedResources,omitempty"`
	// DeployedIndexAuthConfig: Optional. If set, the authentication is enabled for
	// the private endpoint.
	DeployedIndexAuthConfig *GoogleCloudAiplatformV1beta1DeployedIndexAuthConfig `json:"deployedIndexAuthConfig,omitempty"`
	// DeploymentGroup: Optional. The deployment group can be no longer than 64
	// characters (eg: 'test', 'prod'). If not set, we will use the 'default'
	// deployment group. Creating `deployment_groups` with `reserved_ip_ranges` is
	// a recommended practice when the peered network has multiple peering ranges.
	// This creates your deployments from predictable IP spaces for easier traffic
	// administration. Also, one deployment_group (except 'default') can only be
	// used with the same reserved_ip_ranges which means if the deployment_group
	// has been used with reserved_ip_ranges: [a, b, c], using it with [a, b] or
	// [d, e] is disallowed. Note: we only support up to 5 deployment groups(not
	// including 'default').
	DeploymentGroup string `json:"deploymentGroup,omitempty"`
	// DisplayName: The display name of the DeployedIndex. If not provided upon
	// creation, the Index's display_name is used.
	DisplayName string `json:"displayName,omitempty"`
	// EnableAccessLogging: Optional. If true, private endpoint's access logs are
	// sent to Cloud Logging. These logs are like standard server access logs,
	// containing information like timestamp and latency for each MatchRequest.
	// Note that logs may incur a cost, especially if the deployed index receives a
	// high queries per second rate (QPS). Estimate your costs before enabling this
	// option.
	EnableAccessLogging bool `json:"enableAccessLogging,omitempty"`
	// Id: Required. The user specified ID of the DeployedIndex. The ID can be up
	// to 128 characters long and must start with a letter and only contain
	// letters, numbers, and underscores. The ID must be unique within the project
	// it is created in.
	Id string `json:"id,omitempty"`
	// Index: Required. The name of the Index this is the deployment of. We may
	// refer to this Index as the DeployedIndex's "original" Index.
	Index string `json:"index,omitempty"`
	// IndexSyncTime: Output only. The DeployedIndex may depend on various data on
	// its original Index. Additionally when certain changes to the original Index
	// are being done (e.g. when what the Index contains is being changed) the
	// DeployedIndex may be asynchronously updated in the background to reflect
	// these changes. If this timestamp's value is at least the Index.update_time
	// of the original Index, it means that this DeployedIndex and the original
	// Index are in sync. If this timestamp is older, then to see which updates
	// this DeployedIndex already contains (and which it does not), one must list
	// the operations that are running on the original Index. Only the successfully
	// completed Operations with update_time equal or before this sync time are
	// contained in this DeployedIndex.
	IndexSyncTime string `json:"indexSyncTime,omitempty"`
	// PrivateEndpoints: Output only. Provides paths for users to send requests
	// directly to the deployed index services running on Cloud via private
	// services access. This field is populated if network is configured.
	PrivateEndpoints *GoogleCloudAiplatformV1beta1IndexPrivateEndpoints `json:"privateEndpoints,omitempty"`
	// PscAutomationConfigs: Optional. If set for PSC deployed index, PSC
	// connection will be automatically created after deployment is done and the
	// endpoint information is populated in
	// private_endpoints.psc_automated_endpoints.
	PscAutomationConfigs []*GoogleCloudAiplatformV1beta1PSCAutomationConfig `json:"pscAutomationConfigs,omitempty"`
	// ReservedIpRanges: Optional. A list of reserved ip ranges under the VPC
	// network that can be used for this DeployedIndex. If set, we will deploy the
	// index within the provided ip ranges. Otherwise, the index might be deployed
	// to any ip ranges under the provided VPC network. The value should be the
	// name of the address
	// (https://cloud.google.com/compute/docs/reference/rest/v1/addresses) Example:
	// ['vertex-ai-ip-range']. For more information about subnets and network IP
	// ranges, please see
	// https://cloud.google.com/vpc/docs/subnets#manually_created_subnet_ip_ranges.
	ReservedIpRanges []string `json:"reservedIpRanges,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutomaticResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomaticResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployedIndex) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployedIndex
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployedIndexAuthConfig: Used to set up the auth
// on the DeployedIndex's private endpoint.
type GoogleCloudAiplatformV1beta1DeployedIndexAuthConfig struct {
	// AuthProvider: Defines the authentication provider that the DeployedIndex
	// uses.
	AuthProvider *GoogleCloudAiplatformV1beta1DeployedIndexAuthConfigAuthProvider `json:"authProvider,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthProvider") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthProvider") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployedIndexAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployedIndexAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployedIndexAuthConfigAuthProvider:
// Configuration for an authentication provider, including support for JSON Web
// Token (JWT)
// (https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
type GoogleCloudAiplatformV1beta1DeployedIndexAuthConfigAuthProvider struct {
	// AllowedIssuers: A list of allowed JWT issuers. Each entry must be a valid
	// Google service account, in the following format:
	// `service-account-name@project-id.iam.gserviceaccount.com`
	AllowedIssuers []string `json:"allowedIssuers,omitempty"`
	// Audiences: The list of JWT audiences
	// (https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
	// that are allowed to access. A JWT containing any of these audiences will be
	// accepted.
	Audiences []string `json:"audiences,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedIssuers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedIssuers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployedIndexAuthConfigAuthProvider) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployedIndexAuthConfigAuthProvider
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployedIndexRef: Points to a DeployedIndex.
type GoogleCloudAiplatformV1beta1DeployedIndexRef struct {
	// DeployedIndexId: Immutable. The ID of the DeployedIndex in the above
	// IndexEndpoint.
	DeployedIndexId string `json:"deployedIndexId,omitempty"`
	// DisplayName: Output only. The display name of the DeployedIndex.
	DisplayName string `json:"displayName,omitempty"`
	// IndexEndpoint: Immutable. A resource name of the IndexEndpoint.
	IndexEndpoint string `json:"indexEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedIndexId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedIndexId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployedIndexRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployedIndexRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployedModel: A deployment of a Model.
// Endpoints contain one or more DeployedModels.
type GoogleCloudAiplatformV1beta1DeployedModel struct {
	// AutomaticResources: A description of resources that to large degree are
	// decided by Vertex AI, and require only a modest additional configuration.
	AutomaticResources *GoogleCloudAiplatformV1beta1AutomaticResources `json:"automaticResources,omitempty"`
	// CreateTime: Output only. Timestamp when the DeployedModel was created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedResources: A description of resources that are dedicated to the
	// DeployedModel, and that need a higher degree of manual configuration.
	DedicatedResources *GoogleCloudAiplatformV1beta1DedicatedResources `json:"dedicatedResources,omitempty"`
	// DisableExplanations: If true, deploy the model without explainable feature,
	// regardless the existence of Model.explanation_spec or explanation_spec.
	DisableExplanations bool `json:"disableExplanations,omitempty"`
	// DisplayName: The display name of the DeployedModel. If not provided upon
	// creation, the Model's display_name is used.
	DisplayName string `json:"displayName,omitempty"`
	// EnableAccessLogging: If true, online prediction access logs are sent to
	// Cloud Logging. These logs are like standard server access logs, containing
	// information like timestamp and latency for each prediction request. Note
	// that logs may incur a cost, especially if your project receives prediction
	// requests at a high queries per second rate (QPS). Estimate your costs before
	// enabling this option.
	EnableAccessLogging bool `json:"enableAccessLogging,omitempty"`
	// EnableContainerLogging: If true, the container of the DeployedModel
	// instances will send `stderr` and `stdout` streams to Cloud Logging. Only
	// supported for custom-trained Models and AutoML Tabular Models.
	EnableContainerLogging bool `json:"enableContainerLogging,omitempty"`
	// ExplanationSpec: Explanation configuration for this DeployedModel. When
	// deploying a Model using EndpointService.DeployModel, this value overrides
	// the value of Model.explanation_spec. All fields of explanation_spec are
	// optional in the request. If a field of explanation_spec is not populated,
	// the value of the same field of Model.explanation_spec is inherited. If the
	// corresponding Model.explanation_spec is not populated, all fields of the
	// explanation_spec will be used for the explanation configuration.
	ExplanationSpec *GoogleCloudAiplatformV1beta1ExplanationSpec `json:"explanationSpec,omitempty"`
	// FasterDeploymentConfig: Configuration for faster model deployment.
	FasterDeploymentConfig *GoogleCloudAiplatformV1beta1FasterDeploymentConfig `json:"fasterDeploymentConfig,omitempty"`
	// Id: Immutable. The ID of the DeployedModel. If not provided upon deployment,
	// Vertex AI will generate a value for this ID. This value should be 1-10
	// characters, and valid characters are `/[0-9]/`.
	Id string `json:"id,omitempty"`
	// Model: Required. The resource name of the Model that this is the deployment
	// of. Note that the Model may be in a different location than the
	// DeployedModel's Endpoint. The resource name may contain version id or
	// version alias to specify the version. Example:
	// `projects/{project}/locations/{location}/models/{model}@2` or
	// `projects/{project}/locations/{location}/models/{model}@golden` if no
	// version is specified, the default version will be deployed.
	Model string `json:"model,omitempty"`
	// ModelVersionId: Output only. The version ID of the model that is deployed.
	ModelVersionId string `json:"modelVersionId,omitempty"`
	// PrivateEndpoints: Output only. Provide paths for users to send
	// predict/explain/health requests directly to the deployed model services
	// running on Cloud via private services access. This field is populated if
	// network is configured.
	PrivateEndpoints *GoogleCloudAiplatformV1beta1PrivateEndpoints `json:"privateEndpoints,omitempty"`
	// RolloutOptions: Options for configuring rolling deployments.
	RolloutOptions *GoogleCloudAiplatformV1beta1RolloutOptions `json:"rolloutOptions,omitempty"`
	// ServiceAccount: The service account that the DeployedModel's container runs
	// as. Specify the email address of the service account. If this service
	// account is not specified, the container runs as a service account that
	// doesn't have access to the resource project. Users deploying the Model must
	// have the `iam.serviceAccounts.actAs` permission on this service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// SharedResources: The resource name of the shared DeploymentResourcePool to
	// deploy on. Format:
	// `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_
	// resource_pool}`
	SharedResources string `json:"sharedResources,omitempty"`
	// SpeculativeDecodingSpec: Optional. Spec for configuring speculative
	// decoding.
	SpeculativeDecodingSpec *GoogleCloudAiplatformV1beta1SpeculativeDecodingSpec `json:"speculativeDecodingSpec,omitempty"`
	// Status: Output only. Runtime status of the deployed model.
	Status *GoogleCloudAiplatformV1beta1DeployedModelStatus `json:"status,omitempty"`
	// SystemLabels: System labels to apply to Model Garden deployments. System
	// labels are managed by Google for internal use only.
	SystemLabels map[string]string `json:"systemLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutomaticResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomaticResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployedModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployedModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployedModelRef: Points to a DeployedModel.
type GoogleCloudAiplatformV1beta1DeployedModelRef struct {
	// DeployedModelId: Immutable. An ID of a DeployedModel in the above Endpoint.
	DeployedModelId string `json:"deployedModelId,omitempty"`
	// Endpoint: Immutable. A resource name of an Endpoint.
	Endpoint string `json:"endpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedModelId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedModelId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployedModelRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployedModelRef
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeployedModelStatus: Runtime status of the
// deployed model.
type GoogleCloudAiplatformV1beta1DeployedModelStatus struct {
	// AvailableReplicaCount: Output only. The number of available replicas of the
	// deployed model.
	AvailableReplicaCount int64 `json:"availableReplicaCount,omitempty"`
	// LastUpdateTime: Output only. The time at which the status was last updated.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`
	// Message: Output only. The latest deployed model's status message (if any).
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvailableReplicaCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailableReplicaCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeployedModelStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeployedModelStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DeploymentResourcePool: A description of
// resources that can be shared by multiple DeployedModels, whose underlying
// specification consists of a DedicatedResources.
type GoogleCloudAiplatformV1beta1DeploymentResourcePool struct {
	// CreateTime: Output only. Timestamp when this DeploymentResourcePool was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedResources: Required. The underlying DedicatedResources that the
	// DeploymentResourcePool uses.
	DedicatedResources *GoogleCloudAiplatformV1beta1DedicatedResources `json:"dedicatedResources,omitempty"`
	// DisableContainerLogging: If the DeploymentResourcePool is deployed with
	// custom-trained Models or AutoML Tabular Models, the container(s) of the
	// DeploymentResourcePool will send `stderr` and `stdout` streams to Cloud
	// Logging by default. Please note that the logs incur cost, which are subject
	// to Cloud Logging pricing (https://cloud.google.com/logging/pricing). User
	// can disable container logging by setting this flag to true.
	DisableContainerLogging bool `json:"disableContainerLogging,omitempty"`
	// EncryptionSpec: Customer-managed encryption key spec for a
	// DeploymentResourcePool. If set, this DeploymentResourcePool will be secured
	// by this key. Endpoints and the DeploymentResourcePool they deploy in need to
	// have the same EncryptionSpec.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Name: Immutable. The resource name of the DeploymentResourcePool. Format:
	// `projects/{project}/locations/{location}/deploymentResourcePools/{deployment_
	// resource_pool}`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// ServiceAccount: The service account that the DeploymentResourcePool's
	// container(s) run as. Specify the email address of the service account. If
	// this service account is not specified, the container(s) run as a service
	// account that doesn't have access to the resource project. Users deploying
	// the Models to this DeploymentResourcePool must have the
	// `iam.serviceAccounts.actAs` permission on this service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DeploymentResourcePool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DeploymentResourcePool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1beta1DestinationFeatureSetting struct {
	// DestinationField: Specify the field name in the export destination. If not
	// specified, Feature ID is used.
	DestinationField string `json:"destinationField,omitempty"`
	// FeatureId: Required. The ID of the Feature to apply the setting to.
	FeatureId string `json:"featureId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationField") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationField") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DestinationFeatureSetting) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DestinationFeatureSetting
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DirectPredictRequest: Request message for
// PredictionService.DirectPredict.
type GoogleCloudAiplatformV1beta1DirectPredictRequest struct {
	// Inputs: The prediction input.
	Inputs []*GoogleCloudAiplatformV1beta1Tensor `json:"inputs,omitempty"`
	// Parameters: The parameters that govern the prediction.
	Parameters *GoogleCloudAiplatformV1beta1Tensor `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Inputs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Inputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DirectPredictRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DirectPredictRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DirectPredictResponse: Response message for
// PredictionService.DirectPredict.
type GoogleCloudAiplatformV1beta1DirectPredictResponse struct {
	// Outputs: The prediction output.
	Outputs []*GoogleCloudAiplatformV1beta1Tensor `json:"outputs,omitempty"`
	// Parameters: The parameters that govern the prediction.
	Parameters *GoogleCloudAiplatformV1beta1Tensor `json:"parameters,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Outputs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Outputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DirectPredictResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DirectPredictResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DirectRawPredictRequest: Request message for
// PredictionService.DirectRawPredict.
type GoogleCloudAiplatformV1beta1DirectRawPredictRequest struct {
	// Input: The prediction input.
	Input string `json:"input,omitempty"`
	// MethodName: Fully qualified name of the API method being invoked to perform
	// predictions. Format: `/namespace.Service/Method/` Example:
	// `/tensorflow.serving.PredictionService/Predict`
	MethodName string `json:"methodName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Input") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Input") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DirectRawPredictRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DirectRawPredictRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DirectRawPredictResponse: Response message for
// PredictionService.DirectRawPredict.
type GoogleCloudAiplatformV1beta1DirectRawPredictResponse struct {
	// Output: The prediction output.
	Output string `json:"output,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Output") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Output") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DirectRawPredictResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DirectRawPredictResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DirectUploadSource: The input content is
// encapsulated and uploaded in the request.
type GoogleCloudAiplatformV1beta1DirectUploadSource struct {
}

// GoogleCloudAiplatformV1beta1DiskSpec: Represents the spec of disk options.
type GoogleCloudAiplatformV1beta1DiskSpec struct {
	// BootDiskSizeGb: Size in GB of the boot disk (default is 100GB).
	BootDiskSizeGb int64 `json:"bootDiskSizeGb,omitempty"`
	// BootDiskType: Type of the boot disk. For non-A3U machines, the default value
	// is "pd-ssd", for A3U machines, the default value is "hyperdisk-balanced".
	// Valid values: "pd-ssd" (Persistent Disk Solid State Drive), "pd-standard"
	// (Persistent Disk Hard Disk Drive) or "hyperdisk-balanced".
	BootDiskType string `json:"bootDiskType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BootDiskSizeGb") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BootDiskSizeGb") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DiskSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DiskSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DistillationDataStats: Statistics computed for
// datasets used for distillation.
type GoogleCloudAiplatformV1beta1DistillationDataStats struct {
	// TrainingDatasetStats: Output only. Statistics computed for the training
	// dataset.
	TrainingDatasetStats *GoogleCloudAiplatformV1beta1DatasetStats `json:"trainingDatasetStats,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrainingDatasetStats") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrainingDatasetStats") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DistillationDataStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DistillationDataStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DistillationHyperParameters: Hyperparameters for
// Distillation.
type GoogleCloudAiplatformV1beta1DistillationHyperParameters struct {
	// AdapterSize: Optional. Adapter size for distillation.
	//
	// Possible values:
	//   "ADAPTER_SIZE_UNSPECIFIED" - Adapter size is unspecified.
	//   "ADAPTER_SIZE_ONE" - Adapter size 1.
	//   "ADAPTER_SIZE_TWO" - Adapter size 2.
	//   "ADAPTER_SIZE_FOUR" - Adapter size 4.
	//   "ADAPTER_SIZE_EIGHT" - Adapter size 8.
	//   "ADAPTER_SIZE_SIXTEEN" - Adapter size 16.
	//   "ADAPTER_SIZE_THIRTY_TWO" - Adapter size 32.
	AdapterSize string `json:"adapterSize,omitempty"`
	// EpochCount: Optional. Number of complete passes the model makes over the
	// entire training dataset during training.
	EpochCount int64 `json:"epochCount,omitempty,string"`
	// LearningRateMultiplier: Optional. Multiplier for adjusting the default
	// learning rate.
	LearningRateMultiplier float64 `json:"learningRateMultiplier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdapterSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdapterSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DistillationHyperParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DistillationHyperParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1DistillationHyperParameters) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1DistillationHyperParameters
	var s1 struct {
		LearningRateMultiplier gensupport.JSONFloat64 `json:"learningRateMultiplier"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LearningRateMultiplier = float64(s1.LearningRateMultiplier)
	return nil
}

// GoogleCloudAiplatformV1beta1DistillationSpec: Tuning Spec for Distillation.
type GoogleCloudAiplatformV1beta1DistillationSpec struct {
	// BaseTeacherModel: The base teacher model that is being distilled, e.g.,
	// "gemini-1.0-pro-002".
	BaseTeacherModel string `json:"baseTeacherModel,omitempty"`
	// HyperParameters: Optional. Hyperparameters for Distillation.
	HyperParameters *GoogleCloudAiplatformV1beta1DistillationHyperParameters `json:"hyperParameters,omitempty"`
	// PipelineRootDirectory: Deprecated. A path in a Cloud Storage bucket, which
	// will be treated as the root output directory of the distillation pipeline.
	// It is used by the system to generate the paths of output artifacts.
	PipelineRootDirectory string `json:"pipelineRootDirectory,omitempty"`
	// StudentModel: The student model that is being tuned, e.g.,
	// "google/gemma-2b-1.1-it". Deprecated. Use base_model instead.
	StudentModel string `json:"studentModel,omitempty"`
	// TrainingDatasetUri: Deprecated. Cloud Storage path to file containing
	// training dataset for tuning. The dataset must be formatted as a JSONL file.
	TrainingDatasetUri string `json:"trainingDatasetUri,omitempty"`
	// TunedTeacherModelSource: The resource name of the Tuned teacher model.
	// Format: `projects/{project}/locations/{location}/models/{model}`.
	TunedTeacherModelSource string `json:"tunedTeacherModelSource,omitempty"`
	// ValidationDatasetUri: Optional. Cloud Storage path to file containing
	// validation dataset for tuning. The dataset must be formatted as a JSONL
	// file.
	ValidationDatasetUri string `json:"validationDatasetUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseTeacherModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseTeacherModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DistillationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DistillationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1DoubleArray: A list of double values.
type GoogleCloudAiplatformV1beta1DoubleArray struct {
	// Values: A list of double values.
	Values []float64 `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DoubleArray) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DoubleArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1DoubleArray) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1DoubleArray
	var s1 struct {
		Values []gensupport.JSONFloat64 `json:"values"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Values = make([]float64, len(s1.Values))
	for i := range s1.Values {
		s.Values[i] = float64(s1.Values[i])
	}
	return nil
}

// GoogleCloudAiplatformV1beta1DynamicRetrievalConfig: Describes the options to
// customize dynamic retrieval.
type GoogleCloudAiplatformV1beta1DynamicRetrievalConfig struct {
	// DynamicThreshold: Optional. The threshold to be used in dynamic retrieval.
	// If not set, a system default value is used.
	DynamicThreshold float64 `json:"dynamicThreshold,omitempty"`
	// Mode: The mode of the predictor to be used in dynamic retrieval.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Always trigger retrieval.
	//   "MODE_DYNAMIC" - Run retrieval only when system decides it is necessary.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DynamicThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DynamicThreshold") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1DynamicRetrievalConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1DynamicRetrievalConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1DynamicRetrievalConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1DynamicRetrievalConfig
	var s1 struct {
		DynamicThreshold gensupport.JSONFloat64 `json:"dynamicThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DynamicThreshold = float64(s1.DynamicThreshold)
	return nil
}

// GoogleCloudAiplatformV1beta1EncryptionSpec: Represents a customer-managed
// encryption key spec that can be applied to a top-level resource.
type GoogleCloudAiplatformV1beta1EncryptionSpec struct {
	// KmsKeyName: Required. The Cloud KMS resource identifier of the customer
	// managed encryption key used to protect a resource. Has the form:
	// `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`.
	// The key needs to be in the same region as where the compute resource is
	// created.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKeyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Endpoint: Models are deployed into it, and
// afterwards Endpoint is called to obtain predictions and explanations.
type GoogleCloudAiplatformV1beta1Endpoint struct {
	// ClientConnectionConfig: Configurations that are applied to the endpoint for
	// online prediction.
	ClientConnectionConfig *GoogleCloudAiplatformV1beta1ClientConnectionConfig `json:"clientConnectionConfig,omitempty"`
	// CreateTime: Output only. Timestamp when this Endpoint was created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedEndpointDns: Output only. DNS of the dedicated endpoint. Will only
	// be populated if dedicated_endpoint_enabled is true. Depending on the
	// features enabled, uid might be a random number or a string. For example, if
	// fast_tryout is enabled, uid will be fasttryout. Format:
	// `https://{endpoint_id}.{region}-{uid}.prediction.vertexai.goog`.
	DedicatedEndpointDns string `json:"dedicatedEndpointDns,omitempty"`
	// DedicatedEndpointEnabled: If true, the endpoint will be exposed through a
	// dedicated DNS [Endpoint.dedicated_endpoint_dns]. Your request to the
	// dedicated DNS will be isolated from other users' traffic and will have
	// better performance and reliability. Note: Once you enabled dedicated
	// endpoint, you won't be able to send request to the shared DNS
	// {region}-aiplatform.googleapis.com. The limitation will be removed soon.
	DedicatedEndpointEnabled bool `json:"dedicatedEndpointEnabled,omitempty"`
	// DeployedModels: Output only. The models deployed in this Endpoint. To add or
	// remove DeployedModels use EndpointService.DeployModel and
	// EndpointService.UndeployModel respectively.
	DeployedModels []*GoogleCloudAiplatformV1beta1DeployedModel `json:"deployedModels,omitempty"`
	// Description: The description of the Endpoint.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the Endpoint. The name can be up
	// to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// EnablePrivateServiceConnect: Deprecated: If true, expose the Endpoint via
	// private service connect. Only one of the fields, network or
	// enable_private_service_connect, can be set.
	EnablePrivateServiceConnect bool `json:"enablePrivateServiceConnect,omitempty"`
	// EncryptionSpec: Customer-managed encryption key spec for an Endpoint. If
	// set, this Endpoint and all sub-resources of this Endpoint will be secured by
	// this key.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Used to perform consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// GenAiAdvancedFeaturesConfig: Optional. Configuration for
	// GenAiAdvancedFeatures. If the endpoint is serving GenAI models, advanced
	// features like native RAG integration can be configured. Currently, only
	// Model Garden models are supported.
	GenAiAdvancedFeaturesConfig *GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfig `json:"genAiAdvancedFeaturesConfig,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Endpoints.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. See
	// https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// ModelDeploymentMonitoringJob: Output only. Resource name of the Model
	// Monitoring job associated with this Endpoint if monitoring is enabled by
	// JobService.CreateModelDeploymentMonitoringJob. Format:
	// `projects/{project}/locations/{location}/modelDeploymentMonitoringJobs/{model
	// _deployment_monitoring_job}`
	ModelDeploymentMonitoringJob string `json:"modelDeploymentMonitoringJob,omitempty"`
	// Name: Output only. The resource name of the Endpoint.
	Name string `json:"name,omitempty"`
	// Network: Optional. The full name of the Google Compute Engine network
	// (https://cloud.google.com//compute/docs/networks-and-firewalls#networks) to
	// which the Endpoint should be peered. Private services access must already be
	// configured for the network. If left unspecified, the Endpoint is not peered
	// with any network. Only one of the fields, network or
	// enable_private_service_connect, can be set. Format
	// (https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
	// `projects/{project}/global/networks/{network}`. Where `{project}` is a
	// project number, as in `12345`, and `{network}` is network name.
	Network string `json:"network,omitempty"`
	// PredictRequestResponseLoggingConfig: Configures the request-response logging
	// for online prediction.
	PredictRequestResponseLoggingConfig *GoogleCloudAiplatformV1beta1PredictRequestResponseLoggingConfig `json:"predictRequestResponseLoggingConfig,omitempty"`
	// PrivateServiceConnectConfig: Optional. Configuration for private service
	// connect. network and private_service_connect_config are mutually exclusive.
	PrivateServiceConnectConfig *GoogleCloudAiplatformV1beta1PrivateServiceConnectConfig `json:"privateServiceConnectConfig,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// TrafficSplit: A map from a DeployedModel's ID to the percentage of this
	// Endpoint's traffic that should be forwarded to that DeployedModel. If a
	// DeployedModel's ID is not listed in this map, then it receives no traffic.
	// The traffic percentage values must add up to 100, or map must be empty if
	// the Endpoint is to not accept any traffic at a moment.
	TrafficSplit map[string]int64 `json:"trafficSplit,omitempty"`
	// UpdateTime: Output only. Timestamp when this Endpoint was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClientConnectionConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientConnectionConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Endpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Endpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1EnterpriseWebSearch: Tool to search public web
// data, powered by Vertex AI Search and Sec4 compliance.
type GoogleCloudAiplatformV1beta1EnterpriseWebSearch struct {
}

// GoogleCloudAiplatformV1beta1EntityIdSelector: Selector for entityId. Getting
// ids from the given source.
type GoogleCloudAiplatformV1beta1EntityIdSelector struct {
	// CsvSource: Source of Csv
	CsvSource *GoogleCloudAiplatformV1beta1CsvSource `json:"csvSource,omitempty"`
	// EntityIdField: Source column that holds entity IDs. If not provided, entity
	// IDs are extracted from the column named entity_id.
	EntityIdField string `json:"entityIdField,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CsvSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CsvSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EntityIdSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EntityIdSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1EntityType: An entity type is a type of object
// in a system that needs to be modeled and have stored information about. For
// example, driver is an entity type, and driver0 is an instance of an entity
// type driver.
type GoogleCloudAiplatformV1beta1EntityType struct {
	// CreateTime: Output only. Timestamp when this EntityType was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the EntityType.
	Description string `json:"description,omitempty"`
	// Etag: Optional. Used to perform a consistent read-modify-write updates. If
	// not set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// EntityTypes. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one EntityType (System
	// labels are excluded)." System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// MonitoringConfig: Optional. The default monitoring configuration for all
	// Features with value type (Feature.ValueType) BOOL, STRING, DOUBLE or INT64
	// under this EntityType. If this is populated with
	// [FeaturestoreMonitoringConfig.monitoring_interval] specified, snapshot
	// analysis monitoring is enabled. Otherwise, snapshot analysis monitoring is
	// disabled.
	MonitoringConfig *GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfig `json:"monitoringConfig,omitempty"`
	// Name: Immutable. Name of the EntityType. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityT
	// ypes/{entity_type}` The last part entity_type is assigned by the client. The
	// entity_type can be up to 64 characters long and can consist only of ASCII
	// Latin letters A-Z and a-z and underscore(_), and ASCII digits 0-9 starting
	// with a letter. The value will be unique given a featurestore.
	Name string `json:"name,omitempty"`
	// OfflineStorageTtlDays: Optional. Config for data retention policy in offline
	// storage. TTL in days for feature values that will be stored in offline
	// storage. The Feature Store offline storage periodically removes obsolete
	// feature values older than `offline_storage_ttl_days` since the feature
	// generation time. If unset (or explicitly set to 0), default to 4000 days
	// TTL.
	OfflineStorageTtlDays int64 `json:"offlineStorageTtlDays,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// UpdateTime: Output only. Timestamp when this EntityType was most recently
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1EnvVar: Represents an environment variable
// present in a Container or Python Module.
type GoogleCloudAiplatformV1beta1EnvVar struct {
	// Name: Required. Name of the environment variable. Must be a valid C
	// identifier.
	Name string `json:"name,omitempty"`
	// Value: Required. Variables that reference a $(VAR_NAME) are expanded using
	// the previous defined environment variables in the container and any service
	// environment variables. If a variable cannot be resolved, the reference in
	// the input string will be unchanged. The $(VAR_NAME) syntax can be escaped
	// with a double $$, ie: $$(VAR_NAME). Escaped references will never be
	// expanded, regardless of whether the variable exists or not.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EnvVar) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EnvVar
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotation: Model error analysis
// for each annotation.
type GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotation struct {
	// AttributedItems: Attributed items for a given annotation, typically
	// representing neighbors from the training sets constrained by the query type.
	AttributedItems []*GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotationAttributedItem `json:"attributedItems,omitempty"`
	// OutlierScore: The outlier score of this annotated item. Usually defined as
	// the min of all distances from attributed items.
	OutlierScore float64 `json:"outlierScore,omitempty"`
	// OutlierThreshold: The threshold used to determine if this annotation is an
	// outlier or not.
	OutlierThreshold float64 `json:"outlierThreshold,omitempty"`
	// QueryType: The query type used for finding the attributed items.
	//
	// Possible values:
	//   "QUERY_TYPE_UNSPECIFIED" - Unspecified query type for model error
	// analysis.
	//   "ALL_SIMILAR" - Query similar samples across all classes in the dataset.
	//   "SAME_CLASS_SIMILAR" - Query similar samples from the same class of the
	// input sample.
	//   "SAME_CLASS_DISSIMILAR" - Query dissimilar samples from the same class of
	// the input sample.
	QueryType string `json:"queryType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributedItems") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributedItems") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotation) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotation
	var s1 struct {
		OutlierScore     gensupport.JSONFloat64 `json:"outlierScore"`
		OutlierThreshold gensupport.JSONFloat64 `json:"outlierThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.OutlierScore = float64(s1.OutlierScore)
	s.OutlierThreshold = float64(s1.OutlierThreshold)
	return nil
}

// GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotationAttributedItem:
// Attributed items for a given annotation, typically representing neighbors
// from the training sets constrained by the query type.
type GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotationAttributedItem struct {
	// AnnotationResourceName: The unique ID for each annotation. Used by FE to
	// allocate the annotation in DB.
	AnnotationResourceName string `json:"annotationResourceName,omitempty"`
	// Distance: The distance of this item to the annotation.
	Distance float64 `json:"distance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationResourceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationResourceName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotationAttributedItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotationAttributedItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotationAttributedItem) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotationAttributedItem
	var s1 struct {
		Distance gensupport.JSONFloat64 `json:"distance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Distance = float64(s1.Distance)
	return nil
}

// GoogleCloudAiplatformV1beta1EvaluateDatasetRequest: Request message for
// EvaluationService.EvaluateDataset.
type GoogleCloudAiplatformV1beta1EvaluateDatasetRequest struct {
	// AutoraterConfig: Optional. Autorater config used for evaluation. Currently
	// only publisher Gemini models are supported. Format:
	// `projects/{PROJECT}/locations/{LOCATION}/publishers/google/models/{MODEL}.`
	AutoraterConfig *GoogleCloudAiplatformV1beta1AutoraterConfig `json:"autoraterConfig,omitempty"`
	// Dataset: Required. The dataset used for evaluation.
	Dataset *GoogleCloudAiplatformV1beta1EvaluationDataset `json:"dataset,omitempty"`
	// Metrics: Required. The metrics used for evaluation.
	Metrics []*GoogleCloudAiplatformV1beta1Metric `json:"metrics,omitempty"`
	// OutputConfig: Required. Config for evaluation output.
	OutputConfig *GoogleCloudAiplatformV1beta1OutputConfig `json:"outputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoraterConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoraterConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EvaluateDatasetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EvaluateDatasetRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1EvaluateInstancesRequest: Request message for
// EvaluationService.EvaluateInstances.
type GoogleCloudAiplatformV1beta1EvaluateInstancesRequest struct {
	// AutoraterConfig: Optional. Autorater config used for evaluation.
	AutoraterConfig *GoogleCloudAiplatformV1beta1AutoraterConfig `json:"autoraterConfig,omitempty"`
	// BleuInput: Instances and metric spec for bleu metric.
	BleuInput *GoogleCloudAiplatformV1beta1BleuInput `json:"bleuInput,omitempty"`
	// CoherenceInput: Input for coherence metric.
	CoherenceInput *GoogleCloudAiplatformV1beta1CoherenceInput `json:"coherenceInput,omitempty"`
	// CometInput: Translation metrics. Input for Comet metric.
	CometInput *GoogleCloudAiplatformV1beta1CometInput `json:"cometInput,omitempty"`
	// ExactMatchInput: Auto metric instances. Instances and metric spec for exact
	// match metric.
	ExactMatchInput *GoogleCloudAiplatformV1beta1ExactMatchInput `json:"exactMatchInput,omitempty"`
	// FluencyInput: LLM-based metric instance. General text generation metrics,
	// applicable to other categories. Input for fluency metric.
	FluencyInput *GoogleCloudAiplatformV1beta1FluencyInput `json:"fluencyInput,omitempty"`
	// FulfillmentInput: Input for fulfillment metric.
	FulfillmentInput *GoogleCloudAiplatformV1beta1FulfillmentInput `json:"fulfillmentInput,omitempty"`
	// GroundednessInput: Input for groundedness metric.
	GroundednessInput *GoogleCloudAiplatformV1beta1GroundednessInput `json:"groundednessInput,omitempty"`
	// MetricxInput: Input for Metricx metric.
	MetricxInput *GoogleCloudAiplatformV1beta1MetricxInput `json:"metricxInput,omitempty"`
	// PairwiseMetricInput: Input for pairwise metric.
	PairwiseMetricInput *GoogleCloudAiplatformV1beta1PairwiseMetricInput `json:"pairwiseMetricInput,omitempty"`
	// PairwiseQuestionAnsweringQualityInput: Input for pairwise question answering
	// quality metric.
	PairwiseQuestionAnsweringQualityInput *GoogleCloudAiplatformV1beta1PairwiseQuestionAnsweringQualityInput `json:"pairwiseQuestionAnsweringQualityInput,omitempty"`
	// PairwiseSummarizationQualityInput: Input for pairwise summarization quality
	// metric.
	PairwiseSummarizationQualityInput *GoogleCloudAiplatformV1beta1PairwiseSummarizationQualityInput `json:"pairwiseSummarizationQualityInput,omitempty"`
	// PointwiseMetricInput: Input for pointwise metric.
	PointwiseMetricInput *GoogleCloudAiplatformV1beta1PointwiseMetricInput `json:"pointwiseMetricInput,omitempty"`
	// QuestionAnsweringCorrectnessInput: Input for question answering correctness
	// metric.
	QuestionAnsweringCorrectnessInput *GoogleCloudAiplatformV1beta1QuestionAnsweringCorrectnessInput `json:"questionAnsweringCorrectnessInput,omitempty"`
	// QuestionAnsweringHelpfulnessInput: Input for question answering helpfulness
	// metric.
	QuestionAnsweringHelpfulnessInput *GoogleCloudAiplatformV1beta1QuestionAnsweringHelpfulnessInput `json:"questionAnsweringHelpfulnessInput,omitempty"`
	// QuestionAnsweringQualityInput: Input for question answering quality metric.
	QuestionAnsweringQualityInput *GoogleCloudAiplatformV1beta1QuestionAnsweringQualityInput `json:"questionAnsweringQualityInput,omitempty"`
	// QuestionAnsweringRelevanceInput: Input for question answering relevance
	// metric.
	QuestionAnsweringRelevanceInput *GoogleCloudAiplatformV1beta1QuestionAnsweringRelevanceInput `json:"questionAnsweringRelevanceInput,omitempty"`
	// RougeInput: Instances and metric spec for rouge metric.
	RougeInput *GoogleCloudAiplatformV1beta1RougeInput `json:"rougeInput,omitempty"`
	// RubricBasedInstructionFollowingInput: Rubric Based Instruction Following
	// metric.
	RubricBasedInstructionFollowingInput *GoogleCloudAiplatformV1beta1RubricBasedInstructionFollowingInput `json:"rubricBasedInstructionFollowingInput,omitempty"`
	// SafetyInput: Input for safety metric.
	SafetyInput *GoogleCloudAiplatformV1beta1SafetyInput `json:"safetyInput,omitempty"`
	// SummarizationHelpfulnessInput: Input for summarization helpfulness metric.
	SummarizationHelpfulnessInput *GoogleCloudAiplatformV1beta1SummarizationHelpfulnessInput `json:"summarizationHelpfulnessInput,omitempty"`
	// SummarizationQualityInput: Input for summarization quality metric.
	SummarizationQualityInput *GoogleCloudAiplatformV1beta1SummarizationQualityInput `json:"summarizationQualityInput,omitempty"`
	// SummarizationVerbosityInput: Input for summarization verbosity metric.
	SummarizationVerbosityInput *GoogleCloudAiplatformV1beta1SummarizationVerbosityInput `json:"summarizationVerbosityInput,omitempty"`
	// ToolCallValidInput: Tool call metric instances. Input for tool call valid
	// metric.
	ToolCallValidInput *GoogleCloudAiplatformV1beta1ToolCallValidInput `json:"toolCallValidInput,omitempty"`
	// ToolNameMatchInput: Input for tool name match metric.
	ToolNameMatchInput *GoogleCloudAiplatformV1beta1ToolNameMatchInput `json:"toolNameMatchInput,omitempty"`
	// ToolParameterKeyMatchInput: Input for tool parameter key match metric.
	ToolParameterKeyMatchInput *GoogleCloudAiplatformV1beta1ToolParameterKeyMatchInput `json:"toolParameterKeyMatchInput,omitempty"`
	// ToolParameterKvMatchInput: Input for tool parameter key value match metric.
	ToolParameterKvMatchInput *GoogleCloudAiplatformV1beta1ToolParameterKVMatchInput `json:"toolParameterKvMatchInput,omitempty"`
	// TrajectoryAnyOrderMatchInput: Input for trajectory match any order metric.
	TrajectoryAnyOrderMatchInput *GoogleCloudAiplatformV1beta1TrajectoryAnyOrderMatchInput `json:"trajectoryAnyOrderMatchInput,omitempty"`
	// TrajectoryExactMatchInput: Input for trajectory exact match metric.
	TrajectoryExactMatchInput *GoogleCloudAiplatformV1beta1TrajectoryExactMatchInput `json:"trajectoryExactMatchInput,omitempty"`
	// TrajectoryInOrderMatchInput: Input for trajectory in order match metric.
	TrajectoryInOrderMatchInput *GoogleCloudAiplatformV1beta1TrajectoryInOrderMatchInput `json:"trajectoryInOrderMatchInput,omitempty"`
	// TrajectoryPrecisionInput: Input for trajectory precision metric.
	TrajectoryPrecisionInput *GoogleCloudAiplatformV1beta1TrajectoryPrecisionInput `json:"trajectoryPrecisionInput,omitempty"`
	// TrajectoryRecallInput: Input for trajectory recall metric.
	TrajectoryRecallInput *GoogleCloudAiplatformV1beta1TrajectoryRecallInput `json:"trajectoryRecallInput,omitempty"`
	// TrajectorySingleToolUseInput: Input for trajectory single tool use metric.
	TrajectorySingleToolUseInput *GoogleCloudAiplatformV1beta1TrajectorySingleToolUseInput `json:"trajectorySingleToolUseInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoraterConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoraterConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EvaluateInstancesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EvaluateInstancesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1EvaluateInstancesResponse: Response message for
// EvaluationService.EvaluateInstances.
type GoogleCloudAiplatformV1beta1EvaluateInstancesResponse struct {
	// BleuResults: Results for bleu metric.
	BleuResults *GoogleCloudAiplatformV1beta1BleuResults `json:"bleuResults,omitempty"`
	// CoherenceResult: Result for coherence metric.
	CoherenceResult *GoogleCloudAiplatformV1beta1CoherenceResult `json:"coherenceResult,omitempty"`
	// CometResult: Translation metrics. Result for Comet metric.
	CometResult *GoogleCloudAiplatformV1beta1CometResult `json:"cometResult,omitempty"`
	// ExactMatchResults: Auto metric evaluation results. Results for exact match
	// metric.
	ExactMatchResults *GoogleCloudAiplatformV1beta1ExactMatchResults `json:"exactMatchResults,omitempty"`
	// FluencyResult: LLM-based metric evaluation result. General text generation
	// metrics, applicable to other categories. Result for fluency metric.
	FluencyResult *GoogleCloudAiplatformV1beta1FluencyResult `json:"fluencyResult,omitempty"`
	// FulfillmentResult: Result for fulfillment metric.
	FulfillmentResult *GoogleCloudAiplatformV1beta1FulfillmentResult `json:"fulfillmentResult,omitempty"`
	// GroundednessResult: Result for groundedness metric.
	GroundednessResult *GoogleCloudAiplatformV1beta1GroundednessResult `json:"groundednessResult,omitempty"`
	// MetricxResult: Result for Metricx metric.
	MetricxResult *GoogleCloudAiplatformV1beta1MetricxResult `json:"metricxResult,omitempty"`
	// PairwiseMetricResult: Result for pairwise metric.
	PairwiseMetricResult *GoogleCloudAiplatformV1beta1PairwiseMetricResult `json:"pairwiseMetricResult,omitempty"`
	// PairwiseQuestionAnsweringQualityResult: Result for pairwise question
	// answering quality metric.
	PairwiseQuestionAnsweringQualityResult *GoogleCloudAiplatformV1beta1PairwiseQuestionAnsweringQualityResult `json:"pairwiseQuestionAnsweringQualityResult,omitempty"`
	// PairwiseSummarizationQualityResult: Result for pairwise summarization
	// quality metric.
	PairwiseSummarizationQualityResult *GoogleCloudAiplatformV1beta1PairwiseSummarizationQualityResult `json:"pairwiseSummarizationQualityResult,omitempty"`
	// PointwiseMetricResult: Generic metrics. Result for pointwise metric.
	PointwiseMetricResult *GoogleCloudAiplatformV1beta1PointwiseMetricResult `json:"pointwiseMetricResult,omitempty"`
	// QuestionAnsweringCorrectnessResult: Result for question answering
	// correctness metric.
	QuestionAnsweringCorrectnessResult *GoogleCloudAiplatformV1beta1QuestionAnsweringCorrectnessResult `json:"questionAnsweringCorrectnessResult,omitempty"`
	// QuestionAnsweringHelpfulnessResult: Result for question answering
	// helpfulness metric.
	QuestionAnsweringHelpfulnessResult *GoogleCloudAiplatformV1beta1QuestionAnsweringHelpfulnessResult `json:"questionAnsweringHelpfulnessResult,omitempty"`
	// QuestionAnsweringQualityResult: Question answering only metrics. Result for
	// question answering quality metric.
	QuestionAnsweringQualityResult *GoogleCloudAiplatformV1beta1QuestionAnsweringQualityResult `json:"questionAnsweringQualityResult,omitempty"`
	// QuestionAnsweringRelevanceResult: Result for question answering relevance
	// metric.
	QuestionAnsweringRelevanceResult *GoogleCloudAiplatformV1beta1QuestionAnsweringRelevanceResult `json:"questionAnsweringRelevanceResult,omitempty"`
	// RougeResults: Results for rouge metric.
	RougeResults *GoogleCloudAiplatformV1beta1RougeResults `json:"rougeResults,omitempty"`
	// RubricBasedInstructionFollowingResult: Result for rubric based instruction
	// following metric.
	RubricBasedInstructionFollowingResult *GoogleCloudAiplatformV1beta1RubricBasedInstructionFollowingResult `json:"rubricBasedInstructionFollowingResult,omitempty"`
	// SafetyResult: Result for safety metric.
	SafetyResult *GoogleCloudAiplatformV1beta1SafetyResult `json:"safetyResult,omitempty"`
	// SummarizationHelpfulnessResult: Result for summarization helpfulness metric.
	SummarizationHelpfulnessResult *GoogleCloudAiplatformV1beta1SummarizationHelpfulnessResult `json:"summarizationHelpfulnessResult,omitempty"`
	// SummarizationQualityResult: Summarization only metrics. Result for
	// summarization quality metric.
	SummarizationQualityResult *GoogleCloudAiplatformV1beta1SummarizationQualityResult `json:"summarizationQualityResult,omitempty"`
	// SummarizationVerbosityResult: Result for summarization verbosity metric.
	SummarizationVerbosityResult *GoogleCloudAiplatformV1beta1SummarizationVerbosityResult `json:"summarizationVerbosityResult,omitempty"`
	// ToolCallValidResults: Tool call metrics. Results for tool call valid metric.
	ToolCallValidResults *GoogleCloudAiplatformV1beta1ToolCallValidResults `json:"toolCallValidResults,omitempty"`
	// ToolNameMatchResults: Results for tool name match metric.
	ToolNameMatchResults *GoogleCloudAiplatformV1beta1ToolNameMatchResults `json:"toolNameMatchResults,omitempty"`
	// ToolParameterKeyMatchResults: Results for tool parameter key match metric.
	ToolParameterKeyMatchResults *GoogleCloudAiplatformV1beta1ToolParameterKeyMatchResults `json:"toolParameterKeyMatchResults,omitempty"`
	// ToolParameterKvMatchResults: Results for tool parameter key value match
	// metric.
	ToolParameterKvMatchResults *GoogleCloudAiplatformV1beta1ToolParameterKVMatchResults `json:"toolParameterKvMatchResults,omitempty"`
	// TrajectoryAnyOrderMatchResults: Result for trajectory any order match
	// metric.
	TrajectoryAnyOrderMatchResults *GoogleCloudAiplatformV1beta1TrajectoryAnyOrderMatchResults `json:"trajectoryAnyOrderMatchResults,omitempty"`
	// TrajectoryExactMatchResults: Result for trajectory exact match metric.
	TrajectoryExactMatchResults *GoogleCloudAiplatformV1beta1TrajectoryExactMatchResults `json:"trajectoryExactMatchResults,omitempty"`
	// TrajectoryInOrderMatchResults: Result for trajectory in order match metric.
	TrajectoryInOrderMatchResults *GoogleCloudAiplatformV1beta1TrajectoryInOrderMatchResults `json:"trajectoryInOrderMatchResults,omitempty"`
	// TrajectoryPrecisionResults: Result for trajectory precision metric.
	TrajectoryPrecisionResults *GoogleCloudAiplatformV1beta1TrajectoryPrecisionResults `json:"trajectoryPrecisionResults,omitempty"`
	// TrajectoryRecallResults: Results for trajectory recall metric.
	TrajectoryRecallResults *GoogleCloudAiplatformV1beta1TrajectoryRecallResults `json:"trajectoryRecallResults,omitempty"`
	// TrajectorySingleToolUseResults: Results for trajectory single tool use
	// metric.
	TrajectorySingleToolUseResults *GoogleCloudAiplatformV1beta1TrajectorySingleToolUseResults `json:"trajectorySingleToolUseResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BleuResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BleuResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EvaluateInstancesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EvaluateInstancesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1EvaluatedAnnotation: True positive, false
// positive, or false negative. EvaluatedAnnotation is only available under
// ModelEvaluationSlice with slice of `annotationSpec` dimension.
type GoogleCloudAiplatformV1beta1EvaluatedAnnotation struct {
	// DataItemPayload: Output only. The data item payload that the Model predicted
	// this EvaluatedAnnotation on.
	DataItemPayload interface{} `json:"dataItemPayload,omitempty"`
	// ErrorAnalysisAnnotations: Annotations of model error analysis results.
	ErrorAnalysisAnnotations []*GoogleCloudAiplatformV1beta1ErrorAnalysisAnnotation `json:"errorAnalysisAnnotations,omitempty"`
	// EvaluatedDataItemViewId: Output only. ID of the EvaluatedDataItemView under
	// the same ancestor ModelEvaluation. The EvaluatedDataItemView consists of all
	// ground truths and predictions on data_item_payload.
	EvaluatedDataItemViewId string `json:"evaluatedDataItemViewId,omitempty"`
	// Explanations: Explanations of predictions. Each element of the explanations
	// indicates the explanation for one explanation Method. The attributions list
	// in the EvaluatedAnnotationExplanation.explanation object corresponds to the
	// predictions list. For example, the second element in the attributions list
	// explains the second element in the predictions list.
	Explanations []*GoogleCloudAiplatformV1beta1EvaluatedAnnotationExplanation `json:"explanations,omitempty"`
	// GroundTruths: Output only. The ground truth Annotations, i.e. the
	// Annotations that exist in the test data the Model is evaluated on. For true
	// positive, there is one and only one ground truth annotation, which matches
	// the only prediction in predictions. For false positive, there are zero or
	// more ground truth annotations that are similar to the only prediction in
	// predictions, but not enough for a match. For false negative, there is one
	// and only one ground truth annotation, which doesn't match any predictions
	// created by the model. The schema of the ground truth is stored in
	// ModelEvaluation.annotation_schema_uri
	GroundTruths []interface{} `json:"groundTruths,omitempty"`
	// Predictions: Output only. The model predicted annotations. For true
	// positive, there is one and only one prediction, which matches the only one
	// ground truth annotation in ground_truths. For false positive, there is one
	// and only one prediction, which doesn't match any ground truth annotation of
	// the corresponding data_item_view_id. For false negative, there are zero or
	// more predictions which are similar to the only ground truth annotation in
	// ground_truths but not enough for a match. The schema of the prediction is
	// stored in ModelEvaluation.annotation_schema_uri
	Predictions []interface{} `json:"predictions,omitempty"`
	// Type: Output only. Type of the EvaluatedAnnotation.
	//
	// Possible values:
	//   "EVALUATED_ANNOTATION_TYPE_UNSPECIFIED" - Invalid value.
	//   "TRUE_POSITIVE" - The EvaluatedAnnotation is a true positive. It has a
	// prediction created by the Model and a ground truth Annotation which the
	// prediction matches.
	//   "FALSE_POSITIVE" - The EvaluatedAnnotation is false positive. It has a
	// prediction created by the Model which does not match any ground truth
	// annotation.
	//   "FALSE_NEGATIVE" - The EvaluatedAnnotation is false negative. It has a
	// ground truth annotation which is not matched by any of the model created
	// predictions.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataItemPayload") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataItemPayload") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EvaluatedAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EvaluatedAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1EvaluatedAnnotationExplanation: Explanation
// result of the prediction produced by the Model.
type GoogleCloudAiplatformV1beta1EvaluatedAnnotationExplanation struct {
	// Explanation: Explanation attribution response details.
	Explanation *GoogleCloudAiplatformV1beta1Explanation `json:"explanation,omitempty"`
	// ExplanationType: Explanation type. For AutoML Image Classification models,
	// possible values are: * `image-integrated-gradients` * `image-xrai`
	ExplanationType string `json:"explanationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Explanation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Explanation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EvaluatedAnnotationExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EvaluatedAnnotationExplanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1EvaluationDataset: The dataset used for
// evaluation.
type GoogleCloudAiplatformV1beta1EvaluationDataset struct {
	// BigquerySource: BigQuery source holds the dataset.
	BigquerySource *GoogleCloudAiplatformV1beta1BigQuerySource `json:"bigquerySource,omitempty"`
	// GcsSource: Cloud storage source holds the dataset. Currently only one Cloud
	// Storage file path is supported.
	GcsSource *GoogleCloudAiplatformV1beta1GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigquerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigquerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EvaluationDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EvaluationDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Event: An edge describing the relationship
// between an Artifact and an Execution in a lineage graph.
type GoogleCloudAiplatformV1beta1Event struct {
	// Artifact: Required. The relative resource name of the Artifact in the Event.
	Artifact string `json:"artifact,omitempty"`
	// EventTime: Output only. Time the Event occurred.
	EventTime string `json:"eventTime,omitempty"`
	// Execution: Output only. The relative resource name of the Execution in the
	// Event.
	Execution string `json:"execution,omitempty"`
	// Labels: The labels with user-defined metadata to annotate Events. Label keys
	// and values can be no longer than 64 characters (Unicode codepoints), can
	// only contain lowercase letters, numeric characters, underscores and dashes.
	// International characters are allowed. No more than 64 user labels can be
	// associated with one Event (System labels are excluded). See
	// https://goo.gl/xmQnxf for more information and examples of labels. System
	// reserved label keys are prefixed with "aiplatform.googleapis.com/" and are
	// immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Type: Required. The type of the Event.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified whether input or output of the Execution.
	//   "INPUT" - An input of the Execution.
	//   "OUTPUT" - An output of the Execution.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Artifact") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Artifact") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Event) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Event
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1EventActions: Actions are parts of events that
// are executed by the agent.
type GoogleCloudAiplatformV1beta1EventActions struct {
	// ArtifactDelta: Optional. Indicates that the event is updating an artifact.
	// key is the filename, value is the version.
	ArtifactDelta map[string]int64 `json:"artifactDelta,omitempty"`
	// Escalate: Optional. The agent is escalating to a higher level agent.
	Escalate bool `json:"escalate,omitempty"`
	// RequestedAuthConfigs: Optional. Will only be set by a tool response
	// indicating tool request euc. Struct key is the function call id since one
	// function call response (from model) could correspond to multiple function
	// calls. Struct value is the required auth config, which can be another
	// struct.
	RequestedAuthConfigs googleapi.RawMessage `json:"requestedAuthConfigs,omitempty"`
	// SkipSummarization: Optional. If true, it won't call model to summarize
	// function response. Only used for function_response event.
	SkipSummarization bool `json:"skipSummarization,omitempty"`
	// StateDelta: Optional. Indicates that the event is updating the state with
	// the given delta.
	StateDelta googleapi.RawMessage `json:"stateDelta,omitempty"`
	// TransferToAgent: Optional. If set, the event transfers to the specified
	// agent.
	TransferToAgent bool `json:"transferToAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactDelta") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactDelta") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EventActions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EventActions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1EventMetadata: Metadata relating to a LLM
// response event.
type GoogleCloudAiplatformV1beta1EventMetadata struct {
	// Branch: Optional. The branch of the event. The format is like
	// agent_1.agent_2.agent_3, where agent_1 is the parent of agent_2, and agent_2
	// is the parent of agent_3. Branch is used when multiple child agents
	// shouldn't see their siblings' conversation history.
	Branch string `json:"branch,omitempty"`
	// GroundingMetadata: Optional. Metadata returned to client when grounding is
	// enabled.
	GroundingMetadata *GoogleCloudAiplatformV1beta1GroundingMetadata `json:"groundingMetadata,omitempty"`
	// Interrupted: Optional. Flag indicating that LLM was interrupted when
	// generating the content. Usually it's due to user interruption during a bidi
	// streaming.
	Interrupted bool `json:"interrupted,omitempty"`
	// LongRunningToolIds: Optional. Set of ids of the long running function calls.
	// Agent client will know from this field about which function call is long
	// running. Only valid for function call event.
	LongRunningToolIds []string `json:"longRunningToolIds,omitempty"`
	// Partial: Optional. Indicates whether the text content is part of a
	// unfinished text stream. Only used for streaming mode and when the content is
	// plain text.
	Partial bool `json:"partial,omitempty"`
	// TurnComplete: Optional. Indicates whether the response from the model is
	// complete. Only used for streaming mode.
	TurnComplete bool `json:"turnComplete,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Branch") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Branch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1EventMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1EventMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExactMatchInput: Input for exact match metric.
type GoogleCloudAiplatformV1beta1ExactMatchInput struct {
	// Instances: Required. Repeated exact match instances.
	Instances []*GoogleCloudAiplatformV1beta1ExactMatchInstance `json:"instances,omitempty"`
	// MetricSpec: Required. Spec for exact match metric.
	MetricSpec *GoogleCloudAiplatformV1beta1ExactMatchSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instances") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExactMatchInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExactMatchInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExactMatchInstance: Spec for exact match
// instance.
type GoogleCloudAiplatformV1beta1ExactMatchInstance struct {
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// Reference: Required. Ground truth used to compare against the prediction.
	Reference string `json:"reference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prediction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prediction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExactMatchInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExactMatchInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExactMatchMetricValue: Exact match metric value
// for an instance.
type GoogleCloudAiplatformV1beta1ExactMatchMetricValue struct {
	// Score: Output only. Exact match score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Score") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Score") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExactMatchMetricValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExactMatchMetricValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1ExactMatchMetricValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1ExactMatchMetricValue
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1beta1ExactMatchResults: Results for exact match
// metric.
type GoogleCloudAiplatformV1beta1ExactMatchResults struct {
	// ExactMatchMetricValues: Output only. Exact match metric values.
	ExactMatchMetricValues []*GoogleCloudAiplatformV1beta1ExactMatchMetricValue `json:"exactMatchMetricValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExactMatchMetricValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExactMatchMetricValues") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExactMatchResults) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExactMatchResults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExactMatchSpec: Spec for exact match metric -
// returns 1 if prediction and reference exactly matches, otherwise 0.
type GoogleCloudAiplatformV1beta1ExactMatchSpec struct {
}

// GoogleCloudAiplatformV1beta1Example: A single example to upload or read from
// the Example Store.
type GoogleCloudAiplatformV1beta1Example struct {
	// CreateTime: Output only. Timestamp when this Example was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Optional. The display name for Example.
	DisplayName string `json:"displayName,omitempty"`
	// ExampleId: Optional. Immutable. Unique identifier of an example. If not
	// specified when upserting new examples, the example_id will be generated.
	ExampleId string `json:"exampleId,omitempty"`
	// StoredContentsExample: An example of chat history and its expected outcome
	// to be used with GenerateContent.
	StoredContentsExample *GoogleCloudAiplatformV1beta1StoredContentsExample `json:"storedContentsExample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Example) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Example
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExampleStore: Represents an executable service
// to manage and retrieve examples.
type GoogleCloudAiplatformV1beta1ExampleStore struct {
	// CreateTime: Output only. Timestamp when this ExampleStore was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the ExampleStore.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. Display name of the ExampleStore.
	DisplayName string `json:"displayName,omitempty"`
	// ExampleStoreConfig: Required. Example Store config.
	ExampleStoreConfig *GoogleCloudAiplatformV1beta1ExampleStoreConfig `json:"exampleStoreConfig,omitempty"`
	// Name: Identifier. The resource name of the ExampleStore. This is a unique
	// identifier. Format:
	// projects/{project}/locations/{location}/exampleStores/{example_store}
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Timestamp when this ExampleStore was most recently
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExampleStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExampleStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExampleStoreConfig: Configuration for the
// Example Store.
type GoogleCloudAiplatformV1beta1ExampleStoreConfig struct {
	// VertexEmbeddingModel: Required. The embedding model to be used for vector
	// embedding. Immutable. Supported models: * "textembedding-gecko@003" *
	// "text-embedding-004" * "text-embedding-005" *
	// "text-multilingual-embedding-002"
	VertexEmbeddingModel string `json:"vertexEmbeddingModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VertexEmbeddingModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VertexEmbeddingModel") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExampleStoreConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExampleStoreConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Examples: Example-based explainability that
// returns the nearest neighbors from the provided dataset.
type GoogleCloudAiplatformV1beta1Examples struct {
	// ExampleGcsSource: The Cloud Storage input instances.
	ExampleGcsSource *GoogleCloudAiplatformV1beta1ExamplesExampleGcsSource `json:"exampleGcsSource,omitempty"`
	// GcsSource: The Cloud Storage locations that contain the instances to be
	// indexed for approximate nearest neighbor search.
	GcsSource *GoogleCloudAiplatformV1beta1GcsSource `json:"gcsSource,omitempty"`
	// NearestNeighborSearchConfig: The full configuration for the generated index,
	// the semantics are the same as metadata and should match
	// NearestNeighborSearchConfig
	// (https://cloud.google.com/vertex-ai/docs/explainable-ai/configuring-explanations-example-based#nearest-neighbor-search-config).
	NearestNeighborSearchConfig interface{} `json:"nearestNeighborSearchConfig,omitempty"`
	// NeighborCount: The number of neighbors to return when querying for examples.
	NeighborCount int64 `json:"neighborCount,omitempty"`
	// Presets: Simplified preset configuration, which automatically sets
	// configuration values based on the desired query speed-precision trade-off
	// and modality.
	Presets *GoogleCloudAiplatformV1beta1Presets `json:"presets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExampleGcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExampleGcsSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Examples) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Examples
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExamplesArrayFilter: Filters for examples' array
// metadata fields. An array field is example metadata where multiple values
// are attributed to a single example.
type GoogleCloudAiplatformV1beta1ExamplesArrayFilter struct {
	// ArrayOperator: Required. The operator logic to use for filtering.
	//
	// Possible values:
	//   "ARRAY_OPERATOR_UNSPECIFIED" - Not specified. This value should not be
	// used.
	//   "CONTAINS_ANY" - The metadata array field in the example must contain at
	// least one of the values.
	//   "CONTAINS_ALL" - The metadata array field in the example must contain all
	// of the values.
	ArrayOperator string `json:"arrayOperator,omitempty"`
	// Values: Required. The values by which to filter examples.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArrayOperator") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArrayOperator") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExamplesArrayFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExamplesArrayFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExamplesExampleGcsSource: The Cloud Storage
// input instances.
type GoogleCloudAiplatformV1beta1ExamplesExampleGcsSource struct {
	// DataFormat: The format in which instances are given, if not specified,
	// assume it's JSONL format. Currently only JSONL format is supported.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Format unspecified, used when unset.
	//   "JSONL" - Examples are stored in JSONL files.
	DataFormat string `json:"dataFormat,omitempty"`
	// GcsSource: The Cloud Storage location for the input instances.
	GcsSource *GoogleCloudAiplatformV1beta1GcsSource `json:"gcsSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExamplesExampleGcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExamplesExampleGcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExamplesOverride: Overrides for example-based
// explanations.
type GoogleCloudAiplatformV1beta1ExamplesOverride struct {
	// CrowdingCount: The number of neighbors to return that have the same crowding
	// tag.
	CrowdingCount int64 `json:"crowdingCount,omitempty"`
	// DataFormat: The format of the data being provided with each call.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Unspecified format. Must not be used.
	//   "INSTANCES" - Provided data is a set of model inputs.
	//   "EMBEDDINGS" - Provided data is a set of embeddings.
	DataFormat string `json:"dataFormat,omitempty"`
	// NeighborCount: The number of neighbors to return.
	NeighborCount int64 `json:"neighborCount,omitempty"`
	// Restrictions: Restrict the resulting nearest neighbors to respect these
	// constraints.
	Restrictions []*GoogleCloudAiplatformV1beta1ExamplesRestrictionsNamespace `json:"restrictions,omitempty"`
	// ReturnEmbeddings: If true, return the embeddings instead of neighbors.
	ReturnEmbeddings bool `json:"returnEmbeddings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CrowdingCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrowdingCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExamplesOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExamplesOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExamplesRestrictionsNamespace: Restrictions
// namespace for example-based explanations overrides.
type GoogleCloudAiplatformV1beta1ExamplesRestrictionsNamespace struct {
	// Allow: The list of allowed tags.
	Allow []string `json:"allow,omitempty"`
	// Deny: The list of deny tags.
	Deny []string `json:"deny,omitempty"`
	// NamespaceName: The namespace name.
	NamespaceName string `json:"namespaceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Allow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Allow") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExamplesRestrictionsNamespace) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExamplesRestrictionsNamespace
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExecutableCode: Code generated by the model that
// is meant to be executed, and the result returned to the model. Generated
// when using the [FunctionDeclaration] tool and [FunctionCallingConfig] mode
// is set to [Mode.CODE].
type GoogleCloudAiplatformV1beta1ExecutableCode struct {
	// Code: Required. The code to be executed.
	Code string `json:"code,omitempty"`
	// Language: Required. Programming language of the `code`.
	//
	// Possible values:
	//   "LANGUAGE_UNSPECIFIED" - Unspecified language. This value should not be
	// used.
	//   "PYTHON" - Python >= 3.10, with numpy and simpy available.
	Language string `json:"language,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExecutableCode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExecutableCode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExecuteExtensionRequest: Request message for
// ExtensionExecutionService.ExecuteExtension.
type GoogleCloudAiplatformV1beta1ExecuteExtensionRequest struct {
	// OperationId: Required. The desired ID of the operation to be executed in
	// this extension as defined in ExtensionOperation.operation_id.
	OperationId string `json:"operationId,omitempty"`
	// OperationParams: Optional. Request parameters that will be used for
	// executing this operation. The struct should be in a form of map with param
	// name as the key and actual param value as the value. E.g. If this operation
	// requires a param "name" to be set to "abc". you can set this to something
	// like {"name": "abc"}.
	OperationParams googleapi.RawMessage `json:"operationParams,omitempty"`
	// RuntimeAuthConfig: Optional. Auth config provided at runtime to override the
	// default value in Extension.manifest.auth_config. The AuthConfig.auth_type
	// should match the value in Extension.manifest.auth_config.
	RuntimeAuthConfig *GoogleCloudAiplatformV1beta1AuthConfig `json:"runtimeAuthConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OperationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExecuteExtensionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExecuteExtensionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExecuteExtensionResponse: Response message for
// ExtensionExecutionService.ExecuteExtension.
type GoogleCloudAiplatformV1beta1ExecuteExtensionResponse struct {
	// Content: Response content from the extension. The content should be
	// conformant to the response.content schema in the extension's
	// manifest/OpenAPI spec.
	Content string `json:"content,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExecuteExtensionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExecuteExtensionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Execution: Instance of a general execution.
type GoogleCloudAiplatformV1beta1Execution struct {
	// CreateTime: Output only. Timestamp when this Execution was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of the Execution
	Description string `json:"description,omitempty"`
	// DisplayName: User provided display name of the Execution. May be up to 128
	// Unicode characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: An eTag used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Executions.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. No more than
	// 64 user labels can be associated with one Execution (System labels are
	// excluded).
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: Properties of the Execution. Top level metadata keys' heading and
	// trailing spaces will be trimmed. The size of this field should not exceed
	// 200KB.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Output only. The resource name of the Execution.
	Name string `json:"name,omitempty"`
	// SchemaTitle: The title of the schema describing the metadata. Schema title
	// and version is expected to be registered in earlier Create Schema calls. And
	// both are used together as unique identifiers to identify schemas within the
	// local metadata store.
	SchemaTitle string `json:"schemaTitle,omitempty"`
	// SchemaVersion: The version of the schema in `schema_title` to use. Schema
	// title and version is expected to be registered in earlier Create Schema
	// calls. And both are used together as unique identifiers to identify schemas
	// within the local metadata store.
	SchemaVersion string `json:"schemaVersion,omitempty"`
	// State: The state of this Execution. This is a property of the Execution, and
	// does not imply or capture any ongoing process. This property is managed by
	// clients (such as Vertex AI Pipelines) and the system does not prescribe or
	// check the validity of state transitions.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified Execution state
	//   "NEW" - The Execution is new
	//   "RUNNING" - The Execution is running
	//   "COMPLETE" - The Execution has finished running
	//   "FAILED" - The Execution has failed
	//   "CACHED" - The Execution completed through Cache hit.
	//   "CANCELLED" - The Execution was cancelled.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp when this Execution was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Execution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Execution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExplainRequest: Request message for
// PredictionService.Explain.
type GoogleCloudAiplatformV1beta1ExplainRequest struct {
	// ConcurrentExplanationSpecOverride: Optional. This field is the same as the
	// one above, but supports multiple explanations to occur in parallel. The key
	// can be any string. Each override will be run against the model, then its
	// explanations will be grouped together. Note - these explanations are run
	// **In Addition** to the default Explanation in the deployed model.
	ConcurrentExplanationSpecOverride map[string]GoogleCloudAiplatformV1beta1ExplanationSpecOverride `json:"concurrentExplanationSpecOverride,omitempty"`
	// DeployedModelId: If specified, this ExplainRequest will be served by the
	// chosen DeployedModel, overriding Endpoint.traffic_split.
	DeployedModelId string `json:"deployedModelId,omitempty"`
	// ExplanationSpecOverride: If specified, overrides the explanation_spec of the
	// DeployedModel. Can be used for explaining prediction results with different
	// configurations, such as: - Explaining top-5 predictions results as opposed
	// to top-1; - Increasing path count or step count of the attribution methods
	// to reduce approximate errors; - Using different baselines for explaining the
	// prediction results.
	ExplanationSpecOverride *GoogleCloudAiplatformV1beta1ExplanationSpecOverride `json:"explanationSpecOverride,omitempty"`
	// Instances: Required. The instances that are the input to the explanation
	// call. A DeployedModel may have an upper limit on the number of instances it
	// supports per request, and when it is exceeded the explanation call errors in
	// case of AutoML Models, or, in case of customer created Models, the behaviour
	// is as documented by that Model. The schema of any single instance may be
	// specified via Endpoint's DeployedModels' Model's PredictSchemata's
	// instance_schema_uri.
	Instances []interface{} `json:"instances,omitempty"`
	// Parameters: The parameters that govern the prediction. The schema of the
	// parameters may be specified via Endpoint's DeployedModels' Model's
	// PredictSchemata's parameters_schema_uri.
	Parameters interface{} `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ConcurrentExplanationSpecOverride") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "ConcurrentExplanationSpecOverride") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplainRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplainRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExplainResponse: Response message for
// PredictionService.Explain.
type GoogleCloudAiplatformV1beta1ExplainResponse struct {
	// ConcurrentExplanations: This field stores the results of the explanations
	// run in parallel with The default explanation strategy/method.
	ConcurrentExplanations map[string]GoogleCloudAiplatformV1beta1ExplainResponseConcurrentExplanation `json:"concurrentExplanations,omitempty"`
	// DeployedModelId: ID of the Endpoint's DeployedModel that served this
	// explanation.
	DeployedModelId string `json:"deployedModelId,omitempty"`
	// Explanations: The explanations of the Model's PredictResponse.predictions.
	// It has the same number of elements as instances to be explained.
	Explanations []*GoogleCloudAiplatformV1beta1Explanation `json:"explanations,omitempty"`
	// Predictions: The predictions that are the output of the predictions call.
	// Same as PredictResponse.predictions.
	Predictions []interface{} `json:"predictions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConcurrentExplanations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConcurrentExplanations") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplainResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplainResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExplainResponseConcurrentExplanation: This
// message is a wrapper grouping Concurrent Explanations.
type GoogleCloudAiplatformV1beta1ExplainResponseConcurrentExplanation struct {
	// Explanations: The explanations of the Model's PredictResponse.predictions.
	// It has the same number of elements as instances to be explained.
	Explanations []*GoogleCloudAiplatformV1beta1Explanation `json:"explanations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Explanations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Explanations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplainResponseConcurrentExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplainResponseConcurrentExplanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Explanation: Explanation of a prediction
// (provided in PredictResponse.predictions) produced by the Model on a given
// instance.
type GoogleCloudAiplatformV1beta1Explanation struct {
	// Attributions: Output only. Feature attributions grouped by predicted
	// outputs. For Models that predict only one output, such as regression Models
	// that predict only one score, there is only one attibution that explains the
	// predicted output. For Models that predict multiple outputs, such as
	// multiclass Models that predict multiple classes, each element explains one
	// specific item. Attribution.output_index can be used to identify which output
	// this attribution is explaining. By default, we provide Shapley values for
	// the predicted class. However, you can configure the explanation request to
	// generate Shapley values for any other classes too. For example, if a model
	// predicts a probability of `0.4` for approving a loan application, the
	// model's decision is to reject the application since `p(reject) = 0.6 >
	// p(approve) = 0.4`, and the default Shapley values would be computed for
	// rejection decision and not approval, even though the latter might be the
	// positive class. If users set ExplanationParameters.top_k, the attributions
	// are sorted by instance_output_value in descending order. If
	// ExplanationParameters.output_indices is specified, the attributions are
	// stored by Attribution.output_index in the same order as they appear in the
	// output_indices.
	Attributions []*GoogleCloudAiplatformV1beta1Attribution `json:"attributions,omitempty"`
	// Neighbors: Output only. List of the nearest neighbors for example-based
	// explanations. For models deployed with the examples explanations feature
	// enabled, the attributions field is empty and instead the neighbors field is
	// populated.
	Neighbors []*GoogleCloudAiplatformV1beta1Neighbor `json:"neighbors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attributions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attributions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Explanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Explanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExplanationMetadata: Metadata describing the
// Model's input and output for explanation.
type GoogleCloudAiplatformV1beta1ExplanationMetadata struct {
	// FeatureAttributionsSchemaUri: Points to a YAML file stored on Google Cloud
	// Storage describing the format of the feature attributions. The schema is
	// defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// AutoML tabular Models always have this field populated by Vertex AI. Note:
	// The URI given on output may be different, including the URI scheme, than the
	// one given on input. The output URI will point to a location where the user
	// only has a read access.
	FeatureAttributionsSchemaUri string `json:"featureAttributionsSchemaUri,omitempty"`
	// Inputs: Required. Map from feature names to feature input metadata. Keys are
	// the name of the features. Values are the specification of the feature. An
	// empty InputMetadata is valid. It describes a text feature which has the name
	// specified as the key in ExplanationMetadata.inputs. The baseline of the
	// empty feature is chosen by Vertex AI. For Vertex AI-provided Tensorflow
	// images, the key can be any friendly name of the feature. Once specified,
	// featureAttributions are keyed by this key (if not grouped with another
	// feature). For custom images, the key must match with the key in instance.
	Inputs map[string]GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata `json:"inputs,omitempty"`
	// LatentSpaceSource: Name of the source to generate embeddings for example
	// based explanations.
	LatentSpaceSource string `json:"latentSpaceSource,omitempty"`
	// Outputs: Required. Map from output names to output metadata. For Vertex
	// AI-provided Tensorflow images, keys can be any user defined string that
	// consists of any UTF-8 characters. For custom images, keys are the name of
	// the output field in the prediction to be explained. Currently only one key
	// is allowed.
	Outputs map[string]GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata `json:"outputs,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "FeatureAttributionsSchemaUri") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureAttributionsSchemaUri") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplanationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata: Metadata of
// the input of a feature. Fields other than InputMetadata.input_baselines are
// applicable only for Models that are using Vertex AI-provided images for
// Tensorflow.
type GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata struct {
	// DenseShapeTensorName: Specifies the shape of the values of the input if the
	// input is a sparse representation. Refer to Tensorflow documentation for more
	// details: https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
	DenseShapeTensorName string `json:"denseShapeTensorName,omitempty"`
	// EncodedBaselines: A list of baselines for the encoded tensor. The shape of
	// each baseline should match the shape of the encoded tensor. If a scalar is
	// provided, Vertex AI broadcasts to the same shape as the encoded tensor.
	EncodedBaselines []interface{} `json:"encodedBaselines,omitempty"`
	// EncodedTensorName: Encoded tensor is a transformation of the input tensor.
	// Must be provided if choosing Integrated Gradients attribution or XRAI
	// attribution and the input tensor is not differentiable. An encoded tensor is
	// generated if the input tensor is encoded by a lookup table.
	EncodedTensorName string `json:"encodedTensorName,omitempty"`
	// Encoding: Defines how the feature is encoded into the input tensor. Defaults
	// to IDENTITY.
	//
	// Possible values:
	//   "ENCODING_UNSPECIFIED" - Default value. This is the same as IDENTITY.
	//   "IDENTITY" - The tensor represents one feature.
	//   "BAG_OF_FEATURES" - The tensor represents a bag of features where each
	// index maps to a feature. InputMetadata.index_feature_mapping must be
	// provided for this encoding. For example: ``` input = [27, 6.0, 150]
	// index_feature_mapping = ["age", "height", "weight"] ```
	//   "BAG_OF_FEATURES_SPARSE" - The tensor represents a bag of features where
	// each index maps to a feature. Zero values in the tensor indicates feature
	// being non-existent. InputMetadata.index_feature_mapping must be provided for
	// this encoding. For example: ``` input = [2, 0, 5, 0, 1]
	// index_feature_mapping = ["a", "b", "c", "d", "e"] ```
	//   "INDICATOR" - The tensor is a list of binaries representing whether a
	// feature exists or not (1 indicates existence).
	// InputMetadata.index_feature_mapping must be provided for this encoding. For
	// example: ``` input = [1, 0, 1, 0, 1] index_feature_mapping = ["a", "b", "c",
	// "d", "e"] ```
	//   "COMBINED_EMBEDDING" - The tensor is encoded into a 1-dimensional array
	// represented by an encoded tensor. InputMetadata.encoded_tensor_name must be
	// provided for this encoding. For example: ``` input = ["This", "is", "a",
	// "test", "."] encoded = [0.1, 0.2, 0.3, 0.4, 0.5] ```
	//   "CONCAT_EMBEDDING" - Select this encoding when the input tensor is encoded
	// into a 2-dimensional array represented by an encoded tensor.
	// InputMetadata.encoded_tensor_name must be provided for this encoding. The
	// first dimension of the encoded tensor's shape is the same as the input
	// tensor's shape. For example: ``` input = ["This", "is", "a", "test", "."]
	// encoded = [[0.1, 0.2, 0.3, 0.4, 0.5], [0.2, 0.1, 0.4, 0.3, 0.5], [0.5, 0.1,
	// 0.3, 0.5, 0.4], [0.5, 0.3, 0.1, 0.2, 0.4], [0.4, 0.3, 0.2, 0.5, 0.1]] ```
	Encoding string `json:"encoding,omitempty"`
	// FeatureValueDomain: The domain details of the input feature value. Like
	// min/max, original mean or standard deviation if normalized.
	FeatureValueDomain *GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataFeatureValueDomain `json:"featureValueDomain,omitempty"`
	// GroupName: Name of the group that the input belongs to. Features with the
	// same group name will be treated as one feature when computing attributions.
	// Features grouped together can have different shapes in value. If provided,
	// there will be one single attribution generated in
	// Attribution.feature_attributions, keyed by the group name.
	GroupName string `json:"groupName,omitempty"`
	// IndexFeatureMapping: A list of feature names for each index in the input
	// tensor. Required when the input InputMetadata.encoding is BAG_OF_FEATURES,
	// BAG_OF_FEATURES_SPARSE, INDICATOR.
	IndexFeatureMapping []string `json:"indexFeatureMapping,omitempty"`
	// IndicesTensorName: Specifies the index of the values of the input tensor.
	// Required when the input tensor is a sparse representation. Refer to
	// Tensorflow documentation for more details:
	// https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
	IndicesTensorName string `json:"indicesTensorName,omitempty"`
	// InputBaselines: Baseline inputs for this feature. If no baseline is
	// specified, Vertex AI chooses the baseline for this feature. If multiple
	// baselines are specified, Vertex AI returns the average attributions across
	// them in Attribution.feature_attributions. For Vertex AI-provided Tensorflow
	// images (both 1.x and 2.x), the shape of each baseline must match the shape
	// of the input tensor. If a scalar is provided, we broadcast to the same shape
	// as the input tensor. For custom images, the element of the baselines must be
	// in the same format as the feature's input in the instance[]. The schema of
	// any single instance may be specified via Endpoint's DeployedModels' Model's
	// PredictSchemata's instance_schema_uri.
	InputBaselines []interface{} `json:"inputBaselines,omitempty"`
	// InputTensorName: Name of the input tensor for this feature. Required and is
	// only applicable to Vertex AI-provided images for Tensorflow.
	InputTensorName string `json:"inputTensorName,omitempty"`
	// Modality: Modality of the feature. Valid values are: numeric, image.
	// Defaults to numeric.
	Modality string `json:"modality,omitempty"`
	// Visualization: Visualization configurations for image explanation.
	Visualization *GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataVisualization `json:"visualization,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DenseShapeTensorName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DenseShapeTensorName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataFeatureValueDomai
// n: Domain details of the input feature value. Provides numeric information
// about the feature, such as its range (min, max). If the feature has been
// pre-processed, for example with z-scoring, then it provides information
// about how to recover the original feature. For example, if the input feature
// is an image and it has been pre-processed to obtain 0-mean and stddev = 1
// values, then original_mean, and original_stddev refer to the mean and stddev
// of the original feature (e.g. image tensor) from which input feature (with
// mean = 0 and stddev = 1) was obtained.
type GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataFeatureValueDomain struct {
	// MaxValue: The maximum permissible value for this feature.
	MaxValue float64 `json:"maxValue,omitempty"`
	// MinValue: The minimum permissible value for this feature.
	MinValue float64 `json:"minValue,omitempty"`
	// OriginalMean: If this input feature has been normalized to a mean value of
	// 0, the original_mean specifies the mean value of the domain prior to
	// normalization.
	OriginalMean float64 `json:"originalMean,omitempty"`
	// OriginalStddev: If this input feature has been normalized to a standard
	// deviation of 1.0, the original_stddev specifies the standard deviation of
	// the domain prior to normalization.
	OriginalStddev float64 `json:"originalStddev,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataFeatureValueDomain) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataFeatureValueDomain
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataFeatureValueDomain) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataFeatureValueDomain
	var s1 struct {
		MaxValue       gensupport.JSONFloat64 `json:"maxValue"`
		MinValue       gensupport.JSONFloat64 `json:"minValue"`
		OriginalMean   gensupport.JSONFloat64 `json:"originalMean"`
		OriginalStddev gensupport.JSONFloat64 `json:"originalStddev"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxValue = float64(s1.MaxValue)
	s.MinValue = float64(s1.MinValue)
	s.OriginalMean = float64(s1.OriginalMean)
	s.OriginalStddev = float64(s1.OriginalStddev)
	return nil
}

// GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataVisualization:
// Visualization configurations for image explanation.
type GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataVisualization struct {
	// ClipPercentLowerbound: Excludes attributions below the specified percentile,
	// from the highlighted areas. Defaults to 62.
	ClipPercentLowerbound float64 `json:"clipPercentLowerbound,omitempty"`
	// ClipPercentUpperbound: Excludes attributions above the specified percentile
	// from the highlighted areas. Using the clip_percent_upperbound and
	// clip_percent_lowerbound together can be useful for filtering out noise and
	// making it easier to see areas of strong attribution. Defaults to 99.9.
	ClipPercentUpperbound float64 `json:"clipPercentUpperbound,omitempty"`
	// ColorMap: The color scheme used for the highlighted areas. Defaults to
	// PINK_GREEN for Integrated Gradients attribution, which shows positive
	// attributions in green and negative in pink. Defaults to VIRIDIS for XRAI
	// attribution, which highlights the most influential regions in yellow and the
	// least influential in blue.
	//
	// Possible values:
	//   "COLOR_MAP_UNSPECIFIED" - Should not be used.
	//   "PINK_GREEN" - Positive: green. Negative: pink.
	//   "VIRIDIS" - Viridis color map: A perceptually uniform color mapping which
	// is easier to see by those with colorblindness and progresses from yellow to
	// green to blue. Positive: yellow. Negative: blue.
	//   "RED" - Positive: red. Negative: red.
	//   "GREEN" - Positive: green. Negative: green.
	//   "RED_GREEN" - Positive: green. Negative: red.
	//   "PINK_WHITE_GREEN" - PiYG palette.
	ColorMap string `json:"colorMap,omitempty"`
	// OverlayType: How the original image is displayed in the visualization.
	// Adjusting the overlay can help increase visual clarity if the original image
	// makes it difficult to view the visualization. Defaults to NONE.
	//
	// Possible values:
	//   "OVERLAY_TYPE_UNSPECIFIED" - Default value. This is the same as NONE.
	//   "NONE" - No overlay.
	//   "ORIGINAL" - The attributions are shown on top of the original image.
	//   "GRAYSCALE" - The attributions are shown on top of grayscaled version of
	// the original image.
	//   "MASK_BLACK" - The attributions are used as a mask to reveal predictive
	// parts of the image and hide the un-predictive parts.
	OverlayType string `json:"overlayType,omitempty"`
	// Polarity: Whether to only highlight pixels with positive contributions,
	// negative or both. Defaults to POSITIVE.
	//
	// Possible values:
	//   "POLARITY_UNSPECIFIED" - Default value. This is the same as POSITIVE.
	//   "POSITIVE" - Highlights the pixels/outlines that were most influential to
	// the model's prediction.
	//   "NEGATIVE" - Setting polarity to negative highlights areas that does not
	// lead to the models's current prediction.
	//   "BOTH" - Shows both positive and negative attributions.
	Polarity string `json:"polarity,omitempty"`
	// Type: Type of the image visualization. Only applicable to Integrated
	// Gradients attribution. OUTLINES shows regions of attribution, while PIXELS
	// shows per-pixel attribution. Defaults to OUTLINES.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Should not be used.
	//   "PIXELS" - Shows which pixel contributed to the image prediction.
	//   "OUTLINES" - Shows which region contributed to the image prediction by
	// outlining the region.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClipPercentLowerbound") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClipPercentLowerbound") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataVisualization) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataVisualization
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataVisualization) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationMetadataInputMetadataVisualization
	var s1 struct {
		ClipPercentLowerbound gensupport.JSONFloat64 `json:"clipPercentLowerbound"`
		ClipPercentUpperbound gensupport.JSONFloat64 `json:"clipPercentUpperbound"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ClipPercentLowerbound = float64(s1.ClipPercentLowerbound)
	s.ClipPercentUpperbound = float64(s1.ClipPercentUpperbound)
	return nil
}

// GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata: Metadata of
// the prediction output to be explained.
type GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata struct {
	// DisplayNameMappingKey: Specify a field name in the prediction to look for
	// the display name. Use this if the prediction contains the display names for
	// the outputs. The display names in the prediction must have the same shape of
	// the outputs, so that it can be located by Attribution.output_index for a
	// specific output.
	DisplayNameMappingKey string `json:"displayNameMappingKey,omitempty"`
	// IndexDisplayNameMapping: Static mapping between the index and display name.
	// Use this if the outputs are a deterministic n-dimensional array, e.g. a list
	// of scores of all the classes in a pre-defined order for a
	// multi-classification Model. It's not feasible if the outputs are
	// non-deterministic, e.g. the Model produces top-k classes or sort the outputs
	// by their values. The shape of the value must be an n-dimensional array of
	// strings. The number of dimensions must match that of the outputs to be
	// explained. The Attribution.output_display_name is populated by locating in
	// the mapping with Attribution.output_index.
	IndexDisplayNameMapping interface{} `json:"indexDisplayNameMapping,omitempty"`
	// OutputTensorName: Name of the output tensor. Required and is only applicable
	// to Vertex AI provided images for Tensorflow.
	OutputTensorName string `json:"outputTensorName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayNameMappingKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayNameMappingKey") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationMetadataOutputMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExplanationMetadataOverride: The
// ExplanationMetadata entries that can be overridden at online explanation
// time.
type GoogleCloudAiplatformV1beta1ExplanationMetadataOverride struct {
	// Inputs: Required. Overrides the input metadata of the features. The key is
	// the name of the feature to be overridden. The keys specified here must exist
	// in the input metadata to be overridden. If a feature is not specified here,
	// the corresponding feature's input metadata is not overridden.
	Inputs map[string]GoogleCloudAiplatformV1beta1ExplanationMetadataOverrideInputMetadataOverride `json:"inputs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Inputs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Inputs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplanationMetadataOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationMetadataOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExplanationMetadataOverrideInputMetadataOverride:
//
//	The input metadata entries to be overridden.
type GoogleCloudAiplatformV1beta1ExplanationMetadataOverrideInputMetadataOverride struct {
	// InputBaselines: Baseline inputs for this feature. This overrides the
	// `input_baseline` field of the ExplanationMetadata.InputMetadata object of
	// the corresponding feature's input metadata. If it's not specified, the
	// original baselines are not overridden.
	InputBaselines []interface{} `json:"inputBaselines,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputBaselines") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputBaselines") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplanationMetadataOverrideInputMetadataOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationMetadataOverrideInputMetadataOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExplanationParameters: Parameters to configure
// explaining for Model's predictions.
type GoogleCloudAiplatformV1beta1ExplanationParameters struct {
	// Examples: Example-based explanations that returns the nearest neighbors from
	// the provided dataset.
	Examples *GoogleCloudAiplatformV1beta1Examples `json:"examples,omitempty"`
	// IntegratedGradientsAttribution: An attribution method that computes
	// Aumann-Shapley values taking advantage of the model's fully differentiable
	// structure. Refer to this paper for more details:
	// https://arxiv.org/abs/1703.01365
	IntegratedGradientsAttribution *GoogleCloudAiplatformV1beta1IntegratedGradientsAttribution `json:"integratedGradientsAttribution,omitempty"`
	// OutputIndices: If populated, only returns attributions that have
	// output_index contained in output_indices. It must be an ndarray of integers,
	// with the same shape of the output it's explaining. If not populated, returns
	// attributions for top_k indices of outputs. If neither top_k nor
	// output_indices is populated, returns the argmax index of the outputs. Only
	// applicable to Models that predict multiple outputs (e,g, multi-class Models
	// that predict multiple classes).
	OutputIndices []interface{} `json:"outputIndices,omitempty"`
	// SampledShapleyAttribution: An attribution method that approximates Shapley
	// values for features that contribute to the label being predicted. A sampling
	// strategy is used to approximate the value rather than considering all
	// subsets of features. Refer to this paper for model details:
	// https://arxiv.org/abs/1306.4265.
	SampledShapleyAttribution *GoogleCloudAiplatformV1beta1SampledShapleyAttribution `json:"sampledShapleyAttribution,omitempty"`
	// TopK: If populated, returns attributions for top K indices of outputs
	// (defaults to 1). Only applies to Models that predicts more than one outputs
	// (e,g, multi-class Models). When set to -1, returns explanations for all
	// outputs.
	TopK int64 `json:"topK,omitempty"`
	// XraiAttribution: An attribution method that redistributes Integrated
	// Gradients attribution to segmented regions, taking advantage of the model's
	// fully differentiable structure. Refer to this paper for more details:
	// https://arxiv.org/abs/1906.02825 XRAI currently performs better on natural
	// images, like a picture of a house or an animal. If the images are taken in
	// artificial environments, like a lab or manufacturing line, or from
	// diagnostic equipment, like x-rays or quality-control cameras, use Integrated
	// Gradients instead.
	XraiAttribution *GoogleCloudAiplatformV1beta1XraiAttribution `json:"xraiAttribution,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Examples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Examples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplanationParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExplanationSpec: Specification of Model
// explanation.
type GoogleCloudAiplatformV1beta1ExplanationSpec struct {
	// Metadata: Optional. Metadata describing the Model's input and output for
	// explanation.
	Metadata *GoogleCloudAiplatformV1beta1ExplanationMetadata `json:"metadata,omitempty"`
	// Parameters: Required. Parameters that configure explaining of the Model's
	// predictions.
	Parameters *GoogleCloudAiplatformV1beta1ExplanationParameters `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplanationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExplanationSpecOverride: The ExplanationSpec
// entries that can be overridden at online explanation time.
type GoogleCloudAiplatformV1beta1ExplanationSpecOverride struct {
	// ExamplesOverride: The example-based explanations parameter overrides.
	ExamplesOverride *GoogleCloudAiplatformV1beta1ExamplesOverride `json:"examplesOverride,omitempty"`
	// Metadata: The metadata to be overridden. If not specified, no metadata is
	// overridden.
	Metadata *GoogleCloudAiplatformV1beta1ExplanationMetadataOverride `json:"metadata,omitempty"`
	// Parameters: The parameters to be overridden. Note that the attribution
	// method cannot be changed. If not specified, no parameter is overridden.
	Parameters *GoogleCloudAiplatformV1beta1ExplanationParameters `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExamplesOverride") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExamplesOverride") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExplanationSpecOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExplanationSpecOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportDataConfig: Describes what part of the
// Dataset is to be exported, the destination of the export and how to export.
type GoogleCloudAiplatformV1beta1ExportDataConfig struct {
	// AnnotationsFilter: An expression for filtering what part of the Dataset is
	// to be exported. Only Annotations that match this filter will be exported.
	// The filter syntax is the same as in ListAnnotations.
	AnnotationsFilter string `json:"annotationsFilter,omitempty"`
	// FractionSplit: Split based on fractions defining the size of each set.
	FractionSplit *GoogleCloudAiplatformV1beta1ExportFractionSplit `json:"fractionSplit,omitempty"`
	// GcsDestination: The Google Cloud Storage location where the output is to be
	// written to. In the given directory a new directory will be created with
	// name: `export-data--` where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ
	// ISO-8601 format. All export output will be written into that directory.
	// Inside that directory, annotations with the same schema will be grouped into
	// sub directories which are named with the corresponding annotations' schema
	// title. Inside these sub directories, a schema.yaml will be created to
	// describe the output format.
	GcsDestination *GoogleCloudAiplatformV1beta1GcsDestination `json:"gcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationsFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationsFilter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportDataOperationMetadata: Runtime operation
// information for DatasetService.ExportData.
type GoogleCloudAiplatformV1beta1ExportDataOperationMetadata struct {
	// GcsOutputDirectory: A Google Cloud Storage directory which path ends with
	// '/'. The exported data is stored in the directory.
	GcsOutputDirectory string `json:"gcsOutputDirectory,omitempty"`
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsOutputDirectory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsOutputDirectory") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportDataRequest: Request message for
// DatasetService.ExportData.
type GoogleCloudAiplatformV1beta1ExportDataRequest struct {
	// ExportConfig: Required. The desired output location.
	ExportConfig *GoogleCloudAiplatformV1beta1ExportDataConfig `json:"exportConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportDataResponse: Response message for
// DatasetService.ExportData.
type GoogleCloudAiplatformV1beta1ExportDataResponse struct {
	// ExportedFiles: All of the files that are exported in this export operation.
	// For custom code training export, only three (training, validation and test)
	// Cloud Storage paths in wildcard format are populated (for example,
	// gs://.../training-*).
	ExportedFiles []string `json:"exportedFiles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportedFiles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportedFiles") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportFeatureValuesOperationMetadata: Details of
// operations that exports Features values.
type GoogleCloudAiplatformV1beta1ExportFeatureValuesOperationMetadata struct {
	// GenericMetadata: Operation metadata for Featurestore export Feature values.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportFeatureValuesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportFeatureValuesRequest: Request message for
// FeaturestoreService.ExportFeatureValues.
type GoogleCloudAiplatformV1beta1ExportFeatureValuesRequest struct {
	// Destination: Required. Specifies destination location and format.
	Destination *GoogleCloudAiplatformV1beta1FeatureValueDestination `json:"destination,omitempty"`
	// FeatureSelector: Required. Selects Features to export values of.
	FeatureSelector *GoogleCloudAiplatformV1beta1FeatureSelector `json:"featureSelector,omitempty"`
	// FullExport: Exports all historical values of all entities of the EntityType
	// within a time range
	FullExport *GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestFullExport `json:"fullExport,omitempty"`
	// Settings: Per-Feature export settings.
	Settings []*GoogleCloudAiplatformV1beta1DestinationFeatureSetting `json:"settings,omitempty"`
	// SnapshotExport: Exports the latest Feature values of all entities of the
	// EntityType within a time range.
	SnapshotExport *GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestSnapshotExport `json:"snapshotExport,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportFeatureValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestFullExport: Describes
// exporting all historical Feature values of all entities of the EntityType
// between [start_time, end_time].
type GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestFullExport struct {
	// EndTime: Exports Feature values as of this timestamp. If not set, retrieve
	// values as of now. Timestamp, if present, must not have higher than
	// millisecond precision.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Excludes Feature values with feature generation timestamp before
	// this timestamp. If not set, retrieve oldest values kept in Feature Store.
	// Timestamp, if present, must not have higher than millisecond precision.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestFullExport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestFullExport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestSnapshotExport:
// Describes exporting the latest Feature values of all entities of the
// EntityType between [start_time, snapshot_time].
type GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestSnapshotExport struct {
	// SnapshotTime: Exports Feature values as of this timestamp. If not set,
	// retrieve values as of now. Timestamp, if present, must not have higher than
	// millisecond precision.
	SnapshotTime string `json:"snapshotTime,omitempty"`
	// StartTime: Excludes Feature values with feature generation timestamp before
	// this timestamp. If not set, retrieve oldest values kept in Feature Store.
	// Timestamp, if present, must not have higher than millisecond precision.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SnapshotTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SnapshotTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestSnapshotExport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportFeatureValuesRequestSnapshotExport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportFeatureValuesResponse: Response message
// for FeaturestoreService.ExportFeatureValues.
type GoogleCloudAiplatformV1beta1ExportFeatureValuesResponse struct {
}

// GoogleCloudAiplatformV1beta1ExportFractionSplit: Assigns the input data to
// training, validation, and test sets as per the given fractions. Any of
// `training_fraction`, `validation_fraction` and `test_fraction` may
// optionally be provided, they must sum to up to 1. If the provided ones sum
// to less than 1, the remainder is assigned to sets as decided by Vertex AI.
// If none of the fractions are set, by default roughly 80% of data is used for
// training, 10% for validation, and 10% for test.
type GoogleCloudAiplatformV1beta1ExportFractionSplit struct {
	// TestFraction: The fraction of the input data that is to be used to evaluate
	// the Model.
	TestFraction float64 `json:"testFraction,omitempty"`
	// TrainingFraction: The fraction of the input data that is to be used to train
	// the Model.
	TrainingFraction float64 `json:"trainingFraction,omitempty"`
	// ValidationFraction: The fraction of the input data that is to be used to
	// validate the Model.
	ValidationFraction float64 `json:"validationFraction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestFraction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestFraction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportFractionSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportFractionSplit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1ExportFractionSplit) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1ExportFractionSplit
	var s1 struct {
		TestFraction       gensupport.JSONFloat64 `json:"testFraction"`
		TrainingFraction   gensupport.JSONFloat64 `json:"trainingFraction"`
		ValidationFraction gensupport.JSONFloat64 `json:"validationFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TestFraction = float64(s1.TestFraction)
	s.TrainingFraction = float64(s1.TrainingFraction)
	s.ValidationFraction = float64(s1.ValidationFraction)
	return nil
}

// GoogleCloudAiplatformV1beta1ExportModelOperationMetadata: Details of
// ModelService.ExportModel operation.
type GoogleCloudAiplatformV1beta1ExportModelOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// OutputInfo: Output only. Information further describing the output of this
	// Model export.
	OutputInfo *GoogleCloudAiplatformV1beta1ExportModelOperationMetadataOutputInfo `json:"outputInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportModelOperationMetadataOutputInfo: Further
// describes the output of the ExportModel. Supplements
// ExportModelRequest.OutputConfig.
type GoogleCloudAiplatformV1beta1ExportModelOperationMetadataOutputInfo struct {
	// ArtifactOutputUri: Output only. If the Model artifact is being exported to
	// Google Cloud Storage this is the full path of the directory created, into
	// which the Model files are being written to.
	ArtifactOutputUri string `json:"artifactOutputUri,omitempty"`
	// ImageOutputUri: Output only. If the Model image is being exported to Google
	// Container Registry or Artifact Registry this is the full path of the image
	// created.
	ImageOutputUri string `json:"imageOutputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactOutputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactOutputUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportModelOperationMetadataOutputInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportModelOperationMetadataOutputInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportModelRequest: Request message for
// ModelService.ExportModel.
type GoogleCloudAiplatformV1beta1ExportModelRequest struct {
	// OutputConfig: Required. The desired output location and configuration.
	OutputConfig *GoogleCloudAiplatformV1beta1ExportModelRequestOutputConfig `json:"outputConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportModelRequestOutputConfig: Output
// configuration for the Model export.
type GoogleCloudAiplatformV1beta1ExportModelRequestOutputConfig struct {
	// ArtifactDestination: The Cloud Storage location where the Model artifact is
	// to be written to. Under the directory given as the destination a new one
	// with name "model-export--", where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ
	// ISO-8601 format, will be created. Inside, the Model and any of its
	// supporting files will be written. This field should only be set when the
	// `exportableContent` field of the [Model.supported_export_formats] object
	// contains `ARTIFACT`.
	ArtifactDestination *GoogleCloudAiplatformV1beta1GcsDestination `json:"artifactDestination,omitempty"`
	// ExportFormatId: The ID of the format in which the Model must be exported.
	// Each Model lists the export formats it supports. If no value is provided
	// here, then the first from the list of the Model's supported formats is used
	// by default.
	ExportFormatId string `json:"exportFormatId,omitempty"`
	// ImageDestination: The Google Container Registry or Artifact Registry uri
	// where the Model container image will be copied to. This field should only be
	// set when the `exportableContent` field of the
	// [Model.supported_export_formats] object contains `IMAGE`.
	ImageDestination *GoogleCloudAiplatformV1beta1ContainerRegistryDestination `json:"imageDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportModelRequestOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportModelRequestOutputConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportModelResponse: Response message of
// ModelService.ExportModel operation.
type GoogleCloudAiplatformV1beta1ExportModelResponse struct {
}

// GoogleCloudAiplatformV1beta1ExportPublisherModelOperationMetadata: Runtime
// operation information for ModelGardenService.ExportPublisherModel.
type GoogleCloudAiplatformV1beta1ExportPublisherModelOperationMetadata struct {
	// GenericMetadata: The operation generic information.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportPublisherModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportPublisherModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportPublisherModelRequest: Request message for
// ModelGardenService.ExportPublisherModel.
type GoogleCloudAiplatformV1beta1ExportPublisherModelRequest struct {
	// Destination: Required. The target where we are exporting the model weights
	// to
	Destination *GoogleCloudAiplatformV1beta1GcsDestination `json:"destination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportPublisherModelRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportPublisherModelRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportPublisherModelResponse: Response message
// for ModelGardenService.ExportPublisherModel.
type GoogleCloudAiplatformV1beta1ExportPublisherModelResponse struct {
	// DestinationUri: The destination uri of the model weights.
	DestinationUri string `json:"destinationUri,omitempty"`
	// PublisherModel: The name of the PublisherModel resource. Format:
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`
	PublisherModel string `json:"publisherModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationUri") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportPublisherModelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportPublisherModelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataRequest: Request
// message for TensorboardService.ExportTensorboardTimeSeriesData.
type GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataRequest struct {
	// Filter: Exports the TensorboardTimeSeries' data that match the filter
	// expression.
	Filter string `json:"filter,omitempty"`
	// OrderBy: Field to use to sort the TensorboardTimeSeries' data. By default,
	// TensorboardTimeSeries' data is returned in a pseudo random order.
	OrderBy string `json:"orderBy,omitempty"`
	// PageSize: The maximum number of data points to return per page. The default
	// page_size is 1000. Values must be between 1 and 10000. Values above 10000
	// are coerced to 10000.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: A page token, received from a previous
	// ExportTensorboardTimeSeriesData call. Provide this to retrieve the
	// subsequent page. When paginating, all other parameters provided to
	// ExportTensorboardTimeSeriesData must match the call that provided the page
	// token.
	PageToken string `json:"pageToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataResponse:
// Response message for TensorboardService.ExportTensorboardTimeSeriesData.
type GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataResponse struct {
	// NextPageToken: A token, which can be sent as page_token to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TimeSeriesDataPoints: The returned time series data points.
	TimeSeriesDataPoints []*GoogleCloudAiplatformV1beta1TimeSeriesDataPoint `json:"timeSeriesDataPoints,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExportTensorboardTimeSeriesDataResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Extension: Extensions are tools for large
// language models to access external data, run computations, etc.
type GoogleCloudAiplatformV1beta1Extension struct {
	// CreateTime: Output only. Timestamp when this Extension was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. The description of the Extension.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the Extension. The name can be up
	// to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// ExtensionOperations: Output only. Supported operations.
	ExtensionOperations []*GoogleCloudAiplatformV1beta1ExtensionOperation `json:"extensionOperations,omitempty"`
	// Manifest: Required. Manifest of the Extension.
	Manifest *GoogleCloudAiplatformV1beta1ExtensionManifest `json:"manifest,omitempty"`
	// Name: Identifier. The resource name of the Extension.
	Name string `json:"name,omitempty"`
	// PrivateServiceConnectConfig: Optional. The PrivateServiceConnect config for
	// the extension. If specified, the service endpoints associated with the
	// Extension should be registered with private network access in the provided
	// Service Directory
	// (https://cloud.google.com/service-directory/docs/configuring-private-network-access).
	// If the service contains more than one endpoint with a network, the service
	// will arbitrarilty choose one of the endpoints to use for extension
	// execution.
	PrivateServiceConnectConfig *GoogleCloudAiplatformV1beta1ExtensionPrivateServiceConnectConfig `json:"privateServiceConnectConfig,omitempty"`
	// RuntimeConfig: Optional. Runtime config controlling the runtime behavior of
	// this Extension.
	RuntimeConfig *GoogleCloudAiplatformV1beta1RuntimeConfig `json:"runtimeConfig,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// ToolUseExamples: Optional. Examples to illustrate the usage of the extension
	// as a tool.
	ToolUseExamples []*GoogleCloudAiplatformV1beta1ToolUseExample `json:"toolUseExamples,omitempty"`
	// UpdateTime: Output only. Timestamp when this Extension was most recently
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Extension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Extension
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExtensionManifest: Manifest spec of an Extension
// needed for runtime execution.
type GoogleCloudAiplatformV1beta1ExtensionManifest struct {
	// ApiSpec: Required. Immutable. The API specification shown to the LLM.
	ApiSpec *GoogleCloudAiplatformV1beta1ExtensionManifestApiSpec `json:"apiSpec,omitempty"`
	// AuthConfig: Required. Immutable. Type of auth supported by this extension.
	AuthConfig *GoogleCloudAiplatformV1beta1AuthConfig `json:"authConfig,omitempty"`
	// Description: Required. The natural language description shown to the LLM. It
	// should describe the usage of the extension, and is essential for the LLM to
	// perform reasoning. e.g., if the extension is a data store, you can let the
	// LLM know what data it contains.
	Description string `json:"description,omitempty"`
	// Name: Required. Extension name shown to the LLM. The name can be up to 128
	// characters long.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiSpec") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExtensionManifest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExtensionManifest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExtensionManifestApiSpec: The API specification
// shown to the LLM.
type GoogleCloudAiplatformV1beta1ExtensionManifestApiSpec struct {
	// OpenApiGcsUri: Cloud Storage URI pointing to the OpenAPI spec.
	OpenApiGcsUri string `json:"openApiGcsUri,omitempty"`
	// OpenApiYaml: The API spec in Open API standard and YAML format.
	OpenApiYaml string `json:"openApiYaml,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OpenApiGcsUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OpenApiGcsUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExtensionManifestApiSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExtensionManifestApiSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExtensionOperation: Operation of an extension.
type GoogleCloudAiplatformV1beta1ExtensionOperation struct {
	// FunctionDeclaration: Output only. Structured representation of a function
	// declaration as defined by the OpenAPI Spec.
	FunctionDeclaration *GoogleCloudAiplatformV1beta1FunctionDeclaration `json:"functionDeclaration,omitempty"`
	// OperationId: Operation ID that uniquely identifies the operations among the
	// extension. See: "Operation Object" in https://swagger.io/specification/.
	// This field is parsed from the OpenAPI spec. For HTTP extensions, if it does
	// not exist in the spec, we will generate one from the HTTP method and path.
	OperationId string `json:"operationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FunctionDeclaration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FunctionDeclaration") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExtensionOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExtensionOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ExtensionPrivateServiceConnectConfig:
// PrivateExtensionConfig configuration for the extension.
type GoogleCloudAiplatformV1beta1ExtensionPrivateServiceConnectConfig struct {
	// ServiceDirectory: Required. The Service Directory resource name in which the
	// service endpoints associated to the extension are registered. Format:
	// `projects/{project_id}/locations/{location_id}/namespaces/{namespace_id}/serv
	// ices/{service_id}` - The Vertex AI Extension Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// should be granted `servicedirectory.viewer` and
	// `servicedirectory.pscAuthorizedService` roles on the resource.
	ServiceDirectory string `json:"serviceDirectory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceDirectory") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceDirectory") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ExtensionPrivateServiceConnectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ExtensionPrivateServiceConnectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Fact: The fact used in grounding.
type GoogleCloudAiplatformV1beta1Fact struct {
	// Query: Query that is used to retrieve this fact.
	Query string `json:"query,omitempty"`
	// Score: If present, according to the underlying Vector DB and the selected
	// metric type, the score can be either the distance or the similarity between
	// the query and the fact and its range depends on the metric type. For
	// example, if the metric type is COSINE_DISTANCE, it represents the distance
	// between the query and the fact. The larger the distance, the less relevant
	// the fact is to the query. The range is [0, 2], while 0 means the most
	// relevant and 2 means the least relevant.
	Score float64 `json:"score,omitempty"`
	// Summary: If present, the summary/snippet of the fact.
	Summary string `json:"summary,omitempty"`
	// Title: If present, it refers to the title of this fact.
	Title string `json:"title,omitempty"`
	// Uri: If present, this uri links to the source of the fact.
	Uri string `json:"uri,omitempty"`
	// VectorDistance: If present, the distance between the query vector and this
	// fact vector.
	VectorDistance float64 `json:"vectorDistance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Fact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Fact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1Fact) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1Fact
	var s1 struct {
		Score          gensupport.JSONFloat64 `json:"score"`
		VectorDistance gensupport.JSONFloat64 `json:"vectorDistance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	s.VectorDistance = float64(s1.VectorDistance)
	return nil
}

// GoogleCloudAiplatformV1beta1FasterDeploymentConfig: Configuration for faster
// model deployment.
type GoogleCloudAiplatformV1beta1FasterDeploymentConfig struct {
	// FastTryoutEnabled: If true, enable fast tryout feature for this deployed
	// model.
	FastTryoutEnabled bool `json:"fastTryoutEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FastTryoutEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FastTryoutEnabled") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FasterDeploymentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FasterDeploymentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Feature: Feature Metadata information. For
// example, color is a feature that describes an apple.
type GoogleCloudAiplatformV1beta1Feature struct {
	// CreateTime: Output only. Only applicable for Vertex AI Feature Store
	// (Legacy). Timestamp when this EntityType was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Description of the Feature.
	Description string `json:"description,omitempty"`
	// DisableMonitoring: Optional. Only applicable for Vertex AI Feature Store
	// (Legacy). If not set, use the monitoring_config defined for the EntityType
	// this Feature belongs to. Only Features with type (Feature.ValueType) BOOL,
	// STRING, DOUBLE or INT64 can enable monitoring. If set to true, all types of
	// data monitoring are disabled despite the config on EntityType.
	DisableMonitoring bool `json:"disableMonitoring,omitempty"`
	// Etag: Used to perform a consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// FeatureStatsAndAnomaly: Output only. Only applicable for Vertex AI Feature
	// Store. The list of historical stats and anomalies.
	FeatureStatsAndAnomaly []*GoogleCloudAiplatformV1beta1FeatureStatsAndAnomaly `json:"featureStatsAndAnomaly,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// Features. Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. See
	// https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one Feature (System labels
	// are excluded)." System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// MonitoringConfig: Optional. Only applicable for Vertex AI Feature Store
	// (Legacy). Deprecated: The custom monitoring configuration for this Feature,
	// if not set, use the monitoring_config defined for the EntityType this
	// Feature belongs to. Only Features with type (Feature.ValueType) BOOL,
	// STRING, DOUBLE or INT64 can enable monitoring. If this is populated with
	// FeaturestoreMonitoringConfig.disabled = true, snapshot analysis monitoring
	// is disabled; if FeaturestoreMonitoringConfig.monitoring_interval specified,
	// snapshot analysis monitoring is enabled. Otherwise, snapshot analysis
	// monitoring config is same as the EntityType's this Feature belongs to.
	MonitoringConfig *GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfig `json:"monitoringConfig,omitempty"`
	// MonitoringStats: Output only. Only applicable for Vertex AI Feature Store
	// (Legacy). A list of historical SnapshotAnalysis stats requested by user,
	// sorted by FeatureStatsAnomaly.start_time descending.
	MonitoringStats []*GoogleCloudAiplatformV1beta1FeatureStatsAnomaly `json:"monitoringStats,omitempty"`
	// MonitoringStatsAnomalies: Output only. Only applicable for Vertex AI Feature
	// Store (Legacy). The list of historical stats and anomalies with specified
	// objectives.
	MonitoringStatsAnomalies []*GoogleCloudAiplatformV1beta1FeatureMonitoringStatsAnomaly `json:"monitoringStatsAnomalies,omitempty"`
	// Name: Immutable. Name of the Feature. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityT
	// ypes/{entity_type}/features/{feature}`
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}/featur
	// es/{feature}` The last part feature is assigned by the client. The feature
	// can be up to 64 characters long and can consist only of ASCII Latin letters
	// A-Z and a-z, underscore(_), and ASCII digits 0-9 starting with a letter. The
	// value will be unique given an entity type.
	Name string `json:"name,omitempty"`
	// PointOfContact: Entity responsible for maintaining this feature. Can be
	// comma separated list of email addresses or URIs.
	PointOfContact string `json:"pointOfContact,omitempty"`
	// UpdateTime: Output only. Only applicable for Vertex AI Feature Store
	// (Legacy). Timestamp when this EntityType was most recently updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ValueType: Immutable. Only applicable for Vertex AI Feature Store (Legacy).
	// Type of Feature value.
	//
	// Possible values:
	//   "VALUE_TYPE_UNSPECIFIED" - The value type is unspecified.
	//   "BOOL" - Used for Feature that is a boolean.
	//   "BOOL_ARRAY" - Used for Feature that is a list of boolean.
	//   "DOUBLE" - Used for Feature that is double.
	//   "DOUBLE_ARRAY" - Used for Feature that is a list of double.
	//   "INT64" - Used for Feature that is INT64.
	//   "INT64_ARRAY" - Used for Feature that is a list of INT64.
	//   "STRING" - Used for Feature that is string.
	//   "STRING_ARRAY" - Used for Feature that is a list of String.
	//   "BYTES" - Used for Feature that is bytes.
	//   "STRUCT" - Used for Feature that is struct.
	ValueType string `json:"valueType,omitempty"`
	// VersionColumnName: Only applicable for Vertex AI Feature Store. The name of
	// the BigQuery Table/View column hosting data for this version. If no value is
	// provided, will use feature_id.
	VersionColumnName string `json:"versionColumnName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Feature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Feature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureGroup: Vertex AI Feature Group.
type GoogleCloudAiplatformV1beta1FeatureGroup struct {
	// BigQuery: Indicates that features for this group come from BigQuery
	// Table/View. By default treats the source as a sparse time series source. The
	// BigQuery source table or view must have at least one entity ID column and a
	// column named `feature_timestamp`.
	BigQuery *GoogleCloudAiplatformV1beta1FeatureGroupBigQuery `json:"bigQuery,omitempty"`
	// CreateTime: Output only. Timestamp when this FeatureGroup was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the FeatureGroup.
	Description string `json:"description,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// FeatureGroup. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one FeatureGroup(System
	// labels are excluded)." System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the FeatureGroup. Format:
	// `projects/{project}/locations/{location}/featureGroups/{featureGroup}`
	Name string `json:"name,omitempty"`
	// ServiceAccountEmail: Output only. A Service Account unique to this
	// FeatureGroup. The role bigquery.dataViewer should be granted to this service
	// account to allow Vertex AI Feature Store to access source data while running
	// jobs under this FeatureGroup.
	ServiceAccountEmail string `json:"serviceAccountEmail,omitempty"`
	// ServiceAgentType: Optional. Service agent type used during jobs under a
	// FeatureGroup. By default, the Vertex AI Service Agent is used. When using an
	// IAM Policy to isolate this FeatureGroup within a project, a separate service
	// account should be provisioned by setting this field to
	// `SERVICE_AGENT_TYPE_FEATURE_GROUP`. This will generate a separate service
	// account to access the BigQuery source table.
	//
	// Possible values:
	//   "SERVICE_AGENT_TYPE_UNSPECIFIED" - By default, the project-level Vertex AI
	// Service Agent is enabled.
	//   "SERVICE_AGENT_TYPE_PROJECT" - Specifies the project-level Vertex AI
	// Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
	//   "SERVICE_AGENT_TYPE_FEATURE_GROUP" - Enable a FeatureGroup service account
	// to be created by Vertex AI and output in the field `service_account_email`.
	// This service account will be used to read from the source BigQuery table
	// during jobs under a FeatureGroup.
	ServiceAgentType string `json:"serviceAgentType,omitempty"`
	// UpdateTime: Output only. Timestamp when this FeatureGroup was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BigQuery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQuery") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureGroupBigQuery: Input source type for
// BigQuery Tables and Views.
type GoogleCloudAiplatformV1beta1FeatureGroupBigQuery struct {
	// BigQuerySource: Required. Immutable. The BigQuery source URI that points to
	// either a BigQuery Table or View.
	BigQuerySource *GoogleCloudAiplatformV1beta1BigQuerySource `json:"bigQuerySource,omitempty"`
	// Dense: Optional. If set, all feature values will be fetched from a single
	// row per unique entityId including nulls. If not set, will collapse all rows
	// for each unique entityId into a singe row with any non-null values if
	// present, if no non-null values are present will sync null. ex: If source has
	// schema `(entity_id, feature_timestamp, f0, f1)` and the following rows:
	// `(e1, 2020-01-01T10:00:00.123Z, 10, 15)` `(e1, 2020-02-01T10:00:00.123Z, 20,
	// null)` If dense is set, `(e1, 20, null)` is synced to online stores. If
	// dense is not set, `(e1, 20, 15)` is synced to online stores.
	Dense bool `json:"dense,omitempty"`
	// EntityIdColumns: Optional. Columns to construct entity_id / row keys. If not
	// provided defaults to `entity_id`.
	EntityIdColumns []string `json:"entityIdColumns,omitempty"`
	// StaticDataSource: Optional. Set if the data source is not a time-series.
	StaticDataSource bool `json:"staticDataSource,omitempty"`
	// TimeSeries: Optional. If the source is a time-series source, this can be set
	// to control how downstream sources (ex: FeatureView ) will treat time-series
	// sources. If not set, will treat the source as a time-series source with
	// `feature_timestamp` as timestamp column and no scan boundary.
	TimeSeries *GoogleCloudAiplatformV1beta1FeatureGroupBigQueryTimeSeries `json:"timeSeries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQuerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureGroupBigQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureGroupBigQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1beta1FeatureGroupBigQueryTimeSeries struct {
	// TimestampColumn: Optional. Column hosting timestamp values for a time-series
	// source. Will be used to determine the latest `feature_values` for each
	// entity. Optional. If not provided, column named `feature_timestamp` of type
	// `TIMESTAMP` will be used.
	TimestampColumn string `json:"timestampColumn,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TimestampColumn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TimestampColumn") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureGroupBigQueryTimeSeries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureGroupBigQueryTimeSeries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureMonitor: Vertex AI Feature Monitor.
type GoogleCloudAiplatformV1beta1FeatureMonitor struct {
	// CreateTime: Output only. Timestamp when this FeatureMonitor was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the FeatureMonitor.
	Description string `json:"description,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// FeatureSelectionConfig: Required. Feature selection config for the
	// FeatureMonitor.
	FeatureSelectionConfig *GoogleCloudAiplatformV1beta1FeatureSelectionConfig `json:"featureSelectionConfig,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// FeatureMonitor. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one FeatureMonitor(System
	// labels are excluded)." System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the FeatureMonitor. Format:
	// `projects/{project}/locations/{location}/featureGroups/{featureGroup}/feature
	// Monitors/{featureMonitor}`
	Name string `json:"name,omitempty"`
	// ScheduleConfig: Required. Schedule config for the FeatureMonitor.
	ScheduleConfig *GoogleCloudAiplatformV1beta1ScheduleConfig `json:"scheduleConfig,omitempty"`
	// UpdateTime: Output only. Timestamp when this FeatureMonitor was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureMonitor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureMonitor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureMonitorJob: Vertex AI Feature Monitor
// Job.
type GoogleCloudAiplatformV1beta1FeatureMonitorJob struct {
	// CreateTime: Output only. Timestamp when this FeatureMonitorJob was created.
	// Creation of a FeatureMonitorJob means that the job is pending / waiting for
	// sufficient resources but may not have started running yet.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of the FeatureMonitor.
	Description string `json:"description,omitempty"`
	// DriftBaseFeatureMonitorJobId: Output only. FeatureMonitorJob ID comparing to
	// which the drift is calculated.
	DriftBaseFeatureMonitorJobId int64 `json:"driftBaseFeatureMonitorJobId,omitempty,string"`
	// DriftBaseSnapshotTime: Output only. Data snapshot time comparing to which
	// the drift is calculated.
	DriftBaseSnapshotTime string `json:"driftBaseSnapshotTime,omitempty"`
	// FeatureSelectionConfig: Output only. Feature selection config used when
	// creating FeatureMonitorJob.
	FeatureSelectionConfig *GoogleCloudAiplatformV1beta1FeatureSelectionConfig `json:"featureSelectionConfig,omitempty"`
	// FinalStatus: Output only. Final status of the FeatureMonitorJob.
	FinalStatus *GoogleRpcStatus `json:"finalStatus,omitempty"`
	// JobSummary: Output only. Summary from the FeatureMonitorJob.
	JobSummary *GoogleCloudAiplatformV1beta1FeatureMonitorJobJobSummary `json:"jobSummary,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// FeatureMonitorJob. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one FeatureMonitor(System
	// labels are excluded)." System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the FeatureMonitorJob. Format:
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}/featur
	// eMonitors/{feature_monitor}/featureMonitorJobs/{feature_monitor_job}`.
	Name string `json:"name,omitempty"`
	// TriggerType: Output only. Trigger type of the Feature Monitor Job.
	//
	// Possible values:
	//   "FEATURE_MONITOR_JOB_TRIGGER_UNSPECIFIED" - Trigger type unspecified.
	//   "FEATURE_MONITOR_JOB_TRIGGER_PERIODIC" - Triggered by periodic schedule.
	//   "FEATURE_MONITOR_JOB_TRIGGER_ON_DEMAND" - Triggered on demand by
	// CreateFeatureMonitorJob request.
	TriggerType string `json:"triggerType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureMonitorJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureMonitorJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureMonitorJobJobSummary: Summary from the
// FeatureMonitorJob.
type GoogleCloudAiplatformV1beta1FeatureMonitorJobJobSummary struct {
	// FeatureStatsAndAnomalies: Output only. Features and their stats and
	// anomalies
	FeatureStatsAndAnomalies []*GoogleCloudAiplatformV1beta1FeatureStatsAndAnomaly `json:"featureStatsAndAnomalies,omitempty"`
	// TotalSlotMs: Output only. BigQuery slot milliseconds consumed.
	TotalSlotMs int64 `json:"totalSlotMs,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FeatureStatsAndAnomalies")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureStatsAndAnomalies") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureMonitorJobJobSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureMonitorJobJobSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureMonitoringStatsAnomaly: A list of
// historical SnapshotAnalysis or ImportFeaturesAnalysis stats requested by
// user, sorted by FeatureStatsAnomaly.start_time descending.
type GoogleCloudAiplatformV1beta1FeatureMonitoringStatsAnomaly struct {
	// FeatureStatsAnomaly: Output only. The stats and anomalies generated at
	// specific timestamp.
	FeatureStatsAnomaly *GoogleCloudAiplatformV1beta1FeatureStatsAnomaly `json:"featureStatsAnomaly,omitempty"`
	// Objective: Output only. The objective for each stats.
	//
	// Possible values:
	//   "OBJECTIVE_UNSPECIFIED" - If it's OBJECTIVE_UNSPECIFIED, monitoring_stats
	// will be empty.
	//   "IMPORT_FEATURE_ANALYSIS" - Stats are generated by Import Feature
	// Analysis.
	//   "SNAPSHOT_ANALYSIS" - Stats are generated by Snapshot Analysis.
	Objective string `json:"objective,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeatureStatsAnomaly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureStatsAnomaly") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureMonitoringStatsAnomaly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureMonitoringStatsAnomaly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureNoiseSigma: Noise sigma by features.
// Noise sigma represents the standard deviation of the gaussian kernel that
// will be used to add noise to interpolated inputs prior to computing
// gradients.
type GoogleCloudAiplatformV1beta1FeatureNoiseSigma struct {
	// NoiseSigma: Noise sigma per feature. No noise is added to features that are
	// not set.
	NoiseSigma []*GoogleCloudAiplatformV1beta1FeatureNoiseSigmaNoiseSigmaForFeature `json:"noiseSigma,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoiseSigma") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoiseSigma") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureNoiseSigma) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureNoiseSigma
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureNoiseSigmaNoiseSigmaForFeature: Noise
// sigma for a single feature.
type GoogleCloudAiplatformV1beta1FeatureNoiseSigmaNoiseSigmaForFeature struct {
	// Name: The name of the input feature for which noise sigma is provided. The
	// features are defined in explanation metadata inputs.
	Name string `json:"name,omitempty"`
	// Sigma: This represents the standard deviation of the Gaussian kernel that
	// will be used to add noise to the feature prior to computing gradients.
	// Similar to noise_sigma but represents the noise added to the current
	// feature. Defaults to 0.1.
	Sigma float64 `json:"sigma,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureNoiseSigmaNoiseSigmaForFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureNoiseSigmaNoiseSigmaForFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FeatureNoiseSigmaNoiseSigmaForFeature) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureNoiseSigmaNoiseSigmaForFeature
	var s1 struct {
		Sigma gensupport.JSONFloat64 `json:"sigma"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Sigma = float64(s1.Sigma)
	return nil
}

// GoogleCloudAiplatformV1beta1FeatureOnlineStore: Vertex AI Feature Online
// Store provides a centralized repository for serving ML features and
// embedding indexes at low latency. The Feature Online Store is a top-level
// container.
type GoogleCloudAiplatformV1beta1FeatureOnlineStore struct {
	// Bigtable: Contains settings for the Cloud Bigtable instance that will be
	// created to serve featureValues for all FeatureViews under this
	// FeatureOnlineStore.
	Bigtable *GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtable `json:"bigtable,omitempty"`
	// CreateTime: Output only. Timestamp when this FeatureOnlineStore was created.
	CreateTime string `json:"createTime,omitempty"`
	// DedicatedServingEndpoint: Optional. The dedicated serving endpoint for this
	// FeatureOnlineStore, which is different from common Vertex service endpoint.
	DedicatedServingEndpoint *GoogleCloudAiplatformV1beta1FeatureOnlineStoreDedicatedServingEndpoint `json:"dedicatedServingEndpoint,omitempty"`
	// EmbeddingManagement: Optional. Deprecated: This field is no longer needed
	// anymore and embedding management is automatically enabled when specifying
	// Optimized storage type.
	EmbeddingManagement *GoogleCloudAiplatformV1beta1FeatureOnlineStoreEmbeddingManagement `json:"embeddingManagement,omitempty"`
	// EncryptionSpec: Optional. Customer-managed encryption key spec for data
	// storage. If set, online store will be secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// FeatureOnlineStore. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one
	// FeatureOnlineStore(System labels are excluded)." System reserved label keys
	// are prefixed with "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the FeatureOnlineStore. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{featureOnlineSt
	// ore}`
	Name string `json:"name,omitempty"`
	// Optimized: Contains settings for the Optimized store that will be created to
	// serve featureValues for all FeatureViews under this FeatureOnlineStore. When
	// choose Optimized storage type, need to set
	// PrivateServiceConnectConfig.enable_private_service_connect to use private
	// endpoint. Otherwise will use public endpoint by default.
	Optimized *GoogleCloudAiplatformV1beta1FeatureOnlineStoreOptimized `json:"optimized,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// State: Output only. State of the featureOnlineStore.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "STABLE" - State when the featureOnlineStore configuration is not being
	// updated and the fields reflect the current configuration of the
	// featureOnlineStore. The featureOnlineStore is usable in this state.
	//   "UPDATING" - The state of the featureOnlineStore configuration when it is
	// being updated. During an update, the fields reflect either the original
	// configuration or the updated configuration of the featureOnlineStore. The
	// featureOnlineStore is still usable in this state.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp when this FeatureOnlineStore was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Bigtable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bigtable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureOnlineStore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureOnlineStore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtable struct {
	// AutoScaling: Required. Autoscaling config applied to Bigtable Instance.
	AutoScaling *GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtableAutoScaling `json:"autoScaling,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoScaling") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoScaling") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtable) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtableAutoScaling struct {
	// CpuUtilizationTarget: Optional. A percentage of the cluster's CPU capacity.
	// Can be from 10% to 80%. When a cluster's CPU utilization exceeds the target
	// that you have set, Bigtable immediately adds nodes to the cluster. When CPU
	// utilization is substantially lower than the target, Bigtable removes nodes.
	// If not set will default to 50%.
	CpuUtilizationTarget int64 `json:"cpuUtilizationTarget,omitempty"`
	// MaxNodeCount: Required. The maximum number of nodes to scale up to. Must be
	// greater than or equal to min_node_count, and less than or equal to 10 times
	// of 'min_node_count'.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty"`
	// MinNodeCount: Required. The minimum number of nodes to scale down to. Must
	// be greater than or equal to 1.
	MinNodeCount int64 `json:"minNodeCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CpuUtilizationTarget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CpuUtilizationTarget") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtableAutoScaling) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureOnlineStoreBigtableAutoScaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureOnlineStoreDedicatedServingEndpoint: The
// dedicated serving endpoint for this FeatureOnlineStore. Only need to set
// when you choose Optimized storage type. Public endpoint is provisioned by
// default.
type GoogleCloudAiplatformV1beta1FeatureOnlineStoreDedicatedServingEndpoint struct {
	// PrivateServiceConnectConfig: Optional. Private service connect config. The
	// private service connection is available only for Optimized storage type, not
	// for embedding management now. If
	// PrivateServiceConnectConfig.enable_private_service_connect set to true,
	// customers will use private service connection to send request. Otherwise,
	// the connection will set to public endpoint.
	PrivateServiceConnectConfig *GoogleCloudAiplatformV1beta1PrivateServiceConnectConfig `json:"privateServiceConnectConfig,omitempty"`
	// PublicEndpointDomainName: Output only. This field will be populated with the
	// domain name to use for this FeatureOnlineStore
	PublicEndpointDomainName string `json:"publicEndpointDomainName,omitempty"`
	// ServiceAttachment: Output only. The name of the service attachment resource.
	// Populated if private service connect is enabled and after FeatureViewSync is
	// created.
	ServiceAttachment string `json:"serviceAttachment,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "PrivateServiceConnectConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrivateServiceConnectConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureOnlineStoreDedicatedServingEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureOnlineStoreDedicatedServingEndpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureOnlineStoreEmbeddingManagement:
// Deprecated: This sub message is no longer needed anymore and embedding
// management is automatically enabled when specifying Optimized storage type.
// Contains settings for embedding management.
type GoogleCloudAiplatformV1beta1FeatureOnlineStoreEmbeddingManagement struct {
	// Enabled: Optional. Immutable. Whether to enable embedding management in this
	// FeatureOnlineStore. It's immutable after creation to ensure the
	// FeatureOnlineStore availability.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureOnlineStoreEmbeddingManagement) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureOnlineStoreEmbeddingManagement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureOnlineStoreOptimized: Optimized storage
// type
type GoogleCloudAiplatformV1beta1FeatureOnlineStoreOptimized struct {
}

// GoogleCloudAiplatformV1beta1FeatureSelectionConfig: Feature selection
// configuration for the FeatureMonitor.
type GoogleCloudAiplatformV1beta1FeatureSelectionConfig struct {
	// FeatureConfigs: Optional. A list of features to be monitored and each
	// feature's drift threshold.
	FeatureConfigs []*GoogleCloudAiplatformV1beta1FeatureSelectionConfigFeatureConfig `json:"featureConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeatureConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureSelectionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureSelectionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureSelectionConfigFeatureConfig: Feature
// configuration.
type GoogleCloudAiplatformV1beta1FeatureSelectionConfigFeatureConfig struct {
	// DriftThreshold: Optional. Drift threshold. If calculated difference with
	// baseline data larger than threshold, it will be considered as the feature
	// has drift. If not present, the threshold will be default to 0.3.
	DriftThreshold float64 `json:"driftThreshold,omitempty"`
	// FeatureId: Required. The ID of the feature resource. Final component of the
	// Feature's resource name.
	FeatureId string `json:"featureId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DriftThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DriftThreshold") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureSelectionConfigFeatureConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureSelectionConfigFeatureConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FeatureSelectionConfigFeatureConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureSelectionConfigFeatureConfig
	var s1 struct {
		DriftThreshold gensupport.JSONFloat64 `json:"driftThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DriftThreshold = float64(s1.DriftThreshold)
	return nil
}

// GoogleCloudAiplatformV1beta1FeatureSelector: Selector for Features of an
// EntityType.
type GoogleCloudAiplatformV1beta1FeatureSelector struct {
	// IdMatcher: Required. Matches Features based on ID.
	IdMatcher *GoogleCloudAiplatformV1beta1IdMatcher `json:"idMatcher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdMatcher") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdMatcher") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureStatsAndAnomaly: Stats and Anomaly
// generated by FeatureMonitorJobs. Anomaly only includes Drift.
type GoogleCloudAiplatformV1beta1FeatureStatsAndAnomaly struct {
	// DistributionDeviation: Deviation from the current stats to baseline stats.
	// 1. For categorical feature, the distribution distance is calculated by
	// L-inifinity norm. 2. For numerical feature, the distribution distance is
	// calculated by Jensen–Shannon divergence.
	DistributionDeviation float64 `json:"distributionDeviation,omitempty"`
	// DriftDetected: If set to true, indicates current stats is detected as and
	// comparing with baseline stats.
	DriftDetected bool `json:"driftDetected,omitempty"`
	// DriftDetectionThreshold: This is the threshold used when detecting drifts,
	// which is set in
	// FeatureMonitor.FeatureSelectionConfig.FeatureConfig.drift_threshold
	DriftDetectionThreshold float64 `json:"driftDetectionThreshold,omitempty"`
	// FeatureId: Feature Id.
	FeatureId string `json:"featureId,omitempty"`
	// FeatureMonitorId: The ID of the FeatureMonitor that this
	// FeatureStatsAndAnomaly generated according to.
	FeatureMonitorId string `json:"featureMonitorId,omitempty"`
	// FeatureMonitorJobId: The ID of the FeatureMonitorJob that generated this
	// FeatureStatsAndAnomaly.
	FeatureMonitorJobId int64 `json:"featureMonitorJobId,omitempty,string"`
	// FeatureStats: Feature stats. e.g. histogram buckets. In the format of
	// tensorflow.metadata.v0.DatasetFeatureStatistics.
	FeatureStats interface{} `json:"featureStats,omitempty"`
	// StatsTime: The timestamp we take snapshot for feature values to generate
	// stats.
	StatsTime string `json:"statsTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DistributionDeviation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DistributionDeviation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureStatsAndAnomaly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureStatsAndAnomaly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FeatureStatsAndAnomaly) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureStatsAndAnomaly
	var s1 struct {
		DistributionDeviation   gensupport.JSONFloat64 `json:"distributionDeviation"`
		DriftDetectionThreshold gensupport.JSONFloat64 `json:"driftDetectionThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DistributionDeviation = float64(s1.DistributionDeviation)
	s.DriftDetectionThreshold = float64(s1.DriftDetectionThreshold)
	return nil
}

// GoogleCloudAiplatformV1beta1FeatureStatsAnomaly: Stats and Anomaly generated
// at specific timestamp for specific Feature. The start_time and end_time are
// used to define the time range of the dataset that current stats belongs to,
// e.g. prediction traffic is bucketed into prediction datasets by time window.
// If the Dataset is not defined by time window, start_time = end_time.
// Timestamp of the stats and anomalies always refers to end_time. Raw stats
// and anomalies are stored in stats_uri or anomaly_uri in the tensorflow
// defined protos. Field data_stats contains almost identical information with
// the raw stats in Vertex AI defined proto, for UI to display.
type GoogleCloudAiplatformV1beta1FeatureStatsAnomaly struct {
	// AnomalyDetectionThreshold: This is the threshold used when detecting
	// anomalies. The threshold can be changed by user, so this one might be
	// different from ThresholdConfig.value.
	AnomalyDetectionThreshold float64 `json:"anomalyDetectionThreshold,omitempty"`
	// AnomalyUri: Path of the anomaly file for current feature values in Cloud
	// Storage bucket. Format: gs:////anomalies. Example:
	// gs://monitoring_bucket/feature_name/anomalies. Stats are stored as binary
	// format with Protobuf message Anoamlies are stored as binary format with
	// Protobuf message [tensorflow.metadata.v0.AnomalyInfo]
	// (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/anomalies.proto).
	AnomalyUri string `json:"anomalyUri,omitempty"`
	// DistributionDeviation: Deviation from the current stats to baseline stats.
	// 1. For categorical feature, the distribution distance is calculated by
	// L-inifinity norm. 2. For numerical feature, the distribution distance is
	// calculated by Jensen–Shannon divergence.
	DistributionDeviation float64 `json:"distributionDeviation,omitempty"`
	// EndTime: The end timestamp of window where stats were generated. For
	// objectives where time window doesn't make sense (e.g. Featurestore Snapshot
	// Monitoring), end_time indicates the timestamp of the data used to generate
	// stats (e.g. timestamp we take snapshots for feature values).
	EndTime string `json:"endTime,omitempty"`
	// Score: Feature importance score, only populated when cross-feature
	// monitoring is enabled. For now only used to represent feature attribution
	// score within range [0, 1] for
	// ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_SKEW and
	// ModelDeploymentMonitoringObjectiveType.FEATURE_ATTRIBUTION_DRIFT.
	Score float64 `json:"score,omitempty"`
	// StartTime: The start timestamp of window where stats were generated. For
	// objectives where time window doesn't make sense (e.g. Featurestore Snapshot
	// Monitoring), start_time is only used to indicate the monitoring intervals,
	// so it always equals to (end_time - monitoring_interval).
	StartTime string `json:"startTime,omitempty"`
	// StatsUri: Path of the stats file for current feature values in Cloud Storage
	// bucket. Format: gs:////stats. Example:
	// gs://monitoring_bucket/feature_name/stats. Stats are stored as binary format
	// with Protobuf message tensorflow.metadata.v0.FeatureNameStatistics
	// (https://github.com/tensorflow/metadata/blob/master/tensorflow_metadata/proto/v0/statistics.proto).
	StatsUri string `json:"statsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnomalyDetectionThreshold")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnomalyDetectionThreshold") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureStatsAnomaly) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureStatsAnomaly
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FeatureStatsAnomaly) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureStatsAnomaly
	var s1 struct {
		AnomalyDetectionThreshold gensupport.JSONFloat64 `json:"anomalyDetectionThreshold"`
		DistributionDeviation     gensupport.JSONFloat64 `json:"distributionDeviation"`
		Score                     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AnomalyDetectionThreshold = float64(s1.AnomalyDetectionThreshold)
	s.DistributionDeviation = float64(s1.DistributionDeviation)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1beta1FeatureValue: Value for a feature.
type GoogleCloudAiplatformV1beta1FeatureValue struct {
	// BoolArrayValue: A list of bool type feature value.
	BoolArrayValue *GoogleCloudAiplatformV1beta1BoolArray `json:"boolArrayValue,omitempty"`
	// BoolValue: Bool type feature value.
	BoolValue bool `json:"boolValue,omitempty"`
	// BytesValue: Bytes feature value.
	BytesValue string `json:"bytesValue,omitempty"`
	// DoubleArrayValue: A list of double type feature value.
	DoubleArrayValue *GoogleCloudAiplatformV1beta1DoubleArray `json:"doubleArrayValue,omitempty"`
	// DoubleValue: Double type feature value.
	DoubleValue float64 `json:"doubleValue,omitempty"`
	// Int64ArrayValue: A list of int64 type feature value.
	Int64ArrayValue *GoogleCloudAiplatformV1beta1Int64Array `json:"int64ArrayValue,omitempty"`
	// Int64Value: Int64 feature value.
	Int64Value int64 `json:"int64Value,omitempty,string"`
	// Metadata: Metadata of feature value.
	Metadata *GoogleCloudAiplatformV1beta1FeatureValueMetadata `json:"metadata,omitempty"`
	// StringArrayValue: A list of string type feature value.
	StringArrayValue *GoogleCloudAiplatformV1beta1StringArray `json:"stringArrayValue,omitempty"`
	// StringValue: String feature value.
	StringValue string `json:"stringValue,omitempty"`
	// StructValue: A struct type feature value.
	StructValue *GoogleCloudAiplatformV1beta1StructValue `json:"structValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoolArrayValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoolArrayValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FeatureValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureValue
	var s1 struct {
		DoubleValue gensupport.JSONFloat64 `json:"doubleValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DoubleValue = float64(s1.DoubleValue)
	return nil
}

// GoogleCloudAiplatformV1beta1FeatureValueDestination: A destination location
// for Feature values and format.
type GoogleCloudAiplatformV1beta1FeatureValueDestination struct {
	// BigqueryDestination: Output in BigQuery format.
	// BigQueryDestination.output_uri in
	// FeatureValueDestination.bigquery_destination must refer to a table.
	BigqueryDestination *GoogleCloudAiplatformV1beta1BigQueryDestination `json:"bigqueryDestination,omitempty"`
	// CsvDestination: Output in CSV format. Array Feature value types are not
	// allowed in CSV format.
	CsvDestination *GoogleCloudAiplatformV1beta1CsvDestination `json:"csvDestination,omitempty"`
	// TfrecordDestination: Output in TFRecord format. Below are the mapping from
	// Feature value type in Featurestore to Feature value type in TFRecord: Value
	// type in Featurestore | Value type in TFRecord DOUBLE, DOUBLE_ARRAY |
	// FLOAT_LIST INT64, INT64_ARRAY | INT64_LIST STRING, STRING_ARRAY, BYTES |
	// BYTES_LIST true -> byte_string("true"), false -> byte_string("false") BOOL,
	// BOOL_ARRAY (true, false) | BYTES_LIST
	TfrecordDestination *GoogleCloudAiplatformV1beta1TFRecordDestination `json:"tfrecordDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDestination") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureValueDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureValueDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureValueList: Container for list of values.
type GoogleCloudAiplatformV1beta1FeatureValueList struct {
	// Values: A list of feature values. All of them should be the same data type.
	Values []*GoogleCloudAiplatformV1beta1FeatureValue `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureValueList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureValueList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureValueMetadata: Metadata of feature value.
type GoogleCloudAiplatformV1beta1FeatureValueMetadata struct {
	// GenerateTime: Feature generation timestamp. Typically, it is provided by
	// user at feature ingestion time. If not, feature store will use the system
	// timestamp when the data is ingested into feature store. For streaming
	// ingestion, the time, aligned by days, must be no older than five years (1825
	// days) and no later than one year (366 days) in the future.
	GenerateTime string `json:"generateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenerateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenerateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureValueMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureValueMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureView: FeatureView is representation of
// values that the FeatureOnlineStore will serve based on its syncConfig.
type GoogleCloudAiplatformV1beta1FeatureView struct {
	// BigQuerySource: Optional. Configures how data is supposed to be extracted
	// from a BigQuery source to be loaded onto the FeatureOnlineStore.
	BigQuerySource *GoogleCloudAiplatformV1beta1FeatureViewBigQuerySource `json:"bigQuerySource,omitempty"`
	// CreateTime: Output only. Timestamp when this FeatureView was created.
	CreateTime string `json:"createTime,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// FeatureRegistrySource: Optional. Configures the features from a Feature
	// Registry source that need to be loaded onto the FeatureOnlineStore.
	FeatureRegistrySource *GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySource `json:"featureRegistrySource,omitempty"`
	// IndexConfig: Optional. Configuration for index preparation for vector
	// search. It contains the required configurations to create an index from
	// source data, so that approximate nearest neighbor (a.k.a ANN) algorithms
	// search can be performed during online serving.
	IndexConfig *GoogleCloudAiplatformV1beta1FeatureViewIndexConfig `json:"indexConfig,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// FeatureViews. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one
	// FeatureOnlineStore(System labels are excluded)." System reserved label keys
	// are prefixed with "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. Name of the FeatureView. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_
	// store}/featureViews/{feature_view}`
	Name string `json:"name,omitempty"`
	// OptimizedConfig: Optional. Configuration for FeatureView created under
	// Optimized FeatureOnlineStore.
	OptimizedConfig *GoogleCloudAiplatformV1beta1FeatureViewOptimizedConfig `json:"optimizedConfig,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// ServiceAccountEmail: Output only. A Service Account unique to this
	// FeatureView. The role bigquery.dataViewer should be granted to this service
	// account to allow Vertex AI Feature Store to sync data to the online store.
	ServiceAccountEmail string `json:"serviceAccountEmail,omitempty"`
	// ServiceAgentType: Optional. Service agent type used during data sync. By
	// default, the Vertex AI Service Agent is used. When using an IAM Policy to
	// isolate this FeatureView within a project, a separate service account should
	// be provisioned by setting this field to `SERVICE_AGENT_TYPE_FEATURE_VIEW`.
	// This will generate a separate service account to access the BigQuery source
	// table.
	//
	// Possible values:
	//   "SERVICE_AGENT_TYPE_UNSPECIFIED" - By default, the project-level Vertex AI
	// Service Agent is enabled.
	//   "SERVICE_AGENT_TYPE_PROJECT" - Indicates the project-level Vertex AI
	// Service Agent
	// (https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents)
	// will be used during sync jobs.
	//   "SERVICE_AGENT_TYPE_FEATURE_VIEW" - Enable a FeatureView service account
	// to be created by Vertex AI and output in the field `service_account_email`.
	// This service account will be used to read from the source BigQuery table
	// during sync.
	ServiceAgentType string `json:"serviceAgentType,omitempty"`
	// SyncConfig: Configures when data is to be synced/updated for this
	// FeatureView. At the end of the sync the latest featureValues for each
	// entityId of this FeatureView are made ready for online serving.
	SyncConfig *GoogleCloudAiplatformV1beta1FeatureViewSyncConfig `json:"syncConfig,omitempty"`
	// UpdateTime: Output only. Timestamp when this FeatureView was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// VectorSearchConfig: Optional. Deprecated: please use
	// FeatureView.index_config instead.
	VectorSearchConfig *GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfig `json:"vectorSearchConfig,omitempty"`
	// VertexRagSource: Optional. The Vertex RAG Source that the FeatureView is
	// linked to.
	VertexRagSource *GoogleCloudAiplatformV1beta1FeatureViewVertexRagSource `json:"vertexRagSource,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BigQuerySource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigQuerySource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1beta1FeatureViewBigQuerySource struct {
	// EntityIdColumns: Required. Columns to construct entity_id / row keys.
	EntityIdColumns []string `json:"entityIdColumns,omitempty"`
	// Uri: Required. The BigQuery view URI that will be materialized on each sync
	// trigger based on FeatureView.SyncConfig.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityIdColumns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityIdColumns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewBigQuerySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewBigQuerySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewDataKey: Lookup key for a feature
// view.
type GoogleCloudAiplatformV1beta1FeatureViewDataKey struct {
	// CompositeKey: The actual Entity ID will be composed from this struct. This
	// should match with the way ID is defined in the FeatureView spec.
	CompositeKey *GoogleCloudAiplatformV1beta1FeatureViewDataKeyCompositeKey `json:"compositeKey,omitempty"`
	// Key: String key to use for lookup.
	Key string `json:"key,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompositeKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompositeKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewDataKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewDataKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewDataKeyCompositeKey: ID that is
// comprised from several parts (columns).
type GoogleCloudAiplatformV1beta1FeatureViewDataKeyCompositeKey struct {
	// Parts: Parts to construct Entity ID. Should match with the same ID columns
	// as defined in FeatureView in the same order.
	Parts []string `json:"parts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewDataKeyCompositeKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewDataKeyCompositeKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequest: Request message
// for FeatureOnlineStoreService.FeatureViewDirectWrite.
type GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequest struct {
	// DataKeyAndFeatureValues: Required. The data keys and associated feature
	// values.
	DataKeyAndFeatureValues []*GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValues `json:"dataKeyAndFeatureValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataKeyAndFeatureValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataKeyAndFeatureValues") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureVal
// ues: A data key and associated feature values to write to the feature view.
type GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValues struct {
	// DataKey: The data key.
	DataKey *GoogleCloudAiplatformV1beta1FeatureViewDataKey `json:"dataKey,omitempty"`
	// Features: List of features to write.
	Features []*GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeature `json:"features,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureVal
// uesFeature: Feature name & value pair.
type GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeature struct {
	// Name: Feature short name.
	Name string `json:"name,omitempty"`
	// ValueAndTimestamp: Feature value and timestamp.
	ValueAndTimestamp *GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeatureFeatureValueAndTimestamp `json:"valueAndTimestamp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeature) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureVal
// uesFeatureFeatureValueAndTimestamp: Feature value and timestamp.
type GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeatureFeatureValueAndTimestamp struct {
	// Timestamp: The feature timestamp to store with this value. If not set, then
	// the Feature Store server will generate a timestamp when it receives the
	// write request.
	Timestamp string `json:"timestamp,omitempty"`
	// Value: The feature value.
	Value *GoogleCloudAiplatformV1beta1FeatureValue `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Timestamp") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Timestamp") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeatureFeatureValueAndTimestamp) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewDirectWriteRequestDataKeyAndFeatureValuesFeatureFeatureValueAndTimestamp
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewDirectWriteResponse: Response message
// for FeatureOnlineStoreService.FeatureViewDirectWrite.
type GoogleCloudAiplatformV1beta1FeatureViewDirectWriteResponse struct {
	// Status: Response status for the keys listed in
	// FeatureViewDirectWriteResponse.write_responses. The error only applies to
	// the listed data keys - the stream will remain open for further
	// FeatureOnlineStoreService.FeatureViewDirectWriteRequest requests. Partial
	// failures (e.g. if the first 10 keys of a request fail, but the rest succeed)
	// from a single request may result in multiple responses - there will be one
	// response for the successful request keys and one response for the failing
	// request keys.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// WriteResponses: Details about write for each key. If status is not OK,
	// WriteResponse.data_key will have the key with error, but
	// WriteResponse.online_store_write_time will not be present.
	WriteResponses []*GoogleCloudAiplatformV1beta1FeatureViewDirectWriteResponseWriteResponse `json:"writeResponses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewDirectWriteResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewDirectWriteResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewDirectWriteResponseWriteResponse:
// Details about the write for each key.
type GoogleCloudAiplatformV1beta1FeatureViewDirectWriteResponseWriteResponse struct {
	// DataKey: What key is this write response associated with.
	DataKey *GoogleCloudAiplatformV1beta1FeatureViewDataKey `json:"dataKey,omitempty"`
	// OnlineStoreWriteTime: When the feature values were written to the online
	// store. If FeatureViewDirectWriteResponse.status is not OK, this field is not
	// populated.
	OnlineStoreWriteTime string `json:"onlineStoreWriteTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewDirectWriteResponseWriteResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewDirectWriteResponseWriteResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySource: A Feature
// Registry source for features that need to be synced to Online Store.
type GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySource struct {
	// FeatureGroups: Required. List of features that need to be synced to Online
	// Store.
	FeatureGroups []*GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySourceFeatureGroup `json:"featureGroups,omitempty"`
	// ProjectNumber: Optional. The project number of the parent project of the
	// Feature Groups.
	ProjectNumber int64 `json:"projectNumber,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FeatureGroups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureGroups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySourceFeatureGroup:
// Features belonging to a single feature group that will be synced to Online
// Store.
type GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySourceFeatureGroup struct {
	// FeatureGroupId: Required. Identifier of the feature group.
	FeatureGroupId string `json:"featureGroupId,omitempty"`
	// FeatureIds: Required. Identifiers of features under the feature group.
	FeatureIds []string `json:"featureIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FeatureGroupId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureGroupId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySourceFeatureGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewFeatureRegistrySourceFeatureGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewIndexConfig: Configuration for vector
// indexing.
type GoogleCloudAiplatformV1beta1FeatureViewIndexConfig struct {
	// BruteForceConfig: Optional. Configuration options for using brute force
	// search, which simply implements the standard linear search in the database
	// for each query. It is primarily meant for benchmarking and to generate the
	// ground truth for approximate search.
	BruteForceConfig *GoogleCloudAiplatformV1beta1FeatureViewIndexConfigBruteForceConfig `json:"bruteForceConfig,omitempty"`
	// CrowdingColumn: Optional. Column of crowding. This column contains crowding
	// attribute which is a constraint on a neighbor list produced by
	// FeatureOnlineStoreService.SearchNearestEntities to diversify search results.
	// If NearestNeighborQuery.per_crowding_attribute_neighbor_count is set to K in
	// SearchNearestEntitiesRequest, it's guaranteed that no more than K entities
	// of the same crowding attribute are returned in the response.
	CrowdingColumn string `json:"crowdingColumn,omitempty"`
	// DistanceMeasureType: Optional. The distance measure used in nearest neighbor
	// search.
	//
	// Possible values:
	//   "DISTANCE_MEASURE_TYPE_UNSPECIFIED" - Should not be set.
	//   "SQUARED_L2_DISTANCE" - Euclidean (L_2) Distance.
	//   "COSINE_DISTANCE" - Cosine Distance. Defined as 1 - cosine similarity. We
	// strongly suggest using DOT_PRODUCT_DISTANCE + UNIT_L2_NORM instead of COSINE
	// distance. Our algorithms have been more optimized for DOT_PRODUCT distance
	// which, when combined with UNIT_L2_NORM, is mathematically equivalent to
	// COSINE distance and results in the same ranking.
	//   "DOT_PRODUCT_DISTANCE" - Dot Product Distance. Defined as a negative of
	// the dot product.
	DistanceMeasureType string `json:"distanceMeasureType,omitempty"`
	// EmbeddingColumn: Optional. Column of embedding. This column contains the
	// source data to create index for vector search. embedding_column must be set
	// when using vector search.
	EmbeddingColumn string `json:"embeddingColumn,omitempty"`
	// EmbeddingDimension: Optional. The number of dimensions of the input
	// embedding.
	EmbeddingDimension int64 `json:"embeddingDimension,omitempty"`
	// FilterColumns: Optional. Columns of features that're used to filter vector
	// search results.
	FilterColumns []string `json:"filterColumns,omitempty"`
	// TreeAhConfig: Optional. Configuration options for the tree-AH algorithm
	// (Shallow tree + Asymmetric Hashing). Please refer to this paper for more
	// details: https://arxiv.org/abs/1908.10396
	TreeAhConfig *GoogleCloudAiplatformV1beta1FeatureViewIndexConfigTreeAHConfig `json:"treeAhConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BruteForceConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BruteForceConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewIndexConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewIndexConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewIndexConfigBruteForceConfig:
// Configuration options for using brute force search.
type GoogleCloudAiplatformV1beta1FeatureViewIndexConfigBruteForceConfig struct {
}

// GoogleCloudAiplatformV1beta1FeatureViewIndexConfigTreeAHConfig:
// Configuration options for the tree-AH algorithm.
type GoogleCloudAiplatformV1beta1FeatureViewIndexConfigTreeAHConfig struct {
	// LeafNodeEmbeddingCount: Optional. Number of embeddings on each leaf node.
	// The default value is 1000 if not set.
	LeafNodeEmbeddingCount int64 `json:"leafNodeEmbeddingCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "LeafNodeEmbeddingCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LeafNodeEmbeddingCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewIndexConfigTreeAHConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewIndexConfigTreeAHConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewOptimizedConfig: Configuration for
// FeatureViews created in Optimized FeatureOnlineStore.
type GoogleCloudAiplatformV1beta1FeatureViewOptimizedConfig struct {
	// AutomaticResources: Optional. A description of resources that the
	// FeatureView uses, which to large degree are decided by Vertex AI, and
	// optionally allows only a modest additional configuration. If
	// min_replica_count is not set, the default value is 2. If max_replica_count
	// is not set, the default value is 6. The max allowed replica count is 1000.
	AutomaticResources *GoogleCloudAiplatformV1beta1AutomaticResources `json:"automaticResources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutomaticResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomaticResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewOptimizedConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewOptimizedConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewSync: FeatureViewSync is a
// representation of sync operation which copies data from data source to
// Feature View in Online Store.
type GoogleCloudAiplatformV1beta1FeatureViewSync struct {
	// CreateTime: Output only. Time when this FeatureViewSync is created. Creation
	// of a FeatureViewSync means that the job is pending / waiting for sufficient
	// resources but may not have started the actual data transfer yet.
	CreateTime string `json:"createTime,omitempty"`
	// FinalStatus: Output only. Final status of the FeatureViewSync.
	FinalStatus *GoogleRpcStatus `json:"finalStatus,omitempty"`
	// Name: Identifier. Name of the FeatureViewSync. Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_
	// store}/featureViews/{feature_view}/featureViewSyncs/{feature_view_sync}`
	Name string `json:"name,omitempty"`
	// RunTime: Output only. Time when this FeatureViewSync is finished.
	RunTime *GoogleTypeInterval `json:"runTime,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SyncSummary: Output only. Summary of the sync job.
	SyncSummary *GoogleCloudAiplatformV1beta1FeatureViewSyncSyncSummary `json:"syncSummary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewSync) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewSync
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewSyncConfig: Configuration for Sync.
// Only one option is set.
type GoogleCloudAiplatformV1beta1FeatureViewSyncConfig struct {
	// Continuous: Optional. If true, syncs the FeatureView in a continuous manner
	// to Online Store.
	Continuous bool `json:"continuous,omitempty"`
	// Cron: Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
	// runs. To explicitly set a timezone to the cron tab, apply a prefix in the
	// cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}". The
	// ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database.
	// For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1
	// * * * *".
	Cron string `json:"cron,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Continuous") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Continuous") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewSyncConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewSyncConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewSyncSyncSummary: Summary from the
// Sync job. For continuous syncs, the summary is updated periodically. For
// batch syncs, it gets updated on completion of the sync.
type GoogleCloudAiplatformV1beta1FeatureViewSyncSyncSummary struct {
	// RowSynced: Output only. Total number of rows synced.
	RowSynced int64 `json:"rowSynced,omitempty,string"`
	// SystemWatermarkTime: Lower bound of the system time watermark for the sync
	// job. This is only set for continuously syncing feature views.
	SystemWatermarkTime string `json:"systemWatermarkTime,omitempty"`
	// TotalSlot: Output only. BigQuery slot milliseconds consumed for the sync
	// job.
	TotalSlot int64 `json:"totalSlot,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "RowSynced") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RowSynced") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewSyncSyncSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewSyncSyncSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfig: Deprecated. Use
// IndexConfig instead.
type GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfig struct {
	// BruteForceConfig: Optional. Configuration options for using brute force
	// search, which simply implements the standard linear search in the database
	// for each query. It is primarily meant for benchmarking and to generate the
	// ground truth for approximate search.
	BruteForceConfig *GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigBruteForceConfig `json:"bruteForceConfig,omitempty"`
	// CrowdingColumn: Optional. Column of crowding. This column contains crowding
	// attribute which is a constraint on a neighbor list produced by
	// FeatureOnlineStoreService.SearchNearestEntities to diversify search results.
	// If NearestNeighborQuery.per_crowding_attribute_neighbor_count is set to K in
	// SearchNearestEntitiesRequest, it's guaranteed that no more than K entities
	// of the same crowding attribute are returned in the response.
	CrowdingColumn string `json:"crowdingColumn,omitempty"`
	// DistanceMeasureType: Optional. The distance measure used in nearest neighbor
	// search.
	//
	// Possible values:
	//   "DISTANCE_MEASURE_TYPE_UNSPECIFIED" - Should not be set.
	//   "SQUARED_L2_DISTANCE" - Euclidean (L_2) Distance.
	//   "COSINE_DISTANCE" - Cosine Distance. Defined as 1 - cosine similarity. We
	// strongly suggest using DOT_PRODUCT_DISTANCE + UNIT_L2_NORM instead of COSINE
	// distance. Our algorithms have been more optimized for DOT_PRODUCT distance
	// which, when combined with UNIT_L2_NORM, is mathematically equivalent to
	// COSINE distance and results in the same ranking.
	//   "DOT_PRODUCT_DISTANCE" - Dot Product Distance. Defined as a negative of
	// the dot product.
	DistanceMeasureType string `json:"distanceMeasureType,omitempty"`
	// EmbeddingColumn: Optional. Column of embedding. This column contains the
	// source data to create index for vector search. embedding_column must be set
	// when using vector search.
	EmbeddingColumn string `json:"embeddingColumn,omitempty"`
	// EmbeddingDimension: Optional. The number of dimensions of the input
	// embedding.
	EmbeddingDimension int64 `json:"embeddingDimension,omitempty"`
	// FilterColumns: Optional. Columns of features that're used to filter vector
	// search results.
	FilterColumns []string `json:"filterColumns,omitempty"`
	// TreeAhConfig: Optional. Configuration options for the tree-AH algorithm
	// (Shallow tree + Asymmetric Hashing). Please refer to this paper for more
	// details: https://arxiv.org/abs/1908.10396
	TreeAhConfig *GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigTreeAHConfig `json:"treeAhConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BruteForceConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BruteForceConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigBruteForceConfig struct {
}

type GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigTreeAHConfig struct {
	// LeafNodeEmbeddingCount: Optional. Number of embeddings on each leaf node.
	// The default value is 1000 if not set.
	LeafNodeEmbeddingCount int64 `json:"leafNodeEmbeddingCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "LeafNodeEmbeddingCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LeafNodeEmbeddingCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigTreeAHConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewVectorSearchConfigTreeAHConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeatureViewVertexRagSource: A Vertex Rag source
// for features that need to be synced to Online Store.
type GoogleCloudAiplatformV1beta1FeatureViewVertexRagSource struct {
	// RagCorpusId: Optional. The RAG corpus id corresponding to this FeatureView.
	RagCorpusId int64 `json:"ragCorpusId,omitempty,string"`
	// Uri: Required. The BigQuery view/table URI that will be materialized on each
	// manual sync trigger. The table/view is expected to have the following
	// columns and types at least: - `corpus_id` (STRING, NULLABLE/REQUIRED) -
	// `file_id` (STRING, NULLABLE/REQUIRED) - `chunk_id` (STRING,
	// NULLABLE/REQUIRED) - `chunk_data_type` (STRING, NULLABLE/REQUIRED) -
	// `chunk_data` (STRING, NULLABLE/REQUIRED) - `embeddings` (FLOAT, REPEATED) -
	// `file_original_uri` (STRING, NULLABLE/REQUIRED)
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RagCorpusId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RagCorpusId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeatureViewVertexRagSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeatureViewVertexRagSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Featurestore: Vertex AI Feature Store provides a
// centralized repository for organizing, storing, and serving ML features. The
// Featurestore is a top-level container for your features and their values.
type GoogleCloudAiplatformV1beta1Featurestore struct {
	// CreateTime: Output only. Timestamp when this Featurestore was created.
	CreateTime string `json:"createTime,omitempty"`
	// EncryptionSpec: Optional. Customer-managed encryption key spec for data
	// storage. If set, both of the online and offline data storage will be secured
	// by this key.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Optional. Used to perform consistent read-modify-write updates. If not
	// set, a blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: Optional. The labels with user-defined metadata to organize your
	// Featurestore. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information on and examples of labels. No
	// more than 64 user labels can be associated with one Featurestore(System
	// labels are excluded)." System reserved label keys are prefixed with
	// "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. Name of the Featurestore. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}`
	Name string `json:"name,omitempty"`
	// OnlineServingConfig: Optional. Config for online storage resources. The
	// field should not co-exist with the field of `OnlineStoreReplicationConfig`.
	// If both of it and OnlineStoreReplicationConfig are unset, the feature store
	// will not have an online store and cannot be used for online serving.
	OnlineServingConfig *GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfig `json:"onlineServingConfig,omitempty"`
	// OnlineStorageTtlDays: Optional. TTL in days for feature values that will be
	// stored in online serving storage. The Feature Store online storage
	// periodically removes obsolete feature values older than
	// `online_storage_ttl_days` since the feature generation time. Note that
	// `online_storage_ttl_days` should be less than or equal to
	// `offline_storage_ttl_days` for each EntityType under a featurestore. If not
	// set, default to 4000 days
	OnlineStorageTtlDays int64 `json:"onlineStorageTtlDays,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// State: Output only. State of the featurestore.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "STABLE" - State when the featurestore configuration is not being updated
	// and the fields reflect the current configuration of the featurestore. The
	// featurestore is usable in this state.
	//   "UPDATING" - The state of the featurestore configuration when it is being
	// updated. During an update, the fields reflect either the original
	// configuration or the updated configuration of the featurestore. For example,
	// `online_serving_config.fixed_node_count` can take minutes to update. While
	// the update is in progress, the featurestore is in the UPDATING state, and
	// the value of `fixed_node_count` can be the original value or the updated
	// value, depending on the progress of the operation. Until the update
	// completes, the actual number of nodes can still be the original value of
	// `fixed_node_count`. The featurestore is still usable in this state.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Timestamp when this Featurestore was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Featurestore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Featurestore
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfig: Configuration of
// how features in Featurestore are monitored.
type GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfig struct {
	// CategoricalThresholdConfig: Threshold for categorical features of anomaly
	// detection. This is shared by all types of Featurestore Monitoring for
	// categorical features (i.e. Features with type (Feature.ValueType) BOOL or
	// STRING).
	CategoricalThresholdConfig *GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigThresholdConfig `json:"categoricalThresholdConfig,omitempty"`
	// ImportFeaturesAnalysis: The config for ImportFeatures Analysis Based Feature
	// Monitoring.
	ImportFeaturesAnalysis *GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigImportFeaturesAnalysis `json:"importFeaturesAnalysis,omitempty"`
	// NumericalThresholdConfig: Threshold for numerical features of anomaly
	// detection. This is shared by all objectives of Featurestore Monitoring for
	// numerical features (i.e. Features with type (Feature.ValueType) DOUBLE or
	// INT64).
	NumericalThresholdConfig *GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigThresholdConfig `json:"numericalThresholdConfig,omitempty"`
	// SnapshotAnalysis: The config for Snapshot Analysis Based Feature Monitoring.
	SnapshotAnalysis *GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigSnapshotAnalysis `json:"snapshotAnalysis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CategoricalThresholdConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CategoricalThresholdConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigImportFeaturesAnalysi
// s: Configuration of the Featurestore's ImportFeature Analysis Based
// Monitoring. This type of analysis generates statistics for values of each
// Feature imported by every ImportFeatureValues operation.
type GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigImportFeaturesAnalysis struct {
	// AnomalyDetectionBaseline: The baseline used to do anomaly detection for the
	// statistics generated by import features analysis.
	//
	// Possible values:
	//   "BASELINE_UNSPECIFIED" - Should not be used.
	//   "LATEST_STATS" - Choose the later one statistics generated by either most
	// recent snapshot analysis or previous import features analysis. If non of
	// them exists, skip anomaly detection and only generate a statistics.
	//   "MOST_RECENT_SNAPSHOT_STATS" - Use the statistics generated by the most
	// recent snapshot analysis if exists.
	//   "PREVIOUS_IMPORT_FEATURES_STATS" - Use the statistics generated by the
	// previous import features analysis if exists.
	AnomalyDetectionBaseline string `json:"anomalyDetectionBaseline,omitempty"`
	// State: Whether to enable / disable / inherite default hebavior for import
	// features analysis.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Should not be used.
	//   "DEFAULT" - The default behavior of whether to enable the monitoring.
	// EntityType-level config: disabled. Feature-level config: inherited from the
	// configuration of EntityType this Feature belongs to.
	//   "ENABLED" - Explicitly enables import features analysis. EntityType-level
	// config: by default enables import features analysis for all Features under
	// it. Feature-level config: enables import features analysis regardless of the
	// EntityType-level config.
	//   "DISABLED" - Explicitly disables import features analysis.
	// EntityType-level config: by default disables import features analysis for
	// all Features under it. Feature-level config: disables import features
	// analysis regardless of the EntityType-level config.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnomalyDetectionBaseline")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnomalyDetectionBaseline") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigImportFeaturesAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigImportFeaturesAnalysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigSnapshotAnalysis:
// Configuration of the Featurestore's Snapshot Analysis Based Monitoring. This
// type of analysis generates statistics for each Feature based on a snapshot
// of the latest feature value of each entities every monitoring_interval.
type GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigSnapshotAnalysis struct {
	// Disabled: The monitoring schedule for snapshot analysis. For
	// EntityType-level config: unset / disabled = true indicates disabled by
	// default for Features under it; otherwise by default enable snapshot analysis
	// monitoring with monitoring_interval for Features under it. Feature-level
	// config: disabled = true indicates disabled regardless of the
	// EntityType-level config; unset monitoring_interval indicates going with
	// EntityType-level config; otherwise run snapshot analysis monitoring with
	// monitoring_interval regardless of the EntityType-level config. Explicitly
	// Disable the snapshot analysis based monitoring.
	Disabled bool `json:"disabled,omitempty"`
	// MonitoringInterval: Configuration of the snapshot analysis based monitoring
	// pipeline running interval. The value is rolled up to full day. If both
	// monitoring_interval_days and the deprecated `monitoring_interval` field are
	// set when creating/updating EntityTypes/Features, monitoring_interval_days
	// will be used.
	MonitoringInterval string `json:"monitoringInterval,omitempty"`
	// MonitoringIntervalDays: Configuration of the snapshot analysis based
	// monitoring pipeline running interval. The value indicates number of days.
	MonitoringIntervalDays int64 `json:"monitoringIntervalDays,omitempty"`
	// StalenessDays: Customized export features time window for snapshot analysis.
	// Unit is one day. Default value is 3 weeks. Minimum value is 1 day. Maximum
	// value is 4000 days.
	StalenessDays int64 `json:"stalenessDays,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigSnapshotAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigSnapshotAnalysis
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigThresholdConfig: The
// config for Featurestore Monitoring threshold.
type GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigThresholdConfig struct {
	// Value: Specify a threshold value that can trigger the alert. 1. For
	// categorical feature, the distribution distance is calculated by L-inifinity
	// norm. 2. For numerical feature, the distribution distance is calculated by
	// Jensen–Shannon divergence. Each feature must have a non-zero threshold if
	// they need to be monitored. Otherwise no alert will be triggered for that
	// feature.
	Value float64 `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigThresholdConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigThresholdConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigThresholdConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FeaturestoreMonitoringConfigThresholdConfig
	var s1 struct {
		Value gensupport.JSONFloat64 `json:"value"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Value = float64(s1.Value)
	return nil
}

// GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfig:
// OnlineServingConfig specifies the details for provisioning online serving
// resources.
type GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfig struct {
	// FixedNodeCount: The number of nodes for the online store. The number of
	// nodes doesn't scale automatically, but you can manually update the number of
	// nodes. If set to 0, the featurestore will not have an online store and
	// cannot be used for online serving.
	FixedNodeCount int64 `json:"fixedNodeCount,omitempty"`
	// Scaling: Online serving scaling configuration. Only one of
	// `fixed_node_count` and `scaling` can be set. Setting one will reset the
	// other.
	Scaling *GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfigScaling `json:"scaling,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FixedNodeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FixedNodeCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfigScaling: Online
// serving scaling configuration. If min_node_count and max_node_count are set
// to the same value, the cluster will be configured with the fixed number of
// node (no auto-scaling).
type GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfigScaling struct {
	// CpuUtilizationTarget: Optional. The cpu utilization that the Autoscaler
	// should be trying to achieve. This number is on a scale from 0 (no
	// utilization) to 100 (total utilization), and is limited between 10 and 80.
	// When a cluster's CPU utilization exceeds the target that you have set,
	// Bigtable immediately adds nodes to the cluster. When CPU utilization is
	// substantially lower than the target, Bigtable removes nodes. If not set or
	// set to 0, default to 50.
	CpuUtilizationTarget int64 `json:"cpuUtilizationTarget,omitempty"`
	// MaxNodeCount: The maximum number of nodes to scale up to. Must be greater
	// than min_node_count, and less than or equal to 10 times of 'min_node_count'.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty"`
	// MinNodeCount: Required. The minimum number of nodes to scale down to. Must
	// be greater than or equal to 1.
	MinNodeCount int64 `json:"minNodeCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CpuUtilizationTarget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CpuUtilizationTarget") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfigScaling) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FeaturestoreOnlineServingConfigScaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FetchExamplesRequest: Request message for
// ExampleStoreService.FetchExamples.
type GoogleCloudAiplatformV1beta1FetchExamplesRequest struct {
	// ExampleIds: Optional. Example IDs to fetch. If both metadata filters and
	// Example IDs are specified, then both ID and metadata filtering will be
	// applied.
	ExampleIds []string `json:"exampleIds,omitempty"`
	// PageSize: Optional. The maximum number of examples to return. The service
	// may return fewer than this value. If unspecified, at most 100 examples will
	// be returned.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: Optional. The next_page_token value returned from a previous list
	// ExampleStoreService.FetchExamplesResponse call.
	PageToken string `json:"pageToken,omitempty"`
	// StoredContentsExampleFilter: The metadata filters for
	// StoredContentsExamples.
	StoredContentsExampleFilter *GoogleCloudAiplatformV1beta1StoredContentsExampleFilter `json:"storedContentsExampleFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExampleIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExampleIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FetchExamplesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FetchExamplesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FetchExamplesResponse: Response message for
// ExampleStoreService.FetchExamples.
type GoogleCloudAiplatformV1beta1FetchExamplesResponse struct {
	// Examples: The examples in the Example Store that satisfy the metadata
	// filters.
	Examples []*GoogleCloudAiplatformV1beta1Example `json:"examples,omitempty"`
	// NextPageToken: A token, which can be sent as ListExamplesRequest.page_token
	// to retrieve the next page. Absence of this field indicates there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Examples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Examples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FetchExamplesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FetchExamplesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FetchFeatureValuesRequest: Request message for
// FeatureOnlineStoreService.FetchFeatureValues. All the features under the
// requested feature view will be returned.
type GoogleCloudAiplatformV1beta1FetchFeatureValuesRequest struct {
	// DataFormat: Optional. Response data format. If not set,
	// FeatureViewDataFormat.KEY_VALUE will be used.
	//
	// Possible values:
	//   "FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED" - Not set. Will be treated as the
	// KeyValue format.
	//   "KEY_VALUE" - Return response data in key-value format.
	//   "PROTO_STRUCT" - Return response data in proto Struct format.
	DataFormat string `json:"dataFormat,omitempty"`
	// DataKey: Optional. The request key to fetch feature values for.
	DataKey *GoogleCloudAiplatformV1beta1FeatureViewDataKey `json:"dataKey,omitempty"`
	// Format: Specify response data format. If not set, KeyValue format will be
	// used. Deprecated. Use FetchFeatureValuesRequest.data_format.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Not set. Will be treated as the KeyValue format.
	//   "KEY_VALUE" - Return response data in key-value format.
	//   "PROTO_STRUCT" - Return response data in proto Struct format.
	Format string `json:"format,omitempty"`
	// Id: Simple ID. The whole string will be used as is to identify Entity to
	// fetch feature values for.
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FetchFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FetchFeatureValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FetchFeatureValuesResponse: Response message for
// FeatureOnlineStoreService.FetchFeatureValues
type GoogleCloudAiplatformV1beta1FetchFeatureValuesResponse struct {
	// DataKey: The data key associated with this response. Will only be populated
	// for FeatureOnlineStoreService.StreamingFetchFeatureValues RPCs.
	DataKey *GoogleCloudAiplatformV1beta1FeatureViewDataKey `json:"dataKey,omitempty"`
	// KeyValues: Feature values in KeyValue format.
	KeyValues *GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairList `json:"keyValues,omitempty"`
	// ProtoStruct: Feature values in proto Struct format.
	ProtoStruct googleapi.RawMessage `json:"protoStruct,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FetchFeatureValuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FetchFeatureValuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairLis
// t: Response structure in the format of key (feature name) and (feature)
// value pair.
type GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairList struct {
	// Features: List of feature names and values.
	Features []*GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair `json:"features,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Features") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Features") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairLis
// tFeatureNameValuePair: Feature name & value pair.
type GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair struct {
	// Name: Feature short name.
	Name string `json:"name,omitempty"`
	// Value: Feature value.
	Value *GoogleCloudAiplatformV1beta1FeatureValue `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FetchFeatureValuesResponseFeatureNameValuePairListFeatureNameValuePair
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FetchPredictOperationRequest: Request message
// for PredictionService.FetchPredictOperation.
type GoogleCloudAiplatformV1beta1FetchPredictOperationRequest struct {
	// OperationName: Required. The server-assigned name for the operation.
	OperationName string `json:"operationName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OperationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperationName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FetchPredictOperationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FetchPredictOperationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FileData: URI based data.
type GoogleCloudAiplatformV1beta1FileData struct {
	// DisplayName: Optional. Display name of the file data. Used to provide a
	// label or filename to distinguish file datas. This field is only returned in
	// PromptMessage for prompt management. It is not currently used in the Gemini
	// GenerateContent calls.
	DisplayName string `json:"displayName,omitempty"`
	// FileUri: Required. URI.
	FileUri string `json:"fileUri,omitempty"`
	// MimeType: Required. The IANA standard MIME type of the source data.
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FileData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FileData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FileStatus: RagFile status.
type GoogleCloudAiplatformV1beta1FileStatus struct {
	// ErrorStatus: Output only. Only when the `state` field is ERROR.
	ErrorStatus string `json:"errorStatus,omitempty"`
	// State: Output only. RagFile state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - RagFile state is unspecified.
	//   "ACTIVE" - RagFile resource has been created and indexed successfully.
	//   "ERROR" - RagFile resource is in a problematic state. See `error_message`
	// field for details.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorStatus") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FileStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FileStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FilterSplit: Assigns input data to training,
// validation, and test sets based on the given filters, data pieces not
// matched by any filter are ignored. Currently only supported for Datasets
// containing DataItems. If any of the filters in this message are to match
// nothing, then they can be set as '-' (the minus sign). Supported only for
// unstructured Datasets.
type GoogleCloudAiplatformV1beta1FilterSplit struct {
	// TestFilter: Required. A filter on DataItems of the Dataset. DataItems that
	// match this filter are used to test the Model. A filter with same syntax as
	// the one used in DatasetService.ListDataItems may be used. If a single
	// DataItem is matched by more than one of the FilterSplit filters, then it is
	// assigned to the first set that applies to it in the training, validation,
	// test order.
	TestFilter string `json:"testFilter,omitempty"`
	// TrainingFilter: Required. A filter on DataItems of the Dataset. DataItems
	// that match this filter are used to train the Model. A filter with same
	// syntax as the one used in DatasetService.ListDataItems may be used. If a
	// single DataItem is matched by more than one of the FilterSplit filters, then
	// it is assigned to the first set that applies to it in the training,
	// validation, test order.
	TrainingFilter string `json:"trainingFilter,omitempty"`
	// ValidationFilter: Required. A filter on DataItems of the Dataset. DataItems
	// that match this filter are used to validate the Model. A filter with same
	// syntax as the one used in DatasetService.ListDataItems may be used. If a
	// single DataItem is matched by more than one of the FilterSplit filters, then
	// it is assigned to the first set that applies to it in the training,
	// validation, test order.
	ValidationFilter string `json:"validationFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestFilter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FilterSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FilterSplit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FindNeighborsRequest: The request message for
// MatchService.FindNeighbors.
type GoogleCloudAiplatformV1beta1FindNeighborsRequest struct {
	// DeployedIndexId: The ID of the DeployedIndex that will serve the request.
	// This request is sent to a specific IndexEndpoint, as per the
	// IndexEndpoint.network. That IndexEndpoint also has
	// IndexEndpoint.deployed_indexes, and each such index has a DeployedIndex.id
	// field. The value of the field below must equal one of the DeployedIndex.id
	// fields of the IndexEndpoint that is being called for this request.
	DeployedIndexId string `json:"deployedIndexId,omitempty"`
	// Queries: The list of queries.
	Queries []*GoogleCloudAiplatformV1beta1FindNeighborsRequestQuery `json:"queries,omitempty"`
	// ReturnFullDatapoint: If set to true, the full datapoints (including all
	// vector values and restricts) of the nearest neighbors are returned. Note
	// that returning full datapoint will significantly increase the latency and
	// cost of the query.
	ReturnFullDatapoint bool `json:"returnFullDatapoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeployedIndexId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeployedIndexId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FindNeighborsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FindNeighborsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FindNeighborsRequestQuery: A query to find a
// number of the nearest neighbors (most similar vectors) of a vector.
type GoogleCloudAiplatformV1beta1FindNeighborsRequestQuery struct {
	// ApproximateNeighborCount: The number of neighbors to find via approximate
	// search before exact reordering is performed. If not set, the default value
	// from scam config is used; if set, this value must be > 0.
	ApproximateNeighborCount int64 `json:"approximateNeighborCount,omitempty"`
	// Datapoint: Required. The datapoint/vector whose nearest neighbors should be
	// searched for.
	Datapoint *GoogleCloudAiplatformV1beta1IndexDatapoint `json:"datapoint,omitempty"`
	// FractionLeafNodesToSearchOverride: The fraction of the number of leaves to
	// search, set at query time allows user to tune search performance. This value
	// increase result in both search accuracy and latency increase. The value
	// should be between 0.0 and 1.0. If not set or set to 0.0, query uses the
	// default value specified in
	// NearestNeighborSearchConfig.TreeAHConfig.fraction_leaf_nodes_to_search.
	FractionLeafNodesToSearchOverride float64 `json:"fractionLeafNodesToSearchOverride,omitempty"`
	// NeighborCount: The number of nearest neighbors to be retrieved from database
	// for each query. If not set, will use the default from the service
	// configuration
	// (https://cloud.google.com/vertex-ai/docs/matching-engine/configuring-indexes#nearest-neighbor-search-config).
	NeighborCount int64 `json:"neighborCount,omitempty"`
	// PerCrowdingAttributeNeighborCount: Crowding is a constraint on a neighbor
	// list produced by nearest neighbor search requiring that no more than some
	// value k' of the k neighbors returned have the same value of
	// crowding_attribute. It's used for improving result diversity. This field is
	// the maximum number of matches with the same crowding tag.
	PerCrowdingAttributeNeighborCount int64 `json:"perCrowdingAttributeNeighborCount,omitempty"`
	// Rrf: Optional. Represents RRF algorithm that combines search results.
	Rrf *GoogleCloudAiplatformV1beta1FindNeighborsRequestQueryRRF `json:"rrf,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApproximateNeighborCount")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApproximateNeighborCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FindNeighborsRequestQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FindNeighborsRequestQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FindNeighborsRequestQuery) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FindNeighborsRequestQuery
	var s1 struct {
		FractionLeafNodesToSearchOverride gensupport.JSONFloat64 `json:"fractionLeafNodesToSearchOverride"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FractionLeafNodesToSearchOverride = float64(s1.FractionLeafNodesToSearchOverride)
	return nil
}

// GoogleCloudAiplatformV1beta1FindNeighborsRequestQueryRRF: Parameters for RRF
// algorithm that combines search results.
type GoogleCloudAiplatformV1beta1FindNeighborsRequestQueryRRF struct {
	// Alpha: Required. Users can provide an alpha value to give more weight to
	// dense vs sparse results. For example, if the alpha is 0, we only return
	// sparse and if the alpha is 1, we only return dense.
	Alpha float64 `json:"alpha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alpha") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alpha") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FindNeighborsRequestQueryRRF) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FindNeighborsRequestQueryRRF
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FindNeighborsRequestQueryRRF) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FindNeighborsRequestQueryRRF
	var s1 struct {
		Alpha gensupport.JSONFloat64 `json:"alpha"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Alpha = float64(s1.Alpha)
	return nil
}

// GoogleCloudAiplatformV1beta1FindNeighborsResponse: The response message for
// MatchService.FindNeighbors.
type GoogleCloudAiplatformV1beta1FindNeighborsResponse struct {
	// NearestNeighbors: The nearest neighbors of the query datapoints.
	NearestNeighbors []*GoogleCloudAiplatformV1beta1FindNeighborsResponseNearestNeighbors `json:"nearestNeighbors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NearestNeighbors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NearestNeighbors") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FindNeighborsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FindNeighborsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FindNeighborsResponseNearestNeighbors: Nearest
// neighbors for one query.
type GoogleCloudAiplatformV1beta1FindNeighborsResponseNearestNeighbors struct {
	// Id: The ID of the query datapoint.
	Id string `json:"id,omitempty"`
	// Neighbors: All its neighbors.
	Neighbors []*GoogleCloudAiplatformV1beta1FindNeighborsResponseNeighbor `json:"neighbors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FindNeighborsResponseNearestNeighbors) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FindNeighborsResponseNearestNeighbors
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FindNeighborsResponseNeighbor: A neighbor of the
// query vector.
type GoogleCloudAiplatformV1beta1FindNeighborsResponseNeighbor struct {
	// Datapoint: The datapoint of the neighbor. Note that full datapoints are
	// returned only when "return_full_datapoint" is set to true. Otherwise, only
	// the "datapoint_id" and "crowding_tag" fields are populated.
	Datapoint *GoogleCloudAiplatformV1beta1IndexDatapoint `json:"datapoint,omitempty"`
	// Distance: The distance between the neighbor and the dense embedding query.
	Distance float64 `json:"distance,omitempty"`
	// SparseDistance: The distance between the neighbor and the query
	// sparse_embedding.
	SparseDistance float64 `json:"sparseDistance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Datapoint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Datapoint") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FindNeighborsResponseNeighbor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FindNeighborsResponseNeighbor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FindNeighborsResponseNeighbor) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FindNeighborsResponseNeighbor
	var s1 struct {
		Distance       gensupport.JSONFloat64 `json:"distance"`
		SparseDistance gensupport.JSONFloat64 `json:"sparseDistance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Distance = float64(s1.Distance)
	s.SparseDistance = float64(s1.SparseDistance)
	return nil
}

// GoogleCloudAiplatformV1beta1FluencyInput: Input for fluency metric.
type GoogleCloudAiplatformV1beta1FluencyInput struct {
	// Instance: Required. Fluency instance.
	Instance *GoogleCloudAiplatformV1beta1FluencyInstance `json:"instance,omitempty"`
	// MetricSpec: Required. Spec for fluency score metric.
	MetricSpec *GoogleCloudAiplatformV1beta1FluencySpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FluencyInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FluencyInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FluencyInstance: Spec for fluency instance.
type GoogleCloudAiplatformV1beta1FluencyInstance struct {
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Prediction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Prediction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FluencyInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FluencyInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FluencyResult: Spec for fluency result.
type GoogleCloudAiplatformV1beta1FluencyResult struct {
	// Confidence: Output only. Confidence for fluency score.
	Confidence float64 `json:"confidence,omitempty"`
	// Explanation: Output only. Explanation for fluency score.
	Explanation string `json:"explanation,omitempty"`
	// Score: Output only. Fluency score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FluencyResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FluencyResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FluencyResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FluencyResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		Score      gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1beta1FluencySpec: Spec for fluency score metric.
type GoogleCloudAiplatformV1beta1FluencySpec struct {
	// Version: Optional. Which version to use for evaluation.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FluencySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FluencySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FractionSplit: Assigns the input data to
// training, validation, and test sets as per the given fractions. Any of
// `training_fraction`, `validation_fraction` and `test_fraction` may
// optionally be provided, they must sum to up to 1. If the provided ones sum
// to less than 1, the remainder is assigned to sets as decided by Vertex AI.
// If none of the fractions are set, by default roughly 80% of data is used for
// training, 10% for validation, and 10% for test.
type GoogleCloudAiplatformV1beta1FractionSplit struct {
	// TestFraction: The fraction of the input data that is to be used to evaluate
	// the Model.
	TestFraction float64 `json:"testFraction,omitempty"`
	// TrainingFraction: The fraction of the input data that is to be used to train
	// the Model.
	TrainingFraction float64 `json:"trainingFraction,omitempty"`
	// ValidationFraction: The fraction of the input data that is to be used to
	// validate the Model.
	ValidationFraction float64 `json:"validationFraction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestFraction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestFraction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FractionSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FractionSplit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FractionSplit) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FractionSplit
	var s1 struct {
		TestFraction       gensupport.JSONFloat64 `json:"testFraction"`
		TrainingFraction   gensupport.JSONFloat64 `json:"trainingFraction"`
		ValidationFraction gensupport.JSONFloat64 `json:"validationFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TestFraction = float64(s1.TestFraction)
	s.TrainingFraction = float64(s1.TrainingFraction)
	s.ValidationFraction = float64(s1.ValidationFraction)
	return nil
}

// GoogleCloudAiplatformV1beta1FulfillmentInput: Input for fulfillment metric.
type GoogleCloudAiplatformV1beta1FulfillmentInput struct {
	// Instance: Required. Fulfillment instance.
	Instance *GoogleCloudAiplatformV1beta1FulfillmentInstance `json:"instance,omitempty"`
	// MetricSpec: Required. Spec for fulfillment score metric.
	MetricSpec *GoogleCloudAiplatformV1beta1FulfillmentSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FulfillmentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FulfillmentInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FulfillmentInstance: Spec for fulfillment
// instance.
type GoogleCloudAiplatformV1beta1FulfillmentInstance struct {
	// Instruction: Required. Inference instruction prompt to compare prediction
	// with.
	Instruction string `json:"instruction,omitempty"`
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instruction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instruction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FulfillmentInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FulfillmentInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FulfillmentResult: Spec for fulfillment result.
type GoogleCloudAiplatformV1beta1FulfillmentResult struct {
	// Confidence: Output only. Confidence for fulfillment score.
	Confidence float64 `json:"confidence,omitempty"`
	// Explanation: Output only. Explanation for fulfillment score.
	Explanation string `json:"explanation,omitempty"`
	// Score: Output only. Fulfillment score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FulfillmentResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FulfillmentResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1FulfillmentResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1FulfillmentResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		Score      gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1beta1FulfillmentSpec: Spec for fulfillment metric.
type GoogleCloudAiplatformV1beta1FulfillmentSpec struct {
	// Version: Optional. Which version to use for evaluation.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FulfillmentSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FulfillmentSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FunctionCall: A predicted [FunctionCall]
// returned from the model that contains a string representing the
// [FunctionDeclaration.name] and a structured JSON object containing the
// parameters and their values.
type GoogleCloudAiplatformV1beta1FunctionCall struct {
	// Args: Optional. Required. The function parameters and values in JSON object
	// format. See [FunctionDeclaration.parameters] for parameter details.
	Args googleapi.RawMessage `json:"args,omitempty"`
	// Id: Optional. The unique id of the function call. If populated, the client
	// to execute the `function_call` and return the response with the matching
	// `id`.
	Id string `json:"id,omitempty"`
	// Name: Required. The name of the function to call. Matches
	// [FunctionDeclaration.name].
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FunctionCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FunctionCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FunctionCallingConfig: Function calling config.
type GoogleCloudAiplatformV1beta1FunctionCallingConfig struct {
	// AllowedFunctionNames: Optional. Function names to call. Only set when the
	// Mode is ANY. Function names should match [FunctionDeclaration.name]. With
	// mode set to ANY, model will predict a function call from the set of function
	// names provided.
	AllowedFunctionNames []string `json:"allowedFunctionNames,omitempty"`
	// Mode: Optional. Function calling mode.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Unspecified function calling mode. This value should
	// not be used.
	//   "AUTO" - Default model behavior, model decides to predict either function
	// calls or natural language response.
	//   "ANY" - Model is constrained to always predicting function calls only. If
	// "allowed_function_names" are set, the predicted function calls will be
	// limited to any one of "allowed_function_names", else the predicted function
	// calls will be any one of the provided "function_declarations".
	//   "NONE" - Model will not predict any function calls. Model behavior is same
	// as when not passing any function declarations.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedFunctionNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedFunctionNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FunctionCallingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FunctionCallingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FunctionDeclaration: Structured representation
// of a function declaration as defined by the OpenAPI 3.0 specification
// (https://spec.openapis.org/oas/v3.0.3). Included in this declaration are the
// function name, description, parameters and response type. This
// FunctionDeclaration is a representation of a block of code that can be used
// as a `Tool` by the model and executed by the client.
type GoogleCloudAiplatformV1beta1FunctionDeclaration struct {
	// Description: Optional. Description and purpose of the function. Model uses
	// it to decide how and whether to call the function.
	Description string `json:"description,omitempty"`
	// Name: Required. The name of the function to call. Must start with a letter
	// or an underscore. Must be a-z, A-Z, 0-9, or contain underscores, dots and
	// dashes, with a maximum length of 64.
	Name string `json:"name,omitempty"`
	// Parameters: Optional. Describes the parameters to this function in JSON
	// Schema Object format. Reflects the Open API 3.03 Parameter Object. string
	// Key: the name of the parameter. Parameter names are case sensitive. Schema
	// Value: the Schema defining the type used for the parameter. For function
	// with no parameters, this can be left unset. Parameter names must start with
	// a letter or an underscore and must only contain chars a-z, A-Z, 0-9, or
	// underscores with a maximum length of 64. Example with 1 required and 1
	// optional parameter: type: OBJECT properties: param1: type: STRING param2:
	// type: INTEGER required: - param1
	Parameters *GoogleCloudAiplatformV1beta1Schema `json:"parameters,omitempty"`
	// Response: Optional. Describes the output from this function in JSON Schema
	// format. Reflects the Open API 3.03 Response Object. The Schema defines the
	// type used for the response value of the function.
	Response *GoogleCloudAiplatformV1beta1Schema `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FunctionDeclaration) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FunctionDeclaration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1FunctionResponse: The result output from a
// [FunctionCall] that contains a string representing the
// [FunctionDeclaration.name] and a structured JSON object containing any
// output from the function is used as context to the model. This should
// contain the result of a [FunctionCall] made based on model prediction.
type GoogleCloudAiplatformV1beta1FunctionResponse struct {
	// Id: Optional. The id of the function call this response is for. Populated by
	// the client to match the corresponding function call `id`.
	Id string `json:"id,omitempty"`
	// Name: Required. The name of the function to call. Matches
	// [FunctionDeclaration.name] and [FunctionCall.name].
	Name string `json:"name,omitempty"`
	// Response: Required. The function response in JSON object format. Use
	// "output" key to specify function output and "error" key to specify error
	// details (if any). If "output" and "error" keys are not specified, then whole
	// "response" is treated as function output.
	Response googleapi.RawMessage `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1FunctionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1FunctionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GcsDestination: The Google Cloud Storage
// location where the output is to be written to.
type GoogleCloudAiplatformV1beta1GcsDestination struct {
	// OutputUriPrefix: Required. Google Cloud Storage URI to output directory. If
	// the uri doesn't end with '/', a '/' will be automatically appended. The
	// directory is created if it doesn't exist.
	OutputUriPrefix string `json:"outputUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUriPrefix") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUriPrefix") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GcsSource: The Google Cloud Storage location for
// the input content.
type GoogleCloudAiplatformV1beta1GcsSource struct {
	// Uris: Required. Google Cloud Storage URI(-s) to the input file(s). May
	// contain wildcards. For more information on wildcards, see
	// https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames.
	Uris []string `json:"uris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uris") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uris") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GcsSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GcsSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GeminiExample: Format for Gemini examples used
// for Vertex Multimodal datasets.
type GoogleCloudAiplatformV1beta1GeminiExample struct {
	// CachedContent: Optional. The name of the cached content used as context to
	// serve the prediction. Note: only used in explicit caching, where users can
	// have control over caching (e.g. what content to cache) and enjoy guaranteed
	// cost savings. Format:
	// `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
	CachedContent string `json:"cachedContent,omitempty"`
	// Contents: Required. The content of the current conversation with the model.
	// For single-turn queries, this is a single instance. For multi-turn queries,
	// this is a repeated field that contains conversation history + latest
	// request.
	Contents []*GoogleCloudAiplatformV1beta1Content `json:"contents,omitempty"`
	// GenerationConfig: Optional. Generation config.
	GenerationConfig *GoogleCloudAiplatformV1beta1GenerationConfig `json:"generationConfig,omitempty"`
	// Labels: Optional. The labels with user-defined metadata for the request. It
	// is used for billing and reporting only. Label keys and values can be no
	// longer than 63 characters (Unicode codepoints) and can only contain
	// lowercase letters, numeric characters, underscores, and dashes.
	// International characters are allowed. Label values are optional. Label keys
	// must start with a letter.
	Labels map[string]string `json:"labels,omitempty"`
	// Model: Optional. The fully qualified name of the publisher model or tuned
	// model endpoint to use. Publisher model format:
	// `projects/{project}/locations/{location}/publishers/*/models/*` Tuned model
	// endpoint format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Model string `json:"model,omitempty"`
	// SafetySettings: Optional. Per request settings for blocking unsafe content.
	// Enforced on GenerateContentResponse.candidates.
	SafetySettings []*GoogleCloudAiplatformV1beta1SafetySetting `json:"safetySettings,omitempty"`
	// SystemInstruction: Optional. The user provided system instructions for the
	// model. Note: only text should be used in parts and content in each part will
	// be in a separate paragraph.
	SystemInstruction *GoogleCloudAiplatformV1beta1Content `json:"systemInstruction,omitempty"`
	// ToolConfig: Optional. Tool config. This config is shared for all tools
	// provided in the request.
	ToolConfig *GoogleCloudAiplatformV1beta1ToolConfig `json:"toolConfig,omitempty"`
	// Tools: Optional. A list of `Tools` the model may use to generate the next
	// response. A `Tool` is a piece of code that enables the system to interact
	// with external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model.
	Tools []*GoogleCloudAiplatformV1beta1Tool `json:"tools,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CachedContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CachedContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GeminiExample) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GeminiExample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GeminiTemplateConfig: Template configuration to
// create Gemini examples from a multimodal dataset.
type GoogleCloudAiplatformV1beta1GeminiTemplateConfig struct {
	// FieldMapping: Required. Map of template params to the columns in the dataset
	// table.
	FieldMapping map[string]string `json:"fieldMapping,omitempty"`
	// GeminiExample: Required. The template that will be used for assembling the
	// request to use for downstream applications.
	GeminiExample *GoogleCloudAiplatformV1beta1GeminiExample `json:"geminiExample,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FieldMapping") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FieldMapping") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GeminiTemplateConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GeminiTemplateConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfig: Configuration for
// GenAiAdvancedFeatures.
type GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfig struct {
	// RagConfig: Configuration for Retrieval Augmented Generation feature.
	RagConfig *GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfigRagConfig `json:"ragConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RagConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RagConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfigRagConfig:
// Configuration for Retrieval Augmented Generation feature.
type GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfigRagConfig struct {
	// EnableRag: If true, enable Retrieval Augmented Generation in ChatCompletion
	// request. Once enabled, the endpoint will be identified as GenAI endpoint and
	// Arthedain router will be used.
	EnableRag bool `json:"enableRag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableRag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableRag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfigRagConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenAiAdvancedFeaturesConfigRagConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateAccessTokenRequest: Request message for
// NotebookInternalService.GenerateAccessToken.
type GoogleCloudAiplatformV1beta1GenerateAccessTokenRequest struct {
	// VmToken: Required. The VM identity token (a JWT) for authenticating the VM.
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	VmToken string `json:"vmToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "VmToken") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "VmToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateAccessTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateAccessTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateAccessTokenResponse: Response message
// for NotebookInternalService.GenerateToken.
type GoogleCloudAiplatformV1beta1GenerateAccessTokenResponse struct {
	// AccessToken: Short-lived access token string which may be used to access
	// Google APIs.
	AccessToken string `json:"accessToken,omitempty"`
	// ExpiresIn: The time in seconds when the access token expires. Typically
	// that's 3600.
	ExpiresIn int64 `json:"expiresIn,omitempty"`
	// Scope: Space-separated list of scopes contained in the returned token.
	// https://cloud.google.com/docs/authentication/token-types#access-contents
	Scope string `json:"scope,omitempty"`
	// TokenType: Type of the returned access token (e.g. "Bearer"). It specifies
	// how the token must be used. Bearer tokens may be used by any entity without
	// proof of identity.
	TokenType string `json:"tokenType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateAccessTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateAccessTokenResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateContentRequest: Request message for
// [PredictionService.GenerateContent].
type GoogleCloudAiplatformV1beta1GenerateContentRequest struct {
	// CachedContent: Optional. The name of the cached content used as context to
	// serve the prediction. Note: only used in explicit caching, where users can
	// have control over caching (e.g. what content to cache) and enjoy guaranteed
	// cost savings. Format:
	// `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
	CachedContent string `json:"cachedContent,omitempty"`
	// Contents: Required. The content of the current conversation with the model.
	// For single-turn queries, this is a single instance. For multi-turn queries,
	// this is a repeated field that contains conversation history + latest
	// request.
	Contents []*GoogleCloudAiplatformV1beta1Content `json:"contents,omitempty"`
	// GenerationConfig: Optional. Generation config.
	GenerationConfig *GoogleCloudAiplatformV1beta1GenerationConfig `json:"generationConfig,omitempty"`
	// Labels: Optional. The labels with user-defined metadata for the request. It
	// is used for billing and reporting only. Label keys and values can be no
	// longer than 63 characters (Unicode codepoints) and can only contain
	// lowercase letters, numeric characters, underscores, and dashes.
	// International characters are allowed. Label values are optional. Label keys
	// must start with a letter.
	Labels map[string]string `json:"labels,omitempty"`
	// SafetySettings: Optional. Per request settings for blocking unsafe content.
	// Enforced on GenerateContentResponse.candidates.
	SafetySettings []*GoogleCloudAiplatformV1beta1SafetySetting `json:"safetySettings,omitempty"`
	// SystemInstruction: Optional. The user provided system instructions for the
	// model. Note: only text should be used in parts and content in each part will
	// be in a separate paragraph.
	SystemInstruction *GoogleCloudAiplatformV1beta1Content `json:"systemInstruction,omitempty"`
	// ToolConfig: Optional. Tool config. This config is shared for all tools
	// provided in the request.
	ToolConfig *GoogleCloudAiplatformV1beta1ToolConfig `json:"toolConfig,omitempty"`
	// Tools: Optional. A list of `Tools` the model may use to generate the next
	// response. A `Tool` is a piece of code that enables the system to interact
	// with external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model.
	Tools []*GoogleCloudAiplatformV1beta1Tool `json:"tools,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CachedContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CachedContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateContentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateContentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateContentResponse: Response message for
// [PredictionService.GenerateContent].
type GoogleCloudAiplatformV1beta1GenerateContentResponse struct {
	// Candidates: Output only. Generated candidates.
	Candidates []*GoogleCloudAiplatformV1beta1Candidate `json:"candidates,omitempty"`
	// CreateTime: Output only. Timestamp when the request is made to the server.
	CreateTime string `json:"createTime,omitempty"`
	// ModelVersion: Output only. The model version used to generate the response.
	ModelVersion string `json:"modelVersion,omitempty"`
	// PromptFeedback: Output only. Content filter results for a prompt sent in the
	// request. Note: Sent only in the first stream chunk. Only happens when no
	// candidates were generated due to content violations.
	PromptFeedback *GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback `json:"promptFeedback,omitempty"`
	// ResponseId: Output only. response_id is used to identify each response. It
	// is the encoding of the event_id.
	ResponseId string `json:"responseId,omitempty"`
	// UsageMetadata: Usage metadata about the response(s).
	UsageMetadata *GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata `json:"usageMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateContentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback: Content
// filter results for a prompt sent in the request.
type GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback struct {
	// BlockReason: Output only. Blocked reason.
	//
	// Possible values:
	//   "BLOCKED_REASON_UNSPECIFIED" - Unspecified blocked reason.
	//   "SAFETY" - Candidates blocked due to safety.
	//   "OTHER" - Candidates blocked due to other reason.
	//   "BLOCKLIST" - Candidates blocked due to the terms which are included from
	// the terminology blocklist.
	//   "PROHIBITED_CONTENT" - Candidates blocked due to prohibited content.
	BlockReason string `json:"blockReason,omitempty"`
	// BlockReasonMessage: Output only. A readable block reason message.
	BlockReasonMessage string `json:"blockReasonMessage,omitempty"`
	// SafetyRatings: Output only. Safety ratings.
	SafetyRatings []*GoogleCloudAiplatformV1beta1SafetyRating `json:"safetyRatings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockReason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateContentResponsePromptFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata: Usage
// metadata about response(s).
type GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata struct {
	// CacheTokensDetails: Output only. List of modalities of the cached content in
	// the request input.
	CacheTokensDetails []*GoogleCloudAiplatformV1beta1ModalityTokenCount `json:"cacheTokensDetails,omitempty"`
	// CachedContentTokenCount: Output only. Number of tokens in the cached part in
	// the input (the cached content).
	CachedContentTokenCount int64 `json:"cachedContentTokenCount,omitempty"`
	// CandidatesTokenCount: Number of tokens in the response(s).
	CandidatesTokenCount int64 `json:"candidatesTokenCount,omitempty"`
	// CandidatesTokensDetails: Output only. List of modalities that were returned
	// in the response.
	CandidatesTokensDetails []*GoogleCloudAiplatformV1beta1ModalityTokenCount `json:"candidatesTokensDetails,omitempty"`
	// PromptTokenCount: Number of tokens in the request. When `cached_content` is
	// set, this is still the total effective prompt size meaning this includes the
	// number of tokens in the cached content.
	PromptTokenCount int64 `json:"promptTokenCount,omitempty"`
	// PromptTokensDetails: Output only. List of modalities that were processed in
	// the request input.
	PromptTokensDetails []*GoogleCloudAiplatformV1beta1ModalityTokenCount `json:"promptTokensDetails,omitempty"`
	// ThoughtsTokenCount: Output only. Number of tokens present in thoughts
	// output.
	ThoughtsTokenCount int64 `json:"thoughtsTokenCount,omitempty"`
	// ToolUsePromptTokenCount: Output only. Number of tokens present in tool-use
	// prompt(s).
	ToolUsePromptTokenCount int64 `json:"toolUsePromptTokenCount,omitempty"`
	// ToolUsePromptTokensDetails: Output only. List of modalities that were
	// processed for tool-use request inputs.
	ToolUsePromptTokensDetails []*GoogleCloudAiplatformV1beta1ModalityTokenCount `json:"toolUsePromptTokensDetails,omitempty"`
	// TotalTokenCount: Total token count for prompt, response candidates, and
	// tool-use prompts (if present).
	TotalTokenCount int64 `json:"totalTokenCount,omitempty"`
	// TrafficType: Output only. Traffic type. This shows whether a request
	// consumes Pay-As-You-Go or Provisioned Throughput quota.
	//
	// Possible values:
	//   "TRAFFIC_TYPE_UNSPECIFIED" - Unspecified request traffic type.
	//   "ON_DEMAND" - Type for Pay-As-You-Go traffic.
	//   "PROVISIONED_THROUGHPUT" - Type for Provisioned Throughput traffic.
	TrafficType string `json:"trafficType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CacheTokensDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CacheTokensDetails") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateContentResponseUsageMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateVideoResponse: Generate video response.
type GoogleCloudAiplatformV1beta1GenerateVideoResponse struct {
	// GeneratedSamples: The cloud storage uris of the generated videos.
	GeneratedSamples []string `json:"generatedSamples,omitempty"`
	// RaiMediaFilteredCount: Returns if any videos were filtered due to RAI
	// policies.
	RaiMediaFilteredCount int64 `json:"raiMediaFilteredCount,omitempty"`
	// RaiMediaFilteredReasons: Returns rai failure reasons if any.
	RaiMediaFilteredReasons []string `json:"raiMediaFilteredReasons,omitempty"`
	// Videos: List of video bytes or Cloud Storage URIs of the generated videos.
	Videos []*GoogleCloudAiplatformV1beta1GenerateVideoResponseVideo `json:"videos,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratedSamples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratedSamples") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateVideoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateVideoResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerateVideoResponseVideo: A generated video.
type GoogleCloudAiplatformV1beta1GenerateVideoResponseVideo struct {
	// BytesBase64Encoded: Base64 encoded bytes string representing the video.
	BytesBase64Encoded string `json:"bytesBase64Encoded,omitempty"`
	// GcsUri: Cloud Storage URI where the generated video is written.
	GcsUri string `json:"gcsUri,omitempty"`
	// MimeType: The MIME type of the content of the video. - video/mp4
	MimeType string `json:"mimeType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BytesBase64Encoded") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesBase64Encoded") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerateVideoResponseVideo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerateVideoResponseVideo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerationConfig: Generation config.
type GoogleCloudAiplatformV1beta1GenerationConfig struct {
	// AudioTimestamp: Optional. If enabled, audio timestamp will be included in
	// the request to the model.
	AudioTimestamp bool `json:"audioTimestamp,omitempty"`
	// CandidateCount: Optional. Number of candidates to generate.
	CandidateCount int64 `json:"candidateCount,omitempty"`
	// FrequencyPenalty: Optional. Frequency penalties.
	FrequencyPenalty float64 `json:"frequencyPenalty,omitempty"`
	// Logprobs: Optional. Logit probabilities.
	Logprobs int64 `json:"logprobs,omitempty"`
	// MaxOutputTokens: Optional. The maximum number of output tokens to generate
	// per message.
	MaxOutputTokens int64 `json:"maxOutputTokens,omitempty"`
	// MediaResolution: Optional. If specified, the media resolution specified will
	// be used.
	//
	// Possible values:
	//   "MEDIA_RESOLUTION_UNSPECIFIED" - Media resolution has not been set.
	//   "MEDIA_RESOLUTION_LOW" - Media resolution set to low (64 tokens).
	//   "MEDIA_RESOLUTION_MEDIUM" - Media resolution set to medium (256 tokens).
	//   "MEDIA_RESOLUTION_HIGH" - Media resolution set to high (zoomed reframing
	// with 256 tokens).
	MediaResolution string `json:"mediaResolution,omitempty"`
	// PresencePenalty: Optional. Positive penalties.
	PresencePenalty float64 `json:"presencePenalty,omitempty"`
	// ResponseLogprobs: Optional. If true, export the logprobs results in
	// response.
	ResponseLogprobs bool `json:"responseLogprobs,omitempty"`
	// ResponseMimeType: Optional. Output response mimetype of the generated
	// candidate text. Supported mimetype: - `text/plain`: (default) Text output. -
	// `application/json`: JSON response in the candidates. The model needs to be
	// prompted to output the appropriate response type, otherwise the behavior is
	// undefined. This is a preview feature.
	ResponseMimeType string `json:"responseMimeType,omitempty"`
	// ResponseModalities: Optional. The modalities of the response.
	//
	// Possible values:
	//   "MODALITY_UNSPECIFIED" - Unspecified modality. Will be processed as text.
	//   "TEXT" - Text modality.
	//   "IMAGE" - Image modality.
	//   "AUDIO" - Audio modality.
	ResponseModalities []string `json:"responseModalities,omitempty"`
	// ResponseSchema: Optional. The `Schema` object allows the definition of input
	// and output data types. These types can be objects, but also primitives and
	// arrays. Represents a select subset of an OpenAPI 3.0 schema object
	// (https://spec.openapis.org/oas/v3.0.3#schema). If set, a compatible
	// response_mime_type must also be set. Compatible mimetypes:
	// `application/json`: Schema for JSON response.
	ResponseSchema *GoogleCloudAiplatformV1beta1Schema `json:"responseSchema,omitempty"`
	// RoutingConfig: Optional. Routing configuration.
	RoutingConfig *GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig `json:"routingConfig,omitempty"`
	// Seed: Optional. Seed.
	Seed int64 `json:"seed,omitempty"`
	// SpeechConfig: Optional. The speech generation config.
	SpeechConfig *GoogleCloudAiplatformV1beta1SpeechConfig `json:"speechConfig,omitempty"`
	// StopSequences: Optional. Stop sequences.
	StopSequences []string `json:"stopSequences,omitempty"`
	// Temperature: Optional. Controls the randomness of predictions.
	Temperature float64 `json:"temperature,omitempty"`
	// TopK: Optional. If specified, top-k sampling will be used.
	TopK float64 `json:"topK,omitempty"`
	// TopP: Optional. If specified, nucleus sampling will be used.
	TopP float64 `json:"topP,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioTimestamp") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioTimestamp") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1GenerationConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfig
	var s1 struct {
		FrequencyPenalty gensupport.JSONFloat64 `json:"frequencyPenalty"`
		PresencePenalty  gensupport.JSONFloat64 `json:"presencePenalty"`
		Temperature      gensupport.JSONFloat64 `json:"temperature"`
		TopK             gensupport.JSONFloat64 `json:"topK"`
		TopP             gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FrequencyPenalty = float64(s1.FrequencyPenalty)
	s.PresencePenalty = float64(s1.PresencePenalty)
	s.Temperature = float64(s1.Temperature)
	s.TopK = float64(s1.TopK)
	s.TopP = float64(s1.TopP)
	return nil
}

// GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig: The configuration
// for routing the request to a specific model.
type GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig struct {
	// AutoMode: Automated routing.
	AutoMode *GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode `json:"autoMode,omitempty"`
	// ManualMode: Manual routing.
	ManualMode *GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode `json:"manualMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode:
// When automated routing is specified, the routing will be determined by the
// pretrained routing model and customer provided model routing preference.
type GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode struct {
	// ModelRoutingPreference: The model routing preference.
	//
	// Possible values:
	//   "UNKNOWN" - Unspecified model routing preference.
	//   "PRIORITIZE_QUALITY" - Prefer higher quality over low cost.
	//   "BALANCED" - Balanced model routing preference.
	//   "PRIORITIZE_COST" - Prefer lower cost over higher quality.
	ModelRoutingPreference string `json:"modelRoutingPreference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelRoutingPreference") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelRoutingPreference") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigAutoRoutingMode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode:
// When manual routing is set, the specified model will be used directly.
type GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode struct {
	// ModelName: The model name to use. Only the public LLM models are accepted.
	// e.g. 'gemini-1.5-pro-001'.
	ModelName string `json:"modelName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenerationConfigRoutingConfigManualRoutingMode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenericOperationMetadata: Generic Metadata
// shared by all operations.
type GoogleCloudAiplatformV1beta1GenericOperationMetadata struct {
	// CreateTime: Output only. Time when the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// PartialFailures: Output only. Partial failures encountered. E.g. single
	// files that couldn't be read. This field should never exceed 20 entries.
	// Status details field will contain standard Google Cloud error details.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// UpdateTime: Output only. Time when the operation was updated for the last
	// time. If the operation has finished (successfully or not), this is the
	// finish time.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenericOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenericOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GenieSource: Contains information about the
// source of the models generated from Generative AI Studio.
type GoogleCloudAiplatformV1beta1GenieSource struct {
	// BaseModelUri: Required. The public base model URI.
	BaseModelUri string `json:"baseModelUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseModelUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseModelUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GenieSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GenieSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GoogleDriveSource: The Google Drive location for
// the input content.
type GoogleCloudAiplatformV1beta1GoogleDriveSource struct {
	// ResourceIds: Required. Google Drive resource IDs.
	ResourceIds []*GoogleCloudAiplatformV1beta1GoogleDriveSourceResourceId `json:"resourceIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceIds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GoogleDriveSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GoogleDriveSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GoogleDriveSourceResourceId: The type and ID of
// the Google Drive resource.
type GoogleCloudAiplatformV1beta1GoogleDriveSourceResourceId struct {
	// ResourceId: Required. The ID of the Google Drive resource.
	ResourceId string `json:"resourceId,omitempty"`
	// ResourceType: Required. The type of the Google Drive resource.
	//
	// Possible values:
	//   "RESOURCE_TYPE_UNSPECIFIED" - Unspecified resource type.
	//   "RESOURCE_TYPE_FILE" - File resource type.
	//   "RESOURCE_TYPE_FOLDER" - Folder resource type.
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GoogleDriveSourceResourceId) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GoogleDriveSourceResourceId
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GoogleSearchRetrieval: Tool to retrieve public
// web data for grounding, powered by Google.
type GoogleCloudAiplatformV1beta1GoogleSearchRetrieval struct {
	// DynamicRetrievalConfig: Specifies the dynamic retrieval configuration for
	// the given source.
	DynamicRetrievalConfig *GoogleCloudAiplatformV1beta1DynamicRetrievalConfig `json:"dynamicRetrievalConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DynamicRetrievalConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DynamicRetrievalConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GoogleSearchRetrieval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GoogleSearchRetrieval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundednessInput: Input for groundedness
// metric.
type GoogleCloudAiplatformV1beta1GroundednessInput struct {
	// Instance: Required. Groundedness instance.
	Instance *GoogleCloudAiplatformV1beta1GroundednessInstance `json:"instance,omitempty"`
	// MetricSpec: Required. Spec for groundedness metric.
	MetricSpec *GoogleCloudAiplatformV1beta1GroundednessSpec `json:"metricSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instance") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundednessInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundednessInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundednessInstance: Spec for groundedness
// instance.
type GoogleCloudAiplatformV1beta1GroundednessInstance struct {
	// Context: Required. Background information provided in context used to
	// compare against the prediction.
	Context string `json:"context,omitempty"`
	// Prediction: Required. Output of the evaluated model.
	Prediction string `json:"prediction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Context") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Context") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundednessInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundednessInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundednessResult: Spec for groundedness
// result.
type GoogleCloudAiplatformV1beta1GroundednessResult struct {
	// Confidence: Output only. Confidence for groundedness score.
	Confidence float64 `json:"confidence,omitempty"`
	// Explanation: Output only. Explanation for groundedness score.
	Explanation string `json:"explanation,omitempty"`
	// Score: Output only. Groundedness score.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundednessResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundednessResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1GroundednessResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1GroundednessResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		Score      gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudAiplatformV1beta1GroundednessSpec: Spec for groundedness metric.
type GoogleCloudAiplatformV1beta1GroundednessSpec struct {
	// Version: Optional. Which version to use for evaluation.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundednessSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundednessSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingChunk: Grounding chunk.
type GoogleCloudAiplatformV1beta1GroundingChunk struct {
	// RetrievedContext: Grounding chunk from context retrieved by the retrieval
	// tools.
	RetrievedContext *GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext `json:"retrievedContext,omitempty"`
	// Web: Grounding chunk from the web.
	Web *GoogleCloudAiplatformV1beta1GroundingChunkWeb `json:"web,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RetrievedContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RetrievedContext") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingChunk) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingChunk
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext: Chunk from
// context retrieved by the retrieval tools.
type GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext struct {
	// Text: Text of the attribution.
	Text string `json:"text,omitempty"`
	// Title: Title of the attribution.
	Title string `json:"title,omitempty"`
	// Uri: URI reference of the attribution.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingChunkRetrievedContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingChunkWeb: Chunk from the web.
type GoogleCloudAiplatformV1beta1GroundingChunkWeb struct {
	// Domain: Domain of the (original) URI.
	Domain string `json:"domain,omitempty"`
	// Title: Title of the chunk.
	Title string `json:"title,omitempty"`
	// Uri: URI reference of the chunk.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Domain") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domain") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingChunkWeb) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingChunkWeb
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingMetadata: Metadata returned to client
// when grounding is enabled.
type GoogleCloudAiplatformV1beta1GroundingMetadata struct {
	// GroundingChunks: List of supporting references retrieved from specified
	// grounding source.
	GroundingChunks []*GoogleCloudAiplatformV1beta1GroundingChunk `json:"groundingChunks,omitempty"`
	// GroundingSupports: Optional. List of grounding support.
	GroundingSupports []*GoogleCloudAiplatformV1beta1GroundingSupport `json:"groundingSupports,omitempty"`
	// RetrievalMetadata: Optional. Output only. Retrieval metadata.
	RetrievalMetadata *GoogleCloudAiplatformV1beta1RetrievalMetadata `json:"retrievalMetadata,omitempty"`
	// RetrievalQueries: Optional. Queries executed by the retrieval tools.
	RetrievalQueries []string `json:"retrievalQueries,omitempty"`
	// SearchEntryPoint: Optional. Google search entry for the following-up web
	// searches.
	SearchEntryPoint *GoogleCloudAiplatformV1beta1SearchEntryPoint `json:"searchEntryPoint,omitempty"`
	// WebSearchQueries: Optional. Web search queries for the following-up web
	// search.
	WebSearchQueries []string `json:"webSearchQueries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GroundingChunks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GroundingChunks") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1GroundingSupport: Grounding support.
type GoogleCloudAiplatformV1beta1GroundingSupport struct {
	// ConfidenceScores: Confidence score of the support references. Ranges from 0
	// to 1. 1 is the most confident. This list must have the same size as the
	// grounding_chunk_indices.
	ConfidenceScores []float64 `json:"confidenceScores,omitempty"`
	// GroundingChunkIndices: A list of indices (into 'grounding_chunk') specifying
	// the citations associated with the claim. For instance [1,3,4] means that
	// grounding_chunk[1], grounding_chunk[3], grounding_chunk[4] are the retrieved
	// content attributed to the claim.
	GroundingChunkIndices []int64 `json:"groundingChunkIndices,omitempty"`
	// Segment: Segment of the content this support belongs to.
	Segment *GoogleCloudAiplatformV1beta1Segment `json:"segment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScores") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1GroundingSupport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingSupport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1GroundingSupport) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1GroundingSupport
	var s1 struct {
		ConfidenceScores []gensupport.JSONFloat64 `json:"confidenceScores"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScores = make([]float64, len(s1.ConfidenceScores))
	for i := range s1.ConfidenceScores {
		s.ConfidenceScores[i] = float64(s1.ConfidenceScores[i])
	}
	return nil
}

// GoogleCloudAiplatformV1beta1HyperparameterTuningJob: Represents a
// HyperparameterTuningJob. A HyperparameterTuningJob has a Study specification
// and multiple CustomJobs with identical CustomJob specification.
type GoogleCloudAiplatformV1beta1HyperparameterTuningJob struct {
	// CreateTime: Output only. Time when the HyperparameterTuningJob was created.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The display name of the HyperparameterTuningJob. The
	// name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Customer-managed encryption key options for a
	// HyperparameterTuningJob. If this is set, then all resources created by the
	// HyperparameterTuningJob will be encrypted with the provided encryption key.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// EndTime: Output only. Time when the HyperparameterTuningJob entered any of
	// the following states: `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`,
	// `JOB_STATE_CANCELLED`.
	EndTime string `json:"endTime,omitempty"`
	// Error: Output only. Only populated when job's state is JOB_STATE_FAILED or
	// JOB_STATE_CANCELLED.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Labels: The labels with user-defined metadata to organize
	// HyperparameterTuningJobs. Label keys and values can be no longer than 64
	// characters (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// MaxFailedTrialCount: The number of failed Trials that need to be seen before
	// failing the HyperparameterTuningJob. If set to 0, Vertex AI decides how many
	// Trials must fail before the whole job fails.
	MaxFailedTrialCount int64 `json:"maxFailedTrialCount,omitempty"`
	// MaxTrialCount: Required. The desired total number of Trials.
	MaxTrialCount int64 `json:"maxTrialCount,omitempty"`
	// Name: Output only. Resource name of the HyperparameterTuningJob.
	Name string `json:"name,omitempty"`
	// ParallelTrialCount: Required. The desired number of Trials to run in
	// parallel.
	ParallelTrialCount int64 `json:"parallelTrialCount,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// StartTime: Output only. Time when the HyperparameterTuningJob for the first
	// time entered the `JOB_STATE_RUNNING` state.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The detailed state of the job.
	//
	// Possible values:
	//   "JOB_STATE_UNSPECIFIED" - The job state is unspecified.
	//   "JOB_STATE_QUEUED" - The job has been just created or resumed and
	// processing has not yet begun.
	//   "JOB_STATE_PENDING" - The service is preparing to run the job.
	//   "JOB_STATE_RUNNING" - The job is in progress.
	//   "JOB_STATE_SUCCEEDED" - The job completed successfully.
	//   "JOB_STATE_FAILED" - The job failed.
	//   "JOB_STATE_CANCELLING" - The job is being cancelled. From this state the
	// job may only go to either `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	//   "JOB_STATE_CANCELLED" - The job has been cancelled.
	//   "JOB_STATE_PAUSED" - The job has been stopped, and can be resumed.
	//   "JOB_STATE_EXPIRED" - The job has expired.
	//   "JOB_STATE_UPDATING" - The job is being updated. Only jobs in the
	// `RUNNING` state can be updated. After updating, the job goes back to the
	// `RUNNING` state.
	//   "JOB_STATE_PARTIALLY_SUCCEEDED" - The job is partially succeeded, some
	// results may be missing due to errors.
	State string `json:"state,omitempty"`
	// StudySpec: Required. Study configuration of the HyperparameterTuningJob.
	StudySpec *GoogleCloudAiplatformV1beta1StudySpec `json:"studySpec,omitempty"`
	// TrialJobSpec: Required. The spec of a trial job. The same spec applies to
	// the CustomJobs created in all the trials.
	TrialJobSpec *GoogleCloudAiplatformV1beta1CustomJobSpec `json:"trialJobSpec,omitempty"`
	// Trials: Output only. Trials of the HyperparameterTuningJob.
	Trials []*GoogleCloudAiplatformV1beta1Trial `json:"trials,omitempty"`
	// UpdateTime: Output only. Time when the HyperparameterTuningJob was most
	// recently updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1HyperparameterTuningJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1HyperparameterTuningJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1IdMatcher: Matcher for Features of an EntityType
// by Feature ID.
type GoogleCloudAiplatformV1beta1IdMatcher struct {
	// Ids: Required. The following are accepted as `ids`: * A single-element list
	// containing only `*`, which selects all Features in the target EntityType, or
	// * A list containing only Feature IDs, which selects only Features with those
	// IDs in the target EntityType.
	Ids []string `json:"ids,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Ids") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Ids") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1IdMatcher) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1IdMatcher
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImportDataConfig: Describes the location from
// where we import data into a Dataset, together with the labels that will be
// applied to the DataItems and the Annotations.
type GoogleCloudAiplatformV1beta1ImportDataConfig struct {
	// AnnotationLabels: Labels that will be applied to newly imported Annotations.
	// If two Annotations are identical, one of them will be deduped. Two
	// Annotations are considered identical if their payload, payload_schema_uri
	// and all of their labels are the same. These labels will be overridden by
	// Annotation labels specified inside index file referenced by
	// import_schema_uri, e.g. jsonl file.
	AnnotationLabels map[string]string `json:"annotationLabels,omitempty"`
	// DataItemLabels: Labels that will be applied to newly imported DataItems. If
	// an identical DataItem as one being imported already exists in the Dataset,
	// then these labels will be appended to these of the already existing one, and
	// if labels with identical key is imported before, the old label value will be
	// overwritten. If two DataItems are identical in the same import data
	// operation, the labels will be combined and if key collision happens in this
	// case, one of the values will be picked randomly. Two DataItems are
	// considered identical if their content bytes are identical (e.g. image bytes
	// or pdf bytes). These labels will be overridden by Annotation labels
	// specified inside index file referenced by import_schema_uri, e.g. jsonl
	// file.
	DataItemLabels map[string]string `json:"dataItemLabels,omitempty"`
	// GcsSource: The Google Cloud Storage location for the input content.
	GcsSource *GoogleCloudAiplatformV1beta1GcsSource `json:"gcsSource,omitempty"`
	// ImportSchemaUri: Required. Points to a YAML file stored on Google Cloud
	// Storage describing the import format. Validation will be done against the
	// schema. The schema is defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	ImportSchemaUri string `json:"importSchemaUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationLabels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImportDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImportDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImportDataOperationMetadata: Runtime operation
// information for DatasetService.ImportData.
type GoogleCloudAiplatformV1beta1ImportDataOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImportDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImportDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImportDataRequest: Request message for
// DatasetService.ImportData.
type GoogleCloudAiplatformV1beta1ImportDataRequest struct {
	// ImportConfigs: Required. The desired input locations. The contents of all
	// input locations will be imported in one batch.
	ImportConfigs []*GoogleCloudAiplatformV1beta1ImportDataConfig `json:"importConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImportConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImportDataRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImportDataRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImportDataResponse: Response message for
// DatasetService.ImportData.
type GoogleCloudAiplatformV1beta1ImportDataResponse struct {
}

// GoogleCloudAiplatformV1beta1ImportExtensionOperationMetadata: Details of
// ExtensionRegistryService.ImportExtension operation.
type GoogleCloudAiplatformV1beta1ImportExtensionOperationMetadata struct {
	// GenericMetadata: The common part of the operation metadata.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImportExtensionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImportExtensionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImportFeatureValuesOperationMetadata: Details of
// operations that perform import Feature values.
type GoogleCloudAiplatformV1beta1ImportFeatureValuesOperationMetadata struct {
	// BlockingOperationIds: List of ImportFeatureValues operations running under a
	// single EntityType that are blocking this operation.
	BlockingOperationIds googleapi.Int64s `json:"blockingOperationIds,omitempty"`
	// GenericMetadata: Operation metadata for Featurestore import Feature values.
	GenericMetadata *GoogleCloudAiplatformV1beta1GenericOperationMetadata `json:"genericMetadata,omitempty"`
	// ImportedEntityCount: Number of entities that have been imported by the
	// operation.
	ImportedEntityCount int64 `json:"importedEntityCount,omitempty,string"`
	// ImportedFeatureValueCount: Number of Feature values that have been imported
	// by the operation.
	ImportedFeatureValueCount int64 `json:"importedFeatureValueCount,omitempty,string"`
	// InvalidRowCount: The number of rows in input source that weren't imported
	// due to either * Not having any featureValues. * Having a null entityId. *
	// Having a null timestamp. * Not being parsable (applicable for CSV sources).
	InvalidRowCount int64 `json:"invalidRowCount,omitempty,string"`
	// SourceUris: The source URI from where Feature values are imported.
	SourceUris []string `json:"sourceUris,omitempty"`
	// TimestampOutsideRetentionRowsCount: The number rows that weren't ingested
	// due to having timestamps outside the retention boundary.
	TimestampOutsideRetentionRowsCount int64 `json:"timestampOutsideRetentionRowsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BlockingOperationIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockingOperationIds") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImportFeatureValuesOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImportFeatureValuesOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImportFeatureValuesRequest: Request message for
// FeaturestoreService.ImportFeatureValues.
type GoogleCloudAiplatformV1beta1ImportFeatureValuesRequest struct {
	AvroSource     *GoogleCloudAiplatformV1beta1AvroSource     `json:"avroSource,omitempty"`
	BigquerySource *GoogleCloudAiplatformV1beta1BigQuerySource `json:"bigquerySource,omitempty"`
	CsvSource      *GoogleCloudAiplatformV1beta1CsvSource      `json:"csvSource,omitempty"`
	// DisableIngestionAnalysis: If true, API doesn't start ingestion analysis
	// pipeline.
	DisableIngestionAnalysis bool `json:"disableIngestionAnalysis,omitempty"`
	// DisableOnlineServing: If set, data will not be imported for online serving.
	// This is typically used for backfilling, where Feature generation timestamps
	// are not in the timestamp range needed for online serving.
	DisableOnlineServing bool `json:"disableOnlineServing,omitempty"`
	// EntityIdField: Source column that holds entity IDs. If not provided, entity
	// IDs are extracted from the column named entity_id.
	EntityIdField string `json:"entityIdField,omitempty"`
	// FeatureSpecs: Required. Specifications defining which Feature values to
	// import from the entity. The request fails if no feature_specs are provided,
	// and having multiple feature_specs for one Feature is not allowed.
	FeatureSpecs []*GoogleCloudAiplatformV1beta1ImportFeatureValuesRequestFeatureSpec `json:"featureSpecs,omitempty"`
	// FeatureTime: Single Feature timestamp for all entities being imported. The
	// timestamp must not have higher than millisecond precision.
	FeatureTime string `json:"featureTime,omitempty"`
	// FeatureTimeField: Source column that holds the Feature timestamp for all
	// Feature values in each entity.
	FeatureTimeField string `json:"featureTimeField,omitempty"`
	// WorkerCount: Specifies the number of workers that are used to write data to
	// the Featurestore. Consider the online serving capacity that you require to
	// achieve the desired import throughput without interfering with online
	// serving. The value must be positive, and less than or equal to 100. If not
	// set, defaults to using 1 worker. The low count ensures minimal impact on
	// online serving performance.
	WorkerCount int64 `json:"workerCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvroSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvroSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImportFeatureValuesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImportFeatureValuesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImportFeatureValuesRequestFeatureSpec: Defines
// the Feature value(s) to import.
type GoogleCloudAiplatformV1beta1ImportFeatureValuesRequestFeatureSpec struct {
	// Id: Required. ID of the Feature to import values of. This Feature must exist
	// in the target EntityType, or the request will fail.
	Id string `json:"id,omitempty"`
	// SourceField: Source column to get the Feature values from. If not set, uses
	// the column with the same name as the Feature ID.
	SourceField string `json:"sourceField,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImportFeatureValuesRequestFeatureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImportFeatureValuesRequestFeatureSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImportFeatureValuesResponse: Response message
// for FeaturestoreService.ImportFeatureValues.
type GoogleCloudAiplatformV1beta1ImportFeatureValuesResponse struct {
	// ImportedEntityCount: Number of entities that have been imported by the
	// operation.
	ImportedEntityCount int64 `json:"importedEntityCount,omitempty,string"`
	// ImportedFeatureValueCount: Number of Feature values that have been imported
	// by the operation.
	ImportedFeatureValueCount int64 `json:"importedFeatureValueCount,omitempty,string"`
	// InvalidRowCount: The number of rows in input source that weren't imported
	// due to either * Not having any featureValues. * Having a null entityId. *
	// Having a null timestamp. * Not being parsable (applicable for CSV sources).
	InvalidRowCount int64 `json:"invalidRowCount,omitempty,string"`
	// TimestampOutsideRetentionRowsCount: The number rows that weren't ingested
	// due to having feature timestamps outside the retention boundary.
	TimestampOutsideRetentionRowsCount int64 `json:"timestampOutsideRetentionRowsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ImportedEntityCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportedEntityCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImportFeatureValuesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImportFeatureValuesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImportModelEvaluationRequest: Request message
// for ModelService.ImportModelEvaluation
type GoogleCloudAiplatformV1beta1ImportModelEvaluationRequest struct {
	// ModelEvaluation: Required. Model evaluation resource to be imported.
	ModelEvaluation *GoogleCloudAiplatformV1beta1ModelEvaluation `json:"modelEvaluation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelEvaluation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelEvaluation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImportModelEvaluationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImportModelEvaluationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImportRagFilesConfig: Config for importing
// RagFiles.
type GoogleCloudAiplatformV1beta1ImportRagFilesConfig struct {
	// GcsSource: Google Cloud Storage location. Supports importing individual
	// files as well as entire Google Cloud Storage directories. Sample formats: -
	// `gs://bucket_name/my_directory/object_name/my_file.txt` -
	// `gs://bucket_name/my_directory`
	GcsSource *GoogleCloudAiplatformV1beta1GcsSource `json:"gcsSource,omitempty"`
	// GlobalMaxEmbeddingRequestsPerMin: Optional. The max number of queries per
	// minute that the indexing pipeline job is allowed to make to the embedding
	// model specified in the project. Please follow the quota usage guideline of
	// the embedding model you use to set the value properly.If this value is not
	// specified, max_embedding_requests_per_min will be used by indexing pipeline
	// job as the global limit.
	GlobalMaxEmbeddingRequestsPerMin int64 `json:"globalMaxEmbeddingRequestsPerMin,omitempty"`
	// GoogleDriveSource: Google Drive location. Supports importing individual
	// files as well as Google Drive folders.
	GoogleDriveSource *GoogleCloudAiplatformV1beta1GoogleDriveSource `json:"googleDriveSource,omitempty"`
	// ImportResultBigquerySink: The BigQuery destination to write import result
	// to. It should be a bigquery table resource name (e.g.
	// "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
	// table does not exist, it will be created with the expected schema. If the
	// table exists, the schema will be validated and data will be added to this
	// existing table.
	ImportResultBigquerySink *GoogleCloudAiplatformV1beta1BigQueryDestination `json:"importResultBigquerySink,omitempty"`
	// ImportResultGcsSink: The Cloud Storage path to write import result to.
	ImportResultGcsSink *GoogleCloudAiplatformV1beta1GcsDestination `json:"importResultGcsSink,omitempty"`
	// JiraSource: Jira queries with their corresponding authentication.
	JiraSource *GoogleCloudAiplatformV1beta1JiraSource `json:"jiraSource,omitempty"`
	// MaxEmbeddingRequestsPerMin: Optional. The max number of queries per minute
	// that this job is allowed to make to the embedding model specified on the
	// corpus. This value is specific to this job and not shared across other
	// import jobs. Consult the Quotas page on the project to set an appropriate
	// value here. If unspecified, a default value of 1,000 QPM would be used.
	MaxEmbeddingRequestsPerMin int64 `json:"maxEmbeddingRequestsPerMin,omitempty"`
	// PartialFailureBigquerySink: The BigQuery destination to write partial
	// failures to. It should be a bigquery table resource name (e.g.
	// "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
	// table does not exist, it will be created with the expected schema. If the
	// table exists, the schema will be validated and data will be added to this
	// existing table. Deprecated. Prefer to use `import_result_bq_sink`.
	PartialFailureBigquerySink *GoogleCloudAiplatformV1beta1BigQueryDestination `json:"partialFailureBigquerySink,omitempty"`
	// PartialFailureGcsSink: The Cloud Storage path to write partial failures to.
	// Deprecated. Prefer to use `import_result_gcs_sink`.
	PartialFailureGcsSink *GoogleCloudAiplatformV1beta1GcsDestination `json:"partialFailureGcsSink,omitempty"`
	// RagFileChunkingConfig: Specifies the size and overlap of chunks after
	// importing RagFiles.
	RagFileChunkingConfig *GoogleCloudAiplatformV1beta1RagFileChunkingConfig `json:"ragFileChunkingConfig,omitempty"`
	// RagFileParsingConfig: Optional. Specifies the parsing config for RagFiles.
	// RAG will use the default parser if this field is not set.
	RagFileParsingConfig *GoogleCloudAiplatformV1beta1RagFileParsingConfig `json:"ragFileParsingConfig,omitempty"`
	// RagFileTransformationConfig: Specifies the transformation config for
	// RagFiles.
	RagFileTransformationConfig *GoogleCloudAiplatformV1beta1RagFileTransformationConfig `json:"ragFileTransformationConfig,omitempty"`
	// SharePointSources: SharePoint sources.
	SharePointSources *GoogleCloudAiplatformV1beta1SharePointSources `json:"sharePointSources,omitempty"`
	// SlackSource: Slack channels with their corresponding access tokens.
	SlackSource *GoogleCloudAiplatformV1beta1SlackSource `json:"slackSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcsSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcsSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImportRagFilesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImportRagFilesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ImportRagFilesRequest: Request message for
// VertexRagDataService.ImportRagFiles.
type GoogleCloudAiplatformV1beta1ImportRagFilesRequest struct {
	// ImportRagFilesConfig: Required. The config for the RagFiles to be synced and
	// imported into the RagCorpus. VertexRagDataService.ImportRagFiles.
	ImportRagFilesConfig *GoogleCloudAiplatformV1beta1ImportRagFilesConfig `json:"importRagFilesConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImportRagFilesConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportRagFilesConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ImportRagFilesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ImportRagFilesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Index: A representation of a collection of
// database items organized in a way that allows for approximate nearest
// neighbor (a.k.a ANN) algorithms search.
type GoogleCloudAiplatformV1beta1Index struct {
	// CreateTime: Output only. Timestamp when this Index was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeployedIndexes: Output only. The pointers to DeployedIndexes created from
	// this Index. An Index can be only deleted if all its DeployedIndexes had been
	// undeployed first.
	DeployedIndexes []*GoogleCloudAiplatformV1beta1DeployedIndexRef `json:"deployedIndexes,omitempty"`
	// Description: The description of the Index.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the Index. The name can be up to
	// 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// EncryptionSpec: Immutable. Customer-managed encryption key spec for an
	// Index. If set, this Index and all sub-resources of this Index will be
	// secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Used to perform consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// IndexStats: Output only. Stats of the index resource.
	IndexStats *GoogleCloudAiplatformV1beta1IndexStats `json:"indexStats,omitempty"`
	// IndexUpdateMethod: Immutable. The update method to use with this Index. If
	// not set, BATCH_UPDATE will be used by default.
	//
	// Possible values:
	//   "INDEX_UPDATE_METHOD_UNSPECIFIED" - Should not be used.
	//   "BATCH_UPDATE" - BatchUpdate: user can call UpdateIndex with files on
	// Cloud Storage of Datapoints to update.
	//   "STREAM_UPDATE" - StreamUpdate: user can call
	// UpsertDatapoints/DeleteDatapoints to update the Index and the updates will
	// be applied in corresponding DeployedIndexes in nearly real-time.
	IndexUpdateMethod string `json:"indexUpdateMethod,omitempty"`
	// Labels: The labels with user-defined metadata to organize your Indexes.
	// Label keys and values can be no longer than 64 characters (Unicode
	// codepoints), can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. See
	// https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Metadata: An additional information about the Index; the schema of the
	// metadata can be found in metadata_schema.
	Metadata interface{} `json:"metadata,omitempty"`
	// MetadataSchemaUri: Immutable. Points to a YAML file stored on Google Cloud
	// Storage describing additional information about the Index, that is specific
	// to it. Unset if the Index does not have any additional information. The
	// schema is defined as an OpenAPI 3.0.2 Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// Note: The URI given on output will be immutable and probably different,
	// including the URI scheme, than the one given on input. The output URI will
	// point to a location where the user only has a read access.
	MetadataSchemaUri string `json:"metadataSchemaUri,omitempty"`
	// Name: Output only. The resource name of the Index.
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// UpdateTime: Output only. Timestamp when this Index was most recently
	// updated. This also includes any update to the contents of the Index. Note
	// that Operations working on this Index may have their
	// Operations.metadata.generic_metadata.update_time a little after the value of
	// this timestamp, yet that does not mean their results are not already
	// reflected in the Index. Result of any successfully completed Operation on
	// the Index is reflected in it.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Index) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Index
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1IndexDatapoint: A datapoint of Index.
type GoogleCloudAiplatformV1beta1IndexDatapoint struct {
	// CrowdingTag: Optional. CrowdingTag of the datapoint, the number of neighbors
	// to return in each crowding can be configured during query.
	CrowdingTag *GoogleCloudAiplatformV1beta1IndexDatapointCrowdingTag `json:"crowdingTag,omitempty"`
	// DatapointId: Required. Unique identifier of the datapoint.
	DatapointId string `json:"datapointId,omitempty"`
	// FeatureVector: Required. Feature embedding vector for dense index. An array
	// of numbers with the length of [NearestNeighborSearchConfig.dimensions].
	FeatureVector []float64 `json:"featureVector,omitempty"`
	// NumericRestricts: Optional. List of Restrict of the datapoint, used to
	// perform "restricted searches" where boolean rule are used to filter the
	// subset of the database eligible for matching. This uses numeric comparisons.
	NumericRestricts []*GoogleCloudAiplatformV1beta1IndexDatapointNumericRestriction `json:"numericRestricts,omitempty"`
	// Restricts: Optional. List of Restrict of the datapoint, used to perform
	// "restricted searches" where boolean rule are used to filter the subset of
	// the database eligible for matching. This uses categorical tokens. See:
	// https://cloud.google.com/vertex-ai/docs/matching-engine/filtering
	Restricts []*GoogleCloudAiplatformV1beta1IndexDatapointRestriction `json:"restricts,omitempty"`
	// SparseEmbedding: Optional. Feature embedding vector for sparse index.
	SparseEmbedding *GoogleCloudAiplatformV1beta1IndexDatapointSparseEmbedding `json:"sparseEmbedding,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CrowdingTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrowdingTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1IndexDatapoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1IndexDatapoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1IndexDatapoint) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1IndexDatapoint
	var s1 struct {
		FeatureVector []gensupport.JSONFloat64 `json:"featureVector"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.FeatureVector = make([]float64, len(s1.FeatureVector))
	for i := range s1.FeatureVector {
		s.FeatureVector[i] = float64(s1.FeatureVector[i])
	}
	return nil
}

// GoogleCloudAiplatformV1beta1IndexDatapointCrowdingTag: Crowding tag is a
// constraint on a neighbor list produced by nearest neighbor search requiring
// that no more than some value k' of the k neighbors returned have the same
// value of crowding_attribute.
type GoogleCloudAiplatformV1beta1IndexDatapointCrowdingTag struct {
	// CrowdingAttribute: The attribute value used for crowding. The maximum number
	// of neighbors to return per crowding attribute value
	// (per_crowding_attribute_num_neighbors) is configured per-query. This field
	// is ignored if per_crowding_attribute_num_neighbors is larger than the total
	// number of neighbors to return for a given query.
	CrowdingAttribute string `json:"crowdingAttribute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CrowdingAttribute") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrowdingAttribute") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1IndexDatapointCrowdingTag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1IndexDatapointCrowdingTag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1IndexDatapointNumericRestriction: This field
// allows restricts to be based on numeric comparisons rather than categorical
// tokens.
type GoogleCloudAiplatformV1beta1IndexDatapointNumericRestriction struct {
	// Namespace: The namespace of this restriction. e.g.: cost.
	Namespace string `json:"namespace,omitempty"`
	// Op: This MUST be specified for queries and must NOT be specified for
	// datapoints.
	//
	// Possible values:
	//   "OPERATOR_UNSPECIFIED" - Default value of the enum.
	//   "LESS" - Datapoints are eligible iff their value is < the query's.
	//   "LESS_EQUAL" - Datapoints are eligible iff their value is <= the query's.
	//   "EQUAL" - Datapoints are eligible iff their value is == the query's.
	//   "GREATER_EQUAL" - Datapoints are eligible iff their value is >= the
	// query's.
	//   "GREATER" - Datapoints are eligible iff their value is > the query's.
	//   "NOT_EQUAL" - Datapoints are eligible iff their value is != the query's.
	Op string `json:"op,omitempty"`
	// ValueDouble: Represents 64 bit float.
	ValueDouble float64 `json:"valueDouble,omitempty"`
	// ValueFloat: Represents 32 bit float.
	ValueFloat float64 `json:"valueFloat,omitempty"`
	// ValueInt: Represents 64 bit integer.
	ValueInt int64 `json:"valueInt,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Namespace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Namespace") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1IndexDatapointNumericRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1IndexDatapointNumericRestriction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1IndexDatapointNumericRestriction) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1IndexDatapointNumericRestriction
	var s1 struct {
		ValueDouble gensupport.JSONFloat64 `json:"valueDouble"`
		ValueFloat  gensupport.JSONFloat64 `json:"valueFloat"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ValueDouble = float64(s1.ValueDouble)
	s.ValueFloat = float64(s1.ValueFloat)
	return nil
}

// GoogleCloudAiplatformV1beta1IndexDatapointRestriction: Restriction of a
// datapoint which describe its attributes(tokens) from each of several
// attribute categories(namespaces).
type GoogleCloudAiplatformV1beta1IndexDatapointRestriction struct {
	// AllowList: The attributes to allow in this namespace. e.g.: 'red'
	AllowList []string `json:"allowList,omitempty"`
	// DenyList: The attributes to deny in this namespace. e.g.: 'blue'
	DenyList []string `json:"denyList,omitempty"`
	// Namespace: The namespace of this restriction. e.g.: color.
	Namespace string `json:"namespace,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowList") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1IndexDatapointRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1IndexDatapointRestriction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1IndexDatapointSparseEmbedding: Feature embedding
// vector for sparse index. An array of numbers whose values are located in the
// specified dimensions.
type GoogleCloudAiplatformV1beta1IndexDatapointSparseEmbedding struct {
	// Dimensions: Required. The list of indexes for the embedding values of the
	// sparse vector.
	Dimensions googleapi.Int64s `json:"dimensions,omitempty"`
	// Values: Required. The list of embedding values of the sparse vector.
	Values []float64 `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dimensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1IndexDatapointSparseEmbedding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1IndexDatapointSparseEmbedding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudAiplatformV1beta1IndexDatapointSparseEmbedding) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudAiplatformV1beta1IndexDatapointSparseEmbedding
	var s1 struct {
		Values []gensupport.JSONFloat64 `json:"values"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Values = make([]float64, len(s1.Values))
	for i := range s1.Values {
		s.Values[i] = float64(s1.Values[i])
	}
	return nil
}

// GoogleCloudAiplatformV1beta1IndexEndpoint: Indexes are deployed into it. An
// IndexEndpoint can have multiple DeployedIndexes.
type GoogleCloudAiplatformV1beta1IndexEndpoint struct {
	// CreateTime: Output only. Timestamp when this IndexEndpoint was created.
	CreateTime string `json:"createTime,omitempty"`
	// DeployedIndexes: Output only. The indexes deployed in this endpoint.
	DeployedIndexes []*GoogleCloudAiplatformV1beta1DeployedIndex `json:"deployedIndexes,omitempty"`
	// Description: The description of the IndexEndpoint.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the IndexEndpoint. The name can
	// be up to 128 characters long and can consist of any UTF-8 characters.
	DisplayName string `json:"displayName,omitempty"`
	// EnablePrivateServiceConnect: Optional. Deprecated: If true, expose the
	// IndexEndpoint via private service connect. Only one of the fields, network
	// or enable_private_service_connect, can be set.
	EnablePrivateServiceConnect bool `json:"enablePrivateServiceConnect,omitempty"`
	// EncryptionSpec: Immutable. Customer-managed encryption key spec for an
	// IndexEndpoint. If set, this IndexEndpoint and all sub-resources of this
	// IndexEndpoint will be secured by this key.
	EncryptionSpec *GoogleCloudAiplatformV1beta1EncryptionSpec `json:"encryptionSpec,omitempty"`
	// Etag: Used to perform consistent read-modify-write updates. If not set, a
	// blind "overwrite" update happens.
	Etag string `json:"etag,omitempty"`
	// Labels: The labels with user-defined metadata to organize your
	// IndexEndpoints. Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The resource name of the IndexEndpoint.
	Name string `json:"name,omitempty"`
	// Network: Optional. The full name of the Google Compute Engine network
	// (https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to
	// which the IndexEndpoint should be peered. Private services access must
	// already be configured for the network. If left unspecified, the Endpoint is
	// not peered with any network. network and private_service_connect_config are
	// mutually exclusive. Format
	// (https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert):
	// `projects/{project}/global/networks/{network}`. Where {project} is a project
	// number, as in '12345', and {network} is network name.
	Network string `json:"network,omitempty"`
	// PrivateServiceConnectConfig: Optional. Configuration for private service
	// connect. network and private_service_connect_config are mutually exclusive.
	PrivateServiceConnectConfig *GoogleCloudAiplatformV1beta1PrivateServiceConnectConfig `json:"privateServiceConnectConfig,omitempty"`
	// PublicEndpointDomainName: Output only. If public_endpoint_enabled is true,
	// this field will be populated with the domain name to use for this index
	// endpoint.
	PublicEndpointDomainName string `json:"publicEndpointDomainName,omitempty"`
	// PublicEndpointEnabled: Optional. If true, the deployed index will be
	// accessible through public endpoint.
	PublicEndpointEnabled bool `json:"publicEndpointEnabled,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// UpdateTime: Output only. Timestamp when this IndexEndpoint was last updated.
	// This timestamp is not updated when the endpoint's DeployedIndexes are
	// updated, e.g. due to updates of the original Indexes they are the
	// deployments of.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1IndexEndpoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1IndexEndpoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1IndexPrivateEndpoints: IndexPrivateEndpoints
// proto is used to provide paths for users to send requests via private
// endpoints (e.g. private service access, private service connect). To send
// request via private service access, use match_grpc_address. To send request
// via private service connect, use service_attachment.
type GoogleCloudAiplatformV1beta1IndexPrivateEndpoints struct {
	// MatchGrpcAddress: Output only. The ip address used to send match gRPC
	// requests.
	MatchGrpcAddress string `json:"matchGrpcAddress,omitempty"`
	// PscAutomatedEndpoints: Output only. PscAutomatedEndpoints is populated if
	// private service connect is enabled if PscAutomatedConfig is set.
	PscAutomatedEndpoints []*GoogleCloudAiplatformV1beta1PscAutomatedEndpoints `json:"pscAutomatedEndpoints,omitempty"`
	// ServiceAttachment: Output only. The name of the service attachment resource.
	// Populated if private service connect is enabled.
	ServiceAttachment string `json:"serviceAttachment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MatchGrpcAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MatchGrpcAddress") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1IndexPrivateEndpoints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1IndexPrivateEndpoints
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1IndexStats: Stats of the Index.
type GoogleCloudAiplatformV1beta1IndexStats struct {
	// ShardsCount: Output only. The number of shards in the Index.
	ShardsCount int64 `json:"shardsCount,omitempty"`
	// SparseVectorsCount: Output only. The number of sparse vectors in the Index.
	SparseVectorsCount int64 `json:"sparseVectorsCount,omitempty,string"`
	// VectorsCount: Output only. The number of dense vectors in the Index.
	VectorsCount int64 `json:"vectorsCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ShardsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ShardsCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1IndexStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1IndexStats
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1InputDataConfig: Specifies Vertex AI owned input
// data to be used for training, and possibly evaluating, the Model.
type GoogleCloudAiplatformV1beta1InputDataConfig struct {
	// AnnotationSchemaUri: Applicable only to custom training with Datasets that
	// have DataItems and Annotations. Cloud Storage URI that points to a YAML file
	// describing the annotation schema. The schema is defined as an OpenAPI 3.0.2
	// Schema Object
	// (https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// The schema files that can be used here are found in
	// gs://google-cloud-aiplatform/schema/dataset/annotation/ , note that the
	// chosen schema must be consistent with metadata of the Dataset specified by
	// dataset_id. Only Annotations that both match this schema and belong to
	// DataItems not ignored by the split method are used in respectively training,
	// validation or test role, depending on the role of the DataItem they are on.
	// When used in conjunction with annotations_filter, the Annotations used for
	// training are filtered by both annotations_filter and annotation_schema_uri.
	AnnotationSchemaUri string `json:"annotationSchemaUri,omitempty"`
	// AnnotationsFilter: Applicable only to Datasets that have DataItems and
	// Annotations. A filter on Annotations of the Dataset. Only Annotations that
	// both match this filter and belong to DataItems not ignored by the split
	// method are used in respectively training, validation or test role, depending
	// on the role of the DataItem they are on (for the auto-assigned that role is
	// decided by Vertex AI). A filter with same syntax as the one used in
	// ListAnnotations may be used, but note here it filters across all Annotations
	// of the Dataset, and not just within a single DataItem.
	AnnotationsFilter string `json:"annotationsFilter,omitempty"`
	// BigqueryDestination: Only applicable to custom training with tabular Dataset
	// with BigQuery source. The BigQuery project location where the training data
	// is to be written to. In the given project a new dataset is created with name
	// `dataset___` where timestamp is in YYYY_MM_DDThh_mm_ss_sssZ format. All
	// training input data is written into that dataset. In the dataset three
	// tables are created, `training`, `validation` and `test`. * AIP_DATA_FORMAT =
	// "bigquery". * AIP_TRAINING_DATA_URI =
	// "bigquery_destination.dataset___.training" * AIP_VALIDATION_DATA_URI =
	// "bigquery_destination.dataset___.validation" * AIP_TEST_DATA_URI =
	// "bigquery_destination.dataset___.test"
	BigqueryDestination *GoogleCloudAiplatformV1beta1BigQueryDestination `json:"bigqueryDestination,omitempty"`
	// DatasetId: Required. The ID of the Dataset in the same Project and Location
	// which data will be used to train the Model. The Dataset must use schema
	// compatible with Model being trained, and what is compatible should be
	// described in the used TrainingPipeline's training_task_definition. For
	// tabular Datasets, all their data is exported to training, to pick and choose
	// from.
	DatasetId string `json:"datasetId,omitempty"`
	// FilterSplit: Split based on the provided filters for each set.
	FilterSplit *GoogleCloudAiplatformV1beta1FilterSplit `json:"filterSplit,omitempty"`
	// FractionSplit: Split based on fractions defining the size of each set.
	FractionSplit *GoogleCloudAiplatformV1beta1FractionSplit `json:"fractionSplit,omitempty"`
	// GcsDestination: The Cloud Storage location where the training data is to be
	// written to. In the given directory a new directory is created with name:
	// `dataset---` where timestamp is in YYYY-MM-DDThh:mm:ss.sssZ ISO-8601 format.
	// All training input data is written into that directory. The Vertex AI
	// environment variables representing Cloud Storage data URIs are represented
	// in the Cloud Storage wildcard format to support sharded data. e.g.:
	// "gs://.../training-*.jsonl" * AIP_DATA_FORMAT = "jsonl" for non-tabular
	// data, "csv" for tabular data * AIP_TRAINING_DATA_URI =
	// "gcs_destination/dataset---/training-*.${AIP_DATA_FORMAT}" *
	// AIP_VALIDATION_DATA_URI =
	// "gcs_destination/dataset---/validation-*.${AIP_DATA_FORMAT}" *
	// AIP_TEST_DATA_URI = "gcs_destination/dataset---/test-*.${AIP_DATA_FORMAT}"
	GcsDestination *GoogleCloudAiplatformV1beta1GcsDestination `json:"gcsDestination,omitempty"`
	// PersistMlUseAssignment: Whether to persist the ML use assignment to data
	// item system labels.
	PersistMlUseAssignment bool `json:"persistMlUseAssignment,omitempty"`
	// PredefinedSplit: Supported only for tabular Datasets. Split based on a
	// predefined key.
	PredefinedSplit *GoogleCloudAiplatformV1beta1PredefinedSplit `json:"predefinedSplit,omitempty"`
	// SavedQueryId: Only applicable to Datasets that have SavedQueries. The ID of
	// a SavedQuery (annotation set) under the Dataset specified by dataset_id used
	// for filtering Annotations for training. Only Annotations that are associated
	// with this SavedQuery are used in respectively training. When used in
	// conjunction with annotations_filter, the Annotations used for training are
	// filtered by both saved_query_id and annotations_filter. Only one of
	// saved_query_id and annotation_schema_uri should be specified as both of them
	// represent the same thing: problem type.
	SavedQueryId string `json:"savedQueryId,omitempty"`
	// StratifiedSplit: Supported only for tabular Datasets. Split based on the
	// distribution of the specified column.
	StratifiedSplit *GoogleCloudAiplatformV1beta1StratifiedSplit `json:"stratifiedSplit,omitempty"`
	// TimestampSplit: Supported only for tabular Datasets. Split based on the
	// timestamp of the input data pieces.
	TimestampSplit *GoogleCloudAiplatformV1beta1TimestampSplit `json:"timestampSplit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnnotationSchemaUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnnotationSchemaUri") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1InputDataConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1InputDataConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1Int64Array: A list of int64 values.
type GoogleCloudAiplatformV1beta1Int64Array struct {
	// Values: A list of int64 values.
	Values googleapi.Int64s `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1Int64Array) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1Int64Array
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1IntegratedGradientsAttribution: An attribution
// method that computes the Aumann-Shapley value taking advantage of the
// model's fully differentiable structure. Refer to this paper for more
// details: https://arxiv.org/abs/1703.01365
type GoogleCloudAiplatformV1beta1IntegratedGradientsAttribution struct {
	// BlurBaselineConfig: Config for IG with blur baseline. When enabled, a linear
	// path from the maximally blurred image to the input image is created. Using a
	// blurred baseline instead of zero (black image) is motivated by the BlurIG
	// approach explained here: https://arxiv.org/abs/2004.03383
	BlurBaselineConfig *GoogleCloudAiplatformV1beta1BlurBaselineConfig `json:"blurBaselineConfig,omitempty"`
	// SmoothGradConfig: Config for SmoothGrad approximation of gradients. When
	// enabled, the gradients are approximated by averaging the gradients from
	// noisy samples in the vicinity of the inputs. Adding noise can help improve
	// the computed gradients. Refer to this paper for more details:
	// https://arxiv.org/pdf/1706.03825.pdf
	SmoothGradConfig *GoogleCloudAiplatformV1beta1SmoothGradConfig `json:"smoothGradConfig,omitempty"`
	// StepCount: Required. The number of steps for approximating the path
	// integral. A good value to start is 50 and gradually increase until the sum
	// to diff property is within the desired error range. Valid range of its value
	// is [1, 100], inclusively.
	StepCount int64 `json:"stepCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlurBaselineConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlurBaselineConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1IntegratedGradientsAttribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1IntegratedGradientsAttribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1InternalOsServiceStateInstance: Request message
// for [InternalOsServiceStateInstance].
type GoogleCloudAiplatformV1beta1InternalOsServiceStateInstance struct {
	// ServiceName: Required. internal service name.
	//
	// Possible values:
	//   "INTERNAL_OS_SERVICE_ENUM_UNSPECIFIED" - Service name unknown.
	//   "DOCKER_SERVICE_STATE" - Represents the internal os docker client.
	//   "CONTROL_PLANE_API_DNS_STATE" - Represents resolving DNS for the control
	// plane api endpoint.
	//   "PROXY_REGISTRATION_DNS_STATE" - Represents resolving DNS for the proxy
	// registration endpoint.
	//   "JUPYTER_STATE" - Represents the jupyter endpoint.
	//   "JUPYTER_API_STATE" - Represents the jupyter/api endpoint.
	//   "EUC_METADATA_API_STATE" - Represents the EUC metadata server API
	// endpoint.
	//   "EUC_AGENT_API_STATE" - Represents the EUC agent server API endpoint.
	//   "IDLE_SHUTDOWN_AGENT_STATE" - Represents the idle shutdown agent sidecar
	// container.
	//   "PROXY_AGENT_STATE" - Represents the proxy agent sidecar container.
	//   "GCR_DNS_STATE" - Represents resolving DNS for the gcr.io endpoint.
	//   "GUEST_ATTRIBUTE_STATE" - Represents if the guest attribute service is
	// enabled.
	ServiceName string `json:"serviceName,omitempty"`
	// ServiceState: Required. internal service state.
	//
	// Possible values:
	//   "UNKNOWN" - Health status is unknown: not initialized or failed to
	// retrieve.
	//   "HEALTHY" - The resource is healthy.
	//   "UNHEALTHY" - The resource is unhealthy.
	ServiceState string `json:"serviceState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1InternalOsServiceStateInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1InternalOsServiceStateInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1JiraSource: The Jira source for the
// ImportRagFilesRequest.
type GoogleCloudAiplatformV1beta1JiraSource struct {
	// JiraQueries: Required. The Jira queries.
	JiraQueries []*GoogleCloudAiplatformV1beta1JiraSourceJiraQueries `json:"jiraQueries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JiraQueries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JiraQueries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1JiraSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1JiraSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1JiraSourceJiraQueries: JiraQueries contains the
// Jira queries and corresponding authentication.
type GoogleCloudAiplatformV1beta1JiraSourceJiraQueries struct {
	// ApiKeyConfig: Required. The SecretManager secret version resource name (e.g.
	// projects/{project}/secrets/{secret}/versions/{version}) storing the Jira API
	// key. See Manage API tokens for your Atlassian account
	// (https://support.atlassian.com/atlassian-account/docs/manage-api-tokens-for-your-atlassian-account/).
	ApiKeyConfig *GoogleCloudAiplatformV1beta1ApiAuthApiKeyConfig `json:"apiKeyConfig,omitempty"`
	// CustomQueries: A list of custom Jira queries to import. For information
	// about JQL (Jira Query Language), see
	// https://support.atlassian.com/jira-service-management-cloud/docs/use-advanced-search-with-jira-query-language-jql/
	CustomQueries []string `json:"customQueries,omitempty"`
	// Email: Required. The Jira email address.
	Email string `json:"email,omitempty"`
	// Projects: A list of Jira projects to import in their entirety.
	Projects []string `json:"projects,omitempty"`
	// ServerUri: Required. The Jira server URI.
	ServerUri string `json:"serverUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1JiraSourceJiraQueries) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1JiraSourceJiraQueries
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1LargeModelReference: Contains information about
// the Large Model.
type GoogleCloudAiplatformV1beta1LargeModelReference struct {
	// Name: Required. The unique name of the large Foundation or pre-built model.
	// Like "chat-bison", "text-bison". Or model name with version ID, like
	// "chat-bison@001", "text-bison@005", etc.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1LargeModelReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1LargeModelReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1LineageSubgraph: A subgraph of the overall
// lineage graph. Event edges connect Artifact and Execution nodes.
type GoogleCloudAiplatformV1beta1LineageSubgraph struct {
	// Artifacts: The Artifact nodes in the subgraph.
	Artifacts []*GoogleCloudAiplatformV1beta1Artifact `json:"artifacts,omitempty"`
	// Events: The Event edges between Artifacts and Executions in the subgraph.
	Events []*GoogleCloudAiplatformV1beta1Event `json:"events,omitempty"`
	// Executions: The Execution nodes in the subgraph.
	Executions []*GoogleCloudAiplatformV1beta1Execution `json:"executions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Artifacts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Artifacts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1LineageSubgraph) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1LineageSubgraph
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListAnnotationsResponse: Response message for
// DatasetService.ListAnnotations.
type GoogleCloudAiplatformV1beta1ListAnnotationsResponse struct {
	// Annotations: A list of Annotations that matches the specified filter in the
	// request.
	Annotations []*GoogleCloudAiplatformV1beta1Annotation `json:"annotations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListAnnotationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListAnnotationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListArtifactsResponse: Response message for
// MetadataService.ListArtifacts.
type GoogleCloudAiplatformV1beta1ListArtifactsResponse struct {
	// Artifacts: The Artifacts retrieved from the MetadataStore.
	Artifacts []*GoogleCloudAiplatformV1beta1Artifact `json:"artifacts,omitempty"`
	// NextPageToken: A token, which can be sent as ListArtifactsRequest.page_token
	// to retrieve the next page. If this field is not populated, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Artifacts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Artifacts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListArtifactsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListArtifactsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListBatchPredictionJobsResponse: Response
// message for JobService.ListBatchPredictionJobs
type GoogleCloudAiplatformV1beta1ListBatchPredictionJobsResponse struct {
	// BatchPredictionJobs: List of BatchPredictionJobs in the requested page.
	BatchPredictionJobs []*GoogleCloudAiplatformV1beta1BatchPredictionJob `json:"batchPredictionJobs,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListBatchPredictionJobsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BatchPredictionJobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchPredictionJobs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListBatchPredictionJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListBatchPredictionJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListCachedContentsResponse: Response with a list
// of CachedContents.
type GoogleCloudAiplatformV1beta1ListCachedContentsResponse struct {
	// CachedContents: List of cached contents.
	CachedContents []*GoogleCloudAiplatformV1beta1CachedContent `json:"cachedContents,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CachedContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CachedContents") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListCachedContentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListCachedContentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListContextsResponse: Response message for
// MetadataService.ListContexts.
type GoogleCloudAiplatformV1beta1ListContextsResponse struct {
	// Contexts: The Contexts retrieved from the MetadataStore.
	Contexts []*GoogleCloudAiplatformV1beta1Context `json:"contexts,omitempty"`
	// NextPageToken: A token, which can be sent as ListContextsRequest.page_token
	// to retrieve the next page. If this field is not populated, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Contexts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Contexts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListContextsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListContextsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListCustomJobsResponse: Response message for
// JobService.ListCustomJobs
type GoogleCloudAiplatformV1beta1ListCustomJobsResponse struct {
	// CustomJobs: List of CustomJobs in the requested page.
	CustomJobs []*GoogleCloudAiplatformV1beta1CustomJob `json:"customJobs,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListCustomJobsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CustomJobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomJobs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListCustomJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListCustomJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListDataItemsResponse: Response message for
// DatasetService.ListDataItems.
type GoogleCloudAiplatformV1beta1ListDataItemsResponse struct {
	// DataItems: A list of DataItems that matches the specified filter in the
	// request.
	DataItems []*GoogleCloudAiplatformV1beta1DataItem `json:"dataItems,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataItems") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataItems") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListDataItemsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListDataItemsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListDataLabelingJobsResponse: Response message
// for JobService.ListDataLabelingJobs.
type GoogleCloudAiplatformV1beta1ListDataLabelingJobsResponse struct {
	// DataLabelingJobs: A list of DataLabelingJobs that matches the specified
	// filter in the request.
	DataLabelingJobs []*GoogleCloudAiplatformV1beta1DataLabelingJob `json:"dataLabelingJobs,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataLabelingJobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataLabelingJobs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListDataLabelingJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListDataLabelingJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListDatasetVersionsResponse: Response message
// for DatasetService.ListDatasetVersions.
type GoogleCloudAiplatformV1beta1ListDatasetVersionsResponse struct {
	// DatasetVersions: A list of DatasetVersions that matches the specified filter
	// in the request.
	DatasetVersions []*GoogleCloudAiplatformV1beta1DatasetVersion `json:"datasetVersions,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DatasetVersions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetVersions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListDatasetVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListDatasetVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListDatasetsResponse: Response message for
// DatasetService.ListDatasets.
type GoogleCloudAiplatformV1beta1ListDatasetsResponse struct {
	// Datasets: A list of Datasets that matches the specified filter in the
	// request.
	Datasets []*GoogleCloudAiplatformV1beta1Dataset `json:"datasets,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Datasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Datasets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListDatasetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListDatasetsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListDeploymentResourcePoolsResponse: Response
// message for ListDeploymentResourcePools method.
type GoogleCloudAiplatformV1beta1ListDeploymentResourcePoolsResponse struct {
	// DeploymentResourcePools: The DeploymentResourcePools from the specified
	// location.
	DeploymentResourcePools []*GoogleCloudAiplatformV1beta1DeploymentResourcePool `json:"deploymentResourcePools,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DeploymentResourcePools") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeploymentResourcePools") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListDeploymentResourcePoolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListDeploymentResourcePoolsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListEndpointsResponse: Response message for
// EndpointService.ListEndpoints.
type GoogleCloudAiplatformV1beta1ListEndpointsResponse struct {
	// Endpoints: List of Endpoints in the requested page.
	Endpoints []*GoogleCloudAiplatformV1beta1Endpoint `json:"endpoints,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListEndpointsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Endpoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Endpoints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListEndpointsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListEndpointsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListEntityTypesResponse: Response message for
// FeaturestoreService.ListEntityTypes.
type GoogleCloudAiplatformV1beta1ListEntityTypesResponse struct {
	// EntityTypes: The EntityTypes matching the request.
	EntityTypes []*GoogleCloudAiplatformV1beta1EntityType `json:"entityTypes,omitempty"`
	// NextPageToken: A token, which can be sent as
	// ListEntityTypesRequest.page_token to retrieve the next page. If this field
	// is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListEventsResponse: Response message for
// SessionService.ListEvents.
type GoogleCloudAiplatformV1beta1ListEventsResponse struct {
	// NextPageToken: A token, which can be sent as ListEventsRequest.page_token to
	// retrieve the next page. Absence of this field indicates there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SessionEvents: A list of events matching the request.
	SessionEvents []*GoogleCloudAiplatformV1beta1SessionEvent `json:"sessionEvents,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListEventsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListExampleStoresResponse: Response message for
// ExampleStoreService.ListExampleStores.
type GoogleCloudAiplatformV1beta1ListExampleStoresResponse struct {
	// ExampleStores: List of ExampleStore in the requested page.
	ExampleStores []*GoogleCloudAiplatformV1beta1ExampleStore `json:"exampleStores,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListExampleStoresRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExampleStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExampleStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListExampleStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListExampleStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListExecutionsResponse: Response message for
// MetadataService.ListExecutions.
type GoogleCloudAiplatformV1beta1ListExecutionsResponse struct {
	// Executions: The Executions retrieved from the MetadataStore.
	Executions []*GoogleCloudAiplatformV1beta1Execution `json:"executions,omitempty"`
	// NextPageToken: A token, which can be sent as
	// ListExecutionsRequest.page_token to retrieve the next page. If this field is
	// not populated, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Executions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Executions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListExecutionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListExecutionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListExtensionsResponse: Response message for
// ExtensionRegistryService.ListExtensions
type GoogleCloudAiplatformV1beta1ListExtensionsResponse struct {
	// Extensions: List of Extension in the requested page.
	Extensions []*GoogleCloudAiplatformV1beta1Extension `json:"extensions,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListExtensionsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Extensions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Extensions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListExtensionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListExtensionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListFeatureGroupsResponse: Response message for
// FeatureRegistryService.ListFeatureGroups.
type GoogleCloudAiplatformV1beta1ListFeatureGroupsResponse struct {
	// FeatureGroups: The FeatureGroups matching the request.
	FeatureGroups []*GoogleCloudAiplatformV1beta1FeatureGroup `json:"featureGroups,omitempty"`
	// NextPageToken: A token, which can be sent as
	// ListFeatureGroupsRequest.page_token to retrieve the next page. If this field
	// is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeatureGroups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureGroups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListFeatureGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListFeatureGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListFeatureMonitorJobsResponse: Response message
// for FeatureRegistryService.ListFeatureMonitorJobs.
type GoogleCloudAiplatformV1beta1ListFeatureMonitorJobsResponse struct {
	// FeatureMonitorJobs: The FeatureMonitorJobs matching the request.
	FeatureMonitorJobs []*GoogleCloudAiplatformV1beta1FeatureMonitorJob `json:"featureMonitorJobs,omitempty"`
	// NextPageToken: A token, which can be sent as
	// ListFeatureMonitorJobsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeatureMonitorJobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureMonitorJobs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListFeatureMonitorJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListFeatureMonitorJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListFeatureMonitorsResponse: Response message
// for FeatureRegistryService.ListFeatureMonitors.
type GoogleCloudAiplatformV1beta1ListFeatureMonitorsResponse struct {
	// FeatureMonitors: The FeatureMonitors matching the request.
	FeatureMonitors []*GoogleCloudAiplatformV1beta1FeatureMonitor `json:"featureMonitors,omitempty"`
	// NextPageToken: A token, which can be sent as
	// ListFeatureMonitorsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeatureMonitors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureMonitors") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListFeatureMonitorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListFeatureMonitorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListFeatureOnlineStoresResponse: Response
// message for FeatureOnlineStoreAdminService.ListFeatureOnlineStores.
type GoogleCloudAiplatformV1beta1ListFeatureOnlineStoresResponse struct {
	// FeatureOnlineStores: The FeatureOnlineStores matching the request.
	FeatureOnlineStores []*GoogleCloudAiplatformV1beta1FeatureOnlineStore `json:"featureOnlineStores,omitempty"`
	// NextPageToken: A token, which can be sent as
	// ListFeatureOnlineStoresRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeatureOnlineStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureOnlineStores") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListFeatureOnlineStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListFeatureOnlineStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListFeatureViewSyncsResponse: Response message
// for FeatureOnlineStoreAdminService.ListFeatureViewSyncs.
type GoogleCloudAiplatformV1beta1ListFeatureViewSyncsResponse struct {
	// FeatureViewSyncs: The FeatureViewSyncs matching the request.
	FeatureViewSyncs []*GoogleCloudAiplatformV1beta1FeatureViewSync `json:"featureViewSyncs,omitempty"`
	// NextPageToken: A token, which can be sent as
	// ListFeatureViewSyncsRequest.page_token to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeatureViewSyncs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureViewSyncs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListFeatureViewSyncsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListFeatureViewSyncsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListFeatureViewsResponse: Response message for
// FeatureOnlineStoreAdminService.ListFeatureViews.
type GoogleCloudAiplatformV1beta1ListFeatureViewsResponse struct {
	// FeatureViews: The FeatureViews matching the request.
	FeatureViews []*GoogleCloudAiplatformV1beta1FeatureView `json:"featureViews,omitempty"`
	// NextPageToken: A token, which can be sent as
	// ListFeatureViewsRequest.page_token to retrieve the next page. If this field
	// is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FeatureViews") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FeatureViews") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListFeatureViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListFeatureViewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListFeaturesResponse: Response message for
// FeaturestoreService.ListFeatures. Response message for
// FeatureRegistryService.ListFeatures.
type GoogleCloudAiplatformV1beta1ListFeaturesResponse struct {
	// Features: The Features matching the request.
	Features []*GoogleCloudAiplatformV1beta1Feature `json:"features,omitempty"`
	// NextPageToken: A token, which can be sent as ListFeaturesRequest.page_token
	// to retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Features") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Features") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListFeaturesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListFeaturesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListFeaturestoresResponse: Response message for
// FeaturestoreService.ListFeaturestores.
type GoogleCloudAiplatformV1beta1ListFeaturestoresResponse struct {
	// Featurestores: The Featurestores matching the request.
	Featurestores []*GoogleCloudAiplatformV1beta1Featurestore `json:"featurestores,omitempty"`
	// NextPageToken: A token, which can be sent as
	// ListFeaturestoresRequest.page_token to retrieve the next page. If this field
	// is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Featurestores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Featurestores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListFeaturestoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListFeaturestoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListHyperparameterTuningJobsResponse: Response
// message for JobService.ListHyperparameterTuningJobs
type GoogleCloudAiplatformV1beta1ListHyperparameterTuningJobsResponse struct {
	// HyperparameterTuningJobs: List of HyperparameterTuningJobs in the requested
	// page. HyperparameterTuningJob.trials of the jobs will be not be returned.
	HyperparameterTuningJobs []*GoogleCloudAiplatformV1beta1HyperparameterTuningJob `json:"hyperparameterTuningJobs,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListHyperparameterTuningJobsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "HyperparameterTuningJobs")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HyperparameterTuningJobs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListHyperparameterTuningJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListHyperparameterTuningJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListIndexEndpointsResponse: Response message for
// IndexEndpointService.ListIndexEndpoints.
type GoogleCloudAiplatformV1beta1ListIndexEndpointsResponse struct {
	// IndexEndpoints: List of IndexEndpoints in the requested page.
	IndexEndpoints []*GoogleCloudAiplatformV1beta1IndexEndpoint `json:"indexEndpoints,omitempty"`
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListIndexEndpointsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "IndexEndpoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IndexEndpoints") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListIndexEndpointsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListIndexEndpointsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListIndexesResponse: Response message for
// IndexService.ListIndexes.
type GoogleCloudAiplatformV1beta1ListIndexesResponse struct {
	// Indexes: List of indexes in the requested page.
	Indexes []*GoogleCloudAiplatformV1beta1Index `json:"indexes,omitempty"`
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListIndexesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Indexes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Indexes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListIndexesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListIndexesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListMetadataSchemasResponse: Response message
// for MetadataService.ListMetadataSchemas.
type GoogleCloudAiplatformV1beta1ListMetadataSchemasResponse struct {
	// MetadataSchemas: The MetadataSchemas found for the MetadataStore.
	MetadataSchemas []*GoogleCloudAiplatformV1beta1MetadataSchema `json:"metadataSchemas,omitempty"`
	// NextPageToken: A token, which can be sent as
	// ListMetadataSchemasRequest.page_token to retrieve the next page. If this
	// field is not populated, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MetadataSchemas") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetadataSchemas") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListMetadataSchemasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListMetadataSchemasResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListMetadataStoresResponse: Response message for
// MetadataService.ListMetadataStores.
type GoogleCloudAiplatformV1beta1ListMetadataStoresResponse struct {
	// MetadataStores: The MetadataStores found for the Location.
	MetadataStores []*GoogleCloudAiplatformV1beta1MetadataStore `json:"metadataStores,omitempty"`
	// NextPageToken: A token, which can be sent as
	// ListMetadataStoresRequest.page_token to retrieve the next page. If this
	// field is not populated, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "MetadataStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetadataStores") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListMetadataStoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListMetadataStoresResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListModelDeploymentMonitoringJobsResponse:
// Response message for JobService.ListModelDeploymentMonitoringJobs.
type GoogleCloudAiplatformV1beta1ListModelDeploymentMonitoringJobsResponse struct {
	// ModelDeploymentMonitoringJobs: A list of ModelDeploymentMonitoringJobs that
	// matches the specified filter in the request.
	ModelDeploymentMonitoringJobs []*GoogleCloudAiplatformV1beta1ModelDeploymentMonitoringJob `json:"modelDeploymentMonitoringJobs,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "ModelDeploymentMonitoringJobs") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelDeploymentMonitoringJobs")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListModelDeploymentMonitoringJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListModelDeploymentMonitoringJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListModelEvaluationSlicesResponse: Response
// message for ModelService.ListModelEvaluationSlices.
type GoogleCloudAiplatformV1beta1ListModelEvaluationSlicesResponse struct {
	// ModelEvaluationSlices: List of ModelEvaluations in the requested page.
	ModelEvaluationSlices []*GoogleCloudAiplatformV1beta1ModelEvaluationSlice `json:"modelEvaluationSlices,omitempty"`
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListModelEvaluationSlicesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ModelEvaluationSlices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelEvaluationSlices") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListModelEvaluationSlicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListModelEvaluationSlicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListModelEvaluationsResponse: Response message
// for ModelService.ListModelEvaluations.
type GoogleCloudAiplatformV1beta1ListModelEvaluationsResponse struct {
	// ModelEvaluations: List of ModelEvaluations in the requested page.
	ModelEvaluations []*GoogleCloudAiplatformV1beta1ModelEvaluation `json:"modelEvaluations,omitempty"`
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListModelEvaluationsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ModelEvaluations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelEvaluations") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListModelEvaluationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListModelEvaluationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListModelMonitoringJobsResponse: Response
// message for ModelMonitoringService.ListModelMonitoringJobs.
type GoogleCloudAiplatformV1beta1ListModelMonitoringJobsResponse struct {
	// ModelMonitoringJobs: A list of ModelMonitoringJobs that matches the
	// specified filter in the request.
	ModelMonitoringJobs []*GoogleCloudAiplatformV1beta1ModelMonitoringJob `json:"modelMonitoringJobs,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ModelMonitoringJobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelMonitoringJobs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListModelMonitoringJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListModelMonitoringJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListModelMonitorsResponse: Response message for
// ModelMonitoringService.ListModelMonitors
type GoogleCloudAiplatformV1beta1ListModelMonitorsResponse struct {
	// ModelMonitors: List of ModelMonitor in the requested page.
	ModelMonitors []*GoogleCloudAiplatformV1beta1ModelMonitor `json:"modelMonitors,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListModelMonitorsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ModelMonitors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelMonitors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListModelMonitorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListModelMonitorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListModelVersionCheckpointsResponse: Response
// message for ModelService.ListModelVersionCheckpoints
type GoogleCloudAiplatformV1beta1ListModelVersionCheckpointsResponse struct {
	// Checkpoints: List of Model Version checkpoints.
	Checkpoints []*GoogleCloudAiplatformV1beta1ModelVersionCheckpoint `json:"checkpoints,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListModelVersionCheckpointsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Checkpoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Checkpoints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListModelVersionCheckpointsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListModelVersionCheckpointsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListModelVersionsResponse: Response message for
// ModelService.ListModelVersions
type GoogleCloudAiplatformV1beta1ListModelVersionsResponse struct {
	// Models: List of Model versions in the requested page. In the returned Model
	// name field, version ID instead of regvision tag will be included.
	Models []*GoogleCloudAiplatformV1beta1Model `json:"models,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListModelVersionsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Models") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListModelVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListModelVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListModelsResponse: Response message for
// ModelService.ListModels
type GoogleCloudAiplatformV1beta1ListModelsResponse struct {
	// Models: List of Models in the requested page.
	Models []*GoogleCloudAiplatformV1beta1Model `json:"models,omitempty"`
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListModelsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Models") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListNasJobsResponse: Response message for
// JobService.ListNasJobs
type GoogleCloudAiplatformV1beta1ListNasJobsResponse struct {
	// NasJobs: List of NasJobs in the requested page. NasJob.nas_job_output of the
	// jobs will not be returned.
	NasJobs []*GoogleCloudAiplatformV1beta1NasJob `json:"nasJobs,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListNasJobsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NasJobs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NasJobs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListNasJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListNasJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListNasTrialDetailsResponse: Response message
// for JobService.ListNasTrialDetails
type GoogleCloudAiplatformV1beta1ListNasTrialDetailsResponse struct {
	// NasTrialDetails: List of top NasTrials in the requested page.
	NasTrialDetails []*GoogleCloudAiplatformV1beta1NasTrialDetail `json:"nasTrialDetails,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListNasTrialDetailsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NasTrialDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NasTrialDetails") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListNasTrialDetailsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListNasTrialDetailsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListNotebookExecutionJobsResponse: Response
// message for [NotebookService.CreateNotebookExecutionJob]
type GoogleCloudAiplatformV1beta1ListNotebookExecutionJobsResponse struct {
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListNotebookExecutionJobsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// NotebookExecutionJobs: List of NotebookExecutionJobs in the requested page.
	NotebookExecutionJobs []*GoogleCloudAiplatformV1beta1NotebookExecutionJob `json:"notebookExecutionJobs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListNotebookExecutionJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListNotebookExecutionJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListNotebookRuntimeTemplatesResponse: Response
// message for NotebookService.ListNotebookRuntimeTemplates.
type GoogleCloudAiplatformV1beta1ListNotebookRuntimeTemplatesResponse struct {
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListNotebookRuntimeTemplatesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// NotebookRuntimeTemplates: List of NotebookRuntimeTemplates in the requested
	// page.
	NotebookRuntimeTemplates []*GoogleCloudAiplatformV1beta1NotebookRuntimeTemplate `json:"notebookRuntimeTemplates,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListNotebookRuntimeTemplatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListNotebookRuntimeTemplatesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListNotebookRuntimesResponse: Response message
// for NotebookService.ListNotebookRuntimes.
type GoogleCloudAiplatformV1beta1ListNotebookRuntimesResponse struct {
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListNotebookRuntimesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// NotebookRuntimes: List of NotebookRuntimes in the requested page.
	NotebookRuntimes []*GoogleCloudAiplatformV1beta1NotebookRuntime `json:"notebookRuntimes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListNotebookRuntimesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListNotebookRuntimesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListOptimalTrialsRequest: Request message for
// VizierService.ListOptimalTrials.
type GoogleCloudAiplatformV1beta1ListOptimalTrialsRequest struct {
}

// GoogleCloudAiplatformV1beta1ListOptimalTrialsResponse: Response message for
// VizierService.ListOptimalTrials.
type GoogleCloudAiplatformV1beta1ListOptimalTrialsResponse struct {
	// OptimalTrials: The pareto-optimal Trials for multiple objective Study or the
	// optimal trial for single objective Study. The definition of pareto-optimal
	// can be checked in wiki page. https://en.wikipedia.org/wiki/Pareto_efficiency
	OptimalTrials []*GoogleCloudAiplatformV1beta1Trial `json:"optimalTrials,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "OptimalTrials") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OptimalTrials") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListOptimalTrialsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListOptimalTrialsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListPersistentResourcesResponse: Response
// message for PersistentResourceService.ListPersistentResources
type GoogleCloudAiplatformV1beta1ListPersistentResourcesResponse struct {
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListPersistentResourcesRequest.page_token to obtain that page.
	NextPageToken       string                                            `json:"nextPageToken,omitempty"`
	PersistentResources []*GoogleCloudAiplatformV1beta1PersistentResource `json:"persistentResources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListPersistentResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListPersistentResourcesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListPipelineJobsResponse: Response message for
// PipelineService.ListPipelineJobs
type GoogleCloudAiplatformV1beta1ListPipelineJobsResponse struct {
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListPipelineJobsRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PipelineJobs: List of PipelineJobs in the requested page.
	PipelineJobs []*GoogleCloudAiplatformV1beta1PipelineJob `json:"pipelineJobs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListPipelineJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListPipelineJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListPublisherModelsResponse: Response message
// for ModelGardenService.ListPublisherModels.
type GoogleCloudAiplatformV1beta1ListPublisherModelsResponse struct {
	// NextPageToken: A token to retrieve next page of results. Pass to
	// ListPublisherModels.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PublisherModels: List of PublisherModels in the requested page.
	PublisherModels []*GoogleCloudAiplatformV1beta1PublisherModel `json:"publisherModels,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListPublisherModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListPublisherModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListRagCorporaResponse: Response message for
// VertexRagDataService.ListRagCorpora.
type GoogleCloudAiplatformV1beta1ListRagCorporaResponse struct {
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListRagCorporaRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// RagCorpora: List of RagCorpora in the requested page.
	RagCorpora []*GoogleCloudAiplatformV1beta1RagCorpus `json:"ragCorpora,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListRagCorporaResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListRagCorporaResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListRagFilesResponse: Response message for
// VertexRagDataService.ListRagFiles.
type GoogleCloudAiplatformV1beta1ListRagFilesResponse struct {
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListRagFilesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// RagFiles: List of RagFiles in the requested page.
	RagFiles []*GoogleCloudAiplatformV1beta1RagFile `json:"ragFiles,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListRagFilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListRagFilesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListReasoningEnginesResponse: Response message
// for ReasoningEngineService.ListReasoningEngines
type GoogleCloudAiplatformV1beta1ListReasoningEnginesResponse struct {
	// NextPageToken: A token to retrieve the next page of results. Pass to
	// ListReasoningEnginesRequest.page_token to obtain that page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ReasoningEngines: List of ReasoningEngines in the requested page.
	ReasoningEngines []*GoogleCloudAiplatformV1beta1ReasoningEngine `json:"reasoningEngines,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudAiplatformV1beta1ListReasoningEnginesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAiplatformV1beta1ListReasoningEnginesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudAiplatformV1beta1ListSavedQueriesResponse: Response message for
// DatasetService.ListSavedQueries.
type GoogleCloudAiplatformV1beta1ListSavedQueriesResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SavedQueries: A list of SavedQueries that match the specified filter in the
	// request.
	SavedQueries []*GoogleCloudAiplatformV1beta1SavedQuery `json:"savedQueries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken