// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package dialogflow provides access to the Dialogflow API.
//
// This package is DEPRECATED. Use package cloud.google.com/go/dialogflow/apiv2 instead.
//
// For product documentation, see: https://cloud.google.com/dialogflow/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/dialogflow/v3beta1"
//	...
//	ctx := context.Background()
//	dialogflowService, err := dialogflow.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithScopes(dialogflow.DialogflowScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	dialogflowService, err := dialogflow.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package dialogflow // import "google.golang.org/api/dialogflow/v3beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "dialogflow:v3beta1"
const apiName = "dialogflow"
const apiVersion = "v3beta1"
const basePath = "https://dialogflow.googleapis.com/"
const basePathTemplate = "https://dialogflow.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://dialogflow.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View, manage and query your Dialogflow agents
	DialogflowScope = "https://www.googleapis.com/auth/dialogflow"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/dialogflow",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.Operations = NewProjectsOperationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	Operations *ProjectsOperationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Agents = NewProjectsLocationsAgentsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.SecuritySettings = NewProjectsLocationsSecuritySettingsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Agents *ProjectsLocationsAgentsService

	Operations *ProjectsLocationsOperationsService

	SecuritySettings *ProjectsLocationsSecuritySettingsService
}

func NewProjectsLocationsAgentsService(s *Service) *ProjectsLocationsAgentsService {
	rs := &ProjectsLocationsAgentsService{s: s}
	rs.Changelogs = NewProjectsLocationsAgentsChangelogsService(s)
	rs.Conversations = NewProjectsLocationsAgentsConversationsService(s)
	rs.EntityTypes = NewProjectsLocationsAgentsEntityTypesService(s)
	rs.Environments = NewProjectsLocationsAgentsEnvironmentsService(s)
	rs.Flows = NewProjectsLocationsAgentsFlowsService(s)
	rs.Generators = NewProjectsLocationsAgentsGeneratorsService(s)
	rs.Intents = NewProjectsLocationsAgentsIntentsService(s)
	rs.Playbooks = NewProjectsLocationsAgentsPlaybooksService(s)
	rs.Sessions = NewProjectsLocationsAgentsSessionsService(s)
	rs.TestCases = NewProjectsLocationsAgentsTestCasesService(s)
	rs.Tools = NewProjectsLocationsAgentsToolsService(s)
	rs.TransitionRouteGroups = NewProjectsLocationsAgentsTransitionRouteGroupsService(s)
	rs.Webhooks = NewProjectsLocationsAgentsWebhooksService(s)
	return rs
}

type ProjectsLocationsAgentsService struct {
	s *Service

	Changelogs *ProjectsLocationsAgentsChangelogsService

	Conversations *ProjectsLocationsAgentsConversationsService

	EntityTypes *ProjectsLocationsAgentsEntityTypesService

	Environments *ProjectsLocationsAgentsEnvironmentsService

	Flows *ProjectsLocationsAgentsFlowsService

	Generators *ProjectsLocationsAgentsGeneratorsService

	Intents *ProjectsLocationsAgentsIntentsService

	Playbooks *ProjectsLocationsAgentsPlaybooksService

	Sessions *ProjectsLocationsAgentsSessionsService

	TestCases *ProjectsLocationsAgentsTestCasesService

	Tools *ProjectsLocationsAgentsToolsService

	TransitionRouteGroups *ProjectsLocationsAgentsTransitionRouteGroupsService

	Webhooks *ProjectsLocationsAgentsWebhooksService
}

func NewProjectsLocationsAgentsChangelogsService(s *Service) *ProjectsLocationsAgentsChangelogsService {
	rs := &ProjectsLocationsAgentsChangelogsService{s: s}
	return rs
}

type ProjectsLocationsAgentsChangelogsService struct {
	s *Service
}

func NewProjectsLocationsAgentsConversationsService(s *Service) *ProjectsLocationsAgentsConversationsService {
	rs := &ProjectsLocationsAgentsConversationsService{s: s}
	return rs
}

type ProjectsLocationsAgentsConversationsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEntityTypesService(s *Service) *ProjectsLocationsAgentsEntityTypesService {
	rs := &ProjectsLocationsAgentsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsService(s *Service) *ProjectsLocationsAgentsEnvironmentsService {
	rs := &ProjectsLocationsAgentsEnvironmentsService{s: s}
	rs.ContinuousTestResults = NewProjectsLocationsAgentsEnvironmentsContinuousTestResultsService(s)
	rs.Deployments = NewProjectsLocationsAgentsEnvironmentsDeploymentsService(s)
	rs.Experiments = NewProjectsLocationsAgentsEnvironmentsExperimentsService(s)
	rs.Sessions = NewProjectsLocationsAgentsEnvironmentsSessionsService(s)
	return rs
}

type ProjectsLocationsAgentsEnvironmentsService struct {
	s *Service

	ContinuousTestResults *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService

	Deployments *ProjectsLocationsAgentsEnvironmentsDeploymentsService

	Experiments *ProjectsLocationsAgentsEnvironmentsExperimentsService

	Sessions *ProjectsLocationsAgentsEnvironmentsSessionsService
}

func NewProjectsLocationsAgentsEnvironmentsContinuousTestResultsService(s *Service) *ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService {
	rs := &ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsContinuousTestResultsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsDeploymentsService(s *Service) *ProjectsLocationsAgentsEnvironmentsDeploymentsService {
	rs := &ProjectsLocationsAgentsEnvironmentsDeploymentsService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsDeploymentsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsExperimentsService(s *Service) *ProjectsLocationsAgentsEnvironmentsExperimentsService {
	rs := &ProjectsLocationsAgentsEnvironmentsExperimentsService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsExperimentsService struct {
	s *Service
}

func NewProjectsLocationsAgentsEnvironmentsSessionsService(s *Service) *ProjectsLocationsAgentsEnvironmentsSessionsService {
	rs := &ProjectsLocationsAgentsEnvironmentsSessionsService{s: s}
	rs.EntityTypes = NewProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService(s)
	return rs
}

type ProjectsLocationsAgentsEnvironmentsSessionsService struct {
	s *Service

	EntityTypes *ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService
}

func NewProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService(s *Service) *ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService {
	rs := &ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentsEnvironmentsSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentsFlowsService(s *Service) *ProjectsLocationsAgentsFlowsService {
	rs := &ProjectsLocationsAgentsFlowsService{s: s}
	rs.Pages = NewProjectsLocationsAgentsFlowsPagesService(s)
	rs.TransitionRouteGroups = NewProjectsLocationsAgentsFlowsTransitionRouteGroupsService(s)
	rs.Versions = NewProjectsLocationsAgentsFlowsVersionsService(s)
	return rs
}

type ProjectsLocationsAgentsFlowsService struct {
	s *Service

	Pages *ProjectsLocationsAgentsFlowsPagesService

	TransitionRouteGroups *ProjectsLocationsAgentsFlowsTransitionRouteGroupsService

	Versions *ProjectsLocationsAgentsFlowsVersionsService
}

func NewProjectsLocationsAgentsFlowsPagesService(s *Service) *ProjectsLocationsAgentsFlowsPagesService {
	rs := &ProjectsLocationsAgentsFlowsPagesService{s: s}
	return rs
}

type ProjectsLocationsAgentsFlowsPagesService struct {
	s *Service
}

func NewProjectsLocationsAgentsFlowsTransitionRouteGroupsService(s *Service) *ProjectsLocationsAgentsFlowsTransitionRouteGroupsService {
	rs := &ProjectsLocationsAgentsFlowsTransitionRouteGroupsService{s: s}
	return rs
}

type ProjectsLocationsAgentsFlowsTransitionRouteGroupsService struct {
	s *Service
}

func NewProjectsLocationsAgentsFlowsVersionsService(s *Service) *ProjectsLocationsAgentsFlowsVersionsService {
	rs := &ProjectsLocationsAgentsFlowsVersionsService{s: s}
	return rs
}

type ProjectsLocationsAgentsFlowsVersionsService struct {
	s *Service
}

func NewProjectsLocationsAgentsGeneratorsService(s *Service) *ProjectsLocationsAgentsGeneratorsService {
	rs := &ProjectsLocationsAgentsGeneratorsService{s: s}
	return rs
}

type ProjectsLocationsAgentsGeneratorsService struct {
	s *Service
}

func NewProjectsLocationsAgentsIntentsService(s *Service) *ProjectsLocationsAgentsIntentsService {
	rs := &ProjectsLocationsAgentsIntentsService{s: s}
	return rs
}

type ProjectsLocationsAgentsIntentsService struct {
	s *Service
}

func NewProjectsLocationsAgentsPlaybooksService(s *Service) *ProjectsLocationsAgentsPlaybooksService {
	rs := &ProjectsLocationsAgentsPlaybooksService{s: s}
	rs.Examples = NewProjectsLocationsAgentsPlaybooksExamplesService(s)
	rs.Versions = NewProjectsLocationsAgentsPlaybooksVersionsService(s)
	return rs
}

type ProjectsLocationsAgentsPlaybooksService struct {
	s *Service

	Examples *ProjectsLocationsAgentsPlaybooksExamplesService

	Versions *ProjectsLocationsAgentsPlaybooksVersionsService
}

func NewProjectsLocationsAgentsPlaybooksExamplesService(s *Service) *ProjectsLocationsAgentsPlaybooksExamplesService {
	rs := &ProjectsLocationsAgentsPlaybooksExamplesService{s: s}
	return rs
}

type ProjectsLocationsAgentsPlaybooksExamplesService struct {
	s *Service
}

func NewProjectsLocationsAgentsPlaybooksVersionsService(s *Service) *ProjectsLocationsAgentsPlaybooksVersionsService {
	rs := &ProjectsLocationsAgentsPlaybooksVersionsService{s: s}
	return rs
}

type ProjectsLocationsAgentsPlaybooksVersionsService struct {
	s *Service
}

func NewProjectsLocationsAgentsSessionsService(s *Service) *ProjectsLocationsAgentsSessionsService {
	rs := &ProjectsLocationsAgentsSessionsService{s: s}
	rs.EntityTypes = NewProjectsLocationsAgentsSessionsEntityTypesService(s)
	return rs
}

type ProjectsLocationsAgentsSessionsService struct {
	s *Service

	EntityTypes *ProjectsLocationsAgentsSessionsEntityTypesService
}

func NewProjectsLocationsAgentsSessionsEntityTypesService(s *Service) *ProjectsLocationsAgentsSessionsEntityTypesService {
	rs := &ProjectsLocationsAgentsSessionsEntityTypesService{s: s}
	return rs
}

type ProjectsLocationsAgentsSessionsEntityTypesService struct {
	s *Service
}

func NewProjectsLocationsAgentsTestCasesService(s *Service) *ProjectsLocationsAgentsTestCasesService {
	rs := &ProjectsLocationsAgentsTestCasesService{s: s}
	rs.Results = NewProjectsLocationsAgentsTestCasesResultsService(s)
	return rs
}

type ProjectsLocationsAgentsTestCasesService struct {
	s *Service

	Results *ProjectsLocationsAgentsTestCasesResultsService
}

func NewProjectsLocationsAgentsTestCasesResultsService(s *Service) *ProjectsLocationsAgentsTestCasesResultsService {
	rs := &ProjectsLocationsAgentsTestCasesResultsService{s: s}
	return rs
}

type ProjectsLocationsAgentsTestCasesResultsService struct {
	s *Service
}

func NewProjectsLocationsAgentsToolsService(s *Service) *ProjectsLocationsAgentsToolsService {
	rs := &ProjectsLocationsAgentsToolsService{s: s}
	rs.Versions = NewProjectsLocationsAgentsToolsVersionsService(s)
	return rs
}

type ProjectsLocationsAgentsToolsService struct {
	s *Service

	Versions *ProjectsLocationsAgentsToolsVersionsService
}

func NewProjectsLocationsAgentsToolsVersionsService(s *Service) *ProjectsLocationsAgentsToolsVersionsService {
	rs := &ProjectsLocationsAgentsToolsVersionsService{s: s}
	return rs
}

type ProjectsLocationsAgentsToolsVersionsService struct {
	s *Service
}

func NewProjectsLocationsAgentsTransitionRouteGroupsService(s *Service) *ProjectsLocationsAgentsTransitionRouteGroupsService {
	rs := &ProjectsLocationsAgentsTransitionRouteGroupsService{s: s}
	return rs
}

type ProjectsLocationsAgentsTransitionRouteGroupsService struct {
	s *Service
}

func NewProjectsLocationsAgentsWebhooksService(s *Service) *ProjectsLocationsAgentsWebhooksService {
	rs := &ProjectsLocationsAgentsWebhooksService{s: s}
	return rs
}

type ProjectsLocationsAgentsWebhooksService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsSecuritySettingsService(s *Service) *ProjectsLocationsSecuritySettingsService {
	rs := &ProjectsLocationsSecuritySettingsService{s: s}
	return rs
}

type ProjectsLocationsSecuritySettingsService struct {
	s *Service
}

func NewProjectsOperationsService(s *Service) *ProjectsOperationsService {
	rs := &ProjectsOperationsService{s: s}
	return rs
}

type ProjectsOperationsService struct {
	s *Service
}

// GoogleCloudDialogflowCxV3AdvancedSettings: Hierarchical advanced settings
// for agent/flow/page/fulfillment/parameter. Settings exposed at lower level
// overrides the settings exposed at higher level. Overriding occurs at the
// sub-setting level. For example, the playback_interruption_settings at
// fulfillment level only overrides the playback_interruption_settings at the
// agent level, leaving other settings at the agent level unchanged. DTMF
// settings does not override each other. DTMF settings set at different levels
// define DTMF detections running in parallel. Hierarchy:
// Agent->Flow->Page->Fulfillment/Parameter.
type GoogleCloudDialogflowCxV3AdvancedSettings struct {
	// AudioExportGcsDestination: If present, incoming audio is exported by
	// Dialogflow to the configured Google Cloud Storage destination. Exposed at
	// the following levels: - Agent level - Flow level
	AudioExportGcsDestination *GoogleCloudDialogflowCxV3GcsDestination `json:"audioExportGcsDestination,omitempty"`
	// DtmfSettings: Settings for DTMF. Exposed at the following levels: - Agent
	// level - Flow level - Page level - Parameter level.
	DtmfSettings *GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings `json:"dtmfSettings,omitempty"`
	// LoggingSettings: Settings for logging. Settings for Dialogflow History,
	// Contact Center messages, StackDriver logs, and speech logging. Exposed at
	// the following levels: - Agent level.
	LoggingSettings *GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings `json:"loggingSettings,omitempty"`
	// SpeechSettings: Settings for speech to text detection. Exposed at the
	// following levels: - Agent level - Flow level - Page level - Parameter level
	SpeechSettings *GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings `json:"speechSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioExportGcsDestination")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings: Define behaviors for
// DTMF (dual tone multi frequency).
type GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings struct {
	// Enabled: If true, incoming audio is processed for DTMF (dual tone multi
	// frequency) events. For example, if the caller presses a button on their
	// telephone keypad and DTMF processing is enabled, Dialogflow will detect the
	// event (e.g. a "3" was pressed) in the incoming audio and pass the event to
	// the bot to drive business logic (e.g. when 3 is pressed, return the account
	// balance).
	Enabled bool `json:"enabled,omitempty"`
	// EndpointingTimeoutDuration: Endpoint timeout setting for matching dtmf input
	// to regex.
	EndpointingTimeoutDuration string `json:"endpointingTimeoutDuration,omitempty"`
	// FinishDigit: The digit that terminates a DTMF digit sequence.
	FinishDigit string `json:"finishDigit,omitempty"`
	// InterdigitTimeoutDuration: Interdigit timeout setting for matching dtmf
	// input to regex.
	InterdigitTimeoutDuration string `json:"interdigitTimeoutDuration,omitempty"`
	// MaxDigits: Max length of DTMF digits.
	MaxDigits int64 `json:"maxDigits,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings: Define behaviors
// on logging.
type GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings struct {
	// EnableConsentBasedRedaction: Enables consent-based end-user input redaction,
	// if true, a pre-defined session parameter
	// `$session.params.conversation-redaction` will be used to determine if the
	// utterance should be redacted.
	EnableConsentBasedRedaction bool `json:"enableConsentBasedRedaction,omitempty"`
	// EnableInteractionLogging: Enables DF Interaction logging.
	EnableInteractionLogging bool `json:"enableInteractionLogging,omitempty"`
	// EnableStackdriverLogging: Enables Google Cloud Logging.
	EnableStackdriverLogging bool `json:"enableStackdriverLogging,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableConsentBasedRedaction") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableConsentBasedRedaction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings: Define behaviors of
// speech to text detection.
type GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings struct {
	// EndpointerSensitivity: Sensitivity of the speech model that detects the end
	// of speech. Scale from 0 to 100.
	EndpointerSensitivity int64 `json:"endpointerSensitivity,omitempty"`
	// Models: Mapping from language to Speech-to-Text model. The mapped
	// Speech-to-Text model will be selected for requests from its corresponding
	// language. For more information, see Speech models
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
	Models map[string]string `json:"models,omitempty"`
	// NoSpeechTimeout: Timeout before detecting no speech.
	NoSpeechTimeout string `json:"noSpeechTimeout,omitempty"`
	// UseTimeoutBasedEndpointing: Use timeout based endpointing, interpreting
	// endpointer sensitivity as seconds of timeout value.
	UseTimeoutBasedEndpointing bool `json:"useTimeoutBasedEndpointing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndpointerSensitivity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndpointerSensitivity") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3AudioInput: Represents the natural speech audio to
// be processed.
type GoogleCloudDialogflowCxV3AudioInput struct {
	// Audio: The natural language speech audio to be processed. A single request
	// can contain up to 2 minutes of speech audio data. The transcribed text
	// cannot contain more than 256 bytes. For non-streaming audio detect intent,
	// both `config` and `audio` must be provided. For streaming audio detect
	// intent, `config` must be provided in the first request and `audio` must be
	// provided in all following requests.
	Audio string `json:"audio,omitempty"`
	// Config: Required. Instructs the speech recognizer how to process the speech
	// audio.
	Config *GoogleCloudDialogflowCxV3InputAudioConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3AudioInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3BargeInConfig: Configuration of the barge-in
// behavior. Barge-in instructs the API to return a detected utterance at a
// proper time while the client is playing back the response audio from a
// previous request. When the client sees the utterance, it should stop the
// playback and immediately get ready for receiving the responses for the
// current request. The barge-in handling requires the client to start
// streaming audio input as soon as it starts playing back the audio from the
// previous response. The playback is modeled into two phases: * No barge-in
// phase: which goes first and during which speech detection should not be
// carried out. * Barge-in phase: which follows the no barge-in phase and
// during which the API starts speech detection and may inform the client that
// an utterance has been detected. Note that no-speech event is not expected in
// this phase. The client provides this configuration in terms of the durations
// of those two phases. The durations are measured in terms of the audio length
// from the start of the input audio. No-speech event is a response with
// END_OF_UTTERANCE without any transcript following up.
type GoogleCloudDialogflowCxV3BargeInConfig struct {
	// NoBargeInDuration: Duration that is not eligible for barge-in at the
	// beginning of the input audio.
	NoBargeInDuration string `json:"noBargeInDuration,omitempty"`
	// TotalDuration: Total duration for the playback at the beginning of the input
	// audio.
	TotalDuration string `json:"totalDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoBargeInDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoBargeInDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BargeInConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BargeInConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata: Metadata returned for
// the TestCases.BatchRunTestCases long running operation.
type GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3BatchRunTestCasesResponse: The response message for
// TestCases.BatchRunTestCases.
type GoogleCloudDialogflowCxV3BatchRunTestCasesResponse struct {
	// Results: The test case results. The detailed conversation turns are empty in
	// this response.
	Results []*GoogleCloudDialogflowCxV3TestCaseResult `json:"results,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3BatchRunTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3BatchRunTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ContinuousTestResult: Represents a result from
// running a test case in an agent environment.
type GoogleCloudDialogflowCxV3ContinuousTestResult struct {
	// Name: The resource name for the continuous test result. Format:
	// `projects//locations//agents//environments//continuousTestResults/`.
	Name string `json:"name,omitempty"`
	// Result: The result of this continuous test run, i.e. whether all the tests
	// in this continuous test run pass or not.
	//
	// Possible values:
	//   "AGGREGATED_TEST_RESULT_UNSPECIFIED" - Not specified. Should never be
	// used.
	//   "PASSED" - All the tests passed.
	//   "FAILED" - At least one test did not pass.
	Result string `json:"result,omitempty"`
	// RunTime: Time when the continuous testing run starts.
	RunTime string `json:"runTime,omitempty"`
	// TestCaseResults: A list of individual test case results names in this
	// continuous test run.
	TestCaseResults []string `json:"testCaseResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ContinuousTestResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ContinuousTestResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ConversationSignals: This message is used to hold
// all the Conversation Signals data, which will be converted to JSON and
// exported to BigQuery.
type GoogleCloudDialogflowCxV3ConversationSignals struct {
	// TurnSignals: Required. Turn signals for the current turn.
	TurnSignals *GoogleCloudDialogflowCxV3TurnSignals `json:"turnSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnSignals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ConversationTurn: One interaction between a human
// and virtual agent. The human provides some input and the virtual agent
// provides a response.
type GoogleCloudDialogflowCxV3ConversationTurn struct {
	// UserInput: The user input.
	UserInput *GoogleCloudDialogflowCxV3ConversationTurnUserInput `json:"userInput,omitempty"`
	// VirtualAgentOutput: The virtual agent output.
	VirtualAgentOutput *GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput `json:"virtualAgentOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserInput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ConversationTurnUserInput: The input from the human
// user.
type GoogleCloudDialogflowCxV3ConversationTurnUserInput struct {
	// EnableSentimentAnalysis: Whether sentiment analysis is enabled.
	EnableSentimentAnalysis bool `json:"enableSentimentAnalysis,omitempty"`
	// InjectedParameters: Parameters that need to be injected into the
	// conversation during intent detection.
	InjectedParameters googleapi.RawMessage `json:"injectedParameters,omitempty"`
	// Input: Supports text input, event input, dtmf input in the test case.
	Input *GoogleCloudDialogflowCxV3QueryInput `json:"input,omitempty"`
	// IsWebhookEnabled: If webhooks should be allowed to trigger in response to
	// the user utterance. Often if parameters are injected, webhooks should not be
	// enabled.
	IsWebhookEnabled bool `json:"isWebhookEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurnUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurnUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput: The output from
// the virtual agent.
type GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput struct {
	// CurrentPage: The Page on which the utterance was spoken. Only name and
	// displayName will be set.
	CurrentPage *GoogleCloudDialogflowCxV3Page `json:"currentPage,omitempty"`
	// DiagnosticInfo: Required. Input only. The diagnostic info output for the
	// turn. Required to calculate the testing coverage.
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`
	// Differences: Output only. If this is part of a result conversation turn, the
	// list of differences between the original run and the replay for this output,
	// if any.
	Differences []*GoogleCloudDialogflowCxV3TestRunDifference `json:"differences,omitempty"`
	// SessionParameters: The session parameters available to the bot at this
	// point.
	SessionParameters googleapi.RawMessage `json:"sessionParameters,omitempty"`
	// Status: Response error from the agent in the test result. If set, other
	// output is empty.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TextResponses: The text responses from the agent for the turn.
	TextResponses []*GoogleCloudDialogflowCxV3ResponseMessageText `json:"textResponses,omitempty"`
	// TriggeredIntent: The Intent that triggered the response. Only name and
	// displayName will be set.
	TriggeredIntent *GoogleCloudDialogflowCxV3Intent `json:"triggeredIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3CreateVersionOperationMetadata: Metadata associated
// with the long running operation for Versions.CreateVersion.
type GoogleCloudDialogflowCxV3CreateVersionOperationMetadata struct {
	// Version: Name of the created version. Format:
	// `projects//locations//agents//flows//versions/`.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3CreateVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3CreateVersionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DataStoreConnection: A data store connection. It
// represents a data store in Discovery Engine and the type of the contents it
// contains.
type GoogleCloudDialogflowCxV3DataStoreConnection struct {
	// DataStore: The full name of the referenced data store. Formats:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}`
	// `projects/{project}/locations/{location}/dataStores/{data_store}`
	DataStore string `json:"dataStore,omitempty"`
	// DataStoreType: The type of the connected data store.
	//
	// Possible values:
	//   "DATA_STORE_TYPE_UNSPECIFIED" - Not specified. This value indicates that
	// the data store type is not specified, so it will not be used during search.
	//   "PUBLIC_WEB" - A data store that contains public web content.
	//   "UNSTRUCTURED" - A data store that contains unstructured private data.
	//   "STRUCTURED" - A data store that contains structured data (for example
	// FAQ).
	DataStoreType string `json:"dataStoreType,omitempty"`
	// DocumentProcessingMode: The document processing mode for the data store
	// connection. Should only be set for PUBLIC_WEB and UNSTRUCTURED data stores.
	// If not set it is considered as DOCUMENTS, as this is the legacy mode.
	//
	// Possible values:
	//   "DOCUMENT_PROCESSING_MODE_UNSPECIFIED" - Not specified. This should be set
	// for STRUCTURED type data stores. Due to legacy reasons this is considered as
	// DOCUMENTS for STRUCTURED and PUBLIC_WEB data stores.
	//   "DOCUMENTS" - Documents are processed as documents.
	//   "CHUNKS" - Documents are converted to chunks.
	DocumentProcessingMode string `json:"documentProcessingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DataStoreConnection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DataStoreConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DeployFlowMetadata: Metadata returned for the
// Environments.DeployFlow long running operation.
type GoogleCloudDialogflowCxV3DeployFlowMetadata struct {
	// TestErrors: Errors of running deployment tests.
	TestErrors []*GoogleCloudDialogflowCxV3TestError `json:"testErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DeployFlowMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeployFlowMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DeployFlowResponse: The response message for
// Environments.DeployFlow.
type GoogleCloudDialogflowCxV3DeployFlowResponse struct {
	// Deployment: The name of the flow version Deployment. Format:
	// `projects//locations//agents//environments//deployments/`.
	Deployment string `json:"deployment,omitempty"`
	// Environment: The updated environment where the flow is deployed.
	Environment *GoogleCloudDialogflowCxV3Environment `json:"environment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DeployFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DeployFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3DtmfInput: Represents the input for dtmf event.
type GoogleCloudDialogflowCxV3DtmfInput struct {
	// Digits: The dtmf digits.
	Digits string `json:"digits,omitempty"`
	// FinishDigit: The finish digit (if any).
	FinishDigit string `json:"finishDigit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3DtmfInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3DtmfInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Environment: Represents an environment for an
// agent. You can create multiple versions of your agent and publish them to
// separate environments. When you edit an agent, you are editing the draft
// agent. At any point, you can save the draft agent as an agent version, which
// is an immutable snapshot of your agent. When you save the draft agent, it is
// published to the default environment. When you create agent versions, you
// can publish them to custom environments. You can create a variety of custom
// environments for testing, development, production, etc.
type GoogleCloudDialogflowCxV3Environment struct {
	// Description: The human-readable description of the environment. The maximum
	// length is 500 characters. If exceeded, the request is rejected.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the environment (unique in
	// an agent). Limit of 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: The name of the environment. Format:
	// `projects//locations//agents//environments/`.
	Name string `json:"name,omitempty"`
	// TestCasesConfig: The test cases config for continuous tests of this
	// environment.
	TestCasesConfig *GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig `json:"testCasesConfig,omitempty"`
	// UpdateTime: Output only. Update time of this environment.
	UpdateTime string `json:"updateTime,omitempty"`
	// VersionConfigs: A list of configurations for flow versions. You should
	// include version configs for all flows that are reachable from `Start Flow`
	// in the agent. Otherwise, an error will be returned.
	VersionConfigs []*GoogleCloudDialogflowCxV3EnvironmentVersionConfig `json:"versionConfigs,omitempty"`
	// WebhookConfig: The webhook configuration for this environment.
	WebhookConfig *GoogleCloudDialogflowCxV3EnvironmentWebhookConfig `json:"webhookConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Environment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig: The configuration for
// continuous tests.
type GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig struct {
	// EnableContinuousRun: Whether to run test cases in TestCasesConfig.test_cases
	// periodically. Default false. If set to true, run once a day.
	EnableContinuousRun bool `json:"enableContinuousRun,omitempty"`
	// EnablePredeploymentRun: Whether to run test cases in
	// TestCasesConfig.test_cases before deploying a flow version to the
	// environment. Default false.
	EnablePredeploymentRun bool `json:"enablePredeploymentRun,omitempty"`
	// TestCases: A list of test case names to run. They should be under the same
	// agent. Format of each test case name:
	// `projects//locations//agents//testCases/`
	TestCases []string `json:"testCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableContinuousRun") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableContinuousRun") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EnvironmentVersionConfig: Configuration for the
// version.
type GoogleCloudDialogflowCxV3EnvironmentVersionConfig struct {
	// Version: Required. Flow, playbook and tool versions are supported. Format
	// for flow version: projects//locations//agents//flows//versions/. Format for
	// playbook version: projects//locations//agents//playbooks//versions/. Format
	// for tool version: projects//locations//agents//tools//versions/.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentVersionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EnvironmentWebhookConfig: Configuration for
// webhooks.
type GoogleCloudDialogflowCxV3EnvironmentWebhookConfig struct {
	// WebhookOverrides: The list of webhooks to override for the agent
	// environment. The webhook must exist in the agent. You can override fields in
	// `generic_web_service` and `service_directory`.
	WebhookOverrides []*GoogleCloudDialogflowCxV3Webhook `json:"webhookOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WebhookOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WebhookOverrides") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EnvironmentWebhookConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EnvironmentWebhookConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EventHandler: An event handler specifies an event
// that can be handled during a session. When the specified event happens, the
// following actions are taken in order: * If there is a `trigger_fulfillment`
// associated with the event, it will be called. * If there is a `target_page`
// associated with the event, the session will transition into the specified
// page. * If there is a `target_flow` associated with the event, the session
// will transition into the specified flow.
type GoogleCloudDialogflowCxV3EventHandler struct {
	// Event: Required. The name of the event to handle.
	Event string `json:"event,omitempty"`
	// Name: Output only. The unique identifier of this event handler.
	Name string `json:"name,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TargetPlaybook: The target playbook to transition to. Format:
	// `projects//locations//agents//playbooks/`.
	TargetPlaybook string `json:"targetPlaybook,omitempty"`
	// TriggerFulfillment: The fulfillment to call when the event occurs. Handling
	// webhook errors with a fulfillment enabled with webhook could cause infinite
	// loop. It is invalid to specify such fulfillment for a handler handling
	// webhooks.
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EventHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3EventInput: Represents the event to trigger.
type GoogleCloudDialogflowCxV3EventInput struct {
	// Event: Name of the event.
	Event string `json:"event,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportAgentResponse: The response message for
// Agents.ExportAgent.
type GoogleCloudDialogflowCxV3ExportAgentResponse struct {
	// AgentContent: Uncompressed raw byte content for agent. This field is
	// populated if none of `agent_uri` and `git_destination` are specified in
	// ExportAgentRequest.
	AgentContent string `json:"agentContent,omitempty"`
	// AgentUri: The URI to a file containing the exported agent. This field is
	// populated if `agent_uri` is specified in ExportAgentRequest.
	AgentUri string `json:"agentUri,omitempty"`
	// CommitSha: Commit SHA of the git push. This field is populated if
	// `git_destination` is specified in ExportAgentRequest.
	CommitSha string `json:"commitSha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportEntityTypesMetadata: Metadata returned for
// the EntityTypes.ExportEntityTypes long running operation.
type GoogleCloudDialogflowCxV3ExportEntityTypesMetadata struct {
}

// GoogleCloudDialogflowCxV3ExportEntityTypesResponse: The response message for
// EntityTypes.ExportEntityTypes.
type GoogleCloudDialogflowCxV3ExportEntityTypesResponse struct {
	// EntityTypesContent: Uncompressed byte content for entity types. This field
	// is populated only if `entity_types_content_inline` is set to true in
	// ExportEntityTypesRequest.
	EntityTypesContent *GoogleCloudDialogflowCxV3InlineDestination `json:"entityTypesContent,omitempty"`
	// EntityTypesUri: The URI to a file containing the exported entity types. This
	// field is populated only if `entity_types_uri` is specified in
	// ExportEntityTypesRequest.
	EntityTypesUri string `json:"entityTypesUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypesContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypesContent") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportFlowResponse: The response message for
// Flows.ExportFlow.
type GoogleCloudDialogflowCxV3ExportFlowResponse struct {
	// FlowContent: Uncompressed raw byte content for flow.
	FlowContent string `json:"flowContent,omitempty"`
	// FlowUri: The URI to a file containing the exported flow. This field is
	// populated only if `flow_uri` is specified in ExportFlowRequest.
	FlowUri string `json:"flowUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportIntentsMetadata: Metadata returned for the
// Intents.ExportIntents long running operation.
type GoogleCloudDialogflowCxV3ExportIntentsMetadata struct {
}

// GoogleCloudDialogflowCxV3ExportIntentsResponse: The response message for
// Intents.ExportIntents.
type GoogleCloudDialogflowCxV3ExportIntentsResponse struct {
	// IntentsContent: Uncompressed byte content for intents. This field is
	// populated only if `intents_content_inline` is set to true in
	// ExportIntentsRequest.
	IntentsContent *GoogleCloudDialogflowCxV3InlineDestination `json:"intentsContent,omitempty"`
	// IntentsUri: The URI to a file containing the exported intents. This field is
	// populated only if `intents_uri` is specified in ExportIntentsRequest.
	IntentsUri string `json:"intentsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentsContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentsContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ExportTestCasesMetadata: Metadata returned for the
// TestCases.ExportTestCases long running operation. This message currently has
// no fields.
type GoogleCloudDialogflowCxV3ExportTestCasesMetadata struct {
}

// GoogleCloudDialogflowCxV3ExportTestCasesResponse: The response message for
// TestCases.ExportTestCases.
type GoogleCloudDialogflowCxV3ExportTestCasesResponse struct {
	// Content: Uncompressed raw byte content for test cases.
	Content string `json:"content,omitempty"`
	// GcsUri: The URI to a file containing the exported test cases. This field is
	// populated only if `gcs_uri` is specified in ExportTestCasesRequest.
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ExportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ExportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Form: A form is a data model that groups related
// parameters that can be collected from the user. The process in which the
// agent prompts the user and collects parameter values from the user is called
// form filling. A form can be added to a page. When form filling is done, the
// filled parameters will be written to the session.
type GoogleCloudDialogflowCxV3Form struct {
	// Parameters: Parameters to collect from the user.
	Parameters []*GoogleCloudDialogflowCxV3FormParameter `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Form) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Form
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FormParameter: Represents a form parameter.
type GoogleCloudDialogflowCxV3FormParameter struct {
	// AdvancedSettings: Hierarchical advanced settings for this parameter. The
	// settings exposed at the lower level overrides the settings exposed at the
	// higher level.
	AdvancedSettings *GoogleCloudDialogflowCxV3AdvancedSettings `json:"advancedSettings,omitempty"`
	// DefaultValue: The default value of an optional parameter. If the parameter
	// is required, the default value will be ignored.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// DisplayName: Required. The human-readable name of the parameter, unique
	// within the form.
	DisplayName string `json:"displayName,omitempty"`
	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for
	// example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity types.
	EntityType string `json:"entityType,omitempty"`
	// FillBehavior: Required. Defines fill behavior for the parameter.
	FillBehavior *GoogleCloudDialogflowCxV3FormParameterFillBehavior `json:"fillBehavior,omitempty"`
	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`
	// Redact: Indicates whether the parameter content should be redacted in log.
	// If redaction is enabled, the parameter content will be replaced by parameter
	// name during logging. Note: the parameter content is subject to redaction if
	// either parameter level redaction or entity type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`
	// Required: Indicates whether the parameter is required. Optional parameters
	// will not trigger prompts; however, they are filled if the user specifies
	// them. Required parameters must be filled before form filling concludes.
	Required bool `json:"required,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FormParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FormParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FormParameterFillBehavior: Configuration for how
// the filling of a parameter should be handled.
type GoogleCloudDialogflowCxV3FormParameterFillBehavior struct {
	// InitialPromptFulfillment: Required. The fulfillment to provide the initial
	// prompt that the agent can present to the user in order to fill the
	// parameter.
	InitialPromptFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"initialPromptFulfillment,omitempty"`
	// RepromptEventHandlers: The handlers for parameter-level events, used to
	// provide reprompt for the parameter or transition to a different page/flow.
	// The supported events are: * `sys.no-match-`, where N can be from 1 to 6 *
	// `sys.no-match-default` * `sys.no-input-`, where N can be from 1 to 6 *
	// `sys.no-input-default` * `sys.invalid-parameter`
	// `initial_prompt_fulfillment` provides the first prompt for the parameter. If
	// the user's response does not fill the parameter, a no-match/no-input event
	// will be triggered, and the fulfillment associated with the
	// `sys.no-match-1`/`sys.no-input-1` handler (if defined) will be called to
	// provide a prompt. The `sys.no-match-2`/`sys.no-input-2` handler (if defined)
	// will respond to the next no-match/no-input event, and so on. A
	// `sys.no-match-default` or `sys.no-input-default` handler will be used to
	// handle all following no-match/no-input events after all numbered
	// no-match/no-input handlers for the parameter are consumed. A
	// `sys.invalid-parameter` handler can be defined to handle the case where the
	// parameter values have been `invalidated` by webhook. For example, if the
	// user's response fill the parameter, however the parameter was invalidated by
	// webhook, the fulfillment associated with the `sys.invalid-parameter` handler
	// (if defined) will be called to provide a prompt. If the event handler for
	// the corresponding event can't be found on the parameter,
	// `initial_prompt_fulfillment` will be re-prompted.
	RepromptEventHandlers []*GoogleCloudDialogflowCxV3EventHandler `json:"repromptEventHandlers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InitialPromptFulfillment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InitialPromptFulfillment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FormParameterFillBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FormParameterFillBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Fulfillment: A fulfillment can do one or more of
// the following actions at the same time: * Generate rich message responses. *
// Set parameter values. * Call the webhook. Fulfillments can be called at
// various stages in the Page or Form lifecycle. For example, when a
// DetectIntentRequest drives a session to enter a new page, the page's entry
// fulfillment can add a static response to the QueryResult in the returning
// DetectIntentResponse, call the webhook (for example, to load user data from
// a database), or both.
type GoogleCloudDialogflowCxV3Fulfillment struct {
	// AdvancedSettings: Hierarchical advanced settings for this fulfillment. The
	// settings exposed at the lower level overrides the settings exposed at the
	// higher level.
	AdvancedSettings *GoogleCloudDialogflowCxV3AdvancedSettings `json:"advancedSettings,omitempty"`
	// ConditionalCases: Conditional cases for this fulfillment.
	ConditionalCases []*GoogleCloudDialogflowCxV3FulfillmentConditionalCases `json:"conditionalCases,omitempty"`
	// EnableGenerativeFallback: If the flag is true, the agent will utilize LLM to
	// generate a text response. If LLM generation fails, the defined responses in
	// the fulfillment will be respected. This flag is only useful for fulfillments
	// associated with no-match event handlers.
	EnableGenerativeFallback bool `json:"enableGenerativeFallback,omitempty"`
	// Generators: A list of Generators to be called during this fulfillment.
	Generators []*GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings `json:"generators,omitempty"`
	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3ResponseMessage `json:"messages,omitempty"`
	// ReturnPartialResponses: Whether Dialogflow should return currently queued
	// fulfillment response messages in streaming APIs. If a webhook is specified,
	// it happens before Dialogflow invokes webhook. Warning: 1) This flag only
	// affects streaming API. Responses are still queued and returned once in
	// non-streaming API. 2) The flag can be enabled in any fulfillment but only
	// the first 3 partial responses will be returned. You may only want to apply
	// it to fulfillments that have slow webhooks.
	ReturnPartialResponses bool `json:"returnPartialResponses,omitempty"`
	// SetParameterActions: Set parameter values before executing the webhook.
	SetParameterActions []*GoogleCloudDialogflowCxV3FulfillmentSetParameterAction `json:"setParameterActions,omitempty"`
	// Tag: The value of this field will be populated in the WebhookRequest
	// `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
	// called. The tag is typically used by the webhook service to identify which
	// fulfillment is being called, but it could be used for other purposes. This
	// field is required if `webhook` is specified.
	Tag string `json:"tag,omitempty"`
	// Webhook: The webhook to call. Format:
	// `projects//locations//agents//webhooks/`.
	Webhook string `json:"webhook,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Fulfillment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentConditionalCases: A list of cascading
// if-else conditions. Cases are mutually exclusive. The first one with a
// matching condition is selected, all the rest ignored.
type GoogleCloudDialogflowCxV3FulfillmentConditionalCases struct {
	// Cases: A list of cascading if-else conditions.
	Cases []*GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase `json:"cases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cases") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCases) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCases
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase: Each case has a
// Boolean condition. When it is evaluated to be True, the corresponding
// messages will be selected and evaluated recursively.
type GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase struct {
	// CaseContent: A list of case content.
	CaseContent []*GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent `json:"caseContent,omitempty"`
	// Condition: The condition to activate and select this case. Empty means the
	// condition is always true. The condition is evaluated against form parameters
	// or session parameters. See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent: The
// list of messages or conditional cases to activate for this case.
type GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent struct {
	// AdditionalCases: Additional cases to be evaluated.
	AdditionalCases *GoogleCloudDialogflowCxV3FulfillmentConditionalCases `json:"additionalCases,omitempty"`
	// Message: Returned message.
	Message *GoogleCloudDialogflowCxV3ResponseMessage `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalCases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalCases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings: Generator settings
// used by the LLM to generate a text response.
type GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings struct {
	// Generator: Required. The generator to call. Format:
	// `projects//locations//agents//generators/`.
	Generator string `json:"generator,omitempty"`
	// InputParameters: Map from placeholder parameter in the Generator to
	// corresponding session parameters. By default, Dialogflow uses the session
	// parameter with the same name to fill in the generator template. e.g. If
	// there is a placeholder parameter `city` in the Generator, Dialogflow default
	// to fill in the `$city` with `$session.params.city`. However, you may choose
	// to fill `$city` with `$session.params.desination-city`. - Map key: parameter
	// ID - Map value: session parameter name
	InputParameters map[string]string `json:"inputParameters,omitempty"`
	// OutputParameter: Required. Output parameter which should contain the
	// generator response.
	OutputParameter string `json:"outputParameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Generator") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Generator") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3FulfillmentSetParameterAction: Setting a parameter
// value.
type GoogleCloudDialogflowCxV3FulfillmentSetParameterAction struct {
	// Parameter: Display name of the parameter.
	Parameter string `json:"parameter,omitempty"`
	// Value: The new value of the parameter. A null value clears the parameter.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3FulfillmentSetParameterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3FulfillmentSetParameterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3GcsDestination: Google Cloud Storage location for a
// Dialogflow operation that writes or exports objects (e.g. exported agent or
// transcripts) outside of Dialogflow.
type GoogleCloudDialogflowCxV3GcsDestination struct {
	// Uri: Required. The Google Cloud Storage URI for the exported objects. A URI
	// is of the form: `gs://bucket/object-name-or-prefix` Whether a full object
	// name, or just a prefix, its usage depends on the Dialogflow operation.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportEntityTypesMetadata: Metadata returned for
// the EntityTypes.ImportEntityTypes long running operation.
type GoogleCloudDialogflowCxV3ImportEntityTypesMetadata struct {
}

// GoogleCloudDialogflowCxV3ImportEntityTypesResponse: The response message for
// EntityTypes.ImportEntityTypes.
type GoogleCloudDialogflowCxV3ImportEntityTypesResponse struct {
	// ConflictingResources: Info which resources have conflicts when
	// REPORT_CONFLICT merge_option is set in ImportEntityTypesRequest.
	ConflictingResources *GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources `json:"conflictingResources,omitempty"`
	// EntityTypes: The unique identifier of the imported entity types. Format:
	// `projects//locations//agents//entity_types/`.
	EntityTypes []string `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources:
// Conflicting resources detected during the import process. Only filled when
// REPORT_CONFLICT is set in the request and there are conflicts in the display
// names.
type GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources struct {
	// EntityDisplayNames: Display names of conflicting entities.
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	// EntityTypeDisplayNames: Display names of conflicting entity types.
	EntityTypeDisplayNames []string `json:"entityTypeDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportFlowResponse: The response message for
// Flows.ImportFlow.
type GoogleCloudDialogflowCxV3ImportFlowResponse struct {
	// Flow: The unique identifier of the new flow. Format:
	// `projects//locations//agents//flows/`.
	Flow string `json:"flow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportIntentsMetadata: Metadata returned for the
// Intents.ImportIntents long running operation.
type GoogleCloudDialogflowCxV3ImportIntentsMetadata struct {
}

// GoogleCloudDialogflowCxV3ImportIntentsResponse: The response message for
// Intents.ImportIntents.
type GoogleCloudDialogflowCxV3ImportIntentsResponse struct {
	// ConflictingResources: Info which resources have conflicts when
	// REPORT_CONFLICT merge_option is set in ImportIntentsRequest.
	ConflictingResources *GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources `json:"conflictingResources,omitempty"`
	// Intents: The unique identifier of the imported intents. Format:
	// `projects//locations//agents//intents/`.
	Intents []string `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources:
// Conflicting resources detected during the import process. Only filled when
// REPORT_CONFLICT is set in the request and there are conflicts in the display
// names.
type GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources struct {
	// EntityDisplayNames: Display names of conflicting entities.
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	// IntentDisplayNames: Display names of conflicting intents.
	IntentDisplayNames []string `json:"intentDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportTestCasesMetadata: Metadata returned for the
// TestCases.ImportTestCases long running operation.
type GoogleCloudDialogflowCxV3ImportTestCasesMetadata struct {
	// Errors: Errors for failed test cases.
	Errors []*GoogleCloudDialogflowCxV3TestCaseError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ImportTestCasesResponse: The response message for
// TestCases.ImportTestCases.
type GoogleCloudDialogflowCxV3ImportTestCasesResponse struct {
	// Names: The unique identifiers of the new test cases. Format:
	// `projects//locations//agents//testCases/`.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ImportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ImportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3InlineDestination: Inline destination for a
// Dialogflow operation that writes or exports objects (e.g. intents) outside
// of Dialogflow.
type GoogleCloudDialogflowCxV3InlineDestination struct {
	// Content: Output only. The uncompressed byte content for the objects. Only
	// populated in responses.
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3InlineDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3InlineDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3InputAudioConfig: Instructs the speech recognizer
// on how to process the audio content.
type GoogleCloudDialogflowCxV3InputAudioConfig struct {
	// AudioEncoding: Required. Audio encoding of the audio content to process.
	//
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED" - Not specified.
	//   "AUDIO_ENCODING_LINEAR_16" - Uncompressed 16-bit signed little-endian
	// samples (Linear PCM).
	//   "AUDIO_ENCODING_FLAC" - [`FLAC`](https://xiph.org/flac/documentation.html)
	// (Free Lossless Audio Codec) is the recommended encoding because it is
	// lossless (therefore recognition is not compromised) and requires only about
	// half the bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
	// 24-bit samples, however, not all fields in `STREAMINFO` are supported.
	//   "AUDIO_ENCODING_MULAW" - 8-bit samples that compand 14-bit audio samples
	// using G.711 PCMU/mu-law.
	//   "AUDIO_ENCODING_AMR" - Adaptive Multi-Rate Narrowband codec.
	// `sample_rate_hertz` must be 8000.
	//   "AUDIO_ENCODING_AMR_WB" - Adaptive Multi-Rate Wideband codec.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_OGG_OPUS" - Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)). `sample_rate_hertz` must be
	// 16000.
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE" - Although the use of lossy
	// encodings is not recommended, if a very low bitrate encoding is required,
	// `OGG_OPUS` is highly preferred over Speex encoding. The
	// [Speex](https://speex.org/) encoding supported by Dialogflow API has a
	// header byte in each block, as in MIME type `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in [RFC
	// 5574](https://tools.ietf.org/html/rfc5574). The stream is a sequence of
	// blocks, one block per RTP packet. Each block starts with a byte containing
	// the length of the block, in bytes, followed by one or more frames of Speex
	// data, padded to an integral number of bytes (octets) as specified in RFC
	// 5574. In other words, each RTP header is replaced with a single byte
	// containing the block length. Only Speex wideband is supported.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_ALAW" - 8-bit samples that compand 13-bit audio samples
	// using G.711 PCMU/a-law.
	AudioEncoding string `json:"audioEncoding,omitempty"`
	// BargeInConfig: Configuration of barge-in behavior during the streaming of
	// input audio.
	BargeInConfig *GoogleCloudDialogflowCxV3BargeInConfig `json:"bargeInConfig,omitempty"`
	// EnableWordInfo: Optional. If `true`, Dialogflow returns SpeechWordInfo in
	// StreamingRecognitionResult with information about the recognized speech
	// words, e.g. start and end time offsets. If false or unspecified, Speech
	// doesn't return any word-level information.
	EnableWordInfo bool `json:"enableWordInfo,omitempty"`
	// Model: Optional. Which Speech model to select for the given request. For
	// more information, see Speech models
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
	Model string `json:"model,omitempty"`
	// ModelVariant: Optional. Which variant of the Speech model to use.
	//
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED" - No model variant specified. In this
	// case Dialogflow defaults to USE_BEST_AVAILABLE.
	//   "USE_BEST_AVAILABLE" - Use the best available variant of the Speech model
	// that the caller is eligible for.
	//   "USE_STANDARD" - Use standard model variant even if an enhanced model is
	// available. See the [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// for details about enhanced models.
	//   "USE_ENHANCED" - Use an enhanced model variant: * If an enhanced variant
	// does not exist for the given model and request language, Dialogflow falls
	// back to the standard variant. The [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// describes which models have enhanced variants.
	ModelVariant string `json:"modelVariant,omitempty"`
	// OptOutConformerModelMigration: If `true`, the request will opt out for STT
	// conformer model migration. This field will be deprecated once force
	// migration takes place in June 2024. Please refer to Dialogflow CX Speech
	// model migration
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-model-migration).
	OptOutConformerModelMigration bool `json:"optOutConformerModelMigration,omitempty"`
	// PhraseHints: Optional. A list of strings containing words and phrases that
	// the speech recognizer should recognize with higher likelihood. See the Cloud
	// Speech documentation
	// (https://cloud.google.com/speech-to-text/docs/basics#phrase-hints) for more
	// details.
	PhraseHints []string `json:"phraseHints,omitempty"`
	// SampleRateHertz: Sample rate (in Hertz) of the audio content sent in the
	// query. Refer to Cloud Speech API documentation
	// (https://cloud.google.com/speech-to-text/docs/basics) for more details.
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`
	// SingleUtterance: Optional. If `false` (default), recognition does not cease
	// until the client closes the stream. If `true`, the recognizer will detect a
	// single spoken utterance in input audio. Recognition ceases when it detects
	// the audio's voice has stopped or paused. In this case, once a detected
	// intent is received, the client should close the stream and start a new
	// request with a new stream as needed. Note: This setting is relevant only for
	// streaming methods.
	SingleUtterance bool `json:"singleUtterance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3InputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3Intent: An intent represents a user's intent to
// interact with a conversational agent. You can provide information for the
// Dialogflow API to use to match user input to an intent by adding training
// phrases (i.e., examples of user input) to your intent.
type GoogleCloudDialogflowCxV3Intent struct {
	// Description: Human readable description for better understanding an intent
	// like its scope, content, result etc. Maximum character limit: 140
	// characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the intent, unique within
	// the agent.
	DisplayName string `json:"displayName,omitempty"`
	// IsFallback: Indicates whether this is a fallback intent. Currently only
	// default fallback intent is allowed in the agent, which is added upon agent
	// creation. Adding training phrases to fallback intent is useful in the case
	// of requests that are mistakenly matched, since training phrases assigned to
	// fallback intents act as negative examples that triggers no-match event.
	IsFallback bool `json:"isFallback,omitempty"`
	// Labels: The key/value metadata to label an intent. Labels can contain
	// lowercase letters, digits and the symbols '-' and '_'. International
	// characters are allowed, including letters from unicase alphabets. Keys must
	// start with a letter. Keys and values can be no longer than 63 characters and
	// no more than 128 bytes. Prefix "sys-" is reserved for Dialogflow defined
	// labels. Currently allowed Dialogflow defined labels include: * sys-head *
	// sys-contextual The above labels do not require value. "sys-head" means the
	// intent is a head intent. "sys.contextual" means the intent is a contextual
	// intent.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: The unique identifier of the intent. Required for the
	// Intents.UpdateIntent method. Intents.CreateIntent populates the name
	// automatically. Format: `projects//locations//agents//intents/`.
	Name string `json:"name,omitempty"`
	// Parameters: The collection of parameters associated with the intent.
	Parameters []*GoogleCloudDialogflowCxV3IntentParameter `json:"parameters,omitempty"`
	// Priority: The priority of this intent. Higher numbers represent higher
	// priorities. - If the supplied value is unspecified or 0, the service
	// translates the value to 500,000, which corresponds to the `Normal` priority
	// in the console. - If the supplied value is negative, the intent is ignored
	// in runtime detect intent requests.
	Priority int64 `json:"priority,omitempty"`
	// TrainingPhrases: The collection of training phrases the agent is trained on
	// to identify the intent.
	TrainingPhrases []*GoogleCloudDialogflowCxV3IntentTrainingPhrase `json:"trainingPhrases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentInput: Represents the intent to trigger
// programmatically rather than as a result of natural language processing.
type GoogleCloudDialogflowCxV3IntentInput struct {
	// Intent: Required. The unique identifier of the intent. Format:
	// `projects//locations//agents//intents/`.
	Intent string `json:"intent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentParameter: Represents an intent parameter.
type GoogleCloudDialogflowCxV3IntentParameter struct {
	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for
	// example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity types.
	EntityType string `json:"entityType,omitempty"`
	// Id: Required. The unique identifier of the parameter. This field is used by
	// training phrases to annotate their parts.
	Id string `json:"id,omitempty"`
	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`
	// Redact: Indicates whether the parameter content should be redacted in log.
	// If redaction is enabled, the parameter content will be replaced by parameter
	// name during logging. Note: the parameter content is subject to redaction if
	// either parameter level redaction or entity type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentTrainingPhrase: Represents an example that
// the agent is trained on to identify the intent.
type GoogleCloudDialogflowCxV3IntentTrainingPhrase struct {
	// Id: Output only. The unique identifier of the training phrase.
	Id string `json:"id,omitempty"`
	// Parts: Required. The ordered list of training phrase parts. The parts are
	// concatenated in order to form the training phrase. Note: The API does not
	// automatically annotate training phrases like the Dialogflow Console does.
	// Note: Do not forget to include whitespace at part boundaries, so the
	// training phrase is well formatted when the parts are concatenated. If the
	// training phrase does not need to be annotated with parameters, you just need
	// a single part with only the Part.text field set. If you want to annotate the
	// training phrase, you must create multiple parts, where the fields of each
	// part are populated in one of two ways: - `Part.text` is set to a part of the
	// phrase that has no parameters. - `Part.text` is set to a part of the phrase
	// that you want to annotate, and the `parameter_id` field is set.
	Parts []*GoogleCloudDialogflowCxV3IntentTrainingPhrasePart `json:"parts,omitempty"`
	// RepeatCount: Indicates how many times this example was added to the intent.
	RepeatCount int64 `json:"repeatCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3IntentTrainingPhrasePart: Represents a part of a
// training phrase.
type GoogleCloudDialogflowCxV3IntentTrainingPhrasePart struct {
	// ParameterId: The parameter used to annotate this part of the training
	// phrase. This field is required for annotated parts of the training phrase.
	ParameterId string `json:"parameterId,omitempty"`
	// Text: Required. The text for this part.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3KnowledgeConnectorSettings: The Knowledge Connector
// settings for this page or flow. This includes information such as the
// attached Knowledge Bases, and the way to execute fulfillment.
type GoogleCloudDialogflowCxV3KnowledgeConnectorSettings struct {
	// DataStoreConnections: Optional. List of related data store connections.
	DataStoreConnections []*GoogleCloudDialogflowCxV3DataStoreConnection `json:"dataStoreConnections,omitempty"`
	// Enabled: Whether Knowledge Connector is enabled or not.
	Enabled bool `json:"enabled,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TriggerFulfillment: The fulfillment to be triggered. When the answers from
	// the Knowledge Connector are selected by Dialogflow, you can utitlize the
	// request scoped parameter `$request.knowledge.answers` (contains up to the 5
	// highest confidence answers) and `$request.knowledge.questions` (contains the
	// corresponding questions) to construct the fulfillment.
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3KnowledgeConnectorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3KnowledgeConnectorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3LanguageInfo: Represents the language information
// of the request.
type GoogleCloudDialogflowCxV3LanguageInfo struct {
	// ConfidenceScore: The confidence score of the detected language between 0 and
	// 1.
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// InputLanguageCode: The language code specified in the original request.
	InputLanguageCode string `json:"inputLanguageCode,omitempty"`
	// ResolvedLanguageCode: The language code detected for this request based on
	// the user conversation.
	ResolvedLanguageCode string `json:"resolvedLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3LanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3LanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3LanguageInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3LanguageInfo
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudDialogflowCxV3Page: A Dialogflow CX conversation (session) can be
// described and visualized as a state machine. The states of a CX session are
// represented by pages. For each flow, you define many pages, where your
// combined pages can handle a complete conversation on the topics the flow is
// designed for. At any given moment, exactly one page is the current page, the
// current page is considered active, and the flow associated with that page is
// considered active. Every flow has a special start page. When a flow
// initially becomes active, the start page page becomes the current page. For
// each conversational turn, the current page will either stay the same or
// transition to another page. You configure each page to collect information
// from the end-user that is relevant for the conversational state represented
// by the page. For more information, see the Page guide
// (https://cloud.google.com/dialogflow/cx/docs/concept/page).
type GoogleCloudDialogflowCxV3Page struct {
	// AdvancedSettings: Hierarchical advanced settings for this page. The settings
	// exposed at the lower level overrides the settings exposed at the higher
	// level.
	AdvancedSettings *GoogleCloudDialogflowCxV3AdvancedSettings `json:"advancedSettings,omitempty"`
	// Description: The description of the page. The maximum length is 500
	// characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the page, unique within
	// the flow.
	DisplayName string `json:"displayName,omitempty"`
	// EntryFulfillment: The fulfillment to call when the session is entering the
	// page.
	EntryFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"entryFulfillment,omitempty"`
	// EventHandlers: Handlers associated with the page to handle events such as
	// webhook errors, no match or no input.
	EventHandlers []*GoogleCloudDialogflowCxV3EventHandler `json:"eventHandlers,omitempty"`
	// Form: The form associated with the page, used for collecting parameters
	// relevant to the page.
	Form *GoogleCloudDialogflowCxV3Form `json:"form,omitempty"`
	// KnowledgeConnectorSettings: Optional. Knowledge connector configuration.
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3KnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	// Name: The unique identifier of the page. Required for the Pages.UpdatePage
	// method. Pages.CreatePage populates the name automatically. Format:
	// `projects//locations//agents//flows//pages/`.
	Name string `json:"name,omitempty"`
	// TransitionRouteGroups: Ordered list of `TransitionRouteGroups` added to the
	// page. Transition route groups must be unique within a page. If the page
	// links both flow-level transition route groups and agent-level transition
	// route groups, the flow-level ones will have higher priority and will be put
	// before the agent-level ones. * If multiple transition routes within a page
	// scope refer to the same intent, then the precedence order is: page's
	// transition route -> page's transition route group -> flow's transition
	// routes. * If multiple transition route groups within a page contain the same
	// intent, then the first group in the ordered list takes precedence.
	// Format:`projects//locations//agents//flows//transitionRouteGroups/` or
	// `projects//locations//agents//transitionRouteGroups/` for agent-level
	// groups.
	TransitionRouteGroups []string `json:"transitionRouteGroups,omitempty"`
	// TransitionRoutes: A list of transitions for the transition rules of this
	// page. They route the conversation to another page in the same flow, or
	// another flow. When we are in a certain page, the TransitionRoutes are
	// evaluated in the following order: * TransitionRoutes defined in the page
	// with intent specified. * TransitionRoutes defined in the transition route
	// groups with intent specified. * TransitionRoutes defined in flow with intent
	// specified. * TransitionRoutes defined in the transition route groups with
	// intent specified. * TransitionRoutes defined in the page with only condition
	// specified. * TransitionRoutes defined in the transition route groups with
	// only condition specified.
	TransitionRoutes []*GoogleCloudDialogflowCxV3TransitionRoute `json:"transitionRoutes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Page) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Page
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3PageInfo: Represents page information communicated
// to and from the webhook.
type GoogleCloudDialogflowCxV3PageInfo struct {
	// CurrentPage: Always present for WebhookRequest. Ignored for WebhookResponse.
	// The unique identifier of the current page. Format:
	// `projects//locations//agents//flows//pages/`.
	CurrentPage string `json:"currentPage,omitempty"`
	// DisplayName: Always present for WebhookRequest. Ignored for WebhookResponse.
	// The display name of the current page.
	DisplayName string `json:"displayName,omitempty"`
	// FormInfo: Optional for both WebhookRequest and WebhookResponse. Information
	// about the form.
	FormInfo *GoogleCloudDialogflowCxV3PageInfoFormInfo `json:"formInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3PageInfoFormInfo: Represents form information.
type GoogleCloudDialogflowCxV3PageInfoFormInfo struct {
	// ParameterInfo: Optional for both WebhookRequest and WebhookResponse. The
	// parameters contained in the form. Note that the webhook cannot add or remove
	// any form parameter.
	ParameterInfo []*GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo `json:"parameterInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfoFormInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfoFormInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo: Represents parameter
// information.
type GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo struct {
	// DisplayName: Always present for WebhookRequest. Required for
	// WebhookResponse. The human-readable name of the parameter, unique within the
	// form. This field cannot be modified by the webhook.
	DisplayName string `json:"displayName,omitempty"`
	// JustCollected: Optional for WebhookRequest. Ignored for WebhookResponse.
	// Indicates if the parameter value was just collected on the last conversation
	// turn.
	JustCollected bool `json:"justCollected,omitempty"`
	// Required: Optional for both WebhookRequest and WebhookResponse. Indicates
	// whether the parameter is required. Optional parameters will not trigger
	// prompts; however, they are filled if the user specifies them. Required
	// parameters must be filled before form filling concludes.
	Required bool `json:"required,omitempty"`
	// State: Always present for WebhookRequest. Required for WebhookResponse. The
	// state of the parameter. This field can be set to INVALID by the webhook to
	// invalidate the parameter; other values set by the webhook will be ignored.
	//
	// Possible values:
	//   "PARAMETER_STATE_UNSPECIFIED" - Not specified. This value should be never
	// used.
	//   "EMPTY" - Indicates that the parameter does not have a value.
	//   "INVALID" - Indicates that the parameter value is invalid. This field can
	// be used by the webhook to invalidate the parameter and ask the server to
	// collect it from the user again.
	//   "FILLED" - Indicates that the parameter has a value.
	State string `json:"state,omitempty"`
	// Value: Optional for both WebhookRequest and WebhookResponse. The value of
	// the parameter. This field can be set by the webhook to change the parameter
	// value.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3QueryInput: Represents the query input. It can
// contain one of: 1. A conversational query in the form of text. 2. An intent
// query that specifies which intent to trigger. 3. Natural language speech
// audio to be processed. 4. An event to be triggered. 5. DTMF digits to invoke
// an intent and fill in parameter value. 6. The results of a tool executed by
// the client.
type GoogleCloudDialogflowCxV3QueryInput struct {
	// Audio: The natural language speech audio to be processed.
	Audio *GoogleCloudDialogflowCxV3AudioInput `json:"audio,omitempty"`
	// Dtmf: The DTMF event to be handled.
	Dtmf *GoogleCloudDialogflowCxV3DtmfInput `json:"dtmf,omitempty"`
	// Event: The event to be triggered.
	Event *GoogleCloudDialogflowCxV3EventInput `json:"event,omitempty"`
	// Intent: The intent to be triggered.
	Intent *GoogleCloudDialogflowCxV3IntentInput `json:"intent,omitempty"`
	// LanguageCode: Required. The language of the input. See Language Support
	// (https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list
	// of the currently supported language codes. Note that queries in the same
	// session do not necessarily need to specify the same language.
	LanguageCode string `json:"languageCode,omitempty"`
	// Text: The natural language text to be processed.
	Text *GoogleCloudDialogflowCxV3TextInput `json:"text,omitempty"`
	// ToolCallResult: The results of a tool executed by the client.
	ToolCallResult *GoogleCloudDialogflowCxV3ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3QueryInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3QueryInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessage: Represents a response message that
// can be returned by a conversational agent. Response messages are also used
// for output audio synthesis. The approach is as follows: * If at least one
// OutputAudioText response is present, then all OutputAudioText responses are
// linearly concatenated, and the result is used for output audio synthesis. *
// If the OutputAudioText responses are a mixture of text and SSML, then the
// concatenated result is treated as SSML; otherwise, the result is treated as
// either text or SSML as appropriate. The agent designer should ideally use
// either text or SSML consistently throughout the bot design. * Otherwise, all
// Text responses are linearly concatenated, and the result is used for output
// audio synthesis. This approach allows for more sophisticated user experience
// scenarios, where the text displayed to the user may differ from what is
// heard.
type GoogleCloudDialogflowCxV3ResponseMessage struct {
	// Channel: The channel which the response is associated with. Clients can
	// specify the channel via QueryParameters.channel, and only associated channel
	// response will be returned.
	Channel string `json:"channel,omitempty"`
	// ConversationSuccess: Indicates that the conversation succeeded.
	ConversationSuccess *GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess `json:"conversationSuccess,omitempty"`
	// EndInteraction: Output only. A signal that indicates the interaction with
	// the Dialogflow agent has ended. This message is generated by Dialogflow only
	// when the conversation reaches `END_SESSION` page. It is not supposed to be
	// defined by the user. It's guaranteed that there is at most one such message
	// in each response.
	EndInteraction *GoogleCloudDialogflowCxV3ResponseMessageEndInteraction `json:"endInteraction,omitempty"`
	// KnowledgeInfoCard: Represents info card for knowledge answers, to be better
	// rendered in Dialogflow Messenger.
	KnowledgeInfoCard *GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard `json:"knowledgeInfoCard,omitempty"`
	// LiveAgentHandoff: Hands off conversation to a human agent.
	LiveAgentHandoff *GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff `json:"liveAgentHandoff,omitempty"`
	// MixedAudio: Output only. An audio response message composed of both the
	// synthesized Dialogflow agent responses and responses defined via play_audio.
	// This message is generated by Dialogflow only and not supposed to be defined
	// by the user.
	MixedAudio *GoogleCloudDialogflowCxV3ResponseMessageMixedAudio `json:"mixedAudio,omitempty"`
	// OutputAudioText: A text or ssml response that is preferentially used for TTS
	// output audio synthesis, as described in the comment on the ResponseMessage
	// message.
	OutputAudioText *GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText `json:"outputAudioText,omitempty"`
	// Payload: Returns a response containing a custom, platform-specific payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// PlayAudio: Signal that the client should play an audio clip hosted at a
	// client-specific URI. Dialogflow uses this to construct mixed_audio. However,
	// Dialogflow itself does not try to read or process the URI in any way.
	PlayAudio *GoogleCloudDialogflowCxV3ResponseMessagePlayAudio `json:"playAudio,omitempty"`
	// ResponseType: Response type.
	//
	// Possible values:
	//   "RESPONSE_TYPE_UNSPECIFIED" - Not specified.
	//   "ENTRY_PROMPT" - The response is from an entry prompt in the page.
	//   "PARAMETER_PROMPT" - The response is from form-filling prompt in the page.
	//   "HANDLER_PROMPT" - The response is from a transition route or an event
	// handler in the page or flow or transition route group.
	ResponseType string `json:"responseType,omitempty"`
	// TelephonyTransferCall: A signal that the client should transfer the phone
	// call connected to this agent to a third-party endpoint.
	TelephonyTransferCall *GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`
	// Text: Returns a text response.
	Text *GoogleCloudDialogflowCxV3ResponseMessageText `json:"text,omitempty"`
	// ToolCall: Returns the definition of a tool call that should be executed by
	// the client.
	ToolCall *GoogleCloudDialogflowCxV3ToolCall `json:"toolCall,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess: Indicates that
// the conversation succeeded, i.e., the bot handled the issue that the
// customer talked to it about. Dialogflow only uses this to determine which
// conversations should be counted as successful and doesn't process the
// metadata in this message in any way. Note that Dialogflow also considers
// conversations that get to the conversation end page as successful even if
// they don't return ConversationSuccess. You may set this, for example: * In
// the entry_fulfillment of a Page if entering the page indicates that the
// conversation succeeded. * In a webhook response when you determine that you
// handled the customer issue.
type GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess struct {
	// Metadata: Custom metadata. Dialogflow doesn't impose any structure on this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageEndInteraction: Indicates that
// interaction with the Dialogflow agent has ended. This message is generated
// by Dialogflow only and not supposed to be defined by the user.
type GoogleCloudDialogflowCxV3ResponseMessageEndInteraction struct {
}

// GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard: Represents info
// card response. If the response contains generative knowledge prediction,
// Dialogflow will return a payload with Infobot Messenger compatible info
// card. Otherwise, the info card response is skipped.
type GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard struct {
}

// GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff: Indicates that the
// conversation should be handed off to a live agent. Dialogflow only uses this
// to determine which conversations were handed off to a human agent for
// measurement purposes. What else to do with this signal is up to you and your
// handoff procedures. You may set this, for example: * In the
// entry_fulfillment of a Page if entering the page indicates something went
// extremely wrong in the conversation. * In a webhook response when you
// determine that the customer issue can only be handled by a human.
type GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff struct {
	// Metadata: Custom metadata for your handoff procedure. Dialogflow doesn't
	// impose any structure on this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageMixedAudio: Represents an audio
// message that is composed of both segments synthesized from the Dialogflow
// agent prompts and ones hosted externally at the specified URIs. The external
// URIs are specified via play_audio. This message is generated by Dialogflow
// only and not supposed to be defined by the user.
type GoogleCloudDialogflowCxV3ResponseMessageMixedAudio struct {
	// Segments: Segments this audio response is composed of.
	Segments []*GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageMixedAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment: Represents one
// segment of audio.
type GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this segment
	// can be interrupted by the end user's speech and the client should then start
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Audio: Raw audio synthesized from the Dialogflow agent's response using the
	// output config specified in the request.
	Audio string `json:"audio,omitempty"`
	// Uri: Client-specific URI that points to an audio clip accessible to the
	// client. Dialogflow does not impose any validation on it.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText: A text or ssml
// response that is preferentially used for TTS output audio synthesis, as
// described in the comment on the ResponseMessage message.
type GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Ssml: The SSML text to be synthesized. For more information, see SSML
	// (/speech/text-to-speech/docs/ssml).
	Ssml string `json:"ssml,omitempty"`
	// Text: The raw text to be synthesized.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessagePlayAudio: Specifies an audio clip
// to be played by the client as part of the response.
type GoogleCloudDialogflowCxV3ResponseMessagePlayAudio struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// AudioUri: Required. URI of the audio clip. Dialogflow does not impose any
	// validation on this value. It is specific to the client that reads it.
	AudioUri string `json:"audioUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessagePlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessagePlayAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall: Represents
// the signal that telles the client to transfer the phone call connected to
// the agent to a third-party endpoint.
type GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall struct {
	// PhoneNumber: Transfer the call to a phone number in E.164 format
	// (https://en.wikipedia.org/wiki/E.164).
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ResponseMessageText: The text response message.
type GoogleCloudDialogflowCxV3ResponseMessageText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Text: Required. A collection of text response variants. If multiple variants
	// are defined, only one text response variant is returned at runtime.
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ResponseMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3RunContinuousTestMetadata: Metadata returned for
// the Environments.RunContinuousTest long running operation.
type GoogleCloudDialogflowCxV3RunContinuousTestMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunContinuousTestMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunContinuousTestMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3RunContinuousTestResponse: The response message for
// Environments.RunContinuousTest.
type GoogleCloudDialogflowCxV3RunContinuousTestResponse struct {
	// ContinuousTestResult: The result for a continuous test run.
	ContinuousTestResult *GoogleCloudDialogflowCxV3ContinuousTestResult `json:"continuousTestResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContinuousTestResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinuousTestResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunContinuousTestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunContinuousTestResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3RunTestCaseMetadata: Metadata returned for the
// TestCases.RunTestCase long running operation. This message currently has no
// fields.
type GoogleCloudDialogflowCxV3RunTestCaseMetadata struct {
}

// GoogleCloudDialogflowCxV3RunTestCaseResponse: The response message for
// TestCases.RunTestCase.
type GoogleCloudDialogflowCxV3RunTestCaseResponse struct {
	// Result: The result.
	Result *GoogleCloudDialogflowCxV3TestCaseResult `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Result") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3RunTestCaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3RunTestCaseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3SessionInfo: Represents session information
// communicated to and from the webhook.
type GoogleCloudDialogflowCxV3SessionInfo struct {
	// Parameters: Optional for WebhookRequest. Optional for WebhookResponse. All
	// parameters collected from forms and intents during the session. Parameters
	// can be created, updated, or removed by the webhook. To remove a parameter
	// from the session, the webhook should explicitly set the parameter value to
	// null in WebhookResponse. The map is keyed by parameters' display names.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// Session: Always present for WebhookRequest. Ignored for WebhookResponse. The
	// unique identifier of the session. This field can be used by the webhook to
	// identify a session. Format: `projects//locations//agents//sessions/` or
	// `projects//locations//agents//environments//sessions/` if environment is
	// specified.
	Session string `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3SessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3SessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestCase: Represents a test case.
type GoogleCloudDialogflowCxV3TestCase struct {
	// CreationTime: Output only. When the test was created.
	CreationTime string `json:"creationTime,omitempty"`
	// DisplayName: Required. The human-readable name of the test case, unique
	// within the agent. Limit of 200 characters.
	DisplayName string `json:"displayName,omitempty"`
	// LastTestResult: The latest test result.
	LastTestResult *GoogleCloudDialogflowCxV3TestCaseResult `json:"lastTestResult,omitempty"`
	// Name: The unique identifier of the test case. TestCases.CreateTestCase will
	// populate the name automatically. Otherwise use format:
	// `projects//locations//agents//testCases/`.
	Name string `json:"name,omitempty"`
	// Notes: Additional freeform notes about the test case. Limit of 400
	// characters.
	Notes string `json:"notes,omitempty"`
	// Tags: Tags are short descriptions that users may apply to test cases for
	// organizational and filtering purposes. Each tag should start with "#" and
	// has a limit of 30 characters.
	Tags []string `json:"tags,omitempty"`
	// TestCaseConversationTurns: The conversation turns uttered when the test case
	// was created, in chronological order. These include the canonical set of
	// agent utterances that should occur when the agent is working properly.
	TestCaseConversationTurns []*GoogleCloudDialogflowCxV3ConversationTurn `json:"testCaseConversationTurns,omitempty"`
	// TestConfig: Config for the test case.
	TestConfig *GoogleCloudDialogflowCxV3TestConfig `json:"testConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestCaseError: Error info for importing a test.
type GoogleCloudDialogflowCxV3TestCaseError struct {
	// Status: The status associated with the test case.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TestCase: The test case.
	TestCase *GoogleCloudDialogflowCxV3TestCase `json:"testCase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCaseError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCaseError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestCaseResult: Represents a result from running a
// test case in an agent environment.
type GoogleCloudDialogflowCxV3TestCaseResult struct {
	// ConversationTurns: The conversation turns uttered during the test case
	// replay in chronological order.
	ConversationTurns []*GoogleCloudDialogflowCxV3ConversationTurn `json:"conversationTurns,omitempty"`
	// Environment: Environment where the test was run. If not set, it indicates
	// the draft environment.
	Environment string `json:"environment,omitempty"`
	// Name: The resource name for the test case result. Format:
	// `projects//locations//agents//testCases//results/`.
	Name string `json:"name,omitempty"`
	// TestResult: Whether the test case passed in the agent environment.
	//
	// Possible values:
	//   "TEST_RESULT_UNSPECIFIED" - Not specified. Should never be used.
	//   "PASSED" - The test passed.
	//   "FAILED" - The test did not pass.
	TestResult string `json:"testResult,omitempty"`
	// TestTime: The time that the test was run.
	TestTime string `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationTurns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationTurns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestCaseResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestCaseResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestConfig: Represents configurations for a test
// case.
type GoogleCloudDialogflowCxV3TestConfig struct {
	// Flow: Flow name to start the test case with. Format:
	// `projects//locations//agents//flows/`. Only one of `flow` and `page` should
	// be set to indicate the starting point of the test case. If neither is set,
	// the test case will start with start page on the default start flow.
	Flow string `json:"flow,omitempty"`
	// Page: The page to start the test case with. Format:
	// `projects//locations//agents//flows//pages/`. Only one of `flow` and `page`
	// should be set to indicate the starting point of the test case. If neither is
	// set, the test case will start with start page on the default start flow.
	Page string `json:"page,omitempty"`
	// TrackingParameters: Session parameters to be compared when calculating
	// differences.
	TrackingParameters []string `json:"trackingParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestError: Error info for running a test.
type GoogleCloudDialogflowCxV3TestError struct {
	// Status: The status associated with the test.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TestCase: The test case resource name.
	TestCase string `json:"testCase,omitempty"`
	// TestTime: The timestamp when the test was completed.
	TestTime string `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TestRunDifference: The description of differences
// between original and replayed agent output.
type GoogleCloudDialogflowCxV3TestRunDifference struct {
	// Description: A human readable description of the diff, showing the actual
	// output vs expected output.
	Description string `json:"description,omitempty"`
	// Type: The type of diff.
	//
	// Possible values:
	//   "DIFF_TYPE_UNSPECIFIED" - Should never be used.
	//   "INTENT" - The intent.
	//   "PAGE" - The page.
	//   "PARAMETERS" - The parameters.
	//   "UTTERANCE" - The message utterance.
	//   "FLOW" - The flow.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TestRunDifference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TestRunDifference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TextInput: Represents the natural language text to
// be processed.
type GoogleCloudDialogflowCxV3TextInput struct {
	// Text: Required. The UTF-8 encoded natural language text to be processed.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ToolCall: Represents a call of a specific tool's
// action with the specified inputs.
type GoogleCloudDialogflowCxV3ToolCall struct {
	// Action: Required. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// InputParameters: Optional. The action's input parameters.
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	// Tool: Required. The tool associated with this call. Format:
	// `projects//locations//agents//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ToolCallResult: The result of calling a tool's
// action that has been executed by the client.
type GoogleCloudDialogflowCxV3ToolCallResult struct {
	// Action: Required. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// Error: The tool call's error.
	Error *GoogleCloudDialogflowCxV3ToolCallResultError `json:"error,omitempty"`
	// OutputParameters: The tool call's output parameters.
	OutputParameters googleapi.RawMessage `json:"outputParameters,omitempty"`
	// Tool: Required. The tool associated with this call. Format:
	// `projects//locations//agents//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3ToolCallResultError: An error produced by the tool
// call.
type GoogleCloudDialogflowCxV3ToolCallResultError struct {
	// Message: Optional. The error message of the function.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TransitionRoute: A transition route specifies a
// intent that can be matched and/or a data condition that can be evaluated
// during a session. When a specified transition is matched, the following
// actions are taken in order: * If there is a `trigger_fulfillment` associated
// with the transition, it will be called. * If there is a `target_page`
// associated with the transition, the session will transition into the
// specified page. * If there is a `target_flow` associated with the
// transition, the session will transition into the specified flow.
type GoogleCloudDialogflowCxV3TransitionRoute struct {
	// Condition: The condition to evaluate against form parameters or session
	// parameters. See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition). At least
	// one of `intent` or `condition` must be specified. When both `intent` and
	// `condition` are specified, the transition can only happen when both are
	// fulfilled.
	Condition string `json:"condition,omitempty"`
	// Description: Optional. The description of the transition route. The maximum
	// length is 500 characters.
	Description string `json:"description,omitempty"`
	// Intent: The unique identifier of an Intent. Format:
	// `projects//locations//agents//intents/`. Indicates that the transition can
	// only happen when the given intent is matched. At least one of `intent` or
	// `condition` must be specified. When both `intent` and `condition` are
	// specified, the transition can only happen when both are fulfilled.
	Intent string `json:"intent,omitempty"`
	// Name: Output only. The unique identifier of this transition route.
	Name string `json:"name,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TriggerFulfillment: The fulfillment to call when the condition is satisfied.
	// At least one of `trigger_fulfillment` and `target` must be specified. When
	// both are defined, `trigger_fulfillment` is executed first.
	TriggerFulfillment *GoogleCloudDialogflowCxV3Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TransitionRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TransitionRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3TurnSignals: Collection of all signals that were
// extracted for a single turn of the conversation.
type GoogleCloudDialogflowCxV3TurnSignals struct {
	// AgentEscalated: Whether agent responded with LiveAgentHandoff fulfillment.
	AgentEscalated bool `json:"agentEscalated,omitempty"`
	// DtmfUsed: Whether user was using DTMF input.
	DtmfUsed bool `json:"dtmfUsed,omitempty"`
	// FailureReasons: Failure reasons of the turn.
	//
	// Possible values:
	//   "FAILURE_REASON_UNSPECIFIED" - Failure reason is not assigned.
	//   "FAILED_INTENT" - Whether NLU failed to recognize user intent.
	//   "FAILED_WEBHOOK" - Whether webhook failed during the turn.
	FailureReasons []string `json:"failureReasons,omitempty"`
	// NoMatch: Whether NLU predicted NO_MATCH.
	NoMatch bool `json:"noMatch,omitempty"`
	// NoUserInput: Whether user provided no input.
	NoUserInput bool `json:"noUserInput,omitempty"`
	// ReachedEndPage: Whether turn resulted in End Session page.
	ReachedEndPage bool `json:"reachedEndPage,omitempty"`
	// SentimentMagnitude: Sentiment magnitude of the user utterance if sentiment
	// (https://cloud.google.com/dialogflow/cx/docs/concept/sentiment) was enabled.
	SentimentMagnitude float64 `json:"sentimentMagnitude,omitempty"`
	// SentimentScore: Sentiment score of the user utterance if sentiment
	// (https://cloud.google.com/dialogflow/cx/docs/concept/sentiment) was enabled.
	SentimentScore float64 `json:"sentimentScore,omitempty"`
	// UserEscalated: Whether user was specifically asking for a live agent.
	UserEscalated bool `json:"userEscalated,omitempty"`
	// WebhookStatuses: Human-readable statuses of the webhooks triggered during
	// this turn.
	WebhookStatuses []string `json:"webhookStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentEscalated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentEscalated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3TurnSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3TurnSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3TurnSignals) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3TurnSignals
	var s1 struct {
		SentimentMagnitude gensupport.JSONFloat64 `json:"sentimentMagnitude"`
		SentimentScore     gensupport.JSONFloat64 `json:"sentimentScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SentimentMagnitude = float64(s1.SentimentMagnitude)
	s.SentimentScore = float64(s1.SentimentScore)
	return nil
}

// GoogleCloudDialogflowCxV3Webhook: Webhooks host the developer's business
// logic. During a session, webhooks allow the developer to use the data
// extracted by Dialogflow's natural language processing to generate dynamic
// responses, validate collected data, or trigger actions on the backend.
type GoogleCloudDialogflowCxV3Webhook struct {
	// Disabled: Indicates whether the webhook is disabled.
	Disabled bool `json:"disabled,omitempty"`
	// DisplayName: Required. The human-readable name of the webhook, unique within
	// the agent.
	DisplayName string `json:"displayName,omitempty"`
	// GenericWebService: Configuration for a generic web service.
	GenericWebService *GoogleCloudDialogflowCxV3WebhookGenericWebService `json:"genericWebService,omitempty"`
	// Name: The unique identifier of the webhook. Required for the
	// Webhooks.UpdateWebhook method. Webhooks.CreateWebhook populates the name
	// automatically. Format: `projects//locations//agents//webhooks/`.
	Name string `json:"name,omitempty"`
	// ServiceDirectory: Configuration for a Service Directory
	// (https://cloud.google.com/service-directory) service.
	ServiceDirectory *GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig `json:"serviceDirectory,omitempty"`
	// Timeout: Webhook execution timeout. Execution is considered failed if
	// Dialogflow doesn't receive a response from webhook at the end of the timeout
	// period. Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
	Timeout string `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3Webhook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3Webhook
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookGenericWebService: Represents configuration
// for a generic web service.
type GoogleCloudDialogflowCxV3WebhookGenericWebService struct {
	// AllowedCaCerts: Optional. Specifies a list of allowed custom CA certificates
	// (in DER format) for HTTPS verification. This overrides the default SSL trust
	// store. If this is empty or unspecified, Dialogflow will use Google's default
	// trust store to verify certificates. N.B. Make sure the HTTPS server
	// certificates are signed with "subject alt name". For instance a certificate
	// can be self-signed using the following command, ``` openssl x509 -req -days
	// 200 -in example.com.csr \ -signkey example.com.key \ -out example.com.crt \
	// -extfile <(printf "\nsubjectAltName='DNS:www.example.com'") ```
	AllowedCaCerts []string `json:"allowedCaCerts,omitempty"`
	// HttpMethod: Optional. HTTP method for the flexible webhook calls. Standard
	// webhook always uses POST.
	//
	// Possible values:
	//   "HTTP_METHOD_UNSPECIFIED" - HTTP method not specified.
	//   "POST" - HTTP POST Method.
	//   "GET" - HTTP GET Method.
	//   "HEAD" - HTTP HEAD Method.
	//   "PUT" - HTTP PUT Method.
	//   "DELETE" - HTTP DELETE Method.
	//   "PATCH" - HTTP PATCH Method.
	//   "OPTIONS" - HTTP OPTIONS Method.
	HttpMethod string `json:"httpMethod,omitempty"`
	// OauthConfig: Optional. The OAuth configuration of the webhook. If specified,
	// Dialogflow will initiate the OAuth client credential flow to exchange an
	// access token from the 3rd party platform and put it in the auth header.
	OauthConfig *GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig `json:"oauthConfig,omitempty"`
	// ParameterMapping: Optional. Maps the values extracted from specific fields
	// of the flexible webhook response into session parameters. - Key: session
	// parameter name - Value: field path in the webhook response
	ParameterMapping map[string]string `json:"parameterMapping,omitempty"`
	// Password: The password for HTTP Basic authentication.
	Password string `json:"password,omitempty"`
	// RequestBody: Optional. Defines a custom JSON object as request body to send
	// to flexible webhook.
	RequestBody string `json:"requestBody,omitempty"`
	// RequestHeaders: The HTTP request headers to send together with webhook
	// requests.
	RequestHeaders map[string]string `json:"requestHeaders,omitempty"`
	// SecretVersionForUsernamePassword: Optional. The SecretManager secret version
	// resource storing the username:password pair for HTTP Basic authentication.
	// Format: `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForUsernamePassword string `json:"secretVersionForUsernamePassword,omitempty"`
	// SecretVersionsForRequestHeaders: Optional. The HTTP request headers to send
	// together with webhook requests. Header values are stored in SecretManager
	// secret versions. When the same header name is specified in both
	// `request_headers` and `secret_versions_for_request_headers`, the value in
	// `secret_versions_for_request_headers` will be used.
	SecretVersionsForRequestHeaders map[string]GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue `json:"secretVersionsForRequestHeaders,omitempty"`
	// ServiceAgentAuth: Optional. Indicate the auth token type generated from the
	// Diglogflow service agent
	// (https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
	// The generated token is sent in the Authorization header.
	//
	// Possible values:
	//   "SERVICE_AGENT_AUTH_UNSPECIFIED" - Service agent auth type unspecified.
	// Default to ID_TOKEN.
	//   "NONE" - No token used.
	//   "ID_TOKEN" - Use [ID
	// token](https://cloud.google.com/docs/authentication/token-types#id)
	// generated from service agent. This can be used to access Cloud Function and
	// Cloud Run after you grant Invoker role to
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	//   "ACCESS_TOKEN" - Use [access
	// token](https://cloud.google.com/docs/authentication/token-types#access)
	// generated from service agent. This can be used to access other Google Cloud
	// APIs after you grant required roles to
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	ServiceAgentAuth string `json:"serviceAgentAuth,omitempty"`
	// Uri: Required. The webhook URI for receiving POST requests. It must use
	// https protocol.
	Uri string `json:"uri,omitempty"`
	// Username: The user name for HTTP Basic authentication.
	Username string `json:"username,omitempty"`
	// WebhookType: Optional. Type of the webhook.
	//
	// Possible values:
	//   "WEBHOOK_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "STANDARD" - Represents a standard webhook.
	//   "FLEXIBLE" - Represents a flexible webhook.
	WebhookType string `json:"webhookType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedCaCerts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedCaCerts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig: Represents
// configuration of OAuth client credential flow for 3rd party API
// authentication.
type GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig struct {
	// ClientId: Required. The client ID provided by the 3rd party platform.
	ClientId string `json:"clientId,omitempty"`
	// ClientSecret: Optional. The client secret provided by the 3rd party
	// platform.
	ClientSecret string `json:"clientSecret,omitempty"`
	// Scopes: Optional. The OAuth scopes to grant.
	Scopes []string `json:"scopes,omitempty"`
	// SecretVersionForClientSecret: Optional. The name of the SecretManager secret
	// version resource storing the client secret. If this field is set, the
	// `client_secret` field will be ignored. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForClientSecret string `json:"secretVersionForClientSecret,omitempty"`
	// TokenEndpoint: Required. The token endpoint provided by the 3rd party
	// platform to exchange an access token.
	TokenEndpoint string `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue:
// Represents the value of an HTTP header stored in a SecretManager secret
// version.
type GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue struct {
	// SecretVersion: Required. The SecretManager secret version resource storing
	// the header value. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersion string `json:"secretVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequest: The request message for a webhook
// call. The request is sent as a JSON object and the field names will be
// presented in camel cases. You may see undocumented fields in an actual
// request. These fields are used internally by Dialogflow and should be
// ignored.
type GoogleCloudDialogflowCxV3WebhookRequest struct {
	// DetectIntentResponseId: Always present. The unique identifier of the
	// DetectIntentResponse that will be returned to the API caller.
	DetectIntentResponseId string `json:"detectIntentResponseId,omitempty"`
	// DtmfDigits: If DTMF was provided as input, this field will contain the DTMF
	// digits.
	DtmfDigits string `json:"dtmfDigits,omitempty"`
	// FulfillmentInfo: Always present. Information about the fulfillment that
	// triggered this webhook call.
	FulfillmentInfo *GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo `json:"fulfillmentInfo,omitempty"`
	// IntentInfo: Information about the last matched intent.
	IntentInfo *GoogleCloudDialogflowCxV3WebhookRequestIntentInfo `json:"intentInfo,omitempty"`
	// LanguageCode: The language code specified in the original request.
	LanguageCode string `json:"languageCode,omitempty"`
	// LanguageInfo: Information about the language of the request.
	LanguageInfo *GoogleCloudDialogflowCxV3LanguageInfo `json:"languageInfo,omitempty"`
	// Messages: The list of rich message responses to present to the user. Webhook
	// can choose to append or replace this list in
	// WebhookResponse.fulfillment_response;
	Messages []*GoogleCloudDialogflowCxV3ResponseMessage `json:"messages,omitempty"`
	// PageInfo: Information about page status.
	PageInfo *GoogleCloudDialogflowCxV3PageInfo `json:"pageInfo,omitempty"`
	// Payload: Custom data set in QueryParameters.payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// SentimentAnalysisResult: The sentiment analysis result of the current user
	// request. The field is filled when sentiment analysis is configured to be
	// enabled for the request.
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	// SessionInfo: Information about session status.
	SessionInfo *GoogleCloudDialogflowCxV3SessionInfo `json:"sessionInfo,omitempty"`
	// Text: If natural language text was provided as input, this field will
	// contain a copy of the text.
	Text string `json:"text,omitempty"`
	// Transcript: If natural language speech audio was provided as input, this
	// field will contain the transcript for the audio.
	Transcript string `json:"transcript,omitempty"`
	// TriggerEvent: If an event was provided as input, this field will contain the
	// name of the event.
	TriggerEvent string `json:"triggerEvent,omitempty"`
	// TriggerIntent: If an intent was provided as input, this field will contain a
	// copy of the intent identifier. Format:
	// `projects//locations//agents//intents/`.
	TriggerIntent string `json:"triggerIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectIntentResponseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectIntentResponseId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo: Represents
// fulfillment information communicated to the webhook.
type GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo struct {
	// Tag: Always present. The value of the Fulfillment.tag field will be
	// populated in this field by Dialogflow when the associated webhook is called.
	// The tag is typically used by the webhook service to identify which
	// fulfillment is being called, but it could be used for other purposes.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequestIntentInfo: Represents intent
// information communicated to the webhook.
type GoogleCloudDialogflowCxV3WebhookRequestIntentInfo struct {
	// Confidence: The confidence of the matched intent. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// DisplayName: Always present. The display name of the last matched intent.
	DisplayName string `json:"displayName,omitempty"`
	// LastMatchedIntent: Always present. The unique identifier of the last matched
	// intent. Format: `projects//locations//agents//intents/`.
	LastMatchedIntent string `json:"lastMatchedIntent,omitempty"`
	// Parameters: Parameters identified as a result of intent matching. This is a
	// map of the name of the identified parameter to the value of the parameter
	// identified from the user's utterance. All parameters defined in the matched
	// intent that are identified will be surfaced here.
	Parameters map[string]GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestIntentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue:
// Represents a value for an intent parameter.
type GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue struct {
	// OriginalValue: Always present. Original text value extracted from user
	// utterance.
	OriginalValue string `json:"originalValue,omitempty"`
	// ResolvedValue: Always present. Structured value for the parameter extracted
	// from user utterance.
	ResolvedValue interface{} `json:"resolvedValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OriginalValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult: Represents
// the result of sentiment analysis.
type GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which represents
	// the absolute magnitude of sentiment, regardless of score (positive or
	// negative).
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowCxV3WebhookResponse: The response message for a webhook
// call.
type GoogleCloudDialogflowCxV3WebhookResponse struct {
	// FulfillmentResponse: The fulfillment response to send to the user. This
	// field can be omitted by the webhook if it does not intend to send any
	// response to the user.
	FulfillmentResponse *GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse `json:"fulfillmentResponse,omitempty"`
	// PageInfo: Information about page status. This field can be omitted by the
	// webhook if it does not intend to modify page status.
	PageInfo *GoogleCloudDialogflowCxV3PageInfo `json:"pageInfo,omitempty"`
	// Payload: Value to append directly to QueryResult.webhook_payloads.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// SessionInfo: Information about session status. This field can be omitted by
	// the webhook if it does not intend to modify session status.
	SessionInfo *GoogleCloudDialogflowCxV3SessionInfo `json:"sessionInfo,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FulfillmentResponse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FulfillmentResponse") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse: Represents a
// fulfillment response to the user.
type GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse struct {
	// MergeBehavior: Merge behavior for `messages`.
	//
	// Possible values:
	//   "MERGE_BEHAVIOR_UNSPECIFIED" - Not specified. `APPEND` will be used.
	//   "APPEND" - `messages` will be appended to the list of messages waiting to
	// be sent to the user.
	//   "REPLACE" - `messages` will replace the list of messages waiting to be
	// sent to the user.
	MergeBehavior string `json:"mergeBehavior,omitempty"`
	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3ResponseMessage `json:"messages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MergeBehavior") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MergeBehavior") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig: Represents
// configuration for a Service Directory
// (https://cloud.google.com/service-directory) service.
type GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig struct {
	// GenericWebService: Generic Service configuration of this webhook.
	GenericWebService *GoogleCloudDialogflowCxV3WebhookGenericWebService `json:"genericWebService,omitempty"`
	// Service: Required. The name of Service Directory
	// (https://cloud.google.com/service-directory) service. Format:
	// `projects//locations//namespaces//services/`. `Location ID` of the service
	// directory must be the same as the location of the agent.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericWebService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericWebService") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Action: Action performed by end user or
// Dialogflow agent in the conversation.
type GoogleCloudDialogflowCxV3beta1Action struct {
	// AgentUtterance: Optional. Action performed by the agent as a message.
	AgentUtterance *GoogleCloudDialogflowCxV3beta1AgentUtterance `json:"agentUtterance,omitempty"`
	// CompleteTime: Output only. Timestamp of the completion of the agent action.
	CompleteTime string `json:"completeTime,omitempty"`
	// DisplayName: Output only. The display name of the action.
	DisplayName string `json:"displayName,omitempty"`
	// Event: Optional. The agent received an event from the customer or a system
	// event is emitted.
	Event *GoogleCloudDialogflowCxV3beta1Event `json:"event,omitempty"`
	// FlowInvocation: Optional. Action performed on behalf of the agent by
	// invoking a CX flow.
	FlowInvocation *GoogleCloudDialogflowCxV3beta1FlowInvocation `json:"flowInvocation,omitempty"`
	// FlowStateUpdate: Optional. Output only. The state machine update in flows.
	FlowStateUpdate *GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdate `json:"flowStateUpdate,omitempty"`
	// FlowTransition: Optional. Action performed on behalf of the agent by
	// transitioning to a target CX flow.
	FlowTransition *GoogleCloudDialogflowCxV3beta1FlowTransition `json:"flowTransition,omitempty"`
	// IntentMatch: Optional. Output only. Intent Match in flows.
	IntentMatch *GoogleCloudDialogflowCxV3beta1ActionIntentMatch `json:"intentMatch,omitempty"`
	// LlmCall: Optional. Output only. LLM call performed by the agent.
	LlmCall *GoogleCloudDialogflowCxV3beta1LlmCall `json:"llmCall,omitempty"`
	// PlaybookInvocation: Optional. Action performed on behalf of the agent by
	// invoking a child playbook.
	PlaybookInvocation *GoogleCloudDialogflowCxV3beta1PlaybookInvocation `json:"playbookInvocation,omitempty"`
	// PlaybookTransition: Optional. Action performed on behalf of the agent by
	// transitioning to a target playbook.
	PlaybookTransition *GoogleCloudDialogflowCxV3beta1PlaybookTransition `json:"playbookTransition,omitempty"`
	// StartTime: Output only. Timestamp of the start of the agent action.
	StartTime string `json:"startTime,omitempty"`
	// Status: Optional. Output only. The status of the action.
	Status *GoogleCloudDialogflowCxV3beta1Status `json:"status,omitempty"`
	// Stt: Optional. Speech-to-text action performed by the agent.
	Stt *GoogleCloudDialogflowCxV3beta1ActionSTT `json:"stt,omitempty"`
	// SubExecutionSteps: Optional. The detailed tracing information for sub
	// execution steps of the action.
	SubExecutionSteps []*GoogleCloudDialogflowCxV3beta1Span `json:"subExecutionSteps,omitempty"`
	// ToolUse: Optional. Action performed on behalf of the agent by calling a
	// plugin tool.
	ToolUse *GoogleCloudDialogflowCxV3beta1ToolUse `json:"toolUse,omitempty"`
	// Tts: Optional. Text-to-speech action performed by the agent.
	Tts *GoogleCloudDialogflowCxV3beta1ActionTTS `json:"tts,omitempty"`
	// UserUtterance: Optional. Agent obtained a message from the customer.
	UserUtterance *GoogleCloudDialogflowCxV3beta1UserUtterance `json:"userUtterance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentUtterance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentUtterance") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Action) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Action
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdate: Stores metadata of the
// state update action, such as a state machine execution in flows.
type GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdate struct {
	// Destination: The destination of the transition. Format:
	// `projects//locations//agents//flows//pages/` or
	// `projects//locations//agents//playbooks/`.
	Destination string `json:"destination,omitempty"`
	// EventType: The type of the event that triggered the state update.
	EventType string `json:"eventType,omitempty"`
	// FunctionCall: The function call to execute.
	FunctionCall *GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdateFunctionCall `json:"functionCall,omitempty"`
	// PageState: The updated page and flow state.
	PageState *GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdatePageState `json:"pageState,omitempty"`
	// UpdatedParameters: The updated parameters.
	UpdatedParameters googleapi.RawMessage `json:"updatedParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdateFunctionCall: Stores the
// metadata of a function call to execute.
type GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdateFunctionCall struct {
	// Name: The name of the function call.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdateFunctionCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdateFunctionCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdatePageState: Stores the
// state of a page and its flow.
type GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdatePageState struct {
	// DisplayName: The display name of the page.
	DisplayName string `json:"displayName,omitempty"`
	// Page: The ID of the page. Format:
	// `projects//locations//agents//flows//pages/`.
	Page string `json:"page,omitempty"`
	// Status: The status of the page.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdatePageState) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ActionFlowStateUpdatePageState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ActionIntentMatch: Stores metadata of the
// intent match action.
type GoogleCloudDialogflowCxV3beta1ActionIntentMatch struct {
	// MatchedIntents: The matched intent.
	MatchedIntents []*GoogleCloudDialogflowCxV3beta1ActionIntentMatchMatchedIntent `json:"matchedIntents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MatchedIntents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MatchedIntents") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ActionIntentMatch) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ActionIntentMatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ActionIntentMatchMatchedIntent: Stores the
// matched intent, which is the result of the intent match action.
type GoogleCloudDialogflowCxV3beta1ActionIntentMatchMatchedIntent struct {
	// DisplayName: The display name of the matched intent.
	DisplayName string `json:"displayName,omitempty"`
	// GenerativeFallback: The generative fallback response of the matched intent.
	GenerativeFallback googleapi.RawMessage `json:"generativeFallback,omitempty"`
	// IntentId: The ID of the matched intent.
	IntentId string `json:"intentId,omitempty"`
	// Score: The score of the matched intent.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ActionIntentMatchMatchedIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ActionIntentMatchMatchedIntent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1ActionIntentMatchMatchedIntent) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1ActionIntentMatchMatchedIntent
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowCxV3beta1ActionSTT: Stores metadata of the
// Speech-to-Text action.
type GoogleCloudDialogflowCxV3beta1ActionSTT struct {
}

// GoogleCloudDialogflowCxV3beta1ActionTTS: Stores metadata of the
// Text-to-Speech action.
type GoogleCloudDialogflowCxV3beta1ActionTTS struct {
}

// GoogleCloudDialogflowCxV3beta1AdvancedSettings: Hierarchical advanced
// settings for agent/flow/page/fulfillment/parameter. Settings exposed at
// lower level overrides the settings exposed at higher level. Overriding
// occurs at the sub-setting level. For example, the
// playback_interruption_settings at fulfillment level only overrides the
// playback_interruption_settings at the agent level, leaving other settings at
// the agent level unchanged. DTMF settings does not override each other. DTMF
// settings set at different levels define DTMF detections running in parallel.
// Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
type GoogleCloudDialogflowCxV3beta1AdvancedSettings struct {
	// AudioExportGcsDestination: If present, incoming audio is exported by
	// Dialogflow to the configured Google Cloud Storage destination. Exposed at
	// the following levels: - Agent level - Flow level
	AudioExportGcsDestination *GoogleCloudDialogflowCxV3beta1GcsDestination `json:"audioExportGcsDestination,omitempty"`
	// DtmfSettings: Settings for DTMF. Exposed at the following levels: - Agent
	// level - Flow level - Page level - Parameter level.
	DtmfSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings `json:"dtmfSettings,omitempty"`
	// LoggingSettings: Settings for logging. Settings for Dialogflow History,
	// Contact Center messages, StackDriver logs, and speech logging. Exposed at
	// the following levels: - Agent level.
	LoggingSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings `json:"loggingSettings,omitempty"`
	// SpeechSettings: Settings for speech to text detection. Exposed at the
	// following levels: - Agent level - Flow level - Page level - Parameter level
	SpeechSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings `json:"speechSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioExportGcsDestination")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings: Define behaviors
// for DTMF (dual tone multi frequency).
type GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings struct {
	// Enabled: If true, incoming audio is processed for DTMF (dual tone multi
	// frequency) events. For example, if the caller presses a button on their
	// telephone keypad and DTMF processing is enabled, Dialogflow will detect the
	// event (e.g. a "3" was pressed) in the incoming audio and pass the event to
	// the bot to drive business logic (e.g. when 3 is pressed, return the account
	// balance).
	Enabled bool `json:"enabled,omitempty"`
	// EndpointingTimeoutDuration: Endpoint timeout setting for matching dtmf input
	// to regex.
	EndpointingTimeoutDuration string `json:"endpointingTimeoutDuration,omitempty"`
	// FinishDigit: The digit that terminates a DTMF digit sequence.
	FinishDigit string `json:"finishDigit,omitempty"`
	// InterdigitTimeoutDuration: Interdigit timeout setting for matching dtmf
	// input to regex.
	InterdigitTimeoutDuration string `json:"interdigitTimeoutDuration,omitempty"`
	// MaxDigits: Max length of DTMF digits.
	MaxDigits int64 `json:"maxDigits,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings: Define
// behaviors on logging.
type GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings struct {
	// EnableConsentBasedRedaction: Enables consent-based end-user input redaction,
	// if true, a pre-defined session parameter
	// `$session.params.conversation-redaction` will be used to determine if the
	// utterance should be redacted.
	EnableConsentBasedRedaction bool `json:"enableConsentBasedRedaction,omitempty"`
	// EnableInteractionLogging: Enables DF Interaction logging.
	EnableInteractionLogging bool `json:"enableInteractionLogging,omitempty"`
	// EnableStackdriverLogging: Enables Google Cloud Logging.
	EnableStackdriverLogging bool `json:"enableStackdriverLogging,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableConsentBasedRedaction") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableConsentBasedRedaction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings: Define
// behaviors of speech to text detection.
type GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings struct {
	// EndpointerSensitivity: Sensitivity of the speech model that detects the end
	// of speech. Scale from 0 to 100.
	EndpointerSensitivity int64 `json:"endpointerSensitivity,omitempty"`
	// Models: Mapping from language to Speech-to-Text model. The mapped
	// Speech-to-Text model will be selected for requests from its corresponding
	// language. For more information, see Speech models
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
	Models map[string]string `json:"models,omitempty"`
	// NoSpeechTimeout: Timeout before detecting no speech.
	NoSpeechTimeout string `json:"noSpeechTimeout,omitempty"`
	// UseTimeoutBasedEndpointing: Use timeout based endpointing, interpreting
	// endpointer sensitivity as seconds of timeout value.
	UseTimeoutBasedEndpointing bool `json:"useTimeoutBasedEndpointing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndpointerSensitivity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndpointerSensitivity") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Agent: Agents are best described as Natural
// Language Understanding (NLU) modules that transform user requests into
// actionable data. You can include agents in your app, product, or service to
// determine user intent and respond to the user in a natural way. After you
// create an agent, you can add Intents, Entity Types, Flows, Fulfillments,
// Webhooks, TransitionRouteGroups and so on to manage the conversation flows.
type GoogleCloudDialogflowCxV3beta1Agent struct {
	// AdvancedSettings: Hierarchical advanced settings for this agent. The
	// settings exposed at the lower level overrides the settings exposed at the
	// higher level.
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings `json:"advancedSettings,omitempty"`
	// AnswerFeedbackSettings: Optional. Answer feedback collection settings.
	AnswerFeedbackSettings *GoogleCloudDialogflowCxV3beta1AgentAnswerFeedbackSettings `json:"answerFeedbackSettings,omitempty"`
	// AvatarUri: The URI of the agent's avatar. Avatars are used throughout the
	// Dialogflow console and in the self-hosted Web Demo
	// (https://cloud.google.com/dialogflow/docs/integrations/web-demo)
	// integration.
	AvatarUri string `json:"avatarUri,omitempty"`
	// BigqueryExportSettings: Optional. The BigQuery export settings for this
	// agent. The conversation data will be exported to BigQuery tables if it is
	// enabled. By default, BigQuery export settings will not be exported with
	// agent. You need to set include_bigquery_export_settings to include it in the
	// exported agent.
	BigqueryExportSettings *GoogleCloudDialogflowCxV3beta1BigQueryExportSettings `json:"bigqueryExportSettings,omitempty"`
	// ClientCertificateSettings: Optional. Settings for custom client
	// certificates.
	ClientCertificateSettings *GoogleCloudDialogflowCxV3beta1AgentClientCertificateSettings `json:"clientCertificateSettings,omitempty"`
	// DefaultLanguageCode: Required. Immutable. The default language of the agent
	// as a language tag. See Language Support
	// (https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list
	// of the currently supported language codes. This field cannot be set by the
	// Agents.UpdateAgent method.
	DefaultLanguageCode string `json:"defaultLanguageCode,omitempty"`
	// Description: The description of the agent. The maximum length is 500
	// characters. If exceeded, the request is rejected.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the agent, unique within
	// the location.
	DisplayName string `json:"displayName,omitempty"`
	// EnableMultiLanguageTraining: Optional. Enable training multi-lingual models
	// for this agent. These models will be trained on all the languages supported
	// by the agent.
	EnableMultiLanguageTraining bool `json:"enableMultiLanguageTraining,omitempty"`
	// EnableSpellCorrection: Indicates if automatic spell correction is enabled in
	// detect intent requests.
	EnableSpellCorrection bool `json:"enableSpellCorrection,omitempty"`
	// EnableStackdriverLogging: Indicates if stackdriver logging is enabled for
	// the agent. Please use agent.advanced_settings instead.
	EnableStackdriverLogging bool `json:"enableStackdriverLogging,omitempty"`
	// GenAppBuilderSettings: Gen App Builder-related agent-level settings.
	GenAppBuilderSettings *GoogleCloudDialogflowCxV3beta1AgentGenAppBuilderSettings `json:"genAppBuilderSettings,omitempty"`
	// GitIntegrationSettings: Git integration settings for this agent.
	GitIntegrationSettings *GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettings `json:"gitIntegrationSettings,omitempty"`
	// Locked: Indicates whether the agent is locked for changes. If the agent is
	// locked, modifications to the agent will be rejected except for RestoreAgent.
	Locked bool `json:"locked,omitempty"`
	// Name: The unique identifier of the agent. Required for the
	// Agents.UpdateAgent method. Agents.CreateAgent populates the name
	// automatically. Format: `projects//locations//agents/`.
	Name string `json:"name,omitempty"`
	// PersonalizationSettings: Optional. Settings for end user personalization.
	PersonalizationSettings *GoogleCloudDialogflowCxV3beta1AgentPersonalizationSettings `json:"personalizationSettings,omitempty"`
	// SatisfiesPzi: Optional. Output only. A read only boolean field reflecting
	// Zone Isolation status of the agent.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Optional. Output only. A read only boolean field reflecting
	// Zone Separation status of the agent.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SecuritySettings: Name of the SecuritySettings reference for the agent.
	// Format: `projects//locations//securitySettings/`.
	SecuritySettings string `json:"securitySettings,omitempty"`
	// SpeechToTextSettings: Speech recognition related settings.
	SpeechToTextSettings *GoogleCloudDialogflowCxV3beta1SpeechToTextSettings `json:"speechToTextSettings,omitempty"`
	// StartFlow: Name of the start flow in this agent. A start flow will be
	// automatically created when the agent is created, and can only be deleted by
	// deleting the agent. Format: `projects//locations//agents//flows/`. Currently
	// only the default start flow with id "00000000-0000-0000-0000-000000000000"
	// is allowed.
	StartFlow string `json:"startFlow,omitempty"`
	// StartPlaybook: Name of the start playbook in this agent. A start playbook
	// will be automatically created when the agent is created, and can only be
	// deleted by deleting the agent. Format:
	// `projects//locations//agents//playbooks/`. Currently only the default
	// playbook with id "00000000-0000-0000-0000-000000000000" is allowed.
	StartPlaybook string `json:"startPlaybook,omitempty"`
	// SupportedLanguageCodes: The list of all languages supported by the agent
	// (except for the `default_language_code`).
	SupportedLanguageCodes []string `json:"supportedLanguageCodes,omitempty"`
	// TextToSpeechSettings: Settings on instructing the speech synthesizer on how
	// to generate the output audio content.
	TextToSpeechSettings *GoogleCloudDialogflowCxV3beta1TextToSpeechSettings `json:"textToSpeechSettings,omitempty"`
	// TimeZone: Required. The time zone of the agent from the time zone database
	// (https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
	TimeZone string `json:"timeZone,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Agent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Agent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AgentAnswerFeedbackSettings: Settings for
// answer feedback collection.
type GoogleCloudDialogflowCxV3beta1AgentAnswerFeedbackSettings struct {
	// EnableAnswerFeedback: Optional. If enabled, end users will be able to
	// provide answer feedback to Dialogflow responses. Feature works only if
	// interaction logging is enabled in the Dialogflow agent.
	EnableAnswerFeedback bool `json:"enableAnswerFeedback,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableAnswerFeedback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableAnswerFeedback") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AgentAnswerFeedbackSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AgentAnswerFeedbackSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AgentClientCertificateSettings: Settings for
// custom client certificates.
type GoogleCloudDialogflowCxV3beta1AgentClientCertificateSettings struct {
	// Passphrase: Optional. The name of the SecretManager secret version resource
	// storing the passphrase. 'passphrase' should be left unset if the private key
	// is not encrypted. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	Passphrase string `json:"passphrase,omitempty"`
	// PrivateKey: Required. The name of the SecretManager secret version resource
	// storing the private key encoded in PEM format. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	PrivateKey string `json:"privateKey,omitempty"`
	// SslCertificate: Required. The ssl certificate encoded in PEM format. This
	// string must include the begin header and end footer lines.
	SslCertificate string `json:"sslCertificate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Passphrase") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Passphrase") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AgentClientCertificateSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AgentClientCertificateSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AgentGenAppBuilderSettings: Settings for Gen
// App Builder.
type GoogleCloudDialogflowCxV3beta1AgentGenAppBuilderSettings struct {
	// Engine: Required. The full name of the Gen App Builder engine related to
	// this agent if there is one. Format: `projects/{Project
	// ID}/locations/{Location ID}/collections/{Collection ID}/engines/{Engine ID}`
	Engine string `json:"engine,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Engine") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Engine") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AgentGenAppBuilderSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AgentGenAppBuilderSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettings: Settings for
// connecting to Git repository for an agent.
type GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettings struct {
	// GitConnectionSettings: Git connection settings.
	GitConnectionSettings *GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettingsGitConnectionSettings `json:"gitConnectionSettings,omitempty"`
	// GithubSettings: GitHub settings.
	GithubSettings *GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettingsGithubSettings `json:"githubSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GitConnectionSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GitConnectionSettings") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettingsGitConnectionSetting
// s: Integration settings for a Git service hosted on Cloud Run.
type GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettingsGitConnectionSettings struct {
	// AccessTokenSecret: The name of the SecretManager secret version resource
	// storing the git access token. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	AccessTokenSecret string `json:"accessTokenSecret,omitempty"`
	// Branches: Optional. List of branches configured for the repository.
	Branches []string `json:"branches,omitempty"`
	// DisplayName: Required. Display name for the repository
	DisplayName string `json:"displayName,omitempty"`
	// RepositoryUri: Required. Git server reporitory URI.
	RepositoryUri string `json:"repositoryUri,omitempty"`
	// TrackingBranch: Required. Default branch of the repository.
	TrackingBranch string `json:"trackingBranch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessTokenSecret") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessTokenSecret") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettingsGitConnectionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettingsGitConnectionSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettingsGithubSettings:
// Settings of integration with GitHub.
type GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettingsGithubSettings struct {
	// AccessToken: The access token used to authenticate the access to the GitHub
	// repository.
	AccessToken string `json:"accessToken,omitempty"`
	// Branches: A list of branches configured to be used from Dialogflow.
	Branches []string `json:"branches,omitempty"`
	// DisplayName: The unique repository display name for the GitHub repository.
	DisplayName string `json:"displayName,omitempty"`
	// RepositoryUri: The GitHub repository URI related to the agent.
	RepositoryUri string `json:"repositoryUri,omitempty"`
	// TrackingBranch: The branch of the GitHub repository tracked for this agent.
	TrackingBranch string `json:"trackingBranch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettingsGithubSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AgentGitIntegrationSettingsGithubSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AgentPersonalizationSettings: Settings for end
// user personalization.
type GoogleCloudDialogflowCxV3beta1AgentPersonalizationSettings struct {
	// DefaultEndUserMetadata: Optional. Default end user metadata, used when
	// processing DetectIntent requests. Recommended to be filled as a template
	// instead of hard-coded value, for example { "age": "$session.params.age" }.
	// The data will be merged with the QueryParameters.end_user_metadata in
	// DetectIntentRequest.query_params during query processing.
	DefaultEndUserMetadata googleapi.RawMessage `json:"defaultEndUserMetadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultEndUserMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultEndUserMetadata") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AgentPersonalizationSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AgentPersonalizationSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AgentUtterance: AgentUtterance represents one
// message sent by the agent.
type GoogleCloudDialogflowCxV3beta1AgentUtterance struct {
	// RequireGeneration: Optional. True if the agent utterance needs to be
	// generated by the LLM. Only used in webhook response to differentiate from
	// empty text. Revisit whether we need this field or mark `text` as optional
	// when we expose webhook interface to customer.
	RequireGeneration bool `json:"requireGeneration,omitempty"`
	// Text: Required. Message content in text.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequireGeneration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequireGeneration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AgentUtterance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AgentUtterance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AgentValidationResult: The response message
// for Agents.GetAgentValidationResult.
type GoogleCloudDialogflowCxV3beta1AgentValidationResult struct {
	// FlowValidationResults: Contains all flow validation results.
	FlowValidationResults []*GoogleCloudDialogflowCxV3beta1FlowValidationResult `json:"flowValidationResults,omitempty"`
	// Name: The unique identifier of the agent validation result. Format:
	// `projects//locations//agents//validationResult`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FlowValidationResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowValidationResults") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AgentValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AgentValidationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AnswerFeedback: Stores information about
// feedback provided by users about a response.
type GoogleCloudDialogflowCxV3beta1AnswerFeedback struct {
	// CustomRating: Optional. Custom rating from the user about the provided
	// answer, with maximum length of 1024 characters. For example, client could
	// use a customized JSON object to indicate the rating.
	CustomRating string `json:"customRating,omitempty"`
	// Rating: Optional. Rating from user for the specific Dialogflow response.
	//
	// Possible values:
	//   "RATING_UNSPECIFIED" - Rating not specified.
	//   "THUMBS_UP" - Thumbs up feedback from user.
	//   "THUMBS_DOWN" - Thumbs down feedback from user.
	Rating string `json:"rating,omitempty"`
	// RatingReason: Optional. In case of thumbs down rating provided, users can
	// optionally provide context about the rating.
	RatingReason *GoogleCloudDialogflowCxV3beta1AnswerFeedbackRatingReason `json:"ratingReason,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CustomRating") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomRating") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AnswerFeedback) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AnswerFeedback
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AnswerFeedbackRatingReason: Stores extra
// information about why users provided thumbs down rating.
type GoogleCloudDialogflowCxV3beta1AnswerFeedbackRatingReason struct {
	// Feedback: Optional. Additional feedback about the rating. This field can be
	// populated without choosing a predefined `reason`.
	Feedback string `json:"feedback,omitempty"`
	// ReasonLabels: Optional. Custom reason labels for thumbs down rating provided
	// by the user. The maximum number of labels allowed is 10 and the maximum
	// length of a single label is 128 characters.
	ReasonLabels []string `json:"reasonLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Feedback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Feedback") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AnswerFeedbackRatingReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AnswerFeedbackRatingReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1AudioInput: Represents the natural speech
// audio to be processed.
type GoogleCloudDialogflowCxV3beta1AudioInput struct {
	// Audio: The natural language speech audio to be processed. A single request
	// can contain up to 2 minutes of speech audio data. The transcribed text
	// cannot contain more than 256 bytes. For non-streaming audio detect intent,
	// both `config` and `audio` must be provided. For streaming audio detect
	// intent, `config` must be provided in the first request and `audio` must be
	// provided in all following requests.
	Audio string `json:"audio,omitempty"`
	// Config: Required. Instructs the speech recognizer how to process the speech
	// audio.
	Config *GoogleCloudDialogflowCxV3beta1InputAudioConfig `json:"config,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1AudioInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1AudioInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BargeInConfig: Configuration of the barge-in
// behavior. Barge-in instructs the API to return a detected utterance at a
// proper time while the client is playing back the response audio from a
// previous request. When the client sees the utterance, it should stop the
// playback and immediately get ready for receiving the responses for the
// current request. The barge-in handling requires the client to start
// streaming audio input as soon as it starts playing back the audio from the
// previous response. The playback is modeled into two phases: * No barge-in
// phase: which goes first and during which speech detection should not be
// carried out. * Barge-in phase: which follows the no barge-in phase and
// during which the API starts speech detection and may inform the client that
// an utterance has been detected. Note that no-speech event is not expected in
// this phase. The client provides this configuration in terms of the durations
// of those two phases. The durations are measured in terms of the audio length
// from the start of the input audio. No-speech event is a response with
// END_OF_UTTERANCE without any transcript following up.
type GoogleCloudDialogflowCxV3beta1BargeInConfig struct {
	// NoBargeInDuration: Duration that is not eligible for barge-in at the
	// beginning of the input audio.
	NoBargeInDuration string `json:"noBargeInDuration,omitempty"`
	// TotalDuration: Total duration for the playback at the beginning of the input
	// audio.
	TotalDuration string `json:"totalDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NoBargeInDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NoBargeInDuration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BargeInConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BargeInConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BatchDeleteTestCasesRequest: The request
// message for TestCases.BatchDeleteTestCases.
type GoogleCloudDialogflowCxV3beta1BatchDeleteTestCasesRequest struct {
	// Names: Required. Format of test case names:
	// `projects//locations//agents//testCases/`.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BatchDeleteTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchDeleteTestCasesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata: Metadata returned
// for the TestCases.BatchRunTestCases long running operation.
type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3beta1TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BatchRunTestCasesRequest: The request message
// for TestCases.BatchRunTestCases.
type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesRequest struct {
	// Environment: Optional. If not set, draft environment is assumed. Format:
	// `projects//locations//agents//environments/`.
	Environment string `json:"environment,omitempty"`
	// TestCases: Required. Format: `projects//locations//agents//testCases/`.
	TestCases []string `json:"testCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Environment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BatchRunTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse: The response
// message for TestCases.BatchRunTestCases.
type GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse struct {
	// Results: The test case results. The detailed conversation turns are empty in
	// this response.
	Results []*GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"results,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BigQueryExportSettings: The settings of
// BigQuery export.
type GoogleCloudDialogflowCxV3beta1BigQueryExportSettings struct {
	// BigqueryTable: The BigQuery table to export. Format:
	// `projects//datasets//tables/`.
	BigqueryTable string `json:"bigqueryTable,omitempty"`
	// Enabled: The field to indicate whether the BigQuery export is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BigqueryTable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryTable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BigQueryExportSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BigQueryExportSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BoostSpec: Boost specification to boost
// certain documents. A copy of google.cloud.discoveryengine.v1main.BoostSpec,
// field documentation is available at
// https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1alpha/BoostSpec
type GoogleCloudDialogflowCxV3beta1BoostSpec struct {
	// ConditionBoostSpecs: Optional. Condition boost specifications. If a document
	// matches multiple conditions in the specifications, boost scores from these
	// specifications are all applied and combined in a non-linear way. Maximum
	// number of specifications is 20.
	ConditionBoostSpecs []*GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpec `json:"conditionBoostSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConditionBoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConditionBoostSpecs") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpec: Boost applies to
// documents which match a condition.
type GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpec struct {
	// Boost: Optional. Strength of the condition boost, which should be in [-1,
	// 1]. Negative boost means demotion. Default is 0.0. Setting to 1.0 gives the
	// document a big promotion. However, it does not necessarily mean that the
	// boosted document will be the top result at all times, nor that other
	// documents will be excluded. Results could still be shown even when none of
	// them matches the condition. And results that are significantly more relevant
	// to the search query can still trump your heavily favored but irrelevant
	// documents. Setting to -1.0 gives the document a big demotion. However,
	// results that are deeply relevant might still be shown. The document will
	// have an upstream battle to get a fairly high ranking, but it is not blocked
	// out completely. Setting to 0.0 means no boost applied. The boosting
	// condition is ignored.
	Boost float64 `json:"boost,omitempty"`
	// BoostControlSpec: Optional. Complex specification for custom ranking based
	// on customer defined attribute value.
	BoostControlSpec *GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpec `json:"boostControlSpec,omitempty"`
	// Condition: Optional. An expression which specifies a boost condition. The
	// syntax and supported fields are the same as a filter expression. Examples: *
	// To boost documents with document ID "doc_1" or "doc_2", and color "Red" or
	// "Blue": * (id: ANY("doc_1", "doc_2")) AND (color: ANY("Red","Blue"))
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Boost") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Boost") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpec
	var s1 struct {
		Boost gensupport.JSONFloat64 `json:"boost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Boost = float64(s1.Boost)
	return nil
}

// GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpec:
// Specification for custom ranking based on customer specified attribute
// value. It provides more controls for customized ranking than the simple
// (condition, boost) combination above.
type GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpec struct {
	// AttributeType: Optional. The attribute type to be used to determine the
	// boost amount. The attribute value can be derived from the field value of the
	// specified field_name. In the case of numerical it is straightforward i.e.
	// attribute_value = numerical_field_value. In the case of freshness however,
	// attribute_value = (time.now() - datetime_field_value).
	//
	// Possible values:
	//   "ATTRIBUTE_TYPE_UNSPECIFIED" - Unspecified AttributeType.
	//   "NUMERICAL" - The value of the numerical field will be used to dynamically
	// update the boost amount. In this case, the attribute_value (the x value) of
	// the control point will be the actual value of the numerical field for which
	// the boost_amount is specified.
	//   "FRESHNESS" - For the freshness use case the attribute value will be the
	// duration between the current time and the date in the datetime field
	// specified. The value must be formatted as an XSD `dayTimeDuration` value (a
	// restricted subset of an ISO 8601 duration value). The pattern for this is:
	// `nDnM]`. E.g. `5D`, `3DT12H30M`, `T24H`.
	AttributeType string `json:"attributeType,omitempty"`
	// ControlPoints: Optional. The control points used to define the curve. The
	// monotonic function (defined through the interpolation_type above) passes
	// through the control points listed here.
	ControlPoints []*GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpecControlPoint `json:"controlPoints,omitempty"`
	// FieldName: Optional. The name of the field whose value will be used to
	// determine the boost amount.
	FieldName string `json:"fieldName,omitempty"`
	// InterpolationType: Optional. The interpolation type to be applied to connect
	// the control points listed below.
	//
	// Possible values:
	//   "INTERPOLATION_TYPE_UNSPECIFIED" - Interpolation type is unspecified. In
	// this case, it defaults to Linear.
	//   "LINEAR" - Piecewise linear interpolation will be applied.
	InterpolationType string `json:"interpolationType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpecCont
// rolPoint: The control points used to define the curve. The curve defined
// through these control points can only be monotonically increasing or
// decreasing(constant values are acceptable).
type GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpecControlPoint struct {
	// AttributeValue: Optional. Can be one of: 1. The numerical field value. 2.
	// The duration spec for freshness: The value must be formatted as an XSD
	// `dayTimeDuration` value (a restricted subset of an ISO 8601 duration value).
	// The pattern for this is: `nDnM]`.
	AttributeValue string `json:"attributeValue,omitempty"`
	// BoostAmount: Optional. The value between -1 to 1 by which to boost the score
	// if the attribute_value evaluates to the value specified above.
	BoostAmount float64 `json:"boostAmount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttributeValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttributeValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpecControlPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpecControlPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpecControlPoint) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1BoostSpecConditionBoostSpecBoostControlSpecControlPoint
	var s1 struct {
		BoostAmount gensupport.JSONFloat64 `json:"boostAmount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BoostAmount = float64(s1.BoostAmount)
	return nil
}

// GoogleCloudDialogflowCxV3beta1BoostSpecs: Boost specifications for data
// stores.
type GoogleCloudDialogflowCxV3beta1BoostSpecs struct {
	// DataStores: Optional. Data Stores where the boosting configuration is
	// applied. The full names of the referenced data stores. Formats:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}`
	// `projects/{project}/locations/{location}/dataStores/{data_store}
	DataStores []string `json:"dataStores,omitempty"`
	// Spec: Optional. A list of boosting specifications.
	Spec []*GoogleCloudDialogflowCxV3beta1BoostSpec `json:"spec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1BoostSpecs) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1BoostSpecs
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1CalculateCoverageResponse: The response
// message for TestCases.CalculateCoverage.
type GoogleCloudDialogflowCxV3beta1CalculateCoverageResponse struct {
	// Agent: The agent to calculate coverage for. Format:
	// `projects//locations//agents/`.
	Agent string `json:"agent,omitempty"`
	// IntentCoverage: Intent coverage.
	IntentCoverage *GoogleCloudDialogflowCxV3beta1IntentCoverage `json:"intentCoverage,omitempty"`
	// RouteGroupCoverage: Transition route group coverage.
	RouteGroupCoverage *GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage `json:"routeGroupCoverage,omitempty"`
	// TransitionCoverage: Transition (excluding transition route groups) coverage.
	TransitionCoverage *GoogleCloudDialogflowCxV3beta1TransitionCoverage `json:"transitionCoverage,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1CalculateCoverageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CalculateCoverageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Changelog: Changelogs represents a change made
// to a given agent.
type GoogleCloudDialogflowCxV3beta1Changelog struct {
	// Action: The action of the change.
	Action string `json:"action,omitempty"`
	// CreateTime: The timestamp of the change.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: The affected resource display name of the change.
	DisplayName string `json:"displayName,omitempty"`
	// LanguageCode: The affected language code of the change.
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: The unique identifier of the changelog. Format:
	// `projects//locations//agents//changelogs/`.
	Name string `json:"name,omitempty"`
	// Resource: The affected resource name of the change.
	Resource string `json:"resource,omitempty"`
	// Type: The affected resource type.
	Type string `json:"type,omitempty"`
	// UserEmail: Email address of the authenticated user.
	UserEmail string `json:"userEmail,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Changelog) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Changelog
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1CompareVersionsRequest: The request message
// for Versions.CompareVersions.
type GoogleCloudDialogflowCxV3beta1CompareVersionsRequest struct {
	// LanguageCode: The language to compare the flow versions for. If not
	// specified, the agent's default language is used. Many languages
	// (https://cloud.google.com/dialogflow/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `json:"languageCode,omitempty"`
	// TargetVersion: Required. Name of the target flow version to compare with the
	// base version. Use version ID `0` to indicate the draft version of the
	// specified flow. Format: `projects//locations//agents//flows//versions/`.
	TargetVersion string `json:"targetVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1CompareVersionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CompareVersionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1CompareVersionsResponse: The response message
// for Versions.CompareVersions.
type GoogleCloudDialogflowCxV3beta1CompareVersionsResponse struct {
	// BaseVersionContentJson: JSON representation of the base version content.
	BaseVersionContentJson string `json:"baseVersionContentJson,omitempty"`
	// CompareTime: The timestamp when the two version compares.
	CompareTime string `json:"compareTime,omitempty"`
	// TargetVersionContentJson: JSON representation of the target version content.
	TargetVersionContentJson string `json:"targetVersionContentJson,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BaseVersionContentJson") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseVersionContentJson") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1CompareVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CompareVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ContinuousTestResult: Represents a result from
// running a test case in an agent environment.
type GoogleCloudDialogflowCxV3beta1ContinuousTestResult struct {
	// Name: The resource name for the continuous test result. Format:
	// `projects//locations//agents//environments//continuousTestResults/`.
	Name string `json:"name,omitempty"`
	// Result: The result of this continuous test run, i.e. whether all the tests
	// in this continuous test run pass or not.
	//
	// Possible values:
	//   "AGGREGATED_TEST_RESULT_UNSPECIFIED" - Not specified. Should never be
	// used.
	//   "PASSED" - All the tests passed.
	//   "FAILED" - At least one test did not pass.
	Result string `json:"result,omitempty"`
	// RunTime: Time when the continuous testing run starts.
	RunTime string `json:"runTime,omitempty"`
	// TestCaseResults: A list of individual test case results names in this
	// continuous test run.
	TestCaseResults []string `json:"testCaseResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ContinuousTestResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ContinuousTestResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Conversation: Represents a conversation.
type GoogleCloudDialogflowCxV3beta1Conversation struct {
	// Duration: Duration of the conversation.
	Duration string `json:"duration,omitempty"`
	// Environment: Environment of the conversation. Only `name` and `display_name`
	// are filled in this message.
	Environment *GoogleCloudDialogflowCxV3beta1Environment `json:"environment,omitempty"`
	// FlowVersions: Flow versions used in the conversation.
	FlowVersions map[string]string `json:"flowVersions,omitempty"`
	// Flows: All the Flow the conversation has went through. Only `name` and
	// `display_name` are filled in this message.
	Flows []*GoogleCloudDialogflowCxV3beta1Flow `json:"flows,omitempty"`
	// Intents: All the matched Intent in the conversation. Only `name` and
	// `display_name` are filled in this message.
	Intents []*GoogleCloudDialogflowCxV3beta1Intent `json:"intents,omitempty"`
	// Interactions: Interactions of the conversation. Only populated for
	// `GetConversation` and empty for `ListConversations`.
	Interactions []*GoogleCloudDialogflowCxV3beta1ConversationInteraction `json:"interactions,omitempty"`
	// LanguageCode: The language of the conversation, which is the language of the
	// first request in the conversation.
	LanguageCode string `json:"languageCode,omitempty"`
	// Metrics: Conversation metrics.
	Metrics *GoogleCloudDialogflowCxV3beta1ConversationMetrics `json:"metrics,omitempty"`
	// Name: Identifier. The identifier of the conversation. If conversation ID is
	// reused, interactions happened later than 48 hours of the conversation's
	// create time will be ignored. Format:
	// `projects//locations//agents//conversations/`
	Name string `json:"name,omitempty"`
	// Pages: All the Page the conversation has went through. Only `name` and
	// `display_name` are filled in this message.
	Pages []*GoogleCloudDialogflowCxV3beta1Page `json:"pages,omitempty"`
	// StartTime: Start time of the conversation, which is the time of the first
	// request of the conversation.
	StartTime string `json:"startTime,omitempty"`
	// Type: The type of the conversation.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Not specified. This value should never be used.
	//   "AUDIO" - Audio conversation. A conversation is classified as an audio
	// conversation if any request has STT input audio or any response has TTS
	// output audio.
	//   "TEXT" - Text conversation. A conversation is classified as a text
	// conversation if any request has text input and no request has STT input
	// audio and no response has TTS output audio.
	//   "UNDETERMINED" - Default conversation type for a conversation. A
	// conversation is classified as undetermined if none of the requests contain
	// text or audio input (eg. event or intent input).
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Duration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Conversation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Conversation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationInteraction: Represents an
// interaction between an end user and a Dialogflow CX agent using V3
// (Streaming)DetectIntent API, or an interaction between an end user and a
// Dialogflow CX agent using V2 (Streaming)AnalyzeContent API.
type GoogleCloudDialogflowCxV3beta1ConversationInteraction struct {
	// AnswerFeedback: Answer feedback for the final response.
	AnswerFeedback *GoogleCloudDialogflowCxV3beta1AnswerFeedback `json:"answerFeedback,omitempty"`
	// CreateTime: The time that the interaction was created.
	CreateTime string `json:"createTime,omitempty"`
	// MissingTransition: Missing transition predicted for the interaction. This
	// field is set only if the interaction match type was no-match.
	MissingTransition *GoogleCloudDialogflowCxV3beta1ConversationInteractionMissingTransition `json:"missingTransition,omitempty"`
	// PartialResponses: The partial responses of the interaction. Empty if there
	// is no partial response in the interaction. See the partial response
	// documentation.
	PartialResponses []*GoogleCloudDialogflowCxV3beta1DetectIntentResponse `json:"partialResponses,omitempty"`
	// Request: The request of the interaction.
	Request *GoogleCloudDialogflowCxV3beta1DetectIntentRequest `json:"request,omitempty"`
	// RequestUtterances: The input text or the transcript of the input audio in
	// the request.
	RequestUtterances string `json:"requestUtterances,omitempty"`
	// Response: The final response of the interaction.
	Response *GoogleCloudDialogflowCxV3beta1DetectIntentResponse `json:"response,omitempty"`
	// ResponseUtterances: The output text or the transcript of the output audio in
	// the responses. If multiple output messages are returned, they will be
	// concatenated into one.
	ResponseUtterances string `json:"responseUtterances,omitempty"`
	// StepMetrics: Metrics associated with different processing steps. Names and
	// number of steps depend on the request and can change without a notice.
	StepMetrics []*GoogleCloudDialogflowCxV3beta1ConversationInteractionStepMetrics `json:"stepMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerFeedback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerFeedback") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationInteraction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationInteraction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationInteractionMissingTransition:
// Information collected for DF CX agents in case NLU predicted an intent that
// was filtered out as being inactive which may indicate a missing transition
// and/or absent functionality.
type GoogleCloudDialogflowCxV3beta1ConversationInteractionMissingTransition struct {
	// IntentDisplayName: Name of the intent that could have triggered.
	IntentDisplayName string `json:"intentDisplayName,omitempty"`
	// Score: Score of the above intent. The higher it is the more likely a
	// transition was missed on a given page.
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentDisplayName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationInteractionMissingTransition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationInteractionMissingTransition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1ConversationInteractionMissingTransition) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationInteractionMissingTransition
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowCxV3beta1ConversationInteractionStepMetrics: Metrics of
// each processing step.
type GoogleCloudDialogflowCxV3beta1ConversationInteractionStepMetrics struct {
	// Latency: Processing latency of the step.
	Latency string `json:"latency,omitempty"`
	// Name: Name of the request processing step.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Latency") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Latency") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationInteractionStepMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationInteractionStepMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationMetrics: Represents metrics for
// the conversation.
type GoogleCloudDialogflowCxV3beta1ConversationMetrics struct {
	// AverageMatchConfidence: The average confidence all of the Match in the
	// conversation. Values range from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	AverageMatchConfidence float64 `json:"averageMatchConfidence,omitempty"`
	// HasEndInteraction: A signal that indicates the interaction with the
	// Dialogflow agent has ended. If any response has the
	// ResponseMessage.end_interaction signal, this is set to true.
	HasEndInteraction bool `json:"hasEndInteraction,omitempty"`
	// HasLiveAgentHandoff: Hands off conversation to a human agent. If any
	// response has the ResponseMessage.live_agent_handoffsignal, this is set to
	// true.
	HasLiveAgentHandoff bool `json:"hasLiveAgentHandoff,omitempty"`
	// InputAudioDuration: Duration of all the input's audio in the conversation.
	InputAudioDuration string `json:"inputAudioDuration,omitempty"`
	// InteractionCount: The number of interactions in the conversation.
	InteractionCount int64 `json:"interactionCount,omitempty"`
	// MatchTypeCount: Match type counts.
	MatchTypeCount *GoogleCloudDialogflowCxV3beta1ConversationMetricsMatchTypeCount `json:"matchTypeCount,omitempty"`
	// MaxWebhookLatency: Maximum latency of the Webhook calls in the conversation.
	MaxWebhookLatency string `json:"maxWebhookLatency,omitempty"`
	// OutputAudioDuration: Duration of all the output's audio in the conversation.
	OutputAudioDuration string `json:"outputAudioDuration,omitempty"`
	// QueryInputCount: Query input counts.
	QueryInputCount *GoogleCloudDialogflowCxV3beta1ConversationMetricsQueryInputCount `json:"queryInputCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageMatchConfidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageMatchConfidence") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1ConversationMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationMetrics
	var s1 struct {
		AverageMatchConfidence gensupport.JSONFloat64 `json:"averageMatchConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageMatchConfidence = float64(s1.AverageMatchConfidence)
	return nil
}

// GoogleCloudDialogflowCxV3beta1ConversationMetricsMatchTypeCount: Count by
// Match.MatchType of the matches in the conversation.
type GoogleCloudDialogflowCxV3beta1ConversationMetricsMatchTypeCount struct {
	// DirectIntentCount: The number of matches with type
	// Match.MatchType.DIRECT_INTENT.
	DirectIntentCount int64 `json:"directIntentCount,omitempty"`
	// EventCount: The number of matches with type Match.MatchType.EVENT.
	EventCount int64 `json:"eventCount,omitempty"`
	// IntentCount: The number of matches with type Match.MatchType.INTENT.
	IntentCount int64 `json:"intentCount,omitempty"`
	// NoInputCount: The number of matches with type Match.MatchType.NO_INPUT.
	NoInputCount int64 `json:"noInputCount,omitempty"`
	// NoMatchCount: The number of matches with type Match.MatchType.NO_MATCH.
	NoMatchCount int64 `json:"noMatchCount,omitempty"`
	// ParameterFillingCount: The number of matches with type
	// Match.MatchType.PARAMETER_FILLING.
	ParameterFillingCount int64 `json:"parameterFillingCount,omitempty"`
	// UnspecifiedCount: The number of matches with type
	// Match.MatchType.MATCH_TYPE_UNSPECIFIED.
	UnspecifiedCount int64 `json:"unspecifiedCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DirectIntentCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DirectIntentCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationMetricsMatchTypeCount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationMetricsMatchTypeCount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationMetricsQueryInputCount: Count by
// types of QueryInput of the requests in the conversation.
type GoogleCloudDialogflowCxV3beta1ConversationMetricsQueryInputCount struct {
	// AudioCount: The number of AudioInput in the conversation.
	AudioCount int64 `json:"audioCount,omitempty"`
	// DtmfCount: The number of DtmfInput in the conversation.
	DtmfCount int64 `json:"dtmfCount,omitempty"`
	// EventCount: The number of EventInput in the conversation.
	EventCount int64 `json:"eventCount,omitempty"`
	// IntentCount: The number of IntentInput in the conversation.
	IntentCount int64 `json:"intentCount,omitempty"`
	// TextCount: The number of TextInput in the conversation.
	TextCount int64 `json:"textCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationMetricsQueryInputCount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationMetricsQueryInputCount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationSignals: This message is used to
// hold all the Conversation Signals data, which will be converted to JSON and
// exported to BigQuery.
type GoogleCloudDialogflowCxV3beta1ConversationSignals struct {
	// TurnSignals: Required. Turn signals for the current turn.
	TurnSignals *GoogleCloudDialogflowCxV3beta1TurnSignals `json:"turnSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TurnSignals") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TurnSignals") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationTurn: One interaction between a
// human and virtual agent. The human provides some input and the virtual agent
// provides a response.
type GoogleCloudDialogflowCxV3beta1ConversationTurn struct {
	// UserInput: The user input.
	UserInput *GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput `json:"userInput,omitempty"`
	// VirtualAgentOutput: The virtual agent output.
	VirtualAgentOutput *GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput `json:"virtualAgentOutput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserInput") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserInput") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurn) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput: The input from the
// human user.
type GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput struct {
	// EnableSentimentAnalysis: Whether sentiment analysis is enabled.
	EnableSentimentAnalysis bool `json:"enableSentimentAnalysis,omitempty"`
	// InjectedParameters: Parameters that need to be injected into the
	// conversation during intent detection.
	InjectedParameters googleapi.RawMessage `json:"injectedParameters,omitempty"`
	// Input: Supports text input, event input, dtmf input in the test case.
	Input *GoogleCloudDialogflowCxV3beta1QueryInput `json:"input,omitempty"`
	// IsWebhookEnabled: If webhooks should be allowed to trigger in response to
	// the user utterance. Often if parameters are injected, webhooks should not be
	// enabled.
	IsWebhookEnabled bool `json:"isWebhookEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSentimentAnalysis") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput: The output
// from the virtual agent.
type GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput struct {
	// CurrentPage: The Page on which the utterance was spoken. Only name and
	// displayName will be set.
	CurrentPage *GoogleCloudDialogflowCxV3beta1Page `json:"currentPage,omitempty"`
	// DiagnosticInfo: Required. Input only. The diagnostic info output for the
	// turn. Required to calculate the testing coverage.
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`
	// Differences: Output only. If this is part of a result conversation turn, the
	// list of differences between the original run and the replay for this output,
	// if any.
	Differences []*GoogleCloudDialogflowCxV3beta1TestRunDifference `json:"differences,omitempty"`
	// SessionParameters: The session parameters available to the bot at this
	// point.
	SessionParameters googleapi.RawMessage `json:"sessionParameters,omitempty"`
	// Status: Response error from the agent in the test result. If set, other
	// output is empty.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TextResponses: The text responses from the agent for the turn.
	TextResponses []*GoogleCloudDialogflowCxV3beta1ResponseMessageText `json:"textResponses,omitempty"`
	// TriggeredIntent: The Intent that triggered the response. Only name and
	// displayName will be set.
	TriggeredIntent *GoogleCloudDialogflowCxV3beta1Intent `json:"triggeredIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata: Metadata
// associated with the long running operation for Versions.CreateVersion.
type GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata struct {
	// Version: Name of the created version. Format:
	// `projects//locations//agents//flows//versions/`.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DataStoreConnection: A data store connection.
// It represents a data store in Discovery Engine and the type of the contents
// it contains.
type GoogleCloudDialogflowCxV3beta1DataStoreConnection struct {
	// DataStore: The full name of the referenced data store. Formats:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}`
	// `projects/{project}/locations/{location}/dataStores/{data_store}`
	DataStore string `json:"dataStore,omitempty"`
	// DataStoreType: The type of the connected data store.
	//
	// Possible values:
	//   "DATA_STORE_TYPE_UNSPECIFIED" - Not specified. This value indicates that
	// the data store type is not specified, so it will not be used during search.
	//   "PUBLIC_WEB" - A data store that contains public web content.
	//   "UNSTRUCTURED" - A data store that contains unstructured private data.
	//   "STRUCTURED" - A data store that contains structured data (for example
	// FAQ).
	DataStoreType string `json:"dataStoreType,omitempty"`
	// DocumentProcessingMode: The document processing mode for the data store
	// connection. Should only be set for PUBLIC_WEB and UNSTRUCTURED data stores.
	// If not set it is considered as DOCUMENTS, as this is the legacy mode.
	//
	// Possible values:
	//   "DOCUMENT_PROCESSING_MODE_UNSPECIFIED" - Not specified. This should be set
	// for STRUCTURED type data stores. Due to legacy reasons this is considered as
	// DOCUMENTS for STRUCTURED and PUBLIC_WEB data stores.
	//   "DOCUMENTS" - Documents are processed as documents.
	//   "CHUNKS" - Documents are converted to chunks.
	DocumentProcessingMode string `json:"documentProcessingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignals: Data store
// connection feature output signals. Might be only partially field if
// processing stop before the final answer. Reasons for this can be, but are
// not limited to: empty UCS search results, positive RAI check outcome,
// grounding failure, ...
type GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignals struct {
	// Answer: Optional. The final compiled answer.
	Answer string `json:"answer,omitempty"`
	// AnswerGenerationModelCallSignals: Optional. Diagnostic info related to the
	// answer generation model call.
	AnswerGenerationModelCallSignals *GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsAnswerGenerationModelCallSignals `json:"answerGenerationModelCallSignals,omitempty"`
	// AnswerParts: Optional. Answer parts with relevant citations. Concatenation
	// of texts should add up the `answer` (not counting whitespaces).
	AnswerParts []*GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsAnswerPart `json:"answerParts,omitempty"`
	// CitedSnippets: Optional. Snippets cited by the answer generation model from
	// the most to least relevant.
	CitedSnippets []*GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsCitedSnippet `json:"citedSnippets,omitempty"`
	// GroundingSignals: Optional. Grounding signals.
	GroundingSignals *GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsGroundingSignals `json:"groundingSignals,omitempty"`
	// RewriterModelCallSignals: Optional. Diagnostic info related to the rewriter
	// model call.
	RewriterModelCallSignals *GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsRewriterModelCallSignals `json:"rewriterModelCallSignals,omitempty"`
	// RewrittenQuery: Optional. Rewritten string query used for search.
	RewrittenQuery string `json:"rewrittenQuery,omitempty"`
	// SafetySignals: Optional. Safety check result.
	SafetySignals *GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsSafetySignals `json:"safetySignals,omitempty"`
	// SearchSnippets: Optional. Search snippets included in the answer generation
	// prompt.
	SearchSnippets []*GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsSearchSnippet `json:"searchSnippets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsAnswerGenerationModel
// CallSignals: Diagnostic info related to the answer generation model call.
type GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsAnswerGenerationModelCallSignals struct {
	// Model: Name of the generative model. For example, "gemini-ultra",
	// "gemini-pro", "gemini-1.5-flash" etc. Defaults to "Other" if the model is
	// unknown.
	Model string `json:"model,omitempty"`
	// ModelOutput: Output of the generative model.
	ModelOutput string `json:"modelOutput,omitempty"`
	// RenderedPrompt: Prompt as sent to the model.
	RenderedPrompt string `json:"renderedPrompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsAnswerGenerationModelCallSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsAnswerGenerationModelCallSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsAnswerPart: Answer
// part with citation.
type GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsAnswerPart struct {
	// SupportingIndices: Citations for this answer part. Indices of
	// `search_snippets`.
	SupportingIndices []int64 `json:"supportingIndices,omitempty"`
	// Text: Substring of the answer.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SupportingIndices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SupportingIndices") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsAnswerPart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsAnswerPart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsCitedSnippet:
// Snippet cited by the answer generation model.
type GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsCitedSnippet struct {
	// SearchSnippet: Details of the snippet.
	SearchSnippet *GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsSearchSnippet `json:"searchSnippet,omitempty"`
	// SnippetIndex: Index of the snippet in `search_snippets` field.
	SnippetIndex int64 `json:"snippetIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SearchSnippet") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SearchSnippet") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsCitedSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsCitedSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsGroundingSignals:
// Grounding signals.
type GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsGroundingSignals struct {
	// Decision: Represents the decision of the grounding check.
	//
	// Possible values:
	//   "GROUNDING_DECISION_UNSPECIFIED" - Decision not specified.
	//   "ACCEPTED_BY_GROUNDING" - Grounding have accepted the answer.
	//   "REJECTED_BY_GROUNDING" - Grounding have rejected the answer.
	Decision string `json:"decision,omitempty"`
	// Score: Grounding score bucket setting.
	//
	// Possible values:
	//   "GROUNDING_SCORE_BUCKET_UNSPECIFIED" - Score not specified.
	//   "VERY_LOW" - We have very low confidence that the answer is grounded.
	//   "LOW" - We have low confidence that the answer is grounded.
	//   "MEDIUM" - We have medium confidence that the answer is grounded.
	//   "HIGH" - We have high confidence that the answer is grounded.
	//   "VERY_HIGH" - We have very high confidence that the answer is grounded.
	Score string `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Decision") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Decision") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsGroundingSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsGroundingSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsRewriterModelCallSign
// als: Diagnostic info related to the rewriter model call.
type GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsRewriterModelCallSignals struct {
	// Model: Name of the generative model. For example, "gemini-ultra",
	// "gemini-pro", "gemini-1.5-flash" etc. Defaults to "Other" if the model is
	// unknown.
	Model string `json:"model,omitempty"`
	// ModelOutput: Output of the generative model.
	ModelOutput string `json:"modelOutput,omitempty"`
	// RenderedPrompt: Prompt as sent to the model.
	RenderedPrompt string `json:"renderedPrompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsRewriterModelCallSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsRewriterModelCallSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsSafetySignals:
// Safety check results.
type GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsSafetySignals struct {
	// BannedPhraseMatch: Specifies banned phrase match subject.
	//
	// Possible values:
	//   "BANNED_PHRASE_MATCH_UNSPECIFIED" - No banned phrase check was executed.
	//   "BANNED_PHRASE_MATCH_NONE" - All banned phrase checks led to no match.
	//   "BANNED_PHRASE_MATCH_QUERY" - A banned phrase matched the query.
	//   "BANNED_PHRASE_MATCH_RESPONSE" - A banned phrase matched the response.
	BannedPhraseMatch string `json:"bannedPhraseMatch,omitempty"`
	// Decision: Safety decision.
	//
	// Possible values:
	//   "SAFETY_DECISION_UNSPECIFIED" - Decision not specified.
	//   "ACCEPTED_BY_SAFETY_CHECK" - No manual or automatic safety check fired.
	//   "REJECTED_BY_SAFETY_CHECK" - One ore more safety checks fired.
	Decision string `json:"decision,omitempty"`
	// MatchedBannedPhrase: The matched banned phrase if there was a match.
	MatchedBannedPhrase string `json:"matchedBannedPhrase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BannedPhraseMatch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BannedPhraseMatch") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsSafetySignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsSafetySignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsSearchSnippet:
// Search snippet details.
type GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsSearchSnippet struct {
	// DocumentTitle: Title of the enclosing document.
	DocumentTitle string `json:"documentTitle,omitempty"`
	// DocumentUri: Uri for the document. Present if specified for the document.
	DocumentUri string `json:"documentUri,omitempty"`
	// Text: Text included in the prompt.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DocumentTitle") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DocumentTitle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsSearchSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignalsSearchSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DeployFlowMetadata: Metadata returned for the
// Environments.DeployFlow long running operation.
type GoogleCloudDialogflowCxV3beta1DeployFlowMetadata struct {
	// TestErrors: Errors of running deployment tests.
	TestErrors []*GoogleCloudDialogflowCxV3beta1TestError `json:"testErrors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TestErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TestErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DeployFlowMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DeployFlowRequest: The request message for
// Environments.DeployFlow.
type GoogleCloudDialogflowCxV3beta1DeployFlowRequest struct {
	// FlowVersion: Required. The flow version to deploy. Format:
	// `projects//locations//agents//flows//versions/`.
	FlowVersion string `json:"flowVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DeployFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DeployFlowResponse: The response message for
// Environments.DeployFlow.
type GoogleCloudDialogflowCxV3beta1DeployFlowResponse struct {
	// Deployment: The name of the flow version deployment. Format:
	// `projects//locations//agents//environments//deployments/`.
	Deployment string `json:"deployment,omitempty"`
	// Environment: The updated environment where the flow is deployed.
	Environment *GoogleCloudDialogflowCxV3beta1Environment `json:"environment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deployment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DeployFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeployFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Deployment: Represents a deployment in an
// environment. A deployment happens when a flow version configured to be
// active in the environment. You can configure running pre-deployment steps,
// e.g. running validation test cases, experiment auto-rollout, etc.
type GoogleCloudDialogflowCxV3beta1Deployment struct {
	// EndTime: End time of this deployment.
	EndTime string `json:"endTime,omitempty"`
	// FlowVersion: The name of the flow version for this deployment. Format:
	// projects//locations//agents//flows//versions/.
	FlowVersion string `json:"flowVersion,omitempty"`
	// Name: The name of the deployment. Format:
	// projects//locations//agents//environments//deployments/.
	Name string `json:"name,omitempty"`
	// Result: Result of the deployment.
	Result *GoogleCloudDialogflowCxV3beta1DeploymentResult `json:"result,omitempty"`
	// StartTime: Start time of this deployment.
	StartTime string `json:"startTime,omitempty"`
	// State: The current state of the deployment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "RUNNING" - The deployment is running.
	//   "SUCCEEDED" - The deployment succeeded.
	//   "FAILED" - The deployment failed.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Deployment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Deployment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DeploymentResult: Result of the deployment.
type GoogleCloudDialogflowCxV3beta1DeploymentResult struct {
	// DeploymentTestResults: Results of test cases running before the deployment.
	// Format: `projects//locations//agents//testCases//results/`.
	DeploymentTestResults []string `json:"deploymentTestResults,omitempty"`
	// Experiment: The name of the experiment triggered by this deployment. Format:
	// projects//locations//agents//environments//experiments/.
	Experiment string `json:"experiment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeploymentTestResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeploymentTestResults") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DeploymentResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DeploymentResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DetectIntentRequest: The request to detect
// user's intent.
type GoogleCloudDialogflowCxV3beta1DetectIntentRequest struct {
	// OutputAudioConfig: Instructs the speech synthesizer how to generate the
	// output audio.
	OutputAudioConfig *GoogleCloudDialogflowCxV3beta1OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	// QueryInput: Required. The input specification.
	QueryInput *GoogleCloudDialogflowCxV3beta1QueryInput `json:"queryInput,omitempty"`
	// QueryParams: The parameters of this query.
	QueryParams *GoogleCloudDialogflowCxV3beta1QueryParameters `json:"queryParams,omitempty"`
	// Session: Required. The name of the session this query is sent to. Format:
	// `projects//locations//agents//sessions/` or
	// `projects//locations//agents//environments//sessions/`. If `Environment ID`
	// is not specified, we assume default 'draft' environment. It's up to the API
	// caller to choose an appropriate `Session ID`. It can be a random number or
	// some type of session identifiers (preferably hashed). The length of the
	// `Session ID` must not exceed 36 characters. For more information, see the
	// sessions guide
	// (https://cloud.google.com/dialogflow/cx/docs/concept/session). Note: Always
	// use agent versions for production traffic. See Versions and environments
	// (https://cloud.google.com/dialogflow/cx/docs/concept/version).
	Session string `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputAudioConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputAudioConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DetectIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DetectIntentResponse: The message returned
// from the DetectIntent method.
type GoogleCloudDialogflowCxV3beta1DetectIntentResponse struct {
	// AllowCancellation: Indicates whether the partial response can be cancelled
	// when a later response arrives. e.g. if the agent specified some music as
	// partial response, it can be cancelled.
	AllowCancellation bool `json:"allowCancellation,omitempty"`
	// OutputAudio: The audio data bytes encoded as specified in the request. Note:
	// The output audio is generated based on the values of default platform text
	// responses found in the `query_result.response_messages` field. If multiple
	// default text responses exist, they will be concatenated when generating
	// audio. If no default platform text responses exist, the generated audio
	// content will be empty. In some scenarios, multiple output audio fields may
	// be present in the response structure. In these cases, only the
	// top-most-level audio output has content.
	OutputAudio string `json:"outputAudio,omitempty"`
	// OutputAudioConfig: The config used by the speech synthesizer to generate the
	// output audio.
	OutputAudioConfig *GoogleCloudDialogflowCxV3beta1OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	// QueryResult: The result of the conversational query.
	QueryResult *GoogleCloudDialogflowCxV3beta1QueryResult `json:"queryResult,omitempty"`
	// ResponseId: Output only. The unique identifier of the response. It can be
	// used to locate a response in the training example set or for reporting
	// issues.
	ResponseId string `json:"responseId,omitempty"`
	// ResponseType: Response type.
	//
	// Possible values:
	//   "RESPONSE_TYPE_UNSPECIFIED" - Not specified. This should never happen.
	//   "PARTIAL" - Partial response. e.g. Aggregated responses in a Fulfillment
	// that enables `return_partial_response` can be returned as partial response.
	// WARNING: partial response is not eligible for barge-in.
	//   "FINAL" - Final response.
	ResponseType string `json:"responseType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AllowCancellation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowCancellation") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DetectIntentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DetectIntentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1DtmfInput: Represents the input for dtmf
// event.
type GoogleCloudDialogflowCxV3beta1DtmfInput struct {
	// Digits: The dtmf digits.
	Digits string `json:"digits,omitempty"`
	// FinishDigit: The finish digit (if any).
	FinishDigit string `json:"finishDigit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Digits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Digits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1DtmfInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1DtmfInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EntityType: Entities are extracted from user
// input and represent parameters that are meaningful to your application. For
// example, a date range, a proper name such as a geographic location or
// landmark, and so on. Entities represent actionable data for your
// application. When you define an entity, you can also include synonyms that
// all map to that entity. For example, "soft drink", "soda", "pop", and so on.
// There are three types of entities: * **System** - entities that are defined
// by the Dialogflow API for common data types such as date, time, currency,
// and so on. A system entity is represented by the `EntityType` type. *
// **Custom** - entities that are defined by you that represent actionable data
// that is meaningful to your application. For example, you could define a
// `pizza.sauce` entity for red or white pizza sauce, a `pizza.cheese` entity
// for the different types of cheese on a pizza, a `pizza.topping` entity for
// different toppings, and so on. A custom entity is represented by the
// `EntityType` type. * **User** - entities that are built for an individual
// user such as favorites, preferences, playlists, and so on. A user entity is
// represented by the SessionEntityType type. For more information about entity
// types, see the Dialogflow documentation
// (https://cloud.google.com/dialogflow/docs/entities-overview).
type GoogleCloudDialogflowCxV3beta1EntityType struct {
	// AutoExpansionMode: Indicates whether the entity type can be automatically
	// expanded.
	//
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED" - Auto expansion disabled for the
	// entity.
	//   "AUTO_EXPANSION_MODE_DEFAULT" - Allows an agent to recognize values that
	// have not been explicitly listed in the entity.
	AutoExpansionMode string `json:"autoExpansionMode,omitempty"`
	// DisplayName: Required. The human-readable name of the entity type, unique
	// within the agent.
	DisplayName string `json:"displayName,omitempty"`
	// EnableFuzzyExtraction: Enables fuzzy entity extraction during
	// classification.
	EnableFuzzyExtraction bool `json:"enableFuzzyExtraction,omitempty"`
	// Entities: The collection of entity entries associated with the entity type.
	Entities []*GoogleCloudDialogflowCxV3beta1EntityTypeEntity `json:"entities,omitempty"`
	// ExcludedPhrases: Collection of exceptional words and phrases that shouldn't
	// be matched. For example, if you have a size entity type with entry
	// `giant`(an adjective), you might consider adding `giants`(a noun) as an
	// exclusion. If the kind of entity type is `KIND_MAP`, then the phrases
	// specified by entities and excluded phrases should be mutually exclusive.
	ExcludedPhrases []*GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhrase `json:"excludedPhrases,omitempty"`
	// Kind: Required. Indicates the kind of entity type.
	//
	// Possible values:
	//   "KIND_UNSPECIFIED" - Not specified. This value should be never used.
	//   "KIND_MAP" - Map entity types allow mapping of a group of synonyms to a
	// canonical value.
	//   "KIND_LIST" - List entity types contain a set of entries that do not map
	// to canonical values. However, list entity types can contain references to
	// other entity types (with or without aliases).
	//   "KIND_REGEXP" - Regexp entity types allow to specify regular expressions
	// in entries values.
	Kind string `json:"kind,omitempty"`
	// Name: The unique identifier of the entity type. Required for
	// EntityTypes.UpdateEntityType. Format:
	// `projects//locations//agents//entityTypes/`.
	Name string `json:"name,omitempty"`
	// Redact: Indicates whether parameters of the entity type should be redacted
	// in log. If redaction is enabled, page parameters and intent parameters
	// referring to the entity type will be replaced by parameter name during
	// logging.
	Redact bool `json:"redact,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoExpansionMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EntityTypeEntity: An **entity entry** for an
// associated entity type.
type GoogleCloudDialogflowCxV3beta1EntityTypeEntity struct {
	// Synonyms: Required. A collection of value synonyms. For example, if the
	// entity type is *vegetable*, and `value` is *scallions*, a synonym could be
	// *green onions*. For `KIND_LIST` entity types: * This collection must contain
	// exactly one synonym equal to `value`.
	Synonyms []string `json:"synonyms,omitempty"`
	// Value: Required. The primary value associated with this entity entry. For
	// example, if the entity type is *vegetable*, the value could be *scallions*.
	// For `KIND_MAP` entity types: * A canonical value to be used in place of
	// synonyms. For `KIND_LIST` entity types: * A string that can contain
	// references to other entity types (with or without aliases).
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EntityTypeEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhrase: An excluded entity
// phrase that should not be matched.
type GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhrase struct {
	// Value: Required. The word or phrase to be excluded.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Environment: Represents an environment for an
// agent. You can create multiple versions of your agent and publish them to
// separate environments. When you edit an agent, you are editing the draft
// agent. At any point, you can save the draft agent as an agent version, which
// is an immutable snapshot of your agent. When you save the draft agent, it is
// published to the default environment. When you create agent versions, you
// can publish them to custom environments. You can create a variety of custom
// environments for testing, development, production, etc.
type GoogleCloudDialogflowCxV3beta1Environment struct {
	// Description: The human-readable description of the environment. The maximum
	// length is 500 characters. If exceeded, the request is rejected.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the environment (unique in
	// an agent). Limit of 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: The name of the environment. Format:
	// `projects//locations//agents//environments/`.
	Name string `json:"name,omitempty"`
	// TestCasesConfig: The test cases config for continuous tests of this
	// environment.
	TestCasesConfig *GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig `json:"testCasesConfig,omitempty"`
	// UpdateTime: Output only. Update time of this environment.
	UpdateTime string `json:"updateTime,omitempty"`
	// VersionConfigs: A list of configurations for flow versions. You should
	// include version configs for all flows that are reachable from `Start Flow`
	// in the agent. Otherwise, an error will be returned.
	VersionConfigs []*GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig `json:"versionConfigs,omitempty"`
	// WebhookConfig: The webhook configuration for this environment.
	WebhookConfig *GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig `json:"webhookConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Environment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig: The configuration
// for continuous tests.
type GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig struct {
	// EnableContinuousRun: Whether to run test cases in TestCasesConfig.test_cases
	// periodically. Default false. If set to true, run once a day.
	EnableContinuousRun bool `json:"enableContinuousRun,omitempty"`
	// EnablePredeploymentRun: Whether to run test cases in
	// TestCasesConfig.test_cases before deploying a flow version to the
	// environment. Default false.
	EnablePredeploymentRun bool `json:"enablePredeploymentRun,omitempty"`
	// TestCases: A list of test case names to run. They should be under the same
	// agent. Format of each test case name:
	// `projects//locations//agents//testCases/`
	TestCases []string `json:"testCases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableContinuousRun") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableContinuousRun") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig: Configuration for
// the version.
type GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig struct {
	// Version: Required. Flow, playbook and tool versions are supported. Format
	// for flow version: projects//locations//agents//flows//versions/. Format for
	// playbook version: projects//locations//agents//playbooks//versions/. Format
	// for tool version: projects//locations//agents//tools//versions/.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Version") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Version") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig: Configuration for
// webhooks.
type GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig struct {
	// WebhookOverrides: The list of webhooks to override for the agent
	// environment. The webhook must exist in the agent. You can override fields in
	// `generic_web_service` and `service_directory`.
	WebhookOverrides []*GoogleCloudDialogflowCxV3beta1Webhook `json:"webhookOverrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WebhookOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WebhookOverrides") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Event: Event represents the event sent by the
// customer.
type GoogleCloudDialogflowCxV3beta1Event struct {
	// Event: Required. Name of the event.
	Event string `json:"event,omitempty"`
	// Text: Optional. Unstructured text payload of the event.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Event) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Event
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EventHandler: An event handler specifies an
// event that can be handled during a session. When the specified event
// happens, the following actions are taken in order: * If there is a
// `trigger_fulfillment` associated with the event, it will be called. * If
// there is a `target_page` associated with the event, the session will
// transition into the specified page. * If there is a `target_flow` associated
// with the event, the session will transition into the specified flow.
type GoogleCloudDialogflowCxV3beta1EventHandler struct {
	// Event: Required. The name of the event to handle.
	Event string `json:"event,omitempty"`
	// Name: Output only. The unique identifier of this event handler.
	Name string `json:"name,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TargetPlaybook: The target playbook to transition to. Format:
	// `projects//locations//agents//playbooks/`.
	TargetPlaybook string `json:"targetPlaybook,omitempty"`
	// TriggerFulfillment: The fulfillment to call when the event occurs. Handling
	// webhook errors with a fulfillment enabled with webhook could cause infinite
	// loop. It is invalid to specify such fulfillment for a handler handling
	// webhooks.
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EventHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1EventInput: Represents the event to trigger.
type GoogleCloudDialogflowCxV3beta1EventInput struct {
	// Event: Name of the event.
	Event string `json:"event,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Event") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Event") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Example: Example represents a sample execution
// of the playbook in the conversation. An example consists of a list of
// ordered actions performed by end user or Dialogflow agent according the
// playbook instructions to fulfill the task.
type GoogleCloudDialogflowCxV3beta1Example struct {
	// Actions: Required. The ordered list of actions performed by the end user and
	// the Dialogflow agent.
	Actions []*GoogleCloudDialogflowCxV3beta1Action `json:"actions,omitempty"`
	// ConversationState: Required. Example's output state.
	//
	// Possible values:
	//   "OUTPUT_STATE_UNSPECIFIED" - Unspecified output.
	//   "OUTPUT_STATE_OK" - Succeeded.
	//   "OUTPUT_STATE_CANCELLED" - Cancelled.
	//   "OUTPUT_STATE_FAILED" - Failed.
	//   "OUTPUT_STATE_ESCALATED" - Escalated.
	//   "OUTPUT_STATE_PENDING" - Pending.
	ConversationState string `json:"conversationState,omitempty"`
	// CreateTime: Output only. The timestamp of initial example creation.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. The high level concise description of the example.
	// The max number of characters is 200.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The display name of the example.
	DisplayName string `json:"displayName,omitempty"`
	// LanguageCode: Optional. The language code of the example. If not specified,
	// the agent's default language is used. Note: languages must be enabled in the
	// agent before they can be used. Note: example's language code is not
	// currently used in dialogflow agents.
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: The unique identifier of the playbook example. Format:
	// `projects//locations//agents//playbooks//examples/`.
	Name string `json:"name,omitempty"`
	// PlaybookInput: Optional. The input to the playbook in the example.
	PlaybookInput *GoogleCloudDialogflowCxV3beta1PlaybookInput `json:"playbookInput,omitempty"`
	// PlaybookOutput: Optional. The output of the playbook in the example.
	PlaybookOutput *GoogleCloudDialogflowCxV3beta1PlaybookOutput `json:"playbookOutput,omitempty"`
	// TokenCount: Output only. Estimated number of tokes current example takes
	// when sent to the LLM.
	TokenCount int64 `json:"tokenCount,omitempty,string"`
	// UpdateTime: Output only. Last time the example was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Example) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Example
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExceptionDetail: Exception thrown during the
// execution of an action.
type GoogleCloudDialogflowCxV3beta1ExceptionDetail struct {
	// ErrorMessage: Optional. The error message.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExceptionDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExceptionDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Experiment: Represents an experiment in an
// environment.
type GoogleCloudDialogflowCxV3beta1Experiment struct {
	// CreateTime: Creation time of this experiment.
	CreateTime string `json:"createTime,omitempty"`
	// Definition: The definition of the experiment.
	Definition *GoogleCloudDialogflowCxV3beta1ExperimentDefinition `json:"definition,omitempty"`
	// Description: The human-readable description of the experiment.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the experiment (unique in
	// an environment). Limit of 64 characters.
	DisplayName string `json:"displayName,omitempty"`
	// EndTime: End time of this experiment.
	EndTime string `json:"endTime,omitempty"`
	// ExperimentLength: Maximum number of days to run the experiment. If
	// auto-rollout is not enabled, default value and maximum will be 30 days. If
	// auto-rollout is enabled, default value and maximum will be 6 days.
	ExperimentLength string `json:"experimentLength,omitempty"`
	// LastUpdateTime: Last update time of this experiment.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`
	// Name: The name of the experiment. Format:
	// projects//locations//agents//environments//experiments/.
	Name string `json:"name,omitempty"`
	// Result: Inference result of the experiment.
	Result *GoogleCloudDialogflowCxV3beta1ExperimentResult `json:"result,omitempty"`
	// RolloutConfig: The configuration for auto rollout. If set, there should be
	// exactly two variants in the experiment (control variant being the default
	// version of the flow), the traffic allocation for the non-control variant
	// will gradually increase to 100% when conditions are met, and eventually
	// replace the control variant to become the default version of the flow.
	RolloutConfig *GoogleCloudDialogflowCxV3beta1RolloutConfig `json:"rolloutConfig,omitempty"`
	// RolloutFailureReason: The reason why rollout has failed. Should only be set
	// when state is ROLLOUT_FAILED.
	RolloutFailureReason string `json:"rolloutFailureReason,omitempty"`
	// RolloutState: State of the auto rollout process.
	RolloutState *GoogleCloudDialogflowCxV3beta1RolloutState `json:"rolloutState,omitempty"`
	// StartTime: Start time of this experiment.
	StartTime string `json:"startTime,omitempty"`
	// State: The current state of the experiment. Transition triggered by
	// Experiments.StartExperiment: DRAFT->RUNNING. Transition triggered by
	// Experiments.CancelExperiment: DRAFT->DONE or RUNNING->DONE.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "DRAFT" - The experiment is created but not started yet.
	//   "RUNNING" - The experiment is running.
	//   "DONE" - The experiment is done.
	//   "ROLLOUT_FAILED" - The experiment with auto-rollout enabled has failed.
	State string `json:"state,omitempty"`
	// VariantsHistory: The history of updates to the experiment variants.
	VariantsHistory []*GoogleCloudDialogflowCxV3beta1VariantsHistory `json:"variantsHistory,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Experiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Experiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExperimentDefinition: Definition of the
// experiment.
type GoogleCloudDialogflowCxV3beta1ExperimentDefinition struct {
	// Condition: The condition defines which subset of sessions are selected for
	// this experiment. If not specified, all sessions are eligible. E.g.
	// "query_input.language_code=en" See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	Condition string `json:"condition,omitempty"`
	// VersionVariants: The flow versions as the variants of this experiment.
	VersionVariants *GoogleCloudDialogflowCxV3beta1VersionVariants `json:"versionVariants,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExperimentDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExperimentResult: The inference result which
// includes an objective metric to optimize and the confidence interval.
type GoogleCloudDialogflowCxV3beta1ExperimentResult struct {
	// LastUpdateTime: The last time the experiment's stats data was updated. Will
	// have default value if stats have never been computed for this experiment.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`
	// VersionMetrics: Version variants and metrics.
	VersionMetrics []*GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetrics `json:"versionMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastUpdateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastUpdateTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExperimentResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval: A
// confidence interval is a range of possible values for the experiment
// objective you are trying to measure.
type GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval struct {
	// ConfidenceLevel: The confidence level used to construct the interval, i.e.
	// there is X% chance that the true value is within this interval.
	ConfidenceLevel float64 `json:"confidenceLevel,omitempty"`
	// LowerBound: Lower bound of the interval.
	LowerBound float64 `json:"lowerBound,omitempty"`
	// Ratio: The percent change between an experiment metric's value and the value
	// for its control.
	Ratio float64 `json:"ratio,omitempty"`
	// UpperBound: Upper bound of the interval.
	UpperBound float64 `json:"upperBound,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceLevel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval
	var s1 struct {
		ConfidenceLevel gensupport.JSONFloat64 `json:"confidenceLevel"`
		LowerBound      gensupport.JSONFloat64 `json:"lowerBound"`
		Ratio           gensupport.JSONFloat64 `json:"ratio"`
		UpperBound      gensupport.JSONFloat64 `json:"upperBound"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceLevel = float64(s1.ConfidenceLevel)
	s.LowerBound = float64(s1.LowerBound)
	s.Ratio = float64(s1.Ratio)
	s.UpperBound = float64(s1.UpperBound)
	return nil
}

// GoogleCloudDialogflowCxV3beta1ExperimentResultMetric: Metric and
// corresponding confidence intervals.
type GoogleCloudDialogflowCxV3beta1ExperimentResultMetric struct {
	// ConfidenceInterval: The probability that the treatment is better than all
	// other treatments in the experiment
	ConfidenceInterval *GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceInterval `json:"confidenceInterval,omitempty"`
	// Count: Count value of a metric.
	Count float64 `json:"count,omitempty"`
	// CountType: Count-based metric type. Only one of type or count_type is
	// specified in each Metric.
	//
	// Possible values:
	//   "COUNT_TYPE_UNSPECIFIED" - Count type unspecified.
	//   "TOTAL_NO_MATCH_COUNT" - Total number of occurrences of a 'NO_MATCH'.
	//   "TOTAL_TURN_COUNT" - Total number of turn counts.
	//   "AVERAGE_TURN_COUNT" - Average turn count in a session.
	CountType string `json:"countType,omitempty"`
	// Ratio: Ratio value of a metric.
	Ratio float64 `json:"ratio,omitempty"`
	// Type: Ratio-based metric type. Only one of type or count_type is specified
	// in each Metric.
	//
	// Possible values:
	//   "METRIC_UNSPECIFIED" - Metric unspecified.
	//   "CONTAINED_SESSION_NO_CALLBACK_RATE" - Percentage of contained sessions
	// without user calling back in 24 hours.
	//   "LIVE_AGENT_HANDOFF_RATE" - Percentage of sessions that were handed to a
	// human agent.
	//   "CALLBACK_SESSION_RATE" - Percentage of sessions with the same user
	// calling back.
	//   "ABANDONED_SESSION_RATE" - Percentage of sessions where user hung up.
	//   "SESSION_END_RATE" - Percentage of sessions reached Dialogflow 'END_PAGE'
	// or 'END_SESSION'.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceInterval") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceInterval") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExperimentResultMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResultMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1ExperimentResultMetric) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResultMetric
	var s1 struct {
		Count gensupport.JSONFloat64 `json:"count"`
		Ratio gensupport.JSONFloat64 `json:"ratio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Count = float64(s1.Count)
	s.Ratio = float64(s1.Ratio)
	return nil
}

// GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetrics: Version
// variant and associated metrics.
type GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetrics struct {
	// Metrics: The metrics and corresponding confidence intervals in the inference
	// result.
	Metrics []*GoogleCloudDialogflowCxV3beta1ExperimentResultMetric `json:"metrics,omitempty"`
	// SessionCount: Number of sessions that were allocated to this version.
	SessionCount int64 `json:"sessionCount,omitempty"`
	// Version: The name of the flow Version. Format:
	// `projects//locations//agents//flows//versions/`.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metrics") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportAgentRequest: The request message for
// Agents.ExportAgent.
type GoogleCloudDialogflowCxV3beta1ExportAgentRequest struct {
	// AgentUri: Optional. The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to export the agent to. The
	// format of this URI must be `gs:///`. If left unspecified, the serialized
	// agent is returned inline. Dialogflow performs a write operation for the
	// Cloud Storage object on the caller's behalf, so your request authentication
	// must have write permissions for the object. For more information, see
	// Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	AgentUri string `json:"agentUri,omitempty"`
	// DataFormat: Optional. The data format of the exported agent. If not
	// specified, `BLOB` is assumed.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Unspecified format.
	//   "BLOB" - Agent content will be exported as raw bytes.
	//   "JSON_PACKAGE" - Agent content will be exported in JSON Package format.
	DataFormat string `json:"dataFormat,omitempty"`
	// Environment: Optional. Environment name. If not set, draft environment is
	// assumed. Format: `projects//locations//agents//environments/`.
	Environment string `json:"environment,omitempty"`
	// GitDestination: Optional. The Git branch to export the agent to.
	GitDestination *GoogleCloudDialogflowCxV3beta1ExportAgentRequestGitDestination `json:"gitDestination,omitempty"`
	// IncludeBigqueryExportSettings: Optional. Whether to include BigQuery Export
	// setting.
	IncludeBigqueryExportSettings bool `json:"includeBigqueryExportSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportAgentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportAgentRequestGitDestination: Settings for
// exporting to a git branch.
type GoogleCloudDialogflowCxV3beta1ExportAgentRequestGitDestination struct {
	// CommitMessage: Commit message for the git push.
	CommitMessage string `json:"commitMessage,omitempty"`
	// TrackingBranch: Tracking branch for the git push.
	TrackingBranch string `json:"trackingBranch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommitMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommitMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportAgentRequestGitDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportAgentRequestGitDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportAgentResponse: The response message for
// Agents.ExportAgent.
type GoogleCloudDialogflowCxV3beta1ExportAgentResponse struct {
	// AgentContent: Uncompressed raw byte content for agent. This field is
	// populated if none of `agent_uri` and `git_destination` are specified in
	// ExportAgentRequest.
	AgentContent string `json:"agentContent,omitempty"`
	// AgentUri: The URI to a file containing the exported agent. This field is
	// populated if `agent_uri` is specified in ExportAgentRequest.
	AgentUri string `json:"agentUri,omitempty"`
	// CommitSha: Commit SHA of the git push. This field is populated if
	// `git_destination` is specified in ExportAgentRequest.
	CommitSha string `json:"commitSha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportEntityTypesMetadata: Metadata returned
// for the EntityTypes.ExportEntityTypes long running operation.
type GoogleCloudDialogflowCxV3beta1ExportEntityTypesMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1ExportEntityTypesRequest: The request message
// for EntityTypes.ExportEntityTypes.
type GoogleCloudDialogflowCxV3beta1ExportEntityTypesRequest struct {
	// DataFormat: Optional. The data format of the exported entity types. If not
	// specified, `BLOB` is assumed.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Unspecified format. Treated as `BLOB`.
	//   "BLOB" - EntityTypes will be exported as raw bytes.
	//   "JSON_PACKAGE" - EntityTypes will be exported in JSON Package format.
	DataFormat string `json:"dataFormat,omitempty"`
	// EntityTypes: Required. The name of the entity types to export. Format:
	// `projects//locations//agents//entityTypes/`.
	EntityTypes []string `json:"entityTypes,omitempty"`
	// EntityTypesContentInline: Optional. The option to return the serialized
	// entity types inline.
	EntityTypesContentInline bool `json:"entityTypesContentInline,omitempty"`
	// EntityTypesUri: Optional. The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to export the entity types to.
	// The format of this URI must be `gs:///`. Dialogflow performs a write
	// operation for the Cloud Storage object on the caller's behalf, so your
	// request authentication must have write permissions for the object. For more
	// information, see Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	EntityTypesUri string `json:"entityTypesUri,omitempty"`
	// LanguageCode: Optional. The language to retrieve the entity type for. The
	// following fields are language dependent: * `EntityType.entities.value` *
	// `EntityType.entities.synonyms` * `EntityType.excluded_phrases.value` If not
	// specified, all language dependent fields will be retrieved. Many languages
	// (https://cloud.google.com/dialogflow/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportEntityTypesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportEntityTypesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse: The response
// message for EntityTypes.ExportEntityTypes.
type GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse struct {
	// EntityTypesContent: Uncompressed byte content for entity types. This field
	// is populated only if `entity_types_content_inline` is set to true in
	// ExportEntityTypesRequest.
	EntityTypesContent *GoogleCloudDialogflowCxV3beta1InlineDestination `json:"entityTypesContent,omitempty"`
	// EntityTypesUri: The URI to a file containing the exported entity types. This
	// field is populated only if `entity_types_uri` is specified in
	// ExportEntityTypesRequest.
	EntityTypesUri string `json:"entityTypesUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypesContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypesContent") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportFlowRequest: The request message for
// Flows.ExportFlow.
type GoogleCloudDialogflowCxV3beta1ExportFlowRequest struct {
	// FlowUri: Optional. The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to export the flow to. The
	// format of this URI must be `gs:///`. If left unspecified, the serialized
	// flow is returned inline. Dialogflow performs a write operation for the Cloud
	// Storage object on the caller's behalf, so your request authentication must
	// have write permissions for the object. For more information, see Dialogflow
	// access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	FlowUri string `json:"flowUri,omitempty"`
	// IncludeReferencedFlows: Optional. Whether to export flows referenced by the
	// specified flow.
	IncludeReferencedFlows bool `json:"includeReferencedFlows,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowUri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportFlowRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportFlowResponse: The response message for
// Flows.ExportFlow.
type GoogleCloudDialogflowCxV3beta1ExportFlowResponse struct {
	// FlowContent: Uncompressed raw byte content for flow.
	FlowContent string `json:"flowContent,omitempty"`
	// FlowUri: The URI to a file containing the exported flow. This field is
	// populated only if `flow_uri` is specified in ExportFlowRequest.
	FlowUri string `json:"flowUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportIntentsMetadata: Metadata returned for
// the Intents.ExportIntents long running operation.
type GoogleCloudDialogflowCxV3beta1ExportIntentsMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1ExportIntentsRequest: The request message for
// Intents.ExportIntents.
type GoogleCloudDialogflowCxV3beta1ExportIntentsRequest struct {
	// DataFormat: Optional. The data format of the exported intents. If not
	// specified, `BLOB` is assumed.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Unspecified format. Treated as `BLOB`.
	//   "BLOB" - Intents will be exported as raw bytes.
	//   "JSON" - Intents will be exported in JSON format.
	//   "CSV" - Intents will be exported in CSV format.
	DataFormat string `json:"dataFormat,omitempty"`
	// Intents: Required. The name of the intents to export. Format:
	// `projects//locations//agents//intents/`.
	Intents []string `json:"intents,omitempty"`
	// IntentsContentInline: Optional. The option to return the serialized intents
	// inline.
	IntentsContentInline bool `json:"intentsContentInline,omitempty"`
	// IntentsUri: Optional. The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to export the intents to. The
	// format of this URI must be `gs:///`. Dialogflow performs a write operation
	// for the Cloud Storage object on the caller's behalf, so your request
	// authentication must have write permissions for the object. For more
	// information, see Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	IntentsUri string `json:"intentsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportIntentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportIntentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportIntentsResponse: The response message
// for Intents.ExportIntents.
type GoogleCloudDialogflowCxV3beta1ExportIntentsResponse struct {
	// IntentsContent: Uncompressed byte content for intents. This field is
	// populated only if `intents_content_inline` is set to true in
	// ExportIntentsRequest.
	IntentsContent *GoogleCloudDialogflowCxV3beta1InlineDestination `json:"intentsContent,omitempty"`
	// IntentsUri: The URI to a file containing the exported intents. This field is
	// populated only if `intents_uri` is specified in ExportIntentsRequest.
	IntentsUri string `json:"intentsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentsContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentsContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportPlaybookRequest: The request message for
// Playbooks.ExportPlaybook.
type GoogleCloudDialogflowCxV3beta1ExportPlaybookRequest struct {
	// DataFormat: Optional. The data format of the exported agent. If not
	// specified, `BLOB` is assumed.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Unspecified format.
	//   "BLOB" - Flow content will be exported as raw bytes.
	//   "JSON" - Flow content will be exported in JSON format.
	DataFormat string `json:"dataFormat,omitempty"`
	// PlaybookUri: Optional. The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to export the playbook to. The
	// format of this URI must be `gs:///`. If left unspecified, the serialized
	// playbook is returned inline. Dialogflow performs a write operation for the
	// Cloud Storage object on the caller's behalf, so your request authentication
	// must have write permissions for the object. For more information, see
	// Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	PlaybookUri string `json:"playbookUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportPlaybookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportPlaybookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportTestCasesMetadata: Metadata returned for
// the TestCases.ExportTestCases long running operation. This message currently
// has no fields.
type GoogleCloudDialogflowCxV3beta1ExportTestCasesMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1ExportTestCasesRequest: The request message
// for TestCases.ExportTestCases.
type GoogleCloudDialogflowCxV3beta1ExportTestCasesRequest struct {
	// DataFormat: The data format of the exported test cases. If not specified,
	// `BLOB` is assumed.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Unspecified format.
	//   "BLOB" - Raw bytes.
	//   "JSON" - JSON format.
	DataFormat string `json:"dataFormat,omitempty"`
	// Filter: The filter expression used to filter exported test cases, see API
	// Filtering (https://aip.dev/160). The expression is case insensitive and
	// supports the following syntax: name = [OR name = ] ... For example: * "name
	// = t1 OR name = t2" matches the test case with the exact resource name "t1"
	// or "t2".
	Filter string `json:"filter,omitempty"`
	// GcsUri: The Google Cloud Storage (https://cloud.google.com/storage/docs/)
	// URI to export the test cases to. The format of this URI must be `gs:///`. If
	// unspecified, the serialized test cases is returned inline. Dialogflow
	// performs a write operation for the Cloud Storage object on the caller's
	// behalf, so your request authentication must have write permissions for the
	// object. For more information, see Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportTestCasesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse: The response message
// for TestCases.ExportTestCases.
type GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse struct {
	// Content: Uncompressed raw byte content for test cases.
	Content string `json:"content,omitempty"`
	// GcsUri: The URI to a file containing the exported test cases. This field is
	// populated only if `gcs_uri` is specified in ExportTestCasesRequest.
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ExportToolsRequest: The request message for
// Tools.ExportTools.
type GoogleCloudDialogflowCxV3beta1ExportToolsRequest struct {
	// DataFormat: Optional. The data format of the exported tools. If not
	// specified, `BLOB` is assumed.
	//
	// Possible values:
	//   "DATA_FORMAT_UNSPECIFIED" - Unspecified format. Treated as `BLOB`.
	//   "BLOB" - Tools will be exported as raw bytes.
	DataFormat string `json:"dataFormat,omitempty"`
	// Tools: Required. The name of the tools to export. Format:
	// `projects//locations//agents//tools/`.
	Tools []string `json:"tools,omitempty"`
	// ToolsContentInline: Optional. The option to return the serialized tools
	// inline.
	ToolsContentInline bool `json:"toolsContentInline,omitempty"`
	// ToolsUri: Optional. The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to export the tools to. The
	// format of this URI must be `gs:///`. Dialogflow performs a write operation
	// for the Cloud Storage object on the caller's behalf, so your request
	// authentication must have write permissions for the object. For more
	// information, see Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	ToolsUri string `json:"toolsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ExportToolsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ExportToolsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FilterSpecs: Filter specifications for data
// stores.
type GoogleCloudDialogflowCxV3beta1FilterSpecs struct {
	// DataStores: Optional. Data Stores where the boosting configuration is
	// applied. The full names of the referenced data stores. Formats:
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/
	// {data_store}`
	// `projects/{project}/locations/{location}/dataStores/{data_store}
	DataStores []string `json:"dataStores,omitempty"`
	// Filter: Optional. The filter expression to be applied. Expression syntax is
	// documented at
	// https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax
	Filter string `json:"filter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStores") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStores") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FilterSpecs) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FilterSpecs
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Flow: Flows represents the conversation flows
// when you build your chatbot agent. A flow consists of many pages connected
// by the transition routes. Conversations always start with the built-in Start
// Flow (with an all-0 ID). Transition routes can direct the conversation
// session from the current flow (parent flow) to another flow (sub flow). When
// the sub flow is finished, Dialogflow will bring the session back to the
// parent flow, where the sub flow is started. Usually, when a transition route
// is followed by a matched intent, the intent will be "consumed". This means
// the intent won't activate more transition routes. However, when the followed
// transition route moves the conversation session into a different flow, the
// matched intent can be carried over and to be consumed in the target flow.
type GoogleCloudDialogflowCxV3beta1Flow struct {
	// AdvancedSettings: Hierarchical advanced settings for this flow. The settings
	// exposed at the lower level overrides the settings exposed at the higher
	// level.
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings `json:"advancedSettings,omitempty"`
	// Description: The description of the flow. The maximum length is 500
	// characters. If exceeded, the request is rejected.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the flow.
	DisplayName string `json:"displayName,omitempty"`
	// EventHandlers: A flow's event handlers serve two purposes: * They are
	// responsible for handling events (e.g. no match, webhook errors) in the flow.
	// * They are inherited by every page's event handlers, which can be used to
	// handle common events regardless of the current page. Event handlers defined
	// in the page have higher priority than those defined in the flow. Unlike
	// transition_routes, these handlers are evaluated on a first-match basis. The
	// first one that matches the event get executed, with the rest being ignored.
	EventHandlers []*GoogleCloudDialogflowCxV3beta1EventHandler `json:"eventHandlers,omitempty"`
	// KnowledgeConnectorSettings: Optional. Knowledge connector configuration.
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	// Locked: Indicates whether the flow is locked for changes. If the flow is
	// locked, modifications to the flow will be rejected.
	Locked bool `json:"locked,omitempty"`
	// MultiLanguageSettings: Optional. Multi-lingual agent settings for this flow.
	MultiLanguageSettings *GoogleCloudDialogflowCxV3beta1FlowMultiLanguageSettings `json:"multiLanguageSettings,omitempty"`
	// Name: The unique identifier of the flow. Format:
	// `projects//locations//agents//flows/`.
	Name string `json:"name,omitempty"`
	// NluSettings: NLU related settings of the flow.
	NluSettings *GoogleCloudDialogflowCxV3beta1NluSettings `json:"nluSettings,omitempty"`
	// TransitionRouteGroups: A flow's transition route group serve two purposes: *
	// They are responsible for matching the user's first utterances in the flow. *
	// They are inherited by every page's transition route groups. Transition route
	// groups defined in the page have higher priority than those defined in the
	// flow. Format:`projects//locations//agents//flows//transitionRouteGroups/` or
	// `projects//locations//agents//transitionRouteGroups/` for agent-level
	// groups.
	TransitionRouteGroups []string `json:"transitionRouteGroups,omitempty"`
	// TransitionRoutes: A flow's transition routes serve two purposes: * They are
	// responsible for matching the user's first utterances in the flow. * They are
	// inherited by every page's transition routes and can support use cases such
	// as the user saying "help" or "can I talk to a human?", which can be handled
	// in a common way regardless of the current page. Transition routes defined in
	// the page have higher priority than those defined in the flow.
	// TransitionRoutes are evaluated in the following order: * TransitionRoutes
	// with intent specified. * TransitionRoutes with only condition specified.
	// TransitionRoutes with intent specified are inherited by pages in the flow.
	TransitionRoutes []*GoogleCloudDialogflowCxV3beta1TransitionRoute `json:"transitionRoutes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Flow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Flow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FlowImportStrategy: The flow import strategy
// used for resource conflict resolution associated with an ImportFlowRequest.
type GoogleCloudDialogflowCxV3beta1FlowImportStrategy struct {
	// GlobalImportStrategy: Optional. Global flow import strategy for resource
	// conflict resolution. The import Import strategy for resource conflict
	// resolution, applied globally throughout the flow. It will be applied for all
	// display name conflicts in the imported content. If not specified,
	// 'CREATE_NEW' is assumed.
	//
	// Possible values:
	//   "IMPORT_STRATEGY_UNSPECIFIED" - Unspecified. Treated as 'CREATE_NEW'.
	//   "IMPORT_STRATEGY_CREATE_NEW" - Create a new resource with a numeric suffix
	// appended to the end of the existing display name.
	//   "IMPORT_STRATEGY_REPLACE" - Replace existing resource with incoming
	// resource in the content to be imported.
	//   "IMPORT_STRATEGY_KEEP" - Keep existing resource and discard incoming
	// resource in the content to be imported.
	//   "IMPORT_STRATEGY_MERGE" - Combine existing and incoming resources when a
	// conflict is encountered.
	//   "IMPORT_STRATEGY_THROW_ERROR" - Throw error if a conflict is encountered.
	GlobalImportStrategy string `json:"globalImportStrategy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GlobalImportStrategy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlobalImportStrategy") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FlowImportStrategy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FlowImportStrategy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FlowInvocation: Stores metadata of the
// invocation of a child CX flow. Flow invocation actions enter the child flow.
type GoogleCloudDialogflowCxV3beta1FlowInvocation struct {
	// DisplayName: Output only. The display name of the flow.
	DisplayName string `json:"displayName,omitempty"`
	// Flow: Required. The unique identifier of the flow. Format:
	// `projects//locations//agents/`.
	Flow string `json:"flow,omitempty"`
	// FlowState: Required. Flow invocation's output state.
	//
	// Possible values:
	//   "OUTPUT_STATE_UNSPECIFIED" - Unspecified output.
	//   "OUTPUT_STATE_OK" - Succeeded.
	//   "OUTPUT_STATE_CANCELLED" - Cancelled.
	//   "OUTPUT_STATE_FAILED" - Failed.
	//   "OUTPUT_STATE_ESCALATED" - Escalated.
	//   "OUTPUT_STATE_PENDING" - Pending.
	FlowState string `json:"flowState,omitempty"`
	// InputActionParameters: Optional. A list of input parameters for the flow.
	InputActionParameters googleapi.RawMessage `json:"inputActionParameters,omitempty"`
	// OutputActionParameters: Optional. A list of output parameters generated by
	// the flow invocation.
	OutputActionParameters googleapi.RawMessage `json:"outputActionParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FlowInvocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FlowInvocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FlowMultiLanguageSettings: Settings for
// multi-lingual agents.
type GoogleCloudDialogflowCxV3beta1FlowMultiLanguageSettings struct {
	// EnableMultiLanguageDetection: Optional. Enable multi-language detection for
	// this flow. This can be set only if agent level multi language setting is
	// enabled.
	EnableMultiLanguageDetection bool `json:"enableMultiLanguageDetection,omitempty"`
	// SupportedResponseLanguageCodes: Optional. Agent will respond in the detected
	// language if the detected language code is in the supported resolved
	// languages for this flow. This will be used only if multi-language training
	// is enabled in the agent and multi-language detection is enabled in the flow.
	// The supported languages must be a subset of the languages supported by the
	// agent.
	SupportedResponseLanguageCodes []string `json:"supportedResponseLanguageCodes,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "EnableMultiLanguageDetection") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableMultiLanguageDetection") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FlowMultiLanguageSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FlowMultiLanguageSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FlowTransition: Stores metadata of the
// transition to a target CX flow. Flow transition actions exit the caller
// playbook and enter the child flow.
type GoogleCloudDialogflowCxV3beta1FlowTransition struct {
	// DisplayName: Output only. The display name of the flow.
	DisplayName string `json:"displayName,omitempty"`
	// Flow: Required. The unique identifier of the flow. Format:
	// `projects//locations//agents/`.
	Flow string `json:"flow,omitempty"`
	// InputActionParameters: A list of input parameters for the action.
	InputActionParameters googleapi.RawMessage `json:"inputActionParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FlowTransition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FlowTransition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FlowValidationResult: The response message for
// Flows.GetFlowValidationResult.
type GoogleCloudDialogflowCxV3beta1FlowValidationResult struct {
	// Name: The unique identifier of the flow validation result. Format:
	// `projects//locations//agents//flows//validationResult`.
	Name string `json:"name,omitempty"`
	// UpdateTime: Last time the flow was validated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ValidationMessages: Contains all validation messages.
	ValidationMessages []*GoogleCloudDialogflowCxV3beta1ValidationMessage `json:"validationMessages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FlowValidationResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FlowValidationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Form: A form is a data model that groups
// related parameters that can be collected from the user. The process in which
// the agent prompts the user and collects parameter values from the user is
// called form filling. A form can be added to a page. When form filling is
// done, the filled parameters will be written to the session.
type GoogleCloudDialogflowCxV3beta1Form struct {
	// Parameters: Parameters to collect from the user.
	Parameters []*GoogleCloudDialogflowCxV3beta1FormParameter `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Form) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Form
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FormParameter: Represents a form parameter.
type GoogleCloudDialogflowCxV3beta1FormParameter struct {
	// AdvancedSettings: Hierarchical advanced settings for this parameter. The
	// settings exposed at the lower level overrides the settings exposed at the
	// higher level.
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings `json:"advancedSettings,omitempty"`
	// DefaultValue: The default value of an optional parameter. If the parameter
	// is required, the default value will be ignored.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// DisplayName: Required. The human-readable name of the parameter, unique
	// within the form.
	DisplayName string `json:"displayName,omitempty"`
	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for
	// example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity types.
	EntityType string `json:"entityType,omitempty"`
	// FillBehavior: Required. Defines fill behavior for the parameter.
	FillBehavior *GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior `json:"fillBehavior,omitempty"`
	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`
	// Redact: Indicates whether the parameter content should be redacted in log.
	// If redaction is enabled, the parameter content will be replaced by parameter
	// name during logging. Note: the parameter content is subject to redaction if
	// either parameter level redaction or entity type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`
	// Required: Indicates whether the parameter is required. Optional parameters
	// will not trigger prompts; however, they are filled if the user specifies
	// them. Required parameters must be filled before form filling concludes.
	Required bool `json:"required,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FormParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FormParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior: Configuration for
// how the filling of a parameter should be handled.
type GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior struct {
	// InitialPromptFulfillment: Required. The fulfillment to provide the initial
	// prompt that the agent can present to the user in order to fill the
	// parameter.
	InitialPromptFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"initialPromptFulfillment,omitempty"`
	// RepromptEventHandlers: The handlers for parameter-level events, used to
	// provide reprompt for the parameter or transition to a different page/flow.
	// The supported events are: * `sys.no-match-`, where N can be from 1 to 6 *
	// `sys.no-match-default` * `sys.no-input-`, where N can be from 1 to 6 *
	// `sys.no-input-default` * `sys.invalid-parameter`
	// `initial_prompt_fulfillment` provides the first prompt for the parameter. If
	// the user's response does not fill the parameter, a no-match/no-input event
	// will be triggered, and the fulfillment associated with the
	// `sys.no-match-1`/`sys.no-input-1` handler (if defined) will be called to
	// provide a prompt. The `sys.no-match-2`/`sys.no-input-2` handler (if defined)
	// will respond to the next no-match/no-input event, and so on. A
	// `sys.no-match-default` or `sys.no-input-default` handler will be used to
	// handle all following no-match/no-input events after all numbered
	// no-match/no-input handlers for the parameter are consumed. A
	// `sys.invalid-parameter` handler can be defined to handle the case where the
	// parameter values have been `invalidated` by webhook. For example, if the
	// user's response fill the parameter, however the parameter was invalidated by
	// webhook, the fulfillment associated with the `sys.invalid-parameter` handler
	// (if defined) will be called to provide a prompt. If the event handler for
	// the corresponding event can't be found on the parameter,
	// `initial_prompt_fulfillment` will be re-prompted.
	RepromptEventHandlers []*GoogleCloudDialogflowCxV3beta1EventHandler `json:"repromptEventHandlers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InitialPromptFulfillment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InitialPromptFulfillment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillIntentRequest: Request of FulfillIntent
type GoogleCloudDialogflowCxV3beta1FulfillIntentRequest struct {
	// Match: The matched intent/event to fulfill.
	Match *GoogleCloudDialogflowCxV3beta1Match `json:"match,omitempty"`
	// MatchIntentRequest: Must be same as the corresponding MatchIntent request,
	// otherwise the behavior is undefined.
	MatchIntentRequest *GoogleCloudDialogflowCxV3beta1MatchIntentRequest `json:"matchIntentRequest,omitempty"`
	// OutputAudioConfig: Instructs the speech synthesizer how to generate output
	// audio.
	OutputAudioConfig *GoogleCloudDialogflowCxV3beta1OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Match") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Match") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillIntentResponse: Response of
// FulfillIntent
type GoogleCloudDialogflowCxV3beta1FulfillIntentResponse struct {
	// OutputAudio: The audio data bytes encoded as specified in the request. Note:
	// The output audio is generated based on the values of default platform text
	// responses found in the `query_result.response_messages` field. If multiple
	// default text responses exist, they will be concatenated when generating
	// audio. If no default platform text responses exist, the generated audio
	// content will be empty. In some scenarios, multiple output audio fields may
	// be present in the response structure. In these cases, only the
	// top-most-level audio output has content.
	OutputAudio string `json:"outputAudio,omitempty"`
	// OutputAudioConfig: The config used by the speech synthesizer to generate the
	// output audio.
	OutputAudioConfig *GoogleCloudDialogflowCxV3beta1OutputAudioConfig `json:"outputAudioConfig,omitempty"`
	// QueryResult: The result of the conversational query.
	QueryResult *GoogleCloudDialogflowCxV3beta1QueryResult `json:"queryResult,omitempty"`
	// ResponseId: Output only. The unique identifier of the response. It can be
	// used to locate a response in the training example set or for reporting
	// issues.
	ResponseId string `json:"responseId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "OutputAudio") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputAudio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillIntentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillIntentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Fulfillment: A fulfillment can do one or more
// of the following actions at the same time: * Generate rich message
// responses. * Set parameter values. * Call the webhook. Fulfillments can be
// called at various stages in the Page or Form lifecycle. For example, when a
// DetectIntentRequest drives a session to enter a new page, the page's entry
// fulfillment can add a static response to the QueryResult in the returning
// DetectIntentResponse, call the webhook (for example, to load user data from
// a database), or both.
type GoogleCloudDialogflowCxV3beta1Fulfillment struct {
	// AdvancedSettings: Hierarchical advanced settings for this fulfillment. The
	// settings exposed at the lower level overrides the settings exposed at the
	// higher level.
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings `json:"advancedSettings,omitempty"`
	// ConditionalCases: Conditional cases for this fulfillment.
	ConditionalCases []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases `json:"conditionalCases,omitempty"`
	// EnableGenerativeFallback: If the flag is true, the agent will utilize LLM to
	// generate a text response. If LLM generation fails, the defined responses in
	// the fulfillment will be respected. This flag is only useful for fulfillments
	// associated with no-match event handlers.
	EnableGenerativeFallback bool `json:"enableGenerativeFallback,omitempty"`
	// Generators: A list of Generators to be called during this fulfillment.
	Generators []*GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings `json:"generators,omitempty"`
	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"messages,omitempty"`
	// ReturnPartialResponses: Whether Dialogflow should return currently queued
	// fulfillment response messages in streaming APIs. If a webhook is specified,
	// it happens before Dialogflow invokes webhook. Warning: 1) This flag only
	// affects streaming API. Responses are still queued and returned once in
	// non-streaming API. 2) The flag can be enabled in any fulfillment but only
	// the first 3 partial responses will be returned. You may only want to apply
	// it to fulfillments that have slow webhooks.
	ReturnPartialResponses bool `json:"returnPartialResponses,omitempty"`
	// SetParameterActions: Set parameter values before executing the webhook.
	SetParameterActions []*GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction `json:"setParameterActions,omitempty"`
	// Tag: The value of this field will be populated in the WebhookRequest
	// `fulfillmentInfo.tag` field by Dialogflow when the associated webhook is
	// called. The tag is typically used by the webhook service to identify which
	// fulfillment is being called, but it could be used for other purposes. This
	// field is required if `webhook` is specified.
	Tag string `json:"tag,omitempty"`
	// Webhook: The webhook to call. Format:
	// `projects//locations//agents//webhooks/`.
	Webhook string `json:"webhook,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Fulfillment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Fulfillment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases: A list of
// cascading if-else conditions. Cases are mutually exclusive. The first one
// with a matching condition is selected, all the rest ignored.
type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases struct {
	// Cases: A list of cascading if-else conditions.
	Cases []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase `json:"cases,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cases") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase: Each case has
// a Boolean condition. When it is evaluated to be True, the corresponding
// messages will be selected and evaluated recursively.
type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase struct {
	// CaseContent: A list of case content.
	CaseContent []*GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent `json:"caseContent,omitempty"`
	// Condition: The condition to activate and select this case. Empty means the
	// condition is always true. The condition is evaluated against form parameters
	// or session parameters. See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	Condition string `json:"condition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaseContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaseContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent:
// The list of messages or conditional cases to activate for this case.
type GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent struct {
	// AdditionalCases: Additional cases to be evaluated.
	AdditionalCases *GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases `json:"additionalCases,omitempty"`
	// Message: Returned message.
	Message *GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalCases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalCases") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings: Generator
// settings used by the LLM to generate a text response.
type GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings struct {
	// Generator: Required. The generator to call. Format:
	// `projects//locations//agents//generators/`.
	Generator string `json:"generator,omitempty"`
	// InputParameters: Map from placeholder parameter in the Generator to
	// corresponding session parameters. By default, Dialogflow uses the session
	// parameter with the same name to fill in the generator template. e.g. If
	// there is a placeholder parameter `city` in the Generator, Dialogflow default
	// to fill in the `$city` with `$session.params.city`. However, you may choose
	// to fill `$city` with `$session.params.desination-city`. - Map key: parameter
	// ID - Map value: session parameter name
	InputParameters map[string]string `json:"inputParameters,omitempty"`
	// OutputParameter: Required. Output parameter which should contain the
	// generator response.
	OutputParameter string `json:"outputParameter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Generator") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Generator") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction: Setting a
// parameter value.
type GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction struct {
	// Parameter: Display name of the parameter.
	Parameter string `json:"parameter,omitempty"`
	// Value: The new value of the parameter. A null value clears the parameter.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1GcsDestination: Google Cloud Storage location
// for a Dialogflow operation that writes or exports objects (e.g. exported
// agent or transcripts) outside of Dialogflow.
type GoogleCloudDialogflowCxV3beta1GcsDestination struct {
	// Uri: Required. The Google Cloud Storage URI for the exported objects. A URI
	// is of the form: `gs://bucket/object-name-or-prefix` Whether a full object
	// name, or just a prefix, its usage depends on the Dialogflow operation.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1GenerativeInfo: Represents the information of
// a query if handled by generative agent resources.
type GoogleCloudDialogflowCxV3beta1GenerativeInfo struct {
	// ActionTracingInfo: The actions performed by the generative playbook for the
	// current agent response.
	ActionTracingInfo *GoogleCloudDialogflowCxV3beta1Example `json:"actionTracingInfo,omitempty"`
	// CurrentPlaybooks: The stack of playbooks that the conversation has currently
	// entered, with the most recent one on the top.
	CurrentPlaybooks []string `json:"currentPlaybooks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionTracingInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionTracingInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1GenerativeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GenerativeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1GenerativeSettings: Settings for Generative
// AI.
type GoogleCloudDialogflowCxV3beta1GenerativeSettings struct {
	// FallbackSettings: Settings for Generative Fallback.
	FallbackSettings *GoogleCloudDialogflowCxV3beta1GenerativeSettingsFallbackSettings `json:"fallbackSettings,omitempty"`
	// GenerativeSafetySettings: Settings for Generative Safety.
	GenerativeSafetySettings *GoogleCloudDialogflowCxV3beta1SafetySettings `json:"generativeSafetySettings,omitempty"`
	// KnowledgeConnectorSettings: Settings for knowledge connector.
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3beta1GenerativeSettingsKnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	// LanguageCode: Language for this settings.
	LanguageCode string `json:"languageCode,omitempty"`
	// LlmModelSettings: LLM model settings.
	LlmModelSettings *GoogleCloudDialogflowCxV3beta1LlmModelSettings `json:"llmModelSettings,omitempty"`
	// Name: Format: `projects//locations//agents//generativeSettings`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "FallbackSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FallbackSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1GenerativeSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GenerativeSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1GenerativeSettingsFallbackSettings: Settings
// for Generative Fallback.
type GoogleCloudDialogflowCxV3beta1GenerativeSettingsFallbackSettings struct {
	// PromptTemplates: Stored prompts that can be selected, for example default
	// templates like "conservative" or "chatty", or user defined ones.
	PromptTemplates []*GoogleCloudDialogflowCxV3beta1GenerativeSettingsFallbackSettingsPromptTemplate `json:"promptTemplates,omitempty"`
	// SelectedPrompt: Display name of the selected prompt.
	SelectedPrompt string `json:"selectedPrompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PromptTemplates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PromptTemplates") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1GenerativeSettingsFallbackSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GenerativeSettingsFallbackSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1GenerativeSettingsFallbackSettingsPromptTemplat
// e: Prompt template.
type GoogleCloudDialogflowCxV3beta1GenerativeSettingsFallbackSettingsPromptTemplate struct {
	// DisplayName: Prompt name.
	DisplayName string `json:"displayName,omitempty"`
	// Frozen: If the flag is true, the prompt is frozen and cannot be modified by
	// users.
	Frozen bool `json:"frozen,omitempty"`
	// PromptText: Prompt text that is sent to a LLM on no-match default,
	// placeholders are filled downstream. For example: "Here is a conversation
	// $conversation, a response is: "
	PromptText string `json:"promptText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1GenerativeSettingsFallbackSettingsPromptTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GenerativeSettingsFallbackSettingsPromptTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1GenerativeSettingsKnowledgeConnectorSettings:
// Settings for knowledge connector. These parameters are used for LLM prompt
// like "You are . You are a helpful and verbose at , . Your task is to help
// humans on ".
type GoogleCloudDialogflowCxV3beta1GenerativeSettingsKnowledgeConnectorSettings struct {
	// Agent: Name of the virtual agent. Used for LLM prompt. Can be left empty.
	Agent string `json:"agent,omitempty"`
	// AgentIdentity: Identity of the agent, e.g. "virtual agent", "AI assistant".
	AgentIdentity string `json:"agentIdentity,omitempty"`
	// AgentScope: Agent scope, e.g. "Example company website", "internal Example
	// company website for employees", "manual of car owner".
	AgentScope string `json:"agentScope,omitempty"`
	// Business: Name of the company, organization or other entity that the agent
	// represents. Used for knowledge connector LLM prompt and for knowledge
	// search.
	Business string `json:"business,omitempty"`
	// BusinessDescription: Company description, used for LLM prompt, e.g. "a
	// family company selling freshly roasted coffee beans".
	BusinessDescription string `json:"businessDescription,omitempty"`
	// DisableDataStoreFallback: Whether to disable fallback to Data Store search
	// results (in case the LLM couldn't pick a proper answer). Per default the
	// feature is enabled.
	DisableDataStoreFallback bool `json:"disableDataStoreFallback,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Agent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1GenerativeSettingsKnowledgeConnectorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GenerativeSettingsKnowledgeConnectorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Generator: Generators contain prompt to be
// sent to the LLM model to generate text. The prompt can contain parameters
// which will be resolved before calling the model. It can optionally contain
// banned phrases to ensure the model responses are safe.
type GoogleCloudDialogflowCxV3beta1Generator struct {
	// DisplayName: Required. The human-readable name of the generator, unique
	// within the agent. The prompt contains pre-defined parameters such as
	// $conversation, $last-user-utterance, etc. populated by Dialogflow. It can
	// also contain custom placeholders which will be resolved during fulfillment.
	DisplayName string `json:"displayName,omitempty"`
	// LlmModelSettings: The LLM model settings.
	LlmModelSettings *GoogleCloudDialogflowCxV3beta1LlmModelSettings `json:"llmModelSettings,omitempty"`
	// ModelParameter: Parameters passed to the LLM to configure its behavior.
	ModelParameter *GoogleCloudDialogflowCxV3beta1GeneratorModelParameter `json:"modelParameter,omitempty"`
	// Name: The unique identifier of the generator. Must be set for the
	// Generators.UpdateGenerator method. Generators.CreateGenerate populates the
	// name automatically. Format: `projects//locations//agents//generators/`.
	Name string `json:"name,omitempty"`
	// Placeholders: Optional. List of custom placeholders in the prompt text.
	Placeholders []*GoogleCloudDialogflowCxV3beta1GeneratorPlaceholder `json:"placeholders,omitempty"`
	// PromptText: Required. Prompt for the LLM model.
	PromptText *GoogleCloudDialogflowCxV3beta1Phrase `json:"promptText,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Generator) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Generator
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1GeneratorModelParameter: Parameters to be
// passed to the LLM. If not set, default values will be used.
type GoogleCloudDialogflowCxV3beta1GeneratorModelParameter struct {
	// MaxDecodeSteps: The maximum number of tokens to generate.
	MaxDecodeSteps int64 `json:"maxDecodeSteps,omitempty"`
	// Temperature: The temperature used for sampling. Temperature sampling occurs
	// after both topP and topK have been applied. Valid range: [0.0, 1.0] Low
	// temperature = less random. High temperature = more random.
	Temperature float64 `json:"temperature,omitempty"`
	// TopK: If set, the sampling process in each step is limited to the top_k
	// tokens with highest probabilities. Valid range: [1, 40] or 1000+. Small topK
	// = less random. Large topK = more random.
	TopK int64 `json:"topK,omitempty"`
	// TopP: If set, only the tokens comprising the top top_p probability mass are
	// considered. If both top_p and top_k are set, top_p will be used for further
	// refining candidates selected with top_k. Valid range: (0.0, 1.0]. Small topP
	// = less random. Large topP = more random.
	TopP float64 `json:"topP,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxDecodeSteps") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxDecodeSteps") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1GeneratorModelParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GeneratorModelParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1GeneratorModelParameter) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1GeneratorModelParameter
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		TopP        gensupport.JSONFloat64 `json:"topP"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	s.TopP = float64(s1.TopP)
	return nil
}

// GoogleCloudDialogflowCxV3beta1GeneratorPlaceholder: Represents a custom
// placeholder in the prompt text.
type GoogleCloudDialogflowCxV3beta1GeneratorPlaceholder struct {
	// Id: Unique ID used to map custom placeholder to parameters in fulfillment.
	Id string `json:"id,omitempty"`
	// Name: Custom placeholder value in the prompt text.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1GeneratorPlaceholder) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1GeneratorPlaceholder
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Handler: Handler can be used to define custom
// logic to be executed based on the user-specified triggers.
type GoogleCloudDialogflowCxV3beta1Handler struct {
	// EventHandler: A handler triggered by event.
	EventHandler *GoogleCloudDialogflowCxV3beta1HandlerEventHandler `json:"eventHandler,omitempty"`
	// LifecycleHandler: A handler triggered during specific lifecycle of the
	// playbook execution.
	LifecycleHandler *GoogleCloudDialogflowCxV3beta1HandlerLifecycleHandler `json:"lifecycleHandler,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EventHandler") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EventHandler") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Handler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Handler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1HandlerEventHandler: A handler that is
// triggered by the specified event.
type GoogleCloudDialogflowCxV3beta1HandlerEventHandler struct {
	// Condition: Optional. The condition that must be satisfied to trigger this
	// handler.
	Condition string `json:"condition,omitempty"`
	// Event: Required. The name of the event that triggers this handler.
	Event string `json:"event,omitempty"`
	// Fulfillment: Required. The fulfillment to call when the event occurs.
	Fulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"fulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1HandlerEventHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1HandlerEventHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1HandlerLifecycleHandler: A handler that is
// triggered on the specific lifecycle_stage of the playbook execution.
type GoogleCloudDialogflowCxV3beta1HandlerLifecycleHandler struct {
	// Condition: Optional. The condition that must be satisfied to trigger this
	// handler.
	Condition string `json:"condition,omitempty"`
	// Fulfillment: Required. The fulfillment to call when this handler is
	// triggered.
	Fulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"fulfillment,omitempty"`
	// LifecycleStage: Required. The name of the lifecycle stage that triggers this
	// handler. Supported values: * `playbook-start` * `pre-action-selection` *
	// `pre-action-execution`
	LifecycleStage string `json:"lifecycleStage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1HandlerLifecycleHandler) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1HandlerLifecycleHandler
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportEntityTypesMetadata: Metadata returned
// for the EntityTypes.ImportEntityTypes long running operation.
type GoogleCloudDialogflowCxV3beta1ImportEntityTypesMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1ImportEntityTypesRequest: The request message
// for EntityTypes.ImportEntityTypes.
type GoogleCloudDialogflowCxV3beta1ImportEntityTypesRequest struct {
	// EntityTypesContent: Uncompressed byte content of entity types.
	EntityTypesContent *GoogleCloudDialogflowCxV3beta1InlineSource `json:"entityTypesContent,omitempty"`
	// EntityTypesUri: The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to import entity types from.
	// The format of this URI must be `gs:///`. Dialogflow performs a read
	// operation for the Cloud Storage object on the caller's behalf, so your
	// request authentication must have read permissions for the object. For more
	// information, see Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	EntityTypesUri string `json:"entityTypesUri,omitempty"`
	// MergeOption: Required. Merge option for importing entity types.
	//
	// Possible values:
	//   "MERGE_OPTION_UNSPECIFIED" - Unspecified. If used, system uses
	// REPORT_CONFLICT as default.
	//   "REPLACE" - Replace the original entity type in the agent with the new
	// entity type when display name conflicts exist.
	//   "MERGE" - Merge the original entity type with the new entity type when
	// display name conflicts exist.
	//   "RENAME" - Create new entity types with new display names to differentiate
	// them from the existing entity types when display name conflicts exist.
	//   "REPORT_CONFLICT" - Report conflict information if display names conflict
	// is detected. Otherwise, import entity types.
	//   "KEEP" - Keep the original entity type and discard the conflicting new
	// entity type when display name conflicts exist.
	MergeOption string `json:"mergeOption,omitempty"`
	// TargetEntityType: Optional. The target entity type to import into. Format:
	// `projects//locations//agents//entity_types/`. If set, there should be only
	// one entity type included in entity_types, of which the type should match the
	// type of the target entity type. All entities in the imported entity type
	// will be added to the target entity type.
	TargetEntityType string `json:"targetEntityType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypesContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypesContent") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportEntityTypesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportEntityTypesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse: The response
// message for EntityTypes.ImportEntityTypes.
type GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse struct {
	// ConflictingResources: Info which resources have conflicts when
	// REPORT_CONFLICT merge_option is set in ImportEntityTypesRequest.
	ConflictingResources *GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources `json:"conflictingResources,omitempty"`
	// EntityTypes: The unique identifier of the imported entity types. Format:
	// `projects//locations//agents//entity_types/`.
	EntityTypes []string `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources:
// Conflicting resources detected during the import process. Only filled when
// REPORT_CONFLICT is set in the request and there are conflicts in the display
// names.
type GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources struct {
	// EntityDisplayNames: Display names of conflicting entities.
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	// EntityTypeDisplayNames: Display names of conflicting entity types.
	EntityTypeDisplayNames []string `json:"entityTypeDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportFlowRequest: The request message for
// Flows.ImportFlow.
type GoogleCloudDialogflowCxV3beta1ImportFlowRequest struct {
	// FlowContent: Uncompressed raw byte content for flow.
	FlowContent string `json:"flowContent,omitempty"`
	// FlowImportStrategy: Optional. Specifies the import strategy used when
	// resolving resource conflicts.
	FlowImportStrategy *GoogleCloudDialogflowCxV3beta1FlowImportStrategy `json:"flowImportStrategy,omitempty"`
	// FlowUri: The Google Cloud Storage (https://cloud.google.com/storage/docs/)
	// URI to import flow from. The format of this URI must be `gs:///`. Dialogflow
	// performs a read operation for the Cloud Storage object on the caller's
	// behalf, so your request authentication must have read permissions for the
	// object. For more information, see Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	FlowUri string `json:"flowUri,omitempty"`
	// ImportOption: Flow import mode. If not specified, `KEEP` is assumed.
	//
	// Possible values:
	//   "IMPORT_OPTION_UNSPECIFIED" - Unspecified. Treated as `KEEP`.
	//   "KEEP" - Always respect settings in exported flow content. It may cause a
	// import failure if some settings (e.g. custom NLU) are not supported in the
	// agent to import into.
	//   "FALLBACK" - Fallback to default settings if some settings are not
	// supported in the agent to import into. E.g. Standard NLU will be used if
	// custom NLU is not available.
	ImportOption string `json:"importOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlowContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlowContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportFlowRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportFlowResponse: The response message for
// Flows.ImportFlow.
type GoogleCloudDialogflowCxV3beta1ImportFlowResponse struct {
	// Flow: The unique identifier of the new flow. Format:
	// `projects//locations//agents//flows/`.
	Flow string `json:"flow,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportFlowResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportFlowResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportIntentsMetadata: Metadata returned for
// the Intents.ImportIntents long running operation.
type GoogleCloudDialogflowCxV3beta1ImportIntentsMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1ImportIntentsRequest: The request message for
// Intents.ImportIntents.
type GoogleCloudDialogflowCxV3beta1ImportIntentsRequest struct {
	// IntentsContent: Uncompressed byte content of intents.
	IntentsContent *GoogleCloudDialogflowCxV3beta1InlineSource `json:"intentsContent,omitempty"`
	// IntentsUri: The Google Cloud Storage
	// (https://cloud.google.com/storage/docs/) URI to import intents from. The
	// format of this URI must be `gs:///`. Dialogflow performs a read operation
	// for the Cloud Storage object on the caller's behalf, so your request
	// authentication must have read permissions for the object. For more
	// information, see Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	IntentsUri string `json:"intentsUri,omitempty"`
	// MergeOption: Merge option for importing intents. If not specified, `REJECT`
	// is assumed.
	//
	// Possible values:
	//   "MERGE_OPTION_UNSPECIFIED" - Unspecified. Should not be used.
	//   "REJECT" - DEPRECATED: Please use REPORT_CONFLICT instead. Fail the
	// request if there are intents whose display names conflict with the display
	// names of intents in the agent.
	//   "REPLACE" - Replace the original intent in the agent with the new intent
	// when display name conflicts exist.
	//   "MERGE" - Merge the original intent with the new intent when display name
	// conflicts exist.
	//   "RENAME" - Create new intents with new display names to differentiate them
	// from the existing intents when display name conflicts exist.
	//   "REPORT_CONFLICT" - Report conflict information if display names conflict
	// is detected. Otherwise, import intents.
	//   "KEEP" - Keep the original intent and discard the conflicting new intent
	// when display name conflicts exist.
	MergeOption string `json:"mergeOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IntentsContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IntentsContent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportIntentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportIntentsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportIntentsResponse: The response message
// for Intents.ImportIntents.
type GoogleCloudDialogflowCxV3beta1ImportIntentsResponse struct {
	// ConflictingResources: Info which resources have conflicts when
	// REPORT_CONFLICT merge_option is set in ImportIntentsRequest.
	ConflictingResources *GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources `json:"conflictingResources,omitempty"`
	// Intents: The unique identifier of the imported intents. Format:
	// `projects//locations//agents//intents/`.
	Intents []string `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConflictingResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConflictingResources") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources:
// Conflicting resources detected during the import process. Only filled when
// REPORT_CONFLICT is set in the request and there are conflicts in the display
// names.
type GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources struct {
	// EntityDisplayNames: Display names of conflicting entities.
	EntityDisplayNames []string `json:"entityDisplayNames,omitempty"`
	// IntentDisplayNames: Display names of conflicting intents.
	IntentDisplayNames []string `json:"intentDisplayNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityDisplayNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityDisplayNames") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportPlaybookRequest: The request message for
// Playbooks.ImportPlaybook.
type GoogleCloudDialogflowCxV3beta1ImportPlaybookRequest struct {
	// ImportStrategy: Optional. Specifies the import strategy used when resolving
	// resource conflicts.
	ImportStrategy *GoogleCloudDialogflowCxV3beta1PlaybookImportStrategy `json:"importStrategy,omitempty"`
	// PlaybookContent: Uncompressed raw byte content for playbook.
	PlaybookContent string `json:"playbookContent,omitempty"`
	// PlaybookUri: [Dialogflow access control]
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	PlaybookUri string `json:"playbookUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImportStrategy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportStrategy") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportPlaybookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportPlaybookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata: Metadata returned for
// the TestCases.ImportTestCases long running operation.
type GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata struct {
	// Errors: Errors for failed test cases.
	Errors []*GoogleCloudDialogflowCxV3beta1TestCaseError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportTestCasesRequest: The request message
// for TestCases.ImportTestCases.
type GoogleCloudDialogflowCxV3beta1ImportTestCasesRequest struct {
	// Content: Uncompressed raw byte content for test cases.
	Content string `json:"content,omitempty"`
	// GcsUri: The Google Cloud Storage (https://cloud.google.com/storage/docs/)
	// URI to import test cases from. The format of this URI must be `gs:///`.
	// Dialogflow performs a read operation for the Cloud Storage object on the
	// caller's behalf, so your request authentication must have read permissions
	// for the object. For more information, see Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	GcsUri string `json:"gcsUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportTestCasesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse: The response message
// for TestCases.ImportTestCases.
type GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse struct {
	// Names: The unique identifiers of the new test cases. Format:
	// `projects//locations//agents//testCases/`.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1InlineDestination: Inline destination for a
// Dialogflow operation that writes or exports objects (e.g. intents) outside
// of Dialogflow.
type GoogleCloudDialogflowCxV3beta1InlineDestination struct {
	// Content: Output only. The uncompressed byte content for the objects. Only
	// populated in responses.
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1InlineDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1InlineDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1InlineSchema: A type schema object that's
// specified inline.
type GoogleCloudDialogflowCxV3beta1InlineSchema struct {
	// Items: Schema of the elements if this is an ARRAY type.
	Items *GoogleCloudDialogflowCxV3beta1TypeSchema `json:"items,omitempty"`
	// Type: Data type of the schema.
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Not specified.
	//   "STRING" - Represents any string value.
	//   "NUMBER" - Represents any number value.
	//   "BOOLEAN" - Represents a boolean value.
	//   "ARRAY" - Represents a repeated value.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1InlineSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1InlineSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1InlineSource: Inline source for a Dialogflow
// operation that reads or imports objects (e.g. intents) into Dialogflow.
type GoogleCloudDialogflowCxV3beta1InlineSource struct {
	// Content: The uncompressed byte content for the objects.
	Content string `json:"content,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1InlineSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1InlineSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1InputAudioConfig: Instructs the speech
// recognizer on how to process the audio content.
type GoogleCloudDialogflowCxV3beta1InputAudioConfig struct {
	// AudioEncoding: Required. Audio encoding of the audio content to process.
	//
	// Possible values:
	//   "AUDIO_ENCODING_UNSPECIFIED" - Not specified.
	//   "AUDIO_ENCODING_LINEAR_16" - Uncompressed 16-bit signed little-endian
	// samples (Linear PCM).
	//   "AUDIO_ENCODING_FLAC" - [`FLAC`](https://xiph.org/flac/documentation.html)
	// (Free Lossless Audio Codec) is the recommended encoding because it is
	// lossless (therefore recognition is not compromised) and requires only about
	// half the bandwidth of `LINEAR16`. `FLAC` stream encoding supports 16-bit and
	// 24-bit samples, however, not all fields in `STREAMINFO` are supported.
	//   "AUDIO_ENCODING_MULAW" - 8-bit samples that compand 14-bit audio samples
	// using G.711 PCMU/mu-law.
	//   "AUDIO_ENCODING_AMR" - Adaptive Multi-Rate Narrowband codec.
	// `sample_rate_hertz` must be 8000.
	//   "AUDIO_ENCODING_AMR_WB" - Adaptive Multi-Rate Wideband codec.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_OGG_OPUS" - Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)). `sample_rate_hertz` must be
	// 16000.
	//   "AUDIO_ENCODING_SPEEX_WITH_HEADER_BYTE" - Although the use of lossy
	// encodings is not recommended, if a very low bitrate encoding is required,
	// `OGG_OPUS` is highly preferred over Speex encoding. The
	// [Speex](https://speex.org/) encoding supported by Dialogflow API has a
	// header byte in each block, as in MIME type `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in [RFC
	// 5574](https://tools.ietf.org/html/rfc5574). The stream is a sequence of
	// blocks, one block per RTP packet. Each block starts with a byte containing
	// the length of the block, in bytes, followed by one or more frames of Speex
	// data, padded to an integral number of bytes (octets) as specified in RFC
	// 5574. In other words, each RTP header is replaced with a single byte
	// containing the block length. Only Speex wideband is supported.
	// `sample_rate_hertz` must be 16000.
	//   "AUDIO_ENCODING_ALAW" - 8-bit samples that compand 13-bit audio samples
	// using G.711 PCMU/a-law.
	AudioEncoding string `json:"audioEncoding,omitempty"`
	// BargeInConfig: Configuration of barge-in behavior during the streaming of
	// input audio.
	BargeInConfig *GoogleCloudDialogflowCxV3beta1BargeInConfig `json:"bargeInConfig,omitempty"`
	// EnableWordInfo: Optional. If `true`, Dialogflow returns SpeechWordInfo in
	// StreamingRecognitionResult with information about the recognized speech
	// words, e.g. start and end time offsets. If false or unspecified, Speech
	// doesn't return any word-level information.
	EnableWordInfo bool `json:"enableWordInfo,omitempty"`
	// Model: Optional. Which Speech model to select for the given request. For
	// more information, see Speech models
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-models).
	Model string `json:"model,omitempty"`
	// ModelVariant: Optional. Which variant of the Speech model to use.
	//
	// Possible values:
	//   "SPEECH_MODEL_VARIANT_UNSPECIFIED" - No model variant specified. In this
	// case Dialogflow defaults to USE_BEST_AVAILABLE.
	//   "USE_BEST_AVAILABLE" - Use the best available variant of the Speech model
	// that the caller is eligible for.
	//   "USE_STANDARD" - Use standard model variant even if an enhanced model is
	// available. See the [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// for details about enhanced models.
	//   "USE_ENHANCED" - Use an enhanced model variant: * If an enhanced variant
	// does not exist for the given model and request language, Dialogflow falls
	// back to the standard variant. The [Cloud Speech
	// documentation](https://cloud.google.com/speech-to-text/docs/enhanced-models)
	// describes which models have enhanced variants.
	ModelVariant string `json:"modelVariant,omitempty"`
	// OptOutConformerModelMigration: If `true`, the request will opt out for STT
	// conformer model migration. This field will be deprecated once force
	// migration takes place in June 2024. Please refer to Dialogflow CX Speech
	// model migration
	// (https://cloud.google.com/dialogflow/cx/docs/concept/speech-model-migration).
	OptOutConformerModelMigration bool `json:"optOutConformerModelMigration,omitempty"`
	// PhraseHints: Optional. A list of strings containing words and phrases that
	// the speech recognizer should recognize with higher likelihood. See the Cloud
	// Speech documentation
	// (https://cloud.google.com/speech-to-text/docs/basics#phrase-hints) for more
	// details.
	PhraseHints []string `json:"phraseHints,omitempty"`
	// SampleRateHertz: Sample rate (in Hertz) of the audio content sent in the
	// query. Refer to Cloud Speech API documentation
	// (https://cloud.google.com/speech-to-text/docs/basics) for more details.
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`
	// SingleUtterance: Optional. If `false` (default), recognition does not cease
	// until the client closes the stream. If `true`, the recognizer will detect a
	// single spoken utterance in input audio. Recognition ceases when it detects
	// the audio's voice has stopped or paused. In this case, once a detected
	// intent is received, the client should close the stream and start a new
	// request with a new stream as needed. Note: This setting is relevant only for
	// streaming methods.
	SingleUtterance bool `json:"singleUtterance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1InputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1InputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Intent: An intent represents a user's intent
// to interact with a conversational agent. You can provide information for the
// Dialogflow API to use to match user input to an intent by adding training
// phrases (i.e., examples of user input) to your intent.
type GoogleCloudDialogflowCxV3beta1Intent struct {
	// Description: Human readable description for better understanding an intent
	// like its scope, content, result etc. Maximum character limit: 140
	// characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the intent, unique within
	// the agent.
	DisplayName string `json:"displayName,omitempty"`
	// IsFallback: Indicates whether this is a fallback intent. Currently only
	// default fallback intent is allowed in the agent, which is added upon agent
	// creation. Adding training phrases to fallback intent is useful in the case
	// of requests that are mistakenly matched, since training phrases assigned to
	// fallback intents act as negative examples that triggers no-match event.
	IsFallback bool `json:"isFallback,omitempty"`
	// Labels: The key/value metadata to label an intent. Labels can contain
	// lowercase letters, digits and the symbols '-' and '_'. International
	// characters are allowed, including letters from unicase alphabets. Keys must
	// start with a letter. Keys and values can be no longer than 63 characters and
	// no more than 128 bytes. Prefix "sys-" is reserved for Dialogflow defined
	// labels. Currently allowed Dialogflow defined labels include: * sys-head *
	// sys-contextual The above labels do not require value. "sys-head" means the
	// intent is a head intent. "sys-contextual" means the intent is a contextual
	// intent.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: The unique identifier of the intent. Required for the
	// Intents.UpdateIntent method. Intents.CreateIntent populates the name
	// automatically. Format: `projects//locations//agents//intents/`.
	Name string `json:"name,omitempty"`
	// Parameters: The collection of parameters associated with the intent.
	Parameters []*GoogleCloudDialogflowCxV3beta1IntentParameter `json:"parameters,omitempty"`
	// Priority: The priority of this intent. Higher numbers represent higher
	// priorities. - If the supplied value is unspecified or 0, the service
	// translates the value to 500,000, which corresponds to the `Normal` priority
	// in the console. - If the supplied value is negative, the intent is ignored
	// in runtime detect intent requests.
	Priority int64 `json:"priority,omitempty"`
	// TrainingPhrases: The collection of training phrases the agent is trained on
	// to identify the intent.
	TrainingPhrases []*GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase `json:"trainingPhrases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentCoverage: Intent coverage represents the
// percentage of all possible intents in the agent that are triggered in any of
// a parent's test cases.
type GoogleCloudDialogflowCxV3beta1IntentCoverage struct {
	// CoverageScore: The percent of intents in the agent that are covered.
	CoverageScore float64 `json:"coverageScore,omitempty"`
	// Intents: The list of Intents present in the agent
	Intents []*GoogleCloudDialogflowCxV3beta1IntentCoverageIntent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoverageScore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentCoverage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1IntentCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1IntentCoverageIntent: The agent's intent.
type GoogleCloudDialogflowCxV3beta1IntentCoverageIntent struct {
	// Covered: Whether the intent is covered by at least one of the agent's test
	// cases.
	Covered bool `json:"covered,omitempty"`
	// Intent: The intent full resource name
	Intent string `json:"intent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Covered") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Covered") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentCoverageIntent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentCoverageIntent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentInput: Represents the intent to trigger
// programmatically rather than as a result of natural language processing.
type GoogleCloudDialogflowCxV3beta1IntentInput struct {
	// Intent: Required. The unique identifier of the intent. Format:
	// `projects//locations//agents//intents/`.
	Intent string `json:"intent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentParameter: Represents an intent
// parameter.
type GoogleCloudDialogflowCxV3beta1IntentParameter struct {
	// EntityType: Required. The entity type of the parameter. Format:
	// `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for
	// example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects//locations//agents//entityTypes/` for developer entity types.
	EntityType string `json:"entityType,omitempty"`
	// Id: Required. The unique identifier of the parameter. This field is used by
	// training phrases to annotate their parts.
	Id string `json:"id,omitempty"`
	// IsList: Indicates whether the parameter represents a list of values.
	IsList bool `json:"isList,omitempty"`
	// Redact: Indicates whether the parameter content should be redacted in log.
	// If redaction is enabled, the parameter content will be replaced by parameter
	// name during logging. Note: the parameter content is subject to redaction if
	// either parameter level redaction or entity type level redaction is enabled.
	Redact bool `json:"redact,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase: Represents an example
// that the agent is trained on to identify the intent.
type GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase struct {
	// Id: Output only. The unique identifier of the training phrase.
	Id string `json:"id,omitempty"`
	// Parts: Required. The ordered list of training phrase parts. The parts are
	// concatenated in order to form the training phrase. Note: The API does not
	// automatically annotate training phrases like the Dialogflow Console does.
	// Note: Do not forget to include whitespace at part boundaries, so the
	// training phrase is well formatted when the parts are concatenated. If the
	// training phrase does not need to be annotated with parameters, you just need
	// a single part with only the Part.text field set. If you want to annotate the
	// training phrase, you must create multiple parts, where the fields of each
	// part are populated in one of two ways: - `Part.text` is set to a part of the
	// phrase that has no parameters. - `Part.text` is set to a part of the phrase
	// that you want to annotate, and the `parameter_id` field is set.
	Parts []*GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart `json:"parts,omitempty"`
	// RepeatCount: Indicates how many times this example was added to the intent.
	RepeatCount int64 `json:"repeatCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart: Represents a part of
// a training phrase.
type GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart struct {
	// ParameterId: The parameter used to annotate this part of the training
	// phrase. This field is required for annotated parts of the training phrase.
	ParameterId string `json:"parameterId,omitempty"`
	// Text: Required. The text for this part.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings: The Knowledge
// Connector settings for this page or flow. This includes information such as
// the attached Knowledge Bases, and the way to execute fulfillment.
type GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings struct {
	// DataStoreConnections: Optional. List of related data store connections.
	DataStoreConnections []*GoogleCloudDialogflowCxV3beta1DataStoreConnection `json:"dataStoreConnections,omitempty"`
	// Enabled: Whether Knowledge Connector is enabled or not.
	Enabled bool `json:"enabled,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TriggerFulfillment: The fulfillment to be triggered. When the answers from
	// the Knowledge Connector are selected by Dialogflow, you can utitlize the
	// request scoped parameter `$request.knowledge.answers` (contains up to the 5
	// highest confidence answers) and `$request.knowledge.questions` (contains the
	// corresponding questions) to construct the fulfillment.
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1LanguageInfo: Represents the language
// information of the request.
type GoogleCloudDialogflowCxV3beta1LanguageInfo struct {
	// ConfidenceScore: The confidence score of the detected language between 0 and
	// 1.
	ConfidenceScore float64 `json:"confidenceScore,omitempty"`
	// InputLanguageCode: The language code specified in the original request.
	InputLanguageCode string `json:"inputLanguageCode,omitempty"`
	// ResolvedLanguageCode: The language code detected for this request based on
	// the user conversation.
	ResolvedLanguageCode string `json:"resolvedLanguageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceScore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1LanguageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LanguageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1LanguageInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1LanguageInfo
	var s1 struct {
		ConfidenceScore gensupport.JSONFloat64 `json:"confidenceScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceScore = float64(s1.ConfidenceScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1ListAgentsResponse: The response message for
// Agents.ListAgents.
type GoogleCloudDialogflowCxV3beta1ListAgentsResponse struct {
	// Agents: The list of agents. There will be a maximum number of items returned
	// based on the page_size field in the request.
	Agents []*GoogleCloudDialogflowCxV3beta1Agent `json:"agents,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Agents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Agents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListAgentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListAgentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListChangelogsResponse: The response message
// for Changelogs.ListChangelogs.
type GoogleCloudDialogflowCxV3beta1ListChangelogsResponse struct {
	// Changelogs: The list of changelogs. There will be a maximum number of items
	// returned based on the page_size field in the request. The changelogs will be
	// ordered by timestamp.
	Changelogs []*GoogleCloudDialogflowCxV3beta1Changelog `json:"changelogs,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Changelogs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Changelogs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListChangelogsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListChangelogsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListContinuousTestResultsResponse: The
// response message for Environments.ListTestCaseResults.
type GoogleCloudDialogflowCxV3beta1ListContinuousTestResultsResponse struct {
	// ContinuousTestResults: The list of continuous test results.
	ContinuousTestResults []*GoogleCloudDialogflowCxV3beta1ContinuousTestResult `json:"continuousTestResults,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContinuousTestResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinuousTestResults") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListContinuousTestResultsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListContinuousTestResultsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListConversationsResponse: The response
// message for Conversations.ListConversations.
type GoogleCloudDialogflowCxV3beta1ListConversationsResponse struct {
	// Conversations: The list of conversations. There will be a maximum number of
	// items returned based on the page_size field. The returned conversations will
	// be sorted by start_time in descending order (newest conversation first).
	Conversations []*GoogleCloudDialogflowCxV3beta1Conversation `json:"conversations,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Conversations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListConversationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListConversationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListDeploymentsResponse: The response message
// for Deployments.ListDeployments.
type GoogleCloudDialogflowCxV3beta1ListDeploymentsResponse struct {
	// Deployments: The list of deployments. There will be a maximum number of
	// items returned based on the page_size field in the request. The list may in
	// some cases be empty or contain fewer entries than page_size even if this
	// isn't the last page.
	Deployments []*GoogleCloudDialogflowCxV3beta1Deployment `json:"deployments,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Deployments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deployments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListDeploymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListDeploymentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse: The response message
// for EntityTypes.ListEntityTypes.
type GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse struct {
	// EntityTypes: The list of entity types. There will be a maximum number of
	// items returned based on the page_size field in the request.
	EntityTypes []*GoogleCloudDialogflowCxV3beta1EntityType `json:"entityTypes,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListEnvironmentsResponse: The response message
// for Environments.ListEnvironments.
type GoogleCloudDialogflowCxV3beta1ListEnvironmentsResponse struct {
	// Environments: The list of environments. There will be a maximum number of
	// items returned based on the page_size field in the request. The list may in
	// some cases be empty or contain fewer entries than page_size even if this
	// isn't the last page.
	Environments []*GoogleCloudDialogflowCxV3beta1Environment `json:"environments,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Environments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListEnvironmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListEnvironmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListExamplesResponse: The response message for
// Examples.ListExamples.
type GoogleCloudDialogflowCxV3beta1ListExamplesResponse struct {
	// Examples: The list of examples. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Examples []*GoogleCloudDialogflowCxV3beta1Example `json:"examples,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Examples") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Examples") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListExamplesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListExamplesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListExperimentsResponse: The response message
// for Experiments.ListExperiments.
type GoogleCloudDialogflowCxV3beta1ListExperimentsResponse struct {
	// Experiments: The list of experiments. There will be a maximum number of
	// items returned based on the page_size field in the request. The list may in
	// some cases be empty or contain fewer entries than page_size even if this
	// isn't the last page.
	Experiments []*GoogleCloudDialogflowCxV3beta1Experiment `json:"experiments,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Experiments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Experiments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListExperimentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListExperimentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListFlowsResponse: The response message for
// Flows.ListFlows.
type GoogleCloudDialogflowCxV3beta1ListFlowsResponse struct {
	// Flows: The list of flows. There will be a maximum number of items returned
	// based on the page_size field in the request.
	Flows []*GoogleCloudDialogflowCxV3beta1Flow `json:"flows,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Flows") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flows") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListFlowsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListFlowsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListGeneratorsResponse: The response message
// for Generators.ListGenerators.
type GoogleCloudDialogflowCxV3beta1ListGeneratorsResponse struct {
	// Generators: The list of generators. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Generators []*GoogleCloudDialogflowCxV3beta1Generator `json:"generators,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Generators") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Generators") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListGeneratorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListGeneratorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListIntentsResponse: The response message for
// Intents.ListIntents.
type GoogleCloudDialogflowCxV3beta1ListIntentsResponse struct {
	// Intents: The list of intents. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Intents []*GoogleCloudDialogflowCxV3beta1Intent `json:"intents,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListPagesResponse: The response message for
// Pages.ListPages.
type GoogleCloudDialogflowCxV3beta1ListPagesResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Pages: The list of pages. There will be a maximum number of items returned
	// based on the page_size field in the request.
	Pages []*GoogleCloudDialogflowCxV3beta1Page `json:"pages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListPagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListPagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListPlaybookVersionsResponse: The response
// message for Playbooks.ListPlaybookVersions.
type GoogleCloudDialogflowCxV3beta1ListPlaybookVersionsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PlaybookVersions: The list of playbook version. There will be a maximum
	// number of items returned based on the page_size field in the request.
	PlaybookVersions []*GoogleCloudDialogflowCxV3beta1PlaybookVersion `json:"playbookVersions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListPlaybookVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListPlaybookVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListPlaybooksResponse: The response message
// for Playbooks.ListPlaybooks.
type GoogleCloudDialogflowCxV3beta1ListPlaybooksResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Playbooks: The list of playbooks. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Playbooks []*GoogleCloudDialogflowCxV3beta1Playbook `json:"playbooks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListPlaybooksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListPlaybooksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListSecuritySettingsResponse: The response
// message for SecuritySettings.ListSecuritySettings.
type GoogleCloudDialogflowCxV3beta1ListSecuritySettingsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SecuritySettings: The list of security settings.
	SecuritySettings []*GoogleCloudDialogflowCxV3beta1SecuritySettings `json:"securitySettings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListSecuritySettingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListSecuritySettingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListSessionEntityTypesResponse: The response
// message for SessionEntityTypes.ListSessionEntityTypes.
type GoogleCloudDialogflowCxV3beta1ListSessionEntityTypesResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SessionEntityTypes: The list of session entity types. There will be a
	// maximum number of items returned based on the page_size field in the
	// request.
	SessionEntityTypes []*GoogleCloudDialogflowCxV3beta1SessionEntityType `json:"sessionEntityTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListSessionEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListSessionEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListTestCaseResultsResponse: The response
// message for TestCases.ListTestCaseResults.
type GoogleCloudDialogflowCxV3beta1ListTestCaseResultsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TestCaseResults: The list of test case results.
	TestCaseResults []*GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"testCaseResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListTestCaseResultsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListTestCaseResultsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListTestCasesResponse: The response message
// for TestCases.ListTestCases.
type GoogleCloudDialogflowCxV3beta1ListTestCasesResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TestCases: The list of test cases. There will be a maximum number of items
	// returned based on the page_size field in the request.
	TestCases []*GoogleCloudDialogflowCxV3beta1TestCase `json:"testCases,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListTestCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListTestCasesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListToolVersionsResponse: The response message
// for Tools.ListToolVersions.
type GoogleCloudDialogflowCxV3beta1ListToolVersionsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ToolVersions: The list of tool versions. There will be a maximum number of
	// items returned based on the page_size field in the request.
	ToolVersions []*GoogleCloudDialogflowCxV3beta1ToolVersion `json:"toolVersions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListToolVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListToolVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListToolsResponse: The response message for
// Tools.ListTools.
type GoogleCloudDialogflowCxV3beta1ListToolsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Tools: The list of Tools. There will be a maximum number of items returned
	// based on the page_size field in the request.
	Tools []*GoogleCloudDialogflowCxV3beta1Tool `json:"tools,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListToolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListToolsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListTransitionRouteGroupsResponse: The
// response message for TransitionRouteGroups.ListTransitionRouteGroups.
type GoogleCloudDialogflowCxV3beta1ListTransitionRouteGroupsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// TransitionRouteGroups: The list of transition route groups. There will be a
	// maximum number of items returned based on the page_size field in the
	// request. The list may in some cases be empty or contain fewer entries than
	// page_size even if this isn't the last page.
	TransitionRouteGroups []*GoogleCloudDialogflowCxV3beta1TransitionRouteGroup `json:"transitionRouteGroups,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListTransitionRouteGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListTransitionRouteGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListVersionsResponse: The response message for
// Versions.ListVersions.
type GoogleCloudDialogflowCxV3beta1ListVersionsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Versions: A list of versions. There will be a maximum number of items
	// returned based on the page_size field in the request. The list may in some
	// cases be empty or contain fewer entries than page_size even if this isn't
	// the last page.
	Versions []*GoogleCloudDialogflowCxV3beta1Version `json:"versions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListVersionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListVersionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ListWebhooksResponse: The response message for
// Webhooks.ListWebhooks.
type GoogleCloudDialogflowCxV3beta1ListWebhooksResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Webhooks: The list of webhooks. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Webhooks []*GoogleCloudDialogflowCxV3beta1Webhook `json:"webhooks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ListWebhooksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ListWebhooksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1LlmCall: Stores metadata of the call of an
// LLM.
type GoogleCloudDialogflowCxV3beta1LlmCall struct {
	// Model: The model of the LLM call.
	Model string `json:"model,omitempty"`
	// RetrievedExamples: A list of relevant examples used for the LLM prompt.
	RetrievedExamples []*GoogleCloudDialogflowCxV3beta1LlmCallRetrievedExample `json:"retrievedExamples,omitempty"`
	// Temperature: The temperature of the LLM call.
	Temperature float64 `json:"temperature,omitempty"`
	// TokenCount: The token counts of the LLM call.
	TokenCount *GoogleCloudDialogflowCxV3beta1LlmCallTokenCount `json:"tokenCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1LlmCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LlmCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1LlmCall) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1LlmCall
	var s1 struct {
		Temperature gensupport.JSONFloat64 `json:"temperature"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Temperature = float64(s1.Temperature)
	return nil
}

// GoogleCloudDialogflowCxV3beta1LlmCallRetrievedExample: Relevant example used
// for the LLM prompt.
type GoogleCloudDialogflowCxV3beta1LlmCallRetrievedExample struct {
	// ExampleDisplayName: The display name of the example.
	ExampleDisplayName string `json:"exampleDisplayName,omitempty"`
	// ExampleId: The id of the example.
	ExampleId string `json:"exampleId,omitempty"`
	// MatchedRetrievalLabel: Optional. The matched retrieval label of this LLM
	// call.
	MatchedRetrievalLabel string `json:"matchedRetrievalLabel,omitempty"`
	// RetrievalStrategy: Retrieval strategy of the example.
	//
	// Possible values:
	//   "RETRIEVAL_STRATEGY_UNSPECIFIED" - Not specified. `DEFAULT` will be used.
	//   "DEFAULT" - Default retrieval strategy.
	//   "STATIC" - Static example will always be inserted to the prompt.
	//   "NEVER" - Example will never be inserted into the prompt.
	RetrievalStrategy string `json:"retrievalStrategy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExampleDisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExampleDisplayName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1LlmCallRetrievedExample) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LlmCallRetrievedExample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1LlmCallTokenCount: Stores token counts of the
// LLM call.
type GoogleCloudDialogflowCxV3beta1LlmCallTokenCount struct {
	// ConversationContextTokenCount: The number of tokens used for the
	// conversation history in the prompt.
	ConversationContextTokenCount int64 `json:"conversationContextTokenCount,omitempty,string"`
	// ExampleTokenCount: The number of tokens used for the retrieved examples in
	// the prompt.
	ExampleTokenCount int64 `json:"exampleTokenCount,omitempty,string"`
	// TotalInputTokenCount: The total number of tokens used for the input to the
	// LLM call.
	TotalInputTokenCount int64 `json:"totalInputTokenCount,omitempty,string"`
	// TotalOutputTokenCount: The total number of tokens used for the output of the
	// LLM call.
	TotalOutputTokenCount int64 `json:"totalOutputTokenCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g.
	// "ConversationContextTokenCount") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationContextTokenCount")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1LlmCallTokenCount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LlmCallTokenCount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1LlmModelSettings: Settings for LLM models.
type GoogleCloudDialogflowCxV3beta1LlmModelSettings struct {
	// Model: The selected LLM model.
	Model string `json:"model,omitempty"`
	// PromptText: The custom prompt to use.
	PromptText string `json:"promptText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Model") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Model") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1LlmModelSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LlmModelSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1LoadVersionRequest: The request message for
// Versions.LoadVersion.
type GoogleCloudDialogflowCxV3beta1LoadVersionRequest struct {
	// AllowOverrideAgentResources: This field is used to prevent accidental
	// overwrite of other agent resources, which can potentially impact other
	// flow's behavior. If `allow_override_agent_resources` is false, conflicted
	// agent-level resources will not be overridden (i.e. intents, entities,
	// webhooks).
	AllowOverrideAgentResources bool `json:"allowOverrideAgentResources,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AllowOverrideAgentResources") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowOverrideAgentResources") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1LoadVersionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LoadVersionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1LookupEnvironmentHistoryResponse: The response
// message for Environments.LookupEnvironmentHistory.
type GoogleCloudDialogflowCxV3beta1LookupEnvironmentHistoryResponse struct {
	// Environments: Represents a list of snapshots for an environment. Time of the
	// snapshots is stored in `update_time`.
	Environments []*GoogleCloudDialogflowCxV3beta1Environment `json:"environments,omitempty"`
	// NextPageToken: Token to retrieve the next page of results, or empty if there
	// are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Environments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1LookupEnvironmentHistoryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1LookupEnvironmentHistoryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Match: Represents one match result of
// MatchIntent.
type GoogleCloudDialogflowCxV3beta1Match struct {
	// Confidence: The confidence of this match. Values range from 0.0 (completely
	// uncertain) to 1.0 (completely certain). This value is for informational
	// purpose only and is only used to help match the best intent within the
	// classification threshold. This value may change for the same end-user
	// expression at any time due to a model retraining or change in
	// implementation.
	Confidence float64 `json:"confidence,omitempty"`
	// Event: The event that matched the query. Filled for `EVENT`, `NO_MATCH` and
	// `NO_INPUT` match types.
	Event string `json:"event,omitempty"`
	// Intent: The Intent that matched the query. Some, not all fields are filled
	// in this message, including but not limited to: `name` and `display_name`.
	// Only filled for `INTENT` match type.
	Intent *GoogleCloudDialogflowCxV3beta1Intent `json:"intent,omitempty"`
	// MatchType: Type of this Match.
	//
	// Possible values:
	//   "MATCH_TYPE_UNSPECIFIED" - Not specified. Should never be used.
	//   "INTENT" - The query was matched to an intent.
	//   "DIRECT_INTENT" - The query directly triggered an intent.
	//   "PARAMETER_FILLING" - The query was used for parameter filling.
	//   "NO_MATCH" - No match was found for the query.
	//   "NO_INPUT" - Indicates an empty query.
	//   "EVENT" - The query directly triggered an event.
	//   "KNOWLEDGE_CONNECTOR" - The query was matched to a Knowledge Connector
	// answer.
	//   "PLAYBOOK" - The query was handled by a `Playbook`.
	MatchType string `json:"matchType,omitempty"`
	// Parameters: The collection of parameters extracted from the query. Depending
	// on your protocol or client library language, this is a map, associative
	// array, symbol table, dictionary, or JSON object composed of a collection of
	// (MapKey, MapValue) pairs: * MapKey type: string * MapKey value: parameter
	// name * MapValue type: If parameter's entity type is a composite entity then
	// use map, otherwise, depending on the parameter value type, it could be one
	// of string, number, boolean, null, list or map. * MapValue value: If
	// parameter's entity type is a composite entity then use map from composite
	// entity property names to property values, otherwise, use parameter value.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ResolvedInput: Final text input which was matched during MatchIntent. This
	// value can be different from original input sent in request because of
	// spelling correction or other processing.
	ResolvedInput string `json:"resolvedInput,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Match) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Match
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1Match) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1Match
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowCxV3beta1MatchIntentRequest: Request of MatchIntent.
type GoogleCloudDialogflowCxV3beta1MatchIntentRequest struct {
	// PersistParameterChanges: Persist session parameter changes from
	// `query_params`.
	PersistParameterChanges bool `json:"persistParameterChanges,omitempty"`
	// QueryInput: Required. The input specification.
	QueryInput *GoogleCloudDialogflowCxV3beta1QueryInput `json:"queryInput,omitempty"`
	// QueryParams: The parameters of this query.
	QueryParams *GoogleCloudDialogflowCxV3beta1QueryParameters `json:"queryParams,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PersistParameterChanges") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PersistParameterChanges") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1MatchIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1MatchIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1MatchIntentResponse: Response of MatchIntent.
type GoogleCloudDialogflowCxV3beta1MatchIntentResponse struct {
	// CurrentPage: The current Page. Some, not all fields are filled in this
	// message, including but not limited to `name` and `display_name`.
	CurrentPage *GoogleCloudDialogflowCxV3beta1Page `json:"currentPage,omitempty"`
	// Matches: Match results, if more than one, ordered descendingly by the
	// confidence we have that the particular intent matches the query.
	Matches []*GoogleCloudDialogflowCxV3beta1Match `json:"matches,omitempty"`
	// Text: If natural language text was provided as input, this field will
	// contain a copy of the text.
	Text string `json:"text,omitempty"`
	// Transcript: If natural language speech audio was provided as input, this
	// field will contain the transcript for the audio.
	Transcript string `json:"transcript,omitempty"`
	// TriggerEvent: If an event was provided as input, this field will contain a
	// copy of the event name.
	TriggerEvent string `json:"triggerEvent,omitempty"`
	// TriggerIntent: If an intent was provided as input, this field will contain a
	// copy of the intent identifier. Format:
	// `projects//locations//agents//intents/`.
	TriggerIntent string `json:"triggerIntent,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1MatchIntentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1MatchIntentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1NamedMetric: A named metric is a metric with
// name, value and unit.
type GoogleCloudDialogflowCxV3beta1NamedMetric struct {
	// Name: The name of the metric.
	Name string `json:"name,omitempty"`
	// Unit: The unit in which this metric is reported. Follows The Unified Code
	// for Units of Measure (https://unitsofmeasure.org/ucum.html) standard.
	Unit string `json:"unit,omitempty"`
	// Value: The value of the metric.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1NamedMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1NamedMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1NluSettings: Settings related to NLU.
type GoogleCloudDialogflowCxV3beta1NluSettings struct {
	// ClassificationThreshold: To filter out false positive results and still get
	// variety in matched natural language inputs for your agent, you can tune the
	// machine learning classification threshold. If the returned score value is
	// less than the threshold value, then a no-match event will be triggered. The
	// score values range from 0.0 (completely uncertain) to 1.0 (completely
	// certain). If set to 0.0, the default of 0.3 is used. You can set a separate
	// classification threshold for the flow in each language enabled for the
	// agent.
	ClassificationThreshold float64 `json:"classificationThreshold,omitempty"`
	// ModelTrainingMode: Indicates NLU model training mode.
	//
	// Possible values:
	//   "MODEL_TRAINING_MODE_UNSPECIFIED" - Not specified.
	// `MODEL_TRAINING_MODE_AUTOMATIC` will be used.
	//   "MODEL_TRAINING_MODE_AUTOMATIC" - NLU model training is automatically
	// triggered when a flow gets modified. User can also manually trigger model
	// training in this mode.
	//   "MODEL_TRAINING_MODE_MANUAL" - User needs to manually trigger NLU model
	// training. Best for large flows whose models take long time to train.
	ModelTrainingMode string `json:"modelTrainingMode,omitempty"`
	// ModelType: Indicates the type of NLU model.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Not specified. `MODEL_TYPE_STANDARD` will be
	// used.
	//   "MODEL_TYPE_STANDARD" - Use standard NLU model.
	//   "MODEL_TYPE_ADVANCED" - Use advanced NLU model.
	ModelType string `json:"modelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClassificationThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClassificationThreshold") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1NluSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1NluSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1NluSettings) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1NluSettings
	var s1 struct {
		ClassificationThreshold gensupport.JSONFloat64 `json:"classificationThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ClassificationThreshold = float64(s1.ClassificationThreshold)
	return nil
}

// GoogleCloudDialogflowCxV3beta1OutputAudioConfig: Instructs the speech
// synthesizer how to generate the output audio content.
type GoogleCloudDialogflowCxV3beta1OutputAudioConfig struct {
	// AudioEncoding: Required. Audio encoding of the synthesized audio content.
	//
	// Possible values:
	//   "OUTPUT_AUDIO_ENCODING_UNSPECIFIED" - Not specified.
	//   "OUTPUT_AUDIO_ENCODING_LINEAR_16" - Uncompressed 16-bit signed
	// little-endian samples (Linear PCM). Audio content returned as LINEAR16 also
	// contains a WAV header.
	//   "OUTPUT_AUDIO_ENCODING_MP3" - MP3 audio at 32kbps.
	//   "OUTPUT_AUDIO_ENCODING_MP3_64_KBPS" - MP3 audio at 64kbps.
	//   "OUTPUT_AUDIO_ENCODING_OGG_OPUS" - Opus encoded audio wrapped in an ogg
	// container. The result will be a file which can be played natively on
	// Android, and in browsers (at least Chrome and Firefox). The quality of the
	// encoding is considerably higher than MP3 while using approximately the same
	// bitrate.
	//   "OUTPUT_AUDIO_ENCODING_MULAW" - 8-bit samples that compand 14-bit audio
	// samples using G.711 PCMU/mu-law.
	//   "OUTPUT_AUDIO_ENCODING_ALAW" - 8-bit samples that compand 13-bit audio
	// samples using G.711 PCMU/a-law.
	AudioEncoding string `json:"audioEncoding,omitempty"`
	// SampleRateHertz: Optional. The synthesis sample rate (in hertz) for this
	// audio. If not provided, then the synthesizer will use the default sample
	// rate based on the audio encoding. If this is different from the voice's
	// natural sample rate, then the synthesizer will honor this request by
	// converting to the desired sample rate (which might result in worse audio
	// quality).
	SampleRateHertz int64 `json:"sampleRateHertz,omitempty"`
	// SynthesizeSpeechConfig: Optional. Configuration of how speech should be
	// synthesized. If not specified, Agent.text_to_speech_settings is applied.
	SynthesizeSpeechConfig *GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig `json:"synthesizeSpeechConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioEncoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioEncoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1OutputAudioConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1OutputAudioConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Page: A Dialogflow CX conversation (session)
// can be described and visualized as a state machine. The states of a CX
// session are represented by pages. For each flow, you define many pages,
// where your combined pages can handle a complete conversation on the topics
// the flow is designed for. At any given moment, exactly one page is the
// current page, the current page is considered active, and the flow associated
// with that page is considered active. Every flow has a special start page.
// When a flow initially becomes active, the start page page becomes the
// current page. For each conversational turn, the current page will either
// stay the same or transition to another page. You configure each page to
// collect information from the end-user that is relevant for the
// conversational state represented by the page. For more information, see the
// Page guide (https://cloud.google.com/dialogflow/cx/docs/concept/page).
type GoogleCloudDialogflowCxV3beta1Page struct {
	// AdvancedSettings: Hierarchical advanced settings for this page. The settings
	// exposed at the lower level overrides the settings exposed at the higher
	// level.
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings `json:"advancedSettings,omitempty"`
	// Description: The description of the page. The maximum length is 500
	// characters.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the page, unique within
	// the flow.
	DisplayName string `json:"displayName,omitempty"`
	// EntryFulfillment: The fulfillment to call when the session is entering the
	// page.
	EntryFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"entryFulfillment,omitempty"`
	// EventHandlers: Handlers associated with the page to handle events such as
	// webhook errors, no match or no input.
	EventHandlers []*GoogleCloudDialogflowCxV3beta1EventHandler `json:"eventHandlers,omitempty"`
	// Form: The form associated with the page, used for collecting parameters
	// relevant to the page.
	Form *GoogleCloudDialogflowCxV3beta1Form `json:"form,omitempty"`
	// KnowledgeConnectorSettings: Optional. Knowledge connector configuration.
	KnowledgeConnectorSettings *GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings `json:"knowledgeConnectorSettings,omitempty"`
	// Name: The unique identifier of the page. Required for the Pages.UpdatePage
	// method. Pages.CreatePage populates the name automatically. Format:
	// `projects//locations//agents//flows//pages/`.
	Name string `json:"name,omitempty"`
	// TransitionRouteGroups: Ordered list of `TransitionRouteGroups` added to the
	// page. Transition route groups must be unique within a page. If the page
	// links both flow-level transition route groups and agent-level transition
	// route groups, the flow-level ones will have higher priority and will be put
	// before the agent-level ones. * If multiple transition routes within a page
	// scope refer to the same intent, then the precedence order is: page's
	// transition route -> page's transition route group -> flow's transition
	// routes. * If multiple transition route groups within a page contain the same
	// intent, then the first group in the ordered list takes precedence.
	// Format:`projects//locations//agents//flows//transitionRouteGroups/` or
	// `projects//locations//agents//transitionRouteGroups/` for agent-level
	// groups.
	TransitionRouteGroups []string `json:"transitionRouteGroups,omitempty"`
	// TransitionRoutes: A list of transitions for the transition rules of this
	// page. They route the conversation to another page in the same flow, or
	// another flow. When we are in a certain page, the TransitionRoutes are
	// evaluated in the following order: * TransitionRoutes defined in the page
	// with intent specified. * TransitionRoutes defined in the transition route
	// groups with intent specified. * TransitionRoutes defined in flow with intent
	// specified. * TransitionRoutes defined in the transition route groups with
	// intent specified. * TransitionRoutes defined in the page with only condition
	// specified. * TransitionRoutes defined in the transition route groups with
	// only condition specified.
	TransitionRoutes []*GoogleCloudDialogflowCxV3beta1TransitionRoute `json:"transitionRoutes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Page) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Page
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PageInfo: Represents page information
// communicated to and from the webhook.
type GoogleCloudDialogflowCxV3beta1PageInfo struct {
	// CurrentPage: Always present for WebhookRequest. Ignored for WebhookResponse.
	// The unique identifier of the current page. Format:
	// `projects//locations//agents//flows//pages/`.
	CurrentPage string `json:"currentPage,omitempty"`
	// DisplayName: Always present for WebhookRequest. Ignored for WebhookResponse.
	// The display name of the current page.
	DisplayName string `json:"displayName,omitempty"`
	// FormInfo: Optional for both WebhookRequest and WebhookResponse. Information
	// about the form.
	FormInfo *GoogleCloudDialogflowCxV3beta1PageInfoFormInfo `json:"formInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CurrentPage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentPage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PageInfoFormInfo: Represents form information.
type GoogleCloudDialogflowCxV3beta1PageInfoFormInfo struct {
	// ParameterInfo: Optional for both WebhookRequest and WebhookResponse. The
	// parameters contained in the form. Note that the webhook cannot add or remove
	// any form parameter.
	ParameterInfo []*GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo `json:"parameterInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ParameterInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ParameterInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfoFormInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfoFormInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo: Represents
// parameter information.
type GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo struct {
	// DisplayName: Always present for WebhookRequest. Required for
	// WebhookResponse. The human-readable name of the parameter, unique within the
	// form. This field cannot be modified by the webhook.
	DisplayName string `json:"displayName,omitempty"`
	// JustCollected: Optional for WebhookRequest. Ignored for WebhookResponse.
	// Indicates if the parameter value was just collected on the last conversation
	// turn.
	JustCollected bool `json:"justCollected,omitempty"`
	// Required: Optional for both WebhookRequest and WebhookResponse. Indicates
	// whether the parameter is required. Optional parameters will not trigger
	// prompts; however, they are filled if the user specifies them. Required
	// parameters must be filled before form filling concludes.
	Required bool `json:"required,omitempty"`
	// State: Always present for WebhookRequest. Required for WebhookResponse. The
	// state of the parameter. This field can be set to INVALID by the webhook to
	// invalidate the parameter; other values set by the webhook will be ignored.
	//
	// Possible values:
	//   "PARAMETER_STATE_UNSPECIFIED" - Not specified. This value should be never
	// used.
	//   "EMPTY" - Indicates that the parameter does not have a value.
	//   "INVALID" - Indicates that the parameter value is invalid. This field can
	// be used by the webhook to invalidate the parameter and ask the server to
	// collect it from the user again.
	//   "FILLED" - Indicates that the parameter has a value.
	State string `json:"state,omitempty"`
	// Value: Optional for both WebhookRequest and WebhookResponse. The value of
	// the parameter. This field can be set by the webhook to change the parameter
	// value.
	Value interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ParameterDefinition: Defines the properties of
// a parameter. Used to define parameters used in the agent and the input /
// output parameters for each fulfillment.
type GoogleCloudDialogflowCxV3beta1ParameterDefinition struct {
	// Description: Human-readable description of the parameter. Limited to 300
	// characters.
	Description string `json:"description,omitempty"`
	// Name: Required. Name of parameter.
	Name string `json:"name,omitempty"`
	// Type: Type of parameter.
	//
	// Possible values:
	//   "PARAMETER_TYPE_UNSPECIFIED" - Not specified. No validation will be
	// performed.
	//   "STRING" - Represents any string value.
	//   "NUMBER" - Represents any number value.
	//   "BOOLEAN" - Represents a boolean value.
	//   "NULL" - Represents a null value.
	//   "OBJECT" - Represents any object value.
	//   "LIST" - Represents a repeated value.
	Type string `json:"type,omitempty"`
	// TypeSchema: Optional. Type schema of parameter.
	TypeSchema *GoogleCloudDialogflowCxV3beta1TypeSchema `json:"typeSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ParameterDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ParameterDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Phrase: Text input which can be used for
// prompt or banned phrases.
type GoogleCloudDialogflowCxV3beta1Phrase struct {
	// Text: Required. Text input which can be used for prompt or banned phrases.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Phrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Phrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Playbook: Playbook is the basic building block
// to instruct the LLM how to execute a certain task. A playbook consists of a
// goal to accomplish, an optional list of step by step instructions (the step
// instruction may refers to name of the custom or default plugin tools to use)
// to perform the task, a list of contextual input data to be passed in at the
// beginning of the invoked, and a list of output parameters to store the
// playbook result.
type GoogleCloudDialogflowCxV3beta1Playbook struct {
	// CreateTime: Output only. The timestamp of initial playbook creation.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The human-readable name of the playbook, unique
	// within an agent.
	DisplayName string `json:"displayName,omitempty"`
	// Goal: Required. High level description of the goal the playbook intend to
	// accomplish. A goal should be concise since it's visible to other playbooks
	// that may reference this playbook.
	Goal string `json:"goal,omitempty"`
	// Handlers: Optional. A list of registered handlers to execute based on the
	// specified triggers.
	Handlers []*GoogleCloudDialogflowCxV3beta1Handler `json:"handlers,omitempty"`
	// InputParameterDefinitions: Optional. Defined structured input parameters for
	// this playbook.
	InputParameterDefinitions []*GoogleCloudDialogflowCxV3beta1ParameterDefinition `json:"inputParameterDefinitions,omitempty"`
	// Instruction: Instruction to accomplish target goal.
	Instruction *GoogleCloudDialogflowCxV3beta1PlaybookInstruction `json:"instruction,omitempty"`
	// LlmModelSettings: Optional. Llm model settings for the playbook.
	LlmModelSettings *GoogleCloudDialogflowCxV3beta1LlmModelSettings `json:"llmModelSettings,omitempty"`
	// Name: The unique identifier of the playbook. Format:
	// `projects//locations//agents//playbooks/`.
	Name string `json:"name,omitempty"`
	// OutputParameterDefinitions: Optional. Defined structured output parameters
	// for this playbook.
	OutputParameterDefinitions []*GoogleCloudDialogflowCxV3beta1ParameterDefinition `json:"outputParameterDefinitions,omitempty"`
	// PlaybookType: Optional. Type of the playbook.
	//
	// Possible values:
	//   "PLAYBOOK_TYPE_UNSPECIFIED" - Unspecified type. Default to TASK.
	//   "TASK" - Task playbook.
	//   "ROUTINE" - Routine playbook.
	PlaybookType string `json:"playbookType,omitempty"`
	// ReferencedFlows: Output only. The resource name of flows referenced by the
	// current playbook in the instructions.
	ReferencedFlows []string `json:"referencedFlows,omitempty"`
	// ReferencedPlaybooks: Output only. The resource name of other playbooks
	// referenced by the current playbook in the instructions.
	ReferencedPlaybooks []string `json:"referencedPlaybooks,omitempty"`
	// ReferencedTools: Optional. The resource name of tools referenced by the
	// current playbook in the instructions. If not provided explicitly, they are
	// will be implied using the tool being referenced in goal and steps.
	ReferencedTools []string `json:"referencedTools,omitempty"`
	// SpeechSettings: Optional. Playbook level Settings for speech to text
	// detection.
	SpeechSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings `json:"speechSettings,omitempty"`
	// TokenCount: Output only. Estimated number of tokes current playbook takes
	// when sent to the LLM.
	TokenCount int64 `json:"tokenCount,omitempty,string"`
	// UpdateTime: Output only. Last time the playbook version was updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Playbook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Playbook
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PlaybookImportStrategy: The playbook import
// strategy used for resource conflict resolution associated with an
// ImportPlaybookRequest.
type GoogleCloudDialogflowCxV3beta1PlaybookImportStrategy struct {
	// MainPlaybookImportStrategy: Optional. Specifies the import strategy used
	// when resolving conflicts with the main playbook. If not specified,
	// 'CREATE_NEW' is assumed.
	//
	// Possible values:
	//   "IMPORT_STRATEGY_UNSPECIFIED" - Unspecified. Treated as 'CREATE_NEW'.
	//   "IMPORT_STRATEGY_CREATE_NEW" - Create a new resource with a numeric suffix
	// appended to the end of the existing display name.
	//   "IMPORT_STRATEGY_REPLACE" - Replace existing resource with incoming
	// resource in the content to be imported.
	//   "IMPORT_STRATEGY_KEEP" - Keep existing resource and discard incoming
	// resource in the content to be imported.
	//   "IMPORT_STRATEGY_MERGE" - Combine existing and incoming resources when a
	// conflict is encountered.
	//   "IMPORT_STRATEGY_THROW_ERROR" - Throw error if a conflict is encountered.
	MainPlaybookImportStrategy string `json:"mainPlaybookImportStrategy,omitempty"`
	// NestedResourceImportStrategy: Optional. Specifies the import strategy used
	// when resolving referenced playbook/flow conflicts. If not specified,
	// 'CREATE_NEW' is assumed.
	//
	// Possible values:
	//   "IMPORT_STRATEGY_UNSPECIFIED" - Unspecified. Treated as 'CREATE_NEW'.
	//   "IMPORT_STRATEGY_CREATE_NEW" - Create a new resource with a numeric suffix
	// appended to the end of the existing display name.
	//   "IMPORT_STRATEGY_REPLACE" - Replace existing resource with incoming
	// resource in the content to be imported.
	//   "IMPORT_STRATEGY_KEEP" - Keep existing resource and discard incoming
	// resource in the content to be imported.
	//   "IMPORT_STRATEGY_MERGE" - Combine existing and incoming resources when a
	// conflict is encountered.
	//   "IMPORT_STRATEGY_THROW_ERROR" - Throw error if a conflict is encountered.
	NestedResourceImportStrategy string `json:"nestedResourceImportStrategy,omitempty"`
	// ToolImportStrategy: Optional. Specifies the import strategy used when
	// resolving tool conflicts. If not specified, 'CREATE_NEW' is assumed. This
	// will be applied after the main playbook and nested resource import
	// strategies, meaning if the playbook that references the tool is skipped, the
	// tool will also be skipped.
	//
	// Possible values:
	//   "IMPORT_STRATEGY_UNSPECIFIED" - Unspecified. Treated as 'CREATE_NEW'.
	//   "IMPORT_STRATEGY_CREATE_NEW" - Create a new resource with a numeric suffix
	// appended to the end of the existing display name.
	//   "IMPORT_STRATEGY_REPLACE" - Replace existing resource with incoming
	// resource in the content to be imported.
	//   "IMPORT_STRATEGY_KEEP" - Keep existing resource and discard incoming
	// resource in the content to be imported.
	//   "IMPORT_STRATEGY_MERGE" - Combine existing and incoming resources when a
	// conflict is encountered.
	//   "IMPORT_STRATEGY_THROW_ERROR" - Throw error if a conflict is encountered.
	ToolImportStrategy string `json:"toolImportStrategy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MainPlaybookImportStrategy")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MainPlaybookImportStrategy") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PlaybookImportStrategy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PlaybookImportStrategy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PlaybookInput: Input of the playbook.
type GoogleCloudDialogflowCxV3beta1PlaybookInput struct {
	// ActionParameters: Optional. A list of input parameters for the action.
	ActionParameters googleapi.RawMessage `json:"actionParameters,omitempty"`
	// PrecedingConversationSummary: Optional. Summary string of the preceding
	// conversation for the child playbook invocation.
	PrecedingConversationSummary string `json:"precedingConversationSummary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionParameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionParameters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PlaybookInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PlaybookInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PlaybookInstruction: Message of the
// Instruction of the playbook.
type GoogleCloudDialogflowCxV3beta1PlaybookInstruction struct {
	// Guidelines: General guidelines for the playbook. These are unstructured
	// instructions that are not directly part of the goal, e.g. "Always be
	// polite". It's valid for this text to be long and used instead of steps
	// altogether.
	Guidelines string `json:"guidelines,omitempty"`
	// Steps: Ordered list of step by step execution instructions to accomplish
	// target goal.
	Steps []*GoogleCloudDialogflowCxV3beta1PlaybookStep `json:"steps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Guidelines") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Guidelines") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PlaybookInstruction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PlaybookInstruction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PlaybookInvocation: Stores metadata of the
// invocation of a child playbook. Playbook invocation actions enter the child
// playbook.
type GoogleCloudDialogflowCxV3beta1PlaybookInvocation struct {
	// DisplayName: Output only. The display name of the playbook.
	DisplayName string `json:"displayName,omitempty"`
	// Playbook: Required. The unique identifier of the playbook. Format:
	// `projects//locations//agents//playbooks/`.
	Playbook string `json:"playbook,omitempty"`
	// PlaybookInput: Optional. Input of the child playbook invocation.
	PlaybookInput *GoogleCloudDialogflowCxV3beta1PlaybookInput `json:"playbookInput,omitempty"`
	// PlaybookOutput: Optional. Output of the child playbook invocation.
	PlaybookOutput *GoogleCloudDialogflowCxV3beta1PlaybookOutput `json:"playbookOutput,omitempty"`
	// PlaybookState: Required. Playbook invocation's output state.
	//
	// Possible values:
	//   "OUTPUT_STATE_UNSPECIFIED" - Unspecified output.
	//   "OUTPUT_STATE_OK" - Succeeded.
	//   "OUTPUT_STATE_CANCELLED" - Cancelled.
	//   "OUTPUT_STATE_FAILED" - Failed.
	//   "OUTPUT_STATE_ESCALATED" - Escalated.
	//   "OUTPUT_STATE_PENDING" - Pending.
	PlaybookState string `json:"playbookState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PlaybookInvocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PlaybookInvocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PlaybookOutput: Output of the playbook.
type GoogleCloudDialogflowCxV3beta1PlaybookOutput struct {
	// ActionParameters: Optional. A Struct object of output parameters for the
	// action.
	ActionParameters googleapi.RawMessage `json:"actionParameters,omitempty"`
	// ExecutionSummary: Optional. Summary string of the execution result of the
	// child playbook.
	ExecutionSummary string `json:"executionSummary,omitempty"`
	// State: End state of the playbook.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "OK" - Playbook succeeded.
	//   "CANCELLED" - Playbook cancelled.
	//   "FAILED" - Playbook failed.
	//   "ESCALATED" - Playbook failed due to escalation.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionParameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionParameters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PlaybookOutput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PlaybookOutput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PlaybookStep: Message of single step
// execution.
type GoogleCloudDialogflowCxV3beta1PlaybookStep struct {
	// Steps: Sub-processing needed to execute the current step.
	Steps []*GoogleCloudDialogflowCxV3beta1PlaybookStep `json:"steps,omitempty"`
	// Text: Step instruction in text format.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Steps") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Steps") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PlaybookStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PlaybookStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PlaybookTransition: Stores metadata of the
// transition to another target playbook. Playbook transition actions exit the
// caller playbook and enter the target playbook.
type GoogleCloudDialogflowCxV3beta1PlaybookTransition struct {
	// DisplayName: Output only. The display name of the playbook.
	DisplayName string `json:"displayName,omitempty"`
	// InputActionParameters: A list of input parameters for the action.
	InputActionParameters googleapi.RawMessage `json:"inputActionParameters,omitempty"`
	// Playbook: Required. The unique identifier of the playbook. Format:
	// `projects//locations//agents//playbooks/`.
	Playbook string `json:"playbook,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PlaybookTransition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PlaybookTransition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1PlaybookVersion: Playbook version is a
// snapshot of the playbook at certain timestamp.
type GoogleCloudDialogflowCxV3beta1PlaybookVersion struct {
	// Description: Optional. The description of the playbook version.
	Description string `json:"description,omitempty"`
	// Examples: Output only. Snapshot of the examples belonging to the playbook
	// when the playbook version is created.
	Examples []*GoogleCloudDialogflowCxV3beta1Example `json:"examples,omitempty"`
	// Name: The unique identifier of the playbook version. Format:
	// `projects//locations//agents//playbooks//versions/`.
	Name string `json:"name,omitempty"`
	// Playbook: Output only. Snapshot of the playbook when the playbook version is
	// created.
	Playbook *GoogleCloudDialogflowCxV3beta1Playbook `json:"playbook,omitempty"`
	// UpdateTime: Output only. Last time the playbook version was created or
	// modified.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1PlaybookVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1PlaybookVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1QueryInput: Represents the query input. It can
// contain one of: 1. A conversational query in the form of text. 2. An intent
// query that specifies which intent to trigger. 3. Natural language speech
// audio to be processed. 4. An event to be triggered. 5. DTMF digits to invoke
// an intent and fill in parameter value. 6. The results of a tool executed by
// the client.
type GoogleCloudDialogflowCxV3beta1QueryInput struct {
	// Audio: The natural language speech audio to be processed.
	Audio *GoogleCloudDialogflowCxV3beta1AudioInput `json:"audio,omitempty"`
	// Dtmf: The DTMF event to be handled.
	Dtmf *GoogleCloudDialogflowCxV3beta1DtmfInput `json:"dtmf,omitempty"`
	// Event: The event to be triggered.
	Event *GoogleCloudDialogflowCxV3beta1EventInput `json:"event,omitempty"`
	// Intent: The intent to be triggered.
	Intent *GoogleCloudDialogflowCxV3beta1IntentInput `json:"intent,omitempty"`
	// LanguageCode: Required. The language of the input. See Language Support
	// (https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list
	// of the currently supported language codes. Note that queries in the same
	// session do not necessarily need to specify the same language.
	LanguageCode string `json:"languageCode,omitempty"`
	// Text: The natural language text to be processed.
	Text *GoogleCloudDialogflowCxV3beta1TextInput `json:"text,omitempty"`
	// ToolCallResult: The results of a tool executed by the client.
	ToolCallResult *GoogleCloudDialogflowCxV3beta1ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1QueryInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1QueryInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1QueryParameters: Represents the parameters of
// a conversational query.
type GoogleCloudDialogflowCxV3beta1QueryParameters struct {
	// AnalyzeQueryTextSentiment: Configures whether sentiment analysis should be
	// performed. If not provided, sentiment analysis is not performed.
	AnalyzeQueryTextSentiment bool `json:"analyzeQueryTextSentiment,omitempty"`
	// Channel: The channel which this query is for. If specified, only the
	// ResponseMessage associated with the channel will be returned. If no
	// ResponseMessage is associated with the channel, it falls back to the
	// ResponseMessage with unspecified channel. If unspecified, the
	// ResponseMessage with unspecified channel will be returned.
	Channel string `json:"channel,omitempty"`
	// CurrentPage: The unique identifier of the page to override the current page
	// in the session. Format: `projects//locations//agents//flows//pages/`. If
	// `current_page` is specified, the previous state of the session will be
	// ignored by Dialogflow, including the previous page and the previous session
	// parameters. In most cases, current_page and parameters should be configured
	// together to direct a session to a specific state.
	CurrentPage string `json:"currentPage,omitempty"`
	// CurrentPlaybook: Optional. The unique identifier of the playbook to start or
	// continue the session with. If `current_playbook` is specified, the previous
	// state of the session will be ignored by Dialogflow. Format:
	// `projects//locations//agents//playbooks/`.
	CurrentPlaybook string `json:"currentPlaybook,omitempty"`
	// DisableWebhook: Whether to disable webhook calls for this request.
	DisableWebhook bool `json:"disableWebhook,omitempty"`
	// EndUserMetadata: Optional. Information about the end-user to improve the
	// relevance and accuracy of generative answers. This will be interpreted and
	// used by a language model, so, for good results, the data should be
	// self-descriptive, and in a simple structure. Example: ```json {
	// "subscription plan": "Business Premium Plus", "devices owned": [ {"model":
	// "Google Pixel 7"}, {"model": "Google Pixel Tablet"} ] } ```
	EndUserMetadata googleapi.RawMessage `json:"endUserMetadata,omitempty"`
	// FlowVersions: A list of flow versions to override for the request. Format:
	// `projects//locations//agents//flows//versions/`. If version 1 of flow X is
	// included in this list, the traffic of flow X will go through version 1
	// regardless of the version configuration in the environment. Each flow can
	// have at most one version specified in this list.
	FlowVersions []string `json:"flowVersions,omitempty"`
	// GeoLocation: The geo location of this conversational query.
	GeoLocation *GoogleTypeLatLng `json:"geoLocation,omitempty"`
	// LlmModelSettings: Optional. Use the specified LLM model settings for
	// processing the request.
	LlmModelSettings *GoogleCloudDialogflowCxV3beta1LlmModelSettings `json:"llmModelSettings,omitempty"`
	// ParameterScope: Scope for the parameters. If not specified, parameters will
	// be treated as session parameters. Parameters with custom scope will not be
	// put into session parameters. You can reference the parameters with custom
	// scope in the agent with the following format:
	// $parameter-scope.params.parameter-id.
	ParameterScope string `json:"parameterScope,omitempty"`
	// Parameters: Additional parameters to be put into session parameters. To
	// remove a parameter from the session, clients should explicitly set the
	// parameter value to null. You can reference the session parameters in the
	// agent with the following format: $session.params.parameter-id. Depending on
	// your protocol or client library language, this is a map, associative array,
	// symbol table, dictionary, or JSON object composed of a collection of
	// (MapKey, MapValue) pairs: * MapKey type: string * MapKey value: parameter
	// name * MapValue type: If parameter's entity type is a composite entity then
	// use map, otherwise, depending on the parameter value type, it could be one
	// of string, number, boolean, null, list or map. * MapValue value: If
	// parameter's entity type is a composite entity then use map from composite
	// entity property names to property values, otherwise, use parameter value.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// Payload: This field can be used to pass custom data into the webhook
	// associated with the agent. Arbitrary JSON objects are supported. Some
	// integrations that query a Dialogflow agent may provide additional
	// information in the payload. In particular, for the Dialogflow Phone Gateway
	// integration, this field has the form: ``` { "telephony": { "caller_id":
	// "+18558363987" } } ```
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// PopulateDataStoreConnectionSignals: Optional. If set to true and data stores
	// are involved in serving the request then
	// DetectIntentResponse.query_result.data_store_connection_signals will be
	// filled with data that can help evaluations.
	PopulateDataStoreConnectionSignals bool `json:"populateDataStoreConnectionSignals,omitempty"`
	// SearchConfig: Optional. Search configuration for UCS search queries.
	SearchConfig *GoogleCloudDialogflowCxV3beta1SearchConfig `json:"searchConfig,omitempty"`
	// SessionEntityTypes: Additional session entity types to replace or extend
	// developer entity types with. The entity synonyms apply to all languages and
	// persist for the session of this query.
	SessionEntityTypes []*GoogleCloudDialogflowCxV3beta1SessionEntityType `json:"sessionEntityTypes,omitempty"`
	// SessionTtl: Optional. Configure lifetime of the Dialogflow session. By
	// default, a Dialogflow session remains active and its data is stored for 30
	// minutes after the last request is sent for the session. This value should be
	// no longer than 1 day.
	SessionTtl string `json:"sessionTtl,omitempty"`
	// TimeZone: The time zone of this conversational query from the time zone
	// database (https://www.iana.org/time-zones), e.g., America/New_York,
	// Europe/Paris. If not provided, the time zone specified in the agent is used.
	TimeZone string `json:"timeZone,omitempty"`
	// WebhookHeaders: This field can be used to pass HTTP headers for a webhook
	// call. These headers will be sent to webhook along with the headers that have
	// been configured through Dialogflow web console. The headers defined within
	// this field will overwrite the headers configured through Dialogflow console
	// if there is a conflict. Header names are case-insensitive. Google's
	// specified headers are not allowed. Including: "Host", "Content-Length",
	// "Connection", "From", "User-Agent", "Accept-Encoding", "If-Modified-Since",
	// "If-None-Match", "X-Forwarded-For", etc.
	WebhookHeaders map[string]string `json:"webhookHeaders,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalyzeQueryTextSentiment")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyzeQueryTextSentiment") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1QueryParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1QueryParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1QueryResult: Represents the result of a
// conversational query.
type GoogleCloudDialogflowCxV3beta1QueryResult struct {
	// AdvancedSettings: Returns the current advanced settings including IVR
	// settings. Even though the operations configured by these settings are
	// performed by Dialogflow, the client may need to perform special logic at the
	// moment. For example, if Dialogflow exports audio to Google Cloud Storage,
	// then the client may need to wait for the resulting object to appear in the
	// bucket before proceeding.
	AdvancedSettings *GoogleCloudDialogflowCxV3beta1AdvancedSettings `json:"advancedSettings,omitempty"`
	// AllowAnswerFeedback: Indicates whether the Thumbs up/Thumbs down rating
	// controls are need to be shown for the response in the Dialogflow Messenger
	// widget.
	AllowAnswerFeedback bool `json:"allowAnswerFeedback,omitempty"`
	// CurrentFlow: The current Flow. Some, not all fields are filled in this
	// message, including but not limited to `name` and `display_name`.
	CurrentFlow *GoogleCloudDialogflowCxV3beta1Flow `json:"currentFlow,omitempty"`
	// CurrentPage: The current Page. Some, not all fields are filled in this
	// message, including but not limited to `name` and `display_name`.
	CurrentPage *GoogleCloudDialogflowCxV3beta1Page `json:"currentPage,omitempty"`
	// DataStoreConnectionSignals: Optional. Data store connection feature output
	// signals. Filled only when data stores are involved in serving the query.
	DataStoreConnectionSignals *GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignals `json:"dataStoreConnectionSignals,omitempty"`
	// DiagnosticInfo: The free-form diagnostic info. For example, this field could
	// contain webhook call latency. The fields of this data can change without
	// notice, so you should not write code that depends on its structure. One of
	// the fields is called "Alternative Matched Intents", which may aid with
	// debugging. The following describes these intent results: - The list is empty
	// if no intent was matched to end-user input. - Only intents that are
	// referenced in the currently active flow are included. - The matched intent
	// is included. - Other intents that could have matched end-user input, but did
	// not match because they are referenced by intent routes that are out of scope
	// (https://cloud.google.com/dialogflow/cx/docs/concept/handler#scope), are
	// included. - Other intents referenced by intent routes in scope that matched
	// end-user input, but had a lower confidence score.
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`
	// Dtmf: If a DTMF was provided as input, this field will contain a copy of the
	// DtmfInput.
	Dtmf *GoogleCloudDialogflowCxV3beta1DtmfInput `json:"dtmf,omitempty"`
	// GenerativeInfo: The information of a query if handled by generative agent
	// resources.
	GenerativeInfo *GoogleCloudDialogflowCxV3beta1GenerativeInfo `json:"generativeInfo,omitempty"`
	// Intent: The Intent that matched the conversational query. Some, not all
	// fields are filled in this message, including but not limited to: `name` and
	// `display_name`. This field is deprecated, please use QueryResult.match
	// instead.
	Intent *GoogleCloudDialogflowCxV3beta1Intent `json:"intent,omitempty"`
	// IntentDetectionConfidence: The intent detection confidence. Values range
	// from 0.0 (completely uncertain) to 1.0 (completely certain). This value is
	// for informational purpose only and is only used to help match the best
	// intent within the classification threshold. This value may change for the
	// same end-user expression at any time due to a model retraining or change in
	// implementation. This field is deprecated, please use QueryResult.match
	// instead.
	IntentDetectionConfidence float64 `json:"intentDetectionConfidence,omitempty"`
	// LanguageCode: The language that was triggered during intent detection. See
	// Language Support
	// (https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list
	// of the currently supported language codes.
	LanguageCode string `json:"languageCode,omitempty"`
	// Match: Intent match result, could be an intent or an event.
	Match *GoogleCloudDialogflowCxV3beta1Match `json:"match,omitempty"`
	// Parameters: The collected session parameters. Depending on your protocol or
	// client library language, this is a map, associative array, symbol table,
	// dictionary, or JSON object composed of a collection of (MapKey, MapValue)
	// pairs: * MapKey type: string * MapKey value: parameter name * MapValue type:
	// If parameter's entity type is a composite entity then use map, otherwise,
	// depending on the parameter value type, it could be one of string, number,
	// boolean, null, list or map. * MapValue value: If parameter's entity type is
	// a composite entity then use map from composite entity property names to
	// property values, otherwise, use parameter value.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ResponseMessages: The list of rich messages returned to the client.
	// Responses vary from simple text messages to more sophisticated, structured
	// payloads used to drive complex logic.
	ResponseMessages []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"responseMessages,omitempty"`
	// SentimentAnalysisResult: The sentiment analyss result, which depends on
	// `analyze_query_text_sentiment`, specified in the request.
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	// Text: If natural language text was provided as input, this field will
	// contain a copy of the text.
	Text string `json:"text,omitempty"`
	// Transcript: If natural language speech audio was provided as input, this
	// field will contain the transcript for the audio.
	Transcript string `json:"transcript,omitempty"`
	// TriggerEvent: If an event was provided as input, this field will contain the
	// name of the event.
	TriggerEvent string `json:"triggerEvent,omitempty"`
	// TriggerIntent: If an intent was provided as input, this field will contain a
	// copy of the intent identifier. Format:
	// `projects//locations//agents//intents/`.
	TriggerIntent string `json:"triggerIntent,omitempty"`
	// WebhookDisplayNames: The list of webhook display names in the order of call
	// sequence.
	WebhookDisplayNames []string `json:"webhookDisplayNames,omitempty"`
	// WebhookIds: The list of webhook ids in the order of call sequence.
	WebhookIds []string `json:"webhookIds,omitempty"`
	// WebhookLatencies: The list of webhook latencies in the order of call
	// sequence.
	WebhookLatencies []string `json:"webhookLatencies,omitempty"`
	// WebhookPayloads: The list of webhook payload in WebhookResponse.payload, in
	// the order of call sequence. If some webhook call fails or doesn't return any
	// payload, an empty `Struct` would be used instead.
	WebhookPayloads []googleapi.RawMessage `json:"webhookPayloads,omitempty"`
	// WebhookStatuses: The list of webhook call status in the order of call
	// sequence.
	WebhookStatuses []*GoogleRpcStatus `json:"webhookStatuses,omitempty"`
	// WebhookTags: The list of webhook tags in the order of call sequence.
	WebhookTags []string `json:"webhookTags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdvancedSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdvancedSettings") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1QueryResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1QueryResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1QueryResult
	var s1 struct {
		IntentDetectionConfidence gensupport.JSONFloat64 `json:"intentDetectionConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IntentDetectionConfidence = float64(s1.IntentDetectionConfidence)
	return nil
}

// GoogleCloudDialogflowCxV3beta1ResourceName: Resource name and display name.
type GoogleCloudDialogflowCxV3beta1ResourceName struct {
	// DisplayName: Display name.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResourceName) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResourceName
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessage: Represents a response message
// that can be returned by a conversational agent. Response messages are also
// used for output audio synthesis. The approach is as follows: * If at least
// one OutputAudioText response is present, then all OutputAudioText responses
// are linearly concatenated, and the result is used for output audio
// synthesis. * If the OutputAudioText responses are a mixture of text and
// SSML, then the concatenated result is treated as SSML; otherwise, the result
// is treated as either text or SSML as appropriate. The agent designer should
// ideally use either text or SSML consistently throughout the bot design. *
// Otherwise, all Text responses are linearly concatenated, and the result is
// used for output audio synthesis. This approach allows for more sophisticated
// user experience scenarios, where the text displayed to the user may differ
// from what is heard.
type GoogleCloudDialogflowCxV3beta1ResponseMessage struct {
	// Channel: The channel which the response is associated with. Clients can
	// specify the channel via QueryParameters.channel, and only associated channel
	// response will be returned.
	Channel string `json:"channel,omitempty"`
	// ConversationSuccess: Indicates that the conversation succeeded.
	ConversationSuccess *GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess `json:"conversationSuccess,omitempty"`
	// EndInteraction: Output only. A signal that indicates the interaction with
	// the Dialogflow agent has ended. This message is generated by Dialogflow only
	// when the conversation reaches `END_SESSION` page. It is not supposed to be
	// defined by the user. It's guaranteed that there is at most one such message
	// in each response.
	EndInteraction *GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction `json:"endInteraction,omitempty"`
	// KnowledgeInfoCard: Represents info card for knowledge answers, to be better
	// rendered in Dialogflow Messenger.
	KnowledgeInfoCard *GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard `json:"knowledgeInfoCard,omitempty"`
	// LiveAgentHandoff: Hands off conversation to a human agent.
	LiveAgentHandoff *GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff `json:"liveAgentHandoff,omitempty"`
	// MixedAudio: Output only. An audio response message composed of both the
	// synthesized Dialogflow agent responses and responses defined via play_audio.
	// This message is generated by Dialogflow only and not supposed to be defined
	// by the user.
	MixedAudio *GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio `json:"mixedAudio,omitempty"`
	// OutputAudioText: A text or ssml response that is preferentially used for TTS
	// output audio synthesis, as described in the comment on the ResponseMessage
	// message.
	OutputAudioText *GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText `json:"outputAudioText,omitempty"`
	// Payload: Returns a response containing a custom, platform-specific payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// PlayAudio: Signal that the client should play an audio clip hosted at a
	// client-specific URI. Dialogflow uses this to construct mixed_audio. However,
	// Dialogflow itself does not try to read or process the URI in any way.
	PlayAudio *GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio `json:"playAudio,omitempty"`
	// TelephonyTransferCall: A signal that the client should transfer the phone
	// call connected to this agent to a third-party endpoint.
	TelephonyTransferCall *GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall `json:"telephonyTransferCall,omitempty"`
	// Text: Returns a text response.
	Text *GoogleCloudDialogflowCxV3beta1ResponseMessageText `json:"text,omitempty"`
	// ToolCall: Returns the definition of a tool call that should be executed by
	// the client.
	ToolCall *GoogleCloudDialogflowCxV3beta1ToolCall `json:"toolCall,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess: Indicates
// that the conversation succeeded, i.e., the bot handled the issue that the
// customer talked to it about. Dialogflow only uses this to determine which
// conversations should be counted as successful and doesn't process the
// metadata in this message in any way. Note that Dialogflow also considers
// conversations that get to the conversation end page as successful even if
// they don't return ConversationSuccess. You may set this, for example: * In
// the entry_fulfillment of a Page if entering the page indicates that the
// conversation succeeded. * In a webhook response when you determine that you
// handled the customer issue.
type GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess struct {
	// Metadata: Custom metadata. Dialogflow doesn't impose any structure on this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction: Indicates that
// interaction with the Dialogflow agent has ended. This message is generated
// by Dialogflow only and not supposed to be defined by the user.
type GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction struct {
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard: Represents
// info card response. If the response contains generative knowledge
// prediction, Dialogflow will return a payload with Infobot Messenger
// compatible info card. Otherwise, the info card response is skipped.
type GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard struct {
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff: Indicates
// that the conversation should be handed off to a live agent. Dialogflow only
// uses this to determine which conversations were handed off to a human agent
// for measurement purposes. What else to do with this signal is up to you and
// your handoff procedures. You may set this, for example: * In the
// entry_fulfillment of a Page if entering the page indicates something went
// extremely wrong in the conversation. * In a webhook response when you
// determine that the customer issue can only be handled by a human.
type GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff struct {
	// Metadata: Custom metadata for your handoff procedure. Dialogflow doesn't
	// impose any structure on this.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio: Represents an audio
// message that is composed of both segments synthesized from the Dialogflow
// agent prompts and ones hosted externally at the specified URIs. The external
// URIs are specified via play_audio. This message is generated by Dialogflow
// only and not supposed to be defined by the user.
type GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio struct {
	// Segments: Segments this audio response is composed of.
	Segments []*GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment `json:"segments,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Segments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Segments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment: Represents
// one segment of audio.
type GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this segment
	// can be interrupted by the end user's speech and the client should then start
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Audio: Raw audio synthesized from the Dialogflow agent's response using the
	// output config specified in the request.
	Audio string `json:"audio,omitempty"`
	// Uri: Client-specific URI that points to an audio clip accessible to the
	// client. Dialogflow does not impose any validation on it.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText: A text or ssml
// response that is preferentially used for TTS output audio synthesis, as
// described in the comment on the ResponseMessage message.
type GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Ssml: The SSML text to be synthesized. For more information, see SSML
	// (/speech/text-to-speech/docs/ssml).
	Ssml string `json:"ssml,omitempty"`
	// Text: The raw text to be synthesized.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio: Specifies an audio
// clip to be played by the client as part of the response.
type GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// AudioUri: Required. URI of the audio clip. Dialogflow does not impose any
	// validation on this value. It is specific to the client that reads it.
	AudioUri string `json:"audioUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall:
// Represents the signal that telles the client to transfer the phone call
// connected to the agent to a third-party endpoint.
type GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall struct {
	// PhoneNumber: Transfer the call to a phone number in E.164 format
	// (https://en.wikipedia.org/wiki/E.164).
	PhoneNumber string `json:"phoneNumber,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PhoneNumber") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PhoneNumber") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ResponseMessageText: The text response
// message.
type GoogleCloudDialogflowCxV3beta1ResponseMessageText struct {
	// AllowPlaybackInterruption: Output only. Whether the playback of this message
	// can be interrupted by the end user's speech and the client can then starts
	// the next Dialogflow request.
	AllowPlaybackInterruption bool `json:"allowPlaybackInterruption,omitempty"`
	// Text: Required. A collection of text response variants. If multiple variants
	// are defined, only one text response variant is returned at runtime.
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPlaybackInterruption")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPlaybackInterruption") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ResponseMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ResponseMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RestoreAgentRequest: The request message for
// Agents.RestoreAgent.
type GoogleCloudDialogflowCxV3beta1RestoreAgentRequest struct {
	// AgentContent: Uncompressed raw byte content for agent.
	AgentContent string `json:"agentContent,omitempty"`
	// AgentUri: The Google Cloud Storage (https://cloud.google.com/storage/docs/)
	// URI to restore agent from. The format of this URI must be `gs:///`.
	// Dialogflow performs a read operation for the Cloud Storage object on the
	// caller's behalf, so your request authentication must have read permissions
	// for the object. For more information, see Dialogflow access control
	// (https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	AgentUri string `json:"agentUri,omitempty"`
	// GitSource: Setting for restoring from a git branch
	GitSource *GoogleCloudDialogflowCxV3beta1RestoreAgentRequestGitSource `json:"gitSource,omitempty"`
	// RestoreOption: Agent restore mode. If not specified, `KEEP` is assumed.
	//
	// Possible values:
	//   "RESTORE_OPTION_UNSPECIFIED" - Unspecified. Treated as KEEP.
	//   "KEEP" - Always respect the settings from the exported agent file. It may
	// cause a restoration failure if some settings (e.g. model type) are not
	// supported in the target agent.
	//   "FALLBACK" - Fallback to default settings if some settings are not
	// supported in the target agent.
	RestoreOption string `json:"restoreOption,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RestoreAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RestoreAgentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RestoreAgentRequestGitSource: Settings for
// restoring from a git branch
type GoogleCloudDialogflowCxV3beta1RestoreAgentRequestGitSource struct {
	// TrackingBranch: tracking branch for the git pull
	TrackingBranch string `json:"trackingBranch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrackingBranch") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrackingBranch") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RestoreAgentRequestGitSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RestoreAgentRequestGitSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RestorePlaybookVersionRequest: The request
// message for Playbooks.RestorePlaybookVersion.
type GoogleCloudDialogflowCxV3beta1RestorePlaybookVersionRequest struct {
}

// GoogleCloudDialogflowCxV3beta1RestorePlaybookVersionResponse: The response
// message for Playbooks.RestorePlaybookVersion.
type GoogleCloudDialogflowCxV3beta1RestorePlaybookVersionResponse struct {
	// Playbook: The updated playbook.
	Playbook *GoogleCloudDialogflowCxV3beta1Playbook `json:"playbook,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Playbook") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Playbook") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RestorePlaybookVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RestorePlaybookVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RestoreToolVersionRequest: The request message
// for Tools.RestoreToolVersion.
type GoogleCloudDialogflowCxV3beta1RestoreToolVersionRequest struct {
}

// GoogleCloudDialogflowCxV3beta1RestoreToolVersionResponse: The response
// message for Tools.RestoreToolVersion.
type GoogleCloudDialogflowCxV3beta1RestoreToolVersionResponse struct {
	// Tool: The updated tool.
	Tool *GoogleCloudDialogflowCxV3beta1Tool `json:"tool,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Tool") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tool") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RestoreToolVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RestoreToolVersionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RolloutConfig: The configuration for auto
// rollout.
type GoogleCloudDialogflowCxV3beta1RolloutConfig struct {
	// FailureCondition: The conditions that are used to evaluate the failure of a
	// rollout step. If not specified, no rollout steps will fail. E.g.
	// "containment_rate < 10% OR average_turn_count < 3". See the conditions
	// reference (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	FailureCondition string `json:"failureCondition,omitempty"`
	// RolloutCondition: The conditions that are used to evaluate the success of a
	// rollout step. If not specified, all rollout steps will proceed to the next
	// one unless failure conditions are met. E.g. "containment_rate > 60% AND
	// callback_rate < 20%". See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	RolloutCondition string `json:"rolloutCondition,omitempty"`
	// RolloutSteps: Steps to roll out a flow version. Steps should be sorted by
	// percentage in ascending order.
	RolloutSteps []*GoogleCloudDialogflowCxV3beta1RolloutConfigRolloutStep `json:"rolloutSteps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailureCondition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailureCondition") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RolloutConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RolloutConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RolloutConfigRolloutStep: A single rollout
// step with specified traffic allocation.
type GoogleCloudDialogflowCxV3beta1RolloutConfigRolloutStep struct {
	// DisplayName: The name of the rollout step;
	DisplayName string `json:"displayName,omitempty"`
	// MinDuration: The minimum time that this step should last. Should be longer
	// than 1 hour. If not set, the default minimum duration for each step will be
	// 1 hour.
	MinDuration string `json:"minDuration,omitempty"`
	// TrafficPercent: The percentage of traffic allocated to the flow version of
	// this rollout step. (0%, 100%].
	TrafficPercent int64 `json:"trafficPercent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RolloutConfigRolloutStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RolloutConfigRolloutStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RolloutState: State of the auto-rollout
// process.
type GoogleCloudDialogflowCxV3beta1RolloutState struct {
	// StartTime: Start time of the current step.
	StartTime string `json:"startTime,omitempty"`
	// Step: Display name of the current auto rollout step.
	Step string `json:"step,omitempty"`
	// StepIndex: Index of the current step in the auto rollout steps list.
	StepIndex int64 `json:"stepIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StartTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StartTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RolloutState) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RolloutState
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata: Metadata returned
// for the Environments.RunContinuousTest long running operation.
type GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata struct {
	// Errors: The test errors.
	Errors []*GoogleCloudDialogflowCxV3beta1TestError `json:"errors,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RunContinuousTestRequest: The request message
// for Environments.RunContinuousTest.
type GoogleCloudDialogflowCxV3beta1RunContinuousTestRequest struct {
}

// GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse: The response
// message for Environments.RunContinuousTest.
type GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse struct {
	// ContinuousTestResult: The result for a continuous test run.
	ContinuousTestResult *GoogleCloudDialogflowCxV3beta1ContinuousTestResult `json:"continuousTestResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContinuousTestResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinuousTestResult") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RunTestCaseMetadata: Metadata returned for the
// TestCases.RunTestCase long running operation. This message currently has no
// fields.
type GoogleCloudDialogflowCxV3beta1RunTestCaseMetadata struct {
}

// GoogleCloudDialogflowCxV3beta1RunTestCaseRequest: The request message for
// TestCases.RunTestCase.
type GoogleCloudDialogflowCxV3beta1RunTestCaseRequest struct {
	// Environment: Optional. Environment name. If not set, draft environment is
	// assumed. Format: `projects//locations//agents//environments/`.
	Environment string `json:"environment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Environment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Environment") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunTestCaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunTestCaseRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1RunTestCaseResponse: The response message for
// TestCases.RunTestCase.
type GoogleCloudDialogflowCxV3beta1RunTestCaseResponse struct {
	// Result: The result.
	Result *GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"result,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Result") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Result") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1RunTestCaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1RunTestCaseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SafetySettings: Settings for Generative
// Safety.
type GoogleCloudDialogflowCxV3beta1SafetySettings struct {
	// BannedPhrases: Banned phrases for generated text.
	BannedPhrases []*GoogleCloudDialogflowCxV3beta1SafetySettingsPhrase `json:"bannedPhrases,omitempty"`
	// DefaultBannedPhraseMatchStrategy: Optional. Default phrase match strategy
	// for banned phrases.
	//
	// Possible values:
	//   "PHRASE_MATCH_STRATEGY_UNSPECIFIED" - Unspecified, defaults to
	// PARTIAL_MATCH.
	//   "PARTIAL_MATCH" - Text that contains the phrase as a substring will be
	// matched, e.g. "foo" will match "afoobar".
	//   "WORD_MATCH" - Text that contains the tokenized words of the phrase will
	// be matched, e.g. "foo" will match "a foo bar" and "foo bar", but not
	// "foobar".
	DefaultBannedPhraseMatchStrategy string `json:"defaultBannedPhraseMatchStrategy,omitempty"`
	// PromptSecuritySettings: Optional. Settings for prompt security checks.
	PromptSecuritySettings *GoogleCloudDialogflowCxV3beta1SafetySettingsPromptSecuritySettings `json:"promptSecuritySettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BannedPhrases") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BannedPhrases") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SafetySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SafetySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SafetySettingsPhrase: Text input which can be
// used for prompt or banned phrases.
type GoogleCloudDialogflowCxV3beta1SafetySettingsPhrase struct {
	// LanguageCode: Required. Language code of the phrase.
	LanguageCode string `json:"languageCode,omitempty"`
	// Text: Required. Text input which can be used for prompt or banned phrases.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SafetySettingsPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SafetySettingsPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SafetySettingsPromptSecuritySettings: Settings
// for prompt security checks.
type GoogleCloudDialogflowCxV3beta1SafetySettingsPromptSecuritySettings struct {
	// EnablePromptSecurity: Optional. Enable prompt security checks.
	EnablePromptSecurity bool `json:"enablePromptSecurity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnablePromptSecurity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnablePromptSecurity") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SafetySettingsPromptSecuritySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SafetySettingsPromptSecuritySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SearchConfig: Search configuration for UCS
// search queries.
type GoogleCloudDialogflowCxV3beta1SearchConfig struct {
	// BoostSpecs: Optional. Boosting configuration for the datastores. Maps from
	// datastore name to their boost configuration. Do not specify more than one
	// BoostSpecs for each datastore name. If multiple BoostSpecs are provided for
	// the same datastore name, the behavior is undefined.
	BoostSpecs []*GoogleCloudDialogflowCxV3beta1BoostSpecs `json:"boostSpecs,omitempty"`
	// FilterSpecs: Optional. Filter configuration for the datastores. Maps from
	// datastore name to the filter expression for that datastore. Do not specify
	// more than one FilterSpecs for each datastore name. If multiple FilterSpecs
	// are provided for the same datastore name, the behavior is undefined.
	FilterSpecs []*GoogleCloudDialogflowCxV3beta1FilterSpecs `json:"filterSpecs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BoostSpecs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BoostSpecs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SearchConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SearchConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SecuritySettings: Represents the settings
// related to security issues, such as data redaction and data retention. It
// may take hours for updates on the settings to propagate to all the related
// components and take effect.
type GoogleCloudDialogflowCxV3beta1SecuritySettings struct {
	// AudioExportSettings: Controls audio export settings for post-conversation
	// analytics when ingesting audio to conversations via
	// Participants.AnalyzeContent or Participants.StreamingAnalyzeContent. If
	// retention_strategy is set to REMOVE_AFTER_CONVERSATION or
	// audio_export_settings.gcs_bucket is empty, audio export is disabled. If
	// audio export is enabled, audio is recorded and saved to
	// audio_export_settings.gcs_bucket, subject to retention policy of
	// audio_export_settings.gcs_bucket. This setting won't effect audio input for
	// implicit sessions via Sessions.DetectIntent or
	// Sessions.StreamingDetectIntent.
	AudioExportSettings *GoogleCloudDialogflowCxV3beta1SecuritySettingsAudioExportSettings `json:"audioExportSettings,omitempty"`
	// DeidentifyTemplate: DLP (https://cloud.google.com/dlp/docs) deidentify
	// template name. Use this template to define de-identification configuration
	// for the content. The `DLP De-identify Templates Reader` role is needed on
	// the Dialogflow service identity service account (has the form
	// `service-PROJECT_NUMBER@gcp-sa-dialogflow.iam.gserviceaccount.com`) for your
	// agent's project. If empty, Dialogflow replaces sensitive info with
	// `[redacted]` text. The template name will have one of the following formats:
	// `projects//locations//deidentifyTemplates/` OR
	// `organizations//locations//deidentifyTemplates/` Note: `deidentify_template`
	// must be located in the same region as the `SecuritySettings`.
	DeidentifyTemplate string `json:"deidentifyTemplate,omitempty"`
	// DisplayName: Required. The human-readable name of the security settings,
	// unique within the location.
	DisplayName string `json:"displayName,omitempty"`
	// InsightsExportSettings: Controls conversation exporting settings to Insights
	// after conversation is completed. If retention_strategy is set to
	// REMOVE_AFTER_CONVERSATION, Insights export is disabled no matter what you
	// configure here.
	InsightsExportSettings *GoogleCloudDialogflowCxV3beta1SecuritySettingsInsightsExportSettings `json:"insightsExportSettings,omitempty"`
	// InspectTemplate: DLP (https://cloud.google.com/dlp/docs) inspect template
	// name. Use this template to define inspect base settings. The `DLP Inspect
	// Templates Reader` role is needed on the Dialogflow service identity service
	// account (has the form
	// `service-PROJECT_NUMBER@gcp-sa-dialogflow.iam.gserviceaccount.com`) for your
	// agent's project. If empty, we use the default DLP inspect config. The
	// template name will have one of the following formats:
	// `projects//locations//inspectTemplates/` OR
	// `organizations//locations//inspectTemplates/` Note: `inspect_template` must
	// be located in the same region as the `SecuritySettings`.
	InspectTemplate string `json:"inspectTemplate,omitempty"`
	// Name: Resource name of the settings. Required for the
	// SecuritySettingsService.UpdateSecuritySettings method.
	// SecuritySettingsService.CreateSecuritySettings populates the name
	// automatically. Format: `projects//locations//securitySettings/`.
	Name string `json:"name,omitempty"`
	// PurgeDataTypes: List of types of data to remove when retention settings
	// triggers purge.
	//
	// Possible values:
	//   "PURGE_DATA_TYPE_UNSPECIFIED" - Unspecified. Do not use.
	//   "DIALOGFLOW_HISTORY" - Dialogflow history. This does not include Cloud
	// logging, which is owned by the user - not Dialogflow.
	PurgeDataTypes []string `json:"purgeDataTypes,omitempty"`
	// RedactionScope: Defines the data for which Dialogflow applies redaction.
	// Dialogflow does not redact data that it does not have access to – for
	// example, Cloud logging.
	//
	// Possible values:
	//   "REDACTION_SCOPE_UNSPECIFIED" - Don't redact any kind of data.
	//   "REDACT_DISK_STORAGE" - On data to be written to disk or similar devices
	// that are capable of holding data even if power is disconnected. This
	// includes data that are temporarily saved on disk.
	RedactionScope string `json:"redactionScope,omitempty"`
	// RedactionStrategy: Strategy that defines how we do redaction.
	//
	// Possible values:
	//   "REDACTION_STRATEGY_UNSPECIFIED" - Do not redact.
	//   "REDACT_WITH_SERVICE" - Call redaction service to clean up the data to be
	// persisted.
	RedactionStrategy string `json:"redactionStrategy,omitempty"`
	// RetentionStrategy: Specifies the retention behavior defined by
	// SecuritySettings.RetentionStrategy.
	//
	// Possible values:
	//   "RETENTION_STRATEGY_UNSPECIFIED" - Retains the persisted data with
	// Dialogflow's internal default 365d TTLs.
	//   "REMOVE_AFTER_CONVERSATION" - Removes data when the conversation ends. If
	// there is no Conversation explicitly established, a default conversation ends
	// when the corresponding Dialogflow session ends.
	RetentionStrategy string `json:"retentionStrategy,omitempty"`
	// RetentionWindowDays: Retains data in interaction logging for the specified
	// number of days. This does not apply to Cloud logging, which is owned by the
	// user - not Dialogflow. User must set a value lower than Dialogflow's default
	// 365d TTL (30 days for Agent Assist traffic), higher value will be ignored
	// and use default. Setting a value higher than that has no effect. A missing
	// value or setting to 0 also means we use default TTL. When data retention
	// configuration is changed, it only applies to the data created after the
	// change; the TTL of existing data created before the change stays intact.
	RetentionWindowDays int64 `json:"retentionWindowDays,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AudioExportSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportSettings") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SecuritySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SecuritySettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SecuritySettingsAudioExportSettings: Settings
// for exporting audio.
type GoogleCloudDialogflowCxV3beta1SecuritySettingsAudioExportSettings struct {
	// AudioExportPattern: Filename pattern for exported audio.
	AudioExportPattern string `json:"audioExportPattern,omitempty"`
	// AudioFormat: File format for exported audio file. Currently only in
	// telephony recordings.
	//
	// Possible values:
	//   "AUDIO_FORMAT_UNSPECIFIED" - Unspecified. Do not use.
	//   "MULAW" - G.711 mu-law PCM with 8kHz sample rate.
	//   "MP3" - MP3 file format.
	//   "OGG" - OGG Vorbis.
	AudioFormat string `json:"audioFormat,omitempty"`
	// EnableAudioRedaction: Enable audio redaction if it is true. Note that this
	// only redacts end-user audio data; Synthesised audio from the virtual agent
	// is not redacted.
	EnableAudioRedaction bool `json:"enableAudioRedaction,omitempty"`
	// GcsBucket: Cloud Storage bucket to export audio record to. Setting this
	// field would grant the Storage Object Creator role to the Dialogflow Service
	// Agent. API caller that tries to modify this field should have the permission
	// of storage.buckets.setIamPolicy.
	GcsBucket string `json:"gcsBucket,omitempty"`
	// StoreTtsAudio: Whether to store TTS audio. By default, TTS audio from the
	// virtual agent is not exported.
	StoreTtsAudio bool `json:"storeTtsAudio,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AudioExportPattern") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AudioExportPattern") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SecuritySettingsAudioExportSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SecuritySettingsAudioExportSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SecuritySettingsInsightsExportSettings:
// Settings for exporting conversations to Insights
// (https://cloud.google.com/contact-center/insights/docs).
type GoogleCloudDialogflowCxV3beta1SecuritySettingsInsightsExportSettings struct {
	// EnableInsightsExport: If enabled, we will automatically exports
	// conversations to Insights and Insights runs its analyzers.
	EnableInsightsExport bool `json:"enableInsightsExport,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableInsightsExport") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableInsightsExport") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SecuritySettingsInsightsExportSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SecuritySettingsInsightsExportSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult: The result of
// sentiment analysis. Sentiment analysis inspects user input and identifies
// the prevailing subjective opinion, especially to determine a user's attitude
// as positive, negative, or neutral.
type GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which represents
	// the absolute magnitude of sentiment, regardless of score (positive or
	// negative).
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1SentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowCxV3beta1SessionEntityType: Session entity types are
// referred to as **User** entity types and are entities that are built for an
// individual user such as favorites, preferences, playlists, and so on. You
// can redefine a session entity type at the session level to extend or replace
// a custom entity type at the user session level (we refer to the entity types
// defined at the agent level as "custom entity types"). Note: session entity
// types apply to all queries, regardless of the language. For more information
// about entity types, see the Dialogflow documentation
// (https://cloud.google.com/dialogflow/docs/entities-overview).
type GoogleCloudDialogflowCxV3beta1SessionEntityType struct {
	// Entities: Required. The collection of entities to override or supplement the
	// custom entity type.
	Entities []*GoogleCloudDialogflowCxV3beta1EntityTypeEntity `json:"entities,omitempty"`
	// EntityOverrideMode: Required. Indicates whether the additional data should
	// override or supplement the custom entity type definition.
	//
	// Possible values:
	//   "ENTITY_OVERRIDE_MODE_UNSPECIFIED" - Not specified. This value should be
	// never used.
	//   "ENTITY_OVERRIDE_MODE_OVERRIDE" - The collection of session entities
	// overrides the collection of entities in the corresponding custom entity
	// type.
	//   "ENTITY_OVERRIDE_MODE_SUPPLEMENT" - The collection of session entities
	// extends the collection of entities in the corresponding custom entity type.
	// Note: Even in this override mode calls to `ListSessionEntityTypes`,
	// `GetSessionEntityType`, `CreateSessionEntityType` and
	// `UpdateSessionEntityType` only return the additional entities added in this
	// session entity type. If you want to get the supplemented list, please call
	// EntityTypes.GetEntityType on the custom entity type and merge.
	EntityOverrideMode string `json:"entityOverrideMode,omitempty"`
	// Name: Required. The unique identifier of the session entity type. Format:
	// `projects//locations//agents//sessions//entityTypes/` or
	// `projects//locations//agents//environments//sessions//entityTypes/`. If
	// `Environment ID` is not specified, we assume default 'draft' environment.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SessionEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SessionEntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SessionInfo: Represents session information
// communicated to and from the webhook.
type GoogleCloudDialogflowCxV3beta1SessionInfo struct {
	// Parameters: Optional for WebhookRequest. Optional for WebhookResponse. All
	// parameters collected from forms and intents during the session. Parameters
	// can be created, updated, or removed by the webhook. To remove a parameter
	// from the session, the webhook should explicitly set the parameter value to
	// null in WebhookResponse. The map is keyed by parameters' display names.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// Session: Always present for WebhookRequest. Ignored for WebhookResponse. The
	// unique identifier of the session. This field can be used by the webhook to
	// identify a session. Format: `projects//locations//agents//sessions/` or
	// `projects//locations//agents//environments//sessions/` if environment is
	// specified.
	Session string `json:"session,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Span: A span represents a sub execution step
// of an action.
type GoogleCloudDialogflowCxV3beta1Span struct {
	// CompleteTime: Timestamp of the completion of the span.
	CompleteTime string `json:"completeTime,omitempty"`
	// Metrics: The unordered collection of metrics in this span.
	Metrics []*GoogleCloudDialogflowCxV3beta1NamedMetric `json:"metrics,omitempty"`
	// Name: The name of the span.
	Name string `json:"name,omitempty"`
	// StartTime: Timestamp of the start of the span.
	StartTime string `json:"startTime,omitempty"`
	// Tags: The metadata tags of the span such as span type.
	Tags []string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompleteTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Span) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Span
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SpeechToTextSettings: Settings related to
// speech recognition.
type GoogleCloudDialogflowCxV3beta1SpeechToTextSettings struct {
	// EnableSpeechAdaptation: Whether to use speech adaptation for speech
	// recognition.
	EnableSpeechAdaptation bool `json:"enableSpeechAdaptation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableSpeechAdaptation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableSpeechAdaptation") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SpeechToTextSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SpeechToTextSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1StartExperimentRequest: The request message
// for Experiments.StartExperiment.
type GoogleCloudDialogflowCxV3beta1StartExperimentRequest struct {
}

// GoogleCloudDialogflowCxV3beta1Status: The status of the action.
type GoogleCloudDialogflowCxV3beta1Status struct {
	// Exception: Optional. The exception thrown during the execution of the
	// action.
	Exception *GoogleCloudDialogflowCxV3beta1ExceptionDetail `json:"exception,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Exception") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Exception") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Status) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1StopExperimentRequest: The request message for
// Experiments.StopExperiment.
type GoogleCloudDialogflowCxV3beta1StopExperimentRequest struct {
}

// GoogleCloudDialogflowCxV3beta1SubmitAnswerFeedbackRequest: The request to
// set the feedback for a bot answer.
type GoogleCloudDialogflowCxV3beta1SubmitAnswerFeedbackRequest struct {
	// AnswerFeedback: Required. Feedback provided for a bot answer.
	AnswerFeedback *GoogleCloudDialogflowCxV3beta1AnswerFeedback `json:"answerFeedback,omitempty"`
	// ResponseId: Required. ID of the response to update its feedback. This is the
	// same as DetectIntentResponse.response_id.
	ResponseId string `json:"responseId,omitempty"`
	// UpdateMask: Optional. The mask to control which fields to update. If the
	// mask is not present, all fields will be updated.
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerFeedback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerFeedback") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SubmitAnswerFeedbackRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SubmitAnswerFeedbackRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig: Configuration of how
// speech should be synthesized.
type GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig struct {
	// EffectsProfileId: Optional. An identifier which selects 'audio effects'
	// profiles that are applied on (post synthesized) text to speech. Effects are
	// applied on top of each other in the order they are given.
	EffectsProfileId []string `json:"effectsProfileId,omitempty"`
	// Pitch: Optional. Speaking pitch, in the range [-20.0, 20.0]. 20 means
	// increase 20 semitones from the original pitch. -20 means decrease 20
	// semitones from the original pitch.
	Pitch float64 `json:"pitch,omitempty"`
	// SpeakingRate: Optional. Speaking rate/speed, in the range [0.25, 4.0]. 1.0
	// is the normal native speed supported by the specific voice. 2.0 is twice as
	// fast, and 0.5 is half as fast. If unset(0.0), defaults to the native 1.0
	// speed. Any other values < 0.25 or > 4.0 will return an error.
	SpeakingRate float64 `json:"speakingRate,omitempty"`
	// Voice: Optional. The desired voice of the synthesized audio.
	Voice *GoogleCloudDialogflowCxV3beta1VoiceSelectionParams `json:"voice,omitempty"`
	// VolumeGainDb: Optional. Volume gain (in dB) of the normal native volume
	// supported by the specific voice, in the range [-96.0, 16.0]. If unset, or
	// set to a value of 0.0 (dB), will play at normal native signal amplitude. A
	// value of -6.0 (dB) will play at approximately half the amplitude of the
	// normal native signal amplitude. A value of +6.0 (dB) will play at
	// approximately twice the amplitude of the normal native signal amplitude. We
	// strongly recommend not to exceed +10 (dB) as there's usually no effective
	// increase in loudness for any value greater than that.
	VolumeGainDb float64 `json:"volumeGainDb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EffectsProfileId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EffectsProfileId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig
	var s1 struct {
		Pitch        gensupport.JSONFloat64 `json:"pitch"`
		SpeakingRate gensupport.JSONFloat64 `json:"speakingRate"`
		VolumeGainDb gensupport.JSONFloat64 `json:"volumeGainDb"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Pitch = float64(s1.Pitch)
	s.SpeakingRate = float64(s1.SpeakingRate)
	s.VolumeGainDb = float64(s1.VolumeGainDb)
	return nil
}

// GoogleCloudDialogflowCxV3beta1TestCase: Represents a test case.
type GoogleCloudDialogflowCxV3beta1TestCase struct {
	// CreationTime: Output only. When the test was created.
	CreationTime string `json:"creationTime,omitempty"`
	// DisplayName: Required. The human-readable name of the test case, unique
	// within the agent. Limit of 200 characters.
	DisplayName string `json:"displayName,omitempty"`
	// LastTestResult: The latest test result.
	LastTestResult *GoogleCloudDialogflowCxV3beta1TestCaseResult `json:"lastTestResult,omitempty"`
	// Name: The unique identifier of the test case. TestCases.CreateTestCase will
	// populate the name automatically. Otherwise use format:
	// `projects//locations//agents//testCases/`.
	Name string `json:"name,omitempty"`
	// Notes: Additional freeform notes about the test case. Limit of 400
	// characters.
	Notes string `json:"notes,omitempty"`
	// Tags: Tags are short descriptions that users may apply to test cases for
	// organizational and filtering purposes. Each tag should start with "#" and
	// has a limit of 30 characters.
	Tags []string `json:"tags,omitempty"`
	// TestCaseConversationTurns: The conversation turns uttered when the test case
	// was created, in chronological order. These include the canonical set of
	// agent utterances that should occur when the agent is working properly.
	TestCaseConversationTurns []*GoogleCloudDialogflowCxV3beta1ConversationTurn `json:"testCaseConversationTurns,omitempty"`
	// TestConfig: Config for the test case.
	TestConfig *GoogleCloudDialogflowCxV3beta1TestConfig `json:"testConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestCaseError: Error info for importing a
// test.
type GoogleCloudDialogflowCxV3beta1TestCaseError struct {
	// Status: The status associated with the test case.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TestCase: The test case.
	TestCase *GoogleCloudDialogflowCxV3beta1TestCase `json:"testCase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCaseError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCaseError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestCaseResult: Represents a result from
// running a test case in an agent environment.
type GoogleCloudDialogflowCxV3beta1TestCaseResult struct {
	// ConversationTurns: The conversation turns uttered during the test case
	// replay in chronological order.
	ConversationTurns []*GoogleCloudDialogflowCxV3beta1ConversationTurn `json:"conversationTurns,omitempty"`
	// Environment: Environment where the test was run. If not set, it indicates
	// the draft environment.
	Environment string `json:"environment,omitempty"`
	// Name: The resource name for the test case result. Format:
	// `projects//locations//agents//testCases//results/`.
	Name string `json:"name,omitempty"`
	// TestResult: Whether the test case passed in the agent environment.
	//
	// Possible values:
	//   "TEST_RESULT_UNSPECIFIED" - Not specified. Should never be used.
	//   "PASSED" - The test passed.
	//   "FAILED" - The test did not pass.
	TestResult string `json:"testResult,omitempty"`
	// TestTime: The time that the test was run.
	TestTime string `json:"testTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConversationTurns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationTurns") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestCaseResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestCaseResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestConfig: Represents configurations for a
// test case.
type GoogleCloudDialogflowCxV3beta1TestConfig struct {
	// Flow: Flow name to start the test case with. Format:
	// `projects//locations//agents//flows/`. Only one of `flow` and `page` should
	// be set to indicate the starting point of the test case. If neither is set,
	// the test case will start with start page on the default start flow.
	Flow string `json:"flow,omitempty"`
	// Page: The page to start the test case with. Format:
	// `projects//locations//agents//flows//pages/`. Only one of `flow` and `page`
	// should be set to indicate the starting point of the test case. If neither is
	// set, the test case will start with start page on the default start flow.
	Page string `json:"page,omitempty"`
	// TrackingParameters: Session parameters to be compared when calculating
	// differences.
	TrackingParameters []string `json:"trackingParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestError: Error info for running a test.
type GoogleCloudDialogflowCxV3beta1TestError struct {
	// Status: The status associated with the test.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TestCase: The test case resource name.
	TestCase string `json:"testCase,omitempty"`
	// TestTime: The timestamp when the test was completed.
	TestTime string `json:"testTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TestRunDifference: The description of
// differences between original and replayed agent output.
type GoogleCloudDialogflowCxV3beta1TestRunDifference struct {
	// Description: A human readable description of the diff, showing the actual
	// output vs expected output.
	Description string `json:"description,omitempty"`
	// Type: The type of diff.
	//
	// Possible values:
	//   "DIFF_TYPE_UNSPECIFIED" - Should never be used.
	//   "INTENT" - The intent.
	//   "PAGE" - The page.
	//   "PARAMETERS" - The parameters.
	//   "UTTERANCE" - The message utterance.
	//   "FLOW" - The flow.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TestRunDifference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TestRunDifference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TextInput: Represents the natural language
// text to be processed.
type GoogleCloudDialogflowCxV3beta1TextInput struct {
	// Text: Required. The UTF-8 encoded natural language text to be processed.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TextInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TextInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TextToSpeechSettings: Settings related to
// speech synthesizing.
type GoogleCloudDialogflowCxV3beta1TextToSpeechSettings struct {
	// SynthesizeSpeechConfigs: Configuration of how speech should be synthesized,
	// mapping from language
	// (https://cloud.google.com/dialogflow/cx/docs/reference/language) to
	// SynthesizeSpeechConfig. These settings affect: - The phone gateway
	// (https://cloud.google.com/dialogflow/cx/docs/concept/integration/phone-gateway)
	// synthesize configuration set via Agent.text_to_speech_settings. - How speech
	// is synthesized when invoking session APIs. Agent.text_to_speech_settings
	// only applies if OutputAudioConfig.synthesize_speech_config is not specified.
	SynthesizeSpeechConfigs map[string]GoogleCloudDialogflowCxV3beta1SynthesizeSpeechConfig `json:"synthesizeSpeechConfigs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SynthesizeSpeechConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SynthesizeSpeechConfigs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TextToSpeechSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TextToSpeechSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Tool: A tool provides a list of actions which
// are available to the Playbook to attain its goal. A Tool consists of a
// description of the tool's usage and a specification of the tool which
// contains the schema and authentication information.
type GoogleCloudDialogflowCxV3beta1Tool struct {
	// ConnectorSpec: Integration connectors tool specification.
	ConnectorSpec *GoogleCloudDialogflowCxV3beta1ToolConnectorTool `json:"connectorSpec,omitempty"`
	// DataStoreSpec: Data store search tool specification.
	DataStoreSpec *GoogleCloudDialogflowCxV3beta1ToolDataStoreTool `json:"dataStoreSpec,omitempty"`
	// Description: Required. High level description of the Tool and its usage.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the Tool, unique within an
	// agent.
	DisplayName string `json:"displayName,omitempty"`
	// ExtensionSpec: Vertex extension tool specification.
	ExtensionSpec *GoogleCloudDialogflowCxV3beta1ToolExtensionTool `json:"extensionSpec,omitempty"`
	// FunctionSpec: Client side executed function specification.
	FunctionSpec *GoogleCloudDialogflowCxV3beta1ToolFunctionTool `json:"functionSpec,omitempty"`
	// Name: The unique identifier of the Tool. Format:
	// `projects//locations//agents//tools/`.
	Name string `json:"name,omitempty"`
	// OpenApiSpec: OpenAPI specification of the Tool.
	OpenApiSpec *GoogleCloudDialogflowCxV3beta1ToolOpenApiTool `json:"openApiSpec,omitempty"`
	// ToolType: Output only. The tool type.
	//
	// Possible values:
	//   "TOOL_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "CUSTOMIZED_TOOL" - Customer provided tool.
	//   "BUILTIN_TOOL" - First party built-in tool created by Dialogflow which
	// cannot be modified.
	ToolType string `json:"toolType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ConnectorSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectorSpec") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Tool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Tool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolAuthentication: Authentication information
// required for API calls
type GoogleCloudDialogflowCxV3beta1ToolAuthentication struct {
	// ApiKeyConfig: Config for API key auth.
	ApiKeyConfig *GoogleCloudDialogflowCxV3beta1ToolAuthenticationApiKeyConfig `json:"apiKeyConfig,omitempty"`
	// BearerTokenConfig: Config for bearer token auth.
	BearerTokenConfig *GoogleCloudDialogflowCxV3beta1ToolAuthenticationBearerTokenConfig `json:"bearerTokenConfig,omitempty"`
	// OauthConfig: Config for OAuth.
	OauthConfig *GoogleCloudDialogflowCxV3beta1ToolAuthenticationOAuthConfig `json:"oauthConfig,omitempty"`
	// ServiceAgentAuthConfig: Config for Diglogflow service agent
	// (https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
	// auth.
	ServiceAgentAuthConfig *GoogleCloudDialogflowCxV3beta1ToolAuthenticationServiceAgentAuthConfig `json:"serviceAgentAuthConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKeyConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKeyConfig") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolAuthentication) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolAuthentication
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolAuthenticationApiKeyConfig: Config for
// authentication with API key.
type GoogleCloudDialogflowCxV3beta1ToolAuthenticationApiKeyConfig struct {
	// ApiKey: Optional. The API key. If the `secret_version_for_api_key` field is
	// set, this field will be ignored.
	ApiKey string `json:"apiKey,omitempty"`
	// KeyName: Required. The parameter name or the header name of the API key.
	// E.g., If the API request is "https://example.com/act?X-Api-Key=",
	// "X-Api-Key" would be the parameter name.
	KeyName string `json:"keyName,omitempty"`
	// RequestLocation: Required. Key location in the request.
	//
	// Possible values:
	//   "REQUEST_LOCATION_UNSPECIFIED" - Default value. This value is unused.
	//   "HEADER" - Represents the key in http header.
	//   "QUERY_STRING" - Represents the key in query string.
	RequestLocation string `json:"requestLocation,omitempty"`
	// SecretVersionForApiKey: Optional. The name of the SecretManager secret
	// version resource storing the API key. If this field is set, the `api_key`
	// field will be ignored. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForApiKey string `json:"secretVersionForApiKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolAuthenticationApiKeyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolAuthenticationApiKeyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolAuthenticationBearerTokenConfig: Config
// for authentication using bearer token.
type GoogleCloudDialogflowCxV3beta1ToolAuthenticationBearerTokenConfig struct {
	// SecretVersionForToken: Optional. The name of the SecretManager secret
	// version resource storing the Bearer token. If this field is set, the `token`
	// field will be ignored. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForToken string `json:"secretVersionForToken,omitempty"`
	// Token: Optional. The text token appended to the text `Bearer` to the request
	// Authorization header. Session parameters reference
	// (https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
	// can be used to pass the token dynamically, e.g.
	// `$session.params.parameter-id`.
	Token string `json:"token,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersionForToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersionForToken") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolAuthenticationBearerTokenConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolAuthenticationBearerTokenConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolAuthenticationOAuthConfig: Config for
// authentication with OAuth.
type GoogleCloudDialogflowCxV3beta1ToolAuthenticationOAuthConfig struct {
	// ClientId: Required. The client ID from the OAuth provider.
	ClientId string `json:"clientId,omitempty"`
	// ClientSecret: Optional. The client secret from the OAuth provider. If the
	// `secret_version_for_client_secret` field is set, this field will be ignored.
	ClientSecret string `json:"clientSecret,omitempty"`
	// OauthGrantType: Required. OAuth grant types.
	//
	// Possible values:
	//   "OAUTH_GRANT_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "CLIENT_CREDENTIAL" - Represents the [client credential
	// flow](https://oauth.net/2/grant-types/client-credentials).
	OauthGrantType string `json:"oauthGrantType,omitempty"`
	// Scopes: Optional. The OAuth scopes to grant.
	Scopes []string `json:"scopes,omitempty"`
	// SecretVersionForClientSecret: Optional. The name of the SecretManager secret
	// version resource storing the client secret. If this field is set, the
	// `client_secret` field will be ignored. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForClientSecret string `json:"secretVersionForClientSecret,omitempty"`
	// TokenEndpoint: Required. The token endpoint in the OAuth provider to
	// exchange for an access token.
	TokenEndpoint string `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolAuthenticationOAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolAuthenticationOAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolAuthenticationServiceAgentAuthConfig:
// Config for auth using Diglogflow service agent
// (https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
type GoogleCloudDialogflowCxV3beta1ToolAuthenticationServiceAgentAuthConfig struct {
	// ServiceAgentAuth: Optional. Indicate the auth token type generated from the
	// Diglogflow service agent
	// (https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
	// The generated token is sent in the Authorization header.
	//
	// Possible values:
	//   "SERVICE_AGENT_AUTH_UNSPECIFIED" - Service agent auth type unspecified.
	// Default to ID_TOKEN.
	//   "ID_TOKEN" - Use [ID
	// token](https://cloud.google.com/docs/authentication/token-types#id)
	// generated from service agent. This can be used to access Cloud Function and
	// Cloud Run after you grant Invoker role to
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	//   "ACCESS_TOKEN" - Use [access
	// token](https://cloud.google.com/docs/authentication/token-types#access)
	// generated from service agent. This can be used to access other Google Cloud
	// APIs after you grant required roles to
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	ServiceAgentAuth string `json:"serviceAgentAuth,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ServiceAgentAuth") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ServiceAgentAuth") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolAuthenticationServiceAgentAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolAuthenticationServiceAgentAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolCall: Represents a call of a specific
// tool's action with the specified inputs.
type GoogleCloudDialogflowCxV3beta1ToolCall struct {
	// Action: Required. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// InputParameters: Optional. The action's input parameters.
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	// Tool: Required. The tool associated with this call. Format:
	// `projects//locations//agents//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolCallResult: The result of calling a tool's
// action that has been executed by the client.
type GoogleCloudDialogflowCxV3beta1ToolCallResult struct {
	// Action: Required. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// Error: The tool call's error.
	Error *GoogleCloudDialogflowCxV3beta1ToolCallResultError `json:"error,omitempty"`
	// OutputParameters: The tool call's output parameters.
	OutputParameters googleapi.RawMessage `json:"outputParameters,omitempty"`
	// Tool: Required. The tool associated with this call. Format:
	// `projects//locations//agents//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolCallResultError: An error produced by the
// tool call.
type GoogleCloudDialogflowCxV3beta1ToolCallResultError struct {
	// Message: Optional. The error message of the function.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolConnectorTool: A ConnectorTool enabling
// using Integration Connectors Connections as tools.
type GoogleCloudDialogflowCxV3beta1ToolConnectorTool struct {
	// Actions: Required. Actions for the tool to use.
	Actions []*GoogleCloudDialogflowCxV3beta1ToolConnectorToolAction `json:"actions,omitempty"`
	// EndUserAuthConfig: Optional. Integration Connectors end-user authentication
	// configuration. If configured, the end-user authentication fields will be
	// passed in the Integration Connectors API request and override the admin,
	// default authentication configured for the Connection. **Note**: The
	// Connection must have authentication override enabled in order to specify an
	// EUC configuration here - otherwise, the ConnectorTool creation will fail.
	// See:
	// https://cloud.google.com/application-integration/docs/configure-connectors-task#configure-authentication-override
	EndUserAuthConfig *GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfig `json:"endUserAuthConfig,omitempty"`
	// Name: Required. The full resource name of the referenced Integration
	// Connectors Connection. Format: `projects/*/locations/*/connections/*`
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolConnectorTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolConnectorTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolConnectorToolAction: Configuration of a
// Connection operation for the tool to use.
type GoogleCloudDialogflowCxV3beta1ToolConnectorToolAction struct {
	// ConnectionActionId: ID of a Connection action for the tool to use.
	ConnectionActionId string `json:"connectionActionId,omitempty"`
	// EntityOperation: Entity operation configuration for the tool to use.
	EntityOperation *GoogleCloudDialogflowCxV3beta1ToolConnectorToolActionEntityOperation `json:"entityOperation,omitempty"`
	// InputFields: Optional. Entity fields to use as inputs for the operation. If
	// no fields are specified, all fields of the Entity will be used.
	InputFields []string `json:"inputFields,omitempty"`
	// OutputFields: Optional. Entity fields to return from the operation. If no
	// fields are specified, all fields of the Entity will be returned.
	OutputFields []string `json:"outputFields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionActionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionActionId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolConnectorToolAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolConnectorToolAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolConnectorToolActionEntityOperation: Entity
// CRUD operation specification.
type GoogleCloudDialogflowCxV3beta1ToolConnectorToolActionEntityOperation struct {
	// EntityId: Required. ID of the entity.
	EntityId string `json:"entityId,omitempty"`
	// Operation: Required. Operation to perform on the entity.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Operation type unspecified. Invalid,
	// ConnectorTool create/update will fail.
	//   "LIST" - List operation.
	//   "GET" - Get operation.
	//   "CREATE" - Create operation.
	//   "UPDATE" - Update operation.
	//   "DELETE" - Delete operation.
	Operation string `json:"operation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolConnectorToolActionEntityOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolConnectorToolActionEntityOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolDataStoreTool: A DataStoreTool is a way to
// provide specifications needed to search a list of data stores.
type GoogleCloudDialogflowCxV3beta1ToolDataStoreTool struct {
	// DataStoreConnections: Required. List of data stores to search.
	DataStoreConnections []*GoogleCloudDialogflowCxV3beta1DataStoreConnection `json:"dataStoreConnections,omitempty"`
	// FallbackPrompt: Required. Fallback prompt configurations to use.
	FallbackPrompt *GoogleCloudDialogflowCxV3beta1ToolDataStoreToolFallbackPrompt `json:"fallbackPrompt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreConnections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreConnections") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolDataStoreTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolDataStoreTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolDataStoreToolFallbackPrompt: A
// FallbackPrompt is a way to provide specifications for the Data Store
// fallback prompt when generating responses.
type GoogleCloudDialogflowCxV3beta1ToolDataStoreToolFallbackPrompt struct {
}

// GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfig: End-user authentication
// configuration used for Connection calls. The field values can either be
// hardcoded authentication values or the names of session parameters
// (https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
// or request parameters
// (https://cloud.google.com/dialogflow/cx/docs/concept/parameter#request-scoped).
// If parameter names are provided, then those parameters can be used to pass
// the authentication values dynamically, through `$session.params.param-id` or
// `$request.payload.param-id`.
type GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfig struct {
	// Oauth2AuthCodeConfig: Oauth 2.0 Authorization Code authentication.
	Oauth2AuthCodeConfig *GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfigOauth2AuthCodeConfig `json:"oauth2AuthCodeConfig,omitempty"`
	// Oauth2JwtBearerConfig: JWT Profile Oauth 2.0 Authorization Grant
	// authentication.
	Oauth2JwtBearerConfig *GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfigOauth2JwtBearerConfig `json:"oauth2JwtBearerConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Oauth2AuthCodeConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Oauth2AuthCodeConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfigOauth2AuthCodeConfig:
// Oauth 2.0 Authorization Code authentication configuration.
type GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfigOauth2AuthCodeConfig struct {
	// OauthToken: Required. Oauth token value or parameter name to pass it
	// through.
	OauthToken string `json:"oauthToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OauthToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OauthToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfigOauth2AuthCodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfigOauth2AuthCodeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfigOauth2JwtBearerConfig:
// JWT Profile Oauth 2.0 Authorization Grant authentication configuration.
type GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfigOauth2JwtBearerConfig struct {
	// ClientKey: Required. Client key value or parameter name to pass it through.
	ClientKey string `json:"clientKey,omitempty"`
	// Issuer: Required. Issuer value or parameter name to pass it through.
	Issuer string `json:"issuer,omitempty"`
	// Subject: Required. Subject value or parameter name to pass it through.
	Subject string `json:"subject,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfigOauth2JwtBearerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolEndUserAuthConfigOauth2JwtBearerConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolExtensionTool: An ExtensionTool is a way
// to use Vertex Extensions as a tool.
type GoogleCloudDialogflowCxV3beta1ToolExtensionTool struct {
	// Name: Required. The full name of the referenced vertex extension. Formats:
	// `projects/{project}/locations/{location}/extensions/{extension}`
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolExtensionTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolExtensionTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolFunctionTool: A Function tool describes
// the functions to be invoked on the client side.
type GoogleCloudDialogflowCxV3beta1ToolFunctionTool struct {
	// InputSchema: Optional. The JSON schema is encapsulated in a
	// google.protobuf.Struct to describe the input of the function. This input is
	// a JSON object that contains the function's parameters as properties of the
	// object.
	InputSchema googleapi.RawMessage `json:"inputSchema,omitempty"`
	// OutputSchema: Optional. The JSON schema is encapsulated in a
	// google.protobuf.Struct to describe the output of the function. This output
	// is a JSON object that contains the function's parameters as properties of
	// the object.
	OutputSchema googleapi.RawMessage `json:"outputSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolFunctionTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolFunctionTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolOpenApiTool: An OpenAPI tool is a way to
// provide the Tool specifications in the Open API schema format.
type GoogleCloudDialogflowCxV3beta1ToolOpenApiTool struct {
	// Authentication: Optional. Authentication information required by the API.
	Authentication *GoogleCloudDialogflowCxV3beta1ToolAuthentication `json:"authentication,omitempty"`
	// ServiceDirectoryConfig: Optional. Service Directory configuration.
	ServiceDirectoryConfig *GoogleCloudDialogflowCxV3beta1ToolServiceDirectoryConfig `json:"serviceDirectoryConfig,omitempty"`
	// TextSchema: Required. The OpenAPI schema specified as a text.
	TextSchema string `json:"textSchema,omitempty"`
	// TlsConfig: Optional. TLS configuration for the HTTPS verification.
	TlsConfig *GoogleCloudDialogflowCxV3beta1ToolTLSConfig `json:"tlsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Authentication") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Authentication") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolOpenApiTool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolOpenApiTool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolServiceDirectoryConfig: Configuration for
// tools using Service Directory.
type GoogleCloudDialogflowCxV3beta1ToolServiceDirectoryConfig struct {
	// Service: Required. The name of Service Directory
	// (https://cloud.google.com/service-directory) service. Format:
	// `projects//locations//namespaces//services/`. `LocationID` of the service
	// directory must be the same as the location of the agent.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Service") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Service") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolTLSConfig: The TLS configuration.
type GoogleCloudDialogflowCxV3beta1ToolTLSConfig struct {
	// CaCerts: Required. Specifies a list of allowed custom CA certificates for
	// HTTPS verification.
	CaCerts []*GoogleCloudDialogflowCxV3beta1ToolTLSConfigCACert `json:"caCerts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaCerts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaCerts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolTLSConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolTLSConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolTLSConfigCACert: The CA certificate.
type GoogleCloudDialogflowCxV3beta1ToolTLSConfigCACert struct {
	// Cert: Required. The allowed custom CA certificates (in DER format) for HTTPS
	// verification. This overrides the default SSL trust store. If this is empty
	// or unspecified, Dialogflow will use Google's default trust store to verify
	// certificates. N.B. Make sure the HTTPS server certificates are signed with
	// "subject alt name". For instance a certificate can be self-signed using the
	// following command: ``` openssl x509 -req -days 200 -in example.com.csr \
	// -signkey example.com.key \ -out example.com.crt \ -extfile <(printf
	// "\nsubjectAltName='DNS:www.example.com'") ```
	Cert string `json:"cert,omitempty"`
	// DisplayName: Required. The name of the allowed custom CA certificates. This
	// can be used to disambiguate the custom CA certificates.
	DisplayName string `json:"displayName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cert") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cert") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolTLSConfigCACert) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolTLSConfigCACert
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolUse: Stores metadata of the invocation of
// an action supported by a tool.
type GoogleCloudDialogflowCxV3beta1ToolUse struct {
	// Action: Optional. Name of the action to be called during the tool use.
	Action string `json:"action,omitempty"`
	// DataStoreToolTrace: Optional. Data store tool trace.
	DataStoreToolTrace *GoogleCloudDialogflowCxV3beta1ToolUseDataStoreToolTrace `json:"dataStoreToolTrace,omitempty"`
	// DisplayName: Output only. The display name of the tool.
	DisplayName string `json:"displayName,omitempty"`
	// InputActionParameters: Optional. A list of input parameters for the action.
	InputActionParameters googleapi.RawMessage `json:"inputActionParameters,omitempty"`
	// OutputActionParameters: Optional. A list of output parameters generated by
	// the action.
	OutputActionParameters googleapi.RawMessage `json:"outputActionParameters,omitempty"`
	// Tool: Required. The tool that should be used. Format:
	// `projects//locations//agents//tools/`.
	Tool string `json:"tool,omitempty"`
	// WebhookToolTrace: Optional. Webhook tool trace.
	WebhookToolTrace *GoogleCloudDialogflowCxV3beta1ToolUseWebhookToolTrace `json:"webhookToolTrace,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolUse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolUse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolUseDataStoreToolTrace: The tracing
// information for the data store tool.
type GoogleCloudDialogflowCxV3beta1ToolUseDataStoreToolTrace struct {
	// DataStoreConnectionSignals: Optional. Data store connection feature output
	// signals.
	DataStoreConnectionSignals *GoogleCloudDialogflowCxV3beta1DataStoreConnectionSignals `json:"dataStoreConnectionSignals,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataStoreConnectionSignals")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataStoreConnectionSignals") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolUseDataStoreToolTrace) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolUseDataStoreToolTrace
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolUseWebhookToolTrace: The tracing
// information for the webhook tool.
type GoogleCloudDialogflowCxV3beta1ToolUseWebhookToolTrace struct {
	// WebhookTag: Optional. The tag of the webhook.
	WebhookTag string `json:"webhookTag,omitempty"`
	// WebhookUri: Optional. The url of the webhook.
	WebhookUri string `json:"webhookUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WebhookTag") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WebhookTag") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolUseWebhookToolTrace) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolUseWebhookToolTrace
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ToolVersion: Tool version is a snapshot of the
// tool at certain timestamp.
type GoogleCloudDialogflowCxV3beta1ToolVersion struct {
	// CreateTime: Output only. Last time the tool version was created or modified.
	CreateTime string `json:"createTime,omitempty"`
	// DisplayName: Required. The display name of the tool version.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Identifier. The unique identifier of the tool version. Format:
	// `projects//locations//agents//tools//versions/`.
	Name string `json:"name,omitempty"`
	// Tool: Required. Snapshot of the tool to be associated with this version.
	Tool *GoogleCloudDialogflowCxV3beta1Tool `json:"tool,omitempty"`
	// UpdateTime: Output only. Last time the tool version was created or modified.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ToolVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ToolVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TrainFlowRequest: The request message for
// Flows.TrainFlow.
type GoogleCloudDialogflowCxV3beta1TrainFlowRequest struct {
}

// GoogleCloudDialogflowCxV3beta1TransitionCoverage: Transition coverage
// represents the percentage of all possible page transitions (page-level
// transition routes and event handlers, excluding transition route groups)
// present within any of a parent's test cases.
type GoogleCloudDialogflowCxV3beta1TransitionCoverage struct {
	// CoverageScore: The percent of transitions in the agent that are covered.
	CoverageScore float64 `json:"coverageScore,omitempty"`
	// Transitions: The list of Transitions present in the agent.
	Transitions []*GoogleCloudDialogflowCxV3beta1TransitionCoverageTransition `json:"transitions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoverageScore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TransitionCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionCoverage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1TransitionCoverageTransition: A transition in
// a page.
type GoogleCloudDialogflowCxV3beta1TransitionCoverageTransition struct {
	// Covered: Whether the transition is covered by at least one of the agent's
	// test cases.
	Covered bool `json:"covered,omitempty"`
	// EventHandler: Event handler.
	EventHandler *GoogleCloudDialogflowCxV3beta1EventHandler `json:"eventHandler,omitempty"`
	// Index: The index of a transition in the transition list. Starting from 0.
	Index int64 `json:"index,omitempty"`
	// Source: The start node of a transition.
	Source *GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode `json:"source,omitempty"`
	// Target: The end node of a transition.
	Target *GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode `json:"target,omitempty"`
	// TransitionRoute: Intent route or condition route.
	TransitionRoute *GoogleCloudDialogflowCxV3beta1TransitionRoute `json:"transitionRoute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Covered") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Covered") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TransitionCoverageTransition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionCoverageTransition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode: The source
// or target of a transition.
type GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode struct {
	// Flow: Indicates a transition to a Flow. Only some fields such as name and
	// displayname will be set.
	Flow *GoogleCloudDialogflowCxV3beta1Flow `json:"flow,omitempty"`
	// Page: Indicates a transition to a Page. Only some fields such as name and
	// displayname will be set.
	Page *GoogleCloudDialogflowCxV3beta1Page `json:"page,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Flow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Flow") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionCoverageTransitionNode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TransitionRoute: A transition route specifies
// a intent that can be matched and/or a data condition that can be evaluated
// during a session. When a specified transition is matched, the following
// actions are taken in order: * If there is a `trigger_fulfillment` associated
// with the transition, it will be called. * If there is a `target_page`
// associated with the transition, the session will transition into the
// specified page. * If there is a `target_flow` associated with the
// transition, the session will transition into the specified flow.
type GoogleCloudDialogflowCxV3beta1TransitionRoute struct {
	// Condition: The condition to evaluate against form parameters or session
	// parameters. See the conditions reference
	// (https://cloud.google.com/dialogflow/cx/docs/reference/condition). At least
	// one of `intent` or `condition` must be specified. When both `intent` and
	// `condition` are specified, the transition can only happen when both are
	// fulfilled.
	Condition string `json:"condition,omitempty"`
	// Description: Optional. The description of the transition route. The maximum
	// length is 500 characters.
	Description string `json:"description,omitempty"`
	// Intent: The unique identifier of an Intent. Format:
	// `projects//locations//agents//intents/`. Indicates that the transition can
	// only happen when the given intent is matched. At least one of `intent` or
	// `condition` must be specified. When both `intent` and `condition` are
	// specified, the transition can only happen when both are fulfilled.
	Intent string `json:"intent,omitempty"`
	// Name: Output only. The unique identifier of this transition route.
	Name string `json:"name,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// TriggerFulfillment: The fulfillment to call when the condition is satisfied.
	// At least one of `trigger_fulfillment` and `target` must be specified. When
	// both are defined, `trigger_fulfillment` is executed first.
	TriggerFulfillment *GoogleCloudDialogflowCxV3beta1Fulfillment `json:"triggerFulfillment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TransitionRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRoute
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TransitionRouteGroup: A TransitionRouteGroup
// represents a group of `TransitionRoutes` to be used by a Page.
type GoogleCloudDialogflowCxV3beta1TransitionRouteGroup struct {
	// DisplayName: Required. The human-readable name of the transition route
	// group, unique within the flow. The display name can be no longer than 30
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: The unique identifier of the transition route group.
	// TransitionRouteGroups.CreateTransitionRouteGroup populates the name
	// automatically. Format:
	// `projects//locations//agents//flows//transitionRouteGroups/` or
	// `projects//locations//agents//transitionRouteGroups/` for agent-level
	// groups.
	Name string `json:"name,omitempty"`
	// TransitionRoutes: Transition routes associated with the
	// TransitionRouteGroup.
	TransitionRoutes []*GoogleCloudDialogflowCxV3beta1TransitionRoute `json:"transitionRoutes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TransitionRouteGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage: Transition route
// group coverage represents the percentage of all possible transition routes
// present within any of a parent's test cases. The results are grouped by the
// transition route group.
type GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage struct {
	// CoverageScore: The percent of transition routes in all the transition route
	// groups that are covered.
	CoverageScore float64 `json:"coverageScore,omitempty"`
	// Coverages: Transition route group coverages.
	Coverages []*GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage `json:"coverages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoverageScore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage: Coverage
// result message for one transition route group.
type GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage struct {
	// CoverageScore: The percent of transition routes in the transition route
	// group that are covered.
	CoverageScore float64 `json:"coverageScore,omitempty"`
	// RouteGroup: Transition route group metadata. Only name and displayName will
	// be set.
	RouteGroup *GoogleCloudDialogflowCxV3beta1TransitionRouteGroup `json:"routeGroup,omitempty"`
	// Transitions: The list of transition routes and coverage in the transition
	// route group.
	Transitions []*GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverageTransition `json:"transitions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoverageScore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoverageScore") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverage
	var s1 struct {
		CoverageScore gensupport.JSONFloat64 `json:"coverageScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CoverageScore = float64(s1.CoverageScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverageTransition:
//
//	A transition coverage in a transition route group.
type GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverageTransition struct {
	// Covered: Whether the transition route is covered by at least one of the
	// agent's test cases.
	Covered bool `json:"covered,omitempty"`
	// TransitionRoute: Intent route or condition route.
	TransitionRoute *GoogleCloudDialogflowCxV3beta1TransitionRoute `json:"transitionRoute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Covered") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Covered") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverageTransition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TransitionRouteGroupCoverageCoverageTransition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TurnSignals: Collection of all signals that
// were extracted for a single turn of the conversation.
type GoogleCloudDialogflowCxV3beta1TurnSignals struct {
	// AgentEscalated: Whether agent responded with LiveAgentHandoff fulfillment.
	AgentEscalated bool `json:"agentEscalated,omitempty"`
	// DtmfUsed: Whether user was using DTMF input.
	DtmfUsed bool `json:"dtmfUsed,omitempty"`
	// FailureReasons: Failure reasons of the turn.
	//
	// Possible values:
	//   "FAILURE_REASON_UNSPECIFIED" - Failure reason is not assigned.
	//   "FAILED_INTENT" - Whether NLU failed to recognize user intent.
	//   "FAILED_WEBHOOK" - Whether webhook failed during the turn.
	FailureReasons []string `json:"failureReasons,omitempty"`
	// NoMatch: Whether NLU predicted NO_MATCH.
	NoMatch bool `json:"noMatch,omitempty"`
	// NoUserInput: Whether user provided no input.
	NoUserInput bool `json:"noUserInput,omitempty"`
	// ReachedEndPage: Whether turn resulted in End Session page.
	ReachedEndPage bool `json:"reachedEndPage,omitempty"`
	// SentimentMagnitude: Sentiment magnitude of the user utterance if sentiment
	// (https://cloud.google.com/dialogflow/cx/docs/concept/sentiment) was enabled.
	SentimentMagnitude float64 `json:"sentimentMagnitude,omitempty"`
	// SentimentScore: Sentiment score of the user utterance if sentiment
	// (https://cloud.google.com/dialogflow/cx/docs/concept/sentiment) was enabled.
	SentimentScore float64 `json:"sentimentScore,omitempty"`
	// UserEscalated: Whether user was specifically asking for a live agent.
	UserEscalated bool `json:"userEscalated,omitempty"`
	// WebhookStatuses: Human-readable statuses of the webhooks triggered during
	// this turn.
	WebhookStatuses []string `json:"webhookStatuses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentEscalated") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentEscalated") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TurnSignals) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TurnSignals
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1TurnSignals) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1TurnSignals
	var s1 struct {
		SentimentMagnitude gensupport.JSONFloat64 `json:"sentimentMagnitude"`
		SentimentScore     gensupport.JSONFloat64 `json:"sentimentScore"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SentimentMagnitude = float64(s1.SentimentMagnitude)
	s.SentimentScore = float64(s1.SentimentScore)
	return nil
}

// GoogleCloudDialogflowCxV3beta1TypeSchema: Encapsulates different type schema
// variations: either a reference to an a schema that's already defined by a
// tool, or an inline definition.
type GoogleCloudDialogflowCxV3beta1TypeSchema struct {
	// InlineSchema: Set if this is an inline schema definition.
	InlineSchema *GoogleCloudDialogflowCxV3beta1InlineSchema `json:"inlineSchema,omitempty"`
	// SchemaReference: Set if this is a schema reference.
	SchemaReference *GoogleCloudDialogflowCxV3beta1TypeSchemaSchemaReference `json:"schemaReference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InlineSchema") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InlineSchema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TypeSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TypeSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1TypeSchemaSchemaReference: A reference to the
// schema of an existing tool.
type GoogleCloudDialogflowCxV3beta1TypeSchemaSchemaReference struct {
	// Schema: The name of the schema.
	Schema string `json:"schema,omitempty"`
	// Tool: The tool that contains this schema definition. Format:
	// `projects//locations//agents//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Schema") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Schema") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1TypeSchemaSchemaReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1TypeSchemaSchemaReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1UserUtterance: UserUtterance represents one
// message sent by the customer.
type GoogleCloudDialogflowCxV3beta1UserUtterance struct {
	// Audio: Optional. Audio input.
	Audio string `json:"audio,omitempty"`
	// AudioTokens: Optional. Tokens of the audio input.
	AudioTokens []int64 `json:"audioTokens,omitempty"`
	// Text: Required. Message content in text.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Audio") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Audio") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1UserUtterance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1UserUtterance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ValidateAgentRequest: The request message for
// Agents.ValidateAgent.
type GoogleCloudDialogflowCxV3beta1ValidateAgentRequest struct {
	// LanguageCode: If not specified, the agent's default language is used.
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ValidateAgentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ValidateAgentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ValidateFlowRequest: The request message for
// Flows.ValidateFlow.
type GoogleCloudDialogflowCxV3beta1ValidateFlowRequest struct {
	// LanguageCode: If not specified, the agent's default language is used.
	LanguageCode string `json:"languageCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ValidateFlowRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ValidateFlowRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1ValidationMessage: Agent/flow validation
// message.
type GoogleCloudDialogflowCxV3beta1ValidationMessage struct {
	// Detail: The message detail.
	Detail string `json:"detail,omitempty"`
	// ResourceNames: The resource names of the resources where the message is
	// found.
	ResourceNames []*GoogleCloudDialogflowCxV3beta1ResourceName `json:"resourceNames,omitempty"`
	// ResourceType: The type of the resources where the message is found.
	//
	// Possible values:
	//   "RESOURCE_TYPE_UNSPECIFIED" - Unspecified.
	//   "AGENT" - Agent.
	//   "INTENT" - Intent.
	//   "INTENT_TRAINING_PHRASE" - Intent training phrase.
	//   "INTENT_PARAMETER" - Intent parameter.
	//   "INTENTS" - Multiple intents.
	//   "INTENT_TRAINING_PHRASES" - Multiple training phrases.
	//   "ENTITY_TYPE" - Entity type.
	//   "ENTITY_TYPES" - Multiple entity types.
	//   "WEBHOOK" - Webhook.
	//   "FLOW" - Flow.
	//   "PAGE" - Page.
	//   "PAGES" - Multiple pages.
	//   "TRANSITION_ROUTE_GROUP" - Transition route group.
	//   "AGENT_TRANSITION_ROUTE_GROUP" - Agent transition route group.
	ResourceType string `json:"resourceType,omitempty"`
	// Resources: The names of the resources where the message is found.
	Resources []string `json:"resources,omitempty"`
	// Severity: Indicates the severity of the message.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Unspecified.
	//   "INFO" - The agent doesn't follow Dialogflow best practices.
	//   "WARNING" - The agent may not behave as expected.
	//   "ERROR" - The agent may experience failures.
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Detail") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Detail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1ValidationMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1ValidationMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1VariantsHistory: The history of variants
// update.
type GoogleCloudDialogflowCxV3beta1VariantsHistory struct {
	// UpdateTime: Update time of the variants.
	UpdateTime string `json:"updateTime,omitempty"`
	// VersionVariants: The flow versions as the variants.
	VersionVariants *GoogleCloudDialogflowCxV3beta1VersionVariants `json:"versionVariants,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UpdateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UpdateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1VariantsHistory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1VariantsHistory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Version: Represents a version of a flow.
type GoogleCloudDialogflowCxV3beta1Version struct {
	// CreateTime: Output only. Create time of the version.
	CreateTime string `json:"createTime,omitempty"`
	// Description: The description of the version. The maximum length is 500
	// characters. If exceeded, the request is rejected.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The human-readable name of the version. Limit of 64
	// characters.
	DisplayName string `json:"displayName,omitempty"`
	// Name: Format: projects//locations//agents//flows//versions/. Version ID is a
	// self-increasing number generated by Dialogflow upon version creation.
	Name string `json:"name,omitempty"`
	// NluSettings: Output only. The NLU settings of the flow at version creation.
	NluSettings *GoogleCloudDialogflowCxV3beta1NluSettings `json:"nluSettings,omitempty"`
	// State: Output only. The state of this version. This field is read-only and
	// cannot be set by create and update methods.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Not specified. This value is not used.
	//   "RUNNING" - Version is not ready to serve (e.g. training is running).
	//   "SUCCEEDED" - Training has succeeded and this version is ready to serve.
	//   "FAILED" - Version training failed.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Version) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Version
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1VersionVariants: A list of flow version
// variants.
type GoogleCloudDialogflowCxV3beta1VersionVariants struct {
	// Variants: A list of flow version variants.
	Variants []*GoogleCloudDialogflowCxV3beta1VersionVariantsVariant `json:"variants,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Variants") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Variants") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1VersionVariants) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1VersionVariants
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1VersionVariantsVariant: A single flow version
// with specified traffic allocation.
type GoogleCloudDialogflowCxV3beta1VersionVariantsVariant struct {
	// IsControlGroup: Whether the variant is for the control group.
	IsControlGroup bool `json:"isControlGroup,omitempty"`
	// TrafficAllocation: Percentage of the traffic which should be routed to this
	// version of flow. Traffic allocation for a single flow must sum up to 1.0.
	TrafficAllocation float64 `json:"trafficAllocation,omitempty"`
	// Version: The name of the flow version. Format:
	// `projects//locations//agents//flows//versions/`.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IsControlGroup") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IsControlGroup") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1VersionVariantsVariant) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1VersionVariantsVariant
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1VersionVariantsVariant) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1VersionVariantsVariant
	var s1 struct {
		TrafficAllocation gensupport.JSONFloat64 `json:"trafficAllocation"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TrafficAllocation = float64(s1.TrafficAllocation)
	return nil
}

// GoogleCloudDialogflowCxV3beta1VoiceSelectionParams: Description of which
// voice to use for speech synthesis.
type GoogleCloudDialogflowCxV3beta1VoiceSelectionParams struct {
	// Name: Optional. The name of the voice. If not set, the service will choose a
	// voice based on the other parameters such as language_code and ssml_gender.
	// For the list of available voices, please refer to Supported voices and
	// languages (https://cloud.google.com/text-to-speech/docs/voices).
	Name string `json:"name,omitempty"`
	// SsmlGender: Optional. The preferred gender of the voice. If not set, the
	// service will choose a voice based on the other parameters such as
	// language_code and name. Note that this is only a preference, not
	// requirement. If a voice of the appropriate gender is not available, the
	// synthesizer should substitute a voice with a different gender rather than
	// failing the request.
	//
	// Possible values:
	//   "SSML_VOICE_GENDER_UNSPECIFIED" - An unspecified gender, which means that
	// the client doesn't care which gender the selected voice will have.
	//   "SSML_VOICE_GENDER_MALE" - A male voice.
	//   "SSML_VOICE_GENDER_FEMALE" - A female voice.
	//   "SSML_VOICE_GENDER_NEUTRAL" - A gender-neutral voice.
	SsmlGender string `json:"ssmlGender,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1VoiceSelectionParams) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1VoiceSelectionParams
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1Webhook: Webhooks host the developer's
// business logic. During a session, webhooks allow the developer to use the
// data extracted by Dialogflow's natural language processing to generate
// dynamic responses, validate collected data, or trigger actions on the
// backend.
type GoogleCloudDialogflowCxV3beta1Webhook struct {
	// Disabled: Indicates whether the webhook is disabled.
	Disabled bool `json:"disabled,omitempty"`
	// DisplayName: Required. The human-readable name of the webhook, unique within
	// the agent.
	DisplayName string `json:"displayName,omitempty"`
	// GenericWebService: Configuration for a generic web service.
	GenericWebService *GoogleCloudDialogflowCxV3beta1WebhookGenericWebService `json:"genericWebService,omitempty"`
	// Name: The unique identifier of the webhook. Required for the
	// Webhooks.UpdateWebhook method. Webhooks.CreateWebhook populates the name
	// automatically. Format: `projects//locations//agents//webhooks/`.
	Name string `json:"name,omitempty"`
	// ServiceDirectory: Configuration for a Service Directory
	// (https://cloud.google.com/service-directory) service.
	ServiceDirectory *GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig `json:"serviceDirectory,omitempty"`
	// Timeout: Webhook execution timeout. Execution is considered failed if
	// Dialogflow doesn't receive a response from webhook at the end of the timeout
	// period. Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
	Timeout string `json:"timeout,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1Webhook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1Webhook
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookGenericWebService: Represents
// configuration for a generic web service.
type GoogleCloudDialogflowCxV3beta1WebhookGenericWebService struct {
	// AllowedCaCerts: Optional. Specifies a list of allowed custom CA certificates
	// (in DER format) for HTTPS verification. This overrides the default SSL trust
	// store. If this is empty or unspecified, Dialogflow will use Google's default
	// trust store to verify certificates. N.B. Make sure the HTTPS server
	// certificates are signed with "subject alt name". For instance a certificate
	// can be self-signed using the following command, ``` openssl x509 -req -days
	// 200 -in example.com.csr \ -signkey example.com.key \ -out example.com.crt \
	// -extfile <(printf "\nsubjectAltName='DNS:www.example.com'") ```
	AllowedCaCerts []string `json:"allowedCaCerts,omitempty"`
	// HttpMethod: Optional. HTTP method for the flexible webhook calls. Standard
	// webhook always uses POST.
	//
	// Possible values:
	//   "HTTP_METHOD_UNSPECIFIED" - HTTP method not specified.
	//   "POST" - HTTP POST Method.
	//   "GET" - HTTP GET Method.
	//   "HEAD" - HTTP HEAD Method.
	//   "PUT" - HTTP PUT Method.
	//   "DELETE" - HTTP DELETE Method.
	//   "PATCH" - HTTP PATCH Method.
	//   "OPTIONS" - HTTP OPTIONS Method.
	HttpMethod string `json:"httpMethod,omitempty"`
	// OauthConfig: Optional. The OAuth configuration of the webhook. If specified,
	// Dialogflow will initiate the OAuth client credential flow to exchange an
	// access token from the 3rd party platform and put it in the auth header.
	OauthConfig *GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig `json:"oauthConfig,omitempty"`
	// ParameterMapping: Optional. Maps the values extracted from specific fields
	// of the flexible webhook response into session parameters. - Key: session
	// parameter name - Value: field path in the webhook response
	ParameterMapping map[string]string `json:"parameterMapping,omitempty"`
	// Password: The password for HTTP Basic authentication.
	Password string `json:"password,omitempty"`
	// RequestBody: Optional. Defines a custom JSON object as request body to send
	// to flexible webhook.
	RequestBody string `json:"requestBody,omitempty"`
	// RequestHeaders: The HTTP request headers to send together with webhook
	// requests.
	RequestHeaders map[string]string `json:"requestHeaders,omitempty"`
	// SecretVersionForUsernamePassword: Optional. The SecretManager secret version
	// resource storing the username:password pair for HTTP Basic authentication.
	// Format: `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForUsernamePassword string `json:"secretVersionForUsernamePassword,omitempty"`
	// SecretVersionsForRequestHeaders: Optional. The HTTP request headers to send
	// together with webhook requests. Header values are stored in SecretManager
	// secret versions. When the same header name is specified in both
	// `request_headers` and `secret_versions_for_request_headers`, the value in
	// `secret_versions_for_request_headers` will be used.
	SecretVersionsForRequestHeaders map[string]GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue `json:"secretVersionsForRequestHeaders,omitempty"`
	// ServiceAgentAuth: Optional. Indicate the auth token type generated from the
	// Diglogflow service agent
	// (https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
	// The generated token is sent in the Authorization header.
	//
	// Possible values:
	//   "SERVICE_AGENT_AUTH_UNSPECIFIED" - Service agent auth type unspecified.
	// Default to ID_TOKEN.
	//   "NONE" - No token used.
	//   "ID_TOKEN" - Use [ID
	// token](https://cloud.google.com/docs/authentication/token-types#id)
	// generated from service agent. This can be used to access Cloud Function and
	// Cloud Run after you grant Invoker role to
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	//   "ACCESS_TOKEN" - Use [access
	// token](https://cloud.google.com/docs/authentication/token-types#access)
	// generated from service agent. This can be used to access other Google Cloud
	// APIs after you grant required roles to
	// `service-@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	ServiceAgentAuth string `json:"serviceAgentAuth,omitempty"`
	// Uri: Required. The webhook URI for receiving POST requests. It must use
	// https protocol.
	Uri string `json:"uri,omitempty"`
	// Username: The user name for HTTP Basic authentication.
	Username string `json:"username,omitempty"`
	// WebhookType: Optional. Type of the webhook.
	//
	// Possible values:
	//   "WEBHOOK_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "STANDARD" - Represents a standard webhook.
	//   "FLEXIBLE" - Represents a flexible webhook.
	WebhookType string `json:"webhookType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedCaCerts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedCaCerts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig:
// Represents configuration of OAuth client credential flow for 3rd party API
// authentication.
type GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig struct {
	// ClientId: Required. The client ID provided by the 3rd party platform.
	ClientId string `json:"clientId,omitempty"`
	// ClientSecret: Optional. The client secret provided by the 3rd party
	// platform.
	ClientSecret string `json:"clientSecret,omitempty"`
	// Scopes: Optional. The OAuth scopes to grant.
	Scopes []string `json:"scopes,omitempty"`
	// SecretVersionForClientSecret: Optional. The name of the SecretManager secret
	// version resource storing the client secret. If this field is set, the
	// `client_secret` field will be ignored. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForClientSecret string `json:"secretVersionForClientSecret,omitempty"`
	// TokenEndpoint: Required. The token endpoint provided by the 3rd party
	// platform to exchange an access token.
	TokenEndpoint string `json:"tokenEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValu
// e: Represents the value of an HTTP header stored in a SecretManager secret
// version.
type GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue struct {
	// SecretVersion: Required. The SecretManager secret version resource storing
	// the header value. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersion string `json:"secretVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequest: The request message for a
// webhook call. The request is sent as a JSON object and the field names will
// be presented in camel cases. You may see undocumented fields in an actual
// request. These fields are used internally by Dialogflow and should be
// ignored.
type GoogleCloudDialogflowCxV3beta1WebhookRequest struct {
	// DetectIntentResponseId: Always present. The unique identifier of the
	// DetectIntentResponse that will be returned to the API caller.
	DetectIntentResponseId string `json:"detectIntentResponseId,omitempty"`
	// DtmfDigits: If DTMF was provided as input, this field will contain the DTMF
	// digits.
	DtmfDigits string `json:"dtmfDigits,omitempty"`
	// FulfillmentInfo: Always present. Information about the fulfillment that
	// triggered this webhook call.
	FulfillmentInfo *GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo `json:"fulfillmentInfo,omitempty"`
	// IntentInfo: Information about the last matched intent.
	IntentInfo *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo `json:"intentInfo,omitempty"`
	// LanguageCode: The language code specified in the original request.
	LanguageCode string `json:"languageCode,omitempty"`
	// LanguageInfo: Information about the language of the request.
	LanguageInfo *GoogleCloudDialogflowCxV3beta1LanguageInfo `json:"languageInfo,omitempty"`
	// Messages: The list of rich message responses to present to the user. Webhook
	// can choose to append or replace this list in
	// WebhookResponse.fulfillment_response;
	Messages []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"messages,omitempty"`
	// PageInfo: Information about page status.
	PageInfo *GoogleCloudDialogflowCxV3beta1PageInfo `json:"pageInfo,omitempty"`
	// Payload: Custom data set in QueryParameters.payload.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// SentimentAnalysisResult: The sentiment analysis result of the current user
	// request. The field is filled when sentiment analysis is configured to be
	// enabled for the request.
	SentimentAnalysisResult *GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	// SessionInfo: Information about session status.
	SessionInfo *GoogleCloudDialogflowCxV3beta1SessionInfo `json:"sessionInfo,omitempty"`
	// Text: If natural language text was provided as input, this field will
	// contain a copy of the text.
	Text string `json:"text,omitempty"`
	// Transcript: If natural language speech audio was provided as input, this
	// field will contain the transcript for the audio.
	Transcript string `json:"transcript,omitempty"`
	// TriggerEvent: If an event was provided as input, this field will contain the
	// name of the event.
	TriggerEvent string `json:"triggerEvent,omitempty"`
	// TriggerIntent: If an intent was provided as input, this field will contain a
	// copy of the intent identifier. Format:
	// `projects//locations//agents//intents/`.
	TriggerIntent string `json:"triggerIntent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DetectIntentResponseId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DetectIntentResponseId") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo: Represents
// fulfillment information communicated to the webhook.
type GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo struct {
	// Tag: Always present. The value of the Fulfillment.tag field will be
	// populated in this field by Dialogflow when the associated webhook is called.
	// The tag is typically used by the webhook service to identify which
	// fulfillment is being called, but it could be used for other purposes.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Tag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Tag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo: Represents intent
// information communicated to the webhook.
type GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo struct {
	// Confidence: The confidence of the matched intent. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// DisplayName: Always present. The display name of the last matched intent.
	DisplayName string `json:"displayName,omitempty"`
	// LastMatchedIntent: Always present. The unique identifier of the last matched
	// intent. Format: `projects//locations//agents//intents/`.
	LastMatchedIntent string `json:"lastMatchedIntent,omitempty"`
	// Parameters: Parameters identified as a result of intent matching. This is a
	// map of the name of the identified parameter to the value of the parameter
	// identified from the user's utterance. All parameters defined in the matched
	// intent that are identified will be surfaced here.
	Parameters map[string]GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue:
// Represents a value for an intent parameter.
type GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue struct {
	// OriginalValue: Always present. Original text value extracted from user
	// utterance.
	OriginalValue string `json:"originalValue,omitempty"`
	// ResolvedValue: Always present. Structured value for the parameter extracted
	// from user utterance.
	ResolvedValue interface{} `json:"resolvedValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OriginalValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OriginalValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult:
// Represents the result of sentiment analysis.
type GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which represents
	// the absolute magnitude of sentiment, regardless of score (positive or
	// negative).
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowCxV3beta1WebhookResponse: The response message for a
// webhook call.
type GoogleCloudDialogflowCxV3beta1WebhookResponse struct {
	// FulfillmentResponse: The fulfillment response to send to the user. This
	// field can be omitted by the webhook if it does not intend to send any
	// response to the user.
	FulfillmentResponse *GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse `json:"fulfillmentResponse,omitempty"`
	// PageInfo: Information about page status. This field can be omitted by the
	// webhook if it does not intend to modify page status.
	PageInfo *GoogleCloudDialogflowCxV3beta1PageInfo `json:"pageInfo,omitempty"`
	// Payload: Value to append directly to QueryResult.webhook_payloads.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// SessionInfo: Information about session status. This field can be omitted by
	// the webhook if it does not intend to modify session status.
	SessionInfo *GoogleCloudDialogflowCxV3beta1SessionInfo `json:"sessionInfo,omitempty"`
	// TargetFlow: The target flow to transition to. Format:
	// `projects//locations//agents//flows/`.
	TargetFlow string `json:"targetFlow,omitempty"`
	// TargetPage: The target page to transition to. Format:
	// `projects//locations//agents//flows//pages/`.
	TargetPage string `json:"targetPage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FulfillmentResponse") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FulfillmentResponse") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse: Represents
// a fulfillment response to the user.
type GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse struct {
	// MergeBehavior: Merge behavior for `messages`.
	//
	// Possible values:
	//   "MERGE_BEHAVIOR_UNSPECIFIED" - Not specified. `APPEND` will be used.
	//   "APPEND" - `messages` will be appended to the list of messages waiting to
	// be sent to the user.
	//   "REPLACE" - `messages` will replace the list of messages waiting to be
	// sent to the user.
	MergeBehavior string `json:"mergeBehavior,omitempty"`
	// Messages: The list of rich message responses to present to the user.
	Messages []*GoogleCloudDialogflowCxV3beta1ResponseMessage `json:"messages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MergeBehavior") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MergeBehavior") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig: Represents
// configuration for a Service Directory
// (https://cloud.google.com/service-directory) service.
type GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig struct {
	// GenericWebService: Generic Service configuration of this webhook.
	GenericWebService *GoogleCloudDialogflowCxV3beta1WebhookGenericWebService `json:"genericWebService,omitempty"`
	// Service: Required. The name of Service Directory
	// (https://cloud.google.com/service-directory) service. Format:
	// `projects//locations//namespaces//services/`. `Location ID` of the service
	// directory must be the same as the location of the agent.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GenericWebService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GenericWebService") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2AnnotatedMessagePart: Represents a part of a message
// possibly annotated with an entity. The part can be an entity or purely a
// part of the message between two entities or message start/end.
type GoogleCloudDialogflowV2AnnotatedMessagePart struct {
	// EntityType: The Dialogflow system entity type
	// (https://cloud.google.com/dialogflow/docs/reference/system-entities) of this
	// message part. If this is empty, Dialogflow could not annotate the phrase
	// part with a system entity.
	EntityType string `json:"entityType,omitempty"`
	// FormattedValue: The Dialogflow system entity formatted value
	// (https://cloud.google.com/dialogflow/docs/reference/system-entities) of this
	// message part. For example for a system entity of type `@sys.unit-currency`,
	// this may contain: { "amount": 5, "currency": "USD" }
	FormattedValue interface{} `json:"formattedValue,omitempty"`
	// Text: A part of a message possibly annotated with an entity.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2AnnotatedMessagePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2AnnotatedMessagePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ArticleAnswer: Represents article answer.
type GoogleCloudDialogflowV2ArticleAnswer struct {
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: Article match confidence. The system's confidence score that
	// this article is a good match for this conversation, as a value from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// Metadata: A map that contains metadata about the answer and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Snippets: Article snippets.
	Snippets []string `json:"snippets,omitempty"`
	// Title: The article title.
	Title string `json:"title,omitempty"`
	// Uri: The article URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ArticleAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ArticleAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2ArticleAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2ArticleAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2ArticleSuggestionModelMetadata: Metadata for article
// suggestion models.
type GoogleCloudDialogflowV2ArticleSuggestionModelMetadata struct {
	// TrainingModelType: Optional. Type of the article suggestion model. If not
	// provided, model_type is used.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - ModelType unspecified.
	//   "SMART_REPLY_DUAL_ENCODER_MODEL" - ModelType smart reply dual encoder
	// model.
	//   "SMART_REPLY_BERT_MODEL" - ModelType smart reply bert model.
	TrainingModelType string `json:"trainingModelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrainingModelType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrainingModelType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ArticleSuggestionModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ArticleSuggestionModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse: The response message
// for EntityTypes.BatchUpdateEntityTypes.
type GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse struct {
	// EntityTypes: The collection of updated or created entity types.
	EntityTypes []*GoogleCloudDialogflowV2EntityType `json:"entityTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntityTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntityTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2BatchUpdateIntentsResponse: The response message for
// Intents.BatchUpdateIntents.
type GoogleCloudDialogflowV2BatchUpdateIntentsResponse struct {
	// Intents: The collection of updated or created intents.
	Intents []*GoogleCloudDialogflowV2Intent `json:"intents,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Intents") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Intents") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2BatchUpdateIntentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2BatchUpdateIntentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata:
// Metadata for a ConversationProfiles.ClearSuggestionFeatureConfig operation.
type GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata struct {
	// ConversationProfile: The resource name of the conversation profile. Format:
	// `projects//locations//conversationProfiles/`
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// CreateTime: Timestamp whe the request was created. The time is measured on
	// server side.
	CreateTime string `json:"createTime,omitempty"`
	// ParticipantRole: Required. The participant role to remove the suggestion
	// feature config. Only HUMAN_AGENT or END_USER can be used.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant role not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent, such as a
	// Dialogflow agent.
	//   "END_USER" - Participant is an end user that has called or chatted with
	// Dialogflow services.
	ParticipantRole string `json:"participantRole,omitempty"`
	// SuggestionFeatureType: Required. The type of the suggestion feature to
	// remove.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified feature type.
	//   "ARTICLE_SUGGESTION" - Run article suggestion model for chat.
	//   "FAQ" - Run FAQ model for chat.
	//   "SMART_REPLY" - Run smart reply model for chat.
	//   "CONVERSATION_SUMMARIZATION" - Run conversation summarization model for
	// chat.
	//   "KNOWLEDGE_SEARCH" - Run knowledge search with text input from agent or
	// text generated query.
	//   "KNOWLEDGE_ASSIST" - Run knowledge assist with automatic query generation.
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2Context: Dialogflow contexts are similar to natural
// language context. If a person says to you "they are orange", you need
// context in order to understand what "they" is referring to. Similarly, for
// Dialogflow to handle an end-user expression like that, it needs to be
// provided with context in order to correctly match an intent. Using contexts,
// you can control the flow of a conversation. You can configure contexts for
// an intent by setting input and output contexts, which are identified by
// string names. When an intent is matched, any configured output contexts for
// that intent become active. While any contexts are active, Dialogflow is more
// likely to match intents that are configured with input contexts that
// correspond to the currently active contexts. For more information about
// context, see the Contexts guide
// (https://cloud.google.com/dialogflow/docs/contexts-overview).
type GoogleCloudDialogflowV2Context struct {
	// LifespanCount: Optional. The number of conversational query requests after
	// which the context expires. The default is `0`. If set to `0`, the context
	// expires immediately. Contexts expire automatically after 20 minutes if there
	// are no matching queries.
	LifespanCount int64 `json:"lifespanCount,omitempty"`
	// Name: Required. The unique identifier of the context. Format:
	// `projects//agent/sessions//contexts/`, or
	// `projects//agent/environments//users//sessions//contexts/`. The `Context ID`
	// is always converted to lowercase, may only contain characters in
	// `a-zA-Z0-9_-%` and may be at most 250 bytes long. If `Environment ID` is not
	// specified, we assume default 'draft' environment. If `User ID` is not
	// specified, we assume default '-' user. The following context names are
	// reserved for internal use by Dialogflow. You should not use these contexts
	// or create contexts with these names: * `__system_counters__` *
	// `*_id_dialog_context` * `*_dialog_params_size`
	Name string `json:"name,omitempty"`
	// Parameters: Optional. The collection of parameters associated with this
	// context. Depending on your protocol or client library language, this is a
	// map, associative array, symbol table, dictionary, or JSON object composed of
	// a collection of (MapKey, MapValue) pairs: * MapKey type: string * MapKey
	// value: parameter name * MapValue type: If parameter's entity type is a
	// composite entity then use map, otherwise, depending on the parameter value
	// type, it could be one of string, number, boolean, null, list or map. *
	// MapValue value: If parameter's entity type is a composite entity then use
	// map from composite entity property names to property values, otherwise, use
	// parameter value.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LifespanCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LifespanCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Context) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Context
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ConversationEvent: Represents a notification sent to
// Pub/Sub subscribers for conversation lifecycle events.
type GoogleCloudDialogflowV2ConversationEvent struct {
	// Conversation: The unique identifier of the conversation this notification
	// refers to. Format: `projects//conversations/`.
	Conversation string `json:"conversation,omitempty"`
	// ErrorStatus: More detailed information about an error. Only set for type
	// UNRECOVERABLE_ERROR_IN_PHONE_CALL.
	ErrorStatus *GoogleRpcStatus `json:"errorStatus,omitempty"`
	// NewMessagePayload: Payload of NEW_MESSAGE event.
	NewMessagePayload *GoogleCloudDialogflowV2Message `json:"newMessagePayload,omitempty"`
	// NewRecognitionResultPayload: Payload of NEW_RECOGNITION_RESULT event.
	NewRecognitionResultPayload *GoogleCloudDialogflowV2StreamingRecognitionResult `json:"newRecognitionResultPayload,omitempty"`
	// Type: The type of the event that this notification refers to.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Type not set.
	//   "CONVERSATION_STARTED" - A new conversation has been opened. This is fired
	// when a telephone call is answered, or a conversation is created via the API.
	//   "CONVERSATION_FINISHED" - An existing conversation has closed. This is
	// fired when a telephone call is terminated, or a conversation is closed via
	// the API.
	//   "HUMAN_INTERVENTION_NEEDED" - An existing conversation has received
	// notification from Dialogflow that human intervention is required.
	//   "NEW_MESSAGE" - An existing conversation has received a new message,
	// either from API or telephony. It is configured in
	// ConversationProfile.new_message_event_notification_config
	//   "NEW_RECOGNITION_RESULT" - An existing conversation has received a new
	// speech recognition result. This is mainly for delivering intermediate
	// transcripts. The notification is configured in
	// ConversationProfile.new_recognition_event_notification_config.
	//   "UNRECOVERABLE_ERROR" - Unrecoverable error during a telephone call. In
	// general non-recoverable errors only occur if something was misconfigured in
	// the ConversationProfile corresponding to the call. After a non-recoverable
	// error, Dialogflow may stop responding. We don't fire this event: * in an API
	// call because we can directly return the error, or, * when we can recover
	// from an error.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ConversationModel: Represents a conversation model.
type GoogleCloudDialogflowV2ConversationModel struct {
	// ArticleSuggestionModelMetadata: Metadata for article suggestion models.
	ArticleSuggestionModelMetadata *GoogleCloudDialogflowV2ArticleSuggestionModelMetadata `json:"articleSuggestionModelMetadata,omitempty"`
	// CreateTime: Output only. Creation time of this model.
	CreateTime string `json:"createTime,omitempty"`
	// Datasets: Required. Datasets used to create model.
	Datasets []*GoogleCloudDialogflowV2InputDataset `json:"datasets,omitempty"`
	// DisplayName: Required. The display name of the model. At most 64 bytes long.
	DisplayName string `json:"displayName,omitempty"`
	// LanguageCode: Language code for the conversation model. If not specified,
	// the language is en-US. Language at ConversationModel should be set for all
	// non en-us languages. This should be a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: ConversationModel resource name. Format:
	// `projects//conversationModels/`
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. A read only boolean field reflecting Zone
	// Isolation status of the model.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. A read only boolean field reflecting Zone
	// Separation status of the model.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SmartReplyModelMetadata: Metadata for smart reply models.
	SmartReplyModelMetadata *GoogleCloudDialogflowV2SmartReplyModelMetadata `json:"smartReplyModelMetadata,omitempty"`
	// State: Output only. State of the model. A model can only serve prediction
	// requests after it gets deployed.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Should not be used, an un-set enum has this value by
	// default.
	//   "CREATING" - Model being created.
	//   "UNDEPLOYED" - Model is not deployed but ready to deploy.
	//   "DEPLOYING" - Model is deploying.
	//   "DEPLOYED" - Model is deployed and ready to use.
	//   "UNDEPLOYING" - Model is undeploying.
	//   "DELETING" - Model is deleting.
	//   "FAILED" - Model is in error state. Not ready to deploy and use.
	//   "PENDING" - Model is being created but the training has not started, The
	// model may remain in this state until there is enough capacity to start
	// training.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ArticleSuggestionModelMetadata") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleSuggestionModelMetadata")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ConversationModel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ConversationModel
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata: Metadata
// for CreateConversationDataset.
type GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata struct {
	// ConversationDataset: The resource name of the conversation dataset that will
	// be created. Format: `projects//locations//conversationDatasets/`
	ConversationDataset string `json:"conversationDataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata:
// Metadata for a ConversationModels.CreateConversationModelEvaluation
// operation.
type GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata struct {
	// ConversationModel: The resource name of the conversation model. Format:
	// `projects//locations//conversationModels/`
	ConversationModel string `json:"conversationModel,omitempty"`
	// ConversationModelEvaluation: The resource name of the conversation model.
	// Format: `projects//locations//conversationModels//evaluations/`
	ConversationModelEvaluation string `json:"conversationModelEvaluation,omitempty"`
	// CreateTime: Timestamp when the request to create conversation model was
	// submitted. The time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// State: State of CreateConversationModel operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Operation status not specified.
	//   "INITIALIZING" - The operation is being prepared.
	//   "RUNNING" - The operation is running.
	//   "CANCELLED" - The operation is cancelled.
	//   "SUCCEEDED" - The operation has succeeded.
	//   "FAILED" - The operation has failed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2CreateConversationModelOperationMetadata: Metadata
// for a ConversationModels.CreateConversationModel operation.
type GoogleCloudDialogflowV2CreateConversationModelOperationMetadata struct {
	// ConversationModel: The resource name of the conversation model. Format:
	// `projects//conversationModels/`
	ConversationModel string `json:"conversationModel,omitempty"`
	// CreateTime: Timestamp when the request to create conversation model is
	// submitted. The time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// State: State of CreateConversationModel operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Invalid.
	//   "PENDING" - Request is submitted, but training has not started yet. The
	// model may remain in this state until there is enough capacity to start
	// training.
	//   "SUCCEEDED" - The training has succeeded.
	//   "FAILED" - The training has succeeded.
	//   "CANCELLED" - The training has been cancelled.
	//   "CANCELLING" - The training is in cancelling state.
	//   "TRAINING" - Custom model is training.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2CreateConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2CreateConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2DeleteConversationDatasetOperationMetadata: Metadata
// for DeleteConversationDataset.
type GoogleCloudDialogflowV2DeleteConversationDatasetOperationMetadata struct {
}

// GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata: Metadata
// for a ConversationModels.DeleteConversationModel operation.
type GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata struct {
	// ConversationModel: The resource name of the conversation model. Format:
	// `projects//conversationModels/`
	ConversationModel string `json:"conversationModel,omitempty"`
	// CreateTime: Timestamp when delete conversation model request was created.
	// The time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2DeployConversationModelOperationMetadata: Metadata
// for a ConversationModels.DeployConversationModel operation.
type GoogleCloudDialogflowV2DeployConversationModelOperationMetadata struct {
	// ConversationModel: The resource name of the conversation model. Format:
	// `projects//conversationModels/`
	ConversationModel string `json:"conversationModel,omitempty"`
	// CreateTime: Timestamp when request to deploy conversation model was
	// submitted. The time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationModel") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2DeployConversationModelOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2DeployConversationModelOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2EncryptionSpec: A customer-managed encryption key
// specification that can be applied to all created resources (e.g.
// Conversation).
type GoogleCloudDialogflowV2EncryptionSpec struct {
	// KmsKey: Required. The name of customer-managed encryption key that is used
	// to secure a resource and its sub-resources. If empty, the resource is
	// secured by the default Google encryption key. Only the key in the same
	// location as this resource is allowed to be used for encryption. Format:
	// `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{key}`
	KmsKey string `json:"kmsKey,omitempty"`
	// Name: Immutable. The resource name of the encryption key specification
	// resource. Format: projects/{project}/locations/{location}/encryptionSpec
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EncryptionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EncryptionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2EntityType: Each intent parameter has a type, called
// the entity type, which dictates exactly how data from an end-user expression
// is extracted. Dialogflow provides predefined system entities that can match
// many common types of data. For example, there are system entities for
// matching dates, times, colors, email addresses, and so on. You can also
// create your own custom entities for matching custom data. For example, you
// could define a vegetable entity that can match the types of vegetables
// available for purchase with a grocery store agent. For more information, see
// the Entity guide
// (https://cloud.google.com/dialogflow/docs/entities-overview).
type GoogleCloudDialogflowV2EntityType struct {
	// AutoExpansionMode: Optional. Indicates whether the entity type can be
	// automatically expanded.
	//
	// Possible values:
	//   "AUTO_EXPANSION_MODE_UNSPECIFIED" - Auto expansion disabled for the
	// entity.
	//   "AUTO_EXPANSION_MODE_DEFAULT" - Allows an agent to recognize values that
	// have not been explicitly listed in the entity.
	AutoExpansionMode string `json:"autoExpansionMode,omitempty"`
	// DisplayName: Required. The name of the entity type.
	DisplayName string `json:"displayName,omitempty"`
	// EnableFuzzyExtraction: Optional. Enables fuzzy entity extraction during
	// classification.
	EnableFuzzyExtraction bool `json:"enableFuzzyExtraction,omitempty"`
	// Entities: Optional. The collection of entity entries associated with the
	// entity type.
	Entities []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`
	// Kind: Required. Indicates the kind of entity type.
	//
	// Possible values:
	//   "KIND_UNSPECIFIED" - Not specified. This value should be never used.
	//   "KIND_MAP" - Map entity types allow mapping of a group of synonyms to a
	// reference value.
	//   "KIND_LIST" - List entity types contain a set of entries that do not map
	// to reference values. However, list entity types can contain references to
	// other entity types (with or without aliases).
	//   "KIND_REGEXP" - Regexp entity types allow to specify regular expressions
	// in entries values.
	Kind string `json:"kind,omitempty"`
	// Name: The unique identifier of the entity type. Required for
	// EntityTypes.UpdateEntityType and EntityTypes.BatchUpdateEntityTypes methods.
	// Format: `projects//agent/entityTypes/`.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoExpansionMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoExpansionMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2EntityTypeEntity: An **entity entry** for an
// associated entity type.
type GoogleCloudDialogflowV2EntityTypeEntity struct {
	// Synonyms: Required. A collection of value synonyms. For example, if the
	// entity type is *vegetable*, and `value` is *scallions*, a synonym could be
	// *green onions*. For `KIND_LIST` entity types: * This collection must contain
	// exactly one synonym equal to `value`.
	Synonyms []string `json:"synonyms,omitempty"`
	// Value: Required. The primary value associated with this entity entry. For
	// example, if the entity type is *vegetable*, the value could be *scallions*.
	// For `KIND_MAP` entity types: * A reference value to be used in place of
	// synonyms. For `KIND_LIST` entity types: * A string that can contain
	// references to other entity types (with or without aliases).
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Synonyms") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Synonyms") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EntityTypeEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EntityTypeEntity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2EventInput: Events allow for matching intents by
// event name instead of the natural language input. For instance, input “ can
// trigger a personalized welcome response. The parameter `name` may be used by
// the agent in the response: "Hello #welcome_event.name! What can I do for
// you today?".
type GoogleCloudDialogflowV2EventInput struct {
	// LanguageCode: Required. The language of this query. See Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes. Note that queries in the same
	// session do not necessarily need to specify the same language. This field is
	// ignored when used in the context of a WebhookResponse.followup_event_input
	// field, because the language was already defined in the originating detect
	// intent request.
	LanguageCode string `json:"languageCode,omitempty"`
	// Name: Required. The unique identifier of the event.
	Name string `json:"name,omitempty"`
	// Parameters: The collection of parameters associated with the event.
	// Depending on your protocol or client library language, this is a map,
	// associative array, symbol table, dictionary, or JSON object composed of a
	// collection of (MapKey, MapValue) pairs: * MapKey type: string * MapKey
	// value: parameter name * MapValue type: If parameter's entity type is a
	// composite entity then use map, otherwise, depending on the parameter value
	// type, it could be one of string, number, boolean, null, list or map. *
	// MapValue value: If parameter's entity type is a composite entity then use
	// map from composite entity property names to property values, otherwise, use
	// parameter value.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2EventInput) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2EventInput
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ExportAgentResponse: The response message for
// Agents.ExportAgent.
type GoogleCloudDialogflowV2ExportAgentResponse struct {
	// AgentContent: Zip compressed raw byte content for agent.
	AgentContent string `json:"agentContent,omitempty"`
	// AgentUri: The URI to a file containing the exported agent. This field is
	// populated only if `agent_uri` is specified in `ExportAgentRequest`.
	AgentUri string `json:"agentUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AgentContent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AgentContent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ExportAgentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ExportAgentResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ExportOperationMetadata: Metadata related to the
// Export Data Operations (e.g. ExportDocument).
type GoogleCloudDialogflowV2ExportOperationMetadata struct {
	// ExportedGcsDestination: Cloud Storage file path of the exported data.
	ExportedGcsDestination *GoogleCloudDialogflowV2GcsDestination `json:"exportedGcsDestination,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportedGcsDestination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportedGcsDestination") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ExportOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ExportOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2FaqAnswer: Represents answer from "frequently asked
// questions".
type GoogleCloudDialogflowV2FaqAnswer struct {
	// Answer: The piece of text from the `source` knowledge base document.
	Answer string `json:"answer,omitempty"`
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: The system's confidence score that this Knowledge answer is a
	// good match for this conversational query, range from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// Metadata: A map that contains metadata about the answer and the document
	// from which it originates.
	Metadata map[string]string `json:"metadata,omitempty"`
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// Source: Indicates which Knowledge Document this answer was extracted from.
	// Format: `projects//locations//agent/knowledgeBases//documents/`.
	Source string `json:"source,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Answer") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Answer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FaqAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FaqAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2FaqAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2FaqAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2FreeFormSuggestion: Suggestion generated using free
// form generator.
type GoogleCloudDialogflowV2FreeFormSuggestion struct {
	// Response: Required. Free form suggestion.
	Response string `json:"response,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Response") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Response") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2FreeFormSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2FreeFormSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2GcsDestination: Google Cloud Storage location for the
// output.
type GoogleCloudDialogflowV2GcsDestination struct {
	// Uri: The Google Cloud Storage URIs for the output. A URI is of the form:
	// `gs://bucket/object-prefix-or-name` Whether a prefix or name is used depends
	// on the use case. The requesting user must have "write-permission" to the
	// bucket.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GcsDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2GenerateSuggestionsResponse: The response message for
// Conversations.GenerateSuggestions.
type GoogleCloudDialogflowV2GenerateSuggestionsResponse struct {
	// GeneratorSuggestionAnswers: The answers generated for the conversation based
	// on context.
	GeneratorSuggestionAnswers []*GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer `json:"generatorSuggestionAnswers,omitempty"`
	// LatestMessage: The name of the latest conversation message used as context
	// for compiling suggestion. Format:
	// `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GeneratorSuggestionAnswers")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GeneratorSuggestionAnswers") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateSuggestionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateSuggestionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer:
// A GeneratorSuggestion answer.
type GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer struct {
	// AnswerRecord: Answer record that uniquely identifies the suggestion. This
	// can be used to provide suggestion feedback.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// GeneratorSuggestion: Suggestion details.
	GeneratorSuggestion *GoogleCloudDialogflowV2GeneratorSuggestion `json:"generatorSuggestion,omitempty"`
	// SourceGenerator: The name of the generator used to generate this suggestion.
	// Format: `projects//locations//generators/`.
	SourceGenerator string `json:"sourceGenerator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2GeneratorSuggestion: Suggestion generated using a
// Generator.
type GoogleCloudDialogflowV2GeneratorSuggestion struct {
	// FreeFormSuggestion: Optional. Free form suggestion.
	FreeFormSuggestion *GoogleCloudDialogflowV2FreeFormSuggestion `json:"freeFormSuggestion,omitempty"`
	// SummarySuggestion: Optional. Suggested summary.
	SummarySuggestion *GoogleCloudDialogflowV2SummarySuggestion `json:"summarySuggestion,omitempty"`
	// ToolCallInfo: Optional. List of request and response for tool calls
	// executed.
	ToolCallInfo []*GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo `json:"toolCallInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FreeFormSuggestion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FreeFormSuggestion") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo: Request and response
// for a tool call.
type GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo struct {
	// ToolCall: Required. Request for a tool call.
	ToolCall *GoogleCloudDialogflowV2ToolCall `json:"toolCall,omitempty"`
	// ToolCallResult: Required. Response for a tool call.
	ToolCallResult *GoogleCloudDialogflowV2ToolCallResult `json:"toolCallResult,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ToolCall") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ToolCall") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2HumanAgentAssistantEvent: Represents a notification
// sent to Cloud Pub/Sub subscribers for human agent assistant events in a
// specific conversation.
type GoogleCloudDialogflowV2HumanAgentAssistantEvent struct {
	// Conversation: The conversation this notification refers to. Format:
	// `projects//conversations/`.
	Conversation string `json:"conversation,omitempty"`
	// Participant: The participant that the suggestion is compiled for. Format:
	// `projects//conversations//participants/`. It will not be set in legacy
	// workflow.
	Participant string `json:"participant,omitempty"`
	// SuggestionResults: The suggestion results payload that this notification
	// refers to.
	SuggestionResults []*GoogleCloudDialogflowV2SuggestionResult `json:"suggestionResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conversation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conversation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2HumanAgentAssistantEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2HumanAgentAssistantEvent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ImportConversationDataOperationMetadata: Metadata for
// a ConversationDatasets.ImportConversationData operation.
type GoogleCloudDialogflowV2ImportConversationDataOperationMetadata struct {
	// ConversationDataset: The resource name of the imported conversation dataset.
	// Format: `projects//locations//conversationDatasets/`
	ConversationDataset string `json:"conversationDataset,omitempty"`
	// CreateTime: Timestamp when import conversation data request was created. The
	// time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// PartialFailures: Partial failures are failures that don't fail the whole
	// long running operation, e.g. single files that couldn't be read.
	PartialFailures []*GoogleRpcStatus `json:"partialFailures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportConversationDataOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportConversationDataOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ImportConversationDataOperationResponse: Response
// used for ConversationDatasets.ImportConversationData long running operation.
type GoogleCloudDialogflowV2ImportConversationDataOperationResponse struct {
	// ConversationDataset: The resource name of the imported conversation dataset.
	// Format: `projects//locations//conversationDatasets/`
	ConversationDataset string `json:"conversationDataset,omitempty"`
	// ImportCount: Number of conversations imported successfully.
	ImportCount int64 `json:"importCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationDataset") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportConversationDataOperationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportConversationDataOperationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ImportDocumentsResponse: Response message for
// Documents.ImportDocuments.
type GoogleCloudDialogflowV2ImportDocumentsResponse struct {
	// Warnings: Includes details about skipped documents or any other warnings.
	Warnings []*GoogleRpcStatus `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Warnings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Warnings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ImportDocumentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ImportDocumentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata: Metadata for
// initializing a location-level encryption specification.
type GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata struct {
	// Request: Output only. The original request for initialization.
	Request *GoogleCloudDialogflowV2InitializeEncryptionSpecRequest `json:"request,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Request") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Request") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2InitializeEncryptionSpecRequest: The request to
// initialize a location-level encryption specification.
type GoogleCloudDialogflowV2InitializeEncryptionSpecRequest struct {
	// EncryptionSpec: Required. The encryption spec used for CMEK encryption. It
	// is required that the kms key is in the same region as the endpoint. The same
	// key will be used for all provisioned resources, if encryption is available.
	// If the kms_key_name is left empty, no encryption will be enforced.
	EncryptionSpec *GoogleCloudDialogflowV2EncryptionSpec `json:"encryptionSpec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncryptionSpec") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncryptionSpec") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InitializeEncryptionSpecRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InitializeEncryptionSpecRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2InputDataset: InputDataset used to create model or do
// evaluation. NextID:5
type GoogleCloudDialogflowV2InputDataset struct {
	// Dataset: Required. ConversationDataset resource name. Format:
	// `projects//locations//conversationDatasets/`
	Dataset string `json:"dataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2InputDataset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2InputDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2Intent: An intent categorizes an end-user's intention
// for one conversation turn. For each agent, you define many intents, where
// your combined intents can handle a complete conversation. When an end-user
// writes or says something, referred to as an end-user expression or end-user
// input, Dialogflow matches the end-user input to the best intent in your
// agent. Matching an intent is also known as intent classification. For more
// information, see the intent guide
// (https://cloud.google.com/dialogflow/docs/intents-overview).
type GoogleCloudDialogflowV2Intent struct {
	// Action: Optional. The name of the action associated with the intent. Note:
	// The action name must not contain whitespaces.
	Action string `json:"action,omitempty"`
	// DefaultResponsePlatforms: Optional. The list of platforms for which the
	// first responses will be copied from the messages in PLATFORM_UNSPECIFIED
	// (i.e. default platform).
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Default platform.
	//   "FACEBOOK" - Facebook.
	//   "SLACK" - Slack.
	//   "TELEGRAM" - Telegram.
	//   "KIK" - Kik.
	//   "SKYPE" - Skype.
	//   "LINE" - Line.
	//   "VIBER" - Viber.
	//   "ACTIONS_ON_GOOGLE" - Google Assistant See [Dialogflow webhook
	// format](https://developers.google.com/assistant/actions/build/json/dialogflow
	// -webhook-json)
	//   "GOOGLE_HANGOUTS" - Google Hangouts.
	DefaultResponsePlatforms []string `json:"defaultResponsePlatforms,omitempty"`
	// DisplayName: Required. The name of this intent.
	DisplayName string `json:"displayName,omitempty"`
	// EndInteraction: Optional. Indicates that this intent ends an interaction.
	// Some integrations (e.g., Actions on Google or Dialogflow phone gateway) use
	// this information to close interaction with an end user. Default is false.
	EndInteraction bool `json:"endInteraction,omitempty"`
	// Events: Optional. The collection of event names that trigger the intent. If
	// the collection of input contexts is not empty, all of the contexts must be
	// present in the active user session for an event to trigger this intent.
	// Event names are limited to 150 characters.
	Events []string `json:"events,omitempty"`
	// FollowupIntentInfo: Output only. Read-only. Information about all followup
	// intents that have this intent as a direct or indirect parent. We populate
	// this field only in the output.
	FollowupIntentInfo []*GoogleCloudDialogflowV2IntentFollowupIntentInfo `json:"followupIntentInfo,omitempty"`
	// InputContextNames: Optional. The list of context names required for this
	// intent to be triggered. Format: `projects//agent/sessions/-/contexts/`.
	InputContextNames []string `json:"inputContextNames,omitempty"`
	// IsFallback: Optional. Indicates whether this is a fallback intent.
	IsFallback bool `json:"isFallback,omitempty"`
	// LiveAgentHandoff: Optional. Indicates that a live agent should be brought in
	// to handle the interaction with the user. In most cases, when you set this
	// flag to true, you would also want to set end_interaction to true as well.
	// Default is false.
	LiveAgentHandoff bool `json:"liveAgentHandoff,omitempty"`
	// Messages: Optional. The collection of rich messages corresponding to the
	// `Response` field in the Dialogflow console.
	Messages []*GoogleCloudDialogflowV2IntentMessage `json:"messages,omitempty"`
	// MlDisabled: Optional. Indicates whether Machine Learning is disabled for the
	// intent. Note: If `ml_disabled` setting is set to true, then this intent is
	// not taken into account during inference in `ML ONLY` match mode. Also,
	// auto-markup in the UI is turned off.
	MlDisabled bool `json:"mlDisabled,omitempty"`
	// Name: Optional. The unique identifier of this intent. Required for
	// Intents.UpdateIntent and Intents.BatchUpdateIntents methods. Format:
	// `projects//agent/intents/`.
	Name string `json:"name,omitempty"`
	// OutputContexts: Optional. The collection of contexts that are activated when
	// the intent is matched. Context messages in this collection should not set
	// the parameters field. Setting the `lifespan_count` to 0 will reset the
	// context when the intent is matched. Format:
	// `projects//agent/sessions/-/contexts/`.
	OutputContexts []*GoogleCloudDialogflowV2Context `json:"outputContexts,omitempty"`
	// Parameters: Optional. The collection of parameters associated with the
	// intent.
	Parameters []*GoogleCloudDialogflowV2IntentParameter `json:"parameters,omitempty"`
	// ParentFollowupIntentName: Read-only after creation. The unique identifier of
	// the parent intent in the chain of followup intents. You can set this field
	// when creating an intent, for example with CreateIntent or
	// BatchUpdateIntents, in order to make this intent a followup intent. It
	// identifies the parent followup intent. Format: `projects//agent/intents/`.
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`
	// Priority: Optional. The priority of this intent. Higher numbers represent
	// higher priorities. - If the supplied value is unspecified or 0, the service
	// translates the value to 500,000, which corresponds to the `Normal` priority
	// in the console. - If the supplied value is negative, the intent is ignored
	// in runtime detect intent requests.
	Priority int64 `json:"priority,omitempty"`
	// ResetContexts: Optional. Indicates whether to delete all contexts in the
	// current session when this intent is matched.
	ResetContexts bool `json:"resetContexts,omitempty"`
	// RootFollowupIntentName: Output only. Read-only. The unique identifier of the
	// root intent in the chain of followup intents. It identifies the correct
	// followup intents chain for this intent. We populate this field only in the
	// output. Format: `projects//agent/intents/`.
	RootFollowupIntentName string `json:"rootFollowupIntentName,omitempty"`
	// TrainingPhrases: Optional. The collection of examples that the agent is
	// trained on.
	TrainingPhrases []*GoogleCloudDialogflowV2IntentTrainingPhrase `json:"trainingPhrases,omitempty"`
	// WebhookState: Optional. Indicates whether webhooks are enabled for the
	// intent.
	//
	// Possible values:
	//   "WEBHOOK_STATE_UNSPECIFIED" - Webhook is disabled in the agent and in the
	// intent.
	//   "WEBHOOK_STATE_ENABLED" - Webhook is enabled in the agent and in the
	// intent.
	//   "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING" - Webhook is enabled in the agent
	// and in the intent. Also, each slot filling prompt is forwarded to the
	// webhook.
	WebhookState string `json:"webhookState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Intent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Intent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentFollowupIntentInfo: Represents a single
// followup intent in the chain.
type GoogleCloudDialogflowV2IntentFollowupIntentInfo struct {
	// FollowupIntentName: The unique identifier of the followup intent. Format:
	// `projects//agent/intents/`.
	FollowupIntentName string `json:"followupIntentName,omitempty"`
	// ParentFollowupIntentName: The unique identifier of the followup intent's
	// parent. Format: `projects//agent/intents/`.
	ParentFollowupIntentName string `json:"parentFollowupIntentName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FollowupIntentName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FollowupIntentName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentFollowupIntentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentFollowupIntentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessage: A rich response message. Corresponds
// to the intent `Response` field in the Dialogflow console. For more
// information, see Rich response messages
// (https://cloud.google.com/dialogflow/docs/intents-rich-messages).
type GoogleCloudDialogflowV2IntentMessage struct {
	// BasicCard: The basic card response for Actions on Google.
	BasicCard *GoogleCloudDialogflowV2IntentMessageBasicCard `json:"basicCard,omitempty"`
	// BrowseCarouselCard: Browse carousel card for Actions on Google.
	BrowseCarouselCard *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard `json:"browseCarouselCard,omitempty"`
	// Card: The card response.
	Card *GoogleCloudDialogflowV2IntentMessageCard `json:"card,omitempty"`
	// CarouselSelect: The carousel card response for Actions on Google.
	CarouselSelect *GoogleCloudDialogflowV2IntentMessageCarouselSelect `json:"carouselSelect,omitempty"`
	// Image: The image response.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// LinkOutSuggestion: The link out suggestion chip for Actions on Google.
	LinkOutSuggestion *GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion `json:"linkOutSuggestion,omitempty"`
	// ListSelect: The list card response for Actions on Google.
	ListSelect *GoogleCloudDialogflowV2IntentMessageListSelect `json:"listSelect,omitempty"`
	// MediaContent: The media content card for Actions on Google.
	MediaContent *GoogleCloudDialogflowV2IntentMessageMediaContent `json:"mediaContent,omitempty"`
	// Payload: A custom platform-specific response.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// Platform: Optional. The platform that this message is intended for.
	//
	// Possible values:
	//   "PLATFORM_UNSPECIFIED" - Default platform.
	//   "FACEBOOK" - Facebook.
	//   "SLACK" - Slack.
	//   "TELEGRAM" - Telegram.
	//   "KIK" - Kik.
	//   "SKYPE" - Skype.
	//   "LINE" - Line.
	//   "VIBER" - Viber.
	//   "ACTIONS_ON_GOOGLE" - Google Assistant See [Dialogflow webhook
	// format](https://developers.google.com/assistant/actions/build/json/dialogflow
	// -webhook-json)
	//   "GOOGLE_HANGOUTS" - Google Hangouts.
	Platform string `json:"platform,omitempty"`
	// QuickReplies: The quick replies response.
	QuickReplies *GoogleCloudDialogflowV2IntentMessageQuickReplies `json:"quickReplies,omitempty"`
	// SimpleResponses: The voice and text-only responses for Actions on Google.
	SimpleResponses *GoogleCloudDialogflowV2IntentMessageSimpleResponses `json:"simpleResponses,omitempty"`
	// Suggestions: The suggestion chips for Actions on Google.
	Suggestions *GoogleCloudDialogflowV2IntentMessageSuggestions `json:"suggestions,omitempty"`
	// TableCard: Table card for Actions on Google.
	TableCard *GoogleCloudDialogflowV2IntentMessageTableCard `json:"tableCard,omitempty"`
	// Text: The text response.
	Text *GoogleCloudDialogflowV2IntentMessageText `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BasicCard") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicCard") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBasicCard: The basic card message.
// Useful for displaying information.
type GoogleCloudDialogflowV2IntentMessageBasicCard struct {
	// Buttons: Optional. The collection of card buttons.
	Buttons []*GoogleCloudDialogflowV2IntentMessageBasicCardButton `json:"buttons,omitempty"`
	// FormattedText: Required, unless image is present. The body text of the card.
	FormattedText string `json:"formattedText,omitempty"`
	// Image: Optional. The image for the card.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// Subtitle: Optional. The subtitle of the card.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Optional. The title of the card.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBasicCardButton: The button object that
// appears at the bottom of a card.
type GoogleCloudDialogflowV2IntentMessageBasicCardButton struct {
	// OpenUriAction: Required. Action to take when a user taps on the button.
	OpenUriAction *GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction `json:"openUriAction,omitempty"`
	// Title: Required. The title of the button.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OpenUriAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OpenUriAction") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction: Opens the
// given URI.
type GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction struct {
	// Uri: Required. The HTTP or HTTPS scheme URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Uri") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Uri") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard: Browse Carousel Card
// for Actions on Google.
// https://developers.google.com/actions/assistant/responses#browsing_carousel
type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard struct {
	// ImageDisplayOptions: Optional. Settings for displaying the image. Applies to
	// every image in items.
	//
	// Possible values:
	//   "IMAGE_DISPLAY_OPTIONS_UNSPECIFIED" - Fill the gaps between the image and
	// the image container with gray bars.
	//   "GRAY" - Fill the gaps between the image and the image container with gray
	// bars.
	//   "WHITE" - Fill the gaps between the image and the image container with
	// white bars.
	//   "CROPPED" - Image is scaled such that the image width and height match or
	// exceed the container dimensions. This may crop the top and bottom of the
	// image if the scaled image height is greater than the container height, or
	// crop the left and right of the image if the scaled image width is greater
	// than the container width. This is similar to "Zoom Mode" on a widescreen TV
	// when playing a 4:3 video.
	//   "BLURRED_BACKGROUND" - Pad the gaps between image and image frame with a
	// blurred copy of the same image.
	ImageDisplayOptions string `json:"imageDisplayOptions,omitempty"`
	// Items: Required. List of items in the Browse Carousel Card. Minimum of two
	// items, maximum of ten.
	Items []*GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageDisplayOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageDisplayOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem:
//
//	Browsing carousel tile
type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem struct {
	// Description: Optional. Description of the carousel item. Maximum of four
	// lines of text.
	Description string `json:"description,omitempty"`
	// Footer: Optional. Text that appears at the bottom of the Browse Carousel
	// Card. Maximum of one line of text.
	Footer string `json:"footer,omitempty"`
	// Image: Optional. Hero image for the carousel item.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// OpenUriAction: Required. Action to present to the user.
	OpenUriAction *GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction `json:"openUriAction,omitempty"`
	// Title: Required. Title of the carousel item. Maximum of two lines of text.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemO
// penUrlAction: Actions on Google action to open a given url.
type GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction struct {
	// Url: Required. URL
	Url string `json:"url,omitempty"`
	// UrlTypeHint: Optional. Specifies the type of viewer that is used when
	// opening the URL. Defaults to opening via web browser.
	//
	// Possible values:
	//   "URL_TYPE_HINT_UNSPECIFIED" - Unspecified
	//   "AMP_ACTION" - Url would be an amp action
	//   "AMP_CONTENT" - URL that points directly to AMP content, or to a canonical
	// URL which refers to AMP content via .
	UrlTypeHint string `json:"urlTypeHint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Url") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Url") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCard: The card response message.
type GoogleCloudDialogflowV2IntentMessageCard struct {
	// Buttons: Optional. The collection of card buttons.
	Buttons []*GoogleCloudDialogflowV2IntentMessageCardButton `json:"buttons,omitempty"`
	// ImageUri: Optional. The public URI to an image file for the card.
	ImageUri string `json:"imageUri,omitempty"`
	// Subtitle: Optional. The subtitle of the card.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Optional. The title of the card.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCardButton: Contains information about a
// button.
type GoogleCloudDialogflowV2IntentMessageCardButton struct {
	// Postback: Optional. The text to send back to the Dialogflow API or a URI to
	// open.
	Postback string `json:"postback,omitempty"`
	// Text: Optional. The text to show on the button.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Postback") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Postback") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCardButton) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCardButton
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCarouselSelect: The card for presenting
// a carousel of options to select from.
type GoogleCloudDialogflowV2IntentMessageCarouselSelect struct {
	// Items: Required. Carousel items.
	Items []*GoogleCloudDialogflowV2IntentMessageCarouselSelectItem `json:"items,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCarouselSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCarouselSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageCarouselSelectItem: An item in the
// carousel.
type GoogleCloudDialogflowV2IntentMessageCarouselSelectItem struct {
	// Description: Optional. The body text of the card.
	Description string `json:"description,omitempty"`
	// Image: Optional. The image to display.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// Info: Required. Additional info about the option item.
	Info *GoogleCloudDialogflowV2IntentMessageSelectItemInfo `json:"info,omitempty"`
	// Title: Required. Title of the carousel item.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageCarouselSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageCarouselSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageColumnProperties: Column properties for
// TableCard.
type GoogleCloudDialogflowV2IntentMessageColumnProperties struct {
	// Header: Required. Column heading.
	Header string `json:"header,omitempty"`
	// HorizontalAlignment: Optional. Defines text alignment for all cells in this
	// column.
	//
	// Possible values:
	//   "HORIZONTAL_ALIGNMENT_UNSPECIFIED" - Text is aligned to the leading edge
	// of the column.
	//   "LEADING" - Text is aligned to the leading edge of the column.
	//   "CENTER" - Text is centered in the column.
	//   "TRAILING" - Text is aligned to the trailing edge of the column.
	HorizontalAlignment string `json:"horizontalAlignment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Header") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Header") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageColumnProperties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageColumnProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageImage: The image response message.
type GoogleCloudDialogflowV2IntentMessageImage struct {
	// AccessibilityText: Optional. A text description of the image to be used for
	// accessibility, e.g., screen readers.
	AccessibilityText string `json:"accessibilityText,omitempty"`
	// ImageUri: Optional. The public URI to an image file.
	ImageUri string `json:"imageUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessibilityText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessibilityText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion: The suggestion chip
// message that allows the user to jump out to the app or website associated
// with this agent.
type GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion struct {
	// DestinationName: Required. The name of the app or site this chip is linking
	// to.
	DestinationName string `json:"destinationName,omitempty"`
	// Uri: Required. The URI of the app or site to open when the user taps the
	// suggestion chip.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageListSelect: The card for presenting a
// list of options to select from.
type GoogleCloudDialogflowV2IntentMessageListSelect struct {
	// Items: Required. List items.
	Items []*GoogleCloudDialogflowV2IntentMessageListSelectItem `json:"items,omitempty"`
	// Subtitle: Optional. Subtitle of the list.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Optional. The overall title of the list.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageListSelect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageListSelect
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageListSelectItem: An item in the list.
type GoogleCloudDialogflowV2IntentMessageListSelectItem struct {
	// Description: Optional. The main text describing the item.
	Description string `json:"description,omitempty"`
	// Image: Optional. The image to display.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// Info: Required. Additional information about this option.
	Info *GoogleCloudDialogflowV2IntentMessageSelectItemInfo `json:"info,omitempty"`
	// Title: Required. The title of the list item.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageListSelectItem) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageListSelectItem
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageMediaContent: The media content card for
// Actions on Google.
type GoogleCloudDialogflowV2IntentMessageMediaContent struct {
	// MediaObjects: Required. List of media objects.
	MediaObjects []*GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject `json:"mediaObjects,omitempty"`
	// MediaType: Optional. What type of media is the content (ie "audio").
	//
	// Possible values:
	//   "RESPONSE_MEDIA_TYPE_UNSPECIFIED" - Unspecified.
	//   "AUDIO" - Response media type is audio.
	MediaType string `json:"mediaType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MediaObjects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MediaObjects") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageMediaContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageMediaContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject:
// Response media object for media content card.
type GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject struct {
	// ContentUrl: Required. Url where the media is stored.
	ContentUrl string `json:"contentUrl,omitempty"`
	// Description: Optional. Description of media card.
	Description string `json:"description,omitempty"`
	// Icon: Optional. Icon to display above media content.
	Icon *GoogleCloudDialogflowV2IntentMessageImage `json:"icon,omitempty"`
	// LargeImage: Optional. Image to display above media content.
	LargeImage *GoogleCloudDialogflowV2IntentMessageImage `json:"largeImage,omitempty"`
	// Name: Required. Name of media card.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentUrl") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentUrl") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageQuickReplies: The quick replies response
// message.
type GoogleCloudDialogflowV2IntentMessageQuickReplies struct {
	// QuickReplies: Optional. The collection of quick replies.
	QuickReplies []string `json:"quickReplies,omitempty"`
	// Title: Optional. The title of the collection of quick replies.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QuickReplies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QuickReplies") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageQuickReplies) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageQuickReplies
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSelectItemInfo: Additional info about
// the select item for when it is triggered in a dialog.
type GoogleCloudDialogflowV2IntentMessageSelectItemInfo struct {
	// Key: Required. A unique key that will be sent back to the agent if this
	// response is given.
	Key string `json:"key,omitempty"`
	// Synonyms: Optional. A list of synonyms that can also be used to trigger this
	// item in dialog.
	Synonyms []string `json:"synonyms,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSelectItemInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSelectItemInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSimpleResponse: The simple response
// message containing speech or text.
type GoogleCloudDialogflowV2IntentMessageSimpleResponse struct {
	// DisplayText: Optional. The text to display.
	DisplayText string `json:"displayText,omitempty"`
	// Ssml: One of text_to_speech or ssml must be provided. Structured spoken
	// response to the user in the SSML format. Mutually exclusive with
	// text_to_speech.
	Ssml string `json:"ssml,omitempty"`
	// TextToSpeech: One of text_to_speech or ssml must be provided. The plain text
	// of the speech output. Mutually exclusive with ssml.
	TextToSpeech string `json:"textToSpeech,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSimpleResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSimpleResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSimpleResponses: The collection of
// simple response candidates. This message in
// `QueryResult.fulfillment_messages` and
// `WebhookResponse.fulfillment_messages` should contain only one
// `SimpleResponse`.
type GoogleCloudDialogflowV2IntentMessageSimpleResponses struct {
	// SimpleResponses: Required. The list of simple responses.
	SimpleResponses []*GoogleCloudDialogflowV2IntentMessageSimpleResponse `json:"simpleResponses,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SimpleResponses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SimpleResponses") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSimpleResponses) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSimpleResponses
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSuggestion: The suggestion chip message
// that the user can tap to quickly post a reply to the conversation.
type GoogleCloudDialogflowV2IntentMessageSuggestion struct {
	// Title: Required. The text shown the in the suggestion chip.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Title") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Title") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageSuggestions: The collection of
// suggestions.
type GoogleCloudDialogflowV2IntentMessageSuggestions struct {
	// Suggestions: Required. The list of suggested replies.
	Suggestions []*GoogleCloudDialogflowV2IntentMessageSuggestion `json:"suggestions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageSuggestions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageSuggestions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageTableCard: Table card for Actions on
// Google.
type GoogleCloudDialogflowV2IntentMessageTableCard struct {
	// Buttons: Optional. List of buttons for the card.
	Buttons []*GoogleCloudDialogflowV2IntentMessageBasicCardButton `json:"buttons,omitempty"`
	// ColumnProperties: Optional. Display properties for the columns in this
	// table.
	ColumnProperties []*GoogleCloudDialogflowV2IntentMessageColumnProperties `json:"columnProperties,omitempty"`
	// Image: Optional. Image which should be displayed on the card.
	Image *GoogleCloudDialogflowV2IntentMessageImage `json:"image,omitempty"`
	// Rows: Optional. Rows in this table of data.
	Rows []*GoogleCloudDialogflowV2IntentMessageTableCardRow `json:"rows,omitempty"`
	// Subtitle: Optional. Subtitle to the title.
	Subtitle string `json:"subtitle,omitempty"`
	// Title: Required. Title of the card.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Buttons") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buttons") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCard) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCard
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageTableCardCell: Cell of TableCardRow.
type GoogleCloudDialogflowV2IntentMessageTableCardCell struct {
	// Text: Required. Text in this cell.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCardCell) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCardCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageTableCardRow: Row of TableCard.
type GoogleCloudDialogflowV2IntentMessageTableCardRow struct {
	// Cells: Optional. List of cells that make up this row.
	Cells []*GoogleCloudDialogflowV2IntentMessageTableCardCell `json:"cells,omitempty"`
	// DividerAfter: Optional. Whether to add a visual divider after this row.
	DividerAfter bool `json:"dividerAfter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cells") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cells") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageTableCardRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageTableCardRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentMessageText: The text response message.
type GoogleCloudDialogflowV2IntentMessageText struct {
	// Text: Optional. The collection of the agent's responses.
	Text []string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Text") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Text") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentMessageText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentMessageText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentParameter: Represents intent parameters.
type GoogleCloudDialogflowV2IntentParameter struct {
	// DefaultValue: Optional. The default value to use when the `value` yields an
	// empty result. Default values can be extracted from contexts by using the
	// following syntax: `#context_name.parameter_name`.
	DefaultValue string `json:"defaultValue,omitempty"`
	// DisplayName: Required. The name of the parameter.
	DisplayName string `json:"displayName,omitempty"`
	// EntityTypeDisplayName: Optional. The name of the entity type, prefixed with
	// `@`, that describes values of the parameter. If the parameter is required,
	// this must be provided.
	EntityTypeDisplayName string `json:"entityTypeDisplayName,omitempty"`
	// IsList: Optional. Indicates whether the parameter represents a list of
	// values.
	IsList bool `json:"isList,omitempty"`
	// Mandatory: Optional. Indicates whether the parameter is required. That is,
	// whether the intent cannot be completed without collecting the parameter
	// value.
	Mandatory bool `json:"mandatory,omitempty"`
	// Name: The unique identifier of this parameter.
	Name string `json:"name,omitempty"`
	// Prompts: Optional. The collection of prompts that the agent can present to
	// the user in order to collect a value for the parameter.
	Prompts []string `json:"prompts,omitempty"`
	// Value: Optional. The definition of the parameter value. It can be: - a
	// constant string, - a parameter value defined as `$parameter_name`, - an
	// original parameter value defined as `$parameter_name.original`, - a
	// parameter value from some context defined as `#context_name.parameter_name`.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentParameter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentTrainingPhrase: Represents an example that the
// agent is trained on.
type GoogleCloudDialogflowV2IntentTrainingPhrase struct {
	// Name: Output only. The unique identifier of this training phrase.
	Name string `json:"name,omitempty"`
	// Parts: Required. The ordered list of training phrase parts. The parts are
	// concatenated in order to form the training phrase. Note: The API does not
	// automatically annotate training phrases like the Dialogflow Console does.
	// Note: Do not forget to include whitespace at part boundaries, so the
	// training phrase is well formatted when the parts are concatenated. If the
	// training phrase does not need to be annotated with parameters, you just need
	// a single part with only the Part.text field set. If you want to annotate the
	// training phrase, you must create multiple parts, where the fields of each
	// part are populated in one of two ways: - `Part.text` is set to a part of the
	// phrase that has no parameters. - `Part.text` is set to a part of the phrase
	// that you want to annotate, and the `entity_type`, `alias`, and
	// `user_defined` fields are all set.
	Parts []*GoogleCloudDialogflowV2IntentTrainingPhrasePart `json:"parts,omitempty"`
	// TimesAddedCount: Optional. Indicates how many times this example was added
	// to the intent. Each time a developer adds an existing sample by editing an
	// intent or training, this counter is increased.
	TimesAddedCount int64 `json:"timesAddedCount,omitempty"`
	// Type: Required. The type of the training phrase.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Not specified. This value should never be used.
	//   "EXAMPLE" - Examples do not contain @-prefixed entity type names, but
	// example parts can be annotated with entity types.
	//   "TEMPLATE" - Templates are not annotated with entity types, but they can
	// contain @-prefixed entity type names as substrings. Template mode has been
	// deprecated. Example mode is the only supported way to create new training
	// phrases. If you have existing training phrases that you've created in
	// template mode, those will continue to work.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentTrainingPhrase) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentTrainingPhrase
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2IntentTrainingPhrasePart: Represents a part of a
// training phrase.
type GoogleCloudDialogflowV2IntentTrainingPhrasePart struct {
	// Alias: Optional. The parameter name for the value extracted from the
	// annotated part of the example. This field is required for annotated parts of
	// the training phrase.
	Alias string `json:"alias,omitempty"`
	// EntityType: Optional. The entity type name prefixed with `@`. This field is
	// required for annotated parts of the training phrase.
	EntityType string `json:"entityType,omitempty"`
	// Text: Required. The text for this part.
	Text string `json:"text,omitempty"`
	// UserDefined: Optional. Indicates whether the text was manually annotated.
	// This field is set to true when the Dialogflow Console is used to manually
	// annotate the part. When creating an annotated part with the API, you must
	// set this to true.
	UserDefined bool `json:"userDefined,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alias") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2IntentTrainingPhrasePart) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2IntentTrainingPhrasePart
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswer: Represents a Knowledge Assist
// answer.
type GoogleCloudDialogflowV2KnowledgeAssistAnswer struct {
	// AnswerRecord: The name of the answer record. Format:
	// `projects//locations//answer Records/`.
	AnswerRecord string `json:"answerRecord,omitempty"`
	// SuggestedQuery: The query suggested based on the context. Suggestion is made
	// only if it is different from the previous suggestion.
	SuggestedQuery *GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery `json:"suggestedQuery,omitempty"`
	// SuggestedQueryAnswer: The answer generated for the suggested query. Whether
	// or not an answer is generated depends on how confident we are about the
	// generated query.
	SuggestedQueryAnswer *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer `json:"suggestedQueryAnswer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer: Represents an
// answer from Knowledge. Currently supports FAQ and Generative answers.
type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer struct {
	// AnswerText: The piece of text from the `source` that answers this suggested
	// query.
	AnswerText string `json:"answerText,omitempty"`
	// FaqSource: Populated if the prediction came from FAQ.
	FaqSource *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource `json:"faqSource,omitempty"`
	// GenerativeSource: Populated if the prediction was Generative.
	GenerativeSource *GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource `json:"generativeSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource:
// Details about source of FAQ answer.
type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource struct {
	// Question: The corresponding FAQ question.
	Question string `json:"question,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Question") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Question") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource:
// Details about source of Generative answer.
type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource struct {
	// Snippets: All snippets used for this Generative Prediction, with their
	// source URI and data.
	Snippets []*GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet `json:"snippets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Snippets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Snippets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSn
// ippet: Snippet Source for a Generative Prediction.
type GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet struct {
	// Metadata: Metadata of the document.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Text: Text taken from that URI.
	Text string `json:"text,omitempty"`
	// Title: Title of the document.
	Title string `json:"title,omitempty"`
	// Uri: URI the data is sourced from.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery: Represents a
// suggested query.
type GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery struct {
	// QueryText: Suggested query text.
	QueryText string `json:"queryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2KnowledgeOperationMetadata: Metadata in
// google::longrunning::Operation for Knowledge operations.
type GoogleCloudDialogflowV2KnowledgeOperationMetadata struct {
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// ExportOperationMetadata: Metadata for the Export Data Operation such as the
	// destination of export.
	ExportOperationMetadata *GoogleCloudDialogflowV2ExportOperationMetadata `json:"exportOperationMetadata,omitempty"`
	// KnowledgeBase: The name of the knowledge base interacted with during the
	// operation.
	KnowledgeBase string `json:"knowledgeBase,omitempty"`
	// State: Output only. The current state of this operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is currently running.
	//   "DONE" - The operation is done, either cancelled or completed.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DoneTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DoneTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2KnowledgeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2KnowledgeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2Message: Represents a message posted into a
// conversation.
type GoogleCloudDialogflowV2Message struct {
	// Content: Required. The message content.
	Content string `json:"content,omitempty"`
	// CreateTime: Output only. The time when the message was created in Contact
	// Center AI.
	CreateTime string `json:"createTime,omitempty"`
	// LanguageCode: Optional. The message language. This should be a BCP-47
	// (https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example:
	// "en-US".
	LanguageCode string `json:"languageCode,omitempty"`
	// MessageAnnotation: Output only. The annotation for the message.
	MessageAnnotation *GoogleCloudDialogflowV2MessageAnnotation `json:"messageAnnotation,omitempty"`
	// Name: Optional. The unique identifier of the message. Format:
	// `projects//locations//conversations//messages/`.
	Name string `json:"name,omitempty"`
	// Participant: Output only. The participant that sends this message.
	Participant string `json:"participant,omitempty"`
	// ParticipantRole: Output only. The role of the participant.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant role not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent, such as a
	// Dialogflow agent.
	//   "END_USER" - Participant is an end user that has called or chatted with
	// Dialogflow services.
	ParticipantRole string `json:"participantRole,omitempty"`
	// SendTime: Optional. The time when the message was sent. For voice messages,
	// this is the time when an utterance started.
	SendTime string `json:"sendTime,omitempty"`
	// SentimentAnalysis: Output only. The sentiment analysis result for the
	// message.
	SentimentAnalysis *GoogleCloudDialogflowV2SentimentAnalysisResult `json:"sentimentAnalysis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Message) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2MessageAnnotation: Represents the result of
// annotation for the message.
type GoogleCloudDialogflowV2MessageAnnotation struct {
	// ContainEntities: Indicates whether the text message contains entities.
	ContainEntities bool `json:"containEntities,omitempty"`
	// Parts: The collection of annotated message parts ordered by their position
	// in the message. You can recover the annotated message by concatenating
	// [AnnotatedMessagePart.text].
	Parts []*GoogleCloudDialogflowV2AnnotatedMessagePart `json:"parts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainEntities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainEntities") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2MessageAnnotation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2MessageAnnotation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2OriginalDetectIntentRequest: Represents the contents
// of the original request that was passed to the `[Streaming]DetectIntent`
// call.
type GoogleCloudDialogflowV2OriginalDetectIntentRequest struct {
	// Payload: Optional. This field is set to the value of the
	// `QueryParameters.payload` field passed in the request. Some integrations
	// that query a Dialogflow agent may provide additional information in the
	// payload. In particular, for the Dialogflow Phone Gateway integration, this
	// field has the form: { "telephony": { "caller_id": "+18558363987" } } Note:
	// The caller ID field (`caller_id`) will be redacted for Trial Edition agents
	// and populated with the caller ID in E.164 format
	// (https://en.wikipedia.org/wiki/E.164) for Essentials Edition agents.
	Payload googleapi.RawMessage `json:"payload,omitempty"`
	// Source: The source of this request, e.g., `google`, `facebook`, `slack`. It
	// is set by Dialogflow-owned servers.
	Source string `json:"source,omitempty"`
	// Version: Optional. The version of the protocol used for this request. This
	// field is AoG-specific.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Payload") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Payload") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2OriginalDetectIntentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2OriginalDetectIntentRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2QueryResult: Represents the result of conversational
// query or event processing.
type GoogleCloudDialogflowV2QueryResult struct {
	// Action: The action name from the matched intent.
	Action string `json:"action,omitempty"`
	// AllRequiredParamsPresent: This field is set to: - `false` if the matched
	// intent has required parameters and not all of the required parameter values
	// have been collected. - `true` if all required parameter values have been
	// collected, or if the matched intent doesn't contain any required parameters.
	AllRequiredParamsPresent bool `json:"allRequiredParamsPresent,omitempty"`
	// CancelsSlotFilling: Indicates whether the conversational query triggers a
	// cancellation for slot filling. For more information, see the cancel slot
	// filling documentation
	// (https://cloud.google.com/dialogflow/es/docs/intents-actions-parameters#cancel).
	CancelsSlotFilling bool `json:"cancelsSlotFilling,omitempty"`
	// DiagnosticInfo: Free-form diagnostic information for the associated detect
	// intent request. The fields of this data can change without notice, so you
	// should not write code that depends on its structure. The data may contain: -
	// webhook call latency - webhook errors
	DiagnosticInfo googleapi.RawMessage `json:"diagnosticInfo,omitempty"`
	// FulfillmentMessages: The collection of rich messages to present to the user.
	FulfillmentMessages []*GoogleCloudDialogflowV2IntentMessage `json:"fulfillmentMessages,omitempty"`
	// FulfillmentText: The text to be pronounced to the user or shown on the
	// screen. Note: This is a legacy field, `fulfillment_messages` should be
	// preferred.
	FulfillmentText string `json:"fulfillmentText,omitempty"`
	// Intent: The intent that matched the conversational query. Some, not all
	// fields are filled in this message, including but not limited to: `name`,
	// `display_name`, `end_interaction` and `is_fallback`.
	Intent *GoogleCloudDialogflowV2Intent `json:"intent,omitempty"`
	// IntentDetectionConfidence: The intent detection confidence. Values range
	// from 0.0 (completely uncertain) to 1.0 (completely certain). This value is
	// for informational purpose only and is only used to help match the best
	// intent within the classification threshold. This value may change for the
	// same end-user expression at any time due to a model retraining or change in
	// implementation. If there are `multiple knowledge_answers` messages, this
	// value is set to the greatest `knowledgeAnswers.match_confidence` value in
	// the list.
	IntentDetectionConfidence float64 `json:"intentDetectionConfidence,omitempty"`
	// LanguageCode: The language that was triggered during intent detection. See
	// Language Support
	// (https://cloud.google.com/dialogflow/docs/reference/language) for a list of
	// the currently supported language codes.
	LanguageCode string `json:"languageCode,omitempty"`
	// OutputContexts: The collection of output contexts. If applicable,
	// `output_contexts.parameters` contains entries with name `.original`
	// containing the original parameter values before the query.
	OutputContexts []*GoogleCloudDialogflowV2Context `json:"outputContexts,omitempty"`
	// Parameters: The collection of extracted parameters. Depending on your
	// protocol or client library language, this is a map, associative array,
	// symbol table, dictionary, or JSON object composed of a collection of
	// (MapKey, MapValue) pairs: * MapKey type: string * MapKey value: parameter
	// name * MapValue type: If parameter's entity type is a composite entity then
	// use map, otherwise, depending on the parameter value type, it could be one
	// of string, number, boolean, null, list or map. * MapValue value: If
	// parameter's entity type is a composite entity then use map from composite
	// entity property names to property values, otherwise, use parameter value.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// QueryText: The original conversational query text: - If natural language
	// text was provided as input, `query_text` contains a copy of the input. - If
	// natural language speech audio was provided as input, `query_text` contains
	// the speech recognition result. If speech recognizer produced multiple
	// alternatives, a particular one is picked. - If automatic spell correction is
	// enabled, `query_text` will contain the corrected user input.
	QueryText string `json:"queryText,omitempty"`
	// SentimentAnalysisResult: The sentiment analysis result, which depends on the
	// `sentiment_analysis_request_config` specified in the request.
	SentimentAnalysisResult *GoogleCloudDialogflowV2SentimentAnalysisResult `json:"sentimentAnalysisResult,omitempty"`
	// SpeechRecognitionConfidence: The Speech recognition confidence between 0.0
	// and 1.0. A higher number indicates an estimated greater likelihood that the
	// recognized words are correct. The default of 0.0 is a sentinel value
	// indicating that confidence was not set. This field is not guaranteed to be
	// accurate or set. In particular this field isn't set for
	// StreamingDetectIntent since the streaming endpoint has separate confidence
	// estimates per portion of the audio in StreamingRecognitionResult.
	SpeechRecognitionConfidence float64 `json:"speechRecognitionConfidence,omitempty"`
	// WebhookPayload: If the query was fulfilled by a webhook call, this field is
	// set to the value of the `payload` field returned in the webhook response.
	WebhookPayload googleapi.RawMessage `json:"webhookPayload,omitempty"`
	// WebhookSource: If the query was fulfilled by a webhook call, this field is
	// set to the value of the `source` field returned in the webhook response.
	WebhookSource string `json:"webhookSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2QueryResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2QueryResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2QueryResult
	var s1 struct {
		IntentDetectionConfidence   gensupport.JSONFloat64 `json:"intentDetectionConfidence"`
		SpeechRecognitionConfidence gensupport.JSONFloat64 `json:"speechRecognitionConfidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.IntentDetectionConfidence = float64(s1.IntentDetectionConfidence)
	s.SpeechRecognitionConfidence = float64(s1.SpeechRecognitionConfidence)
	return nil
}

// GoogleCloudDialogflowV2Sentiment: The sentiment, such as positive/negative
// feeling or association, for a unit of analysis, such as the query text. See:
// https://cloud.google.com/natural-language/docs/basics#interpreting_sentiment_analysis_values
// for how to interpret the result.
type GoogleCloudDialogflowV2Sentiment struct {
	// Magnitude: A non-negative number in the [0, +inf) range, which represents
	// the absolute magnitude of sentiment, regardless of score (positive or
	// negative).
	Magnitude float64 `json:"magnitude,omitempty"`
	// Score: Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float64 `json:"score,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Magnitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Magnitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2Sentiment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2Sentiment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2Sentiment) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2Sentiment
	var s1 struct {
		Magnitude gensupport.JSONFloat64 `json:"magnitude"`
		Score     gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Magnitude = float64(s1.Magnitude)
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDialogflowV2SentimentAnalysisResult: The result of sentiment
// analysis. Sentiment analysis inspects user input and identifies the
// prevailing subjective opinion, especially to determine a user's attitude as
// positive, negative, or neutral. For DetectIntent, it needs to be configured
// in DetectIntentRequest.query_params. For StreamingDetectIntent, it needs to
// be configured in StreamingDetectIntentRequest.query_params. And for
// Participants.AnalyzeContent and Participants.StreamingAnalyzeContent, it
// needs to be configured in ConversationProfile.human_agent_assistant_config
type GoogleCloudDialogflowV2SentimentAnalysisResult struct {
	// QueryTextSentiment: The sentiment analysis result for `query_text`.
	QueryTextSentiment *GoogleCloudDialogflowV2Sentiment `json:"queryTextSentiment,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryTextSentiment") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryTextSentiment") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SentimentAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SentimentAnalysisResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SessionEntityType: A session represents a
// conversation between a Dialogflow agent and an end-user. You can create
// special entities, called session entities, during a session. Session
// entities can extend or replace custom entity types and only exist during the
// session that they were created for. All session data, including session
// entities, is stored by Dialogflow for 20 minutes. For more information, see
// the session entity guide
// (https://cloud.google.com/dialogflow/docs/entities-session).
type GoogleCloudDialogflowV2SessionEntityType struct {
	// Entities: Required. The collection of entities associated with this session
	// entity type.
	Entities []*GoogleCloudDialogflowV2EntityTypeEntity `json:"entities,omitempty"`
	// EntityOverrideMode: Required. Indicates whether the additional data should
	// override or supplement the custom entity type definition.
	//
	// Possible values:
	//   "ENTITY_OVERRIDE_MODE_UNSPECIFIED" - Not specified. This value should be
	// never used.
	//   "ENTITY_OVERRIDE_MODE_OVERRIDE" - The collection of session entities
	// overrides the collection of entities in the corresponding custom entity
	// type.
	//   "ENTITY_OVERRIDE_MODE_SUPPLEMENT" - The collection of session entities
	// extends the collection of entities in the corresponding custom entity type.
	// Note: Even in this override mode calls to `ListSessionEntityTypes`,
	// `GetSessionEntityType`, `CreateSessionEntityType` and
	// `UpdateSessionEntityType` only return the additional entities added in this
	// session entity type. If you want to get the supplemented list, please call
	// EntityTypes.GetEntityType on the custom entity type and merge.
	EntityOverrideMode string `json:"entityOverrideMode,omitempty"`
	// Name: Required. The unique identifier of this session entity type. Format:
	// `projects//agent/sessions//entityTypes/`, or
	// `projects//agent/environments//users//sessions//entityTypes/`. If
	// `Environment ID` is not specified, we assume default 'draft' environment. If
	// `User ID` is not specified, we assume default '-' user. `` must be the
	// display name of an existing entity type in the same agent that will be
	// overridden or supplemented.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SessionEntityType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SessionEntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata: Metadata
// for a ConversationProfiles.SetSuggestionFeatureConfig operation.
type GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata struct {
	// ConversationProfile: The resource name of the conversation profile. Format:
	// `projects//locations//conversationProfiles/`
	ConversationProfile string `json:"conversationProfile,omitempty"`
	// CreateTime: Timestamp whe the request was created. The time is measured on
	// server side.
	CreateTime string `json:"createTime,omitempty"`
	// ParticipantRole: Required. The participant role to add or update the
	// suggestion feature config. Only HUMAN_AGENT or END_USER can be used.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Participant role not set.
	//   "HUMAN_AGENT" - Participant is a human agent.
	//   "AUTOMATED_AGENT" - Participant is an automated agent, such as a
	// Dialogflow agent.
	//   "END_USER" - Participant is an end user that has called or chatted with
	// Dialogflow services.
	ParticipantRole string `json:"participantRole,omitempty"`
	// SuggestionFeatureType: Required. The type of the suggestion feature to add
	// or update.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified feature type.
	//   "ARTICLE_SUGGESTION" - Run article suggestion model for chat.
	//   "FAQ" - Run FAQ model for chat.
	//   "SMART_REPLY" - Run smart reply model for chat.
	//   "CONVERSATION_SUMMARIZATION" - Run conversation summarization model for
	// chat.
	//   "KNOWLEDGE_SEARCH" - Run knowledge search with text input from agent or
	// text generated query.
	//   "KNOWLEDGE_ASSIST" - Run knowledge assist with automatic query generation.
	SuggestionFeatureType string `json:"suggestionFeatureType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationProfile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConversationProfile") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SmartReplyAnswer: Represents a smart reply answer.
type GoogleCloudDialogflowV2SmartReplyAnswer struct {
	// AnswerRecord: The name of answer record, in the format of
	// "projects//locations//answerRecords/"
	AnswerRecord string `json:"answerRecord,omitempty"`
	// Confidence: Smart reply confidence. The system's confidence score that this
	// reply is a good match for this conversation, as a value from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float64 `json:"confidence,omitempty"`
	// Reply: The content of the reply.
	Reply string `json:"reply,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnswerRecord") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnswerRecord") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SmartReplyAnswer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SmartReplyAnswer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SmartReplyAnswer) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SmartReplyAnswer
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2SmartReplyModelMetadata: Metadata for smart reply
// models.
type GoogleCloudDialogflowV2SmartReplyModelMetadata struct {
	// TrainingModelType: Optional. Type of the smart reply model. If not provided,
	// model_type is used.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - ModelType unspecified.
	//   "SMART_REPLY_DUAL_ENCODER_MODEL" - ModelType smart reply dual encoder
	// model.
	//   "SMART_REPLY_BERT_MODEL" - ModelType smart reply bert model.
	TrainingModelType string `json:"trainingModelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrainingModelType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrainingModelType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SmartReplyModelMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SmartReplyModelMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SpeechWordInfo: Information for a word recognized by
// the speech recognizer.
type GoogleCloudDialogflowV2SpeechWordInfo struct {
	// Confidence: The Speech confidence between 0.0 and 1.0 for this word. A
	// higher number indicates an estimated greater likelihood that the recognized
	// word is correct. The default of 0.0 is a sentinel value indicating that
	// confidence was not set. This field is not guaranteed to be fully stable over
	// time for the same audio input. Users should also not rely on it to always be
	// provided.
	Confidence float64 `json:"confidence,omitempty"`
	// EndOffset: Time offset relative to the beginning of the audio that
	// corresponds to the end of the spoken word. This is an experimental feature
	// and the accuracy of the time offset can vary.
	EndOffset string `json:"endOffset,omitempty"`
	// StartOffset: Time offset relative to the beginning of the audio that
	// corresponds to the start of the spoken word. This is an experimental feature
	// and the accuracy of the time offset can vary.
	StartOffset string `json:"startOffset,omitempty"`
	// Word: The word this info is for.
	Word string `json:"word,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SpeechWordInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SpeechWordInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2SpeechWordInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2SpeechWordInfo
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2StreamingRecognitionResult: Contains a speech
// recognition result corresponding to a portion of the audio that is currently
// being processed or an indication that this is the end of the single
// requested utterance. While end-user audio is being processed, Dialogflow
// sends a series of results. Each result may contain a `transcript` value. A
// transcript represents a portion of the utterance. While the recognizer is
// processing audio, transcript values may be interim values or finalized
// values. Once a transcript is finalized, the `is_final` value is set to true
// and processing continues for the next transcript. If
// `StreamingDetectIntentRequest.query_input.audio_config.single_utterance` was
// true, and the recognizer has completed processing audio, the `message_type`
// value is set to `END_OF_SINGLE_UTTERANCE and the following (last) result
// contains the last finalized transcript. The complete end-user utterance is
// determined by concatenating the finalized transcript values received for the
// series of results. In the following example, single utterance is enabled. In
// the case where single utterance is not enabled, result 7 would not occur.
// ``` Num | transcript | message_type | is_final --- | -----------------------
// | ----------------------- | -------- 1 | "tube" | TRANSCRIPT | false 2 | "to
// be a" | TRANSCRIPT | false 3 | "to be" | TRANSCRIPT | false 4 | "to be or
// not to be" | TRANSCRIPT | true 5 | "that's" | TRANSCRIPT | false 6 | "that
// is | TRANSCRIPT | false 7 | unset | END_OF_SINGLE_UTTERANCE | unset 8 | "
// that is the question" | TRANSCRIPT | true ``` Concatenating the finalized
// transcripts with `is_final` set to true, the complete utterance becomes "to
// be or not to be that is the question".
type GoogleCloudDialogflowV2StreamingRecognitionResult struct {
	// Confidence: The Speech confidence between 0.0 and 1.0 for the current
	// portion of audio. A higher number indicates an estimated greater likelihood
	// that the recognized words are correct. The default of 0.0 is a sentinel
	// value indicating that confidence was not set. This field is typically only
	// provided if `is_final` is true and you should not rely on it being accurate
	// or even set.
	Confidence float64 `json:"confidence,omitempty"`
	// IsFinal: If `false`, the `StreamingRecognitionResult` represents an interim
	// result that may change. If `true`, the recognizer will not return any
	// further hypotheses about this piece of the audio. May only be populated for
	// `message_type` = `TRANSCRIPT`.
	IsFinal bool `json:"isFinal,omitempty"`
	// LanguageCode: Detected language code for the transcript.
	LanguageCode string `json:"languageCode,omitempty"`
	// MessageType: Type of the result message.
	//
	// Possible values:
	//   "MESSAGE_TYPE_UNSPECIFIED" - Not specified. Should never be used.
	//   "TRANSCRIPT" - Message contains a (possibly partial) transcript.
	//   "END_OF_SINGLE_UTTERANCE" - This event indicates that the server has
	// detected the end of the user's speech utterance and expects no additional
	// inputs. Therefore, the server will not process additional audio (although it
	// may subsequently return additional results). The client should stop sending
	// additional audio data, half-close the gRPC connection, and wait for any
	// additional results until the server closes the gRPC connection. This message
	// is only sent if `single_utterance` was set to `true`, and is not used
	// otherwise.
	MessageType string `json:"messageType,omitempty"`
	// SpeechEndOffset: Time offset of the end of this Speech recognition result
	// relative to the beginning of the audio. Only populated for `message_type` =
	// `TRANSCRIPT`.
	SpeechEndOffset string `json:"speechEndOffset,omitempty"`
	// SpeechWordInfo: Word-specific information for the words recognized by Speech
	// in transcript. Populated if and only if `message_type` = `TRANSCRIPT` and
	// [InputAudioConfig.enable_word_info] is set.
	SpeechWordInfo []*GoogleCloudDialogflowV2SpeechWordInfo `json:"speechWordInfo,omitempty"`
	// Transcript: Transcript text representing the words that the user spoke.
	// Populated if and only if `message_type` = `TRANSCRIPT`.
	Transcript string `json:"transcript,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Confidence") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Confidence") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2StreamingRecognitionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2StreamingRecognitionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDialogflowV2StreamingRecognitionResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDialogflowV2StreamingRecognitionResult
	var s1 struct {
		Confidence gensupport.JSONFloat64 `json:"confidence"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Confidence = float64(s1.Confidence)
	return nil
}

// GoogleCloudDialogflowV2SuggestArticlesResponse: The response message for
// Participants.SuggestArticles.
type GoogleCloudDialogflowV2SuggestArticlesResponse struct {
	// ArticleAnswers: Articles ordered by score in descending order.
	ArticleAnswers []*GoogleCloudDialogflowV2ArticleAnswer `json:"articleAnswers,omitempty"`
	// ContextSize: Number of messages prior to and including latest_message to
	// compile the suggestion. It may be smaller than the
	// SuggestArticlesRequest.context_size field in the request if there aren't
	// that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`
	// LatestMessage: The name of the latest conversation message used to compile
	// suggestion for. Format: `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArticleAnswers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArticleAnswers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestArticlesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestArticlesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SuggestFaqAnswersResponse: The request message for
// Participants.SuggestFaqAnswers.
type GoogleCloudDialogflowV2SuggestFaqAnswersResponse struct {
	// ContextSize: Number of messages prior to and including latest_message to
	// compile the suggestion. It may be smaller than the
	// SuggestFaqAnswersRequest.context_size field in the request if there aren't
	// that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`
	// FaqAnswers: Answers extracted from FAQ documents.
	FaqAnswers []*GoogleCloudDialogflowV2FaqAnswer `json:"faqAnswers,omitempty"`
	// LatestMessage: The name of the latest conversation message used to compile
	// suggestion for. Format: `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestFaqAnswersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestFaqAnswersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse: The response message
// for Participants.SuggestKnowledgeAssist.
type GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse struct {
	// ContextSize: Number of messages prior to and including latest_message to
	// compile the suggestion. It may be smaller than the
	// SuggestKnowledgeAssistRequest.context_size field in the request if there are
	// fewer messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`
	// KnowledgeAssistAnswer: Output only. Knowledge Assist suggestion.
	KnowledgeAssistAnswer *GoogleCloudDialogflowV2KnowledgeAssistAnswer `json:"knowledgeAssistAnswer,omitempty"`
	// LatestMessage: The name of the latest conversation message used to compile
	// suggestion for. Format: `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SuggestSmartRepliesResponse: The response message for
// Participants.SuggestSmartReplies.
type GoogleCloudDialogflowV2SuggestSmartRepliesResponse struct {
	// ContextSize: Number of messages prior to and including latest_message to
	// compile the suggestion. It may be smaller than the
	// SuggestSmartRepliesRequest.context_size field in the request if there aren't
	// that many messages in the conversation.
	ContextSize int64 `json:"contextSize,omitempty"`
	// LatestMessage: The name of the latest conversation message used to compile
	// suggestion for. Format: `projects//locations//conversations//messages/`.
	LatestMessage string `json:"latestMessage,omitempty"`
	// SmartReplyAnswers: Output only. Multiple reply options provided by smart
	// reply service. The order is based on the rank of the model prediction. The
	// maximum number of the returned replies is set in SmartReplyConfig.
	SmartReplyAnswers []*GoogleCloudDialogflowV2SmartReplyAnswer `json:"smartReplyAnswers,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContextSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestSmartRepliesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestSmartRepliesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SuggestionResult: One response of different type of
// suggestion response which is used in the response of
// Participants.AnalyzeContent and Participants.AnalyzeContent, as well as
// HumanAgentAssistantEvent.
type GoogleCloudDialogflowV2SuggestionResult struct {
	// Error: Error status if the request failed.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// GenerateSuggestionsResponse: Suggestions generated using generators
	// triggered by customer or agent messages.
	GenerateSuggestionsResponse *GoogleCloudDialogflowV2GenerateSuggestionsResponse `json:"generateSuggestionsResponse,omitempty"`
	// SuggestArticlesResponse: SuggestArticlesResponse if request is for
	// ARTICLE_SUGGESTION.
	SuggestArticlesResponse *GoogleCloudDialogflowV2SuggestArticlesResponse `json:"suggestArticlesResponse,omitempty"`
	// SuggestFaqAnswersResponse: SuggestFaqAnswersResponse if request is for
	// FAQ_ANSWER.
	SuggestFaqAnswersResponse *GoogleCloudDialogflowV2SuggestFaqAnswersResponse `json:"suggestFaqAnswersResponse,omitempty"`
	// SuggestKnowledgeAssistResponse: SuggestKnowledgeAssistResponse if request is
	// for KNOWLEDGE_ASSIST.
	SuggestKnowledgeAssistResponse *GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse `json:"suggestKnowledgeAssistResponse,omitempty"`
	// SuggestSmartRepliesResponse: SuggestSmartRepliesResponse if request is for
	// SMART_REPLY.
	SuggestSmartRepliesResponse *GoogleCloudDialogflowV2SuggestSmartRepliesResponse `json:"suggestSmartRepliesResponse,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SuggestionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SuggestionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SummarySuggestion: Suggested summary of the
// conversation.
type GoogleCloudDialogflowV2SummarySuggestion struct {
	// SummarySections: Required. All the parts of generated summary.
	SummarySections []*GoogleCloudDialogflowV2SummarySuggestionSummarySection `json:"summarySections,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SummarySections") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SummarySections") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarySuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarySuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2SummarySuggestionSummarySection: A component of the
// generated summary.
type GoogleCloudDialogflowV2SummarySuggestionSummarySection struct {
	// Section: Required. Name of the section.
	Section string `json:"section,omitempty"`
	// Summary: Required. Summary text for the section.
	Summary string `json:"summary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Section") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Section") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2SummarySuggestionSummarySection) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2SummarySuggestionSummarySection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ToolCall: Represents a call of a specific tool's
// action with the specified inputs.
type GoogleCloudDialogflowV2ToolCall struct {
	// Action: Optional. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// CreateTime: Output only. Create time of the tool call.
	CreateTime string `json:"createTime,omitempty"`
	// InputParameters: Optional. The action's input parameters.
	InputParameters googleapi.RawMessage `json:"inputParameters,omitempty"`
	// Tool: Optional. The tool associated with this call. Format:
	// `projects//locations//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCall) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCall
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ToolCallResult: The result of calling a tool's
// action.
type GoogleCloudDialogflowV2ToolCallResult struct {
	// Action: Optional. The name of the tool's action associated with this call.
	Action string `json:"action,omitempty"`
	// Content: Only populated if the response content is utf-8 encoded.
	Content string `json:"content,omitempty"`
	// CreateTime: Output only. Create time of the tool call result.
	CreateTime string `json:"createTime,omitempty"`
	// Error: The tool call's error.
	Error *GoogleCloudDialogflowV2ToolCallResultError `json:"error,omitempty"`
	// RawContent: Only populated if the response content is not utf-8 encoded. (by
	// definition byte fields are base64 encoded).
	RawContent string `json:"rawContent,omitempty"`
	// Tool: Optional. The tool associated with this call. Format:
	// `projects//locations//tools/`.
	Tool string `json:"tool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Action") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCallResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCallResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2ToolCallResultError: An error produced by the tool
// call.
type GoogleCloudDialogflowV2ToolCallResultError struct {
	// Message: Optional. The error message of the function.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDialogflowV2ToolCallResultError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDialogflowV2ToolCallResultError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata: Metadata
// for a ConversationModels.UndeployConversationModel operation.
type GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata struct {
	// ConversationModel: The resource name of the conversation model. Format:
	// `projects//conversationModels/`
	ConversationModel string `json:"conversationModel,omitempty"`
	// CreateTime: Timestamp when the request to undeploy conversation model was
	// submitted. The time is measured on server side.
	CreateTime string `json:"createTime,omitempty"`
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConversationModel") to
	/