// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlptrace "go.opentelemetry.io/proto/slim/otlp/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigScopeSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeSpans() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigScopeSpans()
				CopyOrigScopeSpans(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigScopeSpans(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigScopeSpansUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigScopeSpans()
	UnmarshalJSONOrigScopeSpans(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigScopeSpans(), dest)
}

func TestMarshalAndUnmarshalJSONOrigScopeSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeSpans() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigScopeSpans(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigScopeSpans()
				UnmarshalJSONOrigScopeSpans(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigScopeSpans(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigScopeSpansFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesScopeSpans() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigScopeSpans()
			require.Error(t, UnmarshalProtoOrigScopeSpans(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigScopeSpansUnknown(t *testing.T) {
	dest := NewOrigScopeSpans()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigScopeSpans(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigScopeSpans(), dest)
}

func TestMarshalAndUnmarshalProtoOrigScopeSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeSpans() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigScopeSpans(src))
				gotSize := MarshalProtoOrigScopeSpans(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigScopeSpans()
				require.NoError(t, UnmarshalProtoOrigScopeSpans(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigScopeSpans(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufScopeSpans(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeSpans() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigScopeSpans(src))
			gotSize := MarshalProtoOrigScopeSpans(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlptrace.ScopeSpans{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigScopeSpans()
			require.NoError(t, UnmarshalProtoOrigScopeSpans(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesScopeSpans() map[string][]byte {
	return map[string][]byte{
		"invalid_field":             {0x02},
		"Scope/wrong_wire_type":     {0xc},
		"Scope/missing_value":       {0xa},
		"Spans/wrong_wire_type":     {0x14},
		"Spans/missing_value":       {0x12},
		"SchemaUrl/wrong_wire_type": {0x1c},
		"SchemaUrl/missing_value":   {0x1a},
	}
}

func genTestEncodingValuesScopeSpans() map[string]*otlptrace.ScopeSpans {
	return map[string]*otlptrace.ScopeSpans{
		"empty":                  NewOrigScopeSpans(),
		"Scope/test":             {Scope: *GenTestOrigInstrumentationScope()},
		"Spans/default_and_test": {Spans: []*otlptrace.Span{{}, GenTestOrigSpan()}},
		"SchemaUrl/test":         {SchemaUrl: "test_schemaurl"},
	}
}
