// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigMappingSlice(t *testing.T) {
	src := []*otlpprofiles.Mapping{}
	dest := []*otlpprofiles.Mapping{}
	// Test CopyTo empty
	dest = CopyOrigMappingSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.Mapping{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestMappingSlice()
	dest = CopyOrigMappingSlice(dest, src)
	assert.Equal(t, GenerateOrigTestMappingSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigMappingSlice(dest, src)
	assert.Equal(t, GenerateOrigTestMappingSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigMappingSlice(dest, []*otlpprofiles.Mapping{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigMappingSlice(dest, src)
	assert.Equal(t, GenerateOrigTestMappingSlice(), dest)
}
