// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectormetrics "go.opentelemetry.io/proto/slim/otlp/collector/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcollectormetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportMetricsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigExportMetricsPartialSuccess()
				CopyOrigExportMetricsPartialSuccess(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigExportMetricsPartialSuccess(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsPartialSuccessUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigExportMetricsPartialSuccess()
	UnmarshalJSONOrigExportMetricsPartialSuccess(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigExportMetricsPartialSuccess(), dest)
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigExportMetricsPartialSuccess(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigExportMetricsPartialSuccess()
				UnmarshalJSONOrigExportMetricsPartialSuccess(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigExportMetricsPartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsPartialSuccessFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportMetricsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigExportMetricsPartialSuccess()
			require.Error(t, UnmarshalProtoOrigExportMetricsPartialSuccess(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsPartialSuccessUnknown(t *testing.T) {
	dest := NewOrigExportMetricsPartialSuccess()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigExportMetricsPartialSuccess(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigExportMetricsPartialSuccess(), dest)
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigExportMetricsPartialSuccess(src))
				gotSize := MarshalProtoOrigExportMetricsPartialSuccess(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigExportMetricsPartialSuccess()
				require.NoError(t, UnmarshalProtoOrigExportMetricsPartialSuccess(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigExportMetricsPartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportMetricsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportMetricsPartialSuccess(src))
			gotSize := MarshalProtoOrigExportMetricsPartialSuccess(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectormetrics.ExportMetricsPartialSuccess{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigExportMetricsPartialSuccess()
			require.NoError(t, UnmarshalProtoOrigExportMetricsPartialSuccess(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportMetricsPartialSuccess() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                      {0x02},
		"RejectedDataPoints/wrong_wire_type": {0xc},
		"RejectedDataPoints/missing_value":   {0x8},
		"ErrorMessage/wrong_wire_type":       {0x14},
		"ErrorMessage/missing_value":         {0x12},
	}
}

func genTestEncodingValuesExportMetricsPartialSuccess() map[string]*otlpcollectormetrics.ExportMetricsPartialSuccess {
	return map[string]*otlpcollectormetrics.ExportMetricsPartialSuccess{
		"empty":                   NewOrigExportMetricsPartialSuccess(),
		"RejectedDataPoints/test": {RejectedDataPoints: int64(13)},
		"ErrorMessage/test":       {ErrorMessage: "test_errormessage"},
	}
}
