// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyResourceMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceMetrics() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewResourceMetrics()
				CopyResourceMetrics(dest, src)
				assert.Equal(t, src, dest)
				CopyResourceMetrics(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyResourceMetricsSlice(t *testing.T) {
	src := []ResourceMetrics{}
	dest := []ResourceMetrics{}
	// Test CopyTo empty
	dest = CopyResourceMetricsSlice(dest, src)
	assert.Equal(t, []ResourceMetrics{}, dest)

	// Test CopyTo larger slice
	src = GenTestResourceMetricsSlice()
	dest = CopyResourceMetricsSlice(dest, src)
	assert.Equal(t, GenTestResourceMetricsSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyResourceMetricsSlice(dest, src)
	assert.Equal(t, GenTestResourceMetricsSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyResourceMetricsSlice(dest, []ResourceMetrics{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyResourceMetricsSlice(dest, src)
	assert.Equal(t, GenTestResourceMetricsSlice(), dest)
}

func TestCopyResourceMetricsPtrSlice(t *testing.T) {
	src := []*ResourceMetrics{}
	dest := []*ResourceMetrics{}
	// Test CopyTo empty
	dest = CopyResourceMetricsPtrSlice(dest, src)
	assert.Equal(t, []*ResourceMetrics{}, dest)

	// Test CopyTo larger slice
	src = GenTestResourceMetricsPtrSlice()
	dest = CopyResourceMetricsPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceMetricsPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyResourceMetricsPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceMetricsPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyResourceMetricsPtrSlice(dest, []*ResourceMetrics{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyResourceMetricsPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceMetricsPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONResourceMetricsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewResourceMetrics()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewResourceMetrics(), dest)
}

func TestMarshalAndUnmarshalJSONResourceMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceMetrics() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewResourceMetrics()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteResourceMetrics(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoResourceMetricsFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesResourceMetrics() {
		t.Run(name, func(t *testing.T) {
			dest := NewResourceMetrics()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoResourceMetricsUnknown(t *testing.T) {
	dest := NewResourceMetrics()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewResourceMetrics(), dest)
}

func TestMarshalAndUnmarshalProtoResourceMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceMetrics() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewResourceMetrics()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteResourceMetrics(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufResourceMetrics(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceMetrics() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.ResourceMetrics{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewResourceMetrics()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesResourceMetrics() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"Resource/wrong_wire_type":               {0xc},
		"Resource/missing_value":                 {0xa},
		"ScopeMetrics/wrong_wire_type":           {0x14},
		"ScopeMetrics/missing_value":             {0x12},
		"SchemaUrl/wrong_wire_type":              {0x1c},
		"SchemaUrl/missing_value":                {0x1a},
		"DeprecatedScopeMetrics/wrong_wire_type": {0xc4, 0x3e},
		"DeprecatedScopeMetrics/missing_value":   {0xc2, 0x3e},
	}
}

func genTestEncodingValuesResourceMetrics() map[string]*ResourceMetrics {
	return map[string]*ResourceMetrics{
		"empty":                       NewResourceMetrics(),
		"Resource/test":               {Resource: *GenTestResource()},
		"ScopeMetrics/test":           {ScopeMetrics: []*ScopeMetrics{{}, GenTestScopeMetrics()}},
		"SchemaUrl/test":              {SchemaUrl: "test_schemaurl"},
		"DeprecatedScopeMetrics/test": {DeprecatedScopeMetrics: []*ScopeMetrics{{}, GenTestScopeMetrics()}},
	}
}
