// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcommon "go.opentelemetry.io/proto/slim/otlp/common/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyEntityRef(t *testing.T) {
	for name, src := range genTestEncodingValuesEntityRef() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewEntityRef()
				CopyEntityRef(dest, src)
				assert.Equal(t, src, dest)
				CopyEntityRef(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyEntityRefSlice(t *testing.T) {
	src := []EntityRef{}
	dest := []EntityRef{}
	// Test CopyTo empty
	dest = CopyEntityRefSlice(dest, src)
	assert.Equal(t, []EntityRef{}, dest)

	// Test CopyTo larger slice
	src = GenTestEntityRefSlice()
	dest = CopyEntityRefSlice(dest, src)
	assert.Equal(t, GenTestEntityRefSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyEntityRefSlice(dest, src)
	assert.Equal(t, GenTestEntityRefSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyEntityRefSlice(dest, []EntityRef{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyEntityRefSlice(dest, src)
	assert.Equal(t, GenTestEntityRefSlice(), dest)
}

func TestCopyEntityRefPtrSlice(t *testing.T) {
	src := []*EntityRef{}
	dest := []*EntityRef{}
	// Test CopyTo empty
	dest = CopyEntityRefPtrSlice(dest, src)
	assert.Equal(t, []*EntityRef{}, dest)

	// Test CopyTo larger slice
	src = GenTestEntityRefPtrSlice()
	dest = CopyEntityRefPtrSlice(dest, src)
	assert.Equal(t, GenTestEntityRefPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyEntityRefPtrSlice(dest, src)
	assert.Equal(t, GenTestEntityRefPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyEntityRefPtrSlice(dest, []*EntityRef{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyEntityRefPtrSlice(dest, src)
	assert.Equal(t, GenTestEntityRefPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONEntityRefUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewEntityRef()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewEntityRef(), dest)
}

func TestMarshalAndUnmarshalJSONEntityRef(t *testing.T) {
	for name, src := range genTestEncodingValuesEntityRef() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewEntityRef()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteEntityRef(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoEntityRefFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesEntityRef() {
		t.Run(name, func(t *testing.T) {
			dest := NewEntityRef()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoEntityRefUnknown(t *testing.T) {
	dest := NewEntityRef()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewEntityRef(), dest)
}

func TestMarshalAndUnmarshalProtoEntityRef(t *testing.T) {
	for name, src := range genTestEncodingValuesEntityRef() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewEntityRef()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteEntityRef(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufEntityRef(t *testing.T) {
	for name, src := range genTestEncodingValuesEntityRef() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcommon.EntityRef{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewEntityRef()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesEntityRef() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                   {0x02},
		"SchemaUrl/wrong_wire_type":       {0xc},
		"SchemaUrl/missing_value":         {0xa},
		"Type/wrong_wire_type":            {0x14},
		"Type/missing_value":              {0x12},
		"IdKeys/wrong_wire_type":          {0x1c},
		"IdKeys/missing_value":            {0x1a},
		"DescriptionKeys/wrong_wire_type": {0x24},
		"DescriptionKeys/missing_value":   {0x22},
	}
}

func genTestEncodingValuesEntityRef() map[string]*EntityRef {
	return map[string]*EntityRef{
		"empty":                NewEntityRef(),
		"SchemaUrl/test":       {SchemaUrl: "test_schemaurl"},
		"Type/test":            {Type: "test_type"},
		"IdKeys/test":          {IdKeys: []string{"", "test_idkeys"}},
		"DescriptionKeys/test": {DescriptionKeys: []string{"", "test_descriptionkeys"}},
	}
}
