// AUTO GENERATED by tools/loadmeta.go
package services_test

import (
	. "github.com/onsi/ginkgo/v2"
	. "github.com/onsi/gomega"
	"github.com/softlayer/softlayer-go/services"
	"github.com/softlayer/softlayer-go/session/sessionfakes"
)

var _ = Describe("Billing Tests", func() {
	var slsession *sessionfakes.FakeSLSession
	BeforeEach(func() {
		slsession = &sessionfakes.FakeSLSession{}
	})

	Context("Testing SoftLayer_Billing_Currency service", func() {
		var sl_service services.Billing_Currency
		BeforeEach(func() {
			sl_service = services.GetBillingCurrencyService(slsession)
		})
		Context("SoftLayer_Billing_Currency Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Currency Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Currency::getAllObjects", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllObjects()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Currency::getCurrentExchangeRate", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCurrentExchangeRate()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Currency::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Currency::getPrice", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPrice(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Currency_Country service", func() {
		var sl_service services.Billing_Currency_Country
		BeforeEach(func() {
			sl_service = services.GetBillingCurrencyCountryService(slsession)
		})
		Context("SoftLayer_Billing_Currency_Country Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Currency_Country Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Currency_Country::getCountriesWithListOfEligibleCurrencies", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCountriesWithListOfEligibleCurrencies()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Currency_Country::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Currency_ExchangeRate service", func() {
		var sl_service services.Billing_Currency_ExchangeRate
		BeforeEach(func() {
			sl_service = services.GetBillingCurrencyExchangeRateService(slsession)
		})
		Context("SoftLayer_Billing_Currency_ExchangeRate Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Currency_ExchangeRate Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Currency_ExchangeRate::getAllCurrencyExchangeRates", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllCurrencyExchangeRates(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Currency_ExchangeRate::getCurrencies", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCurrencies()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Currency_ExchangeRate::getExchangeRate", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetExchangeRate(nil, nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Currency_ExchangeRate::getFundingCurrency", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetFundingCurrency()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Currency_ExchangeRate::getLocalCurrency", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLocalCurrency()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Currency_ExchangeRate::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Currency_ExchangeRate::getPrice", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPrice(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Info service", func() {
		var sl_service services.Billing_Info
		BeforeEach(func() {
			sl_service = services.GetBillingInfoService(slsession)
		})
		Context("SoftLayer_Billing_Info Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Info Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Info::getAccount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Info::getAchInformation", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAchInformation()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Info::getCurrency", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCurrency()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Info::getCurrentBillingCycle", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCurrentBillingCycle()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Info::getLastBillDate", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLastBillDate()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Info::getNextBillDate", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextBillDate()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Info::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Invoice service", func() {
		var sl_service services.Billing_Invoice
		BeforeEach(func() {
			sl_service = services.GetBillingInvoiceService(slsession)
		})
		Context("SoftLayer_Billing_Invoice Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Invoice Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Invoice::emailInvoices", func() {
			It("API Call Test", func() {
				err := sl_service.EmailInvoices(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getAccount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getBrandAtInvoiceCreation", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBrandAtInvoiceCreation()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getChargebackType", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetChargebackType()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getDetailedPdfGeneratedFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDetailedPdfGeneratedFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getExcel", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetExcel()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getInvoiceTopLevelItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoiceTopLevelItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getInvoiceTotalAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoiceTotalAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getInvoiceTotalOneTimeAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoiceTotalOneTimeAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getInvoiceTotalOneTimeTaxAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoiceTotalOneTimeTaxAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getInvoiceTotalPreTaxAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoiceTotalPreTaxAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getInvoiceTotalRecurringAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoiceTotalRecurringAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getInvoiceTotalRecurringTaxAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoiceTotalRecurringTaxAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getLocalCurrencyExchangeRate", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLocalCurrencyExchangeRate()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getPayment", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPayment()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getPayments", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPayments()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getPdf", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPdf()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getPdfDetailed", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPdfDetailed()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getPdfDetailedFilename", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPdfDetailedFilename()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getPdfFileSize", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPdfFileSize()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getPdfFilename", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPdfFilename()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getPreliminaryExcel", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPreliminaryExcel()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getPreliminaryPdf", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPreliminaryPdf()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getPreliminaryPdfDetailed", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPreliminaryPdfDetailed()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getSellerRegistration", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetSellerRegistration()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getTaxInfo", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTaxInfo()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getTaxInfoHistory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTaxInfoHistory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getTaxMessage", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTaxMessage()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getTaxType", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTaxType()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getXlsFilename", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetXlsFilename()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice::getZeroFeeItemCounts", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetZeroFeeItemCounts()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Invoice_Item service", func() {
		var sl_service services.Billing_Invoice_Item
		BeforeEach(func() {
			sl_service = services.GetBillingInvoiceItemService(slsession)
		})
		Context("SoftLayer_Billing_Invoice_Item Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getAssociatedChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAssociatedChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getAssociatedInvoiceItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAssociatedInvoiceItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getBillingItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBillingItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getCategory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCategory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getDPart", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDPart()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getDiscountingInvoiceItemId", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDiscountingInvoiceItemId()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getFilteredAssociatedChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetFilteredAssociatedChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getHourlyFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetHourlyFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getInvoice", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoice()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getLocation", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLocation()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getNonZeroAssociatedChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNonZeroAssociatedChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getParent", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetParent()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getProduct", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetProduct()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getTopLevelProductGroupName", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTopLevelProductGroupName()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getTotalOneTimeAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTotalOneTimeAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getTotalOneTimeTaxAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTotalOneTimeTaxAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getTotalRecurringAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTotalRecurringAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getTotalRecurringTaxAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTotalRecurringTaxAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Item::getUsageChargeFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUsageChargeFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Invoice_Next service", func() {
		var sl_service services.Billing_Invoice_Next
		BeforeEach(func() {
			sl_service = services.GetBillingInvoiceNextService(slsession)
		})
		Context("SoftLayer_Billing_Invoice_Next Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Invoice_Next Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Invoice_Next::getExcel", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetExcel(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Next::getPdf", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPdf(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Next::getPdfDetailed", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPdfDetailed(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Invoice_Tax_Status service", func() {
		var sl_service services.Billing_Invoice_Tax_Status
		BeforeEach(func() {
			sl_service = services.GetBillingInvoiceTaxStatusService(slsession)
		})
		Context("SoftLayer_Billing_Invoice_Tax_Status Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Invoice_Tax_Status Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Invoice_Tax_Status::getAllObjects", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllObjects()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Tax_Status::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Invoice_Tax_Type service", func() {
		var sl_service services.Billing_Invoice_Tax_Type
		BeforeEach(func() {
			sl_service = services.GetBillingInvoiceTaxTypeService(slsession)
		})
		Context("SoftLayer_Billing_Invoice_Tax_Type Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Invoice_Tax_Type Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Invoice_Tax_Type::getAllObjects", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllObjects()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Invoice_Tax_Type::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Item service", func() {
		var sl_service services.Billing_Item
		BeforeEach(func() {
			sl_service = services.GetBillingItemService(slsession)
		})
		Context("SoftLayer_Billing_Item Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Item Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Item::cancelItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.CancelItem(nil, nil, nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::cancelService", func() {
			It("API Call Test", func() {
				_, err := sl_service.CancelService()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::cancelServiceOnAnniversaryDate", func() {
			It("API Call Test", func() {
				_, err := sl_service.CancelServiceOnAnniversaryDate()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getAccount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getActiveAgreement", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveAgreement()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getActiveAgreementFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveAgreementFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getActiveAssociatedChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveAssociatedChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getActiveAssociatedGuestDiskBillingItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveAssociatedGuestDiskBillingItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getActiveBundledItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveBundledItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getActiveCancellationItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveCancellationItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getActiveChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getActiveFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getActiveSparePoolAssociatedGuestDiskBillingItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveSparePoolAssociatedGuestDiskBillingItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getActiveSparePoolBundledItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveSparePoolBundledItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getAssociatedBillingItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAssociatedBillingItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getAssociatedBillingItemHistory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAssociatedBillingItemHistory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getAssociatedChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAssociatedChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getAssociatedParent", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAssociatedParent()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getAvailableMatchingVlans", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAvailableMatchingVlans()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getBandwidthAllocation", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBandwidthAllocation()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getBillableChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBillableChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getBundledItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBundledItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getCanceledChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCanceledChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getCancellationReason", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCancellationReason()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getCancellationRequests", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCancellationRequests()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getCategory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCategory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getChildrenWithActiveAgreement", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetChildrenWithActiveAgreement()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getDowngradeItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDowngradeItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getFilteredNextInvoiceChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetFilteredNextInvoiceChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getHourlyFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetHourlyFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getInvoiceItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoiceItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getInvoiceItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoiceItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getLocation", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLocation()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getNextInvoiceChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextInvoiceChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getNextInvoiceTotalOneTimeAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextInvoiceTotalOneTimeAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getNextInvoiceTotalOneTimeTaxAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextInvoiceTotalOneTimeTaxAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getNextInvoiceTotalRecurringAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextInvoiceTotalRecurringAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getNextInvoiceTotalRecurringTaxAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextInvoiceTotalRecurringTaxAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getNonZeroNextInvoiceChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNonZeroNextInvoiceChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getOrderItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getOriginalLocation", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOriginalLocation()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getPackage", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackage()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getParent", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetParent()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getParentVirtualGuestBillingItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetParentVirtualGuestBillingItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getPendingCancellationFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPendingCancellationFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getPendingOrderItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPendingOrderItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getProvisionTransaction", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetProvisionTransaction()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getServiceBillingItemsByCategory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetServiceBillingItemsByCategory(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getSoftwareDescription", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetSoftwareDescription()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getUpgradeItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUpgradeItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::getUpgradeItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUpgradeItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::removeAssociationId", func() {
			It("API Call Test", func() {
				_, err := sl_service.RemoveAssociationId()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::setAssociationId", func() {
			It("API Call Test", func() {
				_, err := sl_service.SetAssociationId(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item::voidCancelService", func() {
			It("API Call Test", func() {
				_, err := sl_service.VoidCancelService()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Item_Cancellation_Reason service", func() {
		var sl_service services.Billing_Item_Cancellation_Reason
		BeforeEach(func() {
			sl_service = services.GetBillingItemCancellationReasonService(slsession)
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason::getAllCancellationReasons", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllCancellationReasons()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason::getBillingCancellationReasonCategory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBillingCancellationReasonCategory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason::getBillingItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBillingItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason::getTranslatedReason", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTranslatedReason()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Item_Cancellation_Reason_Category service", func() {
		var sl_service services.Billing_Item_Cancellation_Reason_Category
		BeforeEach(func() {
			sl_service = services.GetBillingItemCancellationReasonCategoryService(slsession)
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason_Category Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason_Category Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason_Category::getAllCancellationReasonCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllCancellationReasonCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason_Category::getBillingCancellationReasons", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBillingCancellationReasons()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Reason_Category::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Item_Cancellation_Request service", func() {
		var sl_service services.Billing_Item_Cancellation_Request
		BeforeEach(func() {
			sl_service = services.GetBillingItemCancellationRequestService(slsession)
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::createObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.CreateObject(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::getAccount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::getAllCancellationRequests", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllCancellationRequests()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::getCancellationCutoffDate", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCancellationCutoffDate(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::getItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::getStatus", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetStatus()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::getTicket", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTicket()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::getUser", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUser()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::removeCancellationItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.RemoveCancellationItem(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::validateBillingItemForCancellation", func() {
			It("API Call Test", func() {
				_, err := sl_service.ValidateBillingItemForCancellation(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Cancellation_Request::void", func() {
			It("API Call Test", func() {
				_, err := sl_service.Void(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Item_Chronicle service", func() {
		var sl_service services.Billing_Item_Chronicle
		BeforeEach(func() {
			sl_service = services.GetBillingItemChronicleService(slsession)
		})
		Context("SoftLayer_Billing_Item_Chronicle Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Item_Chronicle Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Item_Chronicle::getAssociatedChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAssociatedChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Chronicle::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Chronicle::getProduct", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetProduct()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Item_Virtual_DedicatedHost service", func() {
		var sl_service services.Billing_Item_Virtual_DedicatedHost
		BeforeEach(func() {
			sl_service = services.GetBillingItemVirtualDedicatedHostService(slsession)
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::cancelItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.CancelItem(nil, nil, nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::cancelService", func() {
			It("API Call Test", func() {
				_, err := sl_service.CancelService()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::cancelServiceOnAnniversaryDate", func() {
			It("API Call Test", func() {
				_, err := sl_service.CancelServiceOnAnniversaryDate()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getAccount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getActiveAgreement", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveAgreement()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getActiveAgreementFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveAgreementFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getActiveAssociatedChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveAssociatedChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getActiveAssociatedGuestDiskBillingItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveAssociatedGuestDiskBillingItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getActiveBundledItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveBundledItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getActiveCancellationItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveCancellationItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getActiveChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getActiveFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getActiveSparePoolAssociatedGuestDiskBillingItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveSparePoolAssociatedGuestDiskBillingItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getActiveSparePoolBundledItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveSparePoolBundledItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getAssociatedBillingItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAssociatedBillingItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getAssociatedBillingItemHistory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAssociatedBillingItemHistory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getAssociatedChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAssociatedChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getAssociatedParent", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAssociatedParent()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getAvailableMatchingVlans", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAvailableMatchingVlans()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getBandwidthAllocation", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBandwidthAllocation()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getBillableChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBillableChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getBundledItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBundledItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getCanceledChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCanceledChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getCancellationReason", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCancellationReason()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getCancellationRequests", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCancellationRequests()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getCategory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCategory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getChildrenWithActiveAgreement", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetChildrenWithActiveAgreement()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getDowngradeItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDowngradeItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getFilteredNextInvoiceChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetFilteredNextInvoiceChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getHourlyFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetHourlyFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getInvoiceItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoiceItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getInvoiceItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoiceItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getLocation", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLocation()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getNextInvoiceChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextInvoiceChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getNextInvoiceTotalOneTimeAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextInvoiceTotalOneTimeAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getNextInvoiceTotalOneTimeTaxAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextInvoiceTotalOneTimeTaxAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getNextInvoiceTotalRecurringAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextInvoiceTotalRecurringAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getNextInvoiceTotalRecurringTaxAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextInvoiceTotalRecurringTaxAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getNonZeroNextInvoiceChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNonZeroNextInvoiceChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getOrderItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getOriginalLocation", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOriginalLocation()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getPackage", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackage()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getParent", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetParent()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getParentVirtualGuestBillingItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetParentVirtualGuestBillingItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getPendingCancellationFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPendingCancellationFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getPendingOrderItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPendingOrderItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getProvisionTransaction", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetProvisionTransaction()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getResource", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetResource()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getServiceBillingItemsByCategory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetServiceBillingItemsByCategory(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getSoftwareDescription", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetSoftwareDescription()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getUpgradeItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUpgradeItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::getUpgradeItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUpgradeItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::removeAssociationId", func() {
			It("API Call Test", func() {
				_, err := sl_service.RemoveAssociationId()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::setAssociationId", func() {
			It("API Call Test", func() {
				_, err := sl_service.SetAssociationId(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Item_Virtual_DedicatedHost::voidCancelService", func() {
			It("API Call Test", func() {
				_, err := sl_service.VoidCancelService()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Order service", func() {
		var sl_service services.Billing_Order
		BeforeEach(func() {
			sl_service = services.GetBillingOrderService(slsession)
		})
		Context("SoftLayer_Billing_Order Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Order Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Order::approveModifiedOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.ApproveModifiedOrder()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getAccount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getAllObjects", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllObjects()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getBrand", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBrand()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getCart", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCart()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getCoreRestrictedItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCoreRestrictedItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getCreditCardTransactions", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCreditCardTransactions()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getExchangeRate", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetExchangeRate()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getInitialInvoice", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInitialInvoice()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderApprovalDate", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderApprovalDate()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderNonServerMonthlyAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderNonServerMonthlyAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderServerMonthlyAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderServerMonthlyAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderStatuses", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderStatuses()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderTopLevelItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderTopLevelItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderTotalAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderTotalAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderTotalOneTime", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderTotalOneTime()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderTotalOneTimeAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderTotalOneTimeAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderTotalOneTimeTaxAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderTotalOneTimeTaxAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderTotalRecurring", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderTotalRecurring()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderTotalRecurringAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderTotalRecurringAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderTotalRecurringTaxAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderTotalRecurringTaxAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderTotalSetupAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderTotalSetupAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getOrderType", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderType()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getPaypalTransactions", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPaypalTransactions()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getPdf", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPdf()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getPdfFilename", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPdfFilename()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getPresaleEvent", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPresaleEvent()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getQuote", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetQuote()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getRecalculatedOrderContainer", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetRecalculatedOrderContainer(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getReceipt", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetReceipt()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getReferralPartner", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetReferralPartner()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getUpgradeRequestFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUpgradeRequestFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::getUserRecord", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUserRecord()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order::isPendingEditApproval", func() {
			It("API Call Test", func() {
				_, err := sl_service.IsPendingEditApproval()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Order_Cart service", func() {
		var sl_service services.Billing_Order_Cart
		BeforeEach(func() {
			sl_service = services.GetBillingOrderCartService(slsession)
		})
		Context("SoftLayer_Billing_Order_Cart Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Order_Cart Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::claim", func() {
			It("API Call Test", func() {
				_, err := sl_service.Claim(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::createCart", func() {
			It("API Call Test", func() {
				_, err := sl_service.CreateCart(GetOrderContainer())
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::deleteCart", func() {
			It("API Call Test", func() {
				_, err := sl_service.DeleteCart()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::deleteQuote", func() {
			It("API Call Test", func() {
				_, err := sl_service.DeleteQuote()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::getAccount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::getCartByCartKey", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCartByCartKey(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::getDoNotContactFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDoNotContactFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::getOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrder()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::getOrdersFromQuote", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrdersFromQuote()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::getPdf", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPdf()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::getQuoteByQuoteKey", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetQuoteByQuoteKey(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::getRecalculatedOrderContainer", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetRecalculatedOrderContainer(GetOrderContainer(), nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::placeOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.PlaceOrder(GetOrderContainer())
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::placeQuote", func() {
			It("API Call Test", func() {
				_, err := sl_service.PlaceQuote(GetOrderContainer())
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::saveQuote", func() {
			It("API Call Test", func() {
				_, err := sl_service.SaveQuote()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::updateCart", func() {
			It("API Call Test", func() {
				_, err := sl_service.UpdateCart(GetOrderContainer())
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::verifyOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.VerifyOrder(GetOrderContainer())
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Cart::withdrawGdprAcceptance", func() {
			It("API Call Test", func() {
				err := sl_service.WithdrawGdprAcceptance()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Order_Item service", func() {
		var sl_service services.Billing_Order_Item
		BeforeEach(func() {
			sl_service = services.GetBillingOrderItemService(slsession)
		})
		Context("SoftLayer_Billing_Order_Item Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Order_Item Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getBillingItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBillingItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getBundledItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBundledItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getCategory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCategory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getGlobalIdentifier", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetGlobalIdentifier()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getHardwareGenericComponent", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetHardwareGenericComponent()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getItemCategoryAnswers", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemCategoryAnswers()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getItemPrice", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemPrice()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getLocation", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLocation()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getNextOrderChildren", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNextOrderChildren()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getOldBillingItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOldBillingItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrder()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getOrderApprovalDate", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderApprovalDate()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getPackage", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackage()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getParent", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetParent()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getPreset", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPreset()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getPromoCode", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPromoCode()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getRedundantPowerSupplyCount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetRedundantPowerSupplyCount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getSoftwareDescription", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetSoftwareDescription()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getStorageGroups", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetStorageGroups()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getTotalRecurringAmount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTotalRecurringAmount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Item::getUpgradeItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUpgradeItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Billing_Order_Quote service", func() {
		var sl_service services.Billing_Order_Quote
		BeforeEach(func() {
			sl_service = services.GetBillingOrderQuoteService(slsession)
		})
		Context("SoftLayer_Billing_Order_Quote Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Billing_Order_Quote Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::claim", func() {
			It("API Call Test", func() {
				_, err := sl_service.Claim(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::deleteQuote", func() {
			It("API Call Test", func() {
				_, err := sl_service.DeleteQuote()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::getAccount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::getDoNotContactFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDoNotContactFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::getOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrder()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::getOrdersFromQuote", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrdersFromQuote()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::getPdf", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPdf()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::getQuoteByQuoteKey", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetQuoteByQuoteKey(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::getRecalculatedOrderContainer", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetRecalculatedOrderContainer(GetOrderContainer(), nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::placeOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.PlaceOrder(GetOrderContainer())
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::placeQuote", func() {
			It("API Call Test", func() {
				_, err := sl_service.PlaceQuote(GetOrderContainer())
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::saveQuote", func() {
			It("API Call Test", func() {
				_, err := sl_service.SaveQuote()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::verifyOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.VerifyOrder(GetOrderContainer())
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Billing_Order_Quote::withdrawGdprAcceptance", func() {
			It("API Call Test", func() {
				err := sl_service.WithdrawGdprAcceptance()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

})
