package main

import (
	"os"
	"strings"

	"github.com/mjwhitta/errors"
)

func generateFuncs(t string) string {
	var ret string
	var T string = strings.ToUpper(t[0:1]) + t[1:]
	var tn string = T + "List"

	// Type declaration
	ret += "\n// " + tn + " allows setting a value multiple times, as"
	ret += " in:\n// --flag=" + t + "1 --flag=" + t + "2\n"
	ret += "type " + tn + " []" + t
	switch t {
	case "float", "int", "uint":
		ret += "64"
	}
	ret += "\n\n"

	// String() func
	ret += "// String will return a string representation of "
	ret += "the " + tn + ".\n"
	ret += "func (list *" + tn + ") String() string {\n"
	ret += "\tif len(*list) == 0 {\n"
	ret += "\t\treturn \"[]\"\n"
	ret += "\t}\n\n"
	ret += "\treturn fmt.Sprint(*list)\n"
	ret += "}\n\n"

	// Set() func
	ret += "// Set will append a " + t + " to a " + tn + ".\n"
	ret += "func (list *" + tn + ") Set(val string) error {\n"
	switch t {
	case "float":
		ret += "\tvar e error\n"
		ret += "\tvar v " + t + "64\n\n"
		ret += "\tif v, e = strconv.Parse" + T + "(val, 64)"
		ret += "; e != nil {\n"
		ret += "\t\treturn errors.Newf(\"failed to parse %s as "
		ret += t + ": %w\", val, e)\n"
		ret += "\t}\n\n"
		ret += "\t(*list) = append(*list, v)\n"
	case "int", "uint":
		ret += "\tvar e error\n"
		ret += "\tvar v " + t + "64\n\n"
		ret += "\tif v, e = strconv.Parse" + T + "(val, 0,"
		ret += " 64); e != nil {\n"
		ret += "\t\treturn errors.Newf(\"failed to parse %s as "
		ret += t + ": %w\", val, e)\n"
		ret += "\t}\n\n"
		ret += "\t(*list) = append(*list, v)\n"
	case "string":
		ret += "\t(*list) = append(*list, val)\n"
	}
	ret += "\treturn nil\n"
	ret += "}\n"

	return ret
}

func header() string {
	return "" +
		"// Code generated by gentypes; DO NOT EDIT.\n" +
		"package cli\n\n" +
		"import (\n" +
		"\t\"fmt\"\n" +
		"\t\"strconv\"\n\n" +
		"\t\"github.com/mjwhitta/errors\"\n" +
		")\n"
}

func main() {
	defer func() {
		if r := recover(); r != nil {
			panic(r.(error).Error())
		}
	}()

	var e error
	var f *os.File
	var fn string = "generated.go"
	var types []string = []string{"float", "int", "string", "uint"}

	if f, e = os.Create(fn); e != nil {
		panic(errors.Newf("failed to create %s: %w", fn, e))
	}
	defer f.Close()

	_, _ = f.WriteString(header())

	for _, thetype := range types {
		_, _ = f.WriteString(generateFuncs(thetype))
	}
}
