package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// VulnerabilitySummary 漏洞信息摘要
type VulnerabilitySummary struct {

	// 发现的漏洞总数
	Total *int32 `json:"total,omitempty"`

	// 可修复漏洞的数量
	Fixable *int32 `json:"fixable,omitempty"`

	// 不同级别的漏洞数量
	Summary map[string]int32 `json:"summary,omitempty"`
}

func (o VulnerabilitySummary) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilitySummary struct{}"
	}

	return strings.Join([]string{"VulnerabilitySummary", string(data)}, " ")
}
