package v5

import (
	httpclient "github.com/huaweicloud/huaweicloud-sdk-go-v3/core"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/invoker"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/services/hss/v5/model"
)

type HssClient struct {
	HcClient *httpclient.HcHttpClient
}

func NewHssClient(hcClient *httpclient.HcHttpClient) *HssClient {
	return &HssClient{HcClient: hcClient}
}

func HssClientBuilder() *httpclient.HcHttpClientBuilder {
	builder := httpclient.NewHcHttpClientBuilder()
	return builder
}

// AddCceIntegrationProtection 新建cce集成防护配置
//
// 新建cce集成防护配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddCceIntegrationProtection(request *model.AddCceIntegrationProtectionRequest) (*model.AddCceIntegrationProtectionResponse, error) {
	requestDef := GenReqDefForAddCceIntegrationProtection()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddCceIntegrationProtectionResponse), nil
	}
}

// AddCceIntegrationProtectionInvoker 新建cce集成防护配置
func (c *HssClient) AddCceIntegrationProtectionInvoker(request *model.AddCceIntegrationProtectionRequest) *AddCceIntegrationProtectionInvoker {
	requestDef := GenReqDefForAddCceIntegrationProtection()
	return &AddCceIntegrationProtectionInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddLoginWhiteList 添加登录白名单
//
// 添加登录白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddLoginWhiteList(request *model.AddLoginWhiteListRequest) (*model.AddLoginWhiteListResponse, error) {
	requestDef := GenReqDefForAddLoginWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddLoginWhiteListResponse), nil
	}
}

// AddLoginWhiteListInvoker 添加登录白名单
func (c *HssClient) AddLoginWhiteListInvoker(request *model.AddLoginWhiteListRequest) *AddLoginWhiteListInvoker {
	requestDef := GenReqDefForAddLoginWhiteList()
	return &AddLoginWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddPolicy 添加防护策略
//
// 添加防护策略：创建防护策略，包含策略名称、相关规则开启状态、防护动作以及检测规则配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddPolicy(request *model.AddPolicyRequest) (*model.AddPolicyResponse, error) {
	requestDef := GenReqDefForAddPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddPolicyResponse), nil
	}
}

// AddPolicyInvoker 添加防护策略
func (c *HssClient) AddPolicyInvoker(request *model.AddPolicyRequest) *AddPolicyInvoker {
	requestDef := GenReqDefForAddPolicy()
	return &AddPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddSystemUserWhiteList 添加系统用户白名单
//
// 添加系统用户白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddSystemUserWhiteList(request *model.AddSystemUserWhiteListRequest) (*model.AddSystemUserWhiteListResponse, error) {
	requestDef := GenReqDefForAddSystemUserWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddSystemUserWhiteListResponse), nil
	}
}

// AddSystemUserWhiteListInvoker 添加系统用户白名单
func (c *HssClient) AddSystemUserWhiteListInvoker(request *model.AddSystemUserWhiteListRequest) *AddSystemUserWhiteListInvoker {
	requestDef := GenReqDefForAddSystemUserWhiteList()
	return &AddSystemUserWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchAddAccounts 批量添加账号
//
// 批量添加账号
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchAddAccounts(request *model.BatchAddAccountsRequest) (*model.BatchAddAccountsResponse, error) {
	requestDef := GenReqDefForBatchAddAccounts()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchAddAccountsResponse), nil
	}
}

// BatchAddAccountsInvoker 批量添加账号
func (c *HssClient) BatchAddAccountsInvoker(request *model.BatchAddAccountsRequest) *BatchAddAccountsInvoker {
	requestDef := GenReqDefForBatchAddAccounts()
	return &BatchAddAccountsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchChangeEvent 全量处理告警事件
//
// 全量处理告警事件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchChangeEvent(request *model.BatchChangeEventRequest) (*model.BatchChangeEventResponse, error) {
	requestDef := GenReqDefForBatchChangeEvent()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchChangeEventResponse), nil
	}
}

// BatchChangeEventInvoker 全量处理告警事件
func (c *HssClient) BatchChangeEventInvoker(request *model.BatchChangeEventRequest) *BatchChangeEventInvoker {
	requestDef := GenReqDefForBatchChangeEvent()
	return &BatchChangeEventInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchCreateTags 批量创建标签
//
// 批量创建标签
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchCreateTags(request *model.BatchCreateTagsRequest) (*model.BatchCreateTagsResponse, error) {
	requestDef := GenReqDefForBatchCreateTags()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchCreateTagsResponse), nil
	}
}

// BatchCreateTagsInvoker 批量创建标签
func (c *HssClient) BatchCreateTagsInvoker(request *model.BatchCreateTagsRequest) *BatchCreateTagsInvoker {
	requestDef := GenReqDefForBatchCreateTags()
	return &BatchCreateTagsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchDeleteTags 批量删除标签
//
// 批量删除标签
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchDeleteTags(request *model.BatchDeleteTagsRequest) (*model.BatchDeleteTagsResponse, error) {
	requestDef := GenReqDefForBatchDeleteTags()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchDeleteTagsResponse), nil
	}
}

// BatchDeleteTagsInvoker 批量删除标签
func (c *HssClient) BatchDeleteTagsInvoker(request *model.BatchDeleteTagsRequest) *BatchDeleteTagsInvoker {
	requestDef := GenReqDefForBatchDeleteTags()
	return &BatchDeleteTagsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchModifyPortStatus 修改开放端口状态
//
// 修改开放端口状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchModifyPortStatus(request *model.BatchModifyPortStatusRequest) (*model.BatchModifyPortStatusResponse, error) {
	requestDef := GenReqDefForBatchModifyPortStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchModifyPortStatusResponse), nil
	}
}

// BatchModifyPortStatusInvoker 修改开放端口状态
func (c *HssClient) BatchModifyPortStatusInvoker(request *model.BatchModifyPortStatusRequest) *BatchModifyPortStatusInvoker {
	requestDef := GenReqDefForBatchModifyPortStatus()
	return &BatchModifyPortStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeBlockedIp 解除已拦截IP
//
// 解除已拦截IP
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeBlockedIp(request *model.ChangeBlockedIpRequest) (*model.ChangeBlockedIpResponse, error) {
	requestDef := GenReqDefForChangeBlockedIp()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeBlockedIpResponse), nil
	}
}

// ChangeBlockedIpInvoker 解除已拦截IP
func (c *HssClient) ChangeBlockedIpInvoker(request *model.ChangeBlockedIpRequest) *ChangeBlockedIpInvoker {
	requestDef := GenReqDefForChangeBlockedIp()
	return &ChangeBlockedIpInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeClusterEvents 修改告警状态
//
// 修改告警状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeClusterEvents(request *model.ChangeClusterEventsRequest) (*model.ChangeClusterEventsResponse, error) {
	requestDef := GenReqDefForChangeClusterEvents()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeClusterEventsResponse), nil
	}
}

// ChangeClusterEventsInvoker 修改告警状态
func (c *HssClient) ChangeClusterEventsInvoker(request *model.ChangeClusterEventsRequest) *ChangeClusterEventsInvoker {
	requestDef := GenReqDefForChangeClusterEvents()
	return &ChangeClusterEventsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeClusterProtectionPolicy 修改集群防护策略
//
// 修改集群防护策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeClusterProtectionPolicy(request *model.ChangeClusterProtectionPolicyRequest) (*model.ChangeClusterProtectionPolicyResponse, error) {
	requestDef := GenReqDefForChangeClusterProtectionPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeClusterProtectionPolicyResponse), nil
	}
}

// ChangeClusterProtectionPolicyInvoker 修改集群防护策略
func (c *HssClient) ChangeClusterProtectionPolicyInvoker(request *model.ChangeClusterProtectionPolicyRequest) *ChangeClusterProtectionPolicyInvoker {
	requestDef := GenReqDefForChangeClusterProtectionPolicy()
	return &ChangeClusterProtectionPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeContainerStatus 管理容器生命周期
//
// 管理容器生命周期
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeContainerStatus(request *model.ChangeContainerStatusRequest) (*model.ChangeContainerStatusResponse, error) {
	requestDef := GenReqDefForChangeContainerStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeContainerStatusResponse), nil
	}
}

// ChangeContainerStatusInvoker 管理容器生命周期
func (c *HssClient) ChangeContainerStatusInvoker(request *model.ChangeContainerStatusRequest) *ChangeContainerStatusInvoker {
	requestDef := GenReqDefForChangeContainerStatus()
	return &ChangeContainerStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeEvent 处理告警事件
//
// 处理告警事件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeEvent(request *model.ChangeEventRequest) (*model.ChangeEventResponse, error) {
	requestDef := GenReqDefForChangeEvent()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeEventResponse), nil
	}
}

// ChangeEventInvoker 处理告警事件
func (c *HssClient) ChangeEventInvoker(request *model.ChangeEventRequest) *ChangeEventInvoker {
	requestDef := GenReqDefForChangeEvent()
	return &ChangeEventInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeIsolatedFile 恢复已隔离文件
//
// 恢复已隔离文件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeIsolatedFile(request *model.ChangeIsolatedFileRequest) (*model.ChangeIsolatedFileResponse, error) {
	requestDef := GenReqDefForChangeIsolatedFile()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeIsolatedFileResponse), nil
	}
}

// ChangeIsolatedFileInvoker 恢复已隔离文件
func (c *HssClient) ChangeIsolatedFileInvoker(request *model.ChangeIsolatedFileRequest) *ChangeIsolatedFileInvoker {
	requestDef := GenReqDefForChangeIsolatedFile()
	return &ChangeIsolatedFileInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeMalwareCollectStatus 开启或关闭恶意软件云查样本收集配置
//
// 开启或关闭恶意软件云查样本收集配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeMalwareCollectStatus(request *model.ChangeMalwareCollectStatusRequest) (*model.ChangeMalwareCollectStatusResponse, error) {
	requestDef := GenReqDefForChangeMalwareCollectStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeMalwareCollectStatusResponse), nil
	}
}

// ChangeMalwareCollectStatusInvoker 开启或关闭恶意软件云查样本收集配置
func (c *HssClient) ChangeMalwareCollectStatusInvoker(request *model.ChangeMalwareCollectStatusRequest) *ChangeMalwareCollectStatusInvoker {
	requestDef := GenReqDefForChangeMalwareCollectStatus()
	return &ChangeMalwareCollectStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateClusterProtectionPolicy 新建集群防护策略
//
// 新建集群防护策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateClusterProtectionPolicy(request *model.CreateClusterProtectionPolicyRequest) (*model.CreateClusterProtectionPolicyResponse, error) {
	requestDef := GenReqDefForCreateClusterProtectionPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateClusterProtectionPolicyResponse), nil
	}
}

// CreateClusterProtectionPolicyInvoker 新建集群防护策略
func (c *HssClient) CreateClusterProtectionPolicyInvoker(request *model.CreateClusterProtectionPolicyRequest) *CreateClusterProtectionPolicyInvoker {
	requestDef := GenReqDefForCreateClusterProtectionPolicy()
	return &CreateClusterProtectionPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateClustersInfo 同步集群信息
//
// 同步集群信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateClustersInfo(request *model.CreateClustersInfoRequest) (*model.CreateClustersInfoResponse, error) {
	requestDef := GenReqDefForCreateClustersInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateClustersInfoResponse), nil
	}
}

// CreateClustersInfoInvoker 同步集群信息
func (c *HssClient) CreateClustersInfoInvoker(request *model.CreateClustersInfoRequest) *CreateClustersInfoInvoker {
	requestDef := GenReqDefForCreateClustersInfo()
	return &CreateClustersInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateContainerNetworkPolicy 容器集群网络添加配置策略
//
// 容器集群网络添加配置策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateContainerNetworkPolicy(request *model.CreateContainerNetworkPolicyRequest) (*model.CreateContainerNetworkPolicyResponse, error) {
	requestDef := GenReqDefForCreateContainerNetworkPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateContainerNetworkPolicyResponse), nil
	}
}

// CreateContainerNetworkPolicyInvoker 容器集群网络添加配置策略
func (c *HssClient) CreateContainerNetworkPolicyInvoker(request *model.CreateContainerNetworkPolicyRequest) *CreateContainerNetworkPolicyInvoker {
	requestDef := GenReqDefForCreateContainerNetworkPolicy()
	return &CreateContainerNetworkPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateDecoyPortPolicy 新增动态端口蜜罐策略
//
// 新增动态端口蜜罐策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateDecoyPortPolicy(request *model.CreateDecoyPortPolicyRequest) (*model.CreateDecoyPortPolicyResponse, error) {
	requestDef := GenReqDefForCreateDecoyPortPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateDecoyPortPolicyResponse), nil
	}
}

// CreateDecoyPortPolicyInvoker 新增动态端口蜜罐策略
func (c *HssClient) CreateDecoyPortPolicyInvoker(request *model.CreateDecoyPortPolicyRequest) *CreateDecoyPortPolicyInvoker {
	requestDef := GenReqDefForCreateDecoyPortPolicy()
	return &CreateDecoyPortPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateGlobalAssetScanTask 创建全局资产扫描任务
//
// 创建全局资产扫描任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateGlobalAssetScanTask(request *model.CreateGlobalAssetScanTaskRequest) (*model.CreateGlobalAssetScanTaskResponse, error) {
	requestDef := GenReqDefForCreateGlobalAssetScanTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateGlobalAssetScanTaskResponse), nil
	}
}

// CreateGlobalAssetScanTaskInvoker 创建全局资产扫描任务
func (c *HssClient) CreateGlobalAssetScanTaskInvoker(request *model.CreateGlobalAssetScanTaskRequest) *CreateGlobalAssetScanTaskInvoker {
	requestDef := GenReqDefForCreateGlobalAssetScanTask()
	return &CreateGlobalAssetScanTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateSecurityGroupPolicy 创建安全组策略
//
// 创建安全组策略(云原生网络模型)
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateSecurityGroupPolicy(request *model.CreateSecurityGroupPolicyRequest) (*model.CreateSecurityGroupPolicyResponse, error) {
	requestDef := GenReqDefForCreateSecurityGroupPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateSecurityGroupPolicyResponse), nil
	}
}

// CreateSecurityGroupPolicyInvoker 创建安全组策略
func (c *HssClient) CreateSecurityGroupPolicyInvoker(request *model.CreateSecurityGroupPolicyRequest) *CreateSecurityGroupPolicyInvoker {
	requestDef := GenReqDefForCreateSecurityGroupPolicy()
	return &CreateSecurityGroupPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteAccount 删除账号
//
// 删除账号
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteAccount(request *model.DeleteAccountRequest) (*model.DeleteAccountResponse, error) {
	requestDef := GenReqDefForDeleteAccount()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteAccountResponse), nil
	}
}

// DeleteAccountInvoker 删除账号
func (c *HssClient) DeleteAccountInvoker(request *model.DeleteAccountRequest) *DeleteAccountInvoker {
	requestDef := GenReqDefForDeleteAccount()
	return &DeleteAccountInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteClusterProtectionPolicy 删除集群防护策略
//
// 删除集群防护策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteClusterProtectionPolicy(request *model.DeleteClusterProtectionPolicyRequest) (*model.DeleteClusterProtectionPolicyResponse, error) {
	requestDef := GenReqDefForDeleteClusterProtectionPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteClusterProtectionPolicyResponse), nil
	}
}

// DeleteClusterProtectionPolicyInvoker 删除集群防护策略
func (c *HssClient) DeleteClusterProtectionPolicyInvoker(request *model.DeleteClusterProtectionPolicyRequest) *DeleteClusterProtectionPolicyInvoker {
	requestDef := GenReqDefForDeleteClusterProtectionPolicy()
	return &DeleteClusterProtectionPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteContainerNetworkPolicy 容器集群网络删除配置策略
//
// 容器集群网络删除配置策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteContainerNetworkPolicy(request *model.DeleteContainerNetworkPolicyRequest) (*model.DeleteContainerNetworkPolicyResponse, error) {
	requestDef := GenReqDefForDeleteContainerNetworkPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteContainerNetworkPolicyResponse), nil
	}
}

// DeleteContainerNetworkPolicyInvoker 容器集群网络删除配置策略
func (c *HssClient) DeleteContainerNetworkPolicyInvoker(request *model.DeleteContainerNetworkPolicyRequest) *DeleteContainerNetworkPolicyInvoker {
	requestDef := GenReqDefForDeleteContainerNetworkPolicy()
	return &DeleteContainerNetworkPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteDecoyPortHostPolicy 关闭主机动态端口蜜罐策略
//
// 关闭主机动态端口蜜罐策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteDecoyPortHostPolicy(request *model.DeleteDecoyPortHostPolicyRequest) (*model.DeleteDecoyPortHostPolicyResponse, error) {
	requestDef := GenReqDefForDeleteDecoyPortHostPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteDecoyPortHostPolicyResponse), nil
	}
}

// DeleteDecoyPortHostPolicyInvoker 关闭主机动态端口蜜罐策略
func (c *HssClient) DeleteDecoyPortHostPolicyInvoker(request *model.DeleteDecoyPortHostPolicyRequest) *DeleteDecoyPortHostPolicyInvoker {
	requestDef := GenReqDefForDeleteDecoyPortHostPolicy()
	return &DeleteDecoyPortHostPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteDecoyPortPolicy 删除动态端口蜜罐策略
//
// 删除动态端口蜜罐策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteDecoyPortPolicy(request *model.DeleteDecoyPortPolicyRequest) (*model.DeleteDecoyPortPolicyResponse, error) {
	requestDef := GenReqDefForDeleteDecoyPortPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteDecoyPortPolicyResponse), nil
	}
}

// DeleteDecoyPortPolicyInvoker 删除动态端口蜜罐策略
func (c *HssClient) DeleteDecoyPortPolicyInvoker(request *model.DeleteDecoyPortPolicyRequest) *DeleteDecoyPortPolicyInvoker {
	requestDef := GenReqDefForDeleteDecoyPortPolicy()
	return &DeleteDecoyPortPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteIsolatedFile 删除已隔离文件
//
// 删除已隔离文件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteIsolatedFile(request *model.DeleteIsolatedFileRequest) (*model.DeleteIsolatedFileResponse, error) {
	requestDef := GenReqDefForDeleteIsolatedFile()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteIsolatedFileResponse), nil
	}
}

// DeleteIsolatedFileInvoker 删除已隔离文件
func (c *HssClient) DeleteIsolatedFileInvoker(request *model.DeleteIsolatedFileRequest) *DeleteIsolatedFileInvoker {
	requestDef := GenReqDefForDeleteIsolatedFile()
	return &DeleteIsolatedFileInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeletePolicy 删除防护策略
//
// 删除防护策略：删除策略，已经在使用的防护策略不能删除
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeletePolicy(request *model.DeletePolicyRequest) (*model.DeletePolicyResponse, error) {
	requestDef := GenReqDefForDeletePolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeletePolicyResponse), nil
	}
}

// DeletePolicyInvoker 删除防护策略
func (c *HssClient) DeletePolicyInvoker(request *model.DeletePolicyRequest) *DeletePolicyInvoker {
	requestDef := GenReqDefForDeletePolicy()
	return &DeletePolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteResourceInstanceTag 删除资源标签
//
// 删除单个资源下的标签
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteResourceInstanceTag(request *model.DeleteResourceInstanceTagRequest) (*model.DeleteResourceInstanceTagResponse, error) {
	requestDef := GenReqDefForDeleteResourceInstanceTag()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteResourceInstanceTagResponse), nil
	}
}

// DeleteResourceInstanceTagInvoker 删除资源标签
func (c *HssClient) DeleteResourceInstanceTagInvoker(request *model.DeleteResourceInstanceTagRequest) *DeleteResourceInstanceTagInvoker {
	requestDef := GenReqDefForDeleteResourceInstanceTag()
	return &DeleteResourceInstanceTagInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteSecurityGroupPolicy 删除安全组策略
//
// 删除安全组策略(云原生网络模型)
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteSecurityGroupPolicy(request *model.DeleteSecurityGroupPolicyRequest) (*model.DeleteSecurityGroupPolicyResponse, error) {
	requestDef := GenReqDefForDeleteSecurityGroupPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteSecurityGroupPolicyResponse), nil
	}
}

// DeleteSecurityGroupPolicyInvoker 删除安全组策略
func (c *HssClient) DeleteSecurityGroupPolicyInvoker(request *model.DeleteSecurityGroupPolicyRequest) *DeleteSecurityGroupPolicyInvoker {
	requestDef := GenReqDefForDeleteSecurityGroupPolicy()
	return &DeleteSecurityGroupPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DownloadAssetFile 导出资产指纹信息
//
// 导出资产指纹信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DownloadAssetFile(request *model.DownloadAssetFileRequest) (*model.DownloadAssetFileResponse, error) {
	requestDef := GenReqDefForDownloadAssetFile()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DownloadAssetFileResponse), nil
	}
}

// DownloadAssetFileInvoker 导出资产指纹信息
func (c *HssClient) DownloadAssetFileInvoker(request *model.DownloadAssetFileRequest) *DownloadAssetFileInvoker {
	requestDef := GenReqDefForDownloadAssetFile()
	return &DownloadAssetFileInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DownloadEventSourceFile 下载告警源文件
//
// 下载告警源文件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DownloadEventSourceFile(request *model.DownloadEventSourceFileRequest) (*model.DownloadEventSourceFileResponse, error) {
	requestDef := GenReqDefForDownloadEventSourceFile()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DownloadEventSourceFileResponse), nil
	}
}

// DownloadEventSourceFileInvoker 下载告警源文件
func (c *HssClient) DownloadEventSourceFileInvoker(request *model.DownloadEventSourceFileRequest) *DownloadEventSourceFileInvoker {
	requestDef := GenReqDefForDownloadEventSourceFile()
	return &DownloadEventSourceFileInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// EnableTrustService 开启可信服务
//
// 开启可信服务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) EnableTrustService(request *model.EnableTrustServiceRequest) (*model.EnableTrustServiceResponse, error) {
	requestDef := GenReqDefForEnableTrustService()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.EnableTrustServiceResponse), nil
	}
}

// EnableTrustServiceInvoker 开启可信服务
func (c *HssClient) EnableTrustServiceInvoker(request *model.EnableTrustServiceRequest) *EnableTrustServiceInvoker {
	requestDef := GenReqDefForEnableTrustService()
	return &EnableTrustServiceInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportContainerList 创建容器导出任务
//
// 创建容器导出任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportContainerList(request *model.ExportContainerListRequest) (*model.ExportContainerListResponse, error) {
	requestDef := GenReqDefForExportContainerList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportContainerListResponse), nil
	}
}

// ExportContainerListInvoker 创建容器导出任务
func (c *HssClient) ExportContainerListInvoker(request *model.ExportContainerListRequest) *ExportContainerListInvoker {
	requestDef := GenReqDefForExportContainerList()
	return &ExportContainerListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportEventRequest 导出漏洞请求
//
// 导出入侵事件请求
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportEventRequest(request *model.ExportEventRequestRequest) (*model.ExportEventRequestResponse, error) {
	requestDef := GenReqDefForExportEventRequest()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportEventRequestResponse), nil
	}
}

// ExportEventRequestInvoker 导出漏洞请求
func (c *HssClient) ExportEventRequestInvoker(request *model.ExportEventRequestRequest) *ExportEventRequestInvoker {
	requestDef := GenReqDefForExportEventRequest()
	return &ExportEventRequestInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAccounts 查询多账号列表
//
// 查询多账号列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAccounts(request *model.ListAccountsRequest) (*model.ListAccountsResponse, error) {
	requestDef := GenReqDefForListAccounts()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAccountsResponse), nil
	}
}

// ListAccountsInvoker 查询多账号列表
func (c *HssClient) ListAccountsInvoker(request *model.ListAccountsRequest) *ListAccountsInvoker {
	requestDef := GenReqDefForListAccounts()
	return &ListAccountsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAgentInstallScript 查询agent安装脚本
//
// 查询agent安装脚本
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAgentInstallScript(request *model.ListAgentInstallScriptRequest) (*model.ListAgentInstallScriptResponse, error) {
	requestDef := GenReqDefForListAgentInstallScript()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAgentInstallScriptResponse), nil
	}
}

// ListAgentInstallScriptInvoker 查询agent安装脚本
func (c *HssClient) ListAgentInstallScriptInvoker(request *model.ListAgentInstallScriptRequest) *ListAgentInstallScriptInvoker {
	requestDef := GenReqDefForListAgentInstallScript()
	return &ListAgentInstallScriptInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAlarmWhiteList 查询告警白名单列表
//
// 查询告警白名单列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAlarmWhiteList(request *model.ListAlarmWhiteListRequest) (*model.ListAlarmWhiteListResponse, error) {
	requestDef := GenReqDefForListAlarmWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAlarmWhiteListResponse), nil
	}
}

// ListAlarmWhiteListInvoker 查询告警白名单列表
func (c *HssClient) ListAlarmWhiteListInvoker(request *model.ListAlarmWhiteListRequest) *ListAlarmWhiteListInvoker {
	requestDef := GenReqDefForListAlarmWhiteList()
	return &ListAlarmWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAppChangeHistories 获取软件信息的历史变动记录
//
// 获取软件信息的历史变动记录
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAppChangeHistories(request *model.ListAppChangeHistoriesRequest) (*model.ListAppChangeHistoriesResponse, error) {
	requestDef := GenReqDefForListAppChangeHistories()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAppChangeHistoriesResponse), nil
	}
}

// ListAppChangeHistoriesInvoker 获取软件信息的历史变动记录
func (c *HssClient) ListAppChangeHistoriesInvoker(request *model.ListAppChangeHistoriesRequest) *ListAppChangeHistoriesInvoker {
	requestDef := GenReqDefForListAppChangeHistories()
	return &ListAppChangeHistoriesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAppStatistics 查询软件列表
//
// 查询软件列表，支持通过软件名称查询对应的服务器数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAppStatistics(request *model.ListAppStatisticsRequest) (*model.ListAppStatisticsResponse, error) {
	requestDef := GenReqDefForListAppStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAppStatisticsResponse), nil
	}
}

// ListAppStatisticsInvoker 查询软件列表
func (c *HssClient) ListAppStatisticsInvoker(request *model.ListAppStatisticsRequest) *ListAppStatisticsInvoker {
	requestDef := GenReqDefForListAppStatistics()
	return &ListAppStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListApps 查询软件的服务器列表
//
// 查询软件的服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListApps(request *model.ListAppsRequest) (*model.ListAppsResponse, error) {
	requestDef := GenReqDefForListApps()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAppsResponse), nil
	}
}

// ListAppsInvoker 查询软件的服务器列表
func (c *HssClient) ListAppsInvoker(request *model.ListAppsRequest) *ListAppsInvoker {
	requestDef := GenReqDefForListApps()
	return &ListAppsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAutoLaunchChangeHistories 获取自启动项的历史变动记录
//
// 获取自启动项的历史变动记录
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAutoLaunchChangeHistories(request *model.ListAutoLaunchChangeHistoriesRequest) (*model.ListAutoLaunchChangeHistoriesResponse, error) {
	requestDef := GenReqDefForListAutoLaunchChangeHistories()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAutoLaunchChangeHistoriesResponse), nil
	}
}

// ListAutoLaunchChangeHistoriesInvoker 获取自启动项的历史变动记录
func (c *HssClient) ListAutoLaunchChangeHistoriesInvoker(request *model.ListAutoLaunchChangeHistoriesRequest) *ListAutoLaunchChangeHistoriesInvoker {
	requestDef := GenReqDefForListAutoLaunchChangeHistories()
	return &ListAutoLaunchChangeHistoriesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAutoLaunchStatistics 查询自启动项信息
//
// 查询自启动信息，支持通过传入自启动名称查询启动类型和服务器数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAutoLaunchStatistics(request *model.ListAutoLaunchStatisticsRequest) (*model.ListAutoLaunchStatisticsResponse, error) {
	requestDef := GenReqDefForListAutoLaunchStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAutoLaunchStatisticsResponse), nil
	}
}

// ListAutoLaunchStatisticsInvoker 查询自启动项信息
func (c *HssClient) ListAutoLaunchStatisticsInvoker(request *model.ListAutoLaunchStatisticsRequest) *ListAutoLaunchStatisticsInvoker {
	requestDef := GenReqDefForListAutoLaunchStatistics()
	return &ListAutoLaunchStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAutoLaunchs 查询自启动项的服务列表
//
// 查询自启动项的服务列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAutoLaunchs(request *model.ListAutoLaunchsRequest) (*model.ListAutoLaunchsResponse, error) {
	requestDef := GenReqDefForListAutoLaunchs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAutoLaunchsResponse), nil
	}
}

// ListAutoLaunchsInvoker 查询自启动项的服务列表
func (c *HssClient) ListAutoLaunchsInvoker(request *model.ListAutoLaunchsRequest) *ListAutoLaunchsInvoker {
	requestDef := GenReqDefForListAutoLaunchs()
	return &ListAutoLaunchsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListBlockedIp 查询已拦截IP列表
//
// 查询已拦截IP列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListBlockedIp(request *model.ListBlockedIpRequest) (*model.ListBlockedIpResponse, error) {
	requestDef := GenReqDefForListBlockedIp()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListBlockedIpResponse), nil
	}
}

// ListBlockedIpInvoker 查询已拦截IP列表
func (c *HssClient) ListBlockedIpInvoker(request *model.ListBlockedIpRequest) *ListBlockedIpInvoker {
	requestDef := GenReqDefForListBlockedIp()
	return &ListBlockedIpInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListCceClusterConfig 获取集群配置
//
// 获取集群配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListCceClusterConfig(request *model.ListCceClusterConfigRequest) (*model.ListCceClusterConfigResponse, error) {
	requestDef := GenReqDefForListCceClusterConfig()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListCceClusterConfigResponse), nil
	}
}

// ListCceClusterConfigInvoker 获取集群配置
func (c *HssClient) ListCceClusterConfigInvoker(request *model.ListCceClusterConfigRequest) *ListCceClusterConfigInvoker {
	requestDef := GenReqDefForListCceClusterConfig()
	return &ListCceClusterConfigInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListCceClusterDetectRisk 批量获取容器集群风险信息
//
// 批量获取容器集群风险信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListCceClusterDetectRisk(request *model.ListCceClusterDetectRiskRequest) (*model.ListCceClusterDetectRiskResponse, error) {
	requestDef := GenReqDefForListCceClusterDetectRisk()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListCceClusterDetectRiskResponse), nil
	}
}

// ListCceClusterDetectRiskInvoker 批量获取容器集群风险信息
func (c *HssClient) ListCceClusterDetectRiskInvoker(request *model.ListCceClusterDetectRiskRequest) *ListCceClusterDetectRiskInvoker {
	requestDef := GenReqDefForListCceClusterDetectRisk()
	return &ListCceClusterDetectRiskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListCheckFeatureRule 查询检测规则列表
//
// 查询检测规则列表：查询默认检测规则信息，包含14种检测规则，默认都不开启
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListCheckFeatureRule(request *model.ListCheckFeatureRuleRequest) (*model.ListCheckFeatureRuleResponse, error) {
	requestDef := GenReqDefForListCheckFeatureRule()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListCheckFeatureRuleResponse), nil
	}
}

// ListCheckFeatureRuleInvoker 查询检测规则列表
func (c *HssClient) ListCheckFeatureRuleInvoker(request *model.ListCheckFeatureRuleRequest) *ListCheckFeatureRuleInvoker {
	requestDef := GenReqDefForListCheckFeatureRule()
	return &ListCheckFeatureRuleInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterAuditLogs 查询k8s集群审计日志列表
//
// 查询k8s集群审计日志列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterAuditLogs(request *model.ListClusterAuditLogsRequest) (*model.ListClusterAuditLogsResponse, error) {
	requestDef := GenReqDefForListClusterAuditLogs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterAuditLogsResponse), nil
	}
}

// ListClusterAuditLogsInvoker 查询k8s集群审计日志列表
func (c *HssClient) ListClusterAuditLogsInvoker(request *model.ListClusterAuditLogsRequest) *ListClusterAuditLogsInvoker {
	requestDef := GenReqDefForListClusterAuditLogs()
	return &ListClusterAuditLogsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterEventLogs 查询k8s集群事件列表
//
// 查询k8s集群事件列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterEventLogs(request *model.ListClusterEventLogsRequest) (*model.ListClusterEventLogsResponse, error) {
	requestDef := GenReqDefForListClusterEventLogs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterEventLogsResponse), nil
	}
}

// ListClusterEventLogsInvoker 查询k8s集群事件列表
func (c *HssClient) ListClusterEventLogsInvoker(request *model.ListClusterEventLogsRequest) *ListClusterEventLogsInvoker {
	requestDef := GenReqDefForListClusterEventLogs()
	return &ListClusterEventLogsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterEvents 获取所有集群中告警事件
//
// 获取所有集群中告警事件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterEvents(request *model.ListClusterEventsRequest) (*model.ListClusterEventsResponse, error) {
	requestDef := GenReqDefForListClusterEvents()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterEventsResponse), nil
	}
}

// ListClusterEventsInvoker 获取所有集群中告警事件
func (c *HssClient) ListClusterEventsInvoker(request *model.ListClusterEventsRequest) *ListClusterEventsInvoker {
	requestDef := GenReqDefForListClusterEvents()
	return &ListClusterEventsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterProtectOverview 集群防护概览
//
// 集群防护概览
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterProtectOverview(request *model.ListClusterProtectOverviewRequest) (*model.ListClusterProtectOverviewResponse, error) {
	requestDef := GenReqDefForListClusterProtectOverview()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterProtectOverviewResponse), nil
	}
}

// ListClusterProtectOverviewInvoker 集群防护概览
func (c *HssClient) ListClusterProtectOverviewInvoker(request *model.ListClusterProtectOverviewRequest) *ListClusterProtectOverviewInvoker {
	requestDef := GenReqDefForListClusterProtectOverview()
	return &ListClusterProtectOverviewInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterProtectPolicyTemplates 查询集群组件防护策略模板列表
//
// 查询集群防护策略模板列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterProtectPolicyTemplates(request *model.ListClusterProtectPolicyTemplatesRequest) (*model.ListClusterProtectPolicyTemplatesResponse, error) {
	requestDef := GenReqDefForListClusterProtectPolicyTemplates()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterProtectPolicyTemplatesResponse), nil
	}
}

// ListClusterProtectPolicyTemplatesInvoker 查询集群组件防护策略模板列表
func (c *HssClient) ListClusterProtectPolicyTemplatesInvoker(request *model.ListClusterProtectPolicyTemplatesRequest) *ListClusterProtectPolicyTemplatesInvoker {
	requestDef := GenReqDefForListClusterProtectPolicyTemplates()
	return &ListClusterProtectPolicyTemplatesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterProtectionDefaultPolicy 获取集群防护默认策略列表
//
// 获取集群防护默认策略列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterProtectionDefaultPolicy(request *model.ListClusterProtectionDefaultPolicyRequest) (*model.ListClusterProtectionDefaultPolicyResponse, error) {
	requestDef := GenReqDefForListClusterProtectionDefaultPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterProtectionDefaultPolicyResponse), nil
	}
}

// ListClusterProtectionDefaultPolicyInvoker 获取集群防护默认策略列表
func (c *HssClient) ListClusterProtectionDefaultPolicyInvoker(request *model.ListClusterProtectionDefaultPolicyRequest) *ListClusterProtectionDefaultPolicyInvoker {
	requestDef := GenReqDefForListClusterProtectionDefaultPolicy()
	return &ListClusterProtectionDefaultPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterProtectionInfo 查询集群防护信息
//
// 查询集群防护信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterProtectionInfo(request *model.ListClusterProtectionInfoRequest) (*model.ListClusterProtectionInfoResponse, error) {
	requestDef := GenReqDefForListClusterProtectionInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterProtectionInfoResponse), nil
	}
}

// ListClusterProtectionInfoInvoker 查询集群防护信息
func (c *HssClient) ListClusterProtectionInfoInvoker(request *model.ListClusterProtectionInfoRequest) *ListClusterProtectionInfoInvoker {
	requestDef := GenReqDefForListClusterProtectionInfo()
	return &ListClusterProtectionInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterProtectionItem 获取集群所有防护项
//
// 获取集群所有防护项
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterProtectionItem(request *model.ListClusterProtectionItemRequest) (*model.ListClusterProtectionItemResponse, error) {
	requestDef := GenReqDefForListClusterProtectionItem()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterProtectionItemResponse), nil
	}
}

// ListClusterProtectionItemInvoker 获取集群所有防护项
func (c *HssClient) ListClusterProtectionItemInvoker(request *model.ListClusterProtectionItemRequest) *ListClusterProtectionItemInvoker {
	requestDef := GenReqDefForListClusterProtectionItem()
	return &ListClusterProtectionItemInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterProtectionPolicy 获取集群防护策略列表
//
// 获取集群防护策略列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterProtectionPolicy(request *model.ListClusterProtectionPolicyRequest) (*model.ListClusterProtectionPolicyResponse, error) {
	requestDef := GenReqDefForListClusterProtectionPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterProtectionPolicyResponse), nil
	}
}

// ListClusterProtectionPolicyInvoker 获取集群防护策略列表
func (c *HssClient) ListClusterProtectionPolicyInvoker(request *model.ListClusterProtectionPolicyRequest) *ListClusterProtectionPolicyInvoker {
	requestDef := GenReqDefForListClusterProtectionPolicy()
	return &ListClusterProtectionPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterProtectionPolicyDetail 查看指定策略的详情
//
// 查看指定策略的详情
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterProtectionPolicyDetail(request *model.ListClusterProtectionPolicyDetailRequest) (*model.ListClusterProtectionPolicyDetailResponse, error) {
	requestDef := GenReqDefForListClusterProtectionPolicyDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterProtectionPolicyDetailResponse), nil
	}
}

// ListClusterProtectionPolicyDetailInvoker 查看指定策略的详情
func (c *HssClient) ListClusterProtectionPolicyDetailInvoker(request *model.ListClusterProtectionPolicyDetailRequest) *ListClusterProtectionPolicyDetailInvoker {
	requestDef := GenReqDefForListClusterProtectionPolicyDetail()
	return &ListClusterProtectionPolicyDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListCommonTips 获取部分提示信息
//
// 获取部分提示信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListCommonTips(request *model.ListCommonTipsRequest) (*model.ListCommonTipsResponse, error) {
	requestDef := GenReqDefForListCommonTips()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListCommonTipsResponse), nil
	}
}

// ListCommonTipsInvoker 获取部分提示信息
func (c *HssClient) ListCommonTipsInvoker(request *model.ListCommonTipsRequest) *ListCommonTipsInvoker {
	requestDef := GenReqDefForListCommonTips()
	return &ListCommonTipsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListContainerCmdLogs 查询容器内运行的命令列表
//
// 查询容器内运行的命令列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListContainerCmdLogs(request *model.ListContainerCmdLogsRequest) (*model.ListContainerCmdLogsResponse, error) {
	requestDef := GenReqDefForListContainerCmdLogs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListContainerCmdLogsResponse), nil
	}
}

// ListContainerCmdLogsInvoker 查询容器内运行的命令列表
func (c *HssClient) ListContainerCmdLogsInvoker(request *model.ListContainerCmdLogsRequest) *ListContainerCmdLogsInvoker {
	requestDef := GenReqDefForListContainerCmdLogs()
	return &ListContainerCmdLogsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListContainerLogs 查询容器日志列表
//
// 查询容器日志列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListContainerLogs(request *model.ListContainerLogsRequest) (*model.ListContainerLogsResponse, error) {
	requestDef := GenReqDefForListContainerLogs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListContainerLogsResponse), nil
	}
}

// ListContainerLogsInvoker 查询容器日志列表
func (c *HssClient) ListContainerLogsInvoker(request *model.ListContainerLogsRequest) *ListContainerLogsInvoker {
	requestDef := GenReqDefForListContainerLogs()
	return &ListContainerLogsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListContainerNetworkClusters 查询容器防护的集群信息
//
// 查询容器防护的集群信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListContainerNetworkClusters(request *model.ListContainerNetworkClustersRequest) (*model.ListContainerNetworkClustersResponse, error) {
	requestDef := GenReqDefForListContainerNetworkClusters()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListContainerNetworkClustersResponse), nil
	}
}

// ListContainerNetworkClustersInvoker 查询容器防护的集群信息
func (c *HssClient) ListContainerNetworkClustersInvoker(request *model.ListContainerNetworkClustersRequest) *ListContainerNetworkClustersInvoker {
	requestDef := GenReqDefForListContainerNetworkClusters()
	return &ListContainerNetworkClustersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListContainerNetworkNodeList 查询容器集群VPC网络的节点列表
//
// 查询容器集群网络的节点列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListContainerNetworkNodeList(request *model.ListContainerNetworkNodeListRequest) (*model.ListContainerNetworkNodeListResponse, error) {
	requestDef := GenReqDefForListContainerNetworkNodeList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListContainerNetworkNodeListResponse), nil
	}
}

// ListContainerNetworkNodeListInvoker 查询容器集群VPC网络的节点列表
func (c *HssClient) ListContainerNetworkNodeListInvoker(request *model.ListContainerNetworkNodeListRequest) *ListContainerNetworkNodeListInvoker {
	requestDef := GenReqDefForListContainerNetworkNodeList()
	return &ListContainerNetworkNodeListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListContainerNetworkPolicy 查询容器集群网络的策略列表
//
// 查询容器集群网络的策略列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListContainerNetworkPolicy(request *model.ListContainerNetworkPolicyRequest) (*model.ListContainerNetworkPolicyResponse, error) {
	requestDef := GenReqDefForListContainerNetworkPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListContainerNetworkPolicyResponse), nil
	}
}

// ListContainerNetworkPolicyInvoker 查询容器集群网络的策略列表
func (c *HssClient) ListContainerNetworkPolicyInvoker(request *model.ListContainerNetworkPolicyRequest) *ListContainerNetworkPolicyInvoker {
	requestDef := GenReqDefForListContainerNetworkPolicy()
	return &ListContainerNetworkPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListContainerNodes 查询容器节点列表
//
// 查询容器节点列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListContainerNodes(request *model.ListContainerNodesRequest) (*model.ListContainerNodesResponse, error) {
	requestDef := GenReqDefForListContainerNodes()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListContainerNodesResponse), nil
	}
}

// ListContainerNodesInvoker 查询容器节点列表
func (c *HssClient) ListContainerNodesInvoker(request *model.ListContainerNodesRequest) *ListContainerNodesInvoker {
	requestDef := GenReqDefForListContainerNodes()
	return &ListContainerNodesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListContainers 查询容器基本信息列表
//
// 查询容器基本信息列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListContainers(request *model.ListContainersRequest) (*model.ListContainersResponse, error) {
	requestDef := GenReqDefForListContainers()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListContainersResponse), nil
	}
}

// ListContainersInvoker 查询容器基本信息列表
func (c *HssClient) ListContainersInvoker(request *model.ListContainersRequest) *ListContainersInvoker {
	requestDef := GenReqDefForListContainers()
	return &ListContainersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListDecoyPortAvailableHost 查看支持配置动态端口蜜罐的主机列表
//
// 查看支持配置动态端口蜜罐的主机列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListDecoyPortAvailableHost(request *model.ListDecoyPortAvailableHostRequest) (*model.ListDecoyPortAvailableHostResponse, error) {
	requestDef := GenReqDefForListDecoyPortAvailableHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListDecoyPortAvailableHostResponse), nil
	}
}

// ListDecoyPortAvailableHostInvoker 查看支持配置动态端口蜜罐的主机列表
func (c *HssClient) ListDecoyPortAvailableHostInvoker(request *model.ListDecoyPortAvailableHostRequest) *ListDecoyPortAvailableHostInvoker {
	requestDef := GenReqDefForListDecoyPortAvailableHost()
	return &ListDecoyPortAvailableHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListDecoyPortPolicy 查看动态端口蜜罐策略
//
// 查看动态端口蜜罐策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListDecoyPortPolicy(request *model.ListDecoyPortPolicyRequest) (*model.ListDecoyPortPolicyResponse, error) {
	requestDef := GenReqDefForListDecoyPortPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListDecoyPortPolicyResponse), nil
	}
}

// ListDecoyPortPolicyInvoker 查看动态端口蜜罐策略
func (c *HssClient) ListDecoyPortPolicyInvoker(request *model.ListDecoyPortPolicyRequest) *ListDecoyPortPolicyInvoker {
	requestDef := GenReqDefForListDecoyPortPolicy()
	return &ListDecoyPortPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListDockerPlugins 查询插件列表
//
// 查询插件列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListDockerPlugins(request *model.ListDockerPluginsRequest) (*model.ListDockerPluginsResponse, error) {
	requestDef := GenReqDefForListDockerPlugins()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListDockerPluginsResponse), nil
	}
}

// ListDockerPluginsInvoker 查询插件列表
func (c *HssClient) ListDockerPluginsInvoker(request *model.ListDockerPluginsRequest) *ListDockerPluginsInvoker {
	requestDef := GenReqDefForListDockerPlugins()
	return &ListDockerPluginsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListDownloadExportedFile 下载导出文件
//
// 下载导出文件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListDownloadExportedFile(request *model.ListDownloadExportedFileRequest) (*model.ListDownloadExportedFileResponse, error) {
	requestDef := GenReqDefForListDownloadExportedFile()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListDownloadExportedFileResponse), nil
	}
}

// ListDownloadExportedFileInvoker 下载导出文件
func (c *HssClient) ListDownloadExportedFileInvoker(request *model.ListDownloadExportedFileRequest) *ListDownloadExportedFileInvoker {
	requestDef := GenReqDefForListDownloadExportedFile()
	return &ListDownloadExportedFileInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListEventAttCk 查询ATT&amp;CK攻击阶段统计列表
//
// 查询ATT&amp;CK攻击阶段统计列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListEventAttCk(request *model.ListEventAttCkRequest) (*model.ListEventAttCkResponse, error) {
	requestDef := GenReqDefForListEventAttCk()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListEventAttCkResponse), nil
	}
}

// ListEventAttCkInvoker 查询ATT&amp;CK攻击阶段统计列表
func (c *HssClient) ListEventAttCkInvoker(request *model.ListEventAttCkRequest) *ListEventAttCkInvoker {
	requestDef := GenReqDefForListEventAttCk()
	return &ListEventAttCkInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListEventForensic 查询具体事件的调查取证信息
//
// 查询具体事件的调查取证信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListEventForensic(request *model.ListEventForensicRequest) (*model.ListEventForensicResponse, error) {
	requestDef := GenReqDefForListEventForensic()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListEventForensicResponse), nil
	}
}

// ListEventForensicInvoker 查询具体事件的调查取证信息
func (c *HssClient) ListEventForensicInvoker(request *model.ListEventForensicRequest) *ListEventForensicInvoker {
	requestDef := GenReqDefForListEventForensic()
	return &ListEventForensicInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListEventOperates 查询事件支持的处理类型
//
// 查询事件支持的处理类型
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListEventOperates(request *model.ListEventOperatesRequest) (*model.ListEventOperatesResponse, error) {
	requestDef := GenReqDefForListEventOperates()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListEventOperatesResponse), nil
	}
}

// ListEventOperatesInvoker 查询事件支持的处理类型
func (c *HssClient) ListEventOperatesInvoker(request *model.ListEventOperatesRequest) *ListEventOperatesInvoker {
	requestDef := GenReqDefForListEventOperates()
	return &ListEventOperatesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListEventTopRisk 查询TOP5事件类型统计列表--接口已废弃
//
// 查询TOP5事件类型统计列表--接口已废弃
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListEventTopRisk(request *model.ListEventTopRiskRequest) (*model.ListEventTopRiskResponse, error) {
	requestDef := GenReqDefForListEventTopRisk()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListEventTopRiskResponse), nil
	}
}

// ListEventTopRiskInvoker 查询TOP5事件类型统计列表--接口已废弃
func (c *HssClient) ListEventTopRiskInvoker(request *model.ListEventTopRiskRequest) *ListEventTopRiskInvoker {
	requestDef := GenReqDefForListEventTopRisk()
	return &ListEventTopRiskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListEventType 查询事件类型统计列表
//
// 查询事件类型统计列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListEventType(request *model.ListEventTypeRequest) (*model.ListEventTypeResponse, error) {
	requestDef := GenReqDefForListEventType()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListEventTypeResponse), nil
	}
}

// ListEventTypeInvoker 查询事件类型统计列表
func (c *HssClient) ListEventTypeInvoker(request *model.ListEventTypeRequest) *ListEventTypeInvoker {
	requestDef := GenReqDefForListEventType()
	return &ListEventTypeInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListGlobalAssetScanTask 查询资产全局扫描任务状态
//
// 查询资产全局扫描任务状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListGlobalAssetScanTask(request *model.ListGlobalAssetScanTaskRequest) (*model.ListGlobalAssetScanTaskResponse, error) {
	requestDef := GenReqDefForListGlobalAssetScanTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListGlobalAssetScanTaskResponse), nil
	}
}

// ListGlobalAssetScanTaskInvoker 查询资产全局扫描任务状态
func (c *HssClient) ListGlobalAssetScanTaskInvoker(request *model.ListGlobalAssetScanTaskRequest) *ListGlobalAssetScanTaskInvoker {
	requestDef := GenReqDefForListGlobalAssetScanTask()
	return &ListGlobalAssetScanTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListIsolatedFile 查询已隔离文件列表
//
// 查询已隔离文件列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListIsolatedFile(request *model.ListIsolatedFileRequest) (*model.ListIsolatedFileResponse, error) {
	requestDef := GenReqDefForListIsolatedFile()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListIsolatedFileResponse), nil
	}
}

// ListIsolatedFileInvoker 查询已隔离文件列表
func (c *HssClient) ListIsolatedFileInvoker(request *model.ListIsolatedFileRequest) *ListIsolatedFileInvoker {
	requestDef := GenReqDefForListIsolatedFile()
	return &ListIsolatedFileInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListJarPackageHostInfo 查询指定中间件的服务器列表
//
// 查询指定中间件的服务器列表，通过传入中间件名称参数，返回对应的中间件服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListJarPackageHostInfo(request *model.ListJarPackageHostInfoRequest) (*model.ListJarPackageHostInfoResponse, error) {
	requestDef := GenReqDefForListJarPackageHostInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListJarPackageHostInfoResponse), nil
	}
}

// ListJarPackageHostInfoInvoker 查询指定中间件的服务器列表
func (c *HssClient) ListJarPackageHostInfoInvoker(request *model.ListJarPackageHostInfoRequest) *ListJarPackageHostInfoInvoker {
	requestDef := GenReqDefForListJarPackageHostInfo()
	return &ListJarPackageHostInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListJarPackageInfo 查询指定主机的中间件信息
//
// 查询指定主机的中间件信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListJarPackageInfo(request *model.ListJarPackageInfoRequest) (*model.ListJarPackageInfoResponse, error) {
	requestDef := GenReqDefForListJarPackageInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListJarPackageInfoResponse), nil
	}
}

// ListJarPackageInfoInvoker 查询指定主机的中间件信息
func (c *HssClient) ListJarPackageInfoInvoker(request *model.ListJarPackageInfoRequest) *ListJarPackageInfoInvoker {
	requestDef := GenReqDefForListJarPackageInfo()
	return &ListJarPackageInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListJarPackageStatistics 查询中间件列表
//
// 查询中间件列表，支持通过中间件名称查询对应的服务器数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListJarPackageStatistics(request *model.ListJarPackageStatisticsRequest) (*model.ListJarPackageStatisticsResponse, error) {
	requestDef := GenReqDefForListJarPackageStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListJarPackageStatisticsResponse), nil
	}
}

// ListJarPackageStatisticsInvoker 查询中间件列表
func (c *HssClient) ListJarPackageStatisticsInvoker(request *model.ListJarPackageStatisticsRequest) *ListJarPackageStatisticsInvoker {
	requestDef := GenReqDefForListJarPackageStatistics()
	return &ListJarPackageStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListK8sCronJobs 查询cronjobs基本信息列表
//
// 查询cronjobs基本信息列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListK8sCronJobs(request *model.ListK8sCronJobsRequest) (*model.ListK8sCronJobsResponse, error) {
	requestDef := GenReqDefForListK8sCronJobs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListK8sCronJobsResponse), nil
	}
}

// ListK8sCronJobsInvoker 查询cronjobs基本信息列表
func (c *HssClient) ListK8sCronJobsInvoker(request *model.ListK8sCronJobsRequest) *ListK8sCronJobsInvoker {
	requestDef := GenReqDefForListK8sCronJobs()
	return &ListK8sCronJobsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListK8sDaemonSets 查询daemonsets基本信息列表
//
// 查询daemonsets基本信息列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListK8sDaemonSets(request *model.ListK8sDaemonSetsRequest) (*model.ListK8sDaemonSetsResponse, error) {
	requestDef := GenReqDefForListK8sDaemonSets()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListK8sDaemonSetsResponse), nil
	}
}

// ListK8sDaemonSetsInvoker 查询daemonsets基本信息列表
func (c *HssClient) ListK8sDaemonSetsInvoker(request *model.ListK8sDaemonSetsRequest) *ListK8sDaemonSetsInvoker {
	requestDef := GenReqDefForListK8sDaemonSets()
	return &ListK8sDaemonSetsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListK8sDeployments 查询deployment基本信息列表
//
// 查询deployment基本信息列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListK8sDeployments(request *model.ListK8sDeploymentsRequest) (*model.ListK8sDeploymentsResponse, error) {
	requestDef := GenReqDefForListK8sDeployments()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListK8sDeploymentsResponse), nil
	}
}

// ListK8sDeploymentsInvoker 查询deployment基本信息列表
func (c *HssClient) ListK8sDeploymentsInvoker(request *model.ListK8sDeploymentsRequest) *ListK8sDeploymentsInvoker {
	requestDef := GenReqDefForListK8sDeployments()
	return &ListK8sDeploymentsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListK8sJobs 查询jobs基本信息列表
//
// 查询jobs基本信息列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListK8sJobs(request *model.ListK8sJobsRequest) (*model.ListK8sJobsResponse, error) {
	requestDef := GenReqDefForListK8sJobs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListK8sJobsResponse), nil
	}
}

// ListK8sJobsInvoker 查询jobs基本信息列表
func (c *HssClient) ListK8sJobsInvoker(request *model.ListK8sJobsRequest) *ListK8sJobsInvoker {
	requestDef := GenReqDefForListK8sJobs()
	return &ListK8sJobsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListK8sPods 查询pod基本信息列表
//
// 查询pod基本信息列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListK8sPods(request *model.ListK8sPodsRequest) (*model.ListK8sPodsResponse, error) {
	requestDef := GenReqDefForListK8sPods()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListK8sPodsResponse), nil
	}
}

// ListK8sPodsInvoker 查询pod基本信息列表
func (c *HssClient) ListK8sPodsInvoker(request *model.ListK8sPodsRequest) *ListK8sPodsInvoker {
	requestDef := GenReqDefForListK8sPods()
	return &ListK8sPodsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListK8sStatefulSets 查询statefulset基本信息列表
//
// 查询statefulset基本信息列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListK8sStatefulSets(request *model.ListK8sStatefulSetsRequest) (*model.ListK8sStatefulSetsResponse, error) {
	requestDef := GenReqDefForListK8sStatefulSets()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListK8sStatefulSetsResponse), nil
	}
}

// ListK8sStatefulSetsInvoker 查询statefulset基本信息列表
func (c *HssClient) ListK8sStatefulSetsInvoker(request *model.ListK8sStatefulSetsRequest) *ListK8sStatefulSetsInvoker {
	requestDef := GenReqDefForListK8sStatefulSets()
	return &ListK8sStatefulSetsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListKernelModuleHostInfo 查询指定内核模块的服务器列表
//
// 查询指定内核模块的服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListKernelModuleHostInfo(request *model.ListKernelModuleHostInfoRequest) (*model.ListKernelModuleHostInfoResponse, error) {
	requestDef := GenReqDefForListKernelModuleHostInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListKernelModuleHostInfoResponse), nil
	}
}

// ListKernelModuleHostInfoInvoker 查询指定内核模块的服务器列表
func (c *HssClient) ListKernelModuleHostInfoInvoker(request *model.ListKernelModuleHostInfoRequest) *ListKernelModuleHostInfoInvoker {
	requestDef := GenReqDefForListKernelModuleHostInfo()
	return &ListKernelModuleHostInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListKernelModuleInfo 查询指定主机的内核模块信息
//
// 查询指定主机的内核模块信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListKernelModuleInfo(request *model.ListKernelModuleInfoRequest) (*model.ListKernelModuleInfoResponse, error) {
	requestDef := GenReqDefForListKernelModuleInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListKernelModuleInfoResponse), nil
	}
}

// ListKernelModuleInfoInvoker 查询指定主机的内核模块信息
func (c *HssClient) ListKernelModuleInfoInvoker(request *model.ListKernelModuleInfoRequest) *ListKernelModuleInfoInvoker {
	requestDef := GenReqDefForListKernelModuleInfo()
	return &ListKernelModuleInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListKernelModuleStatistics 查询内核模块的统计信息
//
// 查询内核模块的服务器数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListKernelModuleStatistics(request *model.ListKernelModuleStatisticsRequest) (*model.ListKernelModuleStatisticsResponse, error) {
	requestDef := GenReqDefForListKernelModuleStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListKernelModuleStatisticsResponse), nil
	}
}

// ListKernelModuleStatisticsInvoker 查询内核模块的统计信息
func (c *HssClient) ListKernelModuleStatisticsInvoker(request *model.ListKernelModuleStatisticsRequest) *ListKernelModuleStatisticsInvoker {
	requestDef := GenReqDefForListKernelModuleStatistics()
	return &ListKernelModuleStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListKubernetesClusterDetails 查询容器Kubernetes集群列表
//
// 查询容器Kubernetes集群列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListKubernetesClusterDetails(request *model.ListKubernetesClusterDetailsRequest) (*model.ListKubernetesClusterDetailsResponse, error) {
	requestDef := GenReqDefForListKubernetesClusterDetails()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListKubernetesClusterDetailsResponse), nil
	}
}

// ListKubernetesClusterDetailsInvoker 查询容器Kubernetes集群列表
func (c *HssClient) ListKubernetesClusterDetailsInvoker(request *model.ListKubernetesClusterDetailsRequest) *ListKubernetesClusterDetailsInvoker {
	requestDef := GenReqDefForListKubernetesClusterDetails()
	return &ListKubernetesClusterDetailsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListKubernetesEndpointDetails 查询容器Kubernetes端点列表
//
// 查询容器Kubernetes端点列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListKubernetesEndpointDetails(request *model.ListKubernetesEndpointDetailsRequest) (*model.ListKubernetesEndpointDetailsResponse, error) {
	requestDef := GenReqDefForListKubernetesEndpointDetails()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListKubernetesEndpointDetailsResponse), nil
	}
}

// ListKubernetesEndpointDetailsInvoker 查询容器Kubernetes端点列表
func (c *HssClient) ListKubernetesEndpointDetailsInvoker(request *model.ListKubernetesEndpointDetailsRequest) *ListKubernetesEndpointDetailsInvoker {
	requestDef := GenReqDefForListKubernetesEndpointDetails()
	return &ListKubernetesEndpointDetailsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListKubernetesServiceDetails 查询容器Kubernetes服务列表
//
// 查询容器Kubernetes服务列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListKubernetesServiceDetails(request *model.ListKubernetesServiceDetailsRequest) (*model.ListKubernetesServiceDetailsResponse, error) {
	requestDef := GenReqDefForListKubernetesServiceDetails()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListKubernetesServiceDetailsResponse), nil
	}
}

// ListKubernetesServiceDetailsInvoker 查询容器Kubernetes服务列表
func (c *HssClient) ListKubernetesServiceDetailsInvoker(request *model.ListKubernetesServiceDetailsRequest) *ListKubernetesServiceDetailsInvoker {
	requestDef := GenReqDefForListKubernetesServiceDetails()
	return &ListKubernetesServiceDetailsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListLoginWhiteList 查询登录白名单列表
//
// 查询登录白名单列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListLoginWhiteList(request *model.ListLoginWhiteListRequest) (*model.ListLoginWhiteListResponse, error) {
	requestDef := GenReqDefForListLoginWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListLoginWhiteListResponse), nil
	}
}

// ListLoginWhiteListInvoker 查询登录白名单列表
func (c *HssClient) ListLoginWhiteListInvoker(request *model.ListLoginWhiteListRequest) *ListLoginWhiteListInvoker {
	requestDef := GenReqDefForListLoginWhiteList()
	return &ListLoginWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListMalwareCollectStatus 查询恶意软件云查样本收集配置开关状态
//
// 查询恶意软件云查样本收集配置开关状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListMalwareCollectStatus(request *model.ListMalwareCollectStatusRequest) (*model.ListMalwareCollectStatusResponse, error) {
	requestDef := GenReqDefForListMalwareCollectStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListMalwareCollectStatusResponse), nil
	}
}

// ListMalwareCollectStatusInvoker 查询恶意软件云查样本收集配置开关状态
func (c *HssClient) ListMalwareCollectStatusInvoker(request *model.ListMalwareCollectStatusRequest) *ListMalwareCollectStatusInvoker {
	requestDef := GenReqDefForListMalwareCollectStatus()
	return &ListMalwareCollectStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListNamespaces 获取集群下的namespace
//
// 获取集群下的namespace
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListNamespaces(request *model.ListNamespacesRequest) (*model.ListNamespacesResponse, error) {
	requestDef := GenReqDefForListNamespaces()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListNamespacesResponse), nil
	}
}

// ListNamespacesInvoker 获取集群下的namespace
func (c *HssClient) ListNamespacesInvoker(request *model.ListNamespacesRequest) *ListNamespacesInvoker {
	requestDef := GenReqDefForListNamespaces()
	return &ListNamespacesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListOrganizationTree 查询账号组织
//
// 查询账号组织
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListOrganizationTree(request *model.ListOrganizationTreeRequest) (*model.ListOrganizationTreeResponse, error) {
	requestDef := GenReqDefForListOrganizationTree()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListOrganizationTreeResponse), nil
	}
}

// ListOrganizationTreeInvoker 查询账号组织
func (c *HssClient) ListOrganizationTreeInvoker(request *model.ListOrganizationTreeRequest) *ListOrganizationTreeInvoker {
	requestDef := GenReqDefForListOrganizationTree()
	return &ListOrganizationTreeInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListPluginInstallScript 获取docker插件安装脚本
//
// 获取docker插件安装脚本
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListPluginInstallScript(request *model.ListPluginInstallScriptRequest) (*model.ListPluginInstallScriptResponse, error) {
	requestDef := GenReqDefForListPluginInstallScript()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListPluginInstallScriptResponse), nil
	}
}

// ListPluginInstallScriptInvoker 获取docker插件安装脚本
func (c *HssClient) ListPluginInstallScriptInvoker(request *model.ListPluginInstallScriptRequest) *ListPluginInstallScriptInvoker {
	requestDef := GenReqDefForListPluginInstallScript()
	return &ListPluginInstallScriptInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListPortHost 查询指定开放端口的服务器列表
//
// 查询具备该端口的主机/容器的服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListPortHost(request *model.ListPortHostRequest) (*model.ListPortHostResponse, error) {
	requestDef := GenReqDefForListPortHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListPortHostResponse), nil
	}
}

// ListPortHostInvoker 查询指定开放端口的服务器列表
func (c *HssClient) ListPortHostInvoker(request *model.ListPortHostRequest) *ListPortHostInvoker {
	requestDef := GenReqDefForListPortHost()
	return &ListPortHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListPortStatistics 查询开放端口统计信息
//
// 查询开放端口列表，支持通过传入端口或协议类型查询服务器数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListPortStatistics(request *model.ListPortStatisticsRequest) (*model.ListPortStatisticsResponse, error) {
	requestDef := GenReqDefForListPortStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListPortStatisticsResponse), nil
	}
}

// ListPortStatisticsInvoker 查询开放端口统计信息
func (c *HssClient) ListPortStatisticsInvoker(request *model.ListPortStatisticsRequest) *ListPortStatisticsInvoker {
	requestDef := GenReqDefForListPortStatistics()
	return &ListPortStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListPorts 查询单服务器的开放端口列表
//
// 查询单服务器的开放端口列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListPorts(request *model.ListPortsRequest) (*model.ListPortsResponse, error) {
	requestDef := GenReqDefForListPorts()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListPortsResponse), nil
	}
}

// ListPortsInvoker 查询单服务器的开放端口列表
func (c *HssClient) ListPortsInvoker(request *model.ListPortsRequest) *ListPortsInvoker {
	requestDef := GenReqDefForListPorts()
	return &ListPortsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListProcessStatistics 查询进程统计信息
//
// 查询进程列表，通过传入进程路径参数查询对应的服务器数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListProcessStatistics(request *model.ListProcessStatisticsRequest) (*model.ListProcessStatisticsResponse, error) {
	requestDef := GenReqDefForListProcessStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListProcessStatisticsResponse), nil
	}
}

// ListProcessStatisticsInvoker 查询进程统计信息
func (c *HssClient) ListProcessStatisticsInvoker(request *model.ListProcessStatisticsRequest) *ListProcessStatisticsInvoker {
	requestDef := GenReqDefForListProcessStatistics()
	return &ListProcessStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListProcessesHost 查询指定进程的服务器列表
//
// 具备该进程的主机/容器的服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListProcessesHost(request *model.ListProcessesHostRequest) (*model.ListProcessesHostResponse, error) {
	requestDef := GenReqDefForListProcessesHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListProcessesHostResponse), nil
	}
}

// ListProcessesHostInvoker 查询指定进程的服务器列表
func (c *HssClient) ListProcessesHostInvoker(request *model.ListProcessesHostRequest) *ListProcessesHostInvoker {
	requestDef := GenReqDefForListProcessesHost()
	return &ListProcessesHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListProjectTags 查询租户当前项目下所有用过的标签
//
// 查询租户当前项目下所有用过的标签
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListProjectTags(request *model.ListProjectTagsRequest) (*model.ListProjectTagsResponse, error) {
	requestDef := GenReqDefForListProjectTags()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListProjectTagsResponse), nil
	}
}

// ListProjectTagsInvoker 查询租户当前项目下所有用过的标签
func (c *HssClient) ListProjectTagsInvoker(request *model.ListProjectTagsRequest) *ListProjectTagsInvoker {
	requestDef := GenReqDefForListProjectTags()
	return &ListProjectTagsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListProtectionServers 查询防护服务器列表
//
// 查询防护服务器列表：查询防护服务器相关数据，包含服务器名称、ip地址、操作系统、服务器组名称、防护策略、防护状态、微服务防护状态、RASP防护状态、RASP攻击数量信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListProtectionServers(request *model.ListProtectionServersRequest) (*model.ListProtectionServersResponse, error) {
	requestDef := GenReqDefForListProtectionServers()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListProtectionServersResponse), nil
	}
}

// ListProtectionServersInvoker 查询防护服务器列表
func (c *HssClient) ListProtectionServersInvoker(request *model.ListProtectionServersRequest) *ListProtectionServersInvoker {
	requestDef := GenReqDefForListProtectionServers()
	return &ListProtectionServersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListQueryExportTask 查询导出任务信息
//
// 查询导出任务信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListQueryExportTask(request *model.ListQueryExportTaskRequest) (*model.ListQueryExportTaskResponse, error) {
	requestDef := GenReqDefForListQueryExportTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListQueryExportTaskResponse), nil
	}
}

// ListQueryExportTaskInvoker 查询导出任务信息
func (c *HssClient) ListQueryExportTaskInvoker(request *model.ListQueryExportTaskRequest) *ListQueryExportTaskInvoker {
	requestDef := GenReqDefForListQueryExportTask()
	return &ListQueryExportTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListRaspEvents 查询应用防护事件列表
//
// 查询应用防护事件列表：展示防护事件相关信息，包含告警级别、服务器名称、告警名称、告警时间、攻击源ip、攻击源url数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListRaspEvents(request *model.ListRaspEventsRequest) (*model.ListRaspEventsResponse, error) {
	requestDef := GenReqDefForListRaspEvents()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListRaspEventsResponse), nil
	}
}

// ListRaspEventsInvoker 查询应用防护事件列表
func (c *HssClient) ListRaspEventsInvoker(request *model.ListRaspEventsRequest) *ListRaspEventsInvoker {
	requestDef := GenReqDefForListRaspEvents()
	return &ListRaspEventsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListRaspPolicies 查询防护策略列表
//
// 查询防护策略列表：查询创建的防护策略信息，包含防护策略名称、检测规则、关联服务器数量
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListRaspPolicies(request *model.ListRaspPoliciesRequest) (*model.ListRaspPoliciesResponse, error) {
	requestDef := GenReqDefForListRaspPolicies()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListRaspPoliciesResponse), nil
	}
}

// ListRaspPoliciesInvoker 查询防护策略列表
func (c *HssClient) ListRaspPoliciesInvoker(request *model.ListRaspPoliciesRequest) *ListRaspPoliciesInvoker {
	requestDef := GenReqDefForListRaspPolicies()
	return &ListRaspPoliciesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListResourceInstanceTag 查询单个资源的资源标签
//
// 查询单个资源的资源标签
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListResourceInstanceTag(request *model.ListResourceInstanceTagRequest) (*model.ListResourceInstanceTagResponse, error) {
	requestDef := GenReqDefForListResourceInstanceTag()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListResourceInstanceTagResponse), nil
	}
}

// ListResourceInstanceTagInvoker 查询单个资源的资源标签
func (c *HssClient) ListResourceInstanceTagInvoker(request *model.ListResourceInstanceTagRequest) *ListResourceInstanceTagInvoker {
	requestDef := GenReqDefForListResourceInstanceTag()
	return &ListResourceInstanceTagInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListSameEvents 查询某告警事件的相同告警列表
//
// 查询某告警事件的相同告警列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListSameEvents(request *model.ListSameEventsRequest) (*model.ListSameEventsResponse, error) {
	requestDef := GenReqDefForListSameEvents()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListSameEventsResponse), nil
	}
}

// ListSameEventsInvoker 查询某告警事件的相同告警列表
func (c *HssClient) ListSameEventsInvoker(request *model.ListSameEventsRequest) *ListSameEventsInvoker {
	requestDef := GenReqDefForListSameEvents()
	return &ListSameEventsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListSecurityEvents 查入侵事件列表
//
// 查入侵事件列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListSecurityEvents(request *model.ListSecurityEventsRequest) (*model.ListSecurityEventsResponse, error) {
	requestDef := GenReqDefForListSecurityEvents()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListSecurityEventsResponse), nil
	}
}

// ListSecurityEventsInvoker 查入侵事件列表
func (c *HssClient) ListSecurityEventsInvoker(request *model.ListSecurityEventsRequest) *ListSecurityEventsInvoker {
	requestDef := GenReqDefForListSecurityEvents()
	return &ListSecurityEventsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListSecurityGroupPolicies 查询云原生网络模式2.0的集群已配置的安全组策略
//
// 查询云原生网络模式2.0的集群已配置的安全组策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListSecurityGroupPolicies(request *model.ListSecurityGroupPoliciesRequest) (*model.ListSecurityGroupPoliciesResponse, error) {
	requestDef := GenReqDefForListSecurityGroupPolicies()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListSecurityGroupPoliciesResponse), nil
	}
}

// ListSecurityGroupPoliciesInvoker 查询云原生网络模式2.0的集群已配置的安全组策略
func (c *HssClient) ListSecurityGroupPoliciesInvoker(request *model.ListSecurityGroupPoliciesRequest) *ListSecurityGroupPoliciesInvoker {
	requestDef := GenReqDefForListSecurityGroupPolicies()
	return &ListSecurityGroupPoliciesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListSecurityGroups 查询企业项目下所有的安全组列表
//
// 查询企业项目下所有的安全组列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListSecurityGroups(request *model.ListSecurityGroupsRequest) (*model.ListSecurityGroupsResponse, error) {
	requestDef := GenReqDefForListSecurityGroups()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListSecurityGroupsResponse), nil
	}
}

// ListSecurityGroupsInvoker 查询企业项目下所有的安全组列表
func (c *HssClient) ListSecurityGroupsInvoker(request *model.ListSecurityGroupsRequest) *ListSecurityGroupsInvoker {
	requestDef := GenReqDefForListSecurityGroups()
	return &ListSecurityGroupsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListSimilarHandledEvents 查询某告警事件关联的已处理的相似告警
//
// 查询某告警事件关联的已处理的相似告警
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListSimilarHandledEvents(request *model.ListSimilarHandledEventsRequest) (*model.ListSimilarHandledEventsResponse, error) {
	requestDef := GenReqDefForListSimilarHandledEvents()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListSimilarHandledEventsResponse), nil
	}
}

// ListSimilarHandledEventsInvoker 查询某告警事件关联的已处理的相似告警
func (c *HssClient) ListSimilarHandledEventsInvoker(request *model.ListSimilarHandledEventsRequest) *ListSimilarHandledEventsInvoker {
	requestDef := GenReqDefForListSimilarHandledEvents()
	return &ListSimilarHandledEventsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListSystemUserWhiteList 查询系统用户白名单列表
//
// 查询系统用户白名单列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListSystemUserWhiteList(request *model.ListSystemUserWhiteListRequest) (*model.ListSystemUserWhiteListResponse, error) {
	requestDef := GenReqDefForListSystemUserWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListSystemUserWhiteListResponse), nil
	}
}

// ListSystemUserWhiteListInvoker 查询系统用户白名单列表
func (c *HssClient) ListSystemUserWhiteListInvoker(request *model.ListSystemUserWhiteListRequest) *ListSystemUserWhiteListInvoker {
	requestDef := GenReqDefForListSystemUserWhiteList()
	return &ListSystemUserWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListTrustServiceStatus 获取可信服务状态
//
// 获取可信服务状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListTrustServiceStatus(request *model.ListTrustServiceStatusRequest) (*model.ListTrustServiceStatusResponse, error) {
	requestDef := GenReqDefForListTrustServiceStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListTrustServiceStatusResponse), nil
	}
}

// ListTrustServiceStatusInvoker 获取可信服务状态
func (c *HssClient) ListTrustServiceStatusInvoker(request *model.ListTrustServiceStatusRequest) *ListTrustServiceStatusInvoker {
	requestDef := GenReqDefForListTrustServiceStatus()
	return &ListTrustServiceStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListUserChangeHistories 获取账户变动历史信息
//
// 获取账户变动历史记录信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListUserChangeHistories(request *model.ListUserChangeHistoriesRequest) (*model.ListUserChangeHistoriesResponse, error) {
	requestDef := GenReqDefForListUserChangeHistories()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListUserChangeHistoriesResponse), nil
	}
}

// ListUserChangeHistoriesInvoker 获取账户变动历史信息
func (c *HssClient) ListUserChangeHistoriesInvoker(request *model.ListUserChangeHistoriesRequest) *ListUserChangeHistoriesInvoker {
	requestDef := GenReqDefForListUserChangeHistories()
	return &ListUserChangeHistoriesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListUserStatistics 查询账号信息列表
//
// 查询账号信息列表，支持通过传入账号名称参数查询对应的服务器数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListUserStatistics(request *model.ListUserStatisticsRequest) (*model.ListUserStatisticsResponse, error) {
	requestDef := GenReqDefForListUserStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListUserStatisticsResponse), nil
	}
}

// ListUserStatisticsInvoker 查询账号信息列表
func (c *HssClient) ListUserStatisticsInvoker(request *model.ListUserStatisticsRequest) *ListUserStatisticsInvoker {
	requestDef := GenReqDefForListUserStatistics()
	return &ListUserStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListUsers 查询账号的服务器列表
//
// 查询账号的服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListUsers(request *model.ListUsersRequest) (*model.ListUsersResponse, error) {
	requestDef := GenReqDefForListUsers()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListUsersResponse), nil
	}
}

// ListUsersInvoker 查询账号的服务器列表
func (c *HssClient) ListUsersInvoker(request *model.ListUsersRequest) *ListUsersInvoker {
	requestDef := GenReqDefForListUsers()
	return &ListUsersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebAppAndServiceStatistics 查询Web服务、Web应用、数据库的统计信息
//
// 查询Web服务、Web应用、数据库的服务器数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebAppAndServiceStatistics(request *model.ListWebAppAndServiceStatisticsRequest) (*model.ListWebAppAndServiceStatisticsResponse, error) {
	requestDef := GenReqDefForListWebAppAndServiceStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebAppAndServiceStatisticsResponse), nil
	}
}

// ListWebAppAndServiceStatisticsInvoker 查询Web服务、Web应用、数据库的统计信息
func (c *HssClient) ListWebAppAndServiceStatisticsInvoker(request *model.ListWebAppAndServiceStatisticsRequest) *ListWebAppAndServiceStatisticsInvoker {
	requestDef := GenReqDefForListWebAppAndServiceStatistics()
	return &ListWebAppAndServiceStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebAppAndServices 查询指定Web服务、Web应用、数据库的服务器列表
//
// 查询指定Web服务、Web应用、数据库的服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebAppAndServices(request *model.ListWebAppAndServicesRequest) (*model.ListWebAppAndServicesResponse, error) {
	requestDef := GenReqDefForListWebAppAndServices()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebAppAndServicesResponse), nil
	}
}

// ListWebAppAndServicesInvoker 查询指定Web服务、Web应用、数据库的服务器列表
func (c *HssClient) ListWebAppAndServicesInvoker(request *model.ListWebAppAndServicesRequest) *ListWebAppAndServicesInvoker {
	requestDef := GenReqDefForListWebAppAndServices()
	return &ListWebAppAndServicesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebFrameworkHostInfo 查询指定Web框架的服务器列表
//
// 查询指定Web框架的服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebFrameworkHostInfo(request *model.ListWebFrameworkHostInfoRequest) (*model.ListWebFrameworkHostInfoResponse, error) {
	requestDef := GenReqDefForListWebFrameworkHostInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebFrameworkHostInfoResponse), nil
	}
}

// ListWebFrameworkHostInfoInvoker 查询指定Web框架的服务器列表
func (c *HssClient) ListWebFrameworkHostInfoInvoker(request *model.ListWebFrameworkHostInfoRequest) *ListWebFrameworkHostInfoInvoker {
	requestDef := GenReqDefForListWebFrameworkHostInfo()
	return &ListWebFrameworkHostInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebFrameworkInfo 查询指定主机的Web框架信息
//
// 查询指定主机的Web框架信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebFrameworkInfo(request *model.ListWebFrameworkInfoRequest) (*model.ListWebFrameworkInfoResponse, error) {
	requestDef := GenReqDefForListWebFrameworkInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebFrameworkInfoResponse), nil
	}
}

// ListWebFrameworkInfoInvoker 查询指定主机的Web框架信息
func (c *HssClient) ListWebFrameworkInfoInvoker(request *model.ListWebFrameworkInfoRequest) *ListWebFrameworkInfoInvoker {
	requestDef := GenReqDefForListWebFrameworkInfo()
	return &ListWebFrameworkInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebFrameworkStatistics 查询Web框架的统计信息
//
// 查询Web框架的服务器数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebFrameworkStatistics(request *model.ListWebFrameworkStatisticsRequest) (*model.ListWebFrameworkStatisticsResponse, error) {
	requestDef := GenReqDefForListWebFrameworkStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebFrameworkStatisticsResponse), nil
	}
}

// ListWebFrameworkStatisticsInvoker 查询Web框架的统计信息
func (c *HssClient) ListWebFrameworkStatisticsInvoker(request *model.ListWebFrameworkStatisticsRequest) *ListWebFrameworkStatisticsInvoker {
	requestDef := GenReqDefForListWebFrameworkStatistics()
	return &ListWebFrameworkStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebSiteHostInfo 查询指定Web站点的服务器列表
//
// 查询指定Web站点的服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebSiteHostInfo(request *model.ListWebSiteHostInfoRequest) (*model.ListWebSiteHostInfoResponse, error) {
	requestDef := GenReqDefForListWebSiteHostInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebSiteHostInfoResponse), nil
	}
}

// ListWebSiteHostInfoInvoker 查询指定Web站点的服务器列表
func (c *HssClient) ListWebSiteHostInfoInvoker(request *model.ListWebSiteHostInfoRequest) *ListWebSiteHostInfoInvoker {
	requestDef := GenReqDefForListWebSiteHostInfo()
	return &ListWebSiteHostInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebSiteInfo 查询指定主机的Web站点信息
//
// 查询指定主机的Web站点信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebSiteInfo(request *model.ListWebSiteInfoRequest) (*model.ListWebSiteInfoResponse, error) {
	requestDef := GenReqDefForListWebSiteInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebSiteInfoResponse), nil
	}
}

// ListWebSiteInfoInvoker 查询指定主机的Web站点信息
func (c *HssClient) ListWebSiteInfoInvoker(request *model.ListWebSiteInfoRequest) *ListWebSiteInfoInvoker {
	requestDef := GenReqDefForListWebSiteInfo()
	return &ListWebSiteInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebSiteStatistics 查询Web站点的统计信息
//
// 查询Web站点的服务器数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebSiteStatistics(request *model.ListWebSiteStatisticsRequest) (*model.ListWebSiteStatisticsResponse, error) {
	requestDef := GenReqDefForListWebSiteStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebSiteStatisticsResponse), nil
	}
}

// ListWebSiteStatisticsInvoker 查询Web站点的统计信息
func (c *HssClient) ListWebSiteStatisticsInvoker(request *model.ListWebSiteStatisticsRequest) *ListWebSiteStatisticsInvoker {
	requestDef := GenReqDefForListWebSiteStatistics()
	return &ListWebSiteStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWorkLoads 查询集群下某一命名空间下的工作负载
//
// 查询集群下某一命名空间下的工作负载
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWorkLoads(request *model.ListWorkLoadsRequest) (*model.ListWorkLoadsResponse, error) {
	requestDef := GenReqDefForListWorkLoads()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWorkLoadsResponse), nil
	}
}

// ListWorkLoadsInvoker 查询集群下某一命名空间下的工作负载
func (c *HssClient) ListWorkLoadsInvoker(request *model.ListWorkLoadsRequest) *ListWorkLoadsInvoker {
	requestDef := GenReqDefForListWorkLoads()
	return &ListWorkLoadsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ModifyDecoyPortPolicy 编辑动态端口蜜罐策略
//
// 编辑动态端口蜜罐策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ModifyDecoyPortPolicy(request *model.ModifyDecoyPortPolicyRequest) (*model.ModifyDecoyPortPolicyResponse, error) {
	requestDef := GenReqDefForModifyDecoyPortPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ModifyDecoyPortPolicyResponse), nil
	}
}

// ModifyDecoyPortPolicyInvoker 编辑动态端口蜜罐策略
func (c *HssClient) ModifyDecoyPortPolicyInvoker(request *model.ModifyDecoyPortPolicyRequest) *ModifyDecoyPortPolicyInvoker {
	requestDef := GenReqDefForModifyDecoyPortPolicy()
	return &ModifyDecoyPortPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RemoveAlarmWhiteList 删除告警白名单
//
// 删除告警白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RemoveAlarmWhiteList(request *model.RemoveAlarmWhiteListRequest) (*model.RemoveAlarmWhiteListResponse, error) {
	requestDef := GenReqDefForRemoveAlarmWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RemoveAlarmWhiteListResponse), nil
	}
}

// RemoveAlarmWhiteListInvoker 删除告警白名单
func (c *HssClient) RemoveAlarmWhiteListInvoker(request *model.RemoveAlarmWhiteListRequest) *RemoveAlarmWhiteListInvoker {
	requestDef := GenReqDefForRemoveAlarmWhiteList()
	return &RemoveAlarmWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RemoveLoginWhiteList 删除登录白名单
//
// 删除登录白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RemoveLoginWhiteList(request *model.RemoveLoginWhiteListRequest) (*model.RemoveLoginWhiteListResponse, error) {
	requestDef := GenReqDefForRemoveLoginWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RemoveLoginWhiteListResponse), nil
	}
}

// RemoveLoginWhiteListInvoker 删除登录白名单
func (c *HssClient) RemoveLoginWhiteListInvoker(request *model.RemoveLoginWhiteListRequest) *RemoveLoginWhiteListInvoker {
	requestDef := GenReqDefForRemoveLoginWhiteList()
	return &RemoveLoginWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RemoveSystemUserWhiteList 删除系统用户白名单
//
// 删除系统用户白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RemoveSystemUserWhiteList(request *model.RemoveSystemUserWhiteListRequest) (*model.RemoveSystemUserWhiteListResponse, error) {
	requestDef := GenReqDefForRemoveSystemUserWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RemoveSystemUserWhiteListResponse), nil
	}
}

// RemoveSystemUserWhiteListInvoker 删除系统用户白名单
func (c *HssClient) RemoveSystemUserWhiteListInvoker(request *model.RemoveSystemUserWhiteListRequest) *RemoveSystemUserWhiteListInvoker {
	requestDef := GenReqDefForRemoveSystemUserWhiteList()
	return &RemoveSystemUserWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RunHostAssetManualCollect 采集单主机资产指纹
//
// 采集单主机资产指纹
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RunHostAssetManualCollect(request *model.RunHostAssetManualCollectRequest) (*model.RunHostAssetManualCollectResponse, error) {
	requestDef := GenReqDefForRunHostAssetManualCollect()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RunHostAssetManualCollectResponse), nil
	}
}

// RunHostAssetManualCollectInvoker 采集单主机资产指纹
func (c *HssClient) RunHostAssetManualCollectInvoker(request *model.RunHostAssetManualCollectRequest) *RunHostAssetManualCollectInvoker {
	requestDef := GenReqDefForRunHostAssetManualCollect()
	return &RunHostAssetManualCollectInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SetMalwareReminders 设置提示信息配置
//
// 设置提示信息配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SetMalwareReminders(request *model.SetMalwareRemindersRequest) (*model.SetMalwareRemindersResponse, error) {
	requestDef := GenReqDefForSetMalwareReminders()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SetMalwareRemindersResponse), nil
	}
}

// SetMalwareRemindersInvoker 设置提示信息配置
func (c *HssClient) SetMalwareRemindersInvoker(request *model.SetMalwareRemindersRequest) *SetMalwareRemindersInvoker {
	requestDef := GenReqDefForSetMalwareReminders()
	return &SetMalwareRemindersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAccountTop 资产管理-概览-账户Top
//
// 资产管理-概览-账户Top
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAccountTop(request *model.ShowAccountTopRequest) (*model.ShowAccountTopResponse, error) {
	requestDef := GenReqDefForShowAccountTop()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAccountTopResponse), nil
	}
}

// ShowAccountTopInvoker 资产管理-概览-账户Top
func (c *HssClient) ShowAccountTopInvoker(request *model.ShowAccountTopRequest) *ShowAccountTopInvoker {
	requestDef := GenReqDefForShowAccountTop()
	return &ShowAccountTopInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAgentStatisticsStatus 资产管理-概览-资产状态-主机Agent状态
//
// 资产管理-概览-资产状态-主机Agent状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAgentStatisticsStatus(request *model.ShowAgentStatisticsStatusRequest) (*model.ShowAgentStatisticsStatusResponse, error) {
	requestDef := GenReqDefForShowAgentStatisticsStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAgentStatisticsStatusResponse), nil
	}
}

// ShowAgentStatisticsStatusInvoker 资产管理-概览-资产状态-主机Agent状态
func (c *HssClient) ShowAgentStatisticsStatusInvoker(request *model.ShowAgentStatisticsStatusRequest) *ShowAgentStatisticsStatusInvoker {
	requestDef := GenReqDefForShowAgentStatisticsStatus()
	return &ShowAgentStatisticsStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAppRaspSwitchStatus 查询应用防护开启状态
//
// 查询应用防护开启状态：查询单台服务器的应用防护功能开启状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAppRaspSwitchStatus(request *model.ShowAppRaspSwitchStatusRequest) (*model.ShowAppRaspSwitchStatusResponse, error) {
	requestDef := GenReqDefForShowAppRaspSwitchStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAppRaspSwitchStatusResponse), nil
	}
}

// ShowAppRaspSwitchStatusInvoker 查询应用防护开启状态
func (c *HssClient) ShowAppRaspSwitchStatusInvoker(request *model.ShowAppRaspSwitchStatusRequest) *ShowAppRaspSwitchStatusInvoker {
	requestDef := GenReqDefForShowAppRaspSwitchStatus()
	return &ShowAppRaspSwitchStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAssetStatistic 统计资产信息数量
//
// 资产统计信息，账号、端口、进程等
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAssetStatistic(request *model.ShowAssetStatisticRequest) (*model.ShowAssetStatisticResponse, error) {
	requestDef := GenReqDefForShowAssetStatistic()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAssetStatisticResponse), nil
	}
}

// ShowAssetStatisticInvoker 统计资产信息数量
func (c *HssClient) ShowAssetStatisticInvoker(request *model.ShowAssetStatisticRequest) *ShowAssetStatisticInvoker {
	requestDef := GenReqDefForShowAssetStatistic()
	return &ShowAssetStatisticInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAutoLaunchTop 资产管理-概览-自启动项Top
//
// 资产管理-概览-自启动项Top
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAutoLaunchTop(request *model.ShowAutoLaunchTopRequest) (*model.ShowAutoLaunchTopResponse, error) {
	requestDef := GenReqDefForShowAutoLaunchTop()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAutoLaunchTopResponse), nil
	}
}

// ShowAutoLaunchTopInvoker 资产管理-概览-自启动项Top
func (c *HssClient) ShowAutoLaunchTopInvoker(request *model.ShowAutoLaunchTopRequest) *ShowAutoLaunchTopInvoker {
	requestDef := GenReqDefForShowAutoLaunchTop()
	return &ShowAutoLaunchTopInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowClusterAssetStatistics 查询集群资产统计数量
//
// 查询集群资产统计数量
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowClusterAssetStatistics(request *model.ShowClusterAssetStatisticsRequest) (*model.ShowClusterAssetStatisticsResponse, error) {
	requestDef := GenReqDefForShowClusterAssetStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowClusterAssetStatisticsResponse), nil
	}
}

// ShowClusterAssetStatisticsInvoker 查询集群资产统计数量
func (c *HssClient) ShowClusterAssetStatisticsInvoker(request *model.ShowClusterAssetStatisticsRequest) *ShowClusterAssetStatisticsInvoker {
	requestDef := GenReqDefForShowClusterAssetStatistics()
	return &ShowClusterAssetStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowClusterProtectPolicyTemplate 查询集群组件防护策略模板
//
// 查询集群防护策略模板
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowClusterProtectPolicyTemplate(request *model.ShowClusterProtectPolicyTemplateRequest) (*model.ShowClusterProtectPolicyTemplateResponse, error) {
	requestDef := GenReqDefForShowClusterProtectPolicyTemplate()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowClusterProtectPolicyTemplateResponse), nil
	}
}

// ShowClusterProtectPolicyTemplateInvoker 查询集群组件防护策略模板
func (c *HssClient) ShowClusterProtectPolicyTemplateInvoker(request *model.ShowClusterProtectPolicyTemplateRequest) *ShowClusterProtectPolicyTemplateInvoker {
	requestDef := GenReqDefForShowClusterProtectPolicyTemplate()
	return &ShowClusterProtectPolicyTemplateInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowCommonPort 查询某一端口的描述信息
//
// 呈现某一端口详细信息，如本地端口：80，类型：TCP，危险程度：正常，端口描述：常用于SSH(SecureShell)-远程登录协议，用于安全登录文件传输（SCP，SFTP）及端口重新定向。
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowCommonPort(request *model.ShowCommonPortRequest) (*model.ShowCommonPortResponse, error) {
	requestDef := GenReqDefForShowCommonPort()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowCommonPortResponse), nil
	}
}

// ShowCommonPortInvoker 查询某一端口的描述信息
func (c *HssClient) ShowCommonPortInvoker(request *model.ShowCommonPortRequest) *ShowCommonPortInvoker {
	requestDef := GenReqDefForShowCommonPort()
	return &ShowCommonPortInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowContainerNetworkInfo 查询容器集群网络的网络信息
//
// 查询容器集群网络的网络信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowContainerNetworkInfo(request *model.ShowContainerNetworkInfoRequest) (*model.ShowContainerNetworkInfoResponse, error) {
	requestDef := GenReqDefForShowContainerNetworkInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowContainerNetworkInfoResponse), nil
	}
}

// ShowContainerNetworkInfoInvoker 查询容器集群网络的网络信息
func (c *HssClient) ShowContainerNetworkInfoInvoker(request *model.ShowContainerNetworkInfoRequest) *ShowContainerNetworkInfoInvoker {
	requestDef := GenReqDefForShowContainerNetworkInfo()
	return &ShowContainerNetworkInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowContainerNodeStatistics 查询容器节点防护总览数据
//
// 查询容器节点防护总览数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowContainerNodeStatistics(request *model.ShowContainerNodeStatisticsRequest) (*model.ShowContainerNodeStatisticsResponse, error) {
	requestDef := GenReqDefForShowContainerNodeStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowContainerNodeStatisticsResponse), nil
	}
}

// ShowContainerNodeStatisticsInvoker 查询容器节点防护总览数据
func (c *HssClient) ShowContainerNodeStatisticsInvoker(request *model.ShowContainerNodeStatisticsRequest) *ShowContainerNodeStatisticsInvoker {
	requestDef := GenReqDefForShowContainerNodeStatistics()
	return &ShowContainerNodeStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowContainerProtectionStatus 资产管理-概览-资产状态-容器节点防护状态
//
// 资产管理-概览-资产状态-容器节点防护状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowContainerProtectionStatus(request *model.ShowContainerProtectionStatusRequest) (*model.ShowContainerProtectionStatusResponse, error) {
	requestDef := GenReqDefForShowContainerProtectionStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowContainerProtectionStatusResponse), nil
	}
}

// ShowContainerProtectionStatusInvoker 资产管理-概览-资产状态-容器节点防护状态
func (c *HssClient) ShowContainerProtectionStatusInvoker(request *model.ShowContainerProtectionStatusRequest) *ShowContainerProtectionStatusInvoker {
	requestDef := GenReqDefForShowContainerProtectionStatus()
	return &ShowContainerProtectionStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowDecoyPortAutoBind 查看默认为新增主机开启防护开关
//
// 查看默认为新增主机开启防护开关
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowDecoyPortAutoBind(request *model.ShowDecoyPortAutoBindRequest) (*model.ShowDecoyPortAutoBindResponse, error) {
	requestDef := GenReqDefForShowDecoyPortAutoBind()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowDecoyPortAutoBindResponse), nil
	}
}

// ShowDecoyPortAutoBindInvoker 查看默认为新增主机开启防护开关
func (c *HssClient) ShowDecoyPortAutoBindInvoker(request *model.ShowDecoyPortAutoBindRequest) *ShowDecoyPortAutoBindInvoker {
	requestDef := GenReqDefForShowDecoyPortAutoBind()
	return &ShowDecoyPortAutoBindInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowDecoyPortHostList 查看开启防护主机列表
//
// 查看开启防护主机列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowDecoyPortHostList(request *model.ShowDecoyPortHostListRequest) (*model.ShowDecoyPortHostListResponse, error) {
	requestDef := GenReqDefForShowDecoyPortHostList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowDecoyPortHostListResponse), nil
	}
}

// ShowDecoyPortHostListInvoker 查看开启防护主机列表
func (c *HssClient) ShowDecoyPortHostListInvoker(request *model.ShowDecoyPortHostListRequest) *ShowDecoyPortHostListInvoker {
	requestDef := GenReqDefForShowDecoyPortHostList()
	return &ShowDecoyPortHostListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowDecoyPortPolicyDetails 查看动态端口蜜罐策略详情
//
// 查看动态端口蜜罐策略详情
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowDecoyPortPolicyDetails(request *model.ShowDecoyPortPolicyDetailsRequest) (*model.ShowDecoyPortPolicyDetailsResponse, error) {
	requestDef := GenReqDefForShowDecoyPortPolicyDetails()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowDecoyPortPolicyDetailsResponse), nil
	}
}

// ShowDecoyPortPolicyDetailsInvoker 查看动态端口蜜罐策略详情
func (c *HssClient) ShowDecoyPortPolicyDetailsInvoker(request *model.ShowDecoyPortPolicyDetailsRequest) *ShowDecoyPortPolicyDetailsInvoker {
	requestDef := GenReqDefForShowDecoyPortPolicyDetails()
	return &ShowDecoyPortPolicyDetailsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowEventAttackTag 查询攻击标识分布统计列表
//
// 查询攻击标识分布统计列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowEventAttackTag(request *model.ShowEventAttackTagRequest) (*model.ShowEventAttackTagResponse, error) {
	requestDef := GenReqDefForShowEventAttackTag()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowEventAttackTagResponse), nil
	}
}

// ShowEventAttackTagInvoker 查询攻击标识分布统计列表
func (c *HssClient) ShowEventAttackTagInvoker(request *model.ShowEventAttackTagRequest) *ShowEventAttackTagInvoker {
	requestDef := GenReqDefForShowEventAttackTag()
	return &ShowEventAttackTagInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowEventSeverity 查询威胁等级统计列表
//
// 查询威胁等级统计列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowEventSeverity(request *model.ShowEventSeverityRequest) (*model.ShowEventSeverityResponse, error) {
	requestDef := GenReqDefForShowEventSeverity()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowEventSeverityResponse), nil
	}
}

// ShowEventSeverityInvoker 查询威胁等级统计列表
func (c *HssClient) ShowEventSeverityInvoker(request *model.ShowEventSeverityRequest) *ShowEventSeverityInvoker {
	requestDef := GenReqDefForShowEventSeverity()
	return &ShowEventSeverityInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowExportTask 查询导出任务信息
//
// 查询导出任务信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowExportTask(request *model.ShowExportTaskRequest) (*model.ShowExportTaskResponse, error) {
	requestDef := GenReqDefForShowExportTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowExportTaskResponse), nil
	}
}

// ShowExportTaskInvoker 查询导出任务信息
func (c *HssClient) ShowExportTaskInvoker(request *model.ShowExportTaskRequest) *ShowExportTaskInvoker {
	requestDef := GenReqDefForShowExportTask()
	return &ShowExportTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowHostAssetManualCollectStatus 查询单主机资产指纹采集状态
//
// 查询单主机资产指纹采集状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowHostAssetManualCollectStatus(request *model.ShowHostAssetManualCollectStatusRequest) (*model.ShowHostAssetManualCollectStatusResponse, error) {
	requestDef := GenReqDefForShowHostAssetManualCollectStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowHostAssetManualCollectStatusResponse), nil
	}
}

// ShowHostAssetManualCollectStatusInvoker 查询单主机资产指纹采集状态
func (c *HssClient) ShowHostAssetManualCollectStatusInvoker(request *model.ShowHostAssetManualCollectStatusRequest) *ShowHostAssetManualCollectStatusInvoker {
	requestDef := GenReqDefForShowHostAssetManualCollectStatus()
	return &ShowHostAssetManualCollectStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowHostProtectionStatus 资产管理-概览-资产状态-Agent状态
//
// 资产管理-概览-资产状态-Agent状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowHostProtectionStatus(request *model.ShowHostProtectionStatusRequest) (*model.ShowHostProtectionStatusResponse, error) {
	requestDef := GenReqDefForShowHostProtectionStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowHostProtectionStatusResponse), nil
	}
}

// ShowHostProtectionStatusInvoker 资产管理-概览-资产状态-Agent状态
func (c *HssClient) ShowHostProtectionStatusInvoker(request *model.ShowHostProtectionStatusRequest) *ShowHostProtectionStatusInvoker {
	requestDef := GenReqDefForShowHostProtectionStatus()
	return &ShowHostProtectionStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowJarPackageTop 资产管理-概览-jar包Top
//
// 资产管理-概览-jar包Top
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowJarPackageTop(request *model.ShowJarPackageTopRequest) (*model.ShowJarPackageTopResponse, error) {
	requestDef := GenReqDefForShowJarPackageTop()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowJarPackageTopResponse), nil
	}
}

// ShowJarPackageTopInvoker 资产管理-概览-jar包Top
func (c *HssClient) ShowJarPackageTopInvoker(request *model.ShowJarPackageTopRequest) *ShowJarPackageTopInvoker {
	requestDef := GenReqDefForShowJarPackageTop()
	return &ShowJarPackageTopInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowK8sContainerDetail 查询容器详细信息
//
// 查询容器详细信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowK8sContainerDetail(request *model.ShowK8sContainerDetailRequest) (*model.ShowK8sContainerDetailResponse, error) {
	requestDef := GenReqDefForShowK8sContainerDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowK8sContainerDetailResponse), nil
	}
}

// ShowK8sContainerDetailInvoker 查询容器详细信息
func (c *HssClient) ShowK8sContainerDetailInvoker(request *model.ShowK8sContainerDetailRequest) *ShowK8sContainerDetailInvoker {
	requestDef := GenReqDefForShowK8sContainerDetail()
	return &ShowK8sContainerDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowK8sPodDetail 查询pod详细信息
//
// 查询pod详细信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowK8sPodDetail(request *model.ShowK8sPodDetailRequest) (*model.ShowK8sPodDetailResponse, error) {
	requestDef := GenReqDefForShowK8sPodDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowK8sPodDetailResponse), nil
	}
}

// ShowK8sPodDetailInvoker 查询pod详细信息
func (c *HssClient) ShowK8sPodDetailInvoker(request *model.ShowK8sPodDetailRequest) *ShowK8sPodDetailInvoker {
	requestDef := GenReqDefForShowK8sPodDetail()
	return &ShowK8sPodDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowKernelModuleTop 资产管理-概览-内核模块Top
//
// 资产管理-概览-内核模块Top
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowKernelModuleTop(request *model.ShowKernelModuleTopRequest) (*model.ShowKernelModuleTopResponse, error) {
	requestDef := GenReqDefForShowKernelModuleTop()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowKernelModuleTopResponse), nil
	}
}

// ShowKernelModuleTopInvoker 资产管理-概览-内核模块Top
func (c *HssClient) ShowKernelModuleTopInvoker(request *model.ShowKernelModuleTopRequest) *ShowKernelModuleTopInvoker {
	requestDef := GenReqDefForShowKernelModuleTop()
	return &ShowKernelModuleTopInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowKubernetesEndpointInfo 查询容器Kubernetes端点详情
//
// 查询容器Kubernetes端点详情
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowKubernetesEndpointInfo(request *model.ShowKubernetesEndpointInfoRequest) (*model.ShowKubernetesEndpointInfoResponse, error) {
	requestDef := GenReqDefForShowKubernetesEndpointInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowKubernetesEndpointInfoResponse), nil
	}
}

// ShowKubernetesEndpointInfoInvoker 查询容器Kubernetes端点详情
func (c *HssClient) ShowKubernetesEndpointInfoInvoker(request *model.ShowKubernetesEndpointInfoRequest) *ShowKubernetesEndpointInfoInvoker {
	requestDef := GenReqDefForShowKubernetesEndpointInfo()
	return &ShowKubernetesEndpointInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowKubernetesServiceInfo 查询容器Kubernetes服务详情
//
// 查询容器Kubernetes服务详情
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowKubernetesServiceInfo(request *model.ShowKubernetesServiceInfoRequest) (*model.ShowKubernetesServiceInfoResponse, error) {
	requestDef := GenReqDefForShowKubernetesServiceInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowKubernetesServiceInfoResponse), nil
	}
}

// ShowKubernetesServiceInfoInvoker 查询容器Kubernetes服务详情
func (c *HssClient) ShowKubernetesServiceInfoInvoker(request *model.ShowKubernetesServiceInfoRequest) *ShowKubernetesServiceInfoInvoker {
	requestDef := GenReqDefForShowKubernetesServiceInfo()
	return &ShowKubernetesServiceInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowLatestExportTaskByType 查询导出任务信息
//
// 查询导出任务信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowLatestExportTaskByType(request *model.ShowLatestExportTaskByTypeRequest) (*model.ShowLatestExportTaskByTypeResponse, error) {
	requestDef := GenReqDefForShowLatestExportTaskByType()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowLatestExportTaskByTypeResponse), nil
	}
}

// ShowLatestExportTaskByTypeInvoker 查询导出任务信息
func (c *HssClient) ShowLatestExportTaskByTypeInvoker(request *model.ShowLatestExportTaskByTypeRequest) *ShowLatestExportTaskByTypeInvoker {
	requestDef := GenReqDefForShowLatestExportTaskByType()
	return &ShowLatestExportTaskByTypeInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowMalwareReminders 获取提示信息配置
//
// 获取提示信息配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowMalwareReminders(request *model.ShowMalwareRemindersRequest) (*model.ShowMalwareRemindersResponse, error) {
	requestDef := GenReqDefForShowMalwareReminders()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowMalwareRemindersResponse), nil
	}
}

// ShowMalwareRemindersInvoker 获取提示信息配置
func (c *HssClient) ShowMalwareRemindersInvoker(request *model.ShowMalwareRemindersRequest) *ShowMalwareRemindersInvoker {
	requestDef := GenReqDefForShowMalwareReminders()
	return &ShowMalwareRemindersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowNetworkStatistics 集群网络策略总览
//
// 集群网络策略总览
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowNetworkStatistics(request *model.ShowNetworkStatisticsRequest) (*model.ShowNetworkStatisticsResponse, error) {
	requestDef := GenReqDefForShowNetworkStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowNetworkStatisticsResponse), nil
	}
}

// ShowNetworkStatisticsInvoker 集群网络策略总览
func (c *HssClient) ShowNetworkStatisticsInvoker(request *model.ShowNetworkStatisticsRequest) *ShowNetworkStatisticsInvoker {
	requestDef := GenReqDefForShowNetworkStatistics()
	return &ShowNetworkStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowOsStatisticsInfo 资产管理-概览-资产状态-操作系统统计信息
//
// 资产管理-概览-资产状态-操作系统统计信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowOsStatisticsInfo(request *model.ShowOsStatisticsInfoRequest) (*model.ShowOsStatisticsInfoResponse, error) {
	requestDef := GenReqDefForShowOsStatisticsInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowOsStatisticsInfoResponse), nil
	}
}

// ShowOsStatisticsInfoInvoker 资产管理-概览-资产状态-操作系统统计信息
func (c *HssClient) ShowOsStatisticsInfoInvoker(request *model.ShowOsStatisticsInfoRequest) *ShowOsStatisticsInfoInvoker {
	requestDef := GenReqDefForShowOsStatisticsInfo()
	return &ShowOsStatisticsInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowPageNotices 获取页面通知信息
//
// 获取页面通知信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowPageNotices(request *model.ShowPageNoticesRequest) (*model.ShowPageNoticesResponse, error) {
	requestDef := GenReqDefForShowPageNotices()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowPageNoticesResponse), nil
	}
}

// ShowPageNoticesInvoker 获取页面通知信息
func (c *HssClient) ShowPageNoticesInvoker(request *model.ShowPageNoticesRequest) *ShowPageNoticesInvoker {
	requestDef := GenReqDefForShowPageNotices()
	return &ShowPageNoticesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowPortTop 资产管理-概览-端口Top
//
// 资产管理-概览-端口Top
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowPortTop(request *model.ShowPortTopRequest) (*model.ShowPortTopResponse, error) {
	requestDef := GenReqDefForShowPortTop()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowPortTopResponse), nil
	}
}

// ShowPortTopInvoker 资产管理-概览-端口Top
func (c *HssClient) ShowPortTopInvoker(request *model.ShowPortTopRequest) *ShowPortTopInvoker {
	requestDef := GenReqDefForShowPortTop()
	return &ShowPortTopInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowProcessTop 资产管理-概览-进程Top
//
// 资产管理-概览-进程Top
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowProcessTop(request *model.ShowProcessTopRequest) (*model.ShowProcessTopResponse, error) {
	requestDef := GenReqDefForShowProcessTop()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowProcessTopResponse), nil
	}
}

// ShowProcessTopInvoker 资产管理-概览-进程Top
func (c *HssClient) ShowProcessTopInvoker(request *model.ShowProcessTopRequest) *ShowProcessTopInvoker {
	requestDef := GenReqDefForShowProcessTop()
	return &ShowProcessTopInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowQuotaStatisticsInfo 资产管理-概览-资产状态-防护配额统计信息
//
// 资产管理-概览-资产状态-防护配额统计信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowQuotaStatisticsInfo(request *model.ShowQuotaStatisticsInfoRequest) (*model.ShowQuotaStatisticsInfoResponse, error) {
	requestDef := GenReqDefForShowQuotaStatisticsInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowQuotaStatisticsInfoResponse), nil
	}
}

// ShowQuotaStatisticsInfoInvoker 资产管理-概览-资产状态-防护配额统计信息
func (c *HssClient) ShowQuotaStatisticsInfoInvoker(request *model.ShowQuotaStatisticsInfoRequest) *ShowQuotaStatisticsInfoInvoker {
	requestDef := GenReqDefForShowQuotaStatisticsInfo()
	return &ShowQuotaStatisticsInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowRaspPolicyDetail 查询防护策略详情
//
// 查询防护策略详情：查询防护策略配置的相关检测规则信息，包含14种检测规则
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowRaspPolicyDetail(request *model.ShowRaspPolicyDetailRequest) (*model.ShowRaspPolicyDetailResponse, error) {
	requestDef := GenReqDefForShowRaspPolicyDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowRaspPolicyDetailResponse), nil
	}
}

// ShowRaspPolicyDetailInvoker 查询防护策略详情
func (c *HssClient) ShowRaspPolicyDetailInvoker(request *model.ShowRaspPolicyDetailRequest) *ShowRaspPolicyDetailInvoker {
	requestDef := GenReqDefForShowRaspPolicyDetail()
	return &ShowRaspPolicyDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowRaspProtectStatistics 防护数据统计
//
// 防护数据统计：统计已添加防护服务器的数量以及近七天微服务RASP攻击数量
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowRaspProtectStatistics(request *model.ShowRaspProtectStatisticsRequest) (*model.ShowRaspProtectStatisticsResponse, error) {
	requestDef := GenReqDefForShowRaspProtectStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowRaspProtectStatisticsResponse), nil
	}
}

// ShowRaspProtectStatisticsInvoker 防护数据统计
func (c *HssClient) ShowRaspProtectStatisticsInvoker(request *model.ShowRaspProtectStatisticsRequest) *ShowRaspProtectStatisticsInvoker {
	requestDef := GenReqDefForShowRaspProtectStatistics()
	return &ShowRaspProtectStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowRaspServerDetail 查询防护服务器java应用详情
//
// 查询防护服务器java应用详情：查询防护服务器的java应用状态列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowRaspServerDetail(request *model.ShowRaspServerDetailRequest) (*model.ShowRaspServerDetailResponse, error) {
	requestDef := GenReqDefForShowRaspServerDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowRaspServerDetailResponse), nil
	}
}

// ShowRaspServerDetailInvoker 查询防护服务器java应用详情
func (c *HssClient) ShowRaspServerDetailInvoker(request *model.ShowRaspServerDetailRequest) *ShowRaspServerDetailInvoker {
	requestDef := GenReqDefForShowRaspServerDetail()
	return &ShowRaspServerDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowSoftwareTop 资产管理-概览-软件Top
//
// 资产管理-概览-软件Top
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowSoftwareTop(request *model.ShowSoftwareTopRequest) (*model.ShowSoftwareTopResponse, error) {
	requestDef := GenReqDefForShowSoftwareTop()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowSoftwareTopResponse), nil
	}
}

// ShowSoftwareTopInvoker 资产管理-概览-软件Top
func (c *HssClient) ShowSoftwareTopInvoker(request *model.ShowSoftwareTopRequest) *ShowSoftwareTopInvoker {
	requestDef := GenReqDefForShowSoftwareTop()
	return &ShowSoftwareTopInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowWebAppAndServiceTop 资产管理-概览-WebAppAndServiceTop
//
// 资产管理-概览-Web应用TOP5/Web服务TOP5
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowWebAppAndServiceTop(request *model.ShowWebAppAndServiceTopRequest) (*model.ShowWebAppAndServiceTopResponse, error) {
	requestDef := GenReqDefForShowWebAppAndServiceTop()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowWebAppAndServiceTopResponse), nil
	}
}

// ShowWebAppAndServiceTopInvoker 资产管理-概览-WebAppAndServiceTop
func (c *HssClient) ShowWebAppAndServiceTopInvoker(request *model.ShowWebAppAndServiceTopRequest) *ShowWebAppAndServiceTopInvoker {
	requestDef := GenReqDefForShowWebAppAndServiceTop()
	return &ShowWebAppAndServiceTopInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowWebFrameworkTop 资产管理-概览-Web框架Top
//
// 资产管理-概览-Web框架Top
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowWebFrameworkTop(request *model.ShowWebFrameworkTopRequest) (*model.ShowWebFrameworkTopResponse, error) {
	requestDef := GenReqDefForShowWebFrameworkTop()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowWebFrameworkTopResponse), nil
	}
}

// ShowWebFrameworkTopInvoker 资产管理-概览-Web框架Top
func (c *HssClient) ShowWebFrameworkTopInvoker(request *model.ShowWebFrameworkTopRequest) *ShowWebFrameworkTopInvoker {
	requestDef := GenReqDefForShowWebFrameworkTop()
	return &ShowWebFrameworkTopInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowWebSiteTop 资产管理-概览-Web站点Top
//
// 资产管理-概览-Web站点Top
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowWebSiteTop(request *model.ShowWebSiteTopRequest) (*model.ShowWebSiteTopResponse, error) {
	requestDef := GenReqDefForShowWebSiteTop()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowWebSiteTopResponse), nil
	}
}

// ShowWebSiteTopInvoker 资产管理-概览-Web站点Top
func (c *HssClient) ShowWebSiteTopInvoker(request *model.ShowWebSiteTopRequest) *ShowWebSiteTopInvoker {
	requestDef := GenReqDefForShowWebSiteTop()
	return &ShowWebSiteTopInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchClusterProtectionMode 操作集群防护模式
//
// 操作集群防护模式
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchClusterProtectionMode(request *model.SwitchClusterProtectionModeRequest) (*model.SwitchClusterProtectionModeResponse, error) {
	requestDef := GenReqDefForSwitchClusterProtectionMode()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchClusterProtectionModeResponse), nil
	}
}

// SwitchClusterProtectionModeInvoker 操作集群防护模式
func (c *HssClient) SwitchClusterProtectionModeInvoker(request *model.SwitchClusterProtectionModeRequest) *SwitchClusterProtectionModeInvoker {
	requestDef := GenReqDefForSwitchClusterProtectionMode()
	return &SwitchClusterProtectionModeInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchContainerProtectStatus 切换防护状态
//
// 切换防护状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchContainerProtectStatus(request *model.SwitchContainerProtectStatusRequest) (*model.SwitchContainerProtectStatusResponse, error) {
	requestDef := GenReqDefForSwitchContainerProtectStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchContainerProtectStatusResponse), nil
	}
}

// SwitchContainerProtectStatusInvoker 切换防护状态
func (c *HssClient) SwitchContainerProtectStatusInvoker(request *model.SwitchContainerProtectStatusRequest) *SwitchContainerProtectStatusInvoker {
	requestDef := GenReqDefForSwitchContainerProtectStatus()
	return &SwitchContainerProtectStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchDecoyPortAutoBind 修改默认为新增主机开启防护开关
//
// 修改默认为新增主机开启防护开关
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchDecoyPortAutoBind(request *model.SwitchDecoyPortAutoBindRequest) (*model.SwitchDecoyPortAutoBindResponse, error) {
	requestDef := GenReqDefForSwitchDecoyPortAutoBind()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchDecoyPortAutoBindResponse), nil
	}
}

// SwitchDecoyPortAutoBindInvoker 修改默认为新增主机开启防护开关
func (c *HssClient) SwitchDecoyPortAutoBindInvoker(request *model.SwitchDecoyPortAutoBindRequest) *SwitchDecoyPortAutoBindInvoker {
	requestDef := GenReqDefForSwitchDecoyPortAutoBind()
	return &SwitchDecoyPortAutoBindInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchDecoyPortHostPolicy 切换主机动态端口蜜罐策略
//
// 切换主机动态端口蜜罐策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchDecoyPortHostPolicy(request *model.SwitchDecoyPortHostPolicyRequest) (*model.SwitchDecoyPortHostPolicyResponse, error) {
	requestDef := GenReqDefForSwitchDecoyPortHostPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchDecoyPortHostPolicyResponse), nil
	}
}

// SwitchDecoyPortHostPolicyInvoker 切换主机动态端口蜜罐策略
func (c *HssClient) SwitchDecoyPortHostPolicyInvoker(request *model.SwitchDecoyPortHostPolicyRequest) *SwitchDecoyPortHostPolicyInvoker {
	requestDef := GenReqDefForSwitchDecoyPortHostPolicy()
	return &SwitchDecoyPortHostPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchDecoyPortPolicy 启用动态端口蜜罐策略
//
// 启用动态端口蜜罐策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchDecoyPortPolicy(request *model.SwitchDecoyPortPolicyRequest) (*model.SwitchDecoyPortPolicyResponse, error) {
	requestDef := GenReqDefForSwitchDecoyPortPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchDecoyPortPolicyResponse), nil
	}
}

// SwitchDecoyPortPolicyInvoker 启用动态端口蜜罐策略
func (c *HssClient) SwitchDecoyPortPolicyInvoker(request *model.SwitchDecoyPortPolicyRequest) *SwitchDecoyPortPolicyInvoker {
	requestDef := GenReqDefForSwitchDecoyPortPolicy()
	return &SwitchDecoyPortPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchRasp 开启/关闭应用防护，更新防护端口
//
// 开启/关闭应用防护，选择开启的防护策略，选择需要防护的服务器，下发防护策略，可传入端口号更新防护端口，关闭防护则清空策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchRasp(request *model.SwitchRaspRequest) (*model.SwitchRaspResponse, error) {
	requestDef := GenReqDefForSwitchRasp()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchRaspResponse), nil
	}
}

// SwitchRaspInvoker 开启/关闭应用防护，更新防护端口
func (c *HssClient) SwitchRaspInvoker(request *model.SwitchRaspRequest) *SwitchRaspInvoker {
	requestDef := GenReqDefForSwitchRasp()
	return &SwitchRaspInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SyncClusterList 同步容器集群最新数据
//
// 同步容器集群最新数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SyncClusterList(request *model.SyncClusterListRequest) (*model.SyncClusterListResponse, error) {
	requestDef := GenReqDefForSyncClusterList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SyncClusterListResponse), nil
	}
}

// SyncClusterListInvoker 同步容器集群最新数据
func (c *HssClient) SyncClusterListInvoker(request *model.SyncClusterListRequest) *SyncClusterListInvoker {
	requestDef := GenReqDefForSyncClusterList()
	return &SyncClusterListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SyncClusterProtectionEvent 同步集群防护事件
//
// 同步集群防护事件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SyncClusterProtectionEvent(request *model.SyncClusterProtectionEventRequest) (*model.SyncClusterProtectionEventResponse, error) {
	requestDef := GenReqDefForSyncClusterProtectionEvent()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SyncClusterProtectionEventResponse), nil
	}
}

// SyncClusterProtectionEventInvoker 同步集群防护事件
func (c *HssClient) SyncClusterProtectionEventInvoker(request *model.SyncClusterProtectionEventRequest) *SyncClusterProtectionEventInvoker {
	requestDef := GenReqDefForSyncClusterProtectionEvent()
	return &SyncClusterProtectionEventInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SyncContainerNetworkNode 同步集群下网络节点最新数据
//
// 同步集群下容器网络策略最新数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SyncContainerNetworkNode(request *model.SyncContainerNetworkNodeRequest) (*model.SyncContainerNetworkNodeResponse, error) {
	requestDef := GenReqDefForSyncContainerNetworkNode()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SyncContainerNetworkNodeResponse), nil
	}
}

// SyncContainerNetworkNodeInvoker 同步集群下网络节点最新数据
func (c *HssClient) SyncContainerNetworkNodeInvoker(request *model.SyncContainerNetworkNodeRequest) *SyncContainerNetworkNodeInvoker {
	requestDef := GenReqDefForSyncContainerNetworkNode()
	return &SyncContainerNetworkNodeInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SyncContainerNetworkPolicyList 同步集群下容器网络策略最新数据
//
// 同步集群下容器网络策略最新数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SyncContainerNetworkPolicyList(request *model.SyncContainerNetworkPolicyListRequest) (*model.SyncContainerNetworkPolicyListResponse, error) {
	requestDef := GenReqDefForSyncContainerNetworkPolicyList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SyncContainerNetworkPolicyListResponse), nil
	}
}

// SyncContainerNetworkPolicyListInvoker 同步集群下容器网络策略最新数据
func (c *HssClient) SyncContainerNetworkPolicyListInvoker(request *model.SyncContainerNetworkPolicyListRequest) *SyncContainerNetworkPolicyListInvoker {
	requestDef := GenReqDefForSyncContainerNetworkPolicyList()
	return &SyncContainerNetworkPolicyListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SyncSecurityGroupPolicies 同步集群下安全组策略最新数据
//
// 同步集群下安全组策略最新数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SyncSecurityGroupPolicies(request *model.SyncSecurityGroupPoliciesRequest) (*model.SyncSecurityGroupPoliciesResponse, error) {
	requestDef := GenReqDefForSyncSecurityGroupPolicies()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SyncSecurityGroupPoliciesResponse), nil
	}
}

// SyncSecurityGroupPoliciesInvoker 同步集群下安全组策略最新数据
func (c *HssClient) SyncSecurityGroupPoliciesInvoker(request *model.SyncSecurityGroupPoliciesRequest) *SyncSecurityGroupPoliciesInvoker {
	requestDef := GenReqDefForSyncSecurityGroupPolicies()
	return &SyncSecurityGroupPoliciesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateContainerNetworkPolicy 容器集群网络更新配置策略
//
// 容器集群网络更新配置策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateContainerNetworkPolicy(request *model.UpdateContainerNetworkPolicyRequest) (*model.UpdateContainerNetworkPolicyResponse, error) {
	requestDef := GenReqDefForUpdateContainerNetworkPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateContainerNetworkPolicyResponse), nil
	}
}

// UpdateContainerNetworkPolicyInvoker 容器集群网络更新配置策略
func (c *HssClient) UpdateContainerNetworkPolicyInvoker(request *model.UpdateContainerNetworkPolicyRequest) *UpdateContainerNetworkPolicyInvoker {
	requestDef := GenReqDefForUpdateContainerNetworkPolicy()
	return &UpdateContainerNetworkPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdatePolicy 修改防护策略
//
// 修改防护策略：修改防护策略内容，包含策略名称、相关规则开启状态、防护动作以及检测规则配置，同时给使用该策略的服务器下发新的策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdatePolicy(request *model.UpdatePolicyRequest) (*model.UpdatePolicyResponse, error) {
	requestDef := GenReqDefForUpdatePolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdatePolicyResponse), nil
	}
}

// UpdatePolicyInvoker 修改防护策略
func (c *HssClient) UpdatePolicyInvoker(request *model.UpdatePolicyRequest) *UpdatePolicyInvoker {
	requestDef := GenReqDefForUpdatePolicy()
	return &UpdatePolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateSecurityGroupPolicy 更新安全组策略
//
// 更新安全组策略(云原生网络模型)
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateSecurityGroupPolicy(request *model.UpdateSecurityGroupPolicyRequest) (*model.UpdateSecurityGroupPolicyResponse, error) {
	requestDef := GenReqDefForUpdateSecurityGroupPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateSecurityGroupPolicyResponse), nil
	}
}

// UpdateSecurityGroupPolicyInvoker 更新安全组策略
func (c *HssClient) UpdateSecurityGroupPolicyInvoker(request *model.UpdateSecurityGroupPolicyRequest) *UpdateSecurityGroupPolicyInvoker {
	requestDef := GenReqDefForUpdateSecurityGroupPolicy()
	return &UpdateSecurityGroupPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateSystemUserWhiteList 修改系统用户白名单
//
// 修改系统用户白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateSystemUserWhiteList(request *model.UpdateSystemUserWhiteListRequest) (*model.UpdateSystemUserWhiteListResponse, error) {
	requestDef := GenReqDefForUpdateSystemUserWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateSystemUserWhiteListResponse), nil
	}
}

// UpdateSystemUserWhiteListInvoker 修改系统用户白名单
func (c *HssClient) UpdateSystemUserWhiteListInvoker(request *model.UpdateSystemUserWhiteListRequest) *UpdateSystemUserWhiteListInvoker {
	requestDef := GenReqDefForUpdateSystemUserWhiteList()
	return &UpdateSystemUserWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ValidateAdmin 校验当前账号是否是管理员账号（包含组织管理员和委托管理员）
//
// 校验当前账号是否是管理员账号（包含组织管理员和委托管理员）
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ValidateAdmin(request *model.ValidateAdminRequest) (*model.ValidateAdminResponse, error) {
	requestDef := GenReqDefForValidateAdmin()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ValidateAdminResponse), nil
	}
}

// ValidateAdminInvoker 校验当前账号是否是管理员账号（包含组织管理员和委托管理员）
func (c *HssClient) ValidateAdminInvoker(request *model.ValidateAdminRequest) *ValidateAdminInvoker {
	requestDef := GenReqDefForValidateAdmin()
	return &ValidateAdminInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeAntivirusPayPerScanStatus 修改“病毒查杀按次计费”开关状态
//
// 修改“病毒查杀按次计费”开关状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeAntivirusPayPerScanStatus(request *model.ChangeAntivirusPayPerScanStatusRequest) (*model.ChangeAntivirusPayPerScanStatusResponse, error) {
	requestDef := GenReqDefForChangeAntivirusPayPerScanStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeAntivirusPayPerScanStatusResponse), nil
	}
}

// ChangeAntivirusPayPerScanStatusInvoker 修改“病毒查杀按次计费”开关状态
func (c *HssClient) ChangeAntivirusPayPerScanStatusInvoker(request *model.ChangeAntivirusPayPerScanStatusRequest) *ChangeAntivirusPayPerScanStatusInvoker {
	requestDef := GenReqDefForChangeAntivirusPayPerScanStatus()
	return &ChangeAntivirusPayPerScanStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeAntivirusPolicy 编辑自定义查杀策略
//
// 编辑自定义查杀策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeAntivirusPolicy(request *model.ChangeAntivirusPolicyRequest) (*model.ChangeAntivirusPolicyResponse, error) {
	requestDef := GenReqDefForChangeAntivirusPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeAntivirusPolicyResponse), nil
	}
}

// ChangeAntivirusPolicyInvoker 编辑自定义查杀策略
func (c *HssClient) ChangeAntivirusPolicyInvoker(request *model.ChangeAntivirusPolicyRequest) *ChangeAntivirusPolicyInvoker {
	requestDef := GenReqDefForChangeAntivirusPolicy()
	return &ChangeAntivirusPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateAntiVirusPaidTask 创建付费病毒扫描任务
//
// 创建付费病毒扫描任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateAntiVirusPaidTask(request *model.CreateAntiVirusPaidTaskRequest) (*model.CreateAntiVirusPaidTaskResponse, error) {
	requestDef := GenReqDefForCreateAntiVirusPaidTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateAntiVirusPaidTaskResponse), nil
	}
}

// CreateAntiVirusPaidTaskInvoker 创建付费病毒扫描任务
func (c *HssClient) CreateAntiVirusPaidTaskInvoker(request *model.CreateAntiVirusPaidTaskRequest) *CreateAntiVirusPaidTaskInvoker {
	requestDef := GenReqDefForCreateAntiVirusPaidTask()
	return &CreateAntiVirusPaidTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateAntiVirusPolicy 创建自定义查杀策略
//
// 创建自定义查杀策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateAntiVirusPolicy(request *model.CreateAntiVirusPolicyRequest) (*model.CreateAntiVirusPolicyResponse, error) {
	requestDef := GenReqDefForCreateAntiVirusPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateAntiVirusPolicyResponse), nil
	}
}

// CreateAntiVirusPolicyInvoker 创建自定义查杀策略
func (c *HssClient) CreateAntiVirusPolicyInvoker(request *model.CreateAntiVirusPolicyRequest) *CreateAntiVirusPolicyInvoker {
	requestDef := GenReqDefForCreateAntiVirusPolicy()
	return &CreateAntiVirusPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateAntiVirusTask 创建病毒扫描任务
//
// 创建病毒扫描任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateAntiVirusTask(request *model.CreateAntiVirusTaskRequest) (*model.CreateAntiVirusTaskResponse, error) {
	requestDef := GenReqDefForCreateAntiVirusTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateAntiVirusTaskResponse), nil
	}
}

// CreateAntiVirusTaskInvoker 创建病毒扫描任务
func (c *HssClient) CreateAntiVirusTaskInvoker(request *model.CreateAntiVirusTaskRequest) *CreateAntiVirusTaskInvoker {
	requestDef := GenReqDefForCreateAntiVirusTask()
	return &CreateAntiVirusTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteAntivirusPolicy 删除自定义查杀策略
//
// 删除自定义查杀策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteAntivirusPolicy(request *model.DeleteAntivirusPolicyRequest) (*model.DeleteAntivirusPolicyResponse, error) {
	requestDef := GenReqDefForDeleteAntivirusPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteAntivirusPolicyResponse), nil
	}
}

// DeleteAntivirusPolicyInvoker 删除自定义查杀策略
func (c *HssClient) DeleteAntivirusPolicyInvoker(request *model.DeleteAntivirusPolicyRequest) *DeleteAntivirusPolicyInvoker {
	requestDef := GenReqDefForDeleteAntivirusPolicy()
	return &DeleteAntivirusPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportAntiVirusResult 导出病毒扫描结果列表
//
// 导出病毒扫描结果列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportAntiVirusResult(request *model.ExportAntiVirusResultRequest) (*model.ExportAntiVirusResultResponse, error) {
	requestDef := GenReqDefForExportAntiVirusResult()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportAntiVirusResultResponse), nil
	}
}

// ExportAntiVirusResultInvoker 导出病毒扫描结果列表
func (c *HssClient) ExportAntiVirusResultInvoker(request *model.ExportAntiVirusResultRequest) *ExportAntiVirusResultInvoker {
	requestDef := GenReqDefForExportAntiVirusResult()
	return &ExportAntiVirusResultInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// HandleAntiVirusResult 处置病毒扫描结果
//
// 处置病毒扫描结果
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) HandleAntiVirusResult(request *model.HandleAntiVirusResultRequest) (*model.HandleAntiVirusResultResponse, error) {
	requestDef := GenReqDefForHandleAntiVirusResult()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.HandleAntiVirusResultResponse), nil
	}
}

// HandleAntiVirusResultInvoker 处置病毒扫描结果
func (c *HssClient) HandleAntiVirusResultInvoker(request *model.HandleAntiVirusResultRequest) *HandleAntiVirusResultInvoker {
	requestDef := GenReqDefForHandleAntiVirusResult()
	return &HandleAntiVirusResultInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAntiVirusHost 查询病毒查杀可选服务器列表
//
// 查询病毒查杀可选服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAntiVirusHost(request *model.ListAntiVirusHostRequest) (*model.ListAntiVirusHostResponse, error) {
	requestDef := GenReqDefForListAntiVirusHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAntiVirusHostResponse), nil
	}
}

// ListAntiVirusHostInvoker 查询病毒查杀可选服务器列表
func (c *HssClient) ListAntiVirusHostInvoker(request *model.ListAntiVirusHostRequest) *ListAntiVirusHostInvoker {
	requestDef := GenReqDefForListAntiVirusHost()
	return &ListAntiVirusHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAntiVirusPaidHosts 查询付费病毒查杀服务器列表
//
// 查询付费病毒查杀服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAntiVirusPaidHosts(request *model.ListAntiVirusPaidHostsRequest) (*model.ListAntiVirusPaidHostsResponse, error) {
	requestDef := GenReqDefForListAntiVirusPaidHosts()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAntiVirusPaidHostsResponse), nil
	}
}

// ListAntiVirusPaidHostsInvoker 查询付费病毒查杀服务器列表
func (c *HssClient) ListAntiVirusPaidHostsInvoker(request *model.ListAntiVirusPaidHostsRequest) *ListAntiVirusPaidHostsInvoker {
	requestDef := GenReqDefForListAntiVirusPaidHosts()
	return &ListAntiVirusPaidHostsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAntiVirusPolicy 查询自定义查杀策略列表
//
// 查询自定义查杀策略列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAntiVirusPolicy(request *model.ListAntiVirusPolicyRequest) (*model.ListAntiVirusPolicyResponse, error) {
	requestDef := GenReqDefForListAntiVirusPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAntiVirusPolicyResponse), nil
	}
}

// ListAntiVirusPolicyInvoker 查询自定义查杀策略列表
func (c *HssClient) ListAntiVirusPolicyInvoker(request *model.ListAntiVirusPolicyRequest) *ListAntiVirusPolicyInvoker {
	requestDef := GenReqDefForListAntiVirusPolicy()
	return &ListAntiVirusPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAntiVirusResult 查询病毒扫描结果列表
//
// 查询病毒扫描结果列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAntiVirusResult(request *model.ListAntiVirusResultRequest) (*model.ListAntiVirusResultResponse, error) {
	requestDef := GenReqDefForListAntiVirusResult()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAntiVirusResultResponse), nil
	}
}

// ListAntiVirusResultInvoker 查询病毒扫描结果列表
func (c *HssClient) ListAntiVirusResultInvoker(request *model.ListAntiVirusResultRequest) *ListAntiVirusResultInvoker {
	requestDef := GenReqDefForListAntiVirusResult()
	return &ListAntiVirusResultInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAntiVirusTask 查看病毒扫描任务列表
//
// 查看病毒扫描任务列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAntiVirusTask(request *model.ListAntiVirusTaskRequest) (*model.ListAntiVirusTaskResponse, error) {
	requestDef := GenReqDefForListAntiVirusTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAntiVirusTaskResponse), nil
	}
}

// ListAntiVirusTaskInvoker 查看病毒扫描任务列表
func (c *HssClient) ListAntiVirusTaskInvoker(request *model.ListAntiVirusTaskRequest) *ListAntiVirusTaskInvoker {
	requestDef := GenReqDefForListAntiVirusTask()
	return &ListAntiVirusTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAntivirusFreeQuota 查询病毒查杀免费扫描次数
//
// 查询病毒查杀免费扫描次数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAntivirusFreeQuota(request *model.ShowAntivirusFreeQuotaRequest) (*model.ShowAntivirusFreeQuotaResponse, error) {
	requestDef := GenReqDefForShowAntivirusFreeQuota()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAntivirusFreeQuotaResponse), nil
	}
}

// ShowAntivirusFreeQuotaInvoker 查询病毒查杀免费扫描次数
func (c *HssClient) ShowAntivirusFreeQuotaInvoker(request *model.ShowAntivirusFreeQuotaRequest) *ShowAntivirusFreeQuotaInvoker {
	requestDef := GenReqDefForShowAntivirusFreeQuota()
	return &ShowAntivirusFreeQuotaInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAntivirusPayPerScanStatus 查询“病毒查杀按次计费”开关状态
//
// 查询“病毒查杀按次计费”开关状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAntivirusPayPerScanStatus(request *model.ShowAntivirusPayPerScanStatusRequest) (*model.ShowAntivirusPayPerScanStatusResponse, error) {
	requestDef := GenReqDefForShowAntivirusPayPerScanStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAntivirusPayPerScanStatusResponse), nil
	}
}

// ShowAntivirusPayPerScanStatusInvoker 查询“病毒查杀按次计费”开关状态
func (c *HssClient) ShowAntivirusPayPerScanStatusInvoker(request *model.ShowAntivirusPayPerScanStatusRequest) *ShowAntivirusPayPerScanStatusInvoker {
	requestDef := GenReqDefForShowAntivirusPayPerScanStatus()
	return &ShowAntivirusPayPerScanStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAntivirusStatistic 查询病毒查杀统计信息
//
// 查询病毒查杀统计信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAntivirusStatistic(request *model.ShowAntivirusStatisticRequest) (*model.ShowAntivirusStatisticResponse, error) {
	requestDef := GenReqDefForShowAntivirusStatistic()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAntivirusStatisticResponse), nil
	}
}

// ShowAntivirusStatisticInvoker 查询病毒查杀统计信息
func (c *HssClient) ShowAntivirusStatisticInvoker(request *model.ShowAntivirusStatisticRequest) *ShowAntivirusStatisticInvoker {
	requestDef := GenReqDefForShowAntivirusStatistic()
	return &ShowAntivirusStatisticInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchAntivirusTask 取消扫描任务
//
// 取消扫描任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchAntivirusTask(request *model.SwitchAntivirusTaskRequest) (*model.SwitchAntivirusTaskResponse, error) {
	requestDef := GenReqDefForSwitchAntivirusTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchAntivirusTaskResponse), nil
	}
}

// SwitchAntivirusTaskInvoker 取消扫描任务
func (c *HssClient) SwitchAntivirusTaskInvoker(request *model.SwitchAntivirusTaskRequest) *SwitchAntivirusTaskInvoker {
	requestDef := GenReqDefForSwitchAntivirusTask()
	return &SwitchAntivirusTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddAppWhitelistPolicyHost 白名单策略添加主机
//
// 白名单策略添加主机
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddAppWhitelistPolicyHost(request *model.AddAppWhitelistPolicyHostRequest) (*model.AddAppWhitelistPolicyHostResponse, error) {
	requestDef := GenReqDefForAddAppWhitelistPolicyHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddAppWhitelistPolicyHostResponse), nil
	}
}

// AddAppWhitelistPolicyHostInvoker 白名单策略添加主机
func (c *HssClient) AddAppWhitelistPolicyHostInvoker(request *model.AddAppWhitelistPolicyHostRequest) *AddAppWhitelistPolicyHostInvoker {
	requestDef := GenReqDefForAddAppWhitelistPolicyHost()
	return &AddAppWhitelistPolicyHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddAppWhitelistPolicyProcess 新增进程白名单策略进程
//
// 新增进程白名单策略进程
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddAppWhitelistPolicyProcess(request *model.AddAppWhitelistPolicyProcessRequest) (*model.AddAppWhitelistPolicyProcessResponse, error) {
	requestDef := GenReqDefForAddAppWhitelistPolicyProcess()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddAppWhitelistPolicyProcessResponse), nil
	}
}

// AddAppWhitelistPolicyProcessInvoker 新增进程白名单策略进程
func (c *HssClient) AddAppWhitelistPolicyProcessInvoker(request *model.AddAppWhitelistPolicyProcessRequest) *AddAppWhitelistPolicyProcessInvoker {
	requestDef := GenReqDefForAddAppWhitelistPolicyProcess()
	return &AddAppWhitelistPolicyProcessInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeAppWhitelistPolicy 修改白名单策略
//
// 修改白名单策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeAppWhitelistPolicy(request *model.ChangeAppWhitelistPolicyRequest) (*model.ChangeAppWhitelistPolicyResponse, error) {
	requestDef := GenReqDefForChangeAppWhitelistPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeAppWhitelistPolicyResponse), nil
	}
}

// ChangeAppWhitelistPolicyInvoker 修改白名单策略
func (c *HssClient) ChangeAppWhitelistPolicyInvoker(request *model.ChangeAppWhitelistPolicyRequest) *ChangeAppWhitelistPolicyInvoker {
	requestDef := GenReqDefForChangeAppWhitelistPolicy()
	return &ChangeAppWhitelistPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeAppWhitelistPolicyProcessStatus 标记进程白名单策略识别进程
//
// 标记进程白名单策略识别进程
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeAppWhitelistPolicyProcessStatus(request *model.ChangeAppWhitelistPolicyProcessStatusRequest) (*model.ChangeAppWhitelistPolicyProcessStatusResponse, error) {
	requestDef := GenReqDefForChangeAppWhitelistPolicyProcessStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeAppWhitelistPolicyProcessStatusResponse), nil
	}
}

// ChangeAppWhitelistPolicyProcessStatusInvoker 标记进程白名单策略识别进程
func (c *HssClient) ChangeAppWhitelistPolicyProcessStatusInvoker(request *model.ChangeAppWhitelistPolicyProcessStatusRequest) *ChangeAppWhitelistPolicyProcessStatusInvoker {
	requestDef := GenReqDefForChangeAppWhitelistPolicyProcessStatus()
	return &ChangeAppWhitelistPolicyProcessStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateAppWhitelistPolicy 创建白名单策略
//
// 创建白名单策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateAppWhitelistPolicy(request *model.CreateAppWhitelistPolicyRequest) (*model.CreateAppWhitelistPolicyResponse, error) {
	requestDef := GenReqDefForCreateAppWhitelistPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateAppWhitelistPolicyResponse), nil
	}
}

// CreateAppWhitelistPolicyInvoker 创建白名单策略
func (c *HssClient) CreateAppWhitelistPolicyInvoker(request *model.CreateAppWhitelistPolicyRequest) *CreateAppWhitelistPolicyInvoker {
	requestDef := GenReqDefForCreateAppWhitelistPolicy()
	return &CreateAppWhitelistPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteAppWhitelistPolicy 删除白名单策略
//
// 删除白名单策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteAppWhitelistPolicy(request *model.DeleteAppWhitelistPolicyRequest) (*model.DeleteAppWhitelistPolicyResponse, error) {
	requestDef := GenReqDefForDeleteAppWhitelistPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteAppWhitelistPolicyResponse), nil
	}
}

// DeleteAppWhitelistPolicyInvoker 删除白名单策略
func (c *HssClient) DeleteAppWhitelistPolicyInvoker(request *model.DeleteAppWhitelistPolicyRequest) *DeleteAppWhitelistPolicyInvoker {
	requestDef := GenReqDefForDeleteAppWhitelistPolicy()
	return &DeleteAppWhitelistPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteAppWhitelistPolicyHost 白名单策略删除主机
//
// 白名单策略删除主机
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteAppWhitelistPolicyHost(request *model.DeleteAppWhitelistPolicyHostRequest) (*model.DeleteAppWhitelistPolicyHostResponse, error) {
	requestDef := GenReqDefForDeleteAppWhitelistPolicyHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteAppWhitelistPolicyHostResponse), nil
	}
}

// DeleteAppWhitelistPolicyHostInvoker 白名单策略删除主机
func (c *HssClient) DeleteAppWhitelistPolicyHostInvoker(request *model.DeleteAppWhitelistPolicyHostRequest) *DeleteAppWhitelistPolicyHostInvoker {
	requestDef := GenReqDefForDeleteAppWhitelistPolicyHost()
	return &DeleteAppWhitelistPolicyHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAppWhitelistEvent 查询进程白名单可疑进程
//
// 查询进程白名单可疑进程
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAppWhitelistEvent(request *model.ListAppWhitelistEventRequest) (*model.ListAppWhitelistEventResponse, error) {
	requestDef := GenReqDefForListAppWhitelistEvent()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAppWhitelistEventResponse), nil
	}
}

// ListAppWhitelistEventInvoker 查询进程白名单可疑进程
func (c *HssClient) ListAppWhitelistEventInvoker(request *model.ListAppWhitelistEventRequest) *ListAppWhitelistEventInvoker {
	requestDef := GenReqDefForListAppWhitelistEvent()
	return &ListAppWhitelistEventInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAppWhitelistHostStatus 查询进程白名单可选服务器列表
//
// 查询进程白名单可选服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAppWhitelistHostStatus(request *model.ListAppWhitelistHostStatusRequest) (*model.ListAppWhitelistHostStatusResponse, error) {
	requestDef := GenReqDefForListAppWhitelistHostStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAppWhitelistHostStatusResponse), nil
	}
}

// ListAppWhitelistHostStatusInvoker 查询进程白名单可选服务器列表
func (c *HssClient) ListAppWhitelistHostStatusInvoker(request *model.ListAppWhitelistHostStatusRequest) *ListAppWhitelistHostStatusInvoker {
	requestDef := GenReqDefForListAppWhitelistHostStatus()
	return &ListAppWhitelistHostStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAppWhitelistPolicy 查询进程白名单策略列表
//
// 查询进程白名单策略列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAppWhitelistPolicy(request *model.ListAppWhitelistPolicyRequest) (*model.ListAppWhitelistPolicyResponse, error) {
	requestDef := GenReqDefForListAppWhitelistPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAppWhitelistPolicyResponse), nil
	}
}

// ListAppWhitelistPolicyInvoker 查询进程白名单策略列表
func (c *HssClient) ListAppWhitelistPolicyInvoker(request *model.ListAppWhitelistPolicyRequest) *ListAppWhitelistPolicyInvoker {
	requestDef := GenReqDefForListAppWhitelistPolicy()
	return &ListAppWhitelistPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAppWhitelistPolicyHost 查询进程白名单策略关联主机列表
//
// 查询进程白名单策略关联主机列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAppWhitelistPolicyHost(request *model.ListAppWhitelistPolicyHostRequest) (*model.ListAppWhitelistPolicyHostResponse, error) {
	requestDef := GenReqDefForListAppWhitelistPolicyHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAppWhitelistPolicyHostResponse), nil
	}
}

// ListAppWhitelistPolicyHostInvoker 查询进程白名单策略关联主机列表
func (c *HssClient) ListAppWhitelistPolicyHostInvoker(request *model.ListAppWhitelistPolicyHostRequest) *ListAppWhitelistPolicyHostInvoker {
	requestDef := GenReqDefForListAppWhitelistPolicyHost()
	return &ListAppWhitelistPolicyHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAppWhitelistPolicyProcess 查询进程白名单策略识别进程
//
// 查询进程白名单策略识别进程
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAppWhitelistPolicyProcess(request *model.ListAppWhitelistPolicyProcessRequest) (*model.ListAppWhitelistPolicyProcessResponse, error) {
	requestDef := GenReqDefForListAppWhitelistPolicyProcess()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAppWhitelistPolicyProcessResponse), nil
	}
}

// ListAppWhitelistPolicyProcessInvoker 查询进程白名单策略识别进程
func (c *HssClient) ListAppWhitelistPolicyProcessInvoker(request *model.ListAppWhitelistPolicyProcessRequest) *ListAppWhitelistPolicyProcessInvoker {
	requestDef := GenReqDefForListAppWhitelistPolicyProcess()
	return &ListAppWhitelistPolicyProcessInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAppWhitelistPolicyProcessExtend 查询进程白名单策略进程扩展列表
//
// 查询进程白名单策略进程扩展列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAppWhitelistPolicyProcessExtend(request *model.ListAppWhitelistPolicyProcessExtendRequest) (*model.ListAppWhitelistPolicyProcessExtendResponse, error) {
	requestDef := GenReqDefForListAppWhitelistPolicyProcessExtend()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAppWhitelistPolicyProcessExtendResponse), nil
	}
}

// ListAppWhitelistPolicyProcessExtendInvoker 查询进程白名单策略进程扩展列表
func (c *HssClient) ListAppWhitelistPolicyProcessExtendInvoker(request *model.ListAppWhitelistPolicyProcessExtendRequest) *ListAppWhitelistPolicyProcessExtendInvoker {
	requestDef := GenReqDefForListAppWhitelistPolicyProcessExtend()
	return &ListAppWhitelistPolicyProcessExtendInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAppWhitelistAgentStatics 统计agent版本不匹配主机数量
//
// 统计agent版本不匹配主机数量
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAppWhitelistAgentStatics(request *model.ShowAppWhitelistAgentStaticsRequest) (*model.ShowAppWhitelistAgentStaticsResponse, error) {
	requestDef := GenReqDefForShowAppWhitelistAgentStatics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAppWhitelistAgentStaticsResponse), nil
	}
}

// ShowAppWhitelistAgentStaticsInvoker 统计agent版本不匹配主机数量
func (c *HssClient) ShowAppWhitelistAgentStaticsInvoker(request *model.ShowAppWhitelistAgentStaticsRequest) *ShowAppWhitelistAgentStaticsInvoker {
	requestDef := GenReqDefForShowAppWhitelistAgentStatics()
	return &ShowAppWhitelistAgentStaticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAppWhitelistPolicy 查询进程白名单策略详情
//
// 查询进程白名单策略详情
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAppWhitelistPolicy(request *model.ShowAppWhitelistPolicyRequest) (*model.ShowAppWhitelistPolicyResponse, error) {
	requestDef := GenReqDefForShowAppWhitelistPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAppWhitelistPolicyResponse), nil
	}
}

// ShowAppWhitelistPolicyInvoker 查询进程白名单策略详情
func (c *HssClient) ShowAppWhitelistPolicyInvoker(request *model.ShowAppWhitelistPolicyRequest) *ShowAppWhitelistPolicyInvoker {
	requestDef := GenReqDefForShowAppWhitelistPolicy()
	return &ShowAppWhitelistPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchAppWhitelistPolicyHost 应用白名单策略
//
// 应用白名单策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchAppWhitelistPolicyHost(request *model.SwitchAppWhitelistPolicyHostRequest) (*model.SwitchAppWhitelistPolicyHostResponse, error) {
	requestDef := GenReqDefForSwitchAppWhitelistPolicyHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchAppWhitelistPolicyHostResponse), nil
	}
}

// SwitchAppWhitelistPolicyHostInvoker 应用白名单策略
func (c *HssClient) SwitchAppWhitelistPolicyHostInvoker(request *model.SwitchAppWhitelistPolicyHostRequest) *SwitchAppWhitelistPolicyHostInvoker {
	requestDef := GenReqDefForSwitchAppWhitelistPolicyHost()
	return &SwitchAppWhitelistPolicyHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchAppWhitelistPolicyLearnStatus 操作白名单策略学习状态
//
// 操作白名单策略学习状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchAppWhitelistPolicyLearnStatus(request *model.SwitchAppWhitelistPolicyLearnStatusRequest) (*model.SwitchAppWhitelistPolicyLearnStatusResponse, error) {
	requestDef := GenReqDefForSwitchAppWhitelistPolicyLearnStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchAppWhitelistPolicyLearnStatusResponse), nil
	}
}

// SwitchAppWhitelistPolicyLearnStatusInvoker 操作白名单策略学习状态
func (c *HssClient) SwitchAppWhitelistPolicyLearnStatusInvoker(request *model.SwitchAppWhitelistPolicyLearnStatusRequest) *SwitchAppWhitelistPolicyLearnStatusInvoker {
	requestDef := GenReqDefForSwitchAppWhitelistPolicyLearnStatus()
	return &SwitchAppWhitelistPolicyLearnStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddBaselineWhiteList 新增基线白名单
//
// 新增基线白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddBaselineWhiteList(request *model.AddBaselineWhiteListRequest) (*model.AddBaselineWhiteListResponse, error) {
	requestDef := GenReqDefForAddBaselineWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddBaselineWhiteListResponse), nil
	}
}

// AddBaselineWhiteListInvoker 新增基线白名单
func (c *HssClient) AddBaselineWhiteListInvoker(request *model.AddBaselineWhiteListRequest) *AddBaselineWhiteListInvoker {
	requestDef := GenReqDefForAddBaselineWhiteList()
	return &AddBaselineWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddSecurityCheckPolicyGroup 新建配置检测策略信息
//
// 新建配置检测策略信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddSecurityCheckPolicyGroup(request *model.AddSecurityCheckPolicyGroupRequest) (*model.AddSecurityCheckPolicyGroupResponse, error) {
	requestDef := GenReqDefForAddSecurityCheckPolicyGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddSecurityCheckPolicyGroupResponse), nil
	}
}

// AddSecurityCheckPolicyGroupInvoker 新建配置检测策略信息
func (c *HssClient) AddSecurityCheckPolicyGroupInvoker(request *model.AddSecurityCheckPolicyGroupRequest) *AddSecurityCheckPolicyGroupInvoker {
	requestDef := GenReqDefForAddSecurityCheckPolicyGroup()
	return &AddSecurityCheckPolicyGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeBaselineWhiteList 修改基线白名单
//
// 修改基线白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeBaselineWhiteList(request *model.ChangeBaselineWhiteListRequest) (*model.ChangeBaselineWhiteListResponse, error) {
	requestDef := GenReqDefForChangeBaselineWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeBaselineWhiteListResponse), nil
	}
}

// ChangeBaselineWhiteListInvoker 修改基线白名单
func (c *HssClient) ChangeBaselineWhiteListInvoker(request *model.ChangeBaselineWhiteListRequest) *ChangeBaselineWhiteListInvoker {
	requestDef := GenReqDefForChangeBaselineWhiteList()
	return &ChangeBaselineWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeCheckRuleAction 对未通过的配置检查项进行忽略/取消忽略/修复/验证操作
//
// 对未通过的配置检查项进行忽略/取消忽略/修复/验证操作
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeCheckRuleAction(request *model.ChangeCheckRuleActionRequest) (*model.ChangeCheckRuleActionResponse, error) {
	requestDef := GenReqDefForChangeCheckRuleAction()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeCheckRuleActionResponse), nil
	}
}

// ChangeCheckRuleActionInvoker 对未通过的配置检查项进行忽略/取消忽略/修复/验证操作
func (c *HssClient) ChangeCheckRuleActionInvoker(request *model.ChangeCheckRuleActionRequest) *ChangeCheckRuleActionInvoker {
	requestDef := GenReqDefForChangeCheckRuleAction()
	return &ChangeCheckRuleActionInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangePasswordComplexityStatus 对口令复杂度检测未通过的主机进行忽略/取消忽略
//
// 对口令复杂度检测未通过的主机进行忽略/取消忽略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangePasswordComplexityStatus(request *model.ChangePasswordComplexityStatusRequest) (*model.ChangePasswordComplexityStatusResponse, error) {
	requestDef := GenReqDefForChangePasswordComplexityStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangePasswordComplexityStatusResponse), nil
	}
}

// ChangePasswordComplexityStatusInvoker 对口令复杂度检测未通过的主机进行忽略/取消忽略
func (c *HssClient) ChangePasswordComplexityStatusInvoker(request *model.ChangePasswordComplexityStatusRequest) *ChangePasswordComplexityStatusInvoker {
	requestDef := GenReqDefForChangePasswordComplexityStatus()
	return &ChangePasswordComplexityStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CopyBaselinePolicyGroup 复制配置检测策略信息
//
// 复制配置检测策略信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CopyBaselinePolicyGroup(request *model.CopyBaselinePolicyGroupRequest) (*model.CopyBaselinePolicyGroupResponse, error) {
	requestDef := GenReqDefForCopyBaselinePolicyGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CopyBaselinePolicyGroupResponse), nil
	}
}

// CopyBaselinePolicyGroupInvoker 复制配置检测策略信息
func (c *HssClient) CopyBaselinePolicyGroupInvoker(request *model.CopyBaselinePolicyGroupRequest) *CopyBaselinePolicyGroupInvoker {
	requestDef := GenReqDefForCopyBaselinePolicyGroup()
	return &CopyBaselinePolicyGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteBaselineWhiteList 删除基线白名单
//
// 删除基线白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteBaselineWhiteList(request *model.DeleteBaselineWhiteListRequest) (*model.DeleteBaselineWhiteListResponse, error) {
	requestDef := GenReqDefForDeleteBaselineWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteBaselineWhiteListResponse), nil
	}
}

// DeleteBaselineWhiteListInvoker 删除基线白名单
func (c *HssClient) DeleteBaselineWhiteListInvoker(request *model.DeleteBaselineWhiteListRequest) *DeleteBaselineWhiteListInvoker {
	requestDef := GenReqDefForDeleteBaselineWhiteList()
	return &DeleteBaselineWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteSecurityCheckPolicyGroup 删除指定配置检测策略信息
//
// 删除指定配置检测策略信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteSecurityCheckPolicyGroup(request *model.DeleteSecurityCheckPolicyGroupRequest) (*model.DeleteSecurityCheckPolicyGroupResponse, error) {
	requestDef := GenReqDefForDeleteSecurityCheckPolicyGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteSecurityCheckPolicyGroupResponse), nil
	}
}

// DeleteSecurityCheckPolicyGroupInvoker 删除指定配置检测策略信息
func (c *HssClient) DeleteSecurityCheckPolicyGroupInvoker(request *model.DeleteSecurityCheckPolicyGroupRequest) *DeleteSecurityCheckPolicyGroupInvoker {
	requestDef := GenReqDefForDeleteSecurityCheckPolicyGroup()
	return &DeleteSecurityCheckPolicyGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportBaselineSecurityCheckReport 从后端导出基线检测报告，生成Excel文件
//
// 从后端导出基线检测报告，生成Excel文件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportBaselineSecurityCheckReport(request *model.ExportBaselineSecurityCheckReportRequest) (*model.ExportBaselineSecurityCheckReportResponse, error) {
	requestDef := GenReqDefForExportBaselineSecurityCheckReport()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportBaselineSecurityCheckReportResponse), nil
	}
}

// ExportBaselineSecurityCheckReportInvoker 从后端导出基线检测报告，生成Excel文件
func (c *HssClient) ExportBaselineSecurityCheckReportInvoker(request *model.ExportBaselineSecurityCheckReportRequest) *ExportBaselineSecurityCheckReportInvoker {
	requestDef := GenReqDefForExportBaselineSecurityCheckReport()
	return &ExportBaselineSecurityCheckReportInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportSecurityCheckReport 按查询结果导出配置检测报告
//
// 按查询结果导出配置检测报告，生成Excel文件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportSecurityCheckReport(request *model.ExportSecurityCheckReportRequest) (*model.ExportSecurityCheckReportResponse, error) {
	requestDef := GenReqDefForExportSecurityCheckReport()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportSecurityCheckReportResponse), nil
	}
}

// ExportSecurityCheckReportInvoker 按查询结果导出配置检测报告
func (c *HssClient) ExportSecurityCheckReportInvoker(request *model.ExportSecurityCheckReportRequest) *ExportSecurityCheckReportInvoker {
	requestDef := GenReqDefForExportSecurityCheckReport()
	return &ExportSecurityCheckReportInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAllRiskConfigCheckRules 查询指定策略组的检查项列表
//
// 查询指定策略组的检查项列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAllRiskConfigCheckRules(request *model.ListAllRiskConfigCheckRulesRequest) (*model.ListAllRiskConfigCheckRulesResponse, error) {
	requestDef := GenReqDefForListAllRiskConfigCheckRules()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAllRiskConfigCheckRulesResponse), nil
	}
}

// ListAllRiskConfigCheckRulesInvoker 查询指定策略组的检查项列表
func (c *HssClient) ListAllRiskConfigCheckRulesInvoker(request *model.ListAllRiskConfigCheckRulesRequest) *ListAllRiskConfigCheckRulesInvoker {
	requestDef := GenReqDefForListAllRiskConfigCheckRules()
	return &ListAllRiskConfigCheckRulesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListBaselineWhiteLists 查询基线白名单列表
//
// 查询基线白名单列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListBaselineWhiteLists(request *model.ListBaselineWhiteListsRequest) (*model.ListBaselineWhiteListsResponse, error) {
	requestDef := GenReqDefForListBaselineWhiteLists()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListBaselineWhiteListsResponse), nil
	}
}

// ListBaselineWhiteListsInvoker 查询基线白名单列表
func (c *HssClient) ListBaselineWhiteListsInvoker(request *model.ListBaselineWhiteListsRequest) *ListBaselineWhiteListsInvoker {
	requestDef := GenReqDefForListBaselineWhiteLists()
	return &ListBaselineWhiteListsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListCheckRuleHost 查询配置检查项影响到的服务器列表
//
// 查询配置检查项影响到的服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListCheckRuleHost(request *model.ListCheckRuleHostRequest) (*model.ListCheckRuleHostResponse, error) {
	requestDef := GenReqDefForListCheckRuleHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListCheckRuleHostResponse), nil
	}
}

// ListCheckRuleHostInvoker 查询配置检查项影响到的服务器列表
func (c *HssClient) ListCheckRuleHostInvoker(request *model.ListCheckRuleHostRequest) *ListCheckRuleHostInvoker {
	requestDef := GenReqDefForListCheckRuleHost()
	return &ListCheckRuleHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListHandleAffectBaseline 查询基线检查执行操作时影响的范围
//
// 查询基线检查执行操作时影响的范围
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListHandleAffectBaseline(request *model.ListHandleAffectBaselineRequest) (*model.ListHandleAffectBaselineResponse, error) {
	requestDef := GenReqDefForListHandleAffectBaseline()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListHandleAffectBaselineResponse), nil
	}
}

// ListHandleAffectBaselineInvoker 查询基线检查执行操作时影响的范围
func (c *HssClient) ListHandleAffectBaselineInvoker(request *model.ListHandleAffectBaselineRequest) *ListHandleAffectBaselineInvoker {
	requestDef := GenReqDefForListHandleAffectBaseline()
	return &ListHandleAffectBaselineInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListHostCheckRules 查看主机对应的检查项
//
// 查询配置检查项影响到的服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListHostCheckRules(request *model.ListHostCheckRulesRequest) (*model.ListHostCheckRulesResponse, error) {
	requestDef := GenReqDefForListHostCheckRules()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListHostCheckRulesResponse), nil
	}
}

// ListHostCheckRulesInvoker 查看主机对应的检查项
func (c *HssClient) ListHostCheckRulesInvoker(request *model.ListHostCheckRulesRequest) *ListHostCheckRulesInvoker {
	requestDef := GenReqDefForListHostCheckRules()
	return &ListHostCheckRulesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListPasswordComplexity 查询口令复杂度策略检测报告
//
// 查询口令复杂度策略检测报告
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListPasswordComplexity(request *model.ListPasswordComplexityRequest) (*model.ListPasswordComplexityResponse, error) {
	requestDef := GenReqDefForListPasswordComplexity()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListPasswordComplexityResponse), nil
	}
}

// ListPasswordComplexityInvoker 查询口令复杂度策略检测报告
func (c *HssClient) ListPasswordComplexityInvoker(request *model.ListPasswordComplexityRequest) *ListPasswordComplexityInvoker {
	requestDef := GenReqDefForListPasswordComplexity()
	return &ListPasswordComplexityInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListRiskConfigCheckRules 查询指定安全配置项的检查项列表
//
// 查询指定安全配置项的检查项列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListRiskConfigCheckRules(request *model.ListRiskConfigCheckRulesRequest) (*model.ListRiskConfigCheckRulesResponse, error) {
	requestDef := GenReqDefForListRiskConfigCheckRules()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListRiskConfigCheckRulesResponse), nil
	}
}

// ListRiskConfigCheckRulesInvoker 查询指定安全配置项的检查项列表
func (c *HssClient) ListRiskConfigCheckRulesInvoker(request *model.ListRiskConfigCheckRulesRequest) *ListRiskConfigCheckRulesInvoker {
	requestDef := GenReqDefForListRiskConfigCheckRules()
	return &ListRiskConfigCheckRulesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListRiskConfigHosts 查询指定安全配置项的受影响服务器列表
//
// 查询指定安全配置项的受影响服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListRiskConfigHosts(request *model.ListRiskConfigHostsRequest) (*model.ListRiskConfigHostsResponse, error) {
	requestDef := GenReqDefForListRiskConfigHosts()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListRiskConfigHostsResponse), nil
	}
}

// ListRiskConfigHostsInvoker 查询指定安全配置项的受影响服务器列表
func (c *HssClient) ListRiskConfigHostsInvoker(request *model.ListRiskConfigHostsRequest) *ListRiskConfigHostsInvoker {
	requestDef := GenReqDefForListRiskConfigHosts()
	return &ListRiskConfigHostsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListRiskConfigs 查询租户的服务器安全配置检测结果列表
//
// 查询租户的服务器安全配置检测结果列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListRiskConfigs(request *model.ListRiskConfigsRequest) (*model.ListRiskConfigsResponse, error) {
	requestDef := GenReqDefForListRiskConfigs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListRiskConfigsResponse), nil
	}
}

// ListRiskConfigsInvoker 查询租户的服务器安全配置检测结果列表
func (c *HssClient) ListRiskConfigsInvoker(request *model.ListRiskConfigsRequest) *ListRiskConfigsInvoker {
	requestDef := GenReqDefForListRiskConfigs()
	return &ListRiskConfigsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListSecurityCheckPolicyGroup 查询配置检测策略组列表
//
// 查询配置检测策略组列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListSecurityCheckPolicyGroup(request *model.ListSecurityCheckPolicyGroupRequest) (*model.ListSecurityCheckPolicyGroupResponse, error) {
	requestDef := GenReqDefForListSecurityCheckPolicyGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListSecurityCheckPolicyGroupResponse), nil
	}
}

// ListSecurityCheckPolicyGroupInvoker 查询配置检测策略组列表
func (c *HssClient) ListSecurityCheckPolicyGroupInvoker(request *model.ListSecurityCheckPolicyGroupRequest) *ListSecurityCheckPolicyGroupInvoker {
	requestDef := GenReqDefForListSecurityCheckPolicyGroup()
	return &ListSecurityCheckPolicyGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWeakPasswordUsers 查询弱口令检测结果列表
//
// 查询弱口令检测结果列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWeakPasswordUsers(request *model.ListWeakPasswordUsersRequest) (*model.ListWeakPasswordUsersResponse, error) {
	requestDef := GenReqDefForListWeakPasswordUsers()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWeakPasswordUsersResponse), nil
	}
}

// ListWeakPasswordUsersInvoker 查询弱口令检测结果列表
func (c *HssClient) ListWeakPasswordUsersInvoker(request *model.ListWeakPasswordUsersRequest) *ListWeakPasswordUsersInvoker {
	requestDef := GenReqDefForListWeakPasswordUsers()
	return &ListWeakPasswordUsersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RunBaselineDetect 手动检测：对策略中选择的主机，进行配置检测和弱口令检测
//
// 手动检测：对策略中选择的主机，进行配置检测和弱口令检测
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RunBaselineDetect(request *model.RunBaselineDetectRequest) (*model.RunBaselineDetectResponse, error) {
	requestDef := GenReqDefForRunBaselineDetect()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RunBaselineDetectResponse), nil
	}
}

// RunBaselineDetectInvoker 手动检测：对策略中选择的主机，进行配置检测和弱口令检测
func (c *HssClient) RunBaselineDetectInvoker(request *model.RunBaselineDetectRequest) *RunBaselineDetectInvoker {
	requestDef := GenReqDefForRunBaselineDetect()
	return &RunBaselineDetectInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowBaselineDirectory 查询基线检测策略的基线目录信息
//
// 查询基线检测策略的基线目录信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowBaselineDirectory(request *model.ShowBaselineDirectoryRequest) (*model.ShowBaselineDirectoryResponse, error) {
	requestDef := GenReqDefForShowBaselineDirectory()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowBaselineDirectoryResponse), nil
	}
}

// ShowBaselineDirectoryInvoker 查询基线检测策略的基线目录信息
func (c *HssClient) ShowBaselineDirectoryInvoker(request *model.ShowBaselineDirectoryRequest) *ShowBaselineDirectoryInvoker {
	requestDef := GenReqDefForShowBaselineDirectory()
	return &ShowBaselineDirectoryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowBaselineOverview 查询基线检查的统计数据信息
//
// 查询基线检查的统计数据信息，用来展示基线检查页面的统计数据和图表数据，包括最近检测时间、检测主机数、检测基线数、主机配置检查项数、主机配置基线通过率、主机配置风险top5、主机弱口令检测统计、主机弱口令风险top5等
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowBaselineOverview(request *model.ShowBaselineOverviewRequest) (*model.ShowBaselineOverviewResponse, error) {
	requestDef := GenReqDefForShowBaselineOverview()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowBaselineOverviewResponse), nil
	}
}

// ShowBaselineOverviewInvoker 查询基线检查的统计数据信息
func (c *HssClient) ShowBaselineOverviewInvoker(request *model.ShowBaselineOverviewRequest) *ShowBaselineOverviewInvoker {
	requestDef := GenReqDefForShowBaselineOverview()
	return &ShowBaselineOverviewInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowBaselineScanStatus 查询基线扫描手动检测结果
//
// 查询基线扫描手动检测结果
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowBaselineScanStatus(request *model.ShowBaselineScanStatusRequest) (*model.ShowBaselineScanStatusResponse, error) {
	requestDef := GenReqDefForShowBaselineScanStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowBaselineScanStatusResponse), nil
	}
}

// ShowBaselineScanStatusInvoker 查询基线扫描手动检测结果
func (c *HssClient) ShowBaselineScanStatusInvoker(request *model.ShowBaselineScanStatusRequest) *ShowBaselineScanStatusInvoker {
	requestDef := GenReqDefForShowBaselineScanStatus()
	return &ShowBaselineScanStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowBaselineStatistic 查询基线检查的统计数据信息，包括弱口令，口令复杂度，配置检测
//
// 查询基线检查的风险数统计信息，包括弱口令，口令复杂度，配置检测
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowBaselineStatistic(request *model.ShowBaselineStatisticRequest) (*model.ShowBaselineStatisticResponse, error) {
	requestDef := GenReqDefForShowBaselineStatistic()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowBaselineStatisticResponse), nil
	}
}

// ShowBaselineStatisticInvoker 查询基线检查的统计数据信息，包括弱口令，口令复杂度，配置检测
func (c *HssClient) ShowBaselineStatisticInvoker(request *model.ShowBaselineStatisticRequest) *ShowBaselineStatisticInvoker {
	requestDef := GenReqDefForShowBaselineStatistic()
	return &ShowBaselineStatisticInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowBaselineWhiteList 查询单个基线白名单
//
// 查询单个基线白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowBaselineWhiteList(request *model.ShowBaselineWhiteListRequest) (*model.ShowBaselineWhiteListResponse, error) {
	requestDef := GenReqDefForShowBaselineWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowBaselineWhiteListResponse), nil
	}
}

// ShowBaselineWhiteListInvoker 查询单个基线白名单
func (c *HssClient) ShowBaselineWhiteListInvoker(request *model.ShowBaselineWhiteListRequest) *ShowBaselineWhiteListInvoker {
	requestDef := GenReqDefForShowBaselineWhiteList()
	return &ShowBaselineWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowCheckRuleDetail 查询配置检查项检测报告
//
// 查询配置检查项检测报告
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowCheckRuleDetail(request *model.ShowCheckRuleDetailRequest) (*model.ShowCheckRuleDetailResponse, error) {
	requestDef := GenReqDefForShowCheckRuleDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowCheckRuleDetailResponse), nil
	}
}

// ShowCheckRuleDetailInvoker 查询配置检查项检测报告
func (c *HssClient) ShowCheckRuleDetailInvoker(request *model.ShowCheckRuleDetailRequest) *ShowCheckRuleDetailInvoker {
	requestDef := GenReqDefForShowCheckRuleDetail()
	return &ShowCheckRuleDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowCheckRuleFixFailDetail 查询检查项修复失败原因
//
// 查询检查项修复失败原因
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowCheckRuleFixFailDetail(request *model.ShowCheckRuleFixFailDetailRequest) (*model.ShowCheckRuleFixFailDetailResponse, error) {
	requestDef := GenReqDefForShowCheckRuleFixFailDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowCheckRuleFixFailDetailResponse), nil
	}
}

// ShowCheckRuleFixFailDetailInvoker 查询检查项修复失败原因
func (c *HssClient) ShowCheckRuleFixFailDetailInvoker(request *model.ShowCheckRuleFixFailDetailRequest) *ShowCheckRuleFixFailDetailInvoker {
	requestDef := GenReqDefForShowCheckRuleFixFailDetail()
	return &ShowCheckRuleFixFailDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowDefaultSecurityCheckPolicy 查询配置检测策略的默认基线信息
//
// 查询配置检测策略的默认基线信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowDefaultSecurityCheckPolicy(request *model.ShowDefaultSecurityCheckPolicyRequest) (*model.ShowDefaultSecurityCheckPolicyResponse, error) {
	requestDef := GenReqDefForShowDefaultSecurityCheckPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowDefaultSecurityCheckPolicyResponse), nil
	}
}

// ShowDefaultSecurityCheckPolicyInvoker 查询配置检测策略的默认基线信息
func (c *HssClient) ShowDefaultSecurityCheckPolicyInvoker(request *model.ShowDefaultSecurityCheckPolicyRequest) *ShowDefaultSecurityCheckPolicyInvoker {
	requestDef := GenReqDefForShowDefaultSecurityCheckPolicy()
	return &ShowDefaultSecurityCheckPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowDefaultSecurityCheckPolicyDetails 查询基线的详细检查项
//
// 查询基线的详细检查项
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowDefaultSecurityCheckPolicyDetails(request *model.ShowDefaultSecurityCheckPolicyDetailsRequest) (*model.ShowDefaultSecurityCheckPolicyDetailsResponse, error) {
	requestDef := GenReqDefForShowDefaultSecurityCheckPolicyDetails()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowDefaultSecurityCheckPolicyDetailsResponse), nil
	}
}

// ShowDefaultSecurityCheckPolicyDetailsInvoker 查询基线的详细检查项
func (c *HssClient) ShowDefaultSecurityCheckPolicyDetailsInvoker(request *model.ShowDefaultSecurityCheckPolicyDetailsRequest) *ShowDefaultSecurityCheckPolicyDetailsInvoker {
	requestDef := GenReqDefForShowDefaultSecurityCheckPolicyDetails()
	return &ShowDefaultSecurityCheckPolicyDetailsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowRiskConfigDetail 查询指定安全配置项的检查结果
//
// 查询指定安全配置项的检查结果
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowRiskConfigDetail(request *model.ShowRiskConfigDetailRequest) (*model.ShowRiskConfigDetailResponse, error) {
	requestDef := GenReqDefForShowRiskConfigDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowRiskConfigDetailResponse), nil
	}
}

// ShowRiskConfigDetailInvoker 查询指定安全配置项的检查结果
func (c *HssClient) ShowRiskConfigDetailInvoker(request *model.ShowRiskConfigDetailRequest) *ShowRiskConfigDetailInvoker {
	requestDef := GenReqDefForShowRiskConfigDetail()
	return &ShowRiskConfigDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateSecurityCheckPolicyGroup 修改指定配置检测策略信息
//
// 修改指定配置检测策略信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateSecurityCheckPolicyGroup(request *model.UpdateSecurityCheckPolicyGroupRequest) (*model.UpdateSecurityCheckPolicyGroupResponse, error) {
	requestDef := GenReqDefForUpdateSecurityCheckPolicyGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateSecurityCheckPolicyGroupResponse), nil
	}
}

// UpdateSecurityCheckPolicyGroupInvoker 修改指定配置检测策略信息
func (c *HssClient) UpdateSecurityCheckPolicyGroupInvoker(request *model.UpdateSecurityCheckPolicyGroupRequest) *UpdateSecurityCheckPolicyGroupInvoker {
	requestDef := GenReqDefForUpdateSecurityCheckPolicyGroup()
	return &UpdateSecurityCheckPolicyGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportRisks 导出集群环境安全相关信息
//
// 导出集群环境安全相关信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportRisks(request *model.ExportRisksRequest) (*model.ExportRisksResponse, error) {
	requestDef := GenReqDefForExportRisks()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportRisksResponse), nil
	}
}

// ExportRisksInvoker 导出集群环境安全相关信息
func (c *HssClient) ExportRisksInvoker(request *model.ExportRisksRequest) *ExportRisksInvoker {
	requestDef := GenReqDefForExportRisks()
	return &ExportRisksInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterRiskAffectResources 查询集群风险影响的集群资源列表
//
// 查询集群风险影响的集群资源列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterRiskAffectResources(request *model.ListClusterRiskAffectResourcesRequest) (*model.ListClusterRiskAffectResourcesResponse, error) {
	requestDef := GenReqDefForListClusterRiskAffectResources()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterRiskAffectResourcesResponse), nil
	}
}

// ListClusterRiskAffectResourcesInvoker 查询集群风险影响的集群资源列表
func (c *HssClient) ListClusterRiskAffectResourcesInvoker(request *model.ListClusterRiskAffectResourcesRequest) *ListClusterRiskAffectResourcesInvoker {
	requestDef := GenReqDefForListClusterRiskAffectResources()
	return &ListClusterRiskAffectResourcesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListClusterRisks 查询集群风险列表
//
// 查询集群风险列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListClusterRisks(request *model.ListClusterRisksRequest) (*model.ListClusterRisksResponse, error) {
	requestDef := GenReqDefForListClusterRisks()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListClusterRisksResponse), nil
	}
}

// ListClusterRisksInvoker 查询集群风险列表
func (c *HssClient) ListClusterRisksInvoker(request *model.ListClusterRisksRequest) *ListClusterRisksInvoker {
	requestDef := GenReqDefForListClusterRisks()
	return &ListClusterRisksInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowClusterScanStatistics 查询集群扫描统计数据
//
// 查询集群扫描统计数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowClusterScanStatistics(request *model.ShowClusterScanStatisticsRequest) (*model.ShowClusterScanStatisticsResponse, error) {
	requestDef := GenReqDefForShowClusterScanStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowClusterScanStatisticsResponse), nil
	}
}

// ShowClusterScanStatisticsInvoker 查询集群扫描统计数据
func (c *HssClient) ShowClusterScanStatisticsInvoker(request *model.ShowClusterScanStatisticsRequest) *ShowClusterScanStatisticsInvoker {
	requestDef := GenReqDefForShowClusterScanStatistics()
	return &ShowClusterScanStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListProjectConfigs 查询项目配置
//
// 查询项目配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListProjectConfigs(request *model.ListProjectConfigsRequest) (*model.ListProjectConfigsResponse, error) {
	requestDef := GenReqDefForListProjectConfigs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListProjectConfigsResponse), nil
	}
}

// ListProjectConfigsInvoker 查询项目配置
func (c *HssClient) ListProjectConfigsInvoker(request *model.ListProjectConfigsRequest) *ListProjectConfigsInvoker {
	requestDef := GenReqDefForListProjectConfigs()
	return &ListProjectConfigsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ModifyProjectConfigs 修改项目配置
//
// 修改项目配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ModifyProjectConfigs(request *model.ModifyProjectConfigsRequest) (*model.ModifyProjectConfigsResponse, error) {
	requestDef := GenReqDefForModifyProjectConfigs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ModifyProjectConfigsResponse), nil
	}
}

// ModifyProjectConfigsInvoker 修改项目配置
func (c *HssClient) ModifyProjectConfigsInvoker(request *model.ModifyProjectConfigsRequest) *ModifyProjectConfigsInvoker {
	requestDef := GenReqDefForModifyProjectConfigs()
	return &ModifyProjectConfigsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SaveBrowsingHistory 保存用户访问记录
//
// 保存用户访问记录
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SaveBrowsingHistory(request *model.SaveBrowsingHistoryRequest) (*model.SaveBrowsingHistoryResponse, error) {
	requestDef := GenReqDefForSaveBrowsingHistory()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SaveBrowsingHistoryResponse), nil
	}
}

// SaveBrowsingHistoryInvoker 保存用户访问记录
func (c *HssClient) SaveBrowsingHistoryInvoker(request *model.SaveBrowsingHistoryRequest) *SaveBrowsingHistoryInvoker {
	requestDef := GenReqDefForSaveBrowsingHistory()
	return &SaveBrowsingHistoryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UploadReportLogo 上传安全报告logo
//
// 上传安全报告logo
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UploadReportLogo(request *model.UploadReportLogoRequest) (*model.UploadReportLogoResponse, error) {
	requestDef := GenReqDefForUploadReportLogo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UploadReportLogoResponse), nil
	}
}

// UploadReportLogoInvoker 上传安全报告logo
func (c *HssClient) UploadReportLogoInvoker(request *model.UploadReportLogoRequest) *UploadReportLogoInvoker {
	requestDef := GenReqDefForUploadReportLogo()
	return &UploadReportLogoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddCicdConfiguration 新增cicd配置
//
// 新增cicd配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddCicdConfiguration(request *model.AddCicdConfigurationRequest) (*model.AddCicdConfigurationResponse, error) {
	requestDef := GenReqDefForAddCicdConfiguration()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddCicdConfigurationResponse), nil
	}
}

// AddCicdConfigurationInvoker 新增cicd配置
func (c *HssClient) AddCicdConfigurationInvoker(request *model.AddCicdConfigurationRequest) *AddCicdConfigurationInvoker {
	requestDef := GenReqDefForAddCicdConfiguration()
	return &AddCicdConfigurationInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddRegistry 新增镜像仓库
//
// 新增镜像仓库
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddRegistry(request *model.AddRegistryRequest) (*model.AddRegistryResponse, error) {
	requestDef := GenReqDefForAddRegistry()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddRegistryResponse), nil
	}
}

// AddRegistryInvoker 新增镜像仓库
func (c *HssClient) AddRegistryInvoker(request *model.AddRegistryRequest) *AddRegistryInvoker {
	requestDef := GenReqDefForAddRegistry()
	return &AddRegistryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchDeleteAgentDaemonset 批量卸载集群daemonset
//
// 批量卸载集群daemonset
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchDeleteAgentDaemonset(request *model.BatchDeleteAgentDaemonsetRequest) (*model.BatchDeleteAgentDaemonsetResponse, error) {
	requestDef := GenReqDefForBatchDeleteAgentDaemonset()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchDeleteAgentDaemonsetResponse), nil
	}
}

// BatchDeleteAgentDaemonsetInvoker 批量卸载集群daemonset
func (c *HssClient) BatchDeleteAgentDaemonsetInvoker(request *model.BatchDeleteAgentDaemonsetRequest) *BatchDeleteAgentDaemonsetInvoker {
	requestDef := GenReqDefForBatchDeleteAgentDaemonset()
	return &BatchDeleteAgentDaemonsetInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchDeleteRegistry 批量删除镜像仓接入信息
//
// 批量删除镜像仓接入信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchDeleteRegistry(request *model.BatchDeleteRegistryRequest) (*model.BatchDeleteRegistryResponse, error) {
	requestDef := GenReqDefForBatchDeleteRegistry()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchDeleteRegistryResponse), nil
	}
}

// BatchDeleteRegistryInvoker 批量删除镜像仓接入信息
func (c *HssClient) BatchDeleteRegistryInvoker(request *model.BatchDeleteRegistryRequest) *BatchDeleteRegistryInvoker {
	requestDef := GenReqDefForBatchDeleteRegistry()
	return &BatchDeleteRegistryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchUpgradeAgentDaemonset 批量升级集群daemonset
//
// 批量升级集群daemonset
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchUpgradeAgentDaemonset(request *model.BatchUpgradeAgentDaemonsetRequest) (*model.BatchUpgradeAgentDaemonsetResponse, error) {
	requestDef := GenReqDefForBatchUpgradeAgentDaemonset()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchUpgradeAgentDaemonsetResponse), nil
	}
}

// BatchUpgradeAgentDaemonsetInvoker 批量升级集群daemonset
func (c *HssClient) BatchUpgradeAgentDaemonsetInvoker(request *model.BatchUpgradeAgentDaemonsetRequest) *BatchUpgradeAgentDaemonsetInvoker {
	requestDef := GenReqDefForBatchUpgradeAgentDaemonset()
	return &BatchUpgradeAgentDaemonsetInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateAgentDaemonset 创建集群daemonset
//
// 创建集群daemonset
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateAgentDaemonset(request *model.CreateAgentDaemonsetRequest) (*model.CreateAgentDaemonsetResponse, error) {
	requestDef := GenReqDefForCreateAgentDaemonset()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateAgentDaemonsetResponse), nil
	}
}

// CreateAgentDaemonsetInvoker 创建集群daemonset
func (c *HssClient) CreateAgentDaemonsetInvoker(request *model.CreateAgentDaemonsetRequest) *CreateAgentDaemonsetInvoker {
	requestDef := GenReqDefForCreateAgentDaemonset()
	return &CreateAgentDaemonsetInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateCicdConfigurationCommand 生成cicd接入配置命令
//
// 生成cicd接入配置命令
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateCicdConfigurationCommand(request *model.CreateCicdConfigurationCommandRequest) (*model.CreateCicdConfigurationCommandResponse, error) {
	requestDef := GenReqDefForCreateCicdConfigurationCommand()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateCicdConfigurationCommandResponse), nil
	}
}

// CreateCicdConfigurationCommandInvoker 生成cicd接入配置命令
func (c *HssClient) CreateCicdConfigurationCommandInvoker(request *model.CreateCicdConfigurationCommandRequest) *CreateCicdConfigurationCommandInvoker {
	requestDef := GenReqDefForCreateCicdConfigurationCommand()
	return &CreateCicdConfigurationCommandInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateMultiCloudClusters 创建多云集群
//
// 创建多云集群
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateMultiCloudClusters(request *model.CreateMultiCloudClustersRequest) (*model.CreateMultiCloudClustersResponse, error) {
	requestDef := GenReqDefForCreateMultiCloudClusters()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateMultiCloudClustersResponse), nil
	}
}

// CreateMultiCloudClustersInvoker 创建多云集群
func (c *HssClient) CreateMultiCloudClustersInvoker(request *model.CreateMultiCloudClustersRequest) *CreateMultiCloudClustersInvoker {
	requestDef := GenReqDefForCreateMultiCloudClusters()
	return &CreateMultiCloudClustersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteAgentDaemonset 删除集群daemonset
//
// 删除集群daemonset
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteAgentDaemonset(request *model.DeleteAgentDaemonsetRequest) (*model.DeleteAgentDaemonsetResponse, error) {
	requestDef := GenReqDefForDeleteAgentDaemonset()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteAgentDaemonsetResponse), nil
	}
}

// DeleteAgentDaemonsetInvoker 删除集群daemonset
func (c *HssClient) DeleteAgentDaemonsetInvoker(request *model.DeleteAgentDaemonsetRequest) *DeleteAgentDaemonsetInvoker {
	requestDef := GenReqDefForDeleteAgentDaemonset()
	return &DeleteAgentDaemonsetInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteCicdConfigurations 删除CI/CD配置
//
// 删除CI/CD配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteCicdConfigurations(request *model.DeleteCicdConfigurationsRequest) (*model.DeleteCicdConfigurationsResponse, error) {
	requestDef := GenReqDefForDeleteCicdConfigurations()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteCicdConfigurationsResponse), nil
	}
}

// DeleteCicdConfigurationsInvoker 删除CI/CD配置
func (c *HssClient) DeleteCicdConfigurationsInvoker(request *model.DeleteCicdConfigurationsRequest) *DeleteCicdConfigurationsInvoker {
	requestDef := GenReqDefForDeleteCicdConfigurations()
	return &DeleteCicdConfigurationsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteRegistry 删除镜像仓接入信息
//
// 删除镜像仓接入信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteRegistry(request *model.DeleteRegistryRequest) (*model.DeleteRegistryResponse, error) {
	requestDef := GenReqDefForDeleteRegistry()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteRegistryResponse), nil
	}
}

// DeleteRegistryInvoker 删除镜像仓接入信息
func (c *HssClient) DeleteRegistryInvoker(request *model.DeleteRegistryRequest) *DeleteRegistryInvoker {
	requestDef := GenReqDefForDeleteRegistry()
	return &DeleteRegistryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportImageSecurityReportTask 创建镜像安全报告信息导出任务（支持全量/批量导出）
//
// 创建镜像安全报告信息导出任务（支持全量/批量导出）,支持导出恶意文件、软件信息、文件信息、敏感信息、软件合规、镜像构建指令风险。
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportImageSecurityReportTask(request *model.ExportImageSecurityReportTaskRequest) (*model.ExportImageSecurityReportTaskResponse, error) {
	requestDef := GenReqDefForExportImageSecurityReportTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportImageSecurityReportTaskResponse), nil
	}
}

// ExportImageSecurityReportTaskInvoker 创建镜像安全报告信息导出任务（支持全量/批量导出）
func (c *HssClient) ExportImageSecurityReportTaskInvoker(request *model.ExportImageSecurityReportTaskRequest) *ExportImageSecurityReportTaskInvoker {
	requestDef := GenReqDefForExportImageSecurityReportTask()
	return &ExportImageSecurityReportTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAgentDaemonsetClusterNodesLabel 获取集群节点标签
//
// 获取集群节点标签
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAgentDaemonsetClusterNodesLabel(request *model.ListAgentDaemonsetClusterNodesLabelRequest) (*model.ListAgentDaemonsetClusterNodesLabelResponse, error) {
	requestDef := GenReqDefForListAgentDaemonsetClusterNodesLabel()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAgentDaemonsetClusterNodesLabelResponse), nil
	}
}

// ListAgentDaemonsetClusterNodesLabelInvoker 获取集群节点标签
func (c *HssClient) ListAgentDaemonsetClusterNodesLabelInvoker(request *model.ListAgentDaemonsetClusterNodesLabelRequest) *ListAgentDaemonsetClusterNodesLabelInvoker {
	requestDef := GenReqDefForListAgentDaemonsetClusterNodesLabel()
	return &ListAgentDaemonsetClusterNodesLabelInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAgentDaemonsetInfo 获取集群daemonset列表
//
// 获取集群daemonset列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAgentDaemonsetInfo(request *model.ListAgentDaemonsetInfoRequest) (*model.ListAgentDaemonsetInfoResponse, error) {
	requestDef := GenReqDefForListAgentDaemonsetInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAgentDaemonsetInfoResponse), nil
	}
}

// ListAgentDaemonsetInfoInvoker 获取集群daemonset列表
func (c *HssClient) ListAgentDaemonsetInfoInvoker(request *model.ListAgentDaemonsetInfoRequest) *ListAgentDaemonsetInfoInvoker {
	requestDef := GenReqDefForListAgentDaemonsetInfo()
	return &ListAgentDaemonsetInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAssociateRegistries 获取镜像同步任务关联的镜像仓的信息
//
// 获取镜像同步任务关联的镜像仓的信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAssociateRegistries(request *model.ListAssociateRegistriesRequest) (*model.ListAssociateRegistriesResponse, error) {
	requestDef := GenReqDefForListAssociateRegistries()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAssociateRegistriesResponse), nil
	}
}

// ListAssociateRegistriesInvoker 获取镜像同步任务关联的镜像仓的信息
func (c *HssClient) ListAssociateRegistriesInvoker(request *model.ListAssociateRegistriesRequest) *ListAssociateRegistriesInvoker {
	requestDef := GenReqDefForListAssociateRegistries()
	return &ListAssociateRegistriesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListCceNodesLabel 获取集群节点标签
//
// 获取集群节点标签
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListCceNodesLabel(request *model.ListCceNodesLabelRequest) (*model.ListCceNodesLabelResponse, error) {
	requestDef := GenReqDefForListCceNodesLabel()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListCceNodesLabelResponse), nil
	}
}

// ListCceNodesLabelInvoker 获取集群节点标签
func (c *HssClient) ListCceNodesLabelInvoker(request *model.ListCceNodesLabelRequest) *ListCceNodesLabelInvoker {
	requestDef := GenReqDefForListCceNodesLabel()
	return &ListCceNodesLabelInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListCicdConfigurations 查询cicd配置列表
//
// 查询cicd配置列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListCicdConfigurations(request *model.ListCicdConfigurationsRequest) (*model.ListCicdConfigurationsResponse, error) {
	requestDef := GenReqDefForListCicdConfigurations()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListCicdConfigurationsResponse), nil
	}
}

// ListCicdConfigurationsInvoker 查询cicd配置列表
func (c *HssClient) ListCicdConfigurationsInvoker(request *model.ListCicdConfigurationsRequest) *ListCicdConfigurationsInvoker {
	requestDef := GenReqDefForListCicdConfigurations()
	return &ListCicdConfigurationsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListCicdImages 查询cicd镜像列表
//
// 查询cicd镜像列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListCicdImages(request *model.ListCicdImagesRequest) (*model.ListCicdImagesResponse, error) {
	requestDef := GenReqDefForListCicdImages()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListCicdImagesResponse), nil
	}
}

// ListCicdImagesInvoker 查询cicd镜像列表
func (c *HssClient) ListCicdImagesInvoker(request *model.ListCicdImagesRequest) *ListCicdImagesInvoker {
	requestDef := GenReqDefForListCicdImages()
	return &ListCicdImagesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListMultiCloudClusters 查询多云集群
//
// 查询多云集群
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListMultiCloudClusters(request *model.ListMultiCloudClustersRequest) (*model.ListMultiCloudClustersResponse, error) {
	requestDef := GenReqDefForListMultiCloudClusters()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListMultiCloudClustersResponse), nil
	}
}

// ListMultiCloudClustersInvoker 查询多云集群
func (c *HssClient) ListMultiCloudClustersInvoker(request *model.ListMultiCloudClustersRequest) *ListMultiCloudClustersInvoker {
	requestDef := GenReqDefForListMultiCloudClusters()
	return &ListMultiCloudClustersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListRegistry 获取镜像仓列表
//
// 获取镜像仓列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListRegistry(request *model.ListRegistryRequest) (*model.ListRegistryResponse, error) {
	requestDef := GenReqDefForListRegistry()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListRegistryResponse), nil
	}
}

// ListRegistryInvoker 获取镜像仓列表
func (c *HssClient) ListRegistryInvoker(request *model.ListRegistryRequest) *ListRegistryInvoker {
	requestDef := GenReqDefForListRegistry()
	return &ListRegistryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListRegistryStatistics 查询镜像仓统计数据
//
// 查询镜像仓统计数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListRegistryStatistics(request *model.ListRegistryStatisticsRequest) (*model.ListRegistryStatisticsResponse, error) {
	requestDef := GenReqDefForListRegistryStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListRegistryStatisticsResponse), nil
	}
}

// ListRegistryStatisticsInvoker 查询镜像仓统计数据
func (c *HssClient) ListRegistryStatisticsInvoker(request *model.ListRegistryStatisticsRequest) *ListRegistryStatisticsInvoker {
	requestDef := GenReqDefForListRegistryStatistics()
	return &ListRegistryStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ModifyCicdConfiguration 修改CI/CD配置
//
// 修改CI/CD配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ModifyCicdConfiguration(request *model.ModifyCicdConfigurationRequest) (*model.ModifyCicdConfigurationResponse, error) {
	requestDef := GenReqDefForModifyCicdConfiguration()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ModifyCicdConfigurationResponse), nil
	}
}

// ModifyCicdConfigurationInvoker 修改CI/CD配置
func (c *HssClient) ModifyCicdConfigurationInvoker(request *model.ModifyCicdConfigurationRequest) *ModifyCicdConfigurationInvoker {
	requestDef := GenReqDefForModifyCicdConfiguration()
	return &ModifyCicdConfigurationInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ParseMultiCloudClusterConfig 解析多云集群的配置文件
//
// 解析多云集群的配置文件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ParseMultiCloudClusterConfig(request *model.ParseMultiCloudClusterConfigRequest) (*model.ParseMultiCloudClusterConfigResponse, error) {
	requestDef := GenReqDefForParseMultiCloudClusterConfig()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ParseMultiCloudClusterConfigResponse), nil
	}
}

// ParseMultiCloudClusterConfigInvoker 解析多云集群的配置文件
func (c *HssClient) ParseMultiCloudClusterConfigInvoker(request *model.ParseMultiCloudClusterConfigRequest) *ParseMultiCloudClusterConfigInvoker {
	requestDef := GenReqDefForParseMultiCloudClusterConfig()
	return &ParseMultiCloudClusterConfigInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RemoveMultiCloudClusters 删除多云集群
//
// 删除多云集群
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RemoveMultiCloudClusters(request *model.RemoveMultiCloudClustersRequest) (*model.RemoveMultiCloudClustersResponse, error) {
	requestDef := GenReqDefForRemoveMultiCloudClusters()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RemoveMultiCloudClustersResponse), nil
	}
}

// RemoveMultiCloudClustersInvoker 删除多云集群
func (c *HssClient) RemoveMultiCloudClustersInvoker(request *model.RemoveMultiCloudClustersRequest) *RemoveMultiCloudClustersInvoker {
	requestDef := GenReqDefForRemoveMultiCloudClusters()
	return &RemoveMultiCloudClustersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAgentAddress 集群公网接入方式网络配置信息
//
// 集群公网接入方式网络配置信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAgentAddress(request *model.ShowAgentAddressRequest) (*model.ShowAgentAddressResponse, error) {
	requestDef := GenReqDefForShowAgentAddress()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAgentAddressResponse), nil
	}
}

// ShowAgentAddressInvoker 集群公网接入方式网络配置信息
func (c *HssClient) ShowAgentAddressInvoker(request *model.ShowAgentAddressRequest) *ShowAgentAddressInvoker {
	requestDef := GenReqDefForShowAgentAddress()
	return &ShowAgentAddressInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAgentDaemonsetDeployTemplate 获取部署模板
//
// 获取部署模板，在安装Daemonset的时候提供选择
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAgentDaemonsetDeployTemplate(request *model.ShowAgentDaemonsetDeployTemplateRequest) (*model.ShowAgentDaemonsetDeployTemplateResponse, error) {
	requestDef := GenReqDefForShowAgentDaemonsetDeployTemplate()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAgentDaemonsetDeployTemplateResponse), nil
	}
}

// ShowAgentDaemonsetDeployTemplateInvoker 获取部署模板
func (c *HssClient) ShowAgentDaemonsetDeployTemplateInvoker(request *model.ShowAgentDaemonsetDeployTemplateRequest) *ShowAgentDaemonsetDeployTemplateInvoker {
	requestDef := GenReqDefForShowAgentDaemonsetDeployTemplate()
	return &ShowAgentDaemonsetDeployTemplateInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAgentDaemonsetDetailInfo 获取集群daemonset信息
//
// 获取集群daemonset信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAgentDaemonsetDetailInfo(request *model.ShowAgentDaemonsetDetailInfoRequest) (*model.ShowAgentDaemonsetDetailInfoResponse, error) {
	requestDef := GenReqDefForShowAgentDaemonsetDetailInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAgentDaemonsetDetailInfoResponse), nil
	}
}

// ShowAgentDaemonsetDetailInfoInvoker 获取集群daemonset信息
func (c *HssClient) ShowAgentDaemonsetDetailInfoInvoker(request *model.ShowAgentDaemonsetDetailInfoRequest) *ShowAgentDaemonsetDetailInfoInvoker {
	requestDef := GenReqDefForShowAgentDaemonsetDetailInfo()
	return &ShowAgentDaemonsetDetailInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowCicdConfiguration 查询CI/CD配置信息
//
// 查询CI/CD配置信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowCicdConfiguration(request *model.ShowCicdConfigurationRequest) (*model.ShowCicdConfigurationResponse, error) {
	requestDef := GenReqDefForShowCicdConfiguration()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowCicdConfigurationResponse), nil
	}
}

// ShowCicdConfigurationInvoker 查询CI/CD配置信息
func (c *HssClient) ShowCicdConfigurationInvoker(request *model.ShowCicdConfigurationRequest) *ShowCicdConfigurationInvoker {
	requestDef := GenReqDefForShowCicdConfiguration()
	return &ShowCicdConfigurationInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowImageUploadCommand 获取扫描组件镜像上传指令
//
// 获取镜像上传指令，上传的镜像是“镜像仓接入功能”和“镜像仓扫描功能”需要的组件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowImageUploadCommand(request *model.ShowImageUploadCommandRequest) (*model.ShowImageUploadCommandResponse, error) {
	requestDef := GenReqDefForShowImageUploadCommand()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowImageUploadCommandResponse), nil
	}
}

// ShowImageUploadCommandInvoker 获取扫描组件镜像上传指令
func (c *HssClient) ShowImageUploadCommandInvoker(request *model.ShowImageUploadCommandRequest) *ShowImageUploadCommandInvoker {
	requestDef := GenReqDefForShowImageUploadCommand()
	return &ShowImageUploadCommandInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowMultiCloudClusterAuth 获取多云集群的账号权限
//
// 获取多云集群的账号权限
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowMultiCloudClusterAuth(request *model.ShowMultiCloudClusterAuthRequest) (*model.ShowMultiCloudClusterAuthResponse, error) {
	requestDef := GenReqDefForShowMultiCloudClusterAuth()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowMultiCloudClusterAuthResponse), nil
	}
}

// ShowMultiCloudClusterAuthInvoker 获取多云集群的账号权限
func (c *HssClient) ShowMultiCloudClusterAuthInvoker(request *model.ShowMultiCloudClusterAuthRequest) *ShowMultiCloudClusterAuthInvoker {
	requestDef := GenReqDefForShowMultiCloudClusterAuth()
	return &ShowMultiCloudClusterAuthInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowMultiCloudClusterImageCommand 获取多云集群的上传镜像指令
//
// 获取多云集群的上传镜像指令
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowMultiCloudClusterImageCommand(request *model.ShowMultiCloudClusterImageCommandRequest) (*model.ShowMultiCloudClusterImageCommandResponse, error) {
	requestDef := GenReqDefForShowMultiCloudClusterImageCommand()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowMultiCloudClusterImageCommandResponse), nil
	}
}

// ShowMultiCloudClusterImageCommandInvoker 获取多云集群的上传镜像指令
func (c *HssClient) ShowMultiCloudClusterImageCommandInvoker(request *model.ShowMultiCloudClusterImageCommandRequest) *ShowMultiCloudClusterImageCommandInvoker {
	requestDef := GenReqDefForShowMultiCloudClusterImageCommand()
	return &ShowMultiCloudClusterImageCommandInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowMultiCloudClusterProxyScript 获取多云集群的代理安装脚本
//
// 获取多云集群的代理安装脚本
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowMultiCloudClusterProxyScript(request *model.ShowMultiCloudClusterProxyScriptRequest) (*model.ShowMultiCloudClusterProxyScriptResponse, error) {
	requestDef := GenReqDefForShowMultiCloudClusterProxyScript()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowMultiCloudClusterProxyScriptResponse), nil
	}
}

// ShowMultiCloudClusterProxyScriptInvoker 获取多云集群的代理安装脚本
func (c *HssClient) ShowMultiCloudClusterProxyScriptInvoker(request *model.ShowMultiCloudClusterProxyScriptRequest) *ShowMultiCloudClusterProxyScriptInvoker {
	requestDef := GenReqDefForShowMultiCloudClusterProxyScript()
	return &ShowMultiCloudClusterProxyScriptInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SyncMultiCloudClusterStatus 同步多云集群的接入状态
//
// 同步多云集群的接入状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SyncMultiCloudClusterStatus(request *model.SyncMultiCloudClusterStatusRequest) (*model.SyncMultiCloudClusterStatusResponse, error) {
	requestDef := GenReqDefForSyncMultiCloudClusterStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SyncMultiCloudClusterStatusResponse), nil
	}
}

// SyncMultiCloudClusterStatusInvoker 同步多云集群的接入状态
func (c *HssClient) SyncMultiCloudClusterStatusInvoker(request *model.SyncMultiCloudClusterStatusRequest) *SyncMultiCloudClusterStatusInvoker {
	requestDef := GenReqDefForSyncMultiCloudClusterStatus()
	return &SyncMultiCloudClusterStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateAgentDaemonset 更新集群daemonset
//
// 更新集群daemonset
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateAgentDaemonset(request *model.UpdateAgentDaemonsetRequest) (*model.UpdateAgentDaemonsetResponse, error) {
	requestDef := GenReqDefForUpdateAgentDaemonset()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateAgentDaemonsetResponse), nil
	}
}

// UpdateAgentDaemonsetInvoker 更新集群daemonset
func (c *HssClient) UpdateAgentDaemonsetInvoker(request *model.UpdateAgentDaemonsetRequest) *UpdateAgentDaemonsetInvoker {
	requestDef := GenReqDefForUpdateAgentDaemonset()
	return &UpdateAgentDaemonsetInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateMultiCloudClusters 更新多云集群
//
// 更新多云集群
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateMultiCloudClusters(request *model.UpdateMultiCloudClustersRequest) (*model.UpdateMultiCloudClustersResponse, error) {
	requestDef := GenReqDefForUpdateMultiCloudClusters()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateMultiCloudClustersResponse), nil
	}
}

// UpdateMultiCloudClustersInvoker 更新多云集群
func (c *HssClient) UpdateMultiCloudClustersInvoker(request *model.UpdateMultiCloudClustersRequest) *UpdateMultiCloudClustersInvoker {
	requestDef := GenReqDefForUpdateMultiCloudClusters()
	return &UpdateMultiCloudClustersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateRegistry 编辑镜像仓接入信息
//
// 编辑镜像仓接入信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateRegistry(request *model.UpdateRegistryRequest) (*model.UpdateRegistryResponse, error) {
	requestDef := GenReqDefForUpdateRegistry()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateRegistryResponse), nil
	}
}

// UpdateRegistryInvoker 编辑镜像仓接入信息
func (c *HssClient) UpdateRegistryInvoker(request *model.UpdateRegistryRequest) *UpdateRegistryInvoker {
	requestDef := GenReqDefForUpdateRegistry()
	return &UpdateRegistryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListFileEvents 变更文件列表
//
// 变更文件列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListFileEvents(request *model.ListFileEventsRequest) (*model.ListFileEventsResponse, error) {
	requestDef := GenReqDefForListFileEvents()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListFileEventsResponse), nil
	}
}

// ListFileEventsInvoker 变更文件列表
func (c *HssClient) ListFileEventsInvoker(request *model.ListFileEventsRequest) *ListFileEventsInvoker {
	requestDef := GenReqDefForListFileEvents()
	return &ListFileEventsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListFileHostEventDetails 某个服务器变更文件信息
//
// 某个服务器变更文件信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListFileHostEventDetails(request *model.ListFileHostEventDetailsRequest) (*model.ListFileHostEventDetailsResponse, error) {
	requestDef := GenReqDefForListFileHostEventDetails()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListFileHostEventDetailsResponse), nil
	}
}

// ListFileHostEventDetailsInvoker 某个服务器变更文件信息
func (c *HssClient) ListFileHostEventDetailsInvoker(request *model.ListFileHostEventDetailsRequest) *ListFileHostEventDetailsInvoker {
	requestDef := GenReqDefForListFileHostEventDetails()
	return &ListFileHostEventDetailsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListFileHosts 云服务器变更列表
//
// 云服务器变更列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListFileHosts(request *model.ListFileHostsRequest) (*model.ListFileHostsResponse, error) {
	requestDef := GenReqDefForListFileHosts()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListFileHostsResponse), nil
	}
}

// ListFileHostsInvoker 云服务器变更列表
func (c *HssClient) ListFileHostsInvoker(request *model.ListFileHostsRequest) *ListFileHostsInvoker {
	requestDef := GenReqDefForListFileHosts()
	return &ListFileHostsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowFileStatistic 获取服务器文件统计信息
//
// 获取服务器文件统计信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowFileStatistic(request *model.ShowFileStatisticRequest) (*model.ShowFileStatisticResponse, error) {
	requestDef := GenReqDefForShowFileStatistic()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowFileStatisticResponse), nil
	}
}

// ShowFileStatisticInvoker 获取服务器文件统计信息
func (c *HssClient) ShowFileStatisticInvoker(request *model.ShowFileStatisticRequest) *ShowFileStatisticInvoker {
	requestDef := GenReqDefForShowFileStatistic()
	return &ShowFileStatisticInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddHostsGroup 创建服务器组
//
// 创建服务器组
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddHostsGroup(request *model.AddHostsGroupRequest) (*model.AddHostsGroupResponse, error) {
	requestDef := GenReqDefForAddHostsGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddHostsGroupResponse), nil
	}
}

// AddHostsGroupInvoker 创建服务器组
func (c *HssClient) AddHostsGroupInvoker(request *model.AddHostsGroupRequest) *AddHostsGroupInvoker {
	requestDef := GenReqDefForAddHostsGroup()
	return &AddHostsGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AssociateHostAssetValue 关联资产重要性
//
// 关联资产重要性
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AssociateHostAssetValue(request *model.AssociateHostAssetValueRequest) (*model.AssociateHostAssetValueResponse, error) {
	requestDef := GenReqDefForAssociateHostAssetValue()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AssociateHostAssetValueResponse), nil
	}
}

// AssociateHostAssetValueInvoker 关联资产重要性
func (c *HssClient) AssociateHostAssetValueInvoker(request *model.AssociateHostAssetValueRequest) *AssociateHostAssetValueInvoker {
	requestDef := GenReqDefForAssociateHostAssetValue()
	return &AssociateHostAssetValueInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AssociateHostsGroup 分配到组
//
// 分配到组
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AssociateHostsGroup(request *model.AssociateHostsGroupRequest) (*model.AssociateHostsGroupResponse, error) {
	requestDef := GenReqDefForAssociateHostsGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AssociateHostsGroupResponse), nil
	}
}

// AssociateHostsGroupInvoker 分配到组
func (c *HssClient) AssociateHostsGroupInvoker(request *model.AssociateHostsGroupRequest) *AssociateHostsGroupInvoker {
	requestDef := GenReqDefForAssociateHostsGroup()
	return &AssociateHostsGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeAutoOpenQuotaStatus 开启或关闭“自动绑定配额”配置开关
//
// 开启或关闭“自动绑定配额”配置开关
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeAutoOpenQuotaStatus(request *model.ChangeAutoOpenQuotaStatusRequest) (*model.ChangeAutoOpenQuotaStatusResponse, error) {
	requestDef := GenReqDefForChangeAutoOpenQuotaStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeAutoOpenQuotaStatusResponse), nil
	}
}

// ChangeAutoOpenQuotaStatusInvoker 开启或关闭“自动绑定配额”配置开关
func (c *HssClient) ChangeAutoOpenQuotaStatusInvoker(request *model.ChangeAutoOpenQuotaStatusRequest) *ChangeAutoOpenQuotaStatusInvoker {
	requestDef := GenReqDefForChangeAutoOpenQuotaStatus()
	return &ChangeAutoOpenQuotaStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeHostIgnoreStatus 忽略/取消忽略主机
//
// 忽略/取消忽略主机
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeHostIgnoreStatus(request *model.ChangeHostIgnoreStatusRequest) (*model.ChangeHostIgnoreStatusResponse, error) {
	requestDef := GenReqDefForChangeHostIgnoreStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeHostIgnoreStatusResponse), nil
	}
}

// ChangeHostIgnoreStatusInvoker 忽略/取消忽略主机
func (c *HssClient) ChangeHostIgnoreStatusInvoker(request *model.ChangeHostIgnoreStatusRequest) *ChangeHostIgnoreStatusInvoker {
	requestDef := GenReqDefForChangeHostIgnoreStatus()
	return &ChangeHostIgnoreStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeHostsGroup 编辑服务器组
//
// 编辑服务器组
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeHostsGroup(request *model.ChangeHostsGroupRequest) (*model.ChangeHostsGroupResponse, error) {
	requestDef := GenReqDefForChangeHostsGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeHostsGroupResponse), nil
	}
}

// ChangeHostsGroupInvoker 编辑服务器组
func (c *HssClient) ChangeHostsGroupInvoker(request *model.ChangeHostsGroupRequest) *ChangeHostsGroupInvoker {
	requestDef := GenReqDefForChangeHostsGroup()
	return &ChangeHostsGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateVpcEndpoint 创建VPC终端节点的创建
//
// 创建VPC终端节点的创建
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateVpcEndpoint(request *model.CreateVpcEndpointRequest) (*model.CreateVpcEndpointResponse, error) {
	requestDef := GenReqDefForCreateVpcEndpoint()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateVpcEndpointResponse), nil
	}
}

// CreateVpcEndpointInvoker 创建VPC终端节点的创建
func (c *HssClient) CreateVpcEndpointInvoker(request *model.CreateVpcEndpointRequest) *CreateVpcEndpointInvoker {
	requestDef := GenReqDefForCreateVpcEndpoint()
	return &CreateVpcEndpointInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteHostsGroup 删除服务器组
//
// 删除服务器组
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteHostsGroup(request *model.DeleteHostsGroupRequest) (*model.DeleteHostsGroupResponse, error) {
	requestDef := GenReqDefForDeleteHostsGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteHostsGroupResponse), nil
	}
}

// DeleteHostsGroupInvoker 删除服务器组
func (c *HssClient) DeleteHostsGroupInvoker(request *model.DeleteHostsGroupRequest) *DeleteHostsGroupInvoker {
	requestDef := GenReqDefForDeleteHostsGroup()
	return &DeleteHostsGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAutoOpenQuotaStatus 查询“自动绑定配额”配置开关状态
//
// 查询“自动绑定配额”配置开关状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAutoOpenQuotaStatus(request *model.ListAutoOpenQuotaStatusRequest) (*model.ListAutoOpenQuotaStatusResponse, error) {
	requestDef := GenReqDefForListAutoOpenQuotaStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAutoOpenQuotaStatusResponse), nil
	}
}

// ListAutoOpenQuotaStatusInvoker 查询“自动绑定配额”配置开关状态
func (c *HssClient) ListAutoOpenQuotaStatusInvoker(request *model.ListAutoOpenQuotaStatusRequest) *ListAutoOpenQuotaStatusInvoker {
	requestDef := GenReqDefForListAutoOpenQuotaStatus()
	return &ListAutoOpenQuotaStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListHostGroups 查询服务器组列表
//
// 查询服务器组列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListHostGroups(request *model.ListHostGroupsRequest) (*model.ListHostGroupsResponse, error) {
	requestDef := GenReqDefForListHostGroups()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListHostGroupsResponse), nil
	}
}

// ListHostGroupsInvoker 查询服务器组列表
func (c *HssClient) ListHostGroupsInvoker(request *model.ListHostGroupsRequest) *ListHostGroupsInvoker {
	requestDef := GenReqDefForListHostGroups()
	return &ListHostGroupsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListHostStatus 查询云服务器列表
//
// 查询云服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListHostStatus(request *model.ListHostStatusRequest) (*model.ListHostStatusResponse, error) {
	requestDef := GenReqDefForListHostStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListHostStatusResponse), nil
	}
}

// ListHostStatusInvoker 查询云服务器列表
func (c *HssClient) ListHostStatusInvoker(request *model.ListHostStatusRequest) *ListHostStatusInvoker {
	requestDef := GenReqDefForListHostStatus()
	return &ListHostStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListHostsRisk ECS风险状况
//
// ECS风险状况
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListHostsRisk(request *model.ListHostsRiskRequest) (*model.ListHostsRiskResponse, error) {
	requestDef := GenReqDefForListHostsRisk()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListHostsRiskResponse), nil
	}
}

// ListHostsRiskInvoker ECS风险状况
func (c *HssClient) ListHostsRiskInvoker(request *model.ListHostsRiskRequest) *ListHostsRiskInvoker {
	requestDef := GenReqDefForListHostsRisk()
	return &ListHostsRiskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListPolicies 查询主机策略列表
//
// 查询主机策略列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListPolicies(request *model.ListPoliciesRequest) (*model.ListPoliciesResponse, error) {
	requestDef := GenReqDefForListPolicies()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListPoliciesResponse), nil
	}
}

// ListPoliciesInvoker 查询主机策略列表
func (c *HssClient) ListPoliciesInvoker(request *model.ListPoliciesRequest) *ListPoliciesInvoker {
	requestDef := GenReqDefForListPolicies()
	return &ListPoliciesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SetManualDetect 下发手动检测
//
// 下发手动检测
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SetManualDetect(request *model.SetManualDetectRequest) (*model.SetManualDetectResponse, error) {
	requestDef := GenReqDefForSetManualDetect()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SetManualDetectResponse), nil
	}
}

// SetManualDetectInvoker 下发手动检测
func (c *HssClient) SetManualDetectInvoker(request *model.SetManualDetectRequest) *SetManualDetectInvoker {
	requestDef := GenReqDefForSetManualDetect()
	return &SetManualDetectInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowEndpointStatus 查询每个主机的终端节点的创建状态
//
// 查询每个主机的终端节点的创建状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowEndpointStatus(request *model.ShowEndpointStatusRequest) (*model.ShowEndpointStatusResponse, error) {
	requestDef := GenReqDefForShowEndpointStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowEndpointStatusResponse), nil
	}
}

// ShowEndpointStatusInvoker 查询每个主机的终端节点的创建状态
func (c *HssClient) ShowEndpointStatusInvoker(request *model.ShowEndpointStatusRequest) *ShowEndpointStatusInvoker {
	requestDef := GenReqDefForShowEndpointStatus()
	return &ShowEndpointStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowHostsStatistics 统计服务器数据
//
// 统计服务器数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowHostsStatistics(request *model.ShowHostsStatisticsRequest) (*model.ShowHostsStatisticsResponse, error) {
	requestDef := GenReqDefForShowHostsStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowHostsStatisticsResponse), nil
	}
}

// ShowHostsStatisticsInvoker 统计服务器数据
func (c *HssClient) ShowHostsStatisticsInvoker(request *model.ShowHostsStatisticsRequest) *ShowHostsStatisticsInvoker {
	requestDef := GenReqDefForShowHostsStatistics()
	return &ShowHostsStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowScanStatus 查询手动检测状态
//
// 查询手动检测状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowScanStatus(request *model.ShowScanStatusRequest) (*model.ShowScanStatusResponse, error) {
	requestDef := GenReqDefForShowScanStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowScanStatusResponse), nil
	}
}

// ShowScanStatusInvoker 查询手动检测状态
func (c *HssClient) ShowScanStatusInvoker(request *model.ShowScanStatusRequest) *ShowScanStatusInvoker {
	requestDef := GenReqDefForShowScanStatus()
	return &ShowScanStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchFirewallStatus 修改防火墙授权状态
//
// 修改防火墙授权状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchFirewallStatus(request *model.SwitchFirewallStatusRequest) (*model.SwitchFirewallStatusResponse, error) {
	requestDef := GenReqDefForSwitchFirewallStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchFirewallStatusResponse), nil
	}
}

// SwitchFirewallStatusInvoker 修改防火墙授权状态
func (c *HssClient) SwitchFirewallStatusInvoker(request *model.SwitchFirewallStatusRequest) *SwitchFirewallStatusInvoker {
	requestDef := GenReqDefForSwitchFirewallStatus()
	return &SwitchFirewallStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchHostsProtectStatus 切换防护状态
//
// 切换防护状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchHostsProtectStatus(request *model.SwitchHostsProtectStatusRequest) (*model.SwitchHostsProtectStatusResponse, error) {
	requestDef := GenReqDefForSwitchHostsProtectStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchHostsProtectStatusResponse), nil
	}
}

// SwitchHostsProtectStatusInvoker 切换防护状态
func (c *HssClient) SwitchHostsProtectStatusInvoker(request *model.SwitchHostsProtectStatusRequest) *SwitchHostsProtectStatusInvoker {
	requestDef := GenReqDefForSwitchHostsProtectStatus()
	return &SwitchHostsProtectStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UninstallAgents 卸载Agent
//
// 卸载Agent
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UninstallAgents(request *model.UninstallAgentsRequest) (*model.UninstallAgentsResponse, error) {
	requestDef := GenReqDefForUninstallAgents()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UninstallAgentsResponse), nil
	}
}

// UninstallAgentsInvoker 卸载Agent
func (c *HssClient) UninstallAgentsInvoker(request *model.UninstallAgentsRequest) *UninstallAgentsInvoker {
	requestDef := GenReqDefForUninstallAgents()
	return &UninstallAgentsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpgradeAgents 升级Agent
//
// 升级Agent
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpgradeAgents(request *model.UpgradeAgentsRequest) (*model.UpgradeAgentsResponse, error) {
	requestDef := GenReqDefForUpgradeAgents()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpgradeAgentsResponse), nil
	}
}

// UpgradeAgentsInvoker 升级Agent
func (c *HssClient) UpgradeAgentsInvoker(request *model.UpgradeAgentsRequest) *UpgradeAgentsInvoker {
	requestDef := GenReqDefForUpgradeAgents()
	return &UpgradeAgentsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListIacFileRiskPaths 获取iac文件风险路径列表
//
// 获取iac文件风险路径列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListIacFileRiskPaths(request *model.ListIacFileRiskPathsRequest) (*model.ListIacFileRiskPathsResponse, error) {
	requestDef := GenReqDefForListIacFileRiskPaths()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListIacFileRiskPathsResponse), nil
	}
}

// ListIacFileRiskPathsInvoker 获取iac文件风险路径列表
func (c *HssClient) ListIacFileRiskPathsInvoker(request *model.ListIacFileRiskPathsRequest) *ListIacFileRiskPathsInvoker {
	requestDef := GenReqDefForListIacFileRiskPaths()
	return &ListIacFileRiskPathsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListIacFileRisks 获取iac文件风险列表
//
// 获取iac文件风险列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListIacFileRisks(request *model.ListIacFileRisksRequest) (*model.ListIacFileRisksResponse, error) {
	requestDef := GenReqDefForListIacFileRisks()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListIacFileRisksResponse), nil
	}
}

// ListIacFileRisksInvoker 获取iac文件风险列表
func (c *HssClient) ListIacFileRisksInvoker(request *model.ListIacFileRisksRequest) *ListIacFileRisksInvoker {
	requestDef := GenReqDefForListIacFileRisks()
	return &ListIacFileRisksInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListIacFiles 获取iac文件列表
//
// 获取iac文件列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListIacFiles(request *model.ListIacFilesRequest) (*model.ListIacFilesResponse, error) {
	requestDef := GenReqDefForListIacFiles()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListIacFilesResponse), nil
	}
}

// ListIacFilesInvoker 获取iac文件列表
func (c *HssClient) ListIacFilesInvoker(request *model.ListIacFilesRequest) *ListIacFilesInvoker {
	requestDef := GenReqDefForListIacFiles()
	return &ListIacFilesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddImageWhiteLists 新增镜像白名单
//
// 新增镜像白名单，目前仅支持漏洞白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddImageWhiteLists(request *model.AddImageWhiteListsRequest) (*model.AddImageWhiteListsResponse, error) {
	requestDef := GenReqDefForAddImageWhiteLists()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddImageWhiteListsResponse), nil
	}
}

// AddImageWhiteListsInvoker 新增镜像白名单
func (c *HssClient) AddImageWhiteListsInvoker(request *model.AddImageWhiteListsRequest) *AddImageWhiteListsInvoker {
	requestDef := GenReqDefForAddImageWhiteLists()
	return &AddImageWhiteListsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchExportBaselineTask 镜像仓库基线检查批量导出（支持全量导出）
//
// 镜像仓库基线检查批量导出（支持全量导出）,若导出镜像类型为cicd类型的数据，需要传参image_type为cicd
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchExportBaselineTask(request *model.BatchExportBaselineTaskRequest) (*model.BatchExportBaselineTaskResponse, error) {
	requestDef := GenReqDefForBatchExportBaselineTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchExportBaselineTaskResponse), nil
	}
}

// BatchExportBaselineTaskInvoker 镜像仓库基线检查批量导出（支持全量导出）
func (c *HssClient) BatchExportBaselineTaskInvoker(request *model.BatchExportBaselineTaskRequest) *BatchExportBaselineTaskInvoker {
	requestDef := GenReqDefForBatchExportBaselineTask()
	return &BatchExportBaselineTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchExportLocalVulTask 本地镜像漏洞批量导出（支持全量导出）
//
// 本地镜像漏洞批量导出（支持全量导出）
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchExportLocalVulTask(request *model.BatchExportLocalVulTaskRequest) (*model.BatchExportLocalVulTaskResponse, error) {
	requestDef := GenReqDefForBatchExportLocalVulTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchExportLocalVulTaskResponse), nil
	}
}

// BatchExportLocalVulTaskInvoker 本地镜像漏洞批量导出（支持全量导出）
func (c *HssClient) BatchExportLocalVulTaskInvoker(request *model.BatchExportLocalVulTaskRequest) *BatchExportLocalVulTaskInvoker {
	requestDef := GenReqDefForBatchExportLocalVulTask()
	return &BatchExportLocalVulTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchScanLocalImage 本地镜像扫描
//
// 本地镜像扫描
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchScanLocalImage(request *model.BatchScanLocalImageRequest) (*model.BatchScanLocalImageResponse, error) {
	requestDef := GenReqDefForBatchScanLocalImage()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchScanLocalImageResponse), nil
	}
}

// BatchScanLocalImageInvoker 本地镜像扫描
func (c *HssClient) BatchScanLocalImageInvoker(request *model.BatchScanLocalImageRequest) *BatchScanLocalImageInvoker {
	requestDef := GenReqDefForBatchScanLocalImage()
	return &BatchScanLocalImageInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchScanSwrImage 镜像仓库镜像批量扫描--接口已废弃
//
// 镜像仓库镜像批量扫描--接口已废弃
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchScanSwrImage(request *model.BatchScanSwrImageRequest) (*model.BatchScanSwrImageResponse, error) {
	requestDef := GenReqDefForBatchScanSwrImage()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchScanSwrImageResponse), nil
	}
}

// BatchScanSwrImageInvoker 镜像仓库镜像批量扫描--接口已废弃
func (c *HssClient) BatchScanSwrImageInvoker(request *model.BatchScanSwrImageRequest) *BatchScanSwrImageInvoker {
	requestDef := GenReqDefForBatchScanSwrImage()
	return &BatchScanSwrImageInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeExtendedWeakPassword 修改镜像的自定义弱口令
//
// 修改镜像的自定义弱口令
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeExtendedWeakPassword(request *model.ChangeExtendedWeakPasswordRequest) (*model.ChangeExtendedWeakPasswordResponse, error) {
	requestDef := GenReqDefForChangeExtendedWeakPassword()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeExtendedWeakPasswordResponse), nil
	}
}

// ChangeExtendedWeakPasswordInvoker 修改镜像的自定义弱口令
func (c *HssClient) ChangeExtendedWeakPasswordInvoker(request *model.ChangeExtendedWeakPasswordRequest) *ChangeExtendedWeakPasswordInvoker {
	requestDef := GenReqDefForChangeExtendedWeakPassword()
	return &ChangeExtendedWeakPasswordInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeFilePathWhiteDetail 修改镜像的敏感信息文件路径白名单--接口已废弃
//
// 修改镜像的敏感信息文件路径白名单--接口已废弃
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeFilePathWhiteDetail(request *model.ChangeFilePathWhiteDetailRequest) (*model.ChangeFilePathWhiteDetailResponse, error) {
	requestDef := GenReqDefForChangeFilePathWhiteDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeFilePathWhiteDetailResponse), nil
	}
}

// ChangeFilePathWhiteDetailInvoker 修改镜像的敏感信息文件路径白名单--接口已废弃
func (c *HssClient) ChangeFilePathWhiteDetailInvoker(request *model.ChangeFilePathWhiteDetailRequest) *ChangeFilePathWhiteDetailInvoker {
	requestDef := GenReqDefForChangeFilePathWhiteDetail()
	return &ChangeFilePathWhiteDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeFilePathWhiteLists 修改镜像的敏感信息文件路径白名单
//
// 修改镜像的敏感信息文件路径白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeFilePathWhiteLists(request *model.ChangeFilePathWhiteListsRequest) (*model.ChangeFilePathWhiteListsResponse, error) {
	requestDef := GenReqDefForChangeFilePathWhiteLists()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeFilePathWhiteListsResponse), nil
	}
}

// ChangeFilePathWhiteListsInvoker 修改镜像的敏感信息文件路径白名单
func (c *HssClient) ChangeFilePathWhiteListsInvoker(request *model.ChangeFilePathWhiteListsRequest) *ChangeFilePathWhiteListsInvoker {
	requestDef := GenReqDefForChangeFilePathWhiteLists()
	return &ChangeFilePathWhiteListsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeImageWhiteList 修改镜像白名单配置信息
//
// 修改镜像白名单配置信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeImageWhiteList(request *model.ChangeImageWhiteListRequest) (*model.ChangeImageWhiteListResponse, error) {
	requestDef := GenReqDefForChangeImageWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeImageWhiteListResponse), nil
	}
}

// ChangeImageWhiteListInvoker 修改镜像白名单配置信息
func (c *HssClient) ChangeImageWhiteListInvoker(request *model.ChangeImageWhiteListRequest) *ChangeImageWhiteListInvoker {
	requestDef := GenReqDefForChangeImageWhiteList()
	return &ChangeImageWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeSensitiveInfo 敏感信息操作处理
//
// 敏感信息操作处理
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeSensitiveInfo(request *model.ChangeSensitiveInfoRequest) (*model.ChangeSensitiveInfoResponse, error) {
	requestDef := GenReqDefForChangeSensitiveInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeSensitiveInfoResponse), nil
	}
}

// ChangeSensitiveInfoInvoker 敏感信息操作处理
func (c *HssClient) ChangeSensitiveInfoInvoker(request *model.ChangeSensitiveInfoRequest) *ChangeSensitiveInfoInvoker {
	requestDef := GenReqDefForChangeSensitiveInfo()
	return &ChangeSensitiveInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteImageWhiteLists 删除镜像白名单
//
// 删除镜像白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteImageWhiteLists(request *model.DeleteImageWhiteListsRequest) (*model.DeleteImageWhiteListsResponse, error) {
	requestDef := GenReqDefForDeleteImageWhiteLists()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteImageWhiteListsResponse), nil
	}
}

// DeleteImageWhiteListsInvoker 删除镜像白名单
func (c *HssClient) DeleteImageWhiteListsInvoker(request *model.DeleteImageWhiteListsRequest) *DeleteImageWhiteListsInvoker {
	requestDef := GenReqDefForDeleteImageWhiteLists()
	return &DeleteImageWhiteListsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// HandleImageVulnerability 处置镜像漏洞
//
// 处置镜像漏洞
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) HandleImageVulnerability(request *model.HandleImageVulnerabilityRequest) (*model.HandleImageVulnerabilityResponse, error) {
	requestDef := GenReqDefForHandleImageVulnerability()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.HandleImageVulnerabilityResponse), nil
	}
}

// HandleImageVulnerabilityInvoker 处置镜像漏洞
func (c *HssClient) HandleImageVulnerabilityInvoker(request *model.HandleImageVulnerabilityRequest) *HandleImageVulnerabilityInvoker {
	requestDef := GenReqDefForHandleImageVulnerability()
	return &HandleImageVulnerabilityInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListCheckRuleResources 查询配置检查项影响到的资源列表
//
// 查询配置检查项影响到的资源列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListCheckRuleResources(request *model.ListCheckRuleResourcesRequest) (*model.ListCheckRuleResourcesResponse, error) {
	requestDef := GenReqDefForListCheckRuleResources()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListCheckRuleResourcesResponse), nil
	}
}

// ListCheckRuleResourcesInvoker 查询配置检查项影响到的资源列表
func (c *HssClient) ListCheckRuleResourcesInvoker(request *model.ListCheckRuleResourcesRequest) *ListCheckRuleResourcesInvoker {
	requestDef := GenReqDefForListCheckRuleResources()
	return &ListCheckRuleResourcesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListCheckRulesInfo 查询基线检查的配置检查信息
//
// 查询基线检查的配置检查信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListCheckRulesInfo(request *model.ListCheckRulesInfoRequest) (*model.ListCheckRulesInfoResponse, error) {
	requestDef := GenReqDefForListCheckRulesInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListCheckRulesInfoResponse), nil
	}
}

// ListCheckRulesInfoInvoker 查询基线检查的配置检查信息
func (c *HssClient) ListCheckRulesInfoInvoker(request *model.ListCheckRulesInfoRequest) *ListCheckRulesInfoInvoker {
	requestDef := GenReqDefForListCheckRulesInfo()
	return &ListCheckRulesInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListContainerImageLogs 查询容器镜像操作日志
//
// 查询容器镜像操作日志
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListContainerImageLogs(request *model.ListContainerImageLogsRequest) (*model.ListContainerImageLogsResponse, error) {
	requestDef := GenReqDefForListContainerImageLogs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListContainerImageLogsResponse), nil
	}
}

// ListContainerImageLogsInvoker 查询容器镜像操作日志
func (c *HssClient) ListContainerImageLogsInvoker(request *model.ListContainerImageLogsRequest) *ListContainerImageLogsInvoker {
	requestDef := GenReqDefForListContainerImageLogs()
	return &ListContainerImageLogsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListContainerImages 查询容器镜像列表
//
// 查询容器镜像列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListContainerImages(request *model.ListContainerImagesRequest) (*model.ListContainerImagesResponse, error) {
	requestDef := GenReqDefForListContainerImages()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListContainerImagesResponse), nil
	}
}

// ListContainerImagesInvoker 查询容器镜像列表
func (c *HssClient) ListContainerImagesInvoker(request *model.ListContainerImagesRequest) *ListContainerImagesInvoker {
	requestDef := GenReqDefForListContainerImages()
	return &ListContainerImagesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListGlobalImageApps 获取镜像软件信息
//
// 获取镜像软件信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListGlobalImageApps(request *model.ListGlobalImageAppsRequest) (*model.ListGlobalImageAppsResponse, error) {
	requestDef := GenReqDefForListGlobalImageApps()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListGlobalImageAppsResponse), nil
	}
}

// ListGlobalImageAppsInvoker 获取镜像软件信息
func (c *HssClient) ListGlobalImageAppsInvoker(request *model.ListGlobalImageAppsRequest) *ListGlobalImageAppsInvoker {
	requestDef := GenReqDefForListGlobalImageApps()
	return &ListGlobalImageAppsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListGlobalImageFiles 获取镜像文件信息
//
// 获取镜像文件信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListGlobalImageFiles(request *model.ListGlobalImageFilesRequest) (*model.ListGlobalImageFilesResponse, error) {
	requestDef := GenReqDefForListGlobalImageFiles()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListGlobalImageFilesResponse), nil
	}
}

// ListGlobalImageFilesInvoker 获取镜像文件信息
func (c *HssClient) ListGlobalImageFilesInvoker(request *model.ListGlobalImageFilesRequest) *ListGlobalImageFilesInvoker {
	requestDef := GenReqDefForListGlobalImageFiles()
	return &ListGlobalImageFilesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListGlobalMalware 查询租户恶意文件列表
//
// 查询租户恶意文件列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListGlobalMalware(request *model.ListGlobalMalwareRequest) (*model.ListGlobalMalwareResponse, error) {
	requestDef := GenReqDefForListGlobalMalware()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListGlobalMalwareResponse), nil
	}
}

// ListGlobalMalwareInvoker 查询租户恶意文件列表
func (c *HssClient) ListGlobalMalwareInvoker(request *model.ListGlobalMalwareRequest) *ListGlobalMalwareInvoker {
	requestDef := GenReqDefForListGlobalMalware()
	return &ListGlobalMalwareInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListGlobalVulnerabilities 租户的漏洞信息
//
// 租户的漏洞信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListGlobalVulnerabilities(request *model.ListGlobalVulnerabilitiesRequest) (*model.ListGlobalVulnerabilitiesResponse, error) {
	requestDef := GenReqDefForListGlobalVulnerabilities()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListGlobalVulnerabilitiesResponse), nil
	}
}

// ListGlobalVulnerabilitiesInvoker 租户的漏洞信息
func (c *HssClient) ListGlobalVulnerabilitiesInvoker(request *model.ListGlobalVulnerabilitiesRequest) *ListGlobalVulnerabilitiesInvoker {
	requestDef := GenReqDefForListGlobalVulnerabilities()
	return &ListGlobalVulnerabilitiesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageApps 查询镜像软件列表
//
// 查询镜像软件列表，若镜像为cicd镜像，只需传参image_id,无需关注组织名称，镜像名称和镜像版本名称；若镜像类型为其他镜像类型，组织名称，镜像名称和镜像版本名称必填
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageApps(request *model.ListImageAppsRequest) (*model.ListImageAppsResponse, error) {
	requestDef := GenReqDefForListImageApps()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageAppsResponse), nil
	}
}

// ListImageAppsInvoker 查询镜像软件列表
func (c *HssClient) ListImageAppsInvoker(request *model.ListImageAppsRequest) *ListImageAppsInvoker {
	requestDef := GenReqDefForListImageApps()
	return &ListImageAppsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageBasicImage 查询镜像的基础镜像信息
//
// 查询镜像的基础镜像信息，若镜像类型为cicd镜像，则需传参镜像类型和镜像id唯一确定一条cicd镜像信息；若镜像类型为其他镜像仓类型，需要传参镜像类型、组织名称、镜像名称、镜像版本名称唯一确定一条其他镜像信息。
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageBasicImage(request *model.ListImageBasicImageRequest) (*model.ListImageBasicImageResponse, error) {
	requestDef := GenReqDefForListImageBasicImage()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageBasicImageResponse), nil
	}
}

// ListImageBasicImageInvoker 查询镜像的基础镜像信息
func (c *HssClient) ListImageBasicImageInvoker(request *model.ListImageBasicImageRequest) *ListImageBasicImageInvoker {
	requestDef := GenReqDefForListImageBasicImage()
	return &ListImageBasicImageInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageBuildCommandRisks 获取镜像构建指令风险信息
//
// 获取镜像构建指令风险信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageBuildCommandRisks(request *model.ListImageBuildCommandRisksRequest) (*model.ListImageBuildCommandRisksResponse, error) {
	requestDef := GenReqDefForListImageBuildCommandRisks()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageBuildCommandRisksResponse), nil
	}
}

// ListImageBuildCommandRisksInvoker 获取镜像构建指令风险信息
func (c *HssClient) ListImageBuildCommandRisksInvoker(request *model.ListImageBuildCommandRisksRequest) *ListImageBuildCommandRisksInvoker {
	requestDef := GenReqDefForListImageBuildCommandRisks()
	return &ListImageBuildCommandRisksInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageBuildCommandRisksImages 查询镜像构建指令影响到的镜像列表
//
// 查询镜像构建指令影响到的镜像列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageBuildCommandRisksImages(request *model.ListImageBuildCommandRisksImagesRequest) (*model.ListImageBuildCommandRisksImagesResponse, error) {
	requestDef := GenReqDefForListImageBuildCommandRisksImages()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageBuildCommandRisksImagesResponse), nil
	}
}

// ListImageBuildCommandRisksImagesInvoker 查询镜像构建指令影响到的镜像列表
func (c *HssClient) ListImageBuildCommandRisksImagesInvoker(request *model.ListImageBuildCommandRisksImagesRequest) *ListImageBuildCommandRisksImagesInvoker {
	requestDef := GenReqDefForListImageBuildCommandRisksImages()
	return &ListImageBuildCommandRisksImagesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageFiles 查询镜像文件列表
//
// 查询镜像文件列表，若镜像为cicd镜像，只需传参image_id,无需关注组织名称，镜像名称和镜像版本名称；若镜像类型为其他镜像类型，组织名称，镜像名称和镜像版本名称必填
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageFiles(request *model.ListImageFilesRequest) (*model.ListImageFilesResponse, error) {
	requestDef := GenReqDefForListImageFiles()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageFilesResponse), nil
	}
}

// ListImageFilesInvoker 查询镜像文件列表
func (c *HssClient) ListImageFilesInvoker(request *model.ListImageFilesRequest) *ListImageFilesInvoker {
	requestDef := GenReqDefForListImageFiles()
	return &ListImageFilesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageHandleAffectVulnerabilities 查询镜像漏洞处置操作影响的漏洞列表
//
// 查询镜像漏洞处置操作影响的漏洞列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageHandleAffectVulnerabilities(request *model.ListImageHandleAffectVulnerabilitiesRequest) (*model.ListImageHandleAffectVulnerabilitiesResponse, error) {
	requestDef := GenReqDefForListImageHandleAffectVulnerabilities()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageHandleAffectVulnerabilitiesResponse), nil
	}
}

// ListImageHandleAffectVulnerabilitiesInvoker 查询镜像漏洞处置操作影响的漏洞列表
func (c *HssClient) ListImageHandleAffectVulnerabilitiesInvoker(request *model.ListImageHandleAffectVulnerabilitiesRequest) *ListImageHandleAffectVulnerabilitiesInvoker {
	requestDef := GenReqDefForListImageHandleAffectVulnerabilities()
	return &ListImageHandleAffectVulnerabilitiesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageLocal 本地镜像列表查询
//
// 本地镜像列表查询
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageLocal(request *model.ListImageLocalRequest) (*model.ListImageLocalResponse, error) {
	requestDef := GenReqDefForListImageLocal()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageLocalResponse), nil
	}
}

// ListImageLocalInvoker 本地镜像列表查询
func (c *HssClient) ListImageLocalInvoker(request *model.ListImageLocalRequest) *ListImageLocalInvoker {
	requestDef := GenReqDefForListImageLocal()
	return &ListImageLocalInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageMalware 查询镜像恶意文件列表
//
// 查询镜像恶意文件列表，若镜像为cicd镜像，只需传参image_id,无需关注组织名称，镜像名称和镜像版本名称；若镜像类型为其他镜像类型，组织名称，镜像名称和镜像版本名称必填
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageMalware(request *model.ListImageMalwareRequest) (*model.ListImageMalwareResponse, error) {
	requestDef := GenReqDefForListImageMalware()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageMalwareResponse), nil
	}
}

// ListImageMalwareInvoker 查询镜像恶意文件列表
func (c *HssClient) ListImageMalwareInvoker(request *model.ListImageMalwareRequest) *ListImageMalwareInvoker {
	requestDef := GenReqDefForListImageMalware()
	return &ListImageMalwareInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageNonCompliantApp 查询镜像的不合规软件信息
//
// 查询镜像的不合规软件信息，若镜像类型为cicd镜像，则需传参镜像类型和镜像id唯一确定一条cicd镜像信息；若镜像类型为其他镜像仓类型，需要传参镜像类型、组织名称、镜像名称、镜像版本名称唯一确定一条其他镜像信息。
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageNonCompliantApp(request *model.ListImageNonCompliantAppRequest) (*model.ListImageNonCompliantAppResponse, error) {
	requestDef := GenReqDefForListImageNonCompliantApp()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageNonCompliantAppResponse), nil
	}
}

// ListImageNonCompliantAppInvoker 查询镜像的不合规软件信息
func (c *HssClient) ListImageNonCompliantAppInvoker(request *model.ListImageNonCompliantAppRequest) *ListImageNonCompliantAppInvoker {
	requestDef := GenReqDefForListImageNonCompliantApp()
	return &ListImageNonCompliantAppInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImagePwdComplexity 查询镜像口令复杂度策略检测报告
//
// 查询镜像口令复杂度策略检测报告，若镜像类型为cicd镜像，则需传参镜像类型和镜像id唯一确定一条cicd镜像信息；若镜像类型为其他镜像仓类型，需要传参镜像类型、组织名称、镜像名称、镜像版本名称唯一确定一条其他镜像信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImagePwdComplexity(request *model.ListImagePwdComplexityRequest) (*model.ListImagePwdComplexityResponse, error) {
	requestDef := GenReqDefForListImagePwdComplexity()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImagePwdComplexityResponse), nil
	}
}

// ListImagePwdComplexityInvoker 查询镜像口令复杂度策略检测报告
func (c *HssClient) ListImagePwdComplexityInvoker(request *model.ListImagePwdComplexityRequest) *ListImagePwdComplexityInvoker {
	requestDef := GenReqDefForListImagePwdComplexity()
	return &ListImagePwdComplexityInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageRiskConfigRules 查询镜像指定安全配置项的检查项列表
//
// 查询镜像指定安全配置项的检查项列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageRiskConfigRules(request *model.ListImageRiskConfigRulesRequest) (*model.ListImageRiskConfigRulesResponse, error) {
	requestDef := GenReqDefForListImageRiskConfigRules()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageRiskConfigRulesResponse), nil
	}
}

// ListImageRiskConfigRulesInvoker 查询镜像指定安全配置项的检查项列表
func (c *HssClient) ListImageRiskConfigRulesInvoker(request *model.ListImageRiskConfigRulesRequest) *ListImageRiskConfigRulesInvoker {
	requestDef := GenReqDefForListImageRiskConfigRules()
	return &ListImageRiskConfigRulesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageRiskConfigs 查询镜像安全配置检测结果列表
//
// 查询镜像安全配置检测结果列表，当前支持检测CentOS 7、Debian 10、EulerOS和Ubuntu16镜像的系统配置项、SSH应用配置项。
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageRiskConfigs(request *model.ListImageRiskConfigsRequest) (*model.ListImageRiskConfigsResponse, error) {
	requestDef := GenReqDefForListImageRiskConfigs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageRiskConfigsResponse), nil
	}
}

// ListImageRiskConfigsInvoker 查询镜像安全配置检测结果列表
func (c *HssClient) ListImageRiskConfigsInvoker(request *model.ListImageRiskConfigsRequest) *ListImageRiskConfigsInvoker {
	requestDef := GenReqDefForListImageRiskConfigs()
	return &ListImageRiskConfigsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageSensitive 查询镜像的敏感信息
//
// 查询镜像的敏感信息，若镜像类型为cicd镜像，则需传参镜像类型和镜像id唯一确定一条cicd镜像信息；若镜像类型为其他镜像仓类型，需要传参镜像类型、组织名称、镜像名称、镜像版本名称唯一确定一条其他镜像信息。
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageSensitive(request *model.ListImageSensitiveRequest) (*model.ListImageSensitiveResponse, error) {
	requestDef := GenReqDefForListImageSensitive()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageSensitiveResponse), nil
	}
}

// ListImageSensitiveInvoker 查询镜像的敏感信息
func (c *HssClient) ListImageSensitiveInvoker(request *model.ListImageSensitiveRequest) *ListImageSensitiveInvoker {
	requestDef := GenReqDefForListImageSensitive()
	return &ListImageSensitiveInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageSensitiveInfo 查询镜像的敏感信息
//
// 查询镜像的敏感信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageSensitiveInfo(request *model.ListImageSensitiveInfoRequest) (*model.ListImageSensitiveInfoResponse, error) {
	requestDef := GenReqDefForListImageSensitiveInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageSensitiveInfoResponse), nil
	}
}

// ListImageSensitiveInfoInvoker 查询镜像的敏感信息
func (c *HssClient) ListImageSensitiveInfoInvoker(request *model.ListImageSensitiveInfoRequest) *ListImageSensitiveInfoInvoker {
	requestDef := GenReqDefForListImageSensitiveInfo()
	return &ListImageSensitiveInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageVulnerabilities 查询镜像的漏洞信息
//
// 查询镜像的漏洞信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageVulnerabilities(request *model.ListImageVulnerabilitiesRequest) (*model.ListImageVulnerabilitiesResponse, error) {
	requestDef := GenReqDefForListImageVulnerabilities()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageVulnerabilitiesResponse), nil
	}
}

// ListImageVulnerabilitiesInvoker 查询镜像的漏洞信息
func (c *HssClient) ListImageVulnerabilitiesInvoker(request *model.ListImageVulnerabilitiesRequest) *ListImageVulnerabilitiesInvoker {
	requestDef := GenReqDefForListImageVulnerabilities()
	return &ListImageVulnerabilitiesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageWeakPwdUsers 查镜像询弱口令检测结果列表
//
// 查询镜像弱口令检测结果列表，若镜像类型为cicd镜像，则需传参镜像类型和镜像id唯一确定一条cicd镜像信息；若镜像类型为其他镜像仓类型，需要传参镜像类型、组织名称、镜像名称、镜像版本名称唯一确定一条其他镜像信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageWeakPwdUsers(request *model.ListImageWeakPwdUsersRequest) (*model.ListImageWeakPwdUsersResponse, error) {
	requestDef := GenReqDefForListImageWeakPwdUsers()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageWeakPwdUsersResponse), nil
	}
}

// ListImageWeakPwdUsersInvoker 查镜像询弱口令检测结果列表
func (c *HssClient) ListImageWeakPwdUsersInvoker(request *model.ListImageWeakPwdUsersRequest) *ListImageWeakPwdUsersInvoker {
	requestDef := GenReqDefForListImageWeakPwdUsers()
	return &ListImageWeakPwdUsersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageWhiteLists 查询镜像白名单列表
//
// 查询镜像白名单列表，目前仅支持漏洞白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageWhiteLists(request *model.ListImageWhiteListsRequest) (*model.ListImageWhiteListsResponse, error) {
	requestDef := GenReqDefForListImageWhiteLists()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageWhiteListsResponse), nil
	}
}

// ListImageWhiteListsInvoker 查询镜像白名单列表
func (c *HssClient) ListImageWhiteListsInvoker(request *model.ListImageWhiteListsRequest) *ListImageWhiteListsInvoker {
	requestDef := GenReqDefForListImageWhiteLists()
	return &ListImageWhiteListsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListLocalImageAppInfo 查询本地镜像的软件信息
//
// 查询本地镜像的软件信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListLocalImageAppInfo(request *model.ListLocalImageAppInfoRequest) (*model.ListLocalImageAppInfoResponse, error) {
	requestDef := GenReqDefForListLocalImageAppInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListLocalImageAppInfoResponse), nil
	}
}

// ListLocalImageAppInfoInvoker 查询本地镜像的软件信息
func (c *HssClient) ListLocalImageAppInfoInvoker(request *model.ListLocalImageAppInfoRequest) *ListLocalImageAppInfoInvoker {
	requestDef := GenReqDefForListLocalImageAppInfo()
	return &ListLocalImageAppInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListLocalImageContainers 查询本地镜像的容器信息
//
// 查询本地镜像的容器信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListLocalImageContainers(request *model.ListLocalImageContainersRequest) (*model.ListLocalImageContainersResponse, error) {
	requestDef := GenReqDefForListLocalImageContainers()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListLocalImageContainersResponse), nil
	}
}

// ListLocalImageContainersInvoker 查询本地镜像的容器信息
func (c *HssClient) ListLocalImageContainersInvoker(request *model.ListLocalImageContainersRequest) *ListLocalImageContainersInvoker {
	requestDef := GenReqDefForListLocalImageContainers()
	return &ListLocalImageContainersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListLocalImageHosts 查询本地镜像的主机信息
//
// 查询本地镜像的主机信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListLocalImageHosts(request *model.ListLocalImageHostsRequest) (*model.ListLocalImageHostsResponse, error) {
	requestDef := GenReqDefForListLocalImageHosts()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListLocalImageHostsResponse), nil
	}
}

// ListLocalImageHostsInvoker 查询本地镜像的主机信息
func (c *HssClient) ListLocalImageHostsInvoker(request *model.ListLocalImageHostsRequest) *ListLocalImageHostsInvoker {
	requestDef := GenReqDefForListLocalImageHosts()
	return &ListLocalImageHostsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListSwrImageRepository 查询swr镜像仓库镜像列表-接口已废弃，不再推荐使用
//
// 查询swr镜像仓库镜像列表,如果需要从swr同步最新镜像，需要先调用“从swr同步镜像”接口
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListSwrImageRepository(request *model.ListSwrImageRepositoryRequest) (*model.ListSwrImageRepositoryResponse, error) {
	requestDef := GenReqDefForListSwrImageRepository()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListSwrImageRepositoryResponse), nil
	}
}

// ListSwrImageRepositoryInvoker 查询swr镜像仓库镜像列表-接口已废弃，不再推荐使用
func (c *HssClient) ListSwrImageRepositoryInvoker(request *model.ListSwrImageRepositoryRequest) *ListSwrImageRepositoryInvoker {
	requestDef := GenReqDefForListSwrImageRepository()
	return &ListSwrImageRepositoryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulAffectImageApps 查看受漏洞影响镜像的软件信息
//
// 查看受漏洞影响镜像的软件信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulAffectImageApps(request *model.ListVulAffectImageAppsRequest) (*model.ListVulAffectImageAppsResponse, error) {
	requestDef := GenReqDefForListVulAffectImageApps()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulAffectImageAppsResponse), nil
	}
}

// ListVulAffectImageAppsInvoker 查看受漏洞影响镜像的软件信息
func (c *HssClient) ListVulAffectImageAppsInvoker(request *model.ListVulAffectImageAppsRequest) *ListVulAffectImageAppsInvoker {
	requestDef := GenReqDefForListVulAffectImageApps()
	return &ListVulAffectImageAppsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulAffectImageContainers 查看受漏洞影响镜像的关联容器信息
//
// 查看受漏洞影响镜像的关联容器信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulAffectImageContainers(request *model.ListVulAffectImageContainersRequest) (*model.ListVulAffectImageContainersResponse, error) {
	requestDef := GenReqDefForListVulAffectImageContainers()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulAffectImageContainersResponse), nil
	}
}

// ListVulAffectImageContainersInvoker 查看受漏洞影响镜像的关联容器信息
func (c *HssClient) ListVulAffectImageContainersInvoker(request *model.ListVulAffectImageContainersRequest) *ListVulAffectImageContainersInvoker {
	requestDef := GenReqDefForListVulAffectImageContainers()
	return &ListVulAffectImageContainersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulAffectImages 查看受漏洞影响的镜像列表
//
// 查看受漏洞影响的镜像列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulAffectImages(request *model.ListVulAffectImagesRequest) (*model.ListVulAffectImagesResponse, error) {
	requestDef := GenReqDefForListVulAffectImages()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulAffectImagesResponse), nil
	}
}

// ListVulAffectImagesInvoker 查看受漏洞影响的镜像列表
func (c *HssClient) ListVulAffectImagesInvoker(request *model.ListVulAffectImagesRequest) *ListVulAffectImagesInvoker {
	requestDef := GenReqDefForListVulAffectImages()
	return &ListVulAffectImagesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulRepoImage 漏洞影响的镜像信息
//
// 查询单个漏洞影响的镜像仓库中的镜像信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulRepoImage(request *model.ListVulRepoImageRequest) (*model.ListVulRepoImageResponse, error) {
	requestDef := GenReqDefForListVulRepoImage()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulRepoImageResponse), nil
	}
}

// ListVulRepoImageInvoker 漏洞影响的镜像信息
func (c *HssClient) ListVulRepoImageInvoker(request *model.ListVulRepoImageRequest) *ListVulRepoImageInvoker {
	requestDef := GenReqDefForListVulRepoImage()
	return &ListVulRepoImageInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulnerabilityCve 漏洞对应cve信息
//
// 漏洞对应cve信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulnerabilityCve(request *model.ListVulnerabilityCveRequest) (*model.ListVulnerabilityCveResponse, error) {
	requestDef := GenReqDefForListVulnerabilityCve()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulnerabilityCveResponse), nil
	}
}

// ListVulnerabilityCveInvoker 漏洞对应cve信息
func (c *HssClient) ListVulnerabilityCveInvoker(request *model.ListVulnerabilityCveRequest) *ListVulnerabilityCveInvoker {
	requestDef := GenReqDefForListVulnerabilityCve()
	return &ListVulnerabilityCveInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RunImageSynchronize 从SWR服务同步镜像列表--接口已废弃
//
// 从SWR服务同步镜像列表--接口已废弃
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RunImageSynchronize(request *model.RunImageSynchronizeRequest) (*model.RunImageSynchronizeResponse, error) {
	requestDef := GenReqDefForRunImageSynchronize()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RunImageSynchronizeResponse), nil
	}
}

// RunImageSynchronizeInvoker 从SWR服务同步镜像列表--接口已废弃
func (c *HssClient) RunImageSynchronizeInvoker(request *model.RunImageSynchronizeRequest) *RunImageSynchronizeInvoker {
	requestDef := GenReqDefForRunImageSynchronize()
	return &RunImageSynchronizeInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowExtendedWeakPassword 查询镜像的自定义弱口令
//
// 查询镜像的自定义弱口令
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowExtendedWeakPassword(request *model.ShowExtendedWeakPasswordRequest) (*model.ShowExtendedWeakPasswordResponse, error) {
	requestDef := GenReqDefForShowExtendedWeakPassword()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowExtendedWeakPasswordResponse), nil
	}
}

// ShowExtendedWeakPasswordInvoker 查询镜像的自定义弱口令
func (c *HssClient) ShowExtendedWeakPasswordInvoker(request *model.ShowExtendedWeakPasswordRequest) *ShowExtendedWeakPasswordInvoker {
	requestDef := GenReqDefForShowExtendedWeakPassword()
	return &ShowExtendedWeakPasswordInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowFilePathWhiteDetail 查询镜像的敏感信息文件路径白名单--接口已废弃
//
// 查询镜像的敏感信息文件路径白名单--接口已废弃
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowFilePathWhiteDetail(request *model.ShowFilePathWhiteDetailRequest) (*model.ShowFilePathWhiteDetailResponse, error) {
	requestDef := GenReqDefForShowFilePathWhiteDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowFilePathWhiteDetailResponse), nil
	}
}

// ShowFilePathWhiteDetailInvoker 查询镜像的敏感信息文件路径白名单--接口已废弃
func (c *HssClient) ShowFilePathWhiteDetailInvoker(request *model.ShowFilePathWhiteDetailRequest) *ShowFilePathWhiteDetailInvoker {
	requestDef := GenReqDefForShowFilePathWhiteDetail()
	return &ShowFilePathWhiteDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowFilePathWhiteLists 查询镜像的敏感信息文件路径白名单
//
// 查询镜像的敏感信息文件路径白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowFilePathWhiteLists(request *model.ShowFilePathWhiteListsRequest) (*model.ShowFilePathWhiteListsResponse, error) {
	requestDef := GenReqDefForShowFilePathWhiteLists()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowFilePathWhiteListsResponse), nil
	}
}

// ShowFilePathWhiteListsInvoker 查询镜像的敏感信息文件路径白名单
func (c *HssClient) ShowFilePathWhiteListsInvoker(request *model.ShowFilePathWhiteListsRequest) *ShowFilePathWhiteListsInvoker {
	requestDef := GenReqDefForShowFilePathWhiteLists()
	return &ShowFilePathWhiteListsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowImageAssetStatistics 容器资产-镜像统计
//
// 容器资产-镜像统计
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowImageAssetStatistics(request *model.ShowImageAssetStatisticsRequest) (*model.ShowImageAssetStatisticsResponse, error) {
	requestDef := GenReqDefForShowImageAssetStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowImageAssetStatisticsResponse), nil
	}
}

// ShowImageAssetStatisticsInvoker 容器资产-镜像统计
func (c *HssClient) ShowImageAssetStatisticsInvoker(request *model.ShowImageAssetStatisticsRequest) *ShowImageAssetStatisticsInvoker {
	requestDef := GenReqDefForShowImageAssetStatistics()
	return &ShowImageAssetStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowImageBaselineStatistic 查询基线检查的统计数据信息
//
// 查询基线检查的统计数据信息，包括弱口令，口令复杂度，配置检测，若查询单个cicd镜像的统计数据，需要传参image_type和image_id；若要查询单个仓库镜像的统计数据，需要传参image_type、组织名称、镜像名称和镜像版本名称
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowImageBaselineStatistic(request *model.ShowImageBaselineStatisticRequest) (*model.ShowImageBaselineStatisticResponse, error) {
	requestDef := GenReqDefForShowImageBaselineStatistic()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowImageBaselineStatisticResponse), nil
	}
}

// ShowImageBaselineStatisticInvoker 查询基线检查的统计数据信息
func (c *HssClient) ShowImageBaselineStatisticInvoker(request *model.ShowImageBaselineStatisticRequest) *ShowImageBaselineStatisticInvoker {
	requestDef := GenReqDefForShowImageBaselineStatistic()
	return &ShowImageBaselineStatisticInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowImageCheckRuleDetail 查询镜像配置检查项检测报告
//
// 查询镜像配置检查项检测报告
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowImageCheckRuleDetail(request *model.ShowImageCheckRuleDetailRequest) (*model.ShowImageCheckRuleDetailResponse, error) {
	requestDef := GenReqDefForShowImageCheckRuleDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowImageCheckRuleDetailResponse), nil
	}
}

// ShowImageCheckRuleDetailInvoker 查询镜像配置检查项检测报告
func (c *HssClient) ShowImageCheckRuleDetailInvoker(request *model.ShowImageCheckRuleDetailRequest) *ShowImageCheckRuleDetailInvoker {
	requestDef := GenReqDefForShowImageCheckRuleDetail()
	return &ShowImageCheckRuleDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowImageFilesStat 查询镜像文件统计信息
//
// 查询镜像文件统计信息，若镜像为cicd镜像，只需传参image_id,无需关注组织名称，镜像名称和镜像版本名称；若镜像类型为其他镜像类型，组织名称，镜像名称和镜像版本名称必填
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowImageFilesStat(request *model.ShowImageFilesStatRequest) (*model.ShowImageFilesStatResponse, error) {
	requestDef := GenReqDefForShowImageFilesStat()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowImageFilesStatResponse), nil
	}
}

// ShowImageFilesStatInvoker 查询镜像文件统计信息
func (c *HssClient) ShowImageFilesStatInvoker(request *model.ShowImageFilesStatRequest) *ShowImageFilesStatInvoker {
	requestDef := GenReqDefForShowImageFilesStat()
	return &ShowImageFilesStatInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowImageSecurityReportStatistic 镜像安全报告导出统计
//
// 镜像安全报告导出统计
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowImageSecurityReportStatistic(request *model.ShowImageSecurityReportStatisticRequest) (*model.ShowImageSecurityReportStatisticResponse, error) {
	requestDef := GenReqDefForShowImageSecurityReportStatistic()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowImageSecurityReportStatisticResponse), nil
	}
}

// ShowImageSecurityReportStatisticInvoker 镜像安全报告导出统计
func (c *HssClient) ShowImageSecurityReportStatisticInvoker(request *model.ShowImageSecurityReportStatisticRequest) *ShowImageSecurityReportStatisticInvoker {
	requestDef := GenReqDefForShowImageSecurityReportStatistic()
	return &ShowImageSecurityReportStatisticInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowImageWhiteListDetail 查询镜像白名单详情
//
// 查询镜像白名单详情，需要分页查询白名单关联的镜像列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowImageWhiteListDetail(request *model.ShowImageWhiteListDetailRequest) (*model.ShowImageWhiteListDetailResponse, error) {
	requestDef := GenReqDefForShowImageWhiteListDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowImageWhiteListDetailResponse), nil
	}
}

// ShowImageWhiteListDetailInvoker 查询镜像白名单详情
func (c *HssClient) ShowImageWhiteListDetailInvoker(request *model.ShowImageWhiteListDetailRequest) *ShowImageWhiteListDetailInvoker {
	requestDef := GenReqDefForShowImageWhiteListDetail()
	return &ShowImageWhiteListDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateManualImageScanTask 创建扫描任务
//
// 创建扫描任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateManualImageScanTask(request *model.CreateManualImageScanTaskRequest) (*model.CreateManualImageScanTaskResponse, error) {
	requestDef := GenReqDefForCreateManualImageScanTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateManualImageScanTaskResponse), nil
	}
}

// CreateManualImageScanTaskInvoker 创建扫描任务
func (c *HssClient) CreateManualImageScanTaskInvoker(request *model.CreateManualImageScanTaskRequest) *CreateManualImageScanTaskInvoker {
	requestDef := GenReqDefForCreateManualImageScanTask()
	return &CreateManualImageScanTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageScanPolicy 获取扫描策略
//
// 获取扫描策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageScanPolicy(request *model.ListImageScanPolicyRequest) (*model.ListImageScanPolicyResponse, error) {
	requestDef := GenReqDefForListImageScanPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageScanPolicyResponse), nil
	}
}

// ListImageScanPolicyInvoker 获取扫描策略
func (c *HssClient) ListImageScanPolicyInvoker(request *model.ListImageScanPolicyRequest) *ListImageScanPolicyInvoker {
	requestDef := GenReqDefForListImageScanPolicy()
	return &ListImageScanPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListImageScanTask 获取扫描任务列表
//
// 获取扫描任务列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListImageScanTask(request *model.ListImageScanTaskRequest) (*model.ListImageScanTaskResponse, error) {
	requestDef := GenReqDefForListImageScanTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListImageScanTaskResponse), nil
	}
}

// ListImageScanTaskInvoker 获取扫描任务列表
func (c *HssClient) ListImageScanTaskInvoker(request *model.ListImageScanTaskRequest) *ListImageScanTaskInvoker {
	requestDef := GenReqDefForListImageScanTask()
	return &ListImageScanTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ModifyImageScanPolicy 修改周期扫描策略
//
// 修改周期扫描策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ModifyImageScanPolicy(request *model.ModifyImageScanPolicyRequest) (*model.ModifyImageScanPolicyResponse, error) {
	requestDef := GenReqDefForModifyImageScanPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ModifyImageScanPolicyResponse), nil
	}
}

// ModifyImageScanPolicyInvoker 修改周期扫描策略
func (c *HssClient) ModifyImageScanPolicyInvoker(request *model.ModifyImageScanPolicyRequest) *ModifyImageScanPolicyInvoker {
	requestDef := GenReqDefForModifyImageScanPolicy()
	return &ModifyImageScanPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowImagePayPerScanStatistics 查询镜像按次扫描统计数据
//
// 查询镜像按次扫描统计数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowImagePayPerScanStatistics(request *model.ShowImagePayPerScanStatisticsRequest) (*model.ShowImagePayPerScanStatisticsResponse, error) {
	requestDef := GenReqDefForShowImagePayPerScanStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowImagePayPerScanStatisticsResponse), nil
	}
}

// ShowImagePayPerScanStatisticsInvoker 查询镜像按次扫描统计数据
func (c *HssClient) ShowImagePayPerScanStatisticsInvoker(request *model.ShowImagePayPerScanStatisticsRequest) *ShowImagePayPerScanStatisticsInvoker {
	requestDef := GenReqDefForShowImagePayPerScanStatistics()
	return &ShowImagePayPerScanStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// StopImageScanTask 终止仓库镜像扫描任务
//
// 终止仓库镜像扫描任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) StopImageScanTask(request *model.StopImageScanTaskRequest) (*model.StopImageScanTaskResponse, error) {
	requestDef := GenReqDefForStopImageScanTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.StopImageScanTaskResponse), nil
	}
}

// StopImageScanTaskInvoker 终止仓库镜像扫描任务
func (c *HssClient) StopImageScanTaskInvoker(request *model.StopImageScanTaskRequest) *StopImageScanTaskInvoker {
	requestDef := GenReqDefForStopImageScanTask()
	return &StopImageScanTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeMonthlyOperationReportTipStatus 修改用户的月度运营弹框状态
//
// 修改用户的月度运营弹框状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeMonthlyOperationReportTipStatus(request *model.ChangeMonthlyOperationReportTipStatusRequest) (*model.ChangeMonthlyOperationReportTipStatusResponse, error) {
	requestDef := GenReqDefForChangeMonthlyOperationReportTipStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeMonthlyOperationReportTipStatusResponse), nil
	}
}

// ChangeMonthlyOperationReportTipStatusInvoker 修改用户的月度运营弹框状态
func (c *HssClient) ChangeMonthlyOperationReportTipStatusInvoker(request *model.ChangeMonthlyOperationReportTipStatusRequest) *ChangeMonthlyOperationReportTipStatusInvoker {
	requestDef := GenReqDefForChangeMonthlyOperationReportTipStatus()
	return &ChangeMonthlyOperationReportTipStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportTaskInfo 月度运营总结报告导出
//
// 月度运营总结报告导出
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportTaskInfo(request *model.ExportTaskInfoRequest) (*model.ExportTaskInfoResponse, error) {
	requestDef := GenReqDefForExportTaskInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportTaskInfoResponse), nil
	}
}

// ExportTaskInfoInvoker 月度运营总结报告导出
func (c *HssClient) ExportTaskInfoInvoker(request *model.ExportTaskInfoRequest) *ExportTaskInfoInvoker {
	requestDef := GenReqDefForExportTaskInfo()
	return &ExportTaskInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListMonthlyOperationReports 查询月度运营报告列表
//
// 查询月度运营报告列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListMonthlyOperationReports(request *model.ListMonthlyOperationReportsRequest) (*model.ListMonthlyOperationReportsResponse, error) {
	requestDef := GenReqDefForListMonthlyOperationReports()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListMonthlyOperationReportsResponse), nil
	}
}

// ListMonthlyOperationReportsInvoker 查询月度运营报告列表
func (c *HssClient) ListMonthlyOperationReportsInvoker(request *model.ListMonthlyOperationReportsRequest) *ListMonthlyOperationReportsInvoker {
	requestDef := GenReqDefForListMonthlyOperationReports()
	return &ListMonthlyOperationReportsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListSecurityRisk 查询安全风险列表
//
// 查询安全风险列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListSecurityRisk(request *model.ListSecurityRiskRequest) (*model.ListSecurityRiskResponse, error) {
	requestDef := GenReqDefForListSecurityRisk()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListSecurityRiskResponse), nil
	}
}

// ListSecurityRiskInvoker 查询安全风险列表
func (c *HssClient) ListSecurityRiskInvoker(request *model.ListSecurityRiskRequest) *ListSecurityRiskInvoker {
	requestDef := GenReqDefForListSecurityRisk()
	return &ListSecurityRiskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowAgentStatistics 查询agent统计数量
//
// 查询待升级agent数，在线/离线agent数量
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowAgentStatistics(request *model.ShowAgentStatisticsRequest) (*model.ShowAgentStatisticsResponse, error) {
	requestDef := GenReqDefForShowAgentStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowAgentStatisticsResponse), nil
	}
}

// ShowAgentStatisticsInvoker 查询agent统计数量
func (c *HssClient) ShowAgentStatisticsInvoker(request *model.ShowAgentStatisticsRequest) *ShowAgentStatisticsInvoker {
	requestDef := GenReqDefForShowAgentStatistics()
	return &ShowAgentStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowHotInformation 热点资讯
//
// 返回标题，更新时间，资讯级别
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowHotInformation(request *model.ShowHotInformationRequest) (*model.ShowHotInformationResponse, error) {
	requestDef := GenReqDefForShowHotInformation()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowHotInformationResponse), nil
	}
}

// ShowHotInformationInvoker 热点资讯
func (c *HssClient) ShowHotInformationInvoker(request *model.ShowHotInformationRequest) *ShowHotInformationInvoker {
	requestDef := GenReqDefForShowHotInformation()
	return &ShowHotInformationInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowMonthlyOperaReportNotifyInfo 查询用户的月度运营弹框状态
//
// 查询用户的月度运营弹框状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowMonthlyOperaReportNotifyInfo(request *model.ShowMonthlyOperaReportNotifyInfoRequest) (*model.ShowMonthlyOperaReportNotifyInfoResponse, error) {
	requestDef := GenReqDefForShowMonthlyOperaReportNotifyInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowMonthlyOperaReportNotifyInfoResponse), nil
	}
}

// ShowMonthlyOperaReportNotifyInfoInvoker 查询用户的月度运营弹框状态
func (c *HssClient) ShowMonthlyOperaReportNotifyInfoInvoker(request *model.ShowMonthlyOperaReportNotifyInfoRequest) *ShowMonthlyOperaReportNotifyInfoInvoker {
	requestDef := GenReqDefForShowMonthlyOperaReportNotifyInfo()
	return &ShowMonthlyOperaReportNotifyInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowMonthlyOperationReportDetail 查询某月月度运营报告的详细信息
//
// 查询某月月度运营报告的详细信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowMonthlyOperationReportDetail(request *model.ShowMonthlyOperationReportDetailRequest) (*model.ShowMonthlyOperationReportDetailResponse, error) {
	requestDef := GenReqDefForShowMonthlyOperationReportDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowMonthlyOperationReportDetailResponse), nil
	}
}

// ShowMonthlyOperationReportDetailInvoker 查询某月月度运营报告的详细信息
func (c *HssClient) ShowMonthlyOperationReportDetailInvoker(request *model.ShowMonthlyOperationReportDetailRequest) *ShowMonthlyOperationReportDetailInvoker {
	requestDef := GenReqDefForShowMonthlyOperationReportDetail()
	return &ShowMonthlyOperationReportDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowProtectStatistics 查询守护天数，病毒库更新时间，漏洞库更新时间，各模块累计次数
//
// 查询守护天数，病毒库更新时间，漏洞库更新时间，各模块累计次数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowProtectStatistics(request *model.ShowProtectStatisticsRequest) (*model.ShowProtectStatisticsResponse, error) {
	requestDef := GenReqDefForShowProtectStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowProtectStatisticsResponse), nil
	}
}

// ShowProtectStatisticsInvoker 查询守护天数，病毒库更新时间，漏洞库更新时间，各模块累计次数
func (c *HssClient) ShowProtectStatisticsInvoker(request *model.ShowProtectStatisticsRequest) *ShowProtectStatisticsInvoker {
	requestDef := GenReqDefForShowProtectStatistics()
	return &ShowProtectStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowRiskScore 查询风险评分结果
//
// 查询风险评分结果
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowRiskScore(request *model.ShowRiskScoreRequest) (*model.ShowRiskScoreResponse, error) {
	requestDef := GenReqDefForShowRiskScore()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowRiskScoreResponse), nil
	}
}

// ShowRiskScoreInvoker 查询风险评分结果
func (c *HssClient) ShowRiskScoreInvoker(request *model.ShowRiskScoreRequest) *ShowRiskScoreInvoker {
	requestDef := GenReqDefForShowRiskScore()
	return &ShowRiskScoreInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowWelfareAreaInfo 查询月度运营报告福利区公共信息
//
// 查询月度运营报告福利区公共信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowWelfareAreaInfo(request *model.ShowWelfareAreaInfoRequest) (*model.ShowWelfareAreaInfoResponse, error) {
	requestDef := GenReqDefForShowWelfareAreaInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowWelfareAreaInfoResponse), nil
	}
}

// ShowWelfareAreaInfoInvoker 查询月度运营报告福利区公共信息
func (c *HssClient) ShowWelfareAreaInfoInvoker(request *model.ShowWelfareAreaInfoRequest) *ShowWelfareAreaInfoInvoker {
	requestDef := GenReqDefForShowWelfareAreaInfo()
	return &ShowWelfareAreaInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListPluginInfo 查询插件详情
//
// 查询插件详情
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListPluginInfo(request *model.ListPluginInfoRequest) (*model.ListPluginInfoResponse, error) {
	requestDef := GenReqDefForListPluginInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListPluginInfoResponse), nil
	}
}

// ListPluginInfoInvoker 查询插件详情
func (c *HssClient) ListPluginInfoInvoker(request *model.ListPluginInfoRequest) *ListPluginInfoInvoker {
	requestDef := GenReqDefForListPluginInfo()
	return &ListPluginInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListPluginStatus 查询插件应用列表
//
// 查询插件应用列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListPluginStatus(request *model.ListPluginStatusRequest) (*model.ListPluginStatusResponse, error) {
	requestDef := GenReqDefForListPluginStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListPluginStatusResponse), nil
	}
}

// ListPluginStatusInvoker 查询插件应用列表
func (c *HssClient) ListPluginStatusInvoker(request *model.ListPluginStatusRequest) *ListPluginStatusInvoker {
	requestDef := GenReqDefForListPluginStatus()
	return &ListPluginStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListPlugins 查询插件列表
//
// 查询插件列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListPlugins(request *model.ListPluginsRequest) (*model.ListPluginsResponse, error) {
	requestDef := GenReqDefForListPlugins()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListPluginsResponse), nil
	}
}

// ListPluginsInvoker 查询插件列表
func (c *HssClient) ListPluginsInvoker(request *model.ListPluginsRequest) *ListPluginsInvoker {
	requestDef := GenReqDefForListPlugins()
	return &ListPluginsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// StartPlugin 启动插件
//
// 启动插件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) StartPlugin(request *model.StartPluginRequest) (*model.StartPluginResponse, error) {
	requestDef := GenReqDefForStartPlugin()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.StartPluginResponse), nil
	}
}

// StartPluginInvoker 启动插件
func (c *HssClient) StartPluginInvoker(request *model.StartPluginRequest) *StartPluginInvoker {
	requestDef := GenReqDefForStartPlugin()
	return &StartPluginInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// StopPlugin 停止插件
//
// 停止插件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) StopPlugin(request *model.StopPluginRequest) (*model.StopPluginResponse, error) {
	requestDef := GenReqDefForStopPlugin()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.StopPluginResponse), nil
	}
}

// StopPluginInvoker 停止插件
func (c *HssClient) StopPluginInvoker(request *model.StopPluginRequest) *StopPluginInvoker {
	requestDef := GenReqDefForStopPlugin()
	return &StopPluginInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddPolicyGroup 复制策略组
//
// 复制策略组，选择已有的旗舰版或容器版策略组，复制生成新的策略组
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddPolicyGroup(request *model.AddPolicyGroupRequest) (*model.AddPolicyGroupResponse, error) {
	requestDef := GenReqDefForAddPolicyGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddPolicyGroupResponse), nil
	}
}

// AddPolicyGroupInvoker 复制策略组
func (c *HssClient) AddPolicyGroupInvoker(request *model.AddPolicyGroupRequest) *AddPolicyGroupInvoker {
	requestDef := GenReqDefForAddPolicyGroup()
	return &AddPolicyGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AssociatePolicyGroup 部署策略组
//
// 为已经开启旗舰版或容器版防护的服务器部署策略组
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AssociatePolicyGroup(request *model.AssociatePolicyGroupRequest) (*model.AssociatePolicyGroupResponse, error) {
	requestDef := GenReqDefForAssociatePolicyGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AssociatePolicyGroupResponse), nil
	}
}

// AssociatePolicyGroupInvoker 部署策略组
func (c *HssClient) AssociatePolicyGroupInvoker(request *model.AssociatePolicyGroupRequest) *AssociatePolicyGroupInvoker {
	requestDef := GenReqDefForAssociatePolicyGroup()
	return &AssociatePolicyGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangePolicyGroup 修改策略组相关内容
//
// 修改策略组相关内容，如防护模式
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangePolicyGroup(request *model.ChangePolicyGroupRequest) (*model.ChangePolicyGroupResponse, error) {
	requestDef := GenReqDefForChangePolicyGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangePolicyGroupResponse), nil
	}
}

// ChangePolicyGroupInvoker 修改策略组相关内容
func (c *HssClient) ChangePolicyGroupInvoker(request *model.ChangePolicyGroupRequest) *ChangePolicyGroupInvoker {
	requestDef := GenReqDefForChangePolicyGroup()
	return &ChangePolicyGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeletePolicyGroup 删除策略组
//
// 删除策略组，支持删除非默认并且未关联服务器的策略组
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeletePolicyGroup(request *model.DeletePolicyGroupRequest) (*model.DeletePolicyGroupResponse, error) {
	requestDef := GenReqDefForDeletePolicyGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeletePolicyGroupResponse), nil
	}
}

// DeletePolicyGroupInvoker 删除策略组
func (c *HssClient) DeletePolicyGroupInvoker(request *model.DeletePolicyGroupRequest) *DeletePolicyGroupInvoker {
	requestDef := GenReqDefForDeletePolicyGroup()
	return &DeletePolicyGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListPolicyGroup 查询策略组列表
//
// 查询策略组列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListPolicyGroup(request *model.ListPolicyGroupRequest) (*model.ListPolicyGroupResponse, error) {
	requestDef := GenReqDefForListPolicyGroup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListPolicyGroupResponse), nil
	}
}

// ListPolicyGroupInvoker 查询策略组列表
func (c *HssClient) ListPolicyGroupInvoker(request *model.ListPolicyGroupRequest) *ListPolicyGroupInvoker {
	requestDef := GenReqDefForListPolicyGroup()
	return &ListPolicyGroupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CancelHostsQuota 解绑配额
//
// 解绑配额
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CancelHostsQuota(request *model.CancelHostsQuotaRequest) (*model.CancelHostsQuotaResponse, error) {
	requestDef := GenReqDefForCancelHostsQuota()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CancelHostsQuotaResponse), nil
	}
}

// CancelHostsQuotaInvoker 解绑配额
func (c *HssClient) CancelHostsQuotaInvoker(request *model.CancelHostsQuotaRequest) *CancelHostsQuotaInvoker {
	requestDef := GenReqDefForCancelHostsQuota()
	return &CancelHostsQuotaInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateQuotasOrder HSS服务创建订单订购配额
//
// HSS服务创建订单订购配额，只支持包周期计费模式
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateQuotasOrder(request *model.CreateQuotasOrderRequest) (*model.CreateQuotasOrderResponse, error) {
	requestDef := GenReqDefForCreateQuotasOrder()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateQuotasOrderResponse), nil
	}
}

// CreateQuotasOrderInvoker HSS服务创建订单订购配额
func (c *HssClient) CreateQuotasOrderInvoker(request *model.CreateQuotasOrderRequest) *CreateQuotasOrderInvoker {
	requestDef := GenReqDefForCreateQuotasOrder()
	return &CreateQuotasOrderInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListLockedStatus 查询资源的锁定状态
//
// 按需计费的防护配额转包年/包月过程中，会将防护配额锁定，已锁定的防护配额不支持转包年/包月，通过该接口可查询主机安全防护配额的锁定状态。
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListLockedStatus(request *model.ListLockedStatusRequest) (*model.ListLockedStatusResponse, error) {
	requestDef := GenReqDefForListLockedStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListLockedStatusResponse), nil
	}
}

// ListLockedStatusInvoker 查询资源的锁定状态
func (c *HssClient) ListLockedStatusInvoker(request *model.ListLockedStatusRequest) *ListLockedStatusInvoker {
	requestDef := GenReqDefForListLockedStatus()
	return &ListLockedStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListQuotasDetail 查询配额详情
//
// 查询配额详情
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListQuotasDetail(request *model.ListQuotasDetailRequest) (*model.ListQuotasDetailResponse, error) {
	requestDef := GenReqDefForListQuotasDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListQuotasDetailResponse), nil
	}
}

// ListQuotasDetailInvoker 查询配额详情
func (c *HssClient) ListQuotasDetailInvoker(request *model.ListQuotasDetailRequest) *ListQuotasDetailInvoker {
	requestDef := GenReqDefForListQuotasDetail()
	return &ListQuotasDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListResourceIds 批量查询配额ID信息
//
// 批量查询配额ID信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListResourceIds(request *model.ListResourceIdsRequest) (*model.ListResourceIdsResponse, error) {
	requestDef := GenReqDefForListResourceIds()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListResourceIdsResponse), nil
	}
}

// ListResourceIdsInvoker 批量查询配额ID信息
func (c *HssClient) ListResourceIdsInvoker(request *model.ListResourceIdsRequest) *ListResourceIdsInvoker {
	requestDef := GenReqDefForListResourceIds()
	return &ListResourceIdsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowProductdataOfferingInfos 查询产商品信息
//
// 查询产商品信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowProductdataOfferingInfos(request *model.ShowProductdataOfferingInfosRequest) (*model.ShowProductdataOfferingInfosResponse, error) {
	requestDef := GenReqDefForShowProductdataOfferingInfos()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowProductdataOfferingInfosResponse), nil
	}
}

// ShowProductdataOfferingInfosInvoker 查询产商品信息
func (c *HssClient) ShowProductdataOfferingInfosInvoker(request *model.ShowProductdataOfferingInfosRequest) *ShowProductdataOfferingInfosInvoker {
	requestDef := GenReqDefForShowProductdataOfferingInfos()
	return &ShowProductdataOfferingInfosInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowResourceQuotas 查询配额信息
//
// 查询配额信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowResourceQuotas(request *model.ShowResourceQuotasRequest) (*model.ShowResourceQuotasResponse, error) {
	requestDef := GenReqDefForShowResourceQuotas()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowResourceQuotasResponse), nil
	}
}

// ShowResourceQuotasInvoker 查询配额信息
func (c *HssClient) ShowResourceQuotasInvoker(request *model.ShowResourceQuotasRequest) *ShowResourceQuotasInvoker {
	requestDef := GenReqDefForShowResourceQuotas()
	return &ShowResourceQuotasInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowVersion 查询客户使用的最高版本
//
// 查询客户使用的最高版本
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowVersion(request *model.ShowVersionRequest) (*model.ShowVersionResponse, error) {
	requestDef := GenReqDefForShowVersion()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowVersionResponse), nil
	}
}

// ShowVersionInvoker 查询客户使用的最高版本
func (c *HssClient) ShowVersionInvoker(request *model.ShowVersionRequest) *ShowVersionInvoker {
	requestDef := GenReqDefForShowVersion()
	return &ShowVersionInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddProtectionPolicy 添加防护策略
//
// 添加防护策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddProtectionPolicy(request *model.AddProtectionPolicyRequest) (*model.AddProtectionPolicyResponse, error) {
	requestDef := GenReqDefForAddProtectionPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddProtectionPolicyResponse), nil
	}
}

// AddProtectionPolicyInvoker 添加防护策略
func (c *HssClient) AddProtectionPolicyInvoker(request *model.AddProtectionPolicyRequest) *AddProtectionPolicyInvoker {
	requestDef := GenReqDefForAddProtectionPolicy()
	return &AddProtectionPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AssociateBackupPolicy 存储库绑定备份策略
//
// 存储库绑定备份策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AssociateBackupPolicy(request *model.AssociateBackupPolicyRequest) (*model.AssociateBackupPolicyResponse, error) {
	requestDef := GenReqDefForAssociateBackupPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AssociateBackupPolicyResponse), nil
	}
}

// AssociateBackupPolicyInvoker 存储库绑定备份策略
func (c *HssClient) AssociateBackupPolicyInvoker(request *model.AssociateBackupPolicyRequest) *AssociateBackupPolicyInvoker {
	requestDef := GenReqDefForAssociateBackupPolicy()
	return &AssociateBackupPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AssociateProtectionPolicy 切换勒索防护策略
//
// 切换勒索防护策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AssociateProtectionPolicy(request *model.AssociateProtectionPolicyRequest) (*model.AssociateProtectionPolicyResponse, error) {
	requestDef := GenReqDefForAssociateProtectionPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AssociateProtectionPolicyResponse), nil
	}
}

// AssociateProtectionPolicyInvoker 切换勒索防护策略
func (c *HssClient) AssociateProtectionPolicyInvoker(request *model.AssociateProtectionPolicyRequest) *AssociateProtectionPolicyInvoker {
	requestDef := GenReqDefForAssociateProtectionPolicy()
	return &AssociateProtectionPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchStartProtection 批量开启勒索病毒防护2.0
//
// 批量开启勒索病毒防护，若开启备份防护，请保证该region有cbr云备份服务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchStartProtection(request *model.BatchStartProtectionRequest) (*model.BatchStartProtectionResponse, error) {
	requestDef := GenReqDefForBatchStartProtection()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchStartProtectionResponse), nil
	}
}

// BatchStartProtectionInvoker 批量开启勒索病毒防护2.0
func (c *HssClient) BatchStartProtectionInvoker(request *model.BatchStartProtectionRequest) *BatchStartProtectionInvoker {
	requestDef := GenReqDefForBatchStartProtection()
	return &BatchStartProtectionInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteDuplicationInfo 删除备份副本
//
// 删除备份副本
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteDuplicationInfo(request *model.DeleteDuplicationInfoRequest) (*model.DeleteDuplicationInfoResponse, error) {
	requestDef := GenReqDefForDeleteDuplicationInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteDuplicationInfoResponse), nil
	}
}

// DeleteDuplicationInfoInvoker 删除备份副本
func (c *HssClient) DeleteDuplicationInfoInvoker(request *model.DeleteDuplicationInfoRequest) *DeleteDuplicationInfoInvoker {
	requestDef := GenReqDefForDeleteDuplicationInfo()
	return &DeleteDuplicationInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteProtectionPolicy 删除防护策略
//
// 删除防护策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteProtectionPolicy(request *model.DeleteProtectionPolicyRequest) (*model.DeleteProtectionPolicyResponse, error) {
	requestDef := GenReqDefForDeleteProtectionPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteProtectionPolicyResponse), nil
	}
}

// DeleteProtectionPolicyInvoker 删除防护策略
func (c *HssClient) DeleteProtectionPolicyInvoker(request *model.DeleteProtectionPolicyRequest) *DeleteProtectionPolicyInvoker {
	requestDef := GenReqDefForDeleteProtectionPolicy()
	return &DeleteProtectionPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListBackedupByHostId 查询备份列表
//
// 查询备份列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListBackedupByHostId(request *model.ListBackedupByHostIdRequest) (*model.ListBackedupByHostIdResponse, error) {
	requestDef := GenReqDefForListBackedupByHostId()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListBackedupByHostIdResponse), nil
	}
}

// ListBackedupByHostIdInvoker 查询备份列表
func (c *HssClient) ListBackedupByHostIdInvoker(request *model.ListBackedupByHostIdRequest) *ListBackedupByHostIdInvoker {
	requestDef := GenReqDefForListBackedupByHostId()
	return &ListBackedupByHostIdInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListBackupPolicy 查询备份策略列表
//
// 查询备份策略列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListBackupPolicy(request *model.ListBackupPolicyRequest) (*model.ListBackupPolicyResponse, error) {
	requestDef := GenReqDefForListBackupPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListBackupPolicyResponse), nil
	}
}

// ListBackupPolicyInvoker 查询备份策略列表
func (c *HssClient) ListBackupPolicyInvoker(request *model.ListBackupPolicyRequest) *ListBackupPolicyInvoker {
	requestDef := GenReqDefForListBackupPolicy()
	return &ListBackupPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListBackupVaults 查询备份存储库列表
//
// 查询备份存储库列表，若进行绑定主机，则需要额外判断，同时满足以下条件：1、存储库状态为“可用”状态；2、备份策略状态为“已启用”；3、存储库有剩余可用备份容量；4、存储库绑定的服务器数量少于256。
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListBackupVaults(request *model.ListBackupVaultsRequest) (*model.ListBackupVaultsResponse, error) {
	requestDef := GenReqDefForListBackupVaults()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListBackupVaultsResponse), nil
	}
}

// ListBackupVaultsInvoker 查询备份存储库列表
func (c *HssClient) ListBackupVaultsInvoker(request *model.ListBackupVaultsRequest) *ListBackupVaultsInvoker {
	requestDef := GenReqDefForListBackupVaults()
	return &ListBackupVaultsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListOperationLogsByVaultName 查询备份恢复任务列表
//
// 查询备份恢复任务列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListOperationLogsByVaultName(request *model.ListOperationLogsByVaultNameRequest) (*model.ListOperationLogsByVaultNameResponse, error) {
	requestDef := GenReqDefForListOperationLogsByVaultName()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListOperationLogsByVaultNameResponse), nil
	}
}

// ListOperationLogsByVaultNameInvoker 查询备份恢复任务列表
func (c *HssClient) ListOperationLogsByVaultNameInvoker(request *model.ListOperationLogsByVaultNameRequest) *ListOperationLogsByVaultNameInvoker {
	requestDef := GenReqDefForListOperationLogsByVaultName()
	return &ListOperationLogsByVaultNameInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListProtectionPolicy 查询勒索病毒的防护策略列表
//
// 查询勒索病毒的防护策略列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListProtectionPolicy(request *model.ListProtectionPolicyRequest) (*model.ListProtectionPolicyResponse, error) {
	requestDef := GenReqDefForListProtectionPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListProtectionPolicyResponse), nil
	}
}

// ListProtectionPolicyInvoker 查询勒索病毒的防护策略列表
func (c *HssClient) ListProtectionPolicyInvoker(request *model.ListProtectionPolicyRequest) *ListProtectionPolicyInvoker {
	requestDef := GenReqDefForListProtectionPolicy()
	return &ListProtectionPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListProtectionServer 查询勒索防护服务器列表
//
// 查询勒索防护服务器列表，与云备份服务配合使用。因此使用勒索相关接口之前确保该局点有云备份服务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListProtectionServer(request *model.ListProtectionServerRequest) (*model.ListProtectionServerResponse, error) {
	requestDef := GenReqDefForListProtectionServer()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListProtectionServerResponse), nil
	}
}

// ListProtectionServerInvoker 查询勒索防护服务器列表
func (c *HssClient) ListProtectionServerInvoker(request *model.ListProtectionServerRequest) *ListProtectionServerInvoker {
	requestDef := GenReqDefForListProtectionServer()
	return &ListProtectionServerInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListRansomwareProtectionNodes 查询勒索防护服务器列表2.0
//
// 查询勒索防护服务器列表，与云备份服务配合使用。因此使用勒索相关接口之前确保该局点有云备份服务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListRansomwareProtectionNodes(request *model.ListRansomwareProtectionNodesRequest) (*model.ListRansomwareProtectionNodesResponse, error) {
	requestDef := GenReqDefForListRansomwareProtectionNodes()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListRansomwareProtectionNodesResponse), nil
	}
}

// ListRansomwareProtectionNodesInvoker 查询勒索防护服务器列表2.0
func (c *HssClient) ListRansomwareProtectionNodesInvoker(request *model.ListRansomwareProtectionNodesRequest) *ListRansomwareProtectionNodesInvoker {
	requestDef := GenReqDefForListRansomwareProtectionNodes()
	return &ListRansomwareProtectionNodesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RestoreDuplicationInfo 备份恢复
//
// 备份恢复
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RestoreDuplicationInfo(request *model.RestoreDuplicationInfoRequest) (*model.RestoreDuplicationInfoResponse, error) {
	requestDef := GenReqDefForRestoreDuplicationInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RestoreDuplicationInfoResponse), nil
	}
}

// RestoreDuplicationInfoInvoker 备份恢复
func (c *HssClient) RestoreDuplicationInfoInvoker(request *model.RestoreDuplicationInfoRequest) *RestoreDuplicationInfoInvoker {
	requestDef := GenReqDefForRestoreDuplicationInfo()
	return &RestoreDuplicationInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowBackupInfoByBackupId 查询指定备份信息
//
// 查询指定备份信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowBackupInfoByBackupId(request *model.ShowBackupInfoByBackupIdRequest) (*model.ShowBackupInfoByBackupIdResponse, error) {
	requestDef := GenReqDefForShowBackupInfoByBackupId()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowBackupInfoByBackupIdResponse), nil
	}
}

// ShowBackupInfoByBackupIdInvoker 查询指定备份信息
func (c *HssClient) ShowBackupInfoByBackupIdInvoker(request *model.ShowBackupInfoByBackupIdRequest) *ShowBackupInfoByBackupIdInvoker {
	requestDef := GenReqDefForShowBackupInfoByBackupId()
	return &ShowBackupInfoByBackupIdInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowBackupPolicyInfo 查询HSS存储库绑定的备份策略信息
//
// 查询HSS存储库绑定的备份策略信息，确保已经购买了勒索防护存储库，可以从cbr云备份服务进行验证，确保已经存在HSS_projectid命名的存储库已经购买
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowBackupPolicyInfo(request *model.ShowBackupPolicyInfoRequest) (*model.ShowBackupPolicyInfoResponse, error) {
	requestDef := GenReqDefForShowBackupPolicyInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowBackupPolicyInfoResponse), nil
	}
}

// ShowBackupPolicyInfoInvoker 查询HSS存储库绑定的备份策略信息
func (c *HssClient) ShowBackupPolicyInfoInvoker(request *model.ShowBackupPolicyInfoRequest) *ShowBackupPolicyInfoInvoker {
	requestDef := GenReqDefForShowBackupPolicyInfo()
	return &ShowBackupPolicyInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowSingleBackupPolicyInfo 查询单个备份策略信息
//
// 查询单个备份策略信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowSingleBackupPolicyInfo(request *model.ShowSingleBackupPolicyInfoRequest) (*model.ShowSingleBackupPolicyInfoResponse, error) {
	requestDef := GenReqDefForShowSingleBackupPolicyInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowSingleBackupPolicyInfoResponse), nil
	}
}

// ShowSingleBackupPolicyInfoInvoker 查询单个备份策略信息
func (c *HssClient) ShowSingleBackupPolicyInfoInvoker(request *model.ShowSingleBackupPolicyInfoRequest) *ShowSingleBackupPolicyInfoInvoker {
	requestDef := GenReqDefForShowSingleBackupPolicyInfo()
	return &ShowSingleBackupPolicyInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// StartProtection 开启勒索病毒防护
//
// 开启勒索病毒防护，请保证该region有cbr云备份服务，勒索服务与云备份服务有关联关系
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) StartProtection(request *model.StartProtectionRequest) (*model.StartProtectionResponse, error) {
	requestDef := GenReqDefForStartProtection()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.StartProtectionResponse), nil
	}
}

// StartProtectionInvoker 开启勒索病毒防护
func (c *HssClient) StartProtectionInvoker(request *model.StartProtectionRequest) *StartProtectionInvoker {
	requestDef := GenReqDefForStartProtection()
	return &StartProtectionInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// StopProtection 关闭勒索病毒防护
//
// 关闭勒索病毒防护
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) StopProtection(request *model.StopProtectionRequest) (*model.StopProtectionResponse, error) {
	requestDef := GenReqDefForStopProtection()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.StopProtectionResponse), nil
	}
}

// StopProtectionInvoker 关闭勒索病毒防护
func (c *HssClient) StopProtectionInvoker(request *model.StopProtectionRequest) *StopProtectionInvoker {
	requestDef := GenReqDefForStopProtection()
	return &StopProtectionInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateBackupPolicyInfo 修改存储库绑定的备份策略
//
// 修改存储库绑定的备份策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateBackupPolicyInfo(request *model.UpdateBackupPolicyInfoRequest) (*model.UpdateBackupPolicyInfoResponse, error) {
	requestDef := GenReqDefForUpdateBackupPolicyInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateBackupPolicyInfoResponse), nil
	}
}

// UpdateBackupPolicyInfoInvoker 修改存储库绑定的备份策略
func (c *HssClient) UpdateBackupPolicyInfoInvoker(request *model.UpdateBackupPolicyInfoRequest) *UpdateBackupPolicyInfoInvoker {
	requestDef := GenReqDefForUpdateBackupPolicyInfo()
	return &UpdateBackupPolicyInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateProtectionPolicy 修改勒索防护策略
//
// 修改勒索防护策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateProtectionPolicy(request *model.UpdateProtectionPolicyRequest) (*model.UpdateProtectionPolicyResponse, error) {
	requestDef := GenReqDefForUpdateProtectionPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateProtectionPolicyResponse), nil
	}
}

// UpdateProtectionPolicyInvoker 修改勒索防护策略
func (c *HssClient) UpdateProtectionPolicyInvoker(request *model.UpdateProtectionPolicyRequest) *UpdateProtectionPolicyInvoker {
	requestDef := GenReqDefForUpdateProtectionPolicy()
	return &UpdateProtectionPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateImageSynchronizeTask 创建同步镜像任务
//
// 创建同步镜像任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateImageSynchronizeTask(request *model.CreateImageSynchronizeTaskRequest) (*model.CreateImageSynchronizeTaskResponse, error) {
	requestDef := GenReqDefForCreateImageSynchronizeTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateImageSynchronizeTaskResponse), nil
	}
}

// CreateImageSynchronizeTaskInvoker 创建同步镜像任务
func (c *HssClient) CreateImageSynchronizeTaskInvoker(request *model.CreateImageSynchronizeTaskRequest) *CreateImageSynchronizeTaskInvoker {
	requestDef := GenReqDefForCreateImageSynchronizeTask()
	return &CreateImageSynchronizeTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListRegistryImages 查询仓库镜像列表
//
// 查询仓库镜像列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListRegistryImages(request *model.ListRegistryImagesRequest) (*model.ListRegistryImagesResponse, error) {
	requestDef := GenReqDefForListRegistryImages()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListRegistryImagesResponse), nil
	}
}

// ListRegistryImagesInvoker 查询仓库镜像列表
func (c *HssClient) ListRegistryImagesInvoker(request *model.ListRegistryImagesRequest) *ListRegistryImagesInvoker {
	requestDef := GenReqDefForListRegistryImages()
	return &ListRegistryImagesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SendSecurityReport 发送安全报告
//
// 发送安全报告
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SendSecurityReport(request *model.SendSecurityReportRequest) (*model.SendSecurityReportResponse, error) {
	requestDef := GenReqDefForSendSecurityReport()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SendSecurityReportResponse), nil
	}
}

// SendSecurityReportInvoker 发送安全报告
func (c *HssClient) SendSecurityReportInvoker(request *model.SendSecurityReportRequest) *SendSecurityReportInvoker {
	requestDef := GenReqDefForSendSecurityReport()
	return &SendSecurityReportInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAntivirusHandleHistory 查询病毒扫描历史处置记录列表
//
// 查询病毒扫描历史处置记录列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAntivirusHandleHistory(request *model.ListAntivirusHandleHistoryRequest) (*model.ListAntivirusHandleHistoryResponse, error) {
	requestDef := GenReqDefForListAntivirusHandleHistory()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAntivirusHandleHistoryResponse), nil
	}
}

// ListAntivirusHandleHistoryInvoker 查询病毒扫描历史处置记录列表
func (c *HssClient) ListAntivirusHandleHistoryInvoker(request *model.ListAntivirusHandleHistoryRequest) *ListAntivirusHandleHistoryInvoker {
	requestDef := GenReqDefForListAntivirusHandleHistory()
	return &ListAntivirusHandleHistoryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListEventHandleHistory 查询告警事件历史处置记录列表
//
// 查询告警事件历史处置记录列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListEventHandleHistory(request *model.ListEventHandleHistoryRequest) (*model.ListEventHandleHistoryResponse, error) {
	requestDef := GenReqDefForListEventHandleHistory()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListEventHandleHistoryResponse), nil
	}
}

// ListEventHandleHistoryInvoker 查询告警事件历史处置记录列表
func (c *HssClient) ListEventHandleHistoryInvoker(request *model.ListEventHandleHistoryRequest) *ListEventHandleHistoryInvoker {
	requestDef := GenReqDefForListEventHandleHistory()
	return &ListEventHandleHistoryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListSecurityCheckClusterReports 查询集群的安全体检报告列表
//
// 查询集群的安全体检报告列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListSecurityCheckClusterReports(request *model.ListSecurityCheckClusterReportsRequest) (*model.ListSecurityCheckClusterReportsResponse, error) {
	requestDef := GenReqDefForListSecurityCheckClusterReports()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListSecurityCheckClusterReportsResponse), nil
	}
}

// ListSecurityCheckClusterReportsInvoker 查询集群的安全体检报告列表
func (c *HssClient) ListSecurityCheckClusterReportsInvoker(request *model.ListSecurityCheckClusterReportsRequest) *ListSecurityCheckClusterReportsInvoker {
	requestDef := GenReqDefForListSecurityCheckClusterReports()
	return &ListSecurityCheckClusterReportsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulHandleHistory 查询漏洞历史处置记录列表
//
// 查询漏洞历史处置记录列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulHandleHistory(request *model.ListVulHandleHistoryRequest) (*model.ListVulHandleHistoryResponse, error) {
	requestDef := GenReqDefForListVulHandleHistory()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulHandleHistoryResponse), nil
	}
}

// ListVulHandleHistoryInvoker 查询漏洞历史处置记录列表
func (c *HssClient) ListVulHandleHistoryInvoker(request *model.ListVulHandleHistoryRequest) *ListVulHandleHistoryInvoker {
	requestDef := GenReqDefForListVulHandleHistory()
	return &ListVulHandleHistoryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowManualSecurityCheckStatus 查询手动体检状态和进度
//
// 查询手动体检状态和进度
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowManualSecurityCheckStatus(request *model.ShowManualSecurityCheckStatusRequest) (*model.ShowManualSecurityCheckStatusResponse, error) {
	requestDef := GenReqDefForShowManualSecurityCheckStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowManualSecurityCheckStatusResponse), nil
	}
}

// ShowManualSecurityCheckStatusInvoker 查询手动体检状态和进度
func (c *HssClient) ShowManualSecurityCheckStatusInvoker(request *model.ShowManualSecurityCheckStatusRequest) *ShowManualSecurityCheckStatusInvoker {
	requestDef := GenReqDefForShowManualSecurityCheckStatus()
	return &ShowManualSecurityCheckStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowSecurityCheckClusterReport 查询集群的安全体检报告信息
//
// 查询集群的安全体检报告信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowSecurityCheckClusterReport(request *model.ShowSecurityCheckClusterReportRequest) (*model.ShowSecurityCheckClusterReportResponse, error) {
	requestDef := GenReqDefForShowSecurityCheckClusterReport()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowSecurityCheckClusterReportResponse), nil
	}
}

// ShowSecurityCheckClusterReportInvoker 查询集群的安全体检报告信息
func (c *HssClient) ShowSecurityCheckClusterReportInvoker(request *model.ShowSecurityCheckClusterReportRequest) *ShowSecurityCheckClusterReportInvoker {
	requestDef := GenReqDefForShowSecurityCheckClusterReport()
	return &ShowSecurityCheckClusterReportInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowSecurityCheckConfig 查询安全体检定时配置信息
//
// 查询安全体检定时配置信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowSecurityCheckConfig(request *model.ShowSecurityCheckConfigRequest) (*model.ShowSecurityCheckConfigResponse, error) {
	requestDef := GenReqDefForShowSecurityCheckConfig()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowSecurityCheckConfigResponse), nil
	}
}

// ShowSecurityCheckConfigInvoker 查询安全体检定时配置信息
func (c *HssClient) ShowSecurityCheckConfigInvoker(request *model.ShowSecurityCheckConfigRequest) *ShowSecurityCheckConfigInvoker {
	requestDef := GenReqDefForShowSecurityCheckConfig()
	return &ShowSecurityCheckConfigInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowSecurityCheckHostReport 查询指定服务器的安全体检报告
//
// 查询指定服务器的安全体检报告
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowSecurityCheckHostReport(request *model.ShowSecurityCheckHostReportRequest) (*model.ShowSecurityCheckHostReportResponse, error) {
	requestDef := GenReqDefForShowSecurityCheckHostReport()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowSecurityCheckHostReportResponse), nil
	}
}

// ShowSecurityCheckHostReportInvoker 查询指定服务器的安全体检报告
func (c *HssClient) ShowSecurityCheckHostReportInvoker(request *model.ShowSecurityCheckHostReportRequest) *ShowSecurityCheckHostReportInvoker {
	requestDef := GenReqDefForShowSecurityCheckHostReport()
	return &ShowSecurityCheckHostReportInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// StartManualSecurityCheck 启动手动体检
//
// 启动手动体检
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) StartManualSecurityCheck(request *model.StartManualSecurityCheckRequest) (*model.StartManualSecurityCheckResponse, error) {
	requestDef := GenReqDefForStartManualSecurityCheck()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.StartManualSecurityCheckResponse), nil
	}
}

// StartManualSecurityCheckInvoker 启动手动体检
func (c *HssClient) StartManualSecurityCheckInvoker(request *model.StartManualSecurityCheckRequest) *StartManualSecurityCheckInvoker {
	requestDef := GenReqDefForStartManualSecurityCheck()
	return &StartManualSecurityCheckInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// StopManualSecurityCheck 取消手动体检
//
// 取消手动体检
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) StopManualSecurityCheck(request *model.StopManualSecurityCheckRequest) (*model.StopManualSecurityCheckResponse, error) {
	requestDef := GenReqDefForStopManualSecurityCheck()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.StopManualSecurityCheckResponse), nil
	}
}

// StopManualSecurityCheckInvoker 取消手动体检
func (c *HssClient) StopManualSecurityCheckInvoker(request *model.StopManualSecurityCheckRequest) *StopManualSecurityCheckInvoker {
	requestDef := GenReqDefForStopManualSecurityCheck()
	return &StopManualSecurityCheckInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateSecurityCheckConfig 修改安全体检定时配置信息
//
// 修改安全体检定时配置信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateSecurityCheckConfig(request *model.UpdateSecurityCheckConfigRequest) (*model.UpdateSecurityCheckConfigResponse, error) {
	requestDef := GenReqDefForUpdateSecurityCheckConfig()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateSecurityCheckConfigResponse), nil
	}
}

// UpdateSecurityCheckConfigInvoker 修改安全体检定时配置信息
func (c *HssClient) UpdateSecurityCheckConfigInvoker(request *model.UpdateSecurityCheckConfigRequest) *UpdateSecurityCheckConfigInvoker {
	requestDef := GenReqDefForUpdateSecurityCheckConfig()
	return &UpdateSecurityCheckConfigInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListServerlessAsset 查询Serverless资产列表
//
// 查询Serverless资产列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListServerlessAsset(request *model.ListServerlessAssetRequest) (*model.ListServerlessAssetResponse, error) {
	requestDef := GenReqDefForListServerlessAsset()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListServerlessAssetResponse), nil
	}
}

// ListServerlessAssetInvoker 查询Serverless资产列表
func (c *HssClient) ListServerlessAssetInvoker(request *model.ListServerlessAssetRequest) *ListServerlessAssetInvoker {
	requestDef := GenReqDefForListServerlessAsset()
	return &ListServerlessAssetInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListServerlessAssetDetail 查询Serverless资产详细信息
//
// 查询Serverless资产详细信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListServerlessAssetDetail(request *model.ListServerlessAssetDetailRequest) (*model.ListServerlessAssetDetailResponse, error) {
	requestDef := GenReqDefForListServerlessAssetDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListServerlessAssetDetailResponse), nil
	}
}

// ListServerlessAssetDetailInvoker 查询Serverless资产详细信息
func (c *HssClient) ListServerlessAssetDetailInvoker(request *model.ListServerlessAssetDetailRequest) *ListServerlessAssetDetailInvoker {
	requestDef := GenReqDefForListServerlessAssetDetail()
	return &ListServerlessAssetDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeAgentAutoUpgradeStatus 开启或关闭“Agent自动升级”配置开关
//
// 开启或关闭“Agent自动升级”配置开关
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeAgentAutoUpgradeStatus(request *model.ChangeAgentAutoUpgradeStatusRequest) (*model.ChangeAgentAutoUpgradeStatusResponse, error) {
	requestDef := GenReqDefForChangeAgentAutoUpgradeStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeAgentAutoUpgradeStatusResponse), nil
	}
}

// ChangeAgentAutoUpgradeStatusInvoker 开启或关闭“Agent自动升级”配置开关
func (c *HssClient) ChangeAgentAutoUpgradeStatusInvoker(request *model.ChangeAgentAutoUpgradeStatusRequest) *ChangeAgentAutoUpgradeStatusInvoker {
	requestDef := GenReqDefForChangeAgentAutoUpgradeStatus()
	return &ChangeAgentAutoUpgradeStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangePolicySwitchStatus 修改指定策略的总开关，将该策略的所有主机都打开或者关闭此策略
//
// 修改指定策略的总开关，将该策略的所有主机都打开或者关闭此策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangePolicySwitchStatus(request *model.ChangePolicySwitchStatusRequest) (*model.ChangePolicySwitchStatusResponse, error) {
	requestDef := GenReqDefForChangePolicySwitchStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangePolicySwitchStatusResponse), nil
	}
}

// ChangePolicySwitchStatusInvoker 修改指定策略的总开关，将该策略的所有主机都打开或者关闭此策略
func (c *HssClient) ChangePolicySwitchStatusInvoker(request *model.ChangePolicySwitchStatusRequest) *ChangePolicySwitchStatusInvoker {
	requestDef := GenReqDefForChangePolicySwitchStatus()
	return &ChangePolicySwitchStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeSwitchesStatus 修改配置开关状态
//
// 修改配置开关状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeSwitchesStatus(request *model.ChangeSwitchesStatusRequest) (*model.ChangeSwitchesStatusResponse, error) {
	requestDef := GenReqDefForChangeSwitchesStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeSwitchesStatusResponse), nil
	}
}

// ChangeSwitchesStatusInvoker 修改配置开关状态
func (c *HssClient) ChangeSwitchesStatusInvoker(request *model.ChangeSwitchesStatusRequest) *ChangeSwitchesStatusInvoker {
	requestDef := GenReqDefForChangeSwitchesStatus()
	return &ChangeSwitchesStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAgentAutoUpgradeStatus 查询“Agent自动升级”配置开关状态
//
// 查询“Agent自动升级”配置开关状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAgentAutoUpgradeStatus(request *model.ListAgentAutoUpgradeStatusRequest) (*model.ListAgentAutoUpgradeStatusResponse, error) {
	requestDef := GenReqDefForListAgentAutoUpgradeStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAgentAutoUpgradeStatusResponse), nil
	}
}

// ListAgentAutoUpgradeStatusInvoker 查询“Agent自动升级”配置开关状态
func (c *HssClient) ListAgentAutoUpgradeStatusInvoker(request *model.ListAgentAutoUpgradeStatusRequest) *ListAgentAutoUpgradeStatusInvoker {
	requestDef := GenReqDefForListAgentAutoUpgradeStatus()
	return &ListAgentAutoUpgradeStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAgentVersion 查询agent版本信息列表
//
// 查询agent版本信息列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAgentVersion(request *model.ListAgentVersionRequest) (*model.ListAgentVersionResponse, error) {
	requestDef := GenReqDefForListAgentVersion()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAgentVersionResponse), nil
	}
}

// ListAgentVersionInvoker 查询agent版本信息列表
func (c *HssClient) ListAgentVersionInvoker(request *model.ListAgentVersionRequest) *ListAgentVersionInvoker {
	requestDef := GenReqDefForListAgentVersion()
	return &ListAgentVersionInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAlarmConfig 查询告警配置
//
// 查询告警配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAlarmConfig(request *model.ListAlarmConfigRequest) (*model.ListAlarmConfigResponse, error) {
	requestDef := GenReqDefForListAlarmConfig()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAlarmConfigResponse), nil
	}
}

// ListAlarmConfigInvoker 查询告警配置
func (c *HssClient) ListAlarmConfigInvoker(request *model.ListAlarmConfigRequest) *ListAlarmConfigInvoker {
	requestDef := GenReqDefForListAlarmConfig()
	return &ListAlarmConfigInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListAutoKillVirusStatus 查询程序自动隔离查杀状态
//
// 查询程序自动隔离查杀状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListAutoKillVirusStatus(request *model.ListAutoKillVirusStatusRequest) (*model.ListAutoKillVirusStatusResponse, error) {
	requestDef := GenReqDefForListAutoKillVirusStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListAutoKillVirusStatusResponse), nil
	}
}

// ListAutoKillVirusStatusInvoker 查询程序自动隔离查杀状态
func (c *HssClient) ListAutoKillVirusStatusInvoker(request *model.ListAutoKillVirusStatusRequest) *ListAutoKillVirusStatusInvoker {
	requestDef := GenReqDefForListAutoKillVirusStatus()
	return &ListAutoKillVirusStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListDictionaries 获取字典列表
//
// 获取字典列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListDictionaries(request *model.ListDictionariesRequest) (*model.ListDictionariesResponse, error) {
	requestDef := GenReqDefForListDictionaries()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListDictionariesResponse), nil
	}
}

// ListDictionariesInvoker 获取字典列表
func (c *HssClient) ListDictionariesInvoker(request *model.ListDictionariesRequest) *ListDictionariesInvoker {
	requestDef := GenReqDefForListDictionaries()
	return &ListDictionariesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListLoginCommonIp 查询常用登录IP信息
//
// 查询常用登录IP信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListLoginCommonIp(request *model.ListLoginCommonIpRequest) (*model.ListLoginCommonIpResponse, error) {
	requestDef := GenReqDefForListLoginCommonIp()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListLoginCommonIpResponse), nil
	}
}

// ListLoginCommonIpInvoker 查询常用登录IP信息
func (c *HssClient) ListLoginCommonIpInvoker(request *model.ListLoginCommonIpRequest) *ListLoginCommonIpInvoker {
	requestDef := GenReqDefForListLoginCommonIp()
	return &ListLoginCommonIpInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListLoginCommonLocation 查询常用登录地信息
//
// 查询常用登录地信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListLoginCommonLocation(request *model.ListLoginCommonLocationRequest) (*model.ListLoginCommonLocationResponse, error) {
	requestDef := GenReqDefForListLoginCommonLocation()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListLoginCommonLocationResponse), nil
	}
}

// ListLoginCommonLocationInvoker 查询常用登录地信息
func (c *HssClient) ListLoginCommonLocationInvoker(request *model.ListLoginCommonLocationRequest) *ListLoginCommonLocationInvoker {
	requestDef := GenReqDefForListLoginCommonLocation()
	return &ListLoginCommonLocationInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListLoginWhiteIp 查询SSH登录IP白名单列表
//
// 查询SSH登录IP白名单列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListLoginWhiteIp(request *model.ListLoginWhiteIpRequest) (*model.ListLoginWhiteIpResponse, error) {
	requestDef := GenReqDefForListLoginWhiteIp()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListLoginWhiteIpResponse), nil
	}
}

// ListLoginWhiteIpInvoker 查询SSH登录IP白名单列表
func (c *HssClient) ListLoginWhiteIpInvoker(request *model.ListLoginWhiteIpRequest) *ListLoginWhiteIpInvoker {
	requestDef := GenReqDefForListLoginWhiteIp()
	return &ListLoginWhiteIpInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListSystemConfigs 查询系统配置内容列表
//
// 查询系统配置内容列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListSystemConfigs(request *model.ListSystemConfigsRequest) (*model.ListSystemConfigsResponse, error) {
	requestDef := GenReqDefForListSystemConfigs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListSystemConfigsResponse), nil
	}
}

// ListSystemConfigsInvoker 查询系统配置内容列表
func (c *HssClient) ListSystemConfigsInvoker(request *model.ListSystemConfigsRequest) *ListSystemConfigsInvoker {
	requestDef := GenReqDefForListSystemConfigs()
	return &ListSystemConfigsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListTwoFactorLoginHost 查询双因子主机列表
//
// 查询双因子主机列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListTwoFactorLoginHost(request *model.ListTwoFactorLoginHostRequest) (*model.ListTwoFactorLoginHostResponse, error) {
	requestDef := GenReqDefForListTwoFactorLoginHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListTwoFactorLoginHostResponse), nil
	}
}

// ListTwoFactorLoginHostInvoker 查询双因子主机列表
func (c *HssClient) ListTwoFactorLoginHostInvoker(request *model.ListTwoFactorLoginHostRequest) *ListTwoFactorLoginHostInvoker {
	requestDef := GenReqDefForListTwoFactorLoginHost()
	return &ListTwoFactorLoginHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ModifyLoginCommonIp 添加、编辑或删除常用登录IP地址
//
// 添加、编辑或删除常用登录IP地址
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ModifyLoginCommonIp(request *model.ModifyLoginCommonIpRequest) (*model.ModifyLoginCommonIpResponse, error) {
	requestDef := GenReqDefForModifyLoginCommonIp()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ModifyLoginCommonIpResponse), nil
	}
}

// ModifyLoginCommonIpInvoker 添加、编辑或删除常用登录IP地址
func (c *HssClient) ModifyLoginCommonIpInvoker(request *model.ModifyLoginCommonIpRequest) *ModifyLoginCommonIpInvoker {
	requestDef := GenReqDefForModifyLoginCommonIp()
	return &ModifyLoginCommonIpInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ModifyLoginCommonLocation 添加、编辑或删除常用登录地
//
// 添加、编辑或删除常用登录地
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ModifyLoginCommonLocation(request *model.ModifyLoginCommonLocationRequest) (*model.ModifyLoginCommonLocationResponse, error) {
	requestDef := GenReqDefForModifyLoginCommonLocation()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ModifyLoginCommonLocationResponse), nil
	}
}

// ModifyLoginCommonLocationInvoker 添加、编辑或删除常用登录地
func (c *HssClient) ModifyLoginCommonLocationInvoker(request *model.ModifyLoginCommonLocationRequest) *ModifyLoginCommonLocationInvoker {
	requestDef := GenReqDefForModifyLoginCommonLocation()
	return &ModifyLoginCommonLocationInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ModifyLoginWhiteIp 添加、删除、编辑、启用或禁用登录IP白名单
//
// 添加、删除、编辑、启用或禁用登录IP白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ModifyLoginWhiteIp(request *model.ModifyLoginWhiteIpRequest) (*model.ModifyLoginWhiteIpResponse, error) {
	requestDef := GenReqDefForModifyLoginWhiteIp()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ModifyLoginWhiteIpResponse), nil
	}
}

// ModifyLoginWhiteIpInvoker 添加、删除、编辑、启用或禁用登录IP白名单
func (c *HssClient) ModifyLoginWhiteIpInvoker(request *model.ModifyLoginWhiteIpRequest) *ModifyLoginWhiteIpInvoker {
	requestDef := GenReqDefForModifyLoginWhiteIp()
	return &ModifyLoginWhiteIpInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SetTwoFactorLoginConfig 设置双因子登录配置
//
// 设置双因子登录配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SetTwoFactorLoginConfig(request *model.SetTwoFactorLoginConfigRequest) (*model.SetTwoFactorLoginConfigResponse, error) {
	requestDef := GenReqDefForSetTwoFactorLoginConfig()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SetTwoFactorLoginConfigResponse), nil
	}
}

// SetTwoFactorLoginConfigInvoker 设置双因子登录配置
func (c *HssClient) SetTwoFactorLoginConfigInvoker(request *model.SetTwoFactorLoginConfigRequest) *SetTwoFactorLoginConfigInvoker {
	requestDef := GenReqDefForSetTwoFactorLoginConfig()
	return &SetTwoFactorLoginConfigInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowPolicySwitchStatus 查询指定策略的总开关
//
// 查询指定策略的总开关
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowPolicySwitchStatus(request *model.ShowPolicySwitchStatusRequest) (*model.ShowPolicySwitchStatusResponse, error) {
	requestDef := GenReqDefForShowPolicySwitchStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowPolicySwitchStatusResponse), nil
	}
}

// ShowPolicySwitchStatusInvoker 查询指定策略的总开关
func (c *HssClient) ShowPolicySwitchStatusInvoker(request *model.ShowPolicySwitchStatusRequest) *ShowPolicySwitchStatusInvoker {
	requestDef := GenReqDefForShowPolicySwitchStatus()
	return &ShowPolicySwitchStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowScriptFile 下载脚本文件
//
// 下载脚本文件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowScriptFile(request *model.ShowScriptFileRequest) (*model.ShowScriptFileResponse, error) {
	requestDef := GenReqDefForShowScriptFile()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowScriptFileResponse), nil
	}
}

// ShowScriptFileInvoker 下载脚本文件
func (c *HssClient) ShowScriptFileInvoker(request *model.ShowScriptFileRequest) *ShowScriptFileInvoker {
	requestDef := GenReqDefForShowScriptFile()
	return &ShowScriptFileInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowSwitchesStatus 获取配置开关状态
//
// 获取配置开关状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowSwitchesStatus(request *model.ShowSwitchesStatusRequest) (*model.ShowSwitchesStatusResponse, error) {
	requestDef := GenReqDefForShowSwitchesStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowSwitchesStatusResponse), nil
	}
}

// ShowSwitchesStatusInvoker 获取配置开关状态
func (c *HssClient) ShowSwitchesStatusInvoker(request *model.ShowSwitchesStatusRequest) *ShowSwitchesStatusInvoker {
	requestDef := GenReqDefForShowSwitchesStatus()
	return &ShowSwitchesStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// StartAutoKillVirusStatus 开启或关闭程序自动隔离查杀
//
// 开启或关闭程序自动隔离查杀
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) StartAutoKillVirusStatus(request *model.StartAutoKillVirusStatusRequest) (*model.StartAutoKillVirusStatusResponse, error) {
	requestDef := GenReqDefForStartAutoKillVirusStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.StartAutoKillVirusStatusResponse), nil
	}
}

// StartAutoKillVirusStatusInvoker 开启或关闭程序自动隔离查杀
func (c *HssClient) StartAutoKillVirusStatusInvoker(request *model.StartAutoKillVirusStatusRequest) *StartAutoKillVirusStatusInvoker {
	requestDef := GenReqDefForStartAutoKillVirusStatus()
	return &StartAutoKillVirusStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateAlarmConfig 设置告警配置
//
// 设置告警配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateAlarmConfig(request *model.UpdateAlarmConfigRequest) (*model.UpdateAlarmConfigResponse, error) {
	requestDef := GenReqDefForUpdateAlarmConfig()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateAlarmConfigResponse), nil
	}
}

// UpdateAlarmConfigInvoker 设置告警配置
func (c *HssClient) UpdateAlarmConfigInvoker(request *model.UpdateAlarmConfigRequest) *UpdateAlarmConfigInvoker {
	requestDef := GenReqDefForUpdateAlarmConfig()
	return &UpdateAlarmConfigInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateTask 创建任务
//
// 创建任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateTask(request *model.CreateTaskRequest) (*model.CreateTaskResponse, error) {
	requestDef := GenReqDefForCreateTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateTaskResponse), nil
	}
}

// CreateTaskInvoker 创建任务
func (c *HssClient) CreateTaskInvoker(request *model.CreateTaskRequest) *CreateTaskInvoker {
	requestDef := GenReqDefForCreateTask()
	return &CreateTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListTaskResources 查询当前任务关联的资源列表
//
// 查询当前任务关联的资源列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListTaskResources(request *model.ListTaskResourcesRequest) (*model.ListTaskResourcesResponse, error) {
	requestDef := GenReqDefForListTaskResources()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListTaskResourcesResponse), nil
	}
}

// ListTaskResourcesInvoker 查询当前任务关联的资源列表
func (c *HssClient) ListTaskResourcesInvoker(request *model.ListTaskResourcesRequest) *ListTaskResourcesInvoker {
	requestDef := GenReqDefForListTaskResources()
	return &ListTaskResourcesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListTasks 查询任务列表
//
// 查询任务列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListTasks(request *model.ListTasksRequest) (*model.ListTasksResponse, error) {
	requestDef := GenReqDefForListTasks()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListTasksResponse), nil
	}
}

// ListTasksInvoker 查询任务列表
func (c *HssClient) ListTasksInvoker(request *model.ListTasksRequest) *ListTasksInvoker {
	requestDef := GenReqDefForListTasks()
	return &ListTasksInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RetryTask 重新运行任务
//
// 重新运行任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RetryTask(request *model.RetryTaskRequest) (*model.RetryTaskResponse, error) {
	requestDef := GenReqDefForRetryTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RetryTaskResponse), nil
	}
}

// RetryTaskInvoker 重新运行任务
func (c *HssClient) RetryTaskInvoker(request *model.RetryTaskRequest) *RetryTaskInvoker {
	requestDef := GenReqDefForRetryTask()
	return &RetryTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowTaskStatistics 查询任务统计数据
//
// 查询任务统计数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowTaskStatistics(request *model.ShowTaskStatisticsRequest) (*model.ShowTaskStatisticsResponse, error) {
	requestDef := GenReqDefForShowTaskStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowTaskStatisticsResponse), nil
	}
}

// ShowTaskStatisticsInvoker 查询任务统计数据
func (c *HssClient) ShowTaskStatisticsInvoker(request *model.ShowTaskStatisticsRequest) *ShowTaskStatisticsInvoker {
	requestDef := GenReqDefForShowTaskStatistics()
	return &ShowTaskStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// AddVulWhiteList 添加漏洞白名单
//
// 添加漏洞白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) AddVulWhiteList(request *model.AddVulWhiteListRequest) (*model.AddVulWhiteListResponse, error) {
	requestDef := GenReqDefForAddVulWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.AddVulWhiteListResponse), nil
	}
}

// AddVulWhiteListInvoker 添加漏洞白名单
func (c *HssClient) AddVulWhiteListInvoker(request *model.AddVulWhiteListRequest) *AddVulWhiteListInvoker {
	requestDef := GenReqDefForAddVulWhiteList()
	return &AddVulWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeVulScanPolicy 修改漏洞扫描策略
//
// 修改漏洞扫描策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeVulScanPolicy(request *model.ChangeVulScanPolicyRequest) (*model.ChangeVulScanPolicyResponse, error) {
	requestDef := GenReqDefForChangeVulScanPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeVulScanPolicyResponse), nil
	}
}

// ChangeVulScanPolicyInvoker 修改漏洞扫描策略
func (c *HssClient) ChangeVulScanPolicyInvoker(request *model.ChangeVulScanPolicyRequest) *ChangeVulScanPolicyInvoker {
	requestDef := GenReqDefForChangeVulScanPolicy()
	return &ChangeVulScanPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeVulStatus 修改漏洞的状态
//
// 修改漏洞的状态
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeVulStatus(request *model.ChangeVulStatusRequest) (*model.ChangeVulStatusResponse, error) {
	requestDef := GenReqDefForChangeVulStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeVulStatusResponse), nil
	}
}

// ChangeVulStatusInvoker 修改漏洞的状态
func (c *HssClient) ChangeVulStatusInvoker(request *model.ChangeVulStatusRequest) *ChangeVulStatusInvoker {
	requestDef := GenReqDefForChangeVulStatus()
	return &ChangeVulStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ChangeVulWhiteList 修改漏洞白名单
//
// 修改漏洞白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ChangeVulWhiteList(request *model.ChangeVulWhiteListRequest) (*model.ChangeVulWhiteListResponse, error) {
	requestDef := GenReqDefForChangeVulWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ChangeVulWhiteListResponse), nil
	}
}

// ChangeVulWhiteListInvoker 修改漏洞白名单
func (c *HssClient) ChangeVulWhiteListInvoker(request *model.ChangeVulWhiteListRequest) *ChangeVulWhiteListInvoker {
	requestDef := GenReqDefForChangeVulWhiteList()
	return &ChangeVulWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateVulnerabilityScanTask 创建漏洞扫描任务
//
// 创建漏洞扫描任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateVulnerabilityScanTask(request *model.CreateVulnerabilityScanTaskRequest) (*model.CreateVulnerabilityScanTaskResponse, error) {
	requestDef := GenReqDefForCreateVulnerabilityScanTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateVulnerabilityScanTaskResponse), nil
	}
}

// CreateVulnerabilityScanTaskInvoker 创建漏洞扫描任务
func (c *HssClient) CreateVulnerabilityScanTaskInvoker(request *model.CreateVulnerabilityScanTaskRequest) *CreateVulnerabilityScanTaskInvoker {
	requestDef := GenReqDefForCreateVulnerabilityScanTask()
	return &CreateVulnerabilityScanTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteVulWhiteList 删除漏洞白名单
//
// 删除漏洞白名单
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteVulWhiteList(request *model.DeleteVulWhiteListRequest) (*model.DeleteVulWhiteListResponse, error) {
	requestDef := GenReqDefForDeleteVulWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteVulWhiteListResponse), nil
	}
}

// DeleteVulWhiteListInvoker 删除漏洞白名单
func (c *HssClient) DeleteVulWhiteListInvoker(request *model.DeleteVulWhiteListRequest) *DeleteVulWhiteListInvoker {
	requestDef := GenReqDefForDeleteVulWhiteList()
	return &DeleteVulWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportHandledVulnerabilities 创建历史处理的漏洞导出任务
//
// 创建历史处理的漏洞导出任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportHandledVulnerabilities(request *model.ExportHandledVulnerabilitiesRequest) (*model.ExportHandledVulnerabilitiesResponse, error) {
	requestDef := GenReqDefForExportHandledVulnerabilities()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportHandledVulnerabilitiesResponse), nil
	}
}

// ExportHandledVulnerabilitiesInvoker 创建历史处理的漏洞导出任务
func (c *HssClient) ExportHandledVulnerabilitiesInvoker(request *model.ExportHandledVulnerabilitiesRequest) *ExportHandledVulnerabilitiesInvoker {
	requestDef := GenReqDefForExportHandledVulnerabilities()
	return &ExportHandledVulnerabilitiesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportVulHandleHistory 创建漏洞处置历史记录的导出任务
//
// 创建漏洞处置历史记录的导出任务
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportVulHandleHistory(request *model.ExportVulHandleHistoryRequest) (*model.ExportVulHandleHistoryResponse, error) {
	requestDef := GenReqDefForExportVulHandleHistory()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportVulHandleHistoryResponse), nil
	}
}

// ExportVulHandleHistoryInvoker 创建漏洞处置历史记录的导出任务
func (c *HssClient) ExportVulHandleHistoryInvoker(request *model.ExportVulHandleHistoryRequest) *ExportVulHandleHistoryInvoker {
	requestDef := GenReqDefForExportVulHandleHistory()
	return &ExportVulHandleHistoryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportVuls 导出漏洞及漏洞影响的主机的相关信息
//
// 导出漏洞及漏洞影响的主机的相关信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportVuls(request *model.ExportVulsRequest) (*model.ExportVulsResponse, error) {
	requestDef := GenReqDefForExportVuls()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportVulsResponse), nil
	}
}

// ExportVulsInvoker 导出漏洞及漏洞影响的主机的相关信息
func (c *HssClient) ExportVulsInvoker(request *model.ExportVulsRequest) *ExportVulsInvoker {
	requestDef := GenReqDefForExportVuls()
	return &ExportVulsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListGeneralImageVulOperations 查看镜像漏洞的历史处置记录
//
// 查看镜像漏洞的历史处置记录
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListGeneralImageVulOperations(request *model.ListGeneralImageVulOperationsRequest) (*model.ListGeneralImageVulOperationsResponse, error) {
	requestDef := GenReqDefForListGeneralImageVulOperations()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListGeneralImageVulOperationsResponse), nil
	}
}

// ListGeneralImageVulOperationsInvoker 查看镜像漏洞的历史处置记录
func (c *HssClient) ListGeneralImageVulOperationsInvoker(request *model.ListGeneralImageVulOperationsRequest) *ListGeneralImageVulOperationsInvoker {
	requestDef := GenReqDefForListGeneralImageVulOperations()
	return &ListGeneralImageVulOperationsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListGeneralImageVuls 查看所有类型镜像的漏洞
//
// 查看所有类型镜像的漏洞
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListGeneralImageVuls(request *model.ListGeneralImageVulsRequest) (*model.ListGeneralImageVulsResponse, error) {
	requestDef := GenReqDefForListGeneralImageVuls()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListGeneralImageVulsResponse), nil
	}
}

// ListGeneralImageVulsInvoker 查看所有类型镜像的漏洞
func (c *HssClient) ListGeneralImageVulsInvoker(request *model.ListGeneralImageVulsRequest) *ListGeneralImageVulsInvoker {
	requestDef := GenReqDefForListGeneralImageVuls()
	return &ListGeneralImageVulsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListHandleVuls 处理的漏洞
//
// 查询今日处理漏洞/累计处理漏洞
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListHandleVuls(request *model.ListHandleVulsRequest) (*model.ListHandleVulsResponse, error) {
	requestDef := GenReqDefForListHandleVuls()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListHandleVulsResponse), nil
	}
}

// ListHandleVulsInvoker 处理的漏洞
func (c *HssClient) ListHandleVulsInvoker(request *model.ListHandleVulsRequest) *ListHandleVulsInvoker {
	requestDef := GenReqDefForListHandleVuls()
	return &ListHandleVulsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListHostVuls 查询单台服务器漏洞信息
//
// 查询单台服务器漏洞信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListHostVuls(request *model.ListHostVulsRequest) (*model.ListHostVulsResponse, error) {
	requestDef := GenReqDefForListHostVuls()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListHostVulsResponse), nil
	}
}

// ListHostVulsInvoker 查询单台服务器漏洞信息
func (c *HssClient) ListHostVulsInvoker(request *model.ListHostVulsRequest) *ListHostVulsInvoker {
	requestDef := GenReqDefForListHostVuls()
	return &ListHostVulsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListUrgentVulnerabilities 查询应急漏洞列表
//
// 查询应急漏洞列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListUrgentVulnerabilities(request *model.ListUrgentVulnerabilitiesRequest) (*model.ListUrgentVulnerabilitiesResponse, error) {
	requestDef := GenReqDefForListUrgentVulnerabilities()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListUrgentVulnerabilitiesResponse), nil
	}
}

// ListUrgentVulnerabilitiesInvoker 查询应急漏洞列表
func (c *HssClient) ListUrgentVulnerabilitiesInvoker(request *model.ListUrgentVulnerabilitiesRequest) *ListUrgentVulnerabilitiesInvoker {
	requestDef := GenReqDefForListUrgentVulnerabilities()
	return &ListUrgentVulnerabilitiesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulContainerApps 查询单个漏洞影响的容器app信息
//
// 查询单个漏洞影响的容器app信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulContainerApps(request *model.ListVulContainerAppsRequest) (*model.ListVulContainerAppsResponse, error) {
	requestDef := GenReqDefForListVulContainerApps()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulContainerAppsResponse), nil
	}
}

// ListVulContainerAppsInvoker 查询单个漏洞影响的容器app信息
func (c *HssClient) ListVulContainerAppsInvoker(request *model.ListVulContainerAppsRequest) *ListVulContainerAppsInvoker {
	requestDef := GenReqDefForListVulContainerApps()
	return &ListVulContainerAppsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulContainers 查询单个漏洞影响的容器信息
//
// 查询单个漏洞影响的容器信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulContainers(request *model.ListVulContainersRequest) (*model.ListVulContainersResponse, error) {
	requestDef := GenReqDefForListVulContainers()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulContainersResponse), nil
	}
}

// ListVulContainersInvoker 查询单个漏洞影响的容器信息
func (c *HssClient) ListVulContainersInvoker(request *model.ListVulContainersRequest) *ListVulContainersInvoker {
	requestDef := GenReqDefForListVulContainers()
	return &ListVulContainersInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulHostApps 查询受影响服务器详情-软件列表
//
// 查询受影响服务器详情-软件列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulHostApps(request *model.ListVulHostAppsRequest) (*model.ListVulHostAppsResponse, error) {
	requestDef := GenReqDefForListVulHostApps()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulHostAppsResponse), nil
	}
}

// ListVulHostAppsInvoker 查询受影响服务器详情-软件列表
func (c *HssClient) ListVulHostAppsInvoker(request *model.ListVulHostAppsRequest) *ListVulHostAppsInvoker {
	requestDef := GenReqDefForListVulHostApps()
	return &ListVulHostAppsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulHostBackups 查询可回滚的备份列表
//
// 查询可回滚的备份列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulHostBackups(request *model.ListVulHostBackupsRequest) (*model.ListVulHostBackupsResponse, error) {
	requestDef := GenReqDefForListVulHostBackups()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulHostBackupsResponse), nil
	}
}

// ListVulHostBackupsInvoker 查询可回滚的备份列表
func (c *HssClient) ListVulHostBackupsInvoker(request *model.ListVulHostBackupsRequest) *ListVulHostBackupsInvoker {
	requestDef := GenReqDefForListVulHostBackups()
	return &ListVulHostBackupsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulHostHosts 查询主机视图下的主机漏洞信息
//
// 查询主机视图下的主机漏洞信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulHostHosts(request *model.ListVulHostHostsRequest) (*model.ListVulHostHostsResponse, error) {
	requestDef := GenReqDefForListVulHostHosts()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulHostHostsResponse), nil
	}
}

// ListVulHostHostsInvoker 查询主机视图下的主机漏洞信息
func (c *HssClient) ListVulHostHostsInvoker(request *model.ListVulHostHostsRequest) *ListVulHostHostsInvoker {
	requestDef := GenReqDefForListVulHostHosts()
	return &ListVulHostHostsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulHostProcess 查询受影响服务器详情-进程列表
//
// 查询受影响服务器详情-进程列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulHostProcess(request *model.ListVulHostProcessRequest) (*model.ListVulHostProcessResponse, error) {
	requestDef := GenReqDefForListVulHostProcess()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulHostProcessResponse), nil
	}
}

// ListVulHostProcessInvoker 查询受影响服务器详情-进程列表
func (c *HssClient) ListVulHostProcessInvoker(request *model.ListVulHostProcessRequest) *ListVulHostProcessInvoker {
	requestDef := GenReqDefForListVulHostProcess()
	return &ListVulHostProcessInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulHostVaults 查询处理对应的主机存储库的列表
//
// 查询处理对应的主机存储库的列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulHostVaults(request *model.ListVulHostVaultsRequest) (*model.ListVulHostVaultsResponse, error) {
	requestDef := GenReqDefForListVulHostVaults()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulHostVaultsResponse), nil
	}
}

// ListVulHostVaultsInvoker 查询处理对应的主机存储库的列表
func (c *HssClient) ListVulHostVaultsInvoker(request *model.ListVulHostVaultsRequest) *ListVulHostVaultsInvoker {
	requestDef := GenReqDefForListVulHostVaults()
	return &ListVulHostVaultsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulHostVuls 主机-漏洞平铺漏洞列表
//
// 查询紧急修复/未完成修复漏洞列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulHostVuls(request *model.ListVulHostVulsRequest) (*model.ListVulHostVulsResponse, error) {
	requestDef := GenReqDefForListVulHostVuls()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulHostVulsResponse), nil
	}
}

// ListVulHostVulsInvoker 主机-漏洞平铺漏洞列表
func (c *HssClient) ListVulHostVulsInvoker(request *model.ListVulHostVulsRequest) *ListVulHostVulsInvoker {
	requestDef := GenReqDefForListVulHostVuls()
	return &ListVulHostVulsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulHosts 查询单个漏洞影响的云服务器信息
//
// 查询单个漏洞影响的云服务器信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulHosts(request *model.ListVulHostsRequest) (*model.ListVulHostsResponse, error) {
	requestDef := GenReqDefForListVulHosts()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulHostsResponse), nil
	}
}

// ListVulHostsInvoker 查询单个漏洞影响的云服务器信息
func (c *HssClient) ListVulHostsInvoker(request *model.ListVulHostsRequest) *ListVulHostsInvoker {
	requestDef := GenReqDefForListVulHosts()
	return &ListVulHostsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulRepairCmds 查询漏洞修复命令列表
//
// 查询漏洞修复命令列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulRepairCmds(request *model.ListVulRepairCmdsRequest) (*model.ListVulRepairCmdsResponse, error) {
	requestDef := GenReqDefForListVulRepairCmds()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulRepairCmdsResponse), nil
	}
}

// ListVulRepairCmdsInvoker 查询漏洞修复命令列表
func (c *HssClient) ListVulRepairCmdsInvoker(request *model.ListVulRepairCmdsRequest) *ListVulRepairCmdsInvoker {
	requestDef := GenReqDefForListVulRepairCmds()
	return &ListVulRepairCmdsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulRepairFailedDetail 查询漏洞修复失败信息
//
// 查询漏洞修复失败信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulRepairFailedDetail(request *model.ListVulRepairFailedDetailRequest) (*model.ListVulRepairFailedDetailResponse, error) {
	requestDef := GenReqDefForListVulRepairFailedDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulRepairFailedDetailResponse), nil
	}
}

// ListVulRepairFailedDetailInvoker 查询漏洞修复失败信息
func (c *HssClient) ListVulRepairFailedDetailInvoker(request *model.ListVulRepairFailedDetailRequest) *ListVulRepairFailedDetailInvoker {
	requestDef := GenReqDefForListVulRepairFailedDetail()
	return &ListVulRepairFailedDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulScanTask 查询漏洞扫描任务列表
//
// 查询漏洞扫描任务列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulScanTask(request *model.ListVulScanTaskRequest) (*model.ListVulScanTaskResponse, error) {
	requestDef := GenReqDefForListVulScanTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulScanTaskResponse), nil
	}
}

// ListVulScanTaskInvoker 查询漏洞扫描任务列表
func (c *HssClient) ListVulScanTaskInvoker(request *model.ListVulScanTaskRequest) *ListVulScanTaskInvoker {
	requestDef := GenReqDefForListVulScanTask()
	return &ListVulScanTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulScanTaskHost 查询漏洞扫描任务对应的主机列表
//
// 查询漏洞扫描任务对应的主机列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulScanTaskHost(request *model.ListVulScanTaskHostRequest) (*model.ListVulScanTaskHostResponse, error) {
	requestDef := GenReqDefForListVulScanTaskHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulScanTaskHostResponse), nil
	}
}

// ListVulScanTaskHostInvoker 查询漏洞扫描任务对应的主机列表
func (c *HssClient) ListVulScanTaskHostInvoker(request *model.ListVulScanTaskHostRequest) *ListVulScanTaskHostInvoker {
	requestDef := GenReqDefForListVulScanTaskHost()
	return &ListVulScanTaskHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulWhiteList 查询漏洞白名单列表
//
// 查询漏洞白名单列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulWhiteList(request *model.ListVulWhiteListRequest) (*model.ListVulWhiteListResponse, error) {
	requestDef := GenReqDefForListVulWhiteList()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulWhiteListResponse), nil
	}
}

// ListVulWhiteListInvoker 查询漏洞白名单列表
func (c *HssClient) ListVulWhiteListInvoker(request *model.ListVulWhiteListRequest) *ListVulWhiteListInvoker {
	requestDef := GenReqDefForListVulWhiteList()
	return &ListVulWhiteListInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulWhiteListVulOptions 查询添加白名单时的漏洞选项
//
// 查询添加白名单时的漏洞选项
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulWhiteListVulOptions(request *model.ListVulWhiteListVulOptionsRequest) (*model.ListVulWhiteListVulOptionsResponse, error) {
	requestDef := GenReqDefForListVulWhiteListVulOptions()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulWhiteListVulOptionsResponse), nil
	}
}

// ListVulWhiteListVulOptionsInvoker 查询添加白名单时的漏洞选项
func (c *HssClient) ListVulWhiteListVulOptionsInvoker(request *model.ListVulWhiteListVulOptionsRequest) *ListVulWhiteListVulOptionsInvoker {
	requestDef := GenReqDefForListVulWhiteListVulOptions()
	return &ListVulWhiteListVulOptionsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListVulnerabilities 查询漏洞列表
//
// 查询漏洞列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListVulnerabilities(request *model.ListVulnerabilitiesRequest) (*model.ListVulnerabilitiesResponse, error) {
	requestDef := GenReqDefForListVulnerabilities()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListVulnerabilitiesResponse), nil
	}
}

// ListVulnerabilitiesInvoker 查询漏洞列表
func (c *HssClient) ListVulnerabilitiesInvoker(request *model.ListVulnerabilitiesRequest) *ListVulnerabilitiesInvoker {
	requestDef := GenReqDefForListVulnerabilities()
	return &ListVulnerabilitiesInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RecordUserViewVulTask 记录用户查看漏洞任务管理页面的最后时间
//
// 记录用户查看漏洞任务管理页面的最后时间
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RecordUserViewVulTask(request *model.RecordUserViewVulTaskRequest) (*model.RecordUserViewVulTaskResponse, error) {
	requestDef := GenReqDefForRecordUserViewVulTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RecordUserViewVulTaskResponse), nil
	}
}

// RecordUserViewVulTaskInvoker 记录用户查看漏洞任务管理页面的最后时间
func (c *HssClient) RecordUserViewVulTaskInvoker(request *model.RecordUserViewVulTaskRequest) *RecordUserViewVulTaskInvoker {
	requestDef := GenReqDefForRecordUserViewVulTask()
	return &RecordUserViewVulTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RecreateVulScanTask 重新扫描之前漏洞扫描任务中的主机
//
// 重新扫描之前漏洞扫描任务中的主机
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RecreateVulScanTask(request *model.RecreateVulScanTaskRequest) (*model.RecreateVulScanTaskResponse, error) {
	requestDef := GenReqDefForRecreateVulScanTask()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RecreateVulScanTaskResponse), nil
	}
}

// RecreateVulScanTaskInvoker 重新扫描之前漏洞扫描任务中的主机
func (c *HssClient) RecreateVulScanTaskInvoker(request *model.RecreateVulScanTaskRequest) *RecreateVulScanTaskInvoker {
	requestDef := GenReqDefForRecreateVulScanTask()
	return &RecreateVulScanTaskInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// RestoreVulHostBackup 用备份进行回滚
//
// 用备份进行回滚
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) RestoreVulHostBackup(request *model.RestoreVulHostBackupRequest) (*model.RestoreVulHostBackupResponse, error) {
	requestDef := GenReqDefForRestoreVulHostBackup()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.RestoreVulHostBackupResponse), nil
	}
}

// RestoreVulHostBackupInvoker 用备份进行回滚
func (c *HssClient) RestoreVulHostBackupInvoker(request *model.RestoreVulHostBackupRequest) *RestoreVulHostBackupInvoker {
	requestDef := GenReqDefForRestoreVulHostBackup()
	return &RestoreVulHostBackupInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowCmsVulDetail 查询webcms漏洞基本信息
//
// 查询webcms漏洞基本信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowCmsVulDetail(request *model.ShowCmsVulDetailRequest) (*model.ShowCmsVulDetailResponse, error) {
	requestDef := GenReqDefForShowCmsVulDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowCmsVulDetailResponse), nil
	}
}

// ShowCmsVulDetailInvoker 查询webcms漏洞基本信息
func (c *HssClient) ShowCmsVulDetailInvoker(request *model.ShowCmsVulDetailRequest) *ShowCmsVulDetailInvoker {
	requestDef := GenReqDefForShowCmsVulDetail()
	return &ShowCmsVulDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowLinuxVulDetail 查询linux漏洞基本信息
//
// 查询linux漏洞基本信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowLinuxVulDetail(request *model.ShowLinuxVulDetailRequest) (*model.ShowLinuxVulDetailResponse, error) {
	requestDef := GenReqDefForShowLinuxVulDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowLinuxVulDetailResponse), nil
	}
}

// ShowLinuxVulDetailInvoker 查询linux漏洞基本信息
func (c *HssClient) ShowLinuxVulDetailInvoker(request *model.ShowLinuxVulDetailRequest) *ShowLinuxVulDetailInvoker {
	requestDef := GenReqDefForShowLinuxVulDetail()
	return &ShowLinuxVulDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowVulAffectedStatics 统计受影响服务器和漏洞数量
//
// 统计受影响服务器和漏洞数量
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowVulAffectedStatics(request *model.ShowVulAffectedStaticsRequest) (*model.ShowVulAffectedStaticsResponse, error) {
	requestDef := GenReqDefForShowVulAffectedStatics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowVulAffectedStaticsResponse), nil
	}
}

// ShowVulAffectedStaticsInvoker 统计受影响服务器和漏洞数量
func (c *HssClient) ShowVulAffectedStaticsInvoker(request *model.ShowVulAffectedStaticsRequest) *ShowVulAffectedStaticsInvoker {
	requestDef := GenReqDefForShowVulAffectedStatics()
	return &ShowVulAffectedStaticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowVulBackupStatistics 查询漏洞处理对应主机的备份相关统计信息
//
// 查询漏洞处理对应主机的备份相关统计信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowVulBackupStatistics(request *model.ShowVulBackupStatisticsRequest) (*model.ShowVulBackupStatisticsResponse, error) {
	requestDef := GenReqDefForShowVulBackupStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowVulBackupStatisticsResponse), nil
	}
}

// ShowVulBackupStatisticsInvoker 查询漏洞处理对应主机的备份相关统计信息
func (c *HssClient) ShowVulBackupStatisticsInvoker(request *model.ShowVulBackupStatisticsRequest) *ShowVulBackupStatisticsInvoker {
	requestDef := GenReqDefForShowVulBackupStatistics()
	return &ShowVulBackupStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowVulReportData 漏洞管理-主机视图-主机列表-导出报告
//
// 在主机视图中导出漏洞报告详细报告pdf格式
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowVulReportData(request *model.ShowVulReportDataRequest) (*model.ShowVulReportDataResponse, error) {
	requestDef := GenReqDefForShowVulReportData()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowVulReportDataResponse), nil
	}
}

// ShowVulReportDataInvoker 漏洞管理-主机视图-主机列表-导出报告
func (c *HssClient) ShowVulReportDataInvoker(request *model.ShowVulReportDataRequest) *ShowVulReportDataInvoker {
	requestDef := GenReqDefForShowVulReportData()
	return &ShowVulReportDataInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowVulScanPolicy 查询漏洞扫描策略
//
// 查询漏洞扫描策略
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowVulScanPolicy(request *model.ShowVulScanPolicyRequest) (*model.ShowVulScanPolicyResponse, error) {
	requestDef := GenReqDefForShowVulScanPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowVulScanPolicyResponse), nil
	}
}

// ShowVulScanPolicyInvoker 查询漏洞扫描策略
func (c *HssClient) ShowVulScanPolicyInvoker(request *model.ShowVulScanPolicyRequest) *ShowVulScanPolicyInvoker {
	requestDef := GenReqDefForShowVulScanPolicy()
	return &ShowVulScanPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowVulScanTaskEstimatedTime 查询漏洞扫描的预估时间
//
// 查询漏洞扫描的预估时间
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowVulScanTaskEstimatedTime(request *model.ShowVulScanTaskEstimatedTimeRequest) (*model.ShowVulScanTaskEstimatedTimeResponse, error) {
	requestDef := GenReqDefForShowVulScanTaskEstimatedTime()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowVulScanTaskEstimatedTimeResponse), nil
	}
}

// ShowVulScanTaskEstimatedTimeInvoker 查询漏洞扫描的预估时间
func (c *HssClient) ShowVulScanTaskEstimatedTimeInvoker(request *model.ShowVulScanTaskEstimatedTimeRequest) *ShowVulScanTaskEstimatedTimeInvoker {
	requestDef := GenReqDefForShowVulScanTaskEstimatedTime()
	return &ShowVulScanTaskEstimatedTimeInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowVulStatics 查询漏洞管理统计数据
//
// 查询漏洞管理统计数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowVulStatics(request *model.ShowVulStaticsRequest) (*model.ShowVulStaticsResponse, error) {
	requestDef := GenReqDefForShowVulStatics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowVulStaticsResponse), nil
	}
}

// ShowVulStaticsInvoker 查询漏洞管理统计数据
func (c *HssClient) ShowVulStaticsInvoker(request *model.ShowVulStaticsRequest) *ShowVulStaticsInvoker {
	requestDef := GenReqDefForShowVulStatics()
	return &ShowVulStaticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowVulTaskStatistics 获取漏洞任务的未读数量
//
// 获取漏洞任务的未读数量
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowVulTaskStatistics(request *model.ShowVulTaskStatisticsRequest) (*model.ShowVulTaskStatisticsResponse, error) {
	requestDef := GenReqDefForShowVulTaskStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowVulTaskStatisticsResponse), nil
	}
}

// ShowVulTaskStatisticsInvoker 获取漏洞任务的未读数量
func (c *HssClient) ShowVulTaskStatisticsInvoker(request *model.ShowVulTaskStatisticsRequest) *ShowVulTaskStatisticsInvoker {
	requestDef := GenReqDefForShowVulTaskStatistics()
	return &ShowVulTaskStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowVulWhiteListDetail 查询漏洞白名单详情
//
// 查询漏洞白名单详情
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowVulWhiteListDetail(request *model.ShowVulWhiteListDetailRequest) (*model.ShowVulWhiteListDetailResponse, error) {
	requestDef := GenReqDefForShowVulWhiteListDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowVulWhiteListDetailResponse), nil
	}
}

// ShowVulWhiteListDetailInvoker 查询漏洞白名单详情
func (c *HssClient) ShowVulWhiteListDetailInvoker(request *model.ShowVulWhiteListDetailRequest) *ShowVulWhiteListDetailInvoker {
	requestDef := GenReqDefForShowVulWhiteListDetail()
	return &ShowVulWhiteListDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowWindosVulDetail 查询windows漏洞基本信息
//
// 查询windows漏洞基本信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowWindosVulDetail(request *model.ShowWindosVulDetailRequest) (*model.ShowWindosVulDetailResponse, error) {
	requestDef := GenReqDefForShowWindosVulDetail()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowWindosVulDetailResponse), nil
	}
}

// ShowWindosVulDetailInvoker 查询windows漏洞基本信息
func (c *HssClient) ShowWindosVulDetailInvoker(request *model.ShowWindosVulDetailRequest) *ShowWindosVulDetailInvoker {
	requestDef := GenReqDefForShowWindosVulDetail()
	return &ShowWindosVulDetailInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// BatchStartWebTamperProtection 批量开启网页防篡改防护
//
// 批量开启网页防篡改防护
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) BatchStartWebTamperProtection(request *model.BatchStartWebTamperProtectionRequest) (*model.BatchStartWebTamperProtectionResponse, error) {
	requestDef := GenReqDefForBatchStartWebTamperProtection()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.BatchStartWebTamperProtectionResponse), nil
	}
}

// BatchStartWebTamperProtectionInvoker 批量开启网页防篡改防护
func (c *HssClient) BatchStartWebTamperProtectionInvoker(request *model.BatchStartWebTamperProtectionRequest) *BatchStartWebTamperProtectionInvoker {
	requestDef := GenReqDefForBatchStartWebTamperProtection()
	return &BatchStartWebTamperProtectionInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// CreateWebTamperProtectionConfig 创建网页防篡改防护配置
//
// 创建网页防篡改防护配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) CreateWebTamperProtectionConfig(request *model.CreateWebTamperProtectionConfigRequest) (*model.CreateWebTamperProtectionConfigResponse, error) {
	requestDef := GenReqDefForCreateWebTamperProtectionConfig()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.CreateWebTamperProtectionConfigResponse), nil
	}
}

// CreateWebTamperProtectionConfigInvoker 创建网页防篡改防护配置
func (c *HssClient) CreateWebTamperProtectionConfigInvoker(request *model.CreateWebTamperProtectionConfigRequest) *CreateWebTamperProtectionConfigInvoker {
	requestDef := GenReqDefForCreateWebTamperProtectionConfig()
	return &CreateWebTamperProtectionConfigInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteBackupHostInfo 删除远端备份服务器
//
// 删除远端备份服务器
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteBackupHostInfo(request *model.DeleteBackupHostInfoRequest) (*model.DeleteBackupHostInfoResponse, error) {
	requestDef := GenReqDefForDeleteBackupHostInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteBackupHostInfoResponse), nil
	}
}

// DeleteBackupHostInfoInvoker 删除远端备份服务器
func (c *HssClient) DeleteBackupHostInfoInvoker(request *model.DeleteBackupHostInfoRequest) *DeleteBackupHostInfoInvoker {
	requestDef := GenReqDefForDeleteBackupHostInfo()
	return &DeleteBackupHostInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// DeleteWebTamperProtectionConfig 删除网页防篡改防护配置
//
// 删除网页防篡改防护配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) DeleteWebTamperProtectionConfig(request *model.DeleteWebTamperProtectionConfigRequest) (*model.DeleteWebTamperProtectionConfigResponse, error) {
	requestDef := GenReqDefForDeleteWebTamperProtectionConfig()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.DeleteWebTamperProtectionConfigResponse), nil
	}
}

// DeleteWebTamperProtectionConfigInvoker 删除网页防篡改防护配置
func (c *HssClient) DeleteWebTamperProtectionConfigInvoker(request *model.DeleteWebTamperProtectionConfigRequest) *DeleteWebTamperProtectionConfigInvoker {
	requestDef := GenReqDefForDeleteWebTamperProtectionConfig()
	return &DeleteWebTamperProtectionConfigInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ExportWebTamperHost 导出网页防篡改防护目录列表
//
// 导出网页防篡改防护目录列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ExportWebTamperHost(request *model.ExportWebTamperHostRequest) (*model.ExportWebTamperHostResponse, error) {
	requestDef := GenReqDefForExportWebTamperHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ExportWebTamperHostResponse), nil
	}
}

// ExportWebTamperHostInvoker 导出网页防篡改防护目录列表
func (c *HssClient) ExportWebTamperHostInvoker(request *model.ExportWebTamperHostRequest) *ExportWebTamperHostInvoker {
	requestDef := GenReqDefForExportWebTamperHost()
	return &ExportWebTamperHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListBackupHostsInfo 查询远端备份服务器列表
//
// 查询远端备份服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListBackupHostsInfo(request *model.ListBackupHostsInfoRequest) (*model.ListBackupHostsInfoResponse, error) {
	requestDef := GenReqDefForListBackupHostsInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListBackupHostsInfoResponse), nil
	}
}

// ListBackupHostsInfoInvoker 查询远端备份服务器列表
func (c *HssClient) ListBackupHostsInfoInvoker(request *model.ListBackupHostsInfoRequest) *ListBackupHostsInfoInvoker {
	requestDef := GenReqDefForListBackupHostsInfo()
	return &ListBackupHostsInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListHostProtectHistoryInfo 查询静态网页防篡改防护事件
//
// 查询静态网页防篡改防护事件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListHostProtectHistoryInfo(request *model.ListHostProtectHistoryInfoRequest) (*model.ListHostProtectHistoryInfoResponse, error) {
	requestDef := GenReqDefForListHostProtectHistoryInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListHostProtectHistoryInfoResponse), nil
	}
}

// ListHostProtectHistoryInfoInvoker 查询静态网页防篡改防护事件
func (c *HssClient) ListHostProtectHistoryInfoInvoker(request *model.ListHostProtectHistoryInfoRequest) *ListHostProtectHistoryInfoInvoker {
	requestDef := GenReqDefForListHostProtectHistoryInfo()
	return &ListHostProtectHistoryInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListHostRaspProtectHistoryInfo 查询动态网页防篡改防护事件
//
// 查询动态网页防篡改防护事件
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListHostRaspProtectHistoryInfo(request *model.ListHostRaspProtectHistoryInfoRequest) (*model.ListHostRaspProtectHistoryInfoResponse, error) {
	requestDef := GenReqDefForListHostRaspProtectHistoryInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListHostRaspProtectHistoryInfoResponse), nil
	}
}

// ListHostRaspProtectHistoryInfoInvoker 查询动态网页防篡改防护事件
func (c *HssClient) ListHostRaspProtectHistoryInfoInvoker(request *model.ListHostRaspProtectHistoryInfoRequest) *ListHostRaspProtectHistoryInfoInvoker {
	requestDef := GenReqDefForListHostRaspProtectHistoryInfo()
	return &ListHostRaspProtectHistoryInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebTamperEvent 查询网页防篡改事件列表
//
// 查询网页防篡改事件列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebTamperEvent(request *model.ListWebTamperEventRequest) (*model.ListWebTamperEventResponse, error) {
	requestDef := GenReqDefForListWebTamperEvent()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebTamperEventResponse), nil
	}
}

// ListWebTamperEventInvoker 查询网页防篡改事件列表
func (c *HssClient) ListWebTamperEventInvoker(request *model.ListWebTamperEventRequest) *ListWebTamperEventInvoker {
	requestDef := GenReqDefForListWebTamperEvent()
	return &ListWebTamperEventInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebTamperHost 查询可开启网页防篡改的服务器列表
//
// 查询可开启网页防篡改的服务器列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebTamperHost(request *model.ListWebTamperHostRequest) (*model.ListWebTamperHostResponse, error) {
	requestDef := GenReqDefForListWebTamperHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebTamperHostResponse), nil
	}
}

// ListWebTamperHostInvoker 查询可开启网页防篡改的服务器列表
func (c *HssClient) ListWebTamperHostInvoker(request *model.ListWebTamperHostRequest) *ListWebTamperHostInvoker {
	requestDef := GenReqDefForListWebTamperHost()
	return &ListWebTamperHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebTamperImageOptions 查询容器网页版防篡改镜像选项列表
//
// 查询容器网页版防篡改镜像选项列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebTamperImageOptions(request *model.ListWebTamperImageOptionsRequest) (*model.ListWebTamperImageOptionsResponse, error) {
	requestDef := GenReqDefForListWebTamperImageOptions()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebTamperImageOptionsResponse), nil
	}
}

// ListWebTamperImageOptionsInvoker 查询容器网页版防篡改镜像选项列表
func (c *HssClient) ListWebTamperImageOptionsInvoker(request *model.ListWebTamperImageOptionsRequest) *ListWebTamperImageOptionsInvoker {
	requestDef := GenReqDefForListWebTamperImageOptions()
	return &ListWebTamperImageOptionsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebTamperProtectStatistics 查询容器网页防篡改防护统计数据
//
// 查询容器网页防篡改防护统计数据
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebTamperProtectStatistics(request *model.ListWebTamperProtectStatisticsRequest) (*model.ListWebTamperProtectStatisticsResponse, error) {
	requestDef := GenReqDefForListWebTamperProtectStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebTamperProtectStatisticsResponse), nil
	}
}

// ListWebTamperProtectStatisticsInvoker 查询容器网页防篡改防护统计数据
func (c *HssClient) ListWebTamperProtectStatisticsInvoker(request *model.ListWebTamperProtectStatisticsRequest) *ListWebTamperProtectStatisticsInvoker {
	requestDef := GenReqDefForListWebTamperProtectStatistics()
	return &ListWebTamperProtectStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebTamperProtectionConfigs 查询网页防篡改防护配置列表
//
// 查询网页防篡改防护配置列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebTamperProtectionConfigs(request *model.ListWebTamperProtectionConfigsRequest) (*model.ListWebTamperProtectionConfigsResponse, error) {
	requestDef := GenReqDefForListWebTamperProtectionConfigs()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebTamperProtectionConfigsResponse), nil
	}
}

// ListWebTamperProtectionConfigsInvoker 查询网页防篡改防护配置列表
func (c *HssClient) ListWebTamperProtectionConfigsInvoker(request *model.ListWebTamperProtectionConfigsRequest) *ListWebTamperProtectionConfigsInvoker {
	requestDef := GenReqDefForListWebTamperProtectionConfigs()
	return &ListWebTamperProtectionConfigsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebTamperProtectionContainer 查询防护配置关联的容器信息列表
//
// 查询防护配置关联的容器信息列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebTamperProtectionContainer(request *model.ListWebTamperProtectionContainerRequest) (*model.ListWebTamperProtectionContainerResponse, error) {
	requestDef := GenReqDefForListWebTamperProtectionContainer()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebTamperProtectionContainerResponse), nil
	}
}

// ListWebTamperProtectionContainerInvoker 查询防护配置关联的容器信息列表
func (c *HssClient) ListWebTamperProtectionContainerInvoker(request *model.ListWebTamperProtectionContainerRequest) *ListWebTamperProtectionContainerInvoker {
	requestDef := GenReqDefForListWebTamperProtectionContainer()
	return &ListWebTamperProtectionContainerInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWebTamperProtectionDirectory 查询防护配置关联的容器的防护目录列表
//
// 查询防护配置关联的容器的防护目录列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWebTamperProtectionDirectory(request *model.ListWebTamperProtectionDirectoryRequest) (*model.ListWebTamperProtectionDirectoryResponse, error) {
	requestDef := GenReqDefForListWebTamperProtectionDirectory()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWebTamperProtectionDirectoryResponse), nil
	}
}

// ListWebTamperProtectionDirectoryInvoker 查询防护配置关联的容器的防护目录列表
func (c *HssClient) ListWebTamperProtectionDirectoryInvoker(request *model.ListWebTamperProtectionDirectoryRequest) *ListWebTamperProtectionDirectoryInvoker {
	requestDef := GenReqDefForListWebTamperProtectionDirectory()
	return &ListWebTamperProtectionDirectoryInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ListWtpProtectHost 查询网页防篡改防护列表
//
// 查询网页防篡改防护列表
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ListWtpProtectHost(request *model.ListWtpProtectHostRequest) (*model.ListWtpProtectHostResponse, error) {
	requestDef := GenReqDefForListWtpProtectHost()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ListWtpProtectHostResponse), nil
	}
}

// ListWtpProtectHostInvoker 查询网页防篡改防护列表
func (c *HssClient) ListWtpProtectHostInvoker(request *model.ListWtpProtectHostRequest) *ListWtpProtectHostInvoker {
	requestDef := GenReqDefForListWtpProtectHost()
	return &ListWtpProtectHostInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SetProtectDirSwitchInfo 暂停或恢复网页防篡改的防护目录
//
// 暂停或恢复网页防篡改的防护目录
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SetProtectDirSwitchInfo(request *model.SetProtectDirSwitchInfoRequest) (*model.SetProtectDirSwitchInfoResponse, error) {
	requestDef := GenReqDefForSetProtectDirSwitchInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SetProtectDirSwitchInfoResponse), nil
	}
}

// SetProtectDirSwitchInfoInvoker 暂停或恢复网页防篡改的防护目录
func (c *HssClient) SetProtectDirSwitchInfoInvoker(request *model.SetProtectDirSwitchInfoRequest) *SetProtectDirSwitchInfoInvoker {
	requestDef := GenReqDefForSetProtectDirSwitchInfo()
	return &SetProtectDirSwitchInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SetRaspSwitch 开启关闭动态网页防篡改防护
//
// 开启关闭动态网页防篡改防护
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SetRaspSwitch(request *model.SetRaspSwitchRequest) (*model.SetRaspSwitchResponse, error) {
	requestDef := GenReqDefForSetRaspSwitch()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SetRaspSwitchResponse), nil
	}
}

// SetRaspSwitchInvoker 开启关闭动态网页防篡改防护
func (c *HssClient) SetRaspSwitchInvoker(request *model.SetRaspSwitchRequest) *SetRaspSwitchInvoker {
	requestDef := GenReqDefForSetRaspSwitch()
	return &SetRaspSwitchInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SetRemoteBackupInfo 开启或关闭远端备份
//
// 为已开启网页防篡改的服务器，开启或关闭远端备份功能，仅限Linux服务器
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SetRemoteBackupInfo(request *model.SetRemoteBackupInfoRequest) (*model.SetRemoteBackupInfoResponse, error) {
	requestDef := GenReqDefForSetRemoteBackupInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SetRemoteBackupInfoResponse), nil
	}
}

// SetRemoteBackupInfoInvoker 开启或关闭远端备份
func (c *HssClient) SetRemoteBackupInfoInvoker(request *model.SetRemoteBackupInfoRequest) *SetRemoteBackupInfoInvoker {
	requestDef := GenReqDefForSetRemoteBackupInfo()
	return &SetRemoteBackupInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SetWtpProtectionStatusInfo 开启关闭网页防篡改防护
//
// 开启关闭网页防篡改防护
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SetWtpProtectionStatusInfo(request *model.SetWtpProtectionStatusInfoRequest) (*model.SetWtpProtectionStatusInfoResponse, error) {
	requestDef := GenReqDefForSetWtpProtectionStatusInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SetWtpProtectionStatusInfoResponse), nil
	}
}

// SetWtpProtectionStatusInfoInvoker 开启关闭网页防篡改防护
func (c *HssClient) SetWtpProtectionStatusInfoInvoker(request *model.SetWtpProtectionStatusInfoRequest) *SetWtpProtectionStatusInfoInvoker {
	requestDef := GenReqDefForSetWtpProtectionStatusInfo()
	return &SetWtpProtectionStatusInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowRemoteBackupHostInfo 查询远端备份服务器信息
//
// 查询远端备份服务器信息：查询远端备份服务器的相关信息，包含服务器名称、地址、端口号、备份路径、运行状态信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowRemoteBackupHostInfo(request *model.ShowRemoteBackupHostInfoRequest) (*model.ShowRemoteBackupHostInfoResponse, error) {
	requestDef := GenReqDefForShowRemoteBackupHostInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowRemoteBackupHostInfoResponse), nil
	}
}

// ShowRemoteBackupHostInfoInvoker 查询远端备份服务器信息
func (c *HssClient) ShowRemoteBackupHostInfoInvoker(request *model.ShowRemoteBackupHostInfoRequest) *ShowRemoteBackupHostInfoInvoker {
	requestDef := GenReqDefForShowRemoteBackupHostInfo()
	return &ShowRemoteBackupHostInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowWebTamperHostPolicy 查看网页防篡改策略信息
//
// 查看网页防篡改策略信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowWebTamperHostPolicy(request *model.ShowWebTamperHostPolicyRequest) (*model.ShowWebTamperHostPolicyResponse, error) {
	requestDef := GenReqDefForShowWebTamperHostPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowWebTamperHostPolicyResponse), nil
	}
}

// ShowWebTamperHostPolicyInvoker 查看网页防篡改策略信息
func (c *HssClient) ShowWebTamperHostPolicyInvoker(request *model.ShowWebTamperHostPolicyRequest) *ShowWebTamperHostPolicyInvoker {
	requestDef := GenReqDefForShowWebTamperHostPolicy()
	return &ShowWebTamperHostPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowWebTamperRaspPath 查询动态网页防篡改的Tomcat bin目录
//
// 查询动态网页防篡改的Tomcat bin目录
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowWebTamperRaspPath(request *model.ShowWebTamperRaspPathRequest) (*model.ShowWebTamperRaspPathResponse, error) {
	requestDef := GenReqDefForShowWebTamperRaspPath()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowWebTamperRaspPathResponse), nil
	}
}

// ShowWebTamperRaspPathInvoker 查询动态网页防篡改的Tomcat bin目录
func (c *HssClient) ShowWebTamperRaspPathInvoker(request *model.ShowWebTamperRaspPathRequest) *ShowWebTamperRaspPathInvoker {
	requestDef := GenReqDefForShowWebTamperRaspPath()
	return &ShowWebTamperRaspPathInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// ShowWtpProtectStatistics 防护数据统计
//
// 防护数据统计：统计防护服务器数、防护目录数、近七天的已防御篡改攻击数
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) ShowWtpProtectStatistics(request *model.ShowWtpProtectStatisticsRequest) (*model.ShowWtpProtectStatisticsResponse, error) {
	requestDef := GenReqDefForShowWtpProtectStatistics()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.ShowWtpProtectStatisticsResponse), nil
	}
}

// ShowWtpProtectStatisticsInvoker 防护数据统计
func (c *HssClient) ShowWtpProtectStatisticsInvoker(request *model.ShowWtpProtectStatisticsRequest) *ShowWtpProtectStatisticsInvoker {
	requestDef := GenReqDefForShowWtpProtectStatistics()
	return &ShowWtpProtectStatisticsInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// SwitchWebTamperProtectStatus 开启/关闭容器网页防篡改防护配置
//
// 开启/关闭容器网页防篡改防护配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) SwitchWebTamperProtectStatus(request *model.SwitchWebTamperProtectStatusRequest) (*model.SwitchWebTamperProtectStatusResponse, error) {
	requestDef := GenReqDefForSwitchWebTamperProtectStatus()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.SwitchWebTamperProtectStatusResponse), nil
	}
}

// SwitchWebTamperProtectStatusInvoker 开启/关闭容器网页防篡改防护配置
func (c *HssClient) SwitchWebTamperProtectStatusInvoker(request *model.SwitchWebTamperProtectStatusRequest) *SwitchWebTamperProtectStatusInvoker {
	requestDef := GenReqDefForSwitchWebTamperProtectStatus()
	return &SwitchWebTamperProtectStatusInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateBackupHostInfo 添加或修改远端备份服务器
//
// 添加或修改远端备份服务器
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateBackupHostInfo(request *model.UpdateBackupHostInfoRequest) (*model.UpdateBackupHostInfoResponse, error) {
	requestDef := GenReqDefForUpdateBackupHostInfo()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateBackupHostInfoResponse), nil
	}
}

// UpdateBackupHostInfoInvoker 添加或修改远端备份服务器
func (c *HssClient) UpdateBackupHostInfoInvoker(request *model.UpdateBackupHostInfoRequest) *UpdateBackupHostInfoInvoker {
	requestDef := GenReqDefForUpdateBackupHostInfo()
	return &UpdateBackupHostInfoInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateWebTamperHostPolicy 编辑网页防篡改策略信息
//
// 编辑网页防篡改策略信息
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateWebTamperHostPolicy(request *model.UpdateWebTamperHostPolicyRequest) (*model.UpdateWebTamperHostPolicyResponse, error) {
	requestDef := GenReqDefForUpdateWebTamperHostPolicy()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateWebTamperHostPolicyResponse), nil
	}
}

// UpdateWebTamperHostPolicyInvoker 编辑网页防篡改策略信息
func (c *HssClient) UpdateWebTamperHostPolicyInvoker(request *model.UpdateWebTamperHostPolicyRequest) *UpdateWebTamperHostPolicyInvoker {
	requestDef := GenReqDefForUpdateWebTamperHostPolicy()
	return &UpdateWebTamperHostPolicyInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateWebTamperProtectionConfig 修改网页防篡改防护配置
//
// 修改网页防篡改防护配置
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateWebTamperProtectionConfig(request *model.UpdateWebTamperProtectionConfigRequest) (*model.UpdateWebTamperProtectionConfigResponse, error) {
	requestDef := GenReqDefForUpdateWebTamperProtectionConfig()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateWebTamperProtectionConfigResponse), nil
	}
}

// UpdateWebTamperProtectionConfigInvoker 修改网页防篡改防护配置
func (c *HssClient) UpdateWebTamperProtectionConfigInvoker(request *model.UpdateWebTamperProtectionConfigRequest) *UpdateWebTamperProtectionConfigInvoker {
	requestDef := GenReqDefForUpdateWebTamperProtectionConfig()
	return &UpdateWebTamperProtectionConfigInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}

// UpdateWebTamperRaspPath 修改动态网页防篡改的Tomcat bin目录
//
// 修改动态网页防篡改的Tomcat bin目录
//
// Please refer to HUAWEI cloud API Explorer for details.
func (c *HssClient) UpdateWebTamperRaspPath(request *model.UpdateWebTamperRaspPathRequest) (*model.UpdateWebTamperRaspPathResponse, error) {
	requestDef := GenReqDefForUpdateWebTamperRaspPath()

	if resp, err := c.HcClient.Sync(request, requestDef); err != nil {
		return nil, err
	} else {
		return resp.(*model.UpdateWebTamperRaspPathResponse), nil
	}
}

// UpdateWebTamperRaspPathInvoker 修改动态网页防篡改的Tomcat bin目录
func (c *HssClient) UpdateWebTamperRaspPathInvoker(request *model.UpdateWebTamperRaspPathRequest) *UpdateWebTamperRaspPathInvoker {
	requestDef := GenReqDefForUpdateWebTamperRaspPath()
	return &UpdateWebTamperRaspPathInvoker{invoker.NewBaseInvoker(c.HcClient, request, requestDef)}
}
