// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"log"
	"reflect"

	"github.com/crowdsecurity/crowdsec/pkg/database/ent/migrate"

	"entgo.io/ent"
	"entgo.io/ent/dialect"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/alert"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlist"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlistitem"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/bouncer"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/configitem"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/decision"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/event"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/lock"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/machine"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/meta"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/metric"
)

// Client is the client that holds all ent builders.
type Client struct {
	config
	// Schema is the client for creating, migrating and dropping schema.
	Schema *migrate.Schema
	// Alert is the client for interacting with the Alert builders.
	Alert *AlertClient
	// AllowList is the client for interacting with the AllowList builders.
	AllowList *AllowListClient
	// AllowListItem is the client for interacting with the AllowListItem builders.
	AllowListItem *AllowListItemClient
	// Bouncer is the client for interacting with the Bouncer builders.
	Bouncer *BouncerClient
	// ConfigItem is the client for interacting with the ConfigItem builders.
	ConfigItem *ConfigItemClient
	// Decision is the client for interacting with the Decision builders.
	Decision *DecisionClient
	// Event is the client for interacting with the Event builders.
	Event *EventClient
	// Lock is the client for interacting with the Lock builders.
	Lock *LockClient
	// Machine is the client for interacting with the Machine builders.
	Machine *MachineClient
	// Meta is the client for interacting with the Meta builders.
	Meta *MetaClient
	// Metric is the client for interacting with the Metric builders.
	Metric *MetricClient
}

// NewClient creates a new client configured with the given options.
func NewClient(opts ...Option) *Client {
	client := &Client{config: newConfig(opts...)}
	client.init()
	return client
}

func (c *Client) init() {
	c.Schema = migrate.NewSchema(c.driver)
	c.Alert = NewAlertClient(c.config)
	c.AllowList = NewAllowListClient(c.config)
	c.AllowListItem = NewAllowListItemClient(c.config)
	c.Bouncer = NewBouncerClient(c.config)
	c.ConfigItem = NewConfigItemClient(c.config)
	c.Decision = NewDecisionClient(c.config)
	c.Event = NewEventClient(c.config)
	c.Lock = NewLockClient(c.config)
	c.Machine = NewMachineClient(c.config)
	c.Meta = NewMetaClient(c.config)
	c.Metric = NewMetricClient(c.config)
}

type (
	// config is the configuration for the client and its builder.
	config struct {
		// driver used for executing database requests.
		driver dialect.Driver
		// debug enable a debug logging.
		debug bool
		// log used for logging on debug mode.
		log func(...any)
		// hooks to execute on mutations.
		hooks *hooks
		// interceptors to execute on queries.
		inters *inters
	}
	// Option function to configure the client.
	Option func(*config)
)

// newConfig creates a new config for the client.
func newConfig(opts ...Option) config {
	cfg := config{log: log.Println, hooks: &hooks{}, inters: &inters{}}
	cfg.options(opts...)
	return cfg
}

// options applies the options on the config object.
func (c *config) options(opts ...Option) {
	for _, opt := range opts {
		opt(c)
	}
	if c.debug {
		c.driver = dialect.Debug(c.driver, c.log)
	}
}

// Debug enables debug logging on the ent.Driver.
func Debug() Option {
	return func(c *config) {
		c.debug = true
	}
}

// Log sets the logging function for debug mode.
func Log(fn func(...any)) Option {
	return func(c *config) {
		c.log = fn
	}
}

// Driver configures the client driver.
func Driver(driver dialect.Driver) Option {
	return func(c *config) {
		c.driver = driver
	}
}

// Open opens a database/sql.DB specified by the driver name and
// the data source name, and returns a new client attached to it.
// Optional parameters can be added for configuring the client.
func Open(driverName, dataSourceName string, options ...Option) (*Client, error) {
	switch driverName {
	case dialect.MySQL, dialect.Postgres, dialect.SQLite:
		drv, err := sql.Open(driverName, dataSourceName)
		if err != nil {
			return nil, err
		}
		return NewClient(append(options, Driver(drv))...), nil
	default:
		return nil, fmt.Errorf("unsupported driver: %q", driverName)
	}
}

// ErrTxStarted is returned when trying to start a new transaction from a transactional client.
var ErrTxStarted = errors.New("ent: cannot start a transaction within a transaction")

// Tx returns a new transactional client. The provided context
// is used until the transaction is committed or rolled back.
func (c *Client) Tx(ctx context.Context) (*Tx, error) {
	if _, ok := c.driver.(*txDriver); ok {
		return nil, ErrTxStarted
	}
	tx, err := newTx(ctx, c.driver)
	if err != nil {
		return nil, fmt.Errorf("ent: starting a transaction: %w", err)
	}
	cfg := c.config
	cfg.driver = tx
	return &Tx{
		ctx:           ctx,
		config:        cfg,
		Alert:         NewAlertClient(cfg),
		AllowList:     NewAllowListClient(cfg),
		AllowListItem: NewAllowListItemClient(cfg),
		Bouncer:       NewBouncerClient(cfg),
		ConfigItem:    NewConfigItemClient(cfg),
		Decision:      NewDecisionClient(cfg),
		Event:         NewEventClient(cfg),
		Lock:          NewLockClient(cfg),
		Machine:       NewMachineClient(cfg),
		Meta:          NewMetaClient(cfg),
		Metric:        NewMetricClient(cfg),
	}, nil
}

// BeginTx returns a transactional client with specified options.
func (c *Client) BeginTx(ctx context.Context, opts *sql.TxOptions) (*Tx, error) {
	if _, ok := c.driver.(*txDriver); ok {
		return nil, errors.New("ent: cannot start a transaction within a transaction")
	}
	tx, err := c.driver.(interface {
		BeginTx(context.Context, *sql.TxOptions) (dialect.Tx, error)
	}).BeginTx(ctx, opts)
	if err != nil {
		return nil, fmt.Errorf("ent: starting a transaction: %w", err)
	}
	cfg := c.config
	cfg.driver = &txDriver{tx: tx, drv: c.driver}
	return &Tx{
		ctx:           ctx,
		config:        cfg,
		Alert:         NewAlertClient(cfg),
		AllowList:     NewAllowListClient(cfg),
		AllowListItem: NewAllowListItemClient(cfg),
		Bouncer:       NewBouncerClient(cfg),
		ConfigItem:    NewConfigItemClient(cfg),
		Decision:      NewDecisionClient(cfg),
		Event:         NewEventClient(cfg),
		Lock:          NewLockClient(cfg),
		Machine:       NewMachineClient(cfg),
		Meta:          NewMetaClient(cfg),
		Metric:        NewMetricClient(cfg),
	}, nil
}

// Debug returns a new debug-client. It's used to get verbose logging on specific operations.
//
//	client.Debug().
//		Alert.
//		Query().
//		Count(ctx)
func (c *Client) Debug() *Client {
	if c.debug {
		return c
	}
	cfg := c.config
	cfg.driver = dialect.Debug(c.driver, c.log)
	client := &Client{config: cfg}
	client.init()
	return client
}

// Close closes the database connection and prevents new queries from starting.
func (c *Client) Close() error {
	return c.driver.Close()
}

// Use adds the mutation hooks to all the entity clients.
// In order to add hooks to a specific client, call: `client.Node.Use(...)`.
func (c *Client) Use(hooks ...Hook) {
	for _, n := range []interface{ Use(...Hook) }{
		c.Alert, c.AllowList, c.AllowListItem, c.Bouncer, c.ConfigItem, c.Decision,
		c.Event, c.Lock, c.Machine, c.Meta, c.Metric,
	} {
		n.Use(hooks...)
	}
}

// Intercept adds the query interceptors to all the entity clients.
// In order to add interceptors to a specific client, call: `client.Node.Intercept(...)`.
func (c *Client) Intercept(interceptors ...Interceptor) {
	for _, n := range []interface{ Intercept(...Interceptor) }{
		c.Alert, c.AllowList, c.AllowListItem, c.Bouncer, c.ConfigItem, c.Decision,
		c.Event, c.Lock, c.Machine, c.Meta, c.Metric,
	} {
		n.Intercept(interceptors...)
	}
}

// Mutate implements the ent.Mutator interface.
func (c *Client) Mutate(ctx context.Context, m Mutation) (Value, error) {
	switch m := m.(type) {
	case *AlertMutation:
		return c.Alert.mutate(ctx, m)
	case *AllowListMutation:
		return c.AllowList.mutate(ctx, m)
	case *AllowListItemMutation:
		return c.AllowListItem.mutate(ctx, m)
	case *BouncerMutation:
		return c.Bouncer.mutate(ctx, m)
	case *ConfigItemMutation:
		return c.ConfigItem.mutate(ctx, m)
	case *DecisionMutation:
		return c.Decision.mutate(ctx, m)
	case *EventMutation:
		return c.Event.mutate(ctx, m)
	case *LockMutation:
		return c.Lock.mutate(ctx, m)
	case *MachineMutation:
		return c.Machine.mutate(ctx, m)
	case *MetaMutation:
		return c.Meta.mutate(ctx, m)
	case *MetricMutation:
		return c.Metric.mutate(ctx, m)
	default:
		return nil, fmt.Errorf("ent: unknown mutation type %T", m)
	}
}

// AlertClient is a client for the Alert schema.
type AlertClient struct {
	config
}

// NewAlertClient returns a client for the Alert from the given config.
func NewAlertClient(c config) *AlertClient {
	return &AlertClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `alert.Hooks(f(g(h())))`.
func (c *AlertClient) Use(hooks ...Hook) {
	c.hooks.Alert = append(c.hooks.Alert, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `alert.Intercept(f(g(h())))`.
func (c *AlertClient) Intercept(interceptors ...Interceptor) {
	c.inters.Alert = append(c.inters.Alert, interceptors...)
}

// Create returns a builder for creating a Alert entity.
func (c *AlertClient) Create() *AlertCreate {
	mutation := newAlertMutation(c.config, OpCreate)
	return &AlertCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Alert entities.
func (c *AlertClient) CreateBulk(builders ...*AlertCreate) *AlertCreateBulk {
	return &AlertCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *AlertClient) MapCreateBulk(slice any, setFunc func(*AlertCreate, int)) *AlertCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &AlertCreateBulk{err: fmt.Errorf("calling to AlertClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*AlertCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &AlertCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Alert.
func (c *AlertClient) Update() *AlertUpdate {
	mutation := newAlertMutation(c.config, OpUpdate)
	return &AlertUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *AlertClient) UpdateOne(a *Alert) *AlertUpdateOne {
	mutation := newAlertMutation(c.config, OpUpdateOne, withAlert(a))
	return &AlertUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *AlertClient) UpdateOneID(id int) *AlertUpdateOne {
	mutation := newAlertMutation(c.config, OpUpdateOne, withAlertID(id))
	return &AlertUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Alert.
func (c *AlertClient) Delete() *AlertDelete {
	mutation := newAlertMutation(c.config, OpDelete)
	return &AlertDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *AlertClient) DeleteOne(a *Alert) *AlertDeleteOne {
	return c.DeleteOneID(a.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *AlertClient) DeleteOneID(id int) *AlertDeleteOne {
	builder := c.Delete().Where(alert.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &AlertDeleteOne{builder}
}

// Query returns a query builder for Alert.
func (c *AlertClient) Query() *AlertQuery {
	return &AlertQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeAlert},
		inters: c.Interceptors(),
	}
}

// Get returns a Alert entity by its id.
func (c *AlertClient) Get(ctx context.Context, id int) (*Alert, error) {
	return c.Query().Where(alert.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *AlertClient) GetX(ctx context.Context, id int) *Alert {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a Alert.
func (c *AlertClient) QueryOwner(a *Alert) *MachineQuery {
	query := (&MachineClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(alert.Table, alert.FieldID, id),
			sqlgraph.To(machine.Table, machine.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, alert.OwnerTable, alert.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryDecisions queries the decisions edge of a Alert.
func (c *AlertClient) QueryDecisions(a *Alert) *DecisionQuery {
	query := (&DecisionClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(alert.Table, alert.FieldID, id),
			sqlgraph.To(decision.Table, decision.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, alert.DecisionsTable, alert.DecisionsColumn),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryEvents queries the events edge of a Alert.
func (c *AlertClient) QueryEvents(a *Alert) *EventQuery {
	query := (&EventClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(alert.Table, alert.FieldID, id),
			sqlgraph.To(event.Table, event.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, alert.EventsTable, alert.EventsColumn),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// QueryMetas queries the metas edge of a Alert.
func (c *AlertClient) QueryMetas(a *Alert) *MetaQuery {
	query := (&MetaClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := a.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(alert.Table, alert.FieldID, id),
			sqlgraph.To(meta.Table, meta.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, alert.MetasTable, alert.MetasColumn),
		)
		fromV = sqlgraph.Neighbors(a.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *AlertClient) Hooks() []Hook {
	return c.hooks.Alert
}

// Interceptors returns the client interceptors.
func (c *AlertClient) Interceptors() []Interceptor {
	return c.inters.Alert
}

func (c *AlertClient) mutate(ctx context.Context, m *AlertMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&AlertCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&AlertUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&AlertUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&AlertDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Alert mutation op: %q", m.Op())
	}
}

// AllowListClient is a client for the AllowList schema.
type AllowListClient struct {
	config
}

// NewAllowListClient returns a client for the AllowList from the given config.
func NewAllowListClient(c config) *AllowListClient {
	return &AllowListClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `allowlist.Hooks(f(g(h())))`.
func (c *AllowListClient) Use(hooks ...Hook) {
	c.hooks.AllowList = append(c.hooks.AllowList, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `allowlist.Intercept(f(g(h())))`.
func (c *AllowListClient) Intercept(interceptors ...Interceptor) {
	c.inters.AllowList = append(c.inters.AllowList, interceptors...)
}

// Create returns a builder for creating a AllowList entity.
func (c *AllowListClient) Create() *AllowListCreate {
	mutation := newAllowListMutation(c.config, OpCreate)
	return &AllowListCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of AllowList entities.
func (c *AllowListClient) CreateBulk(builders ...*AllowListCreate) *AllowListCreateBulk {
	return &AllowListCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *AllowListClient) MapCreateBulk(slice any, setFunc func(*AllowListCreate, int)) *AllowListCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &AllowListCreateBulk{err: fmt.Errorf("calling to AllowListClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*AllowListCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &AllowListCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for AllowList.
func (c *AllowListClient) Update() *AllowListUpdate {
	mutation := newAllowListMutation(c.config, OpUpdate)
	return &AllowListUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *AllowListClient) UpdateOne(al *AllowList) *AllowListUpdateOne {
	mutation := newAllowListMutation(c.config, OpUpdateOne, withAllowList(al))
	return &AllowListUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *AllowListClient) UpdateOneID(id int) *AllowListUpdateOne {
	mutation := newAllowListMutation(c.config, OpUpdateOne, withAllowListID(id))
	return &AllowListUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for AllowList.
func (c *AllowListClient) Delete() *AllowListDelete {
	mutation := newAllowListMutation(c.config, OpDelete)
	return &AllowListDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *AllowListClient) DeleteOne(al *AllowList) *AllowListDeleteOne {
	return c.DeleteOneID(al.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *AllowListClient) DeleteOneID(id int) *AllowListDeleteOne {
	builder := c.Delete().Where(allowlist.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &AllowListDeleteOne{builder}
}

// Query returns a query builder for AllowList.
func (c *AllowListClient) Query() *AllowListQuery {
	return &AllowListQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeAllowList},
		inters: c.Interceptors(),
	}
}

// Get returns a AllowList entity by its id.
func (c *AllowListClient) Get(ctx context.Context, id int) (*AllowList, error) {
	return c.Query().Where(allowlist.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *AllowListClient) GetX(ctx context.Context, id int) *AllowList {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryAllowlistItems queries the allowlist_items edge of a AllowList.
func (c *AllowListClient) QueryAllowlistItems(al *AllowList) *AllowListItemQuery {
	query := (&AllowListItemClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := al.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(allowlist.Table, allowlist.FieldID, id),
			sqlgraph.To(allowlistitem.Table, allowlistitem.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, false, allowlist.AllowlistItemsTable, allowlist.AllowlistItemsPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(al.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *AllowListClient) Hooks() []Hook {
	return c.hooks.AllowList
}

// Interceptors returns the client interceptors.
func (c *AllowListClient) Interceptors() []Interceptor {
	return c.inters.AllowList
}

func (c *AllowListClient) mutate(ctx context.Context, m *AllowListMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&AllowListCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&AllowListUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&AllowListUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&AllowListDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown AllowList mutation op: %q", m.Op())
	}
}

// AllowListItemClient is a client for the AllowListItem schema.
type AllowListItemClient struct {
	config
}

// NewAllowListItemClient returns a client for the AllowListItem from the given config.
func NewAllowListItemClient(c config) *AllowListItemClient {
	return &AllowListItemClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `allowlistitem.Hooks(f(g(h())))`.
func (c *AllowListItemClient) Use(hooks ...Hook) {
	c.hooks.AllowListItem = append(c.hooks.AllowListItem, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `allowlistitem.Intercept(f(g(h())))`.
func (c *AllowListItemClient) Intercept(interceptors ...Interceptor) {
	c.inters.AllowListItem = append(c.inters.AllowListItem, interceptors...)
}

// Create returns a builder for creating a AllowListItem entity.
func (c *AllowListItemClient) Create() *AllowListItemCreate {
	mutation := newAllowListItemMutation(c.config, OpCreate)
	return &AllowListItemCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of AllowListItem entities.
func (c *AllowListItemClient) CreateBulk(builders ...*AllowListItemCreate) *AllowListItemCreateBulk {
	return &AllowListItemCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *AllowListItemClient) MapCreateBulk(slice any, setFunc func(*AllowListItemCreate, int)) *AllowListItemCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &AllowListItemCreateBulk{err: fmt.Errorf("calling to AllowListItemClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*AllowListItemCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &AllowListItemCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for AllowListItem.
func (c *AllowListItemClient) Update() *AllowListItemUpdate {
	mutation := newAllowListItemMutation(c.config, OpUpdate)
	return &AllowListItemUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *AllowListItemClient) UpdateOne(ali *AllowListItem) *AllowListItemUpdateOne {
	mutation := newAllowListItemMutation(c.config, OpUpdateOne, withAllowListItem(ali))
	return &AllowListItemUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *AllowListItemClient) UpdateOneID(id int) *AllowListItemUpdateOne {
	mutation := newAllowListItemMutation(c.config, OpUpdateOne, withAllowListItemID(id))
	return &AllowListItemUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for AllowListItem.
func (c *AllowListItemClient) Delete() *AllowListItemDelete {
	mutation := newAllowListItemMutation(c.config, OpDelete)
	return &AllowListItemDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *AllowListItemClient) DeleteOne(ali *AllowListItem) *AllowListItemDeleteOne {
	return c.DeleteOneID(ali.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *AllowListItemClient) DeleteOneID(id int) *AllowListItemDeleteOne {
	builder := c.Delete().Where(allowlistitem.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &AllowListItemDeleteOne{builder}
}

// Query returns a query builder for AllowListItem.
func (c *AllowListItemClient) Query() *AllowListItemQuery {
	return &AllowListItemQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeAllowListItem},
		inters: c.Interceptors(),
	}
}

// Get returns a AllowListItem entity by its id.
func (c *AllowListItemClient) Get(ctx context.Context, id int) (*AllowListItem, error) {
	return c.Query().Where(allowlistitem.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *AllowListItemClient) GetX(ctx context.Context, id int) *AllowListItem {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryAllowlist queries the allowlist edge of a AllowListItem.
func (c *AllowListItemClient) QueryAllowlist(ali *AllowListItem) *AllowListQuery {
	query := (&AllowListClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := ali.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(allowlistitem.Table, allowlistitem.FieldID, id),
			sqlgraph.To(allowlist.Table, allowlist.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, allowlistitem.AllowlistTable, allowlistitem.AllowlistPrimaryKey...),
		)
		fromV = sqlgraph.Neighbors(ali.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *AllowListItemClient) Hooks() []Hook {
	return c.hooks.AllowListItem
}

// Interceptors returns the client interceptors.
func (c *AllowListItemClient) Interceptors() []Interceptor {
	return c.inters.AllowListItem
}

func (c *AllowListItemClient) mutate(ctx context.Context, m *AllowListItemMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&AllowListItemCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&AllowListItemUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&AllowListItemUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&AllowListItemDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown AllowListItem mutation op: %q", m.Op())
	}
}

// BouncerClient is a client for the Bouncer schema.
type BouncerClient struct {
	config
}

// NewBouncerClient returns a client for the Bouncer from the given config.
func NewBouncerClient(c config) *BouncerClient {
	return &BouncerClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `bouncer.Hooks(f(g(h())))`.
func (c *BouncerClient) Use(hooks ...Hook) {
	c.hooks.Bouncer = append(c.hooks.Bouncer, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `bouncer.Intercept(f(g(h())))`.
func (c *BouncerClient) Intercept(interceptors ...Interceptor) {
	c.inters.Bouncer = append(c.inters.Bouncer, interceptors...)
}

// Create returns a builder for creating a Bouncer entity.
func (c *BouncerClient) Create() *BouncerCreate {
	mutation := newBouncerMutation(c.config, OpCreate)
	return &BouncerCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Bouncer entities.
func (c *BouncerClient) CreateBulk(builders ...*BouncerCreate) *BouncerCreateBulk {
	return &BouncerCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *BouncerClient) MapCreateBulk(slice any, setFunc func(*BouncerCreate, int)) *BouncerCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &BouncerCreateBulk{err: fmt.Errorf("calling to BouncerClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*BouncerCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &BouncerCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Bouncer.
func (c *BouncerClient) Update() *BouncerUpdate {
	mutation := newBouncerMutation(c.config, OpUpdate)
	return &BouncerUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *BouncerClient) UpdateOne(b *Bouncer) *BouncerUpdateOne {
	mutation := newBouncerMutation(c.config, OpUpdateOne, withBouncer(b))
	return &BouncerUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *BouncerClient) UpdateOneID(id int) *BouncerUpdateOne {
	mutation := newBouncerMutation(c.config, OpUpdateOne, withBouncerID(id))
	return &BouncerUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Bouncer.
func (c *BouncerClient) Delete() *BouncerDelete {
	mutation := newBouncerMutation(c.config, OpDelete)
	return &BouncerDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *BouncerClient) DeleteOne(b *Bouncer) *BouncerDeleteOne {
	return c.DeleteOneID(b.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *BouncerClient) DeleteOneID(id int) *BouncerDeleteOne {
	builder := c.Delete().Where(bouncer.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &BouncerDeleteOne{builder}
}

// Query returns a query builder for Bouncer.
func (c *BouncerClient) Query() *BouncerQuery {
	return &BouncerQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeBouncer},
		inters: c.Interceptors(),
	}
}

// Get returns a Bouncer entity by its id.
func (c *BouncerClient) Get(ctx context.Context, id int) (*Bouncer, error) {
	return c.Query().Where(bouncer.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *BouncerClient) GetX(ctx context.Context, id int) *Bouncer {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *BouncerClient) Hooks() []Hook {
	return c.hooks.Bouncer
}

// Interceptors returns the client interceptors.
func (c *BouncerClient) Interceptors() []Interceptor {
	return c.inters.Bouncer
}

func (c *BouncerClient) mutate(ctx context.Context, m *BouncerMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&BouncerCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&BouncerUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&BouncerUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&BouncerDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Bouncer mutation op: %q", m.Op())
	}
}

// ConfigItemClient is a client for the ConfigItem schema.
type ConfigItemClient struct {
	config
}

// NewConfigItemClient returns a client for the ConfigItem from the given config.
func NewConfigItemClient(c config) *ConfigItemClient {
	return &ConfigItemClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `configitem.Hooks(f(g(h())))`.
func (c *ConfigItemClient) Use(hooks ...Hook) {
	c.hooks.ConfigItem = append(c.hooks.ConfigItem, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `configitem.Intercept(f(g(h())))`.
func (c *ConfigItemClient) Intercept(interceptors ...Interceptor) {
	c.inters.ConfigItem = append(c.inters.ConfigItem, interceptors...)
}

// Create returns a builder for creating a ConfigItem entity.
func (c *ConfigItemClient) Create() *ConfigItemCreate {
	mutation := newConfigItemMutation(c.config, OpCreate)
	return &ConfigItemCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of ConfigItem entities.
func (c *ConfigItemClient) CreateBulk(builders ...*ConfigItemCreate) *ConfigItemCreateBulk {
	return &ConfigItemCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *ConfigItemClient) MapCreateBulk(slice any, setFunc func(*ConfigItemCreate, int)) *ConfigItemCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &ConfigItemCreateBulk{err: fmt.Errorf("calling to ConfigItemClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*ConfigItemCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &ConfigItemCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for ConfigItem.
func (c *ConfigItemClient) Update() *ConfigItemUpdate {
	mutation := newConfigItemMutation(c.config, OpUpdate)
	return &ConfigItemUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *ConfigItemClient) UpdateOne(ci *ConfigItem) *ConfigItemUpdateOne {
	mutation := newConfigItemMutation(c.config, OpUpdateOne, withConfigItem(ci))
	return &ConfigItemUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *ConfigItemClient) UpdateOneID(id int) *ConfigItemUpdateOne {
	mutation := newConfigItemMutation(c.config, OpUpdateOne, withConfigItemID(id))
	return &ConfigItemUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for ConfigItem.
func (c *ConfigItemClient) Delete() *ConfigItemDelete {
	mutation := newConfigItemMutation(c.config, OpDelete)
	return &ConfigItemDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *ConfigItemClient) DeleteOne(ci *ConfigItem) *ConfigItemDeleteOne {
	return c.DeleteOneID(ci.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *ConfigItemClient) DeleteOneID(id int) *ConfigItemDeleteOne {
	builder := c.Delete().Where(configitem.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &ConfigItemDeleteOne{builder}
}

// Query returns a query builder for ConfigItem.
func (c *ConfigItemClient) Query() *ConfigItemQuery {
	return &ConfigItemQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeConfigItem},
		inters: c.Interceptors(),
	}
}

// Get returns a ConfigItem entity by its id.
func (c *ConfigItemClient) Get(ctx context.Context, id int) (*ConfigItem, error) {
	return c.Query().Where(configitem.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *ConfigItemClient) GetX(ctx context.Context, id int) *ConfigItem {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *ConfigItemClient) Hooks() []Hook {
	return c.hooks.ConfigItem
}

// Interceptors returns the client interceptors.
func (c *ConfigItemClient) Interceptors() []Interceptor {
	return c.inters.ConfigItem
}

func (c *ConfigItemClient) mutate(ctx context.Context, m *ConfigItemMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&ConfigItemCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&ConfigItemUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&ConfigItemUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&ConfigItemDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown ConfigItem mutation op: %q", m.Op())
	}
}

// DecisionClient is a client for the Decision schema.
type DecisionClient struct {
	config
}

// NewDecisionClient returns a client for the Decision from the given config.
func NewDecisionClient(c config) *DecisionClient {
	return &DecisionClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `decision.Hooks(f(g(h())))`.
func (c *DecisionClient) Use(hooks ...Hook) {
	c.hooks.Decision = append(c.hooks.Decision, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `decision.Intercept(f(g(h())))`.
func (c *DecisionClient) Intercept(interceptors ...Interceptor) {
	c.inters.Decision = append(c.inters.Decision, interceptors...)
}

// Create returns a builder for creating a Decision entity.
func (c *DecisionClient) Create() *DecisionCreate {
	mutation := newDecisionMutation(c.config, OpCreate)
	return &DecisionCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Decision entities.
func (c *DecisionClient) CreateBulk(builders ...*DecisionCreate) *DecisionCreateBulk {
	return &DecisionCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *DecisionClient) MapCreateBulk(slice any, setFunc func(*DecisionCreate, int)) *DecisionCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &DecisionCreateBulk{err: fmt.Errorf("calling to DecisionClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*DecisionCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &DecisionCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Decision.
func (c *DecisionClient) Update() *DecisionUpdate {
	mutation := newDecisionMutation(c.config, OpUpdate)
	return &DecisionUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *DecisionClient) UpdateOne(d *Decision) *DecisionUpdateOne {
	mutation := newDecisionMutation(c.config, OpUpdateOne, withDecision(d))
	return &DecisionUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *DecisionClient) UpdateOneID(id int) *DecisionUpdateOne {
	mutation := newDecisionMutation(c.config, OpUpdateOne, withDecisionID(id))
	return &DecisionUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Decision.
func (c *DecisionClient) Delete() *DecisionDelete {
	mutation := newDecisionMutation(c.config, OpDelete)
	return &DecisionDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *DecisionClient) DeleteOne(d *Decision) *DecisionDeleteOne {
	return c.DeleteOneID(d.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *DecisionClient) DeleteOneID(id int) *DecisionDeleteOne {
	builder := c.Delete().Where(decision.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &DecisionDeleteOne{builder}
}

// Query returns a query builder for Decision.
func (c *DecisionClient) Query() *DecisionQuery {
	return &DecisionQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeDecision},
		inters: c.Interceptors(),
	}
}

// Get returns a Decision entity by its id.
func (c *DecisionClient) Get(ctx context.Context, id int) (*Decision, error) {
	return c.Query().Where(decision.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *DecisionClient) GetX(ctx context.Context, id int) *Decision {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a Decision.
func (c *DecisionClient) QueryOwner(d *Decision) *AlertQuery {
	query := (&AlertClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := d.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(decision.Table, decision.FieldID, id),
			sqlgraph.To(alert.Table, alert.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, decision.OwnerTable, decision.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(d.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *DecisionClient) Hooks() []Hook {
	return c.hooks.Decision
}

// Interceptors returns the client interceptors.
func (c *DecisionClient) Interceptors() []Interceptor {
	return c.inters.Decision
}

func (c *DecisionClient) mutate(ctx context.Context, m *DecisionMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&DecisionCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&DecisionUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&DecisionUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&DecisionDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Decision mutation op: %q", m.Op())
	}
}

// EventClient is a client for the Event schema.
type EventClient struct {
	config
}

// NewEventClient returns a client for the Event from the given config.
func NewEventClient(c config) *EventClient {
	return &EventClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `event.Hooks(f(g(h())))`.
func (c *EventClient) Use(hooks ...Hook) {
	c.hooks.Event = append(c.hooks.Event, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `event.Intercept(f(g(h())))`.
func (c *EventClient) Intercept(interceptors ...Interceptor) {
	c.inters.Event = append(c.inters.Event, interceptors...)
}

// Create returns a builder for creating a Event entity.
func (c *EventClient) Create() *EventCreate {
	mutation := newEventMutation(c.config, OpCreate)
	return &EventCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Event entities.
func (c *EventClient) CreateBulk(builders ...*EventCreate) *EventCreateBulk {
	return &EventCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *EventClient) MapCreateBulk(slice any, setFunc func(*EventCreate, int)) *EventCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &EventCreateBulk{err: fmt.Errorf("calling to EventClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*EventCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &EventCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Event.
func (c *EventClient) Update() *EventUpdate {
	mutation := newEventMutation(c.config, OpUpdate)
	return &EventUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *EventClient) UpdateOne(e *Event) *EventUpdateOne {
	mutation := newEventMutation(c.config, OpUpdateOne, withEvent(e))
	return &EventUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *EventClient) UpdateOneID(id int) *EventUpdateOne {
	mutation := newEventMutation(c.config, OpUpdateOne, withEventID(id))
	return &EventUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Event.
func (c *EventClient) Delete() *EventDelete {
	mutation := newEventMutation(c.config, OpDelete)
	return &EventDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *EventClient) DeleteOne(e *Event) *EventDeleteOne {
	return c.DeleteOneID(e.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *EventClient) DeleteOneID(id int) *EventDeleteOne {
	builder := c.Delete().Where(event.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &EventDeleteOne{builder}
}

// Query returns a query builder for Event.
func (c *EventClient) Query() *EventQuery {
	return &EventQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeEvent},
		inters: c.Interceptors(),
	}
}

// Get returns a Event entity by its id.
func (c *EventClient) Get(ctx context.Context, id int) (*Event, error) {
	return c.Query().Where(event.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *EventClient) GetX(ctx context.Context, id int) *Event {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a Event.
func (c *EventClient) QueryOwner(e *Event) *AlertQuery {
	query := (&AlertClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := e.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(event.Table, event.FieldID, id),
			sqlgraph.To(alert.Table, alert.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, event.OwnerTable, event.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(e.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *EventClient) Hooks() []Hook {
	return c.hooks.Event
}

// Interceptors returns the client interceptors.
func (c *EventClient) Interceptors() []Interceptor {
	return c.inters.Event
}

func (c *EventClient) mutate(ctx context.Context, m *EventMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&EventCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&EventUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&EventUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&EventDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Event mutation op: %q", m.Op())
	}
}

// LockClient is a client for the Lock schema.
type LockClient struct {
	config
}

// NewLockClient returns a client for the Lock from the given config.
func NewLockClient(c config) *LockClient {
	return &LockClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `lock.Hooks(f(g(h())))`.
func (c *LockClient) Use(hooks ...Hook) {
	c.hooks.Lock = append(c.hooks.Lock, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `lock.Intercept(f(g(h())))`.
func (c *LockClient) Intercept(interceptors ...Interceptor) {
	c.inters.Lock = append(c.inters.Lock, interceptors...)
}

// Create returns a builder for creating a Lock entity.
func (c *LockClient) Create() *LockCreate {
	mutation := newLockMutation(c.config, OpCreate)
	return &LockCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Lock entities.
func (c *LockClient) CreateBulk(builders ...*LockCreate) *LockCreateBulk {
	return &LockCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *LockClient) MapCreateBulk(slice any, setFunc func(*LockCreate, int)) *LockCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &LockCreateBulk{err: fmt.Errorf("calling to LockClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*LockCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &LockCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Lock.
func (c *LockClient) Update() *LockUpdate {
	mutation := newLockMutation(c.config, OpUpdate)
	return &LockUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *LockClient) UpdateOne(l *Lock) *LockUpdateOne {
	mutation := newLockMutation(c.config, OpUpdateOne, withLock(l))
	return &LockUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *LockClient) UpdateOneID(id int) *LockUpdateOne {
	mutation := newLockMutation(c.config, OpUpdateOne, withLockID(id))
	return &LockUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Lock.
func (c *LockClient) Delete() *LockDelete {
	mutation := newLockMutation(c.config, OpDelete)
	return &LockDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *LockClient) DeleteOne(l *Lock) *LockDeleteOne {
	return c.DeleteOneID(l.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *LockClient) DeleteOneID(id int) *LockDeleteOne {
	builder := c.Delete().Where(lock.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &LockDeleteOne{builder}
}

// Query returns a query builder for Lock.
func (c *LockClient) Query() *LockQuery {
	return &LockQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeLock},
		inters: c.Interceptors(),
	}
}

// Get returns a Lock entity by its id.
func (c *LockClient) Get(ctx context.Context, id int) (*Lock, error) {
	return c.Query().Where(lock.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *LockClient) GetX(ctx context.Context, id int) *Lock {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *LockClient) Hooks() []Hook {
	return c.hooks.Lock
}

// Interceptors returns the client interceptors.
func (c *LockClient) Interceptors() []Interceptor {
	return c.inters.Lock
}

func (c *LockClient) mutate(ctx context.Context, m *LockMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&LockCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&LockUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&LockUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&LockDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Lock mutation op: %q", m.Op())
	}
}

// MachineClient is a client for the Machine schema.
type MachineClient struct {
	config
}

// NewMachineClient returns a client for the Machine from the given config.
func NewMachineClient(c config) *MachineClient {
	return &MachineClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `machine.Hooks(f(g(h())))`.
func (c *MachineClient) Use(hooks ...Hook) {
	c.hooks.Machine = append(c.hooks.Machine, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `machine.Intercept(f(g(h())))`.
func (c *MachineClient) Intercept(interceptors ...Interceptor) {
	c.inters.Machine = append(c.inters.Machine, interceptors...)
}

// Create returns a builder for creating a Machine entity.
func (c *MachineClient) Create() *MachineCreate {
	mutation := newMachineMutation(c.config, OpCreate)
	return &MachineCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Machine entities.
func (c *MachineClient) CreateBulk(builders ...*MachineCreate) *MachineCreateBulk {
	return &MachineCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *MachineClient) MapCreateBulk(slice any, setFunc func(*MachineCreate, int)) *MachineCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &MachineCreateBulk{err: fmt.Errorf("calling to MachineClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*MachineCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &MachineCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Machine.
func (c *MachineClient) Update() *MachineUpdate {
	mutation := newMachineMutation(c.config, OpUpdate)
	return &MachineUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *MachineClient) UpdateOne(m *Machine) *MachineUpdateOne {
	mutation := newMachineMutation(c.config, OpUpdateOne, withMachine(m))
	return &MachineUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *MachineClient) UpdateOneID(id int) *MachineUpdateOne {
	mutation := newMachineMutation(c.config, OpUpdateOne, withMachineID(id))
	return &MachineUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Machine.
func (c *MachineClient) Delete() *MachineDelete {
	mutation := newMachineMutation(c.config, OpDelete)
	return &MachineDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *MachineClient) DeleteOne(m *Machine) *MachineDeleteOne {
	return c.DeleteOneID(m.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *MachineClient) DeleteOneID(id int) *MachineDeleteOne {
	builder := c.Delete().Where(machine.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &MachineDeleteOne{builder}
}

// Query returns a query builder for Machine.
func (c *MachineClient) Query() *MachineQuery {
	return &MachineQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeMachine},
		inters: c.Interceptors(),
	}
}

// Get returns a Machine entity by its id.
func (c *MachineClient) Get(ctx context.Context, id int) (*Machine, error) {
	return c.Query().Where(machine.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *MachineClient) GetX(ctx context.Context, id int) *Machine {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryAlerts queries the alerts edge of a Machine.
func (c *MachineClient) QueryAlerts(m *Machine) *AlertQuery {
	query := (&AlertClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := m.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(machine.Table, machine.FieldID, id),
			sqlgraph.To(alert.Table, alert.FieldID),
			sqlgraph.Edge(sqlgraph.O2M, false, machine.AlertsTable, machine.AlertsColumn),
		)
		fromV = sqlgraph.Neighbors(m.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *MachineClient) Hooks() []Hook {
	return c.hooks.Machine
}

// Interceptors returns the client interceptors.
func (c *MachineClient) Interceptors() []Interceptor {
	return c.inters.Machine
}

func (c *MachineClient) mutate(ctx context.Context, m *MachineMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&MachineCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&MachineUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&MachineUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&MachineDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Machine mutation op: %q", m.Op())
	}
}

// MetaClient is a client for the Meta schema.
type MetaClient struct {
	config
}

// NewMetaClient returns a client for the Meta from the given config.
func NewMetaClient(c config) *MetaClient {
	return &MetaClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `meta.Hooks(f(g(h())))`.
func (c *MetaClient) Use(hooks ...Hook) {
	c.hooks.Meta = append(c.hooks.Meta, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `meta.Intercept(f(g(h())))`.
func (c *MetaClient) Intercept(interceptors ...Interceptor) {
	c.inters.Meta = append(c.inters.Meta, interceptors...)
}

// Create returns a builder for creating a Meta entity.
func (c *MetaClient) Create() *MetaCreate {
	mutation := newMetaMutation(c.config, OpCreate)
	return &MetaCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Meta entities.
func (c *MetaClient) CreateBulk(builders ...*MetaCreate) *MetaCreateBulk {
	return &MetaCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *MetaClient) MapCreateBulk(slice any, setFunc func(*MetaCreate, int)) *MetaCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &MetaCreateBulk{err: fmt.Errorf("calling to MetaClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*MetaCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &MetaCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Meta.
func (c *MetaClient) Update() *MetaUpdate {
	mutation := newMetaMutation(c.config, OpUpdate)
	return &MetaUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *MetaClient) UpdateOne(m *Meta) *MetaUpdateOne {
	mutation := newMetaMutation(c.config, OpUpdateOne, withMeta(m))
	return &MetaUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *MetaClient) UpdateOneID(id int) *MetaUpdateOne {
	mutation := newMetaMutation(c.config, OpUpdateOne, withMetaID(id))
	return &MetaUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Meta.
func (c *MetaClient) Delete() *MetaDelete {
	mutation := newMetaMutation(c.config, OpDelete)
	return &MetaDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *MetaClient) DeleteOne(m *Meta) *MetaDeleteOne {
	return c.DeleteOneID(m.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *MetaClient) DeleteOneID(id int) *MetaDeleteOne {
	builder := c.Delete().Where(meta.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &MetaDeleteOne{builder}
}

// Query returns a query builder for Meta.
func (c *MetaClient) Query() *MetaQuery {
	return &MetaQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeMeta},
		inters: c.Interceptors(),
	}
}

// Get returns a Meta entity by its id.
func (c *MetaClient) Get(ctx context.Context, id int) (*Meta, error) {
	return c.Query().Where(meta.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *MetaClient) GetX(ctx context.Context, id int) *Meta {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// QueryOwner queries the owner edge of a Meta.
func (c *MetaClient) QueryOwner(m *Meta) *AlertQuery {
	query := (&AlertClient{config: c.config}).Query()
	query.path = func(context.Context) (fromV *sql.Selector, _ error) {
		id := m.ID
		step := sqlgraph.NewStep(
			sqlgraph.From(meta.Table, meta.FieldID, id),
			sqlgraph.To(alert.Table, alert.FieldID),
			sqlgraph.Edge(sqlgraph.M2O, true, meta.OwnerTable, meta.OwnerColumn),
		)
		fromV = sqlgraph.Neighbors(m.driver.Dialect(), step)
		return fromV, nil
	}
	return query
}

// Hooks returns the client hooks.
func (c *MetaClient) Hooks() []Hook {
	return c.hooks.Meta
}

// Interceptors returns the client interceptors.
func (c *MetaClient) Interceptors() []Interceptor {
	return c.inters.Meta
}

func (c *MetaClient) mutate(ctx context.Context, m *MetaMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&MetaCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&MetaUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&MetaUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&MetaDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Meta mutation op: %q", m.Op())
	}
}

// MetricClient is a client for the Metric schema.
type MetricClient struct {
	config
}

// NewMetricClient returns a client for the Metric from the given config.
func NewMetricClient(c config) *MetricClient {
	return &MetricClient{config: c}
}

// Use adds a list of mutation hooks to the hooks stack.
// A call to `Use(f, g, h)` equals to `metric.Hooks(f(g(h())))`.
func (c *MetricClient) Use(hooks ...Hook) {
	c.hooks.Metric = append(c.hooks.Metric, hooks...)
}

// Intercept adds a list of query interceptors to the interceptors stack.
// A call to `Intercept(f, g, h)` equals to `metric.Intercept(f(g(h())))`.
func (c *MetricClient) Intercept(interceptors ...Interceptor) {
	c.inters.Metric = append(c.inters.Metric, interceptors...)
}

// Create returns a builder for creating a Metric entity.
func (c *MetricClient) Create() *MetricCreate {
	mutation := newMetricMutation(c.config, OpCreate)
	return &MetricCreate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// CreateBulk returns a builder for creating a bulk of Metric entities.
func (c *MetricClient) CreateBulk(builders ...*MetricCreate) *MetricCreateBulk {
	return &MetricCreateBulk{config: c.config, builders: builders}
}

// MapCreateBulk creates a bulk creation builder from the given slice. For each item in the slice, the function creates
// a builder and applies setFunc on it.
func (c *MetricClient) MapCreateBulk(slice any, setFunc func(*MetricCreate, int)) *MetricCreateBulk {
	rv := reflect.ValueOf(slice)
	if rv.Kind() != reflect.Slice {
		return &MetricCreateBulk{err: fmt.Errorf("calling to MetricClient.MapCreateBulk with wrong type %T, need slice", slice)}
	}
	builders := make([]*MetricCreate, rv.Len())
	for i := 0; i < rv.Len(); i++ {
		builders[i] = c.Create()
		setFunc(builders[i], i)
	}
	return &MetricCreateBulk{config: c.config, builders: builders}
}

// Update returns an update builder for Metric.
func (c *MetricClient) Update() *MetricUpdate {
	mutation := newMetricMutation(c.config, OpUpdate)
	return &MetricUpdate{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOne returns an update builder for the given entity.
func (c *MetricClient) UpdateOne(m *Metric) *MetricUpdateOne {
	mutation := newMetricMutation(c.config, OpUpdateOne, withMetric(m))
	return &MetricUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// UpdateOneID returns an update builder for the given id.
func (c *MetricClient) UpdateOneID(id int) *MetricUpdateOne {
	mutation := newMetricMutation(c.config, OpUpdateOne, withMetricID(id))
	return &MetricUpdateOne{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// Delete returns a delete builder for Metric.
func (c *MetricClient) Delete() *MetricDelete {
	mutation := newMetricMutation(c.config, OpDelete)
	return &MetricDelete{config: c.config, hooks: c.Hooks(), mutation: mutation}
}

// DeleteOne returns a builder for deleting the given entity.
func (c *MetricClient) DeleteOne(m *Metric) *MetricDeleteOne {
	return c.DeleteOneID(m.ID)
}

// DeleteOneID returns a builder for deleting the given entity by its id.
func (c *MetricClient) DeleteOneID(id int) *MetricDeleteOne {
	builder := c.Delete().Where(metric.ID(id))
	builder.mutation.id = &id
	builder.mutation.op = OpDeleteOne
	return &MetricDeleteOne{builder}
}

// Query returns a query builder for Metric.
func (c *MetricClient) Query() *MetricQuery {
	return &MetricQuery{
		config: c.config,
		ctx:    &QueryContext{Type: TypeMetric},
		inters: c.Interceptors(),
	}
}

// Get returns a Metric entity by its id.
func (c *MetricClient) Get(ctx context.Context, id int) (*Metric, error) {
	return c.Query().Where(metric.ID(id)).Only(ctx)
}

// GetX is like Get, but panics if an error occurs.
func (c *MetricClient) GetX(ctx context.Context, id int) *Metric {
	obj, err := c.Get(ctx, id)
	if err != nil {
		panic(err)
	}
	return obj
}

// Hooks returns the client hooks.
func (c *MetricClient) Hooks() []Hook {
	return c.hooks.Metric
}

// Interceptors returns the client interceptors.
func (c *MetricClient) Interceptors() []Interceptor {
	return c.inters.Metric
}

func (c *MetricClient) mutate(ctx context.Context, m *MetricMutation) (Value, error) {
	switch m.Op() {
	case OpCreate:
		return (&MetricCreate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdate:
		return (&MetricUpdate{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpUpdateOne:
		return (&MetricUpdateOne{config: c.config, hooks: c.Hooks(), mutation: m}).Save(ctx)
	case OpDelete, OpDeleteOne:
		return (&MetricDelete{config: c.config, hooks: c.Hooks(), mutation: m}).Exec(ctx)
	default:
		return nil, fmt.Errorf("ent: unknown Metric mutation op: %q", m.Op())
	}
}

// hooks and interceptors per client, for fast access.
type (
	hooks struct {
		Alert, AllowList, AllowListItem, Bouncer, ConfigItem, Decision, Event, Lock,
		Machine, Meta, Metric []ent.Hook
	}
	inters struct {
		Alert, AllowList, AllowListItem, Bouncer, ConfigItem, Decision, Event, Lock,
		Machine, Meta, Metric []ent.Interceptor
	}
)
