// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: scheduler.proto

package blocksconvert

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type NextPlanRequest struct {
	// Name of service requesting the plan.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *NextPlanRequest) Reset()      { *m = NextPlanRequest{} }
func (*NextPlanRequest) ProtoMessage() {}
func (*NextPlanRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b3fc28395a6d9c5, []int{0}
}
func (m *NextPlanRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NextPlanRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NextPlanRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NextPlanRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NextPlanRequest.Merge(m, src)
}
func (m *NextPlanRequest) XXX_Size() int {
	return m.Size()
}
func (m *NextPlanRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NextPlanRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NextPlanRequest proto.InternalMessageInfo

func (m *NextPlanRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type NextPlanResponse struct {
	PlanFile     string `protobuf:"bytes,1,opt,name=planFile,proto3" json:"planFile,omitempty"`
	ProgressFile string `protobuf:"bytes,2,opt,name=progressFile,proto3" json:"progressFile,omitempty"`
}

func (m *NextPlanResponse) Reset()      { *m = NextPlanResponse{} }
func (*NextPlanResponse) ProtoMessage() {}
func (*NextPlanResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b3fc28395a6d9c5, []int{1}
}
func (m *NextPlanResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NextPlanResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NextPlanResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NextPlanResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NextPlanResponse.Merge(m, src)
}
func (m *NextPlanResponse) XXX_Size() int {
	return m.Size()
}
func (m *NextPlanResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NextPlanResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NextPlanResponse proto.InternalMessageInfo

func (m *NextPlanResponse) GetPlanFile() string {
	if m != nil {
		return m.PlanFile
	}
	return ""
}

func (m *NextPlanResponse) GetProgressFile() string {
	if m != nil {
		return m.ProgressFile
	}
	return ""
}

func init() {
	proto.RegisterType((*NextPlanRequest)(nil), "blocksconvert.NextPlanRequest")
	proto.RegisterType((*NextPlanResponse)(nil), "blocksconvert.NextPlanResponse")
}

func init() { proto.RegisterFile("scheduler.proto", fileDescriptor_2b3fc28395a6d9c5) }

var fileDescriptor_2b3fc28395a6d9c5 = []byte{
	// 264 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0xe2, 0x2f, 0x4e, 0xce, 0x48,
	0x4d, 0x29, 0xcd, 0x49, 0x2d, 0xd2, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0xe2, 0x4d, 0xca, 0xc9,
	0x4f, 0xce, 0x2e, 0x4e, 0xce, 0xcf, 0x2b, 0x4b, 0x2d, 0x2a, 0x91, 0xd2, 0x4d, 0xcf, 0x2c, 0xc9,
	0x28, 0x4d, 0xd2, 0x4b, 0xce, 0xcf, 0xd5, 0x4f, 0xcf, 0x4f, 0xcf, 0xd7, 0x07, 0xab, 0x4a, 0x2a,
	0x4d, 0x03, 0xf3, 0xc0, 0x1c, 0x30, 0x0b, 0xa2, 0x5b, 0x49, 0x95, 0x8b, 0xdf, 0x2f, 0xb5, 0xa2,
	0x24, 0x20, 0x27, 0x31, 0x2f, 0x28, 0xb5, 0xb0, 0x34, 0xb5, 0xb8, 0x44, 0x48, 0x88, 0x8b, 0x25,
	0x2f, 0x31, 0x37, 0x55, 0x82, 0x51, 0x81, 0x51, 0x83, 0x33, 0x08, 0xcc, 0x56, 0x0a, 0xe2, 0x12,
	0x40, 0x28, 0x2b, 0x2e, 0xc8, 0xcf, 0x2b, 0x4e, 0x15, 0x92, 0xe2, 0xe2, 0x28, 0xc8, 0x49, 0xcc,
	0x73, 0xcb, 0xcc, 0x81, 0xa9, 0x85, 0xf3, 0x85, 0x94, 0xb8, 0x78, 0x0a, 0x8a, 0xf2, 0xd3, 0x8b,
	0x52, 0x8b, 0x8b, 0xc1, 0xf2, 0x4c, 0x60, 0x79, 0x14, 0x31, 0xa3, 0x28, 0x2e, 0xce, 0x60, 0x98,
	0x5f, 0x84, 0x7c, 0xb9, 0x38, 0x60, 0x16, 0x08, 0xc9, 0xe9, 0xa1, 0x78, 0x49, 0x0f, 0xcd, 0x81,
	0x52, 0xf2, 0x38, 0xe5, 0x21, 0x2e, 0x53, 0x62, 0x70, 0x72, 0xbe, 0xf0, 0x50, 0x8e, 0xe1, 0xc6,
	0x43, 0x39, 0x86, 0x0f, 0x0f, 0xe5, 0x18, 0x1b, 0x1e, 0xc9, 0x31, 0xae, 0x78, 0x24, 0xc7, 0x78,
	0xe2, 0x91, 0x1c, 0xe3, 0x85, 0x47, 0x72, 0x8c, 0x0f, 0x1e, 0xc9, 0x31, 0xbe, 0x78, 0x24, 0xc7,
	0xf0, 0xe1, 0x91, 0x1c, 0xe3, 0x84, 0xc7, 0x72, 0x0c, 0x17, 0x1e, 0xcb, 0x31, 0xdc, 0x78, 0x2c,
	0xc7, 0x10, 0x85, 0x1a, 0x94, 0x49, 0x6c, 0xe0, 0x20, 0x32, 0x06, 0x04, 0x00, 0x00, 0xff, 0xff,
	0xf7, 0x7b, 0xa4, 0x64, 0x73, 0x01, 0x00, 0x00,
}

func (this *NextPlanRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NextPlanRequest)
	if !ok {
		that2, ok := that.(NextPlanRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	return true
}
func (this *NextPlanResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NextPlanResponse)
	if !ok {
		that2, ok := that.(NextPlanResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.PlanFile != that1.PlanFile {
		return false
	}
	if this.ProgressFile != that1.ProgressFile {
		return false
	}
	return true
}
func (this *NextPlanRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&blocksconvert.NextPlanRequest{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NextPlanResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&blocksconvert.NextPlanResponse{")
	s = append(s, "PlanFile: "+fmt.Sprintf("%#v", this.PlanFile)+",\n")
	s = append(s, "ProgressFile: "+fmt.Sprintf("%#v", this.ProgressFile)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringScheduler(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SchedulerClient is the client API for Scheduler service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SchedulerClient interface {
	// Returns next plan that builder should work on.
	NextPlan(ctx context.Context, in *NextPlanRequest, opts ...grpc.CallOption) (*NextPlanResponse, error)
}

type schedulerClient struct {
	cc *grpc.ClientConn
}

func NewSchedulerClient(cc *grpc.ClientConn) SchedulerClient {
	return &schedulerClient{cc}
}

func (c *schedulerClient) NextPlan(ctx context.Context, in *NextPlanRequest, opts ...grpc.CallOption) (*NextPlanResponse, error) {
	out := new(NextPlanResponse)
	err := c.cc.Invoke(ctx, "/blocksconvert.Scheduler/NextPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SchedulerServer is the server API for Scheduler service.
type SchedulerServer interface {
	// Returns next plan that builder should work on.
	NextPlan(context.Context, *NextPlanRequest) (*NextPlanResponse, error)
}

// UnimplementedSchedulerServer can be embedded to have forward compatible implementations.
type UnimplementedSchedulerServer struct {
}

func (*UnimplementedSchedulerServer) NextPlan(ctx context.Context, req *NextPlanRequest) (*NextPlanResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NextPlan not implemented")
}

func RegisterSchedulerServer(s *grpc.Server, srv SchedulerServer) {
	s.RegisterService(&_Scheduler_serviceDesc, srv)
}

func _Scheduler_NextPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NextPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SchedulerServer).NextPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/blocksconvert.Scheduler/NextPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SchedulerServer).NextPlan(ctx, req.(*NextPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Scheduler_serviceDesc = grpc.ServiceDesc{
	ServiceName: "blocksconvert.Scheduler",
	HandlerType: (*SchedulerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "NextPlan",
			Handler:    _Scheduler_NextPlan_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "scheduler.proto",
}

func (m *NextPlanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NextPlanRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NextPlanRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintScheduler(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NextPlanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NextPlanResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NextPlanResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ProgressFile) > 0 {
		i -= len(m.ProgressFile)
		copy(dAtA[i:], m.ProgressFile)
		i = encodeVarintScheduler(dAtA, i, uint64(len(m.ProgressFile)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.PlanFile) > 0 {
		i -= len(m.PlanFile)
		copy(dAtA[i:], m.PlanFile)
		i = encodeVarintScheduler(dAtA, i, uint64(len(m.PlanFile)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintScheduler(dAtA []byte, offset int, v uint64) int {
	offset -= sovScheduler(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *NextPlanRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func (m *NextPlanResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PlanFile)
	if l > 0 {
		n += 1 + l + sovScheduler(uint64(l))
	}
	l = len(m.ProgressFile)
	if l > 0 {
		n += 1 + l + sovScheduler(uint64(l))
	}
	return n
}

func sovScheduler(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozScheduler(x uint64) (n int) {
	return sovScheduler(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *NextPlanRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NextPlanRequest{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NextPlanResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NextPlanResponse{`,
		`PlanFile:` + fmt.Sprintf("%v", this.PlanFile) + `,`,
		`ProgressFile:` + fmt.Sprintf("%v", this.ProgressFile) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringScheduler(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *NextPlanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NextPlanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NextPlanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthScheduler
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NextPlanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NextPlanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NextPlanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PlanFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthScheduler
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PlanFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProgressFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthScheduler
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthScheduler
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProgressFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipScheduler(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthScheduler
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipScheduler(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowScheduler
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowScheduler
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthScheduler
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthScheduler
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowScheduler
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipScheduler(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthScheduler
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthScheduler = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowScheduler   = fmt.Errorf("proto: integer overflow")
)
