// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the encryption control configuration for a VPC. You can update the
// encryption mode and exclusion settings for various gateway types and peering
// connections.
//
// For more information, see [Enforce VPC encryption in transit] in the Amazon VPC User Guide.
//
// [Enforce VPC encryption in transit]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-encryption-controls.html
func (c *Client) ModifyVpcEncryptionControl(ctx context.Context, params *ModifyVpcEncryptionControlInput, optFns ...func(*Options)) (*ModifyVpcEncryptionControlOutput, error) {
	if params == nil {
		params = &ModifyVpcEncryptionControlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ModifyVpcEncryptionControl", params, optFns, c.addOperationModifyVpcEncryptionControlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ModifyVpcEncryptionControlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ModifyVpcEncryptionControlInput struct {

	// The ID of the VPC Encryption Control resource to modify.
	//
	// This member is required.
	VpcEncryptionControlId *string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// Specifies whether to exclude egress-only internet gateway traffic from
	// encryption enforcement.
	EgressOnlyInternetGatewayExclusion types.VpcEncryptionControlExclusionStateInput

	// Specifies whether to exclude Elastic File System traffic from encryption
	// enforcement.
	ElasticFileSystemExclusion types.VpcEncryptionControlExclusionStateInput

	// Specifies whether to exclude internet gateway traffic from encryption
	// enforcement.
	InternetGatewayExclusion types.VpcEncryptionControlExclusionStateInput

	// Specifies whether to exclude Lambda function traffic from encryption
	// enforcement.
	LambdaExclusion types.VpcEncryptionControlExclusionStateInput

	// The encryption mode for the VPC Encryption Control configuration.
	Mode types.VpcEncryptionControlMode

	// Specifies whether to exclude NAT gateway traffic from encryption enforcement.
	NatGatewayExclusion types.VpcEncryptionControlExclusionStateInput

	// Specifies whether to exclude virtual private gateway traffic from encryption
	// enforcement.
	VirtualPrivateGatewayExclusion types.VpcEncryptionControlExclusionStateInput

	// Specifies whether to exclude VPC Lattice traffic from encryption enforcement.
	VpcLatticeExclusion types.VpcEncryptionControlExclusionStateInput

	// Specifies whether to exclude VPC peering connection traffic from encryption
	// enforcement.
	VpcPeeringExclusion types.VpcEncryptionControlExclusionStateInput

	noSmithyDocumentSerde
}

type ModifyVpcEncryptionControlOutput struct {

	// Information about the VPC Encryption Control configuration.
	VpcEncryptionControl *types.VpcEncryptionControl

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationModifyVpcEncryptionControlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpModifyVpcEncryptionControl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpModifyVpcEncryptionControl{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ModifyVpcEncryptionControl"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpModifyVpcEncryptionControlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opModifyVpcEncryptionControl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opModifyVpcEncryptionControl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ModifyVpcEncryptionControl",
	}
}
