// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the entries in image usage reports, showing how your images are used
// across other Amazon Web Services accounts.
//
// For more information, see [View your AMI usage] in the Amazon EC2 User Guide.
//
// [View your AMI usage]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/your-ec2-ami-usage.html
func (c *Client) DescribeImageUsageReportEntries(ctx context.Context, params *DescribeImageUsageReportEntriesInput, optFns ...func(*Options)) (*DescribeImageUsageReportEntriesOutput, error) {
	if params == nil {
		params = &DescribeImageUsageReportEntriesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeImageUsageReportEntries", params, optFns, c.addOperationDescribeImageUsageReportEntriesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeImageUsageReportEntriesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeImageUsageReportEntriesInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The filters.
	//
	//   - account-id - A 12-digit Amazon Web Services account ID.
	//
	//   - creation-time - The time when the report was created, in the ISO 8601 format
	//   in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example,
	//   2025-11-29T11:04:43.305Z . You can use a wildcard ( * ), for example,
	//   2025-11-29T* , which matches an entire day.
	//
	//   - resource-type - The resource type ( ec2:Instance | ec2:LaunchTemplate ).
	Filters []types.Filter

	// The IDs of the images for filtering the report entries. If specified, only
	// report entries containing these images are returned.
	ImageIds []string

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	MaxResults *int32

	// The token returned from a previous paginated request. Pagination continues from
	// the end of the items returned by the previous request.
	NextToken *string

	// The IDs of the usage reports.
	ReportIds []string

	noSmithyDocumentSerde
}

type DescribeImageUsageReportEntriesOutput struct {

	// The content of the usage reports.
	ImageUsageReportEntries []types.ImageUsageReportEntry

	// The token to include in another request to get the next page of items. This
	// value is null when there are no more items to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeImageUsageReportEntriesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeImageUsageReportEntries{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeImageUsageReportEntries{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeImageUsageReportEntries"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeImageUsageReportEntries(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeImageUsageReportEntriesPaginatorOptions is the paginator options for
// DescribeImageUsageReportEntries
type DescribeImageUsageReportEntriesPaginatorOptions struct {
	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeImageUsageReportEntriesPaginator is a paginator for
// DescribeImageUsageReportEntries
type DescribeImageUsageReportEntriesPaginator struct {
	options   DescribeImageUsageReportEntriesPaginatorOptions
	client    DescribeImageUsageReportEntriesAPIClient
	params    *DescribeImageUsageReportEntriesInput
	nextToken *string
	firstPage bool
}

// NewDescribeImageUsageReportEntriesPaginator returns a new
// DescribeImageUsageReportEntriesPaginator
func NewDescribeImageUsageReportEntriesPaginator(client DescribeImageUsageReportEntriesAPIClient, params *DescribeImageUsageReportEntriesInput, optFns ...func(*DescribeImageUsageReportEntriesPaginatorOptions)) *DescribeImageUsageReportEntriesPaginator {
	if params == nil {
		params = &DescribeImageUsageReportEntriesInput{}
	}

	options := DescribeImageUsageReportEntriesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeImageUsageReportEntriesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeImageUsageReportEntriesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeImageUsageReportEntries page.
func (p *DescribeImageUsageReportEntriesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeImageUsageReportEntriesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeImageUsageReportEntries(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeImageUsageReportEntriesAPIClient is a client that implements the
// DescribeImageUsageReportEntries operation.
type DescribeImageUsageReportEntriesAPIClient interface {
	DescribeImageUsageReportEntries(context.Context, *DescribeImageUsageReportEntriesInput, ...func(*Options)) (*DescribeImageUsageReportEntriesOutput, error)
}

var _ DescribeImageUsageReportEntriesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeImageUsageReportEntries(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeImageUsageReportEntries",
	}
}
