package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDevice invokes the vs.CreateDevice API synchronously
func (client *Client) CreateDevice(request *CreateDeviceRequest) (response *CreateDeviceResponse, err error) {
	response = CreateCreateDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDeviceWithChan invokes the vs.CreateDevice API asynchronously
func (client *Client) CreateDeviceWithChan(request *CreateDeviceRequest) (<-chan *CreateDeviceResponse, <-chan error) {
	responseChan := make(chan *CreateDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDeviceWithCallback invokes the vs.CreateDevice API asynchronously
func (client *Client) CreateDeviceWithCallback(request *CreateDeviceRequest, callback func(response *CreateDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDeviceResponse
		var err error
		defer close(result)
		response, err = client.CreateDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDeviceRequest is the request struct for api CreateDevice
type CreateDeviceRequest struct {
	*requests.RpcRequest
	GbId        string           `position:"Query" name:"GbId"`
	Latitude    string           `position:"Query" name:"Latitude"`
	Description string           `position:"Query" name:"Description"`
	Type        string           `position:"Query" name:"Type"`
	AutoStart   requests.Boolean `position:"Query" name:"AutoStart"`
	ParentId    string           `position:"Query" name:"ParentId"`
	Password    string           `position:"Query" name:"Password"`
	Vendor      string           `position:"Query" name:"Vendor"`
	AlarmMethod string           `position:"Query" name:"AlarmMethod"`
	DirectoryId string           `position:"Query" name:"DirectoryId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	Longitude   string           `position:"Query" name:"Longitude"`
	GroupId     string           `position:"Query" name:"GroupId"`
	Ip          string           `position:"Query" name:"Ip"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	Params      string           `position:"Query" name:"Params"`
	Url         string           `position:"Query" name:"Url"`
	Port        requests.Integer `position:"Query" name:"Port"`
	Name        string           `position:"Query" name:"Name"`
	PosInterval requests.Integer `position:"Query" name:"PosInterval"`
	Dsn         string           `position:"Query" name:"Dsn"`
	Username    string           `position:"Query" name:"Username"`
	AutoPos     requests.Boolean `position:"Query" name:"AutoPos"`
}

// CreateDeviceResponse is the response struct for api CreateDevice
type CreateDeviceResponse struct {
	*responses.BaseResponse
	Id        string `json:"Id" xml:"Id"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateDeviceRequest creates a request to invoke CreateDevice API
func CreateCreateDeviceRequest() (request *CreateDeviceRequest) {
	request = &CreateDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "CreateDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDeviceResponse creates a response to parse from CreateDevice response
func CreateCreateDeviceResponse() (response *CreateDeviceResponse) {
	response = &CreateDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
