package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetHighDefinitionMonitorLogStatus invokes the vpc.SetHighDefinitionMonitorLogStatus API synchronously
func (client *Client) SetHighDefinitionMonitorLogStatus(request *SetHighDefinitionMonitorLogStatusRequest) (response *SetHighDefinitionMonitorLogStatusResponse, err error) {
	response = CreateSetHighDefinitionMonitorLogStatusResponse()
	err = client.DoAction(request, response)
	return
}

// SetHighDefinitionMonitorLogStatusWithChan invokes the vpc.SetHighDefinitionMonitorLogStatus API asynchronously
func (client *Client) SetHighDefinitionMonitorLogStatusWithChan(request *SetHighDefinitionMonitorLogStatusRequest) (<-chan *SetHighDefinitionMonitorLogStatusResponse, <-chan error) {
	responseChan := make(chan *SetHighDefinitionMonitorLogStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetHighDefinitionMonitorLogStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetHighDefinitionMonitorLogStatusWithCallback invokes the vpc.SetHighDefinitionMonitorLogStatus API asynchronously
func (client *Client) SetHighDefinitionMonitorLogStatusWithCallback(request *SetHighDefinitionMonitorLogStatusRequest, callback func(response *SetHighDefinitionMonitorLogStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetHighDefinitionMonitorLogStatusResponse
		var err error
		defer close(result)
		response, err = client.SetHighDefinitionMonitorLogStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetHighDefinitionMonitorLogStatusRequest is the request struct for api SetHighDefinitionMonitorLogStatus
type SetHighDefinitionMonitorLogStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LogProject           string           `position:"Query" name:"LogProject"`
	InstanceType         string           `position:"Query" name:"InstanceType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	LogStore             string           `position:"Query" name:"LogStore"`
	Status               string           `position:"Query" name:"Status"`
}

// SetHighDefinitionMonitorLogStatusResponse is the response struct for api SetHighDefinitionMonitorLogStatus
type SetHighDefinitionMonitorLogStatusResponse struct {
	*responses.BaseResponse
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetHighDefinitionMonitorLogStatusRequest creates a request to invoke SetHighDefinitionMonitorLogStatus API
func CreateSetHighDefinitionMonitorLogStatusRequest() (request *SetHighDefinitionMonitorLogStatusRequest) {
	request = &SetHighDefinitionMonitorLogStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "SetHighDefinitionMonitorLogStatus", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetHighDefinitionMonitorLogStatusResponse creates a response to parse from SetHighDefinitionMonitorLogStatus response
func CreateSetHighDefinitionMonitorLogStatusResponse() (response *SetHighDefinitionMonitorLogStatusResponse) {
	response = &SetHighDefinitionMonitorLogStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
