package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPublicIpAddressPoolCidrBlocks invokes the vpc.ListPublicIpAddressPoolCidrBlocks API synchronously
func (client *Client) ListPublicIpAddressPoolCidrBlocks(request *ListPublicIpAddressPoolCidrBlocksRequest) (response *ListPublicIpAddressPoolCidrBlocksResponse, err error) {
	response = CreateListPublicIpAddressPoolCidrBlocksResponse()
	err = client.DoAction(request, response)
	return
}

// ListPublicIpAddressPoolCidrBlocksWithChan invokes the vpc.ListPublicIpAddressPoolCidrBlocks API asynchronously
func (client *Client) ListPublicIpAddressPoolCidrBlocksWithChan(request *ListPublicIpAddressPoolCidrBlocksRequest) (<-chan *ListPublicIpAddressPoolCidrBlocksResponse, <-chan error) {
	responseChan := make(chan *ListPublicIpAddressPoolCidrBlocksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPublicIpAddressPoolCidrBlocks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPublicIpAddressPoolCidrBlocksWithCallback invokes the vpc.ListPublicIpAddressPoolCidrBlocks API asynchronously
func (client *Client) ListPublicIpAddressPoolCidrBlocksWithCallback(request *ListPublicIpAddressPoolCidrBlocksRequest, callback func(response *ListPublicIpAddressPoolCidrBlocksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPublicIpAddressPoolCidrBlocksResponse
		var err error
		defer close(result)
		response, err = client.ListPublicIpAddressPoolCidrBlocks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPublicIpAddressPoolCidrBlocksRequest is the request struct for api ListPublicIpAddressPoolCidrBlocks
type ListPublicIpAddressPoolCidrBlocksRequest struct {
	*requests.RpcRequest
	PublicIpAddressPoolId string           `position:"Query" name:"PublicIpAddressPoolId"`
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NextToken             string           `position:"Query" name:"NextToken"`
	DryRun                requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	CidrBlock             string           `position:"Query" name:"CidrBlock"`
	MaxResults            requests.Integer `position:"Query" name:"MaxResults"`
}

// ListPublicIpAddressPoolCidrBlocksResponse is the response struct for api ListPublicIpAddressPoolCidrBlocks
type ListPublicIpAddressPoolCidrBlocksResponse struct {
	*responses.BaseResponse
	RequestId                 string                  `json:"RequestId" xml:"RequestId"`
	NextToken                 string                  `json:"NextToken" xml:"NextToken"`
	MaxResults                int                     `json:"MaxResults" xml:"MaxResults"`
	TotalCount                int                     `json:"TotalCount" xml:"TotalCount"`
	PublicIpPoolCidrBlockList []PublicIpPoolCidrBlock `json:"PublicIpPoolCidrBlockList" xml:"PublicIpPoolCidrBlockList"`
}

// CreateListPublicIpAddressPoolCidrBlocksRequest creates a request to invoke ListPublicIpAddressPoolCidrBlocks API
func CreateListPublicIpAddressPoolCidrBlocksRequest() (request *ListPublicIpAddressPoolCidrBlocksRequest) {
	request = &ListPublicIpAddressPoolCidrBlocksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListPublicIpAddressPoolCidrBlocks", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPublicIpAddressPoolCidrBlocksResponse creates a response to parse from ListPublicIpAddressPoolCidrBlocks response
func CreateListPublicIpAddressPoolCidrBlocksResponse() (response *ListPublicIpAddressPoolCidrBlocksResponse) {
	response = &ListPublicIpAddressPoolCidrBlocksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
