package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DiagnoseVpnGateway invokes the vpc.DiagnoseVpnGateway API synchronously
func (client *Client) DiagnoseVpnGateway(request *DiagnoseVpnGatewayRequest) (response *DiagnoseVpnGatewayResponse, err error) {
	response = CreateDiagnoseVpnGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// DiagnoseVpnGatewayWithChan invokes the vpc.DiagnoseVpnGateway API asynchronously
func (client *Client) DiagnoseVpnGatewayWithChan(request *DiagnoseVpnGatewayRequest) (<-chan *DiagnoseVpnGatewayResponse, <-chan error) {
	responseChan := make(chan *DiagnoseVpnGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DiagnoseVpnGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DiagnoseVpnGatewayWithCallback invokes the vpc.DiagnoseVpnGateway API asynchronously
func (client *Client) DiagnoseVpnGatewayWithCallback(request *DiagnoseVpnGatewayRequest, callback func(response *DiagnoseVpnGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DiagnoseVpnGatewayResponse
		var err error
		defer close(result)
		response, err = client.DiagnoseVpnGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DiagnoseVpnGatewayRequest is the request struct for api DiagnoseVpnGateway
type DiagnoseVpnGatewayRequest struct {
	*requests.RpcRequest
	ClientToken     string `position:"Query" name:"ClientToken"`
	ResourceId      string `position:"Query" name:"ResourceId"`
	VpnGatewayId    string `position:"Query" name:"VpnGatewayId"`
	ResourceType    string `position:"Query" name:"ResourceType"`
	IPsecExtendInfo string `position:"Query" name:"IPsecExtendInfo"`
}

// DiagnoseVpnGatewayResponse is the response struct for api DiagnoseVpnGateway
type DiagnoseVpnGatewayResponse struct {
	*responses.BaseResponse
	DiagnoseId string `json:"DiagnoseId" xml:"DiagnoseId"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateDiagnoseVpnGatewayRequest creates a request to invoke DiagnoseVpnGateway API
func CreateDiagnoseVpnGatewayRequest() (request *DiagnoseVpnGatewayRequest) {
	request = &DiagnoseVpnGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DiagnoseVpnGateway", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDiagnoseVpnGatewayResponse creates a response to parse from DiagnoseVpnGateway response
func CreateDiagnoseVpnGatewayResponse() (response *DiagnoseVpnGatewayResponse) {
	response = &DiagnoseVpnGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
