package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateVideoInfo invokes the vod.UpdateVideoInfo API synchronously
func (client *Client) UpdateVideoInfo(request *UpdateVideoInfoRequest) (response *UpdateVideoInfoResponse, err error) {
	response = CreateUpdateVideoInfoResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateVideoInfoWithChan invokes the vod.UpdateVideoInfo API asynchronously
func (client *Client) UpdateVideoInfoWithChan(request *UpdateVideoInfoRequest) (<-chan *UpdateVideoInfoResponse, <-chan error) {
	responseChan := make(chan *UpdateVideoInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateVideoInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateVideoInfoWithCallback invokes the vod.UpdateVideoInfo API asynchronously
func (client *Client) UpdateVideoInfoWithCallback(request *UpdateVideoInfoRequest, callback func(response *UpdateVideoInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateVideoInfoResponse
		var err error
		defer close(result)
		response, err = client.UpdateVideoInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateVideoInfoRequest is the request struct for api UpdateVideoInfo
type UpdateVideoInfoRequest struct {
	*requests.RpcRequest
	Description     string           `position:"Query" name:"Description"`
	Title           string           `position:"Query" name:"Title"`
	CoverURL        string           `position:"Query" name:"CoverURL"`
	UserData        string           `position:"Query" name:"UserData"`
	DownloadSwitch  string           `position:"Query" name:"DownloadSwitch"`
	CateId          requests.Integer `position:"Query" name:"CateId"`
	CustomMediaInfo string           `position:"Query" name:"CustomMediaInfo"`
	VideoId         string           `position:"Query" name:"VideoId"`
	Tags            string           `position:"Query" name:"Tags"`
	Status          string           `position:"Query" name:"Status"`
}

// UpdateVideoInfoResponse is the response struct for api UpdateVideoInfo
type UpdateVideoInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateVideoInfoRequest creates a request to invoke UpdateVideoInfo API
func CreateUpdateVideoInfoRequest() (request *UpdateVideoInfoRequest) {
	request = &UpdateVideoInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "UpdateVideoInfo", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateVideoInfoResponse creates a response to parse from UpdateVideoInfo response
func CreateUpdateVideoInfoResponse() (response *UpdateVideoInfoResponse) {
	response = &UpdateVideoInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
