package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunPython3Script invokes the sophonsoar.RunPython3Script API synchronously
func (client *Client) RunPython3Script(request *RunPython3ScriptRequest) (response *RunPython3ScriptResponse, err error) {
	response = CreateRunPython3ScriptResponse()
	err = client.DoAction(request, response)
	return
}

// RunPython3ScriptWithChan invokes the sophonsoar.RunPython3Script API asynchronously
func (client *Client) RunPython3ScriptWithChan(request *RunPython3ScriptRequest) (<-chan *RunPython3ScriptResponse, <-chan error) {
	responseChan := make(chan *RunPython3ScriptResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunPython3Script(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunPython3ScriptWithCallback invokes the sophonsoar.RunPython3Script API asynchronously
func (client *Client) RunPython3ScriptWithCallback(request *RunPython3ScriptRequest, callback func(response *RunPython3ScriptResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunPython3ScriptResponse
		var err error
		defer close(result)
		response, err = client.RunPython3Script(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunPython3ScriptRequest is the request struct for api RunPython3Script
type RunPython3ScriptRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	Params       string `position:"Body" name:"Params"`
	NodeName     string `position:"Body" name:"NodeName"`
	PlaybookUuid string `position:"Body" name:"PlaybookUuid"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Query" name:"Lang"`
	PythonScript string `position:"Body" name:"PythonScript"`
}

// RunPython3ScriptResponse is the response struct for api RunPython3Script
type RunPython3ScriptResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RunResult string `json:"RunResult" xml:"RunResult"`
}

// CreateRunPython3ScriptRequest creates a request to invoke RunPython3Script API
func CreateRunPython3ScriptRequest() (request *RunPython3ScriptRequest) {
	request = &RunPython3ScriptRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "RunPython3Script", "", "")
	request.Method = requests.POST
	return
}

// CreateRunPython3ScriptResponse creates a response to parse from RunPython3Script response
func CreateRunPython3ScriptResponse() (response *RunPython3ScriptResponse) {
	response = &RunPython3ScriptResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
