package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePopApi invokes the sophonsoar.DescribePopApi API synchronously
func (client *Client) DescribePopApi(request *DescribePopApiRequest) (response *DescribePopApiResponse, err error) {
	response = CreateDescribePopApiResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePopApiWithChan invokes the sophonsoar.DescribePopApi API asynchronously
func (client *Client) DescribePopApiWithChan(request *DescribePopApiRequest) (<-chan *DescribePopApiResponse, <-chan error) {
	responseChan := make(chan *DescribePopApiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePopApi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePopApiWithCallback invokes the sophonsoar.DescribePopApi API asynchronously
func (client *Client) DescribePopApiWithCallback(request *DescribePopApiRequest, callback func(response *DescribePopApiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePopApiResponse
		var err error
		defer close(result)
		response, err = client.DescribePopApi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePopApiRequest is the request struct for api DescribePopApi
type DescribePopApiRequest struct {
	*requests.RpcRequest
	PopCode    string `position:"Query" name:"PopCode"`
	RoleFor    string `position:"Query" name:"RoleFor"`
	ApiVersion string `position:"Query" name:"ApiVersion"`
	Env        string `position:"Query" name:"Env"`
	ApiName    string `position:"Query" name:"ApiName"`
	RoleType   string `position:"Query" name:"RoleType"`
	Lang       string `position:"Query" name:"Lang"`
}

// DescribePopApiResponse is the response struct for api DescribePopApi
type DescribePopApiResponse struct {
	*responses.BaseResponse
	RequestId       string                 `json:"RequestId" xml:"RequestId"`
	PopCode         string                 `json:"PopCode" xml:"PopCode"`
	Version         string                 `json:"Version" xml:"Version"`
	ApiName         string                 `json:"ApiName" xml:"ApiName"`
	ApiMeta         map[string]interface{} `json:"ApiMeta" xml:"ApiMeta"`
	OpenApiMetaList []OpenApiMetaListItem  `json:"OpenApiMetaList" xml:"OpenApiMetaList"`
}

// CreateDescribePopApiRequest creates a request to invoke DescribePopApi API
func CreateDescribePopApiRequest() (request *DescribePopApiRequest) {
	request = &DescribePopApiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribePopApi", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribePopApiResponse creates a response to parse from DescribePopApi response
func CreateDescribePopApiResponse() (response *DescribePopApiResponse) {
	response = &DescribePopApiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
