package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRegionZone invokes the schedulerx3.ListRegionZone API synchronously
func (client *Client) ListRegionZone(request *ListRegionZoneRequest) (response *ListRegionZoneResponse, err error) {
	response = CreateListRegionZoneResponse()
	err = client.DoAction(request, response)
	return
}

// ListRegionZoneWithChan invokes the schedulerx3.ListRegionZone API asynchronously
func (client *Client) ListRegionZoneWithChan(request *ListRegionZoneRequest) (<-chan *ListRegionZoneResponse, <-chan error) {
	responseChan := make(chan *ListRegionZoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRegionZone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRegionZoneWithCallback invokes the schedulerx3.ListRegionZone API asynchronously
func (client *Client) ListRegionZoneWithCallback(request *ListRegionZoneRequest, callback func(response *ListRegionZoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRegionZoneResponse
		var err error
		defer close(result)
		response, err = client.ListRegionZone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRegionZoneRequest is the request struct for api ListRegionZone
type ListRegionZoneRequest struct {
	*requests.RpcRequest
	MseSessionId string `position:"Query" name:"MseSessionId"`
}

// ListRegionZoneResponse is the response struct for api ListRegionZone
type ListRegionZoneResponse struct {
	*responses.BaseResponse
	Code      int        `json:"Code" xml:"Code"`
	ErrorCode string     `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool       `json:"Success" xml:"Success"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListRegionZoneRequest creates a request to invoke ListRegionZone API
func CreateListRegionZoneRequest() (request *ListRegionZoneRequest) {
	request = &ListRegionZoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "ListRegionZone", "", "")
	request.Method = requests.POST
	return
}

// CreateListRegionZoneResponse creates a response to parse from ListRegionZone response
func CreateListRegionZoneResponse() (response *ListRegionZoneResponse) {
	response = &ListRegionZoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
