package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserBackupMachines invokes the sas.DescribeUserBackupMachines API synchronously
func (client *Client) DescribeUserBackupMachines(request *DescribeUserBackupMachinesRequest) (response *DescribeUserBackupMachinesResponse, err error) {
	response = CreateDescribeUserBackupMachinesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserBackupMachinesWithChan invokes the sas.DescribeUserBackupMachines API asynchronously
func (client *Client) DescribeUserBackupMachinesWithChan(request *DescribeUserBackupMachinesRequest) (<-chan *DescribeUserBackupMachinesResponse, <-chan error) {
	responseChan := make(chan *DescribeUserBackupMachinesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserBackupMachines(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserBackupMachinesWithCallback invokes the sas.DescribeUserBackupMachines API asynchronously
func (client *Client) DescribeUserBackupMachinesWithCallback(request *DescribeUserBackupMachinesRequest, callback func(response *DescribeUserBackupMachinesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserBackupMachinesResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserBackupMachines(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserBackupMachinesRequest is the request struct for api DescribeUserBackupMachines
type DescribeUserBackupMachinesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
}

// DescribeUserBackupMachinesResponse is the response struct for api DescribeUserBackupMachines
type DescribeUserBackupMachinesResponse struct {
	*responses.BaseResponse
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Machines  []SimpleBackupMachine `json:"Machines" xml:"Machines"`
}

// CreateDescribeUserBackupMachinesRequest creates a request to invoke DescribeUserBackupMachines API
func CreateDescribeUserBackupMachinesRequest() (request *DescribeUserBackupMachinesRequest) {
	request = &DescribeUserBackupMachinesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeUserBackupMachines", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUserBackupMachinesResponse creates a response to parse from DescribeUserBackupMachines response
func CreateDescribeUserBackupMachinesResponse() (response *DescribeUserBackupMachinesResponse) {
	response = &DescribeUserBackupMachinesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
