package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryApproveFlow invokes the safe.QueryApproveFlow API synchronously
func (client *Client) QueryApproveFlow(request *QueryApproveFlowRequest) (response *QueryApproveFlowResponse, err error) {
	response = CreateQueryApproveFlowResponse()
	err = client.DoAction(request, response)
	return
}

// QueryApproveFlowWithChan invokes the safe.QueryApproveFlow API asynchronously
func (client *Client) QueryApproveFlowWithChan(request *QueryApproveFlowRequest) (<-chan *QueryApproveFlowResponse, <-chan error) {
	responseChan := make(chan *QueryApproveFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryApproveFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryApproveFlowWithCallback invokes the safe.QueryApproveFlow API asynchronously
func (client *Client) QueryApproveFlowWithCallback(request *QueryApproveFlowRequest, callback func(response *QueryApproveFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryApproveFlowResponse
		var err error
		defer close(result)
		response, err = client.QueryApproveFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryApproveFlowRequest is the request struct for api QueryApproveFlow
type QueryApproveFlowRequest struct {
	*requests.RpcRequest
	AuthKey       string           `position:"Query" name:"AuthKey"`
	ReqTimestamp  requests.Integer `position:"Query" name:"ReqTimestamp"`
	Stage         string           `position:"Query" name:"Stage"`
	SourceOrderId string           `position:"Query" name:"SourceOrderId"`
	AuthSign      string           `position:"Query" name:"AuthSign"`
}

// QueryApproveFlowResponse is the response struct for api QueryApproveFlow
type QueryApproveFlowResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateQueryApproveFlowRequest creates a request to invoke QueryApproveFlow API
func CreateQueryApproveFlowRequest() (request *QueryApproveFlowRequest) {
	request = &QueryApproveFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "QueryApproveFlow", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryApproveFlowResponse creates a response to parse from QueryApproveFlow response
func CreateQueryApproveFlowResponse() (response *QueryApproveFlowResponse) {
	response = &QueryApproveFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
