package riskpunish

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPunishList invokes the riskpunish.QueryPunishList API synchronously
func (client *Client) QueryPunishList(request *QueryPunishListRequest) (response *QueryPunishListResponse, err error) {
	response = CreateQueryPunishListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPunishListWithChan invokes the riskpunish.QueryPunishList API asynchronously
func (client *Client) QueryPunishListWithChan(request *QueryPunishListRequest) (<-chan *QueryPunishListResponse, <-chan error) {
	responseChan := make(chan *QueryPunishListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPunishList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPunishListWithCallback invokes the riskpunish.QueryPunishList API asynchronously
func (client *Client) QueryPunishListWithCallback(request *QueryPunishListRequest, callback func(response *QueryPunishListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPunishListResponse
		var err error
		defer close(result)
		response, err = client.QueryPunishList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPunishListRequest is the request struct for api QueryPunishList
type QueryPunishListRequest struct {
	*requests.RpcRequest
	DateStart   requests.Integer `position:"Query" name:"DateStart"`
	PunishIp    string           `position:"Query" name:"PunishIp"`
	PunishUrl   string           `position:"Query" name:"PunishUrl"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	DateEnd     requests.Integer `position:"Query" name:"DateEnd"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
}

// QueryPunishListResponse is the response struct for api QueryPunishList
type QueryPunishListResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateQueryPunishListRequest creates a request to invoke QueryPunishList API
func CreateQueryPunishListRequest() (request *QueryPunishListRequest) {
	request = &QueryPunishListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("RiskPunish", "2024-03-19", "QueryPunishList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryPunishListResponse creates a response to parse from QueryPunishList response
func CreateQueryPunishListResponse() (response *QueryPunishListResponse) {
	response = &QueryPunishListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
